/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import com.darwinsys.util.ArrayIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexList<T>
implements List<T> {
    private int hwm = 0;
    private T[] data;
    public static final int DEFAULT_START_SIZE = 42;

    public IndexList() {
        this(42);
    }

    public IndexList(int startSize) {
        this.data = new Object[startSize];
        this.hwm = 0;
    }

    public void ensureCapacity(int i) {
        if (i > this.data.length) {
            Object[] newData = new Object[i + 10];
            System.arraycopy(this.data, 0, newData, 0, this.hwm);
        }
    }

    @Override
    public int size() {
        return this.hwm;
    }

    @Override
    public boolean isEmpty() {
        return this.hwm > 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean add(T o) {
        this.ensureCapacity(this.hwm);
        this.data[this.hwm++] = o;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    @Override
    public T remove(int i) {
        T old = this.data[i];
        this.data[i] = null;
        return old;
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new IllegalStateException("removeAll method not implemented in IndexList");
    }

    @Override
    public Iterator<T> iterator() {
        Object[] newData = new Object[this.hwm];
        System.arraycopy(this.data, 0, newData, 0, this.hwm);
        return new ArrayIterator(newData);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public Object[] toArray(Object[] newData) {
        if (newData.length != this.hwm) {
            throw new IllegalArgumentException("newData length != current");
        }
        System.arraycopy(this.data, 0, newData, 0, this.hwm);
        return newData;
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.indexOf(it.next()) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add((T)it.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection c) {
        throw new IllegalStateException("addAll method not implemented in IndexList");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new IllegalStateException("removeAll method not implemented in IndexList");
    }

    @Override
    public void clear() {
        this.data = new Object[42];
        this.hwm = 0;
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public T get(int i) {
        return this.data[i];
    }

    @Override
    public T set(int i, T o) {
        this.ensureCapacity(i);
        T old = this.data[i];
        this.data[i] = o;
        return old;
    }

    @Override
    public void add(int i, T o) {
        this.ensureCapacity(i);
        this.data[i] = o;
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        while (i < this.hwm) {
            if (o == this.data[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.hwm - 1;
        while (i >= 0) {
            if (o == this.data[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new IllegalStateException("listIterator method not implemented in IndexList");
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        throw new IllegalStateException("listIterator method not implemented in IndexList");
    }

    @Override
    public List<T> subList(int from, int to) {
        throw new IllegalStateException("subList method not implemented in IndexList");
    }
}

