/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import com.darwinsys.swingui.Clock;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.Calendar;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CalIcon
extends JComponent
implements Icon {
    private static final long serialVersionUID = -75900943452653673L;
    protected final int SIZE = 64;
    protected final Dimension d = new Dimension(64, 64);
    protected final int RBW = 40;
    protected final int RBH = 40;
    protected final int RBX;
    protected final int RBY;
    protected Calendar myCal;
    protected boolean showTime = true;
    protected Clock clock;
    protected Font dayNumbFont;
    protected FontMetrics dayNumbFM;
    protected Font dayNameFont;
    protected FontMetrics dayNameFM;
    protected Font monNameFont;
    protected FontMetrics monNameFM;
    public String[] days = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    public String[] mons = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};

    public CalIcon(boolean showT) {
        this(Calendar.getInstance(), showT);
    }

    public CalIcon(Calendar c, boolean showT) {
        this.showTime = showT;
        this.myCal = c;
        this.setLayout(null);
        if (this.showTime) {
            this.clock = new Clock();
            this.add(this.clock);
            this.clock.setBounds(0, 2, 64, 10);
            this.RBY = this.d.height - (40 + (this.showTime ? 12 : 0) / 2);
        } else {
            this.RBY = 6;
        }
        this.RBX = 12;
        this.dayNumbFont = new Font("Serif", 1, 20);
        this.dayNumbFM = this.getFontMetrics(this.dayNumbFont);
        this.dayNameFont = new Font("SansSerif", 0, 10);
        this.dayNameFM = this.getFontMetrics(this.dayNameFont);
        this.monNameFont = new Font("SansSerif", 2, 10);
        this.monNameFM = this.getFontMetrics(this.monNameFont);
    }

    public void paint(Graphics g) {
        this.paintIcon(this, g, 0, 0);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.showTime) {
            super.paint(g);
        }
        g.setColor(Color.black);
        g.draw3DRect(x, y, this.d.width - 2, this.d.height - 2, true);
        g.setColor(Color.gray);
        g.fillRect(x + this.RBX + 3, y + this.RBY + 3, 40, 40);
        g.setColor(Color.white);
        g.fillRect(x + this.RBX, y + this.RBY, 40, 40);
        g.setColor(Color.black);
        String s = this.days[this.myCal.get(7) - 1];
        g.setFont(this.dayNameFont);
        int w = this.dayNameFM.stringWidth(s);
        g.drawString(s, x + this.RBX + (40 - w) / 2, y + this.RBY + 10);
        s = Integer.toString(this.myCal.get(5));
        g.setFont(this.dayNumbFont);
        w = this.dayNumbFM.stringWidth(s);
        g.drawString(s, x + this.RBX + (40 - w) / 2, y + this.RBY + 25);
        s = this.mons[this.myCal.get(2)];
        g.setFont(this.monNameFont);
        w = this.monNameFM.stringWidth(s);
        g.drawString(s, x + this.RBX + (40 - w) / 2, y + this.RBY + 35);
    }

    public int getIconWidth() {
        return 64;
    }

    public int getIconHeight() {
        return 64;
    }

    public Dimension getPreferredSize() {
        return this.d;
    }

    public Dimension getMinimumSize() {
        return this.d;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("Calendar");
        Container cp = jf.getContentPane();
        cp.setLayout(new GridLayout(0, 1, 5, 5));
        CalIcon c = new CalIcon(true);
        cp.add(c);
        JButton j = new JButton("As Icon", new CalIcon(false));
        cp.add(j);
        jf.pack();
        jf.setVisible(true);
    }
}

