/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.TablePaneUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BasicTablePaneUI
extends TablePaneUI
implements PropertyChangeListener,
Serializable {
    private static Logger logger = Logger.getLogger(BasicTablePaneUI.class);
    private TablePane tablePane;
    final int boxLineThickness = 1;
    final int gap = 1;
    private int pkGap = 10;
    protected Color selectedColor = new Color(204, 204, 255);
    protected Color unselectedColor = new Color(240, 240, 240);
    protected int minimumWidth = 100;

    public static PlayPenComponentUI createUI(PlayPenComponent c) {
        return new BasicTablePaneUI();
    }

    public void installUI(PlayPenComponent c) {
        this.tablePane = (TablePane)c;
        this.tablePane.addPropertyChangeListener(this);
    }

    public void uninstallUI(PlayPenComponent c) {
        this.tablePane = (TablePane)c;
        this.tablePane.removePropertyChangeListener(this);
    }

    public void paint(Graphics2D g) {
        this.paint(g, this.tablePane);
    }

    public void paint(Graphics g, PlayPenComponent c) {
        TablePane tp = (TablePane)c;
        try {
            Graphics2D g2 = (Graphics2D)g;
            if (logger.isDebugEnabled()) {
                Rectangle clip = g2.getClipBounds();
                if (clip != null) {
                    g2.setColor(Color.red);
                    --clip.width;
                    --clip.height;
                    g2.draw(clip);
                    g2.setColor(tp.getForeground());
                    logger.debug((Object)("Clipping region: " + g2.getClip()));
                } else {
                    logger.debug((Object)"Null clipping region");
                }
            }
            Insets insets = c.getInsets();
            g.translate(insets.left, insets.top);
            int width = c.getWidth() - insets.left - insets.right;
            int height = c.getHeight() - insets.top - insets.bottom;
            Font font = c.getFont();
            if (font == null) {
                return;
            }
            FontMetrics metrics = c.getFontMetrics(font);
            int fontHeight = metrics.getHeight();
            int ascent = metrics.getAscent();
            int maxDescent = metrics.getMaxDescent();
            int y = 0;
            g2.setColor(c.getBackground());
            g2.fillRect(0, 0, width, height);
            if (tp.selected) {
                g2.setColor(this.selectedColor);
            } else {
                g2.setColor(this.unselectedColor);
            }
            g2.fillRect(0, 0, c.getWidth(), fontHeight);
            g2.setColor(c.getForeground());
            g2.drawString(this.getTitleString(this.tablePane), 0, y += ascent);
            if (fontHeight < 0) {
                throw new IllegalStateException("FontHeight is negative");
            }
            g2.drawRect(0, fontHeight + 1, width - 1, height - (fontHeight + 1 + 1));
            y += 2 + tp.getMargin().top;
            Iterator<SQLColumn> colNameIt = this.tablePane.getModel().getColumns().iterator();
            int i = 0;
            int hwidth = width - tp.getMargin().right - tp.getMargin().left - 2;
            boolean stillNeedPKLine = true;
            Color currentColor = null;
            while (colNameIt.hasNext()) {
                SQLColumn col = colNameIt.next();
                if (col.getPrimaryKeySeq() == null && stillNeedPKLine) {
                    stillNeedPKLine = false;
                    currentColor = null;
                    g2.setColor(tp.getForeground());
                    g2.drawLine(0, (y += this.pkGap) + maxDescent - this.pkGap / 2, width - 1, y + maxDescent - this.pkGap / 2);
                }
                if (tp.isColumnSelected(i)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Column " + i + " is selected"));
                    }
                    g2.setColor(this.selectedColor);
                    g2.fillRect(1 + tp.getMargin().left, y - ascent + fontHeight, hwidth, fontHeight);
                    g2.setColor(tp.getForeground());
                }
                if (tp.getColumnHighlight(i) != currentColor) {
                    currentColor = tp.getColumnHighlight(i);
                    g2.setColor(currentColor == null ? tp.getForeground() : currentColor);
                }
                g2.drawString(col.getShortDisplayName(), 1 + tp.getMargin().left, y += fontHeight);
                ++i;
            }
            if (currentColor != null) {
                g2.setColor(tp.getForeground());
            }
            if (stillNeedPKLine) {
                stillNeedPKLine = false;
                g2.drawLine(0, (y += this.pkGap) + maxDescent - this.pkGap / 2, width - 1, y + maxDescent - this.pkGap / 2);
            }
            int ip = this.tablePane.getInsertionPoint();
            if (logger.isDebugEnabled()) {
                g2.drawString(String.valueOf(ip), width - 20, ascent);
            }
            if (ip != -2) {
                y = 2 + tp.getMargin().top + fontHeight;
                if (ip == -3) {
                    y += fontHeight * this.tablePane.getModel().getPkSize();
                } else if (ip == -4) {
                    y += fontHeight * this.tablePane.getModel().getPkSize() + this.pkGap;
                } else if (ip < this.tablePane.getModel().getPkSize()) {
                    if (ip == -1) {
                        ip = 0;
                    }
                    y += ip * fontHeight;
                } else {
                    y += ip * fontHeight + this.pkGap;
                }
                g2.drawLine(5, y, width - 6, y);
                g2.drawLine(2, y - 3, 5, y);
                g2.drawLine(2, y + 3, 5, y);
                g2.drawLine(width - 3, y - 3, width - 6, y);
                g2.drawLine(width - 3, y + 3, width - 6, y);
            }
            g.translate(-insets.left, -insets.top);
        }
        catch (ArchitectException e) {
            logger.warn((Object)"BasicTablePaneUI.paint failed", (Throwable)e);
        }
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.tablePane);
    }

    public Dimension getPreferredSize(PlayPenComponent ppc) {
        TablePane c = (TablePane)ppc;
        SQLTable table = c.getModel();
        if (table == null) {
            return null;
        }
        int height = 0;
        int width = 0;
        try {
            Insets insets = c.getInsets();
            List<SQLColumn> columnList = table.getColumns();
            int cols = columnList.size();
            Font font = c.getFont();
            if (font == null) {
                logger.error((Object)"getPreferredSize(): TablePane is missing font.");
                return null;
            }
            FontRenderContext frc = c.getFontRenderContext();
            FontMetrics metrics = c.getFontMetrics(font);
            int fontHeight = metrics.getHeight();
            height = insets.top + fontHeight + 1 + c.getMargin().top + this.pkGap + cols * fontHeight + 2 + c.getMargin().bottom + insets.bottom;
            width = this.minimumWidth;
            logger.debug((Object)("starting width is: " + width));
            ArrayList<String> itemsToCheck = new ArrayList<String>();
            for (SQLColumn col : table.getColumns()) {
                if (col == null) {
                    logger.error((Object)("Found null column in table '" + table.getName() + "'"));
                    throw new NullPointerException("Found null column in table '" + table.getName() + "'");
                }
                itemsToCheck.add(col.toString());
            }
            itemsToCheck.add(this.getTitleString(c));
            for (String item : itemsToCheck) {
                if (item == null) {
                    item = "(null!?)";
                }
                width = frc == null ? Math.max(width, metrics.stringWidth(item)) : Math.max(width, (int)font.getStringBounds(item, frc).getWidth());
                logger.debug((Object)("new width is: " + width));
            }
            width += insets.left + c.getMargin().left + 2 + c.getMargin().right + insets.right;
        }
        catch (ArchitectException e) {
            logger.warn((Object)"BasicTablePaneUI.getPreferredSize failed due to", (Throwable)e);
            width = 100;
            height = 100;
        }
        return new Dimension(width, height);
    }

    public int pointToColumnIndex(Point p) throws ArchitectException {
        Font font = this.tablePane.getFont();
        FontMetrics metrics = this.tablePane.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int numPkCols = this.tablePane.getModel().getPkSize();
        int numCols = this.tablePane.getModel().getColumns().size();
        int firstColStart = fontHeight + 1 + 1 + this.tablePane.getMargin().top;
        int pkLine = firstColStart + fontHeight * numPkCols;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("p.y = " + p.y));
        }
        if (p.y < 0) {
            logger.debug((Object)"y<0");
            return -2;
        }
        if (p.y <= fontHeight) {
            logger.debug((Object)("y<=fontHeight = " + fontHeight));
            return -1;
        }
        if (numPkCols > 0 && p.y <= firstColStart + fontHeight * numPkCols - 1) {
            logger.debug((Object)("y<=firstColStart + fontHeight*numPkCols - 1= " + (firstColStart + fontHeight * numPkCols)));
            return (p.y - firstColStart) / fontHeight;
        }
        if (p.y <= pkLine + this.pkGap / 2) {
            logger.debug((Object)("y<=pkLine + pkGap/2 = " + (pkLine + this.pkGap / 2)));
            return -3;
        }
        if (p.y <= firstColStart + fontHeight * numPkCols + this.pkGap) {
            logger.debug((Object)("y<=firstColStart + fontHeight*numPkCols + pkGap = " + (firstColStart + fontHeight * numPkCols + this.pkGap)));
            return -4;
        }
        if (p.y <= firstColStart + this.pkGap + fontHeight * numCols) {
            return (p.y - firstColStart - this.pkGap) / fontHeight;
        }
        return numCols;
    }

    public void propertyChange(PropertyChangeEvent e) {
        logger.debug((Object)("BasicTablePaneUI notices change of " + e.getPropertyName() + " from " + e.getOldValue() + " to " + e.getNewValue() + " on " + e.getSource()));
        if (e.getPropertyName().equals("UI")) {
            return;
        }
        if (e.getPropertyName().equals("preferredSize")) {
            return;
        }
        if (e.getPropertyName().equals("insertionPoint")) {
            return;
        }
        if (e.getPropertyName().equals("model.tableName")) {
            this.tablePane.setName(this.tablePane.getModel().getName());
            return;
        }
        this.tablePane.revalidate();
    }

    public boolean contains(Point p) {
        return this.tablePane.getBounds().contains(p);
    }

    public void revalidate() {
    }

    private String getTitleString(TablePane tp) {
        if (tp.isFullyQualifiedNameInHeader()) {
            SQLTable t = tp.getModel();
            String db = t.getParentDatabase() == null ? null : t.getParentDatabase().getName();
            String cat = t.getCatalogName().length() == 0 ? null : t.getCatalogName();
            String sch = t.getSchemaName().length() == 0 ? null : t.getSchemaName();
            StringBuffer fqn = new StringBuffer();
            fqn.append(db);
            if (cat != null) {
                fqn.append('.').append(cat);
            }
            if (sch != null) {
                fqn.append('.').append(sch);
            }
            fqn.append('.').append(tp.getModel().getName());
            return fqn.toString();
        }
        return tp.getModel().getName();
    }
}

