--
-- Zabbix
-- Copyright (C) 2000,2001,2002,2003,2004 Alexei Vladishev
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--

--
-- Dumping data for table `config`
--

INSERT INTO config VALUES (1,365,365,600,'1-5,00:00-24:00',7,1,7,100,'default.css',0,'',389,'','','','',1,1,5,50,1000);

--
-- Dumping data for table `scripts`
--

INSERT INTO scripts VALUES (1,'Ping','/sbin/ping -c 3 {HOST.CONN}',2,0,0);
INSERT INTO scripts VALUES (2,'Traceroute','/usr/sbin/traceroute {HOST.CONN}',2,0,0);

--
-- Dumping data for table `users`
--

INSERT INTO users VALUES (1,'Admin','Zabbix','Administrator','5fce1b3e34b520afeffb37ce08c7cd66','',0, 900,'en_gb',30,3,'default.css',0,'',0,50);
INSERT INTO users VALUES (2,'guest','Default','User','d41d8cd98f00b204e9800998ecf8427e','',0,900,'en_gb',30,1,'default.css',0,'',0,50);

--
-- Dumping data for table `usrgrp`
--

INSERT INTO usrgrp VALUES (1,'UNIX administrators',0,0,0,0);
INSERT INTO usrgrp VALUES (2,'Database administrators',0,0,0,0);
INSERT INTO usrgrp VALUES (3,'Network administrators',0,0,0,0);
INSERT INTO usrgrp VALUES (4,'Security specialists',0,0,0,0);
INSERT INTO usrgrp VALUES (5,'WEB administrators',0,0,0,0);
INSERT INTO usrgrp VALUES (6,'Head of IT department',0,0,0,0);
INSERT INTO usrgrp VALUES (7,'Zabbix administrators',0,0,0,0);
INSERT INTO usrgrp VALUES (8,'Guests',0,0,0,0);
INSERT INTO usrgrp VALUES (9,'Disabled',0,0,1,0);
INSERT INTO usrgrp VALUES (10,'API access',0,1,0,0);
--
-- Dumping data for table `users_groups`
--

INSERT INTO users_groups VALUES (1,7,1);
INSERT INTO users_groups VALUES (2,8,2);

--
-- Dumping data for table `media_type`
--

INSERT INTO media_type VALUES (1,0,'Email','mail.company.com','company.com','zabbix@company.com','','','','');
INSERT INTO media_type VALUES (2,3,'Jabber','','','','','','jabber@company.com','zabbix');
INSERT INTO media_type VALUES (3,2,'SMS','','','','','/dev/tty00','','');

--
-- Dumping data for table hosts
--

INSERT INTO hosts VALUES (10001,0,'Template_Linux','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10002,0,'Template_Windows','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10003,0,'Template_App_MySQL','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10004,0,'Template_Standalone','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10007,0,'Template_SNMPv2_Device','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10008,0,'Template_FreeBSD','Template_FreeBSD',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10009,0,'Template_OpenBSD','Template_OpenBSD',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10010,0,'Template_Tru64','Template_Tru64',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10011,0,'Template_Netware','Template_Netware',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10012,0,'Template_AIX','Template_AIX',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10013,0,'Template_HPUX','Template_HPUX',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10014,0,'Template_MacOS_X','Template_MacOS_X',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10015,0,'Template_Solaris','Template_Solaris',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10016,0,'Template_SNMPv1_Device','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10017,0,'Zabbix Server','',1,'127.0.0.1',10050,1,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10018,0,'Template_Cisco_PIX_525','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10019,0,'Template_Dell_PowerConnect_6248','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10020,0,'Template_APC_Battery','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10021,0,'Template_HP_InsightManager','',0,'127.0.0.1',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10022,0,'Template_Dell_OpenManage','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10023,0,'Template_Cisco_PIX','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10024,0,'Template_Dell_PowerEdge','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10025,0,'Template_3COM_3824','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10026,0,'Template_3COM_4400','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10027,0,'Template_APC_Automatic_Transfer_Switch','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10028,0,'Template_Cisco_837','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10029,0,'Template_Cisco_877','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10030,0,'Template_Cisco_2960','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10031,0,'Template_C3750-48TS','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10032,0,'Template_Cisco_PIX515E','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10033,0,'Template_Dell_PowerConnect_5224','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10034,0,'Template_Dell_PowerConnect_5324','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10035,0,'Template_Hibernate','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10036,0,'Template_HP_ColorLaserJet','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10038,0,'Template_HP_Procurve','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10039,0,'Template_Java','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10040,0,'Template_Microsoft_Exchange_2003','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10041,0,'Template_Microsoft_Exchange_2007','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10042,0,'Template_IPMI_Sun_Fire_X4100_M2','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10043,0,'Template_Tomcat','',0,'',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10044,0,'Template_Microsoft_SQLServer_2005','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10045,0,'Template_pfSense','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
INSERT INTO hosts VALUES (10046,0,'Template_NetScreen_25','',0,'0.0.0.0',10050,3,0,'',0,0,0,0,0,0,623,0,2,'','',0,0,0,0,0,0,0,0,'',0,0,'','');
--
-- Dumping data for table `hosts_templates`
--

INSERT INTO hosts_templates VALUES (1,10017,10001);

--
-- Dumping data for table `applications`
--

INSERT INTO applications VALUES (1,10001,'OS',0);
INSERT INTO applications VALUES (2,10001,'Services',0);
INSERT INTO applications VALUES (5,10001,'Filesystem',0);
INSERT INTO applications VALUES (7,10001,'Network',0);
INSERT INTO applications VALUES (9,10001,'Processes',0);
INSERT INTO applications VALUES (11,10001,'Log files',0);
INSERT INTO applications VALUES (13,10001,'CPU',0);
INSERT INTO applications VALUES (15,10001,'Memory',0);
INSERT INTO applications VALUES (17,10001,'Performance',0);
INSERT INTO applications VALUES (19,10001,'Availability',0);
INSERT INTO applications VALUES (21,10001,'General',0);
INSERT INTO applications VALUES (23,10001,'Integrity',0);
INSERT INTO applications VALUES (25,10002,'Availability',0);
INSERT INTO applications VALUES (27,10002,'CPU',0);
INSERT INTO applications VALUES (29,10002,'Filesystem',0);
INSERT INTO applications VALUES (31,10002,'General',0);
INSERT INTO applications VALUES (33,10002,'Integrity',0);
INSERT INTO applications VALUES (35,10002,'Memory',0);
INSERT INTO applications VALUES (37,10002,'Network',0);
INSERT INTO applications VALUES (39,10002,'OS',0);
INSERT INTO applications VALUES (41,10002,'Performance',0);
INSERT INTO applications VALUES (43,10002,'Processes',0);
INSERT INTO applications VALUES (45,10002,'Services',0);
INSERT INTO applications VALUES (47,10008,'General',0);
INSERT INTO applications VALUES (48,10008,'Processes',0);
INSERT INTO applications VALUES (49,10008,'Log files',0);
INSERT INTO applications VALUES (50,10008,'OS',0);
INSERT INTO applications VALUES (51,10008,'Network',0);
INSERT INTO applications VALUES (52,10008,'Performance',0);
INSERT INTO applications VALUES (53,10008,'Services',0);
INSERT INTO applications VALUES (54,10008,'CPU',0);
INSERT INTO applications VALUES (55,10008,'Availability',0);
INSERT INTO applications VALUES (56,10008,'Filesystem',0);
INSERT INTO applications VALUES (57,10008,'Integrity',0);
INSERT INTO applications VALUES (58,10008,'Memory',0);
INSERT INTO applications VALUES (59,10009,'General',0);
INSERT INTO applications VALUES (60,10009,'Processes',0);
INSERT INTO applications VALUES (61,10009,'Log files',0);
INSERT INTO applications VALUES (62,10009,'OS',0);
INSERT INTO applications VALUES (63,10009,'Network',0);
INSERT INTO applications VALUES (64,10009,'Performance',0);
INSERT INTO applications VALUES (65,10009,'Services',0);
INSERT INTO applications VALUES (66,10009,'CPU',0);
INSERT INTO applications VALUES (67,10009,'Availability',0);
INSERT INTO applications VALUES (68,10009,'Filesystem',0);
INSERT INTO applications VALUES (69,10009,'Integrity',0);
INSERT INTO applications VALUES (70,10009,'Memory',0);
INSERT INTO applications VALUES (71,10010,'General',0);
INSERT INTO applications VALUES (72,10010,'Processes',0);
INSERT INTO applications VALUES (73,10010,'Log files',0);
INSERT INTO applications VALUES (74,10010,'OS',0);
INSERT INTO applications VALUES (75,10010,'Network',0);
INSERT INTO applications VALUES (76,10010,'Performance',0);
INSERT INTO applications VALUES (77,10010,'Services',0);
INSERT INTO applications VALUES (78,10010,'CPU',0);
INSERT INTO applications VALUES (79,10010,'Availability',0);
INSERT INTO applications VALUES (80,10010,'Filesystem',0);
INSERT INTO applications VALUES (81,10010,'Integrity',0);
INSERT INTO applications VALUES (82,10010,'Memory',0);
INSERT INTO applications VALUES (83,10011,'General',0);
INSERT INTO applications VALUES (84,10011,'Processes',0);
INSERT INTO applications VALUES (85,10011,'Log files',0);
INSERT INTO applications VALUES (86,10011,'OS',0);
INSERT INTO applications VALUES (87,10011,'Network',0);
INSERT INTO applications VALUES (88,10011,'Performance',0);
INSERT INTO applications VALUES (89,10011,'Services',0);
INSERT INTO applications VALUES (90,10011,'CPU',0);
INSERT INTO applications VALUES (91,10011,'Availability',0);
INSERT INTO applications VALUES (92,10011,'Filesystem',0);
INSERT INTO applications VALUES (93,10011,'Integrity',0);
INSERT INTO applications VALUES (94,10011,'Memory',0);
INSERT INTO applications VALUES (95,10012,'General',0);
INSERT INTO applications VALUES (96,10012,'Processes',0);
INSERT INTO applications VALUES (97,10012,'Log files',0);
INSERT INTO applications VALUES (98,10012,'OS',0);
INSERT INTO applications VALUES (99,10012,'Network',0);
INSERT INTO applications VALUES (100,10012,'Performance',0);
INSERT INTO applications VALUES (101,10012,'Services',0);
INSERT INTO applications VALUES (102,10012,'CPU',0);
INSERT INTO applications VALUES (103,10012,'Availability',0);
INSERT INTO applications VALUES (104,10012,'Filesystem',0);
INSERT INTO applications VALUES (105,10012,'Integrity',0);
INSERT INTO applications VALUES (106,10012,'Memory',0);
INSERT INTO applications VALUES (107,10013,'General',0);
INSERT INTO applications VALUES (108,10013,'Processes',0);
INSERT INTO applications VALUES (109,10013,'Log files',0);
INSERT INTO applications VALUES (110,10013,'OS',0);
INSERT INTO applications VALUES (111,10013,'Network',0);
INSERT INTO applications VALUES (112,10013,'Performance',0);
INSERT INTO applications VALUES (113,10013,'Services',0);
INSERT INTO applications VALUES (114,10013,'CPU',0);
INSERT INTO applications VALUES (115,10013,'Availability',0);
INSERT INTO applications VALUES (116,10013,'Filesystem',0);
INSERT INTO applications VALUES (117,10013,'Integrity',0);
INSERT INTO applications VALUES (118,10013,'Memory',0);
INSERT INTO applications VALUES (119,10014,'General',0);
INSERT INTO applications VALUES (120,10014,'Processes',0);
INSERT INTO applications VALUES (121,10014,'Log files',0);
INSERT INTO applications VALUES (122,10014,'OS',0);
INSERT INTO applications VALUES (123,10014,'Network',0);
INSERT INTO applications VALUES (124,10014,'Performance',0);
INSERT INTO applications VALUES (125,10014,'Services',0);
INSERT INTO applications VALUES (126,10014,'CPU',0);
INSERT INTO applications VALUES (127,10014,'Availability',0);
INSERT INTO applications VALUES (128,10014,'Filesystem',0);
INSERT INTO applications VALUES (129,10014,'Integrity',0);
INSERT INTO applications VALUES (130,10014,'Memory',0);
INSERT INTO applications VALUES (131,10015,'General',0);
INSERT INTO applications VALUES (132,10015,'Processes',0);
INSERT INTO applications VALUES (133,10015,'Log files',0);
INSERT INTO applications VALUES (134,10015,'OS',0);
INSERT INTO applications VALUES (135,10015,'Network',0);
INSERT INTO applications VALUES (136,10015,'Performance',0);
INSERT INTO applications VALUES (137,10015,'Services',0);
INSERT INTO applications VALUES (138,10015,'CPU',0);
INSERT INTO applications VALUES (139,10015,'Availability',0);
INSERT INTO applications VALUES (140,10015,'Filesystem',0);
INSERT INTO applications VALUES (141,10015,'Integrity',0);
INSERT INTO applications VALUES (142,10015,'Memory',0);
INSERT INTO applications VALUES (143,10017,'Availability',19);
INSERT INTO applications VALUES (144,10017,'CPU',13);
INSERT INTO applications VALUES (145,10017,'Filesystem',5);
INSERT INTO applications VALUES (146,10017,'General',21);
INSERT INTO applications VALUES (147,10017,'Integrity',23);
INSERT INTO applications VALUES (148,10017,'Log files',11);
INSERT INTO applications VALUES (149,10017,'Memory',15);
INSERT INTO applications VALUES (150,10017,'Network',7);
INSERT INTO applications VALUES (151,10017,'OS',1);
INSERT INTO applications VALUES (152,10017,'Performance',17);
INSERT INTO applications VALUES (153,10017,'Processes',9);
INSERT INTO applications VALUES (154,10017,'Services',2);
INSERT INTO applications VALUES (155,10031,'General',0);
INSERT INTO applications VALUES (156,10031,'Network',0);
INSERT INTO applications VALUES (157,10032,'Network',0);
INSERT INTO applications VALUES (158,10032,'CPU',0);
INSERT INTO applications VALUES (159,10032,'Memory',0);
INSERT INTO applications VALUES (160,10032,'General',0);
INSERT INTO applications VALUES (161,10033,'General',0);
INSERT INTO applications VALUES (162,10033,'Network',0);
INSERT INTO applications VALUES (163,10034,'General',0);
INSERT INTO applications VALUES (164,10034,'Network',0);
INSERT INTO applications VALUES (165,10041,'Exchange Memory',0);
INSERT INTO applications VALUES (166,10041,'Exchange Connections',0);
INSERT INTO applications VALUES (167,10041,'Exchange Message History',0);
INSERT INTO applications VALUES (168,10041,'Exchange Services',0);
INSERT INTO applications VALUES (169,10045,'pfCounter',0);
INSERT INTO applications VALUES (170,10045,'pfInterfaces',0);
INSERT INTO applications VALUES (171,10045,'pfLimits',0);
INSERT INTO applications VALUES (172,10045,'pfLogInterface',0);
INSERT INTO applications VALUES (173,10045,'pfSrcNodes',0);
INSERT INTO applications VALUES (174,10045,'pfStateTable',0);
INSERT INTO applications VALUES (175,10045,'pfStatus',0);

--
-- Dumping data for table `mappings`
--


INSERT INTO mappings VALUES (1,1,'0','Down');
INSERT INTO mappings VALUES (2,1,'1','Up');
INSERT INTO mappings VALUES (3,2,'0','Up');
INSERT INTO mappings VALUES (4,2,'2','Unreachable');
INSERT INTO mappings VALUES (5,3,'0','Running');
INSERT INTO mappings VALUES (6,3,'1','Paused');
INSERT INTO mappings VALUES (7,3,'3','Pause pending');
INSERT INTO mappings VALUES (8,3,'4','Continue pending');
INSERT INTO mappings VALUES (9,3,'5','Stop pending');
INSERT INTO mappings VALUES (10,3,'6','Stopped');
INSERT INTO mappings VALUES (11,3,'7','Unknown');
INSERT INTO mappings VALUES (12,3,'255','No such service');

--
-- Dumping data for table valuemaps
--

INSERT INTO valuemaps VALUES (1,'Service state');
INSERT INTO valuemaps VALUES (2,'Host status');
INSERT INTO valuemaps VALUES (3,'Windows service state');
INSERT INTO valuemaps VALUES (4,'APC Battery Replacement Status');
INSERT INTO valuemaps VALUES (5,'APC Battery Status');
INSERT INTO valuemaps VALUES (6,'HP Insight System Status');
INSERT INTO valuemaps VALUES (7,'Dell Open Manage System Status');

--
-- Dumping data for table `groups`
--

INSERT INTO groups VALUES (1,'Templates',0);
INSERT INTO groups VALUES (2,'Linux servers',0);
INSERT INTO groups VALUES (3,'Windows servers',0);
INSERT INTO groups VALUES (4,'Zabbix Servers',0);
INSERT INTO groups VALUES (5,'Discovered Hosts',1);

--
-- Dumping data for table hosts_groups
--

INSERT INTO hosts_groups VALUES (1,10001,1);
INSERT INTO hosts_groups VALUES (2,10002,1);
INSERT INTO hosts_groups VALUES (3,10003,1);
INSERT INTO hosts_groups VALUES (4,10004,1);
INSERT INTO hosts_groups VALUES (7,10007,1);
INSERT INTO hosts_groups VALUES (8,10008,1);
INSERT INTO hosts_groups VALUES (9,10009,1);
INSERT INTO hosts_groups VALUES (10,10010,1);
INSERT INTO hosts_groups VALUES (11,10011,1);
INSERT INTO hosts_groups VALUES (12,10012,1);
INSERT INTO hosts_groups VALUES (13,10013,1);
INSERT INTO hosts_groups VALUES (14,10014,1);
INSERT INTO hosts_groups VALUES (15,10015,1);
INSERT INTO hosts_groups VALUES (16,10016,1);
INSERT INTO hosts_groups VALUES (17,10017,4);
INSERT INTO hosts_groups VALUES (18,10018,1);
INSERT INTO hosts_groups VALUES (19,10019,1);
INSERT INTO hosts_groups VALUES (20,10020,1);
INSERT INTO hosts_groups VALUES (21,10021,1);
INSERT INTO hosts_groups VALUES (22,10022,1);
INSERT INTO hosts_groups VALUES (23,10023,1);
INSERT INTO hosts_groups VALUES (24,10024,1);
INSERT INTO hosts_groups VALUES (25,10025,1);
INSERT INTO hosts_groups VALUES (26,10026,1);
INSERT INTO hosts_groups VALUES (27,10027,1);
INSERT INTO hosts_groups VALUES (28,10028,1);
INSERT INTO hosts_groups VALUES (29,10029,1);
INSERT INTO hosts_groups VALUES (30,10030,1);
INSERT INTO hosts_groups VALUES (31,10031,1);
INSERT INTO hosts_groups VALUES (32,10032,1);
INSERT INTO hosts_groups VALUES (33,10033,1);
INSERT INTO hosts_groups VALUES (34,10034,1);
INSERT INTO hosts_groups VALUES (35,10035,1);
INSERT INTO hosts_groups VALUES (36,10036,1);
INSERT INTO hosts_groups VALUES (38,10038,1);
INSERT INTO hosts_groups VALUES (39,10039,1);
INSERT INTO hosts_groups VALUES (40,10040,1);
INSERT INTO hosts_groups VALUES (41,10041,1);
INSERT INTO hosts_groups VALUES (42,10042,1);
INSERT INTO hosts_groups VALUES (43,10043,1);
INSERT INTO hosts_groups VALUES (44,10044,1);
INSERT INTO hosts_groups VALUES (45,10045,1);
INSERT INTO hosts_groups VALUES (46,10046,1);

--
-- Dumping data for table `help_items`
--

insert into help_items values (3,'icmpping[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]','Checks if server is accessible by ICMP ping	0 - ICMP ping fails 1 - ICMP ping successful	One of zabbix_server processes performs ICMP pings once per PingerFrequency seconds.');
insert into help_items values (3,'icmppingloss[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]','Returns percentage of lost ICMP ping packets');
insert into help_items values (3,'icmppingsec[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;,&lt;type&gt;]','Returns ICMP ping response time	Number of seconds Example: 0.02');
insert into help_items values (3,'ftp&lt;,port&gt;','Checks if FTP server is running and accepting connections	0 - FTP server is down 1 - FTP server is running');
insert into help_items values (3,'http&lt;,port&gt;','Checks if HTTP (WEB) server is running and accepting connections	0 - HTTP server is down 1 - HTTP server is running');
insert into help_items values (3,'imap&lt;,port&gt;','Checks if IMAP server is running and accepting connections	0 - IMAP server is down 1 - IMAP server is running');
insert into help_items values (3,'nntp&lt;,port&gt;','Checks if NNTP server is running and accepting connections	0 - NNTP server is down 1 - NNTP server is running');
insert into help_items values (3,'pop&lt;,port&gt;','Checks if POP server is running and accepting connections	0 - POP server is down 1 - POP server is running');
insert into help_items values (3,'smtp&lt;,port&gt;','Checks if SMTP server is running and accepting connections	0 - SMTP server is down 1 - SMTP server is running');
insert into help_items values (3,'ssh&lt;,port&gt;','Checks if SSH server is running and accepting connections	0 - SSH server is down 1 - SSH server is running');
insert into help_items values (3,'tcp,port','Checks if TCP service is running and accepting connections on port	0 - the serivce on the port is down 1 - the service is running');
insert into help_items values (3,'tcp_perf,port','Checks if TCP service is running and accepting connections on port	0 - the service on the port is down Otherwise, number of milliseconds spent connecting to TCP service');
insert into help_items values (3,'ftp_perf&lt;,port&gt;','Checks if FTP server is running and accepting connections	0 - FTP server is down Otherwise, number of milliseconds spent connecting to FTP server');
insert into help_items values (3,'http_perf&lt;,port&gt;','Checks if HTTP (WEB) server is running and accepting connections	0 - HTTP server is down Otherwise, number of milliseconds spent connecting to HTTP server');
insert into help_items values (3,'imap_perf&lt;,port&gt;','Checks if IMAP server is running and accepting connections	0 - IMAP server is down Otherwise, number of milliseconds spent connecting to IMAP server');
insert into help_items values (3,'nntp_perf&lt;,port&gt;','Checks if NNTP server is running and accepting connections	0 - NNTP server is down Otherwise, number of milliseconds spent connecting to NNTP server');
insert into help_items values (3,'pop_perf&lt;,port&gt;','Checks if POP server is running and accepting connections	0 - POP server is down Otherwise, number of milliseconds spent connecting to POP server');
insert into help_items values (3,'smtp_perf&lt;,port&gt;','Checks if SMTP server is running and accepting connections	0 - SMTP server is down Otherwise, number of milliseconds spent connecting to SMTP server');
insert into help_items values (3,'ssh_perf&lt;,port&gt;','Checks if SSH server is running and accepting connections	0 - SSH server is down Otherwise, number of milliseconds spent connecting to SSH server');

insert into help_items values (5,'zabbix[history]','Number of values stored in table HISTORY');
insert into help_items values (5,'zabbix[history_str]','Number of values stored in table HISTORY_STR');
insert into help_items values (5,'zabbix[items]','Number of items in Zabbix database');
insert into help_items values (5,'zabbix[items_unsupported]','Number of unsupported items in Zabbix database');
insert into help_items values (5,'zabbix[log]','Stores warning and error messages generated by Zabbix server.');
insert into help_items values (5,'zabbix[queue]','Number of items in the queue');
insert into help_items values (5,'zabbix[trends]','Number of values stored in table TRENDS');
insert into help_items values (5,'zabbix[triggers]','Number of triggers in Zabbix database');

insert into help_items values (8,'grpfunc[&lt;Group&gt;,&lt;Key&gt;,&lt;func&gt;,&lt;param&gt;]','Aggregate checks do not require any agent running on a host being monitored. Zabbix server collects aggregate information by doing direct database queries. See Zabbix Manual.');

insert into help_items values(0,'agent.ping','Check the agent usability. Always return 1. Can be used as a TCP ping.');
insert into help_items values(0,'agent.version','Version of zabbix_agent(d) running on monitored host. String value. Example of returned value: 1.1');
insert into help_items values(0,'kernel.maxfiles','Maximum number of opened files supported by OS.');
insert into help_items values(0,'kernel.maxproc','Maximum number of processes supported by OS.');
insert into help_items values(0,'net.if.collisions[if]','Out-of-window collision. Collisions count.');
insert into help_items values(0,'net.if.in[if &lt;,mode&gt;]','Network interface input statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(0,'net.if.out[if &lt;,mode&gt;]','Network interface output statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(0,'net.tcp.dns[ip, zone]','Checks if DNS service is up. 0 - DNS is down, 1 - DNS is up.');
insert into help_items values(0,'net.tcp.dns.query[ip, zone, type]','Performs a query for the record type specified by the parameter type');
insert into help_items values(0,'net.tcp.listen[port]','Checks if this port is in LISTEN state. 0 - it is not, 1 - it is in LISTEN state.');
insert into help_items values(0,'net.tcp.port[&lt;ip&gt;, port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
insert into help_items values(0,'net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]','Check if service server is running and accepting connections. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
insert into help_items values(0,'net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]','Check performance of service &quot;service&quot;. 0 - service is down, sec - number of seconds spent on connection to the service. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
insert into help_items values(0,'proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt; &lt;,cmdline&gt;]','Memory used by process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used. Example: proc.mem[,root]');
insert into help_items values(0,'proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt; &lt;,cmdline&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Examples: proc.num[,mysql]; proc.num[apache2,www-data]; proc.num[,oracle,sleep,oracleZABBIX]');
insert into help_items values(0,'system.cpu.intr','Device interrupts.');
insert into help_items values(0,'system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');
insert into help_items values(0,'system.cpu.switches','Context switches.');
insert into help_items values(0,'system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');
insert into help_items values(0,'system.boottime','Timestamp of system boot.');
insert into help_items values(0,'system.cpu.num','Number of available proccessors.');
insert into help_items values(0,'system.hostname','Return host name. String value. Example of returned value: www.zabbix.com');
insert into help_items values(0,'system.localtime','System local time. Time in seconds.');
insert into help_items values(0,'system.run[command,&lt;mode&gt]','Run specified command on the host.');
insert into help_items values(0,'system.swap.in[&lt;swap&gt; &lt;,type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
insert into help_items values(0,'system.swap.out[&lt;swap&gt; &lt;,type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
insert into help_items values(0,'system.swap.size[&lt;swap&gt; &lt;,mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');
insert into help_items values(0,'system.uname','Returns detailed host information. String value');
insert into help_items values(0,'system.uptime','System uptime in seconds.');
insert into help_items values(0,'system.users.num','Number of users connected. Command who is used on agent side.');
insert into help_items values(0,'vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]','Device read statistics.');
insert into help_items values(0,'vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]','Device write statistics.');
insert into help_items values(0,'vfs.file.cksum[file]','Calculate check sum of a given file. Check sum of the file calculate by standard algorithm used by UNIX utility cksum. Example: vfs.file.cksum[/etc/passwd]');
insert into help_items values(0,'vfs.file.exists[file]','Check file existance. 0 - file does not exists, 1 - file exists');
insert into help_items values(0,'vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]');
insert into help_items values(0,'vfs.file.regexp[file,regexp]','Find string in a file. Matched string');
insert into help_items values(0,'vfs.file.regmatch[file,regexp]','Find string in a file. 0 - expression not found, 1 - found');
insert into help_items values(0,'vfs.file.size[file]','Size of a given file. Size in bytes. File must have read permissions for user zabbix. Example: vfs.file.size[/var/log/syslog]');
insert into help_items values(0,'vfs.file.time[file&lt;, mode&gt;]','File time information. Number of seconds.	The mode is optional. If mode is missing modify is used.');
insert into help_items values(0,'vfs.fs.inode[fs &lt;,mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
insert into help_items values(0,'vfs.fs.size[fs &lt;,mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');
insert into help_items values(0,'vm.memory.size[&lt;mode&gt;]','Amount of memory size in bytes. If mode is missing total is used.');
insert into help_items values(0,'web.page.get[host,&lt;path&gt;,&lt;port&gt;]','Get content of WEB page. Default path is /');
insert into help_items values(0,'web.page.perf[host,&lt;path&gt;,&lt;port&gt;]','Get timing of loading full WEB page. Default path is /');
insert into help_items values(0,'web.page.regexp[host,&lt;path&gt;,&lt;port&gt;,&lt;regexp&gt;,&lt;length&gt;]','Get first occurence of regexp in WEB page. Default path is /');
insert into help_items values(0,'perf_counter[counter]','Value of any performance counter, where parameter is the counter path.');
insert into help_items values(0,'service_state[service]','State of service. 0 - running, 1 - paused, 2 - start pending, 3 - pause pending, 4 - continue pending, 5 - stop pending, 6 - stopped, 7 - unknown, 255 - no such service');
insert into help_items values(0,'proc_info[&lt;process&gt;,&lt;attribute&gt;,&lt;type&gt;]','Different information about specific process(es)');

insert into help_items values(7,'agent.ping','Check the agent usability. Always return 1. Can be used as a TCP ping.');
insert into help_items values(7,'agent.version','Version of zabbix_agent(d) running on monitored host. String value. Example of returned value: 1.1');
insert into help_items values(7,'kernel.maxfiles','Maximum number of opened files supported by OS.');
insert into help_items values(7,'kernel.maxproc','Maximum number of processes supported by OS.');
insert into help_items values(7,'net.if.collisions[if]','Out-of-window collision. Collisions count.');
insert into help_items values(7,'net.if.in[if &lt;,mode&gt;]','Network interface input statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(7,'net.if.out[if &lt;,mode&gt;]','Network interface output statistic. Integer value. If mode is missing bytes is used.');
insert into help_items values(7,'net.tcp.dns[ip, zone]','Checks if DNS service is up. 0 - DNS is down, 1 - DNS is up.');
insert into help_items values(7,'net.tcp.dns.query[ip, zone, type]','Performs a query for the record type specified by the parameter type');
insert into help_items values(7,'net.tcp.listen[port]','Checks if this port is in LISTEN state. 0 - it is not, 1 - it is in LISTEN state.');
insert into help_items values(7,'net.tcp.port[&lt;ip&gt;, port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
insert into help_items values(7,'net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]','Check if service server is running and accepting connections. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
insert into help_items values(7,'net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]','Check performance of service &quot;service&quot;. 0 - service is down, sec - number of seconds spent on connection to the service. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
insert into help_items values(7,'proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt; &lt;,cmdline&gt;]','Memory used by process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used. Example: proc.mem[,root]');
insert into help_items values(7,'proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt; &lt;,cmdline&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Examples: proc.num[,mysql]; proc.num[apache2,www-data]; proc.num[,oracle,sleep,oracleZABBIX]');
insert into help_items values(7,'system.cpu.intr','Device interrupts.');
insert into help_items values(7,'system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');
insert into help_items values(7,'system.cpu.switches','Context switches.');
insert into help_items values(7,'system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');
insert into help_items values(7,'system.boottime','Timestamp of system boot.');
insert into help_items values(7,'system.cpu.num','Number of available proccessors.');
insert into help_items values(7,'system.hostname','Return host name. String value. Example of returned value: www.zabbix.com');
insert into help_items values(7,'system.localtime','System local time. Time in seconds.');
insert into help_items values(7,'system.run[command,&lt;mode&gt]','Run specified command on the host.');
insert into help_items values(7,'system.swap.in[&lt;swap&gt; &lt;,type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
insert into help_items values(7,'system.swap.out[&lt;swap&gt; &lt;,type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
insert into help_items values(7,'system.swap.size[&lt;swap&gt; &lt;,mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');
insert into help_items values(7,'system.uname','Returns detailed host information. String value');
insert into help_items values(7,'system.uptime','System uptime in seconds.');
insert into help_items values(7,'system.users.num','Number of users connected. Command who is used on agent side.');
insert into help_items values(7,'vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]','Device read statistics.');
insert into help_items values(7,'vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]','Device write statistics.');
insert into help_items values(7,'vfs.file.cksum[file]','Calculate check sum of a given file. Check sum of the file calculate by standard algorithm used by UNIX utility cksum. Example: vfs.file.cksum[/etc/passwd]');
insert into help_items values(7,'vfs.file.exists[file]','Check file existance. 0 - file does not exists, 1 - file exists');
insert into help_items values(7,'vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]');
insert into help_items values(7,'vfs.file.regexp[file,regexp]','Find string in a file. Matched string');
insert into help_items values(7,'vfs.file.regmatch[file,regexp]','Find string in a file. 0 - expression not found, 1 - found');
insert into help_items values(7,'vfs.file.size[file]','Size of a given file. Size in bytes. File must have read permissions for user zabbix. Example: vfs.file.size[/var/log/syslog]');
insert into help_items values(7,'vfs.file.time[file&lt;, mode&gt;]','File time information. Number of seconds.	The mode is optional. If mode is missing modify is used.');
insert into help_items values(7,'vfs.fs.inode[fs &lt;,mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
insert into help_items values(7,'vfs.fs.size[fs &lt;,mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');
insert into help_items values(7,'vm.memory.size[&lt;mode&gt;]','Amount of memory size in bytes. If mode is missing total is used.');
insert into help_items values(7,'web.page.get[host,&lt;path&gt;,&lt;port&gt;]','Get content of WEB page. Default path is /');
insert into help_items values(7,'web.page.perf[host,&lt;path&gt;,&lt;port&gt;]','Get timing of loading full WEB page. Default path is /');
insert into help_items values(7,'web.page.regexp[host,&lt;path&gt;,&lt;port&gt;,&lt;regexp&gt;,&lt;length&gt;]','Get first occurence of regexp in WEB page. Default path is /');
insert into help_items values(7,'perf_counter[counter]','Value of any performance counter, where parameter is the counter path.');
insert into help_items values(7,'service_state[service]','State of service. 0 - running, 1 - paused, 2 - start pending, 3 - pause pending, 4 - continue pending, 5 - stop pending, 6 - stopped, 7 - unknown, 255 - no such service');
insert into help_items values(7,'proc_info[&lt;process&gt;,&lt;attribute&gt;,&lt;type&gt;]','Different information about specific process(es)');
insert into help_items values(7,'log[file,&lt;pattern&gt;,&lt;encoding&gt;,&lt;maxlines&gt;]','Monitoring of log file. pattern - regular expression');
insert into help_items values(7,'logrt[file_format,&lt;pattern&gt;,&lt;encoding&gt;,&lt;maxlines&gt;]', 'Monitoring of log file with rotation. fileformat - [path][regexp], pattern - regular expression');
insert into help_items values(7,'eventlog[logtype,&lt;pattern&gt;,&lt;severity&gt;,&lt;source&gt;,&lt;eventid&gt;,&lt;maxlines&gt;]','Monitoring of Windows event logs. pattern, severity, eventid - regular expressions');

--
-- Dumping data for table items
--

INSERT INTO items VALUES (10001,0,'','',161,10001,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10002,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10003,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10004,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10005,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10006,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10007,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10008,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10009,0,'','',161,10001,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10010,0,'','',161,10001,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10011,0,'','',161,10001,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10012,0,'','',161,10001,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10013,0,'','',161,10001,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10014,0,'','',161,10001,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10015,0,'','',161,10001,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10016,0,'','',161,10001,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10017,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10018,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10019,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10020,0,'','',161,10001,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10021,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10022,0,'','',161,10001,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10023,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10024,0,'','',161,10001,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10025,0,'','',161,10001,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10026,0,'','',161,10001,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10027,0,'','',161,10001,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10028,0,'','',161,10001,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10029,0,'','',161,10001,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10030,0,'','',161,10001,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10031,0,'','',161,10001,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10032,0,'','',161,10001,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10033,0,'','',161,10001,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10036,0,'','',161,10001,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10037,0,'','',161,10001,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10038,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10039,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10040,0,'','',161,10001,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10046,0,'','',161,10001,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10047,0,'','',161,10001,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10048,0,'','',161,10001,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10049,0,'','',161,10001,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10050,0,'','',161,10001,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10051,0,'','',161,10001,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10052,0,'','',161,10001,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10053,0,'','',161,10001,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10055,0,'','',161,10001,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10056,0,'','',161,10001,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10057,0,'','',161,10001,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10058,0,'','',161,10001,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10059,0,'','',161,10001,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10060,0,'','',161,10001,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10061,0,'','',161,10001,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10062,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10063,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10064,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10065,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10066,0,'','',161,10001,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10067,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10068,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10069,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10070,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10071,0,'','',161,10001,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10072,0,'','',161,10001,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10075,0,'','',161,10001,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10078,0,'','',161,10001,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10081,0,'','',161,10001,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10084,0,'','',161,10001,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10087,0,'','',161,10001,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10090,0,'','',161,10002,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10091,0,'','',161,10002,'Free disk space on $1','vfs.fs.size[c:,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10098,0,'','',161,10002,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10099,0,'','',161,10002,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10100,0,'','',161,10002,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10101,0,'','',161,10002,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10102,0,'','',161,10002,'Number of running processes','system[procrunning]',30,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10103,0,'','',161,10002,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10104,0,'','',161,10002,'Size of $1','vfs.file.size[c:\\msdos.sys]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10106,0,'','',161,10002,'Checksum of $1','vfs.file.cksum[c:\\autoexec.bat]',600,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10109,0,'','',161,10002,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10114,0,'','',161,10002,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,0,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10115,0,'','',161,10002,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10119,0,'','',161,10002,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10137,0,'','',161,10002,'Number of running processes apache','proc_cnt[httpd]',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10147,0,'','',161,10002,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10148,0,'','',161,10002,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10150,0,'','',161,10002,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10156,0,'','',161,10002,'Total disk space on $1','vfs.fs.size[c:,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10200,0,'','',161,10003,'MySQL is alive','mysql.ping',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10201,0,'','',161,10003,'MySQL uptime','mysql.uptime',60,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10202,0,'','',161,10003,'MySQL number of threads','mysql.threads',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10203,0,'','',161,10003,'MySQL queries per second','mysql.qps',60,7,365,NULL,NULL,NULL,0,0,'','qps',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10204,0,'','',161,10003,'MySQL number of slow queries','mysql.slowqueries',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10205,0,'','',161,10003,'MySQL version','version.mysql',600,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10298,3,'','',161,10004,'Email (SMTP) server is running','smtp',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10299,3,'','',161,10004,'FTP server is running','ftp',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10300,3,'','',161,10004,'SSH server is running','ssh',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10303,3,'','',161,10004,'POP3 server is running','pop',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10304,3,'','',161,10004,'IMAP server is running','imap',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10313,3,'','',161,10004,'News (NNTP) server is running','nntp',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10327,3,'','',161,10004,'WEB (HTTP) server is running','http',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10357,0,'','',161,10002,'Checksum of $1','vfs.file.cksum[c:\\config.sys]',600,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10358,0,'','',161,10002,'Free disk space on $1','vfs.fs.size[d:,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10359,0,'','',161,10002,'Total disk space on $1','vfs.fs.size[d:,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10412,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10413,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10414,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10415,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10416,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10417,0,'','',161,10001,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10418,0,'','',161,10001,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10419,0,'','',161,10001,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (10420,0,'','',161,10001,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17001,4,'public','1.3.6.1.2.1.1.5.0',161,10007,'sysName','sysName',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17002,4,'public','1.3.6.1.4.1.9.2.1.112.0',161,10007,'lenvSerialNumber','lenvSerialNumber',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17003,4,'public','1.3.6.1.4.1.9.2.1.47.0',161,10007,'lmemBufferNoMem','lmemBufferNoMem',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17004,4,'public','1.3.6.1.4.1.9.2.1.56.0',161,10007,'lcpuPercentBusy','lcpuPercentBusy',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17005,4,'public','1.3.6.1.4.1.9.2.1.108.0',161,10007,'lenvFirmVersion','lenvFirmVersion',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17006,4,'public','1.3.6.1.4.1.9.2.1.46.0',161,10007,'lmemBufferFail','lmemBufferFail',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17007,4,'public','1.3.6.1.4.1.9.2.1.8.0',161,10007,'lmemFreeMem','lmemFreeMem',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17008,4,'public','1.3.6.1.4.1.9.2.1.1.0',161,10007,'lmemRomID','lmemRomID',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17009,4,'public','1.3.6.1.2.1.2.2.1.2.1',161,10007,'ifDescr1','ifDescr1',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17010,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10007,'ifDescr2','ifDescr2',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17011,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10007,'ifDescr3','ifDescr3',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17012,4,'public','1.3.6.1.2.1.2.2.1.2.4',161,10007,'ifDescr4','ifDescr4',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17013,4,'public','1.3.6.1.2.1.2.2.1.2.5',161,10007,'ifDescr5','ifDescr5',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17014,4,'public','1.3.6.1.2.1.2.2.1.2.6',161,10007,'ifDescr6','ifDescr6',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17015,4,'public','1.3.6.1.2.1.2.2.1.2.7',161,10007,'ifDescr7','ifDescr7',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17016,4,'public','1.3.6.1.2.1.2.2.1.2.8',161,10007,'ifDescr8','ifDescr8',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17017,4,'public','1.3.6.1.2.1.2.2.1.2.9',161,10007,'ifDescr9','ifDescr9',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17018,4,'public','1.3.6.1.2.1.2.2.1.2.10',161,10007,'ifDescr10','ifDescr10',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17019,4,'public','1.3.6.1.2.1.2.2.1.2.11',161,10007,'ifDescr11','ifDescr11',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17020,4,'public','1.3.6.1.2.1.2.2.1.2.12',161,10007,'ifDescr12','ifDescr12',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17021,4,'public','1.3.6.1.2.1.2.2.1.2.13',161,10007,'ifDescr13','ifDescr13',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17022,4,'public','1.3.6.1.2.1.2.2.1.2.14',161,10007,'ifDescr14','ifDescr14',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17023,4,'public','1.3.6.1.2.1.2.2.1.2.15',161,10007,'ifDescr15','ifDescr15',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17024,4,'public','1.3.6.1.2.1.2.2.1.2.16',161,10007,'ifDescr16','ifDescr16',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17025,4,'public','1.3.6.1.2.1.2.2.1.2.17',161,10007,'ifDescr17','ifDescr17',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17026,4,'public','1.3.6.1.2.1.2.2.1.2.18',161,10007,'ifDescr18','ifDescr18',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17027,4,'public','1.3.6.1.2.1.2.2.1.2.19',161,10007,'ifDescr19','ifDescr19',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17028,4,'public','1.3.6.1.2.1.2.2.1.2.20',161,10007,'ifDescr20','ifDescr20',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17029,4,'public','1.3.6.1.2.1.2.2.1.2.21',161,10007,'ifDescr21','ifDescr21',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17030,4,'public','1.3.6.1.2.1.2.2.1.2.22',161,10007,'ifDescr22','ifDescr22',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17031,4,'public','1.3.6.1.2.1.2.2.1.2.23',161,10007,'ifDescr23','ifDescr23',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17032,4,'public','1.3.6.1.2.1.2.2.1.2.24',161,10007,'ifDescr24','ifDescr24',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17033,4,'public','1.3.6.1.2.1.2.2.1.2.25',161,10007,'ifDescr25','ifDescr25',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17034,4,'public','1.3.6.1.2.1.2.2.1.2.26',161,10007,'ifDescr26','ifDescr26',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17035,4,'public','1.3.6.1.2.1.2.2.1.2.27',161,10007,'ifDescr27','ifDescr27',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17036,4,'public','1.3.6.1.2.1.2.2.1.2.28',161,10007,'ifDescr28','ifDescr28',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17037,4,'public','1.3.6.1.2.1.2.2.1.2.29',161,10007,'ifDescr29','ifDescr29',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17038,4,'public','1.3.6.1.2.1.2.2.1.2.30',161,10007,'ifDescr30','ifDescr30',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17039,4,'public','1.3.6.1.2.1.2.2.1.2.31',161,10007,'ifDescr31','ifDescr31',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17040,4,'public','1.3.6.1.2.1.2.2.1.2.32',161,10007,'ifDescr32','ifDescr32',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17041,4,'public','1.3.6.1.2.1.2.2.1.2.33',161,10007,'ifDescr33','ifDescr33',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17042,4,'public','1.3.6.1.2.1.2.2.1.2.34',161,10007,'ifDescr34','ifDescr34',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17043,4,'public','1.3.6.1.2.1.2.2.1.2.35',161,10007,'ifDescr35','ifDescr35',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17044,4,'public','1.3.6.1.2.1.2.2.1.2.36',161,10007,'ifDescr36','ifDescr36',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17045,4,'public','1.3.6.1.2.1.2.2.1.2.37',161,10007,'ifDescr37','ifDescr37',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17046,4,'public','1.3.6.1.2.1.2.2.1.2.38',161,10007,'ifDescr38','ifDescr38',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17047,4,'public','1.3.6.1.2.1.2.2.1.2.39',161,10007,'ifDescr39','ifDescr39',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17048,4,'public','1.3.6.1.2.1.2.2.1.2.40',161,10007,'ifDescr40','ifDescr40',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17049,4,'public','1.3.6.1.2.1.2.2.1.2.41',161,10007,'ifDescr41','ifDescr41',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17050,4,'public','1.3.6.1.2.1.2.2.1.2.42',161,10007,'ifDescr42','ifDescr42',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17051,4,'public','1.3.6.1.2.1.2.2.1.2.43',161,10007,'ifDescr43','ifDescr43',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17052,4,'public','1.3.6.1.2.1.2.2.1.2.44',161,10007,'ifDescr44','ifDescr44',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17053,4,'public','1.3.6.1.2.1.2.2.1.2.45',161,10007,'ifDescr45','ifDescr45',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17054,4,'public','1.3.6.1.2.1.2.2.1.2.46',161,10007,'ifDescr46','ifDescr46',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17055,4,'public','1.3.6.1.2.1.2.2.1.2.47',161,10007,'ifDescr47','ifDescr47',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17056,4,'public','1.3.6.1.2.1.2.2.1.2.48',161,10007,'ifDescr48','ifDescr48',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17057,4,'public','1.3.6.1.2.1.2.2.1.2.49',161,10007,'ifDescr49','ifDescr49',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17058,4,'public','1.3.6.1.2.1.2.2.1.2.50',161,10007,'ifDescr50','ifDescr50',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17059,4,'public','1.3.6.1.2.1.2.2.1.2.51',161,10007,'ifDescr51','ifDescr51',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17060,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10007,'ifInOctets1','ifInOctets1',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17061,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10007,'ifInOctets2','ifInOctets2',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17062,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10007,'ifInOctets3','ifInOctets3',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17063,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10007,'ifInOctets4','ifInOctets4',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17064,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10007,'ifInOctets5','ifInOctets5',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17065,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10007,'ifInOctets6','ifInOctets6',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17066,4,'public','1.3.6.1.2.1.2.2.1.10.7',161,10007,'ifInOctets7','ifInOctets7',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17067,4,'public','1.3.6.1.2.1.2.2.1.10.8',161,10007,'ifInOctets8','ifInOctets8',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17068,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10007,'ifInOctets9','ifInOctets9',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17069,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10007,'ifInOctets10','ifInOctets10',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17070,4,'public','1.3.6.1.2.1.2.2.1.10.11',161,10007,'ifInOctets11','ifInOctets11',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17071,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10007,'ifInOctets12','ifInOctets12',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17072,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10007,'ifInOctets13','ifInOctets13',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17073,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10007,'ifInOctets14','ifInOctets14',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17074,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10007,'ifInOctets15','ifInOctets15',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17075,4,'public','1.3.6.1.2.1.2.2.1.10.16',161,10007,'ifInOctets16','ifInOctets16',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17076,4,'public','1.3.6.1.2.1.2.2.1.10.17',161,10007,'ifInOctets17','ifInOctets17',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17077,4,'public','1.3.6.1.2.1.2.2.1.10.18',161,10007,'ifInOctets18','ifInOctets18',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17078,4,'public','1.3.6.1.2.1.2.2.1.10.19',161,10007,'ifInOctets19','ifInOctets19',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17079,4,'public','1.3.6.1.2.1.2.2.1.10.20',161,10007,'ifInOctets20','ifInOctets20',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17080,4,'public','1.3.6.1.2.1.2.2.1.10.21',161,10007,'ifInOctets21','ifInOctets21',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17081,4,'public','1.3.6.1.2.1.2.2.1.10.22',161,10007,'ifInOctets22','ifInOctets22',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17082,4,'public','1.3.6.1.2.1.2.2.1.10.23',161,10007,'ifInOctets23','ifInOctets23',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17083,4,'public','1.3.6.1.2.1.2.2.1.10.24',161,10007,'ifInOctets24','ifInOctets24',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17084,4,'public','1.3.6.1.2.1.2.2.1.10.25',161,10007,'ifInOctets25','ifInOctets25',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17085,4,'public','1.3.6.1.2.1.2.2.1.10.26',161,10007,'ifInOctets26','ifInOctets26',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17086,4,'public','1.3.6.1.2.1.2.2.1.10.27',161,10007,'ifInOctets27','ifInOctets27',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17087,4,'public','1.3.6.1.2.1.2.2.1.10.28',161,10007,'ifInOctets28','ifInOctets28',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17088,4,'public','1.3.6.1.2.1.2.2.1.10.29',161,10007,'ifInOctets29','ifInOctets29',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17089,4,'public','1.3.6.1.2.1.2.2.1.10.30',161,10007,'ifInOctets30','ifInOctets30',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17090,4,'public','1.3.6.1.2.1.2.2.1.10.31',161,10007,'ifInOctets31','ifInOctets31',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17091,4,'public','1.3.6.1.2.1.2.2.1.10.32',161,10007,'ifInOctets32','ifInOctets32',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17092,4,'public','1.3.6.1.2.1.2.2.1.10.33',161,10007,'ifInOctets33','ifInOctets33',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17093,4,'public','1.3.6.1.2.1.2.2.1.10.34',161,10007,'ifInOctets34','ifInOctets34',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17094,4,'public','1.3.6.1.2.1.2.2.1.10.35',161,10007,'ifInOctets35','ifInOctets35',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17095,4,'public','1.3.6.1.2.1.2.2.1.10.36',161,10007,'ifInOctets36','ifInOctets36',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17096,4,'public','1.3.6.1.2.1.2.2.1.10.37',161,10007,'ifInOctets37','ifInOctets37',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17097,4,'public','1.3.6.1.2.1.2.2.1.10.38',161,10007,'ifInOctets38','ifInOctets38',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17098,4,'public','1.3.6.1.2.1.2.2.1.10.39',161,10007,'ifInOctets39','ifInOctets39',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17099,4,'public','1.3.6.1.2.1.2.2.1.10.40',161,10007,'ifInOctets40','ifInOctets40',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17100,4,'public','1.3.6.1.2.1.2.2.1.10.41',161,10007,'ifInOctets41','ifInOctets41',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17101,4,'public','1.3.6.1.2.1.2.2.1.10.42',161,10007,'ifInOctets42','ifInOctets42',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17102,4,'public','1.3.6.1.2.1.2.2.1.10.43',161,10007,'ifInOctets43','ifInOctets43',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17103,4,'public','1.3.6.1.2.1.2.2.1.10.44',161,10007,'ifInOctets44','ifInOctets44',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17104,4,'public','1.3.6.1.2.1.2.2.1.10.45',161,10007,'ifInOctets45','ifInOctets45',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17105,4,'public','1.3.6.1.2.1.2.2.1.10.46',161,10007,'ifInOctets46','ifInOctets46',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17106,4,'public','1.3.6.1.2.1.2.2.1.10.47',161,10007,'ifInOctets47','ifInOctets47',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17107,4,'public','1.3.6.1.2.1.2.2.1.10.48',161,10007,'ifInOctets48','ifInOctets48',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17108,4,'public','1.3.6.1.2.1.2.2.1.10.49',161,10007,'ifInOctets49','ifInOctets49',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17109,4,'public','1.3.6.1.2.1.2.2.1.10.50',161,10007,'ifInOctets50','ifInOctets50',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17110,4,'public','1.3.6.1.2.1.2.2.1.10.51',161,10007,'ifInOctets51','ifInOctets51',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17111,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10007,'ifOutOctets1','ifOutOctets1',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17112,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10007,'ifOutOctets2','ifOutOctets2',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17113,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10007,'ifOutOctets3','ifOutOctets3',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17114,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10007,'ifOutOctets4','ifOutOctets4',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17115,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10007,'ifOutOctets5','ifOutOctets5',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17116,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10007,'ifOutOctets6','ifOutOctets6',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17117,4,'public','1.3.6.1.2.1.2.2.1.16.7',161,10007,'ifOutOctets7','ifOutOctets7',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17118,4,'public','1.3.6.1.2.1.2.2.1.16.8',161,10007,'ifOutOctets8','ifOutOctets8',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17119,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10007,'ifOutOctets9','ifOutOctets9',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17120,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10007,'ifOutOctets10','ifOutOctets10',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17121,4,'public','1.3.6.1.2.1.2.2.1.16.11',161,10007,'ifOutOctets11','ifOutOctets11',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17122,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10007,'ifOutOctets12','ifOutOctets12',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17123,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10007,'ifOutOctets13','ifOutOctets13',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17124,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10007,'ifOutOctets14','ifOutOctets14',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17125,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10007,'ifOutOctets15','ifOutOctets15',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17126,4,'public','1.3.6.1.2.1.2.2.1.16.16',161,10007,'ifOutOctets16','ifOutOctets16',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17127,4,'public','1.3.6.1.2.1.2.2.1.16.17',161,10007,'ifOutOctets17','ifOutOctets17',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17128,4,'public','1.3.6.1.2.1.2.2.1.16.18',161,10007,'ifOutOctets18','ifOutOctets18',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17129,4,'public','1.3.6.1.2.1.2.2.1.16.19',161,10007,'ifOutOctets19','ifOutOctets19',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17130,4,'public','1.3.6.1.2.1.2.2.1.16.20',161,10007,'ifOutOctets20','ifOutOctets20',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17131,4,'public','1.3.6.1.2.1.2.2.1.16.21',161,10007,'ifOutOctets21','ifOutOctets21',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17132,4,'public','1.3.6.1.2.1.2.2.1.16.22',161,10007,'ifOutOctets22','ifOutOctets22',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17133,4,'public','1.3.6.1.2.1.2.2.1.16.23',161,10007,'ifOutOctets23','ifOutOctets23',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17134,4,'public','1.3.6.1.2.1.2.2.1.16.24',161,10007,'ifOutOctets24','ifOutOctets24',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17135,4,'public','1.3.6.1.2.1.2.2.1.16.25',161,10007,'ifOutOctets25','ifOutOctets25',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17136,4,'public','1.3.6.1.2.1.2.2.1.16.26',161,10007,'ifOutOctets26','ifOutOctets26',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17137,4,'public','1.3.6.1.2.1.2.2.1.16.27',161,10007,'ifOutOctets27','ifOutOctets27',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17138,4,'public','1.3.6.1.2.1.2.2.1.16.28',161,10007,'ifOutOctets28','ifOutOctets28',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17139,4,'public','1.3.6.1.2.1.2.2.1.16.29',161,10007,'ifOutOctets29','ifOutOctets29',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17140,4,'public','1.3.6.1.2.1.2.2.1.16.30',161,10007,'ifOutOctets30','ifOutOctets30',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17141,4,'public','1.3.6.1.2.1.2.2.1.16.31',161,10007,'ifOutOctets31','ifOutOctets31',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17142,4,'public','1.3.6.1.2.1.2.2.1.16.32',161,10007,'ifOutOctets32','ifOutOctets32',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17143,4,'public','1.3.6.1.2.1.2.2.1.16.33',161,10007,'ifOutOctets33','ifOutOctets33',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17144,4,'public','1.3.6.1.2.1.2.2.1.16.34',161,10007,'ifOutOctets34','ifOutOctets34',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17145,4,'public','1.3.6.1.2.1.2.2.1.16.35',161,10007,'ifOutOctets35','ifOutOctets35',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17146,4,'public','1.3.6.1.2.1.2.2.1.16.36',161,10007,'ifOutOctets36','ifOutOctets36',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17147,4,'public','1.3.6.1.2.1.2.2.1.16.37',161,10007,'ifOutOctets37','ifOutOctets37',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17148,4,'public','1.3.6.1.2.1.2.2.1.16.38',161,10007,'ifOutOctets38','ifOutOctets38',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17149,4,'public','1.3.6.1.2.1.2.2.1.16.39',161,10007,'ifOutOctets39','ifOutOctets39',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17150,4,'public','1.3.6.1.2.1.2.2.1.16.40',161,10007,'ifOutOctets40','ifOutOctets40',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17151,4,'public','1.3.6.1.2.1.2.2.1.16.41',161,10007,'ifOutOctets41','ifOutOctets41',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17152,4,'public','1.3.6.1.2.1.2.2.1.16.42',161,10007,'ifOutOctets42','ifOutOctets42',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17153,4,'public','1.3.6.1.2.1.2.2.1.16.43',161,10007,'ifOutOctets43','ifOutOctets43',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17154,4,'public','1.3.6.1.2.1.2.2.1.16.44',161,10007,'ifOutOctets44','ifOutOctets44',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17155,4,'public','1.3.6.1.2.1.2.2.1.16.45',161,10007,'ifOutOctets45','ifOutOctets45',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17156,4,'public','1.3.6.1.2.1.2.2.1.16.46',161,10007,'ifOutOctets46','ifOutOctets46',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17157,4,'public','1.3.6.1.2.1.2.2.1.16.47',161,10007,'ifOutOctets47','ifOutOctets47',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17158,4,'public','1.3.6.1.2.1.2.2.1.16.48',161,10007,'ifOutOctets48','ifOutOctets48',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17159,4,'public','1.3.6.1.2.1.2.2.1.16.49',161,10007,'ifOutOctets49','ifOutOctets49',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17160,4,'public','1.3.6.1.2.1.2.2.1.16.50',161,10007,'ifOutOctets50','ifOutOctets50',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17161,4,'public','1.3.6.1.2.1.2.2.1.16.51',161,10007,'ifOutOctets51','ifOutOctets51',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17162,4,'public','1.3.6.1.2.1.4.1.0',161,10007,'ipForwarding','ipForwarding',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17163,4,'public','1.3.6.1.2.1.4.2.0',161,10007,'ipDefaultTTL','ipDefaultTTL',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17164,4,'public','1.3.6.1.2.1.4.3.0',161,10007,'ipInReceives','ipInReceives',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17165,4,'public','1.3.6.1.2.1.4.4.0',161,10007,'ipInHdrErrors','ipInHdrErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17166,4,'public','1.3.6.1.2.1.4.5.0',161,10007,'ipInAddrErrors','ipInAddrErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17167,4,'public','1.3.6.1.2.1.4.6.0',161,10007,'ipInForwDatagrams','ipInForwDatagrams',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17168,4,'public','1.3.6.1.2.1.4.7.0',161,10007,'ipInUnknownProtos','ipInUnknownProtos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17169,4,'public','1.3.6.1.2.1.4.8.0',161,10007,'ipInDiscards','ipInDiscards',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17170,4,'public','1.3.6.1.2.1.4.9.0',161,10007,'ipInDelivers','ipInDelivers',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17171,4,'public','1.3.6.1.2.1.4.10.0',161,10007,'ipOutRequests','ipOutRequests',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17172,4,'public','1.3.6.1.2.1.4.11.0',161,10007,'ipOutDiscards','ipOutDiscards',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17173,4,'public','1.3.6.1.2.1.4.12.0',161,10007,'ipOutNoRoutes','ipOutNoRoutes',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17174,4,'public','1.3.6.1.2.1.4.13.0',161,10007,'ipReasmTimeout','ipReasmTimeout',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17175,4,'public','1.3.6.1.2.1.4.14.0',161,10007,'ipReasmReqds','ipReasmReqds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17176,4,'public','1.3.6.1.2.1.4.15.0',161,10007,'ipReasmOKs','ipReasmOKs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17177,4,'public','1.3.6.1.2.1.4.16.0',161,10007,'ipReasmFails','ipReasmFails',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17178,4,'public','1.3.6.1.2.1.4.17.0',161,10007,'ipFragOKs','ipFragOKs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17179,4,'public','1.3.6.1.2.1.4.18.0',161,10007,'ipFragFails','ipFragFails',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17180,4,'public','1.3.6.1.2.1.4.19.0',161,10007,'ipFragCreates','ipFragCreates',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17181,4,'public','1.3.6.1.2.1.4.23.0',161,10007,'ipRoutingDiscards','ipRoutingDiscards',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17182,4,'public','1.3.6.1.2.1.5.1.0',161,10007,'icmpInMsgs','icmpInMsgs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17183,4,'public','1.3.6.1.2.1.5.2.0',161,10007,'icmpInErrors','icmpInErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17184,4,'public','1.3.6.1.2.1.5.3.0',161,10007,'icmpInDestUnreachs','icmpInDestUnreachs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17185,4,'public','1.3.6.1.2.1.5.4.0',161,10007,'icmpInTimeExcds','icmpInTimeExcds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17186,4,'public','1.3.6.1.2.1.5.5.0',161,10007,'icmpInParmProbs','icmpInParmProbs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17187,4,'public','1.3.6.1.2.1.5.6.0',161,10007,'icmpInSrcQuenchs','icmpInSrcQuenchs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17188,4,'public','1.3.6.1.2.1.5.7.0',161,10007,'icmpInRedirects','icmpInRedirects',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17189,4,'public','1.3.6.1.2.1.5.8.0',161,10007,'icmpInEchos','icmpInEchos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17190,4,'public','1.3.6.1.2.1.5.9.0',161,10007,'icmpInEchoReps','icmpInEchoReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17191,4,'public','1.3.6.1.2.1.5.10.0',161,10007,'icmpInTimestamps','icmpInTimestamps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17192,4,'public','1.3.6.1.2.1.5.11.0',161,10007,'icmpInTimestampReps','icmpInTimestampReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17193,4,'public','1.3.6.1.2.1.5.12.0',161,10007,'icmpInAddrMasks','icmpInAddrMasks',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17194,4,'public','1.3.6.1.2.1.5.13.0',161,10007,'icmpInAddrMaskReps','icmpInAddrMaskReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17195,4,'public','1.3.6.1.2.1.5.14.0',161,10007,'icmpOutMsgs','icmpOutMsgs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17196,4,'public','1.3.6.1.2.1.5.15.0',161,10007,'icmpOutErrors','icmpOutErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17197,4,'public','1.3.6.1.2.1.5.16.0',161,10007,'icmpOutDesUnreachs','icmpOutDesUnreachs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17198,4,'public','1.3.6.1.2.1.5.17.0',161,10007,'icmpOutTimeExcds','icmpOutTimeExcds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17199,4,'public','1.3.6.1.2.1.5.18.0',161,10007,'icmpOutParmProbs','icmpOutParmProbs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17200,4,'public','1.3.6.1.2.1.5.19.0',161,10007,'icmpOutSrcQuenchs','icmpOutSrcQuenchs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17202,4,'public','1.3.6.1.2.1.5.21.0',161,10007,'icmpOutEchos','icmpOutEchos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17203,4,'public','1.3.6.1.2.1.5.22.0',161,10007,'icmpOutEchoReps','icmpOutEchoReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17204,4,'public','1.3.6.1.2.1.5.23.0',161,10007,'icmpOutTimestamps','icmpOutTimestamps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17205,4,'public','1.3.6.1.2.1.5.24.0',161,10007,'icmpOutTimestampReps','icmpOutTimestampReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17206,4,'public','1.3.6.1.2.1.5.25.0',161,10007,'icmpOutAddrMasks','icmpOutAddrMasks',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17207,4,'public','1.3.6.1.2.1.5.26.0',161,10007,'icmpOutAddrMaskReps','icmpOutAddrMaskReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17208,4,'public','1.3.6.1.2.1.5.20.0',161,10007,'icmpOutRedirects','icmpOutRedirects',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17318,0,'','',161,10001,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17320,0,'','',161,10001,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17322,0,'','',161,10001,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17324,0,'','',161,10001,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17326,0,'','',161,10001,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17328,0,'','',161,10001,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17330,0,'','',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17332,0,'','',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17334,0,'','',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17336,0,'','',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17338,0,'','',161,10001,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17340,0,'','',161,10001,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17342,0,'','',161,10001,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17344,0,'','',161,10001,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17346,0,'','',161,10001,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17348,0,'','',161,10001,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17350,0,'','',161,10001,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17352,0,'','',161,10001,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17354,0,'','',161,10001,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17356,0,'','',161,10001,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17358,0,'','',161,10001,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17360,0,'','',161,10001,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17362,0,'','',161,10001,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17371,3,'','',161,10004,'ICMP ping','icmpping',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17373,0,'','',161,10001,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17397,0,'','',161,10002,'Service state of DHCP client ($1)','service_state[Dhcp]',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,3,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17399,0,'','',161,10002,'Number of threads','perf_counter[\\System\\threads]',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17401,0,'','',161,10002,'File read bytes per second','perf_counter[\\System\\File Read Bytes/sec]',30,90,365,NULL,NULL,NULL,0,0,'','Bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17403,0,'','',161,10002,'File write bytes per second','perf_counter[\\System\\File Write Bytes/sec]',30,90,365,NULL,NULL,NULL,0,0,'','Bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17405,0,'','',161,10002,'Average disk read queue length','perf_counter[\\Physical Disk(_Total)\\Avg. Disk Read Queue Length]',30,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17409,0,'','',161,10002,'Average disk read queue length','perf_counter[\\PhysicalDisk(_Total)\\Avg. Disk Read QUeue Length]',30,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17411,0,'','',161,10002,'Average disk write queue length','perf_counter[\\PhysicalDisk(_Total)\\Avg. Disk Write Queue Length]',30,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17412,0,'','',161,10008,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17413,0,'','',161,10008,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17414,0,'','',161,10008,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17415,0,'','',161,10008,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17416,0,'','',161,10008,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17417,0,'','',161,10008,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17418,0,'','',161,10008,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17419,0,'','',161,10008,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17420,0,'','',161,10008,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17421,0,'','',161,10008,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17422,0,'','',161,10008,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17423,0,'','',161,10008,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17424,0,'','',161,10008,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17425,0,'','',161,10008,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17426,0,'','',161,10008,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17427,0,'','',161,10008,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17428,0,'','',161,10008,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17429,0,'','',161,10008,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17430,0,'','',161,10008,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17431,0,'','',161,10008,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17432,0,'','',161,10008,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17433,0,'','',161,10008,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17434,0,'','',161,10008,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17435,0,'','',161,10008,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17436,0,'','',161,10008,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17437,0,'','',161,10008,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17438,0,'','',161,10008,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17439,0,'','',161,10008,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17440,0,'','',161,10008,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17441,0,'','',161,10008,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17442,0,'','',161,10008,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17443,0,'','',161,10008,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17444,0,'','',161,10008,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17445,0,'','',161,10008,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17446,0,'','',161,10008,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17447,0,'','',161,10008,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17448,0,'','',161,10008,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17449,0,'','',161,10008,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17450,0,'','',161,10008,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17451,0,'','',161,10008,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17452,0,'','',161,10008,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17453,0,'','',161,10008,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17454,0,'','',161,10008,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17455,0,'','',161,10008,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17456,0,'','',161,10008,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17457,0,'','',161,10008,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17458,0,'','',161,10008,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17459,0,'','',161,10008,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17460,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17461,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17462,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17463,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17464,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17465,0,'','',161,10008,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17466,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17467,0,'','',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17468,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17469,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17470,0,'','',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17471,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17472,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17473,0,'','',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17474,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17475,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17476,0,'','',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17477,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17478,0,'','',161,10008,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17479,0,'','',161,10008,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17480,0,'','',161,10008,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17481,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17482,0,'','',161,10008,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17483,0,'','',161,10008,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17484,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17485,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17486,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17487,0,'','',161,10008,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17488,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17489,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17490,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17491,0,'','',161,10008,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17492,0,'','',161,10008,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17493,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17494,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17495,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17496,0,'','',161,10008,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17497,0,'','',161,10008,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17498,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17499,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17500,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17501,0,'','',161,10008,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17502,0,'','',161,10008,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17503,0,'','',161,10008,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17504,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17505,0,'','',161,10008,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17506,0,'','',161,10008,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17507,0,'','',161,10008,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17508,0,'','',161,10008,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17509,0,'','',161,10008,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17510,0,'','',161,10008,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17511,0,'','',161,10008,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17512,0,'','',161,10008,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17513,0,'','',161,10008,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17514,0,'','',161,10009,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17515,0,'','',161,10009,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17516,0,'','',161,10009,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17517,0,'','',161,10009,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17518,0,'','',161,10009,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17519,0,'','',161,10009,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17520,0,'','',161,10009,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17521,0,'','',161,10009,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17522,0,'','',161,10009,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17523,0,'','',161,10009,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17524,0,'','',161,10009,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17525,0,'','',161,10009,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17526,0,'','',161,10009,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17527,0,'','',161,10009,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17528,0,'','',161,10009,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17529,0,'','',161,10009,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17530,0,'','',161,10009,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17531,0,'','',161,10009,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17532,0,'','',161,10009,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17533,0,'','',161,10009,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17534,0,'','',161,10009,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17535,0,'','',161,10009,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17536,0,'','',161,10009,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17537,0,'','',161,10009,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17538,0,'','',161,10009,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17539,0,'','',161,10009,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17540,0,'','',161,10009,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17541,0,'','',161,10009,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17542,0,'','',161,10009,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17543,0,'','',161,10009,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17544,0,'','',161,10009,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17545,0,'','',161,10009,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17546,0,'','',161,10009,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17547,0,'','',161,10009,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17548,0,'','',161,10009,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17549,0,'','',161,10009,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17550,0,'','',161,10009,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17551,0,'','',161,10009,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17552,0,'','',161,10009,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17553,0,'','',161,10009,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17554,0,'','',161,10009,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17555,0,'','',161,10009,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17556,0,'','',161,10009,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17557,0,'','',161,10009,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17558,0,'','',161,10009,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17559,0,'','',161,10009,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17560,0,'','',161,10009,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17561,0,'','',161,10009,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17562,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17563,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17564,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17565,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17566,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17567,0,'','',161,10009,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17568,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17569,0,'','',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17570,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17571,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17572,0,'','',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17573,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17574,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17575,0,'','',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17576,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17577,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17578,0,'','',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17579,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17580,0,'','',161,10009,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17581,0,'','',161,10009,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17582,0,'','',161,10009,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17583,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17584,0,'','',161,10009,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17585,0,'','',161,10009,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17586,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17587,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17588,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17589,0,'','',161,10009,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17590,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17591,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17592,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17593,0,'','',161,10009,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17594,0,'','',161,10009,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17595,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17596,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17597,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17598,0,'','',161,10009,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17599,0,'','',161,10009,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17600,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17601,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17602,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17603,0,'','',161,10009,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17604,0,'','',161,10009,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17605,0,'','',161,10009,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17606,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17607,0,'','',161,10009,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17608,0,'','',161,10009,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17609,0,'','',161,10009,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17610,0,'','',161,10009,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17611,0,'','',161,10009,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17612,0,'','',161,10009,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17613,0,'','',161,10009,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17614,0,'','',161,10009,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17615,0,'','',161,10009,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17616,0,'','',161,10010,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17617,0,'','',161,10010,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17618,0,'','',161,10010,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17619,0,'','',161,10010,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17620,0,'','',161,10010,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17621,0,'','',161,10010,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17622,0,'','',161,10010,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17623,0,'','',161,10010,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17624,0,'','',161,10010,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17625,0,'','',161,10010,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17626,0,'','',161,10010,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17627,0,'','',161,10010,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17628,0,'','',161,10010,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17629,0,'','',161,10010,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17630,0,'','',161,10010,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17631,0,'','',161,10010,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17632,0,'','',161,10010,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17633,0,'','',161,10010,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17634,0,'','',161,10010,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17635,0,'','',161,10010,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17636,0,'','',161,10010,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17637,0,'','',161,10010,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17638,0,'','',161,10010,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17639,0,'','',161,10010,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17640,0,'','',161,10010,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17641,0,'','',161,10010,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17642,0,'','',161,10010,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17643,0,'','',161,10010,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17644,0,'','',161,10010,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17645,0,'','',161,10010,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17646,0,'','',161,10010,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17647,0,'','',161,10010,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17648,0,'','',161,10010,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17649,0,'','',161,10010,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17650,0,'','',161,10010,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17651,0,'','',161,10010,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17652,0,'','',161,10010,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17653,0,'','',161,10010,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17654,0,'','',161,10010,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17655,0,'','',161,10010,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17656,0,'','',161,10010,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17657,0,'','',161,10010,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17658,0,'','',161,10010,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17659,0,'','',161,10010,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17660,0,'','',161,10010,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17661,0,'','',161,10010,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17662,0,'','',161,10010,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17663,0,'','',161,10010,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17664,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17665,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17666,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17667,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17668,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17669,0,'','',161,10010,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17670,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17671,0,'','',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17672,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17673,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17674,0,'','',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17675,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17676,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17677,0,'','',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17678,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17679,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17680,0,'','',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17681,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17682,0,'','',161,10010,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17683,0,'','',161,10010,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17684,0,'','',161,10010,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17685,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17686,0,'','',161,10010,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17687,0,'','',161,10010,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17688,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17689,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17690,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17691,0,'','',161,10010,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17692,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17693,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17694,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17695,0,'','',161,10010,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17696,0,'','',161,10010,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17697,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17698,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17699,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17700,0,'','',161,10010,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17701,0,'','',161,10010,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17702,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17703,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17704,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17705,0,'','',161,10010,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17706,0,'','',161,10010,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17707,0,'','',161,10010,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17708,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17709,0,'','',161,10010,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17710,0,'','',161,10010,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17711,0,'','',161,10010,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17712,0,'','',161,10010,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17713,0,'','',161,10010,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17714,0,'','',161,10010,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17715,0,'','',161,10010,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17716,0,'','',161,10010,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17717,0,'','',161,10010,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17718,0,'','',161,10011,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17719,0,'','',161,10011,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17720,0,'','',161,10011,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17721,0,'','',161,10011,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17722,0,'','',161,10011,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17723,0,'','',161,10011,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17724,0,'','',161,10011,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17725,0,'','',161,10011,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17726,0,'','',161,10011,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17727,0,'','',161,10011,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17728,0,'','',161,10011,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17729,0,'','',161,10011,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17730,0,'','',161,10011,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17731,0,'','',161,10011,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17732,0,'','',161,10011,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17733,0,'','',161,10011,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17734,0,'','',161,10011,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17735,0,'','',161,10011,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17736,0,'','',161,10011,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17737,0,'','',161,10011,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17738,0,'','',161,10011,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17739,0,'','',161,10011,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17740,0,'','',161,10011,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17741,0,'','',161,10011,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17742,0,'','',161,10011,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17743,0,'','',161,10011,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17744,0,'','',161,10011,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17745,0,'','',161,10011,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17746,0,'','',161,10011,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17747,0,'','',161,10011,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17748,0,'','',161,10011,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17749,0,'','',161,10011,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17750,0,'','',161,10011,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17751,0,'','',161,10011,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17752,0,'','',161,10011,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17753,0,'','',161,10011,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17754,0,'','',161,10011,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17755,0,'','',161,10011,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17756,0,'','',161,10011,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17757,0,'','',161,10011,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17758,0,'','',161,10011,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17759,0,'','',161,10011,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17760,0,'','',161,10011,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17761,0,'','',161,10011,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17762,0,'','',161,10011,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17763,0,'','',161,10011,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17764,0,'','',161,10011,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17765,0,'','',161,10011,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17766,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17767,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17768,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17769,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17770,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17771,0,'','',161,10011,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17772,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17773,0,'','',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17774,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17775,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17776,0,'','',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17777,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17778,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17779,0,'','',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17780,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17781,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17782,0,'','',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17783,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17784,0,'','',161,10011,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17785,0,'','',161,10011,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17786,0,'','',161,10011,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17787,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17788,0,'','',161,10011,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17789,0,'','',161,10011,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17790,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17791,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17792,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17793,0,'','',161,10011,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17794,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17795,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17796,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17797,0,'','',161,10011,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17798,0,'','',161,10011,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17799,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17800,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17801,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17802,0,'','',161,10011,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17803,0,'','',161,10011,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17804,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17805,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17806,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17807,0,'','',161,10011,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17808,0,'','',161,10011,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17809,0,'','',161,10011,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17810,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17811,0,'','',161,10011,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17812,0,'','',161,10011,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17813,0,'','',161,10011,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17814,0,'','',161,10011,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17815,0,'','',161,10011,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17816,0,'','',161,10011,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17817,0,'','',161,10011,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17818,0,'','',161,10011,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17819,0,'','',161,10011,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17820,0,'','',161,10012,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17821,0,'','',161,10012,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17822,0,'','',161,10012,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17823,0,'','',161,10012,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17824,0,'','',161,10012,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17825,0,'','',161,10012,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17826,0,'','',161,10012,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17827,0,'','',161,10012,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17828,0,'','',161,10012,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17829,0,'','',161,10012,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17830,0,'','',161,10012,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17831,0,'','',161,10012,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17832,0,'','',161,10012,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17833,0,'','',161,10012,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17834,0,'','',161,10012,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17835,0,'','',161,10012,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17836,0,'','',161,10012,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17837,0,'','',161,10012,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17838,0,'','',161,10012,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17839,0,'','',161,10012,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17840,0,'','',161,10012,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17841,0,'','',161,10012,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17842,0,'','',161,10012,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17843,0,'','',161,10012,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17844,0,'','',161,10012,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17845,0,'','',161,10012,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17846,0,'','',161,10012,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17847,0,'','',161,10012,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17848,0,'','',161,10012,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17849,0,'','',161,10012,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17850,0,'','',161,10012,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17851,0,'','',161,10012,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17852,0,'','',161,10012,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17853,0,'','',161,10012,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17854,0,'','',161,10012,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17855,0,'','',161,10012,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17856,0,'','',161,10012,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17857,0,'','',161,10012,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17858,0,'','',161,10012,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17859,0,'','',161,10012,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17860,0,'','',161,10012,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17861,0,'','',161,10012,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17862,0,'','',161,10012,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17863,0,'','',161,10012,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17864,0,'','',161,10012,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17865,0,'','',161,10012,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17866,0,'','',161,10012,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17867,0,'','',161,10012,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17868,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17869,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17870,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17871,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17872,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17873,0,'','',161,10012,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17874,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17875,0,'','',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17876,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17877,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17878,0,'','',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17879,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17880,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17881,0,'','',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17882,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17883,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17884,0,'','',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17885,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17886,0,'','',161,10012,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17887,0,'','',161,10012,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17888,0,'','',161,10012,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17889,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17890,0,'','',161,10012,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17891,0,'','',161,10012,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17892,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17893,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17894,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17895,0,'','',161,10012,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17896,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17897,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17898,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17899,0,'','',161,10012,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17900,0,'','',161,10012,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17901,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17902,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17903,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17904,0,'','',161,10012,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17905,0,'','',161,10012,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17906,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17907,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17908,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17909,0,'','',161,10012,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17910,0,'','',161,10012,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17911,0,'','',161,10012,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17912,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17913,0,'','',161,10012,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17914,0,'','',161,10012,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17915,0,'','',161,10012,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17916,0,'','',161,10012,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17917,0,'','',161,10012,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17918,0,'','',161,10012,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17919,0,'','',161,10012,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17920,0,'','',161,10012,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17921,0,'','',161,10012,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17922,0,'','',161,10013,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17923,0,'','',161,10013,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17924,0,'','',161,10013,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17925,0,'','',161,10013,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17926,0,'','',161,10013,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17927,0,'','',161,10013,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17928,0,'','',161,10013,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17929,0,'','',161,10013,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17930,0,'','',161,10013,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17931,0,'','',161,10013,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17932,0,'','',161,10013,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17933,0,'','',161,10013,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17934,0,'','',161,10013,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17935,0,'','',161,10013,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17936,0,'','',161,10013,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17937,0,'','',161,10013,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17938,0,'','',161,10013,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17939,0,'','',161,10013,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17940,0,'','',161,10013,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17941,0,'','',161,10013,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17942,0,'','',161,10013,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17943,0,'','',161,10013,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17944,0,'','',161,10013,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17945,0,'','',161,10013,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17946,0,'','',161,10013,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17947,0,'','',161,10013,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17948,0,'','',161,10013,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17949,0,'','',161,10013,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17950,0,'','',161,10013,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17951,0,'','',161,10013,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17952,0,'','',161,10013,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17953,0,'','',161,10013,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17954,0,'','',161,10013,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17955,0,'','',161,10013,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17956,0,'','',161,10013,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17957,0,'','',161,10013,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17958,0,'','',161,10013,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17959,0,'','',161,10013,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17960,0,'','',161,10013,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17961,0,'','',161,10013,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17962,0,'','',161,10013,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17963,0,'','',161,10013,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17964,0,'','',161,10013,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17965,0,'','',161,10013,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17966,0,'','',161,10013,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17967,0,'','',161,10013,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17968,0,'','',161,10013,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17969,0,'','',161,10013,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17970,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17971,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17972,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17973,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17974,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17975,0,'','',161,10013,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17976,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17977,0,'','',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17978,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17979,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17980,0,'','',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17981,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17982,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17983,0,'','',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17984,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17985,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17986,0,'','',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17987,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17988,0,'','',161,10013,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17989,0,'','',161,10013,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17990,0,'','',161,10013,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17991,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17992,0,'','',161,10013,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17993,0,'','',161,10013,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17994,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17995,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17996,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17997,0,'','',161,10013,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17998,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (17999,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18000,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18001,0,'','',161,10013,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18002,0,'','',161,10013,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18003,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18004,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18005,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18006,0,'','',161,10013,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18007,0,'','',161,10013,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18008,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18009,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18010,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18011,0,'','',161,10013,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18012,0,'','',161,10013,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18013,0,'','',161,10013,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18014,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18015,0,'','',161,10013,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18016,0,'','',161,10013,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18017,0,'','',161,10013,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18018,0,'','',161,10013,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18019,0,'','',161,10013,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18020,0,'','',161,10013,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18021,0,'','',161,10013,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18022,0,'','',161,10013,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18023,0,'','',161,10013,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18024,0,'','',161,10014,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18025,0,'','',161,10014,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18026,0,'','',161,10014,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18027,0,'','',161,10014,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18028,0,'','',161,10014,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18029,0,'','',161,10014,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18030,0,'','',161,10014,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18031,0,'','',161,10014,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18032,0,'','',161,10014,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18033,0,'','',161,10014,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18034,0,'','',161,10014,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18035,0,'','',161,10014,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18036,0,'','',161,10014,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18037,0,'','',161,10014,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18038,0,'','',161,10014,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18039,0,'','',161,10014,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18040,0,'','',161,10014,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18041,0,'','',161,10014,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18042,0,'','',161,10014,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18043,0,'','',161,10014,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18044,0,'','',161,10014,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18045,0,'','',161,10014,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18046,0,'','',161,10014,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18047,0,'','',161,10014,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18048,0,'','',161,10014,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18049,0,'','',161,10014,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18050,0,'','',161,10014,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18051,0,'','',161,10014,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18052,0,'','',161,10014,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18053,0,'','',161,10014,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18054,0,'','',161,10014,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18055,0,'','',161,10014,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18056,0,'','',161,10014,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18057,0,'','',161,10014,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18058,0,'','',161,10014,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18059,0,'','',161,10014,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18060,0,'','',161,10014,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18061,0,'','',161,10014,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18062,0,'','',161,10014,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18063,0,'','',161,10014,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18064,0,'','',161,10014,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18065,0,'','',161,10014,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18066,0,'','',161,10014,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18067,0,'','',161,10014,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18068,0,'','',161,10014,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18069,0,'','',161,10014,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18070,0,'','',161,10014,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18071,0,'','',161,10014,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18072,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18073,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18074,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18075,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18076,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18077,0,'','',161,10014,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18078,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18079,0,'','',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18080,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18081,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18082,0,'','',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18083,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18084,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18085,0,'','',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18086,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18087,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18088,0,'','',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18089,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18090,0,'','',161,10014,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18091,0,'','',161,10014,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18092,0,'','',161,10014,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18093,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18094,0,'','',161,10014,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18095,0,'','',161,10014,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18096,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18097,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18098,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18099,0,'','',161,10014,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18100,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18101,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18102,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18103,0,'','',161,10014,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18104,0,'','',161,10014,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18105,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18106,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18107,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18108,0,'','',161,10014,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18109,0,'','',161,10014,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18110,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18111,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18112,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18113,0,'','',161,10014,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18114,0,'','',161,10014,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18115,0,'','',161,10014,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18116,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18117,0,'','',161,10014,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18118,0,'','',161,10014,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18119,0,'','',161,10014,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18120,0,'','',161,10014,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18121,0,'','',161,10014,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18122,0,'','',161,10014,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18123,0,'','',161,10014,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18124,0,'','',161,10014,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18125,0,'','',161,10014,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18126,0,'','',161,10015,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18127,0,'','',161,10015,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18128,0,'','',161,10015,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18129,0,'','',161,10015,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18130,0,'','',161,10015,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18131,0,'','',161,10015,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18132,0,'','',161,10015,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18133,0,'','',161,10015,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18134,0,'','',161,10015,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18135,0,'','',161,10015,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18136,0,'','',161,10015,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18137,0,'','',161,10015,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18138,0,'','',161,10015,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18139,0,'','',161,10015,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18140,0,'','',161,10015,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18141,0,'','',161,10015,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18142,0,'','',161,10015,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18143,0,'','',161,10015,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18144,0,'','',161,10015,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18145,0,'','',161,10015,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18146,0,'','',161,10015,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18147,0,'','',161,10015,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18148,0,'','',161,10015,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18149,0,'','',161,10015,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18150,0,'','',161,10015,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18151,0,'','',161,10015,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18152,0,'','',161,10015,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18153,0,'','',161,10015,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18154,0,'','',161,10015,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18155,0,'','',161,10015,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18156,0,'','',161,10015,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18157,0,'','',161,10015,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18158,0,'','',161,10015,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18159,0,'','',161,10015,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18160,0,'','',161,10015,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18161,0,'','',161,10015,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18162,0,'','',161,10015,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18163,0,'','',161,10015,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18164,0,'','',161,10015,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18165,0,'','',161,10015,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18166,0,'','',161,10015,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18167,0,'','',161,10015,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18168,0,'','',161,10015,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18169,0,'','',161,10015,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18170,0,'','',161,10015,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18171,0,'','',161,10015,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18172,0,'','',161,10015,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18173,0,'','',161,10015,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18174,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18175,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18176,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18177,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18178,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18179,0,'','',161,10015,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18180,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18181,0,'','',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18182,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18183,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18184,0,'','',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18185,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18186,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18187,0,'','',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18188,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18189,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18190,0,'','',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18191,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18192,0,'','',161,10015,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18193,0,'','',161,10015,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18194,0,'','',161,10015,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18195,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18196,0,'','',161,10015,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18197,0,'','',161,10015,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18198,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18199,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18200,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18201,0,'','',161,10015,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18202,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18203,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18204,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18205,0,'','',161,10015,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18206,0,'','',161,10015,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18207,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18208,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18209,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18210,0,'','',161,10015,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18211,0,'','',161,10015,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18212,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18213,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18214,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18215,0,'','',161,10015,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18216,0,'','',161,10015,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18217,0,'','',161,10015,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18218,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18219,0,'','',161,10015,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18220,0,'','',161,10015,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18221,0,'','',161,10015,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18222,0,'','',161,10015,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18223,0,'','',161,10015,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18224,0,'','',161,10015,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18225,0,'','',161,10015,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18226,0,'','',161,10015,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18227,0,'','',161,10015,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18228,1,'public','1.3.6.1.2.1.5.13.0',161,10016,'icmpInAddrMaskReps','icmpInAddrMaskReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18229,1,'public','1.3.6.1.2.1.5.12.0',161,10016,'icmpInAddrMasks','icmpInAddrMasks',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18230,1,'public','1.3.6.1.2.1.5.3.0',161,10016,'icmpInDestUnreachs','icmpInDestUnreachs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18231,1,'public','1.3.6.1.2.1.5.9.0',161,10016,'icmpInEchoReps','icmpInEchoReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18232,1,'public','1.3.6.1.2.1.5.8.0',161,10016,'icmpInEchos','icmpInEchos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18233,1,'public','1.3.6.1.2.1.5.2.0',161,10016,'icmpInErrors','icmpInErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18234,1,'public','1.3.6.1.2.1.5.1.0',161,10016,'icmpInMsgs','icmpInMsgs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18235,1,'public','1.3.6.1.2.1.5.5.0',161,10016,'icmpInParmProbs','icmpInParmProbs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18236,1,'public','1.3.6.1.2.1.5.7.0',161,10016,'icmpInRedirects','icmpInRedirects',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18237,1,'public','1.3.6.1.2.1.5.6.0',161,10016,'icmpInSrcQuenchs','icmpInSrcQuenchs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18238,1,'public','1.3.6.1.2.1.5.4.0',161,10016,'icmpInTimeExcds','icmpInTimeExcds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18239,1,'public','1.3.6.1.2.1.5.11.0',161,10016,'icmpInTimestampReps','icmpInTimestampReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18240,1,'public','1.3.6.1.2.1.5.10.0',161,10016,'icmpInTimestamps','icmpInTimestamps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18241,1,'public','1.3.6.1.2.1.5.26.0',161,10016,'icmpOutAddrMaskReps','icmpOutAddrMaskReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18242,1,'public','1.3.6.1.2.1.5.25.0',161,10016,'icmpOutAddrMasks','icmpOutAddrMasks',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18243,1,'public','1.3.6.1.2.1.5.16.0',161,10016,'icmpOutDesUnreachs','icmpOutDesUnreachs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18244,1,'public','1.3.6.1.2.1.5.22.0',161,10016,'icmpOutEchoReps','icmpOutEchoReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18245,1,'public','1.3.6.1.2.1.5.21.0',161,10016,'icmpOutEchos','icmpOutEchos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18246,1,'public','1.3.6.1.2.1.5.15.0',161,10016,'icmpOutErrors','icmpOutErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18247,1,'public','1.3.6.1.2.1.5.14.0',161,10016,'icmpOutMsgs','icmpOutMsgs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18248,1,'public','1.3.6.1.2.1.5.18.0',161,10016,'icmpOutParmProbs','icmpOutParmProbs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18249,1,'public','1.3.6.1.2.1.5.20.0',161,10016,'icmpOutRedirects','icmpOutRedirects',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18250,1,'public','1.3.6.1.2.1.5.19.0',161,10016,'icmpOutSrcQuenchs','icmpOutSrcQuenchs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18251,1,'public','1.3.6.1.2.1.5.17.0',161,10016,'icmpOutTimeExcds','icmpOutTimeExcds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18252,1,'public','1.3.6.1.2.1.5.24.0',161,10016,'icmpOutTimestampReps','icmpOutTimestampReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18253,1,'public','1.3.6.1.2.1.5.23.0',161,10016,'icmpOutTimestamps','icmpOutTimestamps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18254,1,'public','1.3.6.1.2.1.2.2.1.2.1',161,10016,'ifDescr1','ifDescr1',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18255,1,'public','1.3.6.1.2.1.2.2.1.2.10',161,10016,'ifDescr10','ifDescr10',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18256,1,'public','1.3.6.1.2.1.2.2.1.2.11',161,10016,'ifDescr11','ifDescr11',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18257,1,'public','1.3.6.1.2.1.2.2.1.2.12',161,10016,'ifDescr12','ifDescr12',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18258,1,'public','1.3.6.1.2.1.2.2.1.2.13',161,10016,'ifDescr13','ifDescr13',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18259,1,'public','1.3.6.1.2.1.2.2.1.2.14',161,10016,'ifDescr14','ifDescr14',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18260,1,'public','1.3.6.1.2.1.2.2.1.2.15',161,10016,'ifDescr15','ifDescr15',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18261,1,'public','1.3.6.1.2.1.2.2.1.2.16',161,10016,'ifDescr16','ifDescr16',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18262,1,'public','1.3.6.1.2.1.2.2.1.2.17',161,10016,'ifDescr17','ifDescr17',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18263,1,'public','1.3.6.1.2.1.2.2.1.2.18',161,10016,'ifDescr18','ifDescr18',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18264,1,'public','1.3.6.1.2.1.2.2.1.2.19',161,10016,'ifDescr19','ifDescr19',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18265,1,'public','1.3.6.1.2.1.2.2.1.2.2',161,10016,'ifDescr2','ifDescr2',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18266,1,'public','1.3.6.1.2.1.2.2.1.2.20',161,10016,'ifDescr20','ifDescr20',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18267,1,'public','1.3.6.1.2.1.2.2.1.2.21',161,10016,'ifDescr21','ifDescr21',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18268,1,'public','1.3.6.1.2.1.2.2.1.2.22',161,10016,'ifDescr22','ifDescr22',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18269,1,'public','1.3.6.1.2.1.2.2.1.2.23',161,10016,'ifDescr23','ifDescr23',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18270,1,'public','1.3.6.1.2.1.2.2.1.2.24',161,10016,'ifDescr24','ifDescr24',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18271,1,'public','1.3.6.1.2.1.2.2.1.2.25',161,10016,'ifDescr25','ifDescr25',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18272,1,'public','1.3.6.1.2.1.2.2.1.2.26',161,10016,'ifDescr26','ifDescr26',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18273,1,'public','1.3.6.1.2.1.2.2.1.2.27',161,10016,'ifDescr27','ifDescr27',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18274,1,'public','1.3.6.1.2.1.2.2.1.2.28',161,10016,'ifDescr28','ifDescr28',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18275,1,'public','1.3.6.1.2.1.2.2.1.2.29',161,10016,'ifDescr29','ifDescr29',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18276,1,'public','1.3.6.1.2.1.2.2.1.2.3',161,10016,'ifDescr3','ifDescr3',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18277,1,'public','1.3.6.1.2.1.2.2.1.2.30',161,10016,'ifDescr30','ifDescr30',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18278,1,'public','1.3.6.1.2.1.2.2.1.2.31',161,10016,'ifDescr31','ifDescr31',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18279,1,'public','1.3.6.1.2.1.2.2.1.2.32',161,10016,'ifDescr32','ifDescr32',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18280,1,'public','1.3.6.1.2.1.2.2.1.2.33',161,10016,'ifDescr33','ifDescr33',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18281,1,'public','1.3.6.1.2.1.2.2.1.2.34',161,10016,'ifDescr34','ifDescr34',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18282,1,'public','1.3.6.1.2.1.2.2.1.2.35',161,10016,'ifDescr35','ifDescr35',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18283,1,'public','1.3.6.1.2.1.2.2.1.2.36',161,10016,'ifDescr36','ifDescr36',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18284,1,'public','1.3.6.1.2.1.2.2.1.2.37',161,10016,'ifDescr37','ifDescr37',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18285,1,'public','1.3.6.1.2.1.2.2.1.2.38',161,10016,'ifDescr38','ifDescr38',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18286,1,'public','1.3.6.1.2.1.2.2.1.2.39',161,10016,'ifDescr39','ifDescr39',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18287,1,'public','1.3.6.1.2.1.2.2.1.2.4',161,10016,'ifDescr4','ifDescr4',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18288,1,'public','1.3.6.1.2.1.2.2.1.2.40',161,10016,'ifDescr40','ifDescr40',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18289,1,'public','1.3.6.1.2.1.2.2.1.2.41',161,10016,'ifDescr41','ifDescr41',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18290,1,'public','1.3.6.1.2.1.2.2.1.2.42',161,10016,'ifDescr42','ifDescr42',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18291,1,'public','1.3.6.1.2.1.2.2.1.2.43',161,10016,'ifDescr43','ifDescr43',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18292,1,'public','1.3.6.1.2.1.2.2.1.2.44',161,10016,'ifDescr44','ifDescr44',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18293,1,'public','1.3.6.1.2.1.2.2.1.2.45',161,10016,'ifDescr45','ifDescr45',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18294,1,'public','1.3.6.1.2.1.2.2.1.2.46',161,10016,'ifDescr46','ifDescr46',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18295,1,'public','1.3.6.1.2.1.2.2.1.2.47',161,10016,'ifDescr47','ifDescr47',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18296,1,'public','1.3.6.1.2.1.2.2.1.2.48',161,10016,'ifDescr48','ifDescr48',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18297,1,'public','1.3.6.1.2.1.2.2.1.2.49',161,10016,'ifDescr49','ifDescr49',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18298,1,'public','1.3.6.1.2.1.2.2.1.2.5',161,10016,'ifDescr5','ifDescr5',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18299,1,'public','1.3.6.1.2.1.2.2.1.2.50',161,10016,'ifDescr50','ifDescr50',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18300,1,'public','1.3.6.1.2.1.2.2.1.2.51',161,10016,'ifDescr51','ifDescr51',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18301,1,'public','1.3.6.1.2.1.2.2.1.2.6',161,10016,'ifDescr6','ifDescr6',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18302,1,'public','1.3.6.1.2.1.2.2.1.2.7',161,10016,'ifDescr7','ifDescr7',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18303,1,'public','1.3.6.1.2.1.2.2.1.2.8',161,10016,'ifDescr8','ifDescr8',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18304,1,'public','1.3.6.1.2.1.2.2.1.2.9',161,10016,'ifDescr9','ifDescr9',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18305,1,'public','1.3.6.1.2.1.2.2.1.10.1',161,10016,'ifInOctets1','ifInOctets1',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18306,1,'public','1.3.6.1.2.1.2.2.1.10.10',161,10016,'ifInOctets10','ifInOctets10',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18307,1,'public','1.3.6.1.2.1.2.2.1.10.11',161,10016,'ifInOctets11','ifInOctets11',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18308,1,'public','1.3.6.1.2.1.2.2.1.10.12',161,10016,'ifInOctets12','ifInOctets12',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18309,1,'public','1.3.6.1.2.1.2.2.1.10.13',161,10016,'ifInOctets13','ifInOctets13',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18310,1,'public','1.3.6.1.2.1.2.2.1.10.14',161,10016,'ifInOctets14','ifInOctets14',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18311,1,'public','1.3.6.1.2.1.2.2.1.10.15',161,10016,'ifInOctets15','ifInOctets15',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18312,1,'public','1.3.6.1.2.1.2.2.1.10.16',161,10016,'ifInOctets16','ifInOctets16',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18313,1,'public','1.3.6.1.2.1.2.2.1.10.17',161,10016,'ifInOctets17','ifInOctets17',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18314,1,'public','1.3.6.1.2.1.2.2.1.10.18',161,10016,'ifInOctets18','ifInOctets18',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18315,1,'public','1.3.6.1.2.1.2.2.1.10.19',161,10016,'ifInOctets19','ifInOctets19',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18316,1,'public','1.3.6.1.2.1.2.2.1.10.2',161,10016,'ifInOctets2','ifInOctets2',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18317,1,'public','1.3.6.1.2.1.2.2.1.10.20',161,10016,'ifInOctets20','ifInOctets20',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18318,1,'public','1.3.6.1.2.1.2.2.1.10.21',161,10016,'ifInOctets21','ifInOctets21',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18319,1,'public','1.3.6.1.2.1.2.2.1.10.22',161,10016,'ifInOctets22','ifInOctets22',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18320,1,'public','1.3.6.1.2.1.2.2.1.10.23',161,10016,'ifInOctets23','ifInOctets23',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18321,1,'public','1.3.6.1.2.1.2.2.1.10.24',161,10016,'ifInOctets24','ifInOctets24',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18322,1,'public','1.3.6.1.2.1.2.2.1.10.25',161,10016,'ifInOctets25','ifInOctets25',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18323,1,'public','1.3.6.1.2.1.2.2.1.10.26',161,10016,'ifInOctets26','ifInOctets26',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18324,1,'public','1.3.6.1.2.1.2.2.1.10.27',161,10016,'ifInOctets27','ifInOctets27',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18325,1,'public','1.3.6.1.2.1.2.2.1.10.28',161,10016,'ifInOctets28','ifInOctets28',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18326,1,'public','1.3.6.1.2.1.2.2.1.10.29',161,10016,'ifInOctets29','ifInOctets29',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18327,1,'public','1.3.6.1.2.1.2.2.1.10.3',161,10016,'ifInOctets3','ifInOctets3',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18328,1,'public','1.3.6.1.2.1.2.2.1.10.30',161,10016,'ifInOctets30','ifInOctets30',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18329,1,'public','1.3.6.1.2.1.2.2.1.10.31',161,10016,'ifInOctets31','ifInOctets31',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18330,1,'public','1.3.6.1.2.1.2.2.1.10.32',161,10016,'ifInOctets32','ifInOctets32',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18331,1,'public','1.3.6.1.2.1.2.2.1.10.33',161,10016,'ifInOctets33','ifInOctets33',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18332,1,'public','1.3.6.1.2.1.2.2.1.10.34',161,10016,'ifInOctets34','ifInOctets34',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18333,1,'public','1.3.6.1.2.1.2.2.1.10.35',161,10016,'ifInOctets35','ifInOctets35',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18334,1,'public','1.3.6.1.2.1.2.2.1.10.36',161,10016,'ifInOctets36','ifInOctets36',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18335,1,'public','1.3.6.1.2.1.2.2.1.10.37',161,10016,'ifInOctets37','ifInOctets37',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18336,1,'public','1.3.6.1.2.1.2.2.1.10.38',161,10016,'ifInOctets38','ifInOctets38',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18337,1,'public','1.3.6.1.2.1.2.2.1.10.39',161,10016,'ifInOctets39','ifInOctets39',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18338,1,'public','1.3.6.1.2.1.2.2.1.10.4',161,10016,'ifInOctets4','ifInOctets4',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18339,1,'public','1.3.6.1.2.1.2.2.1.10.40',161,10016,'ifInOctets40','ifInOctets40',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18340,1,'public','1.3.6.1.2.1.2.2.1.10.41',161,10016,'ifInOctets41','ifInOctets41',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18341,1,'public','1.3.6.1.2.1.2.2.1.10.42',161,10016,'ifInOctets42','ifInOctets42',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18342,1,'public','1.3.6.1.2.1.2.2.1.10.43',161,10016,'ifInOctets43','ifInOctets43',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18343,1,'public','1.3.6.1.2.1.2.2.1.10.44',161,10016,'ifInOctets44','ifInOctets44',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18344,1,'public','1.3.6.1.2.1.2.2.1.10.45',161,10016,'ifInOctets45','ifInOctets45',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18345,1,'public','1.3.6.1.2.1.2.2.1.10.46',161,10016,'ifInOctets46','ifInOctets46',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18346,1,'public','1.3.6.1.2.1.2.2.1.10.47',161,10016,'ifInOctets47','ifInOctets47',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18347,1,'public','1.3.6.1.2.1.2.2.1.10.48',161,10016,'ifInOctets48','ifInOctets48',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18348,1,'public','1.3.6.1.2.1.2.2.1.10.49',161,10016,'ifInOctets49','ifInOctets49',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18349,1,'public','1.3.6.1.2.1.2.2.1.10.5',161,10016,'ifInOctets5','ifInOctets5',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18350,1,'public','1.3.6.1.2.1.2.2.1.10.50',161,10016,'ifInOctets50','ifInOctets50',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18351,1,'public','1.3.6.1.2.1.2.2.1.10.51',161,10016,'ifInOctets51','ifInOctets51',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18352,1,'public','1.3.6.1.2.1.2.2.1.10.6',161,10016,'ifInOctets6','ifInOctets6',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18353,1,'public','1.3.6.1.2.1.2.2.1.10.7',161,10016,'ifInOctets7','ifInOctets7',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18354,1,'public','1.3.6.1.2.1.2.2.1.10.8',161,10016,'ifInOctets8','ifInOctets8',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18355,1,'public','1.3.6.1.2.1.2.2.1.10.9',161,10016,'ifInOctets9','ifInOctets9',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18356,1,'public','1.3.6.1.2.1.2.2.1.16.1',161,10016,'ifOutOctets1','ifOutOctets1',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18357,1,'public','1.3.6.1.2.1.2.2.1.16.10',161,10016,'ifOutOctets10','ifOutOctets10',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18358,1,'public','1.3.6.1.2.1.2.2.1.16.11',161,10016,'ifOutOctets11','ifOutOctets11',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18359,1,'public','1.3.6.1.2.1.2.2.1.16.12',161,10016,'ifOutOctets12','ifOutOctets12',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18360,1,'public','1.3.6.1.2.1.2.2.1.16.13',161,10016,'ifOutOctets13','ifOutOctets13',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18361,1,'public','1.3.6.1.2.1.2.2.1.16.14',161,10016,'ifOutOctets14','ifOutOctets14',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18362,1,'public','1.3.6.1.2.1.2.2.1.16.15',161,10016,'ifOutOctets15','ifOutOctets15',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18363,1,'public','1.3.6.1.2.1.2.2.1.16.16',161,10016,'ifOutOctets16','ifOutOctets16',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18364,1,'public','1.3.6.1.2.1.2.2.1.16.17',161,10016,'ifOutOctets17','ifOutOctets17',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18365,1,'public','1.3.6.1.2.1.2.2.1.16.18',161,10016,'ifOutOctets18','ifOutOctets18',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18366,1,'public','1.3.6.1.2.1.2.2.1.16.19',161,10016,'ifOutOctets19','ifOutOctets19',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18367,1,'public','1.3.6.1.2.1.2.2.1.16.2',161,10016,'ifOutOctets2','ifOutOctets2',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18368,1,'public','1.3.6.1.2.1.2.2.1.16.20',161,10016,'ifOutOctets20','ifOutOctets20',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18369,1,'public','1.3.6.1.2.1.2.2.1.16.21',161,10016,'ifOutOctets21','ifOutOctets21',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18370,1,'public','1.3.6.1.2.1.2.2.1.16.22',161,10016,'ifOutOctets22','ifOutOctets22',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18371,1,'public','1.3.6.1.2.1.2.2.1.16.23',161,10016,'ifOutOctets23','ifOutOctets23',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18372,1,'public','1.3.6.1.2.1.2.2.1.16.24',161,10016,'ifOutOctets24','ifOutOctets24',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18373,1,'public','1.3.6.1.2.1.2.2.1.16.25',161,10016,'ifOutOctets25','ifOutOctets25',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18374,1,'public','1.3.6.1.2.1.2.2.1.16.26',161,10016,'ifOutOctets26','ifOutOctets26',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18375,1,'public','1.3.6.1.2.1.2.2.1.16.27',161,10016,'ifOutOctets27','ifOutOctets27',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18376,1,'public','1.3.6.1.2.1.2.2.1.16.28',161,10016,'ifOutOctets28','ifOutOctets28',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18377,1,'public','1.3.6.1.2.1.2.2.1.16.29',161,10016,'ifOutOctets29','ifOutOctets29',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18378,1,'public','1.3.6.1.2.1.2.2.1.16.3',161,10016,'ifOutOctets3','ifOutOctets3',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18379,1,'public','1.3.6.1.2.1.2.2.1.16.30',161,10016,'ifOutOctets30','ifOutOctets30',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18380,1,'public','1.3.6.1.2.1.2.2.1.16.31',161,10016,'ifOutOctets31','ifOutOctets31',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18381,1,'public','1.3.6.1.2.1.2.2.1.16.32',161,10016,'ifOutOctets32','ifOutOctets32',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18382,1,'public','1.3.6.1.2.1.2.2.1.16.33',161,10016,'ifOutOctets33','ifOutOctets33',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18383,1,'public','1.3.6.1.2.1.2.2.1.16.34',161,10016,'ifOutOctets34','ifOutOctets34',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18384,1,'public','1.3.6.1.2.1.2.2.1.16.35',161,10016,'ifOutOctets35','ifOutOctets35',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18385,1,'public','1.3.6.1.2.1.2.2.1.16.36',161,10016,'ifOutOctets36','ifOutOctets36',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18386,1,'public','1.3.6.1.2.1.2.2.1.16.37',161,10016,'ifOutOctets37','ifOutOctets37',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18387,1,'public','1.3.6.1.2.1.2.2.1.16.38',161,10016,'ifOutOctets38','ifOutOctets38',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18388,1,'public','1.3.6.1.2.1.2.2.1.16.39',161,10016,'ifOutOctets39','ifOutOctets39',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18389,1,'public','1.3.6.1.2.1.2.2.1.16.4',161,10016,'ifOutOctets4','ifOutOctets4',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18390,1,'public','1.3.6.1.2.1.2.2.1.16.40',161,10016,'ifOutOctets40','ifOutOctets40',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18391,1,'public','1.3.6.1.2.1.2.2.1.16.41',161,10016,'ifOutOctets41','ifOutOctets41',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18392,1,'public','1.3.6.1.2.1.2.2.1.16.42',161,10016,'ifOutOctets42','ifOutOctets42',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18393,1,'public','1.3.6.1.2.1.2.2.1.16.43',161,10016,'ifOutOctets43','ifOutOctets43',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18394,1,'public','1.3.6.1.2.1.2.2.1.16.44',161,10016,'ifOutOctets44','ifOutOctets44',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18395,1,'public','1.3.6.1.2.1.2.2.1.16.45',161,10016,'ifOutOctets45','ifOutOctets45',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18396,1,'public','1.3.6.1.2.1.2.2.1.16.46',161,10016,'ifOutOctets46','ifOutOctets46',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18397,1,'public','1.3.6.1.2.1.2.2.1.16.47',161,10016,'ifOutOctets47','ifOutOctets47',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18398,1,'public','1.3.6.1.2.1.2.2.1.16.48',161,10016,'ifOutOctets48','ifOutOctets48',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18399,1,'public','1.3.6.1.2.1.2.2.1.16.49',161,10016,'ifOutOctets49','ifOutOctets49',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18400,1,'public','1.3.6.1.2.1.2.2.1.16.5',161,10016,'ifOutOctets5','ifOutOctets5',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18401,1,'public','1.3.6.1.2.1.2.2.1.16.50',161,10016,'ifOutOctets50','ifOutOctets50',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18402,1,'public','1.3.6.1.2.1.2.2.1.16.51',161,10016,'ifOutOctets51','ifOutOctets51',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18403,1,'public','1.3.6.1.2.1.2.2.1.16.6',161,10016,'ifOutOctets6','ifOutOctets6',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18404,1,'public','1.3.6.1.2.1.2.2.1.16.7',161,10016,'ifOutOctets7','ifOutOctets7',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18405,1,'public','1.3.6.1.2.1.2.2.1.16.8',161,10016,'ifOutOctets8','ifOutOctets8',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18406,1,'public','1.3.6.1.2.1.2.2.1.16.9',161,10016,'ifOutOctets9','ifOutOctets9',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18407,1,'public','1.3.6.1.2.1.4.2.0',161,10016,'ipDefaultTTL','ipDefaultTTL',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18408,1,'public','1.3.6.1.2.1.4.1.0',161,10016,'ipForwarding','ipForwarding',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18409,1,'public','1.3.6.1.2.1.4.19.0',161,10016,'ipFragCreates','ipFragCreates',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18410,1,'public','1.3.6.1.2.1.4.18.0',161,10016,'ipFragFails','ipFragFails',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18411,1,'public','1.3.6.1.2.1.4.17.0',161,10016,'ipFragOKs','ipFragOKs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18412,1,'public','1.3.6.1.2.1.4.5.0',161,10016,'ipInAddrErrors','ipInAddrErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18413,1,'public','1.3.6.1.2.1.4.9.0',161,10016,'ipInDelivers','ipInDelivers',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18414,1,'public','1.3.6.1.2.1.4.8.0',161,10016,'ipInDiscards','ipInDiscards',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18415,1,'public','1.3.6.1.2.1.4.6.0',161,10016,'ipInForwDatagrams','ipInForwDatagrams',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18416,1,'public','1.3.6.1.2.1.4.4.0',161,10016,'ipInHdrErrors','ipInHdrErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18417,1,'public','1.3.6.1.2.1.4.3.0',161,10016,'ipInReceives','ipInReceives',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18418,1,'public','1.3.6.1.2.1.4.7.0',161,10016,'ipInUnknownProtos','ipInUnknownProtos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18419,1,'public','1.3.6.1.2.1.4.11.0',161,10016,'ipOutDiscards','ipOutDiscards',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18420,1,'public','1.3.6.1.2.1.4.12.0',161,10016,'ipOutNoRoutes','ipOutNoRoutes',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18421,1,'public','1.3.6.1.2.1.4.10.0',161,10016,'ipOutRequests','ipOutRequests',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18422,1,'public','1.3.6.1.2.1.4.16.0',161,10016,'ipReasmFails','ipReasmFails',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18423,1,'public','1.3.6.1.2.1.4.15.0',161,10016,'ipReasmOKs','ipReasmOKs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18424,1,'public','1.3.6.1.2.1.4.14.0',161,10016,'ipReasmReqds','ipReasmReqds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18425,1,'public','1.3.6.1.2.1.4.13.0',161,10016,'ipReasmTimeout','ipReasmTimeout',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18426,1,'public','1.3.6.1.2.1.4.23.0',161,10016,'ipRoutingDiscards','ipRoutingDiscards',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18427,1,'public','1.3.6.1.4.1.9.2.1.56.0',161,10016,'lcpuPercentBusy','lcpuPercentBusy',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18428,1,'public','1.3.6.1.4.1.9.2.1.108.0',161,10016,'lenvFirmVersion','lenvFirmVersion',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18429,1,'public','1.3.6.1.4.1.9.2.1.112.0',161,10016,'lenvSerialNumber','lenvSerialNumber',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18430,1,'public','1.3.6.1.4.1.9.2.1.46.0',161,10016,'lmemBufferFail','lmemBufferFail',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18431,1,'public','1.3.6.1.4.1.9.2.1.47.0',161,10016,'lmemBufferNoMem','lmemBufferNoMem',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18432,1,'public','1.3.6.1.4.1.9.2.1.8.0',161,10016,'lmemFreeMem','lmemFreeMem',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18433,1,'public','1.3.6.1.4.1.9.2.1.1.0',161,10016,'lmemRomID','lmemRomID',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18434,1,'public','1.3.6.1.2.1.1.5.0',161,10016,'sysName','sysName',60,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18435,0,'','',161,10017,'Ping to the server (TCP)','agent.ping',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10020,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18436,0,'','',161,10017,'Version of zabbix_agent(d) running','agent.version',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',10059,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18437,0,'','',161,10017,'Size of $1','vfs.file.size[/var/log/syslog]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10015,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18438,0,'','',161,10017,'Maximum number of opened files','kernel.maxfiles',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10056,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18439,0,'','',161,10017,'Maximum number of processes','kernel.maxproc',1800,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10055,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18440,0,'','',161,10017,'Incoming traffic on interface $1','net.if.in[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10075,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18441,0,'','',161,10017,'Incoming traffic on interface $1','net.if.in[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10078,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18442,0,'','',161,10017,'Incoming traffic on interface $1','net.if.in[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10072,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18443,0,'','',161,10017,'Outgoing traffic on interface $1','net.if.out[eth0,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10084,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18444,0,'','',161,10017,'Outgoing traffic on interface $1','net.if.out[eth1,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10087,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18445,0,'','',161,10017,'Outgoing traffic on interface $1','net.if.out[lo,bytes]',5,7,365,NULL,NULL,NULL,0,0,'','Bps',0,1,NULL,'',0,'','','0','',0,'',10081,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18446,0,'','',161,10017,'FTP server is running','net.tcp.service[ftp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10032,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18447,0,'','',161,10017,'WEB (HTTP) server is running','net.tcp.service[http]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10060,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18448,0,'','',161,10017,'IMAP server is running','net.tcp.service[imap]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10037,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18449,0,'','',161,10017,'News (NNTP) server is running','net.tcp.service[nntp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10046,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18450,0,'','',161,10017,'POP3 server is running','net.tcp.service[pop]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10036,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18451,0,'','',161,10017,'Email (SMTP) server is running','net.tcp.service[smtp]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10031,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18452,0,'','',161,10017,'SSH server is running','net.tcp.service[ssh]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10033,1,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18453,0,'','',161,10017,'Number of running processes','proc.num[,,run]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10013,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18454,0,'','',161,10017,'Number of running processes apache','proc.num[httpd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10048,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18455,0,'','',161,10017,'Number of running processes inetd','proc.num[inetd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10047,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18456,0,'','',161,10017,'Number of running processes mysqld','proc.num[mysqld]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10049,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18457,0,'','',161,10017,'Number of running processes sshd','proc.num[sshd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10051,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18458,0,'','',161,10017,'Number of running processes syslogd','proc.num[syslogd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10050,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18459,0,'','',161,10017,'Number of running processes $1','proc.num[zabbix_agentd]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10052,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18460,0,'','',161,10017,'Number of running processes $1','proc.num[zabbix_server]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10053,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18461,0,'','',161,10017,'Number of processes','proc.num[]',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10009,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18462,0,'','',161,10017,'Temperature of mainboard','sensor[temp1]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',10418,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18463,0,'','',161,10017,'Temperature of CPU 1of2','sensor[temp2]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',10419,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18464,0,'','',161,10017,'Temperature of CPU 2of2','sensor[temp3]',30,7,365,NULL,NULL,NULL,0,0,'','C',0,0,NULL,'',0,'','','0','',0,'',10420,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18465,0,'','',161,10017,'Host status','status',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10061,2,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18466,0,'','',161,10017,'Host boot time','system.boottime',300,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',17318,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18467,0,'','',161,10017,'Processor load15','system.cpu.load[,avg15]',20,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',10012,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18468,0,'','',161,10017,'Processor load','system.cpu.load[,avg1]',5,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',10010,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18469,0,'','',161,10017,'Processor load5','system.cpu.load[,avg5]',10,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0','',0,'',10011,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18470,0,'','',161,10017,'CPU $2 time ($3)','system.cpu.util[,idle,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17354,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18471,0,'','',161,10017,'CPU $2 time ($3)','system.cpu.util[,nice,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17358,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18472,0,'','',161,10017,'CPU $2 time ($3)','system.cpu.util[,system,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17360,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18473,0,'','',161,10017,'CPU user time (avg1)','system.cpu.util[,user,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17356,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18474,0,'','',161,10017,'CPU $2 time ($3)','system.cpu.util[,iowait,avg1]',10,90,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',17362,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18475,0,'','',161,10017,'Host name','system.hostname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',10057,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18476,0,'','',161,10017,'Host local time','system.localtime',30,90,365,NULL,NULL,NULL,0,3,'','unixtime',0,0,NULL,'',0,'','','1','',0,'',17352,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18477,0,'','',161,10017,'Free swap space','system.swap.size[,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10014,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18478,0,'','',161,10017,'Free swap space in %','system.swap.size[,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17350,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18479,0,'','',161,10017,'Total swap space','system.swap.size[,total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10030,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18480,0,'','',161,10017,'Host information','system.uname',1800,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','0','',0,'',10058,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18481,0,'','',161,10017,'Host uptime (in sec)','system.uptime',300,7,365,NULL,NULL,NULL,0,3,'','uptime',0,0,NULL,'',0,'','','0','',0,'',10025,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18482,0,'','',161,10017,'Number of users connected','system.users.num',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10016,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18483,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/etc/inetd.conf]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10017,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18484,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/etc/passwd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10019,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18485,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/etc/services]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10040,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18486,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/usr/bin/ssh]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10039,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18487,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/usr/sbin/sshd]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10038,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18488,0,'','',161,10017,'Checksum of $1','vfs.file.cksum[/vmlinuz]',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10018,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18489,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10005,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18490,0,'','',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17330,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18491,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10062,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18492,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/home,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10022,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18493,0,'','',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17332,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18494,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10066,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18495,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/opt,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10006,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18496,0,'','',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17334,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18497,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10063,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18498,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/tmp,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10007,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18499,0,'','',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17336,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18500,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10064,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18501,0,'','',161,10017,'Free number of inodes on $1','vfs.fs.inode[/usr,free]',60,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10008,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18502,0,'','',161,10017,'Free number of inodes on $1 in %','vfs.fs.inode[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17338,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18503,0,'','',161,10017,'Total number of inodes on $1','vfs.fs.inode[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','0','',0,'',10065,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18504,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10002,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18505,0,'','',161,10017,'Free disk space on $1 in %','vfs.fs.size[/,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17322,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18506,0,'','',161,10017,'Used disk space on $1 in %','vfs.fs.size[/,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17340,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18507,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10067,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18508,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10412,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18509,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/home,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10021,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18510,0,'','',161,10017,'Free disk space on $1 in %','vfs.fs.size[/home,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17324,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18511,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/home,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10071,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18512,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/home,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10417,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18513,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/opt,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10024,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18514,0,'','',161,10017,'Free disk space on $1 in %','vfs.fs.size[/opt,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17326,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18515,0,'','',161,10017,'Used disk space on $1 in %','vfs.fs.size[/opt,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17342,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18516,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/opt,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10068,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18517,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/opt,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10413,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18518,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/tmp,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10003,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18519,0,'','',161,10017,'Free disk space on $1 in %','vfs.fs.size[/tmp,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17328,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18520,0,'','',161,10017,'Used disk space on $1 in %','vfs.fs.size[/tmp,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17344,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18521,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/tmp,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10069,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18522,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/tmp,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10415,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18523,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/usr,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10004,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18524,0,'','',161,10017,'Free disk space on $1 in %','vfs.fs.size[/usr,pfree]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17320,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18525,0,'','',161,10017,'Used disk space on $1 in %','vfs.fs.size[/usr,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17346,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18526,0,'','',161,10017,'Total disk space on $1','vfs.fs.size[/usr,total]',3600,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10070,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18527,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/usr,used]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10416,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18528,0,'','',161,10017,'Free disk space on $1','vfs.fs.size[/var,free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','','',0,'',10023,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18529,0,'','',161,10017,'Free disk space on $1 in %','vfs.fs.size[/var,pfree]',30,90,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17373,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18530,0,'','',161,10017,'Used disk space on $1 in %','vfs.fs.size[/var,pused]',30,7,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',17348,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18531,0,'','',161,10017,'Used disk space on $1','vfs.fs.size[/var,used]',30,7,365,NULL,NULL,NULL,0,0,'','B',0,0,NULL,'',0,'','','','',0,'',10414,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18532,0,'','',161,10017,'Buffers memory','vm.memory.size[buffers]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10028,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18533,0,'','',161,10017,'Cached memory','vm.memory.size[cached]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10029,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18534,0,'','',161,10017,'Free memory','vm.memory.size[free]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10001,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18535,0,'','',161,10017,'Shared memory','vm.memory.size[shared]',30,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10027,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18536,0,'','',161,10017,'Total memory','vm.memory.size[total]',1800,7,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','0','',0,'',10026,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18537,4,'public','1.3.6.1.2.1.1.4.0',161,10018,'Contact Name','pix.contact.name',60,365,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18538,4,'public','1.3.6.1.2.1.1.1.0',161,10018,'PIX Firmware Level','pix.firmware.level',60,365,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18539,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10018,'PIX Interface 2 Description','pix.intf2.description',60,365,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18540,4,'public','1.3.6.1.2.1.31.1.1.1.1.2',161,10018,'PIX Interface 2 Name','pix.intf2.name',60,365,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18541,4,'public','1.3.6.1.2.1.2.2.1.7.2',161,10018,'PIX Interface 2 Admin Status','pix.intf2.status.admin',60,365,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18542,4,'public','1.3.6.1.2.1.2.2.1.8.2',161,10018,'PIX Interface 2 Op Status','pix.intf2.status.operational',60,365,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18543,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10018,'PIX Interface 2 Egress Traffic','pix.intf2.traffic.egress',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18544,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10018,'PIX Interface 2 Egress Traffic (Bps)','pix.intf2.traffic.egress.bps',60,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18545,4,'public','1.3.6.1.2.1.2.2.1.19.2',161,10018,'PIX Interface 2 Egress Discards','pix.intf2.traffic.egress.discards',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18546,4,'public','1.3.6.1.2.1.2.2.1.20.2',161,10018,'PIX Interface 2 Egress Errors','pix.intf2.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18547,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10018,'PIX Interface 2 Egress Traffic (pkts)','pix.intf2.traffic.egress.packets',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18548,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10018,'PIX Interface 2 Egress Traffic (pps)','pix.intf2.traffic.egress.pps',60,365,365,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18549,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10018,'PIX Interface 2 Ingress Traffic','pix.intf2.traffic.ingress',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18550,4,'public','1.3.6.1.2.1.2.2.1.13.2',161,10018,'PIX Interface 2 Ingress Discards','pix.intf2.traffic.ingress.discards',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18551,4,'public','1.3.6.1.2.1.2.2.1.14.2',161,10018,'PIX Interface 2 Ingress Errors','pix.intf2.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18552,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10018,'PIX Interface 2 Ingress Traffic (Bps)','pix.intf2.traffic.ingress.octets',60,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18553,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10018,'PIX Interface 2 Ingress Traffic (pkts)','pix.intf2.traffic.ingress.packets',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18554,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10018,'PIX Interface 2 Ingress Traffic (pps)','pix.intf2.traffic.ingress.pps',60,365,365,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18555,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10018,'PIX Interface 3 Description','pix.intf3.description',60,365,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18556,4,'public','1.3.6.1.2.1.2.2.1.7.3',161,10018,'PIX Interface 3 Admin Status','pix.intf3.status.admin',60,365,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18557,4,'public','1.3.6.1.2.1.2.2.1.8.3',161,10018,'PIX Interface 3 Op Status','pix.intf3.status.operational',60,365,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18558,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10018,'PIX Interface 3 Egress Traffic','pix.intf3.traffic.egress',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18559,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10018,'PIX Interface 3 Egress Traffic (Bps)','pix.intf3.traffic.egress.bps',60,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18560,4,'public','1.3.6.1.2.1.2.2.1.19.3',161,10018,'PIX Interface 3 Egress Dicards','pix.intf3.traffic.egress.discards',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18561,4,'public','1.3.6.1.2.1.2.2.1.20.2',161,10018,'PIX Interface 3 Egress Errors','pix.intf3.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18562,4,'public','1.3.6.1.2.1.2.2.1.17.3',161,10018,'PIX Interface 3 Egress Traffic (pkts)','pix.intf3.traffic.egress.packets',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18563,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10018,'PIX Interface 3 Egress Traffic (pps)','pix.intf3.traffic.egress.pps',60,365,365,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18564,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10018,'PIX Interface 3 Ingress Traffic','pix.intf3.traffic.ingress',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18565,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10018,'PIX Interface 3 Ingress Traffic (Bps)','pix.intf3.traffic.ingress.bps',60,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18566,4,'public','1.3.6.1.2.1.2.2.1.13.2',161,10018,'PIX Interface 3 Ingress Drops','pix.intf3.traffic.ingress.drops',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18567,4,'public','1.3.6.1.2.1.2.2.1.14.2',161,10018,'PIX Interface 3 Ingress Errors','pix.intf3.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18568,4,'public','1.3.6.1.2.1.2.2.1.11.3',161,10018,'PIX Interface 3 Ingress Traffic (pkts)','pix.intf3.traffic.ingress.packets',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18569,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10018,'PIX Interface 3 Ingress Traffic (pps)','pix.intf3.traffic.ingress.pps',60,365,365,NULL,NULL,NULL,0,3,'','pps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18570,4,'public','1.3.6.1.2.1.47.1.1.1.1.11.1',161,10018,'Serial Number','pix.system.serial',60,365,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18571,4,'public','SNMPv2-MIB::snmpInPkts.0',161,10018,'SNMP Packets Input','pix.system.snmp.packets.input',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18572,4,'public','1.3.6.1.2.1.31.1.1.1.18.1',161,10019,'Interface 01 Description','dell.6248.intf1.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18573,4,'public','1.3.6.1.2.1.2.2.1.5.1',161,10019,'Interface 01 Speed','dell.6248.intf1.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18574,4,'public','1.3.6.1.2.1.2.2.1.7.1',161,10019,'Interface 01 Admin Status','dell.6248.intf1.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18575,4,'public','1.3.6.1.2.1.2.2.1.8.1',161,10019,'Interface 01 Op Status','dell.6248.intf1.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18576,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10019,'Interface 01 Egress Traffic (Bps)','dell.6248.intf1.traffic.egress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18577,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10019,'Interface 01 Egress Traffic (bytes)','dell.6248.intf1.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18578,4,'public','1.3.6.1.2.1.2.2.1.19.1',161,10019,'Interface 01 Egress Discards','dell.6248.intf1.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18579,4,'public','1.3.6.1.2.1.2.2.1.20.1',161,10019,'Interface 01 Egress Errors','dell.6248.intf1.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18580,4,'public','1.3.6.1.2.1.2.2.1.18.1',161,10019,'Interface 01 Egress Traffic (Non-Unicast)','dell.6248.intf1.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18581,4,'public','1.3.6.1.2.1.2.2.1.17.1',161,10019,'Interface 01 Egress Traffic (Unicast)','dell.6248.intf1.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18582,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10019,'Interface 01 Ingress Traffic (Bps)','dell.6248.intf1.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18583,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10019,'Interface 01 Ingress Traffic (bytes)','dell.6248.intf1.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18584,4,'public','1.3.6.1.2.1.2.2.1.13.1',161,10019,'Interface 01 Ingress Discards','dell.6248.intf1.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18585,4,'public','1.3.6.1.2.1.2.2.1.14.1',161,10019,'Interface 01 Ingress Errors','dell.6248.intf1.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18586,4,'public','1.3.6.1.2.1.2.2.1.12.1',161,10019,'Interface 01 Ingress Traffic (Non-Unicast)','dell.6248.intf1.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18587,4,'public','1.3.6.1.2.1.2.2.1.11.1',161,10019,'Interface 01 Ingress Traffic (Unicast)','dell.6248.intf1.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18588,4,'public','1.3.6.1.2.1.31.1.1.1.18.10',161,10019,'Interface 10 Description','dell.6248.intf10.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18589,4,'public','1.3.6.1.2.1.2.2.1.5.10',161,10019,'Interface 10 Speed','dell.6248.intf10.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18590,4,'public','1.3.6.1.2.1.2.2.1.7.10',161,10019,'Interface 10 Admin Status','dell.6248.intf10.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18591,4,'public','1.3.6.1.2.1.2.2.1.8.10',161,10019,'Interface 10 Op Status','dell.6248.intf10.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18592,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10019,'Interface 10 Egress Traffic (Bps)','dell.6248.intf10.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18593,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10019,'Interface 10 Egress Traffic (bytes)','dell.6248.intf10.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18594,4,'public','1.3.6.1.2.1.2.2.1.19.10',161,10019,'Interface 10 Egress Discards','dell.6248.intf10.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18595,4,'public','1.3.6.1.2.1.2.2.1.20.10',161,10019,'Interface 10 Egress Errors','dell.6248.intf10.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18596,4,'public','1.3.6.1.2.1.2.2.1.18.10',161,10019,'Interface 10 Egress Traffic (Non-Unicast)','dell.6248.intf10.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18597,4,'public','1.3.6.1.2.1.2.2.1.17.10',161,10019,'Interface 10 Egress Traffic (Unicast)','dell.6248.intf10.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18598,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10019,'Interface 10 Ingress Traffic (Bps)','dell.6248.intf10.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18599,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10019,'Interface 10 Ingress Traffic (bytes)','dell.6248.intf10.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18600,4,'public','1.3.6.1.2.1.2.2.1.13.10',161,10019,'Interface 10 Ingress Discards','dell.6248.intf10.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18601,4,'public','1.3.6.1.2.1.2.2.1.14.10',161,10019,'Interface 10 Ingress Errors','dell.6248.intf10.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18602,4,'public','1.3.6.1.2.1.2.2.1.12.10',161,10019,'Interface 10 Ingress Traffic (Non-Unicast)','dell.6248.intf10.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18603,4,'public','1.3.6.1.2.1.2.2.1.11.10',161,10019,'Interface 10 Ingress Traffic (Unicast)','dell.6248.intf10.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18604,4,'public','1.3.6.1.2.1.31.1.1.1.18.11',161,10019,'Interface 11 Description','dell.6248.intf11.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18605,4,'public','1.3.6.1.2.1.2.2.1.5.11',161,10019,'Interface 11 Speed','dell.6248.intf11.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18606,4,'public','1.3.6.1.2.1.2.2.1.7.11',161,10019,'Interface 11 Admin Status','dell.6248.intf11.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18607,4,'public','1.3.6.1.2.1.2.2.1.8.11',161,10019,'Interface 11 Op Status','dell.6248.intf11.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18608,4,'public','1.3.6.1.2.1.2.2.1.16.11',161,10019,'Interface 11 Egress Traffic (Bps)','dell.6248.intf11.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18609,4,'public','1.3.6.1.2.1.2.2.1.16.11',161,10019,'Interface 11 Egress Traffic (bytes)','dell.6248.intf11.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18610,4,'public','1.3.6.1.2.1.2.2.1.19.11',161,10019,'Interface 11 Egress Discards','dell.6248.intf11.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18611,4,'public','1.3.6.1.2.1.2.2.1.20.11',161,10019,'Interface 11 Egress Errors','dell.6248.intf11.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18612,4,'public','1.3.6.1.2.1.2.2.1.18.11',161,10019,'Interface 11 Egress Traffic (Non-Unicast)','dell.6248.intf11.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18613,4,'public','1.3.6.1.2.1.2.2.1.17.11',161,10019,'Interface 11 Egress Traffic (Unicast)','dell.6248.intf11.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18614,4,'public','1.3.6.1.2.1.2.2.1.10.11',161,10019,'Interface 11 Ingress Traffic (Bps)','dell.6248.intf11.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18615,4,'public','1.3.6.1.2.1.2.2.1.10.11',161,10019,'Interface 11 Ingress Traffic (bytes)','dell.6248.intf11.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18616,4,'public','1.3.6.1.2.1.2.2.1.13.11',161,10019,'Interface 11 Ingress Discards','dell.6248.intf11.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18617,4,'public','1.3.6.1.2.1.2.2.1.14.11',161,10019,'Interface 11 Ingress Errors','dell.6248.intf11.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18618,4,'public','1.3.6.1.2.1.2.2.1.12.11',161,10019,'Interface 11 Ingress Traffic (Non-Unicast)','dell.6248.intf11.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18619,4,'public','1.3.6.1.2.1.2.2.1.11.11',161,10019,'Interface 11 Ingress Traffic (Unicast)','dell.6248.intf11.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18620,4,'public','1.3.6.1.2.1.31.1.1.1.18.12',161,10019,'Interface 12 Description','dell.6248.intf12.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18621,4,'public','1.3.6.1.2.1.2.2.1.5.12',161,10019,'Interface 12 Speed','dell.6248.intf12.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18622,4,'public','1.3.6.1.2.1.2.2.1.7.12',161,10019,'Interface 12 Admin Status','dell.6248.intf12.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18623,4,'public','1.3.6.1.2.1.2.2.1.8.12',161,10019,'Interface 12 Op Status','dell.6248.intf12.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18624,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10019,'Interface 12 Egress Traffic (Bps)','dell.6248.intf12.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18625,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10019,'Interface 12 Egress Traffic (bytes)','dell.6248.intf12.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18626,4,'public','1.3.6.1.2.1.2.2.1.19.12',161,10019,'Interface 12 Egress Discards','dell.6248.intf12.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18627,4,'public','1.3.6.1.2.1.2.2.1.20.12',161,10019,'Interface 12 Egress Errors','dell.6248.intf12.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18628,4,'public','1.3.6.1.2.1.2.2.1.18.12',161,10019,'Interface 12 Egress Traffic (Non-Unicast)','dell.6248.intf12.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18629,4,'public','1.3.6.1.2.1.2.2.1.17.12',161,10019,'Interface 12 Egress Traffic (Unicast)','dell.6248.intf12.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18630,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10019,'Interface 12 Ingress Traffic (Bps)','dell.6248.intf12.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18631,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10019,'Interface 12 Ingress Traffic (bytes)','dell.6248.intf12.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18632,4,'public','1.3.6.1.2.1.2.2.1.13.12',161,10019,'Interface 12 Ingress Discards','dell.6248.intf12.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18633,4,'public','1.3.6.1.2.1.2.2.1.14.12',161,10019,'Interface 12 Ingress Errors','dell.6248.intf12.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18634,4,'public','1.3.6.1.2.1.2.2.1.12.12',161,10019,'Interface 12 Ingress Traffic (Non-Unicast)','dell.6248.intf12.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18635,4,'public','1.3.6.1.2.1.2.2.1.11.12',161,10019,'Interface 12 Ingress Traffic (Unicast)','dell.6248.intf12.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18636,4,'public','1.3.6.1.2.1.31.1.1.1.18.13',161,10019,'Interface 13 Description','dell.6248.intf13.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18637,4,'public','1.3.6.1.2.1.2.2.1.5.13',161,10019,'Interface 13 Speed','dell.6248.intf13.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18638,4,'public','1.3.6.1.2.1.2.2.1.7.13',161,10019,'Interface 13 Admin Status','dell.6248.intf13.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18639,4,'public','1.3.6.1.2.1.2.2.1.8.13',161,10019,'Interface 13 Op Status','dell.6248.intf13.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18640,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10019,'Interface 13 Egress Traffic (Bps)','dell.6248.intf13.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18641,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10019,'Interface 13 Egress Traffic (bytes)','dell.6248.intf13.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18642,4,'public','1.3.6.1.2.1.2.2.1.19.13',161,10019,'Interface 13 Egress Discards','dell.6248.intf13.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18643,4,'public','1.3.6.1.2.1.2.2.1.20.13',161,10019,'Interface 13 Egress Errors','dell.6248.intf13.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18644,4,'public','1.3.6.1.2.1.2.2.1.18.13',161,10019,'Interface 13 Egress Traffic (Non-Unicast)','dell.6248.intf13.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18645,4,'public','1.3.6.1.2.1.2.2.1.17.13',161,10019,'Interface 13 Egress Traffic (Unicast)','dell.6248.intf13.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18646,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10019,'Interface 13 Ingress Traffic (Bps)','dell.6248.intf13.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18647,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10019,'Interface 13 Ingress Traffic (bytes)','dell.6248.intf13.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18648,4,'public','1.3.6.1.2.1.2.2.1.13.13',161,10019,'Interface 13 Ingress Discards','dell.6248.intf13.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18649,4,'public','1.3.6.1.2.1.2.2.1.14.13',161,10019,'Interface 13 Ingress Errors','dell.6248.intf13.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18650,4,'public','1.3.6.1.2.1.2.2.1.12.13',161,10019,'Interface 13 Ingress Traffic (Non-Unicast)','dell.6248.intf13.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18651,4,'public','1.3.6.1.2.1.2.2.1.11.13',161,10019,'Interface 13 Ingress Traffic (Unicast)','dell.6248.intf13.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18652,4,'public','1.3.6.1.2.1.31.1.1.1.18.14',161,10019,'Interface 14 Description','dell.6248.intf14.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18653,4,'public','1.3.6.1.2.1.2.2.1.5.14',161,10019,'Interface 14 Speed','dell.6248.intf14.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18654,4,'public','1.3.6.1.2.1.2.2.1.7.14',161,10019,'Interface 14 Admin Status','dell.6248.intf14.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18655,4,'public','1.3.6.1.2.1.2.2.1.8.14',161,10019,'Interface 14 Op Status','dell.6248.intf14.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18656,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10019,'Interface 14 Egress Traffic (Bps)','dell.6248.intf14.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18657,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10019,'Interface 14 Egress Traffic (bytes)','dell.6248.intf14.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18658,4,'public','1.3.6.1.2.1.2.2.1.19.14',161,10019,'Interface 14 Egress Discards','dell.6248.intf14.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18659,4,'public','1.3.6.1.2.1.2.2.1.20.14',161,10019,'Interface 14 Egress Errors','dell.6248.intf14.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18660,4,'public','1.3.6.1.2.1.2.2.1.18.14',161,10019,'Interface 14 Egress Traffic (Non-Unicast)','dell.6248.intf14.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18661,4,'public','1.3.6.1.2.1.2.2.1.17.14',161,10019,'Interface 14 Egress Traffic (Unicast)','dell.6248.intf14.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18662,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10019,'Interface 14 Ingress Traffic (Bps)','dell.6248.intf14.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18663,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10019,'Interface 14 Ingress Traffic (bytes)','dell.6248.intf14.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18664,4,'public','1.3.6.1.2.1.2.2.1.13.14',161,10019,'Interface 14 Ingress Discards','dell.6248.intf14.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18665,4,'public','1.3.6.1.2.1.2.2.1.14.14',161,10019,'Interface 14 Ingress Errors','dell.6248.intf14.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18666,4,'public','1.3.6.1.2.1.2.2.1.12.14',161,10019,'Interface 14 Ingress Traffic (Non-Unicast)','dell.6248.intf14.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18667,4,'public','1.3.6.1.2.1.2.2.1.11.14',161,10019,'Interface 14 Ingress Traffic (Unicast)','dell.6248.intf14.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18668,4,'public','1.3.6.1.2.1.31.1.1.1.18.15',161,10019,'Interface 15 Description','dell.6248.intf15.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18669,4,'public','1.3.6.1.2.1.2.2.1.5.15',161,10019,'Interface 15 Speed','dell.6248.intf15.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18670,4,'public','1.3.6.1.2.1.2.2.1.7.15',161,10019,'Interface 15 Admin Status','dell.6248.intf15.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18671,4,'public','1.3.6.1.2.1.2.2.1.8.15',161,10019,'Interface 15 Op Status','dell.6248.intf15.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18672,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10019,'Interface 15 Egress Traffic (Bps)','dell.6248.intf15.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18673,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10019,'Interface 15 Egress Traffic (bytes)','dell.6248.intf15.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18674,4,'public','1.3.6.1.2.1.2.2.1.19.15',161,10019,'Interface 15 Egress Discards','dell.6248.intf15.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18675,4,'public','1.3.6.1.2.1.2.2.1.20.15',161,10019,'Interface 15 Egress Errors','dell.6248.intf15.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18676,4,'public','1.3.6.1.2.1.2.2.1.18.15',161,10019,'Interface 15 Egress Traffic (Non-Unicast)','dell.6248.intf15.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18677,4,'public','1.3.6.1.2.1.2.2.1.17.15',161,10019,'Interface 15 Egress Traffic (Unicast)','dell.6248.intf15.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18678,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10019,'Interface 15 Ingress Traffic (Bps)','dell.6248.intf15.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18679,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10019,'Interface 15 Ingress Traffic (bytes)','dell.6248.intf15.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18680,4,'public','1.3.6.1.2.1.2.2.1.13.15',161,10019,'Interface 15 Ingress Discards','dell.6248.intf15.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18681,4,'public','1.3.6.1.2.1.2.2.1.14.15',161,10019,'Interface 15 Ingress Errors','dell.6248.intf15.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18682,4,'public','1.3.6.1.2.1.2.2.1.12.15',161,10019,'Interface 15 Ingress Traffic (Non-Unicast)','dell.6248.intf15.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18683,4,'public','1.3.6.1.2.1.2.2.1.11.15',161,10019,'Interface 15 Ingress Traffic (Unicast)','dell.6248.intf15.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18684,4,'public','1.3.6.1.2.1.31.1.1.1.18.16',161,10019,'Interface 16 Description','dell.6248.intf16.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18685,4,'public','1.3.6.1.2.1.2.2.1.5.16',161,10019,'Interface 16 Speed','dell.6248.intf16.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18686,4,'public','1.3.6.1.2.1.2.2.1.7.16',161,10019,'Interface 16 Admin Status','dell.6248.intf16.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18687,4,'public','1.3.6.1.2.1.2.2.1.8.16',161,10019,'Interface 16 Op Status','dell.6248.intf16.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18688,4,'public','1.3.6.1.2.1.2.2.1.16.16',161,10019,'Interface 16 Egress Traffic (Bps)','dell.6248.intf16.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18689,4,'public','1.3.6.1.2.1.2.2.1.16.16',161,10019,'Interface 16 Egress Traffic (bytes)','dell.6248.intf16.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18690,4,'public','1.3.6.1.2.1.2.2.1.19.16',161,10019,'Interface 16 Egress Discards','dell.6248.intf16.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18691,4,'public','1.3.6.1.2.1.2.2.1.20.16',161,10019,'Interface 16 Egress Errors','dell.6248.intf16.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18692,4,'public','1.3.6.1.2.1.2.2.1.18.16',161,10019,'Interface 16 Egress Traffic (Non-Unicast)','dell.6248.intf16.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18693,4,'public','1.3.6.1.2.1.2.2.1.17.16',161,10019,'Interface 16 Egress Traffic (Unicast)','dell.6248.intf16.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18694,4,'public','1.3.6.1.2.1.2.2.1.10.16',161,10019,'Interface 16 Ingress Traffic (Bps)','dell.6248.intf16.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18695,4,'public','1.3.6.1.2.1.2.2.1.10.16',161,10019,'Interface 16 Ingress Traffic (bytes)','dell.6248.intf16.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18696,4,'public','1.3.6.1.2.1.2.2.1.13.16',161,10019,'Interface 16 Ingress Discards','dell.6248.intf16.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18697,4,'public','1.3.6.1.2.1.2.2.1.14.16',161,10019,'Interface 16 Ingress Errors','dell.6248.intf16.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18698,4,'public','1.3.6.1.2.1.2.2.1.12.16',161,10019,'Interface 16 Ingress Traffic (Non-Unicast)','dell.6248.intf16.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18699,4,'public','1.3.6.1.2.1.2.2.1.11.16',161,10019,'Interface 16 Ingress Traffic (Unicast)','dell.6248.intf16.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18700,4,'public','1.3.6.1.2.1.31.1.1.1.18.17',161,10019,'Interface 17 Description','dell.6248.intf17.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18701,4,'public','1.3.6.1.2.1.2.2.1.5.17',161,10019,'Interface 17 Speed','dell.6248.intf17.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18702,4,'public','1.3.6.1.2.1.2.2.1.7.17',161,10019,'Interface 17 Admin Status','dell.6248.intf17.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18703,4,'public','1.3.6.1.2.1.2.2.1.8.17',161,10019,'Interface 17 Op Status','dell.6248.intf17.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18704,4,'public','1.3.6.1.2.1.2.2.1.16.17',161,10019,'Interface 17 Egress Traffic (Bps)','dell.6248.intf17.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18705,4,'public','1.3.6.1.2.1.2.2.1.16.17',161,10019,'Interface 17 Egress Traffic (bytes)','dell.6248.intf17.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18706,4,'public','1.3.6.1.2.1.2.2.1.19.17',161,10019,'Interface 17 Egress Discards','dell.6248.intf17.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18707,4,'public','1.3.6.1.2.1.2.2.1.20.17',161,10019,'Interface 17 Egress Errors','dell.6248.intf17.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18708,4,'public','1.3.6.1.2.1.2.2.1.18.17',161,10019,'Interface 17 Egress Traffic (Non-Unicast)','dell.6248.intf17.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18709,4,'public','1.3.6.1.2.1.2.2.1.17.17',161,10019,'Interface 17 Egress Traffic (Unicast)','dell.6248.intf17.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18710,4,'public','1.3.6.1.2.1.2.2.1.10.17',161,10019,'Interface 17 Ingress Traffic (Bps)','dell.6248.intf17.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18711,4,'public','1.3.6.1.2.1.2.2.1.10.17',161,10019,'Interface 17 Ingress Traffic (bytes)','dell.6248.intf17.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18712,4,'public','1.3.6.1.2.1.2.2.1.13.17',161,10019,'Interface 17 Ingress Discards','dell.6248.intf17.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18713,4,'public','1.3.6.1.2.1.2.2.1.14.17',161,10019,'Interface 17 Ingress Errors','dell.6248.intf17.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18714,4,'public','1.3.6.1.2.1.2.2.1.12.17',161,10019,'Interface 17 Ingress Traffic (Non-Unicast)','dell.6248.intf17.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18715,4,'public','1.3.6.1.2.1.2.2.1.11.17',161,10019,'Interface 17 Ingress Traffic (Unicast)','dell.6248.intf17.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18716,4,'public','1.3.6.1.2.1.31.1.1.1.18.18',161,10019,'Interface 18 Description','dell.6248.intf18.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18717,4,'public','1.3.6.1.2.1.2.2.1.5.18',161,10019,'Interface 18 Speed','dell.6248.intf18.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18718,4,'public','1.3.6.1.2.1.2.2.1.7.18',161,10019,'Interface 18 Admin Status','dell.6248.intf18.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18719,4,'public','1.3.6.1.2.1.2.2.1.8.18',161,10019,'Interface 18 Op Status','dell.6248.intf18.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18720,4,'public','1.3.6.1.2.1.2.2.1.16.18',161,10019,'Interface 18 Egress Traffic (Bps)','dell.6248.intf18.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18721,4,'public','1.3.6.1.2.1.2.2.1.16.18',161,10019,'Interface 18 Egress Traffic (bytes)','dell.6248.intf18.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18722,4,'public','1.3.6.1.2.1.2.2.1.19.18',161,10019,'Interface 18 Egress Discards','dell.6248.intf18.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18723,4,'public','1.3.6.1.2.1.2.2.1.20.18',161,10019,'Interface 18 Egress Errors','dell.6248.intf18.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18724,4,'public','1.3.6.1.2.1.2.2.1.18.18',161,10019,'Interface 18 Egress Traffic (Non-Unicast)','dell.6248.intf18.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18725,4,'public','1.3.6.1.2.1.2.2.1.17.18',161,10019,'Interface 18 Egress Traffic (Unicast)','dell.6248.intf18.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18726,4,'public','1.3.6.1.2.1.2.2.1.10.18',161,10019,'Interface 18 Ingress Traffic (Bps)','dell.6248.intf18.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18727,4,'public','1.3.6.1.2.1.2.2.1.10.18',161,10019,'Interface 18 Ingress Traffic (bytes)','dell.6248.intf18.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18728,4,'public','1.3.6.1.2.1.2.2.1.13.18',161,10019,'Interface 18 Ingress Discards','dell.6248.intf18.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18729,4,'public','1.3.6.1.2.1.2.2.1.14.18',161,10019,'Interface 18 Ingress Errors','dell.6248.intf18.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18730,4,'public','1.3.6.1.2.1.2.2.1.12.18',161,10019,'Interface 18 Ingress Traffic (Non-Unicast)','dell.6248.intf18.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18731,4,'public','1.3.6.1.2.1.2.2.1.11.18',161,10019,'Interface 18 Ingress Traffic (Unicast)','dell.6248.intf18.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18732,4,'public','1.3.6.1.2.1.31.1.1.1.18.19',161,10019,'Interface 19 Description','dell.6248.intf19.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18733,4,'public','1.3.6.1.2.1.2.2.1.5.19',161,10019,'Interface 19 Speed','dell.6248.intf19.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18734,4,'public','1.3.6.1.2.1.2.2.1.7.19',161,10019,'Interface 19 Admin Status','dell.6248.intf19.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18735,4,'public','1.3.6.1.2.1.2.2.1.8.19',161,10019,'Interface 19 Op Status','dell.6248.intf19.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18736,4,'public','1.3.6.1.2.1.2.2.1.16.19',161,10019,'Interface 19 Egress Traffic (Bps)','dell.6248.intf19.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18737,4,'public','1.3.6.1.2.1.2.2.1.16.19',161,10019,'Interface 19 Egress Traffic (bytes)','dell.6248.intf19.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18738,4,'public','1.3.6.1.2.1.2.2.1.19.19',161,10019,'Interface 19 Egress Discards','dell.6248.intf19.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18739,4,'public','1.3.6.1.2.1.2.2.1.20.19',161,10019,'Interface 19 Egress Errors','dell.6248.intf19.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18740,4,'public','1.3.6.1.2.1.2.2.1.18.19',161,10019,'Interface 19 Egress Traffic (Non-Unicast)','dell.6248.intf19.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18741,4,'public','1.3.6.1.2.1.2.2.1.17.19',161,10019,'Interface 19 Egress Traffic (Unicast)','dell.6248.intf19.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18742,4,'public','1.3.6.1.2.1.2.2.1.10.19',161,10019,'Interface 19 Ingress Traffic (Bps)','dell.6248.intf19.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18743,4,'public','1.3.6.1.2.1.2.2.1.10.19',161,10019,'Interface 19 Ingress Traffic (bytes)','dell.6248.intf19.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18744,4,'public','1.3.6.1.2.1.2.2.1.13.19',161,10019,'Interface 19 Ingress Discards','dell.6248.intf19.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18745,4,'public','1.3.6.1.2.1.2.2.1.14.19',161,10019,'Interface 19 Ingress Errors','dell.6248.intf19.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18746,4,'public','1.3.6.1.2.1.2.2.1.12.19',161,10019,'Interface 19 Ingress Traffic (Non-Unicast)','dell.6248.intf19.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18747,4,'public','1.3.6.1.2.1.2.2.1.11.19',161,10019,'Interface 19 Ingress Traffic (Unicast)','dell.6248.intf19.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18748,4,'public','1.3.6.1.2.1.31.1.1.1.18.2',161,10019,'Interface 02 Description','dell.6248.intf2.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18749,4,'public','1.3.6.1.2.1.2.2.1.5.2',161,10019,'Interface 02 Speed','dell.6248.intf2.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18750,4,'public','1.3.6.1.2.1.2.2.1.7.2',161,10019,'Interface 02 Admin Status','dell.6248.intf2.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18751,4,'public','1.3.6.1.2.1.2.2.1.8.2',161,10019,'Interface 02 Op Status','dell.6248.intf2.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18752,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10019,'Interface 02 Egress Traffic (Bps)','dell.6248.intf2.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18753,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10019,'Interface 02 Egress Traffic (bytes)','dell.6248.intf2.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18754,4,'public','1.3.6.1.2.1.2.2.1.19.2',161,10019,'Interface 02 Egress Discards','dell.6248.intf2.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18755,4,'public','1.3.6.1.2.1.2.2.1.20.2',161,10019,'Interface 02 Egress Errors','dell.6248.intf2.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18756,4,'public','1.3.6.1.2.1.2.2.1.18.2',161,10019,'Interface 02 Egress Traffic (Non-Unicast)','dell.6248.intf2.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18757,4,'public','1.3.6.1.2.1.2.2.1.17.2',161,10019,'Interface 02 Egress Traffic (Unicast)','dell.6248.intf2.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18758,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10019,'Interface 02 Ingress Traffic (Bps)','dell.6248.intf2.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18759,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10019,'Interface 02 Ingress Traffic (bytes)','dell.6248.intf2.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18760,4,'public','1.3.6.1.2.1.2.2.1.13.2',161,10019,'Interface 02 Ingress Discards','dell.6248.intf2.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18761,4,'public','1.3.6.1.2.1.2.2.1.14.2',161,10019,'Interface 02 Ingress Errors','dell.6248.intf2.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18762,4,'public','1.3.6.1.2.1.2.2.1.12.2',161,10019,'Interface 02 Ingress Traffic (Non-Unicast)','dell.6248.intf2.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18763,4,'public','1.3.6.1.2.1.2.2.1.11.2',161,10019,'Interface 02 Ingress Traffic (Unicast)','dell.6248.intf2.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18764,4,'public','1.3.6.1.2.1.31.1.1.1.18.20',161,10019,'Interface 20 Description','dell.6248.intf20.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18765,4,'public','1.3.6.1.2.1.2.2.1.5.20',161,10019,'Interface 20 Speed','dell.6248.intf20.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18766,4,'public','1.3.6.1.2.1.2.2.1.7.20',161,10019,'Interface 20 Admin Status','dell.6248.intf20.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18767,4,'public','1.3.6.1.2.1.2.2.1.8.20',161,10019,'Interface 20 Op Status','dell.6248.intf20.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18768,4,'public','1.3.6.1.2.1.2.2.1.16.20',161,10019,'Interface 20 Egress Traffic (Bps)','dell.6248.intf20.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18769,4,'public','1.3.6.1.2.1.2.2.1.16.20',161,10019,'Interface 20 Egress Traffic (bytes)','dell.6248.intf20.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18770,4,'public','1.3.6.1.2.1.2.2.1.19.20',161,10019,'Interface 20 Egress Discards','dell.6248.intf20.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18771,4,'public','1.3.6.1.2.1.2.2.1.20.20',161,10019,'Interface 20 Egress Errors','dell.6248.intf20.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18772,4,'public','1.3.6.1.2.1.2.2.1.18.20',161,10019,'Interface 20 Egress Traffic (Non-Unicast)','dell.6248.intf20.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18773,4,'public','1.3.6.1.2.1.2.2.1.17.20',161,10019,'Interface 20 Egress Traffic (Unicast)','dell.6248.intf20.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18774,4,'public','1.3.6.1.2.1.2.2.1.10.20',161,10019,'Interface 20 Ingress Traffic (Bps)','dell.6248.intf20.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18775,4,'public','1.3.6.1.2.1.2.2.1.10.20',161,10019,'Interface 20 Ingress Traffic (bytes)','dell.6248.intf20.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18776,4,'public','1.3.6.1.2.1.2.2.1.13.20',161,10019,'Interface 20 Ingress Discards','dell.6248.intf20.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18777,4,'public','1.3.6.1.2.1.2.2.1.14.20',161,10019,'Interface 20 Ingress Errors','dell.6248.intf20.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18778,4,'public','1.3.6.1.2.1.2.2.1.12.20',161,10019,'Interface 20 Ingress Traffic (Non-Unicast)','dell.6248.intf20.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18779,4,'public','1.3.6.1.2.1.2.2.1.11.20',161,10019,'Interface 20 Ingress Traffic (Unicast)','dell.6248.intf20.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18780,4,'public','1.3.6.1.2.1.31.1.1.1.18.21',161,10019,'Interface 21 Description','dell.6248.intf21.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18781,4,'public','1.3.6.1.2.1.2.2.1.5.21',161,10019,'Interface 21 Speed','dell.6248.intf21.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18782,4,'public','1.3.6.1.2.1.2.2.1.7.21',161,10019,'Interface 21 Admin Status','dell.6248.intf21.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18783,4,'public','1.3.6.1.2.1.2.2.1.8.21',161,10019,'Interface 21 Op Status','dell.6248.intf21.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18784,4,'public','1.3.6.1.2.1.2.2.1.16.21',161,10019,'Interface 21 Egress Traffic (Bps)','dell.6248.intf21.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18785,4,'public','1.3.6.1.2.1.2.2.1.16.21',161,10019,'Interface 21 Egress Traffic (bytes)','dell.6248.intf21.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18786,4,'public','1.3.6.1.2.1.2.2.1.19.21',161,10019,'Interface 21 Egress Discards','dell.6248.intf21.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18787,4,'public','1.3.6.1.2.1.2.2.1.20.21',161,10019,'Interface 21 Egress Errors','dell.6248.intf21.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18788,4,'public','1.3.6.1.2.1.2.2.1.18.21',161,10019,'Interface 21 Egress Traffic (Non-Unicast)','dell.6248.intf21.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18789,4,'public','1.3.6.1.2.1.2.2.1.17.21',161,10019,'Interface 21 Egress Traffic (Unicast)','dell.6248.intf21.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18790,4,'public','1.3.6.1.2.1.2.2.1.10.21',161,10019,'Interface 21 Ingress Traffic (Bps)','dell.6248.intf21.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18791,4,'public','1.3.6.1.2.1.2.2.1.10.21',161,10019,'Interface 21 Ingress Traffic (bytes)','dell.6248.intf21.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18792,4,'public','1.3.6.1.2.1.2.2.1.13.21',161,10019,'Interface 21 Ingress Discards','dell.6248.intf21.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18793,4,'public','1.3.6.1.2.1.2.2.1.14.21',161,10019,'Interface 21 Ingress Errors','dell.6248.intf21.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18794,4,'public','1.3.6.1.2.1.2.2.1.12.21',161,10019,'Interface 21 Ingress Traffic (Non-Unicast)','dell.6248.intf21.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18795,4,'public','1.3.6.1.2.1.2.2.1.11.21',161,10019,'Interface 21 Ingress Traffic (Unicast)','dell.6248.intf21.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18796,4,'public','1.3.6.1.2.1.31.1.1.1.18.22',161,10019,'Interface 22 Description','dell.6248.intf22.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18797,4,'public','1.3.6.1.2.1.2.2.1.5.22',161,10019,'Interface 22 Speed','dell.6248.intf22.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18798,4,'public','1.3.6.1.2.1.2.2.1.7.22',161,10019,'Interface 22 Admin Status','dell.6248.intf22.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18799,4,'public','1.3.6.1.2.1.2.2.1.8.22',161,10019,'Interface 22 Op Status','dell.6248.intf22.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18800,4,'public','1.3.6.1.2.1.2.2.1.16.22',161,10019,'Interface 22 Egress Traffic (Bps)','dell.6248.intf22.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18801,4,'public','1.3.6.1.2.1.2.2.1.16.22',161,10019,'Interface 22 Egress Traffic (bytes)','dell.6248.intf22.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18802,4,'public','1.3.6.1.2.1.2.2.1.19.22',161,10019,'Interface 22 Egress Discards','dell.6248.intf22.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18803,4,'public','1.3.6.1.2.1.2.2.1.20.22',161,10019,'Interface 22 Egress Errors','dell.6248.intf22.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18804,4,'public','1.3.6.1.2.1.2.2.1.18.22',161,10019,'Interface 22 Egress Traffic (Non-Unicast)','dell.6248.intf22.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18805,4,'public','1.3.6.1.2.1.2.2.1.17.22',161,10019,'Interface 22 Egress Traffic (Unicast)','dell.6248.intf22.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18806,4,'public','1.3.6.1.2.1.2.2.1.10.22',161,10019,'Interface 22 Ingress Traffic (Bps)','dell.6248.intf22.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18807,4,'public','1.3.6.1.2.1.2.2.1.10.22',161,10019,'Interface 22 Ingress Traffic (bytes)','dell.6248.intf22.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18808,4,'public','1.3.6.1.2.1.2.2.1.13.22',161,10019,'Interface 22 Ingress Discards','dell.6248.intf22.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18809,4,'public','1.3.6.1.2.1.2.2.1.14.22',161,10019,'Interface 22 Ingress Errors','dell.6248.intf22.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18810,4,'public','1.3.6.1.2.1.2.2.1.12.22',161,10019,'Interface 22 Ingress Traffic (Non-Unicast)','dell.6248.intf22.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18811,4,'public','1.3.6.1.2.1.2.2.1.11.22',161,10019,'Interface 22 Ingress Traffic (Unicast)','dell.6248.intf22.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18812,4,'public','1.3.6.1.2.1.31.1.1.1.18.23',161,10019,'Interface 23 Description','dell.6248.intf23.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18813,4,'public','1.3.6.1.2.1.2.2.1.5.23',161,10019,'Interface 23 Speed','dell.6248.intf23.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18814,4,'public','1.3.6.1.2.1.2.2.1.7.23',161,10019,'Interface 23 Admin Status','dell.6248.intf23.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18815,4,'public','1.3.6.1.2.1.2.2.1.8.23',161,10019,'Interface 23 Op Status','dell.6248.intf23.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18816,4,'public','1.3.6.1.2.1.2.2.1.16.23',161,10019,'Interface 23 Egress Traffic (Bps)','dell.6248.intf23.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18817,4,'public','1.3.6.1.2.1.2.2.1.16.23',161,10019,'Interface 23 Egress Traffic (bytes)','dell.6248.intf23.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18818,4,'public','1.3.6.1.2.1.2.2.1.19.23',161,10019,'Interface 23 Egress Discards','dell.6248.intf23.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18819,4,'public','1.3.6.1.2.1.2.2.1.20.23',161,10019,'Interface 23 Egress Errors','dell.6248.intf23.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18820,4,'public','1.3.6.1.2.1.2.2.1.18.23',161,10019,'Interface 23 Egress Traffic (Non-Unicast)','dell.6248.intf23.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18821,4,'public','1.3.6.1.2.1.2.2.1.17.23',161,10019,'Interface 23 Egress Traffic (Unicast)','dell.6248.intf23.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18822,4,'public','1.3.6.1.2.1.2.2.1.10.23',161,10019,'Interface 23 Ingress Traffic (Bps)','dell.6248.intf23.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18823,4,'public','1.3.6.1.2.1.2.2.1.10.23',161,10019,'Interface 23 Ingress Traffic (bytes)','dell.6248.intf23.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18824,4,'public','1.3.6.1.2.1.2.2.1.13.23',161,10019,'Interface 23 Ingress Discards','dell.6248.intf23.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18825,4,'public','1.3.6.1.2.1.2.2.1.14.23',161,10019,'Interface 23 Ingress Errors','dell.6248.intf23.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18826,4,'public','1.3.6.1.2.1.2.2.1.12.23',161,10019,'Interface 23 Ingress Traffic (Non-Unicast)','dell.6248.intf23.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18827,4,'public','1.3.6.1.2.1.2.2.1.11.23',161,10019,'Interface 23 Ingress Traffic (Unicast)','dell.6248.intf23.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18828,4,'public','1.3.6.1.2.1.31.1.1.1.18.24',161,10019,'Interface 24 Description','dell.6248.intf24.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18829,4,'public','1.3.6.1.2.1.2.2.1.5.24',161,10019,'Interface 24 Speed','dell.6248.intf24.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18830,4,'public','1.3.6.1.2.1.2.2.1.7.24',161,10019,'Interface 24 Admin Status','dell.6248.intf24.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18831,4,'public','1.3.6.1.2.1.2.2.1.8.24',161,10019,'Interface 24 Op Status','dell.6248.intf24.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18832,4,'public','1.3.6.1.2.1.2.2.1.16.24',161,10019,'Interface 24 Egress Traffic (Bps)','dell.6248.intf24.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18833,4,'public','1.3.6.1.2.1.2.2.1.16.24',161,10019,'Interface 24 Egress Traffic (bytes)','dell.6248.intf24.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18834,4,'public','1.3.6.1.2.1.2.2.1.19.24',161,10019,'Interface 24 Egress Discards','dell.6248.intf24.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18835,4,'public','1.3.6.1.2.1.2.2.1.20.24',161,10019,'Interface 24 Egress Errors','dell.6248.intf24.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18836,4,'public','1.3.6.1.2.1.2.2.1.18.24',161,10019,'Interface 24 Egress Traffic (Non-Unicast)','dell.6248.intf24.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18837,4,'public','1.3.6.1.2.1.2.2.1.17.24',161,10019,'Interface 24 Egress Traffic (Unicast)','dell.6248.intf24.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18838,4,'public','1.3.6.1.2.1.2.2.1.10.24',161,10019,'Interface 24 Ingress Traffic (Bps)','dell.6248.intf24.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18839,4,'public','1.3.6.1.2.1.2.2.1.10.24',161,10019,'Interface 24 Ingress Traffic (bytes)','dell.6248.intf24.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18840,4,'public','1.3.6.1.2.1.2.2.1.13.24',161,10019,'Interface 24 Ingress Discards','dell.6248.intf24.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18841,4,'public','1.3.6.1.2.1.2.2.1.14.24',161,10019,'Interface 24 Ingress Errors','dell.6248.intf24.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18842,4,'public','1.3.6.1.2.1.2.2.1.12.24',161,10019,'Interface 24 Ingress Traffic (Non-Unicast)','dell.6248.intf24.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18843,4,'public','1.3.6.1.2.1.2.2.1.11.24',161,10019,'Interface 24 Ingress Traffic (Unicast)','dell.6248.intf24.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18844,4,'public','1.3.6.1.2.1.31.1.1.1.18.25',161,10019,'Interface 25 Description','dell.6248.intf25.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18845,4,'public','1.3.6.1.2.1.2.2.1.5.25',161,10019,'Interface 25 Speed','dell.6248.intf25.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18846,4,'public','1.3.6.1.2.1.2.2.1.7.25',161,10019,'Interface 25 Admin Status','dell.6248.intf25.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18847,4,'public','1.3.6.1.2.1.2.2.1.8.25',161,10019,'Interface 25 Op Status','dell.6248.intf25.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18848,4,'public','1.3.6.1.2.1.2.2.1.16.25',161,10019,'Interface 25 Egress Traffic (Bps)','dell.6248.intf25.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18849,4,'public','1.3.6.1.2.1.2.2.1.16.25',161,10019,'Interface 25 Egress Traffic (bytes)','dell.6248.intf25.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18850,4,'public','1.3.6.1.2.1.2.2.1.19.25',161,10019,'Interface 25 Egress Discards','dell.6248.intf25.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18851,4,'public','1.3.6.1.2.1.2.2.1.20.25',161,10019,'Interface 25 Egress Errors','dell.6248.intf25.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18852,4,'public','1.3.6.1.2.1.2.2.1.18.25',161,10019,'Interface 25 Egress Traffic (Non-Unicast)','dell.6248.intf25.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18853,4,'public','1.3.6.1.2.1.2.2.1.17.25',161,10019,'Interface 25 Egress Traffic (Unicast)','dell.6248.intf25.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18854,4,'public','1.3.6.1.2.1.2.2.1.10.25',161,10019,'Interface 25 Ingress Traffic (Bps)','dell.6248.intf25.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18855,4,'public','1.3.6.1.2.1.2.2.1.10.25',161,10019,'Interface 25 Ingress Traffic (bytes)','dell.6248.intf25.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18856,4,'public','1.3.6.1.2.1.2.2.1.13.25',161,10019,'Interface 25 Ingress Discards','dell.6248.intf25.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18857,4,'public','1.3.6.1.2.1.2.2.1.14.25',161,10019,'Interface 25 Ingress Errors','dell.6248.intf25.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18858,4,'public','1.3.6.1.2.1.2.2.1.12.25',161,10019,'Interface 25 Ingress Traffic (Non-Unicast)','dell.6248.intf25.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18859,4,'public','1.3.6.1.2.1.2.2.1.11.25',161,10019,'Interface 25 Ingress Traffic (Unicast)','dell.6248.intf25.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18860,4,'public','1.3.6.1.2.1.31.1.1.1.18.26',161,10019,'Interface 26 Description','dell.6248.intf26.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18861,4,'public','1.3.6.1.2.1.2.2.1.5.26',161,10019,'Interface 26 Speed','dell.6248.intf26.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18862,4,'public','1.3.6.1.2.1.2.2.1.7.26',161,10019,'Interface 26 Admin Status','dell.6248.intf26.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18863,4,'public','1.3.6.1.2.1.2.2.1.8.26',161,10019,'Interface 26 Op Status','dell.6248.intf26.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18864,4,'public','1.3.6.1.2.1.2.2.1.16.26',161,10019,'Interface 26 Egress Traffic (Bps)','dell.6248.intf26.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18865,4,'public','1.3.6.1.2.1.2.2.1.16.26',161,10019,'Interface 26 Egress Traffic (bytes)','dell.6248.intf26.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18866,4,'public','1.3.6.1.2.1.2.2.1.19.26',161,10019,'Interface 26 Egress Discards','dell.6248.intf26.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18867,4,'public','1.3.6.1.2.1.2.2.1.20.26',161,10019,'Interface 26 Egress Errors','dell.6248.intf26.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18868,4,'public','1.3.6.1.2.1.2.2.1.18.26',161,10019,'Interface 26 Egress Traffic (Non-Unicast)','dell.6248.intf26.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18869,4,'public','1.3.6.1.2.1.2.2.1.17.26',161,10019,'Interface 26 Egress Traffic (Unicast)','dell.6248.intf26.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18870,4,'public','1.3.6.1.2.1.2.2.1.10.26',161,10019,'Interface 26 Ingress Traffic (Bps)','dell.6248.intf26.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18871,4,'public','1.3.6.1.2.1.2.2.1.10.26',161,10019,'Interface 26 Ingress Traffic (bytes)','dell.6248.intf26.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18872,4,'public','1.3.6.1.2.1.2.2.1.13.26',161,10019,'Interface 26 Ingress Discards','dell.6248.intf26.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18873,4,'public','1.3.6.1.2.1.2.2.1.14.26',161,10019,'Interface 26 Ingress Errors','dell.6248.intf26.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18874,4,'public','1.3.6.1.2.1.2.2.1.12.26',161,10019,'Interface 26 Ingress Traffic (Non-Unicast)','dell.6248.intf26.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18875,4,'public','1.3.6.1.2.1.2.2.1.11.26',161,10019,'Interface 26 Ingress Traffic (Unicast)','dell.6248.intf26.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18876,4,'public','1.3.6.1.2.1.31.1.1.1.18.27',161,10019,'Interface 27 Description','dell.6248.intf27.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18877,4,'public','1.3.6.1.2.1.2.2.1.5.27',161,10019,'Interface 27 Speed','dell.6248.intf27.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18878,4,'public','1.3.6.1.2.1.2.2.1.7.27',161,10019,'Interface 27 Admin Status','dell.6248.intf27.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18879,4,'public','1.3.6.1.2.1.2.2.1.8.27',161,10019,'Interface 27 Op Status','dell.6248.intf27.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18880,4,'public','1.3.6.1.2.1.2.2.1.16.27',161,10019,'Interface 27 Egress Traffic (Bps)','dell.6248.intf27.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18881,4,'public','1.3.6.1.2.1.2.2.1.16.27',161,10019,'Interface 27 Egress Traffic (bytes)','dell.6248.intf27.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18882,4,'public','1.3.6.1.2.1.2.2.1.19.27',161,10019,'Interface 27 Egress Discards','dell.6248.intf27.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18883,4,'public','1.3.6.1.2.1.2.2.1.20.27',161,10019,'Interface 27 Egress Errors','dell.6248.intf27.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18884,4,'public','1.3.6.1.2.1.2.2.1.18.27',161,10019,'Interface 27 Egress Traffic (Non-Unicast)','dell.6248.intf27.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18885,4,'public','1.3.6.1.2.1.2.2.1.17.27',161,10019,'Interface 27 Egress Traffic (Unicast)','dell.6248.intf27.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18886,4,'public','1.3.6.1.2.1.2.2.1.10.27',161,10019,'Interface 27 Ingress Traffic (Bps)','dell.6248.intf27.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18887,4,'public','1.3.6.1.2.1.2.2.1.10.27',161,10019,'Interface 27 Ingress Traffic (bytes)','dell.6248.intf27.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18888,4,'public','1.3.6.1.2.1.2.2.1.13.27',161,10019,'Interface 27 Ingress Discards','dell.6248.intf27.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18889,4,'public','1.3.6.1.2.1.2.2.1.14.27',161,10019,'Interface 27 Ingress Errors','dell.6248.intf27.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18890,4,'public','1.3.6.1.2.1.2.2.1.12.27',161,10019,'Interface 27 Ingress Traffic (Non-Unicast)','dell.6248.intf27.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18891,4,'public','1.3.6.1.2.1.2.2.1.11.27',161,10019,'Interface 27 Ingress Traffic (Unicast)','dell.6248.intf27.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18892,4,'public','1.3.6.1.2.1.31.1.1.1.18.28',161,10019,'Interface 28 Description','dell.6248.intf28.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18893,4,'public','1.3.6.1.2.1.2.2.1.5.28',161,10019,'Interface 28 Speed','dell.6248.intf28.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18894,4,'public','1.3.6.1.2.1.2.2.1.7.28',161,10019,'Interface 28 Admin Status','dell.6248.intf28.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18895,4,'public','1.3.6.1.2.1.2.2.1.8.28',161,10019,'Interface 28 Op Status','dell.6248.intf28.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18896,4,'public','1.3.6.1.2.1.2.2.1.16.28',161,10019,'Interface 28 Egress Traffic (Bps)','dell.6248.intf28.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18897,4,'public','1.3.6.1.2.1.2.2.1.16.28',161,10019,'Interface 28 Egress Traffic (bytes)','dell.6248.intf28.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18898,4,'public','1.3.6.1.2.1.2.2.1.19.28',161,10019,'Interface 28 Egress Discards','dell.6248.intf28.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18899,4,'public','1.3.6.1.2.1.2.2.1.20.28',161,10019,'Interface 28 Egress Errors','dell.6248.intf28.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18900,4,'public','1.3.6.1.2.1.2.2.1.18.28',161,10019,'Interface 28 Egress Traffic (Non-Unicast)','dell.6248.intf28.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18901,4,'public','1.3.6.1.2.1.2.2.1.17.28',161,10019,'Interface 28 Egress Traffic (Unicast)','dell.6248.intf28.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18902,4,'public','1.3.6.1.2.1.2.2.1.10.28',161,10019,'Interface 28 Ingress Traffic (Bps)','dell.6248.intf28.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18903,4,'public','1.3.6.1.2.1.2.2.1.10.28',161,10019,'Interface 28 Ingress Traffic (bytes)','dell.6248.intf28.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18904,4,'public','1.3.6.1.2.1.2.2.1.13.28',161,10019,'Interface 28 Ingress Discards','dell.6248.intf28.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18905,4,'public','1.3.6.1.2.1.2.2.1.14.28',161,10019,'Interface 28 Ingress Errors','dell.6248.intf28.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18906,4,'public','1.3.6.1.2.1.2.2.1.12.28',161,10019,'Interface 28 Ingress Traffic (Non-Unicast)','dell.6248.intf28.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18907,4,'public','1.3.6.1.2.1.2.2.1.11.28',161,10019,'Interface 28 Ingress Traffic (Unicast)','dell.6248.intf28.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18908,4,'public','1.3.6.1.2.1.31.1.1.1.18.29',161,10019,'Interface 29 Description','dell.6248.intf29.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18909,4,'public','1.3.6.1.2.1.2.2.1.5.29',161,10019,'Interface 29 Speed','dell.6248.intf29.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18910,4,'public','1.3.6.1.2.1.2.2.1.7.29',161,10019,'Interface 29 Admin Status','dell.6248.intf29.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18911,4,'public','1.3.6.1.2.1.2.2.1.8.29',161,10019,'Interface 29 Op Status','dell.6248.intf29.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18912,4,'public','1.3.6.1.2.1.2.2.1.16.29',161,10019,'Interface 29 Egress Traffic (Bps)','dell.6248.intf29.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18913,4,'public','1.3.6.1.2.1.2.2.1.16.29',161,10019,'Interface 29 Egress Traffic (bytes)','dell.6248.intf29.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18914,4,'public','1.3.6.1.2.1.2.2.1.19.29',161,10019,'Interface 29 Egress Discards','dell.6248.intf29.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18915,4,'public','1.3.6.1.2.1.2.2.1.20.29',161,10019,'Interface 29 Egress Errors','dell.6248.intf29.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18916,4,'public','1.3.6.1.2.1.2.2.1.18.29',161,10019,'Interface 29 Egress Traffic (Non-Unicast)','dell.6248.intf29.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18917,4,'public','1.3.6.1.2.1.2.2.1.17.29',161,10019,'Interface 29 Egress Traffic (Unicast)','dell.6248.intf29.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18918,4,'public','1.3.6.1.2.1.2.2.1.10.29',161,10019,'Interface 29 Ingress Traffic (Bps)','dell.6248.intf29.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18919,4,'public','1.3.6.1.2.1.2.2.1.10.29',161,10019,'Interface 29 Ingress Traffic (bytes)','dell.6248.intf29.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18920,4,'public','1.3.6.1.2.1.2.2.1.13.29',161,10019,'Interface 29 Ingress Discards','dell.6248.intf29.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18921,4,'public','1.3.6.1.2.1.2.2.1.14.29',161,10019,'Interface 29 Ingress Errors','dell.6248.intf29.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18922,4,'public','1.3.6.1.2.1.2.2.1.12.29',161,10019,'Interface 29 Ingress Traffic (Non-Unicast)','dell.6248.intf29.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18923,4,'public','1.3.6.1.2.1.2.2.1.11.29',161,10019,'Interface 29 Ingress Traffic (Unicast)','dell.6248.intf29.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18924,4,'public','1.3.6.1.2.1.31.1.1.1.18.3',161,10019,'Interface 03 Description','dell.6248.intf3.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18925,4,'public','1.3.6.1.2.1.2.2.1.5.3',161,10019,'Interface 03 Speed','dell.6248.intf3.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18926,4,'public','1.3.6.1.2.1.2.2.1.7.3',161,10019,'Interface 03 Admin Status','dell.6248.intf3.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18927,4,'public','1.3.6.1.2.1.2.2.1.8.3',161,10019,'Interface 03 Op Status','dell.6248.intf3.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18928,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10019,'Interface 03 Egress Traffic (Bps)','dell.6248.intf3.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18929,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10019,'Interface 03 Egress Traffic (bytes)','dell.6248.intf3.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18930,4,'public','1.3.6.1.2.1.2.2.1.19.3',161,10019,'Interface 03 Egress Discards','dell.6248.intf3.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18931,4,'public','1.3.6.1.2.1.2.2.1.20.3',161,10019,'Interface 03 Egress Errors','dell.6248.intf3.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18932,4,'public','1.3.6.1.2.1.2.2.1.18.3',161,10019,'Interface 03 Egress Traffic (Non-Unicast)','dell.6248.intf3.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18933,4,'public','1.3.6.1.2.1.2.2.1.17.3',161,10019,'Interface 03 Egress Traffic (Unicast)','dell.6248.intf3.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18934,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10019,'Interface 03 Ingress Traffic (Bps)','dell.6248.intf3.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18935,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10019,'Interface 03 Ingress Traffic (bytes)','dell.6248.intf3.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18936,4,'public','1.3.6.1.2.1.2.2.1.13.3',161,10019,'Interface 03 Ingress Discards','dell.6248.intf3.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18937,4,'public','1.3.6.1.2.1.2.2.1.14.3',161,10019,'Interface 03 Ingress Errors','dell.6248.intf3.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18938,4,'public','1.3.6.1.2.1.2.2.1.12.3',161,10019,'Interface 03 Ingress Traffic (Non-Unicast)','dell.6248.intf3.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18939,4,'public','1.3.6.1.2.1.2.2.1.11.3',161,10019,'Interface 03 Ingress Traffic (Unicast)','dell.6248.intf3.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18940,4,'public','1.3.6.1.2.1.31.1.1.1.18.30',161,10019,'Interface 30 Description','dell.6248.intf30.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18941,4,'public','1.3.6.1.2.1.2.2.1.5.30',161,10019,'Interface 30 Speed','dell.6248.intf30.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18942,4,'public','1.3.6.1.2.1.2.2.1.7.30',161,10019,'Interface 30 Admin Status','dell.6248.intf30.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18943,4,'public','1.3.6.1.2.1.2.2.1.8.30',161,10019,'Interface 30 Op Status','dell.6248.intf30.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18944,4,'public','1.3.6.1.2.1.2.2.1.16.30',161,10019,'Interface 30 Egress Traffic (Bps)','dell.6248.intf30.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18945,4,'public','1.3.6.1.2.1.2.2.1.16.30',161,10019,'Interface 30 Egress Traffic (bytes)','dell.6248.intf30.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18946,4,'public','1.3.6.1.2.1.2.2.1.19.30',161,10019,'Interface 30 Egress Discards','dell.6248.intf30.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18947,4,'public','1.3.6.1.2.1.2.2.1.20.30',161,10019,'Interface 30 Egress Errors','dell.6248.intf30.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18948,4,'public','1.3.6.1.2.1.2.2.1.18.30',161,10019,'Interface 30 Egress Traffic (Non-Unicast)','dell.6248.intf30.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18949,4,'public','1.3.6.1.2.1.2.2.1.17.30',161,10019,'Interface 30 Egress Traffic (Unicast)','dell.6248.intf30.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18950,4,'public','1.3.6.1.2.1.2.2.1.10.30',161,10019,'Interface 30 Ingress Traffic (Bps)','dell.6248.intf30.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18951,4,'public','1.3.6.1.2.1.2.2.1.10.30',161,10019,'Interface 30 Ingress Traffic (bytes)','dell.6248.intf30.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18952,4,'public','1.3.6.1.2.1.2.2.1.13.30',161,10019,'Interface 30 Ingress Discards','dell.6248.intf30.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18953,4,'public','1.3.6.1.2.1.2.2.1.14.30',161,10019,'Interface 30 Ingress Errors','dell.6248.intf30.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18954,4,'public','1.3.6.1.2.1.2.2.1.12.30',161,10019,'Interface 30 Ingress Traffic (Non-Unicast)','dell.6248.intf30.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18955,4,'public','1.3.6.1.2.1.2.2.1.11.30',161,10019,'Interface 30 Ingress Traffic (Unicast)','dell.6248.intf30.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18956,4,'public','1.3.6.1.2.1.31.1.1.1.18.31',161,10019,'Interface 31 Description','dell.6248.intf31.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18957,4,'public','1.3.6.1.2.1.2.2.1.5.31',161,10019,'Interface 31 Speed','dell.6248.intf31.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18958,4,'public','1.3.6.1.2.1.2.2.1.7.31',161,10019,'Interface 31 Admin Status','dell.6248.intf31.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18959,4,'public','1.3.6.1.2.1.2.2.1.8.31',161,10019,'Interface 31 Op Status','dell.6248.intf31.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18960,4,'public','1.3.6.1.2.1.2.2.1.16.31',161,10019,'Interface 31 Egress Traffic (Bps)','dell.6248.intf31.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18961,4,'public','1.3.6.1.2.1.2.2.1.16.31',161,10019,'Interface 31 Egress Traffic (bytes)','dell.6248.intf31.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18962,4,'public','1.3.6.1.2.1.2.2.1.19.31',161,10019,'Interface 31 Egress Discards','dell.6248.intf31.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18963,4,'public','1.3.6.1.2.1.2.2.1.20.31',161,10019,'Interface 31 Egress Errors','dell.6248.intf31.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18964,4,'public','1.3.6.1.2.1.2.2.1.18.31',161,10019,'Interface 31 Egress Traffic (Non-Unicast)','dell.6248.intf31.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18965,4,'public','1.3.6.1.2.1.2.2.1.17.31',161,10019,'Interface 31 Egress Traffic (Unicast)','dell.6248.intf31.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18966,4,'public','1.3.6.1.2.1.2.2.1.10.31',161,10019,'Interface 31 Ingress Traffic (Bps)','dell.6248.intf31.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18967,4,'public','1.3.6.1.2.1.2.2.1.10.31',161,10019,'Interface 31 Ingress Traffic (bytes)','dell.6248.intf31.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18968,4,'public','1.3.6.1.2.1.2.2.1.13.31',161,10019,'Interface 31 Ingress Discards','dell.6248.intf31.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18969,4,'public','1.3.6.1.2.1.2.2.1.14.31',161,10019,'Interface 31 Ingress Errors','dell.6248.intf31.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18970,4,'public','1.3.6.1.2.1.2.2.1.12.31',161,10019,'Interface 31 Ingress Traffic (Non-Unicast)','dell.6248.intf31.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18971,4,'public','1.3.6.1.2.1.2.2.1.11.31',161,10019,'Interface 31 Ingress Traffic (Unicast)','dell.6248.intf31.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18972,4,'public','1.3.6.1.2.1.31.1.1.1.18.32',161,10019,'Interface 32 Description','dell.6248.intf32.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18973,4,'public','1.3.6.1.2.1.2.2.1.5.32',161,10019,'Interface 32 Speed','dell.6248.intf32.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18974,4,'public','1.3.6.1.2.1.2.2.1.7.32',161,10019,'Interface 32 Admin Status','dell.6248.intf32.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18975,4,'public','1.3.6.1.2.1.2.2.1.8.32',161,10019,'Interface 32 Op Status','dell.6248.intf32.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18976,4,'public','1.3.6.1.2.1.2.2.1.16.32',161,10019,'Interface 32 Egress Traffic (Bps)','dell.6248.intf32.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18977,4,'public','1.3.6.1.2.1.2.2.1.16.32',161,10019,'Interface 32 Egress Traffic (bytes)','dell.6248.intf32.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18978,4,'public','1.3.6.1.2.1.2.2.1.19.32',161,10019,'Interface 32 Egress Discards','dell.6248.intf32.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18979,4,'public','1.3.6.1.2.1.2.2.1.20.32',161,10019,'Interface 32 Egress Errors','dell.6248.intf32.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18980,4,'public','1.3.6.1.2.1.2.2.1.18.32',161,10019,'Interface 32 Egress Traffic (Non-Unicast)','dell.6248.intf32.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18981,4,'public','1.3.6.1.2.1.2.2.1.17.32',161,10019,'Interface 32 Egress Traffic (Unicast)','dell.6248.intf32.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18982,4,'public','1.3.6.1.2.1.2.2.1.10.32',161,10019,'Interface 32 Ingress Traffic (Bps)','dell.6248.intf32.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18983,4,'public','1.3.6.1.2.1.2.2.1.10.32',161,10019,'Interface 32 Ingress Traffic (bytes)','dell.6248.intf32.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18984,4,'public','1.3.6.1.2.1.2.2.1.13.32',161,10019,'Interface 32 Ingress Discards','dell.6248.intf32.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18985,4,'public','1.3.6.1.2.1.2.2.1.14.32',161,10019,'Interface 32 Ingress Errors','dell.6248.intf32.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18986,4,'public','1.3.6.1.2.1.2.2.1.12.32',161,10019,'Interface 32 Ingress Traffic (Non-Unicast)','dell.6248.intf32.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18987,4,'public','1.3.6.1.2.1.2.2.1.11.32',161,10019,'Interface 32 Ingress Traffic (Unicast)','dell.6248.intf32.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18988,4,'public','1.3.6.1.2.1.31.1.1.1.18.33',161,10019,'Interface 33 Description','dell.6248.intf33.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18989,4,'public','1.3.6.1.2.1.2.2.1.5.33',161,10019,'Interface 33 Speed','dell.6248.intf33.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18990,4,'public','1.3.6.1.2.1.2.2.1.7.33',161,10019,'Interface 33 Admin Status','dell.6248.intf33.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18991,4,'public','1.3.6.1.2.1.2.2.1.8.33',161,10019,'Interface 33 Op Status','dell.6248.intf33.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18992,4,'public','1.3.6.1.2.1.2.2.1.16.33',161,10019,'Interface 33 Egress Traffic (Bps)','dell.6248.intf33.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18993,4,'public','1.3.6.1.2.1.2.2.1.16.33',161,10019,'Interface 33 Egress Traffic (bytes)','dell.6248.intf33.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18994,4,'public','1.3.6.1.2.1.2.2.1.19.33',161,10019,'Interface 33 Egress Discards','dell.6248.intf33.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18995,4,'public','1.3.6.1.2.1.2.2.1.20.33',161,10019,'Interface 33 Egress Errors','dell.6248.intf33.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18996,4,'public','1.3.6.1.2.1.2.2.1.18.33',161,10019,'Interface 33 Egress Traffic (Non-Unicast)','dell.6248.intf33.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18997,4,'public','1.3.6.1.2.1.2.2.1.17.33',161,10019,'Interface 33 Egress Traffic (Unicast)','dell.6248.intf33.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18998,4,'public','1.3.6.1.2.1.2.2.1.10.33',161,10019,'Interface 33 Ingress Traffic (Bps)','dell.6248.intf33.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (18999,4,'public','1.3.6.1.2.1.2.2.1.10.33',161,10019,'Interface 33 Ingress Traffic (bytes)','dell.6248.intf33.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19000,4,'public','1.3.6.1.2.1.2.2.1.13.33',161,10019,'Interface 33 Ingress Discards','dell.6248.intf33.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19001,4,'public','1.3.6.1.2.1.2.2.1.14.33',161,10019,'Interface 33 Ingress Errors','dell.6248.intf33.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19002,4,'public','1.3.6.1.2.1.2.2.1.12.33',161,10019,'Interface 33 Ingress Traffic (Non-Unicast)','dell.6248.intf33.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19003,4,'public','1.3.6.1.2.1.2.2.1.11.33',161,10019,'Interface 33 Ingress Traffic (Unicast)','dell.6248.intf33.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19004,4,'public','1.3.6.1.2.1.31.1.1.1.18.34',161,10019,'Interface 34 Description','dell.6248.intf34.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19005,4,'public','1.3.6.1.2.1.2.2.1.5.34',161,10019,'Interface 34 Speed','dell.6248.intf34.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19006,4,'public','1.3.6.1.2.1.2.2.1.7.34',161,10019,'Interface 34 Admin Status','dell.6248.intf34.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19007,4,'public','1.3.6.1.2.1.2.2.1.8.34',161,10019,'Interface 34 Op Status','dell.6248.intf34.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19008,4,'public','1.3.6.1.2.1.2.2.1.16.34',161,10019,'Interface 34 Egress Traffic (Bps)','dell.6248.intf34.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19009,4,'public','1.3.6.1.2.1.2.2.1.16.34',161,10019,'Interface 34 Egress Traffic (bytes)','dell.6248.intf34.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19010,4,'public','1.3.6.1.2.1.2.2.1.19.34',161,10019,'Interface 34 Egress Discards','dell.6248.intf34.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19011,4,'public','1.3.6.1.2.1.2.2.1.20.34',161,10019,'Interface 34 Egress Errors','dell.6248.intf34.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19012,4,'public','1.3.6.1.2.1.2.2.1.18.34',161,10019,'Interface 34 Egress Traffic (Non-Unicast)','dell.6248.intf34.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19013,4,'public','1.3.6.1.2.1.2.2.1.17.34',161,10019,'Interface 34 Egress Traffic (Unicast)','dell.6248.intf34.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19014,4,'public','1.3.6.1.2.1.2.2.1.10.34',161,10019,'Interface 34 Ingress Traffic (Bps)','dell.6248.intf34.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19015,4,'public','1.3.6.1.2.1.2.2.1.10.34',161,10019,'Interface 34 Ingress Traffic (bytes)','dell.6248.intf34.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19016,4,'public','1.3.6.1.2.1.2.2.1.13.34',161,10019,'Interface 34 Ingress Discards','dell.6248.intf34.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19017,4,'public','1.3.6.1.2.1.2.2.1.14.34',161,10019,'Interface 34 Ingress Errors','dell.6248.intf34.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19018,4,'public','1.3.6.1.2.1.2.2.1.12.34',161,10019,'Interface 34 Ingress Traffic (Non-Unicast)','dell.6248.intf34.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19019,4,'public','1.3.6.1.2.1.2.2.1.11.34',161,10019,'Interface 34 Ingress Traffic (Unicast)','dell.6248.intf34.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19020,4,'public','1.3.6.1.2.1.31.1.1.1.18.35',161,10019,'Interface 35 Description','dell.6248.intf35.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19021,4,'public','1.3.6.1.2.1.2.2.1.5.35',161,10019,'Interface 35 Speed','dell.6248.intf35.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19022,4,'public','1.3.6.1.2.1.2.2.1.7.35',161,10019,'Interface 35 Admin Status','dell.6248.intf35.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19023,4,'public','1.3.6.1.2.1.2.2.1.8.35',161,10019,'Interface 35 Op Status','dell.6248.intf35.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19024,4,'public','1.3.6.1.2.1.2.2.1.16.35',161,10019,'Interface 35 Egress Traffic (Bps)','dell.6248.intf35.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19025,4,'public','1.3.6.1.2.1.2.2.1.16.35',161,10019,'Interface 35 Egress Traffic (bytes)','dell.6248.intf35.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19026,4,'public','1.3.6.1.2.1.2.2.1.19.35',161,10019,'Interface 35 Egress Discards','dell.6248.intf35.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19027,4,'public','1.3.6.1.2.1.2.2.1.20.35',161,10019,'Interface 35 Egress Errors','dell.6248.intf35.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19028,4,'public','1.3.6.1.2.1.2.2.1.18.35',161,10019,'Interface 35 Egress Traffic (Non-Unicast)','dell.6248.intf35.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19029,4,'public','1.3.6.1.2.1.2.2.1.17.35',161,10019,'Interface 35 Egress Traffic (Unicast)','dell.6248.intf35.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19030,4,'public','1.3.6.1.2.1.2.2.1.10.35',161,10019,'Interface 35 Ingress Traffic (Bps)','dell.6248.intf35.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19031,4,'public','1.3.6.1.2.1.2.2.1.10.35',161,10019,'Interface 35 Ingress Traffic (bytes)','dell.6248.intf35.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19032,4,'public','1.3.6.1.2.1.2.2.1.13.35',161,10019,'Interface 35 Ingress Discards','dell.6248.intf35.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19033,4,'public','1.3.6.1.2.1.2.2.1.14.35',161,10019,'Interface 35 Ingress Errors','dell.6248.intf35.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19034,4,'public','1.3.6.1.2.1.2.2.1.12.35',161,10019,'Interface 35 Ingress Traffic (Non-Unicast)','dell.6248.intf35.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19035,4,'public','1.3.6.1.2.1.2.2.1.11.35',161,10019,'Interface 35 Ingress Traffic (Unicast)','dell.6248.intf35.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19036,4,'public','1.3.6.1.2.1.31.1.1.1.18.36',161,10019,'Interface 36 Description','dell.6248.intf36.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19037,4,'public','1.3.6.1.2.1.2.2.1.5.36',161,10019,'Interface 36 Speed','dell.6248.intf36.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19038,4,'public','1.3.6.1.2.1.2.2.1.7.36',161,10019,'Interface 36 Admin Status','dell.6248.intf36.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19039,4,'public','1.3.6.1.2.1.2.2.1.8.36',161,10019,'Interface 36 Op Status','dell.6248.intf36.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19040,4,'public','1.3.6.1.2.1.2.2.1.16.36',161,10019,'Interface 36 Egress Traffic (Bps)','dell.6248.intf36.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19041,4,'public','1.3.6.1.2.1.2.2.1.16.36',161,10019,'Interface 36 Egress Traffic (bytes)','dell.6248.intf36.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19042,4,'public','1.3.6.1.2.1.2.2.1.19.36',161,10019,'Interface 36 Egress Discards','dell.6248.intf36.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19043,4,'public','1.3.6.1.2.1.2.2.1.20.36',161,10019,'Interface 36 Egress Errors','dell.6248.intf36.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19044,4,'public','1.3.6.1.2.1.2.2.1.18.36',161,10019,'Interface 36 Egress Traffic (Non-Unicast)','dell.6248.intf36.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19045,4,'public','1.3.6.1.2.1.2.2.1.17.36',161,10019,'Interface 36 Egress Traffic (Unicast)','dell.6248.intf36.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19046,4,'public','1.3.6.1.2.1.2.2.1.10.36',161,10019,'Interface 36 Ingress Traffic (Bps)','dell.6248.intf36.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19047,4,'public','1.3.6.1.2.1.2.2.1.10.36',161,10019,'Interface 36 Ingress Traffic (bytes)','dell.6248.intf36.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19048,4,'public','1.3.6.1.2.1.2.2.1.13.36',161,10019,'Interface 36 Ingress Discards','dell.6248.intf36.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19049,4,'public','1.3.6.1.2.1.2.2.1.14.36',161,10019,'Interface 36 Ingress Errors','dell.6248.intf36.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19050,4,'public','1.3.6.1.2.1.2.2.1.12.36',161,10019,'Interface 36 Ingress Traffic (Non-Unicast)','dell.6248.intf36.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19051,4,'public','1.3.6.1.2.1.2.2.1.11.36',161,10019,'Interface 36 Ingress Traffic (Unicast)','dell.6248.intf36.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19052,4,'public','1.3.6.1.2.1.31.1.1.1.18.37',161,10019,'Interface 37 Description','dell.6248.intf37.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19053,4,'public','1.3.6.1.2.1.2.2.1.5.37',161,10019,'Interface 37 Speed','dell.6248.intf37.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19054,4,'public','1.3.6.1.2.1.2.2.1.7.37',161,10019,'Interface 37 Admin Status','dell.6248.intf37.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19055,4,'public','1.3.6.1.2.1.2.2.1.8.37',161,10019,'Interface 37 Op Status','dell.6248.intf37.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19056,4,'public','1.3.6.1.2.1.2.2.1.16.37',161,10019,'Interface 37 Egress Traffic (Bps)','dell.6248.intf37.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19057,4,'public','1.3.6.1.2.1.2.2.1.16.37',161,10019,'Interface 37 Egress Traffic (bytes)','dell.6248.intf37.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19058,4,'public','1.3.6.1.2.1.2.2.1.19.37',161,10019,'Interface 37 Egress Discards','dell.6248.intf37.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19059,4,'public','1.3.6.1.2.1.2.2.1.20.37',161,10019,'Interface 37 Egress Errors','dell.6248.intf37.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19060,4,'public','1.3.6.1.2.1.2.2.1.18.37',161,10019,'Interface 37 Egress Traffic (Non-Unicast)','dell.6248.intf37.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19061,4,'public','1.3.6.1.2.1.2.2.1.17.37',161,10019,'Interface 37 Egress Traffic (Unicast)','dell.6248.intf37.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19062,4,'public','1.3.6.1.2.1.2.2.1.10.37',161,10019,'Interface 37 Ingress Traffic (Bps)','dell.6248.intf37.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19063,4,'public','1.3.6.1.2.1.2.2.1.10.37',161,10019,'Interface 37 Ingress Traffic (bytes)','dell.6248.intf37.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19064,4,'public','1.3.6.1.2.1.2.2.1.13.37',161,10019,'Interface 37 Ingress Discards','dell.6248.intf37.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19065,4,'public','1.3.6.1.2.1.2.2.1.14.37',161,10019,'Interface 37 Ingress Errors','dell.6248.intf37.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19066,4,'public','1.3.6.1.2.1.2.2.1.12.37',161,10019,'Interface 37 Ingress Traffic (Non-Unicast)','dell.6248.intf37.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19067,4,'public','1.3.6.1.2.1.2.2.1.11.37',161,10019,'Interface 37 Ingress Traffic (Unicast)','dell.6248.intf37.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19068,4,'public','1.3.6.1.2.1.31.1.1.1.18.38',161,10019,'Interface 38 Description','dell.6248.intf38.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19069,4,'public','1.3.6.1.2.1.2.2.1.5.38',161,10019,'Interface 38 Speed','dell.6248.intf38.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19070,4,'public','1.3.6.1.2.1.2.2.1.7.38',161,10019,'Interface 38 Admin Status','dell.6248.intf38.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19071,4,'public','1.3.6.1.2.1.2.2.1.8.38',161,10019,'Interface 38 Op Status','dell.6248.intf38.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19072,4,'public','1.3.6.1.2.1.2.2.1.16.38',161,10019,'Interface 38 Egress Traffic (Bps)','dell.6248.intf38.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19073,4,'public','1.3.6.1.2.1.2.2.1.16.38',161,10019,'Interface 38 Egress Traffic (bytes)','dell.6248.intf38.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19074,4,'public','1.3.6.1.2.1.2.2.1.19.38',161,10019,'Interface 38 Egress Discards','dell.6248.intf38.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19075,4,'public','1.3.6.1.2.1.2.2.1.20.38',161,10019,'Interface 38 Egress Errors','dell.6248.intf38.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19076,4,'public','1.3.6.1.2.1.2.2.1.18.38',161,10019,'Interface 38 Egress Traffic (Non-Unicast)','dell.6248.intf38.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19077,4,'public','1.3.6.1.2.1.2.2.1.17.38',161,10019,'Interface 38 Egress Traffic (Unicast)','dell.6248.intf38.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19078,4,'public','1.3.6.1.2.1.2.2.1.10.38',161,10019,'Interface 38 Ingress Traffic (Bps)','dell.6248.intf38.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19079,4,'public','1.3.6.1.2.1.2.2.1.10.38',161,10019,'Interface 38 Ingress Traffic (bytes)','dell.6248.intf38.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19080,4,'public','1.3.6.1.2.1.2.2.1.13.38',161,10019,'Interface 38 Ingress Discards','dell.6248.intf38.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19081,4,'public','1.3.6.1.2.1.2.2.1.14.38',161,10019,'Interface 38 Ingress Errors','dell.6248.intf38.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19082,4,'public','1.3.6.1.2.1.2.2.1.12.38',161,10019,'Interface 38 Ingress Traffic (Non-Unicast)','dell.6248.intf38.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19083,4,'public','1.3.6.1.2.1.2.2.1.11.38',161,10019,'Interface 38 Ingress Traffic (Unicast)','dell.6248.intf38.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19084,4,'public','1.3.6.1.2.1.31.1.1.1.18.39',161,10019,'Interface 39 Description','dell.6248.intf39.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19085,4,'public','1.3.6.1.2.1.2.2.1.5.39',161,10019,'Interface 39 Speed','dell.6248.intf39.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19086,4,'public','1.3.6.1.2.1.2.2.1.7.39',161,10019,'Interface 39 Admin Status','dell.6248.intf39.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19087,4,'public','1.3.6.1.2.1.2.2.1.8.39',161,10019,'Interface 39 Op Status','dell.6248.intf39.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19088,4,'public','1.3.6.1.2.1.2.2.1.16.39',161,10019,'Interface 39 Egress Traffic (Bps)','dell.6248.intf39.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19089,4,'public','1.3.6.1.2.1.2.2.1.16.39',161,10019,'Interface 39 Egress Traffic (bytes)','dell.6248.intf39.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19090,4,'public','1.3.6.1.2.1.2.2.1.19.39',161,10019,'Interface 39 Egress Discards','dell.6248.intf39.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19091,4,'public','1.3.6.1.2.1.2.2.1.20.39',161,10019,'Interface 39 Egress Errors','dell.6248.intf39.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19092,4,'public','1.3.6.1.2.1.2.2.1.18.39',161,10019,'Interface 39 Egress Traffic (Non-Unicast)','dell.6248.intf39.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19093,4,'public','1.3.6.1.2.1.2.2.1.17.39',161,10019,'Interface 39 Egress Traffic (Unicast)','dell.6248.intf39.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19094,4,'public','1.3.6.1.2.1.2.2.1.10.39',161,10019,'Interface 39 Ingress Traffic (Bps)','dell.6248.intf39.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19095,4,'public','1.3.6.1.2.1.2.2.1.10.39',161,10019,'Interface 39 Ingress Traffic (bytes)','dell.6248.intf39.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19096,4,'public','1.3.6.1.2.1.2.2.1.13.39',161,10019,'Interface 39 Ingress Discards','dell.6248.intf39.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19097,4,'public','1.3.6.1.2.1.2.2.1.14.39',161,10019,'Interface 39 Ingress Errors','dell.6248.intf39.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19098,4,'public','1.3.6.1.2.1.2.2.1.12.39',161,10019,'Interface 39 Ingress Traffic (Non-Unicast)','dell.6248.intf39.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19099,4,'public','1.3.6.1.2.1.2.2.1.11.39',161,10019,'Interface 39 Ingress Traffic (Unicast)','dell.6248.intf39.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19100,4,'public','1.3.6.1.2.1.31.1.1.1.18.4',161,10019,'Interface 04 Description','dell.6248.intf4.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19101,4,'public','1.3.6.1.2.1.2.2.1.5.4',161,10019,'Interface 04 Speed','dell.6248.intf4.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19102,4,'public','1.3.6.1.2.1.2.2.1.7.4',161,10019,'Interface 04 Admin Status','dell.6248.intf4.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19103,4,'public','1.3.6.1.2.1.2.2.1.8.4',161,10019,'Interface 04 Op Status','dell.6248.intf4.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19104,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10019,'Interface 04 Egress Traffic (Bps)','dell.6248.intf4.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19105,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10019,'Interface 04 Egress Traffic (bytes)','dell.6248.intf4.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19106,4,'public','1.3.6.1.2.1.2.2.1.19.4',161,10019,'Interface 04 Egress Discards','dell.6248.intf4.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19107,4,'public','1.3.6.1.2.1.2.2.1.20.4',161,10019,'Interface 04 Egress Errors','dell.6248.intf4.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19108,4,'public','1.3.6.1.2.1.2.2.1.18.4',161,10019,'Interface 04 Egress Traffic (Non-Unicast)','dell.6248.intf4.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19109,4,'public','1.3.6.1.2.1.2.2.1.17.4',161,10019,'Interface 04 Egress Traffic (Unicast)','dell.6248.intf4.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19110,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10019,'Interface 04 Ingress Traffic (Bps)','dell.6248.intf4.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19111,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10019,'Interface 04 Ingress Traffic (bytes)','dell.6248.intf4.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19112,4,'public','1.3.6.1.2.1.2.2.1.13.4',161,10019,'Interface 04 Ingress Discards','dell.6248.intf4.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19113,4,'public','1.3.6.1.2.1.2.2.1.14.4',161,10019,'Interface 04 Ingress Errors','dell.6248.intf4.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19114,4,'public','1.3.6.1.2.1.2.2.1.12.4',161,10019,'Interface 04 Ingress Traffic (Non-Unicast)','dell.6248.intf4.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19115,4,'public','1.3.6.1.2.1.2.2.1.11.4',161,10019,'Interface 04 Ingress Traffic (Unicast)','dell.6248.intf4.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19116,4,'public','1.3.6.1.2.1.31.1.1.1.18.40',161,10019,'Interface 40 Description','dell.6248.intf40.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19117,4,'public','1.3.6.1.2.1.2.2.1.5.40',161,10019,'Interface 40 Speed','dell.6248.intf40.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19118,4,'public','1.3.6.1.2.1.2.2.1.7.40',161,10019,'Interface 40 Admin Status','dell.6248.intf40.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19119,4,'public','1.3.6.1.2.1.2.2.1.8.40',161,10019,'Interface 40 Op Status','dell.6248.intf40.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19120,4,'public','1.3.6.1.2.1.2.2.1.16.40',161,10019,'Interface 40 Egress Traffic (Bps)','dell.6248.intf40.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19121,4,'public','1.3.6.1.2.1.2.2.1.16.40',161,10019,'Interface 40 Egress Traffic (bytes)','dell.6248.intf40.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19122,4,'public','1.3.6.1.2.1.2.2.1.19.40',161,10019,'Interface 40 Egress Discards','dell.6248.intf40.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19123,4,'public','1.3.6.1.2.1.2.2.1.20.40',161,10019,'Interface 40 Egress Errors','dell.6248.intf40.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19124,4,'public','1.3.6.1.2.1.2.2.1.18.40',161,10019,'Interface 40 Egress Traffic (Non-Unicast)','dell.6248.intf40.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19125,4,'public','1.3.6.1.2.1.2.2.1.17.40',161,10019,'Interface 40 Egress Traffic (Unicast)','dell.6248.intf40.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19126,4,'public','1.3.6.1.2.1.2.2.1.10.40',161,10019,'Interface 40 Ingress Traffic (Bps)','dell.6248.intf40.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19127,4,'public','1.3.6.1.2.1.2.2.1.10.40',161,10019,'Interface 40 Ingress Traffic (bytes)','dell.6248.intf40.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19128,4,'public','1.3.6.1.2.1.2.2.1.13.40',161,10019,'Interface 40 Ingress Discards','dell.6248.intf40.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19129,4,'public','1.3.6.1.2.1.2.2.1.14.40',161,10019,'Interface 40 Ingress Errors','dell.6248.intf40.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19130,4,'public','1.3.6.1.2.1.2.2.1.12.40',161,10019,'Interface 40 Ingress Traffic (Non-Unicast)','dell.6248.intf40.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19131,4,'public','1.3.6.1.2.1.2.2.1.11.40',161,10019,'Interface 40 Ingress Traffic (Unicast)','dell.6248.intf40.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19132,4,'public','1.3.6.1.2.1.31.1.1.1.18.41',161,10019,'Interface 41 Description','dell.6248.intf41.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19133,4,'public','1.3.6.1.2.1.2.2.1.5.41',161,10019,'Interface 41 Speed','dell.6248.intf41.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19134,4,'public','1.3.6.1.2.1.2.2.1.7.41',161,10019,'Interface 41 Admin Status','dell.6248.intf41.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19135,4,'public','1.3.6.1.2.1.2.2.1.8.41',161,10019,'Interface 41 Op Status','dell.6248.intf41.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19136,4,'public','1.3.6.1.2.1.2.2.1.16.41',161,10019,'Interface 41 Egress Traffic (Bps)','dell.6248.intf41.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19137,4,'public','1.3.6.1.2.1.2.2.1.16.41',161,10019,'Interface 41 Egress Traffic (bytes)','dell.6248.intf41.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19138,4,'public','1.3.6.1.2.1.2.2.1.19.41',161,10019,'Interface 41 Egress Discards','dell.6248.intf41.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19139,4,'public','1.3.6.1.2.1.2.2.1.20.41',161,10019,'Interface 41 Egress Errors','dell.6248.intf41.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19140,4,'public','1.3.6.1.2.1.2.2.1.18.41',161,10019,'Interface 41 Egress Traffic (Non-Unicast)','dell.6248.intf41.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19141,4,'public','1.3.6.1.2.1.2.2.1.17.41',161,10019,'Interface 41 Egress Traffic (Unicast)','dell.6248.intf41.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19142,4,'public','1.3.6.1.2.1.2.2.1.10.41',161,10019,'Interface 41 Ingress Traffic (Bps)','dell.6248.intf41.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19143,4,'public','1.3.6.1.2.1.2.2.1.10.41',161,10019,'Interface 41 Ingress Traffic (bytes)','dell.6248.intf41.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19144,4,'public','1.3.6.1.2.1.2.2.1.13.41',161,10019,'Interface 41 Ingress Discards','dell.6248.intf41.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19145,4,'public','1.3.6.1.2.1.2.2.1.14.41',161,10019,'Interface 41 Ingress Errors','dell.6248.intf41.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19146,4,'public','1.3.6.1.2.1.2.2.1.12.41',161,10019,'Interface 41 Ingress Traffic (Non-Unicast)','dell.6248.intf41.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19147,4,'public','1.3.6.1.2.1.2.2.1.11.41',161,10019,'Interface 41 Ingress Traffic (Unicast)','dell.6248.intf41.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19148,4,'public','1.3.6.1.2.1.31.1.1.1.18.42',161,10019,'Interface 42 Description','dell.6248.intf42.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19149,4,'public','1.3.6.1.2.1.2.2.1.5.42',161,10019,'Interface 42 Speed','dell.6248.intf42.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19150,4,'public','1.3.6.1.2.1.2.2.1.7.42',161,10019,'Interface 42 Admin Status','dell.6248.intf42.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19151,4,'public','1.3.6.1.2.1.2.2.1.8.42',161,10019,'Interface 42 Op Status','dell.6248.intf42.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19152,4,'public','1.3.6.1.2.1.2.2.1.16.42',161,10019,'Interface 42 Egress Traffic (Bps)','dell.6248.intf42.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19153,4,'public','1.3.6.1.2.1.2.2.1.16.42',161,10019,'Interface 42 Egress Traffic (bytes)','dell.6248.intf42.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19154,4,'public','1.3.6.1.2.1.2.2.1.19.42',161,10019,'Interface 42 Egress Discards','dell.6248.intf42.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19155,4,'public','1.3.6.1.2.1.2.2.1.20.42',161,10019,'Interface 42 Egress Errors','dell.6248.intf42.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19156,4,'public','1.3.6.1.2.1.2.2.1.18.42',161,10019,'Interface 42 Egress Traffic (Non-Unicast)','dell.6248.intf42.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19157,4,'public','1.3.6.1.2.1.2.2.1.17.42',161,10019,'Interface 42 Egress Traffic (Unicast)','dell.6248.intf42.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19158,4,'public','1.3.6.1.2.1.2.2.1.10.42',161,10019,'Interface 42 Ingress Traffic (Bps)','dell.6248.intf42.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19159,4,'public','1.3.6.1.2.1.2.2.1.10.42',161,10019,'Interface 42 Ingress Traffic (bytes)','dell.6248.intf42.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19160,4,'public','1.3.6.1.2.1.2.2.1.13.42',161,10019,'Interface 42 Ingress Discards','dell.6248.intf42.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19161,4,'public','1.3.6.1.2.1.2.2.1.14.42',161,10019,'Interface 42 Ingress Errors','dell.6248.intf42.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19162,4,'public','1.3.6.1.2.1.2.2.1.12.42',161,10019,'Interface 42 Ingress Traffic (Non-Unicast)','dell.6248.intf42.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19163,4,'public','1.3.6.1.2.1.2.2.1.11.42',161,10019,'Interface 42 Ingress Traffic (Unicast)','dell.6248.intf42.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19164,4,'public','1.3.6.1.2.1.31.1.1.1.18.43',161,10019,'Interface 43 Description','dell.6248.intf43.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19165,4,'public','1.3.6.1.2.1.2.2.1.5.43',161,10019,'Interface 43 Speed','dell.6248.intf43.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19166,4,'public','1.3.6.1.2.1.2.2.1.7.43',161,10019,'Interface 43 Admin Status','dell.6248.intf43.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19167,4,'public','1.3.6.1.2.1.2.2.1.8.43',161,10019,'Interface 43 Op Status','dell.6248.intf43.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19168,4,'public','1.3.6.1.2.1.2.2.1.16.43',161,10019,'Interface 43 Egress Traffic (Bps)','dell.6248.intf43.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19169,4,'public','1.3.6.1.2.1.2.2.1.16.43',161,10019,'Interface 43 Egress Traffic (bytes)','dell.6248.intf43.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19170,4,'public','1.3.6.1.2.1.2.2.1.19.43',161,10019,'Interface 43 Egress Discards','dell.6248.intf43.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19171,4,'public','1.3.6.1.2.1.2.2.1.20.43',161,10019,'Interface 43 Egress Errors','dell.6248.intf43.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19172,4,'public','1.3.6.1.2.1.2.2.1.18.43',161,10019,'Interface 43 Egress Traffic (Non-Unicast)','dell.6248.intf43.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19173,4,'public','1.3.6.1.2.1.2.2.1.17.43',161,10019,'Interface 43 Egress Traffic (Unicast)','dell.6248.intf43.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19174,4,'public','1.3.6.1.2.1.2.2.1.10.43',161,10019,'Interface 43 Ingress Traffic (Bps)','dell.6248.intf43.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19175,4,'public','1.3.6.1.2.1.2.2.1.10.43',161,10019,'Interface 43 Ingress Traffic (bytes)','dell.6248.intf43.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19176,4,'public','1.3.6.1.2.1.2.2.1.13.43',161,10019,'Interface 43 Ingress Discards','dell.6248.intf43.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19177,4,'public','1.3.6.1.2.1.2.2.1.14.43',161,10019,'Interface 43 Ingress Errors','dell.6248.intf43.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19178,4,'public','1.3.6.1.2.1.2.2.1.12.43',161,10019,'Interface 43 Ingress Traffic (Non-Unicast)','dell.6248.intf43.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19179,4,'public','1.3.6.1.2.1.2.2.1.11.43',161,10019,'Interface 43 Ingress Traffic (Unicast)','dell.6248.intf43.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19180,4,'public','1.3.6.1.2.1.31.1.1.1.18.44',161,10019,'Interface 44 Description','dell.6248.intf44.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19181,4,'public','1.3.6.1.2.1.2.2.1.5.44',161,10019,'Interface 44 Speed','dell.6248.intf44.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19182,4,'public','1.3.6.1.2.1.2.2.1.7.44',161,10019,'Interface 44 Admin Status','dell.6248.intf44.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19183,4,'public','1.3.6.1.2.1.2.2.1.8.44',161,10019,'Interface 44 Op Status','dell.6248.intf44.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19184,4,'public','1.3.6.1.2.1.2.2.1.16.44',161,10019,'Interface 44 Egress Traffic (Bps)','dell.6248.intf44.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19185,4,'public','1.3.6.1.2.1.2.2.1.16.44',161,10019,'Interface 44 Egress Traffic (bytes)','dell.6248.intf44.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19186,4,'public','1.3.6.1.2.1.2.2.1.19.44',161,10019,'Interface 44 Egress Discards','dell.6248.intf44.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19187,4,'public','1.3.6.1.2.1.2.2.1.20.44',161,10019,'Interface 44 Egress Errors','dell.6248.intf44.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19188,4,'public','1.3.6.1.2.1.2.2.1.18.44',161,10019,'Interface 44 Egress Traffic (Non-Unicast)','dell.6248.intf44.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19189,4,'public','1.3.6.1.2.1.2.2.1.17.44',161,10019,'Interface 44 Egress Traffic (Unicast)','dell.6248.intf44.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19190,4,'public','1.3.6.1.2.1.2.2.1.10.44',161,10019,'Interface 44 Ingress Traffic (Bps)','dell.6248.intf44.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19191,4,'public','1.3.6.1.2.1.2.2.1.10.44',161,10019,'Interface 44 Ingress Traffic (bytes)','dell.6248.intf44.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19192,4,'public','1.3.6.1.2.1.2.2.1.13.44',161,10019,'Interface 44 Ingress Discards','dell.6248.intf44.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19193,4,'public','1.3.6.1.2.1.2.2.1.14.44',161,10019,'Interface 44 Ingress Errors','dell.6248.intf44.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19194,4,'public','1.3.6.1.2.1.2.2.1.12.44',161,10019,'Interface 44 Ingress Traffic (Non-Unicast)','dell.6248.intf44.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19195,4,'public','1.3.6.1.2.1.2.2.1.11.44',161,10019,'Interface 44 Ingress Traffic (Unicast)','dell.6248.intf44.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19196,4,'public','1.3.6.1.2.1.31.1.1.1.18.45',161,10019,'Interface 45 Description','dell.6248.intf45.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19197,4,'public','1.3.6.1.2.1.2.2.1.5.45',161,10019,'Interface 45 Speed','dell.6248.intf45.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19198,4,'public','1.3.6.1.2.1.2.2.1.7.45',161,10019,'Interface 45 Admin Status','dell.6248.intf45.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19199,4,'public','1.3.6.1.2.1.2.2.1.8.45',161,10019,'Interface 45 Op Status','dell.6248.intf45.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19200,4,'public','1.3.6.1.2.1.2.2.1.16.45',161,10019,'Interface 45 Egress Traffic (Bps)','dell.6248.intf45.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19201,4,'public','1.3.6.1.2.1.2.2.1.16.45',161,10019,'Interface 45 Egress Traffic (bytes)','dell.6248.intf45.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19202,4,'public','1.3.6.1.2.1.2.2.1.19.45',161,10019,'Interface 45 Egress Discards','dell.6248.intf45.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19203,4,'public','1.3.6.1.2.1.2.2.1.20.45',161,10019,'Interface 45 Egress Errors','dell.6248.intf45.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19204,4,'public','1.3.6.1.2.1.2.2.1.18.45',161,10019,'Interface 45 Egress Traffic (Non-Unicast)','dell.6248.intf45.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19205,4,'public','1.3.6.1.2.1.2.2.1.17.45',161,10019,'Interface 45 Egress Traffic (Unicast)','dell.6248.intf45.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19206,4,'public','1.3.6.1.2.1.2.2.1.10.45',161,10019,'Interface 45 Ingress Traffic (Bps)','dell.6248.intf45.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19207,4,'public','1.3.6.1.2.1.2.2.1.10.45',161,10019,'Interface 45 Ingress Traffic (bytes)','dell.6248.intf45.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19208,4,'public','1.3.6.1.2.1.2.2.1.13.45',161,10019,'Interface 45 Ingress Discards','dell.6248.intf45.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19209,4,'public','1.3.6.1.2.1.2.2.1.14.45',161,10019,'Interface 45 Ingress Errors','dell.6248.intf45.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19210,4,'public','1.3.6.1.2.1.2.2.1.12.45',161,10019,'Interface 45 Ingress Traffic (Non-Unicast)','dell.6248.intf45.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19211,4,'public','1.3.6.1.2.1.2.2.1.11.45',161,10019,'Interface 45 Ingress Traffic (Unicast)','dell.6248.intf45.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19212,4,'public','1.3.6.1.2.1.31.1.1.1.18.46',161,10019,'Interface 46 Description','dell.6248.intf46.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19213,4,'public','1.3.6.1.2.1.2.2.1.5.46',161,10019,'Interface 46 Speed','dell.6248.intf46.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19214,4,'public','1.3.6.1.2.1.2.2.1.7.46',161,10019,'Interface 46 Admin Status','dell.6248.intf46.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19215,4,'public','1.3.6.1.2.1.2.2.1.8.46',161,10019,'Interface 46 Op Status','dell.6248.intf46.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19216,4,'public','1.3.6.1.2.1.2.2.1.16.46',161,10019,'Interface 46 Egress Traffic (Bps)','dell.6248.intf46.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19217,4,'public','1.3.6.1.2.1.2.2.1.16.46',161,10019,'Interface 46 Egress Traffic (bytes)','dell.6248.intf46.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19218,4,'public','1.3.6.1.2.1.2.2.1.19.46',161,10019,'Interface 46 Egress Discards','dell.6248.intf46.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19219,4,'public','1.3.6.1.2.1.2.2.1.20.46',161,10019,'Interface 46 Egress Errors','dell.6248.intf46.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19220,4,'public','1.3.6.1.2.1.2.2.1.18.46',161,10019,'Interface 46 Egress Traffic (Non-Unicast)','dell.6248.intf46.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19221,4,'public','1.3.6.1.2.1.2.2.1.17.46',161,10019,'Interface 46 Egress Traffic (Unicast)','dell.6248.intf46.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19222,4,'public','1.3.6.1.2.1.2.2.1.10.46',161,10019,'Interface 46 Ingress Traffic (Bps)','dell.6248.intf46.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19223,4,'public','1.3.6.1.2.1.2.2.1.10.46',161,10019,'Interface 46 Ingress Traffic (bytes)','dell.6248.intf46.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19224,4,'public','1.3.6.1.2.1.2.2.1.13.46',161,10019,'Interface 46 Ingress Discards','dell.6248.intf46.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19225,4,'public','1.3.6.1.2.1.2.2.1.14.46',161,10019,'Interface 46 Ingress Errors','dell.6248.intf46.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19226,4,'public','1.3.6.1.2.1.2.2.1.12.46',161,10019,'Interface 46 Ingress Traffic (Non-Unicast)','dell.6248.intf46.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19227,4,'public','1.3.6.1.2.1.2.2.1.11.46',161,10019,'Interface 46 Ingress Traffic (Unicast)','dell.6248.intf46.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19228,4,'public','1.3.6.1.2.1.31.1.1.1.18.47',161,10019,'Interface 47 Description','dell.6248.intf47.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19229,4,'public','1.3.6.1.2.1.2.2.1.5.47',161,10019,'Interface 47 Speed','dell.6248.intf47.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19230,4,'public','1.3.6.1.2.1.2.2.1.7.47',161,10019,'Interface 47 Admin Status','dell.6248.intf47.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19231,4,'public','1.3.6.1.2.1.2.2.1.8.47',161,10019,'Interface 47 Op Status','dell.6248.intf47.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19232,4,'public','1.3.6.1.2.1.2.2.1.16.47',161,10019,'Interface 47 Egress Traffic (Bps)','dell.6248.intf47.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19233,4,'public','1.3.6.1.2.1.2.2.1.16.47',161,10019,'Interface 47 Egress Traffic (bytes)','dell.6248.intf47.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19234,4,'public','1.3.6.1.2.1.2.2.1.19.47',161,10019,'Interface 47 Egress Discards','dell.6248.intf47.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19235,4,'public','1.3.6.1.2.1.2.2.1.20.47',161,10019,'Interface 47 Egress Errors','dell.6248.intf47.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19236,4,'public','1.3.6.1.2.1.2.2.1.18.47',161,10019,'Interface 47 Egress Traffic (Non-Unicast)','dell.6248.intf47.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19237,4,'public','1.3.6.1.2.1.2.2.1.17.47',161,10019,'Interface 47 Egress Traffic (Unicast)','dell.6248.intf47.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19238,4,'public','1.3.6.1.2.1.2.2.1.10.47',161,10019,'Interface 47 Ingress Traffic (Bps)','dell.6248.intf47.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19239,4,'public','1.3.6.1.2.1.2.2.1.10.47',161,10019,'Interface 47 Ingress Traffic (bytes)','dell.6248.intf47.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19240,4,'public','1.3.6.1.2.1.2.2.1.13.47',161,10019,'Interface 47 Ingress Discards','dell.6248.intf47.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19241,4,'public','1.3.6.1.2.1.2.2.1.14.47',161,10019,'Interface 47 Ingress Errors','dell.6248.intf47.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19242,4,'public','1.3.6.1.2.1.2.2.1.12.47',161,10019,'Interface 47 Ingress Traffic (Non-Unicast)','dell.6248.intf47.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19243,4,'public','1.3.6.1.2.1.2.2.1.11.47',161,10019,'Interface 47 Ingress Traffic (Unicast)','dell.6248.intf47.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19244,4,'public','1.3.6.1.2.1.31.1.1.1.18.48',161,10019,'Interface 48 Description','dell.6248.intf48.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19245,4,'public','1.3.6.1.2.1.2.2.1.5.48',161,10019,'Interface 48 Speed','dell.6248.intf48.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19246,4,'public','1.3.6.1.2.1.2.2.1.7.48',161,10019,'Interface 48 Admin Status','dell.6248.intf48.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19247,4,'public','1.3.6.1.2.1.2.2.1.8.48',161,10019,'Interface 48 Op Status','dell.6248.intf48.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19248,4,'public','1.3.6.1.2.1.2.2.1.16.48',161,10019,'Interface 48 Egress Traffic (Bps)','dell.6248.intf48.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19249,4,'public','1.3.6.1.2.1.2.2.1.16.48',161,10019,'Interface 48 Egress Traffic (bytes)','dell.6248.intf48.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19250,4,'public','1.3.6.1.2.1.2.2.1.19.48',161,10019,'Interface 48 Egress Discards','dell.6248.intf48.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19251,4,'public','1.3.6.1.2.1.2.2.1.20.48',161,10019,'Interface 48 Egress Errors','dell.6248.intf48.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19252,4,'public','1.3.6.1.2.1.2.2.1.18.48',161,10019,'Interface 48 Egress Traffic (Non-Unicast)','dell.6248.intf48.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19253,4,'public','1.3.6.1.2.1.2.2.1.17.48',161,10019,'Interface 48 Egress Traffic (Unicast)','dell.6248.intf48.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19254,4,'public','1.3.6.1.2.1.2.2.1.10.48',161,10019,'Interface 48 Ingress Traffic (Bps)','dell.6248.intf48.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19255,4,'public','1.3.6.1.2.1.2.2.1.10.48',161,10019,'Interface 48 Ingress Traffic (bytes)','dell.6248.intf48.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19256,4,'public','1.3.6.1.2.1.2.2.1.13.48',161,10019,'Interface 48 Ingress Discards','dell.6248.intf48.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19257,4,'public','1.3.6.1.2.1.2.2.1.14.48',161,10019,'Interface 48 Ingress Errors','dell.6248.intf48.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19258,4,'public','1.3.6.1.2.1.2.2.1.12.48',161,10019,'Interface 48 Ingress Traffic (Non-Unicast)','dell.6248.intf48.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19259,4,'public','1.3.6.1.2.1.2.2.1.11.48',161,10019,'Interface 48 Ingress Traffic (Unicast)','dell.6248.intf48.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19260,4,'public','1.3.6.1.2.1.31.1.1.1.18.49',161,10019,'Interface 49 Description','dell.6248.intf49.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19261,4,'public','1.3.6.1.2.1.2.2.1.5.49',161,10019,'Interface 49 Speed','dell.6248.intf49.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19262,4,'public','1.3.6.1.2.1.2.2.1.7.49',161,10019,'Interface 49 Admin Status','dell.6248.intf49.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19263,4,'public','1.3.6.1.2.1.2.2.1.8.49',161,10019,'Interface 49 Op Status','dell.6248.intf49.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19264,4,'public','1.3.6.1.2.1.2.2.1.16.49',161,10019,'Interface 49 Egress Traffic (Bps)','dell.6248.intf49.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19265,4,'public','1.3.6.1.2.1.2.2.1.16.49',161,10019,'Interface 49 Egress Traffic (bytes)','dell.6248.intf49.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19266,4,'public','1.3.6.1.2.1.2.2.1.19.49',161,10019,'Interface 49 Egress Discards','dell.6248.intf49.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19267,4,'public','1.3.6.1.2.1.2.2.1.20.49',161,10019,'Interface 49 Egress Errors','dell.6248.intf49.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19268,4,'public','1.3.6.1.2.1.2.2.1.18.49',161,10019,'Interface 49 Egress Traffic (Non-Unicast)','dell.6248.intf49.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19269,4,'public','1.3.6.1.2.1.2.2.1.17.49',161,10019,'Interface 49 Egress Traffic (Unicast)','dell.6248.intf49.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19270,4,'public','1.3.6.1.2.1.2.2.1.10.49',161,10019,'Interface 49 Ingress Traffic (Bps)','dell.6248.intf49.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19271,4,'public','1.3.6.1.2.1.2.2.1.10.49',161,10019,'Interface 49 Ingress Traffic (bytes)','dell.6248.intf49.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19272,4,'public','1.3.6.1.2.1.2.2.1.13.49',161,10019,'Interface 49 Ingress Discards','dell.6248.intf49.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19273,4,'public','1.3.6.1.2.1.2.2.1.14.49',161,10019,'Interface 49 Ingress Errors','dell.6248.intf49.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19274,4,'public','1.3.6.1.2.1.2.2.1.12.49',161,10019,'Interface 49 Ingress Traffic (Non-Unicast)','dell.6248.intf49.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19275,4,'public','1.3.6.1.2.1.2.2.1.11.49',161,10019,'Interface 49 Ingress Traffic (Unicast)','dell.6248.intf49.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19276,4,'public','1.3.6.1.2.1.31.1.1.1.18.5',161,10019,'Interface 05 Description','dell.6248.intf5.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19277,4,'public','1.3.6.1.2.1.2.2.1.5.5',161,10019,'Interface 05 Speed','dell.6248.intf5.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19278,4,'public','1.3.6.1.2.1.2.2.1.7.5',161,10019,'Interface 05 Admin Status','dell.6248.intf5.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19279,4,'public','1.3.6.1.2.1.2.2.1.8.5',161,10019,'Interface 05 Op Status','dell.6248.intf5.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19280,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10019,'Interface 05 Egress Traffic (Bps)','dell.6248.intf5.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19281,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10019,'Interface 05 Egress Traffic (bytes)','dell.6248.intf5.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19282,4,'public','1.3.6.1.2.1.2.2.1.19.5',161,10019,'Interface 05 Egress Discards','dell.6248.intf5.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19283,4,'public','1.3.6.1.2.1.2.2.1.20.5',161,10019,'Interface 05 Egress Errors','dell.6248.intf5.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19284,4,'public','1.3.6.1.2.1.2.2.1.18.5',161,10019,'Interface 05 Egress Traffic (Non-Unicast)','dell.6248.intf5.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19285,4,'public','1.3.6.1.2.1.2.2.1.17.5',161,10019,'Interface 05 Egress Traffic (Unicast)','dell.6248.intf5.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19286,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10019,'Interface 05 Ingress Traffic (Bps)','dell.6248.intf5.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19287,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10019,'Interface 05 Ingress Traffic (bytes)','dell.6248.intf5.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19288,4,'public','1.3.6.1.2.1.2.2.1.13.5',161,10019,'Interface 05 Ingress Discards','dell.6248.intf5.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19289,4,'public','1.3.6.1.2.1.2.2.1.14.5',161,10019,'Interface 05 Ingress Errors','dell.6248.intf5.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19290,4,'public','1.3.6.1.2.1.2.2.1.12.5',161,10019,'Interface 05 Ingress Traffic (Non-Unicast)','dell.6248.intf5.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19291,4,'public','1.3.6.1.2.1.2.2.1.11.5',161,10019,'Interface 05 Ingress Traffic (Unicast)','dell.6248.intf5.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19292,4,'public','1.3.6.1.2.1.31.1.1.1.18.50',161,10019,'Interface 50 Description','dell.6248.intf50.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19293,4,'public','1.3.6.1.2.1.2.2.1.5.50',161,10019,'Interface 50 Speed','dell.6248.intf50.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19294,4,'public','1.3.6.1.2.1.2.2.1.7.50',161,10019,'Interface 50 Admin Status','dell.6248.intf50.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19295,4,'public','1.3.6.1.2.1.2.2.1.8.50',161,10019,'Interface 50 Op Status','dell.6248.intf50.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19296,4,'public','1.3.6.1.2.1.2.2.1.16.50',161,10019,'Interface 50 Egress Traffic (Bps)','dell.6248.intf50.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19297,4,'public','1.3.6.1.2.1.2.2.1.16.50',161,10019,'Interface 50 Egress Traffic (bytes)','dell.6248.intf50.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19298,4,'public','1.3.6.1.2.1.2.2.1.19.50',161,10019,'Interface 50 Egress Discards','dell.6248.intf50.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19299,4,'public','1.3.6.1.2.1.2.2.1.20.50',161,10019,'Interface 50 Egress Errors','dell.6248.intf50.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19300,4,'public','1.3.6.1.2.1.2.2.1.18.50',161,10019,'Interface 50 Egress Traffic (Non-Unicast)','dell.6248.intf50.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19301,4,'public','1.3.6.1.2.1.2.2.1.17.50',161,10019,'Interface 50 Egress Traffic (Unicast)','dell.6248.intf50.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19302,4,'public','1.3.6.1.2.1.2.2.1.10.50',161,10019,'Interface 50 Ingress Traffic (Bps)','dell.6248.intf50.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19303,4,'public','1.3.6.1.2.1.2.2.1.10.50',161,10019,'Interface 50 Ingress Traffic (bytes)','dell.6248.intf50.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19304,4,'public','1.3.6.1.2.1.2.2.1.13.50',161,10019,'Interface 50 Ingress Discards','dell.6248.intf50.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19305,4,'public','1.3.6.1.2.1.2.2.1.14.50',161,10019,'Interface 50 Ingress Errors','dell.6248.intf50.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19306,4,'public','1.3.6.1.2.1.2.2.1.12.50',161,10019,'Interface 50 Ingress Traffic (Non-Unicast)','dell.6248.intf50.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19307,4,'public','1.3.6.1.2.1.2.2.1.11.50',161,10019,'Interface 50 Ingress Traffic (Unicast)','dell.6248.intf50.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19308,4,'public','1.3.6.1.2.1.31.1.1.1.18.51',161,10019,'Interface 51 Description','dell.6248.intf51.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19309,4,'public','1.3.6.1.2.1.2.2.1.5.51',161,10019,'Interface 51 Speed','dell.6248.intf51.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19310,4,'public','1.3.6.1.2.1.2.2.1.7.51',161,10019,'Interface 51 Admin Status','dell.6248.intf51.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19311,4,'public','1.3.6.1.2.1.2.2.1.8.51',161,10019,'Interface 51 Op Status','dell.6248.intf51.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19312,4,'public','1.3.6.1.2.1.2.2.1.16.51',161,10019,'Interface 51 Egress Traffic (Bps)','dell.6248.intf51.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19313,4,'public','1.3.6.1.2.1.2.2.1.16.51',161,10019,'Interface 51 Egress Traffic (bytes)','dell.6248.intf51.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19314,4,'public','1.3.6.1.2.1.2.2.1.19.51',161,10019,'Interface 51 Egress Discards','dell.6248.intf51.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19315,4,'public','1.3.6.1.2.1.2.2.1.20.51',161,10019,'Interface 51 Egress Errors','dell.6248.intf51.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19316,4,'public','1.3.6.1.2.1.2.2.1.18.51',161,10019,'Interface 51 Egress Traffic (Non-Unicast)','dell.6248.intf51.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19317,4,'public','1.3.6.1.2.1.2.2.1.17.51',161,10019,'Interface 51 Egress Traffic (Unicast)','dell.6248.intf51.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19318,4,'public','1.3.6.1.2.1.2.2.1.10.51',161,10019,'Interface 51 Ingress Traffic (Bps)','dell.6248.intf51.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19319,4,'public','1.3.6.1.2.1.2.2.1.10.51',161,10019,'Interface 51 Ingress Traffic (bytes)','dell.6248.intf51.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19320,4,'public','1.3.6.1.2.1.2.2.1.13.51',161,10019,'Interface 51 Ingress Discards','dell.6248.intf51.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19321,4,'public','1.3.6.1.2.1.2.2.1.14.51',161,10019,'Interface 51 Ingress Errors','dell.6248.intf51.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19322,4,'public','1.3.6.1.2.1.2.2.1.12.51',161,10019,'Interface 51 Ingress Traffic (Non-Unicast)','dell.6248.intf51.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19323,4,'public','1.3.6.1.2.1.2.2.1.11.51',161,10019,'Interface 51 Ingress Traffic (Unicast)','dell.6248.intf51.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19324,4,'public','1.3.6.1.2.1.31.1.1.1.18.52',161,10019,'Interface 52 Description','dell.6248.intf52.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19325,4,'public','1.3.6.1.2.1.2.2.1.5.52',161,10019,'Interface 52 Speed','dell.6248.intf52.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19326,4,'public','1.3.6.1.2.1.2.2.1.7.52',161,10019,'Interface 52 Admin Status','dell.6248.intf52.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19327,4,'public','1.3.6.1.2.1.2.2.1.8.52',161,10019,'Interface 52 Op Status','dell.6248.intf52.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19328,4,'public','1.3.6.1.2.1.2.2.1.16.52',161,10019,'Interface 52 Egress Traffic (Bps)','dell.6248.intf52.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19329,4,'public','1.3.6.1.2.1.2.2.1.16.52',161,10019,'Interface 52 Egress Traffic (bytes)','dell.6248.intf52.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19330,4,'public','1.3.6.1.2.1.2.2.1.19.52',161,10019,'Interface 52 Egress Discards','dell.6248.intf52.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19331,4,'public','1.3.6.1.2.1.2.2.1.20.52',161,10019,'Interface 52 Egress Errors','dell.6248.intf52.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19332,4,'public','1.3.6.1.2.1.2.2.1.18.52',161,10019,'Interface 52 Egress Traffic (Non-Unicast)','dell.6248.intf52.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19333,4,'public','1.3.6.1.2.1.2.2.1.17.52',161,10019,'Interface 52 Egress Traffic (Unicast)','dell.6248.intf52.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19334,4,'public','1.3.6.1.2.1.2.2.1.10.52',161,10019,'Interface 52 Ingress Traffic (Bps)','dell.6248.intf52.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19335,4,'public','1.3.6.1.2.1.2.2.1.10.52',161,10019,'Interface 52 Ingress Traffic (bytes)','dell.6248.intf52.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19336,4,'public','1.3.6.1.2.1.2.2.1.13.52',161,10019,'Interface 52 Ingress Discards','dell.6248.intf52.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19337,4,'public','1.3.6.1.2.1.2.2.1.14.52',161,10019,'Interface 52 Ingress Errors','dell.6248.intf52.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19338,4,'public','1.3.6.1.2.1.2.2.1.12.52',161,10019,'Interface 52 Ingress Traffic (Non-Unicast)','dell.6248.intf52.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19339,4,'public','1.3.6.1.2.1.2.2.1.11.52',161,10019,'Interface 52 Ingress Traffic (Unicast)','dell.6248.intf52.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19340,4,'public','1.3.6.1.2.1.31.1.1.1.18.6',161,10019,'Interface 06 Description','dell.6248.intf6.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19341,4,'public','1.3.6.1.2.1.2.2.1.5.6',161,10019,'Interface 06 Speed','dell.6248.intf6.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19342,4,'public','1.3.6.1.2.1.2.2.1.7.6',161,10019,'Interface 06 Admin Status','dell.6248.intf6.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19343,4,'public','1.3.6.1.2.1.2.2.1.8.6',161,10019,'Interface 06 Op Status','dell.6248.intf6.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19344,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10019,'Interface 06 Egress Traffic (Bps)','dell.6248.intf6.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19345,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10019,'Interface 06 Egress Traffic (bytes)','dell.6248.intf6.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19346,4,'public','1.3.6.1.2.1.2.2.1.19.6',161,10019,'Interface 06 Egress Discards','dell.6248.intf6.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19347,4,'public','1.3.6.1.2.1.2.2.1.20.6',161,10019,'Interface 06 Egress Errors','dell.6248.intf6.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19348,4,'public','1.3.6.1.2.1.2.2.1.18.6',161,10019,'Interface 06 Egress Traffic (Non-Unicast)','dell.6248.intf6.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19349,4,'public','1.3.6.1.2.1.2.2.1.17.6',161,10019,'Interface 06 Egress Traffic (Unicast)','dell.6248.intf6.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19350,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10019,'Interface 06 Ingress Traffic (Bps)','dell.6248.intf6.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19351,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10019,'Interface 06 Ingress Traffic (bytes)','dell.6248.intf6.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19352,4,'public','1.3.6.1.2.1.2.2.1.13.6',161,10019,'Interface 06 Ingress Discards','dell.6248.intf6.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19353,4,'public','1.3.6.1.2.1.2.2.1.14.6',161,10019,'Interface 06 Ingress Errors','dell.6248.intf6.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19354,4,'public','1.3.6.1.2.1.2.2.1.12.6',161,10019,'Interface 06 Ingress Traffic (Non-Unicast)','dell.6248.intf6.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19355,4,'public','1.3.6.1.2.1.2.2.1.11.6',161,10019,'Interface 06 Ingress Traffic (Unicast)','dell.6248.intf6.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19356,4,'public','1.3.6.1.2.1.31.1.1.1.18.7',161,10019,'Interface 07 Description','dell.6248.intf7.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19357,4,'public','1.3.6.1.2.1.2.2.1.5.7',161,10019,'Interface 07 Speed','dell.6248.intf7.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19358,4,'public','1.3.6.1.2.1.2.2.1.7.7',161,10019,'Interface 07 Admin Status','dell.6248.intf7.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19359,4,'public','1.3.6.1.2.1.2.2.1.8.7',161,10019,'Interface 07 Op Status','dell.6248.intf7.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19360,4,'public','1.3.6.1.2.1.2.2.1.16.7',161,10019,'Interface 07 Egress Traffic (Bps)','dell.6248.intf7.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19361,4,'public','1.3.6.1.2.1.2.2.1.16.7',161,10019,'Interface 07 Egress Traffic (bytes)','dell.6248.intf7.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19362,4,'public','1.3.6.1.2.1.2.2.1.19.7',161,10019,'Interface 07 Egress Discards','dell.6248.intf7.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19363,4,'public','1.3.6.1.2.1.2.2.1.20.7',161,10019,'Interface 07 Egress Errors','dell.6248.intf7.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19364,4,'public','1.3.6.1.2.1.2.2.1.18.7',161,10019,'Interface 07 Egress Traffic (Non-Unicast)','dell.6248.intf7.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19365,4,'public','1.3.6.1.2.1.2.2.1.17.7',161,10019,'Interface 07 Egress Traffic (Unicast)','dell.6248.intf7.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19366,4,'public','1.3.6.1.2.1.2.2.1.10.7',161,10019,'Interface 07 Ingress Traffic (Bps)','dell.6248.intf7.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19367,4,'public','1.3.6.1.2.1.2.2.1.10.7',161,10019,'Interface 07 Ingress Traffic (bytes)','dell.6248.intf7.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19368,4,'public','1.3.6.1.2.1.2.2.1.13.7',161,10019,'Interface 07 Ingress Discards','dell.6248.intf7.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19369,4,'public','1.3.6.1.2.1.2.2.1.14.7',161,10019,'Interface 07 Ingress Errors','dell.6248.intf7.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19370,4,'public','1.3.6.1.2.1.2.2.1.12.7',161,10019,'Interface 07 Ingress Traffic (Non-Unicast)','dell.6248.intf7.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19371,4,'public','1.3.6.1.2.1.2.2.1.11.7',161,10019,'Interface 07 Ingress Traffic (Unicast)','dell.6248.intf7.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19372,4,'public','1.3.6.1.2.1.31.1.1.1.18.8',161,10019,'Interface 08 Description','dell.6248.intf8.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19373,4,'public','1.3.6.1.2.1.2.2.1.5.8',161,10019,'Interface 08 Speed','dell.6248.intf8.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19374,4,'public','1.3.6.1.2.1.2.2.1.7.8',161,10019,'Interface 08 Admin Status','dell.6248.intf8.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19375,4,'public','1.3.6.1.2.1.2.2.1.8.8',161,10019,'Interface 08 Op Status','dell.6248.intf8.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19376,4,'public','1.3.6.1.2.1.2.2.1.16.8',161,10019,'Interface 08 Egress Traffic (Bps)','dell.6248.intf8.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19377,4,'public','1.3.6.1.2.1.2.2.1.16.8',161,10019,'Interface 08 Egress Traffic (bytes)','dell.6248.intf8.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19378,4,'public','1.3.6.1.2.1.2.2.1.19.8',161,10019,'Interface 08 Egress Discards','dell.6248.intf8.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19379,4,'public','1.3.6.1.2.1.2.2.1.20.8',161,10019,'Interface 08 Egress Errors','dell.6248.intf8.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19380,4,'public','1.3.6.1.2.1.2.2.1.18.8',161,10019,'Interface 08 Egress Traffic (Non-Unicast)','dell.6248.intf8.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19381,4,'public','1.3.6.1.2.1.2.2.1.17.8',161,10019,'Interface 08 Egress Traffic (Unicast)','dell.6248.intf8.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19382,4,'public','1.3.6.1.2.1.2.2.1.10.8',161,10019,'Interface 08 Ingress Traffic (Bps)','dell.6248.intf8.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19383,4,'public','1.3.6.1.2.1.2.2.1.10.8',161,10019,'Interface 08 Ingress Traffic (bytes)','dell.6248.intf8.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19384,4,'public','1.3.6.1.2.1.2.2.1.13.8',161,10019,'Interface 08 Ingress Discards','dell.6248.intf8.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19385,4,'public','1.3.6.1.2.1.2.2.1.14.8',161,10019,'Interface 08 Ingress Errors','dell.6248.intf8.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19386,4,'public','1.3.6.1.2.1.2.2.1.12.8',161,10019,'Interface 08 Ingress Traffic (Non-Unicast)','dell.6248.intf8.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19387,4,'public','1.3.6.1.2.1.2.2.1.11.8',161,10019,'Interface 08 Ingress Traffic (Unicast)','dell.6248.intf8.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19388,4,'public','1.3.6.1.2.1.31.1.1.1.18.9',161,10019,'Interface 09 Description','dell.6248.intf9.description',120,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19389,4,'public','1.3.6.1.2.1.2.2.1.5.9',161,10019,'Interface 09 Speed','dell.6248.intf9.speed',90,90,365,NULL,NULL,NULL,0,3,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19390,4,'public','1.3.6.1.2.1.2.2.1.7.9',161,10019,'Interface 09 Admin Status','dell.6248.intf9.status.admin',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19391,4,'public','1.3.6.1.2.1.2.2.1.8.9',161,10019,'Interface 09 Op Status','dell.6248.intf9.status.operational',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19392,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10019,'Interface 09 Egress Traffic (Bps)','dell.6248.intf9.traffic.egress.Bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19393,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10019,'Interface 09 Egress Traffic (bytes)','dell.6248.intf9.traffic.egress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19394,4,'public','1.3.6.1.2.1.2.2.1.19.9',161,10019,'Interface 09 Egress Discards','dell.6248.intf9.traffic.egress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19395,4,'public','1.3.6.1.2.1.2.2.1.20.9',161,10019,'Interface 09 Egress Errors','dell.6248.intf9.traffic.egress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19396,4,'public','1.3.6.1.2.1.2.2.1.18.9',161,10019,'Interface 09 Egress Traffic (Non-Unicast)','dell.6248.intf9.traffic.egress.nonunicast',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19397,4,'public','1.3.6.1.2.1.2.2.1.17.9',161,10019,'Interface 09 Egress Traffic (Unicast)','dell.6248.intf9.traffic.egress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19398,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10019,'Interface 09 Ingress Traffic (Bps)','dell.6248.intf9.traffic.ingress.bps',10,365,365,NULL,NULL,NULL,0,3,'','Bps',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19399,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10019,'Interface 09 Ingress Traffic (bytes)','dell.6248.intf9.traffic.ingress.bytes',60,365,365,NULL,NULL,NULL,0,3,'','bytes',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19400,4,'public','1.3.6.1.2.1.2.2.1.13.9',161,10019,'Interface 09 Ingress Discards','dell.6248.intf9.traffic.ingress.discards',60,90,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19401,4,'public','1.3.6.1.2.1.2.2.1.14.9',161,10019,'Interface 09 Ingress Errors','dell.6248.intf9.traffic.ingress.errors',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19402,4,'public','1.3.6.1.2.1.2.2.1.12.9',161,10019,'Interface 09 Ingress Traffic (Non-Unicast)','dell.6248.intf9.traffic.ingress.nonunicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19403,4,'public','1.3.6.1.2.1.2.2.1.11.9',161,10019,'Interface 09 Ingress Traffic (Unicast)','dell.6248.intf9.traffic.ingress.unicast',60,365,365,NULL,NULL,NULL,0,3,'','packets',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19404,1,'public','.1.3.6.1.4.1.318.1.1.1.2.2.2.0',161,10020,'APC: Battery Temperature','upsAdvBatteryTemperature',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19405,1,'public','.1.3.6.1.4.1.318.1.1.1.4.2.4.0',161,10020,'APC: Load Current (Amps)','upsAdvOutputCurrent',30,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19406,1,'public','.1.3.6.1.4.1.318.1.1.1.4.2.3.0',161,10020,'APC: Output Load (%)','upsAdvOutputLoad',30,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19407,1,'public','.1.3.6.1.4.1.318.1.1.1.2.2.4.0',161,10020,'APC: Replace Battery Indicator','upsAdvReplaceBatteryIndicator',600,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,4,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19408,1,'public','.1.3.6.1.4.1.318.1.1.1.2.2.3.0',161,10020,'APC: Run Time Remaining','upsAdvRunTimeRemaining',30,7,365,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19409,1,'public','.1.3.6.1.4.1.318.1.1.1.2.1.1.0',161,10020,'APC: Battery Status','upsBasicBatteryStatus',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,5,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19410,1,'public','.1.3.6.1.4.1.318.1.1.1.2.1.2.0',161,10020,'APC: Time On Battery','upsBasicBatteryTimeOnBattery',30,7,365,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19411,4,'public','.1.3.6.1.4.1.232.3.2.2.1.1.6.0',161,10021,'HW: Disk Controller 1 Status','HPcontrollerRollupStatus.1',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19412,4,'public','.1.3.6.1.4.1.232.3.2.2.1.1.6.1',161,10021,'HW: Disk Controller 2 Status','HPcontrollerRollupStatus.2',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19413,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.0.1',161,10021,'HW: Logical Disk 0.1 Status','HPenclosureRollupStatus0.1',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19414,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.0.2',161,10021,'HW: Logical Disk 0.2 Status','HPenclosureRollupStatus0.2',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19415,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.1.1',161,10021,'HW: Logical Disk 1.1 Status','HPenclosureRollupStatus1.1',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19416,4,'public','.1.3.6.1.4.1.232.3.2.3.1.1.11.1.2',161,10021,'HW: Logical Disk 1.2 Status','HPenclosureRollupStatus1.2',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19417,4,'public','.1.3.6.1.4.1.232.2.1.3.0',161,10021,'HW: Chassis Status','HPsystemStateChassisStatus',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19418,4,'public','.1.3.6.1.4.1.232.6.2.6.1.0',161,10021,'HW: Fan Unit Status','HPsystemStateCoolingUnitStatusCombined',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19419,4,'public','.1.3.6.1.4.1.232.6.1.3.0',161,10021,'HW: Global System Status','HPsystemStateGlobalSystemStatus',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19420,4,'public','.1.3.6.1.4.1.232.6.2.14.4.0',161,10021,'HW: Memory Status','HPsystemStateMemoryDeviceStatusCombined',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19421,4,'public','.1.3.6.1.4.1.232.6.2.9.1.0',161,10021,'HW: Power Supply Status','HPsystemStatePowerSupplyStatusCombined',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19422,4,'public','.1.3.6.1.4.1.232.6.2.6.3.0',161,10021,'HW: Temperature Status','HPsystemStateTemperatureStatusCombined',240,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,6,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19423,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.1.1.37.1',161,10022,'OM: Disk Controller 1 Status','controllerRollupStatus.1',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19424,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.1.1.37.2',161,10022,'OM: Disk Controller 2 Status','controllerRollupStatus.2',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19425,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.3.1.23.1',161,10022,'OM: Disk Enclosure 1 Status','enclosureRollupStatus.1',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19426,1,'public','.1.3.6.1.4.1.674.10893.1.20.130.3.1.23.2',161,10022,'OM: Disk Enclosure 2 Status','enclosureRollupStatus.2',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19427,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.30.1',161,10022,'OM: Chassis Intrusion Status','systemStateChassisIntrusionStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19428,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.4.1',161,10022,'OM: Chassis Status','systemStateChassisStatus',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19429,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.21.1',161,10022,'OM: Fan Status','systemStateCoolingDeviceStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19430,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.44.1',161,10022,'OM: Fan Unit Status','systemStateCoolingUnitStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19431,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.41.1',161,10022,'OM: Event Log Status','systemStateEventLogStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19432,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.2.1',161,10022,'OM: Global System Status','systemStateGlobalSystemStatus',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19433,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.27.1',161,10022,'OM: Memory Status','systemStateMemoryDeviceStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19434,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.9.1',161,10022,'OM: Power Supply Status','systemStatePowerSupplyStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19435,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.50.1',161,10022,'OM: Processor Status','systemStateProcessorDeviceStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19436,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.24.1',161,10022,'OM: Temperature Status','systemStateTeperatureStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19437,1,'public','.1.3.6.1.4.1.674.10892.1.200.10.1.12.1',161,10022,'OM: Voltage Status','systemStateVoltageStatusCombined',30,7,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,7,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19438,1,'public','.1.3.6.1.4.1.9.9.147.1.2.2.2.1.5.40.6',161,10023,'Connections','Connections',60,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19439,1,'public','interfaces.ifTable.ifEntry.ifInOctets.1',161,10023,'Available Free Processor Memory','FreeProcMem',60,90,365,NULL,NULL,NULL,0,3,'','b',0,0,NULL,'',0,'','','8','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19440,1,'public','.1.3.6.1.2.1.1.1.0',161,10023,'Host_Infomation','Host_Infomation',3600,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19441,3,'','',161,10023,'Ping Check','icmpping',30,30,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19442,1,'public','.1.3.6.1.2.1.2.2.1.10.2',161,10023,'Inside ifInBytes','Inside_ifInBytes',60,90,365,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19443,1,'public','.1.3.6.1.2.1.2.2.1.16.2',161,10023,'Inside ifOutBytes','Inside_ifOutBytes',60,90,365,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19444,1,'public','.1.3.6.1.2.1.2.2.1.10.1',161,10023,'Outside ifInBytes','Outside_ifInBytes',60,90,365,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19445,1,'public','.1.3.6.1.2.1.2.2.1.16.1',161,10023,'Outside ifOutBytes','Outside_ifOutBytes',60,90,365,NULL,NULL,NULL,0,0,'','b',1,1,NULL,'',0,'','','8','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19446,1,'public','.1.3.6.1.2.1.1.3.0',161,10023,'Uptime','Uptime',30,90,365,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19447,1,'public','..1.3.6.1.4.1.674.10892.1.700.20.1.6.1.5',161,10024,'Back plain temperature','dell_bp_temp',60,7,365,NULL,NULL,NULL,0,0,'','C',1,0,NULL,'',0,'','','.1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19448,1,'public','.1.3.6.1.4.1.674.10892.1.700.20.1.6.1.1',161,10024,'Main board temperature','dell_mb_temp',60,7,365,NULL,NULL,NULL,0,0,'','C',1,0,NULL,'',0,'','','.1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19449,1,'public','ifInErrors.1',161,10025,'Port 1 Traffic IN Errors','ifInErrors.1',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19450,1,'public','ifInErrors.10',161,10025,'Port 10 Traffic IN Errors','ifInErrors.10',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19451,1,'public','ifInErrors.11',161,10025,'Port 11 Traffic IN Errors','ifInErrors.11',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19452,1,'public','ifInErrors.12',161,10025,'Port 12 Traffic IN Errors','ifInErrors.12',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19453,1,'public','ifInErrors.13',161,10025,'Port 13 Traffic IN Errors','ifInErrors.13',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19454,1,'public','ifInErrors.14',161,10025,'Port 14 Traffic IN Errors','ifInErrors.14',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19455,1,'public','ifInErrors.15',161,10025,'Port 15 Traffic IN Errors','ifInErrors.15',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19456,1,'public','ifInErrors.16',161,10025,'Port 16 Traffic IN Errors','ifInErrors.16',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19457,1,'public','ifInErrors.17',161,10025,'Port 17 Traffic IN Errors','ifInErrors.17',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19458,1,'public','ifInErrors.18',161,10025,'Port 18 Traffic IN Errors','ifInErrors.18',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19459,1,'public','ifInErrors.19',161,10025,'Port 19 Traffic IN Errors','ifInErrors.19',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19460,1,'public','ifInErrors.2',161,10025,'Port 2 Traffic IN Errors','ifInErrors.2',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19461,1,'public','ifInErrors.20',161,10025,'Port 20 Traffic IN Errors','ifInErrors.20',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19462,1,'public','ifInErrors.21',161,10025,'Port 21 Traffic IN Errors','ifInErrors.21',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19463,1,'public','ifInErrors.22',161,10025,'Port 22 Traffic IN Errors','ifInErrors.22',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19464,1,'public','ifInErrors.23',161,10025,'Port 23 Traffic IN Errors','ifInErrors.23',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19465,1,'public','ifInErrors.24',161,10025,'Port 24 Traffic IN Errors','ifInErrors.24',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19466,1,'public','ifInErrors.3',161,10025,'Port 3 Traffic IN Errors','ifInErrors.3',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19467,1,'public','ifInErrors.4',161,10025,'Port 4 Traffic IN Errors','ifInErrors.4',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19468,1,'public','ifInErrors.5',161,10025,'Port 5 Traffic IN Errors','ifInErrors.5',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19469,1,'public','ifInErrors.6',161,10025,'Port 6 Traffic IN Errors','ifInErrors.6',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19470,1,'public','ifInErrors.7',161,10025,'Port 7 Traffic IN Errors','ifInErrors.7',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19471,1,'public','ifInErrors.8',161,10025,'Port 8 Traffic IN Errors','ifInErrors.8',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19472,1,'public','ifInErrors.9',161,10025,'Port 9 Traffic IN Errors','ifInErrors.9',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19473,1,'public','ifInOctets.1',161,10025,'Port 1 Traffic IN ','ifInOctects.1',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19474,1,'public','ifInOctets.10',161,10025,'Port 10 Traffic IN ','ifInOctects.10',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19475,1,'public','ifInOctets.11',161,10025,'Port 11 Traffic IN ','ifInOctects.11',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19476,1,'public','ifInOctets.12',161,10025,'Port 12 Traffic IN ','ifInOctects.12',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19477,1,'public','ifInOctets.13',161,10025,'Port 13 Traffic IN ','ifInOctects.13',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19478,1,'public','ifInOctets.14',161,10025,'Port 14 Traffic IN ','ifInOctects.14',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19479,1,'public','ifInOctets.15',161,10025,'Port 15 Traffic IN ','ifInOctects.15',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19480,1,'public','ifInOctets.16',161,10025,'Port 16 Traffic IN ','ifInOctects.16',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19481,1,'public','ifInOctets.17',161,10025,'Port 17 Traffic IN ','ifInOctects.17',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19482,1,'public','ifInOctets.18',161,10025,'Port 18 Traffic IN ','ifInOctects.18',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19483,1,'public','ifInOctets.19',161,10025,'Port 19 Traffic IN ','ifInOctects.19',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19484,1,'public','ifInOctets.2',161,10025,'Port 2 Traffic IN ','ifInOctects.2',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19485,1,'public','ifInOctets.20',161,10025,'Port 20 Traffic IN ','ifInOctects.20',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19486,1,'public','ifInOctets.21',161,10025,'Port 21 Traffic IN ','ifInOctects.21',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19487,1,'public','ifInOctets.22',161,10025,'Port 22 Traffic IN ','ifInOctects.22',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19488,1,'public','ifInOctets.23',161,10025,'Port 23 Traffic IN ','ifInOctects.23',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19489,1,'public','ifInOctets.24',161,10025,'Port 24 Traffic IN ','ifInOctects.24',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19490,1,'public','ifInOctets.3',161,10025,'Port 3 Traffic IN ','ifInOctects.3',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19491,1,'public','ifInOctets.4',161,10025,'Port 4 Traffic IN ','ifInOctects.4',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19492,1,'public','ifInOctets.5',161,10025,'Port 5 Traffic IN ','ifInOctects.5',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19493,1,'public','ifInOctets.6',161,10025,'Port 6 Traffic IN ','ifInOctects.6',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19494,1,'public','ifInOctets.7',161,10025,'Port 7 Traffic IN ','ifInOctects.7',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19495,1,'public','ifInOctets.8',161,10025,'Port 8 Traffic IN ','ifInOctects.8',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19496,1,'public','ifInOctets.9',161,10025,'Port 9 Traffic IN ','ifInOctects.9',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19497,1,'public','ifLastChange.1',161,10025,'Port 1 Last Changed','ifLastChange.1',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19498,1,'public','ifLastChange.10',161,10025,'Port 10 Last Changed','ifLastChange.10',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19499,1,'public','ifLastChange.11',161,10025,'Port 11 Last Changed','ifLastChange.11',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19500,1,'public','ifLastChange.12',161,10025,'Port 12 Last Changed','ifLastChange.12',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19501,1,'public','ifLastChange.13',161,10025,'Port 13 Last Changed','ifLastChange.13',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19502,1,'public','ifLastChange.14',161,10025,'Port 14 Last Changed','ifLastChange.14',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19503,1,'public','ifLastChange.15',161,10025,'Port 15 Last Changed','ifLastChange.15',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19504,1,'public','ifLastChange.16',161,10025,'Port 16 Last Changed','ifLastChange.16',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19505,1,'public','ifLastChange.17',161,10025,'Port 17 Last Changed','ifLastChange.17',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19506,1,'public','ifLastChange.18',161,10025,'Port 18 Last Changed','ifLastChange.18',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19507,1,'public','ifLastChange.19',161,10025,'Port 19 Last Changed','ifLastChange.19',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19508,1,'public','ifLastChange.2',161,10025,'Port 2 Last Changed','ifLastChange.2',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19509,1,'public','ifLastChange.20',161,10025,'Port 20 Last Changed','ifLastChange.20',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19510,1,'public','ifLastChange.21',161,10025,'Port 21 Last Changed','ifLastChange.21',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19511,1,'public','ifLastChange.22',161,10025,'Port 22 Last Changed','ifLastChange.22',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19512,1,'public','ifLastChange.23',161,10025,'Port 23 Last Changed','ifLastChange.23',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19513,1,'public','ifLastChange.24',161,10025,'Port 24 Last Changed','ifLastChange.24',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19514,1,'public','ifLastChange.3',161,10025,'Port 3 Last Changed','ifLastChange.3',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19515,1,'public','ifLastChange.4',161,10025,'Port 4 Last Changed','ifLastChange.4',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19516,1,'public','ifLastChange.5',161,10025,'Port 5 Last Changed','ifLastChange.5',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19517,1,'public','ifLastChange.6',161,10025,'Port 6 Last Changed','ifLastChange.6',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19518,1,'public','ifLastChange.7',161,10025,'Port 7 Last Changed','ifLastChange.7',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19519,1,'public','ifLastChange.8',161,10025,'Port 8 Last Changed','ifLastChange.8',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19520,1,'public','ifLastChange.9',161,10025,'Port 9 Last Changed','ifLastChange.9',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19521,1,'public','ifOperStatus.1',161,10025,'Port 1 Status','ifOperStatus.1',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19522,1,'public','ifOperStatus.10',161,10025,'Port 10 Status','ifOperStatus.10',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19523,1,'public','ifOperStatus.11',161,10025,'Port 11 Status','ifOperStatus.11',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19524,1,'public','ifOperStatus.12',161,10025,'Port 12 Status','ifOperStatus.12',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19525,1,'public','ifOperStatus.13',161,10025,'Port 13 Status','ifOperStatus.13',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19526,1,'public','ifOperStatus.14',161,10025,'Port 14 Status','ifOperStatus.14',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19527,1,'public','ifOperStatus.15',161,10025,'Port 15 Status','ifOperStatus.15',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19528,1,'public','ifOperStatus.16',161,10025,'Port 16 Status','ifOperStatus.16',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19529,1,'public','ifOperStatus.17',161,10025,'Port 17 Status','ifOperStatus.17',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19530,1,'public','ifOperStatus.18',161,10025,'Port 18 Status','ifOperStatus.18',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19531,1,'public','ifOperStatus.19',161,10025,'Port 19 Status','ifOperStatus.19',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19532,1,'public','ifOperStatus.2',161,10025,'Port 2 Status','ifOperStatus.2',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19533,1,'public','ifOperStatus.20',161,10025,'Port 20 Status','ifOperStatus.20',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19534,1,'public','ifOperStatus.21',161,10025,'Port 21 Status','ifOperStatus.21',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19535,1,'public','ifOperStatus.22',161,10025,'Port 22 Status','ifOperStatus.22',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19536,1,'public','ifOperStatus.23',161,10025,'Port 23 Status','ifOperStatus.23',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19537,1,'public','ifOperStatus.24',161,10025,'Port 24 Status','ifOperStatus.24',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19538,1,'public','ifOperStatus.3',161,10025,'Port 3 Status','ifOperStatus.3',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19539,1,'public','ifOperStatus.4',161,10025,'Port 4 Status','ifOperStatus.4',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19540,1,'public','ifOperStatus.5',161,10025,'Port 5 Status','ifOperStatus.5',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19541,1,'public','ifOperStatus.6',161,10025,'Port 6 Status','ifOperStatus.6',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19542,1,'public','ifOperStatus.7',161,10025,'Port 7 Status','ifOperStatus.7',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19543,1,'public','ifOperStatus.8',161,10025,'Port 8 Status','ifOperStatus.8',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19544,1,'public','ifOperStatus.9',161,10025,'Port 9 Status','ifOperStatus.9',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19545,1,'public','ifOutErrors.1',161,10025,'Port 1 Traffic OUT Errors','ifOutErrors.1',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19546,1,'public','ifOutErrors.10',161,10025,'Port 10 Traffic OUT Errors','ifOutErrors.10',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19547,1,'public','ifOutErrors.11',161,10025,'Port 11 Traffic OUT Errors','ifOutErrors.11',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19548,1,'public','ifOutErrors.12',161,10025,'Port 12 Traffic OUT Errors','ifOutErrors.12',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19549,1,'public','ifOutErrors.13',161,10025,'Port 13 Traffic OUT Errors','ifOutErrors.13',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19550,1,'public','ifOutErrors.14',161,10025,'Port 14 Traffic OUT Errors','ifOutErrors.14',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19551,1,'public','ifOutErrors.15',161,10025,'Port 15 Traffic OUT Errors','ifOutErrors.15',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19552,1,'public','ifOutErrors.16',161,10025,'Port 16 Traffic OUT Errors','ifOutErrors.16',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19553,1,'public','ifOutErrors.17',161,10025,'Port 17 Traffic OUT Errors','ifOutErrors.17',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19554,1,'public','ifOutErrors.18',161,10025,'Port 18 Traffic OUT Errors','ifOutErrors.18',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19555,1,'public','ifOutErrors.19',161,10025,'Port 19 Traffic OUT Errors','ifOutErrors.19',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19556,1,'public','ifOutErrors.2',161,10025,'Port 2 Traffic OUT Errors','ifOutErrors.2',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19557,1,'public','ifOutErrors.20',161,10025,'Port 20 Traffic OUT Errors','ifOutErrors.20',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19558,1,'public','ifOutErrors.21',161,10025,'Port 21 Traffic OUT Errors','ifOutErrors.21',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19559,1,'public','ifOutErrors.22',161,10025,'Port 22 Traffic OUT Errors','ifOutErrors.22',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19560,1,'public','ifOutErrors.23',161,10025,'Port 23 Traffic OUT Errors','ifOutErrors.23',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19561,1,'public','ifOutErrors.24',161,10025,'Port 24 Traffic OUT Errors','ifOutErrors.24',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19562,1,'public','ifOutErrors.3',161,10025,'Port 3 Traffic OUT Errors','ifOutErrors.3',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19563,1,'public','ifOutErrors.4',161,10025,'Port 4 Traffic OUT Errors','ifOutErrors.4',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19564,1,'public','ifOutErrors.5',161,10025,'Port 5 Traffic OUT Errors','ifOutErrors.5',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19565,1,'public','ifOutErrors.6',161,10025,'Port 6 Traffic OUT Errors','ifOutErrors.6',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19566,1,'public','ifOutErrors.7',161,10025,'Port 7 Traffic OUT Errors','ifOutErrors.7',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19567,1,'public','ifOutErrors.8',161,10025,'Port 8 Traffic OUT Errors','ifOutErrors.8',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19568,1,'public','ifOutErrors.9',161,10025,'Port 9 Traffic OUT Errors','ifOutErrors.9',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19569,1,'public','ifOutOctets.1',161,10025,'Port 1 Traffic OUT ','ifOutOctets.1',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19570,1,'public','ifOutOctets.10',161,10025,'Port 10 Traffic OUT ','ifOutOctets.10',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19571,1,'public','ifOutOctets.11',161,10025,'Port 11 Traffic OUT ','ifOutOctets.11',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19572,1,'public','ifOutOctets.12',161,10025,'Port 12 Traffic OUT ','ifOutOctets.12',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19573,1,'public','ifOutOctets.13',161,10025,'Port 13 Traffic OUT ','ifOutOctets.13',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19574,1,'public','ifOutOctets.14',161,10025,'Port 14 Traffic OUT ','ifOutOctets.14',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19575,1,'public','ifOutOctets.15',161,10025,'Port 15 Traffic OUT ','ifOutOctets.15',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19576,1,'public','ifOutOctets.16',161,10025,'Port 16 Traffic OUT ','ifOutOctets.16',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19577,1,'public','ifOutOctets.17',161,10025,'Port 17 Traffic OUT ','ifOutOctets.17',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19578,1,'public','ifOutOctets.18',161,10025,'Port 18 Traffic OUT ','ifOutOctets.18',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19579,1,'public','ifOutOctets.19',161,10025,'Port 19 Traffic OUT ','ifOutOctets.19',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19580,1,'public','ifOutOctets.2',161,10025,'Port 2 Traffic OUT ','ifOutOctets.2',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19581,1,'public','ifOutOctets.20',161,10025,'Port 20 Traffic OUT ','ifOutOctets.20',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19582,1,'public','ifOutOctets.21',161,10025,'Port 21 Traffic OUT ','ifOutOctets.21',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19583,1,'public','ifOutOctets.22',161,10025,'Port 22 Traffic OUT ','ifOutOctets.22',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19584,1,'public','ifOutOctets.23',161,10025,'Port 23 Traffic OUT ','ifOutOctets.23',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19585,1,'public','ifOutOctets.24',161,10025,'Port 24 Traffic OUT ','ifOutOctets.24',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19586,1,'public','ifOutOctets.3',161,10025,'Port 3 Traffic OUT ','ifOutOctets.3',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19587,1,'public','ifOutOctets.4',161,10025,'Port 4 Traffic OUT ','ifOutOctets.4',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19588,1,'public','ifOutOctets.5',161,10025,'Port 5 Traffic OUT ','ifOutOctets.5',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19589,1,'public','ifOutOctets.6',161,10025,'Port 6 Traffic OUT ','ifOutOctets.6',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19590,1,'public','ifOutOctets.7',161,10025,'Port 7 Traffic OUT ','ifOutOctets.7',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19591,1,'public','ifOutOctets.8',161,10025,'Port 8 Traffic OUT ','ifOutOctets.8',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19592,1,'public','ifOutOctets.9',161,10025,'Port 9 Traffic OUT ','ifOutOctets.9',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19593,1,'public','ifSpeed.1',161,10025,'Port 1 Speed','ifspeed.1',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19594,1,'public','ifSpeed.10',161,10025,'Port 10 Speed','ifspeed.10',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19595,1,'public','ifSpeed.11',161,10025,'Port 11 Speed','ifspeed.11',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19596,1,'public','ifSpeed.12',161,10025,'Port 12 Speed','ifspeed.12',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19597,1,'public','ifSpeed.13',161,10025,'Port 13 Speed','ifspeed.13',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19598,1,'public','ifSpeed.14',161,10025,'Port 14 Speed','ifspeed.14',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19599,1,'public','ifSpeed.15',161,10025,'Port 15 Speed','ifspeed.15',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19600,1,'public','ifSpeed.16',161,10025,'Port 16 Speed','ifspeed.16',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19601,1,'public','ifSpeed.17',161,10025,'Port 17 Speed','ifspeed.17',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19602,1,'public','ifSpeed.18',161,10025,'Port 18 Speed','ifspeed.18',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19603,1,'public','ifSpeed.19',161,10025,'Port 19 Speed','ifspeed.19',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19604,1,'public','ifSpeed.2',161,10025,'Port 2 Speed','ifspeed.2',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19605,1,'public','ifSpeed.20',161,10025,'Port 20 Speed','ifspeed.20',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19606,1,'public','ifSpeed.21',161,10025,'Port 21 Speed','ifspeed.21',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19607,1,'public','ifSpeed.22',161,10025,'Port 22 Speed','ifspeed.22',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19608,1,'public','ifSpeed.23',161,10025,'Port 23 Speed','ifspeed.23',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19609,1,'public','ifSpeed.24',161,10025,'Port 24 Speed','ifspeed.24',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19610,1,'public','ifSpeed.3',161,10025,'Port 3 Speed','ifspeed.3',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19611,1,'public','ifSpeed.4',161,10025,'Port 4 Speed','ifspeed.4',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19612,1,'public','ifSpeed.5',161,10025,'Port 5 Speed','ifspeed.5',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19613,1,'public','ifSpeed.6',161,10025,'Port 6 Speed','ifspeed.6',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19614,1,'public','ifSpeed.7',161,10025,'Port 7 Speed','ifspeed.7',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19615,1,'public','ifSpeed.8',161,10025,'Port 8 Speed','ifspeed.8',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19616,1,'public','ifSpeed.9',161,10025,'Port 9 Speed','ifspeed.9',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19617,1,'public','ifInErrors.101',161,10026,'Port 1 Traffic IN Errors','ifInErrors.101',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19618,1,'public','ifInErrors.110',161,10026,'Port 10 Traffic IN Errors','ifInErrors.110',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19619,1,'public','ifInErrors.111',161,10026,'Port 11 Traffic IN Errors','ifInErrors.111',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19620,1,'public','ifInErrors.112',161,10026,'Port 12 Traffic IN Errors','ifInErrors.112',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19621,1,'public','ifInErrors.113',161,10026,'Port 13 Traffic IN Errors','ifInErrors.113',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19622,1,'public','ifInErrors.114',161,10026,'Port 14 Traffic IN Errors','ifInErrors.114',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19623,1,'public','ifInErrors.115',161,10026,'Port 15 Traffic IN Errors','ifInErrors.115',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19624,1,'public','ifInErrors.116',161,10026,'Port 16 Traffic IN Errors','ifInErrors.116',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19625,1,'public','ifInErrors.117',161,10026,'Port 17 Traffic IN Errors','ifInErrors.117',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19626,1,'public','ifInErrors.118',161,10026,'Port 18 Traffic IN Errors','ifInErrors.118',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19627,1,'public','ifInErrors.119',161,10026,'Port 19 Traffic IN Errors','ifInErrors.119',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19628,1,'public','ifInErrors.102',161,10026,'Port 2 Traffic IN Errors','ifInErrors.102',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19629,1,'public','ifInErrors.120',161,10026,'Port 20 Traffic IN Errors','ifInErrors.120',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19630,1,'public','ifInErrors.121',161,10026,'Port 21 Traffic IN Errors','ifInErrors.121',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19631,1,'public','ifInErrors.122',161,10026,'Port 22 Traffic IN Errors','ifInErrors.122',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19632,1,'public','ifInErrors.123',161,10026,'Port 23 Traffic IN Errors','ifInErrors.123',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19633,1,'public','ifInErrors.124',161,10026,'Port 24 Traffic IN Errors','ifInErrors.124',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19634,1,'public','ifInErrors.125',161,10026,'Port 25 Traffic IN Errors','ifInErrors.125',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19635,1,'public','ifInErrors.103',161,10026,'Port 3 Traffic IN Errors','ifInErrors.103',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19636,1,'public','ifInErrors.104',161,10026,'Port 4 Traffic IN Errors','ifInErrors.104',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19637,1,'public','ifInErrors.105',161,10026,'Port 5 Traffic IN Errors','ifInErrors.105',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19638,1,'public','ifInErrors.106',161,10026,'Port 6 Traffic IN Errors','ifInErrors.106',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19639,1,'public','ifInErrors.107',161,10026,'Port 7 Traffic IN Errors','ifInErrors.107',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19640,1,'public','ifInErrors.108',161,10026,'Port 8 Traffic IN Errors','ifInErrors.108',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19641,1,'public','ifInErrors.109',161,10026,'Port 9 Traffic IN Errors','ifInErrors.109',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19642,1,'public','ifInOctets.101',161,10026,'Port 1 Traffic IN ','ifInOctects.101',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19643,1,'public','ifInOctets.110',161,10026,'Port 10 Traffic IN ','ifInOctects.110',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19644,1,'public','ifInOctets.111',161,10026,'Port 11 Traffic IN ','ifInOctects.111',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19645,1,'public','ifInOctets.112',161,10026,'Port 12 Traffic IN ','ifInOctects.112',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19646,1,'public','ifInOctets.113',161,10026,'Port 13 Traffic IN ','ifInOctects.113',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19647,1,'public','ifInOctets.114',161,10026,'Port 14 Traffic IN ','ifInOctects.114',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19648,1,'public','ifInOctets.115',161,10026,'Port 15 Traffic IN ','ifInOctects.115',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19649,1,'public','ifInOctets.116',161,10026,'Port 16 Traffic IN ','ifInOctects.116',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19650,1,'public','ifInOctets.117',161,10026,'Port 17 Traffic IN ','ifInOctects.117',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19651,1,'public','ifInOctets.118',161,10026,'Port 18 Traffic IN ','ifInOctects.118',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19652,1,'public','ifInOctets.119',161,10026,'Port 19 Traffic IN ','ifInOctects.119',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19653,1,'public','ifInOctets.102',161,10026,'Port 2 Traffic IN ','ifInOctects.102',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19654,1,'public','ifInOctets.120',161,10026,'Port 20 Traffic IN ','ifInOctects.120',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19655,1,'public','ifInOctets.121',161,10026,'Port 21 Traffic IN ','ifInOctects.121',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19656,1,'public','ifInOctets.122',161,10026,'Port 22 Traffic IN ','ifInOctects.122',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19657,1,'public','ifInOctets.123',161,10026,'Port 23 Traffic IN ','ifInOctects.123',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19658,1,'public','ifInOctets.124',161,10026,'Port 24 Traffic IN ','ifInOctects.124',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19659,1,'public','ifInOctets.125',161,10026,'Port 25 Traffic IN ','ifInOctects.125',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19660,1,'public','ifInOctets.103',161,10026,'Port 3 Traffic IN ','ifInOctects.103',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19661,1,'public','ifInOctets.104',161,10026,'Port 4 Traffic IN ','ifInOctects.104',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19662,1,'public','ifInOctets.105',161,10026,'Port 5 Traffic IN ','ifInOctects.105',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19663,1,'public','ifInOctets.106',161,10026,'Port 6 Traffic IN ','ifInOctects.106',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19664,1,'public','ifInOctets.107',161,10026,'Port 7 Traffic IN ','ifInOctects.107',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19665,1,'public','ifInOctets.108',161,10026,'Port 8 Traffic IN ','ifInOctects.108',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19666,1,'public','ifInOctets.109',161,10026,'Port 9 Traffic IN ','ifInOctects.109',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19667,1,'public','ifLastChange.101',161,10026,'Port 1 Last Changed','ifLastChange.101',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19668,1,'public','ifLastChange.110',161,10026,'Port 10 Last Changed','ifLastChange.110',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19669,1,'public','ifLastChange.111',161,10026,'Port 11 Last Changed','ifLastChange.111',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19670,1,'public','ifLastChange.112',161,10026,'Port 12 Last Changed','ifLastChange.112',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19671,1,'public','ifLastChange.113',161,10026,'Port 13 Last Changed','ifLastChange.113',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19672,1,'public','ifLastChange.114',161,10026,'Port 14 Last Changed','ifLastChange.114',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19673,1,'public','ifLastChange.115',161,10026,'Port 15 Last Changed','ifLastChange.115',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19674,1,'public','ifLastChange.116',161,10026,'Port 16 Last Changed','ifLastChange.116',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19675,1,'public','ifLastChange.117',161,10026,'Port 17 Last Changed','ifLastChange.117',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19676,1,'public','ifLastChange.118',161,10026,'Port 18 Last Changed','ifLastChange.118',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19677,1,'public','ifLastChange.119',161,10026,'Port 19 Last Changed','ifLastChange.119',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19678,1,'public','ifLastChange.102',161,10026,'Port 2 Last Changed','ifLastChange.102',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19679,1,'public','ifLastChange.120',161,10026,'Port 20 Last Changed','ifLastChange.120',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19680,1,'public','ifLastChange.121',161,10026,'Port 21 Last Changed','ifLastChange.121',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19681,1,'public','ifLastChange.122',161,10026,'Port 22 Last Changed','ifLastChange.122',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19682,1,'public','ifLastChange.123',161,10026,'Port 23 Last Changed','ifLastChange.123',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19683,1,'public','ifLastChange.124',161,10026,'Port 24 Last Changed','ifLastChange.124',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19684,1,'public','ifLastChange.125',161,10026,'Port 25 Last Changed','ifLastChange.125',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19685,1,'public','ifLastChange.103',161,10026,'Port 3 Last Changed','ifLastChange.103',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19686,1,'public','ifLastChange.104',161,10026,'Port 4 Last Changed','ifLastChange.104',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19687,1,'public','ifLastChange.105',161,10026,'Port 5 Last Changed','ifLastChange.105',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19688,1,'public','ifLastChange.106',161,10026,'Port 6 Last Changed','ifLastChange.106',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19689,1,'public','ifLastChange.107',161,10026,'Port 7 Last Changed','ifLastChange.107',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19690,1,'public','ifLastChange.108',161,10026,'Port 8 Last Changed','ifLastChange.108',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19691,1,'public','ifLastChange.109',161,10026,'Port 9 Last Changed','ifLastChange.109',30,90,365,NULL,NULL,NULL,0,3,'','uptime',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19692,1,'public','ifOperStatus.101',161,10026,'Port 1 Status','ifOperStatus.101',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19693,1,'public','ifOperStatus.110',161,10026,'Port 10 Status','ifOperStatus.110',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19694,1,'public','ifOperStatus.111',161,10026,'Port 11 Status','ifOperStatus.111',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19695,1,'public','ifOperStatus.112',161,10026,'Port 12 Status','ifOperStatus.112',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19696,1,'public','ifOperStatus.113',161,10026,'Port 13 Status','ifOperStatus.113',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19697,1,'public','ifOperStatus.114',161,10026,'Port 14 Status','ifOperStatus.114',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19698,1,'public','ifOperStatus.115',161,10026,'Port 15 Status','ifOperStatus.115',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19699,1,'public','ifOperStatus.116',161,10026,'Port 16 Status','ifOperStatus.116',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19700,1,'public','ifOperStatus.117',161,10026,'Port 17 Status','ifOperStatus.117',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19701,1,'public','ifOperStatus.118',161,10026,'Port 18 Status','ifOperStatus.118',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19702,1,'public','ifOperStatus.119',161,10026,'Port 19 Status','ifOperStatus.119',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19703,1,'public','ifOperStatus.102',161,10026,'Port 2 Status','ifOperStatus.102',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19704,1,'public','ifOperStatus.120',161,10026,'Port 20 Status','ifOperStatus.120',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19705,1,'public','ifOperStatus.121',161,10026,'Port 21 Status','ifOperStatus.121',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19706,1,'public','ifOperStatus.122',161,10026,'Port 22 Status','ifOperStatus.122',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19707,1,'public','ifOperStatus.123',161,10026,'Port 23 Status','ifOperStatus.123',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19708,1,'public','ifOperStatus.124',161,10026,'Port 24 Status','ifOperStatus.124',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19709,1,'public','ifOperStatus.125',161,10026,'Port 25 Status','ifOperStatus.125',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19710,1,'public','ifOperStatus.103',161,10026,'Port 3 Status','ifOperStatus.103',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19711,1,'public','ifOperStatus.104',161,10026,'Port 4 Status','ifOperStatus.104',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19712,1,'public','ifOperStatus.105',161,10026,'Port 5 Status','ifOperStatus.105',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19713,1,'public','ifOperStatus.106',161,10026,'Port 6 Status','ifOperStatus.106',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19714,1,'public','ifOperStatus.107',161,10026,'Port 7 Status','ifOperStatus.107',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19715,1,'public','ifOperStatus.108',161,10026,'Port 8 Status','ifOperStatus.108',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19716,1,'public','ifOperStatus.109',161,10026,'Port 9 Status','ifOperStatus.109',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19717,1,'public','ifOutErrors.101',161,10026,'Port 1 Traffic OUT Errors','ifOutErrors.101',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19718,1,'public','ifOutErrors.110',161,10026,'Port 10 Traffic OUT Errors','ifOutErrors.110',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19719,1,'public','ifOutErrors.111',161,10026,'Port 11 Traffic OUT Errors','ifOutErrors.111',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19720,1,'public','ifOutErrors.112',161,10026,'Port 12 Traffic OUT Errors','ifOutErrors.112',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19721,1,'public','ifOutErrors.113',161,10026,'Port 13 Traffic OUT Errors','ifOutErrors.113',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19722,1,'public','ifOutErrors.114',161,10026,'Port 14 Traffic OUT Errors','ifOutErrors.114',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19723,1,'public','ifOutErrors.115',161,10026,'Port 15 Traffic OUT Errors','ifOutErrors.115',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19724,1,'public','ifOutErrors.116',161,10026,'Port 16 Traffic OUT Errors','ifOutErrors.116',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19725,1,'public','ifOutErrors.117',161,10026,'Port 17 Traffic OUT Errors','ifOutErrors.117',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19726,1,'public','ifOutErrors.118',161,10026,'Port 18 Traffic OUT Errors','ifOutErrors.118',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19727,1,'public','ifOutErrors.119',161,10026,'Port 19 Traffic OUT Errors','ifOutErrors.119',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19728,1,'public','ifOutErrors.102',161,10026,'Port 2 Traffic OUT Errors','ifOutErrors.102',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19729,1,'public','ifOutErrors.120',161,10026,'Port 20 Traffic OUT Errors','ifOutErrors.120',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19730,1,'public','ifOutErrors.121',161,10026,'Port 21 Traffic OUT Errors','ifOutErrors.121',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19731,1,'public','ifOutErrors.122',161,10026,'Port 22 Traffic OUT Errors','ifOutErrors.122',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19732,1,'public','ifOutErrors.123',161,10026,'Port 23 Traffic OUT Errors','ifOutErrors.123',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19733,1,'public','ifOutErrors.124',161,10026,'Port 24 Traffic OUT Errors','ifOutErrors.124',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19734,1,'public','ifOutErrors.125',161,10026,'Port 25 Traffic OUT Errors','ifOutErrors.125',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19735,1,'public','ifOutErrors.103',161,10026,'Port 3 Traffic OUT Errors','ifOutErrors.103',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19736,1,'public','ifOutErrors.104',161,10026,'Port 4 Traffic OUT Errors','ifOutErrors.104',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19737,1,'public','ifOutErrors.105',161,10026,'Port 5 Traffic OUT Errors','ifOutErrors.105',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19738,1,'public','ifOutErrors.106',161,10026,'Port 6 Traffic OUT Errors','ifOutErrors.106',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19739,1,'public','ifOutErrors.107',161,10026,'Port 7 Traffic OUT Errors','ifOutErrors.107',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19740,1,'public','ifOutErrors.108',161,10026,'Port 8 Traffic OUT Errors','ifOutErrors.108',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19741,1,'public','ifOutErrors.109',161,10026,'Port 9 Traffic OUT Errors','ifOutErrors.109',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19742,1,'public','ifOutOctets.101',161,10026,'Port 1 Traffic OUT ','ifOutOctets.101',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19743,1,'public','ifOutOctets.110',161,10026,'Port 10 Traffic OUT ','ifOutOctets.110',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19744,1,'public','ifOutOctets.111',161,10026,'Port 11 Traffic OUT ','ifOutOctets.111',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19745,1,'public','ifOutOctets.112',161,10026,'Port 12 Traffic OUT ','ifOutOctets.112',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19746,1,'public','ifOutOctets.113',161,10026,'Port 13 Traffic OUT ','ifOutOctets.113',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19747,1,'public','ifOutOctets.114',161,10026,'Port 14 Traffic OUT ','ifOutOctets.114',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19748,1,'public','ifOutOctets.115',161,10026,'Port 15 Traffic OUT ','ifOutOctets.115',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19749,1,'public','ifOutOctets.116',161,10026,'Port 16 Traffic OUT ','ifOutOctets.116',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19750,1,'public','ifOutOctets.117',161,10026,'Port 17 Traffic OUT ','ifOutOctets.117',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19751,1,'public','ifOutOctets.118',161,10026,'Port 18 Traffic OUT ','ifOutOctets.118',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19752,1,'public','ifOutOctets.119',161,10026,'Port 19 Traffic OUT ','ifOutOctets.119',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19753,1,'public','ifOutOctets.102',161,10026,'Port 2 Traffic OUT ','ifOutOctets.102',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19754,1,'public','ifOutOctets.120',161,10026,'Port 20 Traffic OUT ','ifOutOctets.120',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19755,1,'public','ifOutOctets.121',161,10026,'Port 21 Traffic OUT ','ifOutOctets.121',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19756,1,'public','ifOutOctets.122',161,10026,'Port 22 Traffic OUT ','ifOutOctets.122',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19757,1,'public','ifOutOctets.123',161,10026,'Port 23 Traffic OUT ','ifOutOctets.123',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19758,1,'public','ifOutOctets.124',161,10026,'Port 24 Traffic OUT ','ifOutOctets.124',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19759,1,'public','ifOutOctets.125',161,10026,'Port 25 Traffic OUT ','ifOutOctets.125',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19760,1,'public','ifOutOctets.103',161,10026,'Port 3 Traffic OUT ','ifOutOctets.103',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19761,1,'public','ifOutOctets.104',161,10026,'Port 4 Traffic OUT ','ifOutOctets.104',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19762,1,'public','ifOutOctets.105',161,10026,'Port 5 Traffic OUT ','ifOutOctets.105',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19763,1,'public','ifOutOctets.106',161,10026,'Port 6 Traffic OUT ','ifOutOctets.106',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19764,1,'public','ifOutOctets.107',161,10026,'Port 7 Traffic OUT ','ifOutOctets.107',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19765,1,'public','ifOutOctets.108',161,10026,'Port 8 Traffic OUT ','ifOutOctets.108',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19766,1,'public','ifOutOctets.109',161,10026,'Port 9 Traffic OUT ','ifOutOctets.109',30,90,365,NULL,NULL,NULL,0,3,'','b',0,2,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19767,1,'public','ifSpeed.101',161,10026,'Port 1 Speed','ifspeed.101',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19768,1,'public','ifSpeed.110',161,10026,'Port 10 Speed','ifspeed.110',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19769,1,'public','ifSpeed.111',161,10026,'Port 11 Speed','ifspeed.111',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19770,1,'public','ifSpeed.112',161,10026,'Port 12 Speed','ifspeed.112',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19771,1,'public','ifSpeed.113',161,10026,'Port 13 Speed','ifspeed.113',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19772,1,'public','ifSpeed.114',161,10026,'Port 14 Speed','ifspeed.114',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19773,1,'public','ifSpeed.115',161,10026,'Port 15 Speed','ifspeed.115',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19774,1,'public','ifSpeed.116',161,10026,'Port 16 Speed','ifspeed.116',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19775,1,'public','ifSpeed.117',161,10026,'Port 17 Speed','ifspeed.117',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19776,1,'public','ifSpeed.118',161,10026,'Port 18 Speed','ifspeed.118',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19777,1,'public','ifSpeed.119',161,10026,'Port 19 Speed','ifspeed.119',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19778,1,'public','ifSpeed.102',161,10026,'Port 2 Speed','ifspeed.102',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19779,1,'public','ifSpeed.120',161,10026,'Port 20 Speed','ifspeed.120',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19780,1,'public','ifSpeed.121',161,10026,'Port 21 Speed','ifspeed.121',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19781,1,'public','ifSpeed.122',161,10026,'Port 22 Speed','ifspeed.122',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19782,1,'public','ifSpeed.123',161,10026,'Port 23 Speed','ifspeed.123',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19783,1,'public','ifSpeed.124',161,10026,'Port 24 Speed','ifspeed.124',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19784,1,'public','ifSpeed.125',161,10026,'Port 25 Speed','ifspeed.125',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19785,1,'public','ifSpeed.103',161,10026,'Port 3 Speed','ifspeed.103',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19786,1,'public','ifSpeed.104',161,10026,'Port 4 Speed','ifspeed.104',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19787,1,'public','ifSpeed.105',161,10026,'Port 5 Speed','ifspeed.105',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19788,1,'public','ifSpeed.106',161,10026,'Port 6 Speed','ifspeed.106',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19789,1,'public','ifSpeed.107',161,10026,'Port 7 Speed','ifspeed.107',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19790,1,'public','ifSpeed.108',161,10026,'Port 8 Speed','ifspeed.108',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19791,1,'public','ifSpeed.109',161,10026,'Port 9 Speed','ifspeed.109',30,90,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','0.00001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19792,1,'public','1.3.6.1.4.1.318.1.1.8.4.2.0',161,10027,'atsConfigPreferredSource','atsConfigPreferredSource',600,7,30,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19793,1,'public','1.3.6.1.4.1.318.1.1.8.1.3.0',161,10027,'atsIdentFirmwareDate','atsIdentFirmwareDate',600,7,30,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19794,1,'public','1.3.6.1.4.1.318.1.1.8.1.2.0',161,10027,'atsIdentFirmwareRev','atsIdentFirmwareRev',600,7,30,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19795,1,'public','1.3.6.1.4.1.318.1.1.8.1.1.0',161,10027,'atsIdentHardwareRev','atsIdentHardwareRev',600,7,30,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19796,1,'public','1.3.6.1.4.1.318.1.1.8.1.5.0',161,10027,'atsIdentModelNumber','atsIdentModelNumber',600,7,30,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19797,1,'public','1.3.6.1.4.1.318.1.1.8.1.6.0',161,10027,'atsIdentSerialNumber','atsIdentSerialNumber',600,7,30,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19798,1,'public','1.3.6.1.4.1.318.1.1.8.5.3.2.1.4.1',161,10027,'atsInputFrequency1','atsInputFrequency1',60,7,30,NULL,NULL,NULL,0,3,'','Hz',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19799,1,'public','1.3.6.1.4.1.318.1.1.8.5.3.2.1.4.2',161,10027,'atsInputFrequency2','atsInputFrequency2',60,7,30,NULL,NULL,NULL,0,3,'','Hz',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19800,1,'public','1.3.6.1.4.1.318.1.1.8.5.3.3.1.3.1.1.1',161,10027,'atsInputVoltage1','atsInputVoltage1',60,7,30,NULL,NULL,NULL,0,3,'','V',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19801,1,'public','1.3.6.1.4.1.318.1.1.8.5.3.3.1.3.2.1.1',161,10027,'atsInputVoltage2','atsInputVoltage2',60,7,30,NULL,NULL,NULL,0,3,'','V',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19802,1,'public','1.3.6.1.4.1.318.1.1.8.5.4.3.1.4.1.1.1',161,10027,'atsOutputCurrent','atsOutputCurrent',60,7,30,NULL,NULL,NULL,0,0,'','A',1,0,NULL,'',0,'','','0.1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19803,1,'public','1.3.6.1.4.1.318.1.1.8.5.4.2.1.4.1',161,10027,'atsOutputFrequency','atsOutputFrequency',60,7,30,NULL,NULL,NULL,0,3,'','Hz',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19804,1,'public','1.3.6.1.4.1.318.1.1.8.5.4.3.1.3.1.1.1',161,10027,'atsOutputVoltage','atsOutputVoltage',60,7,30,NULL,NULL,NULL,0,3,'','V',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19805,1,'public','1.3.6.1.4.1.318.1.1.8.5.1.6.0',161,10027,'atsStatus24VPowerSupply','atsStatus24VPowerSupply',60,7,30,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19806,1,'public','1.3.6.1.4.1.318.1.1.8.5.1.5.0',161,10027,'atsStatus5VPowerSupply','atsStatus5VPowerSupply',60,7,30,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19807,1,'public','1.3.6.1.4.1.318.1.1.8.5.1.3.0',161,10027,'atsStatusOverCurrentState','atsStatusOverCurrentState',60,7,30,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19808,1,'public','1.3.6.1.4.1.318.1.1.8.5.1.3.0',161,10027,'atsStatusRedundancyState','atsStatusRedundancyState',60,7,30,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19809,1,'public','1.3.6.1.4.1.318.1.1.8.5.1.2.0',161,10027,'atsStatusSelectedSource','atsStatusSelectedSource',60,7,30,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19810,4,'public','1.3.6.1.2.1.47.1.1.1.1.7.1',161,10028,'Cisco_Model_Number','cisco.version',30,90,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19811,3,'','',161,10028,'Ping Check','icmpping',30,30,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,8,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19812,4,'public','1.3.6.1.2.1.2.2.1.2.1',161,10028,'ifDescr1','ifDescr1',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19813,4,'public','1.3.6.1.2.1.2.2.1.2.10',161,10028,'ifDescr10','ifDescr10',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19814,4,'public','1.3.6.1.2.1.2.2.1.2.11',161,10028,'ifDescr11','ifDescr11',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19815,4,'public','1.3.6.1.2.1.2.2.1.2.12',161,10028,'ifDescr12','ifDescr12',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19816,4,'public','1.3.6.1.2.1.2.2.1.2.13',161,10028,'ifDescr13','ifDescr13',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19817,4,'public','1.3.6.1.2.1.2.2.1.2.14',161,10028,'ifDescr14','ifDescr14',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19818,4,'public','1.3.6.1.2.1.2.2.1.2.15',161,10028,'ifDescr15','ifDescr15',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19819,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10028,'ifDescr2','ifDescr2',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19820,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10028,'ifDescr3','ifDescr3',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19821,4,'public','1.3.6.1.2.1.2.2.1.2.4',161,10028,'ifDescr4','ifDescr4',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19822,4,'public','1.3.6.1.2.1.2.2.1.2.5',161,10028,'ifDescr5','ifDescr5',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19823,4,'public','1.3.6.1.2.1.2.2.1.2.6',161,10028,'ifDescr6','ifDescr6',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19824,4,'public','1.3.6.1.2.1.2.2.1.2.7',161,10028,'ifDescr7','ifDescr7',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19825,4,'public','1.3.6.1.2.1.2.2.1.2.8',161,10028,'ifDescr8','ifDescr8',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19826,4,'public','1.3.6.1.2.1.2.2.1.2.9',161,10028,'ifDescr9','ifDescr9',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19827,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10028,'FastEthernet1-IN-Bytes','ifInOctets1',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19828,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10028,'FastEthernet2-IN-Bytes','ifInOctets2',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19829,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10028,'FastEthernet3-IN-Bytes','ifInOctets3',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19830,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10028,'FastEthernet4-IN-Bytes','ifInOctets4',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19831,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10028,'Ethernet0-IN-Bytes','ifInOctets5',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19832,4,'public','.1.3.6.1.2.1.2.2.1.10.6',161,10028,'ATM0-IN-Bytes','ifInOctets6',5,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19833,4,'public','.1.3.6.1.2.1.2.2.1.10.7',161,10028,'Ethernet2-IN-Bytes','ifInOctets7',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19834,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10028,'FastEthernet1-OUT-Bytes','ifOutOctets1',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19835,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10028,'FastEthernet2-OUT-Bytes','ifOutOctets2',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19836,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10028,'FastEthernet3-OUT-Bytes','ifOutOctets3',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19837,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10028,'FastEthernet4-OUT-Bytes','ifOutOctets4',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19838,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10028,'Ethernet0-OUT-Bytes','ifOutOctets5',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19839,4,'public','.1.3.6.1.2.1.2.2.1.16.6',161,10028,'ATM0-OUT-Bytes','ifOutOctets6',5,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19840,4,'public','.1.3.6.1.2.1.2.2.1.16.7',161,10028,'Ethernet2-OUT-Bytes','ifOutOctets7',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19841,4,'public','.1.3.6.1.2.1.1.4.0',161,10028,'System_Contact','system.contact',30,90,365,NULL,NULL,NULL,1,1,'','.1.3.6.1.2',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19842,4,'public','.1.3.6.1.2.1.1.1.0',161,10028,'System_Description','system.description',30,90,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19843,4,'public','.1.3.6.1.2.1.1.5.0',161,10028,'System_Name','system.name',30,90,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19844,1,'public','.1.3.6.1.2.1.1.3.0',161,10028,'Uptime','Uptime',60,90,365,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19845,4,'public','1.3.6.1.2.1.47.1.1.1.1.7.1',161,10029,'Cisco_Model_Number','cisco.version',30,90,365,NULL,NULL,NULL,1,1,'','bps',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19846,3,'','',161,10029,'Ping Check','icmpping',30,30,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,8,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19847,4,'public','1.3.6.1.2.1.2.2.1.2.1',161,10029,'ifDescr1','ifDescr1',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19848,4,'public','1.3.6.1.2.1.2.2.1.2.10',161,10029,'ifDescr10','ifDescr10',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19849,4,'public','1.3.6.1.2.1.2.2.1.2.11',161,10029,'ifDescr11','ifDescr11',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19850,4,'public','1.3.6.1.2.1.2.2.1.2.12',161,10029,'ifDescr12','ifDescr12',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19851,4,'public','1.3.6.1.2.1.2.2.1.2.13',161,10029,'ifDescr13','ifDescr13',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19852,4,'public','1.3.6.1.2.1.2.2.1.2.14',161,10029,'ifDescr14','ifDescr14',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19853,4,'public','1.3.6.1.2.1.2.2.1.2.15',161,10029,'ifDescr15','ifDescr15',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19854,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10029,'ifDescr2','ifDescr2',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19855,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10029,'ifDescr3','ifDescr3',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19856,4,'public','1.3.6.1.2.1.2.2.1.2.4',161,10029,'ifDescr4','ifDescr4',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19857,4,'public','1.3.6.1.2.1.2.2.1.2.5',161,10029,'ifDescr5','ifDescr5',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19858,4,'public','1.3.6.1.2.1.2.2.1.2.6',161,10029,'ifDescr6','ifDescr6',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19859,4,'public','1.3.6.1.2.1.2.2.1.2.7',161,10029,'ifDescr7','ifDescr7',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19860,4,'public','1.3.6.1.2.1.2.2.1.2.8',161,10029,'ifDescr8','ifDescr8',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19861,4,'public','1.3.6.1.2.1.2.2.1.2.9',161,10029,'ifDescr9','ifDescr9',60,7,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19862,4,'public','1.3.6.1.2.1.2.2.1.10.1',161,10029,'FastEthernet0-IN-Bytes','ifInOctets1',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19863,4,'public','1.3.6.1.2.1.2.2.1.10.10',161,10029,'ATM0.0-aal5-layer-IN-Bytes','ifInOctets10',5,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19864,4,'public','1.3.6.1.2.1.2.2.1.10.12',161,10029,'Vlan1-IN-Bytes','ifInOctets12',5,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19865,4,'public','1.3.6.1.2.1.2.2.1.10.13',161,10029,'ifInOctets13','ifInOctets13',60,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19866,4,'public','1.3.6.1.2.1.2.2.1.10.14',161,10029,'ifInOctets14','ifInOctets14',60,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19867,4,'public','1.3.6.1.2.1.2.2.1.10.15',161,10029,'ifInOctets15','ifInOctets15',60,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19868,4,'public','1.3.6.1.2.1.2.2.1.10.2',161,10029,'FastEthernet1-IN-Bytes','ifInOctets2',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19869,4,'public','1.3.6.1.2.1.2.2.1.10.3',161,10029,'FastEthernet2-IN-Bytes','ifInOctets3',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19870,4,'public','1.3.6.1.2.1.2.2.1.10.4',161,10029,'FastEthernet3-IN-Bytes','ifInOctets4',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19871,4,'public','1.3.6.1.2.1.2.2.1.10.5',161,10029,'ATM0-IN-Bytes','ifInOctets5',5,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19872,4,'public','1.3.6.1.2.1.2.2.1.10.6',161,10029,'Null0-IN-Bytes','ifInOctets6',60,7,365,NULL,NULL,NULL,1,3,'','Bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19873,4,'public','1.3.6.1.2.1.2.2.1.10.9',161,10029,'ATM0-aal5-layer-IN-Bytes','ifInOctets9',5,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19874,4,'public','1.3.6.1.2.1.2.2.1.16.1',161,10029,'FastEthernet0-OUT-Bytes','ifOutOctets1',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19875,4,'public','1.3.6.1.2.1.2.2.1.16.10',161,10029,'ATM0.0-aal5-layer-OUT-Bytes','ifOutOctets10',5,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19876,4,'public','1.3.6.1.2.1.2.2.1.16.12',161,10029,'Vlan1-OUT-Bytes','ifOutOctets12',5,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19877,4,'public','1.3.6.1.2.1.2.2.1.16.13',161,10029,'ifOutOctets13','ifOutOctets13',60,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19878,4,'public','1.3.6.1.2.1.2.2.1.16.14',161,10029,'ifOutOctets14','ifOutOctets14',60,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19879,4,'public','1.3.6.1.2.1.2.2.1.16.15',161,10029,'ifOutOctets15','ifOutOctets15',60,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19880,4,'public','1.3.6.1.2.1.2.2.1.16.2',161,10029,'FastEthernet1-OUT-Bytes','ifOutOctets2',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19881,4,'public','1.3.6.1.2.1.2.2.1.16.3',161,10029,'FastEthernet2-OUT-Bytes','ifOutOctets3',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19882,4,'public','1.3.6.1.2.1.2.2.1.16.4',161,10029,'FastEthernet3-OUT-Bytes','ifOutOctets4',60,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19883,4,'public','1.3.6.1.2.1.2.2.1.16.5',161,10029,'ATM0-OUT-Bytes','ifOutOctets5',5,7,365,NULL,NULL,NULL,0,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19884,4,'public','1.3.6.1.2.1.2.2.1.16.6',161,10029,'Null0-OUT-Bytes','ifOutOctets6',60,7,365,NULL,NULL,NULL,1,3,'','Bps',1,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19885,4,'public','1.3.6.1.2.1.2.2.1.16.9',161,10029,'ATM0-aal5-layer-OUT-Bytes','ifOutOctets9',5,7,365,NULL,NULL,NULL,1,3,'','bps',1,1,NULL,'',0,'','','1','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19886,4,'public','.1.3.6.1.2.1.1.4.0',161,10029,'System_Contact','system.contact',30,90,365,NULL,NULL,NULL,1,1,'','.1.3.6.1.2',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19887,4,'public','.1.3.6.1.2.1.1.1.0',161,10029,'System_Description','system.description',30,90,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19888,4,'public','.1.3.6.1.2.1.1.5.0',161,10029,'System_Name','system.name',30,90,365,NULL,NULL,NULL,1,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19889,1,'public','.1.3.6.1.2.1.1.3.0',161,10029,'Uptime','Uptime',60,90,365,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19890,3,'','',161,10030,'Ping Check','icmpping',30,30,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19891,4,'itws','.1.3.6.1.2.1.2.2.1.10.10001',161,10030,'FastEthernet0/1-IN','ifInOctets.10001',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19892,4,'itws','.1.3.6.1.2.1.2.2.1.10.10002',161,10030,'FastEthernet0/2-IN','ifInOctets.10002',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19893,4,'itws','.1.3.6.1.2.1.2.2.1.10.10003',161,10030,'FastEthernet0/3-IN','ifInOctets.10003',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19894,4,'itws','.1.3.6.1.2.1.2.2.1.10.10004',161,10030,'FastEthernet0/4-IN','ifInOctets.10004',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19895,4,'itws','.1.3.6.1.2.1.2.2.1.10.10005',161,10030,'FastEthernet0/5-IN','ifInOctets.10005',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19896,4,'itws','.1.3.6.1.2.1.2.2.1.10.10006',161,10030,'FastEthernet0/6-IN','ifInOctets.10006',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19897,4,'itws','.1.3.6.1.2.1.2.2.1.10.10007',161,10030,'FastEthernet0/7-IN','ifInOctets.10007',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19898,4,'itws','.1.3.6.1.2.1.2.2.1.10.10008',161,10030,'FastEthernet0/8-IN','ifInOctets.10008',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19899,4,'itws','.1.3.6.1.2.1.2.2.1.10.10009',161,10030,'FastEthernet0/9-IN','ifInOctets.10009',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19900,4,'itws','.1.3.6.1.2.1.2.2.1.10.10010',161,10030,'FastEthernet0/10-IN','ifInOctets.10010',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19901,4,'itws','.1.3.6.1.2.1.2.2.1.10.10011',161,10030,'FastEthernet0/11-IN','ifInOctets.10011',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19902,4,'itws','.1.3.6.1.2.1.2.2.1.10.10012',161,10030,'FastEthernet0/12-IN','ifInOctets.10012',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19903,4,'itws','.1.3.6.1.2.1.2.2.1.10.10013',161,10030,'FastEthernet0/13-IN','ifInOctets.10013',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19904,4,'itws','.1.3.6.1.2.1.2.2.1.10.10014',161,10030,'FastEthernet0/14-IN','ifInOctets.10014',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19905,4,'itws','.1.3.6.1.2.1.2.2.1.10.10015',161,10030,'FastEthernet0/15-IN','ifInOctets.10015',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19906,4,'itws','.1.3.6.1.2.1.2.2.1.10.10016',161,10030,'FastEthernet0/16-IN','ifInOctets.10016',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19907,4,'itws','.1.3.6.1.2.1.2.2.1.10.10017',161,10030,'FastEthernet0/17-IN','ifInOctets.10017',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19908,4,'itws','.1.3.6.1.2.1.2.2.1.10.10018',161,10030,'FastEthernet0/18-IN','ifInOctets.10018',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19909,4,'itws','.1.3.6.1.2.1.2.2.1.10.10019',161,10030,'FastEthernet0/19-IN','ifInOctets.10019',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19910,4,'itws','.1.3.6.1.2.1.2.2.1.10.10020',161,10030,'FastEthernet0/20-IN','ifInOctets.10020',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19911,4,'itws','.1.3.6.1.2.1.2.2.1.10.10021',161,10030,'FastEthernet0/21-IN','ifInOctets.10021',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19912,4,'itws','.1.3.6.1.2.1.2.2.1.10.10022',161,10030,'FastEthernet0/22-IN','ifInOctets.10022',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19913,4,'itws','.1.3.6.1.2.1.2.2.1.10.10023',161,10030,'FastEthernet0/23-IN','ifInOctets.10023',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19914,4,'itws','.1.3.6.1.2.1.2.2.1.10.10024',161,10030,'FastEthernet0/24-IN','ifInOctets.10024',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19915,4,'itws','.1.3.6.1.2.1.2.2.1.10.10101',161,10030,'GigabitEthernet0/1-IN','ifInOctets.10101',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19916,4,'itws','.1.3.6.1.2.1.2.2.1.10.10102',161,10030,'GigabitEthernet0/2-IN','ifInOctets.10102',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19917,4,'itws','.1.3.6.1.2.1.2.2.1.16.10001',161,10030,'FastEthernet0/1-OUT','ifOutOctets.10001',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19918,4,'itws','.1.3.6.1.2.1.2.2.1.16.10002',161,10030,'FastEthernet0/2-OUT','ifOutOctets.10002',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19919,4,'itws','.1.3.6.1.2.1.2.2.1.16.10003',161,10030,'FastEthernet0/3-OUT','ifOutOctets.10003',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19920,4,'itws','.1.3.6.1.2.1.2.2.1.16.10004',161,10030,'FastEthernet0/4-OUT','ifOutOctets.10004',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19921,4,'itws','.1.3.6.1.2.1.2.2.1.16.10005',161,10030,'FastEthernet0/5-OUT','ifOutOctets.10005',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19922,4,'itws','.1.3.6.1.2.1.2.2.1.16.10006',161,10030,'FastEthernet0/6-OUT','ifOutOctets.10006',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19923,4,'itws','.1.3.6.1.2.1.2.2.1.16.10007',161,10030,'FastEthernet0/7-OUT','ifOutOctets.10007',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19924,4,'itws','.1.3.6.1.2.1.2.2.1.16.10008',161,10030,'FastEthernet0/8-OUT','ifOutOctets.10008',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19925,4,'itws','.1.3.6.1.2.1.2.2.1.16.10009',161,10030,'FastEthernet0/9-OUT','ifOutOctets.10009',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19926,4,'itws','.1.3.6.1.2.1.2.2.1.16.10010',161,10030,'FastEthernet0/10-OUT','ifOutOctets.10010',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19927,4,'itws','.1.3.6.1.2.1.2.2.1.16.10011',161,10030,'FastEthernet0/11-OUT','ifOutOctets.10011',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19928,4,'itws','.1.3.6.1.2.1.2.2.1.16.10012',161,10030,'FastEthernet0/12-OUT','ifOutOctets.10012',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19929,4,'itws','.1.3.6.1.2.1.2.2.1.16.10013',161,10030,'FastEthernet0/13-OUT','ifOutOctets.10013',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19930,4,'itws','.1.3.6.1.2.1.2.2.1.16.10014',161,10030,'FastEthernet0/14-OUT','ifOutOctets.10014',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19931,4,'itws','.1.3.6.1.2.1.2.2.1.16.10015',161,10030,'FastEthernet0/15-OUT','ifOutOctets.10015',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19932,4,'itws','.1.3.6.1.2.1.2.2.1.16.10016',161,10030,'FastEthernet0/16-OUT','ifOutOctets.10016',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19933,4,'itws','.1.3.6.1.2.1.2.2.1.16.10017',161,10030,'FastEthernet0/17-OUT','ifOutOctets.10017',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19934,4,'itws','.1.3.6.1.2.1.2.2.1.16.10018',161,10030,'FastEthernet0/18-OUT','ifOutOctets.10018',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19935,4,'itws','.1.3.6.1.2.1.2.2.1.16.10019',161,10030,'FastEthernet0/19-OUT','ifOutOctets.10019',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19936,4,'itws','.1.3.6.1.2.1.2.2.1.16.10020',161,10030,'FastEthernet0/20-OUT','ifOutOctets.10020',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19937,4,'itws','.1.3.6.1.2.1.2.2.1.16.10021',161,10030,'FastEthernet0/21-OUT','ifOutOctets.10021',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19938,4,'itws','.1.3.6.1.2.1.2.2.1.16.10022',161,10030,'FastEthernet0/22-OUT','ifOutOctets.10022',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19939,4,'itws','.1.3.6.1.2.1.2.2.1.16.10023',161,10030,'FastEthernet0/23-OUT','ifOutOctets.10023',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19940,4,'itws','.1.3.6.1.2.1.2.2.1.16.10024',161,10030,'FastEthernet0/24-OUT','ifOutOctets.10024',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19941,4,'itws','.1.3.6.1.2.1.2.2.1.16.10101',161,10030,'GigabitEthernet0/1-OUT','ifOutOctets.10101',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19942,4,'itws','.1.3.6.1.2.1.2.2.1.16.10102',161,10030,'GigabitEthernet0/2-OUT','ifOutOctets.10102',15,7,365,NULL,NULL,NULL,0,3,'','bps',0,1,NULL,'',0,'','','','',0,'',0,9,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19943,4,'itws','.1.3.6.1.2.1.1.3.0',161,10030,'Uptime','Uptime',60,90,365,NULL,NULL,NULL,0,3,'','s',1,0,NULL,'',0,'','','0.01','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19944,4,'public','.1.3.6.1.2.1.47.1.1.1.1.13.1001',161,10031,'13.1001','13.1001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19945,4,'public','.1.3.6.1.2.1.47.1.1.1.1.2.1',161,10031,'2.1','2.1',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19946,4,'public','.1.3.6.1.2.1.47.1.1.1.1.9.1001',161,10031,'9.1001','9.1001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19947,4,'public','.1.3.6.1.2.1.31.1.1.1.18.1',161,10031,'ifAlias.1','ifAlias.1',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19948,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10001',161,10031,'ifAlias.10001','ifAlias.10001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19949,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10002',161,10031,'ifAlias.10002','ifAlias.10002',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19950,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10003',161,10031,'ifAlias.10003','ifAlias.10003',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19951,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10004',161,10031,'ifAlias.10004','ifAlias.10004',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19952,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10005',161,10031,'ifAlias.10005','ifAlias.10005',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19953,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10006',161,10031,'ifAlias.10006','ifAlias.10006',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19954,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10007',161,10031,'ifAlias.10007','ifAlias.10007',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19955,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10008',161,10031,'ifAlias.10008','ifAlias.10008',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19956,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10009',161,10031,'ifAlias.10009','ifAlias.10009',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19957,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10010',161,10031,'ifAlias.10010','ifAlias.10010',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19958,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10011',161,10031,'ifAlias.10011','ifAlias.10011',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19959,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10012',161,10031,'ifAlias.10012','ifAlias.10012',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19960,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10013',161,10031,'ifAlias.10013','ifAlias.10013',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19961,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10014',161,10031,'ifAlias.10014','ifAlias.10014',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19962,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10015',161,10031,'ifAlias.10015','ifAlias.10015',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19963,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10016',161,10031,'ifAlias.10016','ifAlias.10016',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19964,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10017',161,10031,'ifAlias.10017','ifAlias.10017',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19965,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10018',161,10031,'ifAlias.10018','ifAlias.10018',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19966,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10019',161,10031,'ifAlias.10019','ifAlias.10019',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19967,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10020',161,10031,'ifAlias.10020','ifAlias.10020',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19968,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10021',161,10031,'ifAlias.10021','ifAlias.10021',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19969,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10022',161,10031,'ifAlias.10022','ifAlias.10022',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19970,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10023',161,10031,'ifAlias.10023','ifAlias.10023',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19971,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10024',161,10031,'ifAlias.10024','ifAlias.10024',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19972,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10025',161,10031,'ifAlias.10025','ifAlias.10025',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19973,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10026',161,10031,'ifAlias.10026','ifAlias.10026',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19974,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10027',161,10031,'ifAlias.10027','ifAlias.10027',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19975,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10028',161,10031,'ifAlias.10028','ifAlias.10028',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19976,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10029',161,10031,'ifAlias.10029','ifAlias.10029',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19977,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10030',161,10031,'ifAlias.10030','ifAlias.10030',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19978,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10031',161,10031,'ifAlias.10031','ifAlias.10031',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19979,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10032',161,10031,'ifAlias.10032','ifAlias.10032',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19980,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10033',161,10031,'ifAlias.10033','ifAlias.10033',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19981,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10034',161,10031,'ifAlias.10034','ifAlias.10034',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19982,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10035',161,10031,'ifAlias.10035','ifAlias.10035',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19983,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10036',161,10031,'ifAlias.10036','ifAlias.10036',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19984,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10037',161,10031,'ifAlias.10037','ifAlias.10037',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19985,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10038',161,10031,'ifAlias.10038','ifAlias.10038',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19986,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10039',161,10031,'ifAlias.10039','ifAlias.10039',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19987,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10040',161,10031,'ifAlias.10040','ifAlias.10040',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19988,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10041',161,10031,'ifAlias.10041','ifAlias.10041',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19989,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10042',161,10031,'ifAlias.10042','ifAlias.10042',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19990,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10043',161,10031,'ifAlias.10043','ifAlias.10043',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19991,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10044',161,10031,'ifAlias.10044','ifAlias.10044',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19992,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10045',161,10031,'ifAlias.10045','ifAlias.10045',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19993,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10046',161,10031,'ifAlias.10046','ifAlias.10046',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19994,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10047',161,10031,'ifAlias.10047','ifAlias.10047',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19995,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10048',161,10031,'ifAlias.10048','ifAlias.10048',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19996,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10101',161,10031,'ifAlias.10101','ifAlias.10101',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19997,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10102',161,10031,'ifAlias.10102','ifAlias.10102',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19998,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10103',161,10031,'ifAlias.10103','ifAlias.10103',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (19999,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10104',161,10031,'ifAlias.10104','ifAlias.10104',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20000,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10501',161,10031,'ifAlias.10501','ifAlias.10501',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20001,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10502',161,10031,'ifAlias.10502','ifAlias.10502',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20002,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10503',161,10031,'ifAlias.10503','ifAlias.10503',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20003,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10504',161,10031,'ifAlias.10504','ifAlias.10504',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20004,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10505',161,10031,'ifAlias.10505','ifAlias.10505',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20005,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10506',161,10031,'ifAlias.10506','ifAlias.10506',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20006,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10507',161,10031,'ifAlias.10507','ifAlias.10507',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20007,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10508',161,10031,'ifAlias.10508','ifAlias.10508',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20008,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10509',161,10031,'ifAlias.10509','ifAlias.10509',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20009,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10510',161,10031,'ifAlias.10510','ifAlias.10510',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20010,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10511',161,10031,'ifAlias.10511','ifAlias.10511',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20011,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10512',161,10031,'ifAlias.10512','ifAlias.10512',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20012,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10513',161,10031,'ifAlias.10513','ifAlias.10513',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20013,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10514',161,10031,'ifAlias.10514','ifAlias.10514',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20014,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10515',161,10031,'ifAlias.10515','ifAlias.10515',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20015,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10516',161,10031,'ifAlias.10516','ifAlias.10516',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20016,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10517',161,10031,'ifAlias.10517','ifAlias.10517',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20017,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10518',161,10031,'ifAlias.10518','ifAlias.10518',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20018,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10519',161,10031,'ifAlias.10519','ifAlias.10519',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20019,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10520',161,10031,'ifAlias.10520','ifAlias.10520',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20020,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10521',161,10031,'ifAlias.10521','ifAlias.10521',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20021,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10522',161,10031,'ifAlias.10522','ifAlias.10522',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20022,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10523',161,10031,'ifAlias.10523','ifAlias.10523',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20023,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10524',161,10031,'ifAlias.10524','ifAlias.10524',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20024,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10525',161,10031,'ifAlias.10525','ifAlias.10525',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20025,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10526',161,10031,'ifAlias.10526','ifAlias.10526',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20026,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10527',161,10031,'ifAlias.10527','ifAlias.10527',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20027,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10528',161,10031,'ifAlias.10528','ifAlias.10528',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20028,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10529',161,10031,'ifAlias.10529','ifAlias.10529',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20029,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10530',161,10031,'ifAlias.10530','ifAlias.10530',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20030,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10531',161,10031,'ifAlias.10531','ifAlias.10531',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20031,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10532',161,10031,'ifAlias.10532','ifAlias.10532',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20032,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10533',161,10031,'ifAlias.10533','ifAlias.10533',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20033,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10534',161,10031,'ifAlias.10534','ifAlias.10534',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20034,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10535',161,10031,'ifAlias.10535','ifAlias.10535',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20035,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10536',161,10031,'ifAlias.10536','ifAlias.10536',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20036,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10537',161,10031,'ifAlias.10537','ifAlias.10537',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20037,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10538',161,10031,'ifAlias.10538','ifAlias.10538',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20038,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10539',161,10031,'ifAlias.10539','ifAlias.10539',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20039,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10540',161,10031,'ifAlias.10540','ifAlias.10540',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20040,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10541',161,10031,'ifAlias.10541','ifAlias.10541',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20041,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10542',161,10031,'ifAlias.10542','ifAlias.10542',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20042,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10543',161,10031,'ifAlias.10543','ifAlias.10543',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20043,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10544',161,10031,'ifAlias.10544','ifAlias.10544',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20044,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10545',161,10031,'ifAlias.10545','ifAlias.10545',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20045,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10546',161,10031,'ifAlias.10546','ifAlias.10546',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20046,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10547',161,10031,'ifAlias.10547','ifAlias.10547',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20047,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10548',161,10031,'ifAlias.10548','ifAlias.10548',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20048,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10601',161,10031,'ifAlias.10601','ifAlias.10601',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20049,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10602',161,10031,'ifAlias.10602','ifAlias.10602',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20050,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10603',161,10031,'ifAlias.10603','ifAlias.10603',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20051,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10604',161,10031,'ifAlias.10604','ifAlias.10604',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20052,4,'public','.1.3.6.1.2.1.31.1.1.1.18.12',161,10031,'ifAlias.12','ifAlias.12',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20053,4,'public','.1.3.6.1.2.1.31.1.1.1.18.14501',161,10031,'ifAlias.14501','ifAlias.14501',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20054,4,'public','.1.3.6.1.2.1.2.2.1.2.1',161,10031,'ifDescr.1','ifDescr.1',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20055,4,'public','.1.3.6.1.2.1.2.2.1.2.10001',161,10031,'ifDescr.10001','ifDescr.10001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20056,4,'public','.1.3.6.1.2.1.2.2.1.2.10002',161,10031,'ifDescr.10002','ifDescr.10002',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20057,4,'public','.1.3.6.1.2.1.2.2.1.2.10003',161,10031,'ifDescr.10003','ifDescr.10003',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20058,4,'public','.1.3.6.1.2.1.2.2.1.2.10004',161,10031,'ifDescr.10004','ifDescr.10004',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20059,4,'public','.1.3.6.1.2.1.2.2.1.2.10005',161,10031,'ifDescr.10005','ifDescr.10005',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20060,4,'public','.1.3.6.1.2.1.2.2.1.2.10006',161,10031,'ifDescr.10006','ifDescr.10006',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20061,4,'public','.1.3.6.1.2.1.2.2.1.2.10007',161,10031,'ifDescr.10007','ifDescr.10007',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20062,4,'public','.1.3.6.1.2.1.2.2.1.2.10008',161,10031,'ifDescr.10008','ifDescr.10008',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20063,4,'public','.1.3.6.1.2.1.2.2.1.2.10009',161,10031,'ifDescr.10009','ifDescr.10009',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20064,4,'public','.1.3.6.1.2.1.2.2.1.2.10010',161,10031,'ifDescr.10010','ifDescr.10010',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20065,4,'public','.1.3.6.1.2.1.2.2.1.2.10011',161,10031,'ifDescr.10011','ifDescr.10011',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20066,4,'public','.1.3.6.1.2.1.2.2.1.2.10012',161,10031,'ifDescr.10012','ifDescr.10012',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20067,4,'public','.1.3.6.1.2.1.2.2.1.2.10013',161,10031,'ifDescr.10013','ifDescr.10013',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20068,4,'public','.1.3.6.1.2.1.2.2.1.2.10014',161,10031,'ifDescr.10014','ifDescr.10014',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20069,4,'public','.1.3.6.1.2.1.2.2.1.2.10015',161,10031,'ifDescr.10015','ifDescr.10015',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20070,4,'public','.1.3.6.1.2.1.2.2.1.2.10016',161,10031,'ifDescr.10016','ifDescr.10016',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20071,4,'public','.1.3.6.1.2.1.2.2.1.2.10017',161,10031,'ifDescr.10017','ifDescr.10017',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20072,4,'public','.1.3.6.1.2.1.2.2.1.2.10018',161,10031,'ifDescr.10018','ifDescr.10018',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20073,4,'public','.1.3.6.1.2.1.2.2.1.2.10019',161,10031,'ifDescr.10019','ifDescr.10019',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20074,4,'public','.1.3.6.1.2.1.2.2.1.2.10020',161,10031,'ifDescr.10020','ifDescr.10020',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20075,4,'public','.1.3.6.1.2.1.2.2.1.2.10021',161,10031,'ifDescr.10021','ifDescr.10021',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20076,4,'public','.1.3.6.1.2.1.2.2.1.2.10022',161,10031,'ifDescr.10022','ifDescr.10022',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20077,4,'public','.1.3.6.1.2.1.2.2.1.2.10023',161,10031,'ifDescr.10023','ifDescr.10023',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20078,4,'public','.1.3.6.1.2.1.2.2.1.2.10024',161,10031,'ifDescr.10024','ifDescr.10024',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20079,4,'public','.1.3.6.1.2.1.2.2.1.2.10025',161,10031,'ifDescr.10025','ifDescr.10025',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20080,4,'public','.1.3.6.1.2.1.2.2.1.2.10026',161,10031,'ifDescr.10026','ifDescr.10026',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20081,4,'public','.1.3.6.1.2.1.2.2.1.2.10027',161,10031,'ifDescr.10027','ifDescr.10027',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20082,4,'public','.1.3.6.1.2.1.2.2.1.2.10028',161,10031,'ifDescr.10028','ifDescr.10028',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20083,4,'public','.1.3.6.1.2.1.2.2.1.2.10029',161,10031,'ifDescr.10029','ifDescr.10029',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20084,4,'public','.1.3.6.1.2.1.2.2.1.2.10030',161,10031,'ifDescr.10030','ifDescr.10030',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20085,4,'public','.1.3.6.1.2.1.2.2.1.2.10031',161,10031,'ifDescr.10031','ifDescr.10031',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20086,4,'public','.1.3.6.1.2.1.2.2.1.2.10032',161,10031,'ifDescr.10032','ifDescr.10032',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20087,4,'public','.1.3.6.1.2.1.2.2.1.2.10033',161,10031,'ifDescr.10033','ifDescr.10033',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20088,4,'public','.1.3.6.1.2.1.2.2.1.2.10034',161,10031,'ifDescr.10034','ifDescr.10034',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20089,4,'public','.1.3.6.1.2.1.2.2.1.2.10035',161,10031,'ifDescr.10035','ifDescr.10035',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20090,4,'public','.1.3.6.1.2.1.2.2.1.2.10036',161,10031,'ifDescr.10036','ifDescr.10036',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20091,4,'public','.1.3.6.1.2.1.2.2.1.2.10037',161,10031,'ifDescr.10037','ifDescr.10037',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20092,4,'public','.1.3.6.1.2.1.2.2.1.2.10038',161,10031,'ifDescr.10038','ifDescr.10038',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20093,4,'public','.1.3.6.1.2.1.2.2.1.2.10039',161,10031,'ifDescr.10039','ifDescr.10039',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20094,4,'public','.1.3.6.1.2.1.2.2.1.2.10040',161,10031,'ifDescr.10040','ifDescr.10040',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20095,4,'public','.1.3.6.1.2.1.2.2.1.2.10041',161,10031,'ifDescr.10041','ifDescr.10041',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20096,4,'public','.1.3.6.1.2.1.2.2.1.2.10042',161,10031,'ifDescr.10042','ifDescr.10042',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20097,4,'public','.1.3.6.1.2.1.2.2.1.2.10043',161,10031,'ifDescr.10043','ifDescr.10043',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20098,4,'public','.1.3.6.1.2.1.2.2.1.2.10044',161,10031,'ifDescr.10044','ifDescr.10044',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20099,4,'public','.1.3.6.1.2.1.2.2.1.2.10045',161,10031,'ifDescr.10045','ifDescr.10045',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20100,4,'public','.1.3.6.1.2.1.2.2.1.2.10046',161,10031,'ifDescr.10046','ifDescr.10046',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20101,4,'public','.1.3.6.1.2.1.2.2.1.2.10047',161,10031,'ifDescr.10047','ifDescr.10047',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20102,4,'public','.1.3.6.1.2.1.2.2.1.2.10048',161,10031,'ifDescr.10048','ifDescr.10048',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20103,4,'public','.1.3.6.1.2.1.2.2.1.2.10101',161,10031,'ifDescr.10101','ifDescr.10101',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20104,4,'public','.1.3.6.1.2.1.2.2.1.2.10102',161,10031,'ifDescr.10102','ifDescr.10102',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20105,4,'public','.1.3.6.1.2.1.2.2.1.2.10103',161,10031,'ifDescr.10103','ifDescr.10103',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20106,4,'public','.1.3.6.1.2.1.2.2.1.2.10104',161,10031,'ifDescr.10104','ifDescr.10104',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20107,4,'public','.1.3.6.1.2.1.2.2.1.2.10501',161,10031,'ifDescr.10501','ifDescr.10501',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20108,4,'public','.1.3.6.1.2.1.2.2.1.2.10502',161,10031,'ifDescr.10502','ifDescr.10502',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20109,4,'public','.1.3.6.1.2.1.2.2.1.2.10503',161,10031,'ifDescr.10503','ifDescr.10503',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20110,4,'public','.1.3.6.1.2.1.2.2.1.2.10504',161,10031,'ifDescr.10504','ifDescr.10504',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20111,4,'public','.1.3.6.1.2.1.2.2.1.2.10505',161,10031,'ifDescr.10505','ifDescr.10505',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20112,4,'public','.1.3.6.1.2.1.2.2.1.2.10506',161,10031,'ifDescr.10506','ifDescr.10506',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20113,4,'public','.1.3.6.1.2.1.2.2.1.2.10507',161,10031,'ifDescr.10507','ifDescr.10507',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20114,4,'public','.1.3.6.1.2.1.2.2.1.2.10508',161,10031,'ifDescr.10508','ifDescr.10508',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20115,4,'public','.1.3.6.1.2.1.2.2.1.2.10509',161,10031,'ifDescr.10509','ifDescr.10509',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20116,4,'public','.1.3.6.1.2.1.2.2.1.2.10510',161,10031,'ifDescr.10510','ifDescr.10510',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20117,4,'public','.1.3.6.1.2.1.2.2.1.2.10511',161,10031,'ifDescr.10511','ifDescr.10511',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20118,4,'public','.1.3.6.1.2.1.2.2.1.2.10512',161,10031,'ifDescr.10512','ifDescr.10512',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20119,4,'public','.1.3.6.1.2.1.2.2.1.2.10513',161,10031,'ifDescr.10513','ifDescr.10513',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20120,4,'public','.1.3.6.1.2.1.2.2.1.2.10514',161,10031,'ifDescr.10514','ifDescr.10514',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20121,4,'public','.1.3.6.1.2.1.2.2.1.2.10515',161,10031,'ifDescr.10515','ifDescr.10515',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20122,4,'public','.1.3.6.1.2.1.2.2.1.2.10516',161,10031,'ifDescr.10516','ifDescr.10516',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20123,4,'public','.1.3.6.1.2.1.2.2.1.2.10517',161,10031,'ifDescr.10517','ifDescr.10517',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20124,4,'public','.1.3.6.1.2.1.2.2.1.2.10518',161,10031,'ifDescr.10518','ifDescr.10518',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20125,4,'public','.1.3.6.1.2.1.2.2.1.2.10519',161,10031,'ifDescr.10519','ifDescr.10519',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20126,4,'public','.1.3.6.1.2.1.2.2.1.2.10520',161,10031,'ifDescr.10520','ifDescr.10520',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20127,4,'public','.1.3.6.1.2.1.2.2.1.2.10521',161,10031,'ifDescr.10521','ifDescr.10521',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20128,4,'public','.1.3.6.1.2.1.2.2.1.2.10522',161,10031,'ifDescr.10522','ifDescr.10522',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20129,4,'public','.1.3.6.1.2.1.2.2.1.2.10523',161,10031,'ifDescr.10523','ifDescr.10523',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20130,4,'public','.1.3.6.1.2.1.2.2.1.2.10524',161,10031,'ifDescr.10524','ifDescr.10524',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20131,4,'public','.1.3.6.1.2.1.2.2.1.2.10525',161,10031,'ifDescr.10525','ifDescr.10525',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20132,4,'public','.1.3.6.1.2.1.2.2.1.2.10526',161,10031,'ifDescr.10526','ifDescr.10526',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20133,4,'public','.1.3.6.1.2.1.2.2.1.2.10527',161,10031,'ifDescr.10527','ifDescr.10527',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20134,4,'public','.1.3.6.1.2.1.2.2.1.2.10528',161,10031,'ifDescr.10528','ifDescr.10528',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20135,4,'public','.1.3.6.1.2.1.2.2.1.2.10529',161,10031,'ifDescr.10529','ifDescr.10529',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20136,4,'public','.1.3.6.1.2.1.2.2.1.2.10530',161,10031,'ifDescr.10530','ifDescr.10530',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20137,4,'public','.1.3.6.1.2.1.2.2.1.2.10531',161,10031,'ifDescr.10531','ifDescr.10531',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20138,4,'public','.1.3.6.1.2.1.2.2.1.2.10532',161,10031,'ifDescr.10532','ifDescr.10532',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20139,4,'public','.1.3.6.1.2.1.2.2.1.2.10533',161,10031,'ifDescr.10533','ifDescr.10533',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20140,4,'public','.1.3.6.1.2.1.2.2.1.2.10534',161,10031,'ifDescr.10534','ifDescr.10534',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20141,4,'public','.1.3.6.1.2.1.2.2.1.2.10535',161,10031,'ifDescr.10535','ifDescr.10535',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20142,4,'public','.1.3.6.1.2.1.2.2.1.2.10536',161,10031,'ifDescr.10536','ifDescr.10536',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20143,4,'public','.1.3.6.1.2.1.2.2.1.2.10537',161,10031,'ifDescr.10537','ifDescr.10537',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20144,4,'public','.1.3.6.1.2.1.2.2.1.2.10538',161,10031,'ifDescr.10538','ifDescr.10538',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20145,4,'public','.1.3.6.1.2.1.2.2.1.2.10539',161,10031,'ifDescr.10539','ifDescr.10539',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20146,4,'public','.1.3.6.1.2.1.2.2.1.2.10540',161,10031,'ifDescr.10540','ifDescr.10540',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20147,4,'public','.1.3.6.1.2.1.2.2.1.2.10541',161,10031,'ifDescr.10541','ifDescr.10541',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20148,4,'public','.1.3.6.1.2.1.2.2.1.2.10542',161,10031,'ifDescr.10542','ifDescr.10542',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20149,4,'public','.1.3.6.1.2.1.2.2.1.2.10543',161,10031,'ifDescr.10543','ifDescr.10543',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20150,4,'public','.1.3.6.1.2.1.2.2.1.2.10544',161,10031,'ifDescr.10544','ifDescr.10544',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20151,4,'public','.1.3.6.1.2.1.2.2.1.2.10545',161,10031,'ifDescr.10545','ifDescr.10545',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20152,4,'public','.1.3.6.1.2.1.2.2.1.2.10546',161,10031,'ifDescr.10546','ifDescr.10546',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20153,4,'public','.1.3.6.1.2.1.2.2.1.2.10547',161,10031,'ifDescr.10547','ifDescr.10547',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20154,4,'public','.1.3.6.1.2.1.2.2.1.2.10548',161,10031,'ifDescr.10548','ifDescr.10548',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20155,4,'public','.1.3.6.1.2.1.2.2.1.2.10601',161,10031,'ifDescr.10601','ifDescr.10601',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20156,4,'public','.1.3.6.1.2.1.2.2.1.2.10602',161,10031,'ifDescr.10602','ifDescr.10602',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20157,4,'public','.1.3.6.1.2.1.2.2.1.2.10603',161,10031,'ifDescr.10603','ifDescr.10603',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20158,4,'public','.1.3.6.1.2.1.2.2.1.2.10604',161,10031,'ifDescr.10604','ifDescr.10604',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20159,4,'public','.1.3.6.1.2.1.2.2.1.2.12',161,10031,'ifDescr.12','ifDescr.12',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20160,4,'public','.1.3.6.1.2.1.2.2.1.2.14501',161,10031,'ifDescr.14501','ifDescr.14501',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20161,4,'public','.1.3.6.1.2.1.2.2.1.10.1',161,10031,'ifInOctets.1','ifInOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20162,4,'public','.1.3.6.1.2.1.2.2.1.10.10001',161,10031,'ifInOctets.10001','ifInOctets.10001',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20163,4,'public','.1.3.6.1.2.1.2.2.1.10.10002',161,10031,'ifInOctets.10002','ifInOctets.10002',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20164,4,'public','.1.3.6.1.2.1.2.2.1.10.10003',161,10031,'ifInOctets.10003','ifInOctets.10003',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20165,4,'public','.1.3.6.1.2.1.2.2.1.10.10004',161,10031,'ifInOctets.10004','ifInOctets.10004',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20166,4,'public','.1.3.6.1.2.1.2.2.1.10.10005',161,10031,'ifInOctets.10005','ifInOctets.10005',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20167,4,'public','.1.3.6.1.2.1.2.2.1.10.10006',161,10031,'ifInOctets.10006','ifInOctets.10006',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20168,4,'public','.1.3.6.1.2.1.2.2.1.10.10007',161,10031,'ifInOctets.10007','ifInOctets.10007',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20169,4,'public','.1.3.6.1.2.1.2.2.1.10.10008',161,10031,'ifInOctets.10008','ifInOctets.10008',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20170,4,'public','.1.3.6.1.2.1.2.2.1.10.10009',161,10031,'ifInOctets.10009','ifInOctets.10009',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20171,4,'public','.1.3.6.1.2.1.2.2.1.10.10010',161,10031,'ifInOctets.10010','ifInOctets.10010',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20172,4,'public','.1.3.6.1.2.1.2.2.1.10.10011',161,10031,'ifInOctets.10011','ifInOctets.10011',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20173,4,'public','.1.3.6.1.2.1.2.2.1.10.10012',161,10031,'ifInOctets.10012','ifInOctets.10012',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20174,4,'public','.1.3.6.1.2.1.2.2.1.10.10013',161,10031,'ifInOctets.10013','ifInOctets.10013',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20175,4,'public','.1.3.6.1.2.1.2.2.1.10.10014',161,10031,'ifInOctets.10014','ifInOctets.10014',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20176,4,'public','.1.3.6.1.2.1.2.2.1.10.10015',161,10031,'ifInOctets.10015','ifInOctets.10015',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20177,4,'public','.1.3.6.1.2.1.2.2.1.10.10016',161,10031,'ifInOctets.10016','ifInOctets.10016',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20178,4,'public','.1.3.6.1.2.1.2.2.1.10.10017',161,10031,'ifInOctets.10017','ifInOctets.10017',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20179,4,'public','.1.3.6.1.2.1.2.2.1.10.10018',161,10031,'ifInOctets.10018','ifInOctets.10018',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20180,4,'public','.1.3.6.1.2.1.2.2.1.10.10019',161,10031,'ifInOctets.10019','ifInOctets.10019',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20181,4,'public','.1.3.6.1.2.1.2.2.1.10.10020',161,10031,'ifInOctets.10020','ifInOctets.10020',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20182,4,'public','.1.3.6.1.2.1.2.2.1.10.10021',161,10031,'ifInOctets.10021','ifInOctets.10021',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20183,4,'public','.1.3.6.1.2.1.2.2.1.10.10022',161,10031,'ifInOctets.10022','ifInOctets.10022',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20184,4,'public','.1.3.6.1.2.1.2.2.1.10.10023',161,10031,'ifInOctets.10023','ifInOctets.10023',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20185,4,'public','.1.3.6.1.2.1.2.2.1.10.10024',161,10031,'ifInOctets.10024','ifInOctets.10024',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20186,4,'public','.1.3.6.1.2.1.2.2.1.10.10025',161,10031,'ifInOctets.10025','ifInOctets.10025',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20187,4,'public','.1.3.6.1.2.1.2.2.1.10.10026',161,10031,'ifInOctets.10026','ifInOctets.10026',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20188,4,'public','.1.3.6.1.2.1.2.2.1.10.10027',161,10031,'ifInOctets.10027','ifInOctets.10027',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20189,4,'public','.1.3.6.1.2.1.2.2.1.10.10028',161,10031,'ifInOctets.10028','ifInOctets.10028',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20190,4,'public','.1.3.6.1.2.1.2.2.1.10.10029',161,10031,'ifInOctets.10029','ifInOctets.10029',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20191,4,'public','.1.3.6.1.2.1.2.2.1.10.10030',161,10031,'ifInOctets.10030','ifInOctets.10030',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20192,4,'public','.1.3.6.1.2.1.2.2.1.10.10031',161,10031,'ifInOctets.10031','ifInOctets.10031',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20193,4,'public','.1.3.6.1.2.1.2.2.1.10.10032',161,10031,'ifInOctets.10032','ifInOctets.10032',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20194,4,'public','.1.3.6.1.2.1.2.2.1.10.10033',161,10031,'ifInOctets.10033','ifInOctets.10033',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20195,4,'public','.1.3.6.1.2.1.2.2.1.10.10034',161,10031,'ifInOctets.10034','ifInOctets.10034',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20196,4,'public','.1.3.6.1.2.1.2.2.1.10.10035',161,10031,'ifInOctets.10035','ifInOctets.10035',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20197,4,'public','.1.3.6.1.2.1.2.2.1.10.10036',161,10031,'ifInOctets.10036','ifInOctets.10036',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20198,4,'public','.1.3.6.1.2.1.2.2.1.10.10037',161,10031,'ifInOctets.10037','ifInOctets.10037',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20199,4,'public','.1.3.6.1.2.1.2.2.1.10.10038',161,10031,'ifInOctets.10038','ifInOctets.10038',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20200,4,'public','.1.3.6.1.2.1.2.2.1.10.10039',161,10031,'ifInOctets.10039','ifInOctets.10039',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20201,4,'public','.1.3.6.1.2.1.2.2.1.10.10040',161,10031,'ifInOctets.10040','ifInOctets.10040',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20202,4,'public','.1.3.6.1.2.1.2.2.1.10.10041',161,10031,'ifInOctets.10041','ifInOctets.10041',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20203,4,'public','.1.3.6.1.2.1.2.2.1.10.10042',161,10031,'ifInOctets.10042','ifInOctets.10042',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20204,4,'public','.1.3.6.1.2.1.2.2.1.10.10043',161,10031,'ifInOctets.10043','ifInOctets.10043',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20205,4,'public','.1.3.6.1.2.1.2.2.1.10.10044',161,10031,'ifInOctets.10044','ifInOctets.10044',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20206,4,'public','.1.3.6.1.2.1.2.2.1.10.10045',161,10031,'ifInOctets.10045','ifInOctets.10045',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20207,4,'public','.1.3.6.1.2.1.2.2.1.10.10046',161,10031,'ifInOctets.10046','ifInOctets.10046',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20208,4,'public','.1.3.6.1.2.1.2.2.1.10.10047',161,10031,'ifInOctets.10047','ifInOctets.10047',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20209,4,'public','.1.3.6.1.2.1.2.2.1.10.10048',161,10031,'ifInOctets.10048','ifInOctets.10048',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20210,4,'public','.1.3.6.1.2.1.2.2.1.10.10101',161,10031,'ifInOctets.10101','ifInOctets.10101',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20211,4,'public','.1.3.6.1.2.1.2.2.1.10.10102',161,10031,'ifInOctets.10102','ifInOctets.10102',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20212,4,'public','.1.3.6.1.2.1.2.2.1.10.10103',161,10031,'ifInOctets.10103','ifInOctets.10103',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20213,4,'public','.1.3.6.1.2.1.2.2.1.10.10104',161,10031,'ifInOctets.10104','ifInOctets.10104',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20214,4,'public','.1.3.6.1.2.1.2.2.1.10.10501',161,10031,'ifInOctets.10501','ifInOctets.10501',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20215,4,'public','.1.3.6.1.2.1.2.2.1.10.10502',161,10031,'ifInOctets.10502','ifInOctets.10502',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20216,4,'public','.1.3.6.1.2.1.2.2.1.10.10503',161,10031,'ifInOctets.10503','ifInOctets.10503',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20217,4,'public','.1.3.6.1.2.1.2.2.1.10.10504',161,10031,'ifInOctets.10504','ifInOctets.10504',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20218,4,'public','.1.3.6.1.2.1.2.2.1.10.10505',161,10031,'ifInOctets.10505','ifInOctets.10505',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20219,4,'public','.1.3.6.1.2.1.2.2.1.10.10506',161,10031,'ifInOctets.10506','ifInOctets.10506',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20220,4,'public','.1.3.6.1.2.1.2.2.1.10.10507',161,10031,'ifInOctets.10507','ifInOctets.10507',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20221,4,'public','.1.3.6.1.2.1.2.2.1.10.10508',161,10031,'ifInOctets.10508','ifInOctets.10508',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20222,4,'public','.1.3.6.1.2.1.2.2.1.10.10509',161,10031,'ifInOctets.10509','ifInOctets.10509',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20223,4,'public','.1.3.6.1.2.1.2.2.1.10.10510',161,10031,'ifInOctets.10510','ifInOctets.10510',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20224,4,'public','.1.3.6.1.2.1.2.2.1.10.10511',161,10031,'ifInOctets.10511','ifInOctets.10511',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20225,4,'public','.1.3.6.1.2.1.2.2.1.10.10512',161,10031,'ifInOctets.10512','ifInOctets.10512',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20226,4,'public','.1.3.6.1.2.1.2.2.1.10.10513',161,10031,'ifInOctets.10513','ifInOctets.10513',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20227,4,'public','.1.3.6.1.2.1.2.2.1.10.10514',161,10031,'ifInOctets.10514','ifInOctets.10514',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20228,4,'public','.1.3.6.1.2.1.2.2.1.10.10515',161,10031,'ifInOctets.10515','ifInOctets.10515',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20229,4,'public','.1.3.6.1.2.1.2.2.1.10.10516',161,10031,'ifInOctets.10516','ifInOctets.10516',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20230,4,'public','.1.3.6.1.2.1.2.2.1.10.10517',161,10031,'ifInOctets.10517','ifInOctets.10517',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20231,4,'public','.1.3.6.1.2.1.2.2.1.10.10518',161,10031,'ifInOctets.10518','ifInOctets.10518',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20232,4,'public','.1.3.6.1.2.1.2.2.1.10.10519',161,10031,'ifInOctets.10519','ifInOctets.10519',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20233,4,'public','.1.3.6.1.2.1.2.2.1.10.10520',161,10031,'ifInOctets.10520','ifInOctets.10520',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20234,4,'public','.1.3.6.1.2.1.2.2.1.10.10521',161,10031,'ifInOctets.10521','ifInOctets.10521',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20235,4,'public','.1.3.6.1.2.1.2.2.1.10.10522',161,10031,'ifInOctets.10522','ifInOctets.10522',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20236,4,'public','.1.3.6.1.2.1.2.2.1.10.10523',161,10031,'ifInOctets.10523','ifInOctets.10523',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20237,4,'public','.1.3.6.1.2.1.2.2.1.10.10524',161,10031,'ifInOctets.10524','ifInOctets.10524',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20238,4,'public','.1.3.6.1.2.1.2.2.1.10.10525',161,10031,'ifInOctets.10525','ifInOctets.10525',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20239,4,'public','.1.3.6.1.2.1.2.2.1.10.10526',161,10031,'ifInOctets.10526','ifInOctets.10526',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20240,4,'public','.1.3.6.1.2.1.2.2.1.10.10527',161,10031,'ifInOctets.10527','ifInOctets.10527',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20241,4,'public','.1.3.6.1.2.1.2.2.1.10.10528',161,10031,'ifInOctets.10528','ifInOctets.10528',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20242,4,'public','.1.3.6.1.2.1.2.2.1.10.10529',161,10031,'ifInOctets.10529','ifInOctets.10529',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20243,4,'public','.1.3.6.1.2.1.2.2.1.10.10530',161,10031,'ifInOctets.10530','ifInOctets.10530',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20244,4,'public','.1.3.6.1.2.1.2.2.1.10.10531',161,10031,'ifInOctets.10531','ifInOctets.10531',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20245,4,'public','.1.3.6.1.2.1.2.2.1.10.10532',161,10031,'ifInOctets.10532','ifInOctets.10532',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20246,4,'public','.1.3.6.1.2.1.2.2.1.10.10533',161,10031,'ifInOctets.10533','ifInOctets.10533',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20247,4,'public','.1.3.6.1.2.1.2.2.1.10.10534',161,10031,'ifInOctets.10534','ifInOctets.10534',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20248,4,'public','.1.3.6.1.2.1.2.2.1.10.10535',161,10031,'ifInOctets.10535','ifInOctets.10535',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20249,4,'public','.1.3.6.1.2.1.2.2.1.10.10536',161,10031,'ifInOctets.10536','ifInOctets.10536',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20250,4,'public','.1.3.6.1.2.1.2.2.1.10.10537',161,10031,'ifInOctets.10537','ifInOctets.10537',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20251,4,'public','.1.3.6.1.2.1.2.2.1.10.10538',161,10031,'ifInOctets.10538','ifInOctets.10538',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20252,4,'public','.1.3.6.1.2.1.2.2.1.10.10539',161,10031,'ifInOctets.10539','ifInOctets.10539',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20253,4,'public','.1.3.6.1.2.1.2.2.1.10.10540',161,10031,'ifInOctets.10540','ifInOctets.10540',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20254,4,'public','.1.3.6.1.2.1.2.2.1.10.10541',161,10031,'ifInOctets.10541','ifInOctets.10541',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20255,4,'public','.1.3.6.1.2.1.2.2.1.10.10542',161,10031,'ifInOctets.10542','ifInOctets.10542',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20256,4,'public','.1.3.6.1.2.1.2.2.1.10.10543',161,10031,'ifInOctets.10543','ifInOctets.10543',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20257,4,'public','.1.3.6.1.2.1.2.2.1.10.10544',161,10031,'ifInOctets.10544','ifInOctets.10544',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20258,4,'public','.1.3.6.1.2.1.2.2.1.10.10545',161,10031,'ifInOctets.10545','ifInOctets.10545',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20259,4,'public','.1.3.6.1.2.1.2.2.1.10.10546',161,10031,'ifInOctets.10546','ifInOctets.10546',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20260,4,'public','.1.3.6.1.2.1.2.2.1.10.10547',161,10031,'ifInOctets.10547','ifInOctets.10547',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20261,4,'public','.1.3.6.1.2.1.2.2.1.10.10548',161,10031,'ifInOctets.10548','ifInOctets.10548',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20262,4,'public','.1.3.6.1.2.1.2.2.1.10.10601',161,10031,'ifInOctets.10601','ifInOctets.10601',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20263,4,'public','.1.3.6.1.2.1.2.2.1.10.10602',161,10031,'ifInOctets.10602','ifInOctets.10602',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20264,4,'public','.1.3.6.1.2.1.2.2.1.10.10603',161,10031,'ifInOctets.10603','ifInOctets.10603',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20265,4,'public','.1.3.6.1.2.1.2.2.1.10.10604',161,10031,'ifInOctets.10604','ifInOctets.10604',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20266,4,'public','.1.3.6.1.2.1.2.2.1.10.12',161,10031,'ifInOctets.12','ifInOctets.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20267,4,'public','.1.3.6.1.2.1.2.2.1.10.14501',161,10031,'ifInOctets.14501','ifInOctets.14501',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20268,4,'public','.1.3.6.1.2.1.2.1.0',161,10031,'ifNumber.0','ifNumber.0',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20269,4,'public','.1.3.6.1.2.1.2.2.1.8.1',161,10031,'ifOperStatus.1','ifOperStatus.1',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20270,4,'public','.1.3.6.1.2.1.2.2.1.8.10001',161,10031,'ifOperStatus.10001','ifOperStatus.10001',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20271,4,'public','.1.3.6.1.2.1.2.2.1.8.10002',161,10031,'ifOperStatus.10002','ifOperStatus.10002',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20272,4,'public','.1.3.6.1.2.1.2.2.1.8.10003',161,10031,'ifOperStatus.10003','ifOperStatus.10003',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20273,4,'public','.1.3.6.1.2.1.2.2.1.8.10004',161,10031,'ifOperStatus.10004','ifOperStatus.10004',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20274,4,'public','.1.3.6.1.2.1.2.2.1.8.10005',161,10031,'ifOperStatus.10005','ifOperStatus.10005',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20275,4,'public','.1.3.6.1.2.1.2.2.1.8.10006',161,10031,'ifOperStatus.10006','ifOperStatus.10006',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20276,4,'public','.1.3.6.1.2.1.2.2.1.8.10007',161,10031,'ifOperStatus.10007','ifOperStatus.10007',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20277,4,'public','.1.3.6.1.2.1.2.2.1.8.10008',161,10031,'ifOperStatus.10008','ifOperStatus.10008',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20278,4,'public','.1.3.6.1.2.1.2.2.1.8.10009',161,10031,'ifOperStatus.10009','ifOperStatus.10009',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20279,4,'public','.1.3.6.1.2.1.2.2.1.8.10010',161,10031,'ifOperStatus.10010','ifOperStatus.10010',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20280,4,'public','.1.3.6.1.2.1.2.2.1.8.10011',161,10031,'ifOperStatus.10011','ifOperStatus.10011',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20281,4,'public','.1.3.6.1.2.1.2.2.1.8.10012',161,10031,'ifOperStatus.10012','ifOperStatus.10012',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20282,4,'public','.1.3.6.1.2.1.2.2.1.8.10013',161,10031,'ifOperStatus.10013','ifOperStatus.10013',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20283,4,'public','.1.3.6.1.2.1.2.2.1.8.10014',161,10031,'ifOperStatus.10014','ifOperStatus.10014',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20284,4,'public','.1.3.6.1.2.1.2.2.1.8.10015',161,10031,'ifOperStatus.10015','ifOperStatus.10015',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20285,4,'public','.1.3.6.1.2.1.2.2.1.8.10016',161,10031,'ifOperStatus.10016','ifOperStatus.10016',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20286,4,'public','.1.3.6.1.2.1.2.2.1.8.10017',161,10031,'ifOperStatus.10017','ifOperStatus.10017',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20287,4,'public','.1.3.6.1.2.1.2.2.1.8.10018',161,10031,'ifOperStatus.10018','ifOperStatus.10018',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20288,4,'public','.1.3.6.1.2.1.2.2.1.8.10019',161,10031,'ifOperStatus.10019','ifOperStatus.10019',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20289,4,'public','.1.3.6.1.2.1.2.2.1.8.10020',161,10031,'ifOperStatus.10020','ifOperStatus.10020',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20290,4,'public','.1.3.6.1.2.1.2.2.1.8.10021',161,10031,'ifOperStatus.10021','ifOperStatus.10021',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20291,4,'public','.1.3.6.1.2.1.2.2.1.8.10022',161,10031,'ifOperStatus.10022','ifOperStatus.10022',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20292,4,'public','.1.3.6.1.2.1.2.2.1.8.10023',161,10031,'ifOperStatus.10023','ifOperStatus.10023',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20293,4,'public','.1.3.6.1.2.1.2.2.1.8.10024',161,10031,'ifOperStatus.10024','ifOperStatus.10024',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20294,4,'public','.1.3.6.1.2.1.2.2.1.8.10025',161,10031,'ifOperStatus.10025','ifOperStatus.10025',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20295,4,'public','.1.3.6.1.2.1.2.2.1.8.10026',161,10031,'ifOperStatus.10026','ifOperStatus.10026',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20296,4,'public','.1.3.6.1.2.1.2.2.1.8.10027',161,10031,'ifOperStatus.10027','ifOperStatus.10027',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20297,4,'public','.1.3.6.1.2.1.2.2.1.8.10028',161,10031,'ifOperStatus.10028','ifOperStatus.10028',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20298,4,'public','.1.3.6.1.2.1.2.2.1.8.10029',161,10031,'ifOperStatus.10029','ifOperStatus.10029',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20299,4,'public','.1.3.6.1.2.1.2.2.1.8.10030',161,10031,'ifOperStatus.10030','ifOperStatus.10030',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20300,4,'public','.1.3.6.1.2.1.2.2.1.8.10031',161,10031,'ifOperStatus.10031','ifOperStatus.10031',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20301,4,'public','.1.3.6.1.2.1.2.2.1.8.10032',161,10031,'ifOperStatus.10032','ifOperStatus.10032',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20302,4,'public','.1.3.6.1.2.1.2.2.1.8.10033',161,10031,'ifOperStatus.10033','ifOperStatus.10033',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20303,4,'public','.1.3.6.1.2.1.2.2.1.8.10034',161,10031,'ifOperStatus.10034','ifOperStatus.10034',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20304,4,'public','.1.3.6.1.2.1.2.2.1.8.10035',161,10031,'ifOperStatus.10035','ifOperStatus.10035',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20305,4,'public','.1.3.6.1.2.1.2.2.1.8.10036',161,10031,'ifOperStatus.10036','ifOperStatus.10036',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20306,4,'public','.1.3.6.1.2.1.2.2.1.8.10037',161,10031,'ifOperStatus.10037','ifOperStatus.10037',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20307,4,'public','.1.3.6.1.2.1.2.2.1.8.10038',161,10031,'ifOperStatus.10038','ifOperStatus.10038',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20308,4,'public','.1.3.6.1.2.1.2.2.1.8.10039',161,10031,'ifOperStatus.10039','ifOperStatus.10039',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20309,4,'public','.1.3.6.1.2.1.2.2.1.8.10040',161,10031,'ifOperStatus.10040','ifOperStatus.10040',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20310,4,'public','.1.3.6.1.2.1.2.2.1.8.10041',161,10031,'ifOperStatus.10041','ifOperStatus.10041',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20311,4,'public','.1.3.6.1.2.1.2.2.1.8.10042',161,10031,'ifOperStatus.10042','ifOperStatus.10042',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20312,4,'public','.1.3.6.1.2.1.2.2.1.8.10043',161,10031,'ifOperStatus.10043','ifOperStatus.10043',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20313,4,'public','.1.3.6.1.2.1.2.2.1.8.10044',161,10031,'ifOperStatus.10044','ifOperStatus.10044',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20314,4,'public','.1.3.6.1.2.1.2.2.1.8.10045',161,10031,'ifOperStatus.10045','ifOperStatus.10045',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20315,4,'public','.1.3.6.1.2.1.2.2.1.8.10046',161,10031,'ifOperStatus.10046','ifOperStatus.10046',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20316,4,'public','.1.3.6.1.2.1.2.2.1.8.10047',161,10031,'ifOperStatus.10047','ifOperStatus.10047',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20317,4,'public','.1.3.6.1.2.1.2.2.1.8.10048',161,10031,'ifOperStatus.10048','ifOperStatus.10048',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20318,4,'public','.1.3.6.1.2.1.2.2.1.8.10101',161,10031,'ifOperStatus.10101','ifOperStatus.10101',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20319,4,'public','.1.3.6.1.2.1.2.2.1.8.10102',161,10031,'ifOperStatus.10102','ifOperStatus.10102',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20320,4,'public','.1.3.6.1.2.1.2.2.1.8.10103',161,10031,'ifOperStatus.10103','ifOperStatus.10103',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20321,4,'public','.1.3.6.1.2.1.2.2.1.8.10104',161,10031,'ifOperStatus.10104','ifOperStatus.10104',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20322,4,'public','.1.3.6.1.2.1.2.2.1.8.10501',161,10031,'ifOperStatus.10501','ifOperStatus.10501',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20323,4,'public','.1.3.6.1.2.1.2.2.1.8.10502',161,10031,'ifOperStatus.10502','ifOperStatus.10502',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20324,4,'public','.1.3.6.1.2.1.2.2.1.8.10503',161,10031,'ifOperStatus.10503','ifOperStatus.10503',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20325,4,'public','.1.3.6.1.2.1.2.2.1.8.10504',161,10031,'ifOperStatus.10504','ifOperStatus.10504',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20326,4,'public','.1.3.6.1.2.1.2.2.1.8.10505',161,10031,'ifOperStatus.10505','ifOperStatus.10505',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20327,4,'public','.1.3.6.1.2.1.2.2.1.8.10506',161,10031,'ifOperStatus.10506','ifOperStatus.10506',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20328,4,'public','.1.3.6.1.2.1.2.2.1.8.10507',161,10031,'ifOperStatus.10507','ifOperStatus.10507',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20329,4,'public','.1.3.6.1.2.1.2.2.1.8.10508',161,10031,'ifOperStatus.10508','ifOperStatus.10508',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20330,4,'public','.1.3.6.1.2.1.2.2.1.8.10509',161,10031,'ifOperStatus.10509','ifOperStatus.10509',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20331,4,'public','.1.3.6.1.2.1.2.2.1.8.10510',161,10031,'ifOperStatus.10510','ifOperStatus.10510',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20332,4,'public','.1.3.6.1.2.1.2.2.1.8.10511',161,10031,'ifOperStatus.10511','ifOperStatus.10511',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20333,4,'public','.1.3.6.1.2.1.2.2.1.8.10512',161,10031,'ifOperStatus.10512','ifOperStatus.10512',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20334,4,'public','.1.3.6.1.2.1.2.2.1.8.10513',161,10031,'ifOperStatus.10513','ifOperStatus.10513',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20335,4,'public','.1.3.6.1.2.1.2.2.1.8.10514',161,10031,'ifOperStatus.10514','ifOperStatus.10514',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20336,4,'public','.1.3.6.1.2.1.2.2.1.8.10515',161,10031,'ifOperStatus.10515','ifOperStatus.10515',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20337,4,'public','.1.3.6.1.2.1.2.2.1.8.10516',161,10031,'ifOperStatus.10516','ifOperStatus.10516',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20338,4,'public','.1.3.6.1.2.1.2.2.1.8.10517',161,10031,'ifOperStatus.10517','ifOperStatus.10517',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20339,4,'public','.1.3.6.1.2.1.2.2.1.8.10518',161,10031,'ifOperStatus.10518','ifOperStatus.10518',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20340,4,'public','.1.3.6.1.2.1.2.2.1.8.10519',161,10031,'ifOperStatus.10519','ifOperStatus.10519',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20341,4,'public','.1.3.6.1.2.1.2.2.1.8.10520',161,10031,'ifOperStatus.10520','ifOperStatus.10520',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20342,4,'public','.1.3.6.1.2.1.2.2.1.8.10521',161,10031,'ifOperStatus.10521','ifOperStatus.10521',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20343,4,'public','.1.3.6.1.2.1.2.2.1.8.10522',161,10031,'ifOperStatus.10522','ifOperStatus.10522',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20344,4,'public','.1.3.6.1.2.1.2.2.1.8.10523',161,10031,'ifOperStatus.10523','ifOperStatus.10523',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20345,4,'public','.1.3.6.1.2.1.2.2.1.8.10524',161,10031,'ifOperStatus.10524','ifOperStatus.10524',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20346,4,'public','.1.3.6.1.2.1.2.2.1.8.10525',161,10031,'ifOperStatus.10525','ifOperStatus.10525',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20347,4,'public','.1.3.6.1.2.1.2.2.1.8.10526',161,10031,'ifOperStatus.10526','ifOperStatus.10526',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20348,4,'public','.1.3.6.1.2.1.2.2.1.8.10527',161,10031,'ifOperStatus.10527','ifOperStatus.10527',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20349,4,'public','.1.3.6.1.2.1.2.2.1.8.10528',161,10031,'ifOperStatus.10528','ifOperStatus.10528',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20350,4,'public','.1.3.6.1.2.1.2.2.1.8.10529',161,10031,'ifOperStatus.10529','ifOperStatus.10529',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20351,4,'public','.1.3.6.1.2.1.2.2.1.8.10530',161,10031,'ifOperStatus.10530','ifOperStatus.10530',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20352,4,'public','.1.3.6.1.2.1.2.2.1.8.10531',161,10031,'ifOperStatus.10531','ifOperStatus.10531',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20353,4,'public','.1.3.6.1.2.1.2.2.1.8.10532',161,10031,'ifOperStatus.10532','ifOperStatus.10532',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20354,4,'public','.1.3.6.1.2.1.2.2.1.8.10533',161,10031,'ifOperStatus.10533','ifOperStatus.10533',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20355,4,'public','.1.3.6.1.2.1.2.2.1.8.10534',161,10031,'ifOperStatus.10534','ifOperStatus.10534',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20356,4,'public','.1.3.6.1.2.1.2.2.1.8.10535',161,10031,'ifOperStatus.10535','ifOperStatus.10535',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20357,4,'public','.1.3.6.1.2.1.2.2.1.8.10536',161,10031,'ifOperStatus.10536','ifOperStatus.10536',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20358,4,'public','.1.3.6.1.2.1.2.2.1.8.10537',161,10031,'ifOperStatus.10537','ifOperStatus.10537',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20359,4,'public','.1.3.6.1.2.1.2.2.1.8.10538',161,10031,'ifOperStatus.10538','ifOperStatus.10538',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20360,4,'public','.1.3.6.1.2.1.2.2.1.8.10539',161,10031,'ifOperStatus.10539','ifOperStatus.10539',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20361,4,'public','.1.3.6.1.2.1.2.2.1.8.10540',161,10031,'ifOperStatus.10540','ifOperStatus.10540',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20362,4,'public','.1.3.6.1.2.1.2.2.1.8.10541',161,10031,'ifOperStatus.10541','ifOperStatus.10541',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20363,4,'public','.1.3.6.1.2.1.2.2.1.8.10542',161,10031,'ifOperStatus.10542','ifOperStatus.10542',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20364,4,'public','.1.3.6.1.2.1.2.2.1.8.10543',161,10031,'ifOperStatus.10543','ifOperStatus.10543',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20365,4,'public','.1.3.6.1.2.1.2.2.1.8.10544',161,10031,'ifOperStatus.10544','ifOperStatus.10544',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20366,4,'public','.1.3.6.1.2.1.2.2.1.8.10545',161,10031,'ifOperStatus.10545','ifOperStatus.10545',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20367,4,'public','.1.3.6.1.2.1.2.2.1.8.10546',161,10031,'ifOperStatus.10546','ifOperStatus.10546',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20368,4,'public','.1.3.6.1.2.1.2.2.1.8.10547',161,10031,'ifOperStatus.10547','ifOperStatus.10547',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20369,4,'public','.1.3.6.1.2.1.2.2.1.8.10548',161,10031,'ifOperStatus.10548','ifOperStatus.10548',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20370,4,'public','.1.3.6.1.2.1.2.2.1.8.10601',161,10031,'ifOperStatus.10601','ifOperStatus.10601',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20371,4,'public','.1.3.6.1.2.1.2.2.1.8.10602',161,10031,'ifOperStatus.10602','ifOperStatus.10602',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20372,4,'public','.1.3.6.1.2.1.2.2.1.8.10603',161,10031,'ifOperStatus.10603','ifOperStatus.10603',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20373,4,'public','.1.3.6.1.2.1.2.2.1.8.10604',161,10031,'ifOperStatus.10604','ifOperStatus.10604',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20374,4,'public','.1.3.6.1.2.1.2.2.1.8.12',161,10031,'ifOperStatus.12','ifOperStatus.12',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20375,4,'public','.1.3.6.1.2.1.2.2.1.8.14501',161,10031,'ifOperStatus.14501','ifOperStatus.14501',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20376,4,'public','.1.3.6.1.2.1.2.2.1.16.1',161,10031,'ifOutOctets.1','ifOutOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20377,4,'public','.1.3.6.1.2.1.2.2.1.16.10001',161,10031,'ifOutOctets.10001','ifOutOctets.10001',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20378,4,'public','.1.3.6.1.2.1.2.2.1.16.10002',161,10031,'ifOutOctets.10002','ifOutOctets.10002',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20379,4,'public','.1.3.6.1.2.1.2.2.1.16.10003',161,10031,'ifOutOctets.10003','ifOutOctets.10003',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20380,4,'public','.1.3.6.1.2.1.2.2.1.16.10004',161,10031,'ifOutOctets.10004','ifOutOctets.10004',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20381,4,'public','.1.3.6.1.2.1.2.2.1.16.10005',161,10031,'ifOutOctets.10005','ifOutOctets.10005',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20382,4,'public','.1.3.6.1.2.1.2.2.1.16.10006',161,10031,'ifOutOctets.10006','ifOutOctets.10006',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20383,4,'public','.1.3.6.1.2.1.2.2.1.16.10007',161,10031,'ifOutOctets.10007','ifOutOctets.10007',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20384,4,'public','.1.3.6.1.2.1.2.2.1.16.10008',161,10031,'ifOutOctets.10008','ifOutOctets.10008',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20385,4,'public','.1.3.6.1.2.1.2.2.1.16.10009',161,10031,'ifOutOctets.10009','ifOutOctets.10009',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20386,4,'public','.1.3.6.1.2.1.2.2.1.16.10010',161,10031,'ifOutOctets.10010','ifOutOctets.10010',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20387,4,'public','.1.3.6.1.2.1.2.2.1.16.10011',161,10031,'ifOutOctets.10011','ifOutOctets.10011',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20388,4,'public','.1.3.6.1.2.1.2.2.1.16.10012',161,10031,'ifOutOctets.10012','ifOutOctets.10012',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20389,4,'public','.1.3.6.1.2.1.2.2.1.16.10013',161,10031,'ifOutOctets.10013','ifOutOctets.10013',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20390,4,'public','.1.3.6.1.2.1.2.2.1.16.10014',161,10031,'ifOutOctets.10014','ifOutOctets.10014',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20391,4,'public','.1.3.6.1.2.1.2.2.1.16.10015',161,10031,'ifOutOctets.10015','ifOutOctets.10015',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20392,4,'public','.1.3.6.1.2.1.2.2.1.16.10016',161,10031,'ifOutOctets.10016','ifOutOctets.10016',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20393,4,'public','.1.3.6.1.2.1.2.2.1.16.10017',161,10031,'ifOutOctets.10017','ifOutOctets.10017',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20394,4,'public','.1.3.6.1.2.1.2.2.1.16.10018',161,10031,'ifOutOctets.10018','ifOutOctets.10018',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20395,4,'public','.1.3.6.1.2.1.2.2.1.16.10019',161,10031,'ifOutOctets.10019','ifOutOctets.10019',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20396,4,'public','.1.3.6.1.2.1.2.2.1.16.10020',161,10031,'ifOutOctets.10020','ifOutOctets.10020',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20397,4,'public','.1.3.6.1.2.1.2.2.1.16.10021',161,10031,'ifOutOctets.10021','ifOutOctets.10021',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20398,4,'public','.1.3.6.1.2.1.2.2.1.16.10022',161,10031,'ifOutOctets.10022','ifOutOctets.10022',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20399,4,'public','.1.3.6.1.2.1.2.2.1.16.10023',161,10031,'ifOutOctets.10023','ifOutOctets.10023',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20400,4,'public','.1.3.6.1.2.1.2.2.1.16.10024',161,10031,'ifOutOctets.10024','ifOutOctets.10024',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20401,4,'public','.1.3.6.1.2.1.2.2.1.16.10025',161,10031,'ifOutOctets.10025','ifOutOctets.10025',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20402,4,'public','.1.3.6.1.2.1.2.2.1.16.10026',161,10031,'ifOutOctets.10026','ifOutOctets.10026',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20403,4,'public','.1.3.6.1.2.1.2.2.1.16.10027',161,10031,'ifOutOctets.10027','ifOutOctets.10027',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20404,4,'public','.1.3.6.1.2.1.2.2.1.16.10028',161,10031,'ifOutOctets.10028','ifOutOctets.10028',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20405,4,'public','.1.3.6.1.2.1.2.2.1.16.10029',161,10031,'ifOutOctets.10029','ifOutOctets.10029',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20406,4,'public','.1.3.6.1.2.1.2.2.1.16.10030',161,10031,'ifOutOctets.10030','ifOutOctets.10030',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20407,4,'public','.1.3.6.1.2.1.2.2.1.16.10031',161,10031,'ifOutOctets.10031','ifOutOctets.10031',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20408,4,'public','.1.3.6.1.2.1.2.2.1.16.10032',161,10031,'ifOutOctets.10032','ifOutOctets.10032',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20409,4,'public','.1.3.6.1.2.1.2.2.1.16.10033',161,10031,'ifOutOctets.10033','ifOutOctets.10033',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20410,4,'public','.1.3.6.1.2.1.2.2.1.16.10034',161,10031,'ifOutOctets.10034','ifOutOctets.10034',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20411,4,'public','.1.3.6.1.2.1.2.2.1.16.10035',161,10031,'ifOutOctets.10035','ifOutOctets.10035',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20412,4,'public','.1.3.6.1.2.1.2.2.1.16.10036',161,10031,'ifOutOctets.10036','ifOutOctets.10036',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20413,4,'public','.1.3.6.1.2.1.2.2.1.16.10037',161,10031,'ifOutOctets.10037','ifOutOctets.10037',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20414,4,'public','.1.3.6.1.2.1.2.2.1.16.10038',161,10031,'ifOutOctets.10038','ifOutOctets.10038',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20415,4,'public','.1.3.6.1.2.1.2.2.1.16.10039',161,10031,'ifOutOctets.10039','ifOutOctets.10039',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20416,4,'public','.1.3.6.1.2.1.2.2.1.16.10040',161,10031,'ifOutOctets.10040','ifOutOctets.10040',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20417,4,'public','.1.3.6.1.2.1.2.2.1.16.10041',161,10031,'ifOutOctets.10041','ifOutOctets.10041',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20418,4,'public','.1.3.6.1.2.1.2.2.1.16.10042',161,10031,'ifOutOctets.10042','ifOutOctets.10042',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20419,4,'public','.1.3.6.1.2.1.2.2.1.16.10043',161,10031,'ifOutOctets.10043','ifOutOctets.10043',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20420,4,'public','.1.3.6.1.2.1.2.2.1.16.10044',161,10031,'ifOutOctets.10044','ifOutOctets.10044',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20421,4,'public','.1.3.6.1.2.1.2.2.1.16.10045',161,10031,'ifOutOctets.10045','ifOutOctets.10045',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20422,4,'public','.1.3.6.1.2.1.2.2.1.16.10046',161,10031,'ifOutOctets.10046','ifOutOctets.10046',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20423,4,'public','.1.3.6.1.2.1.2.2.1.16.10047',161,10031,'ifOutOctets.10047','ifOutOctets.10047',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20424,4,'public','.1.3.6.1.2.1.2.2.1.16.10048',161,10031,'ifOutOctets.10048','ifOutOctets.10048',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20425,4,'public','.1.3.6.1.2.1.2.2.1.16.10101',161,10031,'ifOutOctets.10101','ifOutOctets.10101',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20426,4,'public','.1.3.6.1.2.1.2.2.1.16.10102',161,10031,'ifOutOctets.10102','ifOutOctets.10102',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20427,4,'public','.1.3.6.1.2.1.2.2.1.16.10103',161,10031,'ifOutOctets.10103','ifOutOctets.10103',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20428,4,'public','.1.3.6.1.2.1.2.2.1.16.10104',161,10031,'ifOutOctets.10104','ifOutOctets.10104',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20429,4,'public','.1.3.6.1.2.1.2.2.1.16.10501',161,10031,'ifOutOctets.10501','ifOutOctets.10501',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20430,4,'public','.1.3.6.1.2.1.2.2.1.16.10502',161,10031,'ifOutOctets.10502','ifOutOctets.10502',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20431,4,'public','.1.3.6.1.2.1.2.2.1.16.10503',161,10031,'ifOutOctets.10503','ifOutOctets.10503',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20432,4,'public','.1.3.6.1.2.1.2.2.1.16.10504',161,10031,'ifOutOctets.10504','ifOutOctets.10504',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20433,4,'public','.1.3.6.1.2.1.2.2.1.16.10505',161,10031,'ifOutOctets.10505','ifOutOctets.10505',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20434,4,'public','.1.3.6.1.2.1.2.2.1.16.10506',161,10031,'ifOutOctets.10506','ifOutOctets.10506',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20435,4,'public','.1.3.6.1.2.1.2.2.1.16.10507',161,10031,'ifOutOctets.10507','ifOutOctets.10507',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20436,4,'public','.1.3.6.1.2.1.2.2.1.16.10508',161,10031,'ifOutOctets.10508','ifOutOctets.10508',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20437,4,'public','.1.3.6.1.2.1.2.2.1.16.10509',161,10031,'ifOutOctets.10509','ifOutOctets.10509',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20438,4,'public','.1.3.6.1.2.1.2.2.1.16.10510',161,10031,'ifOutOctets.10510','ifOutOctets.10510',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20439,4,'public','.1.3.6.1.2.1.2.2.1.16.10511',161,10031,'ifOutOctets.10511','ifOutOctets.10511',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20440,4,'public','.1.3.6.1.2.1.2.2.1.16.10512',161,10031,'ifOutOctets.10512','ifOutOctets.10512',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20441,4,'public','.1.3.6.1.2.1.2.2.1.16.10513',161,10031,'ifOutOctets.10513','ifOutOctets.10513',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20442,4,'public','.1.3.6.1.2.1.2.2.1.16.10514',161,10031,'ifOutOctets.10514','ifOutOctets.10514',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20443,4,'public','.1.3.6.1.2.1.2.2.1.16.10515',161,10031,'ifOutOctets.10515','ifOutOctets.10515',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20444,4,'public','.1.3.6.1.2.1.2.2.1.16.10516',161,10031,'ifOutOctets.10516','ifOutOctets.10516',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20445,4,'public','.1.3.6.1.2.1.2.2.1.16.10517',161,10031,'ifOutOctets.10517','ifOutOctets.10517',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20446,4,'public','.1.3.6.1.2.1.2.2.1.16.10518',161,10031,'ifOutOctets.10518','ifOutOctets.10518',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20447,4,'public','.1.3.6.1.2.1.2.2.1.16.10519',161,10031,'ifOutOctets.10519','ifOutOctets.10519',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20448,4,'public','.1.3.6.1.2.1.2.2.1.16.10520',161,10031,'ifOutOctets.10520','ifOutOctets.10520',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20449,4,'public','.1.3.6.1.2.1.2.2.1.16.10521',161,10031,'ifOutOctets.10521','ifOutOctets.10521',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20450,4,'public','.1.3.6.1.2.1.2.2.1.16.10522',161,10031,'ifOutOctets.10522','ifOutOctets.10522',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20451,4,'public','.1.3.6.1.2.1.2.2.1.16.10523',161,10031,'ifOutOctets.10523','ifOutOctets.10523',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20452,4,'public','.1.3.6.1.2.1.2.2.1.16.10524',161,10031,'ifOutOctets.10524','ifOutOctets.10524',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20453,4,'public','.1.3.6.1.2.1.2.2.1.16.10525',161,10031,'ifOutOctets.10525','ifOutOctets.10525',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20454,4,'public','.1.3.6.1.2.1.2.2.1.16.10526',161,10031,'ifOutOctets.10526','ifOutOctets.10526',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20455,4,'public','.1.3.6.1.2.1.2.2.1.16.10527',161,10031,'ifOutOctets.10527','ifOutOctets.10527',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20456,4,'public','.1.3.6.1.2.1.2.2.1.16.10528',161,10031,'ifOutOctets.10528','ifOutOctets.10528',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20457,4,'public','.1.3.6.1.2.1.2.2.1.16.10529',161,10031,'ifOutOctets.10529','ifOutOctets.10529',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20458,4,'public','.1.3.6.1.2.1.2.2.1.16.10530',161,10031,'ifOutOctets.10530','ifOutOctets.10530',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20459,4,'public','.1.3.6.1.2.1.2.2.1.16.10531',161,10031,'ifOutOctets.10531','ifOutOctets.10531',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20460,4,'public','.1.3.6.1.2.1.2.2.1.16.10532',161,10031,'ifOutOctets.10532','ifOutOctets.10532',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20461,4,'public','.1.3.6.1.2.1.2.2.1.16.10533',161,10031,'ifOutOctets.10533','ifOutOctets.10533',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20462,4,'public','.1.3.6.1.2.1.2.2.1.16.10534',161,10031,'ifOutOctets.10534','ifOutOctets.10534',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20463,4,'public','.1.3.6.1.2.1.2.2.1.16.10535',161,10031,'ifOutOctets.10535','ifOutOctets.10535',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20464,4,'public','.1.3.6.1.2.1.2.2.1.16.10536',161,10031,'ifOutOctets.10536','ifOutOctets.10536',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20465,4,'public','.1.3.6.1.2.1.2.2.1.16.10537',161,10031,'ifOutOctets.10537','ifOutOctets.10537',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20466,4,'public','.1.3.6.1.2.1.2.2.1.16.10538',161,10031,'ifOutOctets.10538','ifOutOctets.10538',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20467,4,'public','.1.3.6.1.2.1.2.2.1.16.10539',161,10031,'ifOutOctets.10539','ifOutOctets.10539',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20468,4,'public','.1.3.6.1.2.1.2.2.1.16.10540',161,10031,'ifOutOctets.10540','ifOutOctets.10540',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20469,4,'public','.1.3.6.1.2.1.2.2.1.16.10541',161,10031,'ifOutOctets.10541','ifOutOctets.10541',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20470,4,'public','.1.3.6.1.2.1.2.2.1.16.10542',161,10031,'ifOutOctets.10542','ifOutOctets.10542',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20471,4,'public','.1.3.6.1.2.1.2.2.1.16.10543',161,10031,'ifOutOctets.10543','ifOutOctets.10543',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20472,4,'public','.1.3.6.1.2.1.2.2.1.16.10544',161,10031,'ifOutOctets.10544','ifOutOctets.10544',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20473,4,'public','.1.3.6.1.2.1.2.2.1.16.10545',161,10031,'ifOutOctets.10545','ifOutOctets.10545',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20474,4,'public','.1.3.6.1.2.1.2.2.1.16.10546',161,10031,'ifOutOctets.10546','ifOutOctets.10546',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20475,4,'public','.1.3.6.1.2.1.2.2.1.16.10547',161,10031,'ifOutOctets.10547','ifOutOctets.10547',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20476,4,'public','.1.3.6.1.2.1.2.2.1.16.10548',161,10031,'ifOutOctets.10548','ifOutOctets.10548',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20477,4,'public','.1.3.6.1.2.1.2.2.1.16.10601',161,10031,'ifOutOctets.10601','ifOutOctets.10601',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20478,4,'public','.1.3.6.1.2.1.2.2.1.16.10602',161,10031,'ifOutOctets.10602','ifOutOctets.10602',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20479,4,'public','.1.3.6.1.2.1.2.2.1.16.10603',161,10031,'ifOutOctets.10603','ifOutOctets.10603',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20480,4,'public','.1.3.6.1.2.1.2.2.1.16.10604',161,10031,'ifOutOctets.10604','ifOutOctets.10604',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20481,4,'public','.1.3.6.1.2.1.2.2.1.16.12',161,10031,'ifOutOctets.12','ifOutOctets.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20482,4,'public','.1.3.6.1.2.1.2.2.1.16.14501',161,10031,'ifOutOctets.14501','ifOutOctets.14501',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20483,4,'public','.1.3.6.1.2.1.2.2.1.5.1',161,10031,'ifSpeed.1','ifSpeed.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20484,4,'public','.1.3.6.1.2.1.2.2.1.5.10001',161,10031,'ifSpeed.10001','ifSpeed.10001',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20485,4,'public','.1.3.6.1.2.1.2.2.1.5.10002',161,10031,'ifSpeed.10002','ifSpeed.10002',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20486,4,'public','.1.3.6.1.2.1.2.2.1.5.10003',161,10031,'ifSpeed.10003','ifSpeed.10003',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20487,4,'public','.1.3.6.1.2.1.2.2.1.5.10004',161,10031,'ifSpeed.10004','ifSpeed.10004',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20488,4,'public','.1.3.6.1.2.1.2.2.1.5.10005',161,10031,'ifSpeed.10005','ifSpeed.10005',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20489,4,'public','.1.3.6.1.2.1.2.2.1.5.10006',161,10031,'ifSpeed.10006','ifSpeed.10006',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20490,4,'public','.1.3.6.1.2.1.2.2.1.5.10007',161,10031,'ifSpeed.10007','ifSpeed.10007',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20491,4,'public','.1.3.6.1.2.1.2.2.1.5.10008',161,10031,'ifSpeed.10008','ifSpeed.10008',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20492,4,'public','.1.3.6.1.2.1.2.2.1.5.10009',161,10031,'ifSpeed.10009','ifSpeed.10009',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20493,4,'public','.1.3.6.1.2.1.2.2.1.5.10010',161,10031,'ifSpeed.10010','ifSpeed.10010',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20494,4,'public','.1.3.6.1.2.1.2.2.1.5.10011',161,10031,'ifSpeed.10011','ifSpeed.10011',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20495,4,'public','.1.3.6.1.2.1.2.2.1.5.10012',161,10031,'ifSpeed.10012','ifSpeed.10012',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20496,4,'public','.1.3.6.1.2.1.2.2.1.5.10013',161,10031,'ifSpeed.10013','ifSpeed.10013',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20497,4,'public','.1.3.6.1.2.1.2.2.1.5.10014',161,10031,'ifSpeed.10014','ifSpeed.10014',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20498,4,'public','.1.3.6.1.2.1.2.2.1.5.10015',161,10031,'ifSpeed.10015','ifSpeed.10015',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20499,4,'public','.1.3.6.1.2.1.2.2.1.5.10016',161,10031,'ifSpeed.10016','ifSpeed.10016',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20500,4,'public','.1.3.6.1.2.1.2.2.1.5.10017',161,10031,'ifSpeed.10017','ifSpeed.10017',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20501,4,'public','.1.3.6.1.2.1.2.2.1.5.10018',161,10031,'ifSpeed.10018','ifSpeed.10018',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20502,4,'public','.1.3.6.1.2.1.2.2.1.5.10019',161,10031,'ifSpeed.10019','ifSpeed.10019',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20503,4,'public','.1.3.6.1.2.1.2.2.1.5.10020',161,10031,'ifSpeed.10020','ifSpeed.10020',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20504,4,'public','.1.3.6.1.2.1.2.2.1.5.10021',161,10031,'ifSpeed.10021','ifSpeed.10021',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20505,4,'public','.1.3.6.1.2.1.2.2.1.5.10022',161,10031,'ifSpeed.10022','ifSpeed.10022',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20506,4,'public','.1.3.6.1.2.1.2.2.1.5.10023',161,10031,'ifSpeed.10023','ifSpeed.10023',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20507,4,'public','.1.3.6.1.2.1.2.2.1.5.10024',161,10031,'ifSpeed.10024','ifSpeed.10024',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20508,4,'public','.1.3.6.1.2.1.2.2.1.5.10025',161,10031,'ifSpeed.10025','ifSpeed.10025',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20509,4,'public','.1.3.6.1.2.1.2.2.1.5.10026',161,10031,'ifSpeed.10026','ifSpeed.10026',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20510,4,'public','.1.3.6.1.2.1.2.2.1.5.10027',161,10031,'ifSpeed.10027','ifSpeed.10027',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20511,4,'public','.1.3.6.1.2.1.2.2.1.5.10028',161,10031,'ifSpeed.10028','ifSpeed.10028',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20512,4,'public','.1.3.6.1.2.1.2.2.1.5.10029',161,10031,'ifSpeed.10029','ifSpeed.10029',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20513,4,'public','.1.3.6.1.2.1.2.2.1.5.10030',161,10031,'ifSpeed.10030','ifSpeed.10030',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20514,4,'public','.1.3.6.1.2.1.2.2.1.5.10031',161,10031,'ifSpeed.10031','ifSpeed.10031',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20515,4,'public','.1.3.6.1.2.1.2.2.1.5.10032',161,10031,'ifSpeed.10032','ifSpeed.10032',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20516,4,'public','.1.3.6.1.2.1.2.2.1.5.10033',161,10031,'ifSpeed.10033','ifSpeed.10033',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20517,4,'public','.1.3.6.1.2.1.2.2.1.5.10034',161,10031,'ifSpeed.10034','ifSpeed.10034',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20518,4,'public','.1.3.6.1.2.1.2.2.1.5.10035',161,10031,'ifSpeed.10035','ifSpeed.10035',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20519,4,'public','.1.3.6.1.2.1.2.2.1.5.10036',161,10031,'ifSpeed.10036','ifSpeed.10036',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20520,4,'public','.1.3.6.1.2.1.2.2.1.5.10037',161,10031,'ifSpeed.10037','ifSpeed.10037',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20521,4,'public','.1.3.6.1.2.1.2.2.1.5.10038',161,10031,'ifSpeed.10038','ifSpeed.10038',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20522,4,'public','.1.3.6.1.2.1.2.2.1.5.10039',161,10031,'ifSpeed.10039','ifSpeed.10039',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20523,4,'public','.1.3.6.1.2.1.2.2.1.5.10040',161,10031,'ifSpeed.10040','ifSpeed.10040',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20524,4,'public','.1.3.6.1.2.1.2.2.1.5.10041',161,10031,'ifSpeed.10041','ifSpeed.10041',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20525,4,'public','.1.3.6.1.2.1.2.2.1.5.10042',161,10031,'ifSpeed.10042','ifSpeed.10042',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20526,4,'public','.1.3.6.1.2.1.2.2.1.5.10043',161,10031,'ifSpeed.10043','ifSpeed.10043',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20527,4,'public','.1.3.6.1.2.1.2.2.1.5.10044',161,10031,'ifSpeed.10044','ifSpeed.10044',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20528,4,'public','.1.3.6.1.2.1.2.2.1.5.10045',161,10031,'ifSpeed.10045','ifSpeed.10045',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20529,4,'public','.1.3.6.1.2.1.2.2.1.5.10046',161,10031,'ifSpeed.10046','ifSpeed.10046',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20530,4,'public','.1.3.6.1.2.1.2.2.1.5.10047',161,10031,'ifSpeed.10047','ifSpeed.10047',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20531,4,'public','.1.3.6.1.2.1.2.2.1.5.10048',161,10031,'ifSpeed.10048','ifSpeed.10048',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20532,4,'public','.1.3.6.1.2.1.2.2.1.5.10101',161,10031,'ifSpeed.10101','ifSpeed.10101',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20533,4,'public','.1.3.6.1.2.1.2.2.1.5.10102',161,10031,'ifSpeed.10102','ifSpeed.10102',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20534,4,'public','.1.3.6.1.2.1.2.2.1.5.10103',161,10031,'ifSpeed.10103','ifSpeed.10103',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20535,4,'public','.1.3.6.1.2.1.2.2.1.5.10104',161,10031,'ifSpeed.10104','ifSpeed.10104',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20536,4,'public','.1.3.6.1.2.1.2.2.1.5.10501',161,10031,'ifSpeed.10501','ifSpeed.10501',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20537,4,'public','.1.3.6.1.2.1.2.2.1.5.10502',161,10031,'ifSpeed.10502','ifSpeed.10502',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20538,4,'public','.1.3.6.1.2.1.2.2.1.5.10503',161,10031,'ifSpeed.10503','ifSpeed.10503',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20539,4,'public','.1.3.6.1.2.1.2.2.1.5.10504',161,10031,'ifSpeed.10504','ifSpeed.10504',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20540,4,'public','.1.3.6.1.2.1.2.2.1.5.10505',161,10031,'ifSpeed.10505','ifSpeed.10505',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20541,4,'public','.1.3.6.1.2.1.2.2.1.5.10506',161,10031,'ifSpeed.10506','ifSpeed.10506',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20542,4,'public','.1.3.6.1.2.1.2.2.1.5.10507',161,10031,'ifSpeed.10507','ifSpeed.10507',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20543,4,'public','.1.3.6.1.2.1.2.2.1.5.10508',161,10031,'ifSpeed.10508','ifSpeed.10508',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20544,4,'public','.1.3.6.1.2.1.2.2.1.5.10509',161,10031,'ifSpeed.10509','ifSpeed.10509',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20545,4,'public','.1.3.6.1.2.1.2.2.1.5.10510',161,10031,'ifSpeed.10510','ifSpeed.10510',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20546,4,'public','.1.3.6.1.2.1.2.2.1.5.10511',161,10031,'ifSpeed.10511','ifSpeed.10511',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20547,4,'public','.1.3.6.1.2.1.2.2.1.5.10512',161,10031,'ifSpeed.10512','ifSpeed.10512',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20548,4,'public','.1.3.6.1.2.1.2.2.1.5.10513',161,10031,'ifSpeed.10513','ifSpeed.10513',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20549,4,'public','.1.3.6.1.2.1.2.2.1.5.10514',161,10031,'ifSpeed.10514','ifSpeed.10514',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20550,4,'public','.1.3.6.1.2.1.2.2.1.5.10515',161,10031,'ifSpeed.10515','ifSpeed.10515',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20551,4,'public','.1.3.6.1.2.1.2.2.1.5.10516',161,10031,'ifSpeed.10516','ifSpeed.10516',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20552,4,'public','.1.3.6.1.2.1.2.2.1.5.10517',161,10031,'ifSpeed.10517','ifSpeed.10517',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20553,4,'public','.1.3.6.1.2.1.2.2.1.5.10518',161,10031,'ifSpeed.10518','ifSpeed.10518',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20554,4,'public','.1.3.6.1.2.1.2.2.1.5.10519',161,10031,'ifSpeed.10519','ifSpeed.10519',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20555,4,'public','.1.3.6.1.2.1.2.2.1.5.10520',161,10031,'ifSpeed.10520','ifSpeed.10520',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20556,4,'public','.1.3.6.1.2.1.2.2.1.5.10521',161,10031,'ifSpeed.10521','ifSpeed.10521',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20557,4,'public','.1.3.6.1.2.1.2.2.1.5.10522',161,10031,'ifSpeed.10522','ifSpeed.10522',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20558,4,'public','.1.3.6.1.2.1.2.2.1.5.10523',161,10031,'ifSpeed.10523','ifSpeed.10523',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20559,4,'public','.1.3.6.1.2.1.2.2.1.5.10524',161,10031,'ifSpeed.10524','ifSpeed.10524',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20560,4,'public','.1.3.6.1.2.1.2.2.1.5.10525',161,10031,'ifSpeed.10525','ifSpeed.10525',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20561,4,'public','.1.3.6.1.2.1.2.2.1.5.10526',161,10031,'ifSpeed.10526','ifSpeed.10526',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20562,4,'public','.1.3.6.1.2.1.2.2.1.5.10527',161,10031,'ifSpeed.10527','ifSpeed.10527',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20563,4,'public','.1.3.6.1.2.1.2.2.1.5.10528',161,10031,'ifSpeed.10528','ifSpeed.10528',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20564,4,'public','.1.3.6.1.2.1.2.2.1.5.10529',161,10031,'ifSpeed.10529','ifSpeed.10529',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20565,4,'public','.1.3.6.1.2.1.2.2.1.5.10530',161,10031,'ifSpeed.10530','ifSpeed.10530',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20566,4,'public','.1.3.6.1.2.1.2.2.1.5.10531',161,10031,'ifSpeed.10531','ifSpeed.10531',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20567,4,'public','.1.3.6.1.2.1.2.2.1.5.10532',161,10031,'ifSpeed.10532','ifSpeed.10532',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20568,4,'public','.1.3.6.1.2.1.2.2.1.5.10533',161,10031,'ifSpeed.10533','ifSpeed.10533',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20569,4,'public','.1.3.6.1.2.1.2.2.1.5.10534',161,10031,'ifSpeed.10534','ifSpeed.10534',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20570,4,'public','.1.3.6.1.2.1.2.2.1.5.10535',161,10031,'ifSpeed.10535','ifSpeed.10535',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20571,4,'public','.1.3.6.1.2.1.2.2.1.5.10536',161,10031,'ifSpeed.10536','ifSpeed.10536',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20572,4,'public','.1.3.6.1.2.1.2.2.1.5.10537',161,10031,'ifSpeed.10537','ifSpeed.10537',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20573,4,'public','.1.3.6.1.2.1.2.2.1.5.10538',161,10031,'ifSpeed.10538','ifSpeed.10538',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20574,4,'public','.1.3.6.1.2.1.2.2.1.5.10539',161,10031,'ifSpeed.10539','ifSpeed.10539',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20575,4,'public','.1.3.6.1.2.1.2.2.1.5.10540',161,10031,'ifSpeed.10540','ifSpeed.10540',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20576,4,'public','.1.3.6.1.2.1.2.2.1.5.10541',161,10031,'ifSpeed.10541','ifSpeed.10541',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20577,4,'public','.1.3.6.1.2.1.2.2.1.5.10542',161,10031,'ifSpeed.10542','ifSpeed.10542',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20578,4,'public','.1.3.6.1.2.1.2.2.1.5.10543',161,10031,'ifSpeed.10543','ifSpeed.10543',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20579,4,'public','.1.3.6.1.2.1.2.2.1.5.10544',161,10031,'ifSpeed.10544','ifSpeed.10544',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20580,4,'public','.1.3.6.1.2.1.2.2.1.5.10545',161,10031,'ifSpeed.10545','ifSpeed.10545',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20581,4,'public','.1.3.6.1.2.1.2.2.1.5.10546',161,10031,'ifSpeed.10546','ifSpeed.10546',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20582,4,'public','.1.3.6.1.2.1.2.2.1.5.10547',161,10031,'ifSpeed.10547','ifSpeed.10547',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20583,4,'public','.1.3.6.1.2.1.2.2.1.5.10548',161,10031,'ifSpeed.10548','ifSpeed.10548',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20584,4,'public','.1.3.6.1.2.1.2.2.1.5.10601',161,10031,'ifSpeed.10601','ifSpeed.10601',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20585,4,'public','.1.3.6.1.2.1.2.2.1.5.10602',161,10031,'ifSpeed.10602','ifSpeed.10602',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20586,4,'public','.1.3.6.1.2.1.2.2.1.5.10603',161,10031,'ifSpeed.10603','ifSpeed.10603',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20587,4,'public','.1.3.6.1.2.1.2.2.1.5.10604',161,10031,'ifSpeed.10604','ifSpeed.10604',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20588,4,'public','.1.3.6.1.2.1.2.2.1.5.12',161,10031,'ifSpeed.12','ifSpeed.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20589,4,'public','.1.3.6.1.2.1.2.2.1.5.14501',161,10031,'ifSpeed.14501','ifSpeed.14501',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20590,4,'public','.1.3.6.1.2.1.2.2.1.3.1',161,10031,'ifType.1','ifType.1',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20591,4,'public','.1.3.6.1.2.1.2.2.1.3.10001',161,10031,'ifType.10001','ifType.10001',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20592,4,'public','.1.3.6.1.2.1.2.2.1.3.10002',161,10031,'ifType.10002','ifType.10002',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20593,4,'public','.1.3.6.1.2.1.2.2.1.3.10003',161,10031,'ifType.10003','ifType.10003',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20594,4,'public','.1.3.6.1.2.1.2.2.1.3.10004',161,10031,'ifType.10004','ifType.10004',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20595,4,'public','.1.3.6.1.2.1.2.2.1.3.10005',161,10031,'ifType.10005','ifType.10005',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20596,4,'public','.1.3.6.1.2.1.2.2.1.3.10006',161,10031,'ifType.10006','ifType.10006',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20597,4,'public','.1.3.6.1.2.1.2.2.1.3.10007',161,10031,'ifType.10007','ifType.10007',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20598,4,'public','.1.3.6.1.2.1.2.2.1.3.10008',161,10031,'ifType.10008','ifType.10008',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20599,4,'public','.1.3.6.1.2.1.2.2.1.3.10009',161,10031,'ifType.10009','ifType.10009',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20600,4,'public','.1.3.6.1.2.1.2.2.1.3.10010',161,10031,'ifType.10010','ifType.10010',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20601,4,'public','.1.3.6.1.2.1.2.2.1.3.10011',161,10031,'ifType.10011','ifType.10011',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20602,4,'public','.1.3.6.1.2.1.2.2.1.3.10012',161,10031,'ifType.10012','ifType.10012',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20603,4,'public','.1.3.6.1.2.1.2.2.1.3.10013',161,10031,'ifType.10013','ifType.10013',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20604,4,'public','.1.3.6.1.2.1.2.2.1.3.10014',161,10031,'ifType.10014','ifType.10014',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20605,4,'public','.1.3.6.1.2.1.2.2.1.3.10015',161,10031,'ifType.10015','ifType.10015',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20606,4,'public','.1.3.6.1.2.1.2.2.1.3.10016',161,10031,'ifType.10016','ifType.10016',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20607,4,'public','.1.3.6.1.2.1.2.2.1.3.10017',161,10031,'ifType.10017','ifType.10017',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20608,4,'public','.1.3.6.1.2.1.2.2.1.3.10018',161,10031,'ifType.10018','ifType.10018',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20609,4,'public','.1.3.6.1.2.1.2.2.1.3.10019',161,10031,'ifType.10019','ifType.10019',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20610,4,'public','.1.3.6.1.2.1.2.2.1.3.10020',161,10031,'ifType.10020','ifType.10020',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20611,4,'public','.1.3.6.1.2.1.2.2.1.3.10021',161,10031,'ifType.10021','ifType.10021',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20612,4,'public','.1.3.6.1.2.1.2.2.1.3.10022',161,10031,'ifType.10022','ifType.10022',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20613,4,'public','.1.3.6.1.2.1.2.2.1.3.10023',161,10031,'ifType.10023','ifType.10023',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20614,4,'public','.1.3.6.1.2.1.2.2.1.3.10024',161,10031,'ifType.10024','ifType.10024',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20615,4,'public','.1.3.6.1.2.1.2.2.1.3.10025',161,10031,'ifType.10025','ifType.10025',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20616,4,'public','.1.3.6.1.2.1.2.2.1.3.10026',161,10031,'ifType.10026','ifType.10026',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20617,4,'public','.1.3.6.1.2.1.2.2.1.3.10027',161,10031,'ifType.10027','ifType.10027',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20618,4,'public','.1.3.6.1.2.1.2.2.1.3.10028',161,10031,'ifType.10028','ifType.10028',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20619,4,'public','.1.3.6.1.2.1.2.2.1.3.10029',161,10031,'ifType.10029','ifType.10029',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20620,4,'public','.1.3.6.1.2.1.2.2.1.3.10030',161,10031,'ifType.10030','ifType.10030',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20621,4,'public','.1.3.6.1.2.1.2.2.1.3.10031',161,10031,'ifType.10031','ifType.10031',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20622,4,'public','.1.3.6.1.2.1.2.2.1.3.10032',161,10031,'ifType.10032','ifType.10032',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20623,4,'public','.1.3.6.1.2.1.2.2.1.3.10033',161,10031,'ifType.10033','ifType.10033',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20624,4,'public','.1.3.6.1.2.1.2.2.1.3.10034',161,10031,'ifType.10034','ifType.10034',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20625,4,'public','.1.3.6.1.2.1.2.2.1.3.10035',161,10031,'ifType.10035','ifType.10035',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20626,4,'public','.1.3.6.1.2.1.2.2.1.3.10036',161,10031,'ifType.10036','ifType.10036',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20627,4,'public','.1.3.6.1.2.1.2.2.1.3.10037',161,10031,'ifType.10037','ifType.10037',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20628,4,'public','.1.3.6.1.2.1.2.2.1.3.10038',161,10031,'ifType.10038','ifType.10038',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20629,4,'public','.1.3.6.1.2.1.2.2.1.3.10039',161,10031,'ifType.10039','ifType.10039',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20630,4,'public','.1.3.6.1.2.1.2.2.1.3.10040',161,10031,'ifType.10040','ifType.10040',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20631,4,'public','.1.3.6.1.2.1.2.2.1.3.10041',161,10031,'ifType.10041','ifType.10041',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20632,4,'public','.1.3.6.1.2.1.2.2.1.3.10042',161,10031,'ifType.10042','ifType.10042',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20633,4,'public','.1.3.6.1.2.1.2.2.1.3.10043',161,10031,'ifType.10043','ifType.10043',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20634,4,'public','.1.3.6.1.2.1.2.2.1.3.10044',161,10031,'ifType.10044','ifType.10044',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20635,4,'public','.1.3.6.1.2.1.2.2.1.3.10045',161,10031,'ifType.10045','ifType.10045',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20636,4,'public','.1.3.6.1.2.1.2.2.1.3.10046',161,10031,'ifType.10046','ifType.10046',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20637,4,'public','.1.3.6.1.2.1.2.2.1.3.10047',161,10031,'ifType.10047','ifType.10047',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20638,4,'public','.1.3.6.1.2.1.2.2.1.3.10048',161,10031,'ifType.10048','ifType.10048',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20639,4,'public','.1.3.6.1.2.1.2.2.1.3.10101',161,10031,'ifType.10101','ifType.10101',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20640,4,'public','.1.3.6.1.2.1.2.2.1.3.10102',161,10031,'ifType.10102','ifType.10102',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20641,4,'public','.1.3.6.1.2.1.2.2.1.3.10103',161,10031,'ifType.10103','ifType.10103',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20642,4,'public','.1.3.6.1.2.1.2.2.1.3.10104',161,10031,'ifType.10104','ifType.10104',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20643,4,'public','.1.3.6.1.2.1.2.2.1.3.10501',161,10031,'ifType.10501','ifType.10501',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20644,4,'public','.1.3.6.1.2.1.2.2.1.3.10502',161,10031,'ifType.10502','ifType.10502',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20645,4,'public','.1.3.6.1.2.1.2.2.1.3.10503',161,10031,'ifType.10503','ifType.10503',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20646,4,'public','.1.3.6.1.2.1.2.2.1.3.10504',161,10031,'ifType.10504','ifType.10504',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20647,4,'public','.1.3.6.1.2.1.2.2.1.3.10505',161,10031,'ifType.10505','ifType.10505',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20648,4,'public','.1.3.6.1.2.1.2.2.1.3.10506',161,10031,'ifType.10506','ifType.10506',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20649,4,'public','.1.3.6.1.2.1.2.2.1.3.10507',161,10031,'ifType.10507','ifType.10507',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20650,4,'public','.1.3.6.1.2.1.2.2.1.3.10508',161,10031,'ifType.10508','ifType.10508',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20651,4,'public','.1.3.6.1.2.1.2.2.1.3.10509',161,10031,'ifType.10509','ifType.10509',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20652,4,'public','.1.3.6.1.2.1.2.2.1.3.10510',161,10031,'ifType.10510','ifType.10510',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20653,4,'public','.1.3.6.1.2.1.2.2.1.3.10511',161,10031,'ifType.10511','ifType.10511',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20654,4,'public','.1.3.6.1.2.1.2.2.1.3.10512',161,10031,'ifType.10512','ifType.10512',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20655,4,'public','.1.3.6.1.2.1.2.2.1.3.10513',161,10031,'ifType.10513','ifType.10513',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20656,4,'public','.1.3.6.1.2.1.2.2.1.3.10514',161,10031,'ifType.10514','ifType.10514',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20657,4,'public','.1.3.6.1.2.1.2.2.1.3.10515',161,10031,'ifType.10515','ifType.10515',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20658,4,'public','.1.3.6.1.2.1.2.2.1.3.10516',161,10031,'ifType.10516','ifType.10516',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20659,4,'public','.1.3.6.1.2.1.2.2.1.3.10517',161,10031,'ifType.10517','ifType.10517',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20660,4,'public','.1.3.6.1.2.1.2.2.1.3.10518',161,10031,'ifType.10518','ifType.10518',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20661,4,'public','.1.3.6.1.2.1.2.2.1.3.10519',161,10031,'ifType.10519','ifType.10519',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20662,4,'public','.1.3.6.1.2.1.2.2.1.3.10520',161,10031,'ifType.10520','ifType.10520',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20663,4,'public','.1.3.6.1.2.1.2.2.1.3.10521',161,10031,'ifType.10521','ifType.10521',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20664,4,'public','.1.3.6.1.2.1.2.2.1.3.10522',161,10031,'ifType.10522','ifType.10522',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20665,4,'public','.1.3.6.1.2.1.2.2.1.3.10523',161,10031,'ifType.10523','ifType.10523',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20666,4,'public','.1.3.6.1.2.1.2.2.1.3.10524',161,10031,'ifType.10524','ifType.10524',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20667,4,'public','.1.3.6.1.2.1.2.2.1.3.10525',161,10031,'ifType.10525','ifType.10525',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20668,4,'public','.1.3.6.1.2.1.2.2.1.3.10526',161,10031,'ifType.10526','ifType.10526',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20669,4,'public','.1.3.6.1.2.1.2.2.1.3.10527',161,10031,'ifType.10527','ifType.10527',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20670,4,'public','.1.3.6.1.2.1.2.2.1.3.10528',161,10031,'ifType.10528','ifType.10528',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20671,4,'public','.1.3.6.1.2.1.2.2.1.3.10529',161,10031,'ifType.10529','ifType.10529',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20672,4,'public','.1.3.6.1.2.1.2.2.1.3.10530',161,10031,'ifType.10530','ifType.10530',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20673,4,'public','.1.3.6.1.2.1.2.2.1.3.10531',161,10031,'ifType.10531','ifType.10531',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20674,4,'public','.1.3.6.1.2.1.2.2.1.3.10532',161,10031,'ifType.10532','ifType.10532',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20675,4,'public','.1.3.6.1.2.1.2.2.1.3.10533',161,10031,'ifType.10533','ifType.10533',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20676,4,'public','.1.3.6.1.2.1.2.2.1.3.10534',161,10031,'ifType.10534','ifType.10534',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20677,4,'public','.1.3.6.1.2.1.2.2.1.3.10535',161,10031,'ifType.10535','ifType.10535',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20678,4,'public','.1.3.6.1.2.1.2.2.1.3.10536',161,10031,'ifType.10536','ifType.10536',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20679,4,'public','.1.3.6.1.2.1.2.2.1.3.10537',161,10031,'ifType.10537','ifType.10537',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20680,4,'public','.1.3.6.1.2.1.2.2.1.3.10538',161,10031,'ifType.10538','ifType.10538',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20681,4,'public','.1.3.6.1.2.1.2.2.1.3.10539',161,10031,'ifType.10539','ifType.10539',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20682,4,'public','.1.3.6.1.2.1.2.2.1.3.10540',161,10031,'ifType.10540','ifType.10540',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20683,4,'public','.1.3.6.1.2.1.2.2.1.3.10541',161,10031,'ifType.10541','ifType.10541',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20684,4,'public','.1.3.6.1.2.1.2.2.1.3.10542',161,10031,'ifType.10542','ifType.10542',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20685,4,'public','.1.3.6.1.2.1.2.2.1.3.10543',161,10031,'ifType.10543','ifType.10543',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20686,4,'public','.1.3.6.1.2.1.2.2.1.3.10544',161,10031,'ifType.10544','ifType.10544',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20687,4,'public','.1.3.6.1.2.1.2.2.1.3.10545',161,10031,'ifType.10545','ifType.10545',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20688,4,'public','.1.3.6.1.2.1.2.2.1.3.10546',161,10031,'ifType.10546','ifType.10546',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20689,4,'public','.1.3.6.1.2.1.2.2.1.3.10547',161,10031,'ifType.10547','ifType.10547',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20690,4,'public','.1.3.6.1.2.1.2.2.1.3.10548',161,10031,'ifType.10548','ifType.10548',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20691,4,'public','.1.3.6.1.2.1.2.2.1.3.10601',161,10031,'ifType.10601','ifType.10601',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20692,4,'public','.1.3.6.1.2.1.2.2.1.3.10602',161,10031,'ifType.10602','ifType.10602',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20693,4,'public','.1.3.6.1.2.1.2.2.1.3.10603',161,10031,'ifType.10603','ifType.10603',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20694,4,'public','.1.3.6.1.2.1.2.2.1.3.10604',161,10031,'ifType.10604','ifType.10604',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20695,4,'public','.1.3.6.1.2.1.2.2.1.3.12',161,10031,'ifType.12','ifType.12',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20696,4,'public','.1.3.6.1.2.1.2.2.1.3.14501',161,10031,'ifType.14501','ifType.14501',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20697,4,'public','.1.3.6.1.2.1.1.4.0',161,10031,'sysContact.0','sysContact.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20698,4,'public','.1.3.6.1.2.1.1.1.0',161,10031,'sysDescr.0','sysDescr.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20699,4,'public','.1.3.6.1.2.1.1.6.0',161,10031,'sysLocation.0','sysLocation.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20700,4,'public','.1.3.6.1.2.1.1.5.0',161,10031,'sysName.0','sysName.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20701,4,'public','.1.3.6.1.2.1.1.8.0',161,10031,'sysORLastChange.0','sysORLastChange.0',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20702,4,'public','.1.3.6.1.2.1.1.3.0',161,10031,'sysUpTime.sysUpTimeInstance','sysUpTime.sysUpTimeInstance',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20703,1,'public','.1.3.6.1.4.1.9.9.147.1.2.2.2.1.5.40.6',161,10032,'Connections','Connections',60,30,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20704,1,'public','1.3.6.1.4.1.9.9.109.1.1.1.1.3.1',161,10032,'CPU usage','cpuUsage',30,30,365,NULL,NULL,NULL,0,0,'','%',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20705,1,'public','.1.3.6.1.2.1.2.2.1.2.1',161,10032,'ifDescr.1','ifDescr.1',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20706,1,'public','.1.3.6.1.2.1.2.2.1.2.2',161,10032,'ifDescr.2','ifDescr.2',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20707,1,'public','.1.3.6.1.2.1.2.2.1.2.3',161,10032,'ifDescr.3','ifDescr.3',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20708,1,'public','.1.3.6.1.2.1.2.2.1.2.4',161,10032,'ifDescr.4','ifDescr.4',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20709,1,'public','.1.3.6.1.2.1.2.2.1.2.5',161,10032,'ifDescr.5','ifDescr.5',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20710,1,'public','.1.3.6.1.2.1.2.2.1.2.6',161,10032,'ifDescr.6','ifDescr.6',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20711,1,'public','.1.3.6.1.2.1.2.2.1.10.1',161,10032,'ifInOctets.1','ifInOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20712,1,'public','.1.3.6.1.2.1.2.2.1.10.2',161,10032,'ifInOctets.2','ifInOctets.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20713,1,'public','.1.3.6.1.2.1.2.2.1.10.3',161,10032,'ifInOctets.3','ifInOctets.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20714,1,'public','.1.3.6.1.2.1.2.2.1.10.4',161,10032,'ifInOctets.4','ifInOctets.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20715,1,'public','.1.3.6.1.2.1.2.2.1.10.5',161,10032,'ifInOctets.5','ifInOctets.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20716,1,'public','.1.3.6.1.2.1.2.2.1.10.6',161,10032,'ifInOctets.6','ifInOctets.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20717,1,'public','.1.3.6.1.2.1.2.1.0',161,10032,'ifNumber.0','ifNumber.0',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20718,1,'public','.1.3.6.1.2.1.2.2.1.8.1',161,10032,'ifOperStatus.1','ifOperStatus.1',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20719,1,'public','.1.3.6.1.2.1.2.2.1.8.2',161,10032,'ifOperStatus.2','ifOperStatus.2',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20720,1,'public','.1.3.6.1.2.1.2.2.1.8.3',161,10032,'ifOperStatus.3','ifOperStatus.3',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20721,1,'public','.1.3.6.1.2.1.2.2.1.8.4',161,10032,'ifOperStatus.4','ifOperStatus.4',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20722,1,'public','.1.3.6.1.2.1.2.2.1.8.5',161,10032,'ifOperStatus.5','ifOperStatus.5',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20723,1,'public','.1.3.6.1.2.1.2.2.1.8.6',161,10032,'ifOperStatus.6','ifOperStatus.6',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20724,1,'public','.1.3.6.1.2.1.2.2.1.16.1',161,10032,'ifOutOctets.1','ifOutOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20725,1,'public','.1.3.6.1.2.1.2.2.1.16.2',161,10032,'ifOutOctets.2','ifOutOctets.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20726,1,'public','.1.3.6.1.2.1.2.2.1.16.3',161,10032,'ifOutOctets.3','ifOutOctets.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20727,1,'public','.1.3.6.1.2.1.2.2.1.16.4',161,10032,'ifOutOctets.4','ifOutOctets.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20728,1,'public','.1.3.6.1.2.1.2.2.1.16.5',161,10032,'ifOutOctets.5','ifOutOctets.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20729,1,'public','.1.3.6.1.2.1.2.2.1.16.6',161,10032,'ifOutOctets.6','ifOutOctets.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20730,1,'public','.1.3.6.1.2.1.2.2.1.5.1',161,10032,'ifSpeed.1','ifSpeed.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20731,1,'public','.1.3.6.1.2.1.2.2.1.5.2',161,10032,'ifSpeed.2','ifSpeed.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20732,1,'public','.1.3.6.1.2.1.2.2.1.5.3',161,10032,'ifSpeed.3','ifSpeed.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20733,1,'public','.1.3.6.1.2.1.2.2.1.5.4',161,10032,'ifSpeed.4','ifSpeed.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20734,1,'public','.1.3.6.1.2.1.2.2.1.5.5',161,10032,'ifSpeed.5','ifSpeed.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20735,1,'public','.1.3.6.1.2.1.2.2.1.5.6',161,10032,'ifSpeed.6','ifSpeed.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20736,1,'public','.1.3.6.1.2.1.2.2.1.3.1',161,10032,'ifType.1','ifType.1',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20737,1,'public','.1.3.6.1.2.1.2.2.1.3.2',161,10032,'ifType.2','ifType.2',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20738,1,'public','.1.3.6.1.2.1.2.2.1.3.3',161,10032,'ifType.3','ifType.3',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20739,1,'public','.1.3.6.1.2.1.2.2.1.3.4',161,10032,'ifType.4','ifType.4',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20740,1,'public','.1.3.6.1.2.1.2.2.1.3.5',161,10032,'ifType.5','ifType.5',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20741,1,'public','.1.3.6.1.2.1.2.2.1.3.6',161,10032,'ifType.6','ifType.6',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20742,1,'public','.1.3.6.1.4.1.9.9.48.1.1.1.6.1',161,10032,'Available Free Processor Memory','memory.Free',60,30,365,NULL,NULL,NULL,0,3,'','B',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20743,1,'public','.1.3.6.1.4.1.9.9.48.1.1.1.5.1',161,10032,'I/O Memory','memory.IO',60,30,365,NULL,NULL,NULL,0,3,'','B',1,0,NULL,'',0,'','','0.3','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20744,1,'public','1.3.6.1.2.1.1.1.0',161,10032,'PIX Firmware Level','software.Version',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20745,1,'public','.1.3.6.1.2.1.1.4.0',161,10032,'sysContact.0','sysContact.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20746,1,'public','.1.3.6.1.2.1.1.1.0',161,10032,'sysDescr.0','sysDescr.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20747,1,'public','.1.3.6.1.2.1.1.6.0',161,10032,'sysLocation.0','sysLocation.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20748,1,'public','.1.3.6.1.2.1.1.5.0',161,10032,'sysName.0','sysName.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20749,1,'public','1.3.6.1.2.1.47.1.1.1.1.11.1',161,10032,'Serial Number','system.Serial',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20750,1,'public','.1.3.6.1.2.1.1.3.0',161,10032,'sysUpTime.sysUpTimeInstance','sysUpTime.sysUpTimeInstance',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20751,4,'public','.1.3.6.1.2.1.47.1.1.1.1.11.101',161,10033,'11.101','11.101',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20752,4,'public','.1.3.6.1.2.1.47.1.1.1.1.9.201',161,10033,'9.201','9.201',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20753,4,'public','.1.3.6.1.2.1.31.1.1.1.18.1',161,10033,'ifAlias.1','ifAlias.1',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20754,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10',161,10033,'ifAlias.10','ifAlias.10',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20755,4,'public','.1.3.6.1.2.1.31.1.1.1.18.1001',161,10033,'ifAlias.1001','ifAlias.1001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20756,4,'public','.1.3.6.1.2.1.31.1.1.1.18.11',161,10033,'ifAlias.11','ifAlias.11',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20757,4,'public','.1.3.6.1.2.1.31.1.1.1.18.12',161,10033,'ifAlias.12','ifAlias.12',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20758,4,'public','.1.3.6.1.2.1.31.1.1.1.18.13',161,10033,'ifAlias.13','ifAlias.13',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20759,4,'public','.1.3.6.1.2.1.31.1.1.1.18.14',161,10033,'ifAlias.14','ifAlias.14',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20760,4,'public','.1.3.6.1.2.1.31.1.1.1.18.15',161,10033,'ifAlias.15','ifAlias.15',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20761,4,'public','.1.3.6.1.2.1.31.1.1.1.18.16',161,10033,'ifAlias.16','ifAlias.16',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20762,4,'public','.1.3.6.1.2.1.31.1.1.1.18.17',161,10033,'ifAlias.17','ifAlias.17',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20763,4,'public','.1.3.6.1.2.1.31.1.1.1.18.18',161,10033,'ifAlias.18','ifAlias.18',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20764,4,'public','.1.3.6.1.2.1.31.1.1.1.18.19',161,10033,'ifAlias.19','ifAlias.19',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20765,4,'public','.1.3.6.1.2.1.31.1.1.1.18.2',161,10033,'ifAlias.2','ifAlias.2',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20766,4,'public','.1.3.6.1.2.1.31.1.1.1.18.20',161,10033,'ifAlias.20','ifAlias.20',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20767,4,'public','.1.3.6.1.2.1.31.1.1.1.18.21',161,10033,'ifAlias.21','ifAlias.21',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20768,4,'public','.1.3.6.1.2.1.31.1.1.1.18.22',161,10033,'ifAlias.22','ifAlias.22',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20769,4,'public','.1.3.6.1.2.1.31.1.1.1.18.23',161,10033,'ifAlias.23','ifAlias.23',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20770,4,'public','.1.3.6.1.2.1.31.1.1.1.18.24',161,10033,'ifAlias.24','ifAlias.24',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20771,4,'public','.1.3.6.1.2.1.31.1.1.1.18.3',161,10033,'ifAlias.3','ifAlias.3',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20772,4,'public','.1.3.6.1.2.1.31.1.1.1.18.31',161,10033,'ifAlias.31','ifAlias.31',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20773,4,'public','.1.3.6.1.2.1.31.1.1.1.18.4',161,10033,'ifAlias.4','ifAlias.4',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20774,4,'public','.1.3.6.1.2.1.31.1.1.1.18.5',161,10033,'ifAlias.5','ifAlias.5',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20775,4,'public','.1.3.6.1.2.1.31.1.1.1.18.6',161,10033,'ifAlias.6','ifAlias.6',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20776,4,'public','.1.3.6.1.2.1.31.1.1.1.18.7',161,10033,'ifAlias.7','ifAlias.7',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20777,4,'public','.1.3.6.1.2.1.31.1.1.1.18.8',161,10033,'ifAlias.8','ifAlias.8',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20778,4,'public','.1.3.6.1.2.1.31.1.1.1.18.9',161,10033,'ifAlias.9','ifAlias.9',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20779,4,'public','.1.3.6.1.2.1.2.2.1.2.1',161,10033,'ifDescr.1','ifDescr.1',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20780,4,'public','.1.3.6.1.2.1.2.2.1.2.10',161,10033,'ifDescr.10','ifDescr.10',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20781,4,'public','.1.3.6.1.2.1.2.2.1.2.1001',161,10033,'ifDescr.1001','ifDescr.1001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20782,4,'public','.1.3.6.1.2.1.2.2.1.2.11',161,10033,'ifDescr.11','ifDescr.11',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20783,4,'public','.1.3.6.1.2.1.2.2.1.2.12',161,10033,'ifDescr.12','ifDescr.12',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20784,4,'public','.1.3.6.1.2.1.2.2.1.2.13',161,10033,'ifDescr.13','ifDescr.13',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20785,4,'public','.1.3.6.1.2.1.2.2.1.2.14',161,10033,'ifDescr.14','ifDescr.14',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20786,4,'public','.1.3.6.1.2.1.2.2.1.2.15',161,10033,'ifDescr.15','ifDescr.15',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20787,4,'public','.1.3.6.1.2.1.2.2.1.2.16',161,10033,'ifDescr.16','ifDescr.16',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20788,4,'public','.1.3.6.1.2.1.2.2.1.2.17',161,10033,'ifDescr.17','ifDescr.17',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20789,4,'public','.1.3.6.1.2.1.2.2.1.2.18',161,10033,'ifDescr.18','ifDescr.18',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20790,4,'public','.1.3.6.1.2.1.2.2.1.2.19',161,10033,'ifDescr.19','ifDescr.19',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20791,4,'public','.1.3.6.1.2.1.2.2.1.2.2',161,10033,'ifDescr.2','ifDescr.2',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20792,4,'public','.1.3.6.1.2.1.2.2.1.2.20',161,10033,'ifDescr.20','ifDescr.20',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20793,4,'public','.1.3.6.1.2.1.2.2.1.2.21',161,10033,'ifDescr.21','ifDescr.21',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20794,4,'public','.1.3.6.1.2.1.2.2.1.2.22',161,10033,'ifDescr.22','ifDescr.22',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20795,4,'public','.1.3.6.1.2.1.2.2.1.2.23',161,10033,'ifDescr.23','ifDescr.23',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20796,4,'public','.1.3.6.1.2.1.2.2.1.2.24',161,10033,'ifDescr.24','ifDescr.24',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20797,4,'public','.1.3.6.1.2.1.2.2.1.2.3',161,10033,'ifDescr.3','ifDescr.3',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20798,4,'public','.1.3.6.1.2.1.2.2.1.2.31',161,10033,'ifDescr.31','ifDescr.31',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20799,4,'public','.1.3.6.1.2.1.2.2.1.2.4',161,10033,'ifDescr.4','ifDescr.4',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20800,4,'public','.1.3.6.1.2.1.2.2.1.2.5',161,10033,'ifDescr.5','ifDescr.5',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20801,4,'public','.1.3.6.1.2.1.2.2.1.2.6',161,10033,'ifDescr.6','ifDescr.6',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20802,4,'public','.1.3.6.1.2.1.2.2.1.2.7',161,10033,'ifDescr.7','ifDescr.7',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20803,4,'public','.1.3.6.1.2.1.2.2.1.2.8',161,10033,'ifDescr.8','ifDescr.8',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20804,4,'public','.1.3.6.1.2.1.2.2.1.2.9',161,10033,'ifDescr.9','ifDescr.9',600,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20805,4,'public','.1.3.6.1.2.1.2.2.1.10.1',161,10033,'ifInOctets.1','ifInOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20806,4,'public','.1.3.6.1.2.1.2.2.1.10.10',161,10033,'ifInOctets.10','ifInOctets.10',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20807,4,'public','.1.3.6.1.2.1.2.2.1.10.1001',161,10033,'ifInOctets.1001','ifInOctets.1001',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20808,4,'public','.1.3.6.1.2.1.2.2.1.10.11',161,10033,'ifInOctets.11','ifInOctets.11',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20809,4,'public','.1.3.6.1.2.1.2.2.1.10.12',161,10033,'ifInOctets.12','ifInOctets.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20810,4,'public','.1.3.6.1.2.1.2.2.1.10.13',161,10033,'ifInOctets.13','ifInOctets.13',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20811,4,'public','.1.3.6.1.2.1.2.2.1.10.14',161,10033,'ifInOctets.14','ifInOctets.14',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20812,4,'public','.1.3.6.1.2.1.2.2.1.10.15',161,10033,'ifInOctets.15','ifInOctets.15',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20813,4,'public','.1.3.6.1.2.1.2.2.1.10.16',161,10033,'ifInOctets.16','ifInOctets.16',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20814,4,'public','.1.3.6.1.2.1.2.2.1.10.17',161,10033,'ifInOctets.17','ifInOctets.17',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20815,4,'public','.1.3.6.1.2.1.2.2.1.10.18',161,10033,'ifInOctets.18','ifInOctets.18',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20816,4,'public','.1.3.6.1.2.1.2.2.1.10.19',161,10033,'ifInOctets.19','ifInOctets.19',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20817,4,'public','.1.3.6.1.2.1.2.2.1.10.2',161,10033,'ifInOctets.2','ifInOctets.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20818,4,'public','.1.3.6.1.2.1.2.2.1.10.20',161,10033,'ifInOctets.20','ifInOctets.20',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20819,4,'public','.1.3.6.1.2.1.2.2.1.10.21',161,10033,'ifInOctets.21','ifInOctets.21',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20820,4,'public','.1.3.6.1.2.1.2.2.1.10.22',161,10033,'ifInOctets.22','ifInOctets.22',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20821,4,'public','.1.3.6.1.2.1.2.2.1.10.23',161,10033,'ifInOctets.23','ifInOctets.23',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20822,4,'public','.1.3.6.1.2.1.2.2.1.10.24',161,10033,'ifInOctets.24','ifInOctets.24',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20823,4,'public','.1.3.6.1.2.1.2.2.1.10.3',161,10033,'ifInOctets.3','ifInOctets.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20824,4,'public','.1.3.6.1.2.1.2.2.1.10.31',161,10033,'ifInOctets.31','ifInOctets.31',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20825,4,'public','.1.3.6.1.2.1.2.2.1.10.4',161,10033,'ifInOctets.4','ifInOctets.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20826,4,'public','.1.3.6.1.2.1.2.2.1.10.5',161,10033,'ifInOctets.5','ifInOctets.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20827,4,'public','.1.3.6.1.2.1.2.2.1.10.6',161,10033,'ifInOctets.6','ifInOctets.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20828,4,'public','.1.3.6.1.2.1.2.2.1.10.7',161,10033,'ifInOctets.7','ifInOctets.7',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20829,4,'public','.1.3.6.1.2.1.2.2.1.10.8',161,10033,'ifInOctets.8','ifInOctets.8',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20830,4,'public','.1.3.6.1.2.1.2.2.1.10.9',161,10033,'ifInOctets.9','ifInOctets.9',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20831,4,'public','.1.3.6.1.2.1.31.1.1.1.1.1',161,10033,'ifName.1','ifName.1',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20832,4,'public','.1.3.6.1.2.1.31.1.1.1.1.10',161,10033,'ifName.10','ifName.10',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20833,4,'public','.1.3.6.1.2.1.31.1.1.1.1.1001',161,10033,'ifName.1001','ifName.1001',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20834,4,'public','.1.3.6.1.2.1.31.1.1.1.1.11',161,10033,'ifName.11','ifName.11',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20835,4,'public','.1.3.6.1.2.1.31.1.1.1.1.12',161,10033,'ifName.12','ifName.12',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20836,4,'public','.1.3.6.1.2.1.31.1.1.1.1.13',161,10033,'ifName.13','ifName.13',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20837,4,'public','.1.3.6.1.2.1.31.1.1.1.1.14',161,10033,'ifName.14','ifName.14',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20838,4,'public','.1.3.6.1.2.1.31.1.1.1.1.15',161,10033,'ifName.15','ifName.15',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20839,4,'public','.1.3.6.1.2.1.31.1.1.1.1.16',161,10033,'ifName.16','ifName.16',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20840,4,'public','.1.3.6.1.2.1.31.1.1.1.1.17',161,10033,'ifName.17','ifName.17',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20841,4,'public','.1.3.6.1.2.1.31.1.1.1.1.18',161,10033,'ifName.18','ifName.18',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20842,4,'public','.1.3.6.1.2.1.31.1.1.1.1.19',161,10033,'ifName.19','ifName.19',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20843,4,'public','.1.3.6.1.2.1.31.1.1.1.1.2',161,10033,'ifName.2','ifName.2',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20844,4,'public','.1.3.6.1.2.1.31.1.1.1.1.20',161,10033,'ifName.20','ifName.20',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20845,4,'public','.1.3.6.1.2.1.31.1.1.1.1.21',161,10033,'ifName.21','ifName.21',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20846,4,'public','.1.3.6.1.2.1.31.1.1.1.1.22',161,10033,'ifName.22','ifName.22',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20847,4,'public','.1.3.6.1.2.1.31.1.1.1.1.23',161,10033,'ifName.23','ifName.23',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20848,4,'public','.1.3.6.1.2.1.31.1.1.1.1.24',161,10033,'ifName.24','ifName.24',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20849,4,'public','.1.3.6.1.2.1.31.1.1.1.1.3',161,10033,'ifName.3','ifName.3',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20850,4,'public','.1.3.6.1.2.1.31.1.1.1.1.31',161,10033,'ifName.31','ifName.31',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20851,4,'public','.1.3.6.1.2.1.31.1.1.1.1.4',161,10033,'ifName.4','ifName.4',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20852,4,'public','.1.3.6.1.2.1.31.1.1.1.1.5',161,10033,'ifName.5','ifName.5',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20853,4,'public','.1.3.6.1.2.1.31.1.1.1.1.6',161,10033,'ifName.6','ifName.6',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20854,4,'public','.1.3.6.1.2.1.31.1.1.1.1.7',161,10033,'ifName.7','ifName.7',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20855,4,'public','.1.3.6.1.2.1.31.1.1.1.1.8',161,10033,'ifName.8','ifName.8',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20856,4,'public','.1.3.6.1.2.1.31.1.1.1.1.9',161,10033,'ifName.9','ifName.9',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20857,4,'public','.1.3.6.1.2.1.2.1.0',161,10033,'ifNumber.0','ifNumber.0',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20858,4,'public','.1.3.6.1.2.1.2.2.1.8.1',161,10033,'ifOperStatus.1','ifOperStatus.1',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20859,4,'public','.1.3.6.1.2.1.2.2.1.8.10',161,10033,'ifOperStatus.10','ifOperStatus.10',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20860,4,'public','.1.3.6.1.2.1.2.2.1.8.1001',161,10033,'ifOperStatus.1001','ifOperStatus.1001',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20861,4,'public','.1.3.6.1.2.1.2.2.1.8.11',161,10033,'ifOperStatus.11','ifOperStatus.11',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20862,4,'public','.1.3.6.1.2.1.2.2.1.8.12',161,10033,'ifOperStatus.12','ifOperStatus.12',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20863,4,'public','.1.3.6.1.2.1.2.2.1.8.13',161,10033,'ifOperStatus.13','ifOperStatus.13',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20864,4,'public','.1.3.6.1.2.1.2.2.1.8.14',161,10033,'ifOperStatus.14','ifOperStatus.14',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20865,4,'public','.1.3.6.1.2.1.2.2.1.8.15',161,10033,'ifOperStatus.15','ifOperStatus.15',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20866,4,'public','.1.3.6.1.2.1.2.2.1.8.16',161,10033,'ifOperStatus.16','ifOperStatus.16',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20867,4,'public','.1.3.6.1.2.1.2.2.1.8.17',161,10033,'ifOperStatus.17','ifOperStatus.17',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20868,4,'public','.1.3.6.1.2.1.2.2.1.8.18',161,10033,'ifOperStatus.18','ifOperStatus.18',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20869,4,'public','.1.3.6.1.2.1.2.2.1.8.19',161,10033,'ifOperStatus.19','ifOperStatus.19',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20870,4,'public','.1.3.6.1.2.1.2.2.1.8.2',161,10033,'ifOperStatus.2','ifOperStatus.2',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20871,4,'public','.1.3.6.1.2.1.2.2.1.8.20',161,10033,'ifOperStatus.20','ifOperStatus.20',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20872,4,'public','.1.3.6.1.2.1.2.2.1.8.21',161,10033,'ifOperStatus.21','ifOperStatus.21',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20873,4,'public','.1.3.6.1.2.1.2.2.1.8.22',161,10033,'ifOperStatus.22','ifOperStatus.22',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20874,4,'public','.1.3.6.1.2.1.2.2.1.8.23',161,10033,'ifOperStatus.23','ifOperStatus.23',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20875,4,'public','.1.3.6.1.2.1.2.2.1.8.24',161,10033,'ifOperStatus.24','ifOperStatus.24',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20876,4,'public','.1.3.6.1.2.1.2.2.1.8.3',161,10033,'ifOperStatus.3','ifOperStatus.3',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20877,4,'public','.1.3.6.1.2.1.2.2.1.8.31',161,10033,'ifOperStatus.31','ifOperStatus.31',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20878,4,'public','.1.3.6.1.2.1.2.2.1.8.4',161,10033,'ifOperStatus.4','ifOperStatus.4',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20879,4,'public','.1.3.6.1.2.1.2.2.1.8.5',161,10033,'ifOperStatus.5','ifOperStatus.5',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20880,4,'public','.1.3.6.1.2.1.2.2.1.8.6',161,10033,'ifOperStatus.6','ifOperStatus.6',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20881,4,'public','.1.3.6.1.2.1.2.2.1.8.7',161,10033,'ifOperStatus.7','ifOperStatus.7',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20882,4,'public','.1.3.6.1.2.1.2.2.1.8.8',161,10033,'ifOperStatus.8','ifOperStatus.8',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20883,4,'public','.1.3.6.1.2.1.2.2.1.8.9',161,10033,'ifOperStatus.9','ifOperStatus.9',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20884,4,'public','.1.3.6.1.2.1.2.2.1.16.1',161,10033,'ifOutOctets.1','ifOutOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20885,4,'public','.1.3.6.1.2.1.2.2.1.16.10',161,10033,'ifOutOctets.10','ifOutOctets.10',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20886,4,'public','.1.3.6.1.2.1.2.2.1.16.1001',161,10033,'ifOutOctets.1001','ifOutOctets.1001',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20887,4,'public','.1.3.6.1.2.1.2.2.1.16.11',161,10033,'ifOutOctets.11','ifOutOctets.11',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20888,4,'public','.1.3.6.1.2.1.2.2.1.16.12',161,10033,'ifOutOctets.12','ifOutOctets.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20889,4,'public','.1.3.6.1.2.1.2.2.1.16.13',161,10033,'ifOutOctets.13','ifOutOctets.13',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20890,4,'public','.1.3.6.1.2.1.2.2.1.16.14',161,10033,'ifOutOctets.14','ifOutOctets.14',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20891,4,'public','.1.3.6.1.2.1.2.2.1.16.15',161,10033,'ifOutOctets.15','ifOutOctets.15',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20892,4,'public','.1.3.6.1.2.1.2.2.1.16.16',161,10033,'ifOutOctets.16','ifOutOctets.16',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20893,4,'public','.1.3.6.1.2.1.2.2.1.16.17',161,10033,'ifOutOctets.17','ifOutOctets.17',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20894,4,'public','.1.3.6.1.2.1.2.2.1.16.18',161,10033,'ifOutOctets.18','ifOutOctets.18',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20895,4,'public','.1.3.6.1.2.1.2.2.1.16.19',161,10033,'ifOutOctets.19','ifOutOctets.19',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20896,4,'public','.1.3.6.1.2.1.2.2.1.16.2',161,10033,'ifOutOctets.2','ifOutOctets.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20897,4,'public','.1.3.6.1.2.1.2.2.1.16.20',161,10033,'ifOutOctets.20','ifOutOctets.20',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20898,4,'public','.1.3.6.1.2.1.2.2.1.16.21',161,10033,'ifOutOctets.21','ifOutOctets.21',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20899,4,'public','.1.3.6.1.2.1.2.2.1.16.22',161,10033,'ifOutOctets.22','ifOutOctets.22',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20900,4,'public','.1.3.6.1.2.1.2.2.1.16.23',161,10033,'ifOutOctets.23','ifOutOctets.23',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20901,4,'public','.1.3.6.1.2.1.2.2.1.16.24',161,10033,'ifOutOctets.24','ifOutOctets.24',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20902,4,'public','.1.3.6.1.2.1.2.2.1.16.3',161,10033,'ifOutOctets.3','ifOutOctets.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20903,4,'public','.1.3.6.1.2.1.2.2.1.16.31',161,10033,'ifOutOctets.31','ifOutOctets.31',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20904,4,'public','.1.3.6.1.2.1.2.2.1.16.4',161,10033,'ifOutOctets.4','ifOutOctets.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20905,4,'public','.1.3.6.1.2.1.2.2.1.16.5',161,10033,'ifOutOctets.5','ifOutOctets.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20906,4,'public','.1.3.6.1.2.1.2.2.1.16.6',161,10033,'ifOutOctets.6','ifOutOctets.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20907,4,'public','.1.3.6.1.2.1.2.2.1.16.7',161,10033,'ifOutOctets.7','ifOutOctets.7',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20908,4,'public','.1.3.6.1.2.1.2.2.1.16.8',161,10033,'ifOutOctets.8','ifOutOctets.8',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20909,4,'public','.1.3.6.1.2.1.2.2.1.16.9',161,10033,'ifOutOctets.9','ifOutOctets.9',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20910,4,'public','.1.3.6.1.2.1.2.2.1.5.1',161,10033,'ifSpeed.1','ifSpeed.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20911,4,'public','.1.3.6.1.2.1.2.2.1.5.10',161,10033,'ifSpeed.10','ifSpeed.10',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20912,4,'public','.1.3.6.1.2.1.2.2.1.5.1001',161,10033,'ifSpeed.1001','ifSpeed.1001',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20913,4,'public','.1.3.6.1.2.1.2.2.1.5.11',161,10033,'ifSpeed.11','ifSpeed.11',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20914,4,'public','.1.3.6.1.2.1.2.2.1.5.12',161,10033,'ifSpeed.12','ifSpeed.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20915,4,'public','.1.3.6.1.2.1.2.2.1.5.13',161,10033,'ifSpeed.13','ifSpeed.13',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20916,4,'public','.1.3.6.1.2.1.2.2.1.5.14',161,10033,'ifSpeed.14','ifSpeed.14',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20917,4,'public','.1.3.6.1.2.1.2.2.1.5.15',161,10033,'ifSpeed.15','ifSpeed.15',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20918,4,'public','.1.3.6.1.2.1.2.2.1.5.16',161,10033,'ifSpeed.16','ifSpeed.16',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20919,4,'public','.1.3.6.1.2.1.2.2.1.5.17',161,10033,'ifSpeed.17','ifSpeed.17',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20920,4,'public','.1.3.6.1.2.1.2.2.1.5.18',161,10033,'ifSpeed.18','ifSpeed.18',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20921,4,'public','.1.3.6.1.2.1.2.2.1.5.19',161,10033,'ifSpeed.19','ifSpeed.19',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20922,4,'public','.1.3.6.1.2.1.2.2.1.5.2',161,10033,'ifSpeed.2','ifSpeed.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20923,4,'public','.1.3.6.1.2.1.2.2.1.5.20',161,10033,'ifSpeed.20','ifSpeed.20',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20924,4,'public','.1.3.6.1.2.1.2.2.1.5.21',161,10033,'ifSpeed.21','ifSpeed.21',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20925,4,'public','.1.3.6.1.2.1.2.2.1.5.22',161,10033,'ifSpeed.22','ifSpeed.22',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20926,4,'public','.1.3.6.1.2.1.2.2.1.5.23',161,10033,'ifSpeed.23','ifSpeed.23',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20927,4,'public','.1.3.6.1.2.1.2.2.1.5.24',161,10033,'ifSpeed.24','ifSpeed.24',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20928,4,'public','.1.3.6.1.2.1.2.2.1.5.3',161,10033,'ifSpeed.3','ifSpeed.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20929,4,'public','.1.3.6.1.2.1.2.2.1.5.31',161,10033,'ifSpeed.31','ifSpeed.31',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20930,4,'public','.1.3.6.1.2.1.2.2.1.5.4',161,10033,'ifSpeed.4','ifSpeed.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20931,4,'public','.1.3.6.1.2.1.2.2.1.5.5',161,10033,'ifSpeed.5','ifSpeed.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20932,4,'public','.1.3.6.1.2.1.2.2.1.5.6',161,10033,'ifSpeed.6','ifSpeed.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20933,4,'public','.1.3.6.1.2.1.2.2.1.5.7',161,10033,'ifSpeed.7','ifSpeed.7',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20934,4,'public','.1.3.6.1.2.1.2.2.1.5.8',161,10033,'ifSpeed.8','ifSpeed.8',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20935,4,'public','.1.3.6.1.2.1.2.2.1.5.9',161,10033,'ifSpeed.9','ifSpeed.9',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20936,4,'public','.1.3.6.1.2.1.2.2.1.3.1',161,10033,'ifType.1','ifType.1',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20937,4,'public','.1.3.6.1.2.1.2.2.1.3.10',161,10033,'ifType.10','ifType.10',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20938,4,'public','.1.3.6.1.2.1.2.2.1.3.1001',161,10033,'ifType.1001','ifType.1001',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20939,4,'public','.1.3.6.1.2.1.2.2.1.3.11',161,10033,'ifType.11','ifType.11',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20940,4,'public','.1.3.6.1.2.1.2.2.1.3.12',161,10033,'ifType.12','ifType.12',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20941,4,'public','.1.3.6.1.2.1.2.2.1.3.13',161,10033,'ifType.13','ifType.13',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20942,4,'public','.1.3.6.1.2.1.2.2.1.3.14',161,10033,'ifType.14','ifType.14',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20943,4,'public','.1.3.6.1.2.1.2.2.1.3.15',161,10033,'ifType.15','ifType.15',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20944,4,'public','.1.3.6.1.2.1.2.2.1.3.16',161,10033,'ifType.16','ifType.16',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20945,4,'public','.1.3.6.1.2.1.2.2.1.3.17',161,10033,'ifType.17','ifType.17',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20946,4,'public','.1.3.6.1.2.1.2.2.1.3.18',161,10033,'ifType.18','ifType.18',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20947,4,'public','.1.3.6.1.2.1.2.2.1.3.19',161,10033,'ifType.19','ifType.19',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20948,4,'public','.1.3.6.1.2.1.2.2.1.3.2',161,10033,'ifType.2','ifType.2',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20949,4,'public','.1.3.6.1.2.1.2.2.1.3.20',161,10033,'ifType.20','ifType.20',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20950,4,'public','.1.3.6.1.2.1.2.2.1.3.21',161,10033,'ifType.21','ifType.21',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20951,4,'public','.1.3.6.1.2.1.2.2.1.3.22',161,10033,'ifType.22','ifType.22',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20952,4,'public','.1.3.6.1.2.1.2.2.1.3.23',161,10033,'ifType.23','ifType.23',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20953,4,'public','.1.3.6.1.2.1.2.2.1.3.24',161,10033,'ifType.24','ifType.24',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20954,4,'public','.1.3.6.1.2.1.2.2.1.3.3',161,10033,'ifType.3','ifType.3',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20955,4,'public','.1.3.6.1.2.1.2.2.1.3.31',161,10033,'ifType.31','ifType.31',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20956,4,'public','.1.3.6.1.2.1.2.2.1.3.4',161,10033,'ifType.4','ifType.4',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20957,4,'public','.1.3.6.1.2.1.2.2.1.3.5',161,10033,'ifType.5','ifType.5',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20958,4,'public','.1.3.6.1.2.1.2.2.1.3.6',161,10033,'ifType.6','ifType.6',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20959,4,'public','.1.3.6.1.2.1.2.2.1.3.7',161,10033,'ifType.7','ifType.7',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20960,4,'public','.1.3.6.1.2.1.2.2.1.3.8',161,10033,'ifType.8','ifType.8',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20961,4,'public','.1.3.6.1.2.1.2.2.1.3.9',161,10033,'ifType.9','ifType.9',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20962,4,'public','.1.3.6.1.2.1.1.4.0',161,10033,'sysContact.0','sysContact.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20963,4,'public','.1.3.6.1.2.1.1.1.0',161,10033,'sysDescr.0','sysDescr.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20964,4,'public','.1.3.6.1.2.1.1.6.0',161,10033,'sysLocation.0','sysLocation.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20965,4,'public','.1.3.6.1.2.1.1.5.0',161,10033,'sysName.0','sysName.0',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20966,4,'public','.1.3.6.1.2.1.1.3.0',161,10033,'sysUpTime','sysUpTime',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20967,4,'public','.1.3.6.1.2.1.47.1.1.1.1.11.68157952',161,10034,'11.68157952','11.68157952',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20968,4,'public','.1.3.6.1.2.1.47.1.1.1.1.12.68157952',161,10034,'12.68157952','12.68157952',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20969,4,'public','.1.3.6.1.2.1.47.1.1.1.1.2.68424704',161,10034,'2.68424704','2.68424704',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20970,4,'public','.1.3.6.1.2.1.31.1.1.1.18.1',161,10034,'ifAlias.1','ifAlias.1',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20971,4,'public','.1.3.6.1.2.1.31.1.1.1.18.10',161,10034,'ifAlias.10','ifAlias.10',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20972,4,'public','.1.3.6.1.2.1.31.1.1.1.18.100000',161,10034,'ifAlias.100000','ifAlias.100000',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20973,4,'public','.1.3.6.1.2.1.31.1.1.1.18.100001',161,10034,'ifAlias.100001','ifAlias.100001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20974,4,'public','.1.3.6.1.2.1.31.1.1.1.18.100002',161,10034,'ifAlias.100002','ifAlias.100002',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20975,4,'public','.1.3.6.1.2.1.31.1.1.1.18.100003',161,10034,'ifAlias.100003','ifAlias.100003',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20976,4,'public','.1.3.6.1.2.1.31.1.1.1.18.11',161,10034,'ifAlias.11','ifAlias.11',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20977,4,'public','.1.3.6.1.2.1.31.1.1.1.18.12',161,10034,'ifAlias.12','ifAlias.12',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20978,4,'public','.1.3.6.1.2.1.31.1.1.1.18.13',161,10034,'ifAlias.13','ifAlias.13',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20979,4,'public','.1.3.6.1.2.1.31.1.1.1.18.14',161,10034,'ifAlias.14','ifAlias.14',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20980,4,'public','.1.3.6.1.2.1.31.1.1.1.18.15',161,10034,'ifAlias.15','ifAlias.15',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20981,4,'public','.1.3.6.1.2.1.31.1.1.1.18.16',161,10034,'ifAlias.16','ifAlias.16',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20982,4,'public','.1.3.6.1.2.1.31.1.1.1.18.17',161,10034,'ifAlias.17','ifAlias.17',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20983,4,'public','.1.3.6.1.2.1.31.1.1.1.18.18',161,10034,'ifAlias.18','ifAlias.18',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20984,4,'public','.1.3.6.1.2.1.31.1.1.1.18.19',161,10034,'ifAlias.19','ifAlias.19',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20985,4,'public','.1.3.6.1.2.1.31.1.1.1.18.2',161,10034,'ifAlias.2','ifAlias.2',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20986,4,'public','.1.3.6.1.2.1.31.1.1.1.18.20',161,10034,'ifAlias.20','ifAlias.20',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20987,4,'public','.1.3.6.1.2.1.31.1.1.1.18.21',161,10034,'ifAlias.21','ifAlias.21',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20988,4,'public','.1.3.6.1.2.1.31.1.1.1.18.22',161,10034,'ifAlias.22','ifAlias.22',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20989,4,'public','.1.3.6.1.2.1.31.1.1.1.18.23',161,10034,'ifAlias.23','ifAlias.23',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20990,4,'public','.1.3.6.1.2.1.31.1.1.1.18.24',161,10034,'ifAlias.24','ifAlias.24',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20991,4,'public','.1.3.6.1.2.1.31.1.1.1.18.25',161,10034,'ifAlias.25','ifAlias.25',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20992,4,'public','.1.3.6.1.2.1.31.1.1.1.18.26',161,10034,'ifAlias.26','ifAlias.26',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20993,4,'public','.1.3.6.1.2.1.31.1.1.1.18.27',161,10034,'ifAlias.27','ifAlias.27',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20994,4,'public','.1.3.6.1.2.1.31.1.1.1.18.28',161,10034,'ifAlias.28','ifAlias.28',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20995,4,'public','.1.3.6.1.2.1.31.1.1.1.18.29',161,10034,'ifAlias.29','ifAlias.29',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20996,4,'public','.1.3.6.1.2.1.31.1.1.1.18.3',161,10034,'ifAlias.3','ifAlias.3',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20997,4,'public','.1.3.6.1.2.1.31.1.1.1.18.30',161,10034,'ifAlias.30','ifAlias.30',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20998,4,'public','.1.3.6.1.2.1.31.1.1.1.18.31',161,10034,'ifAlias.31','ifAlias.31',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (20999,4,'public','.1.3.6.1.2.1.31.1.1.1.18.32',161,10034,'ifAlias.32','ifAlias.32',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21000,4,'public','.1.3.6.1.2.1.31.1.1.1.18.4',161,10034,'ifAlias.4','ifAlias.4',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21001,4,'public','.1.3.6.1.2.1.31.1.1.1.18.5',161,10034,'ifAlias.5','ifAlias.5',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21002,4,'public','.1.3.6.1.2.1.31.1.1.1.18.6',161,10034,'ifAlias.6','ifAlias.6',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21003,4,'public','.1.3.6.1.2.1.31.1.1.1.18.7',161,10034,'ifAlias.7','ifAlias.7',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21004,4,'public','.1.3.6.1.2.1.31.1.1.1.18.8',161,10034,'ifAlias.8','ifAlias.8',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21005,4,'public','.1.3.6.1.2.1.31.1.1.1.18.9',161,10034,'ifAlias.9','ifAlias.9',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21006,4,'public','.1.3.6.1.2.1.2.2.1.2.1',161,10034,'ifDescr.1','ifDescr.1',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21007,4,'public','.1.3.6.1.2.1.2.2.1.2.10',161,10034,'ifDescr.10','ifDescr.10',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21008,4,'public','.1.3.6.1.2.1.2.2.1.2.100000',161,10034,'ifDescr.100000','ifDescr.100000',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21009,4,'public','.1.3.6.1.2.1.2.2.1.2.100001',161,10034,'ifDescr.100001','ifDescr.100001',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21010,4,'public','.1.3.6.1.2.1.2.2.1.2.100002',161,10034,'ifDescr.100002','ifDescr.100002',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21011,4,'public','.1.3.6.1.2.1.2.2.1.2.100003',161,10034,'ifDescr.100003','ifDescr.100003',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21012,4,'public','.1.3.6.1.2.1.2.2.1.2.11',161,10034,'ifDescr.11','ifDescr.11',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21013,4,'public','.1.3.6.1.2.1.2.2.1.2.12',161,10034,'ifDescr.12','ifDescr.12',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21014,4,'public','.1.3.6.1.2.1.2.2.1.2.13',161,10034,'ifDescr.13','ifDescr.13',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21015,4,'public','.1.3.6.1.2.1.2.2.1.2.14',161,10034,'ifDescr.14','ifDescr.14',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21016,4,'public','.1.3.6.1.2.1.2.2.1.2.15',161,10034,'ifDescr.15','ifDescr.15',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21017,4,'public','.1.3.6.1.2.1.2.2.1.2.16',161,10034,'ifDescr.16','ifDescr.16',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21018,4,'public','.1.3.6.1.2.1.2.2.1.2.17',161,10034,'ifDescr.17','ifDescr.17',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21019,4,'public','.1.3.6.1.2.1.2.2.1.2.18',161,10034,'ifDescr.18','ifDescr.18',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21020,4,'public','.1.3.6.1.2.1.2.2.1.2.19',161,10034,'ifDescr.19','ifDescr.19',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21021,4,'public','.1.3.6.1.2.1.2.2.1.2.2',161,10034,'ifDescr.2','ifDescr.2',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21022,4,'public','.1.3.6.1.2.1.2.2.1.2.20',161,10034,'ifDescr.20','ifDescr.20',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21023,4,'public','.1.3.6.1.2.1.2.2.1.2.21',161,10034,'ifDescr.21','ifDescr.21',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21024,4,'public','.1.3.6.1.2.1.2.2.1.2.22',161,10034,'ifDescr.22','ifDescr.22',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21025,4,'public','.1.3.6.1.2.1.2.2.1.2.23',161,10034,'ifDescr.23','ifDescr.23',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21026,4,'public','.1.3.6.1.2.1.2.2.1.2.24',161,10034,'ifDescr.24','ifDescr.24',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21027,4,'public','.1.3.6.1.2.1.2.2.1.2.25',161,10034,'ifDescr.25','ifDescr.25',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21028,4,'public','.1.3.6.1.2.1.2.2.1.2.26',161,10034,'ifDescr.26','ifDescr.26',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21029,4,'public','.1.3.6.1.2.1.2.2.1.2.27',161,10034,'ifDescr.27','ifDescr.27',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21030,4,'public','.1.3.6.1.2.1.2.2.1.2.28',161,10034,'ifDescr.28','ifDescr.28',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21031,4,'public','.1.3.6.1.2.1.2.2.1.2.29',161,10034,'ifDescr.29','ifDescr.29',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21032,4,'public','.1.3.6.1.2.1.2.2.1.2.3',161,10034,'ifDescr.3','ifDescr.3',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21033,4,'public','.1.3.6.1.2.1.2.2.1.2.30',161,10034,'ifDescr.30','ifDescr.30',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21034,4,'public','.1.3.6.1.2.1.2.2.1.2.31',161,10034,'ifDescr.31','ifDescr.31',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21035,4,'public','.1.3.6.1.2.1.2.2.1.2.32',161,10034,'ifDescr.32','ifDescr.32',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21036,4,'public','.1.3.6.1.2.1.2.2.1.2.4',161,10034,'ifDescr.4','ifDescr.4',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21037,4,'public','.1.3.6.1.2.1.2.2.1.2.5',161,10034,'ifDescr.5','ifDescr.5',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21038,4,'public','.1.3.6.1.2.1.2.2.1.2.6',161,10034,'ifDescr.6','ifDescr.6',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21039,4,'public','.1.3.6.1.2.1.2.2.1.2.7',161,10034,'ifDescr.7','ifDescr.7',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21040,4,'public','.1.3.6.1.2.1.2.2.1.2.8',161,10034,'ifDescr.8','ifDescr.8',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21041,4,'public','.1.3.6.1.2.1.2.2.1.2.9',161,10034,'ifDescr.9','ifDescr.9',600,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21042,4,'public','.1.3.6.1.2.1.2.2.1.10.1',161,10034,'ifInOctets.1','ifInOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21043,4,'public','.1.3.6.1.2.1.2.2.1.10.10',161,10034,'ifInOctets.10','ifInOctets.10',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21044,4,'public','.1.3.6.1.2.1.2.2.1.10.100000',161,10034,'ifInOctets.100000','ifInOctets.100000',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21045,4,'public','.1.3.6.1.2.1.2.2.1.10.100001',161,10034,'ifInOctets.100001','ifInOctets.100001',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21046,4,'public','.1.3.6.1.2.1.2.2.1.10.100002',161,10034,'ifInOctets.100002','ifInOctets.100002',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21047,4,'public','.1.3.6.1.2.1.2.2.1.10.100003',161,10034,'ifInOctets.100003','ifInOctets.100003',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21048,4,'public','.1.3.6.1.2.1.2.2.1.10.11',161,10034,'ifInOctets.11','ifInOctets.11',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21049,4,'public','.1.3.6.1.2.1.2.2.1.10.12',161,10034,'ifInOctets.12','ifInOctets.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21050,4,'public','.1.3.6.1.2.1.2.2.1.10.13',161,10034,'ifInOctets.13','ifInOctets.13',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21051,4,'public','.1.3.6.1.2.1.2.2.1.10.14',161,10034,'ifInOctets.14','ifInOctets.14',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21052,4,'public','.1.3.6.1.2.1.2.2.1.10.15',161,10034,'ifInOctets.15','ifInOctets.15',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21053,4,'public','.1.3.6.1.2.1.2.2.1.10.16',161,10034,'ifInOctets.16','ifInOctets.16',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21054,4,'public','.1.3.6.1.2.1.2.2.1.10.17',161,10034,'ifInOctets.17','ifInOctets.17',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21055,4,'public','.1.3.6.1.2.1.2.2.1.10.18',161,10034,'ifInOctets.18','ifInOctets.18',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21056,4,'public','.1.3.6.1.2.1.2.2.1.10.19',161,10034,'ifInOctets.19','ifInOctets.19',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21057,4,'public','.1.3.6.1.2.1.2.2.1.10.2',161,10034,'ifInOctets.2','ifInOctets.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21058,4,'public','.1.3.6.1.2.1.2.2.1.10.20',161,10034,'ifInOctets.20','ifInOctets.20',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21059,4,'public','.1.3.6.1.2.1.2.2.1.10.21',161,10034,'ifInOctets.21','ifInOctets.21',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21060,4,'public','.1.3.6.1.2.1.2.2.1.10.22',161,10034,'ifInOctets.22','ifInOctets.22',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21061,4,'public','.1.3.6.1.2.1.2.2.1.10.23',161,10034,'ifInOctets.23','ifInOctets.23',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21062,4,'public','.1.3.6.1.2.1.2.2.1.10.24',161,10034,'ifInOctets.24','ifInOctets.24',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21063,4,'public','.1.3.6.1.2.1.2.2.1.10.25',161,10034,'ifInOctets.25','ifInOctets.25',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21064,4,'public','.1.3.6.1.2.1.2.2.1.10.26',161,10034,'ifInOctets.26','ifInOctets.26',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21065,4,'public','.1.3.6.1.2.1.2.2.1.10.27',161,10034,'ifInOctets.27','ifInOctets.27',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21066,4,'public','.1.3.6.1.2.1.2.2.1.10.28',161,10034,'ifInOctets.28','ifInOctets.28',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21067,4,'public','.1.3.6.1.2.1.2.2.1.10.29',161,10034,'ifInOctets.29','ifInOctets.29',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21068,4,'public','.1.3.6.1.2.1.2.2.1.10.3',161,10034,'ifInOctets.3','ifInOctets.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21069,4,'public','.1.3.6.1.2.1.2.2.1.10.30',161,10034,'ifInOctets.30','ifInOctets.30',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21070,4,'public','.1.3.6.1.2.1.2.2.1.10.31',161,10034,'ifInOctets.31','ifInOctets.31',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21071,4,'public','.1.3.6.1.2.1.2.2.1.10.32',161,10034,'ifInOctets.32','ifInOctets.32',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21072,4,'public','.1.3.6.1.2.1.2.2.1.10.4',161,10034,'ifInOctets.4','ifInOctets.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21073,4,'public','.1.3.6.1.2.1.2.2.1.10.5',161,10034,'ifInOctets.5','ifInOctets.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21074,4,'public','.1.3.6.1.2.1.2.2.1.10.6',161,10034,'ifInOctets.6','ifInOctets.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21075,4,'public','.1.3.6.1.2.1.2.2.1.10.7',161,10034,'ifInOctets.7','ifInOctets.7',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21076,4,'public','.1.3.6.1.2.1.2.2.1.10.8',161,10034,'ifInOctets.8','ifInOctets.8',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21077,4,'public','.1.3.6.1.2.1.2.2.1.10.9',161,10034,'ifInOctets.9','ifInOctets.9',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21078,4,'public','.1.3.6.1.2.1.31.1.1.1.1.1',161,10034,'ifName.1','ifName.1',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21079,4,'public','.1.3.6.1.2.1.31.1.1.1.1.10',161,10034,'ifName.10','ifName.10',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21080,4,'public','.1.3.6.1.2.1.31.1.1.1.1.100000',161,10034,'ifName.100000','ifName.100000',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21081,4,'public','.1.3.6.1.2.1.31.1.1.1.1.100001',161,10034,'ifName.100001','ifName.100001',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21082,4,'public','.1.3.6.1.2.1.31.1.1.1.1.100002',161,10034,'ifName.100002','ifName.100002',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21083,4,'public','.1.3.6.1.2.1.31.1.1.1.1.100003',161,10034,'ifName.100003','ifName.100003',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21084,4,'public','.1.3.6.1.2.1.31.1.1.1.1.11',161,10034,'ifName.11','ifName.11',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21085,4,'public','.1.3.6.1.2.1.31.1.1.1.1.12',161,10034,'ifName.12','ifName.12',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21086,4,'public','.1.3.6.1.2.1.31.1.1.1.1.13',161,10034,'ifName.13','ifName.13',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21087,4,'public','.1.3.6.1.2.1.31.1.1.1.1.14',161,10034,'ifName.14','ifName.14',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21088,4,'public','.1.3.6.1.2.1.31.1.1.1.1.15',161,10034,'ifName.15','ifName.15',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21089,4,'public','.1.3.6.1.2.1.31.1.1.1.1.16',161,10034,'ifName.16','ifName.16',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21090,4,'public','.1.3.6.1.2.1.31.1.1.1.1.17',161,10034,'ifName.17','ifName.17',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21091,4,'public','.1.3.6.1.2.1.31.1.1.1.1.18',161,10034,'ifName.18','ifName.18',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21092,4,'public','.1.3.6.1.2.1.31.1.1.1.1.19',161,10034,'ifName.19','ifName.19',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21093,4,'public','.1.3.6.1.2.1.31.1.1.1.1.2',161,10034,'ifName.2','ifName.2',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21094,4,'public','.1.3.6.1.2.1.31.1.1.1.1.20',161,10034,'ifName.20','ifName.20',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21095,4,'public','.1.3.6.1.2.1.31.1.1.1.1.21',161,10034,'ifName.21','ifName.21',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21096,4,'public','.1.3.6.1.2.1.31.1.1.1.1.22',161,10034,'ifName.22','ifName.22',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21097,4,'public','.1.3.6.1.2.1.31.1.1.1.1.23',161,10034,'ifName.23','ifName.23',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21098,4,'public','.1.3.6.1.2.1.31.1.1.1.1.24',161,10034,'ifName.24','ifName.24',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21099,4,'public','.1.3.6.1.2.1.31.1.1.1.1.25',161,10034,'ifName.25','ifName.25',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21100,4,'public','.1.3.6.1.2.1.31.1.1.1.1.26',161,10034,'ifName.26','ifName.26',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21101,4,'public','.1.3.6.1.2.1.31.1.1.1.1.27',161,10034,'ifName.27','ifName.27',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21102,4,'public','.1.3.6.1.2.1.31.1.1.1.1.28',161,10034,'ifName.28','ifName.28',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21103,4,'public','.1.3.6.1.2.1.31.1.1.1.1.29',161,10034,'ifName.29','ifName.29',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21104,4,'public','.1.3.6.1.2.1.31.1.1.1.1.3',161,10034,'ifName.3','ifName.3',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21105,4,'public','.1.3.6.1.2.1.31.1.1.1.1.30',161,10034,'ifName.30','ifName.30',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21106,4,'public','.1.3.6.1.2.1.31.1.1.1.1.31',161,10034,'ifName.31','ifName.31',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21107,4,'public','.1.3.6.1.2.1.31.1.1.1.1.32',161,10034,'ifName.32','ifName.32',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21108,4,'public','.1.3.6.1.2.1.31.1.1.1.1.4',161,10034,'ifName.4','ifName.4',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21109,4,'public','.1.3.6.1.2.1.31.1.1.1.1.5',161,10034,'ifName.5','ifName.5',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21110,4,'public','.1.3.6.1.2.1.31.1.1.1.1.6',161,10034,'ifName.6','ifName.6',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21111,4,'public','.1.3.6.1.2.1.31.1.1.1.1.7',161,10034,'ifName.7','ifName.7',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21112,4,'public','.1.3.6.1.2.1.31.1.1.1.1.8',161,10034,'ifName.8','ifName.8',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21113,4,'public','.1.3.6.1.2.1.31.1.1.1.1.9',161,10034,'ifName.9','ifName.9',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21114,4,'public','.1.3.6.1.2.1.2.1.0',161,10034,'ifNumber.0','ifNumber.0',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21115,4,'public','.1.3.6.1.2.1.2.2.1.8.1',161,10034,'ifOperStatus.1','ifOperStatus.1',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21116,4,'public','.1.3.6.1.2.1.2.2.1.8.10',161,10034,'ifOperStatus.10','ifOperStatus.10',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21117,4,'public','.1.3.6.1.2.1.2.2.1.8.100000',161,10034,'ifOperStatus.100000','ifOperStatus.100000',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21118,4,'public','.1.3.6.1.2.1.2.2.1.8.100001',161,10034,'ifOperStatus.100001','ifOperStatus.100001',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21119,4,'public','.1.3.6.1.2.1.2.2.1.8.100002',161,10034,'ifOperStatus.100002','ifOperStatus.100002',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21120,4,'public','.1.3.6.1.2.1.2.2.1.8.100003',161,10034,'ifOperStatus.100003','ifOperStatus.100003',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21121,4,'public','.1.3.6.1.2.1.2.2.1.8.11',161,10034,'ifOperStatus.11','ifOperStatus.11',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21122,4,'public','.1.3.6.1.2.1.2.2.1.8.12',161,10034,'ifOperStatus.12','ifOperStatus.12',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21123,4,'public','.1.3.6.1.2.1.2.2.1.8.13',161,10034,'ifOperStatus.13','ifOperStatus.13',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21124,4,'public','.1.3.6.1.2.1.2.2.1.8.14',161,10034,'ifOperStatus.14','ifOperStatus.14',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21125,4,'public','.1.3.6.1.2.1.2.2.1.8.15',161,10034,'ifOperStatus.15','ifOperStatus.15',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21126,4,'public','.1.3.6.1.2.1.2.2.1.8.16',161,10034,'ifOperStatus.16','ifOperStatus.16',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21127,4,'public','.1.3.6.1.2.1.2.2.1.8.17',161,10034,'ifOperStatus.17','ifOperStatus.17',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21128,4,'public','.1.3.6.1.2.1.2.2.1.8.18',161,10034,'ifOperStatus.18','ifOperStatus.18',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21129,4,'public','.1.3.6.1.2.1.2.2.1.8.19',161,10034,'ifOperStatus.19','ifOperStatus.19',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21130,4,'public','.1.3.6.1.2.1.2.2.1.8.2',161,10034,'ifOperStatus.2','ifOperStatus.2',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21131,4,'public','.1.3.6.1.2.1.2.2.1.8.20',161,10034,'ifOperStatus.20','ifOperStatus.20',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21132,4,'public','.1.3.6.1.2.1.2.2.1.8.21',161,10034,'ifOperStatus.21','ifOperStatus.21',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21133,4,'public','.1.3.6.1.2.1.2.2.1.8.22',161,10034,'ifOperStatus.22','ifOperStatus.22',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21134,4,'public','.1.3.6.1.2.1.2.2.1.8.23',161,10034,'ifOperStatus.23','ifOperStatus.23',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21135,4,'public','.1.3.6.1.2.1.2.2.1.8.24',161,10034,'ifOperStatus.24','ifOperStatus.24',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21136,4,'public','.1.3.6.1.2.1.2.2.1.8.25',161,10034,'ifOperStatus.25','ifOperStatus.25',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21137,4,'public','.1.3.6.1.2.1.2.2.1.8.26',161,10034,'ifOperStatus.26','ifOperStatus.26',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21138,4,'public','.1.3.6.1.2.1.2.2.1.8.27',161,10034,'ifOperStatus.27','ifOperStatus.27',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21139,4,'public','.1.3.6.1.2.1.2.2.1.8.28',161,10034,'ifOperStatus.28','ifOperStatus.28',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21140,4,'public','.1.3.6.1.2.1.2.2.1.8.29',161,10034,'ifOperStatus.29','ifOperStatus.29',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21141,4,'public','.1.3.6.1.2.1.2.2.1.8.3',161,10034,'ifOperStatus.3','ifOperStatus.3',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21142,4,'public','.1.3.6.1.2.1.2.2.1.8.30',161,10034,'ifOperStatus.30','ifOperStatus.30',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21143,4,'public','.1.3.6.1.2.1.2.2.1.8.31',161,10034,'ifOperStatus.31','ifOperStatus.31',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21144,4,'public','.1.3.6.1.2.1.2.2.1.8.32',161,10034,'ifOperStatus.32','ifOperStatus.32',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21145,4,'public','.1.3.6.1.2.1.2.2.1.8.4',161,10034,'ifOperStatus.4','ifOperStatus.4',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21146,4,'public','.1.3.6.1.2.1.2.2.1.8.5',161,10034,'ifOperStatus.5','ifOperStatus.5',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21147,4,'public','.1.3.6.1.2.1.2.2.1.8.6',161,10034,'ifOperStatus.6','ifOperStatus.6',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21148,4,'public','.1.3.6.1.2.1.2.2.1.8.7',161,10034,'ifOperStatus.7','ifOperStatus.7',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21149,4,'public','.1.3.6.1.2.1.2.2.1.8.8',161,10034,'ifOperStatus.8','ifOperStatus.8',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21150,4,'public','.1.3.6.1.2.1.2.2.1.8.9',161,10034,'ifOperStatus.9','ifOperStatus.9',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21151,4,'public','.1.3.6.1.2.1.2.2.1.16.1',161,10034,'ifOutOctets.1','ifOutOctets.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21152,4,'public','.1.3.6.1.2.1.2.2.1.16.10',161,10034,'ifOutOctets.10','ifOutOctets.10',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21153,4,'public','.1.3.6.1.2.1.2.2.1.16.100000',161,10034,'ifOutOctets.100000','ifOutOctets.100000',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21154,4,'public','.1.3.6.1.2.1.2.2.1.16.100001',161,10034,'ifOutOctets.100001','ifOutOctets.100001',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21155,4,'public','.1.3.6.1.2.1.2.2.1.16.100002',161,10034,'ifOutOctets.100002','ifOutOctets.100002',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21156,4,'public','.1.3.6.1.2.1.2.2.1.16.100003',161,10034,'ifOutOctets.100003','ifOutOctets.100003',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21157,4,'public','.1.3.6.1.2.1.2.2.1.16.11',161,10034,'ifOutOctets.11','ifOutOctets.11',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21158,4,'public','.1.3.6.1.2.1.2.2.1.16.12',161,10034,'ifOutOctets.12','ifOutOctets.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21159,4,'public','.1.3.6.1.2.1.2.2.1.16.13',161,10034,'ifOutOctets.13','ifOutOctets.13',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21160,4,'public','.1.3.6.1.2.1.2.2.1.16.14',161,10034,'ifOutOctets.14','ifOutOctets.14',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21161,4,'public','.1.3.6.1.2.1.2.2.1.16.15',161,10034,'ifOutOctets.15','ifOutOctets.15',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21162,4,'public','.1.3.6.1.2.1.2.2.1.16.16',161,10034,'ifOutOctets.16','ifOutOctets.16',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21163,4,'public','.1.3.6.1.2.1.2.2.1.16.17',161,10034,'ifOutOctets.17','ifOutOctets.17',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21164,4,'public','.1.3.6.1.2.1.2.2.1.16.18',161,10034,'ifOutOctets.18','ifOutOctets.18',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21165,4,'public','.1.3.6.1.2.1.2.2.1.16.19',161,10034,'ifOutOctets.19','ifOutOctets.19',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21166,4,'public','.1.3.6.1.2.1.2.2.1.16.2',161,10034,'ifOutOctets.2','ifOutOctets.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21167,4,'public','.1.3.6.1.2.1.2.2.1.16.20',161,10034,'ifOutOctets.20','ifOutOctets.20',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21168,4,'public','.1.3.6.1.2.1.2.2.1.16.21',161,10034,'ifOutOctets.21','ifOutOctets.21',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21169,4,'public','.1.3.6.1.2.1.2.2.1.16.22',161,10034,'ifOutOctets.22','ifOutOctets.22',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21170,4,'public','.1.3.6.1.2.1.2.2.1.16.23',161,10034,'ifOutOctets.23','ifOutOctets.23',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21171,4,'public','.1.3.6.1.2.1.2.2.1.16.24',161,10034,'ifOutOctets.24','ifOutOctets.24',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21172,4,'public','.1.3.6.1.2.1.2.2.1.16.25',161,10034,'ifOutOctets.25','ifOutOctets.25',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21173,4,'public','.1.3.6.1.2.1.2.2.1.16.26',161,10034,'ifOutOctets.26','ifOutOctets.26',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21174,4,'public','.1.3.6.1.2.1.2.2.1.16.27',161,10034,'ifOutOctets.27','ifOutOctets.27',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21175,4,'public','.1.3.6.1.2.1.2.2.1.16.28',161,10034,'ifOutOctets.28','ifOutOctets.28',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21176,4,'public','.1.3.6.1.2.1.2.2.1.16.29',161,10034,'ifOutOctets.29','ifOutOctets.29',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21177,4,'public','.1.3.6.1.2.1.2.2.1.16.3',161,10034,'ifOutOctets.3','ifOutOctets.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21178,4,'public','.1.3.6.1.2.1.2.2.1.16.30',161,10034,'ifOutOctets.30','ifOutOctets.30',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21179,4,'public','.1.3.6.1.2.1.2.2.1.16.31',161,10034,'ifOutOctets.31','ifOutOctets.31',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21180,4,'public','.1.3.6.1.2.1.2.2.1.16.32',161,10034,'ifOutOctets.32','ifOutOctets.32',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21181,4,'public','.1.3.6.1.2.1.2.2.1.16.4',161,10034,'ifOutOctets.4','ifOutOctets.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21182,4,'public','.1.3.6.1.2.1.2.2.1.16.5',161,10034,'ifOutOctets.5','ifOutOctets.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21183,4,'public','.1.3.6.1.2.1.2.2.1.16.6',161,10034,'ifOutOctets.6','ifOutOctets.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21184,4,'public','.1.3.6.1.2.1.2.2.1.16.7',161,10034,'ifOutOctets.7','ifOutOctets.7',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21185,4,'public','.1.3.6.1.2.1.2.2.1.16.8',161,10034,'ifOutOctets.8','ifOutOctets.8',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21186,4,'public','.1.3.6.1.2.1.2.2.1.16.9',161,10034,'ifOutOctets.9','ifOutOctets.9',60,30,365,NULL,NULL,NULL,0,0,'','bps',1,1,NULL,'',0,'','','0.125','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21187,4,'public','.1.3.6.1.2.1.2.2.1.5.1',161,10034,'ifSpeed.1','ifSpeed.1',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21188,4,'public','.1.3.6.1.2.1.2.2.1.5.10',161,10034,'ifSpeed.10','ifSpeed.10',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21189,4,'public','.1.3.6.1.2.1.2.2.1.5.100000',161,10034,'ifSpeed.100000','ifSpeed.100000',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21190,4,'public','.1.3.6.1.2.1.2.2.1.5.100001',161,10034,'ifSpeed.100001','ifSpeed.100001',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21191,4,'public','.1.3.6.1.2.1.2.2.1.5.100002',161,10034,'ifSpeed.100002','ifSpeed.100002',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21192,4,'public','.1.3.6.1.2.1.2.2.1.5.100003',161,10034,'ifSpeed.100003','ifSpeed.100003',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21193,4,'public','.1.3.6.1.2.1.2.2.1.5.11',161,10034,'ifSpeed.11','ifSpeed.11',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21194,4,'public','.1.3.6.1.2.1.2.2.1.5.12',161,10034,'ifSpeed.12','ifSpeed.12',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21195,4,'public','.1.3.6.1.2.1.2.2.1.5.13',161,10034,'ifSpeed.13','ifSpeed.13',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21196,4,'public','.1.3.6.1.2.1.2.2.1.5.14',161,10034,'ifSpeed.14','ifSpeed.14',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21197,4,'public','.1.3.6.1.2.1.2.2.1.5.15',161,10034,'ifSpeed.15','ifSpeed.15',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21198,4,'public','.1.3.6.1.2.1.2.2.1.5.16',161,10034,'ifSpeed.16','ifSpeed.16',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21199,4,'public','.1.3.6.1.2.1.2.2.1.5.17',161,10034,'ifSpeed.17','ifSpeed.17',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21200,4,'public','.1.3.6.1.2.1.2.2.1.5.18',161,10034,'ifSpeed.18','ifSpeed.18',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21201,4,'public','.1.3.6.1.2.1.2.2.1.5.19',161,10034,'ifSpeed.19','ifSpeed.19',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21202,4,'public','.1.3.6.1.2.1.2.2.1.5.2',161,10034,'ifSpeed.2','ifSpeed.2',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21203,4,'public','.1.3.6.1.2.1.2.2.1.5.20',161,10034,'ifSpeed.20','ifSpeed.20',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21204,4,'public','.1.3.6.1.2.1.2.2.1.5.21',161,10034,'ifSpeed.21','ifSpeed.21',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21205,4,'public','.1.3.6.1.2.1.2.2.1.5.22',161,10034,'ifSpeed.22','ifSpeed.22',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21206,4,'public','.1.3.6.1.2.1.2.2.1.5.23',161,10034,'ifSpeed.23','ifSpeed.23',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21207,4,'public','.1.3.6.1.2.1.2.2.1.5.24',161,10034,'ifSpeed.24','ifSpeed.24',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21208,4,'public','.1.3.6.1.2.1.2.2.1.5.25',161,10034,'ifSpeed.25','ifSpeed.25',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21209,4,'public','.1.3.6.1.2.1.2.2.1.5.26',161,10034,'ifSpeed.26','ifSpeed.26',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21210,4,'public','.1.3.6.1.2.1.2.2.1.5.27',161,10034,'ifSpeed.27','ifSpeed.27',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21211,4,'public','.1.3.6.1.2.1.2.2.1.5.28',161,10034,'ifSpeed.28','ifSpeed.28',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21212,4,'public','.1.3.6.1.2.1.2.2.1.5.29',161,10034,'ifSpeed.29','ifSpeed.29',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21213,4,'public','.1.3.6.1.2.1.2.2.1.5.3',161,10034,'ifSpeed.3','ifSpeed.3',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21214,4,'public','.1.3.6.1.2.1.2.2.1.5.30',161,10034,'ifSpeed.30','ifSpeed.30',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21215,4,'public','.1.3.6.1.2.1.2.2.1.5.31',161,10034,'ifSpeed.31','ifSpeed.31',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21216,4,'public','.1.3.6.1.2.1.2.2.1.5.32',161,10034,'ifSpeed.32','ifSpeed.32',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21217,4,'public','.1.3.6.1.2.1.2.2.1.5.4',161,10034,'ifSpeed.4','ifSpeed.4',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21218,4,'public','.1.3.6.1.2.1.2.2.1.5.5',161,10034,'ifSpeed.5','ifSpeed.5',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21219,4,'public','.1.3.6.1.2.1.2.2.1.5.6',161,10034,'ifSpeed.6','ifSpeed.6',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21220,4,'public','.1.3.6.1.2.1.2.2.1.5.7',161,10034,'ifSpeed.7','ifSpeed.7',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21221,4,'public','.1.3.6.1.2.1.2.2.1.5.8',161,10034,'ifSpeed.8','ifSpeed.8',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21222,4,'public','.1.3.6.1.2.1.2.2.1.5.9',161,10034,'ifSpeed.9','ifSpeed.9',60,30,365,NULL,NULL,NULL,0,0,'','bps',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21223,4,'public','.1.3.6.1.2.1.1.4.0',161,10034,'sysContact.0','sysContact.0',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21224,4,'public','.1.3.6.1.2.1.1.1.0',161,10034,'sysDescr.0','sysDescr.0',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21225,4,'public','.1.3.6.1.2.1.1.6.0',161,10034,'sysLocation.0','sysLocation.0',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21226,4,'public','.1.3.6.1.2.1.1.5.0',161,10034,'sysName.0','sysName.0',60,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21227,4,'public','.1.3.6.1.2.1.47.1.1.1.1.2.68420352',161,10034,'systemType','systemType',1800,30,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21228,4,'public','.1.3.6.1.2.1.1.3.0',161,10034,'sysUpTime','sysUpTime',60,30,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21229,0,'','',161,10035,'transactions failed per second','jmx[org.hibernate:type=statistics][OptimisticFailureCount]',30,90,365,NULL,NULL,NULL,0,3,'','',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21230,0,'','',161,10035,'peak execution sql','jmx[org.hibernate:type=statistics][QueryExecutionMaxTimeQueryString]',30,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21231,0,'','',161,10035,'peak execution time','jmx[org.hibernate:type=statistics][QueryExecutionMaxTime]',30,90,365,NULL,NULL,NULL,0,0,'','s',1,0,NULL,'',0,'','','0.001','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21232,0,'','',161,10035,'session close count','jmx[org.hibernate:type=statistics][SessionCloseCount]',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21233,0,'','',161,10035,'session open count','jmx[org.hibernate:type=statistics][SessionOpenCount]',30,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21234,0,'','',161,10035,'transactions successful per second','jmx[org.hibernate:type=statistics][SuccessfulTransactionCount]',30,90,365,NULL,NULL,NULL,0,3,'','',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21235,0,'','',161,10035,'transactions per second','jmx[org.hibernate:type=statistics][TransactionCount]',30,90,365,NULL,NULL,NULL,0,3,'','',0,1,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21236,4,'public','.1.3.6.1.2.1.43.10.2.1.4.1.1',161,10036,'prtMarkerLifeCount.1.1','prtMarkerLifeCount.1.1',3600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21237,4,'public','.1.3.6.1.2.1.43.10.2.1.5.1.1',161,10036,'prtMarkerPowerOnCount.1.1','prtMarkerPowerOnCount.1.1',3600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21238,4,'public','.1.3.6.1.2.1.43.11.1.1.6.1.1',161,10036,'prtMarkerSuppliesDescription.1.1','prtMarkerSuppliesDescription.1.1',86400,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21239,4,'public','.1.3.6.1.2.1.43.11.1.1.6.1.2',161,10036,'prtMarkerSuppliesDescription.1.2','prtMarkerSuppliesDescription.1.2',86400,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21240,4,'public','.1.3.6.1.2.1.43.11.1.1.6.1.3',161,10036,'prtMarkerSuppliesDescription.1.3','prtMarkerSuppliesDescription.1.3',86400,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21241,4,'public','.1.3.6.1.2.1.43.11.1.1.6.1.4',161,10036,'prtMarkerSuppliesDescription.1.4','prtMarkerSuppliesDescription.1.4',86400,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21242,4,'public','.1.3.6.1.2.1.43.11.1.1.6.1.5',161,10036,'prtMarkerSuppliesDescription.1.5','prtMarkerSuppliesDescription.1.5',86400,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21243,4,'public','.1.3.6.1.2.1.43.11.1.1.6.1.6',161,10036,'prtMarkerSuppliesDescription.1.6','prtMarkerSuppliesDescription.1.6',86400,90,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21244,4,'public','.1.3.6.1.2.1.43.11.1.1.9.1.1',161,10036,'prtMarkerSuppliesLevel.1.1','prtMarkerSuppliesLevel.1.1',600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21245,4,'public','.1.3.6.1.2.1.43.11.1.1.9.1.2',161,10036,'prtMarkerSuppliesLevel.1.2','prtMarkerSuppliesLevel.1.2',600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21246,4,'public','.1.3.6.1.2.1.43.11.1.1.9.1.3',161,10036,'prtMarkerSuppliesLevel.1.3','prtMarkerSuppliesLevel.1.3',600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21247,4,'public','.1.3.6.1.2.1.43.11.1.1.9.1.4',161,10036,'prtMarkerSuppliesLevel.1.4','prtMarkerSuppliesLevel.1.4',600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21248,4,'public','.1.3.6.1.2.1.43.11.1.1.9.1.5',161,10036,'prtMarkerSuppliesLevel.1.5','prtMarkerSuppliesLevel.1.5',600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21249,4,'public','.1.3.6.1.2.1.43.11.1.1.9.1.6',161,10036,'prtMarkerSuppliesLevel.1.6','prtMarkerSuppliesLevel.1.6',600,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21250,4,'public','.1.3.6.1.2.1.43.11.1.1.8.1.1',161,10036,'prtMarkerSuppliesMaxCapacity.1.1','prtMarkerSuppliesMaxCapacity.1.1',14400,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21251,4,'public','.1.3.6.1.2.1.43.11.1.1.8.1.2',161,10036,'prtMarkerSuppliesMaxCapacity.1.2','prtMarkerSuppliesMaxCapacity.1.2',14400,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21252,4,'public','.1.3.6.1.2.1.43.11.1.1.8.1.3',161,10036,'prtMarkerSuppliesMaxCapacity.1.3','prtMarkerSuppliesMaxCapacity.1.3',14400,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21253,4,'public','.1.3.6.1.2.1.43.11.1.1.8.1.4',161,10036,'prtMarkerSuppliesMaxCapacity.1.4','prtMarkerSuppliesMaxCapacity.1.4',14400,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21254,4,'public','.1.3.6.1.2.1.43.11.1.1.8.1.5',161,10036,'prtMarkerSuppliesMaxCapacity.1.5','prtMarkerSuppliesMaxCapacity.1.5',14400,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21255,4,'public','.1.3.6.1.2.1.43.11.1.1.8.1.6',161,10036,'prtMarkerSuppliesMaxCapacity.1.6','prtMarkerSuppliesMaxCapacity.1.6',14400,90,365,NULL,NULL,NULL,0,3,'','',0,0,NULL,'',0,'','','1','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21268,4,'public','1.3.6.1.2.1.5.13.0',161,10038,'icmpInAddrMaskReps','icmpInAddrMaskReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21269,4,'public','1.3.6.1.2.1.5.12.0',161,10038,'icmpInAddrMasks','icmpInAddrMasks',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21270,4,'public','1.3.6.1.2.1.5.3.0',161,10038,'icmpInDestUnreachs','icmpInDestUnreachs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21271,4,'public','1.3.6.1.2.1.5.9.0',161,10038,'icmpInEchoReps','icmpInEchoReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21272,4,'public','1.3.6.1.2.1.5.8.0',161,10038,'icmpInEchos','icmpInEchos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21273,4,'public','1.3.6.1.2.1.5.2.0',161,10038,'icmpInErrors','icmpInErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21274,4,'public','1.3.6.1.2.1.5.1.0',161,10038,'icmpInMsgs','icmpInMsgs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21275,4,'public','1.3.6.1.2.1.5.5.0',161,10038,'icmpInParmProbs','icmpInParmProbs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21276,4,'public','1.3.6.1.2.1.5.7.0',161,10038,'icmpInRedirects','icmpInRedirects',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21277,4,'public','1.3.6.1.2.1.5.6.0',161,10038,'icmpInSrcQuenchs','icmpInSrcQuenchs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21278,4,'public','1.3.6.1.2.1.5.4.0',161,10038,'icmpInTimeExcds','icmpInTimeExcds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21279,4,'public','1.3.6.1.2.1.5.11.0',161,10038,'icmpInTimestampReps','icmpInTimestampReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21280,4,'public','1.3.6.1.2.1.5.10.0',161,10038,'icmpInTimestamps','icmpInTimestamps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21281,4,'public','1.3.6.1.2.1.5.26.0',161,10038,'icmpOutAddrMaskReps','icmpOutAddrMaskReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21282,4,'public','1.3.6.1.2.1.5.25.0',161,10038,'icmpOutAddrMasks','icmpOutAddrMasks',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21283,4,'public','1.3.6.1.2.1.5.16.0',161,10038,'icmpOutDesUnreachs','icmpOutDesUnreachs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21284,4,'public','1.3.6.1.2.1.5.22.0',161,10038,'icmpOutEchoReps','icmpOutEchoReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21285,4,'public','1.3.6.1.2.1.5.21.0',161,10038,'icmpOutEchos','icmpOutEchos',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21286,4,'public','1.3.6.1.2.1.5.15.0',161,10038,'icmpOutErrors','icmpOutErrors',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21287,4,'public','1.3.6.1.2.1.5.14.0',161,10038,'icmpOutMsgs','icmpOutMsgs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21288,4,'public','1.3.6.1.2.1.5.18.0',161,10038,'icmpOutParmProbs','icmpOutParmProbs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21289,4,'public','1.3.6.1.2.1.5.20.0',161,10038,'icmpOutRedirects','icmpOutRedirects',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21290,4,'public','1.3.6.1.2.1.5.19.0',161,10038,'icmpOutSrcQuenchs','icmpOutSrcQuenchs',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21291,4,'public','1.3.6.1.2.1.5.17.0',161,10038,'icmpOutTimeExcds','icmpOutTimeExcds',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21292,4,'public','1.3.6.1.2.1.5.24.0',161,10038,'icmpOutTimestampReps','icmpOutTimestampReps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21293,4,'public','1.3.6.1.2.1.5.23.0',161,10038,'icmpOutTimestamps','icmpOutTimestamps',60,7,365,NULL,NULL,NULL,0,0,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21294,4,'public','1.3.6.1.2.1.2.2.1.2.1',161,10038,'ifDescr1','ifDescr1',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21295,4,'public','1.3.6.1.2.1.2.2.1.2.10',161,10038,'ifDescr10','ifDescr10',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21296,4,'public','1.3.6.1.2.1.2.2.1.2.11',161,10038,'ifDescr11','ifDescr11',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21297,4,'public','1.3.6.1.2.1.2.2.1.2.12',161,10038,'ifDescr12','ifDescr12',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21298,4,'public','1.3.6.1.2.1.2.2.1.2.13',161,10038,'ifDescr13','ifDescr13',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21299,4,'public','1.3.6.1.2.1.2.2.1.2.14',161,10038,'ifDescr14','ifDescr14',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21300,4,'public','1.3.6.1.2.1.2.2.1.2.15',161,10038,'ifDescr15','ifDescr15',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21301,4,'public','1.3.6.1.2.1.2.2.1.2.16',161,10038,'ifDescr16','ifDescr16',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21302,4,'public','1.3.6.1.2.1.2.2.1.2.17',161,10038,'ifDescr17','ifDescr17',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21303,4,'public','1.3.6.1.2.1.2.2.1.2.18',161,10038,'ifDescr18','ifDescr18',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21304,4,'public','1.3.6.1.2.1.2.2.1.2.19',161,10038,'ifDescr19','ifDescr19',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21305,4,'public','1.3.6.1.2.1.2.2.1.2.2',161,10038,'ifDescr2','ifDescr2',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21306,4,'public','1.3.6.1.2.1.2.2.1.2.20',161,10038,'ifDescr20','ifDescr20',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21307,4,'public','1.3.6.1.2.1.2.2.1.2.21',161,10038,'ifDescr21','ifDescr21',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21308,4,'public','1.3.6.1.2.1.2.2.1.2.22',161,10038,'ifDescr22','ifDescr22',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21309,4,'public','1.3.6.1.2.1.2.2.1.2.23',161,10038,'ifDescr23','ifDescr23',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21310,4,'public','1.3.6.1.2.1.2.2.1.2.24',161,10038,'ifDescr24','ifDescr24',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21311,4,'public','1.3.6.1.2.1.2.2.1.2.25',161,10038,'ifDescr25','ifDescr25',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21312,4,'public','1.3.6.1.2.1.2.2.1.2.26',161,10038,'ifDescr26','ifDescr26',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21313,4,'public','1.3.6.1.2.1.2.2.1.2.27',161,10038,'ifDescr27','ifDescr27',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21314,4,'public','1.3.6.1.2.1.2.2.1.2.28',161,10038,'ifDescr28','ifDescr28',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21315,4,'public','1.3.6.1.2.1.2.2.1.2.29',161,10038,'ifDescr29','ifDescr29',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21316,4,'public','1.3.6.1.2.1.2.2.1.2.3',161,10038,'ifDescr3','ifDescr3',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21317,4,'public','1.3.6.1.2.1.2.2.1.2.30',161,10038,'ifDescr30','ifDescr30',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21318,4,'public','1.3.6.1.2.1.2.2.1.2.31',161,10038,'ifDescr31','ifDescr31',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21319,4,'public','1.3.6.1.2.1.2.2.1.2.32',161,10038,'ifDescr32','ifDescr32',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21320,4,'public','1.3.6.1.2.1.2.2.1.2.33',161,10038,'ifDescr33','ifDescr33',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21321,4,'public','1.3.6.1.2.1.2.2.1.2.34',161,10038,'ifDescr34','ifDescr34',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21322,4,'public','1.3.6.1.2.1.2.2.1.2.35',161,10038,'ifDescr35','ifDescr35',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21323,4,'public','1.3.6.1.2.1.2.2.1.2.36',161,10038,'ifDescr36','ifDescr36',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21324,4,'public','1.3.6.1.2.1.2.2.1.2.37',161,10038,'ifDescr37','ifDescr37',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21325,4,'public','1.3.6.1.2.1.2.2.1.2.38',161,10038,'ifDescr38','ifDescr38',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21326,4,'public','1.3.6.1.2.1.2.2.1.2.39',161,10038,'ifDescr39','ifDescr39',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21327,4,'public','1.3.6.1.2.1.2.2.1.2.4',161,10038,'ifDescr4','ifDescr4',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21328,4,'public','1.3.6.1.2.1.2.2.1.2.40',161,10038,'ifDescr40','ifDescr40',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21329,4,'public','1.3.6.1.2.1.2.2.1.2.41',161,10038,'ifDescr41','ifDescr41',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21330,4,'public','1.3.6.1.2.1.2.2.1.2.42',161,10038,'ifDescr42','ifDescr42',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21331,4,'public','1.3.6.1.2.1.2.2.1.2.43',161,10038,'ifDescr43','ifDescr43',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21332,4,'public','1.3.6.1.2.1.2.2.1.2.44',161,10038,'ifDescr44','ifDescr44',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21333,4,'public','1.3.6.1.2.1.2.2.1.2.45',161,10038,'ifDescr45','ifDescr45',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21334,4,'public','1.3.6.1.2.1.2.2.1.2.46',161,10038,'ifDescr46','ifDescr46',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21335,4,'public','1.3.6.1.2.1.2.2.1.2.47',161,10038,'ifDescr47','ifDescr47',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21336,4,'public','1.3.6.1.2.1.2.2.1.2.48',161,10038,'ifDescr48','ifDescr48',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21337,4,'public','1.3.6.1.2.1.2.2.1.2.49',161,10038,'ifDescr49','ifDescr49',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21338,4,'public','1.3.6.1.2.1.2.2.1.2.5',161,10038,'ifDescr5','ifDescr5',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21339,4,'public','1.3.6.1.2.1.2.2.1.2.50',161,10038,'ifDescr50','ifDescr50',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21340,4,'public','1.3.6.1.2.1.2.2.1.2.51',161,10038,'ifDescr51','ifDescr51',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21341,4,'public','1.3.6.1.2.1.2.2.1.2.6',161,10038,'ifDescr6','ifDescr6',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21342,4,'public','1.3.6.1.2.1.2.2.1.2.7',161,10038,'ifDescr7','ifDescr7',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21343,4,'public','1.3.6.1.2.1.2.2.1.2.8',161,10038,'ifDescr8','ifDescr8',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21344,4,'public','1.3.6.1.2.1.2.2.1.2.9',161,10038,'ifDescr9','ifDescr9',300,7,365,NULL,NULL,NULL,0,1,'','',0,0,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21345,4,'public','1.3.6.1.2.1.2.2.1.13.1',161,10038,'ifInDiscards01','ifInDiscards01',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21346,4,'public','1.3.6.1.2.1.2.2.1.13.2',161,10038,'ifInDiscards02','ifInDiscards02',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21347,4,'public','1.3.6.1.2.1.2.2.1.13.3',161,10038,'ifInDiscards03','ifInDiscards03',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21348,4,'public','1.3.6.1.2.1.2.2.1.13.4',161,10038,'ifInDiscards04','ifInDiscards04',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21349,4,'public','1.3.6.1.2.1.2.2.1.13.5',161,10038,'ifInDiscards05','ifInDiscards05',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21350,4,'public','1.3.6.1.2.1.2.2.1.13.6',161,10038,'ifInDiscards06','ifInDiscards06',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21351,4,'public','1.3.6.1.2.1.2.2.1.13.7',161,10038,'ifInDiscards07','ifInDiscards07',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21352,4,'public','1.3.6.1.2.1.2.2.1.13.8',161,10038,'ifInDiscards08','ifInDiscards08',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21353,4,'public','1.3.6.1.2.1.2.2.1.13.9',161,10038,'ifInDiscards09','ifInDiscards09',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21354,4,'public','1.3.6.1.2.1.2.2.1.13.10',161,10038,'ifInDiscards10','ifInDiscards10',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21355,4,'public','1.3.6.1.2.1.2.2.1.13.11',161,10038,'ifInDiscards11','ifInDiscards11',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21356,4,'public','1.3.6.1.2.1.2.2.1.13.12',161,10038,'ifInDiscards12','ifInDiscards12',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21357,4,'public','1.3.6.1.2.1.2.2.1.13.13',161,10038,'ifInDiscards13','ifInDiscards13',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21358,4,'public','1.3.6.1.2.1.2.2.1.13.14',161,10038,'ifInDiscards14','ifInDiscards14',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21359,4,'public','1.3.6.1.2.1.2.2.1.13.15',161,10038,'ifInDiscards15','ifInDiscards15',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21360,4,'public','1.3.6.1.2.1.2.2.1.13.16',161,10038,'ifInDiscards16','ifInDiscards16',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21361,4,'public','1.3.6.1.2.1.2.2.1.13.17',161,10038,'ifInDiscards17','ifInDiscards17',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21362,4,'public','1.3.6.1.2.1.2.2.1.13.18',161,10038,'ifInDiscards18','ifInDiscards18',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21363,4,'public','1.3.6.1.2.1.2.2.1.13.19',161,10038,'ifInDiscards19','ifInDiscards19',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21364,4,'public','1.3.6.1.2.1.2.2.1.13.20',161,10038,'ifInDiscards20','ifInDiscards20',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21365,4,'public','1.3.6.1.2.1.2.2.1.13.21',161,10038,'ifInDiscards21','ifInDiscards21',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21366,4,'public','1.3.6.1.2.1.2.2.1.13.22',161,10038,'ifInDiscards22','ifInDiscards22',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21367,4,'public','1.3.6.1.2.1.2.2.1.13.23',161,10038,'ifInDiscards23','ifInDiscards23',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21368,4,'public','1.3.6.1.2.1.2.2.1.13.24',161,10038,'ifInDiscards24','ifInDiscards24',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21369,4,'public','1.3.6.1.2.1.2.2.1.13.25',161,10038,'ifInDiscards25','ifInDiscards25',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21370,4,'public','1.3.6.1.2.1.2.2.1.13.26',161,10038,'ifInDiscards26','ifInDiscards26',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21371,4,'public','1.3.6.1.2.1.2.2.1.13.27',161,10038,'ifInDiscards27','ifInDiscards27',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21372,4,'public','1.3.6.1.2.1.2.2.1.13.28',161,10038,'ifInDiscards28','ifInDiscards28',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21373,4,'public','1.3.6.1.2.1.2.2.1.13.29',161,10038,'ifInDiscards29','ifInDiscards29',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21374,4,'public','1.3.6.1.2.1.2.2.1.13.30',161,10038,'ifInDiscards30','ifInDiscards30',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21375,4,'public','1.3.6.1.2.1.2.2.1.13.31',161,10038,'ifInDiscards31','ifInDiscards31',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21376,4,'public','1.3.6.1.2.1.2.2.1.13.32',161,10038,'ifInDiscards32','ifInDiscards32',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21377,4,'public','1.3.6.1.2.1.2.2.1.13.33',161,10038,'ifInDiscards33','ifInDiscards33',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21378,4,'public','1.3.6.1.2.1.2.2.1.13.34',161,10038,'ifInDiscards34','ifInDiscards34',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21379,4,'public','1.3.6.1.2.1.2.2.1.13.35',161,10038,'ifInDiscards35','ifInDiscards35',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21380,4,'public','1.3.6.1.2.1.2.2.1.13.36',161,10038,'ifInDiscards36','ifInDiscards36',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21381,4,'public','1.3.6.1.2.1.2.2.1.13.37',161,10038,'ifInDiscards37','ifInDiscards37',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21382,4,'public','1.3.6.1.2.1.2.2.1.13.38',161,10038,'ifInDiscards38','ifInDiscards38',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21383,4,'public','1.3.6.1.2.1.2.2.1.13.39',161,10038,'ifInDiscards39','ifInDiscards39',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21384,4,'public','1.3.6.1.2.1.2.2.1.13.40',161,10038,'ifInDiscards40','ifInDiscards40',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21385,4,'public','1.3.6.1.2.1.2.2.1.13.41',161,10038,'ifInDiscards41','ifInDiscards41',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21386,4,'public','1.3.6.1.2.1.2.2.1.13.42',161,10038,'ifInDiscards42','ifInDiscards42',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21387,4,'public','1.3.6.1.2.1.2.2.1.13.43',161,10038,'ifInDiscards43','ifInDiscards43',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21388,4,'public','1.3.6.1.2.1.2.2.1.13.44',161,10038,'ifInDiscards44','ifInDiscards44',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21389,4,'public','1.3.6.1.2.1.2.2.1.13.45',161,10038,'ifInDiscards45','ifInDiscards45',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21390,4,'public','1.3.6.1.2.1.2.2.1.13.46',161,10038,'ifInDiscards46','ifInDiscards46',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21391,4,'public','1.3.6.1.2.1.2.2.1.13.47',161,10038,'ifInDiscards47','ifInDiscards47',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21392,4,'public','1.3.6.1.2.1.2.2.1.13.48',161,10038,'ifInDiscards48','ifInDiscards48',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21393,4,'public','1.3.6.1.2.1.2.2.1.13.49',161,10038,'ifInDiscards49','ifInDiscards49',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21394,4,'public','1.3.6.1.2.1.2.2.1.13.50',161,10038,'ifInDiscards50','ifInDiscards50',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21395,4,'public','1.3.6.1.2.1.2.2.1.13.51',161,10038,'ifInDiscards51','ifInDiscards51',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21396,4,'public','1.3.6.1.2.1.2.2.1.14.1',161,10038,'ifInErrors01','ifInErrors01',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21397,4,'public','1.3.6.1.2.1.2.2.1.14.2',161,10038,'ifInErrors02','ifInErrors02',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21398,4,'public','1.3.6.1.2.1.2.2.1.14.3',161,10038,'ifInErrors03','ifInErrors03',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21399,4,'public','1.3.6.1.2.1.2.2.1.14.4',161,10038,'ifInErrors04','ifInErrors04',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21400,4,'public','1.3.6.1.2.1.2.2.1.14.5',161,10038,'ifInErrors05','ifInErrors05',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21401,4,'public','1.3.6.1.2.1.2.2.1.14.6',161,10038,'ifInErrors06','ifInErrors06',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21402,4,'public','1.3.6.1.2.1.2.2.1.14.7',161,10038,'ifInErrors07','ifInErrors07',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21403,4,'public','1.3.6.1.2.1.2.2.1.14.8',161,10038,'ifInErrors08','ifInErrors08',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21404,4,'public','1.3.6.1.2.1.2.2.1.14.9',161,10038,'ifInErrors09','ifInErrors09',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21405,4,'public','1.3.6.1.2.1.2.2.1.14.10',161,10038,'ifInErrors10','ifInErrors10',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21406,4,'public','1.3.6.1.2.1.2.2.1.14.11',161,10038,'ifInErrors11','ifInErrors11',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21407,4,'public','1.3.6.1.2.1.2.2.1.14.12',161,10038,'ifInErrors12','ifInErrors12',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21408,4,'public','1.3.6.1.2.1.2.2.1.14.13',161,10038,'ifInErrors13','ifInErrors13',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21409,4,'public','1.3.6.1.2.1.2.2.1.14.14',161,10038,'ifInErrors14','ifInErrors14',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21410,4,'public','1.3.6.1.2.1.2.2.1.14.15',161,10038,'ifInErrors15','ifInErrors15',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21411,4,'public','1.3.6.1.2.1.2.2.1.14.16',161,10038,'ifInErrors16','ifInErrors16',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21412,4,'public','1.3.6.1.2.1.2.2.1.14.17',161,10038,'ifInErrors17','ifInErrors17',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21413,4,'public','1.3.6.1.2.1.2.2.1.14.18',161,10038,'ifInErrors18','ifInErrors18',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21414,4,'public','1.3.6.1.2.1.2.2.1.14.19',161,10038,'ifInErrors19','ifInErrors19',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21415,4,'public','1.3.6.1.2.1.2.2.1.14.20',161,10038,'ifInErrors20','ifInErrors20',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21416,4,'public','1.3.6.1.2.1.2.2.1.14.21',161,10038,'ifInErrors21','ifInErrors21',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21417,4,'public','1.3.6.1.2.1.2.2.1.14.22',161,10038,'ifInErrors22','ifInErrors22',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21418,4,'public','1.3.6.1.2.1.2.2.1.14.23',161,10038,'ifInErrors23','ifInErrors23',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21419,4,'public','1.3.6.1.2.1.2.2.1.14.24',161,10038,'ifInErrors24','ifInErrors24',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21420,4,'public','1.3.6.1.2.1.2.2.1.14.25',161,10038,'ifInErrors25','ifInErrors25',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21421,4,'public','1.3.6.1.2.1.2.2.1.14.26',161,10038,'ifInErrors26','ifInErrors26',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21422,4,'public','1.3.6.1.2.1.2.2.1.14.27',161,10038,'ifInErrors27','ifInErrors27',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21423,4,'public','1.3.6.1.2.1.2.2.1.14.28',161,10038,'ifInErrors28','ifInErrors28',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21424,4,'public','1.3.6.1.2.1.2.2.1.14.29',161,10038,'ifInErrors29','ifInErrors29',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21425,4,'public','1.3.6.1.2.1.2.2.1.14.30',161,10038,'ifInErrors30','ifInErrors30',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21426,4,'public','1.3.6.1.2.1.2.2.1.14.31',161,10038,'ifInErrors31','ifInErrors31',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21427,4,'public','1.3.6.1.2.1.2.2.1.14.32',161,10038,'ifInErrors32','ifInErrors32',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21428,4,'public','1.3.6.1.2.1.2.2.1.14.33',161,10038,'ifInErrors33','ifInErrors33',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21429,4,'public','1.3.6.1.2.1.2.2.1.14.34',161,10038,'ifInErrors34','ifInErrors34',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21430,4,'public','1.3.6.1.2.1.2.2.1.14.35',161,10038,'ifInErrors35','ifInErrors35',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21431,4,'public','1.3.6.1.2.1.2.2.1.14.36',161,10038,'ifInErrors36','ifInErrors36',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21432,4,'public','1.3.6.1.2.1.2.2.1.14.37',161,10038,'ifInErrors37','ifInErrors37',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21433,4,'public','1.3.6.1.2.1.2.2.1.14.38',161,10038,'ifInErrors38','ifInErrors38',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21434,4,'public','1.3.6.1.2.1.2.2.1.14.39',161,10038,'ifInErrors39','ifInErrors39',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21435,4,'public','1.3.6.1.2.1.2.2.1.14.40',161,10038,'ifInErrors40','ifInErrors40',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21436,4,'public','1.3.6.1.2.1.2.2.1.14.41',161,10038,'ifInErrors41','ifInErrors41',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21437,4,'public','1.3.6.1.2.1.2.2.1.14.42',161,10038,'ifInErrors42','ifInErrors42',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21438,4,'public','1.3.6.1.2.1.2.2.1.14.43',161,10038,'ifInErrors43','ifInErrors43',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21439,4,'public','1.3.6.1.2.1.2.2.1.14.44',161,10038,'ifInErrors44','ifInErrors44',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21440,4,'public','1.3.6.1.2.1.2.2.1.14.45',161,10038,'ifInErrors45','ifInErrors45',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21441,4,'public','1.3.6.1.2.1.2.2.1.14.46',161,10038,'ifInErrors46','ifInErrors46',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21442,4,'public','1.3.6.1.2.1.2.2.1.14.47',161,10038,'ifInErrors47','ifInErrors47',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21443,4,'public','1.3.6.1.2.1.2.2.1.14.48',161,10038,'ifInErrors48','ifInErrors48',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21444,4,'public','1.3.6.1.2.1.2.2.1.14.49',161,10038,'ifInErrors49','ifInErrors49',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21445,4,'public','1.3.6.1.2.1.2.2.1.14.50',161,10038,'ifInErrors50','ifInErrors50',120,7,365,NULL,NULL,NULL,0,0,'','',0,1,NULL,'',0,'','','','',0,'',0,0,'','','',0,0,'','','','',0);
INSERT INTO items VALUES (21446,4,'public','1.3.6.1.2.1.2.2.1.14.51',161,10038,'ifInErrors51','ifInErrors51',120,7,36