/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.actions.AbstractActionRadioButton;

public class ViewFit
extends AbstractActionRadioButton {
    public static final String NONE = "None";
    public static final String WINDOW = "Window";
    public static final String PAGE_WIDTH = "PageWidth";
    public static final String PAGE = "Page";

    public ViewFit(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
        this.lastActionCommand = NONE;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Dimension dimension;
        this.lastActionCommand = actionEvent.getActionCommand();
        if (NONE.equals(actionEvent.getActionCommand())) {
            this.getCurrentDocument().setResizeAction(null);
            this.getCurrentGraph().setScale(1.0);
        } else if (WINDOW.equals(actionEvent.getActionCommand())) {
            Rectangle rectangle = this.getCurrentGraph().getCellBounds(this.getCurrentGraph().getRoots());
            if (rectangle != null) {
                Dimension dimension2 = this.getCurrentDocument().getScrollPane().getViewport().getExtentSize();
                double d = 1.0;
                d = Math.abs(dimension2.getWidth() - ((double)rectangle.x + rectangle.getWidth())) > Math.abs(dimension2.getHeight() - ((double)rectangle.x + rectangle.getHeight())) ? dimension2.getWidth() / ((double)rectangle.x + rectangle.getWidth()) : dimension2.getHeight() / ((double)rectangle.y + rectangle.getHeight());
                d = Math.max(Math.min(d, 16.0), 0.01);
                this.getCurrentGraph().setScale(d);
                this.getCurrentDocument().setResizeAction(this);
            }
        } else if (PAGE.equals(actionEvent.getActionCommand())) {
            Dimension dimension3 = this.getCurrentGraph().getMinimumSize();
            if (dimension3 != null && (dimension3.getWidth() != 0.0 || dimension3.getHeight() != 0.0)) {
                Dimension dimension4 = this.getCurrentDocument().getScrollPane().getViewport().getExtentSize();
                double d = 1.0;
                d = dimension4.getWidth() / dimension3.getWidth() < dimension4.getHeight() / dimension3.getHeight() ? dimension4.getWidth() / dimension3.getWidth() : dimension4.getHeight() / dimension3.getHeight();
                d = Math.max(Math.min(d, 16.0), 0.01);
                this.getCurrentGraph().setScale(d);
                this.getCurrentDocument().setResizeAction(this);
                this.getCurrentDocument().repaint();
            }
        } else if (PAGE_WIDTH.equals(actionEvent.getActionCommand()) && (dimension = this.getCurrentGraph().getMinimumSize()) != null && (dimension.getWidth() != 0.0 || dimension.getHeight() != 0.0)) {
            Dimension dimension5 = this.getCurrentDocument().getScrollPane().getViewport().getExtentSize();
            dimension5.width -= 20;
            double d = dimension5.getWidth() / dimension.getWidth();
            d = Math.max(Math.min(d, 16.0), 0.01);
            this.getCurrentGraph().setScale(d);
            this.getCurrentDocument().setResizeAction(this);
        }
        this.update();
    }

    public String[] getPossibleActionCommands() {
        return new String[]{NONE, WINDOW, PAGE_WIDTH, PAGE};
    }
}

