/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.border.Border;
import org.jgraph.GPGraphpad;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;
import org.jgraph.pad.actions.AbstractActionListCell;
import org.jgraph.pad.actions.AbstractActionListCellColor;
import org.jgraph.pad.resources.Translator;

public class FormatBorderColorList
extends AbstractActionListCellColor {
    protected Border[] borders = new Border[]{BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder(), BorderFactory.createEtchedBorder()};

    public FormatBorderColorList(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    protected void fillCustomItems(Vector vector) {
        Map map;
        VertexView vertexView;
        int n = 0;
        while (n < this.borders.length) {
            vertexView = new VertexView(null, AbstractActionListCell.dummyGraph, AbstractActionListCell.dummyGraph.getGraphLayoutCache());
            map = GraphConstants.createMap();
            GraphConstants.setBounds(map, new Rectangle(this.point, this.size));
            GraphConstants.setBorder(map, this.borders[n]);
            GraphConstants.setRemoveAttributes(vertexView.getAttributes(), new Object[]{"border"});
            vertexView.setAttributes(map);
            vector.add(vertexView);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.colors.length) {
            vertexView = new VertexView(null, AbstractActionListCell.dummyGraph, AbstractActionListCell.dummyGraph.getGraphLayoutCache());
            map = GraphConstants.createMap();
            GraphConstants.setBounds(map, new Rectangle(this.point, this.size));
            GraphConstants.setBorderColor(map, this.colors[n2]);
            vertexView.setAttributes(map);
            GraphConstants.setRemoveAttributes(vertexView.getAttributes(), new Object[]{"border"});
            vector.add(vertexView);
            ++n2;
        }
    }

    protected void fillResetMap(Map map) {
        Object[] objectArray = new Object[]{"border", "bordercolor"};
        GraphConstants.setRemoveAttributes(map, objectArray);
        GraphConstants.setBorderColor(map, Color.BLACK);
    }

    protected void fillApplyMap(CellView cellView, Map map) {
        Border border;
        Object[] objectArray = new Object[]{"border", "bordercolor"};
        GraphConstants.setRemoveAttributes(map, objectArray);
        Color color = GraphConstants.getBorderColor(cellView.getAttributes());
        if (color != null) {
            GraphConstants.setBorderColor(map, color);
        }
        if ((border = GraphConstants.getBorder(cellView.getAttributes())) != null) {
            GraphConstants.setBorder(map, border);
        }
    }

    protected void selectAndFillMap(Map map) {
        Color color;
        if (this.getCurrentGraph().getSelectionCount() > 0 && (color = JColorChooser.showDialog(this.graphpad.getFrame(), Translator.getString("ColorDialog"), null)) != null) {
            Object[] objectArray = new Object[]{"border"};
            GraphConstants.setRemoveAttributes(map, objectArray);
            GraphConstants.setBorderColor(map, color);
        }
    }
}

