/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.undo.CannotRedoException;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.GPBarFactory;
import org.jgraph.pad.actions.AbstractActionDefault;
import org.jgraph.pad.resources.Translator;

public class EditRedo
extends AbstractActionDefault {
    protected Vector menuItems = new Vector();

    public EditRedo(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.getCurrentDocument().getGraphUndoManager().redo(this.graphpad.getCurrentGraph().getGraphLayoutCache());
        }
        catch (CannotRedoException cannotRedoException) {
            System.out.println("Unable to redo: " + cannotRedoException);
            cannotRedoException.printStackTrace();
        }
        this.update();
    }

    public void update() {
        Enumeration enumeration = this.menuItems.elements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            if (this.getCurrentDocument() != null && this.getCurrentDocument().getGraphUndoManager().canRedo(this.getCurrentGraphLayoutCache())) {
                this.setEnabled(true);
                jMenuItem.setText(this.getCurrentDocument().getGraphUndoManager().getRedoPresentationName());
                continue;
            }
            this.setEnabled(false);
            jMenuItem.setText(Translator.getString("Component.EditRedo.Text"));
        }
    }

    protected Component getMenuComponent(String string) {
        JMenuItem jMenuItem = new JMenuItem(this);
        GPBarFactory.fillMenuButton(jMenuItem, this.getName(), string);
        this.menuItems.add(jMenuItem);
        return jMenuItem;
    }
}

