/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.actions.AbstractActionDefault;

public abstract class AbstractActionFile
extends AbstractActionDefault {
    public static final boolean COMPRESS_FILES = true;

    public AbstractActionFile(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public String openDialog(String string, String string2, String string3) {
        return this.dialog(string, true, string2, string3);
    }

    public String saveDialog(String string, String string2, String string3) {
        return this.dialog(string, false, string2, string3);
    }

    protected String dialog(String string, boolean bl, String string2, String string3) {
        String string4;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        String string5 = string4 = string2 != null ? "." + string2.toLowerCase() : "";
        if (string2 != null) {
            jFileChooser.setFileFilter(new MyFileFilter(string2, string3));
        }
        if (bl) {
            jFileChooser.showOpenDialog(this.graphpad.getFrame());
        } else {
            jFileChooser.showSaveDialog(this.graphpad.getFrame());
        }
        if (jFileChooser.getSelectedFile() != null) {
            String string6 = jFileChooser.getSelectedFile().getAbsolutePath();
            if (string2 != null && !string6.toLowerCase().endsWith(string4)) {
                string6 = string6 + string4;
            }
            return string6;
        }
        return null;
    }

    public static ObjectInputStream createInputStream(String string, boolean bl) throws Exception {
        InputStream inputStream = new FileInputStream(string);
        if (bl) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return new ObjectInputStream(inputStream);
    }

    public static ObjectOutputStream createOutputStream(String string, boolean bl) throws Exception {
        OutputStream outputStream = new FileOutputStream(string);
        if (bl) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        return new ObjectOutputStream(outputStream);
    }

    public static ObjectInputStream createInputStream(String string) throws Exception {
        return AbstractActionFile.createInputStream(string, true);
    }

    public static ObjectOutputStream createOutputStream(String string) throws Exception {
        return AbstractActionFile.createOutputStream(string, true);
    }

    protected class MyFileFilter
    extends FileFilter {
        protected String ext;
        protected String fullExt;
        protected String desc;

        public MyFileFilter(String string, String string2) {
            this.ext = string.toLowerCase();
            this.fullExt = "." + this.ext;
            this.desc = string2;
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(this.fullExt);
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

