/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.GPBarEntry;
import org.jgraph.pad.GPPlugin;
import org.jgraph.pad.actions.AbstractActionDefault;
import org.jgraph.pad.resources.ImageLoader;
import org.jgraph.pad.resources.Translator;
import org.jgraph.pad.resources.TranslatorConstants;
import org.jgraph.utils.Utilities;
import org.jgraph.utils.gui.LocaleChangeAdapter;

public class GPBarFactory
implements TranslatorConstants {
    public static final String MENUBAR = "Menubar";
    public static final String TOOLBARS = "Toolbars";
    public static final String GRAPH_POPUP = "GraphPopup";
    public static final String LIBRARY_POPUP = "LibraryPopup";
    protected static Hashtable barEntries = new Hashtable();
    protected GPGraphpad graphpad;

    public GPBarFactory(GPGraphpad gPGraphpad) {
        this.graphpad = gPGraphpad;
    }

    protected Component[] createMenuItem(String string) {
        if (string == null) {
            return new Component[0];
        }
        String string2 = Translator.getString(string + ".Menu");
        if (string2 != null) {
            String[] stringArray = this.tokenize(string + ".Menu", string2);
            return new Component[]{this.createMenu(string, stringArray)};
        }
        Action action = this.getAction(string);
        if (action == null) {
            return new Component[0];
        }
        if (action instanceof AbstractActionDefault) {
            return ((AbstractActionDefault)action).getMenuComponents();
        }
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(action);
        GPBarFactory.fillMenuButton(jMenuItem, string, "");
        return new Component[]{jMenuItem};
    }

    public JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = this.tokenize(MENUBAR, Translator.getString(MENUBAR));
        int n = 0;
        while (n < stringArray.length) {
            String string = Translator.getString(stringArray[n] + ".Menu");
            if (string == null) {
                System.err.println("Can't find MenuKey: '" + stringArray[n] + "'. I'm ignoring the MenuKey!");
            } else {
                String[] stringArray2 = this.tokenize(stringArray[n], string);
                JMenu jMenu = this.createMenu(stringArray[n], stringArray2);
                if (jMenu != null) {
                    jMenuBar.add(jMenu);
                }
            }
            ++n;
        }
        return jMenuBar;
    }

    public JPopupMenu createGraphPopupMenu() {
        return this.createPopupMenu(GRAPH_POPUP);
    }

    public JPopupMenu createLibraryPopupMenu() {
        return this.createPopupMenu(LIBRARY_POPUP);
    }

    protected JPopupMenu createPopupMenu(String string) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String[] stringArray = this.tokenize(string, Translator.getString(string));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jPopupMenu.addSeparator();
            } else {
                Component[] componentArray = this.createMenuItem(stringArray[n]);
                int n2 = 0;
                while (n2 < componentArray.length) {
                    jPopupMenu.add(componentArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        LocaleChangeAdapter.updateContainer(jPopupMenu);
        return jPopupMenu;
    }

    protected JMenu createMenu(String string) {
        return this.createMenu(string, this.tokenize(string, Translator.getString(string)));
    }

    protected JMenu createMenu(String string, String[] stringArray) {
        String string2;
        Component[] componentArray;
        JMenu jMenu = new JMenu();
        jMenu.setName(string);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jMenu.addSeparator();
            } else {
                componentArray = this.createMenuItem(stringArray[n]);
                int n2 = 0;
                while (n2 < componentArray.length) {
                    if (componentArray[n2] != null) {
                        jMenu.add(componentArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        componentArray = ImageLoader.getImageIcon(Translator.getString(string + ".Image"));
        if (componentArray != null) {
            jMenu.setHorizontalTextPosition(4);
            jMenu.setIcon((Icon)componentArray);
        }
        if ((string2 = Translator.getString(string + ".Mnemonic")) != null && string2.length() > 0) {
            jMenu.setMnemonic(string2.toCharArray()[0]);
        }
        return jMenu;
    }

    public JPanel createToolBars(JPanel jPanel) {
        String string = Translator.getString(TOOLBARS);
        if (string == null) {
            System.err.println("Can't find Key: 'toolbars'. I'm ignoring the MenuKey!");
            return jPanel;
        }
        String[] stringArray = this.tokenize(TOOLBARS, string);
        JPanel jPanel2 = jPanel;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = Translator.getString(stringArray[n] + ".Label");
            jPanel2.add(this.createToolbar(stringArray[n], string2), "North");
            JPanel jPanel3 = jPanel2;
            jPanel2 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel2, "Center");
            ++n;
        }
        return jPanel2;
    }

    protected Component createToolbar(String string, String string2) {
        JToolBar jToolBar = new JToolBar(string2);
        String string3 = Translator.getString(string);
        if (string3 == null) {
            System.err.println("Can't find ToolBarKey: '" + string3 + "'. I'm ignoring the MenuKey!");
            return jToolBar;
        }
        String[] stringArray = this.tokenize(string, string3);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jToolBar.add(Box.createHorizontalStrut(5));
            } else {
                Component[] componentArray = this.createTool(stringArray[n]);
                int n2 = 0;
                while (n2 < componentArray.length) {
                    jToolBar.add(componentArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        jToolBar.add(Box.createHorizontalGlue());
        return jToolBar;
    }

    protected Component[] createTool(String string) {
        return this.createToolbarButton(string);
    }

    protected Component[] createToolbarButton(String string) {
        Action action = this.graphpad.getCurrentActionMap().get(string);
        if (action instanceof AbstractActionDefault) {
            return ((AbstractActionDefault)action).getToolComponents();
        }
        JButton jButton = new JButton();
        jButton.setAction(action);
        GPBarFactory.fillToolbarButton(jButton, string, "");
        return new Component[]{jButton};
    }

    protected Action getAction(String string) {
        block5: {
            Action action = null;
            if (string != null) {
                action = this.graphpad.getCurrentActionMap().get(string);
            }
            if (action != null) {
                return action;
            }
            String string2 = Translator.getString(string + "Plugin");
            System.out.println("cmd=" + string + " className=" + string2);
            if (string2 == null) break block5;
            try {
                final GPPlugin gPPlugin = (GPPlugin)this.getClass().getClassLoader().loadClass(string2).newInstance();
                if (gPPlugin != null) {
                    AbstractAction abstractAction = new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            gPPlugin.execute(GPBarFactory.this.graphpad);
                        }
                    };
                    this.graphpad.getActionMap().put(string, abstractAction);
                    return abstractAction;
                }
                System.err.println("Can't find plugin Class: " + string2);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static AbstractButton fillMenuButton(AbstractButton abstractButton, String string, String string2) {
        abstractButton.putClientProperty("DontSetToolTipText", new Boolean(true));
        return GPBarFactory.fillAbstractButton(abstractButton, string, string2);
    }

    public static AbstractButton fillToolbarButton(AbstractButton abstractButton, String string, String string2) {
        abstractButton.putClientProperty("DontSetMnemonic", new Boolean(true));
        abstractButton.putClientProperty("SetTextIfIconNotAvailable", new Boolean(true));
        return GPBarFactory.fillAbstractButton(abstractButton, string, string2);
    }

    public static AbstractButton fillAbstractButton(AbstractButton abstractButton, String string, String string2) {
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        if (string != null) {
            abstractButton.setName(string);
        }
        abstractButton.setActionCommand(string2);
        return abstractButton;
    }

    protected String[] tokenize(String string, String string2) {
        String[] stringArray = Utilities.tokenize(string2);
        stringArray = this.integrateBarEntries(string, stringArray);
        return stringArray;
    }

    protected String[] integrateBarEntries(String string, String[] stringArray) {
        Object object;
        Vector vector = (Vector)barEntries.get(string);
        if (vector == null || vector.size() == 0) {
            return stringArray;
        }
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector2.add(stringArray[n]);
            ++n;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (GPBarEntry)enumeration.nextElement();
            try {
                vector2.insertElementAt(((GPBarEntry)object).getBarValue(), ((GPBarEntry)object).getPos());
            }
            catch (Exception exception) {
                System.err.println("Error while integrating Bar Entry" + object);
                System.err.println(exception.getMessage());
            }
        }
        object = new String[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            object[n2] = (String)vector2.get(n2);
            ++n2;
        }
        return object;
    }

    public static void addBarEntry(GPBarEntry gPBarEntry) {
        Vector<GPBarEntry> vector = (Vector<GPBarEntry>)barEntries.get(gPBarEntry.getBarKey());
        if (vector == null) {
            vector = new Vector<GPBarEntry>();
            barEntries.put(gPBarEntry.getBarKey(), vector);
        }
        vector.add(gPBarEntry);
    }

    public static void removeBarEntry(GPBarEntry gPBarEntry) {
        Vector vector = (Vector)barEntries.get(gPBarEntry.getBarKey());
        if (vector == null) {
            return;
        }
        vector.remove(gPBarEntry);
    }
}

