/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.pad.EllipseCell;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.GPUserObject;
import org.jgraph.pad.GraphModelFileFormat;
import org.jgraph.pad.ImageCell;
import org.jgraph.pad.ImageIconBean;
import org.jgraph.pad.TextCell;
import org.jgraph.pad.resources.Translator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultGraphModelFileFormatXML
implements GraphModelFileFormat {
    public static final String EMPTY = new String("Empty");
    public static final String PARENT = new String("Parent");
    protected static Map cells = new Hashtable();
    protected static Map attrs = new Hashtable();
    protected static Map objs = new Hashtable();
    protected static List delayedAttributes = new LinkedList();
    protected static List connectionSetIDs = new LinkedList();
    protected Map cellMap = new Hashtable();
    protected AttributeCollection attrCol = new AttributeCollection();
    protected Map userObjectMap = new Hashtable();
    FileFilter fileFilter = new FileFilter(){

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.getName() == null) {
                return false;
            }
            if (file.getName().endsWith(".jgx")) {
                return true;
            }
            return file.isDirectory();
        }

        public String getDescription() {
            return Translator.getString("FileDesc.JGraphpadDiagramXml");
        }
    };
    JComponent compZipSelect = new JCheckBox(Translator.getString("zipCompress"));
    public static final String COMPRESS_WITH_ZIP = "CompressWithZip";
    public static String[] knownKeys = new String[]{"absolute", "autosize", "backgroundColor", "beginFill", "beginSize", "bendable", "border", "bordercolor", "bounds", "connectable", "dashPattern", "disconnectable", "editable", "endFill", "endsize", "font", "foregroundColor", "horizontalAlignment", "verticalAlignment", "icon", "labelposition", "lineBegin", "linecolor", "lineEnd", "lineStyle", "linewidth", "moveable", "offset", "opaque", "points", "routing", "size", "sizeable", "value"};
    public static Class[] keyTypes = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$awt$Color == null ? (class$java$awt$Color = DefaultGraphModelFileFormatXML.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$javax$swing$border$Border == null ? (class$javax$swing$border$Border = DefaultGraphModelFileFormatXML.class$("javax.swing.border.Border")) : class$javax$swing$border$Border, class$java$awt$Color == null ? (class$java$awt$Color = DefaultGraphModelFileFormatXML.class$("java.awt.Color")) : class$java$awt$Color, class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = DefaultGraphModelFileFormatXML.class$("java.awt.Rectangle")) : class$java$awt$Rectangle, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, array$F == null ? (array$F = DefaultGraphModelFileFormatXML.class$("[F")) : array$F, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$awt$Font == null ? (class$java$awt$Font = DefaultGraphModelFileFormatXML.class$("java.awt.Font")) : class$java$awt$Font, class$java$awt$Color == null ? (class$java$awt$Color = DefaultGraphModelFileFormatXML.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer, class$javax$swing$Icon == null ? (class$javax$swing$Icon = DefaultGraphModelFileFormatXML.class$("javax.swing.Icon")) : class$javax$swing$Icon, class$java$awt$Point == null ? (class$java$awt$Point = DefaultGraphModelFileFormatXML.class$("java.awt.Point")) : class$java$awt$Point, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$awt$Color == null ? (class$java$awt$Color = DefaultGraphModelFileFormatXML.class$("java.awt.Color")) : class$java$awt$Color, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Float == null ? (class$java$lang$Float = DefaultGraphModelFileFormatXML.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$awt$Point == null ? (class$java$awt$Point = DefaultGraphModelFileFormatXML.class$("java.awt.Point")) : class$java$awt$Point, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$util$List == null ? (class$java$util$List = DefaultGraphModelFileFormatXML.class$("java.util.List")) : class$java$util$List, class$org$jgraph$graph$Edge$Routing == null ? (class$org$jgraph$graph$Edge$Routing = DefaultGraphModelFileFormatXML.class$("org.jgraph.graph.Edge$Routing")) : class$org$jgraph$graph$Edge$Routing, class$java$awt$Dimension == null ? (class$java$awt$Dimension = DefaultGraphModelFileFormatXML.class$("java.awt.Dimension")) : class$java$awt$Dimension, class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = DefaultGraphModelFileFormatXML.class$("java.lang.Object")) : class$java$lang$Object};
    static /* synthetic */ Class class$java$awt$Rectangle;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$swing$border$Border;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$org$jgraph$graph$Edge$Routing;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public String getFileExtension() {
        return "jgx";
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public JComponent getReadAccessory() {
        return null;
    }

    public JComponent getWriteAccessory() {
        return null;
    }

    public void write(URL uRL, Hashtable hashtable, GPGraph gPGraph, GraphModel graphModel) throws Exception {
        OutputStream outputStream = null;
        outputStream = new FileOutputStream(uRL.getFile());
        outputStream = new BufferedOutputStream(outputStream);
        outputStream.write(this.toString(gPGraph).getBytes());
        outputStream.flush();
        outputStream.close();
    }

    public Hashtable getWriteProperties(JComponent jComponent) {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        if (!(jComponent instanceof JCheckBox)) {
            return hashtable;
        }
        hashtable.put(COMPRESS_WITH_ZIP, new Boolean(((JCheckBox)jComponent).isSelected()));
        return hashtable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GraphModel read(URL uRL, Hashtable hashtable, GPGraph gPGraph) throws Exception {
        Object object;
        InputStream inputStream;
        boolean bl = false;
        try {
            inputStream = uRL.openStream();
            object = new byte[4];
            int n = inputStream.read((byte[])object);
            if (n == 4 && new String((byte[])object).toLowerCase().equals("<jgx")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            try {
                inputStream = uRL.openStream();
                object = new XMLDecoder(new BufferedInputStream(inputStream));
                gPGraph.setArchivedState(((XMLDecoder)object).readObject());
                return gPGraph.getModel();
            }
            catch (Exception exception) {
                try {
                    object = new GZIPInputStream(uRL.openStream());
                    XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream((InputStream)object));
                    gPGraph.setArchivedState(xMLDecoder.readObject());
                    return gPGraph.getModel();
                }
                catch (Exception exception2) {
                    try {
                        DefaultGraphModelFileFormatXML.read(uRL.openStream(), gPGraph);
                        return gPGraph.getModel();
                    }
                    catch (Exception exception3) {
                        if (uRL.toString().toLowerCase().startsWith("http") || uRL.toString().toLowerCase().startsWith("ftp")) return gPGraph.getModel();
                        throw exception3;
                    }
                }
            }
        }
        try {
            DefaultGraphModelFileFormatXML.read(uRL.openStream(), gPGraph);
            return gPGraph.getModel();
        }
        catch (Exception exception) {
            if (uRL.toString().toLowerCase().startsWith("http") || uRL.toString().toLowerCase().startsWith("ftp")) return gPGraph.getModel();
            throw exception;
        }
    }

    public Hashtable getReadProperties(JComponent jComponent) {
        return null;
    }

    public static void read(InputStream inputStream, GPGraph gPGraph) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        GraphModel graphModel = gPGraph.getModel();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        Node node = null;
        Object object5 = null;
        Object object6 = null;
        Object object7 = null;
        int n = 0;
        while (n < document.getDocumentElement().getChildNodes().getLength()) {
            object4 = document.getDocumentElement().getChildNodes().item(n);
            if (object4.getNodeName().toLowerCase().equals("model")) {
                node = object4;
            } else if (object4.getNodeName().toLowerCase().equals("user")) {
                object5 = object4;
            } else if (object4.getNodeName().toLowerCase().equals("attrs")) {
                object6 = object4;
            } else if (object4.getNodeName().toLowerCase().equals("view")) {
                object7 = object4;
            }
            ++n;
        }
        objs = DefaultGraphModelFileFormatXML.decodeUserObjects(object5);
        attrs = DefaultGraphModelFileFormatXML.parseAttrs(object6);
        attrs = DefaultGraphModelFileFormatXML.augmentAttrs(attrs);
        object4 = DefaultGraphModelFileFormatXML.decodeMap(object7, false, false);
        ConnectionSet connectionSet = new ConnectionSet();
        Hashtable hashtable = new Hashtable();
        Object[] objectArray = DefaultGraphModelFileFormatXML.parseChildren(node, hashtable, connectionSet);
        Iterator iterator = connectionSetIDs.iterator();
        while (iterator.hasNext()) {
            Object v;
            object3 = (ConnectionID)iterator.next();
            object2 = ((ConnectionID)object3).getCell();
            object = ((ConnectionID)object3).getTargetID();
            if (object == null || (v = hashtable.get(object)) == null) continue;
            connectionSet.connect(object2, v, ((ConnectionID)object3).isSource());
        }
        object3 = new Hashtable();
        iterator = delayedAttributes.iterator();
        while (iterator.hasNext()) {
            object2 = (DelayedAttributeID)iterator.next();
            object = (Map)attrs.get(((DelayedAttributeID)object2).getMapID());
            if (object == null) continue;
            object = GraphConstants.cloneMap((Map)object);
            if (((DelayedAttributeID)object2).getBounds() != null) {
                GraphConstants.setBounds((Map)object, ((DelayedAttributeID)object2).getBounds());
            }
            if (((DelayedAttributeID)object2).getPoints() != null) {
                GraphConstants.setPoints((Map)object, ((DelayedAttributeID)object2).getPoints());
            }
            object3.put(((DelayedAttributeID)object2).getCell(), object);
        }
        DefaultGraphModelFileFormatXML.applySettings((Map)object4, gPGraph);
        graphModel.insert(objectArray, (Map)object3, connectionSet, null, null);
    }

    public static void applySettings(Map map, GPGraph gPGraph) {
        Object v = map.get("editable");
        if (v != null) {
            gPGraph.setEditable(new Boolean(v.toString()));
        }
        if ((v = map.get("bendable")) != null) {
            gPGraph.setBendable(new Boolean(v.toString()));
        }
        if ((v = map.get("cloneable")) != null) {
            gPGraph.setCloneable(new Boolean(v.toString()));
        }
        if ((v = map.get("connectable")) != null) {
            gPGraph.setConnectable(new Boolean(v.toString()));
        }
        if ((v = map.get("disconnectable")) != null) {
            gPGraph.setDisconnectable(new Boolean(v.toString()));
        }
        if ((v = map.get("disconnectOnMove")) != null) {
            gPGraph.setDisconnectOnMove(new Boolean(v.toString()));
        }
        if ((v = map.get("doubleBuffered")) != null) {
            gPGraph.setDoubleBuffered(new Boolean(v.toString()));
        }
        if ((v = map.get("dragEnabled")) != null) {
            gPGraph.setDragEnabled(new Boolean(v.toString()));
        }
        if ((v = map.get("dropEnabled")) != null) {
            gPGraph.setDropEnabled(new Boolean(v.toString()));
        }
        if ((v = map.get("moveable")) != null) {
            gPGraph.setMoveable(new Boolean(v.toString()));
        }
        if ((v = map.get("sizeable")) != null) {
            gPGraph.setSizeable(new Boolean(v.toString()));
        }
        if ((v = map.get("selectNewCells")) != null) {
            gPGraph.setSelectNewCells(new Boolean(v.toString()));
        }
        if ((v = map.get("gridVisible")) != null) {
            gPGraph.setGridVisible(new Boolean(v.toString()));
        }
        if ((v = map.get("gridEnabled")) != null) {
            gPGraph.setGridEnabled(new Boolean(v.toString()));
        }
        if ((v = map.get("gridSize")) != null) {
            gPGraph.setGridSize(Integer.parseInt(v.toString()));
        }
        if ((v = map.get("gridMode")) != null) {
            gPGraph.setGridMode(Integer.parseInt(v.toString()));
        }
        if ((v = map.get("scale")) != null) {
            gPGraph.setScale(Double.parseDouble(v.toString()));
        }
        if ((v = map.get("antiAlias")) != null) {
            gPGraph.setAntiAliased(new Boolean(v.toString()));
        }
    }

    public static Map augmentAttrs(Map map) {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Map map2 = (Map)entry.getValue();
            Stack<Map> stack = new Stack<Map>();
            stack.add(map2);
            Object v = map2.get(PARENT);
            Object e = null;
            while (v != null) {
                e = map.get(v);
                stack.add((Map)e);
                v = ((Map)e).get(PARENT);
            }
            Hashtable hashtable2 = new Hashtable();
            while (!stack.isEmpty()) {
                hashtable2.putAll((Map)stack.pop());
            }
            hashtable2.remove(PARENT);
            Iterator iterator2 = hashtable2.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry = iterator2.next();
                if (entry.getValue() != EMPTY) continue;
                iterator2.remove();
            }
            hashtable.put(k, hashtable2);
        }
        return hashtable;
    }

    public static DefaultGraphCell parseCell(Node node, Hashtable hashtable, ConnectionSet connectionSet) {
        DefaultGraphCell defaultGraphCell = null;
        if (node.getNodeName().toLowerCase().equals("a")) {
            Node node2 = node.getAttributes().getNamedItem("id");
            Node node3 = node.getAttributes().getNamedItem("class");
            if (node2 != null && node3 != null) {
                Node node4 = node.getAttributes().getNamedItem("val");
                String string = "";
                if (node4 != null) {
                    string = objs.get(node4.getNodeValue());
                }
                if ((defaultGraphCell = DefaultGraphModelFileFormatXML.createCell(node3.getNodeValue(), string)) != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    hashtable.put(node2.getNodeValue(), defaultGraphCell);
                    DefaultGraphCell[] defaultGraphCellArray = DefaultGraphModelFileFormatXML.parseChildren(node, hashtable, connectionSet);
                    int n = 0;
                    while (n < defaultGraphCellArray.length) {
                        defaultGraphCell.add(defaultGraphCellArray[n]);
                        ++n;
                    }
                    Node node5 = node.getAttributes().getNamedItem("src");
                    Node node6 = node.getAttributes().getNamedItem("tgt");
                    if (node5 != null) {
                        object3 = new ConnectionID(defaultGraphCell, node5.getNodeValue(), true);
                        connectionSetIDs.add(object3);
                    }
                    if (node6 != null) {
                        object3 = new ConnectionID(defaultGraphCell, node6.getNodeValue(), false);
                        connectionSetIDs.add(object3);
                    }
                    object3 = node.getAttributes().getNamedItem("rect");
                    Rectangle rectangle = null;
                    if (object3 != null && (object2 = DefaultGraphModelFileFormatXML.decodeValue(class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = DefaultGraphModelFileFormatXML.class$("java.awt.Rectangle")) : class$java$awt$Rectangle, object3.getNodeValue())) instanceof Rectangle) {
                        rectangle = (Rectangle)object2;
                    }
                    object2 = node.getAttributes().getNamedItem("pts");
                    List list = null;
                    if (object2 != null && (object = DefaultGraphModelFileFormatXML.decodeValue(class$java$util$List == null ? (class$java$util$List = DefaultGraphModelFileFormatXML.class$("java.util.List")) : class$java$util$List, object2.getNodeValue())) instanceof List) {
                        list = (List)object;
                    }
                    object = node.getAttributes().getNamedItem("attr");
                    String string2 = null;
                    if (object != null) {
                        string2 = object.getNodeValue();
                    }
                    if (string2 != null) {
                        delayedAttributes.add(new DelayedAttributeID(defaultGraphCell, rectangle, list, string2));
                    }
                }
            }
        }
        return defaultGraphCell;
    }

    public static DefaultGraphCell[] parseChildren(Node node, Hashtable hashtable, ConnectionSet connectionSet) {
        Object object;
        LinkedList<DefaultGraphCell> linkedList = new LinkedList<DefaultGraphCell>();
        int n = 0;
        while (n < node.getChildNodes().getLength()) {
            object = node.getChildNodes().item(n);
            DefaultGraphCell defaultGraphCell = DefaultGraphModelFileFormatXML.parseCell((Node)object, hashtable, connectionSet);
            if (defaultGraphCell != null) {
                linkedList.add(defaultGraphCell);
            }
            ++n;
        }
        object = new DefaultGraphCell[linkedList.size()];
        linkedList.toArray((T[])object);
        return object;
    }

    public static Map parseAttrs(Node node) {
        Hashtable<String, Map> hashtable = new Hashtable<String, Map>();
        int n = 0;
        while (n < node.getChildNodes().getLength()) {
            Node node2 = node.getChildNodes().item(n);
            if (node2.getNodeName().toLowerCase().equals("map")) {
                Node node3 = node2.getAttributes().getNamedItem("id");
                Node node4 = node2.getAttributes().getNamedItem("pid");
                Map map = DefaultGraphModelFileFormatXML.decodeMap(node2, true, false);
                if (node3 != null && map.size() > 0) {
                    if (node4 != null) {
                        map.put(PARENT, node4.getNodeValue());
                    }
                    hashtable.put(node3.getNodeValue(), map);
                }
            }
            ++n;
        }
        return hashtable;
    }

    public static Map createDefaultAttributes() {
        Map map = GraphConstants.createMap();
        GraphConstants.setBorderColor(map, Color.black);
        return map;
    }

    public String toString(GPGraph gPGraph) {
        this.userObjectMap.clear();
        this.cellMap.clear();
        attrs.clear();
        String string = "<jgx-1.0>\n";
        GraphModel graphModel = gPGraph.getModel();
        string = string + "<model>\n";
        string = string + this.outputModel(graphModel, "\t", null);
        string = string + "</model>\n";
        string = string + "<attrs>\n";
        string = string + this.outputAttributes("\t");
        string = string + "</attrs>\n";
        string = string + "<user>\n";
        string = string + DefaultGraphModelFileFormatXML.encodeUserObjects("\t", this.userObjectMap);
        string = string + "</user>\n";
        string = string + "<view>\n";
        string = string + this.outputView(gPGraph, "\t");
        string = string + "</view>\n";
        string = string + "</jgx-1.0>\n";
        return string;
    }

    public String outputView(GPGraph gPGraph, String string) {
        String string2 = string + "<a key=\"editable\" val=\"" + gPGraph.isEditable() + "\"/>\n" + string + "<a key=\"bendable\" val=\"" + gPGraph.isBendable() + "\"/>\n" + string + "<a key=\"cloneable\" val=\"" + gPGraph.isCloneable() + "\"/>\n" + string + "<a key=\"connectable\" val=\"" + gPGraph.isConnectable() + "\"/>\n" + string + "<a key=\"disconnectable\" val=\"" + gPGraph.isDisconnectable() + "\"/>\n" + string + "<a key=\"disconnectOnMove\" val=\"" + gPGraph.isDisconnectOnMove() + "\"/>\n" + string + "<a key=\"doubleBuffered\" val=\"" + gPGraph.isDoubleBuffered() + "\"/>\n" + string + "<a key=\"dragEnabled\" val=\"" + gPGraph.isDragEnabled() + "\"/>\n" + string + "<a key=\"dropEnabled\" val=\"" + gPGraph.isDropEnabled() + "\"/>\n" + string + "<a key=\"moveable\" val=\"" + gPGraph.isMoveable() + "\"/>\n" + string + "<a key=\"sizeable\" val=\"" + gPGraph.isSizeable() + "\"/>\n" + string + "<a key=\"selectNewCells\" val=\"" + gPGraph.isSelectNewCells() + "\"/>\n" + string + "<a key=\"gridVisible\" val=\"" + gPGraph.isGridVisible() + "\"/>\n" + string + "<a key=\"gridEnabled\" val=\"" + gPGraph.isGridEnabled() + "\"/>\n" + string + "<a key=\"gridSize\" val=\"" + gPGraph.getGridSize() + "\"/>\n" + string + "<a key=\"gridMode\" val=\"" + gPGraph.getGridMode() + "\"/>\n" + string + "<a key=\"scale\" val=\"" + gPGraph.getScale() + "\"/>\n" + string + "<a key=\"antiAlias\" val=\"" + gPGraph.isAntiAliased() + "\"/>\n";
        return string2;
    }

    public String outputModel(GraphModel graphModel, String string, Object object) {
        String string2 = new String("");
        int n = object != null ? graphModel.getChildCount(object) : graphModel.getRootCount();
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            Object object3 = object2 = object != null ? graphModel.getChild(object, n2) : graphModel.getRootAt(n2);
            if (object2 != null) {
                string2 = string2 + this.outputCell(string, graphModel, object2);
            }
            ++n2;
        }
        return string2;
    }

    public String outputCell(String string, GraphModel graphModel, Object object) {
        String string2;
        Hashtable hashtable = new Hashtable(graphModel.getAttributes(object));
        Rectangle rectangle = (Rectangle)hashtable.remove("bounds");
        Object v = hashtable.remove("value");
        if (GraphConstants.getFont(hashtable).equals(GraphConstants.defaultFont)) {
            hashtable.remove("font");
        }
        Object object2 = graphModel.getSource(object);
        Object object3 = graphModel.getTarget(object);
        if (GraphConstants.getRouting(hashtable) != null) {
            hashtable.remove("points");
        }
        String string3 = "";
        String string4 = "";
        if (object2 != null) {
            string3 = " src=\"" + this.getID(object2) + "\"";
        }
        if (object2 != null) {
            string4 = " tgt=\"" + this.getID(object3) + "\"";
        }
        String string5 = "";
        String string6 = "";
        if (!(rectangle == null || graphModel.isEdge(object) || graphModel.isPort(object) || rectangle.equals(DefaultGraphCell.defaultBounds))) {
            string5 = " rect=\"" + DefaultGraphModelFileFormatXML.encodeValue(rectangle) + "\"";
        }
        List list = GraphConstants.getPoints(hashtable);
        hashtable.remove("points");
        String string7 = "";
        if (list != null && !list.equals(DefaultEdge.defaultPoints) && (string2 = DefaultGraphModelFileFormatXML.encodeValue(list)).length() > 0) {
            string7 = " pts=\"" + string2 + "\"";
        }
        if (v != null) {
            string6 = " val=\"" + this.getUserObjectID(v) + "\"";
        }
        string2 = "";
        if (hashtable.size() > 0) {
            string2 = " attr=\"" + this.attrCol.addMap(hashtable) + "\"";
        }
        String string8 = new String(string + "<a class=\"" + DefaultGraphModelFileFormatXML.getType(object) + "\" id=\"" + this.getID(object) + "\"" + string6 + string3 + string4 + string5 + string7 + string2);
        string8 = graphModel.getChildCount(object) > 0 ? string8 + ">\n" + this.outputModel(graphModel, string + "\t", object) + string + "</a>\n" : string8 + "/>\n";
        return string8;
    }

    public int getUserObjectID(Object object) {
        Integer n = (Integer)this.userObjectMap.get(object);
        if (n != null) {
            return n;
        }
        n = new Integer(this.userObjectMap.size() + 1);
        this.userObjectMap.put(object, n);
        return n;
    }

    public int getID(Object object) {
        Integer n = (Integer)this.cellMap.get(object);
        if (n != null) {
            return n;
        }
        n = new Integer(this.cellMap.size() + 1);
        this.cellMap.put(object, n);
        return n;
    }

    public String outputAttributes(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(PARENT);
        hashSet.add("bounds");
        hashSet.add("points");
        String string2 = new String();
        int n = 0;
        while (n < this.attrCol.maps.size()) {
            Map map = (Map)this.attrCol.maps.get(n);
            Object v = map.get(PARENT);
            String string3 = "";
            if (v != null) {
                string3 = " pid=\"" + this.attrCol.maps.indexOf(v) + "\"";
            }
            string2 = string2 + string + "<map id=\"" + n + "\"" + string3 + ">\n";
            string2 = string2 + DefaultGraphModelFileFormatXML.encodeMap(string + "\t", map, false, hashSet, false);
            string2 = string2 + string + "</map>\n";
            ++n;
        }
        return string2;
    }

    public static String encodeMap(String string, Map map, boolean bl, Set set, boolean bl2) {
        String string2 = new String("");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object object = entry.getKey();
            if (set != null && set.contains(object)) continue;
            Object object2 = entry.getValue();
            if (bl) {
                Object k = object;
                object = object2;
                object2 = k;
            }
            if (bl2) {
                try {
                    object = URLEncoder.encode(object.toString(), "UTF-8");
                    object2 = URLEncoder.encode(DefaultGraphModelFileFormatXML.encodeValue(object2), "UTF-8");
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            string2 = string2 + string + "<a key=\"" + DefaultGraphModelFileFormatXML.encodeKey(object.toString()) + "\" val=\"" + DefaultGraphModelFileFormatXML.encodeValue(object2) + "\"/>\n";
        }
        return string2;
    }

    public static String encodeUserObjects(String string, Map map) {
        String string2 = new String("");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            Object object = entry.getKey();
            if (object instanceof GPUserObject) {
                string2 = string2 + string + "<a key=\"" + DefaultGraphModelFileFormatXML.encodeKey(v.toString()) + "\"";
                Map map2 = ((GPUserObject)object).getProperties();
                string2 = string2 + ">\n" + DefaultGraphModelFileFormatXML.encodeMap(string + "\t", map2, false, null, true) + string + "</a>\n";
                continue;
            }
            try {
                object = URLEncoder.encode(DefaultGraphModelFileFormatXML.encodeValue(object), "UTF-8");
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            string2 = string2 + string + "<a key=\"" + DefaultGraphModelFileFormatXML.encodeKey(v.toString()) + "\" val=\"" + object + "\"/>\n";
        }
        return string2;
    }

    public static String encodeKey(String string) {
        return string;
    }

    public static String encodeValue(Object object) {
        String string = "";
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            string = rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
        } else if (object instanceof List) {
            List list = (List)object;
            String string2 = "";
            int n = 0;
            while (n < list.size()) {
                if (list.get(n) instanceof Point) {
                    Point point = (Point)list.get(n);
                    string2 = string2 + point.x + "," + point.y + ",";
                }
                ++n;
            }
            string = string2.length() > 0 ? string2.substring(0, string2.length() - 1) : string2;
        } else if (object instanceof Font) {
            Font font = (Font)object;
            string = font.getName() + "," + font.getSize() + "," + font.getStyle();
        } else if (object instanceof Color) {
            Color color = (Color)object;
            string = Integer.toString(color.getRed()) + "," + Integer.toString(color.getGreen()) + "," + Integer.toString(color.getBlue());
        } else if (object instanceof Point) {
            Point point = (Point)object;
            string = point.x + "," + point.y;
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            String string3 = "";
            int n = 0;
            while (n < fArray.length) {
                string3 = string3 + Float.toString(fArray[n]) + ",";
                ++n;
            }
            string = string3.substring(0, string3.length() - 1);
        } else if (object instanceof Border) {
            if (object instanceof LineBorder) {
                LineBorder lineBorder = (LineBorder)object;
                string = "L," + lineBorder.getLineColor().getRGB() + "," + lineBorder.getThickness();
            } else if (object instanceof BevelBorder) {
                BevelBorder bevelBorder = (BevelBorder)object;
                string = "B," + bevelBorder.getBevelType();
            }
        } else if (object instanceof ImageIconBean) {
            ImageIconBean imageIconBean = (ImageIconBean)object;
            string = imageIconBean.getFileName();
        } else if (object instanceof Edge.Routing) {
            if (object instanceof DefaultEdge.DefaultRouting) {
                string = "simple";
            }
        } else if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public static Map decodeMap(Node node, boolean bl, boolean bl2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < node.getChildNodes().getLength()) {
            Node node2 = node.getChildNodes().item(n);
            if (node2.getNodeName().toLowerCase().equals("a")) {
                Node node3 = node2.getAttributes().getNamedItem("key");
                Node node4 = node2.getAttributes().getNamedItem("val");
                if (node3 != null && node4 != null) {
                    String string = node3.getNodeValue().toString();
                    Object object = node4.getNodeValue().toString();
                    if (bl) {
                        int n2 = -1;
                        int n3 = 0;
                        while (n3 < knownKeys.length) {
                            if (string.equals(knownKeys[n3])) {
                                n2 = n3;
                            }
                            ++n3;
                        }
                        if (n2 != -1) {
                            object = DefaultGraphModelFileFormatXML.decodeValue(keyTypes[n2], object.toString());
                        }
                    } else if (bl2) {
                        try {
                            string = URLDecoder.decode(string.toString(), "UTF-8");
                            object = URLDecoder.decode(object.toString(), "UTF-8");
                        }
                        catch (Exception exception) {
                            System.err.println(exception.getMessage());
                        }
                    }
                    if (object != null) {
                        hashtable.put(string, (String)object);
                    }
                }
            }
            ++n;
        }
        return hashtable;
    }

    public static Map decodeUserObjects(Node node) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = 0;
        while (n < node.getChildNodes().getLength()) {
            Node node2 = node.getChildNodes().item(n);
            if (node2.getNodeName().toLowerCase().equals("a")) {
                Node node3 = node2.getAttributes().getNamedItem("key");
                Node node4 = node2.getAttributes().getNamedItem("val");
                if (node3 != null) {
                    Object object;
                    String string = node3.getNodeValue().toString();
                    if (node4 != null) {
                        object = node4.getNodeValue().toString();
                        if (object != null) {
                            try {
                                object = URLDecoder.decode(object.toString(), "UTF-8");
                            }
                            catch (Exception exception) {
                                System.err.println(exception.getMessage());
                            }
                            hashtable.put(string, object);
                        }
                    } else {
                        object = DefaultGraphModelFileFormatXML.decodeMap(node2, false, true);
                        if (object != null) {
                            hashtable.put(string, object);
                        }
                    }
                }
            }
            ++n;
        }
        return hashtable;
    }

    public static String[] tokenize(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static Object decodeValue(Class clazz, String string) {
        if (clazz != (class$java$lang$String == null ? (class$java$lang$String = DefaultGraphModelFileFormatXML.class$("java.lang.String")) : class$java$lang$String) && clazz != (class$java$lang$Object == null ? (class$java$lang$Object = DefaultGraphModelFileFormatXML.class$("java.lang.Object")) : class$java$lang$Object) && (string == null || string.equals(""))) {
            return EMPTY;
        }
        if (clazz == (class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = DefaultGraphModelFileFormatXML.class$("java.awt.Rectangle")) : class$java$awt$Rectangle)) {
            String[] stringArray = DefaultGraphModelFileFormatXML.tokenize(string, ",");
            if (stringArray.length == 4) {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                int n4 = Integer.parseInt(stringArray[3]);
                return new Rectangle(n, n2, n3, n4);
            }
        } else {
            if (clazz == (class$java$util$List == null ? (class$java$util$List = DefaultGraphModelFileFormatXML.class$("java.util.List")) : class$java$util$List)) {
                LinkedList<Point> linkedList = new LinkedList<Point>();
                String[] stringArray = DefaultGraphModelFileFormatXML.tokenize(string, ",");
                int n = 0;
                while (n < stringArray.length) {
                    int n5 = Integer.parseInt(stringArray[n]);
                    int n6 = Integer.parseInt(stringArray[n + 1]);
                    linkedList.add(new Point(n5, n6));
                    n += 2;
                }
                return linkedList;
            }
            if (clazz == (class$java$awt$Font == null ? (class$java$awt$Font = DefaultGraphModelFileFormatXML.class$("java.awt.Font")) : class$java$awt$Font)) {
                String[] stringArray = DefaultGraphModelFileFormatXML.tokenize(string, ",");
                if (stringArray.length == 3) {
                    String string2 = stringArray[0];
                    int n = Integer.parseInt(stringArray[1]);
                    int n7 = Integer.parseInt(stringArray[2]);
                    return new Font(string2, n7, n);
                }
            } else {
                if (clazz == (class$java$awt$Color == null ? (class$java$awt$Color = DefaultGraphModelFileFormatXML.class$("java.awt.Color")) : class$java$awt$Color)) {
                    String[] stringArray = DefaultGraphModelFileFormatXML.tokenize(string, ",");
                    if (stringArray.length == 3) {
                        int n = Integer.parseInt(stringArray[0]);
                        int n8 = Integer.parseInt(stringArray[1]);
                        int n9 = Integer.parseInt(stringArray[2]);
                        return new Color(n, n8, n9);
                    }
                    return new Color(Integer.parseInt(string));
                }
                if (clazz == (class$java$awt$Point == null ? (class$java$awt$Point = DefaultGraphModelFileFormatXML.class$("java.awt.Point")) : class$java$awt$Point)) {
                    String[] stringArray = DefaultGraphModelFileFormatXML.tokenize(string, ",");
                    if (stringArray.length == 2) {
                        int n = Integer.parseInt(stringArray[0]);
                        int n10 = Integer.parseInt(stringArray[1]);
                        return new Point(n, n10);
                    }
                } else {
                    if (clazz == (array$F == null ? (array$F = DefaultGraphModelFileFormatXML.class$("[F")) : array$F)) {
                        String[] stringArray = DefaultGraphModelFileFormatXML.tokenize(string, ",");
                        float[] fArray = new float[stringArray.length];
                        int n = 0;
                        while (n < stringArray.length) {
                            fArray[n] = Float.parseFloat(stringArray[n]);
                            ++n;
                        }
                        return fArray;
                    }
                    if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultGraphModelFileFormatXML.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        return new Integer(string);
                    }
                    if (clazz == (class$javax$swing$border$Border == null ? (class$javax$swing$border$Border = DefaultGraphModelFileFormatXML.class$("javax.swing.border.Border")) : class$javax$swing$border$Border)) {
                        String[] stringArray = DefaultGraphModelFileFormatXML.tokenize(string, ",");
                        if (stringArray[0].equals("L")) {
                            Color color = new Color(Integer.parseInt(stringArray[1]));
                            int n = Integer.parseInt(stringArray[2]);
                            return BorderFactory.createLineBorder(color, n);
                        }
                        if (stringArray[0].equals("B")) {
                            int n = Integer.parseInt(stringArray[1]);
                            return BorderFactory.createBevelBorder(n);
                        }
                        return BorderFactory.createLineBorder(Color.black, 1);
                    }
                    if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultGraphModelFileFormatXML.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                        return new Boolean(string);
                    }
                    if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = DefaultGraphModelFileFormatXML.class$("java.lang.Float")) : class$java$lang$Float)) {
                        return new Float(string);
                    }
                    if (clazz == (class$javax$swing$Icon == null ? (class$javax$swing$Icon = DefaultGraphModelFileFormatXML.class$("javax.swing.Icon")) : class$javax$swing$Icon)) {
                        try {
                            return new ImageIconBean(new URL(string));
                        }
                        catch (Exception exception) {
                            System.err.println("Invalid URL: " + string);
                            return new ImageIconBean(string);
                        }
                    }
                    if (clazz == (class$org$jgraph$graph$Edge$Routing == null ? (class$org$jgraph$graph$Edge$Routing = DefaultGraphModelFileFormatXML.class$("org.jgraph.graph.Edge$Routing")) : class$org$jgraph$graph$Edge$Routing) && string.equals("simple")) {
                        return GraphConstants.ROUTING_SIMPLE;
                    }
                }
            }
        }
        return string;
    }

    public static DefaultGraphCell createCell(String string, Object object) {
        if (object instanceof Map) {
            object = new GPUserObject((Map)object);
        }
        if (string.equals("rect")) {
            return new DefaultGraphCell(object);
        }
        if (string.equals("text")) {
            return new TextCell(object);
        }
        if (string.equals("ellipse")) {
            return new EllipseCell(object);
        }
        if (string.equals("image")) {
            return new ImageCell(object);
        }
        if (string.equals("port")) {
            return new DefaultPort(object);
        }
        if (string.equals("edge")) {
            return new DefaultEdge(object);
        }
        return null;
    }

    public static String getType(Object object) {
        if (object instanceof DefaultPort) {
            return "port";
        }
        if (object instanceof TextCell) {
            return "text";
        }
        if (object instanceof EllipseCell) {
            return "ellipse";
        }
        if (object instanceof ImageCell) {
            return "image";
        }
        if (object instanceof DefaultEdge) {
            return "edge";
        }
        return "rect";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AttributeCollection {
        public List maps = new LinkedList();

        public int addMap(Map map) {
            Map map2;
            Iterator iterator = this.maps.iterator();
            Map map3 = map2 = new Hashtable(map);
            while (iterator.hasNext()) {
                Map map4 = (Map)iterator.next();
                Map map5 = this.diffMap(map4, map);
                if (map5.size() >= map2.size()) continue;
                map3 = map4;
                map2 = map5;
            }
            if (map2.size() == 0 && map3 != map2) {
                return this.maps.indexOf(map3);
            }
            if (map3 != map2) {
                map2.put(PARENT, map3);
            }
            this.maps.add(map2);
            return this.maps.indexOf(map2);
        }

        public void clear() {
            this.maps.clear();
        }

        public Map diffMap(Map hashtable, Map map) {
            Map.Entry entry;
            Stack stack = new Stack();
            stack.add(hashtable);
            Object v = hashtable.get(PARENT);
            while (v instanceof Map) {
                stack.add(v);
                v = ((Map)v).get(PARENT);
            }
            hashtable = new Hashtable();
            while (!stack.isEmpty()) {
                hashtable.putAll((Map)stack.pop());
            }
            Hashtable hashtable2 = new Hashtable();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                Object k = entry.getKey();
                Object v2 = hashtable.remove(k);
                if (k == PARENT) continue;
                Object v3 = entry.getValue();
                if (v2 != null && v2.equals(v3)) continue;
                hashtable2.put(k, v3);
            }
            iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (hashtable.get(entry).equals("")) continue;
                hashtable2.put(entry, "");
            }
            hashtable2.remove(PARENT);
            return hashtable2;
        }
    }

    public static class ConnectionID {
        protected Object cell;
        protected String targetID;
        protected boolean source;

        public ConnectionID(Object object, String string, boolean bl) {
            this.cell = object;
            this.targetID = string;
            this.source = bl;
        }

        public Object getCell() {
            return this.cell;
        }

        public boolean isSource() {
            return this.source;
        }

        public String getTargetID() {
            return this.targetID;
        }

        public void setCell(Object object) {
            this.cell = object;
        }

        public void setSource(boolean bl) {
            this.source = bl;
        }

        public void setTargetID(String string) {
            this.targetID = string;
        }
    }

    public static class DelayedAttributeID {
        protected Object cell;
        protected Rectangle bounds;
        protected List points;
        protected String mapID;

        public DelayedAttributeID(Object object, Rectangle rectangle, List list, String string) {
            this.cell = object;
            this.bounds = rectangle;
            this.points = list;
            this.mapID = string;
        }

        public Object getCell() {
            return this.cell;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public String getMapID() {
            return this.mapID;
        }

        public List getPoints() {
            return this.points;
        }

        public void setBounds(Rectangle rectangle) {
            this.bounds = rectangle;
        }

        public void setCell(Object object) {
            this.cell = object;
        }

        public void setMapID(String string) {
            this.mapID = string;
        }

        public void setPoints(List list) {
            this.points = list;
        }
    }
}

