# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

"""
Moovida Command Line Options and Arguments parsing
"""

__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

import platform
import sys
from elisa.core import __version__

from twisted.python import usage

class Options(usage.Options):
    """
    Application's command-line options definitions
    """

    optFlags = [['version', '', 'Show elisa version.'],
                ['twisted-version', '', 'Show twisted version.'],
                ['tracebacks', 't', 'Display tracebacks.'],
                ['log', 'l', 'Log output in moovida.log files.'],
                ['shell', '', 'Open an interactive shell in the terminal.'],
                ['headless', '', 'Start in headless mode.'],
                ['force-startup', '', 'Start even another instance is running.'],
                ['fullscreen', 'f', 'Start fullscreen.'],
                ['unfullscreen', 'u', 'Start unfullscreen.'],
                ['nosplash', 'n', 'Do not show the splashscreen.'],
               ]

    optParameters = [['import', 'i', None, 'The script to import, used by \
                                            windows only.'],
                     ['config-file', 'c', None, 'The configuration file.'],
                     ['rss', None, None, 'A rss link']
                    ]


    tracebacks = False

    def parseArgs(self, *args):
        self['files'] = args

    def opt_twisted_version(self):
        return usage.Options.opt_version(self)

    def opt_version(self):
        print 'Moovida version %s' % __version__
        sys.exit(0)
        
    def opt_import(self):
        if platform.system() != 'Windows':
            print "-i (--import) option works only under windows"
            sys.exit(0)
