# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2008-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

"""
Default configuration constants.
"""

import os.path
from elisa.core.utils import locale_helper

# should always be a valid unicode string. On windows the home
# directory can contain accentuated characters.
CONFIG_DIR = os.path.join(os.path.expanduser('~'),
                          ".moovida").decode(locale_helper.system_encoding())

# We add to the configuration file name the version number in order to bypass
# the configuration upgrade system. Direct consequences:
# - custom user configuration is lost between releases
# - prevents configuration upgrade bugs
# - avoid configuration upgrade work
#version_string = "_".join([str(n) for n in version_info])
#CONFIG_FILE = "elisa_%s.conf" % version_string

#FIXME don't we want to be able to upgrade from old confs?
CONFIG_FILE = "moovida.conf"


"""DEPRECATED. This constant is kept for backward compatibility reasons.
Please use the L{elisa.core.utils.caching} module instead."""
# should always be a valid unicode string
PICTURES_CACHE = os.path.join(CONFIG_DIR, u'pictures_cache')

DEFAULT_CONFIG = """\
[general]
version = '%(version)s'
install_date = '%(install_date)s'
frontends = ['frontend1']
disabled_plugins = []
# database connection string. see https://storm.canonical.com/Manual
database = "%(database_uri)s"
# Set to 1 for advanced, unsupported (possibly unstable, you've been warned!)
# features.
power_user = '0'

[frontend1]
frontend = 'pigment.pigment_frontend:PigmentFrontend'
theme = 'elisa.plugins.poblesec'
controller_path = '/poblesec'

[directories]
video = ['*default*']
pictures = ['*default*']
music = ['*default*']
"""
