.\"	$OpenBSD: ws.man,v 1.4 2007/08/25 10:24:15 mbalmer Exp $
.\"
.\" Copyright (c) 2005 Matthieu Herrb
.\"
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH WS __drivermansuffix__ __vendorversion__
.SH NAME 
WS \- wscons pointer input driver for *BSD
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "    Identifier \*q" name \*q
.B  "    Driver \*qws\*q"
.BI "    Option \*qButtons\*q \*q" integer \*q
.BI "    Option \*qDebugLevel\*q \*q" integer \*q
.BI "    Option \*qDevice\*q  \*q" path \*q
.BI "    Option \*qMinX\*q \*q" integer \*q
.BI "    Option \*qMaxX\*q \*q" integer \*q
.BI "    Option \*qMinY\*q \*q" integer \*q
.BI "    Option \*qMaxY\*q \*q" integer \*q
.BI "    Option \*qRotate\*q \*q" string \*q
.BI "    Option \*qSwapXY\*q \*q" boolean \*q
.BI "    Option \*qZAxisMapping\*q \*q" "N1 N2" \*q
.BI "    Option \*qWAxisMapping\*q \*q" "N1 N2" \*q
.B EndSection
.fi
.SH DESCRIPTION
.B ws
is an XFree86/X.Org input driver for pointer devices (mouse, tablet,
touchscreen,...) driven by the wscons console driver on
OpenBSD.
.SH "SUPPORTED HARDWARE"
This driver supports zts(4), the touchscreen of Zaurus machines, and
uts(4), USB touchscreens.
.SH "CONFIGURATION DETAILS"
Please refer to xorg.conf(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.
This section only covers configuration details specific to this driver.
.PP
.TP 4
.BI "Option \*qButtons\*q \*q" integer \*q
Specifies the number of mouse buttons.
In cases where the number of buttons cannot be auto-detected, the
default value is 3.
.TP 4
.BI "Option \*qDebugLevel\*q \*q" integer \*q
This option sets the verbosity level of the driver.
It defaults to 0, which means no extra debug output.
.TP 4
.BI "Option \*qDevice\*q \*q" path \*q
sets the path to the special file used by the device, ususally
.I /dev/wsmouse .
This option is mandatory.
.TP 4
.BI "Option \*qMinX\*q \*q" integer \*q
.TP 4
.BI "Option \*qMaxX\*q \*q" integer \*q
.TP 4
.BI "Option \*qMinY\*q \*q" integer \*q
.TP 4
.BI "Option \*qMaxY\*q \*q" integer \*q
These options represent the coordinate space returned by the device.
They default to the screen dimensions, since the calibration is handled in
the kernel by the zts(4) driver and the ztsscale(8) utility.
.TP 4
.B "Option \*qRotate\*q \*qCW\*q"
.TP 4
.B "Option \*qRotate\*q \*qCCW\*q"
.TP 4
.B "Option \*qRotate\*q \*qUD\*q"
These options rotate the screen coordinates returned by the driver
clockwise, counter-clockwise, or upside-down respectively.
.TP 4
.BI "Option \*qSwapXY\*q \*q" boolean \*q
swaps the X and Y axis of the input device if set. Default: false.
.TP 4
.B Option \fI"ZAxisMapping"\fP \fI"N1 N2"\fP
Set the mapping for the Z axis (wheel) motion to buttons. Button
number
.I N1
is mapped to the negative Z axis motion and button
.I N2
is mapped to the positive Z axis motion.
Default: no mapping.
.B Option \fI"WAxisMapping"\fP \fI"N1 N2"\fP
Set the mapping for the W axis (horizontal wheel) motion to buttons. Button
number
.I N1
is mapped to the negative W axis motion and button
.I N2
is mapped to the positive W axis motion.
Default: no mapping.
.SH "SEE ALSO"
Xorg(1), xorg.conf(__filemansuffix__), uts(4), zts(4), sysctl(8), xtsscale(8), ztsscale(8).
