require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&VR_PAR0)) {
    sub VR_PAR0 () {	0x;}
}
unless(defined(&VR_PAR1)) {
    sub VR_PAR1 () {	0x4;}
}
unless(defined(&VR_RXCFG)) {
    sub VR_RXCFG () {	0x6;}
}
unless(defined(&VR_TXCFG)) {
    sub VR_TXCFG () {	0x7;}
}
unless(defined(&VR_COMMAND)) {
    sub VR_COMMAND () {	0x8;}
}
unless(defined(&VR_TQWK)) {
    sub VR_TQWK () {	0xa;}
}
unless(defined(&VR_ISR)) {
    sub VR_ISR () {	0xc;}
}
unless(defined(&VR_IMR)) {
    sub VR_IMR () {	0xe;}
}
unless(defined(&VR_MAR0)) {
    sub VR_MAR0 () {	0x10;}
}
unless(defined(&VR_MAR1)) {
    sub VR_MAR1 () {	0x14;}
}
unless(defined(&VR_RXADDR)) {
    sub VR_RXADDR () {	0x18;}
}
unless(defined(&VR_TXADDR)) {
    sub VR_TXADDR () {	0x1c;}
}
unless(defined(&VR_CURRXDESC0)) {
    sub VR_CURRXDESC0 () {	0x20;}
}
unless(defined(&VR_CURRXDESC1)) {
    sub VR_CURRXDESC1 () {	0x24;}
}
unless(defined(&VR_CURRXDESC2)) {
    sub VR_CURRXDESC2 () {	0x28;}
}
unless(defined(&VR_CURRXDESC3)) {
    sub VR_CURRXDESC3 () {	0x2c;}
}
unless(defined(&VR_NEXTRXDESC0)) {
    sub VR_NEXTRXDESC0 () {	0x30;}
}
unless(defined(&VR_NEXTRXDESC1)) {
    sub VR_NEXTRXDESC1 () {	0x34;}
}
unless(defined(&VR_NEXTRXDESC2)) {
    sub VR_NEXTRXDESC2 () {	0x38;}
}
unless(defined(&VR_NEXTRXDESC3)) {
    sub VR_NEXTRXDESC3 () {	0x3c;}
}
unless(defined(&VR_CURTXDESC0)) {
    sub VR_CURTXDESC0 () {	0x40;}
}
unless(defined(&VR_CURTXDESC1)) {
    sub VR_CURTXDESC1 () {	0x44;}
}
unless(defined(&VR_CURTXDESC2)) {
    sub VR_CURTXDESC2 () {	0x48;}
}
unless(defined(&VR_CURTXDESC3)) {
    sub VR_CURTXDESC3 () {	0x4c;}
}
unless(defined(&VR_NEXTTXDESC0)) {
    sub VR_NEXTTXDESC0 () {	0x50;}
}
unless(defined(&VR_NEXTTXDESC1)) {
    sub VR_NEXTTXDESC1 () {	0x54;}
}
unless(defined(&VR_NEXTTXDESC2)) {
    sub VR_NEXTTXDESC2 () {	0x58;}
}
unless(defined(&VR_NEXTTXDESC3)) {
    sub VR_NEXTTXDESC3 () {	0x5c;}
}
unless(defined(&VR_CURRXDMA)) {
    sub VR_CURRXDMA () {	0x60;}
}
unless(defined(&VR_CURTXDMA)) {
    sub VR_CURTXDMA () {	0x64;}
}
unless(defined(&VR_TALLYCNT)) {
    sub VR_TALLYCNT () {	0x68;}
}
unless(defined(&VR_PHYADDR)) {
    sub VR_PHYADDR () {	0x6c;}
}
unless(defined(&VR_MIISTAT)) {
    sub VR_MIISTAT () {	0x6d;}
}
unless(defined(&VR_BCR0)) {
    sub VR_BCR0 () {	0x6e;}
}
unless(defined(&VR_BCR1)) {
    sub VR_BCR1 () {	0x6f;}
}
unless(defined(&VR_MIICMD)) {
    sub VR_MIICMD () {	0x70;}
}
unless(defined(&VR_MIIADDR)) {
    sub VR_MIIADDR () {	0x71;}
}
unless(defined(&VR_MIIDATA)) {
    sub VR_MIIDATA () {	0x72;}
}
unless(defined(&VR_EECSR)) {
    sub VR_EECSR () {	0x74;}
}
unless(defined(&VR_TEST)) {
    sub VR_TEST () {	0x75;}
}
unless(defined(&VR_GPIO)) {
    sub VR_GPIO () {	0x76;}
}
unless(defined(&VR_CONFIG)) {
    sub VR_CONFIG () {	0x78;}
}
unless(defined(&VR_MPA_CNT)) {
    sub VR_MPA_CNT () {	0x7c;}
}
unless(defined(&VR_CRC_CNT)) {
    sub VR_CRC_CNT () {	0x7e;}
}
unless(defined(&VR_STICKHW)) {
    sub VR_STICKHW () {	0x83;}
}
unless(defined(&VR_MISC_CR1)) {
    sub VR_MISC_CR1 () {	0x81;}
}
unless(defined(&VR_MISCCR1_FORSRST)) {
    sub VR_MISCCR1_FORSRST () {	0x40;}
}
unless(defined(&VR_RXCFG_RX_ERRPKTS)) {
    sub VR_RXCFG_RX_ERRPKTS () {	0x1;}
}
unless(defined(&VR_RXCFG_RX_RUNT)) {
    sub VR_RXCFG_RX_RUNT () {	0x2;}
}
unless(defined(&VR_RXCFG_RX_MULTI)) {
    sub VR_RXCFG_RX_MULTI () {	0x4;}
}
unless(defined(&VR_RXCFG_RX_BROAD)) {
    sub VR_RXCFG_RX_BROAD () {	0x8;}
}
unless(defined(&VR_RXCFG_RX_PROMISC)) {
    sub VR_RXCFG_RX_PROMISC () {	0x10;}
}
unless(defined(&VR_RXCFG_RX_THRESH)) {
    sub VR_RXCFG_RX_THRESH () {	0xe0;}
}
unless(defined(&VR_RXTHRESH_32BYTES)) {
    sub VR_RXTHRESH_32BYTES () {	0x;}
}
unless(defined(&VR_RXTHRESH_64BYTES)) {
    sub VR_RXTHRESH_64BYTES () {	0x20;}
}
unless(defined(&VR_RXTHRESH_128BYTES)) {
    sub VR_RXTHRESH_128BYTES () {	0x40;}
}
unless(defined(&VR_RXTHRESH_256BYTES)) {
    sub VR_RXTHRESH_256BYTES () {	0x60;}
}
unless(defined(&VR_RXTHRESH_512BYTES)) {
    sub VR_RXTHRESH_512BYTES () {	0x80;}
}
unless(defined(&VR_RXTHRESH_768BYTES)) {
    sub VR_RXTHRESH_768BYTES () {	0xa0;}
}
unless(defined(&VR_RXTHRESH_1024BYTES)) {
    sub VR_RXTHRESH_1024BYTES () {	0xc0;}
}
unless(defined(&VR_RXTHRESH_STORENFWD)) {
    sub VR_RXTHRESH_STORENFWD () {	0xe0;}
}
unless(defined(&VR_TXCFG_TXTAGEN)) {
    sub VR_TXCFG_TXTAGEN () {	0x1;}
}
unless(defined(&VR_TXCFG_LOOPBKMODE)) {
    sub VR_TXCFG_LOOPBKMODE () {	0x6;}
}
unless(defined(&VR_TXCFG_BACKOFF)) {
    sub VR_TXCFG_BACKOFF () {	0x8;}
}
unless(defined(&VR_TXCFG_TX_THRESH)) {
    sub VR_TXCFG_TX_THRESH () {	0xe0;}
}
unless(defined(&VR_TXTHRESH_32BYTES)) {
    sub VR_TXTHRESH_32BYTES () {	0x;}
}
unless(defined(&VR_TXTHRESH_64BYTES)) {
    sub VR_TXTHRESH_64BYTES () {	0x20;}
}
unless(defined(&VR_TXTHRESH_128BYTES)) {
    sub VR_TXTHRESH_128BYTES () {	0x40;}
}
unless(defined(&VR_TXTHRESH_256BYTES)) {
    sub VR_TXTHRESH_256BYTES () {	0x60;}
}
unless(defined(&VR_TXTHRESH_512BYTES)) {
    sub VR_TXTHRESH_512BYTES () {	0x80;}
}
unless(defined(&VR_TXTHRESH_768BYTES)) {
    sub VR_TXTHRESH_768BYTES () {	0xa0;}
}
unless(defined(&VR_TXTHRESH_1024BYTES)) {
    sub VR_TXTHRESH_1024BYTES () {	0xc0;}
}
unless(defined(&VR_TXTHRESH_STORENFWD)) {
    sub VR_TXTHRESH_STORENFWD () {	0xe0;}
}
unless(defined(&VR_CMD_INIT)) {
    sub VR_CMD_INIT () {	0x1;}
}
unless(defined(&VR_CMD_START)) {
    sub VR_CMD_START () {	0x2;}
}
unless(defined(&VR_CMD_STOP)) {
    sub VR_CMD_STOP () {	0x4;}
}
unless(defined(&VR_CMD_RX_ON)) {
    sub VR_CMD_RX_ON () {	0x8;}
}
unless(defined(&VR_CMD_TX_ON)) {
    sub VR_CMD_TX_ON () {	0x10;}
}
unless(defined(&VR_CMD_TX_GO)) {
    sub VR_CMD_TX_GO () {	0x20;}
}
unless(defined(&VR_CMD_RX_GO)) {
    sub VR_CMD_RX_GO () {	0x40;}
}
unless(defined(&VR_CMD_RSVD)) {
    sub VR_CMD_RSVD () {	0x80;}
}
unless(defined(&VR_CMD_RX_EARLY)) {
    sub VR_CMD_RX_EARLY () {	0x100;}
}
unless(defined(&VR_CMD_TX_EARLY)) {
    sub VR_CMD_TX_EARLY () {	0x200;}
}
unless(defined(&VR_CMD_FULLDUPLEX)) {
    sub VR_CMD_FULLDUPLEX () {	0x400;}
}
unless(defined(&VR_CMD_TX_NOPOLL)) {
    sub VR_CMD_TX_NOPOLL () {	0x800;}
}
unless(defined(&VR_CMD_RESET)) {
    sub VR_CMD_RESET () {	0x8000;}
}
unless(defined(&VR_ISR_RX_OK)) {
    sub VR_ISR_RX_OK () {	0x1;}
}
unless(defined(&VR_ISR_TX_OK)) {
    sub VR_ISR_TX_OK () {	0x2;}
}
unless(defined(&VR_ISR_RX_ERR)) {
    sub VR_ISR_RX_ERR () {	0x4;}
}
unless(defined(&VR_ISR_TX_ABRT)) {
    sub VR_ISR_TX_ABRT () {	0x8;}
}
unless(defined(&VR_ISR_TX_UNDERRUN)) {
    sub VR_ISR_TX_UNDERRUN () {	0x10;}
}
unless(defined(&VR_ISR_RX_NOBUF)) {
    sub VR_ISR_RX_NOBUF () {	0x20;}
}
unless(defined(&VR_ISR_BUSERR)) {
    sub VR_ISR_BUSERR () {	0x40;}
}
unless(defined(&VR_ISR_STATSOFLOW)) {
    sub VR_ISR_STATSOFLOW () {	0x80;}
}
unless(defined(&VR_ISR_RX_EARLY)) {
    sub VR_ISR_RX_EARLY () {	0x100;}
}
unless(defined(&VR_ISR_LINKSTAT)) {
    sub VR_ISR_LINKSTAT () {	0x200;}
}
unless(defined(&VR_ISR_ETI)) {
    sub VR_ISR_ETI () {	0x200;}
}
unless(defined(&VR_ISR_UDFI)) {
    sub VR_ISR_UDFI () {	0x200;}
}
unless(defined(&VR_ISR_RX_OFLOW)) {
    sub VR_ISR_RX_OFLOW () {	0x400;}
}
unless(defined(&VR_ISR_RX_DROPPED)) {
    sub VR_ISR_RX_DROPPED () {	0x800;}
}
unless(defined(&VR_ISR_RX_NOBUF2)) {
    sub VR_ISR_RX_NOBUF2 () {	0x1000;}
}
unless(defined(&VR_ISR_TX_ABRT2)) {
    sub VR_ISR_TX_ABRT2 () {	0x2000;}
}
unless(defined(&VR_ISR_LINKSTAT2)) {
    sub VR_ISR_LINKSTAT2 () {	0x4000;}
}
unless(defined(&VR_ISR_MAGICPACKET)) {
    sub VR_ISR_MAGICPACKET () {	0x8000;}
}
unless(defined(&VR_IMR_RX_OK)) {
    sub VR_IMR_RX_OK () {	0x1;}
}
unless(defined(&VR_IMR_TX_OK)) {
    sub VR_IMR_TX_OK () {	0x2;}
}
unless(defined(&VR_IMR_RX_ERR)) {
    sub VR_IMR_RX_ERR () {	0x4;}
}
unless(defined(&VR_IMR_TX_ABRT)) {
    sub VR_IMR_TX_ABRT () {	0x8;}
}
unless(defined(&VR_IMR_TX_UNDERRUN)) {
    sub VR_IMR_TX_UNDERRUN () {	0x10;}
}
unless(defined(&VR_IMR_RX_NOBUF)) {
    sub VR_IMR_RX_NOBUF () {	0x20;}
}
unless(defined(&VR_IMR_BUSERR)) {
    sub VR_IMR_BUSERR () {	0x40;}
}
unless(defined(&VR_IMR_STATSOFLOW)) {
    sub VR_IMR_STATSOFLOW () {	0x80;}
}
unless(defined(&VR_IMR_RX_EARLY)) {
    sub VR_IMR_RX_EARLY () {	0x100;}
}
unless(defined(&VR_IMR_LINKSTAT)) {
    sub VR_IMR_LINKSTAT () {	0x200;}
}
unless(defined(&VR_IMR_RX_OFLOW)) {
    sub VR_IMR_RX_OFLOW () {	0x400;}
}
unless(defined(&VR_IMR_RX_DROPPED)) {
    sub VR_IMR_RX_DROPPED () {	0x800;}
}
unless(defined(&VR_IMR_RX_NOBUF2)) {
    sub VR_IMR_RX_NOBUF2 () {	0x1000;}
}
unless(defined(&VR_IMR_TX_ABRT2)) {
    sub VR_IMR_TX_ABRT2 () {	0x2000;}
}
unless(defined(&VR_IMR_LINKSTAT2)) {
    sub VR_IMR_LINKSTAT2 () {	0x4000;}
}
unless(defined(&VR_IMR_MAGICPACKET)) {
    sub VR_IMR_MAGICPACKET () {	0x8000;}
}
unless(defined(&VR_INTRS)) {
    sub VR_INTRS () {	( &VR_IMR_RX_OK| &VR_IMR_TX_OK| &VR_IMR_RX_NOBUF|  &VR_IMR_TX_ABRT| &VR_IMR_TX_UNDERRUN| &VR_IMR_BUSERR|  &VR_IMR_RX_ERR| &VR_ISR_RX_DROPPED);}
}
unless(defined(&VR_MIISTAT_SPEED)) {
    sub VR_MIISTAT_SPEED () {	0x1;}
}
unless(defined(&VR_MIISTAT_LINKFAULT)) {
    sub VR_MIISTAT_LINKFAULT () {	0x2;}
}
unless(defined(&VR_MIISTAT_MGTREADERR)) {
    sub VR_MIISTAT_MGTREADERR () {	0x4;}
}
unless(defined(&VR_MIISTAT_MIIERR)) {
    sub VR_MIISTAT_MIIERR () {	0x8;}
}
unless(defined(&VR_MIISTAT_PHYOPT)) {
    sub VR_MIISTAT_PHYOPT () {	0x10;}
}
unless(defined(&VR_MIISTAT_MDC_SPEED)) {
    sub VR_MIISTAT_MDC_SPEED () {	0x20;}
}
unless(defined(&VR_MIISTAT_RSVD)) {
    sub VR_MIISTAT_RSVD () {	0x40;}
}
unless(defined(&VR_MIISTAT_GPIO1POLL)) {
    sub VR_MIISTAT_GPIO1POLL () {	0x80;}
}
unless(defined(&VR_MIICMD_CLK)) {
    sub VR_MIICMD_CLK () {	0x1;}
}
unless(defined(&VR_MIICMD_DATAOUT)) {
    sub VR_MIICMD_DATAOUT () {	0x2;}
}
unless(defined(&VR_MIICMD_DATAIN)) {
    sub VR_MIICMD_DATAIN () {	0x4;}
}
unless(defined(&VR_MIICMD_DIR)) {
    sub VR_MIICMD_DIR () {	0x8;}
}
unless(defined(&VR_MIICMD_DIRECTPGM)) {
    sub VR_MIICMD_DIRECTPGM () {	0x10;}
}
unless(defined(&VR_MIICMD_WRITE_ENB)) {
    sub VR_MIICMD_WRITE_ENB () {	0x20;}
}
unless(defined(&VR_MIICMD_READ_ENB)) {
    sub VR_MIICMD_READ_ENB () {	0x40;}
}
unless(defined(&VR_MIICMD_AUTOPOLL)) {
    sub VR_MIICMD_AUTOPOLL () {	0x80;}
}
unless(defined(&VR_EECSR_DATAIN)) {
    sub VR_EECSR_DATAIN () {	0x1;}
}
unless(defined(&VR_EECSR_DATAOUT)) {
    sub VR_EECSR_DATAOUT () {	0x2;}
}
unless(defined(&VR_EECSR_CLK)) {
    sub VR_EECSR_CLK () {	0x4;}
}
unless(defined(&VR_EECSR_CS)) {
    sub VR_EECSR_CS () {	0x8;}
}
unless(defined(&VR_EECSR_DPM)) {
    sub VR_EECSR_DPM () {	0x10;}
}
unless(defined(&VR_EECSR_LOAD)) {
    sub VR_EECSR_LOAD () {	0x20;}
}
unless(defined(&VR_EECSR_EMBP)) {
    sub VR_EECSR_EMBP () {	0x40;}
}
unless(defined(&VR_EECSR_EEPR)) {
    sub VR_EECSR_EEPR () {	0x80;}
}
unless(defined(&VR_EECMD_WRITE)) {
    sub VR_EECMD_WRITE () {	0x140;}
}
unless(defined(&VR_EECMD_READ)) {
    sub VR_EECMD_READ () {	0x180;}
}
unless(defined(&VR_EECMD_ERASE)) {
    sub VR_EECMD_ERASE () {	0x1c0;}
}
unless(defined(&VR_TEST_TEST0)) {
    sub VR_TEST_TEST0 () {	0x1;}
}
unless(defined(&VR_TEST_TEST1)) {
    sub VR_TEST_TEST1 () {	0x2;}
}
unless(defined(&VR_TEST_TEST2)) {
    sub VR_TEST_TEST2 () {	0x4;}
}
unless(defined(&VR_TEST_TSTUD)) {
    sub VR_TEST_TSTUD () {	0x8;}
}
unless(defined(&VR_TEST_TSTOV)) {
    sub VR_TEST_TSTOV () {	0x10;}
}
unless(defined(&VR_TEST_BKOFF)) {
    sub VR_TEST_BKOFF () {	0x20;}
}
unless(defined(&VR_TEST_FCOL)) {
    sub VR_TEST_FCOL () {	0x40;}
}
unless(defined(&VR_TEST_HBDES)) {
    sub VR_TEST_HBDES () {	0x80;}
}
unless(defined(&VR_CFG_PREACPIWAKE)) {
    sub VR_CFG_PREACPIWAKE () {	0x1;}
}
unless(defined(&VR_CFG_ABNORMALWAKE)) {
    sub VR_CFG_ABNORMALWAKE () {	0x2;}
}
unless(defined(&VR_CFG_RSVD0)) {
    sub VR_CFG_RSVD0 () {	0x4;}
}
unless(defined(&VR_CFG_LED0)) {
    sub VR_CFG_LED0 () {	0x8;}
}
unless(defined(&VR_CFG_LED1)) {
    sub VR_CFG_LED1 () {	0x10;}
}
unless(defined(&VR_CFG_TAGCRC)) {
    sub VR_CFG_TAGCRC () {	0x20;}
}
unless(defined(&VR_CFG_MIIOPT)) {
    sub VR_CFG_MIIOPT () {	0x40;}
}
unless(defined(&VR_CFG_EELOAD)) {
    sub VR_CFG_EELOAD () {	0x80;}
}
unless(defined(&VR_CFG_LATMENB)) {
    sub VR_CFG_LATMENB () {	0x100;}
}
unless(defined(&VR_CFG_MRREADWAIT)) {
    sub VR_CFG_MRREADWAIT () {	0x200;}
}
unless(defined(&VR_CFG_MRWRITEWAIT)) {
    sub VR_CFG_MRWRITEWAIT () {	0x400;}
}
unless(defined(&VR_CFG_RX_ARB)) {
    sub VR_CFG_RX_ARB () {	0x800;}
}
unless(defined(&VR_CFG_TX_ARB)) {
    sub VR_CFG_TX_ARB () {	0x1000;}
}
unless(defined(&VR_CFG_READMULTI)) {
    sub VR_CFG_READMULTI () {	0x2000;}
}
unless(defined(&VR_CFG_TX_PACE)) {
    sub VR_CFG_TX_PACE () {	0x4000;}
}
unless(defined(&VR_CFG_TX_QDIS)) {
    sub VR_CFG_TX_QDIS () {	0x8000;}
}
unless(defined(&VR_CFG_ROMSEL0)) {
    sub VR_CFG_ROMSEL0 () {	0x10000;}
}
unless(defined(&VR_CFG_ROMSEL1)) {
    sub VR_CFG_ROMSEL1 () {	0x20000;}
}
unless(defined(&VR_CFG_ROMSEL2)) {
    sub VR_CFG_ROMSEL2 () {	0x40000;}
}
unless(defined(&VR_CFG_ROMTIMESEL)) {
    sub VR_CFG_ROMTIMESEL () {	0x80000;}
}
unless(defined(&VR_CFG_RSVD1)) {
    sub VR_CFG_RSVD1 () {	0x100000;}
}
unless(defined(&VR_CFG_ROMDLY)) {
    sub VR_CFG_ROMDLY () {	0x200000;}
}
unless(defined(&VR_CFG_ROMOPT)) {
    sub VR_CFG_ROMOPT () {	0x400000;}
}
unless(defined(&VR_CFG_RSVD2)) {
    sub VR_CFG_RSVD2 () {	0x800000;}
}
unless(defined(&VR_CFG_BACKOFFOPT)) {
    sub VR_CFG_BACKOFFOPT () {	0x1000000;}
}
unless(defined(&VR_CFG_BACKOFFMOD)) {
    sub VR_CFG_BACKOFFMOD () {	0x2000000;}
}
unless(defined(&VR_CFG_CAPEFFECT)) {
    sub VR_CFG_CAPEFFECT () {	0x4000000;}
}
unless(defined(&VR_CFG_BACKOFFRAND)) {
    sub VR_CFG_BACKOFFRAND () {	0x8000000;}
}
unless(defined(&VR_CFG_MAGICKPACKET)) {
    sub VR_CFG_MAGICKPACKET () {	0x10000000;}
}
unless(defined(&VR_CFG_PCIREADLINE)) {
    sub VR_CFG_PCIREADLINE () {	0x20000000;}
}
unless(defined(&VR_CFG_DIAG)) {
    sub VR_CFG_DIAG () {	0x40000000;}
}
unless(defined(&VR_CFG_GPIOEN)) {
    sub VR_CFG_GPIOEN () {	0x80000000;}
}
unless(defined(&VR_STICKHW_DS0)) {
    sub VR_STICKHW_DS0 () {	0x1;}
}
unless(defined(&VR_STICKHW_DS1)) {
    sub VR_STICKHW_DS1 () {	0x2;}
}
unless(defined(&VR_STICKHW_WOL_ENB)) {
    sub VR_STICKHW_WOL_ENB () {	0x4;}
}
unless(defined(&VR_STICKHW_WOL_STS)) {
    sub VR_STICKHW_WOL_STS () {	0x8;}
}
unless(defined(&VR_STICKHW_LEGWOL_ENB)) {
    sub VR_STICKHW_LEGWOL_ENB () {	0x80;}
}
unless(defined(&VR_BCR0_DMA_LENGTH)) {
    sub VR_BCR0_DMA_LENGTH () {	0x7;}
}
unless(defined(&VR_BCR0_DMA_32BYTES)) {
    sub VR_BCR0_DMA_32BYTES () {	0x;}
}
unless(defined(&VR_BCR0_DMA_64BYTES)) {
    sub VR_BCR0_DMA_64BYTES () {	0x1;}
}
unless(defined(&VR_BCR0_DMA_128BYTES)) {
    sub VR_BCR0_DMA_128BYTES () {	0x2;}
}
unless(defined(&VR_BCR0_DMA_256BYTES)) {
    sub VR_BCR0_DMA_256BYTES () {	0x3;}
}
unless(defined(&VR_BCR0_DMA_512BYTES)) {
    sub VR_BCR0_DMA_512BYTES () {	0x4;}
}
unless(defined(&VR_BCR0_DMA_1024BYTES)) {
    sub VR_BCR0_DMA_1024BYTES () {	0x5;}
}
unless(defined(&VR_BCR0_DMA_STORENFWD)) {
    sub VR_BCR0_DMA_STORENFWD () {	0x7;}
}
unless(defined(&VR_BCR0_RX_THRESH)) {
    sub VR_BCR0_RX_THRESH () {	0x38;}
}
unless(defined(&VR_BCR0_RXTHRESHCFG)) {
    sub VR_BCR0_RXTHRESHCFG () {	0x;}
}
unless(defined(&VR_BCR0_RXTHRESH64BYTES)) {
    sub VR_BCR0_RXTHRESH64BYTES () {	0x8;}
}
unless(defined(&VR_BCR0_RXTHRESH128BYTES)) {
    sub VR_BCR0_RXTHRESH128BYTES () {	0x10;}
}
unless(defined(&VR_BCR0_RXTHRESH256BYTES)) {
    sub VR_BCR0_RXTHRESH256BYTES () {	0x18;}
}
unless(defined(&VR_BCR0_RXTHRESH512BYTES)) {
    sub VR_BCR0_RXTHRESH512BYTES () {	0x20;}
}
unless(defined(&VR_BCR0_RXTHRESH1024BYTES)) {
    sub VR_BCR0_RXTHRESH1024BYTES () {	0x28;}
}
unless(defined(&VR_BCR0_RXTHRESHSTORENFWD)) {
    sub VR_BCR0_RXTHRESHSTORENFWD () {	0x38;}
}
unless(defined(&VR_BCR0_EXTLED)) {
    sub VR_BCR0_EXTLED () {	0x40;}
}
unless(defined(&VR_BCR0_MED2)) {
    sub VR_BCR0_MED2 () {	0x80;}
}
unless(defined(&VR_BCR1_POT0)) {
    sub VR_BCR1_POT0 () {	0x1;}
}
unless(defined(&VR_BCR1_POT1)) {
    sub VR_BCR1_POT1 () {	0x2;}
}
unless(defined(&VR_BCR1_POT2)) {
    sub VR_BCR1_POT2 () {	0x4;}
}
unless(defined(&VR_BCR1_TX_THRESH)) {
    sub VR_BCR1_TX_THRESH () {	0x38;}
}
unless(defined(&VR_BCR1_TXTHRESHCFG)) {
    sub VR_BCR1_TXTHRESHCFG () {	0x;}
}
unless(defined(&VR_BCR1_TXTHRESH64BYTES)) {
    sub VR_BCR1_TXTHRESH64BYTES () {	0x8;}
}
unless(defined(&VR_BCR1_TXTHRESH128BYTES)) {
    sub VR_BCR1_TXTHRESH128BYTES () {	0x10;}
}
unless(defined(&VR_BCR1_TXTHRESH256BYTES)) {
    sub VR_BCR1_TXTHRESH256BYTES () {	0x18;}
}
unless(defined(&VR_BCR1_TXTHRESH512BYTES)) {
    sub VR_BCR1_TXTHRESH512BYTES () {	0x20;}
}
unless(defined(&VR_BCR1_TXTHRESH1024BYTES)) {
    sub VR_BCR1_TXTHRESH1024BYTES () {	0x28;}
}
unless(defined(&VR_BCR1_TXTHRESHSTORENFWD)) {
    sub VR_BCR1_TXTHRESHSTORENFWD () {	0x38;}
}
unless(defined(&VR_BCR1_VLANFILT_ENB)) {
    sub VR_BCR1_VLANFILT_ENB () {	0x80;}
}
unless(defined(&VR_RXSTAT_RXERR)) {
    sub VR_RXSTAT_RXERR () {	0x1;}
}
unless(defined(&VR_RXSTAT_CRCERR)) {
    sub VR_RXSTAT_CRCERR () {	0x2;}
}
unless(defined(&VR_RXSTAT_FRAMEALIGNERR)) {
    sub VR_RXSTAT_FRAMEALIGNERR () {	0x4;}
}
unless(defined(&VR_RXSTAT_FIFOOFLOW)) {
    sub VR_RXSTAT_FIFOOFLOW () {	0x8;}
}
unless(defined(&VR_RXSTAT_GIANT)) {
    sub VR_RXSTAT_GIANT () {	0x10;}
}
unless(defined(&VR_RXSTAT_RUNT)) {
    sub VR_RXSTAT_RUNT () {	0x20;}
}
unless(defined(&VR_RXSTAT_BUSERR)) {
    sub VR_RXSTAT_BUSERR () {	0x40;}
}
unless(defined(&VR_RXSTAT_FRAG)) {
    sub VR_RXSTAT_FRAG () {	0x40;}
}
unless(defined(&VR_RXSTAT_BUFFERR)) {
    sub VR_RXSTAT_BUFFERR () {	0x80;}
}
unless(defined(&VR_RXSTAT_LASTFRAG)) {
    sub VR_RXSTAT_LASTFRAG () {	0x100;}
}
unless(defined(&VR_RXSTAT_FIRSTFRAG)) {
    sub VR_RXSTAT_FIRSTFRAG () {	0x200;}
}
unless(defined(&VR_RXSTAT_RLINK)) {
    sub VR_RXSTAT_RLINK () {	0x400;}
}
unless(defined(&VR_RXSTAT_RX_PHYS)) {
    sub VR_RXSTAT_RX_PHYS () {	0x800;}
}
unless(defined(&VR_RXSTAT_RX_BROAD)) {
    sub VR_RXSTAT_RX_BROAD () {	0x1000;}
}
unless(defined(&VR_RXSTAT_RX_MULTI)) {
    sub VR_RXSTAT_RX_MULTI () {	0x2000;}
}
unless(defined(&VR_RXSTAT_RX_VIDHIT)) {
    sub VR_RXSTAT_RX_VIDHIT () {	0x4000;}
}
unless(defined(&VR_RXSTAT_RX_OK)) {
    sub VR_RXSTAT_RX_OK () {	0x8000;}
}
unless(defined(&VR_RXSTAT_RXLEN)) {
    sub VR_RXSTAT_RXLEN () {	0x7ff0000;}
}
unless(defined(&VR_RXSTAT_RXLEN_EXT)) {
    sub VR_RXSTAT_RXLEN_EXT () {	0x78000000;}
}
unless(defined(&VR_RXSTAT_OWN)) {
    sub VR_RXSTAT_OWN () {	0x80000000;}
}
unless(defined(&VR_RXBYTES)) {
    sub VR_RXBYTES {
	my($x) = @_;
	eval q((($x &  &VR_RXSTAT_RXLEN) >> 16));
    }
}
unless(defined(&VR_RXSTAT)) {
    sub VR_RXSTAT () {	( &VR_RXSTAT_FIRSTFRAG| &VR_RXSTAT_LASTFRAG| &VR_RXSTAT_OWN);}
}
unless(defined(&VR_RXCTL_BUFLEN)) {
    sub VR_RXCTL_BUFLEN () {	0x7ff;}
}
unless(defined(&VR_RXCTL_BUFLEN_EXT)) {
    sub VR_RXCTL_BUFLEN_EXT () {	0x7800;}
}
unless(defined(&VR_RXCTL_CHAIN)) {
    sub VR_RXCTL_CHAIN () {	0x8000;}
}
unless(defined(&VR_RXCTL_TAG)) {
    sub VR_RXCTL_TAG () {	0x10000;}
}
unless(defined(&VR_RXCTL_UDP)) {
    sub VR_RXCTL_UDP () {	0x20000;}
}
unless(defined(&VR_RXCTL_TCP)) {
    sub VR_RXCTL_TCP () {	0x40000;}
}
unless(defined(&VR_RXCTL_IP)) {
    sub VR_RXCTL_IP () {	0x80000;}
}
unless(defined(&VR_RXCTL_TCPUDPOK)) {
    sub VR_RXCTL_TCPUDPOK () {	0x100000;}
}
unless(defined(&VR_RXCTL_IPOK)) {
    sub VR_RXCTL_IPOK () {	0x200000;}
}
unless(defined(&VR_RXCTL_SNAPTAG)) {
    sub VR_RXCTL_SNAPTAG () {	0x400000;}
}
unless(defined(&VR_RXCTL_RXLERR)) {
    sub VR_RXCTL_RXLERR () {	0x800000;}
}
unless(defined(&VR_RXCTL_RX_INTR)) {
    sub VR_RXCTL_RX_INTR () {	0x800000;}
}
unless(defined(&VR_RXCTL)) {
    sub VR_RXCTL () {	( &VR_RXCTL_CHAIN| &VR_RXCTL_RX_INTR);}
}
unless(defined(&VR_TXSTAT_DEFER)) {
    sub VR_TXSTAT_DEFER () {	0x1;}
}
unless(defined(&VR_TXSTAT_UNDERRUN)) {
    sub VR_TXSTAT_UNDERRUN () {	0x2;}
}
unless(defined(&VR_TXSTAT_COLLCNT)) {
    sub VR_TXSTAT_COLLCNT () {	0x78;}
}
unless(defined(&VR_TXSTAT_SQE)) {
    sub VR_TXSTAT_SQE () {	0x80;}
}
unless(defined(&VR_TXSTAT_ABRT)) {
    sub VR_TXSTAT_ABRT () {	0x100;}
}
unless(defined(&VR_TXSTAT_LATECOLL)) {
    sub VR_TXSTAT_LATECOLL () {	0x200;}
}
unless(defined(&VR_TXSTAT_CARRLOST)) {
    sub VR_TXSTAT_CARRLOST () {	0x400;}
}
unless(defined(&VR_TXSTAT_UDF)) {
    sub VR_TXSTAT_UDF () {	0x800;}
}
unless(defined(&VR_TXSTAT_BUSERR)) {
    sub VR_TXSTAT_BUSERR () {	0x2000;}
}
unless(defined(&VR_TXSTAT_JABTIMEO)) {
    sub VR_TXSTAT_JABTIMEO () {	0x4000;}
}
unless(defined(&VR_TXSTAT_ERRSUM)) {
    sub VR_TXSTAT_ERRSUM () {	0x8000;}
}
unless(defined(&VR_TXSTAT_PQMASK)) {
    sub VR_TXSTAT_PQMASK () {	0x7fff0000;}
}
unless(defined(&VR_TXSTAT_OWN)) {
    sub VR_TXSTAT_OWN () {	0x80000000;}
}
unless(defined(&VR_TXCTL_BUFLEN)) {
    sub VR_TXCTL_BUFLEN () {	0x7ff;}
}
unless(defined(&VR_TXCTL_BUFLEN_EXT)) {
    sub VR_TXCTL_BUFLEN_EXT () {	0x7800;}
}
unless(defined(&VR_TXCTL_TLINK)) {
    sub VR_TXCTL_TLINK () {	0x8000;}
}
unless(defined(&VR_TXCTL_NOCRC)) {
    sub VR_TXCTL_NOCRC () {	0x10000;}
}
unless(defined(&VR_TXCTL_INSERTTAG)) {
    sub VR_TXCTL_INSERTTAG () {	0x20000;}
}
unless(defined(&VR_TXCTL_IPCSUM)) {
    sub VR_TXCTL_IPCSUM () {	0x40000;}
}
unless(defined(&VR_TXCTL_UDPCSUM)) {
    sub VR_TXCTL_UDPCSUM () {	0x80000;}
}
unless(defined(&VR_TXCTL_TCPCSUM)) {
    sub VR_TXCTL_TCPCSUM () {	0x100000;}
}
unless(defined(&VR_TXCTL_FIRSTFRAG)) {
    sub VR_TXCTL_FIRSTFRAG () {	0x200000;}
}
unless(defined(&VR_TXCTL_LASTFRAG)) {
    sub VR_TXCTL_LASTFRAG () {	0x400000;}
}
unless(defined(&VR_TXCTL_FINT)) {
    sub VR_TXCTL_FINT () {	0x800000;}
}
unless(defined(&VR_MAXFRAGS)) {
    sub VR_MAXFRAGS () {	16;}
}
unless(defined(&VR_RX_LIST_CNT)) {
    sub VR_RX_LIST_CNT () {	64;}
}
unless(defined(&VR_TX_LIST_CNT)) {
    sub VR_TX_LIST_CNT () {	128;}
}
unless(defined(&VR_MIN_FRAMELEN)) {
    sub VR_MIN_FRAMELEN () {	60;}
}
unless(defined(&VR_RXLEN)) {
    sub VR_RXLEN () {	1524;}
}
unless(defined(&VR_TXOWN)) {
    sub VR_TXOWN {
	my($x) = @_;
	eval q( ($x->{vr_ptr}->{vr_status}));
    }
}
unless(defined(&VR_MII_STARTDELIM)) {
    sub VR_MII_STARTDELIM () {	0x1;}
}
unless(defined(&VR_MII_READOP)) {
    sub VR_MII_READOP () {	0x2;}
}
unless(defined(&VR_MII_WRITEOP)) {
    sub VR_MII_WRITEOP () {	0x1;}
}
unless(defined(&VR_MII_TURNAROUND)) {
    sub VR_MII_TURNAROUND () {	0x2;}
}
unless(defined(&VR_FLAG_FORCEDELAY)) {
    sub VR_FLAG_FORCEDELAY () {	1;}
}
unless(defined(&VR_FLAG_SCHEDDELAY)) {
    sub VR_FLAG_SCHEDDELAY () {	2;}
}
unless(defined(&VR_FLAG_DELAYTIMEO)) {
    sub VR_FLAG_DELAYTIMEO () {	3;}
}
unless(defined(&VR_F_RESTART)) {
    sub VR_F_RESTART () {	0x1;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{vr_btag}),  ($sc->{vr_bhandle}), $reg));
    }
}
unless(defined(&VR_TIMEOUT)) {
    sub VR_TIMEOUT () {	1000;}
}
unless(defined(&REV_ID_VT3043_E)) {
    sub REV_ID_VT3043_E () {	0x4;}
}
unless(defined(&REV_ID_VT3071_A)) {
    sub REV_ID_VT3071_A () {	0x20;}
}
unless(defined(&REV_ID_VT3071_B)) {
    sub REV_ID_VT3071_B () {	0x21;}
}
unless(defined(&REV_ID_VT3065_A)) {
    sub REV_ID_VT3065_A () {	0x40;}
}
unless(defined(&REV_ID_VT3065_B)) {
    sub REV_ID_VT3065_B () {	0x41;}
}
unless(defined(&REV_ID_VT3065_C)) {
    sub REV_ID_VT3065_C () {	0x42;}
}
unless(defined(&REV_ID_VT6102_APOLLO)) {
    sub REV_ID_VT6102_APOLLO () {	0x74;}
}
unless(defined(&REV_ID_VT6103)) {
    sub REV_ID_VT6103 () {	0x78;}
}
unless(defined(&REV_ID_VT3106)) {
    sub REV_ID_VT3106 () {	0x80;}
}
unless(defined(&REV_ID_VT3106_J)) {
    sub REV_ID_VT3106_J () {	0x80;}
}
unless(defined(&REV_ID_VT3106_S)) {
    sub REV_ID_VT3106_S () {	0x90;}
}
unless(defined(&REV_ID_VT6105M_A0)) {
    sub REV_ID_VT6105M_A0 () {	0x90;}
}
unless(defined(&REV_ID_VT6105M_B1)) {
    sub REV_ID_VT6105M_B1 () {	0x94;}
}
unless(defined(&VR_PCI_VENDOR_ID)) {
    sub VR_PCI_VENDOR_ID () {	0x;}
}
unless(defined(&VR_PCI_DEVICE_ID)) {
    sub VR_PCI_DEVICE_ID () {	0x2;}
}
unless(defined(&VR_PCI_COMMAND)) {
    sub VR_PCI_COMMAND () {	0x4;}
}
unless(defined(&VR_PCI_STATUS)) {
    sub VR_PCI_STATUS () {	0x6;}
}
unless(defined(&VR_PCI_REVID)) {
    sub VR_PCI_REVID () {	0x8;}
}
unless(defined(&VR_PCI_CLASSCODE)) {
    sub VR_PCI_CLASSCODE () {	0x9;}
}
unless(defined(&VR_PCI_LATENCY_TIMER)) {
    sub VR_PCI_LATENCY_TIMER () {	0xd;}
}
unless(defined(&VR_PCI_HEADER_TYPE)) {
    sub VR_PCI_HEADER_TYPE () {	0xe;}
}
unless(defined(&VR_PCI_LOIO)) {
    sub VR_PCI_LOIO () {	0x10;}
}
unless(defined(&VR_PCI_LOMEM)) {
    sub VR_PCI_LOMEM () {	0x14;}
}
unless(defined(&VR_PCI_BIOSROM)) {
    sub VR_PCI_BIOSROM () {	0x30;}
}
unless(defined(&VR_PCI_INTLINE)) {
    sub VR_PCI_INTLINE () {	0x3c;}
}
unless(defined(&VR_PCI_INTPIN)) {
    sub VR_PCI_INTPIN () {	0x3d;}
}
unless(defined(&VR_PCI_MINGNT)) {
    sub VR_PCI_MINGNT () {	0x3e;}
}
unless(defined(&VR_PCI_MINLAT)) {
    sub VR_PCI_MINLAT () {	0xf;}
}
unless(defined(&VR_PCI_RESETOPT)) {
    sub VR_PCI_RESETOPT () {	0x48;}
}
unless(defined(&VR_PCI_EEPROM_DATA)) {
    sub VR_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&VR_PCI_MODE)) {
    sub VR_PCI_MODE () {	0x50;}
}
unless(defined(&VR_MODE3_MIION)) {
    sub VR_MODE3_MIION () {	0x4;}
}
unless(defined(&VR_PCI_CAPID)) {
    sub VR_PCI_CAPID () {	0xdc;}
}
unless(defined(&VR_PCI_NEXTPTR)) {
    sub VR_PCI_NEXTPTR () {	0xdd;}
}
unless(defined(&VR_PCI_PWRMGMTCAP)) {
    sub VR_PCI_PWRMGMTCAP () {	0xde;}
}
unless(defined(&VR_PCI_PWRMGMTCTRL)) {
    sub VR_PCI_PWRMGMTCTRL () {	0xe0;}
}
unless(defined(&VR_PSTATE_MASK)) {
    sub VR_PSTATE_MASK () {	0x3;}
}
unless(defined(&VR_PSTATE_D0)) {
    sub VR_PSTATE_D0 () {	0x;}
}
unless(defined(&VR_PSTATE_D1)) {
    sub VR_PSTATE_D1 () {	0x2;}
}
unless(defined(&VR_PSTATE_D2)) {
    sub VR_PSTATE_D2 () {	0x2;}
}
unless(defined(&VR_PSTATE_D3)) {
    sub VR_PSTATE_D3 () {	0x3;}
}
unless(defined(&VR_PME_EN)) {
    sub VR_PME_EN () {	0x10;}
}
unless(defined(&VR_PME_STATUS)) {
    sub VR_PME_STATUS () {	0x8000;}
}
1;
