require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&WI_DELAY)) {
    sub WI_DELAY () {	5;}
}
unless(defined(&WI_TIMEOUT)) {
    sub WI_TIMEOUT () {	(500000/ &WI_DELAY);}
}
unless(defined(&WI_PORT0)) {
    sub WI_PORT0 () {	0;}
}
unless(defined(&WI_PORT1)) {
    sub WI_PORT1 () {	1;}
}
unless(defined(&WI_PORT2)) {
    sub WI_PORT2 () {	2;}
}
unless(defined(&WI_PORT3)) {
    sub WI_PORT3 () {	3;}
}
unless(defined(&WI_PORT4)) {
    sub WI_PORT4 () {	4;}
}
unless(defined(&WI_PORT5)) {
    sub WI_PORT5 () {	5;}
}
unless(defined(&WI_DEFAULT_PORT)) {
    sub WI_DEFAULT_PORT () {	( &WI_PORT0 << 8);}
}
unless(defined(&WI_DEFAULT_TX_RATE)) {
    sub WI_DEFAULT_TX_RATE () {	3;}
}
unless(defined(&WI_DEFAULT_NETNAME)) {
    sub WI_DEFAULT_NETNAME () {	"";}
}
unless(defined(&WI_DEFAULT_AP_DENSITY)) {
    sub WI_DEFAULT_AP_DENSITY () {	1;}
}
unless(defined(&WI_DEFAULT_RTS_THRESH)) {
    sub WI_DEFAULT_RTS_THRESH () {	2347;}
}
unless(defined(&WI_DEFAULT_DATALEN)) {
    sub WI_DEFAULT_DATALEN () {	2304;}
}
unless(defined(&WI_DEFAULT_CREATE_IBSS)) {
    sub WI_DEFAULT_CREATE_IBSS () {	0;}
}
unless(defined(&WI_DEFAULT_PM_ENABLED)) {
    sub WI_DEFAULT_PM_ENABLED () {	0;}
}
unless(defined(&WI_DEFAULT_MAX_SLEEP)) {
    sub WI_DEFAULT_MAX_SLEEP () {	100;}
}
unless(defined(&WI_DEFAULT_NODENAME)) {
    sub WI_DEFAULT_NODENAME () {	"WaveLAN/IEEE node";}
}
unless(defined(&WI_DEFAULT_IBSS)) {
    sub WI_DEFAULT_IBSS () {	"IBSS";}
}
unless(defined(&WI_DEFAULT_CHAN)) {
    sub WI_DEFAULT_CHAN () {	3;}
}
unless(defined(&WI_DEFAULT_ROAMING)) {
    sub WI_DEFAULT_ROAMING () {	1;}
}
unless(defined(&WI_DEFAULT_AUTHTYPE)) {
    sub WI_DEFAULT_AUTHTYPE () {	1;}
}
unless(defined(&WI_DEFAULT_DIVERSITY)) {
    sub WI_DEFAULT_DIVERSITY () {	0;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), ( ($sc->{sc_pci}) ? $reg * 2: $reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), ( ($sc->{sc_pci}) ? $reg * 2: $reg), ($val)));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), ( ($sc->{sc_pci}) ? $reg * 2: $reg), $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), ( ($sc->{sc_pci}) ? $reg * 2: $reg)));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), ( ($sc->{sc_pci}) ? $reg * 2: $reg)));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), ( ($sc->{sc_pci}) ? $reg * 2: $reg)));
    }
}
unless(defined(&CSR_READ_RAW_2)) {
    sub CSR_READ_RAW_2 {
	my($sc, $ba, $dst, $sz) = @_;
	eval q( &bus_space_read_raw_multi_2(($sc)-> &wi_btag, ($sc)-> &wi_bhandle, ( ($sc->{sc_pci})? $ba * 2: $ba), ($dst), ($sz)));
    }
}
unless(defined(&CSR_WRITE_RAW_2)) {
    sub CSR_WRITE_RAW_2 {
	my($sc, $ba, $dst, $sz) = @_;
	eval q( &bus_space_write_raw_multi_2(($sc)-> &wi_btag, ($sc)-> &wi_bhandle, ( ($sc->{sc_pci})? $ba * 2: $ba), ($dst), ($sz)));
    }
}
unless(defined(&WI_IOSIZ)) {
    sub WI_IOSIZ () {	0x40;}
}
unless(defined(&WI_COMMAND)) {
    sub WI_COMMAND () {	0x;}
}
unless(defined(&WI_PARAM0)) {
    sub WI_PARAM0 () {	0x2;}
}
unless(defined(&WI_PARAM1)) {
    sub WI_PARAM1 () {	0x4;}
}
unless(defined(&WI_PARAM2)) {
    sub WI_PARAM2 () {	0x6;}
}
unless(defined(&WI_STATUS)) {
    sub WI_STATUS () {	0x8;}
}
unless(defined(&WI_RESP0)) {
    sub WI_RESP0 () {	0xa;}
}
unless(defined(&WI_RESP1)) {
    sub WI_RESP1 () {	0xc;}
}
unless(defined(&WI_RESP2)) {
    sub WI_RESP2 () {	0xe;}
}
unless(defined(&WI_CMD_BUSY)) {
    sub WI_CMD_BUSY () {	0x8000;}
}
unless(defined(&WI_CMD_INI)) {
    sub WI_CMD_INI () {	0x;}
}
unless(defined(&WI_CMD_ENABLE)) {
    sub WI_CMD_ENABLE () {	0x1;}
}
unless(defined(&WI_CMD_DISABLE)) {
    sub WI_CMD_DISABLE () {	0x2;}
}
unless(defined(&WI_CMD_DIAG)) {
    sub WI_CMD_DIAG () {	0x3;}
}
unless(defined(&WI_CMD_ALLOC_MEM)) {
    sub WI_CMD_ALLOC_MEM () {	0xa;}
}
unless(defined(&WI_CMD_TX)) {
    sub WI_CMD_TX () {	0xb;}
}
unless(defined(&WI_CMD_NOTIFY)) {
    sub WI_CMD_NOTIFY () {	0x10;}
}
unless(defined(&WI_CMD_INQUIRE)) {
    sub WI_CMD_INQUIRE () {	0x11;}
}
unless(defined(&WI_CMD_ACCESS)) {
    sub WI_CMD_ACCESS () {	0x21;}
}
unless(defined(&WI_CMD_PROGRAM)) {
    sub WI_CMD_PROGRAM () {	0x22;}
}
unless(defined(&WI_CMD_READ_MIF)) {
    sub WI_CMD_READ_MIF () {	0x30;}
}
unless(defined(&WI_CMD_WRITE_MIF)) {
    sub WI_CMD_WRITE_MIF () {	0x31;}
}
unless(defined(&WI_CMD_CODE_MASK)) {
    sub WI_CMD_CODE_MASK () {	0x3f;}
}
unless(defined(&WI_RECLAIM)) {
    sub WI_RECLAIM () {	0x100;}
}
unless(defined(&WI_ACCESS_READ)) {
    sub WI_ACCESS_READ () {	0x;}
}
unless(defined(&WI_ACCESS_WRITE)) {
    sub WI_ACCESS_WRITE () {	0x100;}
}
unless(defined(&WI_PROGRAM_DISABLE)) {
    sub WI_PROGRAM_DISABLE () {	0x;}
}
unless(defined(&WI_PROGRAM_ENABLE_RAM)) {
    sub WI_PROGRAM_ENABLE_RAM () {	0x100;}
}
unless(defined(&WI_PROGRAM_ENABLE_NVRAM)) {
    sub WI_PROGRAM_ENABLE_NVRAM () {	0x200;}
}
unless(defined(&WI_PROGRAM_NVRAM)) {
    sub WI_PROGRAM_NVRAM () {	0x300;}
}
unless(defined(&WI_STAT_CMD_CODE)) {
    sub WI_STAT_CMD_CODE () {	0x3f;}
}
unless(defined(&WI_STAT_DIAG_ERR)) {
    sub WI_STAT_DIAG_ERR () {	0x100;}
}
unless(defined(&WI_STAT_INQ_ERR)) {
    sub WI_STAT_INQ_ERR () {	0x500;}
}
unless(defined(&WI_STAT_CMD_RESULT)) {
    sub WI_STAT_CMD_RESULT () {	0x7f00;}
}
unless(defined(&WI_INFO_FID)) {
    sub WI_INFO_FID () {	0x10;}
}
unless(defined(&WI_RX_FID)) {
    sub WI_RX_FID () {	0x20;}
}
unless(defined(&WI_ALLOC_FID)) {
    sub WI_ALLOC_FID () {	0x22;}
}
unless(defined(&WI_TX_CMP_FID)) {
    sub WI_TX_CMP_FID () {	0x24;}
}
unless(defined(&WI_SEL0)) {
    sub WI_SEL0 () {	0x18;}
}
unless(defined(&WI_SEL1)) {
    sub WI_SEL1 () {	0x1a;}
}
unless(defined(&WI_OFF0)) {
    sub WI_OFF0 () {	0x1c;}
}
unless(defined(&WI_OFF1)) {
    sub WI_OFF1 () {	0x1e;}
}
unless(defined(&WI_DATA0)) {
    sub WI_DATA0 () {	0x36;}
}
unless(defined(&WI_DATA1)) {
    sub WI_DATA1 () {	0x38;}
}
unless(defined(&WI_BAP0)) {
    sub WI_BAP0 () {	 &WI_DATA0;}
}
unless(defined(&WI_BAP1)) {
    sub WI_BAP1 () {	 &WI_DATA1;}
}
unless(defined(&WI_OFF_BUSY)) {
    sub WI_OFF_BUSY () {	0x8000;}
}
unless(defined(&WI_OFF_ERR)) {
    sub WI_OFF_ERR () {	0x4000;}
}
unless(defined(&WI_OFF_DATAOFF)) {
    sub WI_OFF_DATAOFF () {	0xfff;}
}
unless(defined(&WI_EVENT_STAT)) {
    sub WI_EVENT_STAT () {	0x30;}
}
unless(defined(&WI_INT_EN)) {
    sub WI_INT_EN () {	0x32;}
}
unless(defined(&WI_EVENT_ACK)) {
    sub WI_EVENT_ACK () {	0x34;}
}
unless(defined(&WI_EV_TICK)) {
    sub WI_EV_TICK () {	0x8000;}
}
unless(defined(&WI_EV_RES)) {
    sub WI_EV_RES () {	0x4000;}
}
unless(defined(&WI_EV_INFO_DROP)) {
    sub WI_EV_INFO_DROP () {	0x2000;}
}
unless(defined(&WI_EV_NO_CARD)) {
    sub WI_EV_NO_CARD () {	0x800;}
}
unless(defined(&WI_EV_DUIF_RX)) {
    sub WI_EV_DUIF_RX () {	0x400;}
}
unless(defined(&WI_EV_INFO)) {
    sub WI_EV_INFO () {	0x80;}
}
unless(defined(&WI_EV_CMD)) {
    sub WI_EV_CMD () {	0x10;}
}
unless(defined(&WI_EV_ALLOC)) {
    sub WI_EV_ALLOC () {	0x8;}
}
unless(defined(&WI_EV_TX_EXC)) {
    sub WI_EV_TX_EXC () {	0x4;}
}
unless(defined(&WI_EV_TX)) {
    sub WI_EV_TX () {	0x2;}
}
unless(defined(&WI_EV_RX)) {
    sub WI_EV_RX () {	0x1;}
}
unless(defined(&WI_INTRS)) {
    sub WI_INTRS () {	( &WI_EV_RX| &WI_EV_TX| &WI_EV_TX_EXC| &WI_EV_ALLOC| &WI_EV_INFO| &WI_EV_INFO_DROP);}
}
unless(defined(&WI_SW0)) {
    sub WI_SW0 () {	0x28;}
}
unless(defined(&WI_SW1)) {
    sub WI_SW1 () {	0x2a;}
}
unless(defined(&WI_SW2)) {
    sub WI_SW2 () {	0x2c;}
}
unless(defined(&WI_SW3)) {
    sub WI_SW3 () {	0x2e;}
}
unless(defined(&WI_CNTL)) {
    sub WI_CNTL () {	0x14;}
}
unless(defined(&WI_CNTL_AUX_ENA)) {
    sub WI_CNTL_AUX_ENA () {	0xc000;}
}
unless(defined(&WI_CNTL_AUX_ENA_STAT)) {
    sub WI_CNTL_AUX_ENA_STAT () {	0xc000;}
}
unless(defined(&WI_CNTL_AUX_DIS_STAT)) {
    sub WI_CNTL_AUX_DIS_STAT () {	0x;}
}
unless(defined(&WI_CNTL_AUX_ENA_CNTL)) {
    sub WI_CNTL_AUX_ENA_CNTL () {	0x8000;}
}
unless(defined(&WI_CNTL_AUX_DIS_CNTL)) {
    sub WI_CNTL_AUX_DIS_CNTL () {	0x4000;}
}
unless(defined(&WI_AUX_PAGE)) {
    sub WI_AUX_PAGE () {	0x3a;}
}
unless(defined(&WI_AUX_OFFSET)) {
    sub WI_AUX_OFFSET () {	0x3c;}
}
unless(defined(&WI_AUX_DATA)) {
    sub WI_AUX_DATA () {	0x3e;}
}
unless(defined(&WI_COR_OFFSET)) {
    sub WI_COR_OFFSET () {	0x40;}
}
unless(defined(&WI_COR_IOMODE)) {
    sub WI_COR_IOMODE () {	0x41;}
}
unless(defined(&WI_PLX_LOCALRES)) {
    sub WI_PLX_LOCALRES () {	0x14;}
}
unless(defined(&WI_PLX_MEMRES)) {
    sub WI_PLX_MEMRES () {	0x18;}
}
unless(defined(&WI_PLX_IORES)) {
    sub WI_PLX_IORES () {	0x1c;}
}
unless(defined(&WI_PLX_INTCSR)) {
    sub WI_PLX_INTCSR () {	0x4c;}
}
unless(defined(&WI_PLX_INTEN)) {
    sub WI_PLX_INTEN () {	0x40;}
}
unless(defined(&WI_PLX_LINT1STAT)) {
    sub WI_PLX_LINT1STAT () {	0x4;}
}
unless(defined(&WI_PLX_COR_OFFSET)) {
    sub WI_PLX_COR_OFFSET () {	0x3e0;}
}
unless(defined(&WI_ACEX_CMDRES)) {
    sub WI_ACEX_CMDRES () {	0x10;}
}
unless(defined(&WI_ACEX_LOCALRES)) {
    sub WI_ACEX_LOCALRES () {	0x14;}
}
unless(defined(&WI_ACEX_IORES)) {
    sub WI_ACEX_IORES () {	0x18;}
}
unless(defined(&WI_ACEX_COR_OFFSET)) {
    sub WI_ACEX_COR_OFFSET () {	0xe0;}
}
unless(defined(&WI_TMD_LOCALRES)) {
    sub WI_TMD_LOCALRES () {	0x14;}
}
unless(defined(&WI_TMD_IORES)) {
    sub WI_TMD_IORES () {	0x18;}
}
unless(defined(&WI_DRVR_MAGIC)) {
    sub WI_DRVR_MAGIC () {	0x4a2d;}
}
unless(defined(&WI_PCI_CBMA)) {
    sub WI_PCI_CBMA () {	0x10;}
}
unless(defined(&WI_PCI_COR_OFFSET)) {
    sub WI_PCI_COR_OFFSET () {	0x4c;}
}
unless(defined(&WI_PCI_HCR)) {
    sub WI_PCI_HCR () {	0x5c;}
}
unless(defined(&WI_PCI_MASTER0_ADDRH)) {
    sub WI_PCI_MASTER0_ADDRH () {	0x80;}
}
unless(defined(&WI_PCI_MASTER0_ADDRL)) {
    sub WI_PCI_MASTER0_ADDRL () {	0x84;}
}
unless(defined(&WI_PCI_MASTER0_LEN)) {
    sub WI_PCI_MASTER0_LEN () {	0x88;}
}
unless(defined(&WI_PCI_MASTER0_CON)) {
    sub WI_PCI_MASTER0_CON () {	0x8c;}
}
unless(defined(&WI_PCI_STATUS)) {
    sub WI_PCI_STATUS () {	0x98;}
}
unless(defined(&WI_PCI_MASTER1_ADDRH)) {
    sub WI_PCI_MASTER1_ADDRH () {	0xa0;}
}
unless(defined(&WI_PCI_MASTER1_ADDRL)) {
    sub WI_PCI_MASTER1_ADDRL () {	0xa4;}
}
unless(defined(&WI_PCI_MASTER1_LEN)) {
    sub WI_PCI_MASTER1_LEN () {	0xa8;}
}
unless(defined(&WI_PCI_MASTER1_CON)) {
    sub WI_PCI_MASTER1_CON () {	0xac;}
}
unless(defined(&WI_COR_SOFT_RESET)) {
    sub WI_COR_SOFT_RESET () {	(1<< 7);}
}
unless(defined(&WI_COR_CLEAR)) {
    sub WI_COR_CLEAR () {	0x;}
}
unless(defined(&WI_SETVAL)) {
    sub WI_SETVAL {
	my($recno, $val) = @_;
	eval q( &do { 'struct wi_ltv_gen'  &g;  ($g->{wi_len}) = 2;  ($g->{wi_type}) = $recno;  ($g->{wi_val}) =  &htole16($val);  &wi_write_record( &sc,  &g); }  &while (0));
    }
}
unless(defined(&WI_SETSTR)) {
    sub WI_SETSTR {
	my($recno, $str) = @_;
	eval q( &do { 'struct wi_ltv_str'  &s; 'int'  &l;  &l = ( ($str->{i_len}) + 1) & ~0x1;  &bzero( &s, $sizeof{ &s});  ($s->{wi_len}) = ( &l / 2) + 2;  ($s->{wi_type}) = $recno;  ($s->{wi_str[0]}) =  &htole16( ($str->{i_len}));  &bcopy( ($str->{i_nwid}),  ($s->{wi_str[1]}),  ($str->{i_len}));  &wi_write_record( &sc,  &s); }  &while (0));
    }
}
unless(defined(&WI_RID_DNLD_BUF)) {
    sub WI_RID_DNLD_BUF () {	0xfd01;}
}
unless(defined(&WI_RID_MEMSZ)) {
    sub WI_RID_MEMSZ () {	0xfd02;}
}
unless(defined(&WI_PORTTYPE_BSS)) {
    sub WI_PORTTYPE_BSS () {	0x1;}
}
unless(defined(&WI_PORTTYPE_WDS)) {
    sub WI_PORTTYPE_WDS () {	0x2;}
}
unless(defined(&WI_PORTTYPE_ADHOC)) {
    sub WI_PORTTYPE_ADHOC () {	0x3;}
}
unless(defined(&WI_PORTTYPE_IBSS)) {
    sub WI_PORTTYPE_IBSS () {	0x4;}
}
unless(defined(&WI_PORTTYPE_HOSTAP)) {
    sub WI_PORTTYPE_HOSTAP () {	0x6;}
}
unless(defined(&WI_SUPPRATES_1M)) {
    sub WI_SUPPRATES_1M () {	0x1;}
}
unless(defined(&WI_SUPPRATES_2M)) {
    sub WI_SUPPRATES_2M () {	0x2;}
}
unless(defined(&WI_SUPPRATES_5M)) {
    sub WI_SUPPRATES_5M () {	0x4;}
}
unless(defined(&WI_SUPPRATES_11M)) {
    sub WI_SUPPRATES_11M () {	0x8;}
}
unless(defined(&WI_RATES_BITS)) {
    sub WI_RATES_BITS () {	"\20\0011M\0022M\0035.5M\00411M";}
}
unless(defined(&WI_INFO_NOTIFY)) {
    sub WI_INFO_NOTIFY () {	0xf000;}
}
unless(defined(&WI_INFO_COUNTERS)) {
    sub WI_INFO_COUNTERS () {	0xf100;}
}
unless(defined(&WI_INFO_SCAN_RESULTS)) {
    sub WI_INFO_SCAN_RESULTS () {	0xf101;}
}
unless(defined(&WI_INFO_LINK_STAT)) {
    sub WI_INFO_LINK_STAT () {	0xf200;}
}
unless(defined(&WI_INFO_ASSOC_STAT)) {
    sub WI_INFO_ASSOC_STAT () {	0xf201;}
}
unless(defined(&WI_802_3_OFFSET)) {
    sub WI_802_3_OFFSET () {	0x2e;}
}
unless(defined(&WI_802_11_OFFSET)) {
    sub WI_802_11_OFFSET () {	0x44;}
}
unless(defined(&WI_802_11_OFFSET_RAW)) {
    sub WI_802_11_OFFSET_RAW () {	0x3c;}
}
unless(defined(&WI_802_11_OFFSET_HDR)) {
    sub WI_802_11_OFFSET_HDR () {	0xe;}
}
unless(defined(&WI_STAT_BADCRC)) {
    sub WI_STAT_BADCRC () {	0x1;}
}
unless(defined(&WI_STAT_UNDECRYPTABLE)) {
    sub WI_STAT_UNDECRYPTABLE () {	0x2;}
}
unless(defined(&WI_STAT_ERRSTAT)) {
    sub WI_STAT_ERRSTAT () {	0x3;}
}
unless(defined(&WI_STAT_MAC_PORT)) {
    sub WI_STAT_MAC_PORT () {	0x700;}
}
unless(defined(&WI_STAT_1042)) {
    sub WI_STAT_1042 () {	0x2000;}
}
unless(defined(&WI_STAT_TUNNEL)) {
    sub WI_STAT_TUNNEL () {	0x4000;}
}
unless(defined(&WI_STAT_WMP_MSG)) {
    sub WI_STAT_WMP_MSG () {	0x6000;}
}
unless(defined(&WI_STAT_MGMT)) {
    sub WI_STAT_MGMT () {	0x8000;}
}
unless(defined(&WI_RXSTAT_MSG_TYPE)) {
    sub WI_RXSTAT_MSG_TYPE () {	0xe000;}
}
unless(defined(&WI_ENC_TX_802_3)) {
    sub WI_ENC_TX_802_3 () {	0x;}
}
unless(defined(&WI_ENC_TX_802_11)) {
    sub WI_ENC_TX_802_11 () {	0x11;}
}
unless(defined(&WI_ENC_TX_MGMT)) {
    sub WI_ENC_TX_MGMT () {	0x8;}
}
unless(defined(&WI_ENC_TX_E_II)) {
    sub WI_ENC_TX_E_II () {	0xe;}
}
unless(defined(&WI_ENC_TX_1042)) {
    sub WI_ENC_TX_1042 () {	0x;}
}
unless(defined(&WI_ENC_TX_TUNNEL)) {
    sub WI_ENC_TX_TUNNEL () {	0xf8;}
}
unless(defined(&WI_TXCNTL_MACPORT)) {
    sub WI_TXCNTL_MACPORT () {	0xff;}
}
unless(defined(&WI_TXCNTL_STRUCTTYPE)) {
    sub WI_TXCNTL_STRUCTTYPE () {	0xff00;}
}
unless(defined(&WI_TXCNTL_TX_EX)) {
    sub WI_TXCNTL_TX_EX () {	0x4;}
}
unless(defined(&WI_TXCNTL_TX_OK)) {
    sub WI_TXCNTL_TX_OK () {	0x2;}
}
unless(defined(&WI_TXCNTL_NOCRYPT)) {
    sub WI_TXCNTL_NOCRYPT () {	0x80;}
}
unless(defined(&WI_SNAP_K1)) {
    sub WI_SNAP_K1 () {	0xaa;}
}
unless(defined(&WI_SNAP_K2)) {
    sub WI_SNAP_K2 () {	0x;}
}
unless(defined(&WI_SNAP_CONTROL)) {
    sub WI_SNAP_CONTROL () {	0x3;}
}
unless(defined(&WI_SNAP_WORD0)) {
    sub WI_SNAP_WORD0 () {	( &WI_SNAP_K1 | ( &WI_SNAP_K1 << 8));}
}
unless(defined(&WI_SNAP_WORD1)) {
    sub WI_SNAP_WORD1 () {	( &WI_SNAP_K2 | ( &WI_SNAP_CONTROL << 8));}
}
unless(defined(&WI_SNAPHDR_LEN)) {
    sub WI_SNAPHDR_LEN () {	0x6;}
}
unless(defined(&WI_FCS_LEN)) {
    sub WI_FCS_LEN () {	0x4;}
}
unless(defined(&WI_ETHERTYPE_LEN)) {
    sub WI_ETHERTYPE_LEN () {	0x2;}
}
unless(defined(&WI_HFA384X_CR_A_D_TEST_MODES2)) {
    sub WI_HFA384X_CR_A_D_TEST_MODES2 () {	0x1a;}
}
unless(defined(&WI_HFA384X_CR_MANUAL_TX_POWER)) {
    sub WI_HFA384X_CR_MANUAL_TX_POWER () {	0x3e;}
}
1;
