require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&PSR_IMPL)) {
    eval 'sub PSR_IMPL () {0xf0000000;}' unless defined(&PSR_IMPL);
    eval 'sub PSR_VER () {0xf000000;}' unless defined(&PSR_VER);
    eval 'sub PSR_ICC () {0xf00000;}' unless defined(&PSR_ICC);
    eval 'sub PSR_N () {0x800000;}' unless defined(&PSR_N);
    eval 'sub PSR_Z () {0x400000;}' unless defined(&PSR_Z);
    eval 'sub PSR_O () {0x200000;}' unless defined(&PSR_O);
    eval 'sub PSR_C () {0x100000;}' unless defined(&PSR_C);
    eval 'sub PSR_EC () {0x2000;}' unless defined(&PSR_EC);
    eval 'sub PSR_EF () {0x1000;}' unless defined(&PSR_EF);
    eval 'sub PSR_PIL () {0xf00;}' unless defined(&PSR_PIL);
    eval 'sub PSR_S () {0x80;}' unless defined(&PSR_S);
    eval 'sub PSR_PS () {0x40;}' unless defined(&PSR_PS);
    eval 'sub PSR_ET () {0x20;}' unless defined(&PSR_ET);
    eval 'sub PSR_CWP () {0x1f;}' unless defined(&PSR_CWP);
    eval 'sub PSR_BITS () {"\\20\\16EC\\15EF\\10S\\7PS\\6ET";}' unless defined(&PSR_BITS);
    eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_SOFTINT () {1;}' unless defined(&IPL_SOFTINT);
    eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFTNET () {1;}' unless defined(&IPL_SOFTNET);
    eval 'sub IPL_AUSOFT () {4;}' unless defined(&IPL_AUSOFT);
    eval 'sub IPL_FDSOFT () {4;}' unless defined(&IPL_FDSOFT);
    eval 'sub IPL_BIO () {5;}' unless defined(&IPL_BIO);
    eval 'sub IPL_TTY () {6;}' unless defined(&IPL_TTY);
    eval 'sub IPL_SOFTTTY () { &IPL_TTY;}' unless defined(&IPL_SOFTTTY);
    eval 'sub IPL_NET () {7;}' unless defined(&IPL_NET);
    eval 'sub IPL_VM () {7;}' unless defined(&IPL_VM);
    eval 'sub IPL_FB () {9;}' unless defined(&IPL_FB);
    eval 'sub IPL_CLOCK () {10;}' unless defined(&IPL_CLOCK);
    eval 'sub IPL_FD () {11;}' unless defined(&IPL_FD);
    eval 'sub IPL_ZS () {12;}' unless defined(&IPL_ZS);
    eval 'sub IPL_AUHARD () {13;}' unless defined(&IPL_AUHARD);
    eval 'sub IPL_STATCLOCK () {14;}' unless defined(&IPL_STATCLOCK);
    eval 'sub IPL_SCHED () { &IPL_STATCLOCK;}' unless defined(&IPL_SCHED);
    eval 'sub IPL_HIGH () {15;}' unless defined(&IPL_HIGH);
    if(defined( &_KERNEL)  && !defined( &_LOCORE)) {
	eval 'sub getmid {
	    eval q({ \'int\'  &mid;  &__asm  &__volatile(\\"rd %%tbr,%0\\" : \\"=r\\" ( &mid)); (( &mid >> 20) & 0x3); });
	}' unless defined(&getmid);
	eval 'sub setpsr {
	    my($newpsr) = @_;
    	    eval q(; {  &__asm  &__volatile(\\"wr %0,0,%%psr\\" : : \\"r\\" ($newpsr));  &__asm  &__volatile(\\"nop\\");  &__asm  &__volatile(\\"nop\\");  &__asm  &__volatile(\\"nop\\"); });
	}' unless defined(&setpsr);
	eval 'sub spl0 {
	    eval q({ \'int\'  &psr,  &oldipl;  &__asm  &__volatile(\\"rd %%psr,%0\\" : \\"=r\\" ( &psr));  &oldipl =  &psr &  &PSR_PIL;  &__asm  &__volatile(\\"wr %0,%1,%%psr\\" : : \\"r\\" ( &psr), \\"r\\" ( &oldipl));  &__asm  &__volatile(\\"nop; nop; nop\\"); ( &oldipl); });
	}' unless defined(&spl0);
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub splassert {
	        my($__wantipl) = @_;
    		eval q( &do {  &if ( &splassert_ctl > 0) {  &splassert_check($__wantipl,  &__func__); } }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &splassert($wantipl));
	    }' unless defined(&splsoftassert);
	} else {
	    eval 'sub splassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splassert);
	    eval 'sub splsoftassert {
	        my($wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splsoftassert);
	}
	eval 'sub SPL {
	    my($name, $newipl) = @_;
    	    eval q( &static  &__inline \'int\' $name( &void);  &static  &__inline \'int\' $name() { \'int\'  &psr,  &oldipl;  &__asm  &__volatile(\\"rd %%psr,%0\\" : \\"=r\\" ( &psr));  &oldipl =  &psr &  &PSR_PIL;  &psr &= ~ &oldipl;  &__asm  &__volatile(\\"wr %0,%1,%%psr\\" : : \\"r\\" ( &psr), \\"n\\" (($newipl) << 8));  &__asm  &__volatile(\\"nop; nop; nop\\");  &__asm  &__volatile(\\"\\":::\\"memory\\");  &return ( &oldipl); });
	}' unless defined(&SPL);
	eval 'sub SPLHOLD {
	    my($name, $newipl) = @_;
    	    eval q( &static  &__inline \'int\' $name( &void);  &static  &__inline \'int\' $name() { \'int\'  &psr,  &oldipl;  &__asm  &__volatile(\\"rd %%psr,%0\\" : \\"=r\\" ( &psr));  &oldipl =  &psr &  &PSR_PIL;  &if (($newipl << 8) <=  &oldipl)  &return  &oldipl;  &psr &= ~ &oldipl;  &__asm  &__volatile(\\"wr %0,%1,%%psr\\" : : \\"r\\" ( &psr), \\"n\\" (($newipl) << 8));  &__asm  &__volatile(\\"nop; nop; nop\\");  &__asm  &__volatile(\\"\\":::\\"memory\\");  &return ( &oldipl); });
	}' unless defined(&SPLHOLD);
	eval 'sub splsoftclock () { &splsoftint;}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () { &splsoftint;}' unless defined(&splsoftnet);
	eval 'sub splhigh {
	    eval q({ \'int\'  &psr,  &oldipl;  &__asm  &__volatile(\\"rd %%psr,%0\\" : \\"=r\\" ( &psr));  &__asm  &__volatile(\\"wr %0,0,%%psr\\" : : \\"r\\" ( &psr |  &PSR_PIL));  &__asm  &__volatile(\\"and %1,%2,%0; nop; nop\\" : \\"=r\\" ( &oldipl) : \\"r\\" ( &psr), \\"n\\" ( &PSR_PIL));  &__asm  &__volatile(\\"\\":::\\"memory\\"); ( &oldipl); });
	}' unless defined(&splhigh);
    }
}
1;
