#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorBalance4',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MP',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 53 => 0x69 },
	'about' => { 209 => 'about' },
	'abspeakaudiofilepath' => { 214 => 'absPeakAudioFilePath' },
	'accessorytype' => { 161 => 0x53 },
	'actionadvised' => { 64 => 0x2a },
	'activearea' => { 58 => 0xc68d },
	'actived-lighting' => { 120 => 0x22, 138 => 0x24 },
	'actived-lightingmode' => { 138 => 0x25 },
	'addaspectratioinfo' => { 35 => 0x80e },
	'additionalmodelinformation' => { 202 => 'AdditionalModelInformation' },
	'addoriginaldecisiondata' => { 35 => 0x80f, 36 => 0x11, 37 => 0x13, 40 => 0x14 },
	'address' => { 87 => 'Address' },
	'adjustmentmode' => { 186 => [0x15,0x22] },
	'adultcontentwarning' => { 205 => 'AdultContentWarning', 208 => 'adultContentWarning' },
	'advancedraw' => { 140 => 0x76a43203 },
	'advisory' => { 212 => 'Advisory' },
	'ae_iso' => { 163 => 0x2 },
	'aeaperture' => { 163 => 0x1 },
	'aebautocancel' => { 35 => 0x104 },
	'aebbracketvalue' => { 32 => 0x11 },
	'aebsequence' => { 33 => 0x9, 34 => 0x9, 35 => 0x105, 36 => 0x8, 37 => 0x9, 40 => 0x9, 41 => 0x7 },
	'aebshotcount' => { 35 => 0x106 },
	'aebxv' => { 163 => 0x4 },
	'aeexposuretime' => { 163 => 0x0 },
	'aeextra' => { 163 => 0x7 },
	'aelock' => { 128 => '733.2', 129 => '752.2', 147 => 0x201, 174 => 0x48 },
	'aelockbutton' => { 128 => '733.1', 129 => '752.1' },
	'aemaxaperture' => { 163 => 0x9 },
	'aemaxaperture2' => { 163 => 0xa },
	'aemeteringmode' => { 163 => 0xc },
	'aemeteringsegments' => { 174 => 0x209 },
	'aeminaperture' => { 163 => 0xb },
	'aeminexposuretime' => { 163 => 0x5 },
	'aeprogrammode' => { 163 => 0x6 },
	'aesetting' => { 13 => 0x21 },
	'aexv' => { 163 => 0x3 },
	'af-cpriorityselection' => { 127 => '791.1' },
	'af-onformb-d10' => { 127 => '793.1' },
	'af-spriorityselection' => { 127 => '791.2' },
	'afactivation' => { 127 => '792.1' },
	'afadjustment' => { 174 => 0x72 },
	'afaperture' => { 118 => 0x5, 119 => 0x5 },
	'afareaillumination' => { 129 => '763.3' },
	'afareamode' => { 104 => 0x0, 105 => 0x5, 129 => 0x2fc },
	'afareamodesetting' => { 128 => 0x2e4 },
	'afareas' => { 147 => 0x304 },
	'afassist' => { 33 => 0x5, 41 => 0x5, 128 => '729.2', 129 => '748.2' },
	'afassistbeam' => { 35 => 0x50e, 36 => 0x4, 37 => 0x5, 38 => 0x4, 39 => 0x4, 40 => 0x5 },
	'afassistilluminator' => { 127 => '792.4' },
	'afdefocus' => { 164 => 0x6 },
	'afduringliveview' => { 35 => 0x511 },
	'afexpansionwithselectedpoint' => { 35 => 0x508 },
	'affinetuneadj' => { 127 => 0x2d1 },
	'afintegrationtime' => { 164 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 35 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 161 => 0xf, 186 => 0x5 },
	'afonaelockbuttonswitch' => { 35 => 0x702 },
	'afpoint' => { 13 => 0x13, 54 => 0x18, 104 => 0x1, 150 => 0x308 },
	'afpointactivationarea' => { 34 => 0x11, 40 => 0x11 },
	'afpointautoselection' => { 35 => 0x50b },
	'afpointbrightness' => { 35 => 0x50d },
	'afpointdisplayduringfocus' => { 35 => 0x50c },
	'afpointillumination' => { 34 => 0xa, 127 => '792.3' },
	'afpointmode' => { 167 => 0x3 },
	'afpointposition' => { 55 => 0x2021 },
	'afpointregistration' => { 33 => 0x7 },
	'afpoints' => { 98 => 0x10 },
	'afpointselected' => { 174 => 0xe },
	'afpointselected2' => { 167 => 0x4 },
	'afpointselection' => { 34 => 0xb, 127 => '791.3' },
	'afpointselectionmethod' => { 35 => 0x50f, 36 => 0xc, 37 => 0xd, 40 => 0xd },
	'afpointsinfocus' => { 32 => 0xe, 104 => 0x2, 164 => 0xb, 174 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 10 => 0x38 },
	'afpointspotmetering' => { 34 => 0xd },
	'afpointsunknown1' => { 164 => 0x0 },
	'afpointsunknown2' => { 164 => 0x2 },
	'afpointsused' => { 105 => 0x8 },
	'afpredictor' => { 164 => 0x4 },
	'afresponse' => { 120 => 0xad },
	'afresult' => { 152 => 0x1038 },
	'afsearch' => { 147 => 0x303 },
	'aggregationtype' => { 206 => 'aggregationType' },
	'agreement' => { 208 => 'agreement' },
	'aiservoimagepriority' => { 35 => 0x503 },
	'aiservotrackingmethod' => { 35 => 0x504 },
	'aiservotrackingsensitivity' => { 34 => 0x14, 35 => 0x502 },
	'album' => { 214 => 'album' },
	'alreadyapplied' => { 197 => 'AlreadyApplied' },
	'alternatetitle' => { 206 => 'alternateTitle' },
	'alttapename' => { 214 => 'altTapeName' },
	'alttimecodetimeformat' => { 214 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 214 => 'altTimecodeTimeValue' },
	'alttimecodevalue' => { 214 => 'altTimecodeValue' },
	'anti-blur' => { 187 => 0xb04b },
	'antialiasstrength' => { 58 => 0xc632 },
	'aperturerange' => { 35 => 0x10d },
	'apertureringuse' => { 167 => '1.4' },
	'aperturevalue' => { 44 => 0x2, 58 => 0x9202, 152 => 0x1002, 200 => 'ApertureValue' },
	'applekeywords' => { 156 => 'AAPL:Keywords' },
	'applicationnotes' => { 58 => 0x2bc },
	'applicationrecordversion' => { 64 => 0x0 },
	'applyshootingmeteringmode' => { 35 => 0x10e },
	'approximatefnumber' => { 159 => 0x313 },
	'armidentifier' => { 65 => 0x78 },
	'armversion' => { 65 => 0x7a },
	'artist' => { 58 => 0x13b, 158 => 'Artist', 210 => 'Artist', 214 => 'artist' },
	'artworkcopyrightnotice' => { 202 => 'ArtworkOrObjectAOCopyrightNotice' },
	'artworkcreator' => { 202 => 'ArtworkOrObjectAOCreator' },
	'artworkdatecreated' => { 202 => 'ArtworkOrObjectAODateCreated' },
	'artworksource' => { 202 => 'ArtworkOrObjectAOSource' },
	'artworksourceinventoryno' => { 202 => 'ArtworkOrObjectAOSourceInvNo' },
	'artworktitle' => { 202 => 'ArtworkOrObjectAOTitle' },
	'asshoticcprofile' => { 58 => 0xc68f },
	'asshotneutral' => { 58 => 0xc628 },
	'asshotpreprofilematrix' => { 58 => 0xc690 },
	'asshotprofilename' => { 58 => 0xc6f6 },
	'asshotwhitexy' => { 58 => 0xc629 },
	'assignfuncbutton' => { 35 => 0x70b },
	'assistbuttonfunction' => { 33 => 0xd },
	'attributionname' => { 196 => 'attributionName' },
	'attributionurl' => { 196 => 'attributionURL' },
	'audio' => { 161 => 0x20 },
	'audiochanneltype' => { 214 => 'audioChannelType' },
	'audiocompression' => { 81 => 'Compression' },
	'audiocompressor' => { 214 => 'audioCompressor' },
	'audioduration' => { 64 => 0x99 },
	'audiomoddate' => { 214 => 'audioModDate' },
	'audiooutcue' => { 64 => 0x9a },
	'audiosamplerate' => { 214 => 'audioSampleRate' },
	'audiosampletype' => { 214 => 'audioSampleType' },
	'audiosamplingrate' => { 64 => 0x97 },
	'audiosamplingresolution' => { 64 => 0x98 },
	'audiotype' => { 64 => 0x96 },
	'author' => { 83 => 'Author', 156 => 'Author', 158 => 'Author', 182 => 'Author', 203 => 'Author' },
	'authorsposition' => { 204 => 'AuthorsPosition' },
	'autoaperture' => { 171 => '0.1' },
	'autobracket' => { 186 => 0x19 },
	'autobracketing' => { 62 => 0x1100, 174 => 0x18 },
	'autobracketmodem' => { 127 => '811.2' },
	'autobracketorder' => { 127 => '811.3', 129 => '750.2' },
	'autobracketrelease' => { 120 => 0x8a },
	'autobracketset' => { 127 => '811.1', 129 => '750.1' },
	'autobrightness' => { 197 => 'AutoBrightness' },
	'autocontrast' => { 197 => 'AutoContrast' },
	'autoexposure' => { 197 => 'AutoExposure' },
	'autoexposurebracketing' => { 32 => 0x10 },
	'autofocus' => { 105 => 0x6, 150 => 0x209 },
	'autofp' => { 129 => '755.3' },
	'autoiso' => { 32 => 0x1, 55 => 0x3008, 128 => '730.1', 129 => '749.1' },
	'autoisomax' => { 128 => '730.2', 129 => '749.2' },
	'autoisominshutterspeed' => { 128 => '730.3', 129 => '749.3' },
	'autolightingoptimizer' => { 9 => 0xbf, 11 => 0xbf, 35 => 0x204, 53 => 0x6f },
	'autolightingoptimizeron' => { 53 => 0x6e },
	'autoredeye' => { 140 => 0xfe28a44f },
	'autorotate' => { 32 => 0x1b },
	'autoshadows' => { 197 => 'AutoShadows' },
	'auxiliarylens' => { 120 => 0x82 },
	'avaperturesetting' => { 167 => 0x13 },
	'avsettingwithoutlens' => { 35 => 0x707 },
	'azimuth' => { 91 => 'Azimuth' },
	'babyage' => { 161 => [0x8010,0x33] },
	'baseexposurecompensation' => { 167 => 0x15 },
	'baseiso' => { 32 => 0x2, 48 => 0x101c },
	'baselineexposure' => { 58 => 0xc62a },
	'baselinenoise' => { 58 => 0xc62b },
	'baselinesharpness' => { 58 => 0xc62c },
	'baseurl' => { 212 => 'BaseURL' },
	'batteryadbodyload' => { 165 => 0x3 },
	'batteryadbodynoload' => { 165 => 0x2 },
	'batteryadgripload' => { 165 => 0x5 },
	'batteryadgripnoload' => { 165 => 0x4 },
	'batteryorder' => { 127 => '802.3' },
	'batterystates' => { 165 => 0x1 },
	'bayergreensplit' => { 58 => 0xc62d },
	'bayerpattern' => { 68 => 0xf902, 101 => 0x17 },
	'beatspliceparamsriseindecibel' => { 214 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimedurationscale' => { 214 => 'beatSpliceParamsRiseInTimeDurationScale' },
	'beatspliceparamsriseintimedurationvalue' => { 214 => 'beatSpliceParamsRiseInTimeDurationValue' },
	'beatspliceparamsusefilebeatsmarker' => { 214 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 127 => '803.1', 128 => '729.1', 129 => '748.1' },
	'bestqualityscale' => { 58 => 0xc65c },
	'bestshotmode' => { 55 => 0x3007 },
	'bitdepth' => { 88 => 'BitDepth', 101 => 0x11, 125 => 0x41 },
	'bitspercomponent' => { 66 => 0x87 },
	'bitspersample' => { 58 => 0x102, 210 => 'BitsPerSample' },
	'blacklevel' => { 58 => 0xc61a, 152 => 0x1012 },
	'blacklevel2' => { 151 => 0x600, 155 => 0x600 },
	'blackpoint' => { 174 => 0x200 },
	'bluebalance' => { 152 => 0x1018, 162 => 0x12, 174 => 0x1b },
	'bluecurvelimits' => { 52 => 0x1fe },
	'bluecurvepoints' => { 52 => 0x1d4 },
	'bluehue' => { 197 => 'BlueHue' },
	'bluesaturation' => { 197 => 'BlueSaturation' },
	'blurwarning' => { 62 => 0x1300 },
	'bodyfirmwareversion' => { 148 => 0x104, 149 => 0x100, 152 => 0x104 },
	'bracketmode' => { 22 => 0x3 },
	'bracketsequence' => { 55 => 0x301d },
	'bracketshotnumber' => { 22 => 0x5, 167 => 0x9 },
	'bracketstep' => { 96 => 0xe },
	'bracketvalue' => { 22 => 0x4 },
	'brightness' => { 58 => 0xfe53, 82 => 'Brightness', 96 => 0x2c, 122 => 0x34, 197 => 'Brightness' },
	'brightnessadj' => { 52 => 0x114, 133 => 0x0, 143 => 0x2d },
	'brightnessvalue' => { 58 => 0x9203, 152 => 0x1003, 200 => 'BrightnessValue' },
	'bulbduration' => { 32 => 0x18 },
	'burstmode' => { 70 => 0xa, 161 => 0x2a },
	'burstmode2' => { 70 => 0x18 },
	'buttonfunctioncontroloff' => { 35 => 0x70a },
	'bwfilter' => { 96 => 0x2a, 102 => 0x39 },
	'bwmode' => { 152 => 0x203 },
	'by-line' => { 64 => 0x50 },
	'by-linetitle' => { 64 => 0x55 },
	'bytecount' => { 206 => 'byteCount' },
	'calibrationilluminant1' => { 58 => 0xc65a },
	'calibrationilluminant2' => { 58 => 0xc65b },
	'cameracalibrationsig' => { 58 => 0xc6f3 },
	'cameraid' => { 152 => 0x209, 185 => 0x209 },
	'cameraiso' => { 13 => 0x10 },
	'cameraorientation' => { 2 => 0x30, 7 => 0x30, 8 => 0x30, 9 => 0x31, 10 => 0x27, 11 => 0x31 },
	'cameraparameters' => { 152 => 0x2050 },
	'cameraprofile' => { 197 => 'CameraProfile' },
	'cameraprofiledigest' => { 197 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 58 => 0xc62f, 193 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 147 => 0x0 },
	'cameratemperature' => { 2 => 0x18, 5 => 0x18, 7 => 0x18, 8 => 0x18, 9 => 0x19, 11 => 0x19, 159 => 0x320, 174 => 0x47 },
	'cameratype' => { 32 => 0x1a, 152 => 0x207 },
	'cameratype2' => { 148 => 0x100 },
	'canonexposuremode' => { 13 => 0x14 },
	'canonfiledescription' => { 48 => 0x805 },
	'canonfilelength' => { 25 => 0xe },
	'canonfirmwareversion' => { 25 => 0x7, 48 => 0x80b },
	'canonflashinfo' => { 48 => 0x1028 },
	'canonflashmode' => { 13 => 0x4 },
	'canonimagesize' => { 4 => 0x39, 13 => 0xa },
	'canonimagetype' => { 25 => 0x6, 48 => 0x815 },
	'canonmodelid' => { 25 => 0x10, 48 => 0x1834 },
	'canonvrd' => { 59 => 'CanonVRD' },
	'caption-abstract' => { 64 => 0x78 },
	'captionwriter' => { 204 => 'CaptionWriter' },
	'casioimagesize' => { 55 => 0x9 },
	'catalogsets' => { 192 => 'CatalogSets' },
	'categories' => { 25 => 0x23 },
	'category' => { 64 => 0xf, 204 => 'Category' },
	'ccdboardversion' => { 159 => 0x331 },
	'ccdscanmode' => { 152 => 0x1039 },
	'ccdsensitivity' => { 130 => 0x6 },
	'ccdversion' => { 159 => 0x330 },
	'celllength' => { 58 => 0x109 },
	'cellwidth' => { 58 => 0x108 },
	'centerafarea' => { 129 => '763.1' },
	'centerweightedareasize' => { 127 => '797.1', 129 => '754.3' },
	'certificate' => { 218 => 'Certificate' },
	'cfapattern' => { 58 => 0xa302 },
	'cfapatterncolumns' => { 200 => 'CFAPatternColumns' },
	'cfapatternrows' => { 200 => 'CFAPatternRows' },
	'cfapatternvalues' => { 200 => 'CFAPatternValues' },
	'channel' => { 206 => 'channel' },
	'channels' => { 81 => 'Channels' },
	'checkmark' => { 52 => 0x26a },
	'childfontfiles' => { 219 => 'FontsChildFontFiles' },
	'chromablurradius' => { 58 => 0xc631 },
	'chromaticaberration' => { 53 => 0x66 },
	'chromaticaberrationb' => { 197 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 53 => 0x6b },
	'chromaticaberrationon' => { 53 => 0x62 },
	'chromaticaberrationr' => { 197 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 53 => 0x6a },
	'chrominancenoisereduction' => { 53 => 0x5e },
	'chrominancenr_tiff_jpeg' => { 53 => 0x60 },
	'city' => { 64 => 0x5a, 87 => 'City', 204 => 'City' },
	'clarity' => { 197 => 'Clarity' },
	'classifystate' => { 64 => 0xe1 },
	'clmodeshootingspeed' => { 127 => '800.2' },
	'cmcontrast' => { 155 => 0x2022 },
	'cmexposurecompensation' => { 155 => 0x2000 },
	'cmhue' => { 155 => 0x2021 },
	'cmsaturation' => { 155 => 0x2020 },
	'cmsharpness' => { 155 => 0x2023 },
	'cmwhitebalance' => { 155 => 0x2001 },
	'cmwhitebalancecomp' => { 155 => 0x2002 },
	'cmwhitebalancegraypoint' => { 155 => 0x2010 },
	'codec' => { 95 => 'Codec' },
	'codedcharacterset' => { 65 => 0x5a },
	'coloraberrationcontrol' => { 140 => 0xc89224b },
	'coloradjustment' => { 186 => 0x14 },
	'coloradjustmentmode' => { 185 => 0x210 },
	'coloranta' => { 219 => 'ColorantsA' },
	'colorantb' => { 219 => 'ColorantsB' },
	'colorantblack' => { 219 => 'ColorantsBlack' },
	'colorantblue' => { 219 => 'ColorantsBlue' },
	'colorantcyan' => { 219 => 'ColorantsCyan' },
	'colorantgreen' => { 219 => 'ColorantsGreen' },
	'colorantl' => { 219 => 'ColorantsL' },
	'colorantmagenta' => { 219 => 'ColorantsMagenta' },
	'colorantmode' => { 219 => 'ColorantsMode' },
	'colorantred' => { 219 => 'ColorantsRed' },
	'colorantswatchname' => { 219 => 'ColorantsSwatchName' },
	'coloranttype' => { 219 => 'ColorantsType' },
	'colorantyellow' => { 219 => 'ColorantsYellow' },
	'colorbalance' => { 82 => 'ColorBalance' },
	'colorbalance1' => { 120 => 0xc },
	'colorbalanceadj' => { 140 => 0x76a43202 },
	'colorbalanceblue' => { 96 => 0x1e },
	'colorbalancegreen' => { 96 => 0x1d },
	'colorbalancered' => { 96 => 0x1c },
	'colorblur' => { 53 => 0x65 },
	'colorbooster' => { 140 => 0x5f0e7d23 },
	'colorboostlevel' => { 134 => 0x1 },
	'colorboosttype' => { 134 => 0x0 },
	'colorclass' => { 177 => 0xde },
	'colorcontrol' => { 152 => 0x102b },
	'coloreffect' => { 161 => 0x28 },
	'colorfilter' => { 54 => 0x17, 96 => 0x29, 102 => 0x38, 176 => 0x17 },
	'colorgain' => { 125 => 0x51 },
	'colorhue' => { 120 => 0x8d },
	'colorimetricreference' => { 58 => 0xc6bf },
	'colormatrix' => { 151 => 0x200, 152 => 0x1011 },
	'colormatrix2' => { 155 => 0x200 },
	'colormatrixa' => { 174 => 0x203 },
	'colormatrixb' => { 174 => 0x204 },
	'colormatrixnumber' => { 152 => 0x1019 },
	'colormode' => { 55 => 0x3015, 62 => 0x1210, 70 => 0x66, 96 => 0x28, 99 => 0x16, 100 => 0x101, 102 => 0x7, 120 => 0x3, 130 => 0x4, 152 => 0x101, 161 => 0x32, 187 => 0xb029, 204 => 'ColorMode' },
	'colormoirereduction' => { 141 => 0x15 },
	'colormoirereductionmode' => { 141 => 0x5 },
	'colornoisereduction' => { 197 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 141 => 0x18 },
	'colornoisereductionsharpness' => { 141 => 0x1c },
	'colorplanes' => { 61 => 0x2 },
	'colorprofile' => { 96 => 0x33 },
	'colorrepresentation' => { 66 => 0x3c },
	'colorreproduction' => { 187 => 0xb020 },
	'colorsequence' => { 66 => 0x41 },
	'colorspace' => { 19 => 0x3, 25 => 0xb4, 48 => 0x10b4, 58 => 0xa001, 88 => 'ColorSpace', 97 => 0x2f, 98 => 0x25, 120 => 0x1e, 147 => 0x507, 174 => 0x37, 186 => 0xb, 200 => 'ColorSpace' },
	'colortempasshot' => { 15 => 0x1d, 16 => 0x26, 17 => 0x43, 18 => 0x43 },
	'colortempauto' => { 15 => 0x22, 16 => 0x1c, 17 => 0x48, 18 => 0x48 },
	'colortempcloudy' => { 15 => 0x31, 16 => 0x35, 17 => 0x5c, 18 => 0x61 },
	'colortempcustom' => { 17 => 0x84 },
	'colortempcustom1' => { 15 => 0x45 },
	'colortempcustom2' => { 15 => 0x4a },
	'colortempdaylight' => { 15 => 0x27, 16 => 0x2b, 17 => 0x52, 18 => 0x57 },
	'colortemperature' => { 2 => 0x73, 3 => [0x48,0x4e], 4 => 0x37, 5 => 0x62, 6 => 0x37, 7 => 0x73, 8 => 0x73, 9 => 0x73, 10 => 0x58, 11 => 0x73, 25 => 0xae, 30 => 0x9, 48 => 0x10ae, 62 => 0x1005, 69 => 0x846, 82 => 'ColorTemperature', 97 => [0x6e,0x49], 98 => 0x3f, 99 => 0x5e, 100 => 0x10b, 102 => 0x3c, 159 => 0x321, 174 => 0x50, 187 => 0xb021 },
	'colortemperaturebg' => { 152 => 0x1013 },
	'colortemperaturerg' => { 152 => 0x1014 },
	'colortempflash' => { 15 => 0x40, 16 => 0x49, 17 => 0x70, 18 => 0x75 },
	'colortempfluorescent' => { 15 => 0x3b, 16 => 0x3f, 17 => 0x66, 18 => 0x6b },
	'colortempkelvin' => { 16 => 0x44, 17 => 0x6b, 18 => 0x70 },
	'colortempmeasured' => { 17 => 0x4d, 18 => 0x4d },
	'colortemppc1' => { 16 => 0x94, 17 => 0x75 },
	'colortemppc2' => { 16 => 0x99, 17 => 0x7a },
	'colortemppc3' => { 16 => 0x9e, 17 => 0x7f },
	'colortempshade' => { 15 => 0x2c, 16 => 0x30, 17 => 0x57, 18 => 0x5c },
	'colortemptungsten' => { 15 => 0x36, 16 => 0x3a, 17 => 0x61, 18 => 0x66 },
	'colortempunknown' => { 16 => 0x21, 18 => 0x52 },
	'colortempunknown10' => { 16 => 0x76, 18 => 0xa2 },
	'colortempunknown11' => { 16 => 0x7b, 18 => 0xa7 },
	'colortempunknown12' => { 16 => 0x80 },
	'colortempunknown13' => { 16 => 0x85 },
	'colortempunknown14' => { 16 => 0x8a },
	'colortempunknown15' => { 16 => 0x8f },
	'colortempunknown16' => { 16 => 0xa3 },
	'colortempunknown2' => { 16 => 0x4e, 18 => 0x7a },
	'colortempunknown3' => { 16 => 0x53, 18 => 0x7f },
	'colortempunknown4' => { 16 => 0x58, 18 => 0x84 },
	'colortempunknown5' => { 16 => 0x5d, 18 => 0x89 },
	'colortempunknown6' => { 16 => 0x62, 18 => 0x8e },
	'colortempunknown7' => { 16 => 0x67, 18 => 0x93 },
	'colortempunknown8' => { 16 => 0x6c, 18 => 0x98 },
	'colortempunknown9' => { 16 => 0x71, 18 => 0x9d },
	'colortone' => { 4 => 0x6f, 6 => 0x77, 13 => 0x2a, 19 => 0x2 },
	'colortoneadj' => { 52 => 0x11e },
	'colortonefaithful' => { 10 => 0x107 },
	'colortonelandscape' => { 10 => 0x105 },
	'colortoneneutral' => { 10 => 0x106 },
	'colortoneportrait' => { 10 => 0x104 },
	'colortonestandard' => { 10 => 0x103 },
	'colortoneuserdef1' => { 10 => 0x109 },
	'colortoneuserdef2' => { 10 => 0x10a },
	'colortoneuserdef3' => { 10 => 0x10b },
	'commanddials' => { 129 => '753.1' },
	'commanddialsaperturesetting' => { 127 => '807.3' },
	'commanddialschangemainsub' => { 127 => '807.2' },
	'commanddialsmenuandplayback' => { 127 => '807.4' },
	'commanddialsreverserotation' => { 127 => '807.1' },
	'commanderchannel' => { 129 => '758.2' },
	'commandergroupa_manualoutput' => { 129 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 129 => '761.1' },
	'commandergroupamode' => { 129 => '759.2' },
	'commandergroupb_manualoutput' => { 129 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 129 => '762.1' },
	'commandergroupbmode' => { 129 => '759.3' },
	'commanderinternalflash' => { 129 => '759.1' },
	'commanderinternalmanualoutput' => { 129 => '760.2' },
	'commanderinternalttlcomp' => { 129 => '760.1' },
	'comment' => { 0 => 0x2, 59 => 'Comment', 83 => 'Comment', 158 => 'Comment' },
	'complianceprofile' => { 206 => 'complianceProfile' },
	'componentsconfiguration' => { 58 => 0x9101, 88 => 'Components', 200 => 'ComponentsConfiguration' },
	'componentversion' => { 48 => 0x80c },
	'composer' => { 214 => 'composer' },
	'compressedbitsperpixel' => { 58 => 0x9102, 200 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 100 => 0x40, 152 => 0x40 },
	'compression' => { 58 => 0x103, 210 => 'Compression' },
	'compressionfactor' => { 147 => 0x50d },
	'compressionratio' => { 88 => 'Compression', 152 => 0x1034 },
	'constrainedcropheight' => { 52 => 0x266, 177 => 0xd6 },
	'constrainedcropwidth' => { 52 => 0x262, 177 => 0xd5 },
	'contact' => { 64 => 0x76 },
	'contentlocationcode' => { 64 => 0x1a },
	'contentlocationname' => { 64 => 0x1b },
	'continuousdrive' => { 13 => 0x5 },
	'continuousshootingspeed' => { 35 => 0x610 },
	'continuousshotlimit' => { 35 => 0x611 },
	'contrast' => { 4 => 0x73, 6 => 0x75, 13 => 0xd, 54 => 0xc, 55 => [0x3012,0x20], 58 => [0xa408,0xfe54], 62 => [0x1004,0x1006], 82 => 'Contrast', 96 => 0x20, 97 => 0x31, 98 => 0x27, 99 => 0x19, 102 => 0x2, 122 => 0x33, 152 => 0x1029, 161 => [0x2c,0x39], 174 => 0x20, 176 => 0xc, 186 => 0xd, 197 => 'Contrast', 200 => 'Contrast' },
	'contrastadj' => { 52 => 0x115, 143 => 0x2c },
	'contrastfaithful' => { 10 => 0xec },
	'contrastlandscape' => { 10 => 0xea },
	'contrastmonochrome' => { 10 => 0xed },
	'contrastneutral' => { 10 => 0xeb },
	'contrastportrait' => { 10 => 0xe9 },
	'contrastsetting' => { 147 => 0x505, 155 => 0x1012 },
	'contraststandard' => { 10 => 0xe8 },
	'contrastuserdef1' => { 10 => 0xee },
	'contrastuserdef2' => { 10 => 0xef },
	'contrastuserdef3' => { 10 => 0xf0 },
	'contributedmediadurationscale' => { 214 => 'contributedMediaDurationScale' },
	'contributedmediadurationvalue' => { 214 => 'contributedMediaDurationValue' },
	'contributedmediamanaged' => { 214 => 'contributedMediaManaged' },
	'contributedmediapath' => { 214 => 'contributedMediaPath' },
	'contributedmediastarttimescale' => { 214 => 'contributedMediaStartTimeScale' },
	'contributedmediastarttimevalue' => { 214 => 'contributedMediaStartTimeValue' },
	'contributedmediatrack' => { 214 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 214 => 'contributedMediaWebStatement' },
	'contributor' => { 198 => 'contributor' },
	'contributors' => { 83 => 'Contributors' },
	'controlledvocabularyterm' => { 202 => 'CVterm' },
	'controllerboardversion' => { 159 => 0x332 },
	'controlmode' => { 32 => 0x12 },
	'conversionlens' => { 161 => 0x35 },
	'converter' => { 58 => 0xfe4d, 130 => 0xb, 197 => 'Converter' },
	'converttograyscale' => { 197 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 58 => 0x8298, 83 => 'Copyright', 158 => 'Copyright', 182 => 'Copyright', 203 => 'Copyright', 206 => 'copyright', 208 => 'copyright', 210 => 'Copyright', 214 => 'copyright' },
	'copyrightflag' => { 180 => 0x40a },
	'copyrightnotice' => { 64 => 0x74 },
	'copyrightownerid' => { 205 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 205 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 205 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 205 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 205 => 'CopyrightStatus' },
	'coringfilter' => { 151 => 0x310, 152 => 0x102d, 155 => 0x310 },
	'coringvalues' => { 151 => 0x311, 155 => 0x311 },
	'corporateentity' => { 206 => 'corporateEntity' },
	'country' => { 87 => 'Country', 204 => 'Country' },
	'country-primarylocationcode' => { 64 => 0x64 },
	'country-primarylocationname' => { 64 => 0x65 },
	'countrycode' => { 178 => 'CountryCode', 201 => 'CountryCode' },
	'coverage' => { 198 => 'coverage' },
	'coverdate' => { 206 => 'coverDate' },
	'coverdisplaydate' => { 206 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 174 => 0x28 },
	'crc32' => { 199 => 'crc32' },
	'createdate' => { 58 => 0x9004, 83 => 'CreateDate', 156 => 'CreationDate', 182 => 'CreationDate', 212 => 'CreateDate' },
	'creationdate' => { 203 => 'CreationDate', 206 => 'creationDate' },
	'creationtime' => { 158 => 'Creation Time' },
	'creator' => { 156 => 'Creator', 182 => 'Creator', 198 => 'creator', 203 => 'Creator' },
	'creatoraddress' => { 201 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcity' => { 201 => 'CreatorContactInfoCiAdrCity' },
	'creatorcountry' => { 201 => 'CreatorContactInfoCiAdrCtry' },
	'creatorpostalcode' => { 201 => 'CreatorContactInfoCiAdrPcode' },
	'creatorregion' => { 201 => 'CreatorContactInfoCiAdrRegion' },
	'creatortool' => { 212 => 'CreatorTool' },
	'creatorworkemail' => { 201 => 'CreatorContactInfoCiEmailWork' },
	'creatorworktelephone' => { 201 => 'CreatorContactInfoCiTelWork' },
	'creatorworkurl' => { 201 => 'CreatorContactInfoCiUrlWork' },
	'credit' => { 64 => 0x6e, 204 => 'Credit' },
	'creditline' => { 208 => 'creditLine' },
	'creditlinereq' => { 217 => 'CreditLineReq' },
	'creditlinerequired' => { 205 => 'CreditLineRequired' },
	'cropactive' => { 52 => 0x244 },
	'cropangle' => { 197 => 'CropAngle' },
	'cropaspectratio' => { 52 => 0x260 },
	'cropbottom' => { 61 => 0x9, 135 => 0x36, 177 => 0xdc, 197 => 'CropBottom' },
	'cropheight' => { 52 => 0x24c, 151 => 0x615, 155 => 0x615, 197 => 'CropHeight' },
	'crophispeed' => { 120 => 0x1b },
	'cropleft' => { 52 => 0x246, 61 => 0x6, 135 => 0x1e, 151 => 0x612, 155 => 0x612, 177 => 0xd9, 197 => 'CropLeft' },
	'cropoutputheight' => { 135 => 0xce },
	'cropoutputheightinches' => { 135 => 0x96 },
	'cropoutputpixels' => { 135 => 0xd6 },
	'cropoutputresolution' => { 135 => 0xb6 },
	'cropoutputscale' => { 135 => 0xbe },
	'cropoutputwidth' => { 135 => 0xc6 },
	'cropoutputwidthinches' => { 135 => 0x8e },
	'cropright' => { 61 => 0x8, 135 => 0x2e, 177 => 0xdb, 197 => 'CropRight' },
	'croprotation' => { 61 => 0xb },
	'cropscaledresolution' => { 135 => 0x9e },
	'cropsourceresolution' => { 135 => 0xae },
	'croptop' => { 52 => 0x248, 61 => 0x7, 135 => 0x26, 151 => 0x613, 155 => 0x613, 177 => 0xda, 197 => 'CropTop' },
	'cropunit' => { 197 => 'CropUnit' },
	'cropunits' => { 197 => 'CropUnits' },
	'cropwidth' => { 52 => 0x24a, 151 => 0x614, 155 => 0x614, 197 => 'CropWidth' },
	'currenticcprofile' => { 58 => 0xc691 },
	'currentpreprofilematrix' => { 58 => 0xc692 },
	'curves' => { 140 => 0x76a43201 },
	'custom1' => { 205 => 'Custom1' },
	'custom10' => { 205 => 'Custom10' },
	'custom2' => { 205 => 'Custom2' },
	'custom3' => { 205 => 'Custom3' },
	'custom4' => { 205 => 'Custom4' },
	'custom5' => { 205 => 'Custom5' },
	'custom6' => { 205 => 'Custom6' },
	'custom7' => { 205 => 'Custom7' },
	'custom8' => { 205 => 'Custom8' },
	'custom9' => { 205 => 'Custom9' },
	'customrendered' => { 58 => 0xa401, 200 => 'CustomRendered' },
	'customsaturation' => { 147 => 0x503 },
	'd-lightinghq' => { 140 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 136 => 0x2 },
	'd-lightinghqhighlight' => { 136 => 0x1 },
	'd-lightinghqselected' => { 140 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 136 => 0x0 },
	'd-lightinghs' => { 140 => 0xce5554aa },
	'd-lightinghsadjustment' => { 137 => 0x0 },
	'd-lightinghscolorboost' => { 137 => 0x1 },
	'datacompressionmethod' => { 66 => 0x6e },
	'dataimprint' => { 96 => 0x34 },
	'date' => { 174 => 0x6, 198 => 'date' },
	'dateacquired' => { 193 => 'DateAcquired' },
	'datecreated' => { 64 => 0x37, 204 => 'DateCreated' },
	'datedisplayformat' => { 132 => 0x3 },
	'daterecieved' => { 206 => 'dateRecieved' },
	'datesent' => { 65 => 0x46 },
	'datestampmode' => { 25 => 0x1c },
	'datetime' => { 210 => 'DateTime' },
	'datetimedigitized' => { 200 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 51 => 0x0, 58 => 0x9003, 80 => 0x14, 83 => 'OriginalDate', 200 => 'DateTimeOriginal' },
	'datetimestamp' => { 70 => 0x64 },
	'daylightsavings' => { 132 => 0x2 },
	'declination' => { 91 => 'Declination' },
	'decposition' => { 96 => 0x32 },
	'defaultcroporigin' => { 58 => 0xc61f },
	'defaultcropsize' => { 58 => 0xc620 },
	'defaultscale' => { 58 => 0xc61e },
	'defringe' => { 197 => 'Defringe' },
	'deletedimagecount' => { 120 => 0xa6, 126 => 0x6e },
	'derivedfromalternatepaths' => { 215 => 'DerivedFromAlternatePaths' },
	'derivedfromdocumentid' => { 215 => 'DerivedFromDocumentID' },
	'derivedfromfilepath' => { 215 => 'DerivedFromFilePath' },
	'derivedfromfrompart' => { 215 => 'DerivedFromFromPart' },
	'derivedfrominstanceid' => { 215 => 'DerivedFromInstanceID' },
	'derivedfromlastmodifydate' => { 215 => 'DerivedFromLastModifyDate' },
	'derivedfrommanager' => { 215 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 215 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 215 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 215 => 'DerivedFromManageUI' },
	'derivedfrommaskmarkers' => { 215 => 'DerivedFromMaskMarkers' },
	'derivedfrompartmapping' => { 215 => 'DerivedFromPartMapping' },
	'derivedfromrenditionclass' => { 215 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 215 => 'DerivedFromRenditionParams' },
	'derivedfromtopart' => { 215 => 'DerivedFromToPart' },
	'derivedfromversionid' => { 215 => 'DerivedFromVersionID' },
	'description' => { 158 => 'Description', 198 => 'description' },
	'destination' => { 65 => 0x5 },
	'destinationcity' => { 174 => 0x24 },
	'destinationcitycode' => { 176 => 0x1001 },
	'destinationdst' => { 174 => 0x26 },
	'developmentdynamicrange' => { 62 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 200 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 200 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 200 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 35 => 0x706 },
	'digitalcreationdate' => { 64 => 0x3e },
	'digitalcreationtime' => { 64 => 0x3f },
	'digitaldeehighlightadj' => { 125 => 0x202 },
	'digitaldeeshadowadj' => { 125 => 0x200 },
	'digitaldeethreshold' => { 125 => 0x201 },
	'digitalgain' => { 30 => 0xb },
	'digitalgem' => { 115 => 0x0 },
	'digitalice' => { 125 => 0x100 },
	'digitalimageguid' => { 202 => 'DigImageGUID' },
	'digitalroc' => { 124 => 0x0 },
	'digitalsourcefiletype' => { 202 => 'DigitalSourcefileType' },
	'digitalzoom' => { 13 => 0xc, 54 => 0xa, 70 => 0x68, 82 => 'DigitalZoom', 96 => 0xc, 120 => 0x86, 130 => 0xa, 152 => 0x204, 174 => 0x1e, 176 => 0xa, 185 => 0x204 },
	'digitalzoomon' => { 185 => 0x21b },
	'digitalzoomratio' => { 58 => 0xa404, 200 => 'DigitalZoomRatio' },
	'directory' => { 59 => 'Directory' },
	'directoryindex' => { 2 => 0x137, 5 => 0x17e, 7 => 0x13f, 8 => 0x133, 9 => [0x1a3,0x1a7], 11 => [0x1a3,0x1c7] },
	'directorynumber' => { 111 => 0x6 },
	'disclaimer' => { 158 => 'Disclaimer' },
	'displayaperture' => { 13 => 0x23 },
	'displayedunitsx' => { 181 => 0x2 },
	'displayedunitsy' => { 181 => 0x6 },
	'distance1' => { 70 => 0x28 },
	'distance2' => { 70 => 0x2c },
	'distance3' => { 70 => 0x30 },
	'distance4' => { 70 => 0x34 },
	'distortioncorrection' => { 53 => 0x67, 147 => 0x50b },
	'distortioncorrection2' => { 151 => 0x1011 },
	'distortioncorrectionon' => { 53 => 0x63 },
	'distributor' => { 206 => 'distributor' },
	'dngbackwardversion' => { 58 => 0xc613 },
	'dnglensinfo' => { 58 => 0xc630 },
	'dngversion' => { 58 => 0xc612 },
	'document' => { 158 => 'Document' },
	'documenthistory' => { 64 => 0xe7 },
	'documentid' => { 215 => 'DocumentID' },
	'documentname' => { 58 => 0x10d },
	'documentnotes' => { 64 => 0xe6 },
	'doi' => { 206 => 'doi' },
	'dotrange' => { 58 => 0x150 },
	'drivemode' => { 96 => 0x6, 99 => 0x1e, 147 => 0x600, 174 => 0x34, 186 => 0x3 },
	'drivemode2' => { 167 => 0x7 },
	'dspfirmwareversion' => { 174 => 0x27 },
	'duration' => { 81 => 'Duration', 95 => 'Duration' },
	'durationscale' => { 214 => 'durationScale' },
	'durationvalue' => { 214 => 'durationValue' },
	'dynamicafarea' => { 127 => '791.4' },
	'dynamicrange' => { 62 => 0x1400 },
	'dynamicrangeexpansion' => { 174 => 0x69 },
	'dynamicrangemax' => { 52 => 0x7c },
	'dynamicrangemin' => { 52 => 0x7a },
	'dynamicrangeoptimizer' => { 187 => 0xb025 },
	'dynamicrangesetting' => { 62 => 0x1402 },
	'e-dialinprogram' => { 167 => '1.3' },
	'easyexposurecompensation' => { 127 => '796.4' },
	'easymode' => { 13 => 0xb },
	'edgenoisereduction' => { 141 => 0x4 },
	'edition' => { 206 => 'edition' },
	'editorialupdate' => { 64 => 0x8 },
	'editstatus' => { 64 => 0x7, 178 => 'EditStatus' },
	'effectivelv' => { 174 => 0x2d },
	'effectivemaxaperture' => { 118 => 0x12, 119 => 0x13 },
	'eissn' => { 206 => 'eIssn' },
	'elevation' => { 91 => 'Elevation' },
	'email' => { 83 => 'EMail' },
	'embargodate' => { 206 => 'embargoDate', 208 => 'embargoDate' },
	'endingpage' => { 206 => 'endingPage' },
	'enduserid' => { 205 => 'EndUserEndUserID' },
	'endusername' => { 205 => 'EndUserEndUserName' },
	'engineer' => { 214 => 'engineer' },
	'enhancedarktones' => { 133 => 0x8 },
	'enhancement' => { 54 => 0x16, 55 => 0x3016 },
	'enhancer' => { 151 => 0x300 },
	'enhancervalues' => { 151 => 0x301 },
	'envelopenumber' => { 65 => 0x28 },
	'envelopepriority' => { 65 => 0x3c },
	'enveloperecordversion' => { 65 => 0x0 },
	'epsonimageheight' => { 152 => 0x20c },
	'epsonimagewidth' => { 152 => 0x20b },
	'epsonsoftware' => { 152 => 0x20d },
	'equipmentinstitution' => { 189 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 189 => 'EquipmentManufacturer' },
	'equipmentversion' => { 148 => 0x0 },
	'ettlii' => { 35 => 0x304, 36 => 0xd, 37 => 0xe, 38 => 0x7, 39 => 0x7, 40 => 0xe },
	'event' => { 192 => 'Event', 202 => 'Event', 206 => 'event' },
	'evsteps' => { 167 => '1.2', 169 => 0x0 },
	'evstepsize' => { 129 => '748.7' },
	'exclusivityenddate' => { 208 => 'exclusivityEndDate' },
	'excursiontolerance' => { 66 => 0x82 },
	'exif' => { 59 => 'EXIF' },
	'exifbyteorder' => { 59 => 'ExifByteOrder' },
	'exifcamerainfo' => { 64 => 0xe8 },
	'exifimageheight' => { 58 => 0xa003, 200 => 'PixelYDimension' },
	'exifimagewidth' => { 58 => 0xa002, 200 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 59 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 58 => 0x9000, 200 => 'ExifVersion' },
	'exitpupilposition' => { 118 => 0x4, 119 => 0x4 },
	'expirationdate' => { 64 => 0x25, 206 => 'expirationDate', 208 => 'expirationDate' },
	'expirationtime' => { 64 => 0x26 },
	'exposure' => { 58 => 0xfe51, 197 => 'Exposure' },
	'exposureadj' => { 138 => 0x0 },
	'exposureadj2' => { 138 => 0x12 },
	'exposurebracketstepsize' => { 167 => 0x8 },
	'exposurebracketvalue' => { 120 => 0x19 },
	'exposurecompensation' => { 32 => 0x6, 44 => 0x0, 58 => 0x9204, 70 => 0x24, 82 => 'ExposureComp', 96 => 0xd, 97 => 0x53, 98 => 0x1e, 99 => 0x1, 152 => 0x1006, 174 => 0x16, 186 => [0xc,0x35], 200 => 'ExposureBiasValue' },
	'exposurecontrolstepsize' => { 127 => '796.2' },
	'exposuredelaymode' => { 127 => '800.1', 129 => '754.4' },
	'exposuredifference' => { 120 => 0xe },
	'exposureindex' => { 58 => 0xa215, 200 => 'ExposureIndex' },
	'exposurelevelincrements' => { 33 => 0x6, 34 => 0x6, 35 => 0x101, 36 => 0x5, 37 => 0x6, 38 => 0x5, 39 => 0x5, 40 => 0x6, 41 => 0x4 },
	'exposuremode' => { 58 => 0xa402, 82 => 'ExposureMode', 96 => 0x1, 97 => 0xa, 98 => 0x0, 99 => 0x0, 147 => 0x200, 186 => 0x8, 187 => 0xb041, 200 => 'ExposureMode' },
	'exposuremodeinmanual' => { 35 => 0x10b },
	'exposureprogram' => { 58 => 0x8822, 200 => 'ExposureProgram' },
	'exposuretime' => { 2 => 0x4, 3 => 0x4, 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x6, 32 => 0x16, 58 => 0x829a, 68 => 0xfd05, 70 => 0x20, 71 => 0xfa24, 73 => 0xf104, 77 => 0x38, 80 => 0x10, 82 => 'ExposureTime', 96 => 0x9, 97 => 0x35, 98 => 0x48, 174 => 0x12, 186 => 0x32, 200 => 'ExposureTime' },
	'exposuretime2' => { 186 => 0x33 },
	'exposurevalue' => { 69 => 0x3 },
	'exposurewarning' => { 62 => 0x1302 },
	'extendedwbdetect' => { 147 => 0x902 },
	'extender' => { 148 => 0x301 },
	'extenderfirmwareversion' => { 148 => 0x304 },
	'extendermagnification' => { 84 => 'Magnification' },
	'extendermake' => { 84 => 'Make' },
	'extendermodel' => { 84 => 'Model', 148 => 0x303 },
	'extenderserialnumber' => { 84 => 'SerialNumber', 148 => 0x302 },
	'externalflash' => { 150 => 0x1201 },
	'externalflashae1' => { 152 => 0x101f },
	'externalflashae1_0' => { 152 => 0x101b },
	'externalflashae2' => { 152 => 0x1020 },
	'externalflashae2_0' => { 152 => 0x101c },
	'externalflashbounce' => { 150 => 0x1204, 152 => 0x1026, 170 => 0x1a },
	'externalflashexposurecomp' => { 170 => 0x19 },
	'externalflashflags' => { 112 => 0x8, 113 => 0x8, 114 => 0x8 },
	'externalflashguidenumber' => { 150 => 0x1203, 170 => '24.1' },
	'externalflashgvalue' => { 152 => 0x1025 },
	'externalflashmode' => { 152 => 0x1028, 170 => 0x2 },
	'externalflashzoom' => { 150 => 0x1205, 152 => 0x1027 },
	'externalsensorbrightnessvalue' => { 159 => 0x311 },
	'face0position' => { 20 => 0x8 },
	'face1position' => { 20 => 0xa },
	'face2position' => { 20 => 0xc },
	'face3position' => { 20 => 0xe },
	'face4position' => { 20 => 0x10 },
	'face5position' => { 20 => 0x12 },
	'face6position' => { 20 => 0x14 },
	'face7position' => { 20 => 0x16 },
	'face8position' => { 20 => 0x18 },
	'facedetect' => { 151 => 0x1200 },
	'facedetectarea' => { 151 => 0x1201 },
	'facedetectframeheight' => { 20 => 0x4 },
	'facedetectframewidth' => { 20 => 0x3 },
	'facesdetected' => { 20 => 0x2, 21 => 0x2 },
	'ffid' => { 199 => 'ffid' },
	'fieldcount' => { 152 => 0x103f },
	'filedatarate' => { 214 => 'fileDataRate' },
	'fileformat' => { 46 => 0x0, 65 => 0x14 },
	'fileindex' => { 2 => 0x143, 5 => 0x172, 7 => 0x133, 8 => 0x13f, 9 => [0x197,0x19b], 11 => [0x197,0x1bb] },
	'filemodifydate' => { 59 => 'FileModifyDate' },
	'filename' => { 59 => 'FileName' },
	'filenameasdelivered' => { 205 => 'FileNameAsDelivered' },
	'filenumber' => { 22 => 0x1, 25 => 0x8, 48 => 0x1817, 111 => 0x8 },
	'filenumbermemory' => { 96 => 0x1a },
	'filenumbersequence' => { 127 => '802.2' },
	'filesource' => { 58 => 0xa300, 62 => 0x8000, 200 => 'FileSource' },
	'fileversion' => { 65 => 0x16 },
	'fillflashautoreduction' => { 33 => 0xe, 34 => 0xe, 41 => 0xa },
	'filllight' => { 197 => 'FillLight' },
	'fillorder' => { 58 => 0x10a },
	'filmmode' => { 62 => 0x1401, 161 => 0x42 },
	'filmtype' => { 125 => 0x2 },
	'filter' => { 55 => 0x3017 },
	'filtereffect' => { 22 => 0xe, 122 => 0x37 },
	'filtereffectmonochrome' => { 10 => 0xff },
	'finderdisplayduringexposure' => { 34 => 0x1 },
	'finetuneoptcenterweighted' => { 127 => '797.2' },
	'finetuneoptmatrixmetering' => { 127 => '798.1' },
	'finetuneoptspotmetering' => { 127 => '798.2' },
	'finetunestepsize' => { 127 => '796.3' },
	'firmware' => { 152 => 0x405, 186 => [0x17,0x3b], 195 => 'Firmware' },
	'firmwaredate' => { 54 => 0x15, 55 => 0x2001 },
	'firmwareid' => { 101 => 0x0 },
	'firmwarerevision' => { 10 => 0xa4, 25 => 0x1e },
	'firmwareversion' => { 2 => 0x10b, 5 => 0x136, 7 => 0xff, 8 => 0x107, 69 => 0xce5, 80 => 0x57, 82 => 'FirmwareVersion', 161 => 0x2 },
	'firstpublicationdate' => { 205 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 64 => 0x16 },
	'flash' => { 58 => 0x9209, 97 => 0x1f, 98 => 0x15 },
	'flashactivity' => { 13 => 0x1c },
	'flashbias' => { 161 => 0x24 },
	'flashbits' => { 13 => 0x1d },
	'flashchargelevel' => { 152 => 0x1010 },
	'flashcommandermode' => { 112 => '9.1', 113 => '9.1', 114 => '9.1' },
	'flashcompensation' => { 195 => 'FlashCompensation' },
	'flashcontrolmode' => { 112 => '9.2', 113 => '9.2', 114 => '9.2' },
	'flashdevice' => { 152 => 0x1005 },
	'flashdistance' => { 55 => 0x2034 },
	'flashenergy' => { 58 => 0xa20b, 200 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 120 => 0x18 },
	'flashexposurecomp' => { 32 => 0xf, 62 => 0x1011, 85 => 'ExposureComp', 96 => 0x23, 100 => 0x104, 112 => 0xa, 113 => 0xa, 114 => 0xa, 120 => 0x12, 147 => 0x401, 152 => 0x1023, 174 => 0x4d, 186 => 0x3a, 187 => 0x104 },
	'flashexposurecompset' => { 163 => 0xe },
	'flashexposurelock' => { 22 => 0x19 },
	'flashfired' => { 70 => 0x5d, 85 => 'Fired', 96 => 0x14, 129 => '590.3', 161 => 0x8007, 200 => 'FlashFired' },
	'flashfiring' => { 35 => 0x306, 36 => 0x6, 37 => 0x7, 40 => 0x7 },
	'flashfirmwareversion' => { 148 => 0x1002 },
	'flashfocallength' => { 112 => 0xb, 113 => 0xc, 114 => 0xc },
	'flashfunction' => { 200 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 112 => 0xf, 113 => '16.1', 114 => '17.1' },
	'flashgroupaexposurecomp' => { 112 => 0x11, 113 => 0x12, 114 => 0x13 },
	'flashgroupaoutput' => { 112 => 0x11, 113 => 0x12, 114 => 0x13 },
	'flashgroupbcontrolmode' => { 112 => 0x10, 113 => '17.1', 114 => '18.1' },
	'flashgroupbexposurecomp' => { 112 => 0x12, 113 => 0x13, 114 => 0x14 },
	'flashgroupboutput' => { 112 => 0x12, 113 => 0x13, 114 => 0x14 },
	'flashgroupccontrolmode' => { 113 => '17.2', 114 => '18.2' },
	'flashgroupcexposurecomp' => { 113 => 0x14, 114 => 0x15 },
	'flashgroupcoutput' => { 113 => 0x14, 114 => 0x15 },
	'flashguidenumber' => { 32 => 0xd, 45 => 0x0, 85 => 'GuideNumber' },
	'flashintensity' => { 54 => [0x19,0x5] },
	'flashlevel' => { 128 => 0x2e2 },
	'flashmake' => { 85 => 'Make' },
	'flashmanufacturer' => { 193 => 'FlashManufacturer' },
	'flashmetering' => { 96 => 0x3f },
	'flashmeteringsegments' => { 174 => 0x20a },
	'flashmode' => { 54 => 0x4, 70 => 0x5c, 85 => 'Mode', 96 => 0x2, 97 => 0x20, 98 => 0x16, 120 => 0x87, 147 => 0x400, 152 => 0x1004, 174 => 0xc, 176 => 0x4, 183 => 0x20, 185 => 0x225, 200 => 'FlashMode' },
	'flashmodel' => { 85 => 'Model', 112 => 0x4, 113 => 0x4, 114 => 0x4, 148 => 0x1001, 193 => 'FlashModel' },
	'flashoptions' => { 167 => 0x2 },
	'flashoptions2' => { 167 => 0x10 },
	'flashoutput' => { 32 => 0x21, 112 => 0xa, 113 => 0xa, 114 => 0xa },
	'flashpixversion' => { 58 => 0xa000, 200 => 'FlashpixVersion' },
	'flashredeyemode' => { 200 => 'FlashRedEyeMode' },
	'flashreturn' => { 200 => 'FlashReturn' },
	'flashserialnumber' => { 85 => 'SerialNumber', 148 => 0x1003 },
	'flashsetting' => { 120 => 0x8 },
	'flashshutterspeed' => { 127 => '810.2', 129 => '755.2' },
	'flashstatus' => { 170 => 0x0 },
	'flashsyncspeed' => { 127 => '810.1' },
	'flashsyncspeedav' => { 33 => 0x3, 35 => 0x10f, 36 => 0x2, 37 => 0x3, 38 => 0x2, 39 => 0x2, 40 => 0x3, 41 => 0x6 },
	'flashthreshold' => { 45 => 0x1 },
	'flashtype' => { 85 => 'Type', 120 => 0x9, 148 => 0x1000 },
	'flashwarning' => { 129 => '755.1' },
	'flickerreduce' => { 185 => 0x218 },
	'fliphorizontal' => { 140 => 0x76a43206 },
	'fnumber' => { 2 => 0x3, 5 => 0x3, 7 => 0x3, 8 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x5, 32 => 0x15, 58 => 0x829d, 68 => 0xfd04, 70 => 0x1e, 71 => 0xfa23, 73 => 0xf103, 77 => 0x3c, 80 => 0xc, 89 => 'FNumber', 96 => 0xa, 97 => 0x36, 98 => 0x47, 174 => 0x13, 186 => 0x31, 200 => 'FNumber' },
	'focallength' => { 2 => 0x1d, 3 => 0xa, 4 => 0x9, 5 => 0x1d, 6 => 0x9, 7 => 0x1d, 8 => 0x1d, 9 => 0x1e, 10 => 0x28, 11 => 0x1e, 24 => 0x1, 55 => 0x1d, 58 => 0x920a, 89 => 'FocalLength', 96 => 0x12, 118 => 0xa, 119 => 0xb, 171 => 0x9, 174 => 0x1d, 200 => 'FocalLength' },
	'focallengthin35mmformat' => { 58 => 0xa405, 200 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 148 => 0x103, 152 => 0x205 },
	'focalplaneresolutionunit' => { 58 => 0xa210, 200 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 58 => 0xa20e, 200 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 24 => 0x2 },
	'focalplanexunknown' => { 24 => 0x2 },
	'focalplaneyresolution' => { 58 => 0xa20f, 200 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 24 => 0x3 },
	'focalplaneyunknown' => { 24 => 0x3 },
	'focaltype' => { 4 => 0x2d, 24 => 0x0 },
	'focalunits' => { 13 => 0x19 },
	'focus' => { 130 => 0x8 },
	'focusarea' => { 96 => 0x31 },
	'focusareaselection' => { 129 => '763.2' },
	'focuscontinuous' => { 13 => 0x20 },
	'focusdistance' => { 89 => 'FocusDistance', 96 => 0x13, 118 => 0x9, 119 => 0xa, 150 => 0x305 },
	'focusdistancelower' => { 2 => 0x45, 5 => 0x45, 7 => 0x45, 8 => 0x45, 9 => 0x52, 11 => 0x52, 32 => 0x14 },
	'focusdistanceupper' => { 2 => 0x43, 5 => 0x43, 7 => 0x43, 8 => 0x43, 9 => 0x50, 11 => 0x50, 32 => 0x13 },
	'focusinfoversion' => { 150 => 0x0 },
	'focusingscreen' => { 34 => 0x0, 35 => 0x80b, 40 => 0x0 },
	'focusmode' => { 13 => 0x7, 54 => 0x3, 55 => [0x3003,0xd], 62 => 0x1021, 70 => 0x38, 82 => 'FocusMode', 96 => 0x30, 98 => 0xe, 120 => 0x7, 147 => 0x301, 152 => 0x100b, 161 => 0x7, 174 => 0xd, 176 => 0x3 },
	'focusmode2' => { 167 => '3.1' },
	'focusmodesetting' => { 128 => 0x2e3 },
	'focuspixel' => { 62 => 0x1023 },
	'focuspointwrap' => { 127 => '792.2' },
	'focusposition' => { 118 => 0x8, 119 => 0x8, 174 => 0x10 },
	'focusprocess' => { 147 => 0x302 },
	'focusrange' => { 13 => 0x12, 152 => 0x100a },
	'focussetting' => { 186 => 0x6 },
	'focusstepcount' => { 150 => 0x301, 152 => 0x100e },
	'focusstepinfinity' => { 150 => 0x303 },
	'focusstepnear' => { 150 => 0x304 },
	'focustrackinglockon' => { 127 => '791.5' },
	'focuswarning' => { 62 => 0x1301 },
	'foldername' => { 96 => 0x27 },
	'fontcomposite' => { 219 => 'FontsComposite' },
	'fontface' => { 219 => 'FontsFontFace' },
	'fontfamily' => { 219 => 'FontsFontFamily' },
	'fontfilename' => { 219 => 'FontsFontFileName' },
	'fontname' => { 219 => 'FontsFontName' },
	'fonttype' => { 219 => 'FontsFontType' },
	'fontversion' => { 219 => 'FontsVersionString' },
	'for' => { 182 => 'For' },
	'format' => { 198 => 'format' },
	'forwardmatrix1' => { 58 => 0xc714 },
	'forwardmatrix2' => { 58 => 0xc715 },
	'framenum' => { 177 => 0xd7 },
	'framenumber' => { 62 => 0x8003, 174 => 0x29 },
	'freebytes' => { 48 => 0x1 },
	'freememorycardimages' => { 97 => [0x37,0x54], 98 => [0x2d,0x4a] },
	'fujiflashmode' => { 62 => 0x1010 },
	'fullsizeimage' => { 88 => 'data' },
	'fullsizeimagename' => { 88 => '1Name' },
	'fullsizeimagetype' => { 88 => '0Type' },
	'functionbutton' => { 129 => '753.2' },
	'gainbase' => { 151 => 0x610 },
	'gaincontrol' => { 58 => 0xa407, 200 => 'GainControl' },
	'gamma' => { 58 => 0xa500 },
	'gammacompensatedvalue' => { 66 => 0x91 },
	'genre' => { 206 => 'genre', 214 => 'genre' },
	'geography' => { 207 => 'geography' },
	'globalaltitude' => { 180 => 0x419 },
	'globalangle' => { 180 => 0x40d },
	'gpsaltitude' => { 63 => 0x6, 86 => 'Altitude', 200 => 'GPSAltitude' },
	'gpsaltituderef' => { 63 => 0x5, 200 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 63 => 0x1c, 200 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 63 => 0x1d },
	'gpsdatetime' => { 86 => 'DateTime', 200 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 63 => 0x18, 86 => 'Bearing', 200 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 63 => 0x17, 200 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 63 => 0x1a, 86 => 'Distance', 200 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 63 => 0x19, 200 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 63 => 0x14, 200 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 63 => 0x13 },
	'gpsdestlongitude' => { 63 => 0x16, 200 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 63 => 0x15 },
	'gpsdifferential' => { 63 => 0x1e, 86 => 'Differential', 200 => 'GPSDifferential' },
	'gpsdop' => { 63 => 0xb, 200 => 'GPSDOP' },
	'gpsimgdirection' => { 63 => 0x11, 200 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 63 => 0x10, 200 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 63 => 0x2, 86 => 'Latitude', 200 => 'GPSLatitude' },
	'gpslatituderef' => { 63 => 0x1 },
	'gpslongitude' => { 63 => 0x4, 86 => 'Longitude', 200 => 'GPSLongitude' },
	'gpslongituderef' => { 63 => 0x3 },
	'gpsmapdatum' => { 63 => 0x12, 86 => 'Datum', 200 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 63 => 0xa, 86 => 'MeasureMode', 200 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 63 => 0x1b, 200 => 'GPSProcessingMethod' },
	'gpssatellites' => { 63 => 0x8, 86 => 'Satellites', 200 => 'GPSSatellites' },
	'gpsspeed' => { 63 => 0xd, 86 => 'Speed', 200 => 'GPSSpeed' },
	'gpsspeedref' => { 63 => 0xc, 200 => 'GPSSpeedRef' },
	'gpsstatus' => { 63 => 0x9, 200 => 'GPSStatus' },
	'gpstimestamp' => { 63 => 0x7 },
	'gpstrack' => { 63 => 0xf, 86 => 'Heading', 200 => 'GPSTrack' },
	'gpstrackref' => { 63 => 0xe, 200 => 'GPSTrackRef' },
	'gpsversionid' => { 63 => 0x0, 200 => 'GPSVersionID' },
	'gradation' => { 147 => 0x50f },
	'graymixeraqua' => { 197 => 'GrayMixerAqua' },
	'graymixerblue' => { 197 => 'GrayMixerBlue' },
	'graymixergreen' => { 197 => 'GrayMixerGreen' },
	'graymixermagenta' => { 197 => 'GrayMixerMagenta' },
	'graymixerorange' => { 197 => 'GrayMixerOrange' },
	'graymixerpurple' => { 197 => 'GrayMixerPurple' },
	'graymixerred' => { 197 => 'GrayMixerRed' },
	'graymixeryellow' => { 197 => 'GrayMixerYellow' },
	'grayresponseunit' => { 58 => 0x122 },
	'greencurvelimits' => { 52 => 0x1c4 },
	'greencurvepoints' => { 52 => 0x19a },
	'greenhue' => { 197 => 'GreenHue' },
	'greensaturation' => { 197 => 'GreenSaturation' },
	'griddisplay' => { 127 => '803.3', 129 => '754.1' },
	'halftonehints' => { 58 => 0x141 },
	'hasalternative' => { 206 => 'hasAlternative' },
	'hascorrection' => { 206 => 'hasCorrection' },
	'hascrop' => { 197 => 'HasCrop' },
	'hasextendedxmp' => { 216 => 'HasExtendedXMP' },
	'haspreviousversion' => { 206 => 'hasPreviousVersion' },
	'hassettings' => { 197 => 'HasSettings' },
	'hastranslation' => { 206 => 'hasTranslation' },
	'headline' => { 64 => 0x69, 204 => 'Headline' },
	'hierarchicalsubject' => { 190 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 9 => 0xbd, 11 => 0xbd, 35 => 0x202, 120 => 0xb1, 174 => 0x71 },
	'highlight' => { 186 => 0xf },
	'highlightprotection' => { 139 => 0x6 },
	'highlightrecovery' => { 197 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 11 => 0x7, 35 => 0x203 },
	'history' => { 204 => 'History' },
	'historyaction' => { 215 => 'HistoryAction' },
	'historychanged' => { 215 => 'HistoryChanged' },
	'historyinstanceid' => { 215 => 'HistoryInstanceID' },
	'historyparameters' => { 215 => 'HistoryParameters' },
	'historysoftwareagent' => { 215 => 'HistorySoftwareAgent' },
	'historywhen' => { 215 => 'HistoryWhen' },
	'hometowncity' => { 55 => 0x3006, 174 => 0x23 },
	'hometowncitycode' => { 176 => 0x1000 },
	'hometowndst' => { 174 => 0x25 },
	'hostcomputer' => { 58 => 0x13c },
	'hue' => { 102 => 0x3b },
	'hueadj' => { 143 => 0x2f },
	'hueadjustment' => { 97 => 0x4a, 98 => 0x40, 120 => 0x92, 122 => 0x36 },
	'hueadjustmentaqua' => { 197 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 197 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 197 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 197 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 197 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 197 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 197 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 197 => 'HueAdjustmentYellow' },
	'huesetting' => { 155 => 0x1011 },
	'icc_profile' => { 59 => 'ICC_Profile' },
	'iccprofilename' => { 204 => 'ICCProfile' },
	'identifier' => { 198 => 'identifier', 212 => 'Identifier' },
	'illumination' => { 129 => '748.5' },
	'imageadjustment' => { 120 => 0x80, 130 => 0x5 },
	'imagealterationconstraints' => { 205 => 'ImageAlterationConstraints' },
	'imageareaoffset' => { 174 => 0x38 },
	'imageauthentication' => { 120 => 0x20 },
	'imageboundary' => { 120 => 0x16 },
	'imagecount' => { 120 => 0xa5 },
	'imagecreatorid' => { 205 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 205 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 205 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 120 => 0xa2 },
	'imagedescription' => { 58 => 0x10e, 210 => 'ImageDescription' },
	'imageduplicationconstraints' => { 205 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 140 => 0xfe443a45 },
	'imagefileconstraints' => { 205 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 205 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 205 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 58 => 0x101, 101 => 0xc, 210 => 'ImageLength' },
	'imagehistory' => { 58 => 0x9213 },
	'imageidnumber' => { 159 => 0x340 },
	'imagenumber' => { 10 => 0xd0, 58 => 0x9211, 82 => 'ImageNumber', 97 => 0xae, 98 => 0x5e, 195 => 'ImageNumber' },
	'imagenumber2' => { 98 => 0x62 },
	'imageoptimization' => { 120 => 0xa9 },
	'imageorientation' => { 64 => 0x83 },
	'imageprocessing' => { 120 => 0x1a, 174 => 0x32 },
	'imageprocessingcount' => { 174 => 0x41 },
	'imageprocessingversion' => { 151 => 0x0 },
	'imagequality' => { 82 => 'ImageQuality', 129 => '708.1', 161 => 0x1 },
	'imagequality2' => { 147 => 0x603 },
	'imagereview' => { 128 => '729.4', 129 => '748.4' },
	'imagereviewtime' => { 128 => 0x2db },
	'imagesize' => { 88 => 'ImageSize' },
	'imagesizerestriction' => { 208 => 'imageSizeRestriction' },
	'imagesourcedata' => { 58 => 0x935c },
	'imagestabilization' => { 13 => 0x22, 55 => 0x3020, 82 => 'ImageStabilization', 97 => 0xbd, 98 => 0x71, 99 => 0x57, 100 => [0x18,0x107,0x113], 120 => 0xac, 150 => 0x1600, 161 => 0x1a, 187 => 0xb026 },
	'imagesupplierid' => { 205 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 205 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 205 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 174 => 0x4f },
	'imagetype' => { 64 => 0x82, 205 => 'ImageType' },
	'imageuniqueid' => { 58 => 0xa420, 200 => 'ImageUniqueID' },
	'imagewidth' => { 58 => 0x100, 101 => 0xe, 210 => 'ImageWidth' },
	'incrementaltemperature' => { 197 => 'IncrementalTemperature' },
	'incrementaltint' => { 197 => 'IncrementalTint' },
	'industry' => { 206 => 'industry', 207 => 'industry' },
	'infinitylensstep' => { 152 => 0x103b },
	'infobuttonwhenshooting' => { 35 => 0x409 },
	'ingredientsalternatepaths' => { 215 => 'IngredientsAlternatePaths' },
	'ingredientsdocumentid' => { 215 => 'IngredientsDocumentID' },
	'ingredientsfilepath' => { 215 => 'IngredientsFilePath' },
	'ingredientsfrompart' => { 215 => 'IngredientsFromPart' },
	'ingredientsinstanceid' => { 215 => 'IngredientsInstanceID' },
	'ingredientslastmodifydate' => { 215 => 'IngredientsLastModifyDate' },
	'ingredientsmanager' => { 215 => 'IngredientsManager' },
	'ingredientsmanagervariant' => { 215 => 'IngredientsManagerVariant' },
	'ingredientsmanageto' => { 215 => 'IngredientsManageTo' },
	'ingredientsmanageui' => { 215 => 'IngredientsManageUI' },
	'ingredientsmaskmarkers' => { 215 => 'IngredientsMaskMarkers' },
	'ingredientspartmapping' => { 215 => 'IngredientsPartMapping' },
	'ingredientsrenditionclass' => { 215 => 'IngredientsRenditionClass' },
	'ingredientsrenditionparams' => { 215 => 'IngredientsRenditionParams' },
	'ingredientstopart' => { 215 => 'IngredientsToPart' },
	'ingredientsversionid' => { 215 => 'IngredientsVersionID' },
	'initialzoomsetting' => { 127 => '799.3' },
	'inkset' => { 58 => 0x14c },
	'instanceid' => { 215 => 'InstanceID' },
	'instructions' => { 204 => 'Instructions' },
	'instrument' => { 214 => 'instrument' },
	'intellectualgenre' => { 201 => 'IntellectualGenre' },
	'interchangecolorspace' => { 66 => 0x40 },
	'internalflash' => { 96 => 0x2b, 127 => '813.1', 128 => '737.1', 129 => '756.1', 150 => 0x1208 },
	'internalflashae1' => { 152 => 0x1021 },
	'internalflashae1_0' => { 152 => 0x101d },
	'internalflashae2' => { 152 => 0x1022 },
	'internalflashae2_0' => { 152 => 0x101e },
	'internalflashmode' => { 170 => 0x1 },
	'internalflashstrength' => { 170 => 0x3 },
	'internalflashtable' => { 152 => 0x1024 },
	'internalserialnumber' => { 25 => 0x96, 31 => 0x9, 62 => 0x10, 148 => 0x102, 161 => 0x25, 166 => 0x4 },
	'interopindex' => { 58 => 0x1 },
	'interopversion' => { 58 => 0x2 },
	'intervallength' => { 96 => 0x10 },
	'intervalmode' => { 96 => 0x26 },
	'intervalnumber' => { 96 => 0x11 },
	'introtimescale' => { 214 => 'introTimeScale' },
	'introtimevalue' => { 214 => 'introTimeValue' },
	'iptc-naa' => { 58 => 0x83bb },
	'iptcbitspersample' => { 66 => 0x56 },
	'iptcdigest' => { 180 => 0x425 },
	'iptcimageheight' => { 66 => 0x1e },
	'iptcimagerotation' => { 66 => 0x66 },
	'iptcimagewidth' => { 66 => 0x14 },
	'iptclastedited' => { 202 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 66 => 0xa },
	'iptcpixelheight' => { 66 => 0x32 },
	'iptcpixelwidth' => { 66 => 0x28 },
	'isbn' => { 206 => 'isbn' },
	'iscorrectionof' => { 206 => 'isCorrectionOf' },
	'iso' => { 2 => 0x6, 4 => 0x75, 5 => 0x6, 6 => 0x79, 7 => 0x6, 8 => 0x6, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x0, 54 => 0x14, 55 => [0x3014,0x14], 58 => 0x8827, 68 => 0xfd06, 69 => 0x1784, 70 => 0x60, 71 => [0xfa2e,0xfa46], 72 => [0x27,0x28], 73 => 0xf105, 77 => 0x4e, 80 => 0x34, 82 => 'ISO', 96 => 0x8, 116 => 0x0, 120 => 0x2, 162 => 0x17, 174 => 0x14, 176 => 0x14, 200 => 'ISOSpeedRatings' },
	'iso2' => { 116 => 0x6, 126 => 0x256, 127 => 0x25c },
	'isoexpansion' => { 35 => 0x103, 36 => 0x7, 37 => 0x8, 40 => 0x8, 116 => 0x4 },
	'isoexpansion2' => { 116 => 0xa },
	'isofloor' => { 167 => 0x6 },
	'isoselection' => { 120 => 0xf },
	'isosetting' => { 70 => 0x5e, 82 => 'ISOSetting', 96 => 0x24, 97 => 0x26, 98 => 0x1c, 102 => 0x6, 120 => 0x13, 167 => '17.3', 183 => 0x27 },
	'isospeedexpansion' => { 34 => 0x3 },
	'isospeedincrements' => { 35 => 0x102 },
	'isospeedrange' => { 35 => 0x103 },
	'isostepsize' => { 127 => '796.1' },
	'isovalue' => { 152 => 0x1001 },
	'issn' => { 206 => 'issn' },
	'issueidentifier' => { 206 => 'issueIdentifier' },
	'issuename' => { 206 => 'issueName' },
	'istranslationof' => { 206 => 'isTranslationOf' },
	'jobid' => { 64 => 0xb8 },
	'jobrefid' => { 213 => 'JobRefId' },
	'jobrefname' => { 213 => 'JobRefName' },
	'jobrefurl' => { 213 => 'JobRefUrl' },
	'jpegquality' => { 4 => 0x66 },
	'jpgfromraw' => { 48 => 0x2007, 56 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 58 => [0x117,0x202] },
	'jpgfromrawstart' => { 58 => [0x111,0x201] },
	'jpgrecordedpixels' => { 167 => 0xe },
	'key' => { 214 => 'key' },
	'keyword' => { 206 => 'keyword' },
	'keywords' => { 64 => 0x19, 83 => 'Keywords', 156 => 'Keywords', 182 => 'Keywords', 203 => 'Keywords' },
	'killdate' => { 206 => 'killDate' },
	'kodakimageheight' => { 68 => 0xf908, 70 => 0xe, 71 => [0xfa1e,0xfa52], 76 => 0x70 },
	'kodakimagewidth' => { 68 => 0xf907, 70 => 0xc, 71 => [0xfa1d,0xfa51], 76 => 0x6c },
	'kodakinfotype' => { 68 => 0xfa00 },
	'kodakmaker' => { 76 => 0x8 },
	'kodakmodel' => { 70 => 0x0, 76 => 0x28 },
	'label' => { 158 => 'Label', 212 => 'Label' },
	'language' => { 198 => 'language' },
	'languageidentifier' => { 64 => 0x87 },
	'lastfilenumber' => { 96 => 0x1b },
	'lastkeywordiptc' => { 193 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 193 => 'LastKeywordXMP' },
	'lasturl' => { 215 => 'LastURL' },
	'lc1' => { 171 => 0x2 },
	'lc10' => { 171 => 0xb },
	'lc11' => { 171 => 0xc },
	'lc12' => { 171 => 0xd },
	'lc14' => { 171 => 0xf },
	'lc15' => { 171 => 0x10 },
	'lc2' => { 171 => 0x3 },
	'lc3' => { 171 => 0x4 },
	'lc4' => { 171 => 0x5 },
	'lc5' => { 171 => 0x6 },
	'lc6' => { 171 => 0x7 },
	'lc7' => { 171 => 0x8 },
	'lcddisplayatpoweron' => { 35 => 0x811, 39 => 0xa },
	'lcddisplayreturntoshoot' => { 40 => 0x12 },
	'lcdillumination' => { 127 => '807.5' },
	'lcdilluminationduringbulb' => { 35 => 0x408 },
	'lcdpanels' => { 34 => 0x8 },
	'lcheditor' => { 140 => 0x8ae85e },
	'legacyiptcdigest' => { 204 => 'LegacyIPTCDigest' },
	'lens' => { 58 => 0xfdea, 120 => 0x84, 186 => 0xa, 195 => 'Lens' },
	'lensafstopbutton' => { 33 => 0x11, 34 => 0x13, 35 => 0x506, 36 => 0x10, 37 => 0x12, 40 => 0x13, 41 => 0x9 },
	'lensaperturerange' => { 186 => 0x30 },
	'lensdistortionparams' => { 152 => 0x206 },
	'lensdrivenoaf' => { 35 => 0x505 },
	'lensfirmwareversion' => { 148 => 0x204 },
	'lensfstops' => { 117 => 0x7, 118 => 0xc, 119 => 0xd, 120 => 0x8b, 171 => '0.3' },
	'lensid' => { 195 => 'LensID' },
	'lensidnumber' => { 117 => 0x6, 118 => 0xb, 119 => 0xc },
	'lensinfo' => { 195 => 'LensInfo' },
	'lenskind' => { 171 => 0x1 },
	'lensmake' => { 89 => 'Make' },
	'lensmanufacturer' => { 193 => 'LensManufacturer' },
	'lensmodel' => { 2 => 0x937, 7 => 0x92b, 8 => 0x933, 25 => 0x95, 89 => 'Model', 193 => 'LensModel' },
	'lensproperties' => { 148 => 0x20b },
	'lensserialnumber' => { 89 => 'SerialNumber', 148 => 0x202, 161 => 0x52 },
	'lenstemperature' => { 152 => 0x1008 },
	'lenstype' => { 2 => 0xe3, 3 => 0xd, 4 => 0xd, 5 => 0x112, 6 => 0xd, 7 => 0xd7, 8 => 0xdf, 9 => 0xeb, 10 => [0xd,0x98], 11 => 0xe7, 13 => 0x16, 100 => 0x10c, 120 => 0x83, 148 => 0x201, 159 => 0x310, 161 => 0x51, 172 => 0x0, 173 => 0x0, 174 => 0x3f, 187 => 0xb027 },
	'license' => { 196 => 'license' },
	'licenseeid' => { 205 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 205 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 205 => 'LicenseeImageNotes' },
	'licenseename' => { 205 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 205 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 205 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 205 => 'LicenseeTransactionID' },
	'licenseid' => { 205 => 'LicenseID' },
	'licensestartdate' => { 205 => 'LicenseStartDate' },
	'licensetransactiondate' => { 205 => 'LicenseTransactionDate' },
	'licensetype' => { 199 => 'licensetype' },
	'licensorcity' => { 205 => 'LicensorLicensorCity' },
	'licensorcountry' => { 205 => 'LicensorLicensorCountry' },
	'licensoremail' => { 205 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 205 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 205 => 'LicensorLicensorID' },
	'licensorimageid' => { 205 => 'LicensorImageID' },
	'licensorname' => { 205 => 'LicensorLicensorName' },
	'licensornotes' => { 205 => 'LicensorNotes' },
	'licensorpostalcode' => { 205 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 205 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 205 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 205 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 205 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 205 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 205 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 205 => 'LicensorTransactionID' },
	'licensorurl' => { 205 => 'LicensorLicensorURL' },
	'lightcondition' => { 152 => 0x1009 },
	'lightreading' => { 174 => 0x15 },
	'lightsource' => { 58 => 0x9208, 120 => 0x90, 155 => 0x1000, 200 => 'LightSource' },
	'lightsourcespecial' => { 185 => 0x21d },
	'lightvaluecenter' => { 152 => 0x103d },
	'lightvalueperiphery' => { 152 => 0x103e },
	'linearresponselimit' => { 58 => 0xc62e },
	'liveviewexposuresimulation' => { 35 => 0x810 },
	'liveviewshooting' => { 22 => 0x13 },
	'localcaption' => { 64 => 0x79 },
	'localizedcameramodel' => { 58 => 0xc615 },
	'location' => { 192 => 'Location', 201 => 'Location', 206 => 'location' },
	'locationcreatedcity' => { 202 => 'LocationCreatedCity' },
	'locationcreatedcountrycode' => { 202 => 'LocationCreatedCountryCode' },
	'locationcreatedcountryname' => { 202 => 'LocationCreatedCountryName' },
	'locationcreatedprovincestate' => { 202 => 'LocationCreatedProvinceState' },
	'locationcreatedsublocation' => { 202 => 'LocationCreatedSublocation' },
	'locationcreatedworldregion' => { 202 => 'LocationCreatedWorldRegion' },
	'locationshowncity' => { 202 => 'LocationShownCity' },
	'locationshowncountrycode' => { 202 => 'LocationShownCountryCode' },
	'locationshowncountryname' => { 202 => 'LocationShownCountryName' },
	'locationshownprovincestate' => { 202 => 'LocationShownProvinceState' },
	'locationshownsublocation' => { 202 => 'LocationShownSublocation' },
	'locationshownworldregion' => { 202 => 'LocationShownWorldRegion' },
	'lockmicrophonebutton' => { 35 => 0x709 },
	'logcomment' => { 214 => 'logComment' },
	'longexposurenoisereduction' => { 35 => 0x201, 36 => 0x1, 37 => 0x2, 38 => 0x1, 39 => 0x1, 40 => 0x2, 41 => 0x1, 187 => 0xb04e },
	'longfocal' => { 3 => 0x10, 4 => 0x13, 5 => 0x115, 6 => 0x13, 7 => 0xda, 9 => 0xee, 10 => 0x95, 11 => 0xea, 13 => 0x17 },
	'loop' => { 214 => 'loop' },
	'luminanceadjustmentaqua' => { 197 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 197 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 197 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 197 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 197 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 197 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 197 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 197 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 53 => 0x5f },
	'luminancenr_tiff_jpeg' => { 53 => 0x6d },
	'luminancesmoothing' => { 197 => 'LuminanceSmoothing' },
	'm16cversion' => { 159 => 0x333 },
	'macro' => { 62 => 0x1020, 152 => 0x202, 183 => 0x21, 185 => 0x202, 187 => 0xb040 },
	'macromode' => { 13 => 0x1, 96 => 0xb, 147 => 0x300, 161 => 0x1c },
	'magnifiedview' => { 37 => 0x11, 39 => 0x9 },
	'maindialexposurecomp' => { 129 => '748.6' },
	'make' => { 49 => 0x0, 58 => 0x10f, 82 => 'Make', 158 => 'Make', 162 => 0x10f, 210 => 'Make' },
	'makernote' => { 200 => 'MakerNote' },
	'makernotecanon' => { 57 => 'MakN', 58 => 0x927c },
	'makernotecasio' => { 57 => 'MakN', 58 => 0x927c },
	'makernotecasio2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotefujifilm' => { 57 => 'MakN', 58 => 0x927c },
	'makernotehp' => { 57 => 'MakN', 58 => 0x927c },
	'makernotehp2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotehp4' => { 57 => 'MakN', 58 => 0x927c },
	'makernotehp6' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteisl' => { 57 => 'MakN', 58 => 0x927c },
	'makernotejvc' => { 57 => 'MakN', 58 => 0x927c },
	'makernotejvctext' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak1a' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak1b' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak3' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak4' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak5' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak6a' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak6b' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak7' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak8a' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak8b' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodak9' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekodakunknown' => { 57 => 'MakN', 58 => 0x927c },
	'makernotekyocera' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteleica' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteleica2' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteleica3' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteminolta' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteminolta2' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteminolta3' => { 57 => 'MakN', 58 => 0x927c },
	'makernotenikon' => { 57 => 'MakN', 58 => 0x927c },
	'makernotenikon2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotenikon3' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteoffset' => { 185 => 0xff },
	'makernoteolympus' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteolympus2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotepanasonic' => { 57 => 'MakN', 58 => 0x927c },
	'makernotepanasonic2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotepentax' => { 57 => 'MakN', 58 => 0x927c },
	'makernotepentax2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotepentax3' => { 57 => 'MakN', 58 => 0x927c },
	'makernotepentax4' => { 57 => 'MakN', 58 => 0x927c },
	'makernotericoh' => { 57 => 'MakN', 58 => 0x927c },
	'makernotericohtext' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesafety' => { 58 => 0xc635 },
	'makernotesanyo' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesanyoc4' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesanyopatch' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesigma' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesony' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesony2' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesony3' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesony4' => { 57 => 'MakN', 58 => 0x927c },
	'makernotesonysrf' => { 57 => 'MakN', 58 => 0x927c },
	'makernotetype' => { 184 => 0x1 },
	'makernoteunknown' => { 57 => 'MakN', 58 => 0x927c },
	'makernoteversion' => { 100 => 0x0, 120 => 0x1, 152 => 0x0, 161 => 0x8000, 184 => 0x2, 186 => 0x1d },
	'managedfromalternatepaths' => { 215 => 'ManagedFromAlternatePaths' },
	'managedfromdocumentid' => { 215 => 'ManagedFromDocumentID' },
	'managedfromfilepath' => { 215 => 'ManagedFromFilePath' },
	'managedfromfrompart' => { 215 => 'ManagedFromFromPart' },
	'managedfrominstanceid' => { 215 => 'ManagedFromInstanceID' },
	'managedfromlastmodifydate' => { 215 => 'ManagedFromLastModifyDate' },
	'managedfrommanager' => { 215 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 215 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 215 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 215 => 'ManagedFromManageUI' },
	'managedfrommaskmarkers' => { 215 => 'ManagedFromMaskMarkers' },
	'managedfrompartmapping' => { 215 => 'ManagedFromPartMapping' },
	'managedfromrenditionclass' => { 215 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 215 => 'ManagedFromRenditionParams' },
	'managedfromtopart' => { 215 => 'ManagedFromToPart' },
	'managedfromversionid' => { 215 => 'ManagedFromVersionID' },
	'manager' => { 215 => 'Manager' },
	'managervariant' => { 215 => 'ManagerVariant' },
	'manageto' => { 215 => 'ManageTo' },
	'manageui' => { 215 => 'ManageUI' },
	'manometerpressure' => { 147 => 0x900 },
	'manometerreading' => { 147 => 0x901 },
	'manualflash' => { 150 => 0x1209 },
	'manualflashoutput' => { 13 => 0x29, 128 => '737.2', 129 => '756.2' },
	'manualfocusdistance' => { 120 => 0x85, 152 => 0x100c, 185 => 0x223 },
	'manualtv' => { 34 => 0x5, 35 => 0x705 },
	'manufacturedate' => { 166 => 0x1 },
	'marked' => { 203 => 'Marked', 218 => 'Marked' },
	'markerscomment' => { 214 => 'markersComment' },
	'markerscuepointparamskey' => { 214 => 'markersCuePointParamsKey' },
	'markerscuepointparamsvalue' => { 214 => 'markersCuePointParamsValue' },
	'markerscuepointtype' => { 214 => 'markersCuePointType' },
	'markersduration' => { 214 => 'markersDuration' },
	'markerslocation' => { 214 => 'markersLocation' },
	'markersname' => { 214 => 'markersName' },
	'markersprobability' => { 214 => 'markersProbability' },
	'markersspeaker' => { 214 => 'markersSpeaker' },
	'markersstarttime' => { 214 => 'markersStartTime' },
	'markerstarget' => { 214 => 'markersTarget' },
	'markerstype' => { 214 => 'markersType' },
	'maskedareas' => { 58 => 0xc68e },
	'masterdocumentid' => { 64 => 0xb9 },
	'mastergain' => { 125 => 0x50 },
	'maxaperture' => { 13 => 0x1a, 73 => 0x6103, 89 => 'MaxAperture', 96 => 0x17, 171 => '14.1' },
	'maxapertureatcurrentfocal' => { 148 => 0x20a },
	'maxapertureatmaxfocal' => { 62 => 0x1407, 89 => 'MaxApertureAtMaxFocal', 117 => 0xb, 118 => 0x10, 119 => 0x11, 148 => 0x206 },
	'maxapertureatminfocal' => { 62 => 0x1406, 117 => 0xa, 118 => 0xf, 119 => 0x10, 148 => 0x205 },
	'maxaperturevalue' => { 58 => 0x9205, 200 => 'MaxApertureValue' },
	'maxavailheight' => { 202 => 'MaxAvailHeight' },
	'maxavailwidth' => { 202 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 127 => '801.1' },
	'maxfocallength' => { 62 => 0x1405, 89 => 'MaxFocalLength', 117 => 0x9, 118 => 0xe, 119 => 0xf, 148 => 0x208 },
	'maximumdensityrange' => { 66 => 0x8c },
	'maxpagesizeh' => { 219 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 219 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 219 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 58 => 0x119 },
	'mb-d10batteries' => { 127 => '802.4' },
	'mb-d80batteries' => { 129 => '754.5' },
	'mcuversion' => { 117 => 0xc, 118 => 0x11, 119 => 0x12 },
	'md5digest' => { 90 => 'zmd5' },
	'measuredev' => { 32 => 0x3, 48 => 0x1814, 82 => 'MeasuredEV' },
	'measuredlv' => { 159 => 0x312 },
	'mediaconstraints' => { 205 => 'MediaConstraints' },
	'mediasummarycode' => { 205 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 33 => 0xb, 36 => 0xa, 37 => 0xb, 40 => 0xb },
	'menubuttonreturn' => { 41 => 0xb },
	'metadatadate' => { 212 => 'MetadataDate' },
	'metadatamoddate' => { 214 => 'metadataModDate' },
	'metering' => { 128 => 0x2df },
	'meteringmode' => { 13 => 0x11, 58 => 0x9207, 70 => 0x1c, 96 => 0x7, 97 => 0x25, 147 => 0x202, 174 => 0x17, 186 => 0x9, 200 => 'MeteringMode' },
	'meteringmode2' => { 167 => '2.1' },
	'meteringmode3' => { 167 => '16.1' },
	'meteringtime' => { 127 => '812.2', 128 => '732.2', 129 => '751.2' },
	'mieversion' => { 90 => '0Vers' },
	'minaperture' => { 13 => 0x1b, 89 => 'MinAperture', 171 => '0.2' },
	'minfocallength' => { 62 => 0x1404, 89 => 'MinFocalLength', 117 => 0x8, 118 => 0xd, 119 => 0xe, 148 => 0x207 },
	'minoltadate' => { 96 => 0x15 },
	'minoltaimagesize' => { 96 => 0x4, 97 => 0xc, 98 => 0x2, 100 => 0x103 },
	'minoltamodelid' => { 96 => 0x25 },
	'minoltaquality' => { 96 => 0x5, 97 => 0xd, 98 => 0x3, 100 => [0x102,0x103], 152 => [0x102,0x103] },
	'minoltatime' => { 96 => 0x16 },
	'minormodelagedisclosure' => { 205 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 58 => 0x118 },
	'mirrorlockup' => { 33 => 0xc, 34 => 0xc, 35 => 0x60f, 36 => 0xb, 37 => 0xc, 38 => 0x6, 39 => 0x6, 40 => 0xc, 41 => 0x3 },
	'moddate' => { 203 => 'ModDate' },
	'model' => { 49 => 0x6, 58 => 0x110, 82 => 'Model', 158 => 'Model', 162 => 0x110, 210 => 'Model' },
	'modelage' => { 202 => 'ModelAge' },
	'modelingflash' => { 127 => '811.4', 129 => '755.4' },
	'modelreleaseid' => { 205 => 'ModelReleaseID' },
	'modelreleasestatus' => { 205 => 'ModelReleaseStatus' },
	'modificationdate' => { 206 => 'modificationDate' },
	'modifiedcolortemp' => { 26 => 0x9 },
	'modifieddigitalgain' => { 26 => 0xb },
	'modifiedparamflag' => { 23 => 0x1 },
	'modifiedpicturestyle' => { 26 => 0xa },
	'modifiedsaturation' => { 147 => 0x504 },
	'modifiedsensorbluelevel' => { 26 => 0x5 },
	'modifiedsensorredlevel' => { 26 => 0x4 },
	'modifiedsharpness' => { 26 => 0x2 },
	'modifiedsharpnessfreq' => { 26 => 0x3 },
	'modifiedtonecurve' => { 26 => 0x1 },
	'modifiedwhitebalance' => { 26 => 0x8 },
	'modifiedwhitebalanceblue' => { 26 => 0x7 },
	'modifiedwhitebalancered' => { 26 => 0x6 },
	'modifydate' => { 58 => 0x132, 83 => 'ModifyDate', 156 => 'ModDate', 157 => 'tIME', 182 => 'ModDate', 212 => 'ModifyDate' },
	'moirefilter' => { 58 => 0xfe58, 197 => 'MoireFilter' },
	'monitorofftime' => { 127 => '808.2', 128 => '732.1', 129 => '751.1' },
	'monochromecontrast' => { 53 => 0x3c },
	'monochromefiltereffect' => { 53 => 0x3a },
	'monochromelinear' => { 53 => 0x3d },
	'monochromesharpness' => { 53 => 0x3e },
	'monochrometoningeffect' => { 53 => 0x3b },
	'monthdaycreated' => { 70 => 0x12, 77 => 0xe },
	'morepermissions' => { 196 => 'morePermissions' },
	'multiexposureautogain' => { 121 => 0x3 },
	'multiexposuremode' => { 121 => 0x1 },
	'multiexposureshots' => { 121 => 0x2 },
	'multipleexposureset' => { 167 => '10.1' },
	'multisample' => { 125 => 0x40 },
	'multiselector' => { 127 => '799.4' },
	'multiselectorplaybackmode' => { 127 => '799.2' },
	'multiselectorshootmode' => { 127 => '799.1' },
	'mycolormode' => { 27 => 0x2 },
	'nativedigest' => { 200 => 'NativeDigest', 210 => 'NativeDigest' },
	'ncdfileinfo' => { 69 => 0x414 },
	'ndfilter' => { 32 => 0x1c },
	'nearlensstep' => { 152 => 0x103c },
	'nefcompression' => { 120 => 0x93 },
	'newsphotoversion' => { 66 => 0x0 },
	'nickname' => { 212 => 'Nickname' },
	'nikon_0x00b9' => { 120 => 0xb9 },
	'nikoncaptureversion' => { 120 => 0xe09 },
	'nikoniccprofile' => { 120 => 0xe1d },
	'nikonimagesize' => { 129 => 0x2c4 },
	'noisefilter' => { 147 => 0x527 },
	'noisereduction' => { 22 => 0x8, 62 => 0x100b, 97 => 0xb0, 98 => 0x60, 99 => 0x3f, 120 => 0x95, 140 => 0x753dcbc0, 141 => 0x17, 147 => 0x50a, 152 => 0x103a, 161 => 0x2d, 174 => 0x49 },
	'noisereduction2' => { 151 => 0x1010 },
	'noisereductionapplied' => { 58 => 0xc6f7 },
	'noisereductionintensity' => { 141 => 0x9 },
	'noisereductionmethod' => { 141 => 0x11 },
	'noisereductionsharpness' => { 141 => 0xd },
	'nomemorycard' => { 127 => '812.1', 128 => '729.3', 129 => '748.3' },
	'nominalmaxaperture' => { 171 => 0xa },
	'nominalminaperture' => { 171 => '10.1' },
	'notes' => { 188 => 'Notes' },
	'npages' => { 219 => 'NPages' },
	'nullrecord' => { 48 => 0x0 },
	'number' => { 206 => 'number' },
	'numberofbeats' => { 214 => 'numberOfBeats' },
	'numindexentries' => { 66 => 0x54 },
	'object' => { 206 => 'object' },
	'objectattributereference' => { 64 => 0x4 },
	'objectcycle' => { 64 => 0x4b },
	'objectdistance' => { 54 => 0x6, 55 => 0x2022 },
	'objectname' => { 64 => 0x5 },
	'objectpreviewdata' => { 64 => 0xca },
	'objectpreviewfileformat' => { 64 => 0xc8 },
	'objectpreviewfileversion' => { 64 => 0xc9 },
	'objecttypereference' => { 64 => 0x3 },
	'oecfcolumns' => { 200 => 'OECFColumns' },
	'oecfnames' => { 200 => 'OECFNames' },
	'oecfrows' => { 200 => 'OECFRows' },
	'oecfvalues' => { 200 => 'OECFValues' },
	'offsetschema' => { 58 => 0xea1d },
	'oldsubfiletype' => { 58 => 0xff },
	'olympusimageheight' => { 152 => 0x102f },
	'olympusimagewidth' => { 152 => 0x102e },
	'onetouchwb' => { 152 => 0x302 },
	'opticalzoom' => { 71 => 0xfa3d, 73 => [0x6006,0xf006], 74 => 0x1000, 75 => 0xf, 77 => 0x1e, 89 => 'OpticalZoom' },
	'opticalzoomcode' => { 32 => 0xa },
	'opticalzoommode' => { 161 => 0x34 },
	'opticalzoomon' => { 185 => 0x219 },
	'optionenddate' => { 208 => 'optionEndDate' },
	'ordernumber' => { 62 => 0x8002 },
	'organisationinimagecode' => { 202 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 202 => 'OrganisationInImageName' },
	'organization' => { 206 => 'organization' },
	'orientation' => { 58 => 0x112, 162 => 0x112, 210 => 'Orientation' },
	'originaldecisiondata' => { 56 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 25 => 0x83 },
	'originaldocumentid' => { 215 => 'OriginalDocumentID' },
	'originalfilename' => { 48 => 0x816, 69 => 0x3e9, 78 => 0x20 },
	'originalimageheight' => { 61 => 0x1 },
	'originalimagewidth' => { 61 => 0x0 },
	'originalrawfiledata' => { 58 => 0xc68c },
	'originalrawfiledigest' => { 58 => 0xc71d },
	'originalrawfilename' => { 58 => 0xc68b },
	'originaltransmissionreference' => { 64 => 0x67 },
	'originatingprogram' => { 64 => 0x41 },
	'originplatform' => { 206 => 'originPlatform' },
	'os' => { 199 => 'os' },
	'otherconditions' => { 205 => 'OtherConditions' },
	'otherconstraints' => { 205 => 'OtherConstraints' },
	'otherimageinfo' => { 205 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 205 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 205 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 205 => 'OtherLicenseRequirements' },
	'outcuescale' => { 214 => 'outCueScale' },
	'outcuevalue' => { 214 => 'outCueValue' },
	'outputimageheight' => { 106 => 0x3 },
	'outputimagewidth' => { 106 => 0x2 },
	'outputresolution' => { 106 => 0x4 },
	'owner' => { 218 => 'Owner' },
	'ownerid' => { 64 => 0xbc },
	'ownername' => { 25 => 0x9, 48 => 0x810, 58 => 0xfde8, 82 => 'OwnerName', 195 => 'OwnerName' },
	'padding' => { 58 => 0xea1c },
	'pagename' => { 58 => 0x11d },
	'pagenumber' => { 58 => 0x129 },
	'pagerange' => { 206 => 'pageRange' },
	'panasonicexifversion' => { 161 => 0x26 },
	'panasonicrawversion' => { 162 => 0x1 },
	'panasonictitle' => { 58 => 0xc6d2 },
	'panoramadirection' => { 28 => 0x5 },
	'panoramaframe' => { 28 => 0x2 },
	'panoramamode' => { 70 => 0x3c, 147 => 0x601 },
	'parametricdarks' => { 197 => 'ParametricDarks' },
	'parametrichighlights' => { 197 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 197 => 'ParametricHighlightSplit' },
	'parametriclights' => { 197 => 'ParametricLights' },
	'parametricmidtonesplit' => { 197 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 197 => 'ParametricShadows' },
	'parametricshadowsplit' => { 197 => 'ParametricShadowSplit' },
	'patientid' => { 189 => 'PatientID' },
	'patientsbirthdate' => { 189 => 'PatientDOB' },
	'patientsname' => { 189 => 'PatientName' },
	'patientssex' => { 189 => 'PatientSex' },
	'pdfversion' => { 203 => 'PDFVersion' },
	'pentaximagesize' => { 174 => 0x9 },
	'pentaxmodelid' => { 166 => 0x0, 174 => 0x5 },
	'pentaxmodeltype' => { 174 => 0x1 },
	'pentaxversion' => { 174 => 0x0 },
	'people' => { 192 => 'People' },
	'peripheralillumination' => { 53 => 0x68 },
	'peripheralilluminationon' => { 53 => 0x64 },
	'permissions' => { 208 => 'permissions' },
	'person' => { 206 => 'person' },
	'personinimage' => { 202 => 'PersonInImage' },
	'pf0customfuncregistration' => { 43 => 0x1 },
	'pf10retainprogramshift' => { 43 => 0xb },
	'pf13drivepriority' => { 43 => 0xe },
	'pf14disablefocussearch' => { 43 => 0xf },
	'pf15disableafassistbeam' => { 43 => 0x10 },
	'pf16autofocuspointshoot' => { 43 => 0x11 },
	'pf17disableafpointsel' => { 43 => 0x12 },
	'pf18enableautoafpointsel' => { 43 => 0x13 },
	'pf19continuousshootspeed' => { 43 => 0x14 },
	'pf19shootingspeedhigh' => { 42 => 0xa },
	'pf19shootingspeedlow' => { 42 => 0x9 },
	'pf1disableshootingmodes' => { 43 => 0x2 },
	'pf1value' => { 42 => 0x1 },
	'pf20limitcontinousshots' => { 43 => 0x15 },
	'pf20maxcontinousshots' => { 42 => 0xb },
	'pf21enablequietoperation' => { 43 => 0x16 },
	'pf23felocktime' => { 42 => 0xd },
	'pf23postreleasetime' => { 42 => 0xe },
	'pf23settimerlengths' => { 43 => 0x18 },
	'pf23shutterbuttontime' => { 42 => 0xc },
	'pf24lightlcdduringbulb' => { 43 => 0x19 },
	'pf25aemode' => { 42 => 0xf },
	'pf25afmode' => { 42 => 0x12 },
	'pf25afpointsel' => { 42 => 0x13 },
	'pf25colormatrix' => { 42 => 0x17 },
	'pf25defaultclearsettings' => { 43 => 0x1a },
	'pf25drivemode' => { 42 => 0x11 },
	'pf25imagesize' => { 42 => 0x14 },
	'pf25meteringmode' => { 42 => 0x10 },
	'pf25parameters' => { 42 => 0x16 },
	'pf25wbmode' => { 42 => 0x15 },
	'pf26shortenreleaselag' => { 43 => 0x1b },
	'pf27reversedialrotation' => { 43 => 0x1c },
	'pf27value' => { 42 => 0x18 },
	'pf28noquickdialexpcomp' => { 43 => 0x1d },
	'pf29quickdialswitchoff' => { 43 => 0x1e },
	'pf2disablemeteringmodes' => { 43 => 0x3 },
	'pf2value' => { 42 => 0x2 },
	'pf30enlargementmode' => { 43 => 0x1f },
	'pf31originaldecisiondata' => { 43 => 0x20 },
	'pf3manualexposuremetering' => { 43 => 0x4 },
	'pf3value' => { 42 => 0x3 },
	'pf4exposuretimelimits' => { 43 => 0x5 },
	'pf4exposuretimemax' => { 42 => 0x5 },
	'pf4exposuretimemin' => { 42 => 0x4 },
	'pf5aperturelimits' => { 43 => 0x6 },
	'pf5aperturemax' => { 42 => 0x7 },
	'pf5aperturemin' => { 42 => 0x6 },
	'pf6presetshootingmodes' => { 43 => 0x7 },
	'pf7bracketcontinuousshoot' => { 43 => 0x8 },
	'pf8bracketshots' => { 42 => 0x8 },
	'pf8setbracketshots' => { 43 => 0x9 },
	'pf9changebracketsequence' => { 43 => 0xa },
	'phonenumber' => { 83 => 'Phone' },
	'photoeffect' => { 13 => 0x28 },
	'photoeffects' => { 140 => 0xab5eca5e },
	'photoeffectsblue' => { 142 => 0x8 },
	'photoeffectsgreen' => { 142 => 0x6 },
	'photoeffectsred' => { 142 => 0x4 },
	'photoeffectstype' => { 142 => 0x0 },
	'photoinfoplayback' => { 127 => '807.6' },
	'photometricinterpretation' => { 58 => 0x106, 210 => 'PhotometricInterpretation' },
	'photoshopquality' => { 179 => 0x0 },
	'pictinfo' => { 185 => 0x208 },
	'picturecontrol' => { 140 => 0xe2173c47 },
	'picturecontrolactive' => { 143 => 0x0 },
	'picturecontroladjust' => { 122 => 0x30 },
	'picturecontrolbase' => { 122 => 0x18 },
	'picturecontrolmode' => { 143 => 0x13 },
	'picturecontrolname' => { 122 => 0x4 },
	'picturecontrolquickadjust' => { 122 => 0x31 },
	'picturefinish' => { 97 => 0x71 },
	'picturemode' => { 62 => 0x1031, 147 => 0x520, 174 => [0xb,0x33] },
	'picturemode2' => { 167 => 0x0 },
	'picturemodebwfilter' => { 147 => 0x525 },
	'picturemodecontrast' => { 147 => 0x523 },
	'picturemodehue' => { 147 => 0x522 },
	'picturemodesaturation' => { 147 => 0x521 },
	'picturemodesharpness' => { 147 => 0x524 },
	'picturemodetone' => { 147 => 0x526 },
	'picturestyle' => { 3 => [0x4b,0x51], 4 => 0x6c, 5 => 0x86, 6 => 0x73, 9 => 0xa7, 10 => 0x6c, 11 => 0xa7, 30 => 0xa, 53 => 0x2 },
	'planarconfiguration' => { 58 => 0x11c, 210 => 'PlanarConfiguration' },
	'platenames' => { 219 => 'PlateNames' },
	'plusversion' => { 205 => 'Version' },
	'pngwarning' => { 158 => 'Warning' },
	'postalcode' => { 87 => 'PostalCode' },
	'postcropvignetteamount' => { 197 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 197 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 197 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 197 => 'PostCropVignetteRoundness' },
	'powersource' => { 165 => 0x0 },
	'precaptureframes' => { 152 => 0x300 },
	'predictor' => { 58 => 0x13d },
	'prefs' => { 64 => 0xdd, 178 => 'Prefs' },
	'preservedfilename' => { 215 => 'PreservedFileName' },
	'previewapplicationname' => { 58 => 0xc716 },
	'previewapplicationversion' => { 58 => 0xc717 },
	'previewcolorspace' => { 58 => 0xc71a },
	'previewdatetime' => { 58 => 0xc71b },
	'previewheight' => { 71 => 0xfa58 },
	'previewimage' => { 55 => 0x2000, 56 => 'PreviewImage', 57 => 'MakN', 58 => 0x927c, 60 => 0x4, 92 => 'data', 100 => 0x81, 152 => 0x280, 162 => 0x2e, 187 => 0x2001 },
	'previewimageborders' => { 174 => 0x3e },
	'previewimageheight' => { 29 => 0x4 },
	'previewimagelength' => { 29 => 0x2, 55 => 0x3, 58 => [0x117,0x202], 100 => 0x89, 123 => 0x202, 147 => 0x102, 152 => 0x1037, 174 => 0x3, 183 => 0x1e, 186 => 0x1b },
	'previewimagename' => { 92 => '1Name' },
	'previewimagesize' => { 55 => 0x2, 92 => 'ImageSize', 174 => 0x2, 186 => 0x1c },
	'previewimagestart' => { 29 => 0x5, 55 => 0x4, 58 => [0x111,0x201], 100 => 0x88, 123 => 0x201, 147 => 0x101, 152 => 0x1036, 174 => 0x4, 183 => 0x1c, 186 => 0x1a },
	'previewimagetype' => { 92 => '0Type' },
	'previewimagevalid' => { 147 => 0x100, 152 => 0x1035 },
	'previewimagewidth' => { 29 => 0x3 },
	'previewquality' => { 29 => 0x1 },
	'previewsettingsdigest' => { 58 => 0xc719 },
	'previewsettingsname' => { 58 => 0xc718 },
	'previewwidth' => { 71 => 0xfa57 },
	'primarychromaticities' => { 58 => 0x13f, 210 => 'PrimaryChromaticities' },
	'printim' => { 58 => 0xc4a5 },
	'privatertkinfo' => { 190 => 'privateRTKInfo' },
	'processingsoftware' => { 58 => 0xb },
	'producer' => { 156 => 'Producer', 203 => 'Producer' },
	'productid' => { 65 => 0x32 },
	'productioncode' => { 166 => 0x2 },
	'productorserviceconstraints' => { 205 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 58 => 0xc6f4 },
	'profilecopyright' => { 58 => 0xc6fe },
	'profileembedpolicy' => { 58 => 0xc6fd },
	'profilehuesatmapdata1' => { 58 => 0xc6fa },
	'profilehuesatmapdata2' => { 58 => 0xc6fb },
	'profilehuesatmapdims' => { 58 => 0xc6f9 },
	'profilelooktabledata' => { 58 => 0xc726 },
	'profilelooktabledims' => { 58 => 0xc725 },
	'profilename' => { 58 => 0xc6f8 },
	'profiletonecurve' => { 58 => 0xc6fc },
	'programiso' => { 161 => 0x3c },
	'programline' => { 167 => '1.1' },
	'programmode' => { 102 => 0x5 },
	'programshift' => { 120 => 0xd },
	'programversion' => { 64 => 0x46 },
	'projectrefpath' => { 214 => 'projectRefPath' },
	'projectreftype' => { 214 => 'projectRefType' },
	'propertyreleaseid' => { 205 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 205 => 'PropertyReleaseStatus' },
	'province-state' => { 64 => 0x5f },
	'publicationdate' => { 206 => 'publicationDate' },
	'publicationname' => { 206 => 'publicationName' },
	'publisher' => { 198 => 'publisher' },
	'pulldown' => { 214 => 'pullDown' },
	'quality' => { 0 => 0x1, 13 => 0x3, 54 => 0x2, 55 => 0x3002, 62 => 0x1000, 70 => 0x9, 120 => 0x4, 130 => 0x3, 152 => 0x201, 159 => 0x300, 174 => 0x8, 176 => 0x2, 186 => 0x16, 187 => [0x102,0xb047] },
	'qualitymode' => { 55 => 0x8 },
	'quantizationmethod' => { 66 => 0x78 },
	'quickadjust' => { 143 => 0x2a },
	'quickcontroldialinmeter' => { 35 => 0x703 },
	'quickshot' => { 185 => 0x213 },
	'rasterizedcaption' => { 64 => 0x7d },
	'rating' => { 58 => 0x4746, 177 => 0xdf, 199 => 'rating', 212 => 'Rating' },
	'ratingpercent' => { 58 => 0x4749, 193 => 'Rating' },
	'rawandjpgrecording' => { 33 => 0x8, 167 => 0xd },
	'rawbrightnessadj' => { 52 => 0x38 },
	'rawcoloradj' => { 52 => 0x2e },
	'rawcolortoneadj' => { 53 => 0xd },
	'rawcontrastadj' => { 53 => 0xf },
	'rawcropbottom' => { 177 => 0xd4 },
	'rawcropleft' => { 177 => 0xd1 },
	'rawcropright' => { 177 => 0xd3 },
	'rawcroptop' => { 177 => 0xd2 },
	'rawcustomsaturation' => { 52 => 0x30 },
	'rawcustomtone' => { 52 => 0x34 },
	'rawdatauniqueid' => { 58 => 0xc65d },
	'rawdepth' => { 101 => 0x10 },
	'rawdevautogradation' => { 154 => 0x119 },
	'rawdevcolorspace' => { 153 => 0x108, 154 => 0x109 },
	'rawdevcontrastvalue' => { 153 => 0x106, 154 => 0x105 },
	'rawdeveditstatus' => { 153 => 0x10b },
	'rawdevengine' => { 153 => 0x109, 154 => 0x10b },
	'rawdevexposurebiasvalue' => { 153 => 0x100, 154 => 0x100 },
	'rawdevgradation' => { 154 => 0x112 },
	'rawdevgraypoint' => { 153 => 0x103, 154 => 0x104 },
	'rawdevmemorycoloremphasis' => { 153 => 0x105, 154 => 0x108 },
	'rawdevnoisereduction' => { 153 => 0x10a, 154 => 0x10a },
	'rawdevpicturemode' => { 154 => 0x10c },
	'rawdevpm_bwfilter' => { 154 => 0x110 },
	'rawdevpmcontrast' => { 154 => 0x10e },
	'rawdevpmnoisefilter' => { 154 => 0x120 },
	'rawdevpmpicturetone' => { 154 => 0x111 },
	'rawdevpmsaturation' => { 154 => 0x10d },
	'rawdevpmsharpness' => { 154 => 0x10f },
	'rawdevsaturation3' => { 154 => 0x113 },
	'rawdevsaturationemphasis' => { 153 => 0x104, 154 => 0x107 },
	'rawdevsettings' => { 153 => 0x10c },
	'rawdevsharpnessvalue' => { 153 => 0x107, 154 => 0x106 },
	'rawdevversion' => { 153 => 0x0, 154 => 0x0 },
	'rawdevwbfineadjustment' => { 153 => 0x102, 154 => 0x103 },
	'rawdevwhitebalance' => { 154 => 0x101 },
	'rawdevwhitebalancevalue' => { 153 => 0x101, 154 => 0x102 },
	'rawfile' => { 58 => 0xfe4c },
	'rawfilename' => { 197 => 'RawFileName' },
	'rawhighlightpoint' => { 53 => 0x12 },
	'rawimagecenter' => { 120 => 0x99 },
	'rawimagedigest' => { 58 => 0xc71c },
	'rawimagesize' => { 174 => 0x39 },
	'rawinfoversion' => { 155 => 0x0 },
	'rawjpgheight' => { 50 => 0x4 },
	'rawjpgquality' => { 22 => 0x6, 50 => 0x1 },
	'rawjpgsize' => { 22 => 0x7, 50 => 0x2 },
	'rawjpgwidth' => { 50 => 0x3 },
	'rawlinear' => { 53 => 0x10 },
	'rawsaturationadj' => { 53 => 0xe },
	'rawshadowpoint' => { 53 => 0x13 },
	'rawsharpnessadj' => { 53 => 0x11 },
	'recordid' => { 48 => 0x1804 },
	'recordingmode' => { 54 => 0x1, 176 => 0x1 },
	'recordmode' => { 13 => 0x9, 55 => 0x3000 },
	'recordshutterrelease' => { 185 => 0x217 },
	'redbalance' => { 152 => 0x1017, 162 => 0x11, 174 => 0x1c },
	'redcurvelimits' => { 52 => 0x18a },
	'redcurvepoints' => { 52 => 0x160 },
	'redeyecorrection' => { 144 => 0x0 },
	'redeyeinfo' => { 197 => 'RedEyeInfo' },
	'redhue' => { 197 => 'RedHue' },
	'redsaturation' => { 197 => 'RedSaturation' },
	'referenceblackwhite' => { 58 => 0x214, 210 => 'ReferenceBlackWhite' },
	'referencedate' => { 64 => 0x2f },
	'referencenumber' => { 64 => 0x32 },
	'references' => { 83 => 'References' },
	'referenceservice' => { 64 => 0x2d },
	'regionconstraints' => { 205 => 'RegionConstraints' },
	'regionpersondisplayname' => { 191 => 'RegionInfoRegionsPersonDisplayName' },
	'regionrectangle' => { 191 => 'RegionInfoRegionsRectangle' },
	'registryitemid' => { 202 => 'RegistryIdRegItemId' },
	'registryorganisationid' => { 202 => 'RegistryIdRegOrgId' },
	'relatedaudiofile' => { 81 => 'data' },
	'relatedaudiofilename' => { 81 => '1Name' },
	'relatedaudiofiletype' => { 81 => '0Type' },
	'relatedimagefileformat' => { 58 => 0x1000 },
	'relatedimageheight' => { 58 => 0x1002 },
	'relatedimagewidth' => { 58 => 0x1001 },
	'relatedsoundfile' => { 58 => 0xa004, 200 => 'RelatedSoundFile' },
	'relatedvideofile' => { 95 => 'data' },
	'relatedvideofilename' => { 95 => '1Name' },
	'relatedvideofiletype' => { 95 => '0Type' },
	'relation' => { 198 => 'relation' },
	'relativepeakaudiofilepath' => { 214 => 'relativePeakAudioFilePath' },
	'relativetimestampscale' => { 214 => 'relativeTimestampScale' },
	'relativetimestampvalue' => { 214 => 'relativeTimestampValue' },
	'releasebuttontousedial' => { 127 => '807.8' },
	'releasedate' => { 64 => 0x1e, 214 => 'releaseDate' },
	'releasesetting' => { 48 => 0x1016 },
	'releasetime' => { 64 => 0x23 },
	'remoteonduration' => { 128 => '732.4', 129 => '752.3' },
	'renditionclass' => { 215 => 'RenditionClass' },
	'renditionofalternatepaths' => { 215 => 'RenditionOfAlternatePaths' },
	'renditionofdocumentid' => { 215 => 'RenditionOfDocumentID' },
	'renditionoffilepath' => { 215 => 'RenditionOfFilePath' },
	'renditionoffrompart' => { 215 => 'RenditionOfFromPart' },
	'renditionofinstanceid' => { 215 => 'RenditionOfInstanceID' },
	'renditionoflastmodifydate' => { 215 => 'RenditionOfLastModifyDate' },
	'renditionofmanager' => { 215 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 215 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 215 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 215 => 'RenditionOfManageUI' },
	'renditionofmaskmarkers' => { 215 => 'RenditionOfMaskMarkers' },
	'renditionofpartmapping' => { 215 => 'RenditionOfPartMapping' },
	'renditionofrenditionclass' => { 215 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 215 => 'RenditionOfRenditionParams' },
	'renditionoftopart' => { 215 => 'RenditionOfToPart' },
	'renditionofversionid' => { 215 => 'RenditionOfVersionID' },
	'renditionparams' => { 215 => 'RenditionParams' },
	'repeatingflashcount' => { 112 => 0xd, 113 => 0xe, 114 => 0xe, 129 => '757.2' },
	'repeatingflashoutput' => { 129 => '757.1' },
	'repeatingflashrate' => { 112 => 0xc, 113 => 0xd, 114 => 0xd, 129 => '758.1' },
	'resampleparamsquality' => { 214 => 'resampleParamsQuality' },
	'resaved' => { 185 => 0x21e },
	'resolution' => { 88 => 'Resolution' },
	'resolutionmode' => { 186 => 0x4 },
	'resolutionunit' => { 58 => 0x128, 67 => 0x2, 210 => 'ResolutionUnit' },
	'restrictions' => { 208 => 'restrictions' },
	'retouchhistory' => { 120 => 0x9e },
	'retouchinfo' => { 197 => 'RetouchInfo' },
	'reuse' => { 205 => 'Reuse' },
	'reuseallowed' => { 217 => 'ReuseAllowed' },
	'reuseprohibited' => { 208 => 'reuseProhibited' },
	'reverseindicators' => { 127 => '802.1' },
	'revision' => { 199 => 'revision' },
	'rgbcurvelimits' => { 52 => 0x238 },
	'rgbcurvepoints' => { 52 => 0x20e },
	'ricohdate' => { 183 => 0x6 },
	'ricohimageheight' => { 183 => 0x2 },
	'ricohimagewidth' => { 183 => 0x0 },
	'rightascension' => { 91 => 'RightAscension' },
	'rights' => { 198 => 'rights' },
	'rightsagent' => { 206 => 'rightsAgent', 208 => 'rightsAgent' },
	'rightsowner' => { 208 => 'rightsOwner' },
	'romoperationmode' => { 48 => 0x80d },
	'rotation' => { 12 => 0x17, 47 => 0x3, 52 => 0x26e, 61 => 0x4, 91 => 'Rotation', 97 => [0x65,0x50], 98 => 0x46, 99 => 0x5a, 129 => '590.1', 140 => 0x76a43207, 161 => 0x30, 167 => '17.2', 177 => 0xd8 },
	'routing' => { 182 => 'Routing' },
	'rowsperstrip' => { 58 => 0x116 },
	'rpp' => { 194 => 'rpp' },
	'safetyshift' => { 35 => 0x108 },
	'safetyshiftinavortv' => { 33 => 0x10, 34 => 0x10, 36 => 0xf, 37 => 0x10, 40 => 0x10 },
	'samplebits' => { 81 => 'SampleBits' },
	'samplerate' => { 81 => 'SampleRate' },
	'samplesperpixel' => { 58 => 0x115, 210 => 'SamplesPerPixel' },
	'samplestructure' => { 66 => 0x5a },
	'sanyoquality' => { 185 => 0x201 },
	'sanyothumbnail' => { 185 => 0x100 },
	'saturation' => { 4 => 0x6e, 6 => 0x76, 13 => 0xe, 19 => 0x1, 54 => 0xd, 55 => [0x3013,0x1f], 58 => [0xa409,0xfe55], 62 => 0x1003, 82 => 'Saturation', 96 => 0x1f, 97 => 0x32, 98 => 0x28, 99 => 0x1a, 102 => 0x1, 120 => [0x94,0xaa], 122 => 0x35, 161 => 0x40, 174 => 0x1f, 176 => 0xd, 183 => 0x28, 186 => 0x10, 197 => 'Saturation', 200 => 'Saturation' },
	'saturationadj' => { 52 => 0x116, 139 => 0x1, 143 => 0x2e },
	'saturationadjustmentaqua' => { 197 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 197 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 197 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 197 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 197 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 197 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 197 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 197 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 10 => 0xfe },
	'saturationinfo' => { 174 => 0x21b },
	'saturationlandscape' => { 10 => 0xfc },
	'saturationneutral' => { 10 => 0xfd },
	'saturationportrait' => { 10 => 0xfb },
	'saturationsetting' => { 155 => 0x1010 },
	'saturationstandard' => { 10 => 0xfa },
	'saturationuserdef1' => { 10 => 0x100 },
	'saturationuserdef2' => { 10 => 0x101 },
	'saturationuserdef3' => { 10 => 0x102 },
	'saveid' => { 215 => 'SaveID' },
	'scaletype' => { 214 => 'scaleType' },
	'scanimageenhancer' => { 125 => 0x60 },
	'scanningdirection' => { 66 => 0x64 },
	'scene' => { 201 => 'Scene', 214 => 'scene' },
	'scenearea' => { 150 => 0x211, 152 => 0x1031 },
	'sceneassist' => { 120 => 0x9c },
	'scenecapturetype' => { 58 => 0xa406, 200 => 'SceneCaptureType' },
	'scenedetect' => { 150 => 0x210, 152 => 0x1030 },
	'scenedetectdata' => { 150 => 0x212, 152 => 0x1033 },
	'scenemode' => { 71 => 0xfa02, 100 => 0x100, 120 => 0x8f, 147 => 0x509, 152 => 0x403, 161 => 0x8001, 187 => 0xb023 },
	'scenemodeused' => { 73 => [0x6002,0xf002] },
	'sceneselect' => { 185 => 0x21f },
	'scenetype' => { 58 => 0xa301, 200 => 'SceneType' },
	'section' => { 206 => 'section' },
	'securityclassification' => { 58 => 0x9212 },
	'selectableafpoint' => { 35 => 0x509 },
	'selftimer' => { 13 => 0x2, 55 => 0x3001, 161 => 0x2e, 185 => 0x214 },
	'selftimer2' => { 32 => 0x1d },
	'selftimermode' => { 58 => 0x882b },
	'selftimertime' => { 48 => 0x1806, 127 => '808.1', 128 => '732.3', 129 => '751.3' },
	'seminfo' => { 58 => 0x8546 },
	'sensingmethod' => { 58 => 0xa217, 200 => 'SensingMethod' },
	'sensitivityadjust' => { 174 => 0x40 },
	'sensitivitysteps' => { 167 => '17.4', 169 => 0x1 },
	'sensorbluelevel' => { 30 => 0x5 },
	'sensorcleaning' => { 41 => 0xd },
	'sensorfullheight' => { 68 => 0xf904 },
	'sensorfullwidth' => { 68 => 0xf903 },
	'sensorheight' => { 68 => 0xf901, 71 => 0xfa21, 101 => 0x8 },
	'sensorpixelsize' => { 120 => 0x9a },
	'sensorredlevel' => { 30 => 0x4 },
	'sensorsize' => { 82 => 'SensorSize' },
	'sensortemperature' => { 150 => 0x1500, 152 => 0x1007 },
	'sensorwidth' => { 68 => 0xf900, 71 => 0xfa20, 101 => 0xa },
	'sequencenumber' => { 32 => 0x9, 55 => 0x301c, 62 => 0x1101, 70 => 0x1d, 161 => 0x2b },
	'sequenceshotinterval' => { 185 => 0x224 },
	'sequentialshot' => { 185 => 0x20e },
	'serialnumber' => { 25 => 0xc, 48 => 0x180b, 58 => 0xfde9, 68 => 0xfa04, 71 => 0xfa19, 79 => 0x0, 80 => 0xa8, 82 => 'SerialNumber', 120 => 0xa0, 148 => 0x101, 152 => [0x404,0x101a], 159 => 0x303, 186 => 0x2, 195 => 'SerialNumber' },
	'serialnumberformat' => { 25 => 0x15, 48 => 0x183b },
	'seriesdatetime' => { 189 => 'SeriesDateTime' },
	'seriesdescription' => { 189 => 'SeriesDescription' },
	'seriesmodality' => { 189 => 'SeriesModality' },
	'seriesnumber' => { 189 => 'SeriesNumber' },
	'serviceidentifier' => { 65 => 0x1e },
	'setbuttoncrosskeysfunc' => { 38 => 0x0, 39 => 0x0 },
	'setbuttonfunction' => { 33 => 0x1, 41 => 0xc },
	'setbuttonwhenshooting' => { 35 => 0x704 },
	'setfunctionwhenshooting' => { 36 => 0x0, 37 => 0x1, 40 => 0x1 },
	'shadingcompensation' => { 147 => 0x50c },
	'shadingcompensation2' => { 151 => 0x1012 },
	'shadow' => { 186 => 0xe },
	'shadowprotection' => { 139 => 0x0 },
	'shadows' => { 58 => 0xfe52, 197 => 'Shadows' },
	'shadowscale' => { 58 => 0xc633 },
	'shadowtint' => { 197 => 'ShadowTint' },
	'shakereduction' => { 175 => 0x1 },
	'sharpendetail' => { 197 => 'SharpenDetail' },
	'sharpenedgemasking' => { 197 => 'SharpenEdgeMasking' },
	'sharpeningadj' => { 143 => 0x2b },
	'sharpenradius' => { 197 => 'SharpenRadius' },
	'sharpness' => { 3 => [0x42,0x48], 4 => 0x72, 6 => 0x74, 13 => 0xf, 30 => 0x2, 54 => 0xb, 55 => [0x3011,0x21], 58 => [0xa40a,0xfe56], 62 => 0x1001, 70 => 0x6b, 77 => 0x37, 82 => 'Sharpness', 96 => 0x21, 97 => 0x30, 98 => 0x26, 99 => 0x18, 102 => 0x3, 120 => 0x6, 122 => 0x32, 152 => 0x100f, 161 => 0x41, 174 => 0x21, 176 => 0xb, 183 => 0x22, 184 => 0x1003, 186 => 0x11, 197 => 'Sharpness', 200 => 'Sharpness' },
	'sharpnessadj' => { 52 => 0x25a },
	'sharpnessfactor' => { 152 => 0x102a },
	'sharpnessfaithful' => { 10 => 0xf5 },
	'sharpnessfrequency' => { 3 => [0x41,0x47], 30 => 0x3 },
	'sharpnesslandscape' => { 10 => 0xf3 },
	'sharpnessmonochrome' => { 10 => 0xf6 },
	'sharpnessneutral' => { 10 => 0xf4 },
	'sharpnessportrait' => { 10 => 0xf2 },
	'sharpnesssetting' => { 147 => 0x506, 155 => 0x1013 },
	'sharpnessstandard' => { 10 => 0xf1 },
	'sharpnessuserdef1' => { 10 => 0xf7 },
	'sharpnessuserdef2' => { 10 => 0xf8 },
	'sharpnessuserdef3' => { 10 => 0xf9 },
	'shootinginfodisplay' => { 127 => '803.2' },
	'shootingmode' => { 82 => 'ShootingMode', 120 => 0x89, 161 => 0x1f },
	'shootingmodesetting' => { 128 => '734.1' },
	'shortdescription' => { 199 => 'shortdescription' },
	'shortdocumentid' => { 64 => 0xba },
	'shortfocal' => { 3 => 0xe, 4 => 0x11, 5 => 0x113, 6 => 0x11, 7 => 0xd8, 9 => 0xec, 10 => 0x93, 11 => 0xe8, 13 => 0x18 },
	'shortownername' => { 10 => 0xac },
	'shortreleasetimelag' => { 35 => 0x80d },
	'shotdate' => { 214 => 'shotDate' },
	'shotlocation' => { 214 => 'shotLocation' },
	'shotname' => { 214 => 'shotName' },
	'shutter-aelock' => { 33 => 0x4, 35 => 0x701, 36 => 0x3, 37 => 0x4, 38 => 0x3, 39 => 0x3, 40 => 0x4, 41 => 0x2 },
	'shutteraelbutton' => { 34 => 0x4 },
	'shutterbuttonafonbutton' => { 35 => 0x701 },
	'shuttercount' => { 5 => 0x176, 22 => 0x1, 126 => [0x6a,0x157,0x276], 127 => 0x279, 128 => 0x246, 129 => 0x24a, 174 => 0x5d },
	'shuttercurtainsync' => { 33 => 0xf, 34 => 0xf, 35 => 0x305, 36 => 0xe, 37 => 0xf, 38 => 0x8, 39 => 0x8, 40 => 0xf, 41 => 0x8 },
	'shuttermode' => { 70 => 0x1b },
	'shutterreleasebuttonae-l' => { 127 => '807.7' },
	'shutterreleasemethod' => { 48 => 0x1010 },
	'shutterreleasenocfcard' => { 33 => 0x2, 34 => 0x2, 41 => 0xf },
	'shutterreleasetiming' => { 48 => 0x1011 },
	'shutterspeedrange' => { 35 => 0x10c },
	'shutterspeedvalue' => { 44 => 0x1, 58 => 0x9201, 152 => 0x1000, 200 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 204 => 'SidecarForExtension' },
	'similarityindex' => { 64 => 0xe4 },
	'slaveflashmeteringsegments' => { 174 => 0x20b },
	'slowshutter' => { 32 => 0x8 },
	'slowsync' => { 62 => 0x1030 },
	'smoothness' => { 58 => 0xfe57, 197 => 'Smoothness' },
	'software' => { 58 => 0x131, 83 => 'Software', 158 => 'Software', 186 => 0x18, 210 => 'Software' },
	'softwareversion' => { 185 => 0x207 },
	'source' => { 64 => 0x73, 158 => 'Source', 198 => 'source', 199 => 'source', 204 => 'Source' },
	'spatialfrequencyresponsecolumns' => { 200 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 200 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 200 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 200 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 214 => 'speakerPlacement' },
	'specialinstructions' => { 64 => 0x28 },
	'specialmode' => { 152 => 0x200, 185 => 0x200 },
	'spectralsensitivity' => { 58 => 0x8824, 200 => 'SpectralSensitivity' },
	'splittoningbalance' => { 197 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 197 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 197 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 197 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 197 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 96 => 0x2d },
	'spotfocuspointy' => { 96 => 0x2e },
	'spotmeteringmode' => { 13 => 0x27 },
	'spotmeterlinktoafpoint' => { 35 => 0x107 },
	'sractive' => { 167 => '17.1' },
	'srawquality' => { 13 => 0x2e },
	'srfocallength' => { 175 => 0x3 },
	'srhalfpresstime' => { 175 => 0x2 },
	'srresult' => { 175 => 0x0 },
	'startingpage' => { 206 => 'startingPage' },
	'starttimecodetimeformat' => { 214 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 214 => 'startTimecodeTimeValue' },
	'starttimecodevalue' => { 214 => 'startTimecodeValue' },
	'state' => { 87 => 'State', 204 => 'State' },
	'status' => { 192 => 'Status' },
	'storagemethod' => { 101 => 0x12 },
	'straightenangle' => { 140 => 0x2fc08431 },
	'stretchmode' => { 214 => 'stretchMode' },
	'studydatetime' => { 189 => 'StudyDateTime' },
	'studydescription' => { 189 => 'StudyDescription' },
	'studyid' => { 189 => 'StudyID' },
	'studyphysician' => { 189 => 'StudyPhysician' },
	'sub-location' => { 64 => 0x5c },
	'subfiledata' => { 90 => 'data' },
	'subfiledirectory' => { 90 => '1Directory' },
	'subfilemimetype' => { 90 => '2MIME' },
	'subfilename' => { 90 => '1Name' },
	'subfileresource' => { 90 => 'rsrc' },
	'subfiletype' => { 58 => 0xfe, 90 => '0Type' },
	'subject' => { 156 => 'Subject', 182 => 'Subject', 198 => 'subject', 203 => 'Subject' },
	'subjectarea' => { 200 => 'SubjectArea' },
	'subjectcode' => { 201 => 'SubjectCode' },
	'subjectdistance' => { 58 => 0x9206, 70 => 0x3e, 200 => 'SubjectDistance' },
	'subjectdistancerange' => { 58 => 0xa40c, 200 => 'SubjectDistanceRange' },
	'subjectlocation' => { 58 => [0x9214,0xa214], 200 => 'SubjectLocation' },
	'subjectprogram' => { 96 => 0x22 },
	'subjectreference' => { 64 => 0xc },
	'subsectime' => { 58 => 0x9290 },
	'subsectimedigitized' => { 58 => 0x9292 },
	'subsectimeoriginal' => { 58 => 0x9291 },
	'subsection1' => { 206 => 'subsection1' },
	'subsection2' => { 206 => 'subsection2' },
	'subsection3' => { 206 => 'subsection3' },
	'subsection4' => { 206 => 'subsection4' },
	'superimposeddisplay' => { 33 => 0xa, 35 => 0x510, 36 => 0x9, 37 => 0xa, 40 => 0xa, 41 => 0xe },
	'supplementalcategories' => { 64 => 0x14, 204 => 'SupplementalCategories' },
	'supplementaltype' => { 66 => 0x37 },
	'svisosetting' => { 167 => 0x14 },
	'switchtoregisteredafpoint' => { 34 => 0x12, 35 => 0x50a },
	'tagged' => { 177 => 0xdd },
	'tapename' => { 214 => 'tapeName' },
	'targetaperture' => { 32 => 0x4 },
	'targetcompressionratio' => { 46 => 0x1 },
	'targetdistancesetting' => { 48 => 0x1807 },
	'targetexposuretime' => { 32 => 0x5 },
	'targetimagetype' => { 48 => 0x100a },
	'teaser' => { 206 => 'teaser' },
	'teleconverter' => { 100 => 0x105, 187 => 0x105 },
	'temperature' => { 197 => 'Temperature' },
	'tempo' => { 214 => 'tempo' },
	'termsandconditionstext' => { 205 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 205 => 'TermsAndConditionsURL' },
	'textstamp' => { 161 => 0x3b },
	'thresholding' => { 58 => 0x107 },
	'thumbnailfilename' => { 48 => 0x817 },
	'thumbnailformat' => { 212 => 'ThumbnailsFormat' },
	'thumbnailheight' => { 71 => 0xfa55, 212 => 'ThumbnailsHeight' },
	'thumbnailimage' => { 48 => 0x2008, 56 => 'ThumbnailImage', 60 => 0x3, 93 => 'data', 152 => 0x100, 212 => 'ThumbnailsImage' },
	'thumbnailimagename' => { 93 => '1Name' },
	'thumbnailimagesize' => { 93 => 'ImageSize' },
	'thumbnailimagetype' => { 93 => '0Type' },
	'thumbnailimagevalidarea' => { 25 => 0x13 },
	'thumbnaillength' => { 58 => 0x202 },
	'thumbnailoffset' => { 58 => 0x201 },
	'thumbnailwidth' => { 71 => 0xfa54, 212 => 'ThumbnailsWidth' },
	'ticker' => { 206 => 'ticker' },
	'tilelength' => { 58 => 0x143 },
	'tilewidth' => { 58 => 0x142 },
	'time' => { 69 => 0x401, 174 => 0x7 },
	'timecreated' => { 64 => 0x3c, 70 => 0x14, 77 => 0x10, 178 => 'TimeCreated' },
	'timeperiod' => { 206 => 'timePeriod' },
	'timerfunctionbutton' => { 128 => '734.2' },
	'timerlength' => { 35 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 214 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 214 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 214 => 'timeScaleParamsQuality' },
	'timesent' => { 65 => 0x50 },
	'timesignature' => { 214 => 'timeSignature' },
	'timesincepoweron' => { 161 => 0x29 },
	'timestamp' => { 5 => 0x45e, 10 => 0x11c, 158 => 'TimeStamp' },
	'timestamp1' => { 5 => 0x45a },
	'timezone' => { 132 => 0x0 },
	'timezonecode' => { 51 => 0x1 },
	'timezoneinfo' => { 51 => 0x2 },
	'timezoneoffset' => { 58 => 0x882a },
	'tint' => { 197 => 'Tint' },
	'title' => { 83 => 'Title', 156 => 'Title', 158 => 'Title', 182 => 'Title', 198 => 'title', 203 => 'Title' },
	'tonecomp' => { 120 => 0x81 },
	'tonecurve' => { 30 => 0x1, 174 => 0x402, 197 => 'ToneCurve' },
	'tonecurveactive' => { 52 => 0x110 },
	'tonecurvefilename' => { 69 => 0x1391 },
	'tonecurvename' => { 197 => 'ToneCurveName' },
	'tonecurveproperty' => { 52 => 0x3c },
	'tonecurves' => { 174 => 0x403 },
	'toningeffect' => { 22 => 0xf, 120 => 0xb3, 122 => 0x38 },
	'toningeffectmonochrome' => { 10 => 0x108 },
	'toningsaturation' => { 122 => 0x39 },
	'totalzoom' => { 70 => 0x62 },
	'tracknumber' => { 214 => 'trackNumber' },
	'tracksframerate' => { 214 => 'TracksFrameRate' },
	'tracksmarkerscomment' => { 214 => 'TracksMarkersComment' },
	'tracksmarkerscuepointparamskey' => { 214 => 'TracksMarkersCuePointParamsKey' },
	'tracksmarkerscuepointparamsvalue' => { 214 => 'TracksMarkersCuePointParamsValue' },
	'tracksmarkerscuepointtype' => { 214 => 'TracksMarkersCuePointType' },
	'tracksmarkersduration' => { 214 => 'TracksMarkersDuration' },
	'tracksmarkerslocation' => { 214 => 'TracksMarkersLocation' },
	'tracksmarkersname' => { 214 => 'TracksMarkersName' },
	'tracksmarkersprobability' => { 214 => 'TracksMarkersProbability' },
	'tracksmarkersspeaker' => { 214 => 'TracksMarkersSpeaker' },
	'tracksmarkersstarttime' => { 214 => 'TracksMarkersStartTime' },
	'tracksmarkerstarget' => { 214 => 'TracksMarkersTarget' },
	'tracksmarkerstype' => { 214 => 'TracksMarkersType' },
	'trackstrackname' => { 214 => 'TracksTrackName' },
	'trackstracktype' => { 214 => 'TracksTrackType' },
	'trailersignature' => { 90 => 'zmie' },
	'transferfunction' => { 210 => 'TransferFunction' },
	'transmissionreference' => { 204 => 'TransmissionReference' },
	'trapped' => { 156 => 'Trapped', 203 => 'Trapped' },
	'travelday' => { 161 => 0x36 },
	'ttl_da_adown' => { 170 => 0x5 },
	'ttl_da_aup' => { 170 => 0x4 },
	'ttl_da_bdown' => { 170 => 0x7 },
	'ttl_da_bup' => { 170 => 0x6 },
	'tvexposuretimesetting' => { 167 => 0x12 },
	'type' => { 198 => 'type' },
	'uniquecameramodel' => { 58 => 0xc614 },
	'uniquedocumentid' => { 64 => 0xbb },
	'uniqueobjectname' => { 65 => 0x64 },
	'unknownblock' => { 151 => 0x1103 },
	'unknowncompensation' => { 186 => 0xc },
	'unknownev' => { 69 => 0x1 },
	'unknownnumber' => { 48 => 0x180b },
	'unsharp1color' => { 145 => 0x13 },
	'unsharp1halowidth' => { 145 => 0x19 },
	'unsharp1intensity' => { 145 => 0x17 },
	'unsharp1threshold' => { 145 => 0x1b },
	'unsharp2color' => { 145 => 0x2e },
	'unsharp2halowidth' => { 145 => 0x34 },
	'unsharp2intensity' => { 145 => 0x32 },
	'unsharp2threshold' => { 145 => 0x36 },
	'unsharp3color' => { 145 => 0x49 },
	'unsharp3halowidth' => { 145 => 0x4f },
	'unsharp3intensity' => { 145 => 0x4d },
	'unsharp3threshold' => { 145 => 0x51 },
	'unsharp4color' => { 145 => 0x64 },
	'unsharp4halowidth' => { 145 => 0x6a },
	'unsharp4intensity' => { 145 => 0x68 },
	'unsharp4threshold' => { 145 => 0x6c },
	'unsharpcount' => { 145 => 0x0 },
	'unsharpmask' => { 140 => 0x76a43200 },
	'urgency' => { 64 => 0xa, 204 => 'Urgency' },
	'url' => { 83 => 'URL', 158 => 'URL', 180 => 0x40b, 206 => 'url' },
	'usablemeteringmodes' => { 35 => 0x10a },
	'usableshootingmodes' => { 35 => 0x109 },
	'usage' => { 207 => 'usage' },
	'usagefee' => { 208 => 'usageFee' },
	'usageterms' => { 218 => 'UsageTerms' },
	'usercomment' => { 48 => 0x805, 58 => 0x9286, 200 => 'UserComment' },
	'userdef1picturestyle' => { 10 => 0x10c },
	'userdef2picturestyle' => { 10 => 0x10e },
	'userdef3picturestyle' => { 10 => 0x110 },
	'userfields' => { 192 => 'UserFields' },
	'userprofile' => { 159 => 0x302 },
	'usmlenselectronicmf' => { 34 => 0x7, 35 => 0x501 },
	'utmeasting' => { 94 => 'Easting' },
	'utmmapdatum' => { 94 => 'Datum' },
	'utmnorthing' => { 94 => 'Northing' },
	'utmzone' => { 94 => 'Zone' },
	'uv-irfiltercorrection' => { 159 => 0x325 },
	'validbits' => { 151 => 0x611, 152 => 0x102c },
	'validpixeldepth' => { 155 => 0x611 },
	'variousmodes' => { 70 => 0x26 },
	'variousmodes2' => { 70 => 0x3a },
	'variprogram' => { 120 => 0xab },
	'version' => { 62 => 0x0, 182 => 'Version', 197 => 'Version' },
	'versionid' => { 215 => 'VersionID' },
	'versionidentifier' => { 206 => 'versionIdentifier' },
	'versionscomments' => { 215 => 'VersionsComments' },
	'versionseventaction' => { 215 => 'VersionsEventAction' },
	'versionseventchanged' => { 215 => 'VersionsEventChanged' },
	'versionseventinstanceid' => { 215 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 215 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 215 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 215 => 'VersionsEventWhen' },
	'versionsmodifier' => { 215 => 'VersionsModifier' },
	'versionsmodifydate' => { 215 => 'VersionsModifyDate' },
	'versionsversion' => { 215 => 'VersionsVersion' },
	'vibrance' => { 197 => 'Vibrance' },
	'vibrationreduction' => { 126 => [0x75,0x82,0x1ae], 128 => '586.1', 129 => '590.2', 131 => 0x4 },
	'videoalphamode' => { 214 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 214 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 214 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 214 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 214 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 214 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 214 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 214 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 214 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 214 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 214 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 214 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 214 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 214 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 214 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 214 => 'videoColorSpace' },
	'videocompressor' => { 214 => 'videoCompressor' },
	'videofieldorder' => { 214 => 'videoFieldOrder' },
	'videoframerate' => { 214 => 'videoFrameRate' },
	'videoframesizeh' => { 214 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 214 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 214 => 'videoFrameSizeW' },
	'videomoddate' => { 214 => 'videoModDate' },
	'videopixelaspectratio' => { 214 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 214 => 'videoPixelDepth' },
	'viewfinderwarning' => { 127 => '803.4', 129 => '754.2' },
	'viewinfoduringexposure' => { 35 => 0x407 },
	'vignetteamount' => { 197 => 'VignetteAmount' },
	'vignettecontrol' => { 120 => 0x2a, 140 => 0x76a43205 },
	'vignettecontrolintensity' => { 140 => 0xac6bd5c0 },
	'vignettemidpoint' => { 197 => 'VignetteMidpoint' },
	'voicememo' => { 185 => 0x216 },
	'volume' => { 206 => 'volume' },
	'vr_0x66' => { 126 => 0x66 },
	'vrdoffset' => { 25 => 0xd0 },
	'wb_gbrglevels' => { 103 => 0x4 },
	'wb_glevel' => { 151 => 0x11f },
	'wb_glevel3000k' => { 151 => 0x113 },
	'wb_glevel3300k' => { 151 => 0x114 },
	'wb_glevel3600k' => { 151 => 0x115 },
	'wb_glevel3900k' => { 151 => 0x116 },
	'wb_glevel4000k' => { 151 => 0x117 },
	'wb_glevel4300k' => { 151 => 0x118 },
	'wb_glevel4500k' => { 151 => 0x119 },
	'wb_glevel4800k' => { 151 => 0x11a },
	'wb_glevel5300k' => { 151 => 0x11b },
	'wb_glevel6000k' => { 151 => 0x11c },
	'wb_glevel6600k' => { 151 => 0x11d },
	'wb_glevel7500k' => { 151 => 0x11e },
	'wb_grbglevels' => { 110 => 0x0 },
	'wb_rbgglevels' => { 107 => 0x0 },
	'wb_rblevels' => { 151 => 0x100 },
	'wb_rblevels3000k' => { 151 => 0x102 },
	'wb_rblevels3300k' => { 151 => 0x103 },
	'wb_rblevels3600k' => { 151 => 0x104 },
	'wb_rblevels3900k' => { 151 => 0x105 },
	'wb_rblevels4000k' => { 151 => 0x106 },
	'wb_rblevels4300k' => { 151 => 0x107 },
	'wb_rblevels4500k' => { 151 => 0x108 },
	'wb_rblevels4800k' => { 151 => 0x109 },
	'wb_rblevels5300k' => { 151 => 0x10a },
	'wb_rblevels6000k' => { 151 => 0x10b },
	'wb_rblevels6600k' => { 151 => 0x10c },
	'wb_rblevels7500k' => { 151 => 0x10d },
	'wb_rblevelsauto' => { 155 => 0x110 },
	'wb_rblevelscloudy' => { 155 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 155 => 0x132 },
	'wb_rblevelscwb1' => { 151 => 0x10e },
	'wb_rblevelscwb2' => { 151 => 0x10f },
	'wb_rblevelscwb3' => { 151 => 0x110 },
	'wb_rblevelscwb4' => { 151 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 155 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 155 => 0x131 },
	'wb_rblevelseveningsunlight' => { 155 => 0x124 },
	'wb_rblevelsfineweather' => { 155 => 0x122 },
	'wb_rblevelsshade' => { 155 => 0x120 },
	'wb_rblevelstungsten' => { 155 => 0x123 },
	'wb_rblevelsused' => { 155 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 155 => 0x133 },
	'wb_rgbglevels' => { 109 => 0x0 },
	'wb_rgblevels' => { 160 => 0xd },
	'wb_rggblevels' => { 103 => 0x4, 108 => 0x0 },
	'wb_rggblevelsasshot' => { 15 => 0x19, 16 => 0x22, 17 => 0x3f, 18 => 0x3f },
	'wb_rggblevelsauto' => { 14 => 0x0, 15 => 0x1e, 16 => 0x18, 17 => 0x44, 18 => 0x44 },
	'wb_rggblevelscloudy' => { 14 => 0xc, 15 => 0x2d, 16 => 0x31, 17 => 0x58, 18 => 0x5d, 174 => 0x20f },
	'wb_rggblevelscustom' => { 14 => 0x1c, 17 => 0x80 },
	'wb_rggblevelscustom1' => { 15 => 0x41 },
	'wb_rggblevelscustom2' => { 15 => 0x46 },
	'wb_rggblevelsdaylight' => { 14 => 0x4, 15 => 0x23, 16 => 0x27, 17 => 0x4e, 18 => 0x53, 174 => 0x20d },
	'wb_rggblevelsflash' => { 14 => 0x18, 15 => 0x3c, 16 => 0x45, 17 => 0x6c, 18 => 0x71, 174 => 0x214 },
	'wb_rggblevelsfluorescent' => { 14 => 0x14, 15 => 0x37, 16 => 0x3b, 17 => 0x62, 18 => 0x67 },
	'wb_rggblevelsfluorescentd' => { 174 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 174 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 174 => 0x213 },
	'wb_rggblevelskelvin' => { 14 => 0x20, 16 => 0x40, 17 => 0x67, 18 => 0x6c },
	'wb_rggblevelsmeasured' => { 17 => 0x49, 18 => 0x49 },
	'wb_rggblevelspc1' => { 16 => 0x90, 17 => 0x71 },
	'wb_rggblevelspc2' => { 16 => 0x95, 17 => 0x76 },
	'wb_rggblevelspc3' => { 16 => 0x9a, 17 => 0x7b },
	'wb_rggblevelsshade' => { 14 => 0x8, 15 => 0x28, 16 => 0x2c, 17 => 0x53, 18 => 0x58, 174 => 0x20e },
	'wb_rggblevelstungsten' => { 14 => 0x10, 15 => 0x32, 16 => 0x36, 17 => 0x5d, 18 => 0x62, 174 => 0x210 },
	'wb_rggblevelsunknown' => { 16 => 0x1d, 18 => 0x4e },
	'wb_rggblevelsunknown10' => { 16 => 0x72, 18 => 0x9e },
	'wb_rggblevelsunknown11' => { 16 => 0x77, 18 => 0xa3 },
	'wb_rggblevelsunknown12' => { 16 => 0x7c },
	'wb_rggblevelsunknown13' => { 16 => 0x81 },
	'wb_rggblevelsunknown14' => { 16 => 0x86 },
	'wb_rggblevelsunknown15' => { 16 => 0x8b },
	'wb_rggblevelsunknown16' => { 16 => 0x9f },
	'wb_rggblevelsunknown2' => { 16 => 0x4a, 18 => 0x76 },
	'wb_rggblevelsunknown3' => { 16 => 0x4f, 18 => 0x7b },
	'wb_rggblevelsunknown4' => { 16 => 0x54, 18 => 0x80 },
	'wb_rggblevelsunknown5' => { 16 => 0x59, 18 => 0x85 },
	'wb_rggblevelsunknown6' => { 16 => 0x5e, 18 => 0x8a },
	'wb_rggblevelsunknown7' => { 16 => 0x63, 18 => 0x8f },
	'wb_rggblevelsunknown8' => { 16 => 0x68, 18 => 0x94 },
	'wb_rggblevelsunknown9' => { 16 => 0x6d, 18 => 0x99 },
	'wbadjbluebalance' => { 146 => 0x8 },
	'wbadjcolortemp' => { 52 => 0x1a },
	'wbadjlighting' => { 146 => 0x15 },
	'wbadjlightingsubtype' => { 146 => 0x14 },
	'wbadjmode' => { 146 => 0x10 },
	'wbadjredbalance' => { 146 => 0x0 },
	'wbadjrgblevels' => { 52 => 0x8 },
	'wbadjtemperature' => { 146 => 0x18 },
	'wbadjtint' => { 146 => 0x25 },
	'wbadjustab' => { 161 => 0x46 },
	'wbadjustgm' => { 161 => 0x47 },
	'wbbluelevel' => { 159 => 0x324, 161 => 0x8006, 162 => 0x26 },
	'wbbracketmode' => { 22 => 0x9 },
	'wbbracketvalueab' => { 22 => 0xc },
	'wbbracketvaluegm' => { 22 => 0xd },
	'wbfinetuneactive' => { 52 => 0x24 },
	'wbfinetunesaturation' => { 52 => 0x28 },
	'wbfinetunetone' => { 52 => 0x2c },
	'wbgreenlevel' => { 159 => 0x323, 161 => 0x8005, 162 => 0x25 },
	'wbmediaimagesizesetting' => { 35 => 0x708 },
	'wbmode' => { 102 => 0x4, 152 => 0x1015 },
	'wbredlevel' => { 159 => 0x322, 161 => 0x8004, 162 => 0x24 },
	'wbscale' => { 103 => 0x0 },
	'wbshiftab' => { 30 => 0xc, 168 => 0x10 },
	'wbshiftgm' => { 30 => 0xd },
	'wbshiftmg' => { 168 => 0x11 },
	'webstatement' => { 218 => 'WebStatement' },
	'whitebalance' => { 2 => 0x6f, 3 => [0x44,0x4a], 4 => 0x36, 5 => 0x5e, 6 => 0x36, 7 => 0x6f, 8 => 0x6f, 9 => 0x6f, 10 => 0x54, 11 => 0x6f, 30 => 0x8, 32 => 0x7, 54 => 0x7, 55 => [0x19,0x2012], 58 => [0xa403,0xfe4e], 62 => 0x1002, 70 => 0x40, 96 => 0x3, 97 => 0xe, 98 => 0x4, 99 => 0xb, 120 => 0x5, 130 => 0x7, 159 => 0x304, 161 => 0x3, 174 => 0x19, 176 => 0x7, 183 => 0x26, 186 => [0x3c,0x7], 197 => 'WhiteBalance', 200 => 'WhiteBalance' },
	'whitebalance2' => { 147 => 0x500 },
	'whitebalanceadj' => { 52 => 0x18, 140 => 0x76a43204 },
	'whitebalancebias' => { 55 => 0x2011, 152 => 0x304, 161 => 0x23 },
	'whitebalanceblue' => { 30 => 0x7 },
	'whitebalancebracket' => { 147 => 0x502, 152 => 0x303 },
	'whitebalancecomp' => { 155 => 0x1001 },
	'whitebalancefinetune' => { 62 => 0x100a, 120 => 0xb, 187 => 0x112 },
	'whitebalancemode' => { 174 => 0x1a },
	'whitebalancered' => { 30 => 0x6 },
	'whitebalanceset' => { 167 => 0xa },
	'whitebalancetemperature' => { 147 => 0x501 },
	'whiteboard' => { 152 => 0x301 },
	'whitelevel' => { 58 => 0xc61d },
	'whitepoint' => { 58 => 0x13e, 174 => 0x201, 210 => 'WhitePoint' },
	'widefocuszone' => { 96 => 0x2f },
	'widerange' => { 185 => 0x20f },
	'wordcount' => { 206 => 'wordCount' },
	'workcolorspace' => { 52 => 0x270 },
	'worldtimelocation' => { 161 => 0x3a, 174 => 0x22 },
	'writer-editor' => { 64 => 0x7a },
	'x3filllight' => { 186 => 0x12 },
	'xmp' => { 59 => 'XMP' },
	'xmptoolkit' => { 211 => 'xmptk' },
	'xpauthor' => { 58 => 0x9c9d },
	'xpcomment' => { 58 => 0x9c9c },
	'xpkeywords' => { 58 => 0x9c9e },
	'xposition' => { 58 => 0x11e },
	'xpsubject' => { 58 => 0x9c9f },
	'xptitle' => { 58 => 0x9c9b },
	'xresolution' => { 58 => 0x11a, 67 => 0x3, 181 => 0x0, 210 => 'XResolution' },
	'xyresolution' => { 61 => 0x3 },
	'ycbcrcoefficients' => { 58 => 0x211, 210 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 58 => 0x213, 210 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 58 => 0x212, 210 => 'YCbCrSubSampling' },
	'yearcreated' => { 70 => 0x10, 77 => 0xc },
	'yposition' => { 58 => 0x11f },
	'yresolution' => { 58 => 0x11b, 67 => 0x5, 181 => 0x4, 210 => 'YResolution' },
	'zonematching' => { 100 => 0x10a, 102 => 0x3a, 187 => 0xb024 },
	'zonematchingon' => { 98 => 0x75 },
	'zoomsourcewidth' => { 13 => 0x24 },
	'zoomstepcount' => { 150 => 0x300, 152 => 0x100d },
	'zoomtargetwidth' => { 13 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitflag' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'chapter' => 1,
	'characterset' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalance4' => 1,
	'colorbalance4b' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'entrypoint' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrafieldlength' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filenamelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileversionnumber' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'gradientbasedcorractive' => 1,
	'gradientbasedcorramount' => 1,
	'gradientbasedcorrbrightness' => 1,
	'gradientbasedcorrclarity' => 1,
	'gradientbasedcorrcontrast' => 1,
	'gradientbasedcorrexposure' => 1,
	'gradientbasedcorrhue' => 1,
	'gradientbasedcorrmaskcenterweight' => 1,
	'gradientbasedcorrmaskdabs' => 1,
	'gradientbasedcorrmaskflow' => 1,
	'gradientbasedcorrmaskfullx' => 1,
	'gradientbasedcorrmaskfully' => 1,
	'gradientbasedcorrmaskradius' => 1,
	'gradientbasedcorrmaskvalue' => 1,
	'gradientbasedcorrmaskwhat' => 1,
	'gradientbasedcorrmaskzerox' => 1,
	'gradientbasedcorrmaskzeroy' => 1,
	'gradientbasedcorrsaturation' => 1,
	'gradientbasedcorrsharpness' => 1,
	'gradientbasedcorrwhat' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'howpublished' => 1,
	'http-equiv' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internalname' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mp' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikoncaptureoutput' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintcorrectionactive' => 1,
	'paintcorrectionamount' => 1,
	'paintcorrectionbrightness' => 1,
	'paintcorrectionclarity' => 1,
	'paintcorrectioncontrast' => 1,
	'paintcorrectionexposure' => 1,
	'paintcorrectionhue' => 1,
	'paintcorrectionmaskcenterweight' => 1,
	'paintcorrectionmaskdabs' => 1,
	'paintcorrectionmaskflow' => 1,
	'paintcorrectionmaskfullx' => 1,
	'paintcorrectionmaskfully' => 1,
	'paintcorrectionmaskradius' => 1,
	'paintcorrectionmaskvalue' => 1,
	'paintcorrectionmaskwhat' => 1,
	'paintcorrectionmaskzerox' => 1,
	'paintcorrectionmaskzeroy' => 1,
	'paintcorrectionsaturation' => 1,
	'paintcorrectionsharpness' => 1,
	'paintcorrectionwhat' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryafpoint' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'school' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'supermacro' => 1,
	'svgversion' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transform' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'x' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipversion' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2009, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
