#!/usr/bin/perl

print "LightSquid Config Checker, (c) 2005 Sergey Erokhin GNU GPL\n\n";

die "perl module File::Basename not found, please install !\n" if (!eval { require File::Basename });
use File::Basename;push (@INC,(fileparse($0))[1]);

die "can't access to lightsquid.cfg !!!\n" if (!eval { require "lightsquid.cfg" });
die "can't access to common.pl !!!\n"      if (!eval { require "common.pl" });

die "no: CGI.PM found, please install\n"   if (!eval { require CGI });

die "can't access to $logpath `access.log` file\ncheck \$logpath variable or privilege\n" unless (-f "$logpath/access.log");

print "LogPath   : $logpath\n";
open F,"<$logpath/access.log"          or die "can't access to `access.log` file, check privilege\n";
close F;

print "reportpath: $reportpath\n";
die "can't found report folder `$reportpath`\nplease check \$reportpath variable, create if need\n" unless (-d "$reportpath");

open F,">$reportpath/test.txt"         or die "can't create file in $reportpath folder, check privilege\n";
close F;
unlink "$reportpath/test.txt";

print "Lang      : $langpath/$lang\n";
open F,"<$langpath/$lang.lng"          or die "can't open language file $langpath/$lang.lng, check \$lang variable\n";
close F;

print "Template  : $tplpath/$templatename\n";
open F,"<$tplpath/$templatename/index.html" or die "can't open template $tplpath/$templatename folder, check \$templatename variable\n";
close F;

print "Ip2Name   : $ip2namepath/ip2name.$ip2name\n";
open F,"<$ip2namepath/ip2name.$ip2name"     or die "can't open file $ip2namepath/ip2name.$ip2name file, check \$ip2name variable\n";
close F;

die "\$skipurl variable empty !, read documentation !!!\n" if ($skipurl eq "");

if ($graphreport) {
  die "no: GD.PM found, please install or set \$graphreport=0 to disable\n"   if (!eval { require GD });
  require GD;
  die "no: GD::Polygon modules, please install or set \$graphreport=0 to disable\n" if (!eval { my $poly1 = new GD::Polygon });
  die "no: GD trouble, please install or set \$graphreport=0 to disable\n" if (!eval {  $im = new GD::Image(720,480) });
  if ($ttffont ne "") {
    die "can't access to TTF font $font file, check \$font variable or set \$ttffont = \"\" to disable\n" unless (-f $ttffont);
    die "no: TTF support in GD, please install, or set \$ttffont = \"\" to disable\n" if (!eval { $im = new GD::Image(720,480) ;$im->stringFT(0,$ttffont,7,0.0,0,437,"Hello World") });
  }    
}

print "\nall check passed, now try access to cgi part in browser\n";
