<?php

function getModuleName() { 
	return "createmailitemmodule"; 
}
function getModuleType() {
	return "item"; 
}
function getDialogTitle() {
	return _("Create E-Mail"); 
}

function getIncludes(){
	$includes = array(
			"client/modules/".getModuleName().".js",
			"client/widgets/suggestionlist.js",
			"client/modules/suggestemailaddressmodule.js",
			"client/layout/css/suggestionlayer.css",
			"client/layout/js/createmail.js"
	);
	
	if (FCKEDITOR_INSTALLED){
		$includes[] = FCKEDITOR_JS_PATH."/fckeditor.js";
	}
	
	return $includes;
}

function getJavaScript_onload(){ ?>

					window.waitForSaveResponse = false;
					var rootentryid = false;
					var attachNum = false;
					var data = new Object();
					data["storeid"] = <?=get("storeid", "false", "'")?>;
					data["parententryid"] = <?=get("parententryid","false", "'")?>;
					data["message_action"] = <?=get("message_action", "false", "'")?>;
					data["message_action_entryid"] = <?=(isset($_GET["message_action"]) && isset($_GET["entryid"]))?get("entryid", "false", "'"):"false"?>;

					// If attachNum is set then it is embedded message
					<? if(isset($_GET["attachNum"]) && is_array($_GET["attachNum"])) { ?>
						rootentryid = <?=get("rootentryid", "false", "'")?>;
						attachNum = new Array();
					
						<? foreach($_GET["attachNum"] as $attachNum) { ?>
							attachNum.push(<?=intval($attachNum)?>);
						<? } ?>
					<? } ?>

					module.init(moduleID);
					module.setData(data);
					module.open(<?=get("entryid", "false", "'")?>, rootentryid, attachNum);

					// Load Suggest Email Address module for the TO, CC and BCC fields
					var suggestEmailModule = webclient.dispatcher.loadModule("suggestEmailAddressModule");
					if(suggestEmailModule != null) {
						var suggestEmailModuleID = webclient.addModule(suggestEmailModule);
						suggestEmailModule.init(suggestEmailModuleID);
						// Setup TO field
						suggestlistTO = new suggestionList("create_email_to_fld", dhtml.getElementById("to"), suggestEmailModule);
						suggestEmailModule.addSuggestionList(suggestlistTO);
						// Setup CC field
						suggestlistCC = new suggestionList("create_email_cc_fld", dhtml.getElementById("cc"), suggestEmailModule);
						suggestEmailModule.addSuggestionList(suggestlistCC);
						// Setup BCC field
						suggestlistBCC = new suggestionList("create_email_bcc_fld", dhtml.getElementById("bcc"), suggestEmailModule);
						suggestEmailModule.addSuggestionList(suggestlistBCC);
					}

					if (FCKEDITOR_INSTALLED && parentWebclient.settings.get("createmail/mailformat","html")=="html"){
<?php
							// check if user language is supported by FCKEditor

							if (isset($_SESSION["lang"])){
								$client_lang = $_SESSION["lang"];
							}else{
								$client_lang = LANG;
							}

							$client_lang = str_replace("_","-",strtolower(substr($client_lang,0,5)));

							if (!file_exists(FCKEDITOR_JS_PATH."/editor/lang/".$client_lang.".js")){
								$client_lang = substr($client_lang,0,2);
								if (!file_exists(FCKEDITOR_JS_PATH."/editor/lang/".$client_lang.".js")){
									$client_lang = "en"; // always fall back to English
								}
							}
?>
						initEditor(true, "<?=FCKEDITOR_JS_PATH?>", "<?=$client_lang?>", <?=FCKEDITOR_SPELLCHECKER_ENABLED?"true":"false"?>);
					}else{
						dhtml.getElementById("use_html").value = "false";
					}

					if(parentWebclient.settings.get("createmail/from", "false") != "false"){
						var settingsFromFieldValue = parentWebclient.settings.get("createmail/from", "false");
						if(settingsFromFieldValue.length > 0){
							var settingsFromFieldValues = settingsFromFieldValue.split(",");
						}else{
							var settingsFromFieldValues = new Array();
						}
						var fromSelect = dhtml.getElementById("from", "select");
						if(fromSelect){
							for(var i=0;i<settingsFromFieldValues.length;i++){
								fromSelect.options[fromSelect.options.length] = new Option(settingsFromFieldValues[i], settingsFromFieldValues[i]);
							}
						}
					}else{
						var fromRow = dhtml.getElementById("from_row", "tr");
						if(fromRow){
							fromRow.style.display = "none";
						}
					}

					if (parentWebclient.settings.get("createmail/always_readreceipt", "false")=="true"){
						dhtml.getElementById("read_receipt_requested").value = "1";
					}
					module.setBody(false, false);

					// Fetch all the attributes that are passed in the URL
					<?	if (isset($_GET["to"])){ // for security reasons we need to urlencode this value for javascript ?>
							dhtml.getElementById("to").value = decodeURIComponent("<?=rawurlencode($_GET["to"])?>");
					<?	} ?>

					<? if(isset($_GET["cc"])) { ?>
							dhtml.getElementById("cc").value = decodeURIComponent("<?=rawurlencode($_GET["cc"])?>");
					<?  } ?>

					<? if(isset($_GET["bcc"])) { ?>
							dhtml.getElementById("bcc").value = decodeURIComponent("<?=rawurlencode($_GET["bcc"])?>");
					<?  } ?>

					<? if(isset($_GET["subject"])) { ?>
							dhtml.getElementById("subject").value = decodeURIComponent("<?=rawurlencode($_GET["subject"])?>");
					<?  } ?>

					if(dhtml.getElementById("use_html").value == "false") {
						<? if(isset($_GET["body"])) { ?>
								dhtml.getElementById("html_body").value = decodeURIComponent("<?=rawurlencode($_GET["body"])?>");
						<?  } ?>
						if (window.BROWSER_IE){
							dhtml.addEvent(-1, dhtml.getElementById("html_body"), "keydown", IE_tracCursorPosition);
							dhtml.addEvent(-1, dhtml.getElementById("html_body"), "click", IE_tracCursorPosition);
						}
					}

					if(dhtml.getElementById("from")){
						dhtml.addEvent(-1, dhtml.getElementById("from"), "change", changeFromAddress);
					}

					setChangeHandlers(dhtml.getElementById("to"));
					setChangeHandlers(dhtml.getElementById("cc"));
					setChangeHandlers(dhtml.getElementById("bcc"));
					setChangeHandlers(dhtml.getElementById("subject"));
					setChangeHandlers(dhtml.getElementById("html_body"));
					setChangeHandlers(dhtml.getElementById("from"));

					resizeBody();

					/**
					 * If setting is enabled to close opening readmail dialog when replying do so. 
					 * This also checks if the user is actually replying/forwarding and has not just
					 * clicked on the email address (hence the message_action check).
					 */
					if (parentWebclient.settings.get("createmail/close_on_reply", "no")=="yes" && opener.parentWebclient && data["message_action"]){
						opener.close();
					}

					dhtml.getElementById("to").focus();
					
					// Specifically enable default action on text fields
					dhtml.addEvent(false, dhtml.getElementById("to"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("cc"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("bcc"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("from"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("subject"), "contextmenu", forceDefaultActionEvent);
					dhtml.addEvent(false, dhtml.getElementById("html_body"), "contextmenu", forceDefaultActionEvent);
					
					// Set flag to take necessary decisions on attachments 
					module.messageAction = data["message_action"];

					// set cursor position
					setCursorPosition(module.messageAction);

					// Activate automatic saving to drafts folder
					if(parentWebclient.settings.get("createmail/autosave", "false") != "false"){
						var autosaveIntervalMin = (parentWebclient.settings.get("createmail/autosave_interval", 3));
						setInterval(function(){
							autosave();
						}, 60 * autosaveIntervalMin * 1000);
					}

					// Notify the ZarafaDnD Firefox extension that this dialog accepts dragged files
					allowDnDFiles();
<?php } // getJavaScript_onload

function getJavaScript_other(){
?>		
			var FCKEDITOR_INSTALLED = <?=(FCKEDITOR_INSTALLED?"true":"false")?>;
			var suggestlist;

			window.messageChanged = false;

			window.onbeforeunload = function(){
				if (window.messageChanged){
					return "<?=_("You can lose changes when you continue.")?>";
				}
			}

			function setChangeHandlers(element)
			{
				if (element){
					dhtml.addEvent(-1, element, "change", setMessageChanged);
					dhtml.addEvent(-1, element, "keypress", setMessageChanged);
				}
			}

			function setMessageChanged()
			{
				window.document.title = _("Create E-Mail")+"*";
				window.messageChanged = true;
				window.changedSinceLastAutoSave = true;
			}

			function setFCKMessageChanged(editorInstance)
			{
				setMessageChanged();
				if (window.BROWSER_IE) IE_tracCursorInEditor(editorInstance);
				return false;
			}


			function FCKeditor_OnComplete( editorInstance )
			{
			    editorInstance.Events.AttachEvent( 'OnSelectionChange', setFCKMessageChanged ) ;
			    
			    // set content of body if it is passed in URL
			    <? if(isset($_GET["body"])) { ?>
			    	editorInstance.SetHTML(decodeURIComponent("<?=rawurlencode($_GET["body"])?>"));
			    <? } ?>
			}
			
			var abSelection = "to";
			function abCallBack(recips)
			{
				for(key in recips) {
					if (key!="multiple" && key!="value"){
						dhtml.getElementById(key).value = recips[key].value;
					}
				}

				dhtml.getElementById(abSelection).select();
				dhtml.getElementById(abSelection).focus();
			}

<?php 
}


function getBody(){ 
	?>
		<input id="entryid" type="hidden">
		<input id="parent_entryid" type="hidden">
		<input id="message_class" type="hidden" value="IPM.Note">
		<input id="importance" type="hidden" value="1">
		<input id="use_html" type="hidden" value="true">
		<input id="sensitivity" type="hidden" value="0">
		<input id="read_receipt_requested" type="hidden" value="false">
		<input id="sent_representing_name" type="hidden" value="">
		<input id="sent_representing_email_address" type="hidden" value="">
		<input id="sent_representing_addrtype" type="hidden" value="SMTP">
		
		<div id="conflict"></div>

		<div class="properties">
			<table class="fixed_table_layout" width="100%" border="0" cellpadding="1" cellspacing="0">

				<tr id="from_row">
					<td class="propertynormal propertywidth" align="center"><?=_("From")?>:</td>
					<td>
						<select id="from" class="field from_select">
							<option></option>
						</select>
					</td>
				</tr>

				<?
					$recipients = array("to" => _("To"), "cc" => _("CC"), "bcc" => _("BCC"));

					$fields = "";					
					foreach($recipients as $key => $name) {
						$fields .= "fields[" . urlencode($key) . "]=" . urlencode($name) . "&";
					}
					
					foreach($recipients as $key => $recipient)
					{
				?>
					<tr>
						<td class="propertynormal propertywidth" align="center">
							<input class="button" type="button" value="<?=$recipient?>..." onclick="abSelection='<?=$key?>'; webclient.openModalDialog(module, 'addressbook', DIALOG_URL+'task=addressbook_modal&storeid=' + module.storeid + '&<?=$fields?>dest=<?=$key?>', 550, 410, abCallBack);">
						</td>
						<td>
							<input id="<?=$key?>" class="field" type="text">
						</td>
					</tr>
				<?
					}
				?>
				
				<tr>
					<td class="propertynormal propertywidth" align="center">
						<?=_("Subject")?>:
					</td>
					<td>
						<input id="subject" class="field" type="text">
					</td>
				</tr>
				<tr>
					<td class="propertynormal propertywidth" valign="top">
						<input class="button" type="button" value="<?=_("Attachments")?>:" onclick="webclient.openWindow(module, 'attachments', DIALOG_URL+'task=attachments_modal&store=' + module.storeid + '&entryid=' + (module.messageentryid?module.messageentryid:'') + '&dialog_attachments=' + dhtml.getElementById('dialog_attachments').value, 550, 350, '0');">
					</td>
					<td valign="top">
						<div id="itemattachments">&nbsp;</div>
					</td>
				</tr>
			</table>
		</div>
		
		<textarea id="html_body" cols="60" rows="12"></textarea>
<?php } // getBody


function getMenuButtons(){
	return array(
			array(
				'id'=>"send",
				'name'=>_("Send"),
				'title'=>_("Send new Mail"),
				'callback'=>'function(){submit_createmail(true);}',
				'shortcut'=>"S"
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"save",
				'name'=>"",
				'title'=>_("Save"),
				'callback'=>'function(){submit_createmail(false);}'
			),
			array(
				'id'=>"attachment",
				'name'=>"",
				'title'=>_("Add Attachments"),
				'callback'=>"function(){setMessageChanged();webclient.openWindow(module, 'attachments', DIALOG_URL+'task=attachments_modal&store=' + module.storeid + '&entryid=' + (module.messageentryid?module.messageentryid:'') + '&dialog_attachments=' + dhtml.getElementById('dialog_attachments').value, 550, 350, '0');}"
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"addsignature",
				'name'=>"",
				'title'=>_("Add Signature"),
				'callback'=>'eventMenuAddSignature'
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"checknames",
				'name'=>"",
				'title'=>_("Check Names"),
				'callback'=>'function(){checkNames();}'
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"priority_high",
				'name'=>"",
				'title'=>_("Priority: High"),
				'callback'=>"function(){setMessageChanged();setImportance(dhtml.getElementById('importance').value!=2?2:1);}"
			),
			array(
				'id'=>"priority_low",
				'name'=>"",
				'title'=>_("Priority: Low"),
				'callback'=>"function(){setMessageChanged();setImportance(dhtml.getElementById('importance').value!=0?0:1);}"
			),
			array(
				'id'=>"seperator",
				'name'=>"",
				'title'=>"",
				'callback'=>""
			),
			array(
				'id'=>"options",
				'name'=>_("Options"),
				'title'=>_("Options"),
				'callback'=>"function(){setMessageChanged();webclient.openModalDialog(module, 'options', DIALOG_URL+'task=mailoptions_modal', 310, 220, mailOptionsCallBack);}"
			)
		);
}  // getMenuButtons
?>
