/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef ECDEFS_H
#define ECDEFS_H

// Get permission type
#define ACCESS_TYPE_DENIED		1
#define ACCESS_TYPE_GRANT		2
#define ACCESS_TYPE_BOTH		3

#define	ecRightsNone			0x00000000L
#define ecRightsReadAny			0x00000001L
#define	ecRightsCreate			0x00000002L
#define	ecRightsEditOwned		0x00000008L
#define	ecRightsDeleteOwned		0x00000010L
#define	ecRightsEditAny			0x00000020L
#define	ecRightsDeleteAny		0x00000040L
#define	ecRightsCreateSubfolder	0x00000080L
#define	ecRightsFolderAccess	0x00000100L
//#define	ecrightsContact			0x00000200L
#define	ecRightsFolderVisible	0x00000400L

#define ecRightsTemplateNoRights	ecRightsFolderVisible
#define ecRightsTemplateReadOnly	ecRightsTemplateNoRights | ecRightsReadAny
#define ecRightsTemplateSecretary	ecRightsTemplateReadOnly | ecRightsCreate | ecRightsEditOwned | ecRightsDeleteOwned | ecRightsEditAny | ecRightsDeleteAny
#define ecRightsTemplateOwner		ecRightsTemplateSecretary | ecRightsCreateSubfolder | ecRightsFolderAccess

/* #define ecRightsTemplateReviewer	ecRightsTemplateReadOnly */
/* #define ecRightsTemplateAuthor		ecRightsTemplateReadOnly | ecRightsCreate | ecRightsEditOwned | ecRightsDeleteOwned */
/* #define ecRightsTemplateEditor		ecRightsTemplateReadOnly | ecRightsCreate | ecRightsEditAny | ecRightsDeleteAny */

#define ecRightsAll				0x000005FBL
#define ecRightsFullControl		0x000004FBL
#define ecRightsDefault			ecRightsNone | ecRightsFolderVisible
#define ecRightsDefaultPublic	ecRightsReadAny | ecRightsFolderVisible
#define	ecRightsAdmin			0x00001000L

#define	ecRightsAllMask			0x000015FBL

// Right change indication (state field in struct)
#define RIGHT_NORMAL				0x00
#define RIGHT_NEW					0x01
#define RIGHT_MODIFY				0x02
#define RIGHT_DELETED				0x04
#define RIGHT_AUTOUPDATE_DENIED		0x08

// Different types of userobjects
enum userobject_type_t {
	USEROBJECT_TYPE_USER = 1,
	USEROBJECT_TYPE_GROUP = 2,
	USEROBJECT_TYPE_CONTACT = 3,
	USEROBJECT_TYPE_COMPANY = 4,
	USEROBJECT_TYPE_NONACTIVE = 5
};

enum userobject_relation_t {
	OBJECTRELATION_GROUP_MEMBER = 1,
	OBJECTRELATION_COMPANY_VIEW = 2,
	OBJECTRELATION_COMPANY_ADMIN = 3,
	OBJECTRELATION_QUOTA_USERRECIPIENT = 4,
	OBJECTRELATION_QUOTA_COMPANYRECIPIENT = 5,
	OBJECTRELATION_USER_SENDAS = 6
};

// Warning, those values are the same as ECSecurity::eQuotaStatus
enum eQuotaStatus{ QUOTA_OK, QUOTA_WARN, QUOTA_SOFTLIMIT, QUOTA_HARDLIMIT};

enum userobject_admin_level_t {
	ADMIN_LEVEL_ADMIN = 1,		/* Administrator over user's own company. */
	ADMIN_LEVEL_SYSADMIN = 2		/* System administrator (same rights as SYSTEM). */
};

typedef struct _sECUser {
	unsigned int	ulUserId;
	char*			lpszUsername;	// username@companyname
	char*			lpszPassword;
	char*			lpszFullEmail;
	char*			lpszFullName;
	unsigned int	ulIsNonActive;
	unsigned int	ulIsAdmin;		// See userobject_admin_level_t
} ECUSER, *LPECUSER;

typedef struct _sECGroup {
	unsigned int	ulGroupId;
	char*			lpszGroupname; // groupname@companyname
	char*			lpszFullname;
}ECGROUP, *LPECGROUP;

typedef struct _sECCompany {
	unsigned int	ulCompanyId;
	unsigned int	ulAdministrator; // userid of the administrator
	char*			lpszCompanyname;
} ECCOMPANY, *LPECCOMPANY;

typedef struct _sECPermission {
	unsigned int	ulUserid;
	unsigned int	ulType;
	unsigned int	ulRights;
	unsigned int	ulState;
}ECPERMISSION, *LPECPERMISSION;

typedef struct _sECUserObject {
	char*				lpszName;		// Fullname or fallback on username/groupname (name@companyname)
	unsigned int		ulId;			// User or group id
	userobject_type_t	type;			// User type (user, group, etc...)
}ECUSEROBJECT, *LPECUSEROBJECT;

typedef struct _sECQuota {
	bool			bUseDefaultQuota;
	bool			bIsUserDefaultQuota; // Default quota for users within company
	long long		llWarnSize;
	long long		llSoftSize;
	long long		llHardSize;
}ECQUOTA, *LPECQUOTA;

typedef struct _sECQuotaStatus {
	long long		llStoreSize;
	eQuotaStatus	quotaStatus;
}ECQUOTASTATUS, *LPECQUOTASTATUS;


// Getuserobjectlist
#define ECUSEROBJECT_LIST_USERS_ACTIVE		0x00000001
#define ECUSEROBJECT_LIST_USERS_NONACTIVE	0x00000002
#define ECUSEROBJECT_LIST_USERS			ECUSEROBJECT_LIST_USERS_ACTIVE | ECUSEROBJECT_LIST_USERS_NONACTIVE
#define ECUSEROBJECT_LIST_GROUP			0x00000004
#define ECUSEROBJECT_LIST_COMPANY		0x00000008

// Flags for ns__submitMessage
#define EC_SUBMIT_LOCAL			0x00000000
#define EC_SUBMIT_MASTER		0x00000001

#define EC_SUBMIT_DOSENTMAIL	0x00000002

#endif
