# -*- coding: utf-8 -*-
#
# Copyright (C) 2005-2006 Edgewall Software
# Copyright (C) 2005-2006 Christopher Lenz <cmlenz@gmx.de>
# All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at http://trac.edgewall.com/license.html.
#
# This software consists of voluntary contributions made by many
# individuals. For the exact contribution history, see the revision
# history and logs, available at http://projects.edgewall.com/trac/.
#
# Author: Christopher Lenz <cmlenz@gmx.de>

from trac.core import *
from webadmin.web_ui import IAdminPageProvider


class ProjectAdminPage(Component):

    implements(IAdminPageProvider)

    # IAdminPageProvider methods

    def get_admin_pages(self, req):
        if req.perm.has_permission('TRAC_ADMIN'):
            yield ('general', 'General', 'basic', 'Basic Settings')

    def process_admin_request(self, req, cat, page, path_info):
        if req.method == "POST":
            self.config.set('project', 'name', req.args.get('name'))
            self.config.set('project', 'url', req.args.get('url'))
            self.config.set('project', 'descr', req.args.get('description'))
            self.config.save()
            req.redirect(self.env.href.admin(cat, page))

        req.hdf['admin.project'] = {
            'name': self.config.get('project', 'name'),
            'description': self.config.get('project', 'descr'),
            'url': self.config.get('project', 'url')
        }
        return 'admin_basics.cs', None
