<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 12 $
 * $Id: UserCount.php 12 2006-08-10 18:43:12Z ipso $
 * $Date: 2006-08-10 11:43:12 -0700 (Thu, 10 Aug 2006) $
 */
/*
 * Counts the total active/inactive/deleted users for each company once a day.
 *
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

$cuclf = new CompanyUserCountListFactory();
$cuclf->getActiveUsers();
if ( $cuclf->getRecordCount() > 0 ) {
	foreach( $cuclf as $cuc_obj ) {
		$user_counts[$cuc_obj->getColumn('company_id')]['active'] = $cuc_obj->getColumn('total');
	}
}

$cuclf->getInActiveUsers();
if ( $cuclf->getRecordCount() > 0 ) {
	foreach( $cuclf as $cuc_obj ) {
		$user_counts[$cuc_obj->getColumn('company_id')]['inactive'] = $cuc_obj->getColumn('total');
	}
}

$cuclf->getDeletedUsers();
if ( $cuclf->getRecordCount() > 0 ) {
	foreach( $cuclf as $cuc_obj ) {
		$user_counts[$cuc_obj->getColumn('company_id')]['deleted'] = $cuc_obj->getColumn('total');
	}
}

$cuclf->StartTransaction();
if ( isset($user_counts) AND count($user_counts) > 0 ) {
	foreach( $user_counts as $company_id => $user_count_arr) {

		$cucf = new CompanyUserCountFactory();
		$cucf->setCompany( $company_id );
		$cucf->setDateStamp( time() );
		if ( !isset($user_count_arr['active']) ) {
			$user_count_arr['active'] = 0;
		}
		$cucf->setActiveUsers( $user_count_arr['active'] );

		if ( !isset($user_count_arr['inactive']) ) {
			$user_count_arr['inactive'] = 0;
		}
		$cucf->setInActiveUsers( $user_count_arr['inactive'] );

		if ( !isset($user_count_arr['deleted']) ) {
			$user_count_arr['deleted'] = 0;
		}
		$cucf->setDeletedUsers( $user_count_arr['deleted']);

		Debug::text('Company ID: '. $company_id .' Active: '. $user_count_arr['active'] .' InActive: '. $user_count_arr['inactive'] .' Deleted: '. $user_count_arr['deleted'], __FILE__, __LINE__, __METHOD__, 10);

		if ( $cucf->isValid() ) {
			$cucf->Save();
		}
	}
}
$cuclf->CommitTransaction();

Debug::Display();
?>