<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2073 $
 * $Id: ViewMessage.php 2073 2008-08-22 18:41:21Z ipso $
 * $Date: 2008-08-22 11:41:21 -0700 (Fri, 22 Aug 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('message','enabled')
		OR !( $permission->Check('message','view') OR $permission->Check('message','view_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'View Message') ); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'object_type_id',
												'object_id',
												'parent_id',
												'id',
												'message_data',
												'ack_message_id',
												) ) );
$mf = new MessageFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'acknowledge_message':
		$mf->setId( $ack_message_id );
		$mf->setAckDate( TTDate::getTime() );
		$mf->setAckBy( $current_user->getId() );
		if ( $mf->isValid() ) {
			$mf->Save();

			Redirect::Page( URLBuilder::getURL( 	array('object_type_id' => $object_type_id, 'object_id' => $object_id, 'id' => $parent_id), 'ViewMessage.php') );
		}
		break;
	case 'submit_message':
		//Debug::setVerbosity(11);
		if ( !$permission->Check('message','enabled')
			OR !( $permission->Check('message','add') ) ) {

			$permission->Redirect( FALSE ); //Redirect

		}

		if ( isset($object_type_id) AND isset($object_id) ) {
			if ( !isset($parent_id) ) {
				$parent_id = 0;
			}

			$mf->setObjectType( $object_type_id );
			$mf->setObject( $object_id );
			$mf->setParent( $parent_id );
			$mf->setPriority();
			$mf->setStatus('UNREAD');
			$mf->setSubject( $message_data['subject'] );
			$mf->setBody( $message_data['body'] );

			if ( $mf->isValid() ) {
				$mf->Save();

				Redirect::Page( URLBuilder::getURL( 	array('object_type_id' => $object_type_id,'object_id' => $object_id, 'id' => $parent_id), 'ViewMessage.php') );

				break;
			}
		}
	default:
		if ( isset($object_type_id) AND isset($object_id) ) {
			BreadCrumb::setCrumb($title);

			$mlf = new MessageListFactory();

			$mlf->getByObjectTypeAndObjectAndId($object_type_id, $object_id, $id);

			$ack_message_id = NULL;
			$require_ack = FALSE;
			$i=0;
			foreach ($mlf as $message) {
				//Get user info
				$ulf = new UserListFactory();

				if ( $message->getRequireAck() == TRUE
						AND $message->isAck() == FALSE
						AND $ack_message_id == NULL
						AND $message->getCreatedBy() != $current_user->getId() ) {
					$require_ack = TRUE;
					$ack_message_id = $message->getId();
				}

				if ( $message->getAckBy() != '' ) {
					$ack_by_full_name = $ulf->getById( $message->getAckBy() )->getCurrent()->getFullName();
				} else {
					$ack_by_full_name = NULL;
				}

				$messages[] = array(
									'id' => $message->getId(),
									'parent_id' => $message->getParent(),
									'object_type' => $message->getObjectType(),
									'object_id' => $message->getObject(),
									'priority' => $message->getPriority(),
									'status' => $message->getStatus(),
									'require_ack' => $message->getRequireAck(),
									'ack_date' => $message->getAckDate(),
									'ack_by' => $message->getAckBy(),
									'ack_by_full_name' => $ack_by_full_name,
									'is_ack' => $message->isAck(),
									'subject' => $message->getSubject(),
									'body' => $message->getBody(),
									'created_date' => $message->getCreatedDate(),
									'created_by' => $message->getCreatedBy(),
									'created_by_full_name' => $ulf->getById( $message->getCreatedBy() )->getCurrent()->getFullName(),
									'updated_date' => $message->getUpdatedDate(),
									'updated_by' => $message->getUpdatedBy(),
									'deleted_date' => $message->getDeletedDate(),
									'deleted_by' => $message->getDeletedBy()
								);

				//Mark own messages as read.
				if ( $message->getCreatedBy() != $current_user->getId() ) {
					$mlf_b = new MessageListFactory();
					$message_obj = $mlf_b->getById( $message->getId() )->getCurrent();
					if ( $message_obj->getStatus() == 10 ) {
						$message_obj->setStatus(20);
						$message_obj->Save();
					}
				}

				if ( $i == 0 ) {
					$parent_id = $message->getId();
					$default_subject = 'Re: '.$message->getSubject();
				}

				$i++;
			}

			//Get object data
			$object_name_options = $mlf->getOptions('object_name');
			$smarty->assign_by_ref('object_name', $object_name_options[$object_type_id]);

			$smarty->assign_by_ref('messages', $messages);
			$smarty->assign_by_ref('message_data', $message_data);

			$smarty->assign_by_ref('default_subject', $default_subject);

			$smarty->assign_by_ref('total_messages', $i);

			$smarty->assign_by_ref('require_ack', $require_ack);
			$smarty->assign_by_ref('ack_message_id', $ack_message_id);
			$smarty->assign_by_ref('current_date', TTDate::getTime() );

			$smarty->assign_by_ref('id', $id);
			$smarty->assign_by_ref('object_type_id', $object_type_id);
			$smarty->assign_by_ref('object_id', $object_id);
		}

		break;
}

$smarty->assign_by_ref('mf', $mf);

$smarty->display('message/ViewMessage.tpl');
?>