<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2426 $
 * $Id: UserMessageList.php 2426 2009-02-18 22:39:19Z ipso $
 * $Date: 2009-02-18 14:39:19 -0800 (Wed, 18 Feb 2009) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('message','enabled')
		OR !( $permission->Check('message','view') OR $permission->Check('message','view_own') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

$smarty->assign('title', TTi18n::gettext($title = 'Message List')); // See index.php
BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'filter_folder_id',
												'ids',
												) ) );

$sort_array = NULL;
if ( $sort_column != '' ) {
	$sort_array = array($sort_column => $sort_order);
}

$mf = new MessageFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'new_message':
		Redirect::Page( URLBuilder::getURL( NULL, 'EditMessage.php', FALSE) );
		break;
	case 'delete':
	case 'undelete':
		//Debug::setVerbosity( 11 );
		if ( strtolower($action) == 'delete' ) {
			$delete = TRUE;
		} else {
			$delete = FALSE;
		}

		if ( is_array($ids) AND count($ids) > 0 AND ( $permission->Check('message','delete') OR $permission->Check('message','delete_own') ) ) {
			$mlf = new MessageListFactory();
			$mlf->StartTransaction();

			foreach ($ids as $id) {
				//Only allow them to delete message they created.
				$mlf->getByCompanyIdAndUserIdAndId( $current_company->getId(), $current_user->getId(), $id );
				foreach ($mlf as $m_obj) {
					$m_obj->setDeleted($delete);
					$m_obj->Save();
				}
			}
			$mlf->CommitTransaction();
		}

		Redirect::Page( URLBuilder::getURL( array('filter_folder_id' => $filter_folder_id ), 'UserMessageList.php') );

		break;
	default:
		$mlf = new MessageListFactory();

		$folder_options = $mf->getOptions('folder');

		Debug::text('Filter Folder ID: '. $filter_folder_id, __FILE__, __LINE__, __METHOD__,9);
		if ( !isset($filter_folder_id) OR !in_array($filter_folder_id, array_keys($folder_options) ) ) {
			Debug::text('Invalid Folder, using default ', __FILE__, __LINE__, __METHOD__,9);
			$filter_folder_id = 10;
		}

		//Make sure folder and sort columns stays as we switch pages.
		URLBuilder::setURL(NULL, array('filter_folder_id' => $filter_folder_id, 'sort_column' => $sort_column, 'sort_order' => $sort_order) );

		$mlf->getByUserIdAndFolder( $current_user->getId(), $filter_folder_id, $current_user_prefs->getItemsPerPage(), $page, NULL, $sort_array );

		$object_name_options = $mlf->getOptions('object_name');

		$pager = new Pager($mlf);

		$require_ack = FALSE;
		foreach ($mlf as $message) {
			//Get user info
			$ulf = new UserListFactory();

			if ( $message->isAck() == FALSE ) {
				$require_ack = TRUE;
			}

			if ( $message->getRequireAck() == TRUE ) {
				$show_ack_column = TRUE;
			}

			$sent_to_full_name = NULL;
			if ( $message->getColumn('sent_to_user_id') != FALSE ) {
				$ulf->getById( $message->getColumn('sent_to_user_id') );
				if ( $ulf->getRecordCount() > 0 ) {
					$sent_to_full_name = $ulf->getCurrent()->getFullName();
				}
			}

			$created_by_full_name = NULL;
			if ( $message->getCreatedBy() != FALSE ) {
				$ulf->getById( $message->getCreatedBy() );
				if ( $ulf->getRecordCount() > 0 ) {
					$created_by_full_name = $ulf->getCurrent()->getFullName();
				}
			}

			$messages[] = array(
								'id' => $message->getId(),
								'parent_id' => $message->getParent(),
								'object_type_id' => $message->getObjectType(),
								'object_type' => $object_name_options[$message->getObjectType()],
								'object_id' => $message->getObject(),
								'priority' => $message->getPriority(),
								'status_id' => $message->getStatus(),
								'require_ack' => $message->getRequireAck(),
								'ack_date' => $message->getAckDate(),
								'subject' => $message->getSubject(),
								'body' => $message->getBody(),
								'sent_to_user_id' => $message->getColumn('sent_to_user_id'),
								'sent_to_full_name' => $sent_to_full_name,
								'created_date' => $message->getCreatedDate(),
								'created_by' => $message->getCreatedBy(),
								'created_by_full_name' => $created_by_full_name,
								'updated_date' => $message->getUpdatedDate(),
								'updated_by' => $message->getUpdatedBy(),
								'deleted_date' => $message->getDeletedDate(),
								'deleted_by' => $message->getDeletedBy()
							);

		}
		//var_dump($messages);

		$smarty->assign_by_ref('messages', $messages);
		$smarty->assign_by_ref('require_ack', $require_ack);
		$smarty->assign_by_ref('show_ack_column', $show_ack_column);

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		$smarty->assign_by_ref('paging_data', $pager->getPageVariables() );

		break;
}

$smarty->assign_by_ref('mf', $mf);
$smarty->assign_by_ref('folder_options', $folder_options );
$smarty->assign_by_ref('filter_folder_id', $filter_folder_id );

$smarty->display('message/UserMessageList.tpl');
?>