<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditHelpGroup.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('help','enabled')
		OR !( $permission->Check('help','edit') OR $permission->Check('help','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Help Group Entries')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'help_data',
												'script',
												'name'
												) ) );

$hgcf = new HelpGroupControlFactory();

switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$hgcf->setId($help_data['id']);
		$hgcf->setHelp($help_data['selected_help_ids']);

		if ( $hgcf->isValid() ) {
			//$hgcf->Save();

			Redirect::Page( URLBuilder::getURL(NULL, 'HelpGroupControlList.php') );

			break;
		}

	default:
		$hgclf = new HelpGroupControlListFactory();

		if ( isset($script) AND !isset($id) ) {
			Debug::Text('Script and Name were passed, attempt lookup!', __FILE__, __LINE__, __METHOD__,10);

			$hgclf->getByScriptAndName( $script, $name );
			if ( $hgclf->getRecordCount() > 0 ) {
				$id = $hgclf->getCurrent()->getID();
				Debug::Text('Found already existing ID: '. $id, __FILE__, __LINE__, __METHOD__,10);
			} else {
				//$help_data = array( 'script_name' => $script, 'name' => $name);
			}
		}

		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$hgclf->getById($id);

			foreach ($hgclf as $help_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$help_data = array(
								'id' => $help_obj->getId(),
								'script_name' => $help_obj->getScriptName(),
								'name' => $help_obj->getName(),
								'help_ids' => $help_obj->getHelp(),
								'created_date' => $help_obj->getCreatedDate(),
								'created_by' => $help_obj->getCreatedBy(),
								'updated_date' => $help_obj->getUpdatedDate(),
								'updated_by' => $help_obj->getUpdatedBy(),
								'deleted_date' => $help_obj->getDeletedDate(),
								'deleted_by' => $help_obj->getDeletedBy(),
								'deleted' => $help_obj->getDeleted()
								);
			}
		}

		//Get all help items
		$hlf = new HelpListFactory();
		$help_options = $hlf->getAllArray();
		//Select box options;
		$help_data['help_options'] = $help_options;

		if ( isset($help_data['help_ids']) AND is_array($help_data['help_ids']) ) {
			foreach( $help_data['help_ids'] as $selected_help_id ) {
				$help_data['selected_help_options'][$selected_help_id] = $help_options[$selected_help_id];
			}
		}
		$smarty->assign_by_ref('help_data', $help_data);

		break;
}

$smarty->assign_by_ref('hgcf', $hgcf);

$smarty->display('help/EditHelpGroup.tpl');
?>