<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1644 $
 * $Id: CompanyDeductionList.php 1644 2008-01-14 22:38:23Z ipso $
 * $Date: 2008-01-14 14:38:23 -0800 (Mon, 14 Jan 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('company_tax_deduction','enabled')
		OR !( $permission->Check('company_tax_deduction','view') OR $permission->Check('company_tax_deduction','view_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Tax / Deduction List')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'ids',
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

$sort_array = NULL;
if ( $sort_column != '' ) {
	$sort_array = array($sort_column => $sort_order);
}

Debug::Arr($ids,'Selected Objects', __FILE__, __LINE__, __METHOD__,10);

$action = Misc::findSubmitButton();
switch ($action) {
	case 'add_presets':
		//Debug::setVerbosity(11);
		CompanyDeductionFactory::addPresets( $current_company->getId() );

		Redirect::Page( URLBuilder::getURL( NULL, 'CompanyDeductionList.php') );
	case 'add':

		Redirect::Page( URLBuilder::getURL( NULL, 'EditCompanyDeduction.php', FALSE) );

		break;
	case 'delete' OR 'undelete':
		if ( strtolower($action) == 'delete' ) {
			$delete = TRUE;
		} else {
			$delete = FALSE;
		}

		$cdlf = new CompanyDeductionListFactory();

		foreach ($ids as $id) {
			$cdlf->getByCompanyIdAndId($current_company->getId(), $id );
			foreach ($cdlf as $cd_obj) {
				$cd_obj->setDeleted($delete);
				if ( $cd_obj->isValid() ) {
					$cd_obj->Save();
				}
			}
		}

		Redirect::Page( URLBuilder::getURL( NULL, 'CompanyDeductionList.php') );

		break;
	default:
		BreadCrumb::setCrumb($title);

		$sort_array = NULL;
		if ( $sort_column != '' ) {
			$sort_array = array(Misc::trimSortPrefix($sort_column) => $sort_order);
		}

		$cdlf = new CompanyDeductionListFactory();
		$cdlf->getByCompanyId( $current_company->getId(), NULL, $sort_array );

		$pager = new Pager($cdlf);

		$status_options = $cdlf->getOptions('status');
		$type_options = $cdlf->getOptions('type');
		$calculation_options = $cdlf->getOptions('calculation');

		foreach ($cdlf as $cd_obj) {

			$rows[] = array(
								'id' => $cd_obj->getId(),
								'status_id' => $cd_obj->getStatus(),
								'status' => $status_options[$cd_obj->getStatus()],
								'type_id' => $cd_obj->getType(),
								'type' => $type_options[$cd_obj->getType()],
								'calculation_id' => $cd_obj->getCalculation(),
								'calculation' => $calculation_options[$cd_obj->getCalculation()],
								'calculation_order' => $cd_obj->getCalculationOrder(),
								'name' => $cd_obj->getName(),
								'deleted' => $cd_obj->getDeleted()
							);
		}
		$smarty->assign_by_ref('rows', $rows);

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		$smarty->assign_by_ref('paging_data', $pager->getPageVariables() );

		break;
}
$smarty->display('company/CompanyDeductionList.tpl');
?>