<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: UserWageListFactory.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Users
 */
class UserWageListFactory extends UserWageFactory implements IteratorAggregate {

	function getAll($limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
		$query = '
					select 	*
					from	'. $this->getTable() .'
					WHERE deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		if ($limit == NULL) {
			//Run query without limit
			$this->rs = $this->db->SelectLimit($query);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page);
		}

		return $this;
	}

	function getById($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		$this->rs = $this->getCache($id);
		if ( $this->rs === FALSE ) {
			$ph = array(
						'id' => $id,
						);

			$query = '
						select 	*
						from	'. $this->getTable() .'
						where	id = ?
							AND deleted = 0';
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			$this->saveCache($this->rs,$id);
		}

		return $this;
	}

	function getByCompanyId($id, $limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .' as a
					where	company_id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		if ($limit == NULL) {
			$this->rs = $this->db->Execute($query, $ph);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page, $ph);
		}

		return $this;
	}

	function getByIdAndCompanyId($id, $company_id, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $company_id == '') {
			return FALSE;
		}

		$uf = new UserFactory();

		$ph = array(
					'company_id' => $company_id,
					'id' => $id,
					);

		$query = '
					select 	a.*
					from 	'. $this->getTable() .' as a,
							'. $uf->getTable() .' as b
					where	a.user_id = b.id
						AND	b.company_id = ?
						AND	a.id = ?
						AND a.deleted = 0';
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByUserId($user_id, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		$ph = array(
					'user_id' => $user_id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	user_id = ?
						AND deleted = 0';
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getIsModifiedByUserIdAndDate($user_id, $date, $where = NULL, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $date == '') {
			return FALSE;
		}

		$ph = array(
					'user_id' => $user_id,
					'created_date' => $date,
					'updated_date' => $date,
					);

		//INCLUDE Deleted rows in this query.
		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	user_id = ?
						AND
							( created_date >= ? OR updated_date >= ? )
						';
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);
		if ( $this->getRecordCount() > 0 ) {
			Debug::text('User Tax rows have been modified: '. $this->getRecordCount(), __FILE__, __LINE__, __METHOD__,10);
			return TRUE;
		}
		Debug::text('User Tax rows have NOT been modified', __FILE__, __LINE__, __METHOD__,10);
		return FALSE;
	}


	//Grabs JUST the latest wage entry.
	function getLastWageByUserId($user_id) {
		if ( $user_id == '') {
			return FALSE;
		}

		$uf = new UserFactory();

		$ph = array(
					'user_id' => $user_id,
					);

		$query = '
					select 	b.*
					from	'. $uf->getTable() .' as a,
							'. $this->getTable() .' as b
					where	a.id = b.user_id
						AND	b.user_id = ?
						AND a.deleted = 0
						AND b.deleted = 0
					ORDER BY b.effective_date desc
					LIMIT 1';

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	//Grabs JUST the latest wage entry.
	function getLastWageByUserIdAndDate($user_id, $epoch) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $epoch == '') {
			return FALSE;
		}

		$uf = new UserFactory();

		$ph = array(
					'epoch' => $this->db->BindTimeStamp( $epoch ),
					);

		$query = '
					select a.*
					from '. $this->getTable() .' as a,
						(
						select 	z.user_id, max(effective_date) as effective_date
						from	'. $this->getTable() .' as z
						where
							z.effective_date <= ?
							AND z.user_id in ('. $this->getListSQL( $user_id, $ph ) .')
							AND ( z.deleted = 0 )
						GROUP BY z.user_id
						) as b,
						'. $uf->getTable() .' as c
					WHERE a.user_id = b.user_id
						AND a.effective_date = b.effective_date
						AND a.user_id = c.id
						AND ( c.deleted = 0	AND a.deleted = 0)
				';

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getWageByUserIdAndPayPeriodEndDate($user_id, $pay_period_end_date) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $pay_period_end_date == '') {
			return FALSE;
		}

		$uf = new UserFactory();

		$ph = array(
					'user_id' => $user_id,
					'epoch' => $this->db->BindTimeStamp( $pay_period_end_date ),
					);

		$query = '
					select 	b.*
					from	'. $uf->getTable() .' as a,
							'. $this->getTable() .' as b
					where	a.id = b.user_id
						AND	b.user_id = ?
						AND b.effective_date <= ?
						AND (a.deleted = 0 AND b.deleted=0)
					ORDER BY b.effective_date desc
					LIMIT 1';

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByUserIdAndDate($user_id, $date) {
		if ( $user_id == '' ) {
			return FALSE;
		}

		if ( $date == '' ) {
			return FALSE;
		}

		$uf = new UserFactory();

		$ph = array(
					'user_id' => $user_id,
					'date' => $this->db->BindTimeStamp(  $date ),
					);

		$query = '
					select 	b.*
					from	'. $uf->getTable() .' as a,
							'. $this->getTable() .' as b
					where	a.id = b.user_id
						AND	b.user_id = ?
						AND b.effective_date <= ?
						AND (a.deleted = 0 AND b.deleted=0)
					ORDER BY b.effective_date desc
					LIMIT 1';

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByUserIdAndStartDateAndEndDate($user_id, $start_date = FALSE, $end_date = FALSE) {
		if ( $user_id == '' ) {
			return FALSE;
		}

		if ( $start_date == '' ) {
			$start_date = 0;
		}

		if ( $end_date == '' ) {
			$end_date = TTDate::getTime();
		}

		$uf = new UserFactory();

		$ph = array(
					'user_id1' => $user_id,
					'start_date1' => $this->db->BindTimeStamp( $start_date ),
					'end_date1' => $this->db->BindTimeStamp( $end_date ),
					'user_id2' => $user_id,
					'start_date2' => $this->db->BindTimeStamp( $start_date ),

					);

		$query = '
					(
					select b.*
					from	'. $uf->getTable() .' as a,
							'. $this->getTable() .' as b
					where	a.id = b.user_id
						AND	b.user_id = ?
						AND b.effective_date >= ?
						AND b.effective_date <= ?
						AND (a.deleted = 0 AND b.deleted=0)

					)
					UNION
					(
						select 	d.*
						from	'. $uf->getTable() .' as c,
								'. $this->getTable() .' as d
						where	c.id = d.user_id
							AND	d.user_id = ?
							AND d.effective_date <= ?
							AND (c.deleted = 0 AND d.deleted=0)
						ORDER BY d.effective_date desc
						LIMIT 1
					)
					ORDER BY effective_date desc
					';

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByUserIdAndCompanyIdAndStartDateAndEndDate($user_id, $company_id, $start_date = FALSE, $end_date = FALSE) {
		if ( $user_id == '' ) {
			return FALSE;
		}

		if ( $company_id == '' ) {
			return FALSE;
		}

		if ( $start_date == '' ) {
			$start_date = 0;
		}

		if ( $end_date == '' ) {
			$end_date = TTDate::getTime();
		}

		$uf = new UserFactory();

		$ph = array(
					'company_id' => $company_id,
					'start_date' => $this->db->BindTimeStamp( $start_date ),
					'end_date' => $this->db->BindTimeStamp( $end_date ),
					);

		$b_user_id_sql = $this->getListSQL($user_id, $ph);

		$ph['company_id2'] = $company_id;
		$ph['start_date2'] = $this->db->BindTimeStamp( $start_date );

		$query = '
					(
					select b.*
					from	'. $uf->getTable() .' as a,
							'. $this->getTable() .' as b
					where	a.id = b.user_id
						AND a.company_id = ?
						AND b.effective_date >= ?
						AND b.effective_date <= ?
						AND	b.user_id in ('. $b_user_id_sql .')
						AND (a.deleted = 0 AND b.deleted=0)

					)
					UNION
					(
						select 	m.*
						from	'. $this->getTable() .' as m
						where
							m.id in (
									select max(d.id) as id
									from 	'. $uf->getTable() .' as c,
											'. $this->getTable() .' as d
									where c.id = d.user_id
										AND c.company_id = ?
										AND d.effective_date <= ?
										AND	d.user_id in ('. $this->getListSQL($user_id, $ph) .')
										AND (c.deleted = 0 AND d.deleted=0)
									group by d.user_id
									)
					)
					ORDER BY effective_date desc
					';

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getArrayByUserIdAndStartDateAndEndDate($user_id, $start_date = FALSE, $end_date = FALSE) {
		$uwlf = new UserWageListFactory();
		$uwlf->getByUserIdAndStartDateAndEndDate($user_id, $start_date, $end_date);

		foreach ($uwlf as $uw_obj) {
			$list[$uw_obj->getEffectiveDate()] = array(
														'wage' => $uw_obj->getWage(),
														'type_id' => $uw_obj->getType(),
														'hourly_rate' => $uw_obj->getHourlyRate(),
														'effective_date' => $uw_obj->getEffectiveDate()
														);
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;

	}

	function getByUserIdAndCompanyId($user_id, $company_id, $limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
		if ( empty($user_id) ) {
			return FALSE;
		}

		if ( empty($company_id) ) {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'b.effective_date' => 'desc');
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$uf = new UserFactory();

		$ph = array(
					'company_id' => $company_id,
					'user_id' => $user_id,
					);

		$query = '
					select 	*
					from	'. $uf->getTable() .' as a,
							'. $this->getTable() .' as b
					where	a.id = b.user_id
						AND a.company_id = ?
						AND	b.user_id = ?
						AND b.deleted = 0';
		$query .= $this->getSortSQL( $order, $strict );

		if ($limit == NULL) {
			$this->rs = $this->db->Execute($query, $ph);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page, $ph);
		}

		return $this;
	}
}
?>