-- filename : char-def.lua
-- comment  : companion to char-def.tex (in ConTeXt)
-- author   : Hans Hagen, PRAGMA-ADE, Hasselt NL
-- copyright: PRAGMA ADE / ConTeXt Development Team
-- license  : see context related readme files

-- remark   : compact version

-- 0x2061 FUNCTION APPLICATION -> relax

if not versions   then versions   = { } end versions['char-def'] = 1.001
if not characters then characters = { } end

characters.data={
 [0x0000]={
  ["category"]="cc",
  ["description"]="NULL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0000,
 },
 {
  ["category"]="cc",
  ["description"]="START OF HEADING",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0001,
 },
 {
  ["category"]="cc",
  ["description"]="START OF TEXT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0002,
 },
 {
  ["category"]="cc",
  ["description"]="END OF TEXT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0003,
 },
 {
  ["category"]="cc",
  ["description"]="END OF TRANSMISSION",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0004,
 },
 {
  ["category"]="cc",
  ["description"]="ENQUIRY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0005,
 },
 {
  ["category"]="cc",
  ["description"]="ACKNOWLEDGE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0006,
 },
 {
  ["category"]="cc",
  ["description"]="BELL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0007,
 },
 {
  ["category"]="cc",
  ["description"]="BACKSPACE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0008,
 },
 {
  ["category"]="cc",
  ["description"]="CHARACTER TABULATION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0009, --
 },
 {
  ["category"]="cc",
  ["description"]="LINE FEED (LF)",
  ["linebreak"]="lf",
  ["unicodeslot"]=0x000A, --

 },
 {
  ["category"]="cc",
  ["description"]="LINE TABULATION",
  ["linebreak"]="bk",
  ["unicodeslot"]=0x000B,
 },
 {
  ["category"]="cc",
  ["description"]="FORM FEED (FF)",
  ["linebreak"]="bk",
  ["unicodeslot"]=0x000C,
 },
 {
  ["category"]="cc",
  ["description"]="CARRIAGE RETURN (CR)",
  ["linebreak"]="cr",
  ["unicodeslot"]=0x000D, --
 },
 {
  ["category"]="cc",
  ["description"]="SHIFT OUT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x000E,
 },
 {
  ["category"]="cc",
  ["description"]="SHIFT IN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x000F,
 },
 {
  ["category"]="cc",
  ["description"]="DATA LINK ESCAPE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0010,
 },
 {
  ["category"]="cc",
  ["description"]="DEVICE CONTROL ONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0011,
 },
 {
  ["category"]="cc",
  ["description"]="DEVICE CONTROL TWO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0012,
 },
 {
  ["category"]="cc",
  ["description"]="DEVICE CONTROL THREE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0013,
 },
 {
  ["category"]="cc",
  ["description"]="DEVICE CONTROL FOUR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0014,
 },
 {
  ["category"]="cc",
  ["description"]="NEGATIVE ACKNOWLEDGE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0015,
 },
 {
  ["category"]="cc",
  ["description"]="SYNCHRONOUS IDLE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0016,
 },
 {
  ["category"]="cc",
  ["description"]="END OF TRANSMISSION BLOCK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0017,
 },
 {
  ["category"]="cc",
  ["description"]="CANCEL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0018,
 },
 {
  ["category"]="cc",
  ["description"]="END OF MEDIUM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0019,
 },
 {
  ["category"]="cc",
  ["description"]="SUBSTITUTE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x001A,
 },
 {
  ["category"]="cc",
  ["description"]="ESCAPE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x001B,
 },
 {
  ["category"]="cc",
  ["description"]="INFORMATION SEPARATOR FOUR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x001C,
 },
 {
  ["category"]="cc",
  ["description"]="INFORMATION SEPARATOR THREE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x001D,
 },
 {
  ["category"]="cc",
  ["description"]="INFORMATION SEPARATOR TWO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x001E,
 },
 {
  ["category"]="cc",
  ["description"]="INFORMATION SEPARATOR ONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x001F,
 },
 {
  ["adobename"]="space",
  ["category"]="zs",
  ["cjkwd"]="na",
  ["description"]="SPACE",
  ["linebreak"]="sp",
  ["unicodeslot"]=0x0020, --
 },
 {
  ["adobename"]="exclam",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="EXCLAMATION MARK",
  ["linebreak"]="ex",
  ["mathclass"]="close",
  ["unicodeslot"]=0x0021, -- !
 },
 {
  ["adobename"]="quotedbl",
  ["category"]="po",
  ["cjkwd"]="na",
  ["contextname"]="quotedbl",
  ["description"]="QUOTATION MARK",
  ["linebreak"]="qu",
  ["unicodeslot"]=0x0022, -- "
 },
 {
  ["adobename"]="numbersign",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="NUMBER SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0023, -- #
 },
 {
  ["adobename"]="dollar",
  ["category"]="sc",
  ["cjkwd"]="na",
  ["description"]="DOLLAR SIGN",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x0024, -- $
 },
 {
  ["adobename"]="percent",
  ["category"]="po",
  ["cjkwd"]="na",
  ["contextname"]="percent",
  ["description"]="PERCENT SIGN",
  ["linebreak"]="po",
  ["unicodeslot"]=0x0025, -- %
 },
 {
  ["adobename"]="ampersand",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="AMPERSAND",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0026, -- &
 },
 {
  ["adobename"]="quotesingle",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="APOSTROPHE",
  ["linebreak"]="qu",
  ["unicodeslot"]=0x0027, -- '
 },
 {
  ["adobename"]="parenleft",
  ["category"]="ps",
  ["cjkwd"]="na",
  ["description"]="LEFT PARENTHESIS",
  ["linebreak"]="op",
  ["mathclass"]="open",
  ["mathname"]="lparent",
  ["unicodeslot"]=0x0028, -- (
 },
 {
  ["adobename"]="parenright",
  ["category"]="pe",
  ["cjkwd"]="na",
  ["description"]="RIGHT PARENTHESIS",
  ["linebreak"]="cl",
  ["mathclass"]="close",
  ["mathname"]="rparent",
  ["unicodeslot"]=0x0029, -- )
 },
 {
  ["adobename"]="asterisk",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="ASTERISK",
  ["linebreak"]="al",
  ["mathclass"]="binary",
  ["unicodeslot"]=0x002A, -- *
 },
 {
  ["adobename"]="plus",
  ["category"]="sm",
  ["cjkwd"]="na",
  ["description"]="PLUS SIGN",
  ["linebreak"]="pr",
  ["mathclass"]="binary",
  ["unicodeslot"]=0x002B, -- +
 },
 {
  ["adobename"]="comma",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="COMMA",
  ["linebreak"]="is",
  ["mathclass"]="punctuation",
  ["unicodeslot"]=0x002C, -- ,
 },
 {
  ["adobename"]="hyphen",
  ["category"]="pd",
  ["cjkwd"]="na",
  ["description"]="HYPHEN-MINUS",
  ["linebreak"]="hy",
  ["mathclass"]="binary",
  ["unicodeslot"]=0x002D, -- -
 },
 {
  ["adobename"]="period",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="FULL STOP",
  ["linebreak"]="is",
  ["mathclass"]="punctuation",
  ["unicodeslot"]=0x002E, -- .
 },
 {
  ["adobename"]="slash",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="SOLIDUS",
  ["linebreak"]="sy",
  ["mathclass"]="binary",
  ["unicodeslot"]=0x002F, -- /
 },
 {
  ["adobename"]="zero",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT ZERO",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0030, -- 0x0000
 },
 {
  ["adobename"]="one",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT ONE",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0031, -- 0x0001
 },
 {
  ["adobename"]="two",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT TWO",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0032, -- 0x0002
 },
 {
  ["adobename"]="three",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT THREE",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0033, -- 0x0003
 },
 {
  ["adobename"]="four",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT FOUR",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0034, -- 0x0004
 },
 {
  ["adobename"]="five",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT FIVE",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0035, -- 0x0005
 },
 {
  ["adobename"]="six",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT SIX",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0036, -- 0x0006
 },
 {
  ["adobename"]="seven",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT SEVEN",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0037, -- 0x0007
 },
 {
  ["adobename"]="eight",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT EIGHT",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0038, -- 0x0008
 },
 {
  ["adobename"]="nine",
  ["category"]="nd",
  ["cjkwd"]="na",
  ["description"]="DIGIT NINE",
  ["linebreak"]="nu",
  ["mathclass"]="number",
  ["unicodeslot"]=0x0039, -- 0x0009
 },
 {
  ["adobename"]="colon",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="COLON",
  ["linebreak"]="is",
  ["mathclass"]="punctuation",
  ["unicodeslot"]=0x003A, -- :
 },
 {
  ["adobename"]="semicolon",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="SEMICOLON",
  ["linebreak"]="is",
  ["mathclass"]="punctuation",
  ["unicodeslot"]=0x003B, -- ;
 },
 {
  ["adobename"]="less",
  ["category"]="sm",
  ["cjkwd"]="na",
  ["description"]="LESS-THAN SIGN",
  ["linebreak"]="al",
  ["mathclass"]="binary",
  ["mathname"]="lt",
  ["unicodeslot"]=0x003C, -- <
 },
 {
  ["adobename"]="equal",
  ["category"]="sm",
  ["cjkwd"]="na",
  ["description"]="EQUALS SIGN",
  ["linebreak"]="al",
  ["mathclass"]="binary",
  ["mathname"]="eq",
  ["unicodeslot"]=0x003D, -- =
 },
 {
  ["adobename"]="greater",
  ["category"]="sm",
  ["cjkwd"]="na",
  ["description"]="GREATER-THAN SIGN",
  ["linebreak"]="al",
  ["mathclass"]="binary",
  ["mathname"]="gt",
  ["unicodeslot"]=0x003E, -- >
 },
 {
  ["adobename"]="question",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="QUESTION MARK",
  ["linebreak"]="ex",
  ["mathclass"]="close",
  ["unicodeslot"]=0x003F, -- ?
 },
 {
  ["adobename"]="at",
  ["category"]="po",
  ["cjkwd"]="na",
  ["description"]="COMMERCIAL AT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0040, -- @
 },
 {
  ["adobename"]="A",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER A",
  ["lccode"]=0x0061,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0041, -- A
 },
 {
  ["adobename"]="B",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER B",
  ["lccode"]=0x0062,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0042, -- B
 },
 {
  ["adobename"]="C",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER C",
  ["lccode"]=0x0063,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0043, -- C
 },
 {
  ["adobename"]="D",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER D",
  ["lccode"]=0x0064,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0044, -- D
 },
 {
  ["adobename"]="E",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER E",
  ["lccode"]=0x0065,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0045, -- E
 },
 {
  ["adobename"]="F",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER F",
  ["lccode"]=0x0066,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0046, -- F
 },
 {
  ["adobename"]="G",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER G",
  ["lccode"]=0x0067,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0047, -- G
 },
 {
  ["adobename"]="H",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER H",
  ["lccode"]=0x0068,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0048, -- H
 },
 {
  ["adobename"]="I",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER I",
  ["lccode"]=0x0069,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0049, -- I
 },
 {
  ["adobename"]="J",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER J",
  ["lccode"]=0x006A,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x004A, -- J
 },
 {
  ["adobename"]="K",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER K",
  ["lccode"]=0x006B,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x004B, -- K
 },
 {
  ["adobename"]="L",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER L",
  ["lccode"]=0x006C,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x004C, -- L
 },
 {
  ["adobename"]="M",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER M",
  ["lccode"]=0x006D,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x004D, -- M
 },
 {
  ["adobename"]="N",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER N",
  ["lccode"]=0x006E,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x004E, -- N
 },
 {
  ["adobename"]="O",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER O",
  ["lccode"]=0x006F,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x004F, -- O
 },
 {
  ["adobename"]="P",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER P",
  ["lccode"]=0x0070,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0050, -- P
 },
 {
  ["adobename"]="Q",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER Q",
  ["lccode"]=0x0071,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0051, -- Q
 },
 {
  ["adobename"]="R",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER R",
  ["lccode"]=0x0072,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0052, -- R
 },
 {
  ["adobename"]="S",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER S",
  ["lccode"]=0x0073,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0053, -- S
 },
 {
  ["adobename"]="T",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER T",
  ["lccode"]=0x0074,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0054, -- T
 },
 {
  ["adobename"]="U",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER U",
  ["lccode"]=0x0075,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0055, -- U
 },
 {
  ["adobename"]="V",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER V",
  ["lccode"]=0x0076,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0056, -- V
 },
 {
  ["adobename"]="W",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER W",
  ["lccode"]=0x0077,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0057, -- W
 },
 {
  ["adobename"]="X",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER X",
  ["lccode"]=0x0078,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0058, -- X
 },
 {
  ["adobename"]="Y",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER Y",
  ["lccode"]=0x0079,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x0059, -- Y
 },
 {
  ["adobename"]="Z",
  ["category"]="lu",
  ["cjkwd"]="na",
  ["description"]="LATIN CAPITAL LETTER Z",
  ["lccode"]=0x007A,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["unicodeslot"]=0x005A, -- Z
 },
 {
  ["adobename"]="bracketleft",
  ["category"]="ps",
  ["cjkwd"]="na",
  ["description"]="LEFT SQUARE BRACKET",
  ["linebreak"]="op",
  ["mathclass"]="open",
  ["unicodeslot"]=0x005B, -- [
 },
 {
  ["adobename"]="backslash",
  ["category"]="po",
  ["cjkwd"]="na",
  ["contextname"]="textbackslash",
  ["description"]="REVERSE SOLIDUS",
  ["linebreak"]="pr",
  ["mathclass"]="binary",
  ["unicodeslot"]=0x005C, -- \
 },
 {
  ["adobename"]="bracketright",
  ["category"]="pe",
  ["cjkwd"]="na",
  ["description"]="RIGHT SQUARE BRACKET",
  ["linebreak"]="cl",
  ["mathclass"]="close",
  ["unicodeslot"]=0x005D, -- ]
 },
 {
  ["adobename"]="asciicircum",
  ["category"]="sk",
  ["cjkwd"]="na",
  ["contextname"]="textasciicircum",
  ["description"]="CIRCUMFLEX ACCENT",
  ["mathclass"]="accent",
  ["mathname"]="widehat",
  ["linebreak"]="al",
  ["unicodeslot"]=0x005E, -- ^
 },
 {
  ["adobename"]="underscore",
  ["category"]="pc",
  ["cjkwd"]="na",
  ["contextname"]="textunderscore",
  ["description"]="LOW LINE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x005F, -- _
 },
 {
  ["adobename"]="grave",
  ["category"]="sk",
  ["cjkwd"]="na",
  ["contextname"]="textgrave",
  ["description"]="GRAVE ACCENT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0060, -- `
 },
 {
  ["adobename"]="a",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER A",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0041,
  ["unicodeslot"]=0x0061, -- a
 },
 {
  ["adobename"]="b",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER B",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0042,
  ["unicodeslot"]=0x0062, -- b
 },
 {
  ["adobename"]="c",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER C",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0043,
  ["unicodeslot"]=0x0063, -- c
 },
 {
  ["adobename"]="d",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER D",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0044,
  ["unicodeslot"]=0x0064, -- d
 },
 {
  ["adobename"]="e",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER E",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0045,
  ["unicodeslot"]=0x0065, -- e
 },
 {
  ["adobename"]="f",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER F",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0046,
  ["unicodeslot"]=0x0066, -- f
 },
 {
  ["adobename"]="g",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER G",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0047,
  ["unicodeslot"]=0x0067, -- g
 },
 {
  ["adobename"]="h",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER H",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0048,
  ["unicodeslot"]=0x0068, -- h
 },
 {
  ["adobename"]="i",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER I",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0049,
  ["unicodeslot"]=0x0069, -- i
 },
 {
  ["adobename"]="j",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER J",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x004A,
  ["unicodeslot"]=0x006A, -- j
 },
 {
  ["adobename"]="k",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER K",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x004B,
  ["unicodeslot"]=0x006B, -- k
 },
 {
  ["adobename"]="l",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER L",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x004C,
  ["unicodeslot"]=0x006C, -- l
 },
 {
  ["adobename"]="m",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER M",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x004D,
  ["unicodeslot"]=0x006D, -- m
 },
 {
  ["adobename"]="n",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER N",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x004E,
  ["unicodeslot"]=0x006E, -- n
 },
 {
  ["adobename"]="o",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER O",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x004F,
  ["unicodeslot"]=0x006F, -- o
 },
 {
  ["adobename"]="p",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER P",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0050,
  ["unicodeslot"]=0x0070, -- p
 },
 {
  ["adobename"]="q",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER Q",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0051,
  ["unicodeslot"]=0x0071, -- q
 },
 {
  ["adobename"]="r",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER R",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0052,
  ["unicodeslot"]=0x0072, -- r
 },
 {
  ["adobename"]="s",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER S",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0053,
  ["unicodeslot"]=0x0073, -- s
 },
 {
  ["adobename"]="t",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER T",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0054,
  ["unicodeslot"]=0x0074, -- t
 },
 {
  ["adobename"]="u",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER U",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0055,
  ["unicodeslot"]=0x0075, -- u
 },
 {
  ["adobename"]="v",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER V",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0056,
  ["unicodeslot"]=0x0076, -- v
 },
 {
  ["adobename"]="w",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER W",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0057,
  ["unicodeslot"]=0x0077, -- w
 },
 {
  ["adobename"]="x",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER X",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0058,
  ["unicodeslot"]=0x0078, -- x
 },
 {
  ["adobename"]="y",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER Y",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x0059,
  ["unicodeslot"]=0x0079, -- y
 },
 {
  ["adobename"]="z",
  ["category"]="ll",
  ["cjkwd"]="na",
  ["description"]="LATIN SMALL LETTER Z",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["uccode"]=0x005A,
  ["unicodeslot"]=0x007A, -- z
 },
 {
  ["adobename"]="braceleft",
  ["category"]="ps",
  ["cjkwd"]="na",
  ["contextname"]="textbraceleft",
  ["description"]="LEFT CURLY BRACKET",
  ["linebreak"]="op",
  ["mathclass"]="open",
  ["mathname"]="lbrace",
  ["unicodeslot"]=0x007B, -- {
 },
 {
  ["adobename"]="bar",
  ["category"]="sm",
  ["cjkwd"]="na",
  ["contextname"]="textbar",
  ["description"]="VERTICAL LINE",
  ["linebreak"]="ba",
  ["mathclass"]="binary",
  ["mathname"]="bar",
  ["unicodeslot"]=0x007C, -- |
 },
 {
  ["adobename"]="braceright",
  ["category"]="pe",
  ["cjkwd"]="na",
  ["contextname"]="textbraceright",
  ["description"]="RIGHT CURLY BRACKET",
  ["linebreak"]="cl",
  ["mathclass"]="close",
  ["mathname"]="rbrace",
  ["unicodeslot"]=0x007D, -- }
 },
 {
  ["adobename"]="asciitilde",
  ["category"]="sm",
  ["cjkwd"]="na",
  ["contextname"]="textasciitilde",
  ["description"]="TILDE",
  ["linebreak"]="al",
  ["mathclass"]="accent",
  ["mathname"]="widetilde",
  ["unicodeslot"]=0x007E, -- ~
 },
 {
  ["category"]="cc",
  ["description"]="DELETE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x007F, -- 
 },
 {
  ["category"]="cc",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0080, -- 
 },
 {
  ["category"]="cc",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0081, -- 
 },
 {
  ["category"]="cc",
  ["description"]="BREAK PERMITTED HERE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0082, -- 
 },
 {
  ["category"]="cc",
  ["description"]="NO BREAK HERE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0083, -- 
 },
 {
  ["category"]="cc",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0084, -- 
 },
 {
  ["category"]="cc",
  ["description"]="NEXT LINE (NEL)",
  ["linebreak"]="nl",
  ["unicodeslot"]=0x0085, -- 
 },
 {
  ["category"]="cc",
  ["description"]="START OF SELECTED AREA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0086, -- 
 },
 {
  ["category"]="cc",
  ["description"]="END OF SELECTED AREA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0087, -- 
 },
 {
  ["category"]="cc",
  ["description"]="CHARACTER TABULATION SET",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0088, -- 
 },
 {
  ["category"]="cc",
  ["description"]="CHARACTER TABULATION WITH JUSTIFICATION",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0089, -- 
 },
 {
  ["category"]="cc",
  ["description"]="LINE TABULATION SET",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x008A, -- 
 },
 {
  ["category"]="cc",
  ["description"]="PARTIAL LINE FORWARD",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x008B, -- 
 },
 {
  ["category"]="cc",
  ["description"]="PARTIAL LINE BACKWARD",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x008C, -- 
 },
 {
  ["category"]="cc",
  ["description"]="REVERSE LINE FEED",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x008D, -- 
 },
 {
  ["category"]="cc",
  ["description"]="SINGLE SHIFT TWO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x008E, -- 
 },
 {
  ["category"]="cc",
  ["description"]="SINGLE SHIFT THREE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x008F, -- 
 },
 {
  ["category"]="cc",
  ["description"]="DEVICE CONTROL STRING",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0090, -- 
 },
 {
  ["category"]="cc",
  ["description"]="PRIVATE USE ONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0091, -- 
 },
 {
  ["category"]="cc",
  ["description"]="PRIVATE USE TWO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0092, -- 
 },
 {
  ["category"]="cc",
  ["description"]="SET TRANSMIT STATE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0093, -- 
 },
 {
  ["category"]="cc",
  ["description"]="CANCEL CHARACTER",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0094, -- 
 },
 {
  ["category"]="cc",
  ["description"]="MESSAGE WAITING",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0095, -- 
 },
 {
  ["category"]="cc",
  ["description"]="START OF GUARDED AREA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0096, -- 
 },
 {
  ["category"]="cc",
  ["description"]="END OF GUARDED AREA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0097, -- 
 },
 {
  ["category"]="cc",
  ["description"]="START OF STRING",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0098, -- 
 },
 {
  ["category"]="cc",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0099, -- 
 },
 {
  ["category"]="cc",
  ["description"]="SINGLE CHARACTER INTRODUCER",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x009A, -- 
 },
 {
  ["category"]="cc",
  ["description"]="CONTROL SEQUENCE INTRODUCER",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x009B, -- 
 },
 {
  ["category"]="cc",
  ["description"]="STRING TERMINATOR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x009C, -- 
 },
 {
  ["category"]="cc",
  ["description"]="OPERATING SYSTEM COMMAND",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x009D, -- 
 },
 {
  ["category"]="cc",
  ["description"]="PRIVACY MESSAGE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x009E, -- 
 },
 {
  ["category"]="cc",
  ["description"]="APPLICATION PROGRAM COMMAND",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x009F, -- 
 },
 {
  ["category"]="zs",
  ["contextname"]="nonbreakablespace",
  ["description"]="NO-BREAK SPACE",
  ["linebreak"]="gl",
  ["specials"]={ "nobreak", 0x0020 },
  ["unicodeslot"]=0x00A0, --  
 },
 {
  ["adobename"]="exclamdown",
  ["category"]="po",
  ["cjkwd"]="a",
  ["contextname"]="exclamdown",
  ["description"]="INVERTED EXCLAMATION MARK",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x00A1, -- ¡
 },
 {
  ["adobename"]="cent",
  ["category"]="sc",
  ["cjkwd"]="na",
  ["contextname"]="textcent",
  ["description"]="CENT SIGN",
  ["linebreak"]="po",
  ["unicodeslot"]=0x00A2, -- ¢
 },
 {
  ["adobename"]="sterling",
  ["category"]="sc",
  ["cjkwd"]="na",
  ["contextname"]="textsterling",
  ["description"]="POUND SIGN",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x00A3, -- £
 },
 {
  ["adobename"]="currency",
  ["category"]="sc",
  ["cjkwd"]="a",
  ["contextname"]="textcurrency",
  ["description"]="CURRENCY SIGN",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x00A4, -- ¤
 },
 {
  ["adobename"]="yen",
  ["category"]="sc",
  ["cjkwd"]="na",
  ["contextname"]="textyen",
  ["description"]="YEN SIGN",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x00A5, -- ¥
 },
 {
  ["adobename"]="brokenbar",
  ["category"]="so",
  ["cjkwd"]="na",
  ["contextname"]="textbrokenbar",
  ["description"]="BROKEN BAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x00A6, -- ¦
 },
 {
  ["adobename"]="section",
  ["category"]="so",
  ["cjkwd"]="a",
  ["contextname"]="sectionmark",
  ["description"]="SECTION SIGN",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x00A7, -- §
 },
 {
  ["adobename"]="dieresis",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="textdiaeresis",
  ["description"]="DIAERESIS",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x0308 },
  ["unicodeslot"]=0x00A8, -- ¨
 },
 {
  ["adobename"]="copyright",
  ["category"]="so",
  ["contextname"]="copyright",
  ["description"]="COPYRIGHT SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x00A9, -- ©
 },
 {
  ["adobename"]="ordfeminine",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ordfeminine",
  ["description"]="FEMININE ORDINAL INDICATOR",
  ["linebreak"]="ai",
  ["specials"]={ "super", 0x0061 },
  ["unicodeslot"]=0x00AA, -- ª
 },
 {
  ["adobename"]="guillemotleft",
  ["category"]="pi",
  ["contextname"]="leftguillemot",
  ["description"]="LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",
  ["linebreak"]="qu",
  ["unicodeslot"]=0x00AB, -- «
 },
 {
  ["adobename"]="logicalnot",
  ["category"]="sm",
  ["cjkwd"]="na",
  ["contextname"]="textlognot",
  ["description"]="NOT SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x00AC, -- ¬
 },
 {
  ["category"]="cf",
  ["cjkwd"]="a",
  ["contextname"]="softhyphen",
  ["description"]="SOFT HYPHEN",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x00AD, -- ­
 },
 {
  ["adobename"]="registered",
  ["category"]="so",
  ["cjkwd"]="a",
  ["contextname"]="registered",
  ["description"]="REGISTERED SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x00AE, -- ®
 },
 {
  ["adobename"]="macron",
  ["category"]="sk",
  ["cjkwd"]="na",
  ["contextname"]="textmacron",
  ["description"]="MACRON",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0304 },
  ["unicodeslot"]=0x00AF, -- ¯
 },
 {
  ["adobename"]="degree",
  ["category"]="so",
  ["cjkwd"]="a",
  ["contextname"]="textdegree",
  ["description"]="DEGREE SIGN",
  ["linebreak"]="po",
  ["unicodeslot"]=0x00B0, -- °
 },
 {
  ["adobename"]="plusminus",
  ["category"]="sm",
  ["cjkwd"]="a",
  ["contextname"]="textpm",
  ["description"]="PLUS-MINUS SIGN",
  ["linebreak"]="pr",
  ["mathclass"]="binary",
  ["mathname"]="pm",
  ["unicodeslot"]=0x00B1, -- ±
 },
 {
  ["category"]="no",
  ["cjkwd"]="a",
  ["contextname"]="twosuperior",
  ["description"]="SUPERSCRIPT TWO",
  ["linebreak"]="ai",
  ["specials"]={ "super", 0x0032 },
  ["unicodeslot"]=0x00B2, -- ²
 },
 {
  ["category"]="no",
  ["cjkwd"]="a",
  ["contextname"]="threesuperior",
  ["description"]="SUPERSCRIPT THREE",
  ["linebreak"]="ai",
  ["specials"]={ "super", 0x0033 },
  ["unicodeslot"]=0x00B3, -- ³
 },
 {
  ["adobename"]="acute",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="textacute",
  ["description"]="ACUTE ACCENT",
  ["linebreak"]="bb",
  ["specials"]={ "compat", 0x0020, 0x0301 },
  ["unicodeslot"]=0x00B4, -- ´
 },
 {
  ["adobename"]="mu",
  ["category"]="ll",
  ["contextname"]="textmu",
  ["description"]="MICRO SIGN",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03BC },
  ["uccode"]=0x039C,
  ["unicodeslot"]=0x00B5, -- µ
 },
 {
  ["adobename"]="paragraph",
  ["category"]="so",
  ["cjkwd"]="a",
  ["contextname"]="paragraphmark",
  ["description"]="PILCROW SIGN",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x00B6, -- ¶
 },
 {
  ["adobename"]="periodcentered",
  ["category"]="po",
  ["cjkwd"]="a",
  ["contextname"]="periodcentered",
  ["description"]="MIDDLE DOT",
  ["linebreak"]="ai",
  ["mathclass"]="binary",
  ["unicodeslot"]=0x00B7, -- ·
 },
 {
  ["adobename"]="cedilla",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="textcedilla",
  ["description"]="CEDILLA",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x0327 },
  ["unicodeslot"]=0x00B8, -- ¸
 },
 {
  ["category"]="no",
  ["cjkwd"]="a",
  ["contextname"]="onesuperior",
  ["description"]="SUPERSCRIPT ONE",
  ["linebreak"]="ai",
  ["specials"]={ "super", 0x0031 },
  ["unicodeslot"]=0x00B9, -- ¹
 },
 {
  ["adobename"]="ordmasculine",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ordmasculine",
  ["description"]="MASCULINE ORDINAL INDICATOR",
  ["linebreak"]="ai",
  ["specials"]={ "super", 0x006F },
  ["unicodeslot"]=0x00BA, -- º
 },
 {
  ["adobename"]="guillemotright",
  ["category"]="pf",
  ["contextname"]="rightguillemot",
  ["description"]="RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK",
  ["linebreak"]="qu",
  ["unicodeslot"]=0x00BB, -- »
 },
 {
  ["adobename"]="onequarter",
  ["category"]="no",
  ["cjkwd"]="a",
  ["contextname"]="onequarter",
  ["description"]="VULGAR FRACTION ONE QUARTER",
  ["linebreak"]="ai",
  ["specials"]={ "fraction", 0x0031, 0x2044, 0x0034 },
  ["unicodeslot"]=0x00BC, -- ¼
 },
 {
  ["adobename"]="onehalf",
  ["category"]="no",
  ["cjkwd"]="a",
  ["contextname"]="onehalf",
  ["description"]="VULGAR FRACTION ONE HALF",
  ["linebreak"]="ai",
  ["specials"]={ "fraction", 0x0031, 0x2044, 0x0032 },
  ["unicodeslot"]=0x00BD, -- ½
 },
 {
  ["adobename"]="threequarters",
  ["category"]="no",
  ["cjkwd"]="a",
  ["contextname"]="threequarter",
  ["description"]="VULGAR FRACTION THREE QUARTERS",
  ["linebreak"]="ai",
  ["specials"]={ "fraction", 0x0033, 0x2044, 0x0034 },
  ["unicodeslot"]=0x00BE, -- ¾
 },
 {
  ["adobename"]="questiondown",
  ["category"]="po",
  ["cjkwd"]="a",
  ["contextname"]="questiondown",
  ["description"]="INVERTED QUESTION MARK",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x00BF, -- ¿
 },
 {
  ["adobename"]="Agrave",
  ["category"]="lu",
  ["contextname"]="Agrave",
  ["description"]="LATIN CAPITAL LETTER A WITH GRAVE",
  ["lccode"]=0x00E0,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0300 },
  ["unicodeslot"]=0x00C0, -- À
 },
 {
  ["adobename"]="Aacute",
  ["category"]="lu",
  ["contextname"]="Aacute",
  ["description"]="LATIN CAPITAL LETTER A WITH ACUTE",
  ["lccode"]=0x00E1,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0301 },
  ["unicodeslot"]=0x00C1, -- Á
 },
 {
  ["adobename"]="Acircumflex",
  ["category"]="lu",
  ["contextname"]="Acircumflex",
  ["description"]="LATIN CAPITAL LETTER A WITH CIRCUMFLEX",
  ["lccode"]=0x00E2,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0302 },
  ["unicodeslot"]=0x00C2, -- Â
 },
 {
  ["adobename"]="Atilde",
  ["category"]="lu",
  ["contextname"]="Atilde",
  ["description"]="LATIN CAPITAL LETTER A WITH TILDE",
  ["lccode"]=0x00E3,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0303 },
  ["unicodeslot"]=0x00C3, -- Ã
 },
 {
  ["adobename"]="Adieresis",
  ["category"]="lu",
  ["contextname"]="Adiaeresis",
  ["description"]="LATIN CAPITAL LETTER A WITH DIAERESIS",
  ["lccode"]=0x00E4,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0308 },
  ["unicodeslot"]=0x00C4, -- Ä
 },
 {
  ["adobename"]="Aring",
  ["category"]="lu",
  ["contextname"]="Aring",
  ["description"]="LATIN CAPITAL LETTER A WITH RING ABOVE",
  ["lccode"]=0x00E5,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x030A },
  ["unicodeslot"]=0x00C5, -- Å
 },
 {
  ["adobename"]="AE",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="AEligature",
  ["description"]="LATIN CAPITAL LETTER AE",
  ["lccode"]=0x00E6,
  ["linebreak"]="al",
  ["shcode"]= { 0x0041, 0x0045 },
  ["unicodeslot"]=0x00C6, -- Æ
 },
 {
  ["adobename"]="Ccedilla",
  ["category"]="lu",
  ["contextname"]="Ccedilla",
  ["description"]="LATIN CAPITAL LETTER C WITH CEDILLA",
  ["lccode"]=0x00E7,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["specials"]={ "char", 0x0043, 0x0327 },
  ["unicodeslot"]=0x00C7, -- Ç
 },
 {
  ["adobename"]="Egrave",
  ["category"]="lu",
  ["contextname"]="Egrave",
  ["description"]="LATIN CAPITAL LETTER E WITH GRAVE",
  ["lccode"]=0x00E8,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0300 },
  ["unicodeslot"]=0x00C8, -- È
 },
 {
  ["adobename"]="Eacute",
  ["category"]="lu",
  ["contextname"]="Eacute",
  ["description"]="LATIN CAPITAL LETTER E WITH ACUTE",
  ["lccode"]=0x00E9,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0301 },
  ["unicodeslot"]=0x00C9, -- É
 },
 {
  ["adobename"]="Ecircumflex",
  ["category"]="lu",
  ["contextname"]="Ecircumflex",
  ["description"]="LATIN CAPITAL LETTER E WITH CIRCUMFLEX",
  ["lccode"]=0x00EA,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0302 },
  ["unicodeslot"]=0x00CA, -- Ê
 },
 {
  ["adobename"]="Edieresis",
  ["category"]="lu",
  ["contextname"]="Ediaeresis",
  ["description"]="LATIN CAPITAL LETTER E WITH DIAERESIS",
  ["lccode"]=0x00EB,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0308 },
  ["unicodeslot"]=0x00CB, -- Ë
 },
 {
  ["adobename"]="Igrave",
  ["category"]="lu",
  ["contextname"]="Igrave",
  ["description"]="LATIN CAPITAL LETTER I WITH GRAVE",
  ["lccode"]=0x00EC,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0300 },
  ["unicodeslot"]=0x00CC, -- Ì
 },
 {
  ["adobename"]="Iacute",
  ["category"]="lu",
  ["contextname"]="Iacute",
  ["description"]="LATIN CAPITAL LETTER I WITH ACUTE",
  ["lccode"]=0x00ED,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0301 },
  ["unicodeslot"]=0x00CD, -- Í
 },
 {
  ["adobename"]="Icircumflex",
  ["category"]="lu",
  ["contextname"]="Icircumflex",
  ["description"]="LATIN CAPITAL LETTER I WITH CIRCUMFLEX",
  ["lccode"]=0x00EE,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0302 },
  ["unicodeslot"]=0x00CE, -- Î
 },
 {
  ["adobename"]="Idieresis",
  ["category"]="lu",
  ["contextname"]="Idiaeresis",
  ["description"]="LATIN CAPITAL LETTER I WITH DIAERESIS",
  ["lccode"]=0x00EF,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0308 },
  ["unicodeslot"]=0x00CF, -- Ï
 },
 {
  ["adobename"]="Eth",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Eth",
  ["description"]="LATIN CAPITAL LETTER ETH",
  ["lccode"]=0x00F0,
  ["linebreak"]="al",
  ["unicodeslot"]=0x00D0, -- Ð
 },
 {
  ["adobename"]="Ntilde",
  ["category"]="lu",
  ["contextname"]="Ntilde",
  ["description"]="LATIN CAPITAL LETTER N WITH TILDE",
  ["lccode"]=0x00F1,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x0303 },
  ["unicodeslot"]=0x00D1, -- Ñ
 },
 {
  ["adobename"]="Ograve",
  ["category"]="lu",
  ["contextname"]="Ograve",
  ["description"]="LATIN CAPITAL LETTER O WITH GRAVE",
  ["lccode"]=0x00F2,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0300 },
  ["unicodeslot"]=0x00D2, -- Ò
 },
 {
  ["adobename"]="Oacute",
  ["category"]="lu",
  ["contextname"]="Oacute",
  ["description"]="LATIN CAPITAL LETTER O WITH ACUTE",
  ["lccode"]=0x00F3,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0301 },
  ["unicodeslot"]=0x00D3, -- Ó
 },
 {
  ["adobename"]="Ocircumflex",
  ["category"]="lu",
  ["contextname"]="Ocircumflex",
  ["description"]="LATIN CAPITAL LETTER O WITH CIRCUMFLEX",
  ["lccode"]=0x00F4,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0302 },
  ["unicodeslot"]=0x00D4, -- Ô
 },
 {
  ["adobename"]="Otilde",
  ["category"]="lu",
  ["contextname"]="Otilde",
  ["description"]="LATIN CAPITAL LETTER O WITH TILDE",
  ["lccode"]=0x00F5,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0303 },
  ["unicodeslot"]=0x00D5, -- Õ
 },
 {
  ["adobename"]="Odieresis",
  ["category"]="lu",
  ["contextname"]="Odiaeresis",
  ["description"]="LATIN CAPITAL LETTER O WITH DIAERESIS",
  ["lccode"]=0x00F6,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0308 },
  ["unicodeslot"]=0x00D6, -- Ö
 },
 {
  ["adobename"]="multiply",
  ["category"]="sm",
  ["cjkwd"]="a",
  ["contextname"]="textmultiply",
  ["description"]="MULTIPLICATION SIGN",
  ["linebreak"]="ai",
  ["mathclass"]="binary",
  ["mathname"]="times",
  ["unicodeslot"]=0x00D7, -- ×
 },
 {
  ["adobename"]="Oslash",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Ostroke",
  ["description"]="LATIN CAPITAL LETTER O WITH STROKE",
  ["lccode"]=0x00F8,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["unicodeslot"]=0x00D8, -- Ø
 },
 {
  ["adobename"]="Ugrave",
  ["category"]="lu",
  ["contextname"]="Ugrave",
  ["description"]="LATIN CAPITAL LETTER U WITH GRAVE",
  ["lccode"]=0x00F9,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0300 },
  ["unicodeslot"]=0x00D9, -- Ù
 },
 {
  ["adobename"]="Uacute",
  ["category"]="lu",
  ["contextname"]="Uacute",
  ["description"]="LATIN CAPITAL LETTER U WITH ACUTE",
  ["lccode"]=0x00FA,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0301 },
  ["unicodeslot"]=0x00DA, -- Ú
 },
 {
  ["adobename"]="Ucircumflex",
  ["category"]="lu",
  ["contextname"]="Ucircumflex",
  ["description"]="LATIN CAPITAL LETTER U WITH CIRCUMFLEX",
  ["lccode"]=0x00FB,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0302 },
  ["unicodeslot"]=0x00DB, -- Û
 },
 {
  ["adobename"]="Udieresis",
  ["category"]="lu",
  ["contextname"]="Udiaeresis",
  ["description"]="LATIN CAPITAL LETTER U WITH DIAERESIS",
  ["lccode"]=0x00FC,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0308 },
  ["unicodeslot"]=0x00DC, -- Ü
 },
 {
  ["adobename"]="Yacute",
  ["category"]="lu",
  ["contextname"]="Yacute",
  ["description"]="LATIN CAPITAL LETTER Y WITH ACUTE",
  ["lccode"]=0x00FD,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0301 },
  ["unicodeslot"]=0x00DD, -- Ý
 },
 {
  ["adobename"]="Thorn",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Thorn",
  ["description"]="LATIN CAPITAL LETTER THORN",
  ["lccode"]=0x00FE,
  ["linebreak"]="al",
  ["unicodeslot"]=0x00DE, -- Þ
 },
 {
  ["adobename"]="germandbls",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ssharp",
  ["description"]="LATIN SMALL LETTER SHARP S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x00DF, -- ß
  ["uccodes"]={0x0053,0x0053},
 },
 {
  ["adobename"]="agrave",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="agrave",
  ["description"]="LATIN SMALL LETTER A WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0300 },
  ["uccode"]=0x00C0,
  ["unicodeslot"]=0x00E0, -- à
 },
 {
  ["adobename"]="aacute",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="aacute",
  ["description"]="LATIN SMALL LETTER A WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0301 },
  ["uccode"]=0x00C1,
  ["unicodeslot"]=0x00E1, -- á
 },
 {
  ["adobename"]="acircumflex",
  ["category"]="ll",
  ["contextname"]="acircumflex",
  ["description"]="LATIN SMALL LETTER A WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0302 },
  ["uccode"]=0x00C2,
  ["unicodeslot"]=0x00E2, -- â
 },
 {
  ["adobename"]="atilde",
  ["category"]="ll",
  ["contextname"]="atilde",
  ["description"]="LATIN SMALL LETTER A WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0303 },
  ["uccode"]=0x00C3,
  ["unicodeslot"]=0x00E3, -- ã
 },
 {
  ["adobename"]="adieresis",
  ["category"]="ll",
  ["contextname"]="adiaeresis",
  ["description"]="LATIN SMALL LETTER A WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0308 },
  ["uccode"]=0x00C4,
  ["unicodeslot"]=0x00E4, -- ä
 },
 {
  ["adobename"]="aring",
  ["category"]="ll",
  ["contextname"]="aring",
  ["description"]="LATIN SMALL LETTER A WITH RING ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x030A },
  ["uccode"]=0x00C5,
  ["unicodeslot"]=0x00E5, -- å
 },
 {
  ["adobename"]="ae",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="aeligature",
  ["description"]="LATIN SMALL LETTER AE",
  ["linebreak"]="al",
  ["shcode"]= { 0x00E6, 0x00EA },
  ["uccode"]=0x00C6,
  ["unicodeslot"]=0x00E6, -- æ
 },
 {
  ["adobename"]="ccedilla",
  ["category"]="ll",
  ["contextname"]="ccedilla",
  ["description"]="LATIN SMALL LETTER C WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["specials"]={ "char", 0x0063, 0x0327 },
  ["uccode"]=0x00C7,
  ["unicodeslot"]=0x00E7, -- ç
 },
 {
  ["adobename"]="egrave",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="egrave",
  ["description"]="LATIN SMALL LETTER E WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0300 },
  ["uccode"]=0x00C8,
  ["unicodeslot"]=0x00E8, -- è
 },
 {
  ["adobename"]="eacute",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="eacute",
  ["description"]="LATIN SMALL LETTER E WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0301 },
  ["uccode"]=0x00C9,
  ["unicodeslot"]=0x00E9, -- é
 },
 {
  ["adobename"]="ecircumflex",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ecircumflex",
  ["description"]="LATIN SMALL LETTER E WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0302 },
  ["uccode"]=0x00CA,
  ["unicodeslot"]=0x00EA, -- ê
 },
 {
  ["adobename"]="edieresis",
  ["category"]="ll",
  ["contextname"]="ediaeresis",
  ["description"]="LATIN SMALL LETTER E WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0308 },
  ["uccode"]=0x00CB,
  ["unicodeslot"]=0x00EB, -- ë
 },
 {
  ["adobename"]="igrave",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="igrave",
  ["description"]="LATIN SMALL LETTER I WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0300 },
  ["uccode"]=0x00CC,
  ["unicodeslot"]=0x00EC, -- ì
 },
 {
  ["adobename"]="iacute",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="iacute",
  ["description"]="LATIN SMALL LETTER I WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0301 },
  ["uccode"]=0x00CD,
  ["unicodeslot"]=0x00ED, -- í
 },
 {
  ["adobename"]="icircumflex",
  ["category"]="ll",
  ["contextname"]="icircumflex",
  ["description"]="LATIN SMALL LETTER I WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0302 },
  ["uccode"]=0x00CE,
  ["unicodeslot"]=0x00EE, -- î
 },
 {
  ["adobename"]="idieresis",
  ["category"]="ll",
  ["contextname"]="idiaeresis",
  ["description"]="LATIN SMALL LETTER I WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0308 },
  ["uccode"]=0x00CF,
  ["unicodeslot"]=0x00EF, -- ï
 },
 {
  ["adobename"]="eth",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="eth",
  ["description"]="LATIN SMALL LETTER ETH",
  ["linebreak"]="al",
  ["uccode"]=0x00D0,
  ["unicodeslot"]=0x00F0, -- ð
 },
 {
  ["adobename"]="ntilde",
  ["category"]="ll",
  ["contextname"]="ntilde",
  ["description"]="LATIN SMALL LETTER N WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x0303 },
  ["uccode"]=0x00D1,
  ["unicodeslot"]=0x00F1, -- ñ
 },
 {
  ["adobename"]="ograve",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ograve",
  ["description"]="LATIN SMALL LETTER O WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0300 },
  ["uccode"]=0x00D2,
  ["unicodeslot"]=0x00F2, -- ò
 },
 {
  ["adobename"]="oacute",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="oacute",
  ["description"]="LATIN SMALL LETTER O WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0301 },
  ["uccode"]=0x00D3,
  ["unicodeslot"]=0x00F3, -- ó
 },
 {
  ["adobename"]="ocircumflex",
  ["category"]="ll",
  ["contextname"]="ocircumflex",
  ["description"]="LATIN SMALL LETTER O WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0302 },
  ["uccode"]=0x00D4,
  ["unicodeslot"]=0x00F4, -- ô
 },
 {
  ["adobename"]="otilde",
  ["category"]="ll",
  ["contextname"]="otilde",
  ["description"]="LATIN SMALL LETTER O WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0303 },
  ["uccode"]=0x00D5,
  ["unicodeslot"]=0x00F5, -- õ
 },
 {
  ["adobename"]="odieresis",
  ["category"]="ll",
  ["contextname"]="odiaeresis",
  ["description"]="LATIN SMALL LETTER O WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0308 },
  ["uccode"]=0x00D6,
  ["unicodeslot"]=0x00F6, -- ö
 },
 {
  ["adobename"]="divide",
  ["category"]="sm",
  ["cjkwd"]="a",
  ["contextname"]="textdiv",
  ["description"]="DIVISION SIGN",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x00F7, -- ÷
 },
 {
  ["adobename"]="oslash",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ostroke",
  ["description"]="LATIN SMALL LETTER O WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["uccode"]=0x00D8,
  ["unicodeslot"]=0x00F8, -- ø
 },
 {
  ["adobename"]="ugrave",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ugrave",
  ["description"]="LATIN SMALL LETTER U WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0300 },
  ["uccode"]=0x00D9,
  ["unicodeslot"]=0x00F9, -- ù
 },
 {
  ["adobename"]="uacute",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="uacute",
  ["description"]="LATIN SMALL LETTER U WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0301 },
  ["uccode"]=0x00DA,
  ["unicodeslot"]=0x00FA, -- ú
 },
 {
  ["adobename"]="ucircumflex",
  ["category"]="ll",
  ["contextname"]="ucircumflex",
  ["description"]="LATIN SMALL LETTER U WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0302 },
  ["uccode"]=0x00DB,
  ["unicodeslot"]=0x00FB, -- û
 },
 {
  ["adobename"]="udieresis",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="udiaeresis",
  ["description"]="LATIN SMALL LETTER U WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0308 },
  ["uccode"]=0x00DC,
  ["unicodeslot"]=0x00FC, -- ü
 },
 {
  ["adobename"]="yacute",
  ["category"]="ll",
  ["contextname"]="yacute",
  ["description"]="LATIN SMALL LETTER Y WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0301 },
  ["uccode"]=0x00DD,
  ["unicodeslot"]=0x00FD, -- ý
 },
 {
  ["adobename"]="thorn",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="thorn",
  ["description"]="LATIN SMALL LETTER THORN",
  ["linebreak"]="al",
  ["uccode"]=0x00DE,
  ["unicodeslot"]=0x00FE, -- þ
 },
 {
  ["adobename"]="ydieresis",
  ["category"]="ll",
  ["contextname"]="ydiaeresis",
  ["description"]="LATIN SMALL LETTER Y WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0308 },
  ["uccode"]=0x0178,
  ["unicodeslot"]=0x00FF, -- ÿ
 },
 {
  ["adobename"]="Amacron",
  ["category"]="lu",
  ["contextname"]="Amacron",
  ["description"]="LATIN CAPITAL LETTER A WITH MACRON",
  ["lccode"]=0x0101,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0304 },
  ["unicodeslot"]=0x0100, -- Ā
 },
 {
  ["adobename"]="amacron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="amacron",
  ["description"]="LATIN SMALL LETTER A WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0304 },
  ["uccode"]=0x0100,
  ["unicodeslot"]=0x0101, -- ā
 },
 {
  ["adobename"]="Abreve",
  ["category"]="lu",
  ["contextname"]="Abreve",
  ["description"]="LATIN CAPITAL LETTER A WITH BREVE",
  ["lccode"]=0x0103,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0306 },
  ["unicodeslot"]=0x0102, -- Ă
 },
 {
  ["adobename"]="abreve",
  ["category"]="ll",
  ["contextname"]="abreve",
  ["description"]="LATIN SMALL LETTER A WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0306 },
  ["uccode"]=0x0102,
  ["unicodeslot"]=0x0103, -- ă
 },
 {
  ["adobename"]="Aogonek",
  ["category"]="lu",
  ["contextname"]="Aogonek",
  ["description"]="LATIN CAPITAL LETTER A WITH OGONEK",
  ["lccode"]=0x0105,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0328 },
  ["unicodeslot"]=0x0104, -- Ą
 },
 {
  ["adobename"]="aogonek",
  ["category"]="ll",
  ["contextname"]="aogonek",
  ["description"]="LATIN SMALL LETTER A WITH OGONEK",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0328 },
  ["uccode"]=0x0104,
  ["unicodeslot"]=0x0105, -- ą
 },
 {
  ["adobename"]="Cacute",
  ["category"]="lu",
  ["contextname"]="Cacute",
  ["description"]="LATIN CAPITAL LETTER C WITH ACUTE",
  ["lccode"]=0x0107,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["specials"]={ "char", 0x0043, 0x0301 },
  ["unicodeslot"]=0x0106, -- Ć
 },
 {
  ["adobename"]="cacute",
  ["category"]="ll",
  ["contextname"]="cacute",
  ["description"]="LATIN SMALL LETTER C WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["specials"]={ "char", 0x0063, 0x0301 },
  ["uccode"]=0x0106,
  ["unicodeslot"]=0x0107, -- ć
 },
 {
  ["adobename"]="Ccircumflex",
  ["category"]="lu",
  ["contextname"]="Ccircumflex",
  ["description"]="LATIN CAPITAL LETTER C WITH CIRCUMFLEX",
  ["lccode"]=0x0109,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["specials"]={ "char", 0x0043, 0x0302 },
  ["unicodeslot"]=0x0108, -- Ĉ
 },
 {
  ["adobename"]="ccircumflex",
  ["category"]="ll",
  ["contextname"]="ccircumflex",
  ["description"]="LATIN SMALL LETTER C WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["specials"]={ "char", 0x0063, 0x0302 },
  ["uccode"]=0x0108,
  ["unicodeslot"]=0x0109, -- ĉ
 },
 {
  ["adobename"]="Cdotaccent",
  ["category"]="lu",
  ["contextname"]="Cdotaccent",
  ["description"]="LATIN CAPITAL LETTER C WITH DOT ABOVE",
  ["lccode"]=0x010B,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["specials"]={ "char", 0x0043, 0x0307 },
  ["unicodeslot"]=0x010A, -- Ċ
 },
 {
  ["adobename"]="cdotaccent",
  ["category"]="ll",
  ["contextname"]="cdotaccent",
  ["description"]="LATIN SMALL LETTER C WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["specials"]={ "char", 0x0063, 0x0307 },
  ["uccode"]=0x010A,
  ["unicodeslot"]=0x010B, -- ċ
 },
 {
  ["adobename"]="Ccaron",
  ["category"]="lu",
  ["contextname"]="Ccaron",
  ["description"]="LATIN CAPITAL LETTER C WITH CARON",
  ["lccode"]=0x010D,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["specials"]={ "char", 0x0043, 0x030C },
  ["unicodeslot"]=0x010C, -- Č
 },
 {
  ["adobename"]="ccaron",
  ["category"]="ll",
  ["contextname"]="ccaron",
  ["description"]="LATIN SMALL LETTER C WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["specials"]={ "char", 0x0063, 0x030C },
  ["uccode"]=0x010C,
  ["unicodeslot"]=0x010D, -- č
 },
 {
  ["adobename"]="Dcaron",
  ["category"]="lu",
  ["contextname"]="Dcaron",
  ["description"]="LATIN CAPITAL LETTER D WITH CARON",
  ["lccode"]=0x010F,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["specials"]={ "char", 0x0044, 0x030C },
  ["unicodeslot"]=0x010E, -- Ď
 },
 {
  ["adobename"]="dcaron",
  ["category"]="ll",
  ["contextname"]="dcaron",
  ["description"]="LATIN SMALL LETTER D WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["specials"]={ "char", 0x0064, 0x030C },
  ["uccode"]=0x010E,
  ["unicodeslot"]=0x010F, -- ď
 },
 {
  ["adobename"]="Dcroat",
  ["category"]="lu",
  ["contextname"]="Dstroke",
  ["description"]="LATIN CAPITAL LETTER D WITH STROKE",
  ["lccode"]=0x0111,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["unicodeslot"]=0x0110, -- Đ
 },
 {
  ["adobename"]="dcroat",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="dstroke",
  ["description"]="LATIN SMALL LETTER D WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["uccode"]=0x0110,
  ["unicodeslot"]=0x0111, -- đ
 },
 {
  ["adobename"]="Emacron",
  ["category"]="lu",
  ["contextname"]="Emacron",
  ["description"]="LATIN CAPITAL LETTER E WITH MACRON",
  ["lccode"]=0x0113,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0304 },
  ["unicodeslot"]=0x0112, -- Ē
 },
 {
  ["adobename"]="emacron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="emacron",
  ["description"]="LATIN SMALL LETTER E WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0304 },
  ["uccode"]=0x0112,
  ["unicodeslot"]=0x0113, -- ē
 },
 {
  ["adobename"]="Ebreve",
  ["category"]="lu",
  ["contextname"]="Ebreve",
  ["description"]="LATIN CAPITAL LETTER E WITH BREVE",
  ["lccode"]=0x0115,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0306 },
  ["unicodeslot"]=0x0114, -- Ĕ
 },
 {
  ["adobename"]="ebreve",
  ["category"]="ll",
  ["contextname"]="ebreve",
  ["description"]="LATIN SMALL LETTER E WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0306 },
  ["uccode"]=0x0114,
  ["unicodeslot"]=0x0115, -- ĕ
 },
 {
  ["adobename"]="Edotaccent",
  ["category"]="lu",
  ["contextname"]="Edotaccent",
  ["description"]="LATIN CAPITAL LETTER E WITH DOT ABOVE",
  ["lccode"]=0x0117,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0307 },
  ["unicodeslot"]=0x0116, -- Ė
 },
 {
  ["adobename"]="edotaccent",
  ["category"]="ll",
  ["contextname"]="edotaccent",
  ["description"]="LATIN SMALL LETTER E WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0307 },
  ["uccode"]=0x0116,
  ["unicodeslot"]=0x0117, -- ė
 },
 {
  ["adobename"]="Eogonek",
  ["category"]="lu",
  ["contextname"]="Eogonek",
  ["description"]="LATIN CAPITAL LETTER E WITH OGONEK",
  ["lccode"]=0x0119,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0328 },
  ["unicodeslot"]=0x0118, -- Ę
 },
 {
  ["adobename"]="eogonek",
  ["category"]="ll",
  ["contextname"]="eogonek",
  ["description"]="LATIN SMALL LETTER E WITH OGONEK",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0328 },
  ["uccode"]=0x0118,
  ["unicodeslot"]=0x0119, -- ę
 },
 {
  ["adobename"]="Ecaron",
  ["category"]="lu",
  ["contextname"]="Ecaron",
  ["description"]="LATIN CAPITAL LETTER E WITH CARON",
  ["lccode"]=0x011B,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x030C },
  ["unicodeslot"]=0x011A, -- Ě
 },
 {
  ["adobename"]="ecaron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ecaron",
  ["description"]="LATIN SMALL LETTER E WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x030C },
  ["uccode"]=0x011A,
  ["unicodeslot"]=0x011B, -- ě
 },
 {
  ["adobename"]="Gcircumflex",
  ["category"]="lu",
  ["contextname"]="Gcircumflex",
  ["description"]="LATIN CAPITAL LETTER G WITH CIRCUMFLEX",
  ["lccode"]=0x011D,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["specials"]={ "char", 0x0047, 0x0302 },
  ["unicodeslot"]=0x011C, -- Ĝ
 },
 {
  ["adobename"]="gcircumflex",
  ["category"]="ll",
  ["contextname"]="gcircumflex",
  ["description"]="LATIN SMALL LETTER G WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["specials"]={ "char", 0x0067, 0x0302 },
  ["uccode"]=0x011C,
  ["unicodeslot"]=0x011D, -- ĝ
 },
 {
  ["adobename"]="Gbreve",
  ["category"]="lu",
  ["contextname"]="Gbreve",
  ["description"]="LATIN CAPITAL LETTER G WITH BREVE",
  ["lccode"]=0x011F,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["specials"]={ "char", 0x0047, 0x0306 },
  ["unicodeslot"]=0x011E, -- Ğ
 },
 {
  ["adobename"]="gbreve",
  ["category"]="ll",
  ["contextname"]="gbreve",
  ["description"]="LATIN SMALL LETTER G WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["specials"]={ "char", 0x0067, 0x0306 },
  ["uccode"]=0x011E,
  ["unicodeslot"]=0x011F, -- ğ
 },
 {
  ["adobename"]="Gdotaccent",
  ["category"]="lu",
  ["contextname"]="Gdotaccent",
  ["description"]="LATIN CAPITAL LETTER G WITH DOT ABOVE",
  ["lccode"]=0x0121,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["specials"]={ "char", 0x0047, 0x0307 },
  ["unicodeslot"]=0x0120, -- Ġ
 },
 {
  ["adobename"]="gdotaccent",
  ["category"]="ll",
  ["contextname"]="gdotaccent",
  ["description"]="LATIN SMALL LETTER G WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["specials"]={ "char", 0x0067, 0x0307 },
  ["uccode"]=0x0120,
  ["unicodeslot"]=0x0121, -- ġ
 },
 {
  ["adobename"]="Gcommaaccent",
  ["category"]="lu",
  ["contextname"]="Gcommaaccent",
  ["description"]="LATIN CAPITAL LETTER G WITH CEDILLA",
  ["lccode"]=0x0123,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["specials"]={ "char", 0x0047, 0x0327 },
  ["unicodeslot"]=0x0122, -- Ģ
 },
 {
  ["adobename"]="gcommaaccent",
  ["category"]="ll",
  ["contextname"]="gcommaaccent",
  ["description"]="LATIN SMALL LETTER G WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["specials"]={ "char", 0x0067, 0x0327 },
  ["uccode"]=0x0122,
  ["unicodeslot"]=0x0123, -- ģ
 },
 {
  ["adobename"]="Hcircumflex",
  ["category"]="lu",
  ["contextname"]="Hcircumflex",
  ["description"]="LATIN CAPITAL LETTER H WITH CIRCUMFLEX",
  ["lccode"]=0x0125,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["specials"]={ "char", 0x0048, 0x0302 },
  ["unicodeslot"]=0x0124, -- Ĥ
 },
 {
  ["adobename"]="hcircumflex",
  ["category"]="ll",
  ["contextname"]="hcircumflex",
  ["description"]="LATIN SMALL LETTER H WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x0302 },
  ["uccode"]=0x0124,
  ["unicodeslot"]=0x0125, -- ĥ
 },
 {
  ["adobename"]="Hbar",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Hstroke",
  ["description"]="LATIN CAPITAL LETTER H WITH STROKE",
  ["lccode"]=0x0127,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["unicodeslot"]=0x0126, -- Ħ
 },
 {
  ["adobename"]="hbar",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="hstroke",
  ["description"]="LATIN SMALL LETTER H WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["uccode"]=0x0126,
  ["unicodeslot"]=0x0127, -- ħ
 },
 {
  ["adobename"]="Itilde",
  ["category"]="lu",
  ["contextname"]="Itilde",
  ["description"]="LATIN CAPITAL LETTER I WITH TILDE",
  ["lccode"]=0x0129,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0303 },
  ["unicodeslot"]=0x0128, -- Ĩ
 },
 {
  ["adobename"]="itilde",
  ["category"]="ll",
  ["contextname"]="itilde",
  ["description"]="LATIN SMALL LETTER I WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0303 },
  ["uccode"]=0x0128,
  ["unicodeslot"]=0x0129, -- ĩ
 },
 {
  ["adobename"]="Imacron",
  ["category"]="lu",
  ["contextname"]="Imacron",
  ["description"]="LATIN CAPITAL LETTER I WITH MACRON",
  ["lccode"]=0x012B,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0304 },
  ["unicodeslot"]=0x012A, -- Ī
 },
 {
  ["adobename"]="imacron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="imacron",
  ["description"]="LATIN SMALL LETTER I WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0304 },
  ["uccode"]=0x012A,
  ["unicodeslot"]=0x012B, -- ī
 },
 {
  ["adobename"]="Ibreve",
  ["category"]="lu",
  ["contextname"]="Ibreve",
  ["description"]="LATIN CAPITAL LETTER I WITH BREVE",
  ["lccode"]=0x012D,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0306 },
  ["unicodeslot"]=0x012C, -- Ĭ
 },
 {
  ["adobename"]="ibreve",
  ["category"]="ll",
  ["contextname"]="ibreve",
  ["description"]="LATIN SMALL LETTER I WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0306 },
  ["uccode"]=0x012C,
  ["unicodeslot"]=0x012D, -- ĭ
 },
 {
  ["adobename"]="Iogonek",
  ["category"]="lu",
  ["contextname"]="Iogonek",
  ["description"]="LATIN CAPITAL LETTER I WITH OGONEK",
  ["lccode"]=0x012F,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0328 },
  ["unicodeslot"]=0x012E, -- Į
 },
 {
  ["adobename"]="iogonek",
  ["category"]="ll",
  ["contextname"]="iogonek",
  ["description"]="LATIN SMALL LETTER I WITH OGONEK",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0328 },
  ["uccode"]=0x012E,
  ["unicodeslot"]=0x012F, -- į
 },
 {
  ["adobename"]="Idotaccent",
  ["category"]="lu",
  ["contextname"]="Idotaccent",
  ["description"]="LATIN CAPITAL LETTER I WITH DOT ABOVE",
  ["lccode"]=0x0069,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0307 },
  ["unicodeslot"]=0x0130, -- İ
 },
 {
  ["adobename"]="dotlessi",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="dotlessi",
  ["description"]="LATIN SMALL LETTER DOTLESS I",
  ["linebreak"]="al",
  ["uccode"]=0x0049,
  ["unicodeslot"]=0x0131, -- ı
 },
 {
  ["adobename"]="IJ",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="IJligature",
  ["description"]="LATIN CAPITAL LIGATURE IJ",
  ["lccode"]=0x0133,
  ["linebreak"]="al",
  ["shcode"]={ 0x0049, 0x004A },
  ["specials"]={ "compat", 0x0049, 0x004A },
  ["unicodeslot"]=0x0132, -- Ĳ
 },
 {
  ["adobename"]="ij",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ijligature",
  ["description"]="LATIN SMALL LIGATURE IJ",
  ["linebreak"]="al",
  ["shcode"]={ 0x0069, 0x006A },
  ["specials"]={ "compat", 0x0069, 0x006A },
  ["uccode"]=0x0132,
  ["unicodeslot"]=0x0133, -- ĳ
 },
 {
  ["adobename"]="Jcircumflex",
  ["category"]="lu",
  ["contextname"]="Jcircumflex",
  ["description"]="LATIN CAPITAL LETTER J WITH CIRCUMFLEX",
  ["lccode"]=0x0135,
  ["linebreak"]="al",
  ["shcode"]=0x004A,
  ["specials"]={ "char", 0x004A, 0x0302 },
  ["unicodeslot"]=0x0134, -- Ĵ
 },
 {
  ["adobename"]="jcircumflex",
  ["category"]="ll",
  ["contextname"]="jcircumflex",
  ["description"]="LATIN SMALL LETTER J WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x006A,
  ["specials"]={ "char", 0x006A, 0x0302 },
  ["uccode"]=0x0134,
  ["unicodeslot"]=0x0135, -- ĵ
 },
 {
  ["adobename"]="Kcommaaccent",
  ["category"]="lu",
  ["contextname"]="Kcommaaccent",
  ["description"]="LATIN CAPITAL LETTER K WITH CEDILLA",
  ["lccode"]=0x0137,
  ["linebreak"]="al",
  ["shcode"]=0x004B,
  ["specials"]={ "char", 0x004B, 0x0327 },
  ["unicodeslot"]=0x0136, -- Ķ
 },
 {
  ["adobename"]="kcommaaccent",
  ["category"]="ll",
  ["contextname"]="kcommaaccent",
  ["description"]="LATIN SMALL LETTER K WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x006B,
  ["specials"]={ "char", 0x006B, 0x0327 },
  ["uccode"]=0x0136,
  ["unicodeslot"]=0x0137, -- ķ
 },
 {
  ["adobename"]="kgreenlandic",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="kkra",
  ["description"]="LATIN SMALL LETTER KRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0138, -- ĸ
 },
 {
  ["adobename"]="Lacute",
  ["category"]="lu",
  ["contextname"]="Lacute",
  ["description"]="LATIN CAPITAL LETTER L WITH ACUTE",
  ["lccode"]=0x013A,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "char", 0x004C, 0x0301 },
  ["unicodeslot"]=0x0139, -- Ĺ
 },
 {
  ["adobename"]="lacute",
  ["category"]="ll",
  ["contextname"]="lacute",
  ["description"]="LATIN SMALL LETTER L WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "char", 0x006C, 0x0301 },
  ["uccode"]=0x0139,
  ["unicodeslot"]=0x013A, -- ĺ
 },
 {
  ["adobename"]="Lcommaaccent",
  ["category"]="lu",
  ["contextname"]="Lcommaaccent",
  ["description"]="LATIN CAPITAL LETTER L WITH CEDILLA",
  ["lccode"]=0x013C,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "char", 0x004C, 0x0327 },
  ["unicodeslot"]=0x013B, -- Ļ
 },
 {
  ["adobename"]="lcommaaccent",
  ["category"]="ll",
  ["contextname"]="lcommaaccent",
  ["description"]="LATIN SMALL LETTER L WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "char", 0x006C, 0x0327 },
  ["uccode"]=0x013B,
  ["unicodeslot"]=0x013C, -- ļ
 },
 {
  ["adobename"]="Lcaron",
  ["category"]="lu",
  ["contextname"]="Lcaron",
  ["description"]="LATIN CAPITAL LETTER L WITH CARON",
  ["lccode"]=0x013E,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "char", 0x004C, 0x030C },
  ["unicodeslot"]=0x013D, -- Ľ
 },
 {
  ["adobename"]="lcaron",
  ["category"]="ll",
  ["contextname"]="lcaron",
  ["description"]="LATIN SMALL LETTER L WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "char", 0x006C, 0x030C },
  ["uccode"]=0x013D,
  ["unicodeslot"]=0x013E, -- ľ
 },
 {
  ["adobename"]="Ldot",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Ldotmiddle",
  ["description"]="LATIN CAPITAL LETTER L WITH MIDDLE DOT",
  ["lccode"]=0x0140,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "compat", 0x004C, 0x00B7 },
  ["unicodeslot"]=0x013F, -- Ŀ
 },
 {
  ["adobename"]="ldot",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ldotmiddle",
  ["description"]="LATIN SMALL LETTER L WITH MIDDLE DOT",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "compat", 0x006C, 0x00B7 },
  ["uccode"]=0x013F,
  ["unicodeslot"]=0x0140, -- ŀ
 },
 {
  ["adobename"]="Lslash",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Lstroke",
  ["description"]="LATIN CAPITAL LETTER L WITH STROKE",
  ["lccode"]=0x0142,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["unicodeslot"]=0x0141, -- Ł
 },
 {
  ["adobename"]="lslash",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="lstroke",
  ["description"]="LATIN SMALL LETTER L WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["uccode"]=0x0141,
  ["unicodeslot"]=0x0142, -- ł
 },
 {
  ["adobename"]="Nacute",
  ["category"]="lu",
  ["contextname"]="Nacute",
  ["description"]="LATIN CAPITAL LETTER N WITH ACUTE",
  ["lccode"]=0x0144,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x0301 },
  ["unicodeslot"]=0x0143, -- Ń
 },
 {
  ["adobename"]="nacute",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="nacute",
  ["description"]="LATIN SMALL LETTER N WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x0301 },
  ["uccode"]=0x0143,
  ["unicodeslot"]=0x0144, -- ń
 },
 {
  ["adobename"]="Ncommaaccent",
  ["category"]="lu",
  ["contextname"]="Ncommaaccent",
  ["description"]="LATIN CAPITAL LETTER N WITH CEDILLA",
  ["lccode"]=0x0146,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x0327 },
  ["unicodeslot"]=0x0145, -- Ņ
 },
 {
  ["adobename"]="ncommaaccent",
  ["category"]="ll",
  ["contextname"]="ncommaaccent",
  ["description"]="LATIN SMALL LETTER N WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x0327 },
  ["uccode"]=0x0145,
  ["unicodeslot"]=0x0146, -- ņ
 },
 {
  ["adobename"]="Ncaron",
  ["category"]="lu",
  ["contextname"]="Ncaron",
  ["description"]="LATIN CAPITAL LETTER N WITH CARON",
  ["lccode"]=0x0148,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x030C },
  ["unicodeslot"]=0x0147, -- Ň
 },
 {
  ["adobename"]="ncaron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ncaron",
  ["description"]="LATIN SMALL LETTER N WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x030C },
  ["uccode"]=0x0147,
  ["unicodeslot"]=0x0148, -- ň
 },
 {
  ["adobename"]="napostrophe",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="napostrophe",
  ["description"]="LATIN SMALL LETTER N PRECEDED BY APOSTROPHE",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x02BC, 0x006E },
  ["unicodeslot"]=0x0149, -- ŉ
 },
 {
  ["adobename"]="Eng",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Neng",
  ["description"]="LATIN CAPITAL LETTER ENG",
  ["lccode"]=0x014B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x014A, -- Ŋ
 },
 {
  ["adobename"]="eng",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="neng",
  ["description"]="LATIN SMALL LETTER ENG",
  ["linebreak"]="al",
  ["uccode"]=0x014A,
  ["unicodeslot"]=0x014B, -- ŋ
 },
 {
  ["adobename"]="Omacron",
  ["category"]="lu",
  ["contextname"]="Omacron",
  ["description"]="LATIN CAPITAL LETTER O WITH MACRON",
  ["lccode"]=0x014D,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0304 },
  ["unicodeslot"]=0x014C, -- Ō
 },
 {
  ["adobename"]="omacron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="omacron",
  ["description"]="LATIN SMALL LETTER O WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0304 },
  ["uccode"]=0x014C,
  ["unicodeslot"]=0x014D, -- ō
 },
 {
  ["adobename"]="Obreve",
  ["category"]="lu",
  ["contextname"]="Obreve",
  ["description"]="LATIN CAPITAL LETTER O WITH BREVE",
  ["lccode"]=0x014F,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0306 },
  ["unicodeslot"]=0x014E, -- Ŏ
 },
 {
  ["adobename"]="obreve",
  ["category"]="ll",
  ["contextname"]="obreve",
  ["description"]="LATIN SMALL LETTER O WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0306 },
  ["uccode"]=0x014E,
  ["unicodeslot"]=0x014F, -- ŏ
 },
 {
  ["adobename"]="Ohungarumlaut",
  ["category"]="lu",
  ["contextname"]="Ohungarumlaut",
  ["description"]="LATIN CAPITAL LETTER O WITH DOUBLE ACUTE",
  ["lccode"]=0x0151,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x030B },
  ["unicodeslot"]=0x0150, -- Ő
 },
 {
  ["adobename"]="ohungarumlaut",
  ["category"]="ll",
  ["contextname"]="ohungarumlaut",
  ["description"]="LATIN SMALL LETTER O WITH DOUBLE ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x030B },
  ["uccode"]=0x0150,
  ["unicodeslot"]=0x0151, -- ő
 },
 {
  ["adobename"]="OE",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="OEligature",
  ["description"]="LATIN CAPITAL LIGATURE OE",
  ["lccode"]=0x0153,
  ["linebreak"]="al",
  ["shcode"]={ 0x004F, 0x0045 },
  ["unicodeslot"]=0x0152, -- Œ
 },
 {
  ["adobename"]="oe",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="oeligature",
  ["description"]="LATIN SMALL LIGATURE OE",
  ["linebreak"]="al",
  ["shcode"]={ 0x006F, 0x0065 },
  ["uccode"]=0x0152,
  ["unicodeslot"]=0x0153, -- œ
 },
 {
  ["adobename"]="Racute",
  ["category"]="lu",
  ["contextname"]="Racute",
  ["description"]="LATIN CAPITAL LETTER R WITH ACUTE",
  ["lccode"]=0x0155,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x0301 },
  ["unicodeslot"]=0x0154, -- Ŕ
 },
 {
  ["adobename"]="racute",
  ["category"]="ll",
  ["contextname"]="racute",
  ["description"]="LATIN SMALL LETTER R WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x0301 },
  ["uccode"]=0x0154,
  ["unicodeslot"]=0x0155, -- ŕ
 },
 {
  ["adobename"]="Rcommaaccent",
  ["category"]="lu",
  ["contextname"]="Rcommaaccent",
  ["description"]="LATIN CAPITAL LETTER R WITH CEDILLA",
  ["lccode"]=0x0157,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x0327 },
  ["unicodeslot"]=0x0156, -- Ŗ
 },
 {
  ["adobename"]="rcommaaccent",
  ["category"]="ll",
  ["contextname"]="rcommaaccent",
  ["description"]="LATIN SMALL LETTER R WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x0327 },
  ["uccode"]=0x0156,
  ["unicodeslot"]=0x0157, -- ŗ
 },
 {
  ["adobename"]="Rcaron",
  ["category"]="lu",
  ["contextname"]="Rcaron",
  ["description"]="LATIN CAPITAL LETTER R WITH CARON",
  ["lccode"]=0x0159,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x030C },
  ["unicodeslot"]=0x0158, -- Ř
 },
 {
  ["adobename"]="rcaron",
  ["category"]="ll",
  ["contextname"]="rcaron",
  ["description"]="LATIN SMALL LETTER R WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x030C },
  ["uccode"]=0x0158,
  ["unicodeslot"]=0x0159, -- ř
 },
 {
  ["adobename"]="Sacute",
  ["category"]="lu",
  ["contextname"]="Sacute",
  ["description"]="LATIN CAPITAL LETTER S WITH ACUTE",
  ["lccode"]=0x015B,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0053, 0x0301 },
  ["unicodeslot"]=0x015A, -- Ś
 },
 {
  ["adobename"]="sacute",
  ["category"]="ll",
  ["contextname"]="sacute",
  ["description"]="LATIN SMALL LETTER S WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0073, 0x0301 },
  ["uccode"]=0x015A,
  ["unicodeslot"]=0x015B, -- ś
 },
 {
  ["adobename"]="Scircumflex",
  ["category"]="lu",
  ["contextname"]="Scircumflex",
  ["description"]="LATIN CAPITAL LETTER S WITH CIRCUMFLEX",
  ["lccode"]=0x015D,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0053, 0x0302 },
  ["unicodeslot"]=0x015C, -- Ŝ
 },
 {
  ["adobename"]="scircumflex",
  ["category"]="ll",
  ["contextname"]="scircumflex",
  ["description"]="LATIN SMALL LETTER S WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0073, 0x0302 },
  ["uccode"]=0x015C,
  ["unicodeslot"]=0x015D, -- ŝ
 },
 {
  ["adobename"]="Scedilla",
  ["category"]="lu",
  ["contextname"]="Scedilla",
  ["description"]="LATIN CAPITAL LETTER S WITH CEDILLA",
  ["lccode"]=0x015F,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0053, 0x0327 },
  ["unicodeslot"]=0x015E, -- Ş
 },
 {
  ["adobename"]="scedilla",
  ["category"]="ll",
  ["contextname"]="scedilla",
  ["description"]="LATIN SMALL LETTER S WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0073, 0x0327 },
  ["uccode"]=0x015E,
  ["unicodeslot"]=0x015F, -- ş
 },
 {
  ["adobename"]="Scaron",
  ["category"]="lu",
  ["contextname"]="Scaron",
  ["description"]="LATIN CAPITAL LETTER S WITH CARON",
  ["lccode"]=0x0161,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0053, 0x030C },
  ["unicodeslot"]=0x0160, -- Š
 },
 {
  ["adobename"]="scaron",
  ["category"]="ll",
  ["contextname"]="scaron",
  ["description"]="LATIN SMALL LETTER S WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0073, 0x030C },
  ["uccode"]=0x0160,
  ["unicodeslot"]=0x0161, -- š
 },
 {
  ["adobename"]="Tcommaaccent",
  ["category"]="lu",
  ["contextname"]="Tcedilla",
  ["description"]="LATIN CAPITAL LETTER T WITH CEDILLA",
  ["lccode"]=0x0163,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["specials"]={ "char", 0x0054, 0x0327 },
  ["unicodeslot"]=0x0162, -- Ţ
 },
 {
  ["adobename"]="tcommaaccent",
  ["category"]="ll",
  ["contextname"]="tcedilla",
  ["description"]="LATIN SMALL LETTER T WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x0327 },
  ["uccode"]=0x0162,
  ["unicodeslot"]=0x0163, -- ţ
 },
 {
  ["adobename"]="Tcaron",
  ["category"]="lu",
  ["contextname"]="Tcaron",
  ["description"]="LATIN CAPITAL LETTER T WITH CARON",
  ["lccode"]=0x0165,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["specials"]={ "char", 0x0054, 0x030C },
  ["unicodeslot"]=0x0164, -- Ť
 },
 {
  ["adobename"]="tcaron",
  ["category"]="ll",
  ["contextname"]="tcaron",
  ["description"]="LATIN SMALL LETTER T WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x030C },
  ["uccode"]=0x0164,
  ["unicodeslot"]=0x0165, -- ť
 },
 {
  ["adobename"]="Tbar",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="Tstroke",
  ["description"]="LATIN CAPITAL LETTER T WITH STROKE",
  ["lccode"]=0x0167,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["unicodeslot"]=0x0166, -- Ŧ
 },
 {
  ["adobename"]="tbar",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="tstroke",
  ["description"]="LATIN SMALL LETTER T WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["uccode"]=0x0166,
  ["unicodeslot"]=0x0167, -- ŧ
 },
 {
  ["adobename"]="Utilde",
  ["category"]="lu",
  ["contextname"]="Utilde",
  ["description"]="LATIN CAPITAL LETTER U WITH TILDE",
  ["lccode"]=0x0169,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0303 },
  ["unicodeslot"]=0x0168, -- Ũ
 },
 {
  ["adobename"]="utilde",
  ["category"]="ll",
  ["contextname"]="utilde",
  ["description"]="LATIN SMALL LETTER U WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0303 },
  ["uccode"]=0x0168,
  ["unicodeslot"]=0x0169, -- ũ
 },
 {
  ["adobename"]="Umacron",
  ["category"]="lu",
  ["contextname"]="Umacron",
  ["description"]="LATIN CAPITAL LETTER U WITH MACRON",
  ["lccode"]=0x016B,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0304 },
  ["unicodeslot"]=0x016A, -- Ū
 },
 {
  ["adobename"]="umacron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="umacron",
  ["description"]="LATIN SMALL LETTER U WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0304 },
  ["uccode"]=0x016A,
  ["unicodeslot"]=0x016B, -- ū
 },
 {
  ["adobename"]="Ubreve",
  ["category"]="lu",
  ["contextname"]="Ubreve",
  ["description"]="LATIN CAPITAL LETTER U WITH BREVE",
  ["lccode"]=0x016D,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0306 },
  ["unicodeslot"]=0x016C, -- Ŭ
 },
 {
  ["adobename"]="ubreve",
  ["category"]="ll",
  ["contextname"]="ubreve",
  ["description"]="LATIN SMALL LETTER U WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0306 },
  ["uccode"]=0x016C,
  ["unicodeslot"]=0x016D, -- ŭ
 },
 {
  ["adobename"]="Uring",
  ["category"]="lu",
  ["contextname"]="Uring",
  ["description"]="LATIN CAPITAL LETTER U WITH RING ABOVE",
  ["lccode"]=0x016F,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x030A },
  ["unicodeslot"]=0x016E, -- Ů
 },
 {
  ["adobename"]="uring",
  ["category"]="ll",
  ["contextname"]="uring",
  ["description"]="LATIN SMALL LETTER U WITH RING ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x030A },
  ["uccode"]=0x016E,
  ["unicodeslot"]=0x016F, -- ů
 },
 {
  ["adobename"]="Uhungarumlaut",
  ["category"]="lu",
  ["contextname"]="Uhungarumlaut",
  ["description"]="LATIN CAPITAL LETTER U WITH DOUBLE ACUTE",
  ["lccode"]=0x0171,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x030B },
  ["unicodeslot"]=0x0170, -- Ű
 },
 {
  ["adobename"]="uhungarumlaut",
  ["category"]="ll",
  ["contextname"]="uhungarumlaut",
  ["description"]="LATIN SMALL LETTER U WITH DOUBLE ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x030B },
  ["uccode"]=0x0170,
  ["unicodeslot"]=0x0171, -- ű
 },
 {
  ["adobename"]="Uogonek",
  ["category"]="lu",
  ["contextname"]="Uogonek",
  ["description"]="LATIN CAPITAL LETTER U WITH OGONEK",
  ["lccode"]=0x0173,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0328 },
  ["unicodeslot"]=0x0172, -- Ų
 },
 {
  ["adobename"]="uogonek",
  ["category"]="ll",
  ["contextname"]="uogonek",
  ["description"]="LATIN SMALL LETTER U WITH OGONEK",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0328 },
  ["uccode"]=0x0172,
  ["unicodeslot"]=0x0173, -- ų
 },
 {
  ["adobename"]="Wcircumflex",
  ["category"]="lu",
  ["contextname"]="Wcircumflex",
  ["description"]="LATIN CAPITAL LETTER W WITH CIRCUMFLEX",
  ["lccode"]=0x0175,
  ["linebreak"]="al",
  ["shcode"]=0x0057,
  ["specials"]={ "char", 0x0057, 0x0302 },
  ["unicodeslot"]=0x0174, -- Ŵ
 },
 {
  ["adobename"]="wcircumflex",
  ["category"]="ll",
  ["contextname"]="wcircumflex",
  ["description"]="LATIN SMALL LETTER W WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0077,
  ["specials"]={ "char", 0x0077, 0x0302 },
  ["uccode"]=0x0174,
  ["unicodeslot"]=0x0175, -- ŵ
 },
 {
  ["adobename"]="Ycircumflex",
  ["category"]="lu",
  ["contextname"]="Ycircumflex",
  ["description"]="LATIN CAPITAL LETTER Y WITH CIRCUMFLEX",
  ["lccode"]=0x0177,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0302 },
  ["unicodeslot"]=0x0176, -- Ŷ
 },
 {
  ["adobename"]="ycircumflex",
  ["category"]="ll",
  ["contextname"]="ycircumflex",
  ["description"]="LATIN SMALL LETTER Y WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0302 },
  ["uccode"]=0x0176,
  ["unicodeslot"]=0x0177, -- ŷ
 },
 {
  ["adobename"]="Ydieresis",
  ["category"]="lu",
  ["contextname"]="Ydiaeresis",
  ["description"]="LATIN CAPITAL LETTER Y WITH DIAERESIS",
  ["lccode"]=0x00FF,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0308 },
  ["unicodeslot"]=0x0178, -- Ÿ
 },
 {
  ["adobename"]="Zacute",
  ["category"]="lu",
  ["contextname"]="Zacute",
  ["description"]="LATIN CAPITAL LETTER Z WITH ACUTE",
  ["lccode"]=0x017A,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["specials"]={ "char", 0x005A, 0x0301 },
  ["unicodeslot"]=0x0179, -- Ź
 },
 {
  ["adobename"]="zacute",
  ["category"]="ll",
  ["contextname"]="zacute",
  ["description"]="LATIN SMALL LETTER Z WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["specials"]={ "char", 0x007A, 0x0301 },
  ["uccode"]=0x0179,
  ["unicodeslot"]=0x017A, -- ź
 },
 {
  ["adobename"]="Zdotaccent",
  ["category"]="lu",
  ["contextname"]="Zdotaccent",
  ["description"]="LATIN CAPITAL LETTER Z WITH DOT ABOVE",
  ["lccode"]=0x017C,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["specials"]={ "char", 0x005A, 0x0307 },
  ["unicodeslot"]=0x017B, -- Ż
 },
 {
  ["adobename"]="zdotaccent",
  ["category"]="ll",
  ["contextname"]="zdotaccent",
  ["description"]="LATIN SMALL LETTER Z WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["specials"]={ "char", 0x007A, 0x0307 },
  ["uccode"]=0x017B,
  ["unicodeslot"]=0x017C, -- ż
 },
 {
  ["adobename"]="Zcaron",
  ["category"]="lu",
  ["contextname"]="Zcaron",
  ["description"]="LATIN CAPITAL LETTER Z WITH CARON",
  ["lccode"]=0x017E,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["specials"]={ "char", 0x005A, 0x030C },
  ["unicodeslot"]=0x017D, -- Ž
 },
 {
  ["adobename"]="zcaron",
  ["category"]="ll",
  ["contextname"]="zcaron",
  ["description"]="LATIN SMALL LETTER Z WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["specials"]={ "char", 0x007A, 0x030C },
  ["uccode"]=0x017D,
  ["unicodeslot"]=0x017E, -- ž
 },
 {
  ["adobename"]="longs",
  ["category"]="ll",
  ["contextname"]="slong",
  ["description"]="LATIN SMALL LETTER LONG S",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0073 },
  ["uccode"]=0x0053,
  ["unicodeslot"]=0x017F, -- ſ
 },
 {
  ["category"]="ll",
  ["contextname"]="bstroke",
  ["description"]="LATIN SMALL LETTER B WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["uccode"]=0x0243,
  ["unicodeslot"]=0x0180, -- ƀ
 },
 {
  ["category"]="lu",
  ["contextname"]="Bhook",
  ["description"]="LATIN CAPITAL LETTER B WITH HOOK",
  ["lccode"]=0x0253,
  ["linebreak"]="al",
  ["shcode"]=0x0042,
  ["unicodeslot"]=0x0181, -- Ɓ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER B WITH TOPBAR",
  ["lccode"]=0x0183,
  ["linebreak"]="al",
  ["shcode"]=0x0042,
  ["unicodeslot"]=0x0182, -- Ƃ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER B WITH TOPBAR",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["uccode"]=0x0182,
  ["unicodeslot"]=0x0183, -- ƃ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER TONE SIX",
  ["lccode"]=0x0185,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0184, -- Ƅ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TONE SIX",
  ["linebreak"]="al",
  ["uccode"]=0x0184,
  ["unicodeslot"]=0x0185, -- ƅ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER OPEN O",
  ["lccode"]=0x0254,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0186, -- Ɔ
 },
 {
  ["category"]="lu",
  ["contextname"]="Chook",
  ["description"]="LATIN CAPITAL LETTER C WITH HOOK",
  ["lccode"]=0x0188,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["unicodeslot"]=0x0187, -- Ƈ
 },
 {
  ["category"]="ll",
  ["contextname"]="chook",
  ["description"]="LATIN SMALL LETTER C WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["uccode"]=0x0187,
  ["unicodeslot"]=0x0188, -- ƈ
 },
 {
  ["category"]="lu",
  ["contextname"]="Dafrican",
  ["description"]="LATIN CAPITAL LETTER AFRICAN D",
  ["lccode"]=0x0256,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0189, -- Ɖ
 },
 {
  ["category"]="lu",
  ["contextname"]="Dhook",
  ["description"]="LATIN CAPITAL LETTER D WITH HOOK",
  ["lccode"]=0x0257,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["unicodeslot"]=0x018A, -- Ɗ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER D WITH TOPBAR",
  ["lccode"]=0x018C,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["unicodeslot"]=0x018B, -- Ƌ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH TOPBAR",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["uccode"]=0x018B,
  ["unicodeslot"]=0x018C, -- ƌ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED DELTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x018D, -- ƍ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER REVERSED E",
  ["lccode"]=0x01DD,
  ["linebreak"]="al",
  ["unicodeslot"]=0x018E, -- Ǝ
 },
 {
  ["category"]="lu",
  ["contextname"]="Schwa",
  ["description"]="LATIN CAPITAL LETTER SCHWA",
  ["lccode"]=0x0259,
  ["linebreak"]="al",
  ["unicodeslot"]=0x018F, -- Ə
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER OPEN E",
  ["lccode"]=0x025B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0190, -- Ɛ
 },
 {
  ["category"]="lu",
  ["contextname"]="Fhook",
  ["description"]="LATIN CAPITAL LETTER F WITH HOOK",
  ["lccode"]=0x0192,
  ["linebreak"]="al",
  ["shcode"]=0x0046,
  ["unicodeslot"]=0x0191, -- Ƒ
 },
 {
  ["adobename"]="florin",
  ["category"]="ll",
  ["contextname"]="fhook",
  ["description"]="LATIN SMALL LETTER F WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0066,
  ["uccode"]=0x0191,
  ["unicodeslot"]=0x0192, -- ƒ
 },
 {
  ["category"]="lu",
  ["contextname"]="Ghook",
  ["description"]="LATIN CAPITAL LETTER G WITH HOOK",
  ["lccode"]=0x0260,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["unicodeslot"]=0x0193, -- Ɠ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER GAMMA",
  ["lccode"]=0x0263,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0194, -- Ɣ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER HV",
  ["linebreak"]="al",
  ["uccode"]=0x01F6,
  ["unicodeslot"]=0x0195, -- ƕ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER IOTA",
  ["lccode"]=0x0269,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0196, -- Ɩ
 },
 {
  ["category"]="lu",
  ["contextname"]="Istroke",
  ["description"]="LATIN CAPITAL LETTER I WITH STROKE",
  ["lccode"]=0x0268,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["unicodeslot"]=0x0197, -- Ɨ
 },
 {
  ["category"]="lu",
  ["contextname"]="Khook",
  ["description"]="LATIN CAPITAL LETTER K WITH HOOK",
  ["lccode"]=0x0199,
  ["linebreak"]="al",
  ["shcode"]=0x004B,
  ["unicodeslot"]=0x0198, -- Ƙ
 },
 {
  ["category"]="ll",
  ["contextname"]="khook",
  ["description"]="LATIN SMALL LETTER K WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006B,
  ["uccode"]=0x0198,
  ["unicodeslot"]=0x0199, -- ƙ
 },
 {
  ["category"]="ll",
  ["contextname"]="lbar",
  ["description"]="LATIN SMALL LETTER L WITH BAR",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["uccode"]=0x023D,
  ["unicodeslot"]=0x019A, -- ƚ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER LAMBDA WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x019B, -- ƛ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER TURNED M",
  ["lccode"]=0x026F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x019C, -- Ɯ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER N WITH LEFT HOOK",
  ["lccode"]=0x0272,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["unicodeslot"]=0x019D, -- Ɲ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH LONG RIGHT LEG",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["uccode"]=0x0220,
  ["unicodeslot"]=0x019E, -- ƞ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER O WITH MIDDLE TILDE",
  ["lccode"]=0x0275,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["unicodeslot"]=0x019F, -- Ɵ
 },
 {
  ["adobename"]="Ohorn",
  ["category"]="lu",
  ["contextname"]="Ohorn",
  ["description"]="LATIN CAPITAL LETTER O WITH HORN",
  ["lccode"]=0x01A1,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x031B },
  ["unicodeslot"]=0x01A0, -- Ơ
 },
 {
  ["adobename"]="ohorn",
  ["category"]="ll",
  ["contextname"]="ohorn",
  ["description"]="LATIN SMALL LETTER O WITH HORN",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x031B },
  ["uccode"]=0x01A0,
  ["unicodeslot"]=0x01A1, -- ơ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER OI",
  ["lccode"]=0x01A3,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01A2, -- Ƣ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER OI",
  ["linebreak"]="al",
  ["uccode"]=0x01A2,
  ["unicodeslot"]=0x01A3, -- ƣ
 },
 {
  ["category"]="lu",
  ["contextname"]="Phook",
  ["description"]="LATIN CAPITAL LETTER P WITH HOOK",
  ["lccode"]=0x01A5,
  ["linebreak"]="al",
  ["shcode"]=0x0050,
  ["unicodeslot"]=0x01A4, -- Ƥ
 },
 {
  ["category"]="ll",
  ["contextname"]="phook",
  ["description"]="LATIN SMALL LETTER P WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0070,
  ["uccode"]=0x01A4,
  ["unicodeslot"]=0x01A5, -- ƥ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN LETTER YR",
  ["lccode"]=0x0280,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01A6, -- Ʀ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER TONE TWO",
  ["lccode"]=0x01A8,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01A7, -- Ƨ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TONE TWO",
  ["linebreak"]="al",
  ["uccode"]=0x01A7,
  ["unicodeslot"]=0x01A8, -- ƨ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER ESH",
  ["lccode"]=0x0283,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01A9, -- Ʃ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER REVERSED ESH LOOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x01AA, -- ƪ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["unicodeslot"]=0x01AB, -- ƫ
 },
 {
  ["category"]="lu",
  ["contextname"]="Thook",
  ["description"]="LATIN CAPITAL LETTER T WITH HOOK",
  ["lccode"]=0x01AD,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["unicodeslot"]=0x01AC, -- Ƭ
 },
 {
  ["category"]="ll",
  ["contextname"]="thook",
  ["description"]="LATIN SMALL LETTER T WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["uccode"]=0x01AC,
  ["unicodeslot"]=0x01AD, -- ƭ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER T WITH RETROFLEX HOOK",
  ["lccode"]=0x0288,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["unicodeslot"]=0x01AE, -- Ʈ
 },
 {
  ["adobename"]="Uhorn",
  ["category"]="lu",
  ["contextname"]="Uhorn",
  ["description"]="LATIN CAPITAL LETTER U WITH HORN",
  ["lccode"]=0x01B0,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x031B },
  ["unicodeslot"]=0x01AF, -- Ư
 },
 {
  ["adobename"]="uhorn",
  ["category"]="ll",
  ["contextname"]="uhorn",
  ["description"]="LATIN SMALL LETTER U WITH HORN",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x031B },
  ["uccode"]=0x01AF,
  ["unicodeslot"]=0x01B0, -- ư
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER UPSILON",
  ["lccode"]=0x028A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01B1, -- Ʊ
 },
 {
  ["category"]="lu",
  ["contextname"]="Uhook",
  ["description"]="LATIN CAPITAL LETTER V WITH HOOK",
  ["lccode"]=0x028B,
  ["linebreak"]="al",
  ["shcode"]=0x0056,
  ["unicodeslot"]=0x01B2, -- Ʋ
 },
 {
  ["category"]="lu",
  ["contextname"]="Yhook",
  ["description"]="LATIN CAPITAL LETTER Y WITH HOOK",
  ["lccode"]=0x01B4,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["unicodeslot"]=0x01B3, -- Ƴ
 },
 {
  ["category"]="ll",
  ["contextname"]="yhook",
  ["description"]="LATIN SMALL LETTER Y WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["uccode"]=0x01B3,
  ["unicodeslot"]=0x01B4, -- ƴ
 },
 {
  ["category"]="lu",
  ["contextname"]="Zstroke",
  ["description"]="LATIN CAPITAL LETTER Z WITH STROKE",
  ["lccode"]=0x01B6,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["unicodeslot"]=0x01B5, -- Ƶ
 },
 {
  ["category"]="ll",
  ["contextname"]="zstroke",
  ["description"]="LATIN SMALL LETTER Z WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["uccode"]=0x01B5,
  ["unicodeslot"]=0x01B6, -- ƶ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER EZH",
  ["lccode"]=0x0292,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01B7, -- Ʒ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER EZH REVERSED",
  ["lccode"]=0x01B9,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01B8, -- Ƹ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER EZH REVERSED",
  ["linebreak"]="al",
  ["uccode"]=0x01B8,
  ["unicodeslot"]=0x01B9, -- ƹ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER EZH WITH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x0292,
  ["unicodeslot"]=0x01BA, -- ƺ
 },
 {
  ["category"]="lo",
  ["description"]="LATIN LETTER TWO WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x01BB, -- ƻ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER TONE FIVE",
  ["lccode"]=0x01BD,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01BC, -- Ƽ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TONE FIVE",
  ["linebreak"]="al",
  ["uccode"]=0x01BC,
  ["unicodeslot"]=0x01BD, -- ƽ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x01BE, -- ƾ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER WYNN",
  ["linebreak"]="al",
  ["uccode"]=0x01F7,
  ["unicodeslot"]=0x01BF, -- ƿ
 },
 {
  ["category"]="lo",
  ["description"]="LATIN LETTER DENTAL CLICK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x01C0, -- ǀ
 },
 {
  ["category"]="lo",
  ["description"]="LATIN LETTER LATERAL CLICK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x01C1, -- ǁ
 },
 {
  ["category"]="lo",
  ["description"]="LATIN LETTER ALVEOLAR CLICK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x01C2, -- ǂ
 },
 {
  ["category"]="lo",
  ["description"]="LATIN LETTER RETROFLEX CLICK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x01C3, -- ǃ
 },
 {
  ["category"]="lu",
  ["contextname"]="DZcaronligature",
  ["description"]="LATIN CAPITAL LETTER DZ WITH CARON",
  ["lccode"]=0x01C6,
  ["linebreak"]="al",
  ["shcode"]=0x01F1,
  ["specials"]={ "compat", 0x0044, 0x017D },
  ["uccode"]=0x01C5,
  ["unicodeslot"]=0x01C4, -- Ǆ
 },
 {
  ["category"]="lt",
  ["contextname"]="Dzcaronligature",
  ["description"]="LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON",
  ["lccode"]=0x01C6,
  ["linebreak"]="al",
  ["shcode"]=0x01F2,
  ["specials"]={ "compat", 0x0044, 0x017E },
  ["uccode"]=0x01C4,
  ["unicodeslot"]=0x01C5, -- ǅ
 },
 {
  ["category"]="ll",
  ["contextname"]="dzcaronligature",
  ["description"]="LATIN SMALL LETTER DZ WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x01F3,
  ["specials"]={ "compat", 0x0064, 0x017E },
  ["uccode"]=0x01C4,
  ["unicodeslot"]=0x01C6, -- ǆ
 },
 {
  ["category"]="lu",
  ["contextname"]="LJligature",
  ["description"]="LATIN CAPITAL LETTER LJ",
  ["lccode"]=0x01C9,
  ["linebreak"]="al",
  ["shcode"]={ 0x004C, 0x004A },
  ["specials"]={ "compat", 0x004C, 0x004A },
  ["uccode"]=0x01C8,
  ["unicodeslot"]=0x01C7, -- Ǉ
 },
 {
  ["category"]="lt",
  ["contextname"]="Ljligature",
  ["description"]="LATIN CAPITAL LETTER L WITH SMALL LETTER J",
  ["lccode"]=0x01C9,
  ["linebreak"]="al",
  ["shcode"]={ 0x004C, 0x006A },
  ["specials"]={ "compat", 0x004C, 0x006A },
  ["uccode"]=0x01C7,
  ["unicodeslot"]=0x01C8, -- ǈ
 },
 {
  ["category"]="ll",
  ["contextname"]="ljligature",
  ["description"]="LATIN SMALL LETTER LJ",
  ["linebreak"]="al",
  ["shcode"]={ 0x006C, 0x006A },
  ["specials"]={ "compat", 0x006C, 0x006A },
  ["uccode"]=0x01C7,
  ["unicodeslot"]=0x01C9, -- ǉ
 },
 {
  ["category"]="lu",
  ["contextname"]="NJligature",
  ["description"]="LATIN CAPITAL LETTER NJ",
  ["lccode"]=0x01CC,
  ["linebreak"]="al",
  ["shcode"]={ 0x004E, 0x004A },
  ["specials"]={ "compat", 0x004E, 0x004A },
  ["uccode"]=0x01CB,
  ["unicodeslot"]=0x01CA, -- Ǌ
 },
 {
  ["category"]="lt",
  ["contextname"]="Njligature",
  ["description"]="LATIN CAPITAL LETTER N WITH SMALL LETTER J",
  ["lccode"]=0x01CC,
  ["linebreak"]="al",
  ["shcode"]={ 0x004E, 0x006A },
  ["shcode"]=0x004E,
  ["specials"]={ "compat", 0x004E, 0x006A },
  ["uccode"]=0x01CA,
  ["unicodeslot"]=0x01CB, -- ǋ
 },
 {
  ["category"]="ll",
  ["contextname"]="njligature",
  ["description"]="LATIN SMALL LETTER NJ",
  ["linebreak"]="al",
  ["shcode"]={ 0x006E, 0x006A },
  ["specials"]={ "compat", 0x006E, 0x006A },
  ["uccode"]=0x01CA,
  ["unicodeslot"]=0x01CC, -- ǌ
 },
 {
  ["category"]="lu",
  ["contextname"]="Acaron",
  ["description"]="LATIN CAPITAL LETTER A WITH CARON",
  ["lccode"]=0x01CE,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x030C },
  ["unicodeslot"]=0x01CD, -- Ǎ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="acaron",
  ["description"]="LATIN SMALL LETTER A WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x030C },
  ["uccode"]=0x01CD,
  ["unicodeslot"]=0x01CE, -- ǎ
 },
 {
  ["category"]="lu",
  ["contextname"]="Icaron",
  ["description"]="LATIN CAPITAL LETTER I WITH CARON",
  ["lccode"]=0x01D0,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x030C },
  ["unicodeslot"]=0x01CF, -- Ǐ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="icaron",
  ["description"]="LATIN SMALL LETTER I WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x030C },
  ["uccode"]=0x01CF,
  ["unicodeslot"]=0x01D0, -- ǐ
 },
 {
  ["category"]="lu",
  ["contextname"]="Ocaron",
  ["description"]="LATIN CAPITAL LETTER O WITH CARON",
  ["lccode"]=0x01D2,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x030C },
  ["unicodeslot"]=0x01D1, -- Ǒ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ocaron",
  ["description"]="LATIN SMALL LETTER O WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x030C },
  ["uccode"]=0x01D1,
  ["unicodeslot"]=0x01D2, -- ǒ
 },
 {
  ["category"]="lu",
  ["contextname"]="Ucaron",
  ["description"]="LATIN CAPITAL LETTER U WITH CARON",
  ["lccode"]=0x01D4,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x030C },
  ["unicodeslot"]=0x01D3, -- Ǔ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="ucaron",
  ["description"]="LATIN SMALL LETTER U WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x030C },
  ["uccode"]=0x01D3,
  ["unicodeslot"]=0x01D4, -- ǔ
 },
 {
  ["category"]="lu",
  ["contextname"]="Udiaeresismacron",
  ["description"]="LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON",
  ["lccode"]=0x01D6,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x00DC, 0x0304 },
  ["unicodeslot"]=0x01D5, -- Ǖ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="udiaeresismacron",
  ["description"]="LATIN SMALL LETTER U WITH DIAERESIS AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x00FC, 0x0304 },
  ["uccode"]=0x01D5,
  ["unicodeslot"]=0x01D6, -- ǖ
 },
 {
  ["category"]="lu",
  ["contextname"]="Udiaeresisacute",
  ["description"]="LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE",
  ["lccode"]=0x01D8,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x00DC, 0x0301 },
  ["unicodeslot"]=0x01D7, -- Ǘ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="udiaeresisacute",
  ["description"]="LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x00FC, 0x0301 },
  ["uccode"]=0x01D7,
  ["unicodeslot"]=0x01D8, -- ǘ
 },
 {
  ["category"]="lu",
  ["contextname"]="Udiaeresiscaron",
  ["description"]="LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON",
  ["lccode"]=0x01DA,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x00DC, 0x030C },
  ["unicodeslot"]=0x01D9, -- Ǚ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="udiaeresiscaron",
  ["description"]="LATIN SMALL LETTER U WITH DIAERESIS AND CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x00FC, 0x030C },
  ["uccode"]=0x01D9,
  ["unicodeslot"]=0x01DA, -- ǚ
 },
 {
  ["category"]="lu",
  ["contextname"]="Udiaeresisgrave",
  ["description"]="LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE",
  ["lccode"]=0x01DC,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x00DC, 0x0300 },
  ["unicodeslot"]=0x01DB, -- Ǜ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="udiaeresisgrave",
  ["description"]="LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x00FC, 0x0300 },
  ["uccode"]=0x01DB,
  ["unicodeslot"]=0x01DC, -- ǜ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED E",
  ["linebreak"]="al",
  ["uccode"]=0x018E,
  ["unicodeslot"]=0x01DD, -- ǝ
 },
 {
  ["category"]="lu",
  ["contextname"]="Adiaeresismacron",
  ["description"]="LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON",
  ["lccode"]=0x01DF,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x00C4, 0x0304 },
  ["unicodeslot"]=0x01DE, -- Ǟ
 },
 {
  ["category"]="ll",
  ["contextname"]="adiaeresismacron",
  ["description"]="LATIN SMALL LETTER A WITH DIAERESIS AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x00E4, 0x0304 },
  ["uccode"]=0x01DE,
  ["unicodeslot"]=0x01DF, -- ǟ
 },
 {
  ["category"]="lu",
  ["contextname"]="Adotaccentmacron",
  ["description"]="LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON",
  ["lccode"]=0x01E1,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0226, 0x0304 },
  ["unicodeslot"]=0x01E0, -- Ǡ
 },
 {
  ["category"]="ll",
  ["contextname"]="adotaccentmacron",
  ["description"]="LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0227, 0x0304 },
  ["uccode"]=0x01E0,
  ["unicodeslot"]=0x01E1, -- ǡ
 },
 {
  ["category"]="lu",
  ["contextname"]="AEmacron",
  ["description"]="LATIN CAPITAL LETTER AE WITH MACRON",
  ["lccode"]=0x01E3,
  ["linebreak"]="al",
  ["shcode"]=0x00C6,
  ["specials"]={ "char", 0x00C6, 0x0304 },
  ["unicodeslot"]=0x01E2, -- Ǣ
 },
 {
  ["category"]="ll",
  ["contextname"]="aemacron",
  ["description"]="LATIN SMALL LETTER AE WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x00E6,
  ["specials"]={ "char", 0x00E6, 0x0304 },
  ["uccode"]=0x01E2,
  ["unicodeslot"]=0x01E3, -- ǣ
 },
 {
  ["category"]="lu",
  ["contextname"]="Gstroke",
  ["description"]="LATIN CAPITAL LETTER G WITH STROKE",
  ["lccode"]=0x01E5,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["unicodeslot"]=0x01E4, -- Ǥ
 },
 {
  ["category"]="ll",
  ["contextname"]="gstroke",
  ["description"]="LATIN SMALL LETTER G WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["uccode"]=0x01E4,
  ["unicodeslot"]=0x01E5, -- ǥ
 },
 {
  ["adobename"]="Gcaron",
  ["category"]="lu",
  ["contextname"]="Gcaron",
  ["description"]="LATIN CAPITAL LETTER G WITH CARON",
  ["lccode"]=0x01E7,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["specials"]={ "char", 0x0047, 0x030C },
  ["unicodeslot"]=0x01E6, -- Ǧ
 },
 {
  ["adobename"]="gcaron",
  ["category"]="ll",
  ["contextname"]="gcaron",
  ["description"]="LATIN SMALL LETTER G WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["specials"]={ "char", 0x0067, 0x030C },
  ["uccode"]=0x01E6,
  ["unicodeslot"]=0x01E7, -- ǧ
 },
 {
  ["category"]="lu",
  ["contextname"]="Kcaron",
  ["description"]="LATIN CAPITAL LETTER K WITH CARON",
  ["lccode"]=0x01E9,
  ["linebreak"]="al",
  ["shcode"]=0x004B,
  ["specials"]={ "char", 0x004B, 0x030C },
  ["unicodeslot"]=0x01E8, -- Ǩ
 },
 {
  ["category"]="ll",
  ["contextname"]="kcaron",
  ["description"]="LATIN SMALL LETTER K WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x006B,
  ["specials"]={ "char", 0x006B, 0x030C },
  ["uccode"]=0x01E8,
  ["unicodeslot"]=0x01E9, -- ǩ
 },
 {
  ["category"]="lu",
  ["contextname"]="Oogonek",
  ["description"]="LATIN CAPITAL LETTER O WITH OGONEK",
  ["lccode"]=0x01EB,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0328 },
  ["unicodeslot"]=0x01EA, -- Ǫ
 },
 {
  ["category"]="ll",
  ["contextname"]="oogonek",
  ["description"]="LATIN SMALL LETTER O WITH OGONEK",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0328 },
  ["uccode"]=0x01EA,
  ["unicodeslot"]=0x01EB, -- ǫ
 },
 {
  ["category"]="lu",
  ["contextname"]="Oogonekmacron",
  ["description"]="LATIN CAPITAL LETTER O WITH OGONEK AND MACRON",
  ["lccode"]=0x01ED,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x01EA, 0x0304 },
  ["unicodeslot"]=0x01EC, -- Ǭ
 },
 {
  ["category"]="ll",
  ["contextname"]="oogonekmacron",
  ["description"]="LATIN SMALL LETTER O WITH OGONEK AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x01EB, 0x0304 },
  ["uccode"]=0x01EC,
  ["unicodeslot"]=0x01ED, -- ǭ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER EZH WITH CARON",
  ["lccode"]=0x01EF,
  ["linebreak"]="al",
  ["shcode"]=0x01B7,
  ["specials"]={ "char", 0x01B7, 0x030C },
  ["unicodeslot"]=0x01EE, -- Ǯ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER EZH WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0292,
  ["specials"]={ "char", 0x0292, 0x030C },
  ["uccode"]=0x01EE,
  ["unicodeslot"]=0x01EF, -- ǯ
 },
 {
  ["category"]="ll",
  ["contextname"]="jcaron",
  ["description"]="LATIN SMALL LETTER J WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x006A,
  ["specials"]={ "char", 0x006A, 0x030C },
  ["unicodeslot"]=0x01F0, -- ǰ
 },
 {
  ["category"]="lu",
  ["contextname"]="DZligature",
  ["description"]="LATIN CAPITAL LETTER DZ",
  ["lccode"]=0x01F3,
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0044, 0x005A },
  ["uccode"]=0x01F2,
  ["unicodeslot"]=0x01F1, -- Ǳ
 },
 {
  ["category"]="lt",
  ["contextname"]="Dzligature",
  ["description"]="LATIN CAPITAL LETTER D WITH SMALL LETTER Z",
  ["lccode"]=0x01F3,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["specials"]={ "compat", 0x0044, 0x007A },
  ["uccode"]=0x01F1,
  ["unicodeslot"]=0x01F2, -- ǲ
 },
 {
  ["category"]="ll",
  ["contextname"]="dzligature",
  ["description"]="LATIN SMALL LETTER DZ",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0064, 0x007A },
  ["uccode"]=0x01F1,
  ["unicodeslot"]=0x01F3, -- ǳ
 },
 {
  ["category"]="lu",
  ["contextname"]="Gacute",
  ["description"]="LATIN CAPITAL LETTER G WITH ACUTE",
  ["lccode"]=0x01F5,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["specials"]={ "char", 0x0047, 0x0301 },
  ["unicodeslot"]=0x01F4, -- Ǵ
 },
 {
  ["category"]="ll",
  ["contextname"]="gacute",
  ["description"]="LATIN SMALL LETTER G WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["specials"]={ "char", 0x0067, 0x0301 },
  ["uccode"]=0x01F4,
  ["unicodeslot"]=0x01F5, -- ǵ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER HWAIR",
  ["lccode"]=0x0195,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01F6, -- Ƕ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER WYNN",
  ["lccode"]=0x01BF,
  ["linebreak"]="al",
  ["unicodeslot"]=0x01F7, -- Ƿ
 },
 {
  ["category"]="lu",
  ["contextname"]="Ngrave",
  ["description"]="LATIN CAPITAL LETTER N WITH GRAVE",
  ["lccode"]=0x01F9,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x0300 },
  ["unicodeslot"]=0x01F8, -- Ǹ
 },
 {
  ["category"]="ll",
  ["contextname"]="ngrave",
  ["description"]="LATIN SMALL LETTER N WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x0300 },
  ["uccode"]=0x01F8,
  ["unicodeslot"]=0x01F9, -- ǹ
 },
 {
  ["adobename"]="Aringacute",
  ["category"]="lu",
  ["contextname"]="Aringacute",
  ["description"]="LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE",
  ["lccode"]=0x01FB,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x00C5, 0x0301 },
  ["unicodeslot"]=0x01FA, -- Ǻ
 },
 {
  ["adobename"]="aringacute",
  ["category"]="ll",
  ["contextname"]="aringacute",
  ["description"]="LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x00E5, 0x0301 },
  ["uccode"]=0x01FA,
  ["unicodeslot"]=0x01FB, -- ǻ
 },
 {
  ["adobename"]="AEacute",
  ["category"]="lu",
  ["contextname"]="AEacute",
  ["description"]="LATIN CAPITAL LETTER AE WITH ACUTE",
  ["lccode"]=0x01FD,
  ["linebreak"]="al",
  ["shcode"]=0x00C6,
  ["specials"]={ "char", 0x00C6, 0x0301 },
  ["unicodeslot"]=0x01FC, -- Ǽ
 },
 {
  ["adobename"]="aeacute",
  ["category"]="ll",
  ["contextname"]="aeacute",
  ["description"]="LATIN SMALL LETTER AE WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x00E6,
  ["specials"]={ "char", 0x00E6, 0x0301 },
  ["uccode"]=0x01FC,
  ["unicodeslot"]=0x01FD, -- ǽ
 },
 {
  ["adobename"]="Oslashacute",
  ["category"]="lu",
  ["contextname"]="Ostrokeacute",
  ["description"]="LATIN CAPITAL LETTER O WITH STROKE AND ACUTE",
  ["lccode"]=0x01FF,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D8, 0x0301 },
  ["unicodeslot"]=0x01FE, -- Ǿ
 },
 {
  ["adobename"]="oslashacute",
  ["category"]="ll",
  ["contextname"]="ostrokeacute",
  ["description"]="LATIN SMALL LETTER O WITH STROKE AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F8, 0x0301 },
  ["uccode"]=0x01FE,
  ["unicodeslot"]=0x01FF, -- ǿ
 },
 {
  ["category"]="lu",
  ["contextname"]="Adoublegrave",
  ["description"]="LATIN CAPITAL LETTER A WITH DOUBLE GRAVE",
  ["lccode"]=0x0201,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x030F },
  ["unicodeslot"]=0x0200, -- Ȁ
 },
 {
  ["category"]="ll",
  ["contextname"]="adoublegrave",
  ["description"]="LATIN SMALL LETTER A WITH DOUBLE GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x030F },
  ["uccode"]=0x0200,
  ["unicodeslot"]=0x0201, -- ȁ
 },
 {
  ["category"]="lu",
  ["contextname"]="Ainvertedbreve",
  ["description"]="LATIN CAPITAL LETTER A WITH INVERTED BREVE",
  ["lccode"]=0x0203,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0311 },
  ["unicodeslot"]=0x0202, -- Ȃ
 },
 {
  ["category"]="ll",
  ["contextname"]="ainvertedbreve",
  ["description"]="LATIN SMALL LETTER A WITH INVERTED BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0311 },
  ["uccode"]=0x0202,
  ["unicodeslot"]=0x0203, -- ȃ
 },
 {
  ["category"]="lu",
  ["contextname"]="Edoublegrave",
  ["description"]="LATIN CAPITAL LETTER E WITH DOUBLE GRAVE",
  ["lccode"]=0x0205,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x030F },
  ["unicodeslot"]=0x0204, -- Ȅ
 },
 {
  ["category"]="ll",
  ["contextname"]="edoublegrave",
  ["description"]="LATIN SMALL LETTER E WITH DOUBLE GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x030F },
  ["uccode"]=0x0204,
  ["unicodeslot"]=0x0205, -- ȅ
 },
 {
  ["category"]="lu",
  ["contextname"]="Einvertedbreve",
  ["description"]="LATIN CAPITAL LETTER E WITH INVERTED BREVE",
  ["lccode"]=0x0207,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0311 },
  ["unicodeslot"]=0x0206, -- Ȇ
 },
 {
  ["category"]="ll",
  ["contextname"]="einvertedbreve",
  ["description"]="LATIN SMALL LETTER E WITH INVERTED BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0311 },
  ["uccode"]=0x0206,
  ["unicodeslot"]=0x0207, -- ȇ
 },
 {
  ["category"]="lu",
  ["contextname"]="Idoublegrave",
  ["description"]="LATIN CAPITAL LETTER I WITH DOUBLE GRAVE",
  ["lccode"]=0x0209,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x030F },
  ["unicodeslot"]=0x0208, -- Ȉ
 },
 {
  ["category"]="ll",
  ["contextname"]="idoublegrave",
  ["description"]="LATIN SMALL LETTER I WITH DOUBLE GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x030F },
  ["uccode"]=0x0208,
  ["unicodeslot"]=0x0209, -- ȉ
 },
 {
  ["category"]="lu",
  ["contextname"]="Iinvertedbreve",
  ["description"]="LATIN CAPITAL LETTER I WITH INVERTED BREVE",
  ["lccode"]=0x020B,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0311 },
  ["unicodeslot"]=0x020A, -- Ȋ
 },
 {
  ["category"]="ll",
  ["contextname"]="iinvertedbreve",
  ["description"]="LATIN SMALL LETTER I WITH INVERTED BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0311 },
  ["uccode"]=0x020A,
  ["unicodeslot"]=0x020B, -- ȋ
 },
 {
  ["category"]="lu",
  ["contextname"]="Odoublegrave",
  ["description"]="LATIN CAPITAL LETTER O WITH DOUBLE GRAVE",
  ["lccode"]=0x020D,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x030F },
  ["unicodeslot"]=0x020C, -- Ȍ
 },
 {
  ["category"]="ll",
  ["contextname"]="odoublegrave",
  ["description"]="LATIN SMALL LETTER O WITH DOUBLE GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x030F },
  ["uccode"]=0x020C,
  ["unicodeslot"]=0x020D, -- ȍ
 },
 {
  ["category"]="lu",
  ["contextname"]="Oinvertedbreve",
  ["description"]="LATIN CAPITAL LETTER O WITH INVERTED BREVE",
  ["lccode"]=0x020F,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0311 },
  ["unicodeslot"]=0x020E, -- Ȏ
 },
 {
  ["category"]="ll",
  ["contextname"]="oinvertedbreve",
  ["description"]="LATIN SMALL LETTER O WITH INVERTED BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0311 },
  ["uccode"]=0x020E,
  ["unicodeslot"]=0x020F, -- ȏ
 },
 {
  ["category"]="lu",
  ["contextname"]="Rdoublegrave",
  ["description"]="LATIN CAPITAL LETTER R WITH DOUBLE GRAVE",
  ["lccode"]=0x0211,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x030F },
  ["unicodeslot"]=0x0210, -- Ȑ
 },
 {
  ["category"]="ll",
  ["contextname"]="rdoublegrave",
  ["description"]="LATIN SMALL LETTER R WITH DOUBLE GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x030F },
  ["uccode"]=0x0210,
  ["unicodeslot"]=0x0211, -- ȑ
 },
 {
  ["category"]="lu",
  ["contextname"]="Rinvertedbreve",
  ["description"]="LATIN CAPITAL LETTER R WITH INVERTED BREVE",
  ["lccode"]=0x0213,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x0311 },
  ["unicodeslot"]=0x0212, -- Ȓ
 },
 {
  ["category"]="ll",
  ["contextname"]="rinvertedbreve",
  ["description"]="LATIN SMALL LETTER R WITH INVERTED BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x0311 },
  ["uccode"]=0x0212,
  ["unicodeslot"]=0x0213, -- ȓ
 },
 {
  ["category"]="lu",
  ["contextname"]="Udoublegrave",
  ["description"]="LATIN CAPITAL LETTER U WITH DOUBLE GRAVE",
  ["lccode"]=0x0215,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x030F },
  ["unicodeslot"]=0x0214, -- Ȕ
 },
 {
  ["category"]="ll",
  ["contextname"]="udoublegrave",
  ["description"]="LATIN SMALL LETTER U WITH DOUBLE GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x030F },
  ["uccode"]=0x0214,
  ["unicodeslot"]=0x0215, -- ȕ
 },
 {
  ["category"]="lu",
  ["contextname"]="Uinvertedbreve",
  ["description"]="LATIN CAPITAL LETTER U WITH INVERTED BREVE",
  ["lccode"]=0x0217,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0311 },
  ["unicodeslot"]=0x0216, -- Ȗ
 },
 {
  ["category"]="ll",
  ["contextname"]="uinvertedbreve",
  ["description"]="LATIN SMALL LETTER U WITH INVERTED BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0311 },
  ["uccode"]=0x0216,
  ["unicodeslot"]=0x0217, -- ȗ
 },
 {
  ["adobename"]="Scommaaccent",
  ["category"]="lu",
  ["contextname"]="Scommaaccent",
  ["description"]="LATIN CAPITAL LETTER S WITH COMMA BELOW",
  ["lccode"]=0x0219,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0053, 0x0326 },
  ["unicodeslot"]=0x0218, -- Ș
 },
 {
  ["adobename"]="scommaaccent",
  ["category"]="ll",
  ["contextname"]="scommaaccent",
  ["description"]="LATIN SMALL LETTER S WITH COMMA BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0073, 0x0326 },
  ["uccode"]=0x0218,
  ["unicodeslot"]=0x0219, -- ș
 },
 {
  ["category"]="lu",
  ["contextname"]="Tcommaaccent",
  ["description"]="LATIN CAPITAL LETTER T WITH COMMA BELOW",
  ["lccode"]=0x021B,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["specials"]={ "char", 0x0054, 0x0326 },
  ["unicodeslot"]=0x021A, -- Ț
 },
 {
  ["category"]="ll",
  ["contextname"]="tcommaaccent",
  ["description"]="LATIN SMALL LETTER T WITH COMMA BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x0326 },
  ["uccode"]=0x021A,
  ["unicodeslot"]=0x021B, -- ț
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER YOGH",
  ["lccode"]=0x021D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x021C, -- Ȝ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER YOGH",
  ["linebreak"]="al",
  ["uccode"]=0x021C,
  ["unicodeslot"]=0x021D, -- ȝ
 },
 {
  ["category"]="lu",
  ["contextname"]="Hcaron",
  ["description"]="LATIN CAPITAL LETTER H WITH CARON",
  ["lccode"]=0x021F,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["specials"]={ "char", 0x0048, 0x030C },
  ["unicodeslot"]=0x021E, -- Ȟ
 },
 {
  ["category"]="ll",
  ["contextname"]="hcaron",
  ["description"]="LATIN SMALL LETTER H WITH CARON",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x030C },
  ["uccode"]=0x021E,
  ["unicodeslot"]=0x021F, -- ȟ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER N WITH LONG RIGHT LEG",
  ["lccode"]=0x019E,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["unicodeslot"]=0x0220, -- Ƞ
 },
 {
  ["category"]="ll",
  ["contextname"]="dcurl",
  ["description"]="LATIN SMALL LETTER D WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["unicodeslot"]=0x0221, -- ȡ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER OU",
  ["lccode"]=0x0223,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0222, -- Ȣ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER OU",
  ["linebreak"]="al",
  ["uccode"]=0x0222,
  ["unicodeslot"]=0x0223, -- ȣ
 },
 {
  ["category"]="lu",
  ["contextname"]="Zhook",
  ["description"]="LATIN CAPITAL LETTER Z WITH HOOK",
  ["lccode"]=0x0225,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["unicodeslot"]=0x0224, -- Ȥ
 },
 {
  ["category"]="ll",
  ["contextname"]="zhook",
  ["description"]="LATIN SMALL LETTER Z WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["uccode"]=0x0224,
  ["unicodeslot"]=0x0225, -- ȥ
 },
 {
  ["category"]="lu",
  ["contextname"]="Adotaccent",
  ["description"]="LATIN CAPITAL LETTER A WITH DOT ABOVE",
  ["lccode"]=0x0227,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0307 },
  ["unicodeslot"]=0x0226, -- Ȧ
 },
 {
  ["category"]="ll",
  ["contextname"]="adotaccent",
  ["description"]="LATIN SMALL LETTER A WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0307 },
  ["uccode"]=0x0226,
  ["unicodeslot"]=0x0227, -- ȧ
 },
 {
  ["category"]="lu",
  ["contextname"]="Ecedilla",
  ["description"]="LATIN CAPITAL LETTER E WITH CEDILLA",
  ["lccode"]=0x0229,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0327 },
  ["unicodeslot"]=0x0228, -- Ȩ
 },
 {
  ["category"]="ll",
  ["contextname"]="ecedilla",
  ["description"]="LATIN SMALL LETTER E WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0327 },
  ["uccode"]=0x0228,
  ["unicodeslot"]=0x0229, -- ȩ
 },
 {
  ["category"]="lu",
  ["contextname"]="Odiaeresismacron",
  ["description"]="LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON",
  ["lccode"]=0x022B,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D6, 0x0304 },
  ["unicodeslot"]=0x022A, -- Ȫ
 },
 {
  ["category"]="ll",
  ["contextname"]="odiaeresismacron",
  ["description"]="LATIN SMALL LETTER O WITH DIAERESIS AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F6, 0x0304 },
  ["uccode"]=0x022A,
  ["unicodeslot"]=0x022B, -- ȫ
 },
 {
  ["category"]="lu",
  ["contextname"]="Otildemacron",
  ["description"]="LATIN CAPITAL LETTER O WITH TILDE AND MACRON",
  ["lccode"]=0x022D,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D5, 0x0304 },
  ["unicodeslot"]=0x022C, -- Ȭ
 },
 {
  ["category"]="ll",
  ["contextname"]="otildemacron",
  ["description"]="LATIN SMALL LETTER O WITH TILDE AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F5, 0x0304 },
  ["uccode"]=0x022C,
  ["unicodeslot"]=0x022D, -- ȭ
 },
 {
  ["category"]="lu",
  ["contextname"]="Odotaccent",
  ["description"]="LATIN CAPITAL LETTER O WITH DOT ABOVE",
  ["lccode"]=0x022F,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0307 },
  ["unicodeslot"]=0x022E, -- Ȯ
 },
 {
  ["category"]="ll",
  ["contextname"]="odotaccent",
  ["description"]="LATIN SMALL LETTER O WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0307 },
  ["uccode"]=0x022E,
  ["unicodeslot"]=0x022F, -- ȯ
 },
 {
  ["category"]="lu",
  ["contextname"]="Odotaccentmacron",
  ["description"]="LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON",
  ["lccode"]=0x0231,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x022E, 0x0304 },
  ["unicodeslot"]=0x0230, -- Ȱ
 },
 {
  ["category"]="ll",
  ["contextname"]="odotaccentmacron",
  ["description"]="LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x022F, 0x0304 },
  ["uccode"]=0x0230,
  ["unicodeslot"]=0x0231, -- ȱ
 },
 {
  ["category"]="lu",
  ["contextname"]="Ymacron",
  ["description"]="LATIN CAPITAL LETTER Y WITH MACRON",
  ["lccode"]=0x0233,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0304 },
  ["unicodeslot"]=0x0232, -- Ȳ
 },
 {
  ["category"]="ll",
  ["contextname"]="ymacron",
  ["description"]="LATIN SMALL LETTER Y WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0304 },
  ["uccode"]=0x0232,
  ["unicodeslot"]=0x0233, -- ȳ
 },
 {
  ["category"]="ll",
  ["contextname"]="lcurl",
  ["description"]="LATIN SMALL LETTER L WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["unicodeslot"]=0x0234, -- ȴ
 },
 {
  ["category"]="ll",
  ["contextname"]="ncurl",
  ["description"]="LATIN SMALL LETTER N WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["unicodeslot"]=0x0235, -- ȵ
 },
 {
  ["category"]="ll",
  ["contextname"]="tcurl",
  ["description"]="LATIN SMALL LETTER T WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["unicodeslot"]=0x0236, -- ȶ
 },
 {
  ["category"]="ll",
  ["contextname"]="dotlessj",
  ["description"]="LATIN SMALL LETTER DOTLESS J",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0237, -- ȷ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER DB DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0238, -- ȸ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER QP DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0239, -- ȹ
 },
 {
  ["category"]="lu",
  ["contextname"]="Astroke",
  ["description"]="LATIN CAPITAL LETTER A WITH STROKE",
  ["lccode"]=0x2C65,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["unicodeslot"]=0x023A, -- Ⱥ
 },
 {
  ["category"]="lu",
  ["contextname"]="Cstroke",
  ["description"]="LATIN CAPITAL LETTER C WITH STROKE",
  ["lccode"]=0x023C,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["unicodeslot"]=0x023B, -- Ȼ
 },
 {
  ["category"]="ll",
  ["contextname"]="cstroke",
  ["description"]="LATIN SMALL LETTER C WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["uccode"]=0x023B,
  ["unicodeslot"]=0x023C, -- ȼ
 },
 {
  ["category"]="lu",
  ["contextname"]="Lbar",
  ["description"]="LATIN CAPITAL LETTER L WITH BAR",
  ["lccode"]=0x019A,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["unicodeslot"]=0x023D, -- Ƚ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER T WITH DIAGONAL STROKE",
  ["lccode"]=0x2C66,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["unicodeslot"]=0x023E, -- Ⱦ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH SWASH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["unicodeslot"]=0x023F, -- ȿ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH SWASH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["unicodeslot"]=0x0240, -- ɀ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER GLOTTAL STOP",
  ["lccode"]=0x0242,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0241, -- Ɂ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER GLOTTAL STOP",
  ["linebreak"]="al",
  ["uccode"]=0x0241,
  ["unicodeslot"]=0x0242, -- ɂ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER B WITH STROKE",
  ["lccode"]=0x0180,
  ["linebreak"]="al",
  ["shcode"]=0x0042,
  ["unicodeslot"]=0x0243, -- Ƀ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER U BAR",
  ["lccode"]=0x0289,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0244, -- Ʉ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER TURNED V",
  ["lccode"]=0x028C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0245, -- Ʌ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER E WITH STROKE",
  ["lccode"]=0x0247,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["unicodeslot"]=0x0246, -- Ɇ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER E WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["uccode"]=0x0246,
  ["unicodeslot"]=0x0247, -- ɇ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER J WITH STROKE",
  ["lccode"]=0x0249,
  ["linebreak"]="al",
  ["shcode"]=0x004A,
  ["unicodeslot"]=0x0248, -- Ɉ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER J WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x006A,
  ["uccode"]=0x0248,
  ["unicodeslot"]=0x0249, -- ɉ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL",
  ["lccode"]=0x024B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x024A, -- Ɋ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Q WITH HOOK TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x0071,
  ["uccode"]=0x024A,
  ["unicodeslot"]=0x024B, -- ɋ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER R WITH STROKE",
  ["lccode"]=0x024D,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["unicodeslot"]=0x024C, -- Ɍ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["uccode"]=0x024C,
  ["unicodeslot"]=0x024D, -- ɍ
 },
 {
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER Y WITH STROKE",
  ["lccode"]=0x024F,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["unicodeslot"]=0x024E, -- Ɏ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Y WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["uccode"]=0x024E,
  ["unicodeslot"]=0x024F, -- ɏ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0250, -- ɐ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["description"]="LATIN SMALL LETTER ALPHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0251, -- ɑ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED ALPHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0252, -- ɒ
 },
 {
  ["category"]="ll",
  ["contextname"]="bhook",
  ["description"]="LATIN SMALL LETTER B WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["uccode"]=0x0181,
  ["unicodeslot"]=0x0253, -- ɓ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER OPEN O",
  ["linebreak"]="al",
  ["uccode"]=0x0186,
  ["unicodeslot"]=0x0254, -- ɔ
 },
 {
  ["category"]="ll",
  ["contextname"]="ccurl",
  ["description"]="LATIN SMALL LETTER C WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["unicodeslot"]=0x0255, -- ɕ
 },
 {
  ["category"]="ll",
  ["contextname"]="dtail",
  ["description"]="LATIN SMALL LETTER D WITH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["uccode"]=0x0189,
  ["unicodeslot"]=0x0256, -- ɖ
 },
 {
  ["category"]="ll",
  ["contextname"]="dhook",
  ["description"]="LATIN SMALL LETTER D WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["uccode"]=0x018A,
  ["unicodeslot"]=0x0257, -- ɗ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER REVERSED E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0258, -- ɘ
 },
 {
  ["category"]="ll",
  ["contextname"]="schwa",
  ["description"]="LATIN SMALL LETTER SCHWA",
  ["linebreak"]="al",
  ["uccode"]=0x018F,
  ["unicodeslot"]=0x0259, -- ə
 },
 {
  ["category"]="ll",
  ["contextname"]="schwahook",
  ["description"]="LATIN SMALL LETTER SCHWA WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0259,
  ["unicodeslot"]=0x025A, -- ɚ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER OPEN E",
  ["linebreak"]="al",
  ["uccode"]=0x0190,
  ["unicodeslot"]=0x025B, -- ɛ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER REVERSED OPEN E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x025C, -- ɜ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER REVERSED OPEN E WITH HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x025D, -- ɝ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER CLOSED REVERSED OPEN E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x025E, -- ɞ
 },
 {
  ["category"]="ll",
  ["contextname"]="dotlessjstroke",
  ["description"]="LATIN SMALL LETTER DOTLESS J WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x025F, -- ɟ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER G WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["uccode"]=0x0193,
  ["unicodeslot"]=0x0260, -- ɠ
 },
 {
  ["category"]="ll",
  ["cjkwd"]="a",
  ["description"]="LATIN SMALL LETTER SCRIPT G",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0261, -- ɡ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL G",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0262, -- ɢ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER GAMMA",
  ["linebreak"]="al",
  ["uccode"]=0x0194,
  ["unicodeslot"]=0x0263, -- ɣ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER RAMS HORN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0264, -- ɤ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0265, -- ɥ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER H WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["unicodeslot"]=0x0266, -- ɦ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER HENG WITH HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0267, -- ɧ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER I WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["uccode"]=0x0197,
  ["unicodeslot"]=0x0268, -- ɨ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER IOTA",
  ["linebreak"]="al",
  ["uccode"]=0x0196,
  ["unicodeslot"]=0x0269, -- ɩ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x026A, -- ɪ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["uccode"]=0x2C62,
  ["unicodeslot"]=0x026B, -- ɫ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH BELT",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["unicodeslot"]=0x026C, -- ɬ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["unicodeslot"]=0x026D, -- ɭ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER LEZH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x026E, -- ɮ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED M",
  ["linebreak"]="al",
  ["uccode"]=0x019C,
  ["unicodeslot"]=0x026F, -- ɯ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED M WITH LONG LEG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0270, -- ɰ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER M WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006D,
  ["unicodeslot"]=0x0271, -- ɱ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH LEFT HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["uccode"]=0x019D,
  ["unicodeslot"]=0x0272, -- ɲ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["unicodeslot"]=0x0273, -- ɳ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0274, -- ɴ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER BARRED O",
  ["linebreak"]="al",
  ["uccode"]=0x019F,
  ["unicodeslot"]=0x0275, -- ɵ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL OE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0276, -- ɶ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER CLOSED OMEGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0277, -- ɷ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER PHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0278, -- ɸ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0279, -- ɹ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED R WITH LONG LEG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x027A, -- ɺ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED R WITH HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x027B, -- ɻ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH LONG LEG",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["unicodeslot"]=0x027C, -- ɼ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["uccode"]=0x2C64,
  ["unicodeslot"]=0x027D, -- ɽ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH FISHHOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["unicodeslot"]=0x027E, -- ɾ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER REVERSED R WITH FISHHOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x027F, -- ɿ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL R",
  ["linebreak"]="al",
  ["uccode"]=0x01A6,
  ["unicodeslot"]=0x0280, -- ʀ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL INVERTED R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0281, -- ʁ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["unicodeslot"]=0x0282, -- ʂ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER ESH",
  ["linebreak"]="al",
  ["uccode"]=0x01A9,
  ["unicodeslot"]=0x0283, -- ʃ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0284, -- ʄ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SQUAT REVERSED ESH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0285, -- ʅ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER ESH WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x0283,
  ["unicodeslot"]=0x0286, -- ʆ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED T",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0287, -- ʇ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["uccode"]=0x01AE,
  ["unicodeslot"]=0x0288, -- ʈ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER U BAR",
  ["linebreak"]="al",
  ["uccode"]=0x0244,
  ["unicodeslot"]=0x0289, -- ʉ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER UPSILON",
  ["linebreak"]="al",
  ["uccode"]=0x01B1,
  ["unicodeslot"]=0x028A, -- ʊ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER V WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0076,
  ["uccode"]=0x01B2,
  ["unicodeslot"]=0x028B, -- ʋ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED V",
  ["linebreak"]="al",
  ["uccode"]=0x0245,
  ["unicodeslot"]=0x028C, -- ʌ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED W",
  ["linebreak"]="al",
  ["unicodeslot"]=0x028D, -- ʍ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED Y",
  ["linebreak"]="al",
  ["unicodeslot"]=0x028E, -- ʎ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL Y",
  ["linebreak"]="al",
  ["unicodeslot"]=0x028F, -- ʏ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["unicodeslot"]=0x0290, -- ʐ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["unicodeslot"]=0x0291, -- ʑ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER EZH",
  ["linebreak"]="al",
  ["uccode"]=0x01B7,
  ["unicodeslot"]=0x0292, -- ʒ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER EZH WITH CURL",
  ["linebreak"]="al",
  ["shcode"]=0x0292,
  ["unicodeslot"]=0x0293, -- ʓ
 },
 {
  ["category"]="lo",
  ["description"]="LATIN LETTER GLOTTAL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0294, -- ʔ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER PHARYNGEAL VOICED FRICATIVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0295, -- ʕ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER INVERTED GLOTTAL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0296, -- ʖ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER STRETCHED C",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0297, -- ʗ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER BILABIAL CLICK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0298, -- ʘ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL B",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0299, -- ʙ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER CLOSED OPEN E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x029A, -- ʚ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL G WITH HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x029B, -- ʛ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x029C, -- ʜ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER J WITH CROSSED-TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x006A,
  ["unicodeslot"]=0x029D, -- ʝ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED K",
  ["linebreak"]="al",
  ["unicodeslot"]=0x029E, -- ʞ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x029F, -- ʟ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Q WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0071,
  ["unicodeslot"]=0x02A0, -- ʠ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER GLOTTAL STOP WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A1, -- ʡ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A2, -- ʢ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER DZ DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A3, -- ʣ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER DEZH DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A4, -- ʤ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER DZ DIGRAPH WITH CURL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A5, -- ʥ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TS DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A6, -- ʦ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TESH DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A7, -- ʧ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TC DIGRAPH WITH CURL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A8, -- ʨ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER FENG DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02A9, -- ʩ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER LS DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02AA, -- ʪ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER LZ DIGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02AB, -- ʫ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER BILABIAL PERCUSSIVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02AC, -- ʬ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN LETTER BIDENTAL PERCUSSIVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02AD, -- ʭ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED H WITH FISHHOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02AE, -- ʮ
 },
 {
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02AF, -- ʯ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL H",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0068 },
  ["unicodeslot"]=0x02B0, -- ʰ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL H WITH HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0266 },
  ["unicodeslot"]=0x02B1, -- ʱ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL J",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x006A },
  ["unicodeslot"]=0x02B2, -- ʲ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL R",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0072 },
  ["unicodeslot"]=0x02B3, -- ʳ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED R",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0279 },
  ["unicodeslot"]=0x02B4, -- ʴ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED R WITH HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x027B },
  ["unicodeslot"]=0x02B5, -- ʵ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL CAPITAL INVERTED R",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0281 },
  ["unicodeslot"]=0x02B6, -- ʶ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL W",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0077 },
  ["unicodeslot"]=0x02B7, -- ʷ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL Y",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0079 },
  ["unicodeslot"]=0x02B8, -- ʸ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER PRIME",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02B9, -- ʹ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER DOUBLE PRIME",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02BA, -- ʺ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER TURNED COMMA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02BB, -- ʻ
 },
 {
  ["adobename"]="afii57929",
  ["category"]="lm",
  ["description"]="MODIFIER LETTER APOSTROPHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02BC, -- ʼ
 },
 {
  ["adobename"]="afii64937",
  ["category"]="lm",
  ["description"]="MODIFIER LETTER REVERSED COMMA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02BD, -- ʽ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER RIGHT HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02BE, -- ʾ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER LEFT HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02BF, -- ʿ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER GLOTTAL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02C0, -- ˀ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER REVERSED GLOTTAL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02C1, -- ˁ
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LEFT ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02C2, -- ˂
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER RIGHT ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02C3, -- ˃
 },
 {
  ["category"]="sk",
  ["cjkwd"]="a",
  ["description"]="MODIFIER LETTER UP ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02C4, -- ˄
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER DOWN ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02C5, -- ˅
 },
 {
  ["adobename"]="circumflex",
  ["category"]="lm",
  ["contextname"]="textcircumflex",
  ["description"]="MODIFIER LETTER CIRCUMFLEX ACCENT",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0302 }, -- added by hh
  ["unicodeslot"]=0x02C6, -- ˆ
 },
 {
  ["adobename"]="caron",
  ["category"]="lm",
  ["cjkwd"]="a",
  ["contextname"]="textcaron",
  ["description"]="CARON",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x030C }, -- added by hh
  ["unicodeslot"]=0x02C7, -- ˇ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER VERTICAL LINE",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x02C8, -- ˈ
 },
 {
  ["category"]="lm",
  ["cjkwd"]="a",
  ["description"]="MODIFIER LETTER MACRON",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x02C9, -- ˉ
 },
 {
  ["category"]="lm",
  ["cjkwd"]="a",
  ["description"]="MODIFIER LETTER ACUTE ACCENT",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x02CA, -- ˊ
 },
 {
  ["category"]="lm",
  ["cjkwd"]="a",
  ["description"]="MODIFIER LETTER GRAVE ACCENT",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x02CB, -- ˋ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER LOW VERTICAL LINE",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x02CC, -- ˌ
 },
 {
  ["category"]="lm",
  ["cjkwd"]="a",
  ["description"]="MODIFIER LETTER LOW MACRON",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x02CD, -- ˍ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER LOW GRAVE ACCENT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02CE, -- ˎ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER LOW ACUTE ACCENT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02CF, -- ˏ
 },
 {
  ["category"]="lm",
  ["cjkwd"]="a",
  ["description"]="MODIFIER LETTER TRIANGULAR COLON",
  ["linebreak"]="ai",
  ["unicodeslot"]=0x02D0, -- ː
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER HALF TRIANGULAR COLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02D1, -- ˑ
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER CENTRED RIGHT HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02D2, -- ˒
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER CENTRED LEFT HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02D3, -- ˓
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER UP TACK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02D4, -- ˔
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER DOWN TACK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02D5, -- ˕
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER PLUS SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02D6, -- ˖
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER MINUS SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02D7, -- ˗
 },
 {
  ["adobename"]="breve",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="textbreve",
  ["description"]="BREVE",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x0306 },
  ["unicodeslot"]=0x02D8, -- ˘
 },
 {
  ["adobename"]="dotaccent",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="textdotaccent",
  ["description"]="DOT ABOVE",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x0307 },
  ["unicodeslot"]=0x02D9, -- ˙
 },
 {
  ["adobename"]="ring",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="textring",
  ["description"]="RING ABOVE",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x030A },
  ["unicodeslot"]=0x02DA, -- ˚
 },
 {
  ["adobename"]="ogonek",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="textogonek",
  ["description"]="OGONEK",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x0328 },
  ["unicodeslot"]=0x02DB, -- ˛
 },
 {
  ["adobename"]="tilde",
  ["category"]="sk",
  ["contextname"]="texttilde",
  ["description"]="SMALL TILDE",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0303 },
  ["unicodeslot"]=0x02DC, -- ˜
 },
 {
  ["adobename"]="hungarumlaut",
  ["category"]="sk",
  ["cjkwd"]="a",
  ["contextname"]="texthungarumlaut",
  ["description"]="DOUBLE ACUTE ACCENT",
  ["linebreak"]="ai",
  ["specials"]={ "compat", 0x0020, 0x030B },
  ["unicodeslot"]=0x02DD, -- ˝
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER RHOTIC HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02DE, -- ˞
 },
 {
  ["category"]="sk",
  ["cjkwd"]="a",
  ["description"]="MODIFIER LETTER CROSS ACCENT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02DF, -- ˟
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL GAMMA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0263 },
  ["unicodeslot"]=0x02E0, -- ˠ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL L",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x006C },
  ["unicodeslot"]=0x02E1, -- ˡ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL S",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0073 },
  ["unicodeslot"]=0x02E2, -- ˢ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL X",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0078 },
  ["unicodeslot"]=0x02E3, -- ˣ
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL REVERSED GLOTTAL STOP",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0295 },
  ["unicodeslot"]=0x02E4, -- ˤ
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER EXTRA-HIGH TONE BAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02E5, -- ˥
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER HIGH TONE BAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02E6, -- ˦
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER MID TONE BAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02E7, -- ˧
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW TONE BAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02E8, -- ˨
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER EXTRA-LOW TONE BAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02E9, -- ˩
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER YIN DEPARTING TONE MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02EA, -- ˪
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER YANG DEPARTING TONE MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02EB, -- ˫
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER VOICING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02EC, -- ˬ
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER UNASPIRATED",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02ED, -- ˭
 },
 {
  ["category"]="lm",
  ["description"]="MODIFIER LETTER DOUBLE APOSTROPHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02EE, -- ˮ
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW DOWN ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02EF, -- ˯
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW UP ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F0, -- ˰
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW LEFT ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F1, -- ˱
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW RIGHT ARROWHEAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F2, -- ˲
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F3, -- ˳
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER MIDDLE GRAVE ACCENT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F4, -- ˴
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F5, -- ˵
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F6, -- ˶
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW TILDE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F7, -- ˷
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER RAISED COLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F8, -- ˸
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER BEGIN HIGH TONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02F9, -- ˹
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER END HIGH TONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02FA, -- ˺
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER BEGIN LOW TONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02FB, -- ˻
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER END LOW TONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02FC, -- ˼
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER SHELF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02FD, -- ˽
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER OPEN SHELF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02FE, -- ˾
 },
 {
  ["category"]="sk",
  ["description"]="MODIFIER LETTER LOW LEFT ARROW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x02FF, -- ˿
 },
 {
  ["adobename"]="gravecomb",
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GRAVE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0300, -- ̀
 },
 {
  ["adobename"]="acutecomb",
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING ACUTE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0301, -- ́
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING CIRCUMFLEX ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0302, -- ̂
 },
 {
  ["adobename"]="tildecomb",
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING TILDE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0303, -- ̃
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING MACRON",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0304, -- ̄
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING OVERLINE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0305, -- ̅
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING BREVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0306, -- ̆
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOT ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0307, -- ̇
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DIAERESIS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0308, -- ̈
 },
 {
  ["adobename"]="hookabovecomb",
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING HOOK ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0309, -- ̉
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RING ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x030A, -- ̊
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE ACUTE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x030B, -- ̋
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING CARON",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x030C, -- ̌
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING VERTICAL LINE ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x030D, -- ̍
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE VERTICAL LINE ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x030E, -- ̎
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE GRAVE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x030F, -- ̏
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING CANDRABINDU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0310, -- ̐
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING INVERTED BREVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0311, -- ̑
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING TURNED COMMA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0312, -- ̒
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING COMMA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0313, -- ̓
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING REVERSED COMMA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0314, -- ̔
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING COMMA ABOVE RIGHT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0315, -- ̕
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GRAVE ACCENT BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0316, -- ̖
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING ACUTE ACCENT BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0317, -- ̗
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LEFT TACK BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0318, -- ̘
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RIGHT TACK BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0319, -- ̙
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LEFT ANGLE ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x031A, -- ̚
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING HORN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x031B, -- ̛
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LEFT HALF RING BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x031C, -- ̜
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING UP TACK BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x031D, -- ̝
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOWN TACK BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x031E, -- ̞
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING PLUS SIGN BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x031F, -- ̟
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING MINUS SIGN BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0320, -- ̠
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING PALATALIZED HOOK BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0321, -- ̡
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RETROFLEX HOOK BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0322, -- ̢
 },
 {
  ["adobename"]="dotbelowcomb",
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOT BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0323, -- ̣
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DIAERESIS BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0324, -- ̤
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RING BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0325, -- ̥
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING COMMA BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0326, -- ̦
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING CEDILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0327, -- ̧
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING OGONEK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0328, -- ̨
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING VERTICAL LINE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0329, -- ̩
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING BRIDGE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x032A, -- ̪
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING INVERTED DOUBLE ARCH BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x032B, -- ̫
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING CARON BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x032C, -- ̬
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING CIRCUMFLEX ACCENT BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x032D, -- ̭
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING BREVE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x032E, -- ̮
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING INVERTED BREVE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x032F, -- ̯
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING TILDE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0330, -- ̰
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING MACRON BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0331, -- ̱
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LOW LINE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0332, -- ̲
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE LOW LINE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0333, -- ̳
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING TILDE OVERLAY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0334, -- ̴
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING SHORT STROKE OVERLAY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0335, -- ̵
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LONG STROKE OVERLAY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0336, -- ̶
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING SHORT SOLIDUS OVERLAY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0337, -- ̷
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LONG SOLIDUS OVERLAY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0338, -- ̸
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RIGHT HALF RING BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0339, -- ̹
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING INVERTED BRIDGE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x033A, -- ̺
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING SQUARE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x033B, -- ̻
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING SEAGULL BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x033C, -- ̼
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING X ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x033D, -- ̽
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING VERTICAL TILDE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x033E, -- ̾
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE OVERLINE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x033F, -- ̿
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GRAVE TONE MARK",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0300 },
  ["unicodeslot"]=0x0340, -- ̀
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING ACUTE TONE MARK",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0301 },
  ["unicodeslot"]=0x0341, -- ́
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GREEK PERISPOMENI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0342, -- ͂
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GREEK KORONIS",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0313 },
  ["unicodeslot"]=0x0343, -- ̓
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GREEK DIALYTIKA TONOS",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0308, 0x0301 },
  ["unicodeslot"]=0x0344, -- ̈́
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GREEK YPOGEGRAMMENI",
  ["linebreak"]="cm",
  ["uccode"]=0x0399,
  ["unicodeslot"]=0x0345, -- ͅ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING BRIDGE ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0346, -- ͆
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING EQUALS SIGN BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0347, -- ͇
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE VERTICAL LINE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0348, -- ͈
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LEFT ANGLE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0349, -- ͉
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING NOT TILDE ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x034A, -- ͊
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING HOMOTHETIC ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x034B, -- ͋
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING ALMOST EQUAL TO ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x034C, -- ͌
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LEFT RIGHT ARROW BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x034D, -- ͍
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING UPWARDS ARROW BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x034E, -- ͎
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING GRAPHEME JOINER",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x034F, -- ͏
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RIGHT ARROWHEAD ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0350, -- ͐
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LEFT HALF RING ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0351, -- ͑
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING FERMATA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0352, -- ͒
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING X BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0353, -- ͓
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LEFT ARROWHEAD BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0354, -- ͔
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RIGHT ARROWHEAD BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0355, -- ͕
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0356, -- ͖
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING RIGHT HALF RING ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0357, -- ͗
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOT ABOVE RIGHT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0358, -- ͘
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING ASTERISK BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0359, -- ͙
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE RING BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x035A, -- ͚
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING ZIGZAG ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x035B, -- ͛
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE BREVE BELOW",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x035C, -- ͜
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE BREVE",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x035D, -- ͝
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE MACRON",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x035E, -- ͞
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE MACRON BELOW",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x035F, -- ͟
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE TILDE",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x0360, -- ͠
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE INVERTED BREVE",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x0361, -- ͡
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING DOUBLE RIGHTWARDS ARROW BELOW",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x0362, -- ͢
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER A",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0363, -- ͣ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0364, -- ͤ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0365, -- ͥ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0366, -- ͦ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0367, -- ͧ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER C",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0368, -- ͨ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER D",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0369, -- ͩ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER H",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x036A, -- ͪ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER M",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x036B, -- ͫ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x036C, -- ͬ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER T",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x036D, -- ͭ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER V",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x036E, -- ͮ
 },
 {
  ["category"]="mn",
  ["cjkwd"]="a",
  ["description"]="COMBINING LATIN SMALL LETTER X",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x036F, -- ͯ
 },
 [0x0374]={
  ["category"]="sk",
  ["description"]="GREEK NUMERAL SIGN",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x02B9 },
  ["unicodeslot"]=0x0374, -- ʹ
 },
 [0x0375]={
  ["category"]="sk",
  ["description"]="GREEK LOWER NUMERAL SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0375, -- ͵
 },
 [0x037A]={
  ["category"]="lm",
  ["description"]="GREEK YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0345 },
  ["unicodeslot"]=0x037A, -- ͺ
 },
 [0x037B]={
  ["category"]="ll",
  ["description"]="GREEK SMALL REVERSED LUNATE SIGMA SYMBOL",
  ["linebreak"]="al",
  ["uccode"]=0x03FD,
  ["unicodeslot"]=0x037B, -- ͻ
 },
 [0x037C]={
  ["category"]="ll",
  ["description"]="GREEK SMALL DOTTED LUNATE SIGMA SYMBOL",
  ["linebreak"]="al",
  ["uccode"]=0x03FE,
  ["unicodeslot"]=0x037C, -- ͼ
 },
 [0x037D]={
  ["category"]="ll",
  ["description"]="GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL",
  ["linebreak"]="al",
  ["uccode"]=0x03FF,
  ["unicodeslot"]=0x037D, -- ͽ
 },
 [0x037E]={
  ["category"]="po",
  ["description"]="GREEK QUESTION MARK",
  ["linebreak"]="is",
  ["specials"]={ "char", 0x003B },
  ["unicodeslot"]=0x037E, -- ;
 },
 [0x0384]={
  ["adobename"]="tonos",
  ["category"]="sk",
  ["contextname"]="greektonos",
  ["description"]="GREEK TONOS",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0301 },
  ["unicodeslot"]=0x0384, -- ΄
 },
 [0x0385]={
  ["adobename"]="dieresistonos",
  ["category"]="sk",
  ["contextname"]="greekdialytikatonos",
  ["description"]="GREEK DIALYTIKA TONOS",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x00A8, 0x0301 },
  ["unicodeslot"]=0x0385, -- ΅
 },
 [0x0386]={
  ["adobename"]="Alphatonos",
  ["category"]="lu",
  ["contextname"]="greekAlphatonos",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH TONOS",
  ["lccode"]=0x03AC,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0391, 0x0301 },
  ["unicodeslot"]=0x0386, -- Ά
 },
 [0x0387]={
  ["adobename"]="anoteleia",
  ["category"]="po",
  ["description"]="GREEK ANO TELEIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x00B7 },
  ["unicodeslot"]=0x0387, -- ·
 },
 [0x0388]={
  ["adobename"]="Epsilontonos",
  ["category"]="lu",
  ["contextname"]="greekEpsilontonos",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH TONOS",
  ["lccode"]=0x03AD,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x0395, 0x0301 },
  ["unicodeslot"]=0x0388, -- Έ
 },
 [0x0389]={
  ["adobename"]="Etatonos",
  ["category"]="lu",
  ["contextname"]="greekEtatonos",
  ["description"]="GREEK CAPITAL LETTER ETA WITH TONOS",
  ["lccode"]=0x03AE,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x0397, 0x0301 },
  ["unicodeslot"]=0x0389, -- Ή
 },
 [0x038A]={
  ["adobename"]="Iotatonos",
  ["category"]="lu",
  ["contextname"]="greekIotatonos",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH TONOS",
  ["lccode"]=0x03AF,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x0399, 0x0301 },
  ["unicodeslot"]=0x038A, -- Ί
 },
 [0x038C]={
  ["adobename"]="Omicrontonos",
  ["category"]="lu",
  ["contextname"]="greekOmicrontonos",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH TONOS",
  ["lccode"]=0x03CC,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x039F, 0x0301 },
  ["unicodeslot"]=0x038C, -- Ό
 },
 [0x038E]={
  ["adobename"]="Upsilontonos",
  ["category"]="lu",
  ["contextname"]="greekUpsilontonos",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH TONOS",
  ["lccode"]=0x03CD,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x03A5, 0x0301 },
  ["unicodeslot"]=0x038E, -- Ύ
 },
 [0x038F]={
  ["adobename"]="Omegatonos",
  ["category"]="lu",
  ["contextname"]="greekOmegatonos",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH TONOS",
  ["lccode"]=0x03CE,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x03A9, 0x0301 },
  ["unicodeslot"]=0x038F, -- Ώ
 },
 [0x0390]={
  ["adobename"]="iotadieresistonos",
  ["category"]="ll",
  ["contextname"]="greekiotadialytikatonos",
  ["description"]="GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03CA, 0x0301 },
  ["unicodeslot"]=0x0390, -- ΐ
 },
 [0x0391]={
  ["adobename"]="Alpha",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekAlpha",
  ["description"]="GREEK CAPITAL LETTER ALPHA",
  ["lccode"]=0x03B1,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Alpha",
  ["unicodeslot"]=0x0391, -- Α
 },
 [0x0392]={
  ["adobename"]="Beta",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekBeta",
  ["description"]="GREEK CAPITAL LETTER BETA",
  ["lccode"]=0x03B2,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Beta",
  ["unicodeslot"]=0x0392, -- Β
 },
 [0x0393]={
  ["adobename"]="Gamma",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekGamma",
  ["description"]="GREEK CAPITAL LETTER GAMMA",
  ["lccode"]=0x03B3,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Gamma",
  ["unicodeslot"]=0x0393, -- Γ
 },
 [0x0394]={
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekDelta",
  ["description"]="GREEK CAPITAL LETTER DELTA",
  ["lccode"]=0x03B4,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Delta",
  ["unicodeslot"]=0x0394, -- Δ
 },
 [0x0395]={
  ["adobename"]="Epsilon",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekEpsilon",
  ["description"]="GREEK CAPITAL LETTER EPSILON",
  ["lccode"]=0x03B5,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Epsilon",
  ["unicodeslot"]=0x0395, -- Ε
 },
 [0x0396]={
  ["adobename"]="Zeta",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekZeta",
  ["description"]="GREEK CAPITAL LETTER ZETA",
  ["lccode"]=0x03B6,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Zeta",
  ["unicodeslot"]=0x0396, -- Ζ
 },
 [0x0397]={
  ["adobename"]="Eta",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekEta",
  ["description"]="GREEK CAPITAL LETTER ETA",
  ["lccode"]=0x03B7,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Eta",
  ["unicodeslot"]=0x0397, -- Η
 },
 [0x0398]={
  ["adobename"]="Theta",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekTheta",
  ["description"]="GREEK CAPITAL LETTER THETA",
  ["lccode"]=0x03B8,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Theta",
  ["unicodeslot"]=0x0398, -- Θ
 },
 [0x0399]={
  ["adobename"]="Iota",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekIota",
  ["description"]="GREEK CAPITAL LETTER IOTA",
  ["lccode"]=0x03B9,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Iota",
  ["unicodeslot"]=0x0399, -- Ι
 },
 [0x039A]={
  ["adobename"]="Kappa",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekKappa",
  ["description"]="GREEK CAPITAL LETTER KAPPA",
  ["lccode"]=0x03BA,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Kappa",
  ["unicodeslot"]=0x039A, -- Κ
 },
 [0x039B]={
  ["adobename"]="Lambda",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekLambda",
  ["description"]="GREEK CAPITAL LETTER LAMDA",
  ["lccode"]=0x03BB,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Lambda",
  ["unicodeslot"]=0x039B, -- Λ
 },
 [0x039C]={
  ["adobename"]="Mu",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekMu",
  ["description"]="GREEK CAPITAL LETTER MU",
  ["lccode"]=0x03BC,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Mu",
  ["unicodeslot"]=0x039C, -- Μ
 },
 [0x039D]={
  ["adobename"]="Nu",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekNu",
  ["description"]="GREEK CAPITAL LETTER NU",
  ["lccode"]=0x03BD,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Nu",
  ["unicodeslot"]=0x039D, -- Ν
 },
 [0x039E]={
  ["adobename"]="Xi",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekXi",
  ["description"]="GREEK CAPITAL LETTER XI",
  ["lccode"]=0x03BE,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Xi",
  ["unicodeslot"]=0x039E, -- Ξ
 },
 [0x039F]={
  ["adobename"]="Omicron",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekOmicron",
  ["description"]="GREEK CAPITAL LETTER OMICRON",
  ["lccode"]=0x03BF,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Omicron",
  ["unicodeslot"]=0x039F, -- Ο
 },
 [0x03A0]={
  ["adobename"]="Pi",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekPi",
  ["description"]="GREEK CAPITAL LETTER PI",
  ["lccode"]=0x03C0,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Pi",
  ["unicodeslot"]=0x03A0, -- Π
 },
 [0x03A1]={
  ["adobename"]="Rho",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekRho",
  ["description"]="GREEK CAPITAL LETTER RHO",
  ["lccode"]=0x03C1,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Rho",
  ["unicodeslot"]=0x03A1, -- Ρ
 },
 [0x03A3]={
  ["adobename"]="Sigma",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekSigma",
  ["description"]="GREEK CAPITAL LETTER SIGMA",
  ["lccode"]=0x03C3,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Sigma",
  ["unicodeslot"]=0x03A3, -- Σ
 },
 [0x03A4]={
  ["adobename"]="Tau",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekTau",
  ["description"]="GREEK CAPITAL LETTER TAU",
  ["lccode"]=0x03C4,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Tau",
  ["unicodeslot"]=0x03A4, -- Τ
 },
 [0x03A5]={
  ["adobename"]="Upsilon",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekUpsilon",
  ["description"]="GREEK CAPITAL LETTER UPSILON",
  ["lccode"]=0x03C5,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Upsilon",
  ["unicodeslot"]=0x03A5, -- Υ
 },
 [0x03A6]={
  ["adobename"]="Phi",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekPhi",
  ["description"]="GREEK CAPITAL LETTER PHI",
  ["lccode"]=0x03C6,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Phi",
  ["unicodeslot"]=0x03A6, -- Φ
 },
 [0x03A7]={
  ["adobename"]="Chi",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekChi",
  ["description"]="GREEK CAPITAL LETTER CHI",
  ["lccode"]=0x03C7,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Chi",
  ["unicodeslot"]=0x03A7, -- Χ
 },
 [0x03A8]={
  ["adobename"]="Psi",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekPsi",
  ["description"]="GREEK CAPITAL LETTER PSI",
  ["lccode"]=0x03C8,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Psi",
  ["unicodeslot"]=0x03A8, -- Ψ
 },
 [0x03A9]={
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="greekOmega",
  ["description"]="GREEK CAPITAL LETTER OMEGA",
  ["lccode"]=0x03C9,
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="Omega",
  ["unicodeslot"]=0x03A9, -- Ω
 },
 [0x03AA]={
  ["adobename"]="Iotadieresis",
  ["category"]="lu",
  ["contextname"]="greekIotadialytika",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH DIALYTIKA",
  ["lccode"]=0x03CA,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x0399, 0x0308 },
  ["unicodeslot"]=0x03AA, -- Ϊ
 },
 [0x03AB]={
  ["adobename"]="Upsilondieresis",
  ["category"]="lu",
  ["contextname"]="greekUpsilondialytika",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA",
  ["lccode"]=0x03CB,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x03A5, 0x0308 },
  ["unicodeslot"]=0x03AB, -- Ϋ
 },
 [0x03AC]={
  ["adobename"]="alphatonos",
  ["category"]="ll",
  ["contextname"]="greekalphatonos",
  ["description"]="GREEK SMALL LETTER ALPHA WITH TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0301 },
  ["uccode"]=0x0386,
  ["unicodeslot"]=0x03AC, -- ά
 },
 [0x03AD]={
  ["adobename"]="epsilontonos",
  ["category"]="ll",
  ["contextname"]="greekepsilontonos",
  ["description"]="GREEK SMALL LETTER EPSILON WITH TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x03B5, 0x0301 },
  ["uccode"]=0x0388,
  ["unicodeslot"]=0x03AD, -- έ
 },
 [0x03AE]={
  ["adobename"]="etatonos",
  ["category"]="ll",
  ["contextname"]="greeketatonos",
  ["description"]="GREEK SMALL LETTER ETA WITH TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03B7, 0x0301 },
  ["uccode"]=0x0389,
  ["unicodeslot"]=0x03AE, -- ή
 },
 [0x03AF]={
  ["adobename"]="iotatonos",
  ["category"]="ll",
  ["contextname"]="greekiotatonos",
  ["description"]="GREEK SMALL LETTER IOTA WITH TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0301 },
  ["uccode"]=0x038A,
  ["unicodeslot"]=0x03AF, -- ί
 },
 [0x03B0]={
  ["adobename"]="upsilondieresistonos",
  ["category"]="ll",
  ["contextname"]="greekupsilondialytikatonos",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03CB, 0x0301 },
  ["unicodeslot"]=0x03B0, -- ΰ
 },
 [0x03B1]={
  ["adobename"]="alpha",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekalpha",
  ["description"]="GREEK SMALL LETTER ALPHA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="alpha",
  ["uccode"]=0x0391,
  ["unicodeslot"]=0x03B1, -- α
 },
 [0x03B2]={
  ["adobename"]="beta",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekbeta",
  ["description"]="GREEK SMALL LETTER BETA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="beta",
  ["uccode"]=0x0392,
  ["unicodeslot"]=0x03B2, -- β
 },
 [0x03B3]={
  ["adobename"]="gamma",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekgamma",
  ["description"]="GREEK SMALL LETTER GAMMA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="gamma",
  ["uccode"]=0x0393,
  ["unicodeslot"]=0x03B3, -- γ
 },
 [0x03B4]={
  ["adobename"]="delta",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekdelta",
  ["description"]="GREEK SMALL LETTER DELTA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="delta",
  ["uccode"]=0x0394,
  ["unicodeslot"]=0x03B4, -- δ
 },
 [0x03B5]={
  ["adobename"]="epsilon",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekepsilon",
  ["description"]="GREEK SMALL LETTER EPSILON",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="epsilon",
  ["uccode"]=0x0395,
  ["unicodeslot"]=0x03B5, -- ε
 },
 [0x03B6]={
  ["adobename"]="zeta",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekzeta",
  ["description"]="GREEK SMALL LETTER ZETA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="zeta",
  ["uccode"]=0x0396,
  ["unicodeslot"]=0x03B6, -- ζ
 },
 [0x03B7]={
  ["adobename"]="eta",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greeketa",
  ["description"]="GREEK SMALL LETTER ETA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="eta",
  ["uccode"]=0x0397,
  ["unicodeslot"]=0x03B7, -- η
 },
 [0x03B8]={
  ["adobename"]="theta",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greektheta",
  ["description"]="GREEK SMALL LETTER THETA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="theta",
  ["uccode"]=0x0398,
  ["unicodeslot"]=0x03B8, -- θ
 },
 [0x03B9]={
  ["adobename"]="iota",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekiota",
  ["description"]="GREEK SMALL LETTER IOTA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="iota",
  ["uccode"]=0x0399,
  ["unicodeslot"]=0x03B9, -- ι
 },
 [0x03BA]={
  ["adobename"]="kappa",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekkappa",
  ["description"]="GREEK SMALL LETTER KAPPA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="kappa",
  ["uccode"]=0x039A,
  ["unicodeslot"]=0x03BA, -- κ
 },
 [0x03BB]={
  ["adobename"]="lambda",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greeklambda",
  ["description"]="GREEK SMALL LETTER LAMDA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="lambda",
  ["uccode"]=0x039B,
  ["unicodeslot"]=0x03BB, -- λ
 },
 [0x03BC]={
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekmu",
  ["description"]="GREEK SMALL LETTER MU",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="mu",
  ["uccode"]=0x039C,
  ["unicodeslot"]=0x03BC, -- μ
 },
 [0x03BD]={
  ["adobename"]="nu",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greeknu",
  ["description"]="GREEK SMALL LETTER NU",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="nu",
  ["uccode"]=0x039D,
  ["unicodeslot"]=0x03BD, -- ν
 },
 [0x03BE]={
  ["adobename"]="xi",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekxi",
  ["description"]="GREEK SMALL LETTER XI",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="xi",
  ["uccode"]=0x039E,
  ["unicodeslot"]=0x03BE, -- ξ
 },
 [0x03BF]={
  ["adobename"]="omicron",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekomicron",
  ["description"]="GREEK SMALL LETTER OMICRON",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="omicron",
  ["uccode"]=0x039F,
  ["unicodeslot"]=0x03BF, -- ο
 },
 [0x03C0]={
  ["adobename"]="pi",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekpi",
  ["description"]="GREEK SMALL LETTER PI",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="pi",
  ["uccode"]=0x03A0,
  ["unicodeslot"]=0x03C0, -- π
 },
 [0x03C1]={
  ["adobename"]="rho",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekrho",
  ["description"]="GREEK SMALL LETTER RHO",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="rho",
  ["uccode"]=0x03A1,
  ["unicodeslot"]=0x03C1, -- ρ
 },
 [0x03C2]={
  ["adobename"]="sigma1",
  ["category"]="ll",
  ["contextname"]="greekfinalsigma",
  ["description"]="GREEK SMALL LETTER FINAL SIGMA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="varsigma",
  ["uccode"]=0x03A3,
  ["unicodeslot"]=0x03C2, -- ς
 },
 [0x03C3]={
  ["adobename"]="sigma",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greeksigma",
  ["description"]="GREEK SMALL LETTER SIGMA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="sigma",
  ["uccode"]=0x03A3,
  ["unicodeslot"]=0x03C3, -- σ
 },
 [0x03C4]={
  ["adobename"]="tau",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greektau",
  ["description"]="GREEK SMALL LETTER TAU",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="tau",
  ["uccode"]=0x03A4,
  ["unicodeslot"]=0x03C4, -- τ
 },
 [0x03C5]={
  ["adobename"]="upsilon",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekupsilon",
  ["description"]="GREEK SMALL LETTER UPSILON",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="upsilon",
  ["uccode"]=0x03A5,
  ["unicodeslot"]=0x03C5, -- υ
 },
 [0x03C6]={
  ["adobename"]="phi",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekphi",
  ["description"]="GREEK SMALL LETTER PHI",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="varphi",
  ["uccode"]=0x03A6,
  ["unicodeslot"]=0x03C6, -- φ
 },
 [0x03C7]={
  ["adobename"]="chi",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekchi",
  ["description"]="GREEK SMALL LETTER CHI",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="chi",
  ["uccode"]=0x03A7,
  ["unicodeslot"]=0x03C7, -- χ
 },
 [0x03C8]={
  ["adobename"]="psi",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekpsi",
  ["description"]="GREEK SMALL LETTER PSI",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="psi",
  ["uccode"]=0x03A8,
  ["unicodeslot"]=0x03C8, -- ψ
 },
 [0x03C9]={
  ["adobename"]="omega",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="greekomega",
  ["description"]="GREEK SMALL LETTER OMEGA",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="omega",
  ["uccode"]=0x03A9,
  ["unicodeslot"]=0x03C9, -- ω
 },
 [0x03CA]={
  ["adobename"]="iotadieresis",
  ["category"]="ll",
  ["contextname"]="greekiotadialytika",
  ["description"]="GREEK SMALL LETTER IOTA WITH DIALYTIKA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0308 },
  ["uccode"]=0x03AA,
  ["unicodeslot"]=0x03CA, -- ϊ
 },
 [0x03CB]={
  ["adobename"]="upsilondieresis",
  ["category"]="ll",
  ["contextname"]="greekupsilondiaeresis",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DIALYTIKA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0308 },
  ["uccode"]=0x03AB,
  ["unicodeslot"]=0x03CB, -- ϋ
 },
 [0x03CC]={
  ["adobename"]="omicrontonos",
  ["category"]="ll",
  ["contextname"]="greekomicrontonos",
  ["description"]="GREEK SMALL LETTER OMICRON WITH TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x03BF, 0x0301 },
  ["uccode"]=0x038C,
  ["unicodeslot"]=0x03CC, -- ό
 },
 [0x03CD]={
  ["adobename"]="upsilontonos",
  ["category"]="ll",
  ["contextname"]="greekupsilontonos",
  ["description"]="GREEK SMALL LETTER UPSILON WITH TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0301 },
  ["uccode"]=0x038E,
  ["unicodeslot"]=0x03CD, -- ύ
 },
 [0x03CE]={
  ["adobename"]="omegatonos",
  ["category"]="ll",
  ["contextname"]="greekomegatonos",
  ["description"]="GREEK SMALL LETTER OMEGA WITH TONOS",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03C9, 0x0301 },
  ["uccode"]=0x038F,
  ["unicodeslot"]=0x03CE, -- ώ
 },
 [0x03D0]={
  ["category"]="ll",
  ["description"]="GREEK BETA SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03B2 },
  ["uccode"]=0x0392,
  ["unicodeslot"]=0x03D0, -- ϐ
 },
 [0x03D1]={
  ["adobename"]="theta1",
  ["category"]="ll",
  ["contextname"]="greekthetaalt",
  ["description"]="GREEK THETA SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03B8 },
  ["mathclass"]="variable",
  ["mathname"]="vartheta",
  ["uccode"]=0x0398,
  ["unicodeslot"]=0x03D1, -- ϑ
 },
 [0x03D2]={
  ["adobename"]="Upsilon1",
  ["category"]="lu",
  ["description"]="GREEK UPSILON WITH HOOK SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03A5 },
  ["unicodeslot"]=0x03D2, -- ϒ
 },
 [0x03D3]={
  ["category"]="lu",
  ["description"]="GREEK UPSILON WITH ACUTE AND HOOK SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x03D2, 0x0301 },
  ["unicodeslot"]=0x03D3, -- ϓ
 },
 [0x03D4]={
  ["category"]="lu",
  ["description"]="GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x03D2, 0x0308 },
  ["unicodeslot"]=0x03D4, -- ϔ
 },
 [0x03D5]={
  ["adobename"]="phi1",
  ["category"]="ll",
  ["contextname"]="greekphialt",
  ["description"]="GREEK PHI SYMBOL",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="phi",
  ["specials"]={ "compat", 0x03C6 },
  ["uccode"]=0x03A6,
  ["unicodeslot"]=0x03D5, -- ϕ
 },
 [0x03D6]={
  ["adobename"]="omega1",
  ["category"]="ll",
  ["contextname"]="greekpialt",
  ["description"]="GREEK PI SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03C0 },
  ["mathclass"]="variable",
  ["mathname"]="varpi",
  ["uccode"]=0x03A0,
  ["unicodeslot"]=0x03D6, -- ϖ
 },
 [0x03D7]={
  ["category"]="ll",
  ["description"]="GREEK KAI SYMBOL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x03D7, -- ϗ
 },
 [0x03D8]={
  ["category"]="lu",
  ["description"]="GREEK LETTER ARCHAIC KOPPA",
  ["lccode"]=0x03D9,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03D8, -- Ϙ
 },
 [0x03D9]={
  ["category"]="ll",
  ["contextname"]="greekkoppa",
  ["description"]="GREEK SMALL LETTER ARCHAIC KOPPA",
  ["linebreak"]="al",
  ["uccode"]=0x03D8,
  ["unicodeslot"]=0x03D9, -- ϙ
 },
 [0x03DA]={
  ["category"]="lu",
  ["description"]="GREEK LETTER STIGMA",
  ["lccode"]=0x03DB,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03DA, -- Ϛ
 },
 [0x03DB]={
  ["category"]="ll",
  ["contextname"]="greekstigma",
  ["description"]="GREEK SMALL LETTER STIGMA",
  ["linebreak"]="al",
  ["uccode"]=0x03DA,
  ["unicodeslot"]=0x03DB, -- ϛ
 },
 [0x03DC]={
  ["category"]="lu",
  ["description"]="GREEK LETTER DIGAMMA",
  ["lccode"]=0x03DD,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03DC, -- Ϝ
 },
 [0x03DD]={
  ["category"]="ll",
  ["contextname"]="greekdigamma",
  ["description"]="GREEK SMALL LETTER DIGAMMA",
  ["linebreak"]="al",
  ["uccode"]=0x03DC,
  ["unicodeslot"]=0x03DD, -- ϝ
 },
 [0x03DE]={
  ["category"]="lu",
  ["description"]="GREEK LETTER KOPPA",
  ["lccode"]=0x03DF,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03DE, -- Ϟ
 },
 [0x03DF]={
  ["category"]="ll",
  ["contextname"]="greeknumkoppa",
  ["description"]="GREEK SMALL LETTER KOPPA",
  ["linebreak"]="al",
  ["uccode"]=0x03DE,
  ["unicodeslot"]=0x03DF, -- ϟ
 },
 [0x03E0]={
  ["category"]="lu",
  ["description"]="GREEK LETTER SAMPI",
  ["lccode"]=0x03E1,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03E0, -- Ϡ
 },
 [0x03E1]={
  ["category"]="ll",
  ["contextname"]="greeksampi",
  ["description"]="GREEK SMALL LETTER SAMPI",
  ["linebreak"]="al",
  ["uccode"]=0x03E0,
  ["unicodeslot"]=0x03E1, -- ϡ
 },
 [0x03E2]={
  ["category"]="lu",
  ["description"]="COPTIC CAPITAL LETTER SHEI",
  ["lccode"]=0x03E3,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03E2, -- Ϣ
 },
 [0x03E3]={
  ["category"]="ll",
  ["description"]="COPTIC SMALL LETTER SHEI",
  ["linebreak"]="al",
  ["uccode"]=0x03E2,
  ["unicodeslot"]=0x03E3, -- ϣ
 },
 [0x03E4]={
  ["category"]="lu",
  ["description"]="COPTIC CAPITAL LETTER FEI",
  ["lccode"]=0x03E5,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03E4, -- Ϥ
 },
 [0x03E5]={
  ["category"]="ll",
  ["description"]="COPTIC SMALL LETTER FEI",
  ["linebreak"]="al",
  ["uccode"]=0x03E4,
  ["unicodeslot"]=0x03E5, -- ϥ
 },
 [0x03E6]={
  ["category"]="lu",
  ["description"]="COPTIC CAPITAL LETTER KHEI",
  ["lccode"]=0x03E7,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03E6, -- Ϧ
 },
 [0x03E7]={
  ["category"]="ll",
  ["description"]="COPTIC SMALL LETTER KHEI",
  ["linebreak"]="al",
  ["uccode"]=0x03E6,
  ["unicodeslot"]=0x03E7, -- ϧ
 },
 [0x03E8]={
  ["category"]="lu",
  ["description"]="COPTIC CAPITAL LETTER HORI",
  ["lccode"]=0x03E9,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03E8, -- Ϩ
 },
 [0x03E9]={
  ["category"]="ll",
  ["description"]="COPTIC SMALL LETTER HORI",
  ["linebreak"]="al",
  ["uccode"]=0x03E8,
  ["unicodeslot"]=0x03E9, -- ϩ
 },
 [0x03EA]={
  ["category"]="lu",
  ["description"]="COPTIC CAPITAL LETTER GANGIA",
  ["lccode"]=0x03EB,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03EA, -- Ϫ
 },
 [0x03EB]={
  ["category"]="ll",
  ["description"]="COPTIC SMALL LETTER GANGIA",
  ["linebreak"]="al",
  ["uccode"]=0x03EA,
  ["unicodeslot"]=0x03EB, -- ϫ
 },
 [0x03EC]={
  ["category"]="lu",
  ["description"]="COPTIC CAPITAL LETTER SHIMA",
  ["lccode"]=0x03ED,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03EC, -- Ϭ
 },
 [0x03ED]={
  ["category"]="ll",
  ["description"]="COPTIC SMALL LETTER SHIMA",
  ["linebreak"]="al",
  ["uccode"]=0x03EC,
  ["unicodeslot"]=0x03ED, -- ϭ
 },
 [0x03EE]={
  ["category"]="lu",
  ["description"]="COPTIC CAPITAL LETTER DEI",
  ["lccode"]=0x03EF,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03EE, -- Ϯ
 },
 [0x03EF]={
  ["category"]="ll",
  ["description"]="COPTIC SMALL LETTER DEI",
  ["linebreak"]="al",
  ["uccode"]=0x03EE,
  ["unicodeslot"]=0x03EF, -- ϯ
 },
 [0x03F0]={
  ["category"]="ll",
  ["description"]="GREEK KAPPA SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03BA },
  ["uccode"]=0x039A,
  ["unicodeslot"]=0x03F0, -- ϰ
 },
 [0x03F1]={
  ["category"]="ll",
  ["contextname"]="greekrhoalt",
  ["description"]="GREEK RHO SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03C1 },
  ["mathclass"]="variable",
  ["mathname"]="varrho",
  ["uccode"]=0x03A1,
  ["unicodeslot"]=0x03F1, -- ϱ
 },
 [0x03F2]={
  ["category"]="ll",
  ["contextname"]="greeksigmalunate",
  ["description"]="GREEK LUNATE SIGMA SYMBOL",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03C2 },
  ["uccode"]=0x03F9,
  ["unicodeslot"]=0x03F2, -- ϲ
 },
 [0x03F3]={
  ["category"]="ll",
  ["description"]="GREEK LETTER YOT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x03F3, -- ϳ
 },
 [0x03F4]={
  ["category"]="lu",
  ["description"]="GREEK CAPITAL THETA SYMBOL",
  ["lccode"]=0x03B8,
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0398 },
  ["unicodeslot"]=0x03F4, -- ϴ
 },
 [0x03F5]={
  ["category"]="ll",
  ["contextname"]="greekepsilonalt",
  ["description"]="GREEK LUNATE EPSILON SYMBOL",
  ["linebreak"]="al",
  ["mathclass"]="variable",
  ["mathname"]="varepsilon",
  ["specials"]={ "compat", 0x03B5 },
  ["uccode"]=0x0395,
  ["unicodeslot"]=0x03F5, -- ϵ
 },
 [0x03F6]={
  ["category"]="sm",
  ["description"]="GREEK REVERSED LUNATE EPSILON SYMBOL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x03F6, -- ϶
 },
 [0x03F7]={
  ["category"]="lu",
  ["description"]="GREEK CAPITAL LETTER SHO",
  ["lccode"]=0x03F8,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03F7, -- Ϸ
 },
 [0x03F8]={
  ["category"]="ll",
  ["description"]="GREEK SMALL LETTER SHO",
  ["linebreak"]="al",
  ["uccode"]=0x03F7,
  ["unicodeslot"]=0x03F8, -- ϸ
 },
 [0x03F9]={
  ["category"]="lu",
  ["contextname"]="greekSigmalunate",
  ["description"]="GREEK CAPITAL LUNATE SIGMA SYMBOL",
  ["lccode"]=0x03F2,
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x03A3 },
  ["unicodeslot"]=0x03F9, -- Ϲ
 },
 [0x03FA]={
  ["category"]="lu",
  ["description"]="GREEK CAPITAL LETTER SAN",
  ["lccode"]=0x03FB,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03FA, -- Ϻ
 },
 [0x03FB]={
  ["category"]="ll",
  ["description"]="GREEK SMALL LETTER SAN",
  ["linebreak"]="al",
  ["uccode"]=0x03FA,
  ["unicodeslot"]=0x03FB, -- ϻ
 },
 [0x03FC]={
  ["category"]="ll",
  ["description"]="GREEK RHO WITH STROKE SYMBOL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x03FC, -- ϼ
 },
 [0x03FD]={
  ["category"]="lu",
  ["description"]="GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL",
  ["lccode"]=0x037B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03FD, -- Ͻ
 },
 [0x03FE]={
  ["category"]="lu",
  ["description"]="GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL",
  ["lccode"]=0x037C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03FE, -- Ͼ
 },
 [0x03FF]={
  ["category"]="lu",
  ["description"]="GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL",
  ["lccode"]=0x037D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x03FF, -- Ͽ
 },
 [0x0400]={
  ["category"]="lu",
  ["contextname"]="cyrillicEgrave",
  ["description"]="CYRILLIC CAPITAL LETTER IE WITH GRAVE",
  ["lccode"]=0x0450,
  ["linebreak"]="al",
  ["shcode"]=0x0415,
  ["specials"]={ "char", 0x0415, 0x0300 },
  ["unicodeslot"]=0x0400, -- Ѐ
 },
 [0x0401]={
  ["adobename"]="afii10023",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicYO",
  ["description"]="CYRILLIC CAPITAL LETTER IO",
  ["lccode"]=0x0451,
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0415, 0x0308 },
  ["unicodeslot"]=0x0401, -- Ё
 },
 [0x0402]={
  ["adobename"]="afii10051",
  ["category"]="lu",
  ["contextname"]="cyrillicDJE",
  ["description"]="CYRILLIC CAPITAL LETTER DJE",
  ["lccode"]=0x0452,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0402, -- Ђ
 },
 [0x0403]={
  ["adobename"]="afii10052",
  ["category"]="lu",
  ["contextname"]="cyrillicGJE",
  ["description"]="CYRILLIC CAPITAL LETTER GJE",
  ["lccode"]=0x0453,
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0413, 0x0301 },
  ["unicodeslot"]=0x0403, -- Ѓ
 },
 [0x0404]={
  ["adobename"]="afii10053",
  ["category"]="lu",
  ["contextname"]="cyrillicIE",
  ["description"]="CYRILLIC CAPITAL LETTER UKRAINIAN IE",
  ["lccode"]=0x0454,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0404, -- Є
 },
 [0x0405]={
  ["adobename"]="afii10054",
  ["category"]="lu",
  ["contextname"]="cyrillicDZE",
  ["description"]="CYRILLIC CAPITAL LETTER DZE",
  ["lccode"]=0x0455,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0405, -- Ѕ
 },
 [0x0406]={
  ["adobename"]="afii10055",
  ["category"]="lu",
  ["contextname"]="cyrillicII",
  ["description"]="CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I",
  ["lccode"]=0x0456,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0406, -- І
 },
 [0x0407]={
  ["adobename"]="afii10056",
  ["category"]="lu",
  ["contextname"]="cyrillicYI",
  ["description"]="CYRILLIC CAPITAL LETTER YI",
  ["lccode"]=0x0457,
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0406, 0x0308 },
  ["unicodeslot"]=0x0407, -- Ї
 },
 [0x0408]={
  ["adobename"]="afii10057",
  ["category"]="lu",
  ["contextname"]="cyrillicJE",
  ["description"]="CYRILLIC CAPITAL LETTER JE",
  ["lccode"]=0x0458,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0408, -- Ј
 },
 [0x0409]={
  ["adobename"]="afii10058",
  ["category"]="lu",
  ["contextname"]="cyrillicLJE",
  ["description"]="CYRILLIC CAPITAL LETTER LJE",
  ["lccode"]=0x0459,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0409, -- Љ
 },
 [0x040A]={
  ["adobename"]="afii10059",
  ["category"]="lu",
  ["contextname"]="cyrillicNJE",
  ["description"]="CYRILLIC CAPITAL LETTER NJE",
  ["lccode"]=0x045A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x040A, -- Њ
 },
 [0x040B]={
  ["adobename"]="afii10060",
  ["category"]="lu",
  ["contextname"]="cyrillicTSHE",
  ["description"]="CYRILLIC CAPITAL LETTER TSHE",
  ["lccode"]=0x045B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x040B, -- Ћ
 },
 [0x040C]={
  ["adobename"]="afii10061",
  ["category"]="lu",
  ["contextname"]="cyrillicKJE",
  ["description"]="CYRILLIC CAPITAL LETTER KJE",
  ["lccode"]=0x045C,
  ["linebreak"]="al",
  ["specials"]={ "char", 0x041A, 0x0301 },
  ["unicodeslot"]=0x040C, -- Ќ
 },
 [0x040D]={
  ["category"]="lu",
  ["contextname"]="cyrillicIgrave",
  ["description"]="CYRILLIC CAPITAL LETTER I WITH GRAVE",
  ["lccode"]=0x045D,
  ["linebreak"]="al",
  ["shcode"]=0x0418,
  ["specials"]={ "char", 0x0418, 0x0300 },
  ["unicodeslot"]=0x040D, -- Ѝ
 },
 [0x040E]={
  ["adobename"]="afii10062",
  ["category"]="lu",
  ["contextname"]="cyrillicUSHRT",
  ["description"]="CYRILLIC CAPITAL LETTER SHORT U",
  ["lccode"]=0x045E,
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0423, 0x0306 },
  ["unicodeslot"]=0x040E, -- Ў
 },
 [0x040F]={
  ["adobename"]="afii10145",
  ["category"]="lu",
  ["contextname"]="cyrillicDZHE",
  ["description"]="CYRILLIC CAPITAL LETTER DZHE",
  ["lccode"]=0x045F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x040F, -- Џ
 },
 [0x0410]={
  ["adobename"]="afii10017",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicA",
  ["description"]="CYRILLIC CAPITAL LETTER A",
  ["lccode"]=0x0430,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0410, -- А
 },
 [0x0411]={
  ["adobename"]="afii10018",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicB",
  ["description"]="CYRILLIC CAPITAL LETTER BE",
  ["lccode"]=0x0431,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0411, -- Б
 },
 [0x0412]={
  ["adobename"]="afii10019",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicV",
  ["description"]="CYRILLIC CAPITAL LETTER VE",
  ["lccode"]=0x0432,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0412, -- В
 },
 [0x0413]={
  ["adobename"]="afii10020",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicG",
  ["description"]="CYRILLIC CAPITAL LETTER GHE",
  ["lccode"]=0x0433,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0413, -- Г
 },
 [0x0414]={
  ["adobename"]="afii10021",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicD",
  ["description"]="CYRILLIC CAPITAL LETTER DE",
  ["lccode"]=0x0434,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0414, -- Д
 },
 [0x0415]={
  ["adobename"]="afii10022",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicE",
  ["description"]="CYRILLIC CAPITAL LETTER IE",
  ["lccode"]=0x0435,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0415, -- Е
 },
 [0x0416]={
  ["adobename"]="afii10024",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicZH",
  ["description"]="CYRILLIC CAPITAL LETTER ZHE",
  ["lccode"]=0x0436,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0416, -- Ж
 },
 [0x0417]={
  ["adobename"]="afii10025",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicZ",
  ["description"]="CYRILLIC CAPITAL LETTER ZE",
  ["lccode"]=0x0437,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0417, -- З
 },
 [0x0418]={
  ["adobename"]="afii10026",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicI",
  ["description"]="CYRILLIC CAPITAL LETTER I",
  ["lccode"]=0x0438,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0418, -- И
 },
 [0x0419]={
  ["adobename"]="afii10027",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicISHRT",
  ["description"]="CYRILLIC CAPITAL LETTER SHORT I",
  ["lccode"]=0x0439,
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0418, 0x0306 },
  ["unicodeslot"]=0x0419, -- Й
 },
 [0x041A]={
  ["adobename"]="afii10028",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicK",
  ["description"]="CYRILLIC CAPITAL LETTER KA",
  ["lccode"]=0x043A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x041A, -- К
 },
 [0x041B]={
  ["adobename"]="afii10029",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicL",
  ["description"]="CYRILLIC CAPITAL LETTER EL",
  ["lccode"]=0x043B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x041B, -- Л
 },
 [0x041C]={
  ["adobename"]="afii10030",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicM",
  ["description"]="CYRILLIC CAPITAL LETTER EM",
  ["lccode"]=0x043C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x041C, -- М
 },
 [0x041D]={
  ["adobename"]="afii10031",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicN",
  ["description"]="CYRILLIC CAPITAL LETTER EN",
  ["lccode"]=0x043D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x041D, -- Н
 },
 [0x041E]={
  ["adobename"]="afii10032",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicO",
  ["description"]="CYRILLIC CAPITAL LETTER O",
  ["lccode"]=0x043E,
  ["linebreak"]="al",
  ["unicodeslot"]=0x041E, -- О
 },
 [0x041F]={
  ["adobename"]="afii10033",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicP",
  ["description"]="CYRILLIC CAPITAL LETTER PE",
  ["lccode"]=0x043F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x041F, -- П
 },
 [0x0420]={
  ["adobename"]="afii10034",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicR",
  ["description"]="CYRILLIC CAPITAL LETTER ER",
  ["lccode"]=0x0440,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0420, -- Р
 },
 [0x0421]={
  ["adobename"]="afii10035",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicS",
  ["description"]="CYRILLIC CAPITAL LETTER ES",
  ["lccode"]=0x0441,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0421, -- С
 },
 [0x0422]={
  ["adobename"]="afii10036",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicT",
  ["description"]="CYRILLIC CAPITAL LETTER TE",
  ["lccode"]=0x0442,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0422, -- Т
 },
 [0x0423]={
  ["adobename"]="afii10037",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicU",
  ["description"]="CYRILLIC CAPITAL LETTER U",
  ["lccode"]=0x0443,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0423, -- У
 },
 [0x0424]={
  ["adobename"]="afii10038",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicF",
  ["description"]="CYRILLIC CAPITAL LETTER EF",
  ["lccode"]=0x0444,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0424, -- Ф
 },
 [0x0425]={
  ["adobename"]="afii10039",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicH",
  ["description"]="CYRILLIC CAPITAL LETTER HA",
  ["lccode"]=0x0445,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0425, -- Х
 },
 [0x0426]={
  ["adobename"]="afii10040",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicC",
  ["description"]="CYRILLIC CAPITAL LETTER TSE",
  ["lccode"]=0x0446,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0426, -- Ц
 },
 [0x0427]={
  ["adobename"]="afii10041",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicCH",
  ["description"]="CYRILLIC CAPITAL LETTER CHE",
  ["lccode"]=0x0447,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0427, -- Ч
 },
 [0x0428]={
  ["adobename"]="afii10042",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicSH",
  ["description"]="CYRILLIC CAPITAL LETTER SHA",
  ["lccode"]=0x0448,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0428, -- Ш
 },
 [0x0429]={
  ["adobename"]="afii10043",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicSHCH",
  ["description"]="CYRILLIC CAPITAL LETTER SHCHA",
  ["lccode"]=0x0449,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0429, -- Щ
 },
 [0x042A]={
  ["adobename"]="afii10044",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicHRDSN",
  ["description"]="CYRILLIC CAPITAL LETTER HARD SIGN",
  ["lccode"]=0x044A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x042A, -- Ъ
 },
 [0x042B]={
  ["adobename"]="afii10045",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicERY",
  ["description"]="CYRILLIC CAPITAL LETTER YERU",
  ["lccode"]=0x044B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x042B, -- Ы
 },
 [0x042C]={
  ["adobename"]="afii10046",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicSFTSN",
  ["description"]="CYRILLIC CAPITAL LETTER SOFT SIGN",
  ["lccode"]=0x044C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x042C, -- Ь
 },
 [0x042D]={
  ["adobename"]="afii10047",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicEREV",
  ["description"]="CYRILLIC CAPITAL LETTER E",
  ["lccode"]=0x044D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x042D, -- Э
 },
 [0x042E]={
  ["adobename"]="afii10048",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicYU",
  ["description"]="CYRILLIC CAPITAL LETTER YU",
  ["lccode"]=0x044E,
  ["linebreak"]="al",
  ["unicodeslot"]=0x042E, -- Ю
 },
 [0x042F]={
  ["adobename"]="afii10049",
  ["category"]="lu",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicYA",
  ["description"]="CYRILLIC CAPITAL LETTER YA",
  ["lccode"]=0x044F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x042F, -- Я
 },
 [0x0430]={
  ["adobename"]="afii10065",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillica",
  ["description"]="CYRILLIC SMALL LETTER A",
  ["linebreak"]="al",
  ["uccode"]=0x0410,
  ["unicodeslot"]=0x0430, -- а
 },
 [0x0431]={
  ["adobename"]="afii10066",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicb",
  ["description"]="CYRILLIC SMALL LETTER BE",
  ["linebreak"]="al",
  ["uccode"]=0x0411,
  ["unicodeslot"]=0x0431, -- б
 },
 [0x0432]={
  ["adobename"]="afii10067",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicv",
  ["description"]="CYRILLIC SMALL LETTER VE",
  ["linebreak"]="al",
  ["uccode"]=0x0412,
  ["unicodeslot"]=0x0432, -- в
 },
 [0x0433]={
  ["adobename"]="afii10068",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicg",
  ["description"]="CYRILLIC SMALL LETTER GHE",
  ["linebreak"]="al",
  ["uccode"]=0x0413,
  ["unicodeslot"]=0x0433, -- г
 },
 [0x0434]={
  ["adobename"]="afii10069",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicd",
  ["description"]="CYRILLIC SMALL LETTER DE",
  ["linebreak"]="al",
  ["uccode"]=0x0414,
  ["unicodeslot"]=0x0434, -- д
 },
 [0x0435]={
  ["adobename"]="afii10070",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillice",
  ["description"]="CYRILLIC SMALL LETTER IE",
  ["linebreak"]="al",
  ["uccode"]=0x0415,
  ["unicodeslot"]=0x0435, -- е
 },
 [0x0436]={
  ["adobename"]="afii10072",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrilliczh",
  ["description"]="CYRILLIC SMALL LETTER ZHE",
  ["linebreak"]="al",
  ["uccode"]=0x0416,
  ["unicodeslot"]=0x0436, -- ж
 },
 [0x0437]={
  ["adobename"]="afii10073",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicz",
  ["description"]="CYRILLIC SMALL LETTER ZE",
  ["linebreak"]="al",
  ["uccode"]=0x0417,
  ["unicodeslot"]=0x0437, -- з
 },
 [0x0438]={
  ["adobename"]="afii10074",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillici",
  ["description"]="CYRILLIC SMALL LETTER I",
  ["linebreak"]="al",
  ["uccode"]=0x0418,
  ["unicodeslot"]=0x0438, -- и
 },
 [0x0439]={
  ["adobename"]="afii10075",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicishrt",
  ["description"]="CYRILLIC SMALL LETTER SHORT I",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0438, 0x0306 },
  ["uccode"]=0x0419,
  ["unicodeslot"]=0x0439, -- й
 },
 [0x043A]={
  ["adobename"]="afii10076",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillick",
  ["description"]="CYRILLIC SMALL LETTER KA",
  ["linebreak"]="al",
  ["uccode"]=0x041A,
  ["unicodeslot"]=0x043A, -- к
 },
 [0x043B]={
  ["adobename"]="afii10077",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicl",
  ["description"]="CYRILLIC SMALL LETTER EL",
  ["linebreak"]="al",
  ["uccode"]=0x041B,
  ["unicodeslot"]=0x043B, -- л
 },
 [0x043C]={
  ["adobename"]="afii10078",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicm",
  ["description"]="CYRILLIC SMALL LETTER EM",
  ["linebreak"]="al",
  ["uccode"]=0x041C,
  ["unicodeslot"]=0x043C, -- м
 },
 [0x043D]={
  ["adobename"]="afii10079",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicn",
  ["description"]="CYRILLIC SMALL LETTER EN",
  ["linebreak"]="al",
  ["uccode"]=0x041D,
  ["unicodeslot"]=0x043D, -- н
 },
 [0x043E]={
  ["adobename"]="afii10080",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillico",
  ["description"]="CYRILLIC SMALL LETTER O",
  ["linebreak"]="al",
  ["uccode"]=0x041E,
  ["unicodeslot"]=0x043E, -- о
 },
 [0x043F]={
  ["adobename"]="afii10081",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicp",
  ["description"]="CYRILLIC SMALL LETTER PE",
  ["linebreak"]="al",
  ["uccode"]=0x041F,
  ["unicodeslot"]=0x043F, -- п
 },
 [0x0440]={
  ["adobename"]="afii10082",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicr",
  ["description"]="CYRILLIC SMALL LETTER ER",
  ["linebreak"]="al",
  ["uccode"]=0x0420,
  ["unicodeslot"]=0x0440, -- р
 },
 [0x0441]={
  ["adobename"]="afii10083",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillics",
  ["description"]="CYRILLIC SMALL LETTER ES",
  ["linebreak"]="al",
  ["uccode"]=0x0421,
  ["unicodeslot"]=0x0441, -- с
 },
 [0x0442]={
  ["adobename"]="afii10084",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillict",
  ["description"]="CYRILLIC SMALL LETTER TE",
  ["linebreak"]="al",
  ["uccode"]=0x0422,
  ["unicodeslot"]=0x0442, -- т
 },
 [0x0443]={
  ["adobename"]="afii10085",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicu",
  ["description"]="CYRILLIC SMALL LETTER U",
  ["linebreak"]="al",
  ["uccode"]=0x0423,
  ["unicodeslot"]=0x0443, -- у
 },
 [0x0444]={
  ["adobename"]="afii10086",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicf",
  ["description"]="CYRILLIC SMALL LETTER EF",
  ["linebreak"]="al",
  ["uccode"]=0x0424,
  ["unicodeslot"]=0x0444, -- ф
 },
 [0x0445]={
  ["adobename"]="afii10087",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillich",
  ["description"]="CYRILLIC SMALL LETTER HA",
  ["linebreak"]="al",
  ["uccode"]=0x0425,
  ["unicodeslot"]=0x0445, -- х
 },
 [0x0446]={
  ["adobename"]="afii10088",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicc",
  ["description"]="CYRILLIC SMALL LETTER TSE",
  ["linebreak"]="al",
  ["uccode"]=0x0426,
  ["unicodeslot"]=0x0446, -- ц
 },
 [0x0447]={
  ["adobename"]="afii10089",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicch",
  ["description"]="CYRILLIC SMALL LETTER CHE",
  ["linebreak"]="al",
  ["uccode"]=0x0427,
  ["unicodeslot"]=0x0447, -- ч
 },
 [0x0448]={
  ["adobename"]="afii10090",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicsh",
  ["description"]="CYRILLIC SMALL LETTER SHA",
  ["linebreak"]="al",
  ["uccode"]=0x0428,
  ["unicodeslot"]=0x0448, -- ш
 },
 [0x0449]={
  ["adobename"]="afii10091",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicshch",
  ["description"]="CYRILLIC SMALL LETTER SHCHA",
  ["linebreak"]="al",
  ["uccode"]=0x0429,
  ["unicodeslot"]=0x0449, -- щ
 },
 [0x044A]={
  ["adobename"]="afii10092",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillichrdsn",
  ["description"]="CYRILLIC SMALL LETTER HARD SIGN",
  ["linebreak"]="al",
  ["uccode"]=0x042A,
  ["unicodeslot"]=0x044A, -- ъ
 },
 [0x044B]={
  ["adobename"]="afii10093",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicery",
  ["description"]="CYRILLIC SMALL LETTER YERU",
  ["linebreak"]="al",
  ["uccode"]=0x042B,
  ["unicodeslot"]=0x044B, -- ы
 },
 [0x044C]={
  ["adobename"]="afii10094",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicsftsn",
  ["description"]="CYRILLIC SMALL LETTER SOFT SIGN",
  ["linebreak"]="al",
  ["uccode"]=0x042C,
  ["unicodeslot"]=0x044C, -- ь
 },
 [0x044D]={
  ["adobename"]="afii10095",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicerev",
  ["description"]="CYRILLIC SMALL LETTER E",
  ["linebreak"]="al",
  ["uccode"]=0x042D,
  ["unicodeslot"]=0x044D, -- э
 },
 [0x044E]={
  ["adobename"]="afii10096",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicyu",
  ["description"]="CYRILLIC SMALL LETTER YU",
  ["linebreak"]="al",
  ["uccode"]=0x042E,
  ["unicodeslot"]=0x044E, -- ю
 },
 [0x044F]={
  ["adobename"]="afii10097",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicya",
  ["description"]="CYRILLIC SMALL LETTER YA",
  ["linebreak"]="al",
  ["uccode"]=0x042F,
  ["unicodeslot"]=0x044F, -- я
 },
 [0x0450]={
  ["category"]="ll",
  ["contextname"]="cyrillicegrave",
  ["description"]="CYRILLIC SMALL LETTER IE WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0435,
  ["specials"]={ "char", 0x0435, 0x0300 },
  ["uccode"]=0x0400,
  ["unicodeslot"]=0x0450, -- ѐ
 },
 [0x0451]={
  ["adobename"]="afii10071",
  ["category"]="ll",
  ["cjkwd"]="a",
  ["contextname"]="cyrillicyo",
  ["description"]="CYRILLIC SMALL LETTER IO",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0435, 0x0308 },
  ["uccode"]=0x0401,
  ["unicodeslot"]=0x0451, -- ё
 },
 [0x0452]={
  ["adobename"]="afii10099",
  ["category"]="ll",
  ["contextname"]="cyrillicdje",
  ["description"]="CYRILLIC SMALL LETTER DJE",
  ["linebreak"]="al",
  ["uccode"]=0x0402,
  ["unicodeslot"]=0x0452, -- ђ
 },
 [0x0453]={
  ["adobename"]="afii10100",
  ["category"]="ll",
  ["contextname"]="cyrillicgje",
  ["description"]="CYRILLIC SMALL LETTER GJE",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0433, 0x0301 },
  ["uccode"]=0x0403,
  ["unicodeslot"]=0x0453, -- ѓ
 },
 [0x0454]={
  ["adobename"]="afii10101",
  ["category"]="ll",
  ["contextname"]="cyrillicie",
  ["description"]="CYRILLIC SMALL LETTER UKRAINIAN IE",
  ["linebreak"]="al",
  ["uccode"]=0x0404,
  ["unicodeslot"]=0x0454, -- є
 },
 [0x0455]={
  ["adobename"]="afii10102",
  ["category"]="ll",
  ["contextname"]="cyrillicdze",
  ["description"]="CYRILLIC SMALL LETTER DZE",
  ["linebreak"]="al",
  ["uccode"]=0x0405,
  ["unicodeslot"]=0x0455, -- ѕ
 },
 [0x0456]={
  ["adobename"]="afii10103",
  ["category"]="ll",
  ["contextname"]="cyrillicii",
  ["description"]="CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
  ["linebreak"]="al",
  ["uccode"]=0x0406,
  ["unicodeslot"]=0x0456, -- і
 },
 [0x0457]={
  ["adobename"]="afii10104",
  ["category"]="ll",
  ["contextname"]="cyrillicyi",
  ["description"]="CYRILLIC SMALL LETTER YI",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0456, 0x0308 },
  ["uccode"]=0x0407,
  ["unicodeslot"]=0x0457, -- ї
 },
 [0x0458]={
  ["adobename"]="afii10105",
  ["category"]="ll",
  ["contextname"]="cyrillicje",
  ["description"]="CYRILLIC SMALL LETTER JE",
  ["linebreak"]="al",
  ["uccode"]=0x0408,
  ["unicodeslot"]=0x0458, -- ј
 },
 [0x0459]={
  ["adobename"]="afii10106",
  ["category"]="ll",
  ["contextname"]="cyrilliclje",
  ["description"]="CYRILLIC SMALL LETTER LJE",
  ["linebreak"]="al",
  ["uccode"]=0x0409,
  ["unicodeslot"]=0x0459, -- љ
 },
 [0x045A]={
  ["adobename"]="afii10107",
  ["category"]="ll",
  ["contextname"]="cyrillicnje",
  ["description"]="CYRILLIC SMALL LETTER NJE",
  ["linebreak"]="al",
  ["uccode"]=0x040A,
  ["unicodeslot"]=0x045A, -- њ
 },
 [0x045B]={
  ["adobename"]="afii10108",
  ["category"]="ll",
  ["contextname"]="cyrillictshe",
  ["description"]="CYRILLIC SMALL LETTER TSHE",
  ["linebreak"]="al",
  ["uccode"]=0x040B,
  ["unicodeslot"]=0x045B, -- ћ
 },
 [0x045C]={
  ["adobename"]="afii10109",
  ["category"]="ll",
  ["contextname"]="cyrillickje",
  ["description"]="CYRILLIC SMALL LETTER KJE",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x043A, 0x0301 },
  ["uccode"]=0x040C,
  ["unicodeslot"]=0x045C, -- ќ
 },
 [0x045D]={
  ["category"]="ll",
  ["contextname"]="cyrillicigrave",
  ["description"]="CYRILLIC SMALL LETTER I WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0438,
  ["specials"]={ "char", 0x0438, 0x0300 },
  ["uccode"]=0x040D,
  ["unicodeslot"]=0x045D, -- ѝ
 },
 [0x045E]={
  ["adobename"]="afii10110",
  ["category"]="ll",
  ["contextname"]="cyrillicushrt",
  ["description"]="CYRILLIC SMALL LETTER SHORT U",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0443, 0x0306 },
  ["uccode"]=0x040E,
  ["unicodeslot"]=0x045E, -- ў
 },
 [0x045F]={
  ["adobename"]="afii10193",
  ["category"]="ll",
  ["contextname"]="cyrillicdzhe",
  ["description"]="CYRILLIC SMALL LETTER DZHE",
  ["linebreak"]="al",
  ["uccode"]=0x040F,
  ["unicodeslot"]=0x045F, -- џ
 },
 [0x0460]={
  ["category"]="lu",
  ["contextname"]="cyrillicOMEGA",
  ["description"]="CYRILLIC CAPITAL LETTER OMEGA",
  ["lccode"]=0x0461,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0460, -- Ѡ
 },
 [0x0461]={
  ["category"]="ll",
  ["contextname"]="cyrillicomega",
  ["description"]="CYRILLIC SMALL LETTER OMEGA",
  ["linebreak"]="al",
  ["uccode"]=0x0460,
  ["unicodeslot"]=0x0461, -- ѡ
 },
 [0x0462]={
  ["adobename"]="afii10146",
  ["category"]="lu",
  ["contextname"]="cyrillicYAT",
  ["description"]="CYRILLIC CAPITAL LETTER YAT",
  ["lccode"]=0x0463,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0462, -- Ѣ
 },
 [0x0463]={
  ["adobename"]="afii10194",
  ["category"]="ll",
  ["contextname"]="cyrillicyat",
  ["description"]="CYRILLIC SMALL LETTER YAT",
  ["linebreak"]="al",
  ["uccode"]=0x0462,
  ["unicodeslot"]=0x0463, -- ѣ
 },
 [0x0464]={
  ["category"]="lu",
  ["contextname"]="cyrillicEiotified",
  ["description"]="CYRILLIC CAPITAL LETTER IOTIFIED E",
  ["lccode"]=0x0465,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0464, -- Ѥ
 },
 [0x0465]={
  ["category"]="ll",
  ["contextname"]="cyrilliceiotified",
  ["description"]="CYRILLIC SMALL LETTER IOTIFIED E",
  ["linebreak"]="al",
  ["uccode"]=0x0464,
  ["unicodeslot"]=0x0465, -- ѥ
 },
 [0x0466]={
  ["category"]="lu",
  ["contextname"]="cyrillicLITTLEYUS",
  ["description"]="CYRILLIC CAPITAL LETTER LITTLE YUS",
  ["lccode"]=0x0467,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0466, -- Ѧ
 },
 [0x0467]={
  ["category"]="ll",
  ["contextname"]="cyrilliclittleyus",
  ["description"]="CYRILLIC SMALL LETTER LITTLE YUS",
  ["linebreak"]="al",
  ["uccode"]=0x0466,
  ["unicodeslot"]=0x0467, -- ѧ
 },
 [0x0468]={
  ["category"]="lu",
  ["contextname"]="cyrillicLITTLEYUSiotified",
  ["description"]="CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS",
  ["lccode"]=0x0469,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0468, -- Ѩ
 },
 [0x0469]={
  ["category"]="ll",
  ["contextname"]="cyrilliclittleyusiotified",
  ["description"]="CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS",
  ["linebreak"]="al",
  ["uccode"]=0x0468,
  ["unicodeslot"]=0x0469, -- ѩ
 },
 [0x046A]={
  ["category"]="lu",
  ["contextname"]="cyrillicBIGYUS",
  ["description"]="CYRILLIC CAPITAL LETTER BIG YUS",
  ["lccode"]=0x046B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x046A, -- Ѫ
 },
 [0x046B]={
  ["category"]="ll",
  ["contextname"]="cyrillicbigyus",
  ["description"]="CYRILLIC SMALL LETTER BIG YUS",
  ["linebreak"]="al",
  ["uccode"]=0x046A,
  ["unicodeslot"]=0x046B, -- ѫ
 },
 [0x046C]={
  ["category"]="lu",
  ["contextname"]="cyrillicBIGYUSiotified",
  ["description"]="CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS",
  ["lccode"]=0x046D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x046C, -- Ѭ
 },
 [0x046D]={
  ["category"]="ll",
  ["contextname"]="cyrillicbigyusiotified",
  ["description"]="CYRILLIC SMALL LETTER IOTIFIED BIG YUS",
  ["linebreak"]="al",
  ["uccode"]=0x046C,
  ["unicodeslot"]=0x046D, -- ѭ
 },
 [0x046E]={
  ["category"]="lu",
  ["contextname"]="cyrillicKSI",
  ["description"]="CYRILLIC CAPITAL LETTER KSI",
  ["lccode"]=0x046F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x046E, -- Ѯ
 },
 [0x046F]={
  ["category"]="ll",
  ["contextname"]="cyrillicksi",
  ["description"]="CYRILLIC SMALL LETTER KSI",
  ["linebreak"]="al",
  ["uccode"]=0x046E,
  ["unicodeslot"]=0x046F, -- ѯ
 },
 [0x0470]={
  ["category"]="lu",
  ["contextname"]="cyrillicPSI",
  ["description"]="CYRILLIC CAPITAL LETTER PSI",
  ["lccode"]=0x0471,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0470, -- Ѱ
 },
 [0x0471]={
  ["category"]="ll",
  ["contextname"]="cyrillicpsi",
  ["description"]="CYRILLIC SMALL LETTER PSI",
  ["linebreak"]="al",
  ["uccode"]=0x0470,
  ["unicodeslot"]=0x0471, -- ѱ
 },
 [0x0472]={
  ["adobename"]="afii10147",
  ["category"]="lu",
  ["contextname"]="cyrillicFITA",
  ["description"]="CYRILLIC CAPITAL LETTER FITA",
  ["lccode"]=0x0473,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0472, -- Ѳ
 },
 [0x0473]={
  ["adobename"]="afii10195",
  ["category"]="ll",
  ["contextname"]="cyrillicfita",
  ["description"]="CYRILLIC SMALL LETTER FITA",
  ["linebreak"]="al",
  ["uccode"]=0x0472,
  ["unicodeslot"]=0x0473, -- ѳ
 },
 [0x0474]={
  ["adobename"]="afii10148",
  ["category"]="lu",
  ["contextname"]="cyrillicIZHITSA",
  ["description"]="CYRILLIC CAPITAL LETTER IZHITSA",
  ["lccode"]=0x0475,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0474, -- Ѵ
 },
 [0x0475]={
  ["adobename"]="afii10196",
  ["category"]="ll",
  ["contextname"]="cyrillicizhitsa",
  ["description"]="CYRILLIC SMALL LETTER IZHITSA",
  ["linebreak"]="al",
  ["uccode"]=0x0474,
  ["unicodeslot"]=0x0475, -- ѵ
 },
 [0x0476]={
  ["category"]="lu",
  ["contextname"]="cyrillicIZHITSAdoublegrave",
  ["description"]="CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
  ["lccode"]=0x0477,
  ["linebreak"]="al",
  ["shcode"]=0x0474,
  ["specials"]={ "char", 0x0474, 0x030F },
  ["unicodeslot"]=0x0476, -- Ѷ
 },
 [0x0477]={
  ["category"]="ll",
  ["contextname"]="cyrillicizhitsadoublegrave",
  ["description"]="CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
  ["linebreak"]="al",
  ["shcode"]=0x0475,
  ["specials"]={ "char", 0x0475, 0x030F },
  ["uccode"]=0x0476,
  ["unicodeslot"]=0x0477, -- ѷ
 },
 [0x0478]={
  ["category"]="lu",
  ["contextname"]="cyrillicUK",
  ["description"]="CYRILLIC CAPITAL LETTER UK",
  ["lccode"]=0x0479,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0478, -- Ѹ
 },
 [0x0479]={
  ["category"]="ll",
  ["contextname"]="cyrillicuk",
  ["description"]="CYRILLIC SMALL LETTER UK",
  ["linebreak"]="al",
  ["uccode"]=0x0478,
  ["unicodeslot"]=0x0479, -- ѹ
 },
 [0x047A]={
  ["category"]="lu",
  ["contextname"]="cyrillicOMEGAround",
  ["description"]="CYRILLIC CAPITAL LETTER ROUND OMEGA",
  ["lccode"]=0x047B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x047A, -- Ѻ
 },
 [0x047B]={
  ["category"]="ll",
  ["contextname"]="cyrillicomegaround",
  ["description"]="CYRILLIC SMALL LETTER ROUND OMEGA",
  ["linebreak"]="al",
  ["uccode"]=0x047A,
  ["unicodeslot"]=0x047B, -- ѻ
 },
 [0x047C]={
  ["category"]="lu",
  ["contextname"]="cyrillicOMEGAtitlo",
  ["description"]="CYRILLIC CAPITAL LETTER OMEGA WITH TITLO",
  ["lccode"]=0x047D,
  ["linebreak"]="al",
  ["shcode"]=0x0460,
  ["unicodeslot"]=0x047C, -- Ѽ
 },
 [0x047D]={
  ["category"]="ll",
  ["contextname"]="cyrillicomegatitlo",
  ["description"]="CYRILLIC SMALL LETTER OMEGA WITH TITLO",
  ["linebreak"]="al",
  ["shcode"]=0x0461,
  ["uccode"]=0x047C,
  ["unicodeslot"]=0x047D, -- ѽ
 },
 [0x047E]={
  ["category"]="lu",
  ["contextname"]="cyrillicOT",
  ["description"]="CYRILLIC CAPITAL LETTER OT",
  ["lccode"]=0x047F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x047E, -- Ѿ
 },
 [0x047F]={
  ["category"]="ll",
  ["contextname"]="cyrillicot",
  ["description"]="CYRILLIC SMALL LETTER OT",
  ["linebreak"]="al",
  ["uccode"]=0x047E,
  ["unicodeslot"]=0x047F, -- ѿ
 },
 [0x0480]={
  ["category"]="lu",
  ["contextname"]="cyrillicKOPPA",
  ["description"]="CYRILLIC CAPITAL LETTER KOPPA",
  ["lccode"]=0x0481,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0480, -- Ҁ
 },
 [0x0481]={
  ["category"]="ll",
  ["contextname"]="cyrillickoppa",
  ["description"]="CYRILLIC SMALL LETTER KOPPA",
  ["linebreak"]="al",
  ["uccode"]=0x0480,
  ["unicodeslot"]=0x0481, -- ҁ
 },
 [0x0482]={
  ["category"]="so",
  ["description"]="CYRILLIC THOUSANDS SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0482, -- ҂
 },
 [0x0483]={
  ["category"]="mn",
  ["contextname"]="cyrillicTITLO",
  ["description"]="COMBINING CYRILLIC TITLO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0483, -- ҃
 },
 [0x0484]={
  ["category"]="mn",
  ["contextname"]="cyrillicPALATALIZATION",
  ["description"]="COMBINING CYRILLIC PALATALIZATION",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0484, -- ҄
 },
 [0x0485]={
  ["category"]="mn",
  ["contextname"]="cyrillicDASIAPNEUMATA",
  ["description"]="COMBINING CYRILLIC DASIA PNEUMATA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0485, -- ҅
 },
 [0x0486]={
  ["category"]="mn",
  ["contextname"]="cyrillicPSILIPNEUMATA",
  ["description"]="COMBINING CYRILLIC PSILI PNEUMATA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0486, -- ҆
 },
 [0x0488]={
  ["category"]="me",
  ["description"]="COMBINING CYRILLIC HUNDRED THOUSANDS SIGN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0488, -- ҈
 },
 [0x0489]={
  ["category"]="me",
  ["description"]="COMBINING CYRILLIC MILLIONS SIGN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0489, -- ҉
 },
 [0x048A]={
  ["category"]="lu",
  ["contextname"]="cyrillicISHRTtail",
  ["description"]="CYRILLIC CAPITAL LETTER SHORT I WITH TAIL",
  ["lccode"]=0x048B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x048A, -- Ҋ
 },
 [0x048B]={
  ["category"]="ll",
  ["contextname"]="cyrillicishrttail",
  ["description"]="CYRILLIC SMALL LETTER SHORT I WITH TAIL",
  ["linebreak"]="al",
  ["uccode"]=0x048A,
  ["unicodeslot"]=0x048B, -- ҋ
 },
 [0x048C]={
  ["category"]="lu",
  ["contextname"]="cyrillicSEMISOFT",
  ["description"]="CYRILLIC CAPITAL LETTER SEMISOFT SIGN",
  ["lccode"]=0x048D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x048C, -- Ҍ
 },
 [0x048D]={
  ["category"]="ll",
  ["contextname"]="cyrillicsemisoft",
  ["description"]="CYRILLIC SMALL LETTER SEMISOFT SIGN",
  ["linebreak"]="al",
  ["uccode"]=0x048C,
  ["unicodeslot"]=0x048D, -- ҍ
 },
 [0x048E]={
  ["category"]="lu",
  ["contextname"]="cyrillicERtick",
  ["description"]="CYRILLIC CAPITAL LETTER ER WITH TICK",
  ["lccode"]=0x048F,
  ["linebreak"]="al",
  ["shcode"]=0x0420,
  ["unicodeslot"]=0x048E, -- Ҏ
 },
 [0x048F]={
  ["category"]="ll",
  ["contextname"]="cyrillicertick",
  ["description"]="CYRILLIC SMALL LETTER ER WITH TICK",
  ["linebreak"]="al",
  ["shcode"]=0x0440,
  ["uccode"]=0x048E,
  ["unicodeslot"]=0x048F, -- ҏ
 },
 [0x0490]={
  ["adobename"]="afii10050",
  ["category"]="lu",
  ["contextname"]="cyrillicGHEupturn",
  ["description"]="CYRILLIC CAPITAL LETTER GHE WITH UPTURN",
  ["lccode"]=0x0491,
  ["linebreak"]="al",
  ["shcode"]=0x0413,
  ["unicodeslot"]=0x0490, -- Ґ
 },
 [0x0491]={
  ["adobename"]="afii10098",
  ["category"]="ll",
  ["contextname"]="cyrillicgheupturn",
  ["description"]="CYRILLIC SMALL LETTER GHE WITH UPTURN",
  ["linebreak"]="al",
  ["shcode"]=0x0433,
  ["uccode"]=0x0490,
  ["unicodeslot"]=0x0491, -- ґ
 },
 [0x0492]={
  ["category"]="lu",
  ["contextname"]="cyrillicGHEstroke",
  ["description"]="CYRILLIC CAPITAL LETTER GHE WITH STROKE",
  ["lccode"]=0x0493,
  ["linebreak"]="al",
  ["shcode"]=0x0413,
  ["unicodeslot"]=0x0492, -- Ғ
 },
 [0x0493]={
  ["category"]="ll",
  ["contextname"]="cyrillicghestroke",
  ["description"]="CYRILLIC SMALL LETTER GHE WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0433,
  ["uccode"]=0x0492,
  ["unicodeslot"]=0x0493, -- ғ
 },
 [0x0494]={
  ["category"]="lu",
  ["contextname"]="cyrillicGHEmidhook",
  ["description"]="CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK",
  ["lccode"]=0x0495,
  ["linebreak"]="al",
  ["shcode"]=0x0413,
  ["unicodeslot"]=0x0494, -- Ҕ
 },
 [0x0495]={
  ["category"]="ll",
  ["contextname"]="cyrillicghemidhook",
  ["description"]="CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0433,
  ["uccode"]=0x0494,
  ["unicodeslot"]=0x0495, -- ҕ
 },
 [0x0496]={
  ["category"]="lu",
  ["contextname"]="cyrillicZHEdescender",
  ["description"]="CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER",
  ["lccode"]=0x0497,
  ["linebreak"]="al",
  ["shcode"]=0x0416,
  ["unicodeslot"]=0x0496, -- Җ
 },
 [0x0497]={
  ["category"]="ll",
  ["contextname"]="cyrilliczhedescender",
  ["description"]="CYRILLIC SMALL LETTER ZHE WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x0436,
  ["uccode"]=0x0496,
  ["unicodeslot"]=0x0497, -- җ
 },
 [0x0498]={
  ["category"]="lu",
  ["contextname"]="cyrillicZDSC",
  ["description"]="CYRILLIC CAPITAL LETTER ZE WITH DESCENDER",
  ["lccode"]=0x0499,
  ["linebreak"]="al",
  ["shcode"]=0x0417,
  ["unicodeslot"]=0x0498, -- Ҙ
 },
 [0x0499]={
  ["category"]="ll",
  ["contextname"]="cyrilliczdsc",
  ["description"]="CYRILLIC SMALL LETTER ZE WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x0437,
  ["uccode"]=0x0498,
  ["unicodeslot"]=0x0499, -- ҙ
 },
 [0x049A]={
  ["category"]="lu",
  ["contextname"]="cyrillicKADC",
  ["description"]="CYRILLIC CAPITAL LETTER KA WITH DESCENDER",
  ["lccode"]=0x049B,
  ["linebreak"]="al",
  ["shcode"]=0x041A,
  ["unicodeslot"]=0x049A, -- Қ
 },
 [0x049B]={
  ["category"]="ll",
  ["contextname"]="cyrillickadc",
  ["description"]="CYRILLIC SMALL LETTER KA WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x043A,
  ["uccode"]=0x049A,
  ["unicodeslot"]=0x049B, -- қ
 },
 [0x049C]={
  ["category"]="lu",
  ["contextname"]="cyrillicKAvertstroke",
  ["description"]="CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE",
  ["lccode"]=0x049D,
  ["linebreak"]="al",
  ["shcode"]=0x041A,
  ["unicodeslot"]=0x049C, -- Ҝ
 },
 [0x049D]={
  ["category"]="ll",
  ["contextname"]="cyrillickavertstroke",
  ["description"]="CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x043A,
  ["uccode"]=0x049C,
  ["unicodeslot"]=0x049D, -- ҝ
 },
 [0x049E]={
  ["category"]="lu",
  ["contextname"]="cyrillicKAstroke",
  ["description"]="CYRILLIC CAPITAL LETTER KA WITH STROKE",
  ["lccode"]=0x049F,
  ["linebreak"]="al",
  ["shcode"]=0x041A,
  ["unicodeslot"]=0x049E, -- Ҟ
 },
 [0x049F]={
  ["category"]="ll",
  ["contextname"]="cyrillickastroke",
  ["description"]="CYRILLIC SMALL LETTER KA WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x043A,
  ["uccode"]=0x049E,
  ["unicodeslot"]=0x049F, -- ҟ
 },
 [0x04A0]={
  ["category"]="lu",
  ["contextname"]="cyrillicKAbashkir",
  ["description"]="CYRILLIC CAPITAL LETTER BASHKIR KA",
  ["lccode"]=0x04A1,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04A0, -- Ҡ
 },
 [0x04A1]={
  ["category"]="ll",
  ["contextname"]="cyrillickabashkir",
  ["description"]="CYRILLIC SMALL LETTER BASHKIR KA",
  ["linebreak"]="al",
  ["uccode"]=0x04A0,
  ["unicodeslot"]=0x04A1, -- ҡ
 },
 [0x04A2]={
  ["category"]="lu",
  ["contextname"]="cyrillicENDC",
  ["description"]="CYRILLIC CAPITAL LETTER EN WITH DESCENDER",
  ["lccode"]=0x04A3,
  ["linebreak"]="al",
  ["shcode"]=0x041D,
  ["unicodeslot"]=0x04A2, -- Ң
 },
 [0x04A3]={
  ["category"]="ll",
  ["contextname"]="cyrillicendc",
  ["description"]="CYRILLIC SMALL LETTER EN WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x043D,
  ["uccode"]=0x04A2,
  ["unicodeslot"]=0x04A3, -- ң
 },
 [0x04A4]={
  ["category"]="lu",
  ["contextname"]="cyrillicENGHE",
  ["description"]="CYRILLIC CAPITAL LIGATURE EN GHE",
  ["lccode"]=0x04A5,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04A4, -- Ҥ
 },
 [0x04A5]={
  ["category"]="ll",
  ["contextname"]="cyrillicenghe",
  ["description"]="CYRILLIC SMALL LIGATURE EN GHE",
  ["linebreak"]="al",
  ["uccode"]=0x04A4,
  ["unicodeslot"]=0x04A5, -- ҥ
 },
 [0x04A6]={
  ["category"]="lu",
  ["contextname"]="cyrillicPEmidhook",
  ["description"]="CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK",
  ["lccode"]=0x04A7,
  ["linebreak"]="al",
  ["shcode"]=0x041F,
  ["unicodeslot"]=0x04A6, -- Ҧ
 },
 [0x04A7]={
  ["category"]="ll",
  ["contextname"]="cyrillicpemidhook",
  ["description"]="CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x043F,
  ["uccode"]=0x04A6,
  ["unicodeslot"]=0x04A7, -- ҧ
 },
 [0x04A8]={
  ["category"]="lu",
  ["contextname"]="cyrillicHA",
  ["description"]="CYRILLIC CAPITAL LETTER ABKHASIAN HA",
  ["lccode"]=0x04A9,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04A8, -- Ҩ
 },
 [0x04A9]={
  ["category"]="ll",
  ["contextname"]="cyrillicha",
  ["description"]="CYRILLIC SMALL LETTER ABKHASIAN HA",
  ["linebreak"]="al",
  ["uccode"]=0x04A8,
  ["unicodeslot"]=0x04A9, -- ҩ
 },
 [0x04AA]={
  ["category"]="lu",
  ["contextname"]="cyrillicSDSC",
  ["description"]="CYRILLIC CAPITAL LETTER ES WITH DESCENDER",
  ["lccode"]=0x04AB,
  ["linebreak"]="al",
  ["shcode"]=0x0421,
  ["unicodeslot"]=0x04AA, -- Ҫ
 },
 [0x04AB]={
  ["category"]="ll",
  ["contextname"]="cyrillicsdsc",
  ["description"]="CYRILLIC SMALL LETTER ES WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x0441,
  ["uccode"]=0x04AA,
  ["unicodeslot"]=0x04AB, -- ҫ
 },
 [0x04AC]={
  ["category"]="lu",
  ["contextname"]="cyrillicTEDC",
  ["description"]="CYRILLIC CAPITAL LETTER TE WITH DESCENDER",
  ["lccode"]=0x04AD,
  ["linebreak"]="al",
  ["shcode"]=0x0422,
  ["unicodeslot"]=0x04AC, -- Ҭ
 },
 [0x04AD]={
  ["category"]="ll",
  ["contextname"]="cyrillictedc",
  ["description"]="CYRILLIC SMALL LETTER TE WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x0442,
  ["uccode"]=0x04AC,
  ["unicodeslot"]=0x04AD, -- ҭ
 },
 [0x04AE]={
  ["category"]="lu",
  ["contextname"]="cyrillicYstr",
  ["description"]="CYRILLIC CAPITAL LETTER STRAIGHT U",
  ["lccode"]=0x04AF,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04AE, -- Ү
 },
 [0x04AF]={
  ["category"]="ll",
  ["contextname"]="cyrillicystr",
  ["description"]="CYRILLIC SMALL LETTER STRAIGHT U",
  ["linebreak"]="al",
  ["uccode"]=0x04AE,
  ["unicodeslot"]=0x04AF, -- ү
 },
 [0x04B0]={
  ["category"]="lu",
  ["contextname"]="cyrillicYstrstroke",
  ["description"]="CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE",
  ["lccode"]=0x04B1,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04B0, -- Ұ
 },
 [0x04B1]={
  ["category"]="ll",
  ["contextname"]="cyrillicystrstroke",
  ["description"]="CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE",
  ["linebreak"]="al",
  ["uccode"]=0x04B0,
  ["unicodeslot"]=0x04B1, -- ұ
 },
 [0x04B2]={
  ["category"]="lu",
  ["contextname"]="cyrillicHADC",
  ["description"]="CYRILLIC CAPITAL LETTER HA WITH DESCENDER",
  ["lccode"]=0x04B3,
  ["linebreak"]="al",
  ["shcode"]=0x0425,
  ["unicodeslot"]=0x04B2, -- Ҳ
 },
 [0x04B3]={
  ["category"]="ll",
  ["contextname"]="cyrillichadc",
  ["description"]="CYRILLIC SMALL LETTER HA WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x0445,
  ["uccode"]=0x04B2,
  ["unicodeslot"]=0x04B3, -- ҳ
 },
 [0x04B4]={
  ["category"]="lu",
  ["contextname"]="cyrillicTETSE",
  ["description"]="CYRILLIC CAPITAL LIGATURE TE TSE",
  ["lccode"]=0x04B5,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04B4, -- Ҵ
 },
 [0x04B5]={
  ["category"]="ll",
  ["contextname"]="cyrillictetse",
  ["description"]="CYRILLIC SMALL LIGATURE TE TSE",
  ["linebreak"]="al",
  ["uccode"]=0x04B4,
  ["unicodeslot"]=0x04B5, -- ҵ
 },
 [0x04B6]={
  ["category"]="lu",
  ["contextname"]="cyrillicCHEDC",
  ["description"]="CYRILLIC CAPITAL LETTER CHE WITH DESCENDER",
  ["lccode"]=0x04B7,
  ["linebreak"]="al",
  ["shcode"]=0x0427,
  ["unicodeslot"]=0x04B6, -- Ҷ
 },
 [0x04B7]={
  ["category"]="ll",
  ["contextname"]="cyrillicchedc",
  ["description"]="CYRILLIC SMALL LETTER CHE WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x0447,
  ["uccode"]=0x04B6,
  ["unicodeslot"]=0x04B7, -- ҷ
 },
 [0x04B8]={
  ["category"]="lu",
  ["contextname"]="cyrillicCHEvertstroke",
  ["description"]="CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE",
  ["lccode"]=0x04B9,
  ["linebreak"]="al",
  ["shcode"]=0x0427,
  ["unicodeslot"]=0x04B8, -- Ҹ
 },
 [0x04B9]={
  ["category"]="ll",
  ["contextname"]="cyrillicchevertstroke",
  ["description"]="CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0447,
  ["uccode"]=0x04B8,
  ["unicodeslot"]=0x04B9, -- ҹ
 },
 [0x04BA]={
  ["category"]="lu",
  ["contextname"]="cyrillicSHHA",
  ["description"]="CYRILLIC CAPITAL LETTER SHHA",
  ["lccode"]=0x04BB,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04BA, -- Һ
 },
 [0x04BB]={
  ["category"]="ll",
  ["contextname"]="cyrillicshha",
  ["description"]="CYRILLIC SMALL LETTER SHHA",
  ["linebreak"]="al",
  ["uccode"]=0x04BA,
  ["unicodeslot"]=0x04BB, -- һ
 },
 [0x04BC]={
  ["category"]="lu",
  ["contextname"]="cyrillicCHEabkhasian",
  ["description"]="CYRILLIC CAPITAL LETTER ABKHASIAN CHE",
  ["lccode"]=0x04BD,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04BC, -- Ҽ
 },
 [0x04BD]={
  ["category"]="ll",
  ["contextname"]="cyrilliccheabkhasian",
  ["description"]="CYRILLIC SMALL LETTER ABKHASIAN CHE",
  ["linebreak"]="al",
  ["uccode"]=0x04BC,
  ["unicodeslot"]=0x04BD, -- ҽ
 },
 [0x04BE]={
  ["category"]="lu",
  ["contextname"]="cyrillicCHEDCabkhasian",
  ["description"]="CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER",
  ["lccode"]=0x04BF,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04BE, -- Ҿ
 },
 [0x04BF]={
  ["category"]="ll",
  ["contextname"]="cyrillicchedcabkhasian",
  ["description"]="CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER",
  ["linebreak"]="al",
  ["uccode"]=0x04BE,
  ["unicodeslot"]=0x04BF, -- ҿ
 },
 [0x04C0]={
  ["category"]="lu",
  ["contextname"]="cyrillicPALOCHKA",
  ["description"]="CYRILLIC LETTER PALOCHKA",
  ["lccode"]=0x04CF,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04C0, -- Ӏ
 },
 [0x04C1]={
  ["category"]="lu",
  ["contextname"]="cyrillicZHEbreve",
  ["description"]="CYRILLIC CAPITAL LETTER ZHE WITH BREVE",
  ["lccode"]=0x04C2,
  ["linebreak"]="al",
  ["shcode"]=0x0416,
  ["specials"]={ "char", 0x0416, 0x0306 },
  ["unicodeslot"]=0x04C1, -- Ӂ
 },
 [0x04C2]={
  ["category"]="ll",
  ["contextname"]="cyrilliczhebreve",
  ["description"]="CYRILLIC SMALL LETTER ZHE WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0436,
  ["specials"]={ "char", 0x0436, 0x0306 },
  ["uccode"]=0x04C1,
  ["unicodeslot"]=0x04C2, -- ӂ
 },
 [0x04C3]={
  ["category"]="lu",
  ["contextname"]="cyrillicKAhook",
  ["description"]="CYRILLIC CAPITAL LETTER KA WITH HOOK",
  ["lccode"]=0x04C4,
  ["linebreak"]="al",
  ["shcode"]=0x041A,
  ["unicodeslot"]=0x04C3, -- Ӄ
 },
 [0x04C4]={
  ["category"]="ll",
  ["contextname"]="cyrillickahook",
  ["description"]="CYRILLIC SMALL LETTER KA WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x043A,
  ["uccode"]=0x04C3,
  ["unicodeslot"]=0x04C4, -- ӄ
 },
 [0x04C5]={
  ["category"]="lu",
  ["contextname"]="cyrillicELtail",
  ["description"]="CYRILLIC CAPITAL LETTER EL WITH TAIL",
  ["lccode"]=0x04C6,
  ["linebreak"]="al",
  ["shcode"]=0x041B,
  ["unicodeslot"]=0x04C5, -- Ӆ
 },
 [0x04C6]={
  ["category"]="ll",
  ["contextname"]="cyrilliceltail",
  ["description"]="CYRILLIC SMALL LETTER EL WITH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x043B,
  ["uccode"]=0x04C5,
  ["unicodeslot"]=0x04C6, -- ӆ
 },
 [0x04C7]={
  ["category"]="lu",
  ["contextname"]="cyrillicENhook",
  ["description"]="CYRILLIC CAPITAL LETTER EN WITH HOOK",
  ["lccode"]=0x04C8,
  ["linebreak"]="al",
  ["shcode"]=0x041D,
  ["unicodeslot"]=0x04C7, -- Ӈ
 },
 [0x04C8]={
  ["category"]="ll",
  ["contextname"]="cyrillicenhook",
  ["description"]="CYRILLIC SMALL LETTER EN WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x043D,
  ["uccode"]=0x04C7,
  ["unicodeslot"]=0x04C8, -- ӈ
 },
 [0x04C9]={
  ["category"]="lu",
  ["contextname"]="cyrillicENtail",
  ["description"]="CYRILLIC CAPITAL LETTER EN WITH TAIL",
  ["lccode"]=0x04CA,
  ["linebreak"]="al",
  ["shcode"]=0x041D,
  ["unicodeslot"]=0x04C9, -- Ӊ
 },
 [0x04CA]={
  ["category"]="ll",
  ["contextname"]="cyrillicentail",
  ["description"]="CYRILLIC SMALL LETTER EN WITH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x043D,
  ["uccode"]=0x04C9,
  ["unicodeslot"]=0x04CA, -- ӊ
 },
 [0x04CB]={
  ["category"]="lu",
  ["contextname"]="cyrillicCHEkhakassian",
  ["description"]="CYRILLIC CAPITAL LETTER KHAKASSIAN CHE",
  ["lccode"]=0x04CC,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04CB, -- Ӌ
 },
 [0x04CC]={
  ["category"]="ll",
  ["contextname"]="cyrillicchekhakassian",
  ["description"]="CYRILLIC SMALL LETTER KHAKASSIAN CHE",
  ["linebreak"]="al",
  ["uccode"]=0x04CB,
  ["unicodeslot"]=0x04CC, -- ӌ
 },
 [0x04CD]={
  ["category"]="lu",
  ["contextname"]="cyrillicEMtail",
  ["description"]="CYRILLIC CAPITAL LETTER EM WITH TAIL",
  ["lccode"]=0x04CE,
  ["linebreak"]="al",
  ["shcode"]=0x041C,
  ["unicodeslot"]=0x04CD, -- Ӎ
 },
 [0x04CE]={
  ["category"]="ll",
  ["contextname"]="cyrillicemtail",
  ["description"]="CYRILLIC SMALL LETTER EM WITH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x043C,
  ["uccode"]=0x04CD,
  ["unicodeslot"]=0x04CE, -- ӎ
 },
 [0x04CF]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER PALOCHKA",
  ["linebreak"]="al",
  ["uccode"]=0x04C0,
  ["unicodeslot"]=0x04CF, -- ӏ
 },
 [0x04D0]={
  ["category"]="lu",
  ["contextname"]="cyrillicAbreve",
  ["description"]="CYRILLIC CAPITAL LETTER A WITH BREVE",
  ["lccode"]=0x04D1,
  ["linebreak"]="al",
  ["shcode"]=0x0410,
  ["specials"]={ "char", 0x0410, 0x0306 },
  ["unicodeslot"]=0x04D0, -- Ӑ
 },
 [0x04D1]={
  ["category"]="ll",
  ["contextname"]="cyrillicabreve",
  ["description"]="CYRILLIC SMALL LETTER A WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0430,
  ["specials"]={ "char", 0x0430, 0x0306 },
  ["uccode"]=0x04D0,
  ["unicodeslot"]=0x04D1, -- ӑ
 },
 [0x04D2]={
  ["category"]="lu",
  ["contextname"]="cyrillicAdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER A WITH DIAERESIS",
  ["lccode"]=0x04D3,
  ["linebreak"]="al",
  ["shcode"]=0x0410,
  ["specials"]={ "char", 0x0410, 0x0308 },
  ["unicodeslot"]=0x04D2, -- Ӓ
 },
 [0x04D3]={
  ["category"]="ll",
  ["contextname"]="cyrillicadiaeresis",
  ["description"]="CYRILLIC SMALL LETTER A WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0430,
  ["specials"]={ "char", 0x0430, 0x0308 },
  ["uccode"]=0x04D2,
  ["unicodeslot"]=0x04D3, -- ӓ
 },
 [0x04D4]={
  ["category"]="lu",
  ["contextname"]="cyrillicAE",
  ["description"]="CYRILLIC CAPITAL LIGATURE A IE",
  ["lccode"]=0x04D5,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04D4, -- Ӕ
 },
 [0x04D5]={
  ["category"]="ll",
  ["contextname"]="cyrillicae",
  ["description"]="CYRILLIC SMALL LIGATURE A IE",
  ["linebreak"]="al",
  ["uccode"]=0x04D4,
  ["unicodeslot"]=0x04D5, -- ӕ
 },
 [0x04D6]={
  ["category"]="lu",
  ["contextname"]="cyrillicEbreve",
  ["description"]="CYRILLIC CAPITAL LETTER IE WITH BREVE",
  ["lccode"]=0x04D7,
  ["linebreak"]="al",
  ["shcode"]=0x0415,
  ["specials"]={ "char", 0x0415, 0x0306 },
  ["unicodeslot"]=0x04D6, -- Ӗ
 },
 [0x04D7]={
  ["category"]="ll",
  ["contextname"]="cyrillicebreve",
  ["description"]="CYRILLIC SMALL LETTER IE WITH BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0435,
  ["specials"]={ "char", 0x0435, 0x0306 },
  ["uccode"]=0x04D6,
  ["unicodeslot"]=0x04D7, -- ӗ
 },
 [0x04D8]={
  ["category"]="lu",
  ["contextname"]="cyrillicSCHWA",
  ["description"]="CYRILLIC CAPITAL LETTER SCHWA",
  ["lccode"]=0x04D9,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04D8, -- Ә
 },
 [0x04D9]={
  ["adobename"]="afii10846",
  ["category"]="ll",
  ["contextname"]="cyrillicschwa",
  ["description"]="CYRILLIC SMALL LETTER SCHWA",
  ["linebreak"]="al",
  ["uccode"]=0x04D8,
  ["unicodeslot"]=0x04D9, -- ә
 },
 [0x04DA]={
  ["category"]="lu",
  ["contextname"]="cyrillicSCHWAdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS",
  ["lccode"]=0x04DB,
  ["linebreak"]="al",
  ["shcode"]=0x04D8,
  ["specials"]={ "char", 0x04D8, 0x0308 },
  ["unicodeslot"]=0x04DA, -- Ӛ
 },
 [0x04DB]={
  ["category"]="ll",
  ["contextname"]="cyrillicschwadiaeresis",
  ["description"]="CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x04D9,
  ["specials"]={ "char", 0x04D9, 0x0308 },
  ["uccode"]=0x04DA,
  ["unicodeslot"]=0x04DB, -- ӛ
 },
 [0x04DC]={
  ["category"]="lu",
  ["contextname"]="cyrillicZHEdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS",
  ["lccode"]=0x04DD,
  ["linebreak"]="al",
  ["shcode"]=0x0416,
  ["specials"]={ "char", 0x0416, 0x0308 },
  ["unicodeslot"]=0x04DC, -- Ӝ
 },
 [0x04DD]={
  ["category"]="ll",
  ["contextname"]="cyrilliczhediaeresis",
  ["description"]="CYRILLIC SMALL LETTER ZHE WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0436,
  ["specials"]={ "char", 0x0436, 0x0308 },
  ["uccode"]=0x04DC,
  ["unicodeslot"]=0x04DD, -- ӝ
 },
 [0x04DE]={
  ["category"]="lu",
  ["contextname"]="cyrillicZEdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS",
  ["lccode"]=0x04DF,
  ["linebreak"]="al",
  ["shcode"]=0x0417,
  ["specials"]={ "char", 0x0417, 0x0308 },
  ["unicodeslot"]=0x04DE, -- Ӟ
 },
 [0x04DF]={
  ["category"]="ll",
  ["contextname"]="cyrilliczediaeresis",
  ["description"]="CYRILLIC SMALL LETTER ZE WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0437,
  ["specials"]={ "char", 0x0437, 0x0308 },
  ["uccode"]=0x04DE,
  ["unicodeslot"]=0x04DF, -- ӟ
 },
 [0x04E0]={
  ["category"]="lu",
  ["contextname"]="cyrillicDZEabkhasian",
  ["description"]="CYRILLIC CAPITAL LETTER ABKHASIAN DZE",
  ["lccode"]=0x04E1,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04E0, -- Ӡ
 },
 [0x04E1]={
  ["category"]="ll",
  ["contextname"]="cyrillicdzeabkhasian",
  ["description"]="CYRILLIC SMALL LETTER ABKHASIAN DZE",
  ["linebreak"]="al",
  ["uccode"]=0x04E0,
  ["unicodeslot"]=0x04E1, -- ӡ
 },
 [0x04E2]={
  ["category"]="lu",
  ["contextname"]="cyrillicImacron",
  ["description"]="CYRILLIC CAPITAL LETTER I WITH MACRON",
  ["lccode"]=0x04E3,
  ["linebreak"]="al",
  ["shcode"]=0x0418,
  ["specials"]={ "char", 0x0418, 0x0304 },
  ["unicodeslot"]=0x04E2, -- Ӣ
 },
 [0x04E3]={
  ["category"]="ll",
  ["contextname"]="cyrillicimacron",
  ["description"]="CYRILLIC SMALL LETTER I WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0438,
  ["specials"]={ "char", 0x0438, 0x0304 },
  ["uccode"]=0x04E2,
  ["unicodeslot"]=0x04E3, -- ӣ
 },
 [0x04E4]={
  ["category"]="lu",
  ["contextname"]="cyrillicIdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER I WITH DIAERESIS",
  ["lccode"]=0x04E5,
  ["linebreak"]="al",
  ["shcode"]=0x0418,
  ["specials"]={ "char", 0x0418, 0x0308 },
  ["unicodeslot"]=0x04E4, -- Ӥ
 },
 [0x04E5]={
  ["category"]="ll",
  ["contextname"]="cyrillicidiaeresis",
  ["description"]="CYRILLIC SMALL LETTER I WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0438,
  ["specials"]={ "char", 0x0438, 0x0308 },
  ["uccode"]=0x04E4,
  ["unicodeslot"]=0x04E5, -- ӥ
 },
 [0x04E6]={
  ["category"]="lu",
  ["contextname"]="cyrillicOdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER O WITH DIAERESIS",
  ["lccode"]=0x04E7,
  ["linebreak"]="al",
  ["shcode"]=0x041E,
  ["specials"]={ "char", 0x041E, 0x0308 },
  ["unicodeslot"]=0x04E6, -- Ӧ
 },
 [0x04E7]={
  ["category"]="ll",
  ["contextname"]="cyrillicodiaeresis",
  ["description"]="CYRILLIC SMALL LETTER O WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x043E,
  ["specials"]={ "char", 0x043E, 0x0308 },
  ["uccode"]=0x04E6,
  ["unicodeslot"]=0x04E7, -- ӧ
 },
 [0x04E8]={
  ["category"]="lu",
  ["contextname"]="cyrillicObarred",
  ["description"]="CYRILLIC CAPITAL LETTER BARRED O",
  ["lccode"]=0x04E9,
  ["linebreak"]="al",
  ["unicodeslot"]=0x04E8, -- Ө
 },
 [0x04E9]={
  ["category"]="ll",
  ["contextname"]="cyrillicobarred",
  ["description"]="CYRILLIC SMALL LETTER BARRED O",
  ["linebreak"]="al",
  ["uccode"]=0x04E8,
  ["unicodeslot"]=0x04E9, -- ө
 },
 [0x04EA]={
  ["category"]="lu",
  ["contextname"]="cyrillicObarreddiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS",
  ["lccode"]=0x04EB,
  ["linebreak"]="al",
  ["specials"]={ "char", 0x04E8, 0x0308 },
  ["unicodeslot"]=0x04EA, -- Ӫ
 },
 [0x04EB]={
  ["category"]="ll",
  ["contextname"]="cyrillicobarreddiaeresis",
  ["description"]="CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x04E9, 0x0308 },
  ["uccode"]=0x04EA,
  ["unicodeslot"]=0x04EB, -- ӫ
 },
 [0x04EC]={
  ["category"]="lu",
  ["contextname"]="cyrillicEdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER E WITH DIAERESIS",
  ["lccode"]=0x04ED,
  ["linebreak"]="al",
  ["shcode"]=0x042D,
  ["specials"]={ "char", 0x042D, 0x0308 },
  ["unicodeslot"]=0x04EC, -- Ӭ
 },
 [0x04ED]={
  ["category"]="ll",
  ["contextname"]="cyrillicediaeresis",
  ["description"]="CYRILLIC SMALL LETTER E WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x044D,
  ["specials"]={ "char", 0x044D, 0x0308 },
  ["uccode"]=0x04EC,
  ["unicodeslot"]=0x04ED, -- ӭ
 },
 [0x04EE]={
  ["category"]="lu",
  ["contextname"]="cyrillicUmacron",
  ["description"]="CYRILLIC CAPITAL LETTER U WITH MACRON",
  ["lccode"]=0x04EF,
  ["linebreak"]="al",
  ["shcode"]=0x0423,
  ["specials"]={ "char", 0x0423, 0x0304 },
  ["unicodeslot"]=0x04EE, -- Ӯ
 },
 [0x04EF]={
  ["category"]="ll",
  ["contextname"]="cyrillicumacron",
  ["description"]="CYRILLIC SMALL LETTER U WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0443,
  ["specials"]={ "char", 0x0443, 0x0304 },
  ["uccode"]=0x04EE,
  ["unicodeslot"]=0x04EF, -- ӯ
 },
 [0x04F0]={
  ["category"]="lu",
  ["contextname"]="cyrillicUdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER U WITH DIAERESIS",
  ["lccode"]=0x04F1,
  ["linebreak"]="al",
  ["shcode"]=0x0423,
  ["specials"]={ "char", 0x0423, 0x0308 },
  ["unicodeslot"]=0x04F0, -- Ӱ
 },
 [0x04F1]={
  ["category"]="ll",
  ["contextname"]="cyrillicudiaeresis",
  ["description"]="CYRILLIC SMALL LETTER U WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0443,
  ["specials"]={ "char", 0x0443, 0x0308 },
  ["uccode"]=0x04F0,
  ["unicodeslot"]=0x04F1, -- ӱ
 },
 [0x04F2]={
  ["category"]="lu",
  ["contextname"]="cyrillicUdoubleacute",
  ["description"]="CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE",
  ["lccode"]=0x04F3,
  ["linebreak"]="al",
  ["shcode"]=0x0423,
  ["specials"]={ "char", 0x0423, 0x030B },
  ["unicodeslot"]=0x04F2, -- Ӳ
 },
 [0x04F3]={
  ["category"]="ll",
  ["contextname"]="cyrillicudoubleacute",
  ["description"]="CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0443,
  ["specials"]={ "char", 0x0443, 0x030B },
  ["uccode"]=0x04F2,
  ["unicodeslot"]=0x04F3, -- ӳ
 },
 [0x04F4]={
  ["category"]="lu",
  ["contextname"]="cyrillicCHEdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS",
  ["lccode"]=0x04F5,
  ["linebreak"]="al",
  ["shcode"]=0x0427,
  ["specials"]={ "char", 0x0427, 0x0308 },
  ["unicodeslot"]=0x04F4, -- Ӵ
 },
 [0x04F5]={
  ["category"]="ll",
  ["contextname"]="cyrillicchediaeresis",
  ["description"]="CYRILLIC SMALL LETTER CHE WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0447,
  ["specials"]={ "char", 0x0447, 0x0308 },
  ["uccode"]=0x04F4,
  ["unicodeslot"]=0x04F5, -- ӵ
 },
 [0x04F6]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER GHE WITH DESCENDER",
  ["lccode"]=0x04F7,
  ["linebreak"]="al",
  ["shcode"]=0x0413,
  ["unicodeslot"]=0x04F6, -- Ӷ
 },
 [0x04F7]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER GHE WITH DESCENDER",
  ["linebreak"]="al",
  ["shcode"]=0x0433,
  ["uccode"]=0x04F6,
  ["unicodeslot"]=0x04F7, -- ӷ
 },
 [0x04F8]={
  ["category"]="lu",
  ["contextname"]="cyrillicYERUdiaeresis",
  ["description"]="CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS",
  ["lccode"]=0x04F9,
  ["linebreak"]="al",
  ["shcode"]=0x042B,
  ["specials"]={ "char", 0x042B, 0x0308 },
  ["unicodeslot"]=0x04F8, -- Ӹ
 },
 [0x04F9]={
  ["category"]="ll",
  ["contextname"]="cyrillicyerudiaeresis",
  ["description"]="CYRILLIC SMALL LETTER YERU WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x044B,
  ["specials"]={ "char", 0x044B, 0x0308 },
  ["uccode"]=0x04F8,
  ["unicodeslot"]=0x04F9, -- ӹ
 },
 [0x04FA]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK",
  ["lccode"]=0x04FB,
  ["linebreak"]="al",
  ["shcode"]=0x0413,
  ["unicodeslot"]=0x04FA, -- Ӻ
 },
 [0x04FB]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0433,
  ["uccode"]=0x04FA,
  ["unicodeslot"]=0x04FB, -- ӻ
 },
 [0x04FC]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER HA WITH HOOK",
  ["lccode"]=0x04FD,
  ["linebreak"]="al",
  ["shcode"]=0x0425,
  ["unicodeslot"]=0x04FC, -- Ӽ
 },
 [0x04FD]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER HA WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0445,
  ["uccode"]=0x04FC,
  ["unicodeslot"]=0x04FD, -- ӽ
 },
 [0x04FE]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER HA WITH STROKE",
  ["lccode"]=0x04FF,
  ["linebreak"]="al",
  ["shcode"]=0x0425,
  ["unicodeslot"]=0x04FE, -- Ӿ
 },
 [0x04FF]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER HA WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0445,
  ["uccode"]=0x04FE,
  ["unicodeslot"]=0x04FF, -- ӿ
 },
 [0x0500]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI DE",
  ["lccode"]=0x0501,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0500, -- Ԁ
 },
 [0x0501]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI DE",
  ["linebreak"]="al",
  ["uccode"]=0x0500,
  ["unicodeslot"]=0x0501, -- ԁ
 },
 [0x0502]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI DJE",
  ["lccode"]=0x0503,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0502, -- Ԃ
 },
 [0x0503]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI DJE",
  ["linebreak"]="al",
  ["uccode"]=0x0502,
  ["unicodeslot"]=0x0503, -- ԃ
 },
 [0x0504]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI ZJE",
  ["lccode"]=0x0505,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0504, -- Ԅ
 },
 [0x0505]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI ZJE",
  ["linebreak"]="al",
  ["uccode"]=0x0504,
  ["unicodeslot"]=0x0505, -- ԅ
 },
 [0x0506]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI DZJE",
  ["lccode"]=0x0507,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0506, -- Ԇ
 },
 [0x0507]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI DZJE",
  ["linebreak"]="al",
  ["uccode"]=0x0506,
  ["unicodeslot"]=0x0507, -- ԇ
 },
 [0x0508]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI LJE",
  ["lccode"]=0x0509,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0508, -- Ԉ
 },
 [0x0509]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI LJE",
  ["linebreak"]="al",
  ["uccode"]=0x0508,
  ["unicodeslot"]=0x0509, -- ԉ
 },
 [0x050A]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI NJE",
  ["lccode"]=0x050B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x050A, -- Ԋ
 },
 [0x050B]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI NJE",
  ["linebreak"]="al",
  ["uccode"]=0x050A,
  ["unicodeslot"]=0x050B, -- ԋ
 },
 [0x050C]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI SJE",
  ["lccode"]=0x050D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x050C, -- Ԍ
 },
 [0x050D]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI SJE",
  ["linebreak"]="al",
  ["uccode"]=0x050C,
  ["unicodeslot"]=0x050D, -- ԍ
 },
 [0x050E]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER KOMI TJE",
  ["lccode"]=0x050F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x050E, -- Ԏ
 },
 [0x050F]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER KOMI TJE",
  ["linebreak"]="al",
  ["uccode"]=0x050E,
  ["unicodeslot"]=0x050F, -- ԏ
 },
 [0x0510]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER REVERSED ZE",
  ["lccode"]=0x0511,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0510, -- Ԑ
 },
 [0x0511]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER REVERSED ZE",
  ["linebreak"]="al",
  ["uccode"]=0x0510,
  ["unicodeslot"]=0x0511, -- ԑ
 },
 [0x0512]={
  ["category"]="lu",
  ["description"]="CYRILLIC CAPITAL LETTER EL WITH HOOK",
  ["lccode"]=0x0513,
  ["linebreak"]="al",
  ["shcode"]=0x041B,
  ["unicodeslot"]=0x0512, -- Ԓ
 },
 [0x0513]={
  ["category"]="ll",
  ["description"]="CYRILLIC SMALL LETTER EL WITH HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x043B,
  ["uccode"]=0x0512,
  ["unicodeslot"]=0x0513, -- ԓ
 },
 [0x0531]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER AYB",
  ["lccode"]=0x0561,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0531, -- Ա
 },
 [0x0532]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER BEN",
  ["lccode"]=0x0562,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0532, -- Բ
 },
 [0x0533]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER GIM",
  ["lccode"]=0x0563,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0533, -- Գ
 },
 [0x0534]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER DA",
  ["lccode"]=0x0564,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0534, -- Դ
 },
 [0x0535]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER ECH",
  ["lccode"]=0x0565,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0535, -- Ե
 },
 [0x0536]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER ZA",
  ["lccode"]=0x0566,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0536, -- Զ
 },
 [0x0537]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER EH",
  ["lccode"]=0x0567,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0537, -- Է
 },
 [0x0538]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER ET",
  ["lccode"]=0x0568,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0538, -- Ը
 },
 [0x0539]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER TO",
  ["lccode"]=0x0569,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0539, -- Թ
 },
 [0x053A]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER ZHE",
  ["lccode"]=0x056A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x053A, -- Ժ
 },
 [0x053B]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER INI",
  ["lccode"]=0x056B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x053B, -- Ի
 },
 [0x053C]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER LIWN",
  ["lccode"]=0x056C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x053C, -- Լ
 },
 [0x053D]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER XEH",
  ["lccode"]=0x056D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x053D, -- Խ
 },
 [0x053E]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER CA",
  ["lccode"]=0x056E,
  ["linebreak"]="al",
  ["unicodeslot"]=0x053E, -- Ծ
 },
 [0x053F]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER KEN",
  ["lccode"]=0x056F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x053F, -- Կ
 },
 [0x0540]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER HO",
  ["lccode"]=0x0570,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0540, -- Հ
 },
 [0x0541]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER JA",
  ["lccode"]=0x0571,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0541, -- Ձ
 },
 [0x0542]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER GHAD",
  ["lccode"]=0x0572,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0542, -- Ղ
 },
 [0x0543]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER CHEH",
  ["lccode"]=0x0573,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0543, -- Ճ
 },
 [0x0544]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER MEN",
  ["lccode"]=0x0574,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0544, -- Մ
 },
 [0x0545]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER YI",
  ["lccode"]=0x0575,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0545, -- Յ
 },
 [0x0546]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER NOW",
  ["lccode"]=0x0576,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0546, -- Ն
 },
 [0x0547]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER SHA",
  ["lccode"]=0x0577,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0547, -- Շ
 },
 [0x0548]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER VO",
  ["lccode"]=0x0578,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0548, -- Ո
 },
 [0x0549]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER CHA",
  ["lccode"]=0x0579,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0549, -- Չ
 },
 [0x054A]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER PEH",
  ["lccode"]=0x057A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x054A, -- Պ
 },
 [0x054B]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER JHEH",
  ["lccode"]=0x057B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x054B, -- Ջ
 },
 [0x054C]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER RA",
  ["lccode"]=0x057C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x054C, -- Ռ
 },
 [0x054D]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER SEH",
  ["lccode"]=0x057D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x054D, -- Ս
 },
 [0x054E]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER VEW",
  ["lccode"]=0x057E,
  ["linebreak"]="al",
  ["unicodeslot"]=0x054E, -- Վ
 },
 [0x054F]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER TIWN",
  ["lccode"]=0x057F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x054F, -- Տ
 },
 [0x0550]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER REH",
  ["lccode"]=0x0580,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0550, -- Ր
 },
 [0x0551]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER CO",
  ["lccode"]=0x0581,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0551, -- Ց
 },
 [0x0552]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER YIWN",
  ["lccode"]=0x0582,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0552, -- Ւ
 },
 [0x0553]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER PIWR",
  ["lccode"]=0x0583,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0553, -- Փ
 },
 [0x0554]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER KEH",
  ["lccode"]=0x0584,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0554, -- Ք
 },
 [0x0555]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER OH",
  ["lccode"]=0x0585,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0555, -- Օ
 },
 [0x0556]={
  ["category"]="lu",
  ["description"]="ARMENIAN CAPITAL LETTER FEH",
  ["lccode"]=0x0586,
  ["linebreak"]="al",
  ["unicodeslot"]=0x0556, -- Ֆ
 },
 [0x0559]={
  ["category"]="lm",
  ["description"]="ARMENIAN MODIFIER LETTER LEFT HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0559, -- ՙ
 },
 [0x055A]={
  ["category"]="po",
  ["description"]="ARMENIAN APOSTROPHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x055A, -- ՚
 },
 [0x055B]={
  ["category"]="po",
  ["description"]="ARMENIAN EMPHASIS MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x055B, -- ՛
 },
 [0x055C]={
  ["category"]="po",
  ["description"]="ARMENIAN EXCLAMATION MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x055C, -- ՜
 },
 [0x055D]={
  ["category"]="po",
  ["description"]="ARMENIAN COMMA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x055D, -- ՝
 },
 [0x055E]={
  ["category"]="po",
  ["description"]="ARMENIAN QUESTION MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x055E, -- ՞
 },
 [0x055F]={
  ["category"]="po",
  ["description"]="ARMENIAN ABBREVIATION MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x055F, -- ՟
 },
 [0x0561]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER AYB",
  ["linebreak"]="al",
  ["uccode"]=0x0531,
  ["unicodeslot"]=0x0561, -- ա
 },
 [0x0562]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER BEN",
  ["linebreak"]="al",
  ["uccode"]=0x0532,
  ["unicodeslot"]=0x0562, -- բ
 },
 [0x0563]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER GIM",
  ["linebreak"]="al",
  ["uccode"]=0x0533,
  ["unicodeslot"]=0x0563, -- գ
 },
 [0x0564]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER DA",
  ["linebreak"]="al",
  ["uccode"]=0x0534,
  ["unicodeslot"]=0x0564, -- դ
 },
 [0x0565]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER ECH",
  ["linebreak"]="al",
  ["uccode"]=0x0535,
  ["unicodeslot"]=0x0565, -- ե
 },
 [0x0566]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER ZA",
  ["linebreak"]="al",
  ["uccode"]=0x0536,
  ["unicodeslot"]=0x0566, -- զ
 },
 [0x0567]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER EH",
  ["linebreak"]="al",
  ["uccode"]=0x0537,
  ["unicodeslot"]=0x0567, -- է
 },
 [0x0568]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER ET",
  ["linebreak"]="al",
  ["uccode"]=0x0538,
  ["unicodeslot"]=0x0568, -- ը
 },
 [0x0569]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER TO",
  ["linebreak"]="al",
  ["uccode"]=0x0539,
  ["unicodeslot"]=0x0569, -- թ
 },
 [0x056A]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER ZHE",
  ["linebreak"]="al",
  ["uccode"]=0x053A,
  ["unicodeslot"]=0x056A, -- ժ
 },
 [0x056B]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER INI",
  ["linebreak"]="al",
  ["uccode"]=0x053B,
  ["unicodeslot"]=0x056B, -- ի
 },
 [0x056C]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER LIWN",
  ["linebreak"]="al",
  ["uccode"]=0x053C,
  ["unicodeslot"]=0x056C, -- լ
 },
 [0x056D]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER XEH",
  ["linebreak"]="al",
  ["uccode"]=0x053D,
  ["unicodeslot"]=0x056D, -- խ
 },
 [0x056E]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER CA",
  ["linebreak"]="al",
  ["uccode"]=0x053E,
  ["unicodeslot"]=0x056E, -- ծ
 },
 [0x056F]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER KEN",
  ["linebreak"]="al",
  ["uccode"]=0x053F,
  ["unicodeslot"]=0x056F, -- կ
 },
 [0x0570]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER HO",
  ["linebreak"]="al",
  ["uccode"]=0x0540,
  ["unicodeslot"]=0x0570, -- հ
 },
 [0x0571]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER JA",
  ["linebreak"]="al",
  ["uccode"]=0x0541,
  ["unicodeslot"]=0x0571, -- ձ
 },
 [0x0572]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER GHAD",
  ["linebreak"]="al",
  ["uccode"]=0x0542,
  ["unicodeslot"]=0x0572, -- ղ
 },
 [0x0573]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER CHEH",
  ["linebreak"]="al",
  ["uccode"]=0x0543,
  ["unicodeslot"]=0x0573, -- ճ
 },
 [0x0574]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER MEN",
  ["linebreak"]="al",
  ["uccode"]=0x0544,
  ["unicodeslot"]=0x0574, -- մ
 },
 [0x0575]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER YI",
  ["linebreak"]="al",
  ["uccode"]=0x0545,
  ["unicodeslot"]=0x0575, -- յ
 },
 [0x0576]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER NOW",
  ["linebreak"]="al",
  ["uccode"]=0x0546,
  ["unicodeslot"]=0x0576, -- ն
 },
 [0x0577]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER SHA",
  ["linebreak"]="al",
  ["uccode"]=0x0547,
  ["unicodeslot"]=0x0577, -- շ
 },
 [0x0578]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER VO",
  ["linebreak"]="al",
  ["uccode"]=0x0548,
  ["unicodeslot"]=0x0578, -- ո
 },
 [0x0579]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER CHA",
  ["linebreak"]="al",
  ["uccode"]=0x0549,
  ["unicodeslot"]=0x0579, -- չ
 },
 [0x057A]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER PEH",
  ["linebreak"]="al",
  ["uccode"]=0x054A,
  ["unicodeslot"]=0x057A, -- պ
 },
 [0x057B]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER JHEH",
  ["linebreak"]="al",
  ["uccode"]=0x054B,
  ["unicodeslot"]=0x057B, -- ջ
 },
 [0x057C]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER RA",
  ["linebreak"]="al",
  ["uccode"]=0x054C,
  ["unicodeslot"]=0x057C, -- ռ
 },
 [0x057D]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER SEH",
  ["linebreak"]="al",
  ["uccode"]=0x054D,
  ["unicodeslot"]=0x057D, -- ս
 },
 [0x057E]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER VEW",
  ["linebreak"]="al",
  ["uccode"]=0x054E,
  ["unicodeslot"]=0x057E, -- վ
 },
 [0x057F]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER TIWN",
  ["linebreak"]="al",
  ["uccode"]=0x054F,
  ["unicodeslot"]=0x057F, -- տ
 },
 [0x0580]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER REH",
  ["linebreak"]="al",
  ["uccode"]=0x0550,
  ["unicodeslot"]=0x0580, -- ր
 },
 [0x0581]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER CO",
  ["linebreak"]="al",
  ["uccode"]=0x0551,
  ["unicodeslot"]=0x0581, -- ց
 },
 [0x0582]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER YIWN",
  ["linebreak"]="al",
  ["uccode"]=0x0552,
  ["unicodeslot"]=0x0582, -- ւ
 },
 [0x0583]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER PIWR",
  ["linebreak"]="al",
  ["uccode"]=0x0553,
  ["unicodeslot"]=0x0583, -- փ
 },
 [0x0584]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER KEH",
  ["linebreak"]="al",
  ["uccode"]=0x0554,
  ["unicodeslot"]=0x0584, -- ք
 },
 [0x0585]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER OH",
  ["linebreak"]="al",
  ["uccode"]=0x0555,
  ["unicodeslot"]=0x0585, -- օ
 },
 [0x0586]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LETTER FEH",
  ["linebreak"]="al",
  ["uccode"]=0x0556,
  ["unicodeslot"]=0x0586, -- ֆ
 },
 [0x0587]={
  ["category"]="ll",
  ["description"]="ARMENIAN SMALL LIGATURE ECH YIWN",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0565, 0x0582 },
  ["unicodeslot"]=0x0587, -- և
 },
 [0x0589]={
  ["category"]="po",
  ["description"]="ARMENIAN FULL STOP",
  ["linebreak"]="is",
  ["unicodeslot"]=0x0589, -- ։
 },
 [0x058A]={
  ["category"]="pd",
  ["description"]="ARMENIAN HYPHEN",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x058A, -- ֊
 },
 [0x0591]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT ETNAHTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0591, -- ֑
 },
 [0x0592]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT SEGOL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0592, -- ֒
 },
 [0x0593]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT SHALSHELET",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0593, -- ֓
 },
 [0x0594]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT ZAQEF QATAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0594, -- ֔
 },
 [0x0595]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT ZAQEF GADOL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0595, -- ֕
 },
 [0x0596]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT TIPEHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0596, -- ֖
 },
 [0x0597]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT REVIA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0597, -- ֗
 },
 [0x0598]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT ZARQA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0598, -- ֘
 },
 [0x0599]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT PASHTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0599, -- ֙
 },
 [0x059A]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT YETIV",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x059A, -- ֚
 },
 [0x059B]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT TEVIR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x059B, -- ֛
 },
 [0x059C]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT GERESH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x059C, -- ֜
 },
 [0x059D]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT GERESH MUQDAM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x059D, -- ֝
 },
 [0x059E]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT GERSHAYIM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x059E, -- ֞
 },
 [0x059F]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT QARNEY PARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x059F, -- ֟
 },
 [0x05A0]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT TELISHA GEDOLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A0, -- ֠
 },
 [0x05A1]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT PAZER",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A1, -- ֡
 },
 [0x05A2]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT ATNAH HAFUKH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A2, -- ֢
 },
 [0x05A3]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT MUNAH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A3, -- ֣
 },
 [0x05A4]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT MAHAPAKH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A4, -- ֤
 },
 [0x05A5]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT MERKHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A5, -- ֥
 },
 [0x05A6]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT MERKHA KEFULA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A6, -- ֦
 },
 [0x05A7]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT DARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A7, -- ֧
 },
 [0x05A8]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT QADMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A8, -- ֨
 },
 [0x05A9]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT TELISHA QETANA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05A9, -- ֩
 },
 [0x05AA]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT YERAH BEN YOMO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05AA, -- ֪
 },
 [0x05AB]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT OLE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05AB, -- ֫
 },
 [0x05AC]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT ILUY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05AC, -- ֬
 },
 [0x05AD]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT DEHI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05AD, -- ֭
 },
 [0x05AE]={
  ["category"]="mn",
  ["description"]="HEBREW ACCENT ZINOR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05AE, -- ֮
 },
 [0x05AF]={
  ["category"]="mn",
  ["description"]="HEBREW MARK MASORA CIRCLE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05AF, -- ֯
 },
 [0x05B0]={
  ["adobename"]="afii57799",
  ["category"]="mn",
  ["description"]="HEBREW POINT SHEVA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B0, -- ְ
 },
 [0x05B1]={
  ["adobename"]="afii57801",
  ["category"]="mn",
  ["description"]="HEBREW POINT HATAF SEGOL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B1, -- ֱ
 },
 [0x05B2]={
  ["adobename"]="afii57800",
  ["category"]="mn",
  ["description"]="HEBREW POINT HATAF PATAH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B2, -- ֲ
 },
 [0x05B3]={
  ["adobename"]="afii57802",
  ["category"]="mn",
  ["description"]="HEBREW POINT HATAF QAMATS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B3, -- ֳ
 },
 [0x05B4]={
  ["adobename"]="afii57793",
  ["category"]="mn",
  ["description"]="HEBREW POINT HIRIQ",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B4, -- ִ
 },
 [0x05B5]={
  ["adobename"]="afii57794",
  ["category"]="mn",
  ["description"]="HEBREW POINT TSERE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B5, -- ֵ
 },
 [0x05B6]={
  ["adobename"]="afii57795",
  ["category"]="mn",
  ["description"]="HEBREW POINT SEGOL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B6, -- ֶ
 },
 [0x05B7]={
  ["adobename"]="afii57798",
  ["category"]="mn",
  ["description"]="HEBREW POINT PATAH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B7, -- ַ
 },
 [0x05B8]={
  ["adobename"]="afii57797",
  ["category"]="mn",
  ["description"]="HEBREW POINT QAMATS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B8, -- ָ
 },
 [0x05B9]={
  ["adobename"]="afii57806",
  ["category"]="mn",
  ["description"]="HEBREW POINT HOLAM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05B9, -- ֹ
 },
 [0x05BA]={
  ["category"]="mn",
  ["description"]="HEBREW POINT HOLAM HASER FOR VAV",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05BA, -- ֺ
 },
 [0x05BB]={
  ["adobename"]="afii57796",
  ["category"]="mn",
  ["description"]="HEBREW POINT QUBUTS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05BB, -- ֻ
 },
 [0x05BC]={
  ["adobename"]="afii57807",
  ["category"]="mn",
  ["description"]="HEBREW POINT DAGESH OR MAPIQ",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05BC, -- ּ
 },
 [0x05BD]={
  ["adobename"]="afii57839",
  ["category"]="mn",
  ["description"]="HEBREW POINT METEG",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05BD, -- ֽ
 },
 [0x05BE]={
  ["adobename"]="afii57645",
  ["category"]="po",
  ["description"]="HEBREW PUNCTUATION MAQAF",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x05BE, -- ־
 },
 [0x05BF]={
  ["adobename"]="afii57841",
  ["category"]="mn",
  ["description"]="HEBREW POINT RAFE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05BF, -- ֿ
 },
 [0x05C0]={
  ["adobename"]="afii57842",
  ["category"]="po",
  ["description"]="HEBREW PUNCTUATION PASEQ",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05C0, -- ׀
 },
 [0x05C1]={
  ["adobename"]="afii57804",
  ["category"]="mn",
  ["description"]="HEBREW POINT SHIN DOT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05C1, -- ׁ
 },
 [0x05C2]={
  ["adobename"]="afii57803",
  ["category"]="mn",
  ["description"]="HEBREW POINT SIN DOT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05C2, -- ׂ
 },
 [0x05C3]={
  ["adobename"]="afii57658",
  ["category"]="po",
  ["description"]="HEBREW PUNCTUATION SOF PASUQ",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05C3, -- ׃
 },
 [0x05C4]={
  ["category"]="mn",
  ["description"]="HEBREW MARK UPPER DOT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05C4, -- ׄ
 },
 [0x05C5]={
  ["category"]="mn",
  ["description"]="HEBREW MARK LOWER DOT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05C5, -- ׅ
 },
 [0x05C6]={
  ["category"]="po",
  ["description"]="HEBREW PUNCTUATION NUN HAFUKHA",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x05C6, -- ׆
 },
 [0x05C7]={
  ["category"]="mn",
  ["description"]="HEBREW POINT QAMATS QATAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x05C7, -- ׇ
 },
 [0x05D0]={
  ["adobename"]="afii57664",
  ["category"]="lo",
  ["contextname"]="hebrewAlef",
  ["description"]="HEBREW LETTER ALEF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D0, -- א
 },
 [0x05D1]={
  ["adobename"]="afii57665",
  ["category"]="lo",
  ["contextname"]="hebrewBet",
  ["description"]="HEBREW LETTER BET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D1, -- ב
 },
 [0x05D2]={
  ["adobename"]="afii57666",
  ["category"]="lo",
  ["contextname"]="hebrewGimel",
  ["description"]="HEBREW LETTER GIMEL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D2, -- ג
 },
 [0x05D3]={
  ["adobename"]="afii57667",
  ["category"]="lo",
  ["contextname"]="hebrewDalet",
  ["description"]="HEBREW LETTER DALET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D3, -- ד
 },
 [0x05D4]={
  ["adobename"]="afii57668",
  ["category"]="lo",
  ["contextname"]="hebrewHe",
  ["description"]="HEBREW LETTER HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D4, -- ה
 },
 [0x05D5]={
  ["adobename"]="afii57669",
  ["category"]="lo",
  ["contextname"]="hebrewVav",
  ["description"]="HEBREW LETTER VAV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D5, -- ו
 },
 [0x05D6]={
  ["adobename"]="afii57670",
  ["category"]="lo",
  ["contextname"]="hebrewZayin",
  ["description"]="HEBREW LETTER ZAYIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D6, -- ז
 },
 [0x05D7]={
  ["adobename"]="afii57671",
  ["category"]="lo",
  ["contextname"]="hebrewHet",
  ["description"]="HEBREW LETTER HET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D7, -- ח
 },
 [0x05D8]={
  ["adobename"]="afii57672",
  ["category"]="lo",
  ["contextname"]="hebrewTet",
  ["description"]="HEBREW LETTER TET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D8, -- ט
 },
 [0x05D9]={
  ["adobename"]="afii57673",
  ["category"]="lo",
  ["contextname"]="hebrewYod",
  ["description"]="HEBREW LETTER YOD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05D9, -- י
 },
 [0x05DA]={
  ["adobename"]="afii57674",
  ["category"]="lo",
  ["contextname"]="hebrewKaffinal",
  ["description"]="HEBREW LETTER FINAL KAF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05DA, -- ך
 },
 [0x05DB]={
  ["adobename"]="afii57675",
  ["category"]="lo",
  ["contextname"]="hebrewKaf",
  ["description"]="HEBREW LETTER KAF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05DB, -- כ
 },
 [0x05DC]={
  ["adobename"]="afii57676",
  ["category"]="lo",
  ["contextname"]="hebrewLamed",
  ["description"]="HEBREW LETTER LAMED",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05DC, -- ל
 },
 [0x05DD]={
  ["adobename"]="afii57677",
  ["category"]="lo",
  ["contextname"]="hebrewMemfinal",
  ["description"]="HEBREW LETTER FINAL MEM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05DD, -- ם
 },
 [0x05DE]={
  ["adobename"]="afii57678",
  ["category"]="lo",
  ["contextname"]="hebrewMem",
  ["description"]="HEBREW LETTER MEM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05DE, -- מ
 },
 [0x05DF]={
  ["adobename"]="afii57679",
  ["category"]="lo",
  ["contextname"]="hebrewNunfinal",
  ["description"]="HEBREW LETTER FINAL NUN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05DF, -- ן
 },
 [0x05E0]={
  ["adobename"]="afii57680",
  ["category"]="lo",
  ["contextname"]="hebrewNun",
  ["description"]="HEBREW LETTER NUN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E0, -- נ
 },
 [0x05E1]={
  ["adobename"]="afii57681",
  ["category"]="lo",
  ["contextname"]="hebrewSamekh",
  ["description"]="HEBREW LETTER SAMEKH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E1, -- ס
 },
 [0x05E2]={
  ["adobename"]="afii57682",
  ["category"]="lo",
  ["contextname"]="hebrewAyin",
  ["description"]="HEBREW LETTER AYIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E2, -- ע
 },
 [0x05E3]={
  ["adobename"]="afii57683",
  ["category"]="lo",
  ["contextname"]="hebrewPefinal",
  ["description"]="HEBREW LETTER FINAL PE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E3, -- ף
 },
 [0x05E4]={
  ["adobename"]="afii57684",
  ["category"]="lo",
  ["contextname"]="hebrewPe",
  ["description"]="HEBREW LETTER PE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E4, -- פ
 },
 [0x05E5]={
  ["adobename"]="afii57685",
  ["category"]="lo",
  ["contextname"]="hebrewTsadifinal",
  ["description"]="HEBREW LETTER FINAL TSADI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E5, -- ץ
 },
 [0x05E6]={
  ["adobename"]="afii57686",
  ["category"]="lo",
  ["contextname"]="hebrewTsadi",
  ["description"]="HEBREW LETTER TSADI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E6, -- צ
 },
 [0x05E7]={
  ["adobename"]="afii57687",
  ["category"]="lo",
  ["contextname"]="hebrewQof",
  ["description"]="HEBREW LETTER QOF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E7, -- ק
 },
 [0x05E8]={
  ["adobename"]="afii57688",
  ["category"]="lo",
  ["contextname"]="hebrewResh",
  ["description"]="HEBREW LETTER RESH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E8, -- ר
 },
 [0x05E9]={
  ["adobename"]="afii57689",
  ["category"]="lo",
  ["contextname"]="hebrewShin",
  ["description"]="HEBREW LETTER SHIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05E9, -- ש
 },
 [0x05EA]={
  ["adobename"]="afii57690",
  ["category"]="lo",
  ["contextname"]="hebrewTav",
  ["description"]="HEBREW LETTER TAV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05EA, -- ת
 },
 [0x05F0]={
  ["adobename"]="afii57716",
  ["category"]="lo",
  ["description"]="HEBREW LIGATURE YIDDISH DOUBLE VAV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05F0, -- װ
 },
 [0x05F1]={
  ["adobename"]="afii57717",
  ["category"]="lo",
  ["description"]="HEBREW LIGATURE YIDDISH VAV YOD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05F1, -- ױ
 },
 [0x05F2]={
  ["adobename"]="afii57718",
  ["category"]="lo",
  ["description"]="HEBREW LIGATURE YIDDISH DOUBLE YOD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05F2, -- ײ
 },
 [0x05F3]={
  ["category"]="po",
  ["description"]="HEBREW PUNCTUATION GERESH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05F3, -- ׳
 },
 [0x05F4]={
  ["category"]="po",
  ["description"]="HEBREW PUNCTUATION GERSHAYIM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x05F4, -- ״
 },
 [0x0600]={
  ["category"]="cf",
  ["description"]="ARABIC NUMBER SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0600, -- ؀
 },
 [0x0601]={
  ["category"]="cf",
  ["description"]="ARABIC SIGN SANAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0601, -- ؁
 },
 [0x0602]={
  ["category"]="cf",
  ["description"]="ARABIC FOOTNOTE MARKER",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0602, -- ؂
 },
 [0x0603]={
  ["category"]="cf",
  ["description"]="ARABIC SIGN SAFHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0603, -- ؃
 },
 [0x060B]={
  ["category"]="sc",
  ["description"]="AFGHANI SIGN",
  ["linebreak"]="po",
  ["unicodeslot"]=0x060B, -- ؋
 },
 [0x060C]={
  ["adobename"]="afii57388",
  ["category"]="po",
  ["description"]="ARABIC COMMA",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x060C, -- ،
 },
 [0x060D]={
  ["category"]="po",
  ["description"]="ARABIC DATE SEPARATOR",
  ["linebreak"]="is",
  ["unicodeslot"]=0x060D, -- ؍
 },
 [0x060E]={
  ["category"]="so",
  ["description"]="ARABIC POETIC VERSE SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x060E, -- ؎
 },
 [0x060F]={
  ["category"]="so",
  ["description"]="ARABIC SIGN MISRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x060F, -- ؏
 },
 [0x0610]={
  ["category"]="mn",
  ["description"]="ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0610, -- ؐ
 },
 [0x0611]={
  ["category"]="mn",
  ["description"]="ARABIC SIGN ALAYHE ASSALLAM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0611, -- ؑ
 },
 [0x0612]={
  ["category"]="mn",
  ["description"]="ARABIC SIGN RAHMATULLAH ALAYHE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0612, -- ؒ
 },
 [0x0613]={
  ["category"]="mn",
  ["description"]="ARABIC SIGN RADI ALLAHOU ANHU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0613, -- ؓ
 },
 [0x0614]={
  ["category"]="mn",
  ["description"]="ARABIC SIGN TAKHALLUS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0614, -- ؔ
 },
 [0x0615]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH TAH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0615, -- ؕ
 },
 [0x061B]={
  ["adobename"]="afii57403",
  ["category"]="po",
  ["description"]="ARABIC SEMICOLON",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x061B, -- ؛
 },
 [0x061E]={
  ["category"]="po",
  ["description"]="ARABIC TRIPLE DOT PUNCTUATION MARK",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x061E, -- ؞
 },
 [0x061F]={
  ["adobename"]="afii57407",
  ["category"]="po",
  ["description"]="ARABIC QUESTION MARK",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x061F, -- ؟
 },
 [0x0621]={
  ["adobename"]="afii57409",
  ["category"]="lo",
  ["description"]="ARABIC LETTER HAMZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0621, -- ء
 },
 [0x0622]={
  ["adobename"]="afii57410",
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF WITH MADDA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0627,
  ["specials"]={ "char", 0x0627, 0x0653 },
  ["unicodeslot"]=0x0622, -- آ
 },
 [0x0623]={
  ["adobename"]="afii57411",
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0627,
  ["specials"]={ "char", 0x0627, 0x0654 },
  ["unicodeslot"]=0x0623, -- أ
 },
 [0x0624]={
  ["adobename"]="afii57412",
  ["category"]="lo",
  ["description"]="ARABIC LETTER WAW WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0648,
  ["specials"]={ "char", 0x0648, 0x0654 },
  ["unicodeslot"]=0x0624, -- ؤ
 },
 [0x0625]={
  ["adobename"]="afii57413",
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF WITH HAMZA BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0627,
  ["specials"]={ "char", 0x0627, 0x0655 },
  ["unicodeslot"]=0x0625, -- إ
 },
 [0x0626]={
  ["adobename"]="afii57414",
  ["category"]="lo",
  ["description"]="ARABIC LETTER YEH WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x064A,
  ["specials"]={ "char", 0x064A, 0x0654 },
  ["unicodeslot"]=0x0626, -- ئ
 },
 [0x0627]={
  ["adobename"]="afii57415",
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0627, -- ا
 },
 [0x0628]={
  ["adobename"]="afii57416",
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0628, -- ب
 },
 [0x0629]={
  ["adobename"]="afii57417",
  ["category"]="lo",
  ["description"]="ARABIC LETTER TEH MARBUTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0629, -- ة
 },
 [0x062A]={
  ["adobename"]="afii57418",
  ["category"]="lo",
  ["description"]="ARABIC LETTER TEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x062A, -- ت
 },
 [0x062B]={
  ["adobename"]="afii57419",
  ["category"]="lo",
  ["description"]="ARABIC LETTER THEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x062B, -- ث
 },
 [0x062C]={
  ["adobename"]="afii57420",
  ["category"]="lo",
  ["description"]="ARABIC LETTER JEEM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x062C, -- ج
 },
 [0x062D]={
  ["adobename"]="afii57421",
  ["category"]="lo",
  ["description"]="ARABIC LETTER HAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x062D, -- ح
 },
 [0x062E]={
  ["adobename"]="afii57422",
  ["category"]="lo",
  ["description"]="ARABIC LETTER KHAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x062E, -- خ
 },
 [0x062F]={
  ["adobename"]="afii57423",
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x062F, -- د
 },
 [0x0630]={
  ["adobename"]="afii57424",
  ["category"]="lo",
  ["description"]="ARABIC LETTER THAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0630, -- ذ
 },
 [0x0631]={
  ["adobename"]="afii57425",
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0631, -- ر
 },
 [0x0632]={
  ["adobename"]="afii57426",
  ["category"]="lo",
  ["description"]="ARABIC LETTER ZAIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0632, -- ز
 },
 [0x0633]={
  ["adobename"]="afii57427",
  ["category"]="lo",
  ["description"]="ARABIC LETTER SEEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0633, -- س
 },
 [0x0634]={
  ["adobename"]="afii57428",
  ["category"]="lo",
  ["description"]="ARABIC LETTER SHEEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0634, -- ش
 },
 [0x0635]={
  ["adobename"]="afii57429",
  ["category"]="lo",
  ["description"]="ARABIC LETTER SAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0635, -- ص
 },
 [0x0636]={
  ["adobename"]="afii57430",
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAD",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0636, -- ض
 },
 [0x0637]={
  ["adobename"]="afii57431",
  ["category"]="lo",
  ["description"]="ARABIC LETTER TAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0637, -- ط
 },
 [0x0638]={
  ["adobename"]="afii57432",
  ["category"]="lo",
  ["description"]="ARABIC LETTER ZAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0638, -- ظ
 },
 [0x0639]={
  ["adobename"]="afii57433",
  ["category"]="lo",
  ["description"]="ARABIC LETTER AIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0639, -- ع
 },
 [0x063A]={
  ["adobename"]="afii57434",
  ["category"]="lo",
  ["description"]="ARABIC LETTER GHAIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x063A, -- غ
 },
 [0x0640]={
  ["adobename"]="afii57440",
  ["category"]="lm",
  ["description"]="ARABIC TATWEEL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0640, -- ـ
 },
 [0x0641]={
  ["adobename"]="afii57441",
  ["category"]="lo",
  ["description"]="ARABIC LETTER FEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0641, -- ف
 },
 [0x0642]={
  ["adobename"]="afii57442",
  ["category"]="lo",
  ["description"]="ARABIC LETTER QAF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0642, -- ق
 },
 [0x0643]={
  ["adobename"]="afii57443",
  ["category"]="lo",
  ["description"]="ARABIC LETTER KAF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0643, -- ك
 },
 [0x0644]={
  ["adobename"]="afii57444",
  ["category"]="lo",
  ["description"]="ARABIC LETTER LAM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0644, -- ل
 },
 [0x0645]={
  ["adobename"]="afii57445",
  ["category"]="lo",
  ["description"]="ARABIC LETTER MEEM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0645, -- م
 },
 [0x0646]={
  ["adobename"]="afii57446",
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0646, -- ن
 },
 [0x0647]={
  ["adobename"]="afii57470",
  ["category"]="lo",
  ["description"]="ARABIC LETTER HEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0647, -- ه
 },
 [0x0648]={
  ["adobename"]="afii57448",
  ["category"]="lo",
  ["description"]="ARABIC LETTER WAW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0648, -- و
 },
 [0x0649]={
  ["adobename"]="afii57449",
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF MAKSURA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0649, -- ى
 },
 [0x064A]={
  ["adobename"]="afii57450",
  ["category"]="lo",
  ["description"]="ARABIC LETTER YEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x064A, -- ي
 },
 [0x064B]={
  ["adobename"]="afii57451",
  ["category"]="mn",
  ["description"]="ARABIC FATHATAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x064B, -- ً
 },
 [0x064C]={
  ["adobename"]="afii57452",
  ["category"]="mn",
  ["description"]="ARABIC DAMMATAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x064C, -- ٌ
 },
 [0x064D]={
  ["adobename"]="afii57453",
  ["category"]="mn",
  ["description"]="ARABIC KASRATAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x064D, -- ٍ
 },
 [0x064E]={
  ["adobename"]="afii57454",
  ["category"]="mn",
  ["description"]="ARABIC FATHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x064E, -- َ
 },
 [0x064F]={
  ["adobename"]="afii57455",
  ["category"]="mn",
  ["description"]="ARABIC DAMMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x064F, -- ُ
 },
 [0x0650]={
  ["adobename"]="afii57456",
  ["category"]="mn",
  ["description"]="ARABIC KASRA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0650, -- ِ
 },
 [0x0651]={
  ["adobename"]="afii57457",
  ["category"]="mn",
  ["description"]="ARABIC SHADDA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0651, -- ّ
 },
 [0x0652]={
  ["adobename"]="afii57458",
  ["category"]="mn",
  ["description"]="ARABIC SUKUN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0652, -- ْ
 },
 [0x0653]={
  ["category"]="mn",
  ["description"]="ARABIC MADDAH ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0653, -- ٓ
 },
 [0x0654]={
  ["category"]="mn",
  ["description"]="ARABIC HAMZA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0654, -- ٔ
 },
 [0x0655]={
  ["category"]="mn",
  ["description"]="ARABIC HAMZA BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0655, -- ٕ
 },
 [0x0656]={
  ["category"]="mn",
  ["description"]="ARABIC SUBSCRIPT ALEF",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0656, -- ٖ
 },
 [0x0657]={
  ["category"]="mn",
  ["description"]="ARABIC INVERTED DAMMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0657, -- ٗ
 },
 [0x0658]={
  ["category"]="mn",
  ["description"]="ARABIC MARK NOON GHUNNA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0658, -- ٘
 },
 [0x0659]={
  ["category"]="mn",
  ["description"]="ARABIC ZWARAKAY",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0659, -- ٙ
 },
 [0x065A]={
  ["category"]="mn",
  ["description"]="ARABIC VOWEL SIGN SMALL V ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x065A, -- ٚ
 },
 [0x065B]={
  ["category"]="mn",
  ["description"]="ARABIC VOWEL SIGN INVERTED SMALL V ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x065B, -- ٛ
 },
 [0x065C]={
  ["category"]="mn",
  ["description"]="ARABIC VOWEL SIGN DOT BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x065C, -- ٜ
 },
 [0x065D]={
  ["category"]="mn",
  ["description"]="ARABIC REVERSED DAMMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x065D, -- ٝ
 },
 [0x065E]={
  ["category"]="mn",
  ["description"]="ARABIC FATHA WITH TWO DOTS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x065E, -- ٞ
 },
 [0x0660]={
  ["adobename"]="afii57392",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0660, -- ٠
 },
 [0x0661]={
  ["adobename"]="afii57393",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0661, -- ١
 },
 [0x0662]={
  ["adobename"]="afii57394",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0662, -- ٢
 },
 [0x0663]={
  ["adobename"]="afii57395",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0663, -- ٣
 },
 [0x0664]={
  ["adobename"]="afii57396",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0664, -- ٤
 },
 [0x0665]={
  ["adobename"]="afii57397",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0665, -- ٥
 },
 [0x0666]={
  ["adobename"]="afii57398",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0666, -- ٦
 },
 [0x0667]={
  ["adobename"]="afii57399",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0667, -- ٧
 },
 [0x0668]={
  ["adobename"]="afii57400",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0668, -- ٨
 },
 [0x0669]={
  ["adobename"]="afii57401",
  ["category"]="nd",
  ["description"]="ARABIC-INDIC DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0669, -- ٩
 },
 [0x066A]={
  ["adobename"]="afii57381",
  ["category"]="po",
  ["description"]="ARABIC PERCENT SIGN",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x066A, -- ٪
 },
 [0x066B]={
  ["category"]="po",
  ["description"]="ARABIC DECIMAL SEPARATOR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x066B, -- ٫
 },
 [0x066C]={
  ["category"]="po",
  ["description"]="ARABIC THOUSANDS SEPARATOR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x066C, -- ٬
 },
 [0x066D]={
  ["adobename"]="afii63167",
  ["category"]="po",
  ["description"]="ARABIC FIVE POINTED STAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x066D, -- ٭
 },
 [0x066E]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DOTLESS BEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x066E, -- ٮ
 },
 [0x066F]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DOTLESS QAF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x066F, -- ٯ
 },
 [0x0670]={
  ["category"]="mn",
  ["description"]="ARABIC LETTER SUPERSCRIPT ALEF",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0670, -- ٰ
 },
 [0x0671]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF WASLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0671, -- ٱ
 },
 [0x0672]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0627,
  ["unicodeslot"]=0x0672, -- ٲ
 },
 [0x0673]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER ALEF WITH WAVY HAMZA BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0627,
  ["unicodeslot"]=0x0673, -- ٳ
 },
 [0x0674]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HIGH HAMZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0674, -- ٴ
 },
 [0x0675]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HIGH HAMZA ALEF",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0627, 0x0674 },
  ["unicodeslot"]=0x0675, -- ٵ
 },
 [0x0676]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HIGH HAMZA WAW",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0648, 0x0674 },
  ["unicodeslot"]=0x0676, -- ٶ
 },
 [0x0677]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER U WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x06C7,
  ["specials"]={ "compat", 0x06C7, 0x0674 },
  ["unicodeslot"]=0x0677, -- ٷ
 },
 [0x0678]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HIGH HAMZA YEH",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x064A, 0x0674 },
  ["unicodeslot"]=0x0678, -- ٸ
 },
 [0x0679]={
  ["adobename"]="afii57511",
  ["category"]="lo",
  ["description"]="ARABIC LETTER TTEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0679, -- ٹ
 },
 [0x067A]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TTEHEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x067A, -- ٺ
 },
 [0x067B]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x067B, -- ٻ
 },
 [0x067C]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TEH WITH RING",
  ["linebreak"]="al",
  ["shcode"]=0x062A,
  ["unicodeslot"]=0x067C, -- ټ
 },
 [0x067D]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS",
  ["linebreak"]="al",
  ["shcode"]=0x062A,
  ["unicodeslot"]=0x067D, -- ٽ
 },
 [0x067E]={
  ["adobename"]="afii57506",
  ["category"]="lo",
  ["description"]="ARABIC LETTER PEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x067E, -- پ
 },
 [0x067F]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TEHEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x067F, -- ٿ
 },
 [0x0680]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEHEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0680, -- ڀ
 },
 [0x0681]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HAH WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x062D,
  ["unicodeslot"]=0x0681, -- ځ
 },
 [0x0682]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x062D,
  ["unicodeslot"]=0x0682, -- ڂ
 },
 [0x0683]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NYEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0683, -- ڃ
 },
 [0x0684]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DYEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0684, -- ڄ
 },
 [0x0685]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HAH WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x062D,
  ["unicodeslot"]=0x0685, -- څ
 },
 [0x0686]={
  ["adobename"]="afii57507",
  ["category"]="lo",
  ["description"]="ARABIC LETTER TCHEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0686, -- چ
 },
 [0x0687]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TCHEHEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0687, -- ڇ
 },
 [0x0688]={
  ["adobename"]="afii57512",
  ["category"]="lo",
  ["description"]="ARABIC LETTER DDAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0688, -- ڈ
 },
 [0x0689]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH RING",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x0689, -- ډ
 },
 [0x068A]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x068A, -- ڊ
 },
 [0x068B]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x068B, -- ڋ
 },
 [0x068C]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAHAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x068C, -- ڌ
 },
 [0x068D]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DDAHAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x068D, -- ڍ
 },
 [0x068E]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DUL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x068E, -- ڎ
 },
 [0x068F]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x068F, -- ڏ
 },
 [0x0690]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH FOUR DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x0690, -- ڐ
 },
 [0x0691]={
  ["adobename"]="afii57513",
  ["category"]="lo",
  ["description"]="ARABIC LETTER RREH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0691, -- ڑ
 },
 [0x0692]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH SMALL V",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x0692, -- ڒ
 },
 [0x0693]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH RING",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x0693, -- ړ
 },
 [0x0694]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x0694, -- ڔ
 },
 [0x0695]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH SMALL V BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x0695, -- ڕ
 },
 [0x0696]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x0696, -- ږ
 },
 [0x0697]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH TWO DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x0697, -- ڗ
 },
 [0x0698]={
  ["adobename"]="afii57508",
  ["category"]="lo",
  ["description"]="ARABIC LETTER JEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0698, -- ژ
 },
 [0x0699]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH FOUR DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x0699, -- ڙ
 },
 [0x069A]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0633,
  ["unicodeslot"]=0x069A, -- ښ
 },
 [0x069B]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SEEN WITH THREE DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0633,
  ["unicodeslot"]=0x069B, -- ڛ
 },
 [0x069C]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0633,
  ["unicodeslot"]=0x069C, -- ڜ
 },
 [0x069D]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SAD WITH TWO DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0635,
  ["unicodeslot"]=0x069D, -- ڝ
 },
 [0x069E]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SAD WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0635,
  ["unicodeslot"]=0x069E, -- ڞ
 },
 [0x069F]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TAH WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0637,
  ["unicodeslot"]=0x069F, -- ڟ
 },
 [0x06A0]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER AIN WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0639,
  ["unicodeslot"]=0x06A0, -- ڠ
 },
 [0x06A1]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DOTLESS FEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06A1, -- ڡ
 },
 [0x06A2]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER FEH WITH DOT MOVED BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0641,
  ["unicodeslot"]=0x06A2, -- ڢ
 },
 [0x06A3]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER FEH WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0641,
  ["unicodeslot"]=0x06A3, -- ڣ
 },
 [0x06A4]={
  ["adobename"]="afii57505",
  ["category"]="lo",
  ["description"]="ARABIC LETTER VEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06A4, -- ڤ
 },
 [0x06A5]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER FEH WITH THREE DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0641,
  ["unicodeslot"]=0x06A5, -- ڥ
 },
 [0x06A6]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER PEHEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06A6, -- ڦ
 },
 [0x06A7]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER QAF WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0642,
  ["unicodeslot"]=0x06A7, -- ڧ
 },
 [0x06A8]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER QAF WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0642,
  ["unicodeslot"]=0x06A8, -- ڨ
 },
 [0x06A9]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KEHEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06A9, -- ک
 },
 [0x06AA]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SWASH KAF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06AA, -- ڪ
 },
 [0x06AB]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KAF WITH RING",
  ["linebreak"]="al",
  ["shcode"]=0x0643,
  ["unicodeslot"]=0x06AB, -- ګ
 },
 [0x06AC]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KAF WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0643,
  ["unicodeslot"]=0x06AC, -- ڬ
 },
 [0x06AD]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06AD, -- ڭ
 },
 [0x06AE]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KAF WITH THREE DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0643,
  ["unicodeslot"]=0x06AE, -- ڮ
 },
 [0x06AF]={
  ["adobename"]="afii57509",
  ["category"]="lo",
  ["description"]="ARABIC LETTER GAF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06AF, -- گ
 },
 [0x06B0]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER GAF WITH RING",
  ["linebreak"]="al",
  ["shcode"]=0x06AF,
  ["unicodeslot"]=0x06B0, -- ڰ
 },
 [0x06B1]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NGOEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06B1, -- ڱ
 },
 [0x06B2]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER GAF WITH TWO DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x06AF,
  ["unicodeslot"]=0x06B2, -- ڲ
 },
 [0x06B3]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER GUEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06B3, -- ڳ
 },
 [0x06B4]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER GAF WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x06AF,
  ["unicodeslot"]=0x06B4, -- ڴ
 },
 [0x06B5]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER LAM WITH SMALL V",
  ["linebreak"]="al",
  ["shcode"]=0x0644,
  ["unicodeslot"]=0x06B5, -- ڵ
 },
 [0x06B6]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER LAM WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0644,
  ["unicodeslot"]=0x06B6, -- ڶ
 },
 [0x06B7]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER LAM WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0644,
  ["unicodeslot"]=0x06B7, -- ڷ
 },
 [0x06B8]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER LAM WITH THREE DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0644,
  ["unicodeslot"]=0x06B8, -- ڸ
 },
 [0x06B9]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0646,
  ["unicodeslot"]=0x06B9, -- ڹ
 },
 [0x06BA]={
  ["adobename"]="afii57514",
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON GHUNNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06BA, -- ں
 },
 [0x06BB]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER RNOON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06BB, -- ڻ
 },
 [0x06BC]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON WITH RING",
  ["linebreak"]="al",
  ["shcode"]=0x0646,
  ["unicodeslot"]=0x06BC, -- ڼ
 },
 [0x06BD]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0646,
  ["unicodeslot"]=0x06BD, -- ڽ
 },
 [0x06BE]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HEH DOACHASHMEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06BE, -- ھ
 },
 [0x06BF]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TCHEH WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0686,
  ["unicodeslot"]=0x06BF, -- ڿ
 },
 [0x06C0]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HEH WITH YEH ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0647,
  ["specials"]={ "char", 0x06D5, 0x0654 },
  ["unicodeslot"]=0x06C0, -- ۀ
 },
 [0x06C1]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HEH GOAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06C1, -- ہ
 },
 [0x06C2]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HEH GOAL WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x06C1, 0x0654 },
  ["unicodeslot"]=0x06C2, -- ۂ
 },
 [0x06C3]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER TEH MARBUTA GOAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06C3, -- ۃ
 },
 [0x06C4]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER WAW WITH RING",
  ["linebreak"]="al",
  ["shcode"]=0x0648,
  ["unicodeslot"]=0x06C4, -- ۄ
 },
 [0x06C5]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KIRGHIZ OE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06C5, -- ۅ
 },
 [0x06C6]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER OE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06C6, -- ۆ
 },
 [0x06C7]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06C7, -- ۇ
 },
 [0x06C8]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER YU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06C8, -- ۈ
 },
 [0x06C9]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KIRGHIZ YU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06C9, -- ۉ
 },
 [0x06CA]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER WAW WITH TWO DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0648,
  ["unicodeslot"]=0x06CA, -- ۊ
 },
 [0x06CB]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER VE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06CB, -- ۋ
 },
 [0x06CC]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER FARSI YEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06CC, -- ی
 },
 [0x06CD]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER YEH WITH TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x064A,
  ["unicodeslot"]=0x06CD, -- ۍ
 },
 [0x06CE]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER YEH WITH SMALL V",
  ["linebreak"]="al",
  ["shcode"]=0x064A,
  ["unicodeslot"]=0x06CE, -- ێ
 },
 [0x06CF]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER WAW WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0648,
  ["unicodeslot"]=0x06CF, -- ۏ
 },
 [0x06D0]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06D0, -- ې
 },
 [0x06D1]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER YEH WITH THREE DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x064A,
  ["unicodeslot"]=0x06D1, -- ۑ
 },
 [0x06D2]={
  ["adobename"]="afii57519",
  ["category"]="lo",
  ["description"]="ARABIC LETTER YEH BARREE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06D2, -- ے
 },
 [0x06D3]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER YEH BARREE WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x06D2, 0x0654 },
  ["unicodeslot"]=0x06D3, -- ۓ
 },
 [0x06D4]={
  ["category"]="po",
  ["description"]="ARABIC FULL STOP",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x06D4, -- ۔
 },
 [0x06D5]={
  ["adobename"]="afii57534",
  ["category"]="lo",
  ["description"]="ARABIC LETTER AE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06D5, -- ە
 },
 [0x06D6]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06D6, -- ۖ
 },
 [0x06D7]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06D7, -- ۗ
 },
 [0x06D8]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH MEEM INITIAL FORM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06D8, -- ۘ
 },
 [0x06D9]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH LAM ALEF",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06D9, -- ۙ
 },
 [0x06DA]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH JEEM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06DA, -- ۚ
 },
 [0x06DB]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH THREE DOTS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06DB, -- ۛ
 },
 [0x06DC]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH SEEN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06DC, -- ۜ
 },
 [0x06DD]={
  ["category"]="cf",
  ["description"]="ARABIC END OF AYAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06DD, -- ۝
 },
 [0x06DE]={
  ["category"]="me",
  ["description"]="ARABIC START OF RUB EL HIZB",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06DE, -- ۞
 },
 [0x06DF]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH ROUNDED ZERO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06DF, -- ۟
 },
 [0x06E0]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06E0, -- ۠
 },
 [0x06E1]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH DOTLESS HEAD OF KHAH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06E1, -- ۡ
 },
 [0x06E2]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH MEEM ISOLATED FORM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06E2, -- ۢ
 },
 [0x06E3]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL LOW SEEN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06E3, -- ۣ
 },
 [0x06E4]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH MADDA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06E4, -- ۤ
 },
 [0x06E5]={
  ["category"]="lm",
  ["description"]="ARABIC SMALL WAW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06E5, -- ۥ
 },
 [0x06E6]={
  ["category"]="lm",
  ["description"]="ARABIC SMALL YEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06E6, -- ۦ
 },
 [0x06E7]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH YEH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06E7, -- ۧ
 },
 [0x06E8]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL HIGH NOON",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06E8, -- ۨ
 },
 [0x06E9]={
  ["category"]="so",
  ["description"]="ARABIC PLACE OF SAJDAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06E9, -- ۩
 },
 [0x06EA]={
  ["category"]="mn",
  ["description"]="ARABIC EMPTY CENTRE LOW STOP",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06EA, -- ۪
 },
 [0x06EB]={
  ["category"]="mn",
  ["description"]="ARABIC EMPTY CENTRE HIGH STOP",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06EB, -- ۫
 },
 [0x06EC]={
  ["category"]="mn",
  ["description"]="ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06EC, -- ۬
 },
 [0x06ED]={
  ["category"]="mn",
  ["description"]="ARABIC SMALL LOW MEEM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x06ED, -- ۭ
 },
 [0x06EE]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH INVERTED V",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x06EE, -- ۮ
 },
 [0x06EF]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH INVERTED V",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x06EF, -- ۯ
 },
 [0x06F0]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F0, -- ۰
 },
 [0x06F1]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F1, -- ۱
 },
 [0x06F2]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F2, -- ۲
 },
 [0x06F3]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F3, -- ۳
 },
 [0x06F4]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F4, -- ۴
 },
 [0x06F5]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F5, -- ۵
 },
 [0x06F6]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F6, -- ۶
 },
 [0x06F7]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F7, -- ۷
 },
 [0x06F8]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F8, -- ۸
 },
 [0x06F9]={
  ["category"]="nd",
  ["description"]="EXTENDED ARABIC-INDIC DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x06F9, -- ۹
 },
 [0x06FA]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SHEEN WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0634,
  ["unicodeslot"]=0x06FA, -- ۺ
 },
 [0x06FB]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAD WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0636,
  ["unicodeslot"]=0x06FB, -- ۻ
 },
 [0x06FC]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER GHAIN WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x063A,
  ["unicodeslot"]=0x06FC, -- ۼ
 },
 [0x06FD]={
  ["category"]="so",
  ["description"]="ARABIC SIGN SINDHI AMPERSAND",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06FD, -- ۽
 },
 [0x06FE]={
  ["category"]="so",
  ["description"]="ARABIC SIGN SINDHI POSTPOSITION MEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x06FE, -- ۾
 },
 [0x06FF]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HEH WITH INVERTED V",
  ["linebreak"]="al",
  ["shcode"]=0x0647,
  ["unicodeslot"]=0x06FF, -- ۿ
 },
 [0x0700]={
  ["category"]="po",
  ["description"]="SYRIAC END OF PARAGRAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0700, -- ܀
 },
 [0x0701]={
  ["category"]="po",
  ["description"]="SYRIAC SUPRALINEAR FULL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0701, -- ܁
 },
 [0x0702]={
  ["category"]="po",
  ["description"]="SYRIAC SUBLINEAR FULL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0702, -- ܂
 },
 [0x0703]={
  ["category"]="po",
  ["description"]="SYRIAC SUPRALINEAR COLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0703, -- ܃
 },
 [0x0704]={
  ["category"]="po",
  ["description"]="SYRIAC SUBLINEAR COLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0704, -- ܄
 },
 [0x0705]={
  ["category"]="po",
  ["description"]="SYRIAC HORIZONTAL COLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0705, -- ܅
 },
 [0x0706]={
  ["category"]="po",
  ["description"]="SYRIAC COLON SKEWED LEFT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0706, -- ܆
 },
 [0x0707]={
  ["category"]="po",
  ["description"]="SYRIAC COLON SKEWED RIGHT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0707, -- ܇
 },
 [0x0708]={
  ["category"]="po",
  ["description"]="SYRIAC SUPRALINEAR COLON SKEWED LEFT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0708, -- ܈
 },
 [0x0709]={
  ["category"]="po",
  ["description"]="SYRIAC SUBLINEAR COLON SKEWED RIGHT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0709, -- ܉
 },
 [0x070A]={
  ["category"]="po",
  ["description"]="SYRIAC CONTRACTION",
  ["linebreak"]="al",
  ["unicodeslot"]=0x070A, -- ܊
 },
 [0x070B]={
  ["category"]="po",
  ["description"]="SYRIAC HARKLEAN OBELUS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x070B, -- ܋
 },
 [0x070C]={
  ["category"]="po",
  ["description"]="SYRIAC HARKLEAN METOBELUS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x070C, -- ܌
 },
 [0x070D]={
  ["category"]="po",
  ["description"]="SYRIAC HARKLEAN ASTERISCUS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x070D, -- ܍
 },
 [0x070F]={
  ["category"]="cf",
  ["description"]="SYRIAC ABBREVIATION MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x070F, -- ܏
 },
 [0x0710]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER ALAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0710, -- ܐ
 },
 [0x0711]={
  ["category"]="mn",
  ["description"]="SYRIAC LETTER SUPERSCRIPT ALAPH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0711, -- ܑ
 },
 [0x0712]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER BETH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0712, -- ܒ
 },
 [0x0713]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER GAMAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0713, -- ܓ
 },
 [0x0714]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER GAMAL GARSHUNI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0714, -- ܔ
 },
 [0x0715]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER DALATH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0715, -- ܕ
 },
 [0x0716]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER DOTLESS DALATH RISH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0716, -- ܖ
 },
 [0x0717]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0717, -- ܗ
 },
 [0x0718]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER WAW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0718, -- ܘ
 },
 [0x0719]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER ZAIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0719, -- ܙ
 },
 [0x071A]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER HETH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x071A, -- ܚ
 },
 [0x071B]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER TETH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x071B, -- ܛ
 },
 [0x071C]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER TETH GARSHUNI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x071C, -- ܜ
 },
 [0x071D]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER YUDH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x071D, -- ܝ
 },
 [0x071E]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER YUDH HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x071E, -- ܞ
 },
 [0x071F]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER KAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x071F, -- ܟ
 },
 [0x0720]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER LAMADH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0720, -- ܠ
 },
 [0x0721]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER MIM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0721, -- ܡ
 },
 [0x0722]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER NUN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0722, -- ܢ
 },
 [0x0723]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER SEMKATH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0723, -- ܣ
 },
 [0x0724]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER FINAL SEMKATH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0724, -- ܤ
 },
 [0x0725]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0725, -- ܥ
 },
 [0x0726]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER PE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0726, -- ܦ
 },
 [0x0727]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER REVERSED PE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0727, -- ܧ
 },
 [0x0728]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER SADHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0728, -- ܨ
 },
 [0x0729]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER QAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0729, -- ܩ
 },
 [0x072A]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER RISH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x072A, -- ܪ
 },
 [0x072B]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER SHIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x072B, -- ܫ
 },
 [0x072C]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER TAW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x072C, -- ܬ
 },
 [0x072D]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER PERSIAN BHETH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x072D, -- ܭ
 },
 [0x072E]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER PERSIAN GHAMAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x072E, -- ܮ
 },
 [0x072F]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER PERSIAN DHALATH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x072F, -- ܯ
 },
 [0x0730]={
  ["category"]="mn",
  ["description"]="SYRIAC PTHAHA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0730, -- ܰ
 },
 [0x0731]={
  ["category"]="mn",
  ["description"]="SYRIAC PTHAHA BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0731, -- ܱ
 },
 [0x0732]={
  ["category"]="mn",
  ["description"]="SYRIAC PTHAHA DOTTED",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0732, -- ܲ
 },
 [0x0733]={
  ["category"]="mn",
  ["description"]="SYRIAC ZQAPHA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0733, -- ܳ
 },
 [0x0734]={
  ["category"]="mn",
  ["description"]="SYRIAC ZQAPHA BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0734, -- ܴ
 },
 [0x0735]={
  ["category"]="mn",
  ["description"]="SYRIAC ZQAPHA DOTTED",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0735, -- ܵ
 },
 [0x0736]={
  ["category"]="mn",
  ["description"]="SYRIAC RBASA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0736, -- ܶ
 },
 [0x0737]={
  ["category"]="mn",
  ["description"]="SYRIAC RBASA BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0737, -- ܷ
 },
 [0x0738]={
  ["category"]="mn",
  ["description"]="SYRIAC DOTTED ZLAMA HORIZONTAL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0738, -- ܸ
 },
 [0x0739]={
  ["category"]="mn",
  ["description"]="SYRIAC DOTTED ZLAMA ANGULAR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0739, -- ܹ
 },
 [0x073A]={
  ["category"]="mn",
  ["description"]="SYRIAC HBASA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x073A, -- ܺ
 },
 [0x073B]={
  ["category"]="mn",
  ["description"]="SYRIAC HBASA BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x073B, -- ܻ
 },
 [0x073C]={
  ["category"]="mn",
  ["description"]="SYRIAC HBASA-ESASA DOTTED",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x073C, -- ܼ
 },
 [0x073D]={
  ["category"]="mn",
  ["description"]="SYRIAC ESASA ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x073D, -- ܽ
 },
 [0x073E]={
  ["category"]="mn",
  ["description"]="SYRIAC ESASA BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x073E, -- ܾ
 },
 [0x073F]={
  ["category"]="mn",
  ["description"]="SYRIAC RWAHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x073F, -- ܿ
 },
 [0x0740]={
  ["category"]="mn",
  ["description"]="SYRIAC FEMININE DOT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0740, -- ݀
 },
 [0x0741]={
  ["category"]="mn",
  ["description"]="SYRIAC QUSHSHAYA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0741, -- ݁
 },
 [0x0742]={
  ["category"]="mn",
  ["description"]="SYRIAC RUKKAKHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0742, -- ݂
 },
 [0x0743]={
  ["category"]="mn",
  ["description"]="SYRIAC TWO VERTICAL DOTS ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0743, -- ݃
 },
 [0x0744]={
  ["category"]="mn",
  ["description"]="SYRIAC TWO VERTICAL DOTS BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0744, -- ݄
 },
 [0x0745]={
  ["category"]="mn",
  ["description"]="SYRIAC THREE DOTS ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0745, -- ݅
 },
 [0x0746]={
  ["category"]="mn",
  ["description"]="SYRIAC THREE DOTS BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0746, -- ݆
 },
 [0x0747]={
  ["category"]="mn",
  ["description"]="SYRIAC OBLIQUE LINE ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0747, -- ݇
 },
 [0x0748]={
  ["category"]="mn",
  ["description"]="SYRIAC OBLIQUE LINE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0748, -- ݈
 },
 [0x0749]={
  ["category"]="mn",
  ["description"]="SYRIAC MUSIC",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0749, -- ݉
 },
 [0x074A]={
  ["category"]="mn",
  ["description"]="SYRIAC BARREKH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x074A, -- ݊
 },
 [0x074D]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER SOGDIAN ZHAIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x074D, -- ݍ
 },
 [0x074E]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER SOGDIAN KHAPH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x074E, -- ݎ
 },
 [0x074F]={
  ["category"]="lo",
  ["description"]="SYRIAC LETTER SOGDIAN FE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x074F, -- ݏ
 },
 [0x0750]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0628,
  ["unicodeslot"]=0x0750, -- ݐ
 },
 [0x0751]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0628,
  ["unicodeslot"]=0x0751, -- ݑ
 },
 [0x0752]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0628,
  ["unicodeslot"]=0x0752, -- ݒ
 },
 [0x0753]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0628,
  ["unicodeslot"]=0x0753, -- ݓ
 },
 [0x0754]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0628,
  ["unicodeslot"]=0x0754, -- ݔ
 },
 [0x0755]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH WITH INVERTED SMALL V BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0628,
  ["unicodeslot"]=0x0755, -- ݕ
 },
 [0x0756]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER BEH WITH SMALL V",
  ["linebreak"]="al",
  ["shcode"]=0x0628,
  ["unicodeslot"]=0x0756, -- ݖ
 },
 [0x0757]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HAH WITH TWO DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x062D,
  ["unicodeslot"]=0x0757, -- ݗ
 },
 [0x0758]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x062D,
  ["unicodeslot"]=0x0758, -- ݘ
 },
 [0x0759]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x0759, -- ݙ
 },
 [0x075A]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER DAL WITH INVERTED SMALL V BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x062F,
  ["unicodeslot"]=0x075A, -- ݚ
 },
 [0x075B]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x075B, -- ݛ
 },
 [0x075C]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SEEN WITH FOUR DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0633,
  ["unicodeslot"]=0x075C, -- ݜ
 },
 [0x075D]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER AIN WITH TWO DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0639,
  ["unicodeslot"]=0x075D, -- ݝ
 },
 [0x075E]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0639,
  ["unicodeslot"]=0x075E, -- ݞ
 },
 [0x075F]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0639,
  ["unicodeslot"]=0x075F, -- ݟ
 },
 [0x0760]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER FEH WITH TWO DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0641,
  ["unicodeslot"]=0x0760, -- ݠ
 },
 [0x0761]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0641,
  ["unicodeslot"]=0x0761, -- ݡ
 },
 [0x0762]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KEHEH WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x06A9,
  ["unicodeslot"]=0x0762, -- ݢ
 },
 [0x0763]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KEHEH WITH THREE DOTS ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x06A9,
  ["unicodeslot"]=0x0763, -- ݣ
 },
 [0x0764]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x06A9,
  ["unicodeslot"]=0x0764, -- ݤ
 },
 [0x0765]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER MEEM WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0645,
  ["unicodeslot"]=0x0765, -- ݥ
 },
 [0x0766]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER MEEM WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0645,
  ["unicodeslot"]=0x0766, -- ݦ
 },
 [0x0767]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON WITH TWO DOTS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0646,
  ["unicodeslot"]=0x0767, -- ݧ
 },
 [0x0768]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON WITH SMALL TAH",
  ["linebreak"]="al",
  ["shcode"]=0x0646,
  ["unicodeslot"]=0x0768, -- ݨ
 },
 [0x0769]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER NOON WITH SMALL V",
  ["linebreak"]="al",
  ["shcode"]=0x0646,
  ["unicodeslot"]=0x0769, -- ݩ
 },
 [0x076A]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER LAM WITH BAR",
  ["linebreak"]="al",
  ["shcode"]=0x0644,
  ["unicodeslot"]=0x076A, -- ݪ
 },
 [0x076B]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x076B, -- ݫ
 },
 [0x076C]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER REH WITH HAMZA ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0631,
  ["unicodeslot"]=0x076C, -- ݬ
 },
 [0x076D]={
  ["category"]="lo",
  ["description"]="ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0633,
  ["unicodeslot"]=0x076D, -- ݭ
 },
 [0x0780]={
  ["category"]="lo",
  ["description"]="THAANA LETTER HAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0780, -- ހ
 },
 [0x0781]={
  ["category"]="lo",
  ["description"]="THAANA LETTER SHAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0781, -- ށ
 },
 [0x0782]={
  ["category"]="lo",
  ["description"]="THAANA LETTER NOONU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0782, -- ނ
 },
 [0x0783]={
  ["category"]="lo",
  ["description"]="THAANA LETTER RAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0783, -- ރ
 },
 [0x0784]={
  ["category"]="lo",
  ["description"]="THAANA LETTER BAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0784, -- ބ
 },
 [0x0785]={
  ["category"]="lo",
  ["description"]="THAANA LETTER LHAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0785, -- ޅ
 },
 [0x0786]={
  ["category"]="lo",
  ["description"]="THAANA LETTER KAAFU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0786, -- ކ
 },
 [0x0787]={
  ["category"]="lo",
  ["description"]="THAANA LETTER ALIFU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0787, -- އ
 },
 [0x0788]={
  ["category"]="lo",
  ["description"]="THAANA LETTER VAAVU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0788, -- ވ
 },
 [0x0789]={
  ["category"]="lo",
  ["description"]="THAANA LETTER MEEMU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0789, -- މ
 },
 [0x078A]={
  ["category"]="lo",
  ["description"]="THAANA LETTER FAAFU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x078A, -- ފ
 },
 [0x078B]={
  ["category"]="lo",
  ["description"]="THAANA LETTER DHAALU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x078B, -- ދ
 },
 [0x078C]={
  ["category"]="lo",
  ["description"]="THAANA LETTER THAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x078C, -- ތ
 },
 [0x078D]={
  ["category"]="lo",
  ["description"]="THAANA LETTER LAAMU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x078D, -- ލ
 },
 [0x078E]={
  ["category"]="lo",
  ["description"]="THAANA LETTER GAAFU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x078E, -- ގ
 },
 [0x078F]={
  ["category"]="lo",
  ["description"]="THAANA LETTER GNAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x078F, -- ޏ
 },
 [0x0790]={
  ["category"]="lo",
  ["description"]="THAANA LETTER SEENU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0790, -- ސ
 },
 [0x0791]={
  ["category"]="lo",
  ["description"]="THAANA LETTER DAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0791, -- ޑ
 },
 [0x0792]={
  ["category"]="lo",
  ["description"]="THAANA LETTER ZAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0792, -- ޒ
 },
 [0x0793]={
  ["category"]="lo",
  ["description"]="THAANA LETTER TAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0793, -- ޓ
 },
 [0x0794]={
  ["category"]="lo",
  ["description"]="THAANA LETTER YAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0794, -- ޔ
 },
 [0x0795]={
  ["category"]="lo",
  ["description"]="THAANA LETTER PAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0795, -- ޕ
 },
 [0x0796]={
  ["category"]="lo",
  ["description"]="THAANA LETTER JAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0796, -- ޖ
 },
 [0x0797]={
  ["category"]="lo",
  ["description"]="THAANA LETTER CHAVIYANI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0797, -- ޗ
 },
 [0x0798]={
  ["category"]="lo",
  ["description"]="THAANA LETTER TTAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0798, -- ޘ
 },
 [0x0799]={
  ["category"]="lo",
  ["description"]="THAANA LETTER HHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0799, -- ޙ
 },
 [0x079A]={
  ["category"]="lo",
  ["description"]="THAANA LETTER KHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x079A, -- ޚ
 },
 [0x079B]={
  ["category"]="lo",
  ["description"]="THAANA LETTER THAALU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x079B, -- ޛ
 },
 [0x079C]={
  ["category"]="lo",
  ["description"]="THAANA LETTER ZAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x079C, -- ޜ
 },
 [0x079D]={
  ["category"]="lo",
  ["description"]="THAANA LETTER SHEENU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x079D, -- ޝ
 },
 [0x079E]={
  ["category"]="lo",
  ["description"]="THAANA LETTER SAADHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x079E, -- ޞ
 },
 [0x079F]={
  ["category"]="lo",
  ["description"]="THAANA LETTER DAADHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x079F, -- ޟ
 },
 [0x07A0]={
  ["category"]="lo",
  ["description"]="THAANA LETTER TO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07A0, -- ޠ
 },
 [0x07A1]={
  ["category"]="lo",
  ["description"]="THAANA LETTER ZO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07A1, -- ޡ
 },
 [0x07A2]={
  ["category"]="lo",
  ["description"]="THAANA LETTER AINU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07A2, -- ޢ
 },
 [0x07A3]={
  ["category"]="lo",
  ["description"]="THAANA LETTER GHAINU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07A3, -- ޣ
 },
 [0x07A4]={
  ["category"]="lo",
  ["description"]="THAANA LETTER QAAFU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07A4, -- ޤ
 },
 [0x07A5]={
  ["category"]="lo",
  ["description"]="THAANA LETTER WAAVU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07A5, -- ޥ
 },
 [0x07A6]={
  ["category"]="mn",
  ["description"]="THAANA ABAFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07A6, -- ަ
 },
 [0x07A7]={
  ["category"]="mn",
  ["description"]="THAANA AABAAFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07A7, -- ާ
 },
 [0x07A8]={
  ["category"]="mn",
  ["description"]="THAANA IBIFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07A8, -- ި
 },
 [0x07A9]={
  ["category"]="mn",
  ["description"]="THAANA EEBEEFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07A9, -- ީ
 },
 [0x07AA]={
  ["category"]="mn",
  ["description"]="THAANA UBUFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07AA, -- ު
 },
 [0x07AB]={
  ["category"]="mn",
  ["description"]="THAANA OOBOOFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07AB, -- ޫ
 },
 [0x07AC]={
  ["category"]="mn",
  ["description"]="THAANA EBEFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07AC, -- ެ
 },
 [0x07AD]={
  ["category"]="mn",
  ["description"]="THAANA EYBEYFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07AD, -- ޭ
 },
 [0x07AE]={
  ["category"]="mn",
  ["description"]="THAANA OBOFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07AE, -- ޮ
 },
 [0x07AF]={
  ["category"]="mn",
  ["description"]="THAANA OABOAFILI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07AF, -- ޯ
 },
 [0x07B0]={
  ["category"]="mn",
  ["description"]="THAANA SUKUN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07B0, -- ް
 },
 [0x07B1]={
  ["category"]="lo",
  ["description"]="THAANA LETTER NAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07B1, -- ޱ
 },
 [0x07C0]={
  ["category"]="nd",
  ["description"]="NKO DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C0, -- ߀
 },
 [0x07C1]={
  ["category"]="nd",
  ["description"]="NKO DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C1, -- ߁
 },
 [0x07C2]={
  ["category"]="nd",
  ["description"]="NKO DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C2, -- ߂
 },
 [0x07C3]={
  ["category"]="nd",
  ["description"]="NKO DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C3, -- ߃
 },
 [0x07C4]={
  ["category"]="nd",
  ["description"]="NKO DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C4, -- ߄
 },
 [0x07C5]={
  ["category"]="nd",
  ["description"]="NKO DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C5, -- ߅
 },
 [0x07C6]={
  ["category"]="nd",
  ["description"]="NKO DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C6, -- ߆
 },
 [0x07C7]={
  ["category"]="nd",
  ["description"]="NKO DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C7, -- ߇
 },
 [0x07C8]={
  ["category"]="nd",
  ["description"]="NKO DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C8, -- ߈
 },
 [0x07C9]={
  ["category"]="nd",
  ["description"]="NKO DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x07C9, -- ߉
 },
 [0x07CA]={
  ["category"]="lo",
  ["description"]="NKO LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07CA, -- ߊ
 },
 [0x07CB]={
  ["category"]="lo",
  ["description"]="NKO LETTER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07CB, -- ߋ
 },
 [0x07CC]={
  ["category"]="lo",
  ["description"]="NKO LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07CC, -- ߌ
 },
 [0x07CD]={
  ["category"]="lo",
  ["description"]="NKO LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07CD, -- ߍ
 },
 [0x07CE]={
  ["category"]="lo",
  ["description"]="NKO LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07CE, -- ߎ
 },
 [0x07CF]={
  ["category"]="lo",
  ["description"]="NKO LETTER OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07CF, -- ߏ
 },
 [0x07D0]={
  ["category"]="lo",
  ["description"]="NKO LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D0, -- ߐ
 },
 [0x07D1]={
  ["category"]="lo",
  ["description"]="NKO LETTER DAGBASINNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D1, -- ߑ
 },
 [0x07D2]={
  ["category"]="lo",
  ["description"]="NKO LETTER N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D2, -- ߒ
 },
 [0x07D3]={
  ["category"]="lo",
  ["description"]="NKO LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D3, -- ߓ
 },
 [0x07D4]={
  ["category"]="lo",
  ["description"]="NKO LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D4, -- ߔ
 },
 [0x07D5]={
  ["category"]="lo",
  ["description"]="NKO LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D5, -- ߕ
 },
 [0x07D6]={
  ["category"]="lo",
  ["description"]="NKO LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D6, -- ߖ
 },
 [0x07D7]={
  ["category"]="lo",
  ["description"]="NKO LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D7, -- ߗ
 },
 [0x07D8]={
  ["category"]="lo",
  ["description"]="NKO LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D8, -- ߘ
 },
 [0x07D9]={
  ["category"]="lo",
  ["description"]="NKO LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07D9, -- ߙ
 },
 [0x07DA]={
  ["category"]="lo",
  ["description"]="NKO LETTER RRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07DA, -- ߚ
 },
 [0x07DB]={
  ["category"]="lo",
  ["description"]="NKO LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07DB, -- ߛ
 },
 [0x07DC]={
  ["category"]="lo",
  ["description"]="NKO LETTER GBA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07DC, -- ߜ
 },
 [0x07DD]={
  ["category"]="lo",
  ["description"]="NKO LETTER FA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07DD, -- ߝ
 },
 [0x07DE]={
  ["category"]="lo",
  ["description"]="NKO LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07DE, -- ߞ
 },
 [0x07DF]={
  ["category"]="lo",
  ["description"]="NKO LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07DF, -- ߟ
 },
 [0x07E0]={
  ["category"]="lo",
  ["description"]="NKO LETTER NA WOLOSO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E0, -- ߠ
 },
 [0x07E1]={
  ["category"]="lo",
  ["description"]="NKO LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E1, -- ߡ
 },
 [0x07E2]={
  ["category"]="lo",
  ["description"]="NKO LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E2, -- ߢ
 },
 [0x07E3]={
  ["category"]="lo",
  ["description"]="NKO LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E3, -- ߣ
 },
 [0x07E4]={
  ["category"]="lo",
  ["description"]="NKO LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E4, -- ߤ
 },
 [0x07E5]={
  ["category"]="lo",
  ["description"]="NKO LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E5, -- ߥ
 },
 [0x07E6]={
  ["category"]="lo",
  ["description"]="NKO LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E6, -- ߦ
 },
 [0x07E7]={
  ["category"]="lo",
  ["description"]="NKO LETTER NYA WOLOSO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E7, -- ߧ
 },
 [0x07E8]={
  ["category"]="lo",
  ["description"]="NKO LETTER JONA JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E8, -- ߨ
 },
 [0x07E9]={
  ["category"]="lo",
  ["description"]="NKO LETTER JONA CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07E9, -- ߩ
 },
 [0x07EA]={
  ["category"]="lo",
  ["description"]="NKO LETTER JONA RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07EA, -- ߪ
 },
 [0x07EB]={
  ["category"]="mn",
  ["description"]="NKO COMBINING SHORT HIGH TONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07EB, -- ߫
 },
 [0x07EC]={
  ["category"]="mn",
  ["description"]="NKO COMBINING SHORT LOW TONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07EC, -- ߬
 },
 [0x07ED]={
  ["category"]="mn",
  ["description"]="NKO COMBINING SHORT RISING TONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07ED, -- ߭
 },
 [0x07EE]={
  ["category"]="mn",
  ["description"]="NKO COMBINING LONG DESCENDING TONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07EE, -- ߮
 },
 [0x07EF]={
  ["category"]="mn",
  ["description"]="NKO COMBINING LONG HIGH TONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07EF, -- ߯
 },
 [0x07F0]={
  ["category"]="mn",
  ["description"]="NKO COMBINING LONG LOW TONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07F0, -- ߰
 },
 [0x07F1]={
  ["category"]="mn",
  ["description"]="NKO COMBINING LONG RISING TONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07F1, -- ߱
 },
 [0x07F2]={
  ["category"]="mn",
  ["description"]="NKO COMBINING NASALIZATION MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07F2, -- ߲
 },
 [0x07F3]={
  ["category"]="mn",
  ["description"]="NKO COMBINING DOUBLE DOT ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x07F3, -- ߳
 },
 [0x07F4]={
  ["category"]="lm",
  ["description"]="NKO HIGH TONE APOSTROPHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07F4, -- ߴ
 },
 [0x07F5]={
  ["category"]="lm",
  ["description"]="NKO LOW TONE APOSTROPHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07F5, -- ߵ
 },
 [0x07F6]={
  ["category"]="so",
  ["description"]="NKO SYMBOL OO DENNEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07F6, -- ߶
 },
 [0x07F7]={
  ["category"]="po",
  ["description"]="NKO SYMBOL GBAKURUNEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07F7, -- ߷
 },
 [0x07F8]={
  ["category"]="po",
  ["description"]="NKO COMMA",
  ["linebreak"]="is",
  ["unicodeslot"]=0x07F8, -- ߸
 },
 [0x07F9]={
  ["category"]="po",
  ["description"]="NKO EXCLAMATION MARK",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x07F9, -- ߹
 },
 [0x07FA]={
  ["category"]="lm",
  ["description"]="NKO LAJANYALAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x07FA, -- ߺ
 },
 [0x0901]={
  ["category"]="mn",
  ["description"]="DEVANAGARI SIGN CANDRABINDU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0901, -- ँ
 },
 [0x0902]={
  ["category"]="mn",
  ["description"]="DEVANAGARI SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0902, -- ं
 },
 [0x0903]={
  ["category"]="mc",
  ["description"]="DEVANAGARI SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0903, -- ः
 },
 [0x0904]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER SHORT A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0904, -- ऄ
 },
 [0x0905]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0905, -- अ
 },
 [0x0906]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0906, -- आ
 },
 [0x0907]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0907, -- इ
 },
 [0x0908]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0908, -- ई
 },
 [0x0909]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0909, -- उ
 },
 [0x090A]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x090A, -- ऊ
 },
 [0x090B]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER VOCALIC R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x090B, -- ऋ
 },
 [0x090C]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER VOCALIC L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x090C, -- ऌ
 },
 [0x090D]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER CANDRA E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x090D, -- ऍ
 },
 [0x090E]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER SHORT E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x090E, -- ऎ
 },
 [0x090F]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x090F, -- ए
 },
 [0x0910]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0910, -- ऐ
 },
 [0x0911]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER CANDRA O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0911, -- ऑ
 },
 [0x0912]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER SHORT O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0912, -- ऒ
 },
 [0x0913]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0913, -- ओ
 },
 [0x0914]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0914, -- औ
 },
 [0x0915]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0915, -- क
 },
 [0x0916]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0916, -- ख
 },
 [0x0917]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0917, -- ग
 },
 [0x0918]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0918, -- घ
 },
 [0x0919]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0919, -- ङ
 },
 [0x091A]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x091A, -- च
 },
 [0x091B]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x091B, -- छ
 },
 [0x091C]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x091C, -- ज
 },
 [0x091D]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x091D, -- झ
 },
 [0x091E]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x091E, -- ञ
 },
 [0x091F]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x091F, -- ट
 },
 [0x0920]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0920, -- ठ
 },
 [0x0921]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0921, -- ड
 },
 [0x0922]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0922, -- ढ
 },
 [0x0923]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0923, -- ण
 },
 [0x0924]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0924, -- त
 },
 [0x0925]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0925, -- थ
 },
 [0x0926]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0926, -- द
 },
 [0x0927]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0927, -- ध
 },
 [0x0928]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0928, -- न
 },
 [0x0929]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER NNNA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0928, 0x093C },
  ["unicodeslot"]=0x0929, -- ऩ
 },
 [0x092A]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x092A, -- प
 },
 [0x092B]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x092B, -- फ
 },
 [0x092C]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x092C, -- ब
 },
 [0x092D]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x092D, -- भ
 },
 [0x092E]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x092E, -- म
 },
 [0x092F]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x092F, -- य
 },
 [0x0930]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0930, -- र
 },
 [0x0931]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER RRA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0930, 0x093C },
  ["unicodeslot"]=0x0931, -- ऱ
 },
 [0x0932]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0932, -- ल
 },
 [0x0933]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER LLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0933, -- ळ
 },
 [0x0934]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER LLLA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0933, 0x093C },
  ["unicodeslot"]=0x0934, -- ऴ
 },
 [0x0935]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0935, -- व
 },
 [0x0936]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0936, -- श
 },
 [0x0937]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0937, -- ष
 },
 [0x0938]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0938, -- स
 },
 [0x0939]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0939, -- ह
 },
 [0x093C]={
  ["category"]="mn",
  ["description"]="DEVANAGARI SIGN NUKTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x093C, -- ़
 },
 [0x093D]={
  ["category"]="lo",
  ["description"]="DEVANAGARI SIGN AVAGRAHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x093D, -- ऽ
 },
 [0x093E]={
  ["category"]="mc",
  ["description"]="DEVANAGARI VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x093E, -- ा
 },
 [0x093F]={
  ["category"]="mc",
  ["description"]="DEVANAGARI VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x093F, -- ि
 },
 [0x0940]={
  ["category"]="mc",
  ["description"]="DEVANAGARI VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0940, -- ी
 },
 [0x0941]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0941, -- ु
 },
 [0x0942]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0942, -- ू
 },
 [0x0943]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0943, -- ृ
 },
 [0x0944]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN VOCALIC RR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0944, -- ॄ
 },
 [0x0945]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN CANDRA E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0945, -- ॅ
 },
 [0x0946]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN SHORT E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0946, -- ॆ
 },
 [0x0947]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0947, -- े
 },
 [0x0948]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0948, -- ै
 },
 [0x0949]={
  ["category"]="mc",
  ["description"]="DEVANAGARI VOWEL SIGN CANDRA O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0949, -- ॉ
 },
 [0x094A]={
  ["category"]="mc",
  ["description"]="DEVANAGARI VOWEL SIGN SHORT O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x094A, -- ॊ
 },
 [0x094B]={
  ["category"]="mc",
  ["description"]="DEVANAGARI VOWEL SIGN O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x094B, -- ो
 },
 [0x094C]={
  ["category"]="mc",
  ["description"]="DEVANAGARI VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x094C, -- ौ
 },
 [0x094D]={
  ["category"]="mn",
  ["description"]="DEVANAGARI SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x094D, -- ्
 },
 [0x0950]={
  ["category"]="lo",
  ["description"]="DEVANAGARI OM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0950, -- ॐ
 },
 [0x0951]={
  ["category"]="mn",
  ["description"]="DEVANAGARI STRESS SIGN UDATTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0951, -- ॑
 },
 [0x0952]={
  ["category"]="mn",
  ["description"]="DEVANAGARI STRESS SIGN ANUDATTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0952, -- ॒
 },
 [0x0953]={
  ["category"]="mn",
  ["description"]="DEVANAGARI GRAVE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0953, -- ॓
 },
 [0x0954]={
  ["category"]="mn",
  ["description"]="DEVANAGARI ACUTE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0954, -- ॔
 },
 [0x0958]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER QA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0915, 0x093C },
  ["unicodeslot"]=0x0958, -- क़
 },
 [0x0959]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER KHHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0916, 0x093C },
  ["unicodeslot"]=0x0959, -- ख़
 },
 [0x095A]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER GHHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0917, 0x093C },
  ["unicodeslot"]=0x095A, -- ग़
 },
 [0x095B]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER ZA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x091C, 0x093C },
  ["unicodeslot"]=0x095B, -- ज़
 },
 [0x095C]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER DDDHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0921, 0x093C },
  ["unicodeslot"]=0x095C, -- ड़
 },
 [0x095D]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER RHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0922, 0x093C },
  ["unicodeslot"]=0x095D, -- ढ़
 },
 [0x095E]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER FA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x092B, 0x093C },
  ["unicodeslot"]=0x095E, -- फ़
 },
 [0x095F]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER YYA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x092F, 0x093C },
  ["unicodeslot"]=0x095F, -- य़
 },
 [0x0960]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER VOCALIC RR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0960, -- ॠ
 },
 [0x0961]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER VOCALIC LL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0961, -- ॡ
 },
 [0x0962]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN VOCALIC L",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0962, -- ॢ
 },
 [0x0963]={
  ["category"]="mn",
  ["description"]="DEVANAGARI VOWEL SIGN VOCALIC LL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0963, -- ॣ
 },
 [0x0964]={
  ["category"]="po",
  ["description"]="DEVANAGARI DANDA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0964, -- ।
 },
 [0x0965]={
  ["category"]="po",
  ["description"]="DEVANAGARI DOUBLE DANDA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0965, -- ॥
 },
 [0x0966]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0966, -- ०
 },
 [0x0967]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0967, -- १
 },
 [0x0968]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0968, -- २
 },
 [0x0969]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0969, -- ३
 },
 [0x096A]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x096A, -- ४
 },
 [0x096B]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x096B, -- ५
 },
 [0x096C]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x096C, -- ६
 },
 [0x096D]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x096D, -- ७
 },
 [0x096E]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x096E, -- ८
 },
 [0x096F]={
  ["category"]="nd",
  ["description"]="DEVANAGARI DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x096F, -- ९
 },
 [0x0970]={
  ["category"]="po",
  ["description"]="DEVANAGARI ABBREVIATION SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0970, -- ॰
 },
 [0x097B]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER GGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x097B, -- ॻ
 },
 [0x097C]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER JJA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x097C, -- ॼ
 },
 [0x097D]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER GLOTTAL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x097D, -- ॽ
 },
 [0x097E]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER DDDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x097E, -- ॾ
 },
 [0x097F]={
  ["category"]="lo",
  ["description"]="DEVANAGARI LETTER BBA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x097F, -- ॿ
 },
 [0x0981]={
  ["category"]="mn",
  ["description"]="BENGALI SIGN CANDRABINDU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0981, -- ঁ
 },
 [0x0982]={
  ["category"]="mc",
  ["description"]="BENGALI SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0982, -- ং
 },
 [0x0983]={
  ["category"]="mc",
  ["description"]="BENGALI SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0983, -- ঃ
 },
 [0x0985]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0985, -- অ
 },
 [0x0986]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0986, -- আ
 },
 [0x0987]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0987, -- ই
 },
 [0x0988]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0988, -- ঈ
 },
 [0x0989]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0989, -- উ
 },
 [0x098A]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x098A, -- ঊ
 },
 [0x098B]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER VOCALIC R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x098B, -- ঋ
 },
 [0x098C]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER VOCALIC L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x098C, -- ঌ
 },
 [0x098F]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x098F, -- এ
 },
 [0x0990]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0990, -- ঐ
 },
 [0x0993]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0993, -- ও
 },
 [0x0994]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0994, -- ঔ
 },
 [0x0995]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0995, -- ক
 },
 [0x0996]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0996, -- খ
 },
 [0x0997]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0997, -- গ
 },
 [0x0998]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0998, -- ঘ
 },
 [0x0999]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0999, -- ঙ
 },
 [0x099A]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x099A, -- চ
 },
 [0x099B]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x099B, -- ছ
 },
 [0x099C]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x099C, -- জ
 },
 [0x099D]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x099D, -- ঝ
 },
 [0x099E]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x099E, -- ঞ
 },
 [0x099F]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x099F, -- ট
 },
 [0x09A0]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A0, -- ঠ
 },
 [0x09A1]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A1, -- ড
 },
 [0x09A2]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A2, -- ঢ
 },
 [0x09A3]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A3, -- ণ
 },
 [0x09A4]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A4, -- ত
 },
 [0x09A5]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A5, -- থ
 },
 [0x09A6]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A6, -- দ
 },
 [0x09A7]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A7, -- ধ
 },
 [0x09A8]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09A8, -- ন
 },
 [0x09AA]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09AA, -- প
 },
 [0x09AB]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09AB, -- ফ
 },
 [0x09AC]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09AC, -- ব
 },
 [0x09AD]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09AD, -- ভ
 },
 [0x09AE]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09AE, -- ম
 },
 [0x09AF]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09AF, -- য
 },
 [0x09B0]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09B0, -- র
 },
 [0x09B2]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09B2, -- ল
 },
 [0x09B6]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09B6, -- শ
 },
 [0x09B7]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09B7, -- ষ
 },
 [0x09B8]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09B8, -- স
 },
 [0x09B9]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09B9, -- হ
 },
 [0x09BC]={
  ["category"]="mn",
  ["description"]="BENGALI SIGN NUKTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09BC, -- ়
 },
 [0x09BD]={
  ["category"]="lo",
  ["description"]="BENGALI SIGN AVAGRAHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09BD, -- ঽ
 },
 [0x09BE]={
  ["category"]="mc",
  ["description"]="BENGALI VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09BE, -- া
 },
 [0x09BF]={
  ["category"]="mc",
  ["description"]="BENGALI VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09BF, -- ি
 },
 [0x09C0]={
  ["category"]="mc",
  ["description"]="BENGALI VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09C0, -- ী
 },
 [0x09C1]={
  ["category"]="mn",
  ["description"]="BENGALI VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09C1, -- ু
 },
 [0x09C2]={
  ["category"]="mn",
  ["description"]="BENGALI VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09C2, -- ূ
 },
 [0x09C3]={
  ["category"]="mn",
  ["description"]="BENGALI VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09C3, -- ৃ
 },
 [0x09C4]={
  ["category"]="mn",
  ["description"]="BENGALI VOWEL SIGN VOCALIC RR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09C4, -- ৄ
 },
 [0x09C7]={
  ["category"]="mc",
  ["description"]="BENGALI VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09C7, -- ে
 },
 [0x09C8]={
  ["category"]="mc",
  ["description"]="BENGALI VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09C8, -- ৈ
 },
 [0x09CB]={
  ["category"]="mc",
  ["description"]="BENGALI VOWEL SIGN O",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x09C7, 0x09BE },
  ["unicodeslot"]=0x09CB, -- ো
 },
 [0x09CC]={
  ["category"]="mc",
  ["description"]="BENGALI VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x09C7, 0x09D7 },
  ["unicodeslot"]=0x09CC, -- ৌ
 },
 [0x09CD]={
  ["category"]="mn",
  ["description"]="BENGALI SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09CD, -- ্
 },
 [0x09CE]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER KHANDA TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09CE, -- ৎ
 },
 [0x09D7]={
  ["category"]="mc",
  ["description"]="BENGALI AU LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09D7, -- ৗ
 },
 [0x09DC]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER RRA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x09A1, 0x09BC },
  ["unicodeslot"]=0x09DC, -- ড়
 },
 [0x09DD]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER RHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x09A2, 0x09BC },
  ["unicodeslot"]=0x09DD, -- ঢ়
 },
 [0x09DF]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER YYA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x09AF, 0x09BC },
  ["unicodeslot"]=0x09DF, -- য়
 },
 [0x09E0]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER VOCALIC RR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09E0, -- ৠ
 },
 [0x09E1]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER VOCALIC LL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09E1, -- ৡ
 },
 [0x09E2]={
  ["category"]="mn",
  ["description"]="BENGALI VOWEL SIGN VOCALIC L",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09E2, -- ৢ
 },
 [0x09E3]={
  ["category"]="mn",
  ["description"]="BENGALI VOWEL SIGN VOCALIC LL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x09E3, -- ৣ
 },
 [0x09E6]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09E6, -- ০
 },
 [0x09E7]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09E7, -- ১
 },
 [0x09E8]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09E8, -- ২
 },
 [0x09E9]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09E9, -- ৩
 },
 [0x09EA]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09EA, -- ৪
 },
 [0x09EB]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09EB, -- ৫
 },
 [0x09EC]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09EC, -- ৬
 },
 [0x09ED]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09ED, -- ৭
 },
 [0x09EE]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09EE, -- ৮
 },
 [0x09EF]={
  ["category"]="nd",
  ["description"]="BENGALI DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x09EF, -- ৯
 },
 [0x09F0]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER RA WITH MIDDLE DIAGONAL",
  ["linebreak"]="al",
  ["shcode"]=0x09B0,
  ["unicodeslot"]=0x09F0, -- ৰ
 },
 [0x09F1]={
  ["category"]="lo",
  ["description"]="BENGALI LETTER RA WITH LOWER DIAGONAL",
  ["linebreak"]="al",
  ["shcode"]=0x09B0,
  ["unicodeslot"]=0x09F1, -- ৱ
 },
 [0x09F2]={
  ["category"]="sc",
  ["description"]="BENGALI RUPEE MARK",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x09F2, -- ৲
 },
 [0x09F3]={
  ["category"]="sc",
  ["description"]="BENGALI RUPEE SIGN",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x09F3, -- ৳
 },
 [0x09F4]={
  ["category"]="no",
  ["description"]="BENGALI CURRENCY NUMERATOR ONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09F4, -- ৴
 },
 [0x09F5]={
  ["category"]="no",
  ["description"]="BENGALI CURRENCY NUMERATOR TWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09F5, -- ৵
 },
 [0x09F6]={
  ["category"]="no",
  ["description"]="BENGALI CURRENCY NUMERATOR THREE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09F6, -- ৶
 },
 [0x09F7]={
  ["category"]="no",
  ["description"]="BENGALI CURRENCY NUMERATOR FOUR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09F7, -- ৷
 },
 [0x09F8]={
  ["category"]="no",
  ["description"]="BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09F8, -- ৸
 },
 [0x09F9]={
  ["category"]="no",
  ["description"]="BENGALI CURRENCY DENOMINATOR SIXTEEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09F9, -- ৹
 },
 [0x09FA]={
  ["category"]="so",
  ["description"]="BENGALI ISSHAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x09FA, -- ৺
 },
 [0x0A01]={
  ["category"]="mn",
  ["description"]="GURMUKHI SIGN ADAK BINDI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A01, -- ਁ
 },
 [0x0A02]={
  ["category"]="mn",
  ["description"]="GURMUKHI SIGN BINDI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A02, -- ਂ
 },
 [0x0A03]={
  ["category"]="mc",
  ["description"]="GURMUKHI SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A03, -- ਃ
 },
 [0x0A05]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A05, -- ਅ
 },
 [0x0A06]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A06, -- ਆ
 },
 [0x0A07]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A07, -- ਇ
 },
 [0x0A08]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A08, -- ਈ
 },
 [0x0A09]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A09, -- ਉ
 },
 [0x0A0A]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A0A, -- ਊ
 },
 [0x0A0F]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A0F, -- ਏ
 },
 [0x0A10]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A10, -- ਐ
 },
 [0x0A13]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A13, -- ਓ
 },
 [0x0A14]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A14, -- ਔ
 },
 [0x0A15]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A15, -- ਕ
 },
 [0x0A16]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A16, -- ਖ
 },
 [0x0A17]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A17, -- ਗ
 },
 [0x0A18]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A18, -- ਘ
 },
 [0x0A19]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A19, -- ਙ
 },
 [0x0A1A]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A1A, -- ਚ
 },
 [0x0A1B]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A1B, -- ਛ
 },
 [0x0A1C]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A1C, -- ਜ
 },
 [0x0A1D]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A1D, -- ਝ
 },
 [0x0A1E]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A1E, -- ਞ
 },
 [0x0A1F]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A1F, -- ਟ
 },
 [0x0A20]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A20, -- ਠ
 },
 [0x0A21]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A21, -- ਡ
 },
 [0x0A22]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A22, -- ਢ
 },
 [0x0A23]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A23, -- ਣ
 },
 [0x0A24]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A24, -- ਤ
 },
 [0x0A25]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A25, -- ਥ
 },
 [0x0A26]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A26, -- ਦ
 },
 [0x0A27]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A27, -- ਧ
 },
 [0x0A28]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A28, -- ਨ
 },
 [0x0A2A]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A2A, -- ਪ
 },
 [0x0A2B]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A2B, -- ਫ
 },
 [0x0A2C]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A2C, -- ਬ
 },
 [0x0A2D]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A2D, -- ਭ
 },
 [0x0A2E]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A2E, -- ਮ
 },
 [0x0A2F]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A2F, -- ਯ
 },
 [0x0A30]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A30, -- ਰ
 },
 [0x0A32]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A32, -- ਲ
 },
 [0x0A33]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER LLA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0A32, 0x0A3C },
  ["unicodeslot"]=0x0A33, -- ਲ਼
 },
 [0x0A35]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A35, -- ਵ
 },
 [0x0A36]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER SHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0A38, 0x0A3C },
  ["unicodeslot"]=0x0A36, -- ਸ਼
 },
 [0x0A38]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A38, -- ਸ
 },
 [0x0A39]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A39, -- ਹ
 },
 [0x0A3C]={
  ["category"]="mn",
  ["description"]="GURMUKHI SIGN NUKTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A3C, -- ਼
 },
 [0x0A3E]={
  ["category"]="mc",
  ["description"]="GURMUKHI VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A3E, -- ਾ
 },
 [0x0A3F]={
  ["category"]="mc",
  ["description"]="GURMUKHI VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A3F, -- ਿ
 },
 [0x0A40]={
  ["category"]="mc",
  ["description"]="GURMUKHI VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A40, -- ੀ
 },
 [0x0A41]={
  ["category"]="mn",
  ["description"]="GURMUKHI VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A41, -- ੁ
 },
 [0x0A42]={
  ["category"]="mn",
  ["description"]="GURMUKHI VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A42, -- ੂ
 },
 [0x0A47]={
  ["category"]="mn",
  ["description"]="GURMUKHI VOWEL SIGN EE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A47, -- ੇ
 },
 [0x0A48]={
  ["category"]="mn",
  ["description"]="GURMUKHI VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A48, -- ੈ
 },
 [0x0A4B]={
  ["category"]="mn",
  ["description"]="GURMUKHI VOWEL SIGN OO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A4B, -- ੋ
 },
 [0x0A4C]={
  ["category"]="mn",
  ["description"]="GURMUKHI VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A4C, -- ੌ
 },
 [0x0A4D]={
  ["category"]="mn",
  ["description"]="GURMUKHI SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A4D, -- ੍
 },
 [0x0A59]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER KHHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0A16, 0x0A3C },
  ["unicodeslot"]=0x0A59, -- ਖ਼
 },
 [0x0A5A]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER GHHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0A17, 0x0A3C },
  ["unicodeslot"]=0x0A5A, -- ਗ਼
 },
 [0x0A5B]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER ZA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0A1C, 0x0A3C },
  ["unicodeslot"]=0x0A5B, -- ਜ਼
 },
 [0x0A5C]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER RRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A5C, -- ੜ
 },
 [0x0A5E]={
  ["category"]="lo",
  ["description"]="GURMUKHI LETTER FA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0A2B, 0x0A3C },
  ["unicodeslot"]=0x0A5E, -- ਫ਼
 },
 [0x0A66]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A66, -- ੦
 },
 [0x0A67]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A67, -- ੧
 },
 [0x0A68]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A68, -- ੨
 },
 [0x0A69]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A69, -- ੩
 },
 [0x0A6A]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A6A, -- ੪
 },
 [0x0A6B]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A6B, -- ੫
 },
 [0x0A6C]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A6C, -- ੬
 },
 [0x0A6D]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A6D, -- ੭
 },
 [0x0A6E]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A6E, -- ੮
 },
 [0x0A6F]={
  ["category"]="nd",
  ["description"]="GURMUKHI DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0A6F, -- ੯
 },
 [0x0A70]={
  ["category"]="mn",
  ["description"]="GURMUKHI TIPPI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A70, -- ੰ
 },
 [0x0A71]={
  ["category"]="mn",
  ["description"]="GURMUKHI ADDAK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A71, -- ੱ
 },
 [0x0A72]={
  ["category"]="lo",
  ["description"]="GURMUKHI IRI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A72, -- ੲ
 },
 [0x0A73]={
  ["category"]="lo",
  ["description"]="GURMUKHI URA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A73, -- ੳ
 },
 [0x0A74]={
  ["category"]="lo",
  ["description"]="GURMUKHI EK ONKAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A74, -- ੴ
 },
 [0x0A81]={
  ["category"]="mn",
  ["description"]="GUJARATI SIGN CANDRABINDU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A81, -- ઁ
 },
 [0x0A82]={
  ["category"]="mn",
  ["description"]="GUJARATI SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A82, -- ં
 },
 [0x0A83]={
  ["category"]="mc",
  ["description"]="GUJARATI SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0A83, -- ઃ
 },
 [0x0A85]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A85, -- અ
 },
 [0x0A86]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A86, -- આ
 },
 [0x0A87]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A87, -- ઇ
 },
 [0x0A88]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A88, -- ઈ
 },
 [0x0A89]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A89, -- ઉ
 },
 [0x0A8A]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A8A, -- ઊ
 },
 [0x0A8B]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER VOCALIC R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A8B, -- ઋ
 },
 [0x0A8C]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER VOCALIC L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A8C, -- ઌ
 },
 [0x0A8D]={
  ["category"]="lo",
  ["description"]="GUJARATI VOWEL CANDRA E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A8D, -- ઍ
 },
 [0x0A8F]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A8F, -- એ
 },
 [0x0A90]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A90, -- ઐ
 },
 [0x0A91]={
  ["category"]="lo",
  ["description"]="GUJARATI VOWEL CANDRA O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A91, -- ઑ
 },
 [0x0A93]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A93, -- ઓ
 },
 [0x0A94]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A94, -- ઔ
 },
 [0x0A95]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A95, -- ક
 },
 [0x0A96]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A96, -- ખ
 },
 [0x0A97]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A97, -- ગ
 },
 [0x0A98]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A98, -- ઘ
 },
 [0x0A99]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A99, -- ઙ
 },
 [0x0A9A]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A9A, -- ચ
 },
 [0x0A9B]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A9B, -- છ
 },
 [0x0A9C]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A9C, -- જ
 },
 [0x0A9D]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A9D, -- ઝ
 },
 [0x0A9E]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A9E, -- ઞ
 },
 [0x0A9F]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0A9F, -- ટ
 },
 [0x0AA0]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA0, -- ઠ
 },
 [0x0AA1]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA1, -- ડ
 },
 [0x0AA2]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA2, -- ઢ
 },
 [0x0AA3]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA3, -- ણ
 },
 [0x0AA4]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA4, -- ત
 },
 [0x0AA5]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA5, -- થ
 },
 [0x0AA6]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA6, -- દ
 },
 [0x0AA7]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA7, -- ધ
 },
 [0x0AA8]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AA8, -- ન
 },
 [0x0AAA]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AAA, -- પ
 },
 [0x0AAB]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AAB, -- ફ
 },
 [0x0AAC]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AAC, -- બ
 },
 [0x0AAD]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AAD, -- ભ
 },
 [0x0AAE]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AAE, -- મ
 },
 [0x0AAF]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AAF, -- ય
 },
 [0x0AB0]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB0, -- ર
 },
 [0x0AB2]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB2, -- લ
 },
 [0x0AB3]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER LLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB3, -- ળ
 },
 [0x0AB5]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB5, -- વ
 },
 [0x0AB6]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB6, -- શ
 },
 [0x0AB7]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB7, -- ષ
 },
 [0x0AB8]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB8, -- સ
 },
 [0x0AB9]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AB9, -- હ
 },
 [0x0ABC]={
  ["category"]="mn",
  ["description"]="GUJARATI SIGN NUKTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0ABC, -- ઼
 },
 [0x0ABD]={
  ["category"]="lo",
  ["description"]="GUJARATI SIGN AVAGRAHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0ABD, -- ઽ
 },
 [0x0ABE]={
  ["category"]="mc",
  ["description"]="GUJARATI VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0ABE, -- ા
 },
 [0x0ABF]={
  ["category"]="mc",
  ["description"]="GUJARATI VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0ABF, -- િ
 },
 [0x0AC0]={
  ["category"]="mc",
  ["description"]="GUJARATI VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC0, -- ી
 },
 [0x0AC1]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC1, -- ુ
 },
 [0x0AC2]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC2, -- ૂ
 },
 [0x0AC3]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC3, -- ૃ
 },
 [0x0AC4]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN VOCALIC RR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC4, -- ૄ
 },
 [0x0AC5]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN CANDRA E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC5, -- ૅ
 },
 [0x0AC7]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC7, -- ે
 },
 [0x0AC8]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC8, -- ૈ
 },
 [0x0AC9]={
  ["category"]="mc",
  ["description"]="GUJARATI VOWEL SIGN CANDRA O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AC9, -- ૉ
 },
 [0x0ACB]={
  ["category"]="mc",
  ["description"]="GUJARATI VOWEL SIGN O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0ACB, -- ો
 },
 [0x0ACC]={
  ["category"]="mc",
  ["description"]="GUJARATI VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0ACC, -- ૌ
 },
 [0x0ACD]={
  ["category"]="mn",
  ["description"]="GUJARATI SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0ACD, -- ્
 },
 [0x0AD0]={
  ["category"]="lo",
  ["description"]="GUJARATI OM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AD0, -- ૐ
 },
 [0x0AE0]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER VOCALIC RR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AE0, -- ૠ
 },
 [0x0AE1]={
  ["category"]="lo",
  ["description"]="GUJARATI LETTER VOCALIC LL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0AE1, -- ૡ
 },
 [0x0AE2]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN VOCALIC L",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AE2, -- ૢ
 },
 [0x0AE3]={
  ["category"]="mn",
  ["description"]="GUJARATI VOWEL SIGN VOCALIC LL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0AE3, -- ૣ
 },
 [0x0AE6]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AE6, -- ૦
 },
 [0x0AE7]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AE7, -- ૧
 },
 [0x0AE8]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AE8, -- ૨
 },
 [0x0AE9]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AE9, -- ૩
 },
 [0x0AEA]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AEA, -- ૪
 },
 [0x0AEB]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AEB, -- ૫
 },
 [0x0AEC]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AEC, -- ૬
 },
 [0x0AED]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AED, -- ૭
 },
 [0x0AEE]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AEE, -- ૮
 },
 [0x0AEF]={
  ["category"]="nd",
  ["description"]="GUJARATI DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0AEF, -- ૯
 },
 [0x0AF1]={
  ["category"]="sc",
  ["description"]="GUJARATI RUPEE SIGN",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x0AF1, -- ૱
 },
 [0x0B01]={
  ["category"]="mn",
  ["description"]="ORIYA SIGN CANDRABINDU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B01, -- ଁ
 },
 [0x0B02]={
  ["category"]="mc",
  ["description"]="ORIYA SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B02, -- ଂ
 },
 [0x0B03]={
  ["category"]="mc",
  ["description"]="ORIYA SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B03, -- ଃ
 },
 [0x0B05]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B05, -- ଅ
 },
 [0x0B06]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B06, -- ଆ
 },
 [0x0B07]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B07, -- ଇ
 },
 [0x0B08]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B08, -- ଈ
 },
 [0x0B09]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B09, -- ଉ
 },
 [0x0B0A]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B0A, -- ଊ
 },
 [0x0B0B]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER VOCALIC R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B0B, -- ଋ
 },
 [0x0B0C]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER VOCALIC L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B0C, -- ଌ
 },
 [0x0B0F]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B0F, -- ଏ
 },
 [0x0B10]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B10, -- ଐ
 },
 [0x0B13]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B13, -- ଓ
 },
 [0x0B14]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B14, -- ଔ
 },
 [0x0B15]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B15, -- କ
 },
 [0x0B16]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B16, -- ଖ
 },
 [0x0B17]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B17, -- ଗ
 },
 [0x0B18]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B18, -- ଘ
 },
 [0x0B19]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B19, -- ଙ
 },
 [0x0B1A]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B1A, -- ଚ
 },
 [0x0B1B]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B1B, -- ଛ
 },
 [0x0B1C]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B1C, -- ଜ
 },
 [0x0B1D]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B1D, -- ଝ
 },
 [0x0B1E]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B1E, -- ଞ
 },
 [0x0B1F]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B1F, -- ଟ
 },
 [0x0B20]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B20, -- ଠ
 },
 [0x0B21]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B21, -- ଡ
 },
 [0x0B22]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B22, -- ଢ
 },
 [0x0B23]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B23, -- ଣ
 },
 [0x0B24]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B24, -- ତ
 },
 [0x0B25]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B25, -- ଥ
 },
 [0x0B26]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B26, -- ଦ
 },
 [0x0B27]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B27, -- ଧ
 },
 [0x0B28]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B28, -- ନ
 },
 [0x0B2A]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B2A, -- ପ
 },
 [0x0B2B]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B2B, -- ଫ
 },
 [0x0B2C]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B2C, -- ବ
 },
 [0x0B2D]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B2D, -- ଭ
 },
 [0x0B2E]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B2E, -- ମ
 },
 [0x0B2F]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B2F, -- ଯ
 },
 [0x0B30]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B30, -- ର
 },
 [0x0B32]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B32, -- ଲ
 },
 [0x0B33]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER LLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B33, -- ଳ
 },
 [0x0B35]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B35, -- ଵ
 },
 [0x0B36]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B36, -- ଶ
 },
 [0x0B37]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B37, -- ଷ
 },
 [0x0B38]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B38, -- ସ
 },
 [0x0B39]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B39, -- ହ
 },
 [0x0B3C]={
  ["category"]="mn",
  ["description"]="ORIYA SIGN NUKTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B3C, -- ଼
 },
 [0x0B3D]={
  ["category"]="lo",
  ["description"]="ORIYA SIGN AVAGRAHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B3D, -- ଽ
 },
 [0x0B3E]={
  ["category"]="mc",
  ["description"]="ORIYA VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B3E, -- ା
 },
 [0x0B3F]={
  ["category"]="mn",
  ["description"]="ORIYA VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B3F, -- ି
 },
 [0x0B40]={
  ["category"]="mc",
  ["description"]="ORIYA VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B40, -- ୀ
 },
 [0x0B41]={
  ["category"]="mn",
  ["description"]="ORIYA VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B41, -- ୁ
 },
 [0x0B42]={
  ["category"]="mn",
  ["description"]="ORIYA VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B42, -- ୂ
 },
 [0x0B43]={
  ["category"]="mn",
  ["description"]="ORIYA VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B43, -- ୃ
 },
 [0x0B47]={
  ["category"]="mc",
  ["description"]="ORIYA VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B47, -- େ
 },
 [0x0B48]={
  ["category"]="mc",
  ["description"]="ORIYA VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0B47, 0x0B56 },
  ["unicodeslot"]=0x0B48, -- ୈ
 },
 [0x0B4B]={
  ["category"]="mc",
  ["description"]="ORIYA VOWEL SIGN O",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0B47, 0x0B3E },
  ["unicodeslot"]=0x0B4B, -- ୋ
 },
 [0x0B4C]={
  ["category"]="mc",
  ["description"]="ORIYA VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0B47, 0x0B57 },
  ["unicodeslot"]=0x0B4C, -- ୌ
 },
 [0x0B4D]={
  ["category"]="mn",
  ["description"]="ORIYA SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B4D, -- ୍
 },
 [0x0B56]={
  ["category"]="mn",
  ["description"]="ORIYA AI LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B56, -- ୖ
 },
 [0x0B57]={
  ["category"]="mc",
  ["description"]="ORIYA AU LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B57, -- ୗ
 },
 [0x0B5C]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER RRA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0B21, 0x0B3C },
  ["unicodeslot"]=0x0B5C, -- ଡ଼
 },
 [0x0B5D]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER RHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0B22, 0x0B3C },
  ["unicodeslot"]=0x0B5D, -- ଢ଼
 },
 [0x0B5F]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER YYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B5F, -- ୟ
 },
 [0x0B60]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER VOCALIC RR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B60, -- ୠ
 },
 [0x0B61]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER VOCALIC LL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B61, -- ୡ
 },
 [0x0B66]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B66, -- ୦
 },
 [0x0B67]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B67, -- ୧
 },
 [0x0B68]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B68, -- ୨
 },
 [0x0B69]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B69, -- ୩
 },
 [0x0B6A]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B6A, -- ୪
 },
 [0x0B6B]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B6B, -- ୫
 },
 [0x0B6C]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B6C, -- ୬
 },
 [0x0B6D]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B6D, -- ୭
 },
 [0x0B6E]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B6E, -- ୮
 },
 [0x0B6F]={
  ["category"]="nd",
  ["description"]="ORIYA DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0B6F, -- ୯
 },
 [0x0B70]={
  ["category"]="so",
  ["description"]="ORIYA ISSHAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B70, -- ୰
 },
 [0x0B71]={
  ["category"]="lo",
  ["description"]="ORIYA LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B71, -- ୱ
 },
 [0x0B82]={
  ["category"]="mn",
  ["description"]="TAMIL SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0B82, -- ஂ
 },
 [0x0B83]={
  ["category"]="lo",
  ["description"]="TAMIL SIGN VISARGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B83, -- ஃ
 },
 [0x0B85]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B85, -- அ
 },
 [0x0B86]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B86, -- ஆ
 },
 [0x0B87]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B87, -- இ
 },
 [0x0B88]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B88, -- ஈ
 },
 [0x0B89]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B89, -- உ
 },
 [0x0B8A]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B8A, -- ஊ
 },
 [0x0B8E]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B8E, -- எ
 },
 [0x0B8F]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B8F, -- ஏ
 },
 [0x0B90]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B90, -- ஐ
 },
 [0x0B92]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B92, -- ஒ
 },
 [0x0B93]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B93, -- ஓ
 },
 [0x0B94]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER AU",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0B92, 0x0BD7 },
  ["unicodeslot"]=0x0B94, -- ஔ
 },
 [0x0B95]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B95, -- க
 },
 [0x0B99]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B99, -- ங
 },
 [0x0B9A]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B9A, -- ச
 },
 [0x0B9C]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B9C, -- ஜ
 },
 [0x0B9E]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B9E, -- ஞ
 },
 [0x0B9F]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0B9F, -- ட
 },
 [0x0BA3]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BA3, -- ண
 },
 [0x0BA4]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BA4, -- த
 },
 [0x0BA8]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BA8, -- ந
 },
 [0x0BA9]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER NNNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BA9, -- ன
 },
 [0x0BAA]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BAA, -- ப
 },
 [0x0BAE]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BAE, -- ம
 },
 [0x0BAF]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BAF, -- ய
 },
 [0x0BB0]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB0, -- ர
 },
 [0x0BB1]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER RRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB1, -- ற
 },
 [0x0BB2]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB2, -- ல
 },
 [0x0BB3]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER LLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB3, -- ள
 },
 [0x0BB4]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER LLLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB4, -- ழ
 },
 [0x0BB5]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB5, -- வ
 },
 [0x0BB6]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB6, -- ஶ
 },
 [0x0BB7]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB7, -- ஷ
 },
 [0x0BB8]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB8, -- ஸ
 },
 [0x0BB9]={
  ["category"]="lo",
  ["description"]="TAMIL LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BB9, -- ஹ
 },
 [0x0BBE]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BBE, -- ா
 },
 [0x0BBF]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BBF, -- ி
 },
 [0x0BC0]={
  ["category"]="mn",
  ["description"]="TAMIL VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BC0, -- ீ
 },
 [0x0BC1]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BC1, -- ு
 },
 [0x0BC2]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BC2, -- ூ
 },
 [0x0BC6]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BC6, -- ெ
 },
 [0x0BC7]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN EE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BC7, -- ே
 },
 [0x0BC8]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BC8, -- ை
 },
 [0x0BCA]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN O",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0BC6, 0x0BBE },
  ["unicodeslot"]=0x0BCA, -- ொ
 },
 [0x0BCB]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN OO",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0BC7, 0x0BBE },
  ["unicodeslot"]=0x0BCB, -- ோ
 },
 [0x0BCC]={
  ["category"]="mc",
  ["description"]="TAMIL VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0BC6, 0x0BD7 },
  ["unicodeslot"]=0x0BCC, -- ௌ
 },
 [0x0BCD]={
  ["category"]="mn",
  ["description"]="TAMIL SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BCD, -- ்
 },
 [0x0BD7]={
  ["category"]="mc",
  ["description"]="TAMIL AU LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0BD7, -- ௗ
 },
 [0x0BE6]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BE6, -- ௦
 },
 [0x0BE7]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BE7, -- ௧
 },
 [0x0BE8]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BE8, -- ௨
 },
 [0x0BE9]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BE9, -- ௩
 },
 [0x0BEA]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BEA, -- ௪
 },
 [0x0BEB]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BEB, -- ௫
 },
 [0x0BEC]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BEC, -- ௬
 },
 [0x0BED]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BED, -- ௭
 },
 [0x0BEE]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BEE, -- ௮
 },
 [0x0BEF]={
  ["category"]="nd",
  ["description"]="TAMIL DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0BEF, -- ௯
 },
 [0x0BF0]={
  ["category"]="no",
  ["description"]="TAMIL NUMBER TEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF0, -- ௰
 },
 [0x0BF1]={
  ["category"]="no",
  ["description"]="TAMIL NUMBER ONE HUNDRED",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF1, -- ௱
 },
 [0x0BF2]={
  ["category"]="no",
  ["description"]="TAMIL NUMBER ONE THOUSAND",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF2, -- ௲
 },
 [0x0BF3]={
  ["category"]="so",
  ["description"]="TAMIL DAY SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF3, -- ௳
 },
 [0x0BF4]={
  ["category"]="so",
  ["description"]="TAMIL MONTH SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF4, -- ௴
 },
 [0x0BF5]={
  ["category"]="so",
  ["description"]="TAMIL YEAR SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF5, -- ௵
 },
 [0x0BF6]={
  ["category"]="so",
  ["description"]="TAMIL DEBIT SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF6, -- ௶
 },
 [0x0BF7]={
  ["category"]="so",
  ["description"]="TAMIL CREDIT SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF7, -- ௷
 },
 [0x0BF8]={
  ["category"]="so",
  ["description"]="TAMIL AS ABOVE SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BF8, -- ௸
 },
 [0x0BF9]={
  ["category"]="sc",
  ["description"]="TAMIL RUPEE SIGN",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x0BF9, -- ௹
 },
 [0x0BFA]={
  ["category"]="so",
  ["description"]="TAMIL NUMBER SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0BFA, -- ௺
 },
 [0x0C01]={
  ["category"]="mc",
  ["description"]="TELUGU SIGN CANDRABINDU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C01, -- ఁ
 },
 [0x0C02]={
  ["category"]="mc",
  ["description"]="TELUGU SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C02, -- ం
 },
 [0x0C03]={
  ["category"]="mc",
  ["description"]="TELUGU SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C03, -- ః
 },
 [0x0C05]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C05, -- అ
 },
 [0x0C06]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C06, -- ఆ
 },
 [0x0C07]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C07, -- ఇ
 },
 [0x0C08]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C08, -- ఈ
 },
 [0x0C09]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C09, -- ఉ
 },
 [0x0C0A]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C0A, -- ఊ
 },
 [0x0C0B]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER VOCALIC R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C0B, -- ఋ
 },
 [0x0C0C]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER VOCALIC L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C0C, -- ఌ
 },
 [0x0C0E]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C0E, -- ఎ
 },
 [0x0C0F]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C0F, -- ఏ
 },
 [0x0C10]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C10, -- ఐ
 },
 [0x0C12]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C12, -- ఒ
 },
 [0x0C13]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C13, -- ఓ
 },
 [0x0C14]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C14, -- ఔ
 },
 [0x0C15]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C15, -- క
 },
 [0x0C16]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C16, -- ఖ
 },
 [0x0C17]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C17, -- గ
 },
 [0x0C18]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C18, -- ఘ
 },
 [0x0C19]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C19, -- ఙ
 },
 [0x0C1A]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C1A, -- చ
 },
 [0x0C1B]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C1B, -- ఛ
 },
 [0x0C1C]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C1C, -- జ
 },
 [0x0C1D]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C1D, -- ఝ
 },
 [0x0C1E]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C1E, -- ఞ
 },
 [0x0C1F]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C1F, -- ట
 },
 [0x0C20]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C20, -- ఠ
 },
 [0x0C21]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C21, -- డ
 },
 [0x0C22]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C22, -- ఢ
 },
 [0x0C23]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C23, -- ణ
 },
 [0x0C24]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C24, -- త
 },
 [0x0C25]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C25, -- థ
 },
 [0x0C26]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C26, -- ద
 },
 [0x0C27]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C27, -- ధ
 },
 [0x0C28]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C28, -- న
 },
 [0x0C2A]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C2A, -- ప
 },
 [0x0C2B]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C2B, -- ఫ
 },
 [0x0C2C]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C2C, -- బ
 },
 [0x0C2D]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C2D, -- భ
 },
 [0x0C2E]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C2E, -- మ
 },
 [0x0C2F]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C2F, -- య
 },
 [0x0C30]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C30, -- ర
 },
 [0x0C31]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER RRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C31, -- ఱ
 },
 [0x0C32]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C32, -- ల
 },
 [0x0C33]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER LLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C33, -- ళ
 },
 [0x0C35]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C35, -- వ
 },
 [0x0C36]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C36, -- శ
 },
 [0x0C37]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C37, -- ష
 },
 [0x0C38]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C38, -- స
 },
 [0x0C39]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C39, -- హ
 },
 [0x0C3E]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C3E, -- ా
 },
 [0x0C3F]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C3F, -- ి
 },
 [0x0C40]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C40, -- ీ
 },
 [0x0C41]={
  ["category"]="mc",
  ["description"]="TELUGU VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C41, -- ు
 },
 [0x0C42]={
  ["category"]="mc",
  ["description"]="TELUGU VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C42, -- ూ
 },
 [0x0C43]={
  ["category"]="mc",
  ["description"]="TELUGU VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C43, -- ృ
 },
 [0x0C44]={
  ["category"]="mc",
  ["description"]="TELUGU VOWEL SIGN VOCALIC RR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C44, -- ౄ
 },
 [0x0C46]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C46, -- ె
 },
 [0x0C47]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN EE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C47, -- ే
 },
 [0x0C48]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0C46, 0x0C56 },
  ["unicodeslot"]=0x0C48, -- ై
 },
 [0x0C4A]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C4A, -- ొ
 },
 [0x0C4B]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN OO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C4B, -- ో
 },
 [0x0C4C]={
  ["category"]="mn",
  ["description"]="TELUGU VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C4C, -- ౌ
 },
 [0x0C4D]={
  ["category"]="mn",
  ["description"]="TELUGU SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C4D, -- ్
 },
 [0x0C55]={
  ["category"]="mn",
  ["description"]="TELUGU LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C55, -- ౕ
 },
 [0x0C56]={
  ["category"]="mn",
  ["description"]="TELUGU AI LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C56, -- ౖ
 },
 [0x0C60]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER VOCALIC RR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C60, -- ౠ
 },
 [0x0C61]={
  ["category"]="lo",
  ["description"]="TELUGU LETTER VOCALIC LL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C61, -- ౡ
 },
 [0x0C66]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C66, -- ౦
 },
 [0x0C67]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C67, -- ౧
 },
 [0x0C68]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C68, -- ౨
 },
 [0x0C69]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C69, -- ౩
 },
 [0x0C6A]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C6A, -- ౪
 },
 [0x0C6B]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C6B, -- ౫
 },
 [0x0C6C]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C6C, -- ౬
 },
 [0x0C6D]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C6D, -- ౭
 },
 [0x0C6E]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C6E, -- ౮
 },
 [0x0C6F]={
  ["category"]="nd",
  ["description"]="TELUGU DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0C6F, -- ౯
 },
 [0x0C82]={
  ["category"]="mc",
  ["description"]="KANNADA SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C82, -- ಂ
 },
 [0x0C83]={
  ["category"]="mc",
  ["description"]="KANNADA SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0C83, -- ಃ
 },
 [0x0C85]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C85, -- ಅ
 },
 [0x0C86]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C86, -- ಆ
 },
 [0x0C87]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C87, -- ಇ
 },
 [0x0C88]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C88, -- ಈ
 },
 [0x0C89]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C89, -- ಉ
 },
 [0x0C8A]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C8A, -- ಊ
 },
 [0x0C8B]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER VOCALIC R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C8B, -- ಋ
 },
 [0x0C8C]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER VOCALIC L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C8C, -- ಌ
 },
 [0x0C8E]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C8E, -- ಎ
 },
 [0x0C8F]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C8F, -- ಏ
 },
 [0x0C90]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C90, -- ಐ
 },
 [0x0C92]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C92, -- ಒ
 },
 [0x0C93]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C93, -- ಓ
 },
 [0x0C94]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C94, -- ಔ
 },
 [0x0C95]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C95, -- ಕ
 },
 [0x0C96]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C96, -- ಖ
 },
 [0x0C97]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C97, -- ಗ
 },
 [0x0C98]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C98, -- ಘ
 },
 [0x0C99]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C99, -- ಙ
 },
 [0x0C9A]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C9A, -- ಚ
 },
 [0x0C9B]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C9B, -- ಛ
 },
 [0x0C9C]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C9C, -- ಜ
 },
 [0x0C9D]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C9D, -- ಝ
 },
 [0x0C9E]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C9E, -- ಞ
 },
 [0x0C9F]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0C9F, -- ಟ
 },
 [0x0CA0]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA0, -- ಠ
 },
 [0x0CA1]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA1, -- ಡ
 },
 [0x0CA2]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA2, -- ಢ
 },
 [0x0CA3]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA3, -- ಣ
 },
 [0x0CA4]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA4, -- ತ
 },
 [0x0CA5]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA5, -- ಥ
 },
 [0x0CA6]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA6, -- ದ
 },
 [0x0CA7]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA7, -- ಧ
 },
 [0x0CA8]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CA8, -- ನ
 },
 [0x0CAA]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CAA, -- ಪ
 },
 [0x0CAB]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CAB, -- ಫ
 },
 [0x0CAC]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CAC, -- ಬ
 },
 [0x0CAD]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CAD, -- ಭ
 },
 [0x0CAE]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CAE, -- ಮ
 },
 [0x0CAF]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CAF, -- ಯ
 },
 [0x0CB0]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB0, -- ರ
 },
 [0x0CB1]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER RRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB1, -- ಱ
 },
 [0x0CB2]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB2, -- ಲ
 },
 [0x0CB3]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER LLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB3, -- ಳ
 },
 [0x0CB5]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB5, -- ವ
 },
 [0x0CB6]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB6, -- ಶ
 },
 [0x0CB7]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB7, -- ಷ
 },
 [0x0CB8]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB8, -- ಸ
 },
 [0x0CB9]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CB9, -- ಹ
 },
 [0x0CBC]={
  ["category"]="mn",
  ["description"]="KANNADA SIGN NUKTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CBC, -- ಼
 },
 [0x0CBD]={
  ["category"]="lo",
  ["description"]="KANNADA SIGN AVAGRAHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CBD, -- ಽ
 },
 [0x0CBE]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CBE, -- ಾ
 },
 [0x0CBF]={
  ["category"]="mn",
  ["description"]="KANNADA VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CBF, -- ಿ
 },
 [0x0CC0]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN II",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0CBF, 0x0CD5 },
  ["unicodeslot"]=0x0CC0, -- ೀ
 },
 [0x0CC1]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CC1, -- ು
 },
 [0x0CC2]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CC2, -- ೂ
 },
 [0x0CC3]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CC3, -- ೃ
 },
 [0x0CC4]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN VOCALIC RR",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CC4, -- ೄ
 },
 [0x0CC6]={
  ["category"]="mn",
  ["description"]="KANNADA VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CC6, -- ೆ
 },
 [0x0CC7]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN EE",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0CC6, 0x0CD5 },
  ["unicodeslot"]=0x0CC7, -- ೇ
 },
 [0x0CC8]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0CC6, 0x0CD6 },
  ["unicodeslot"]=0x0CC8, -- ೈ
 },
 [0x0CCA]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN O",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0CC6, 0x0CC2 },
  ["unicodeslot"]=0x0CCA, -- ೊ
 },
 [0x0CCB]={
  ["category"]="mc",
  ["description"]="KANNADA VOWEL SIGN OO",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0CCA, 0x0CD5 },
  ["unicodeslot"]=0x0CCB, -- ೋ
 },
 [0x0CCC]={
  ["category"]="mn",
  ["description"]="KANNADA VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CCC, -- ೌ
 },
 [0x0CCD]={
  ["category"]="mn",
  ["description"]="KANNADA SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CCD, -- ್
 },
 [0x0CD5]={
  ["category"]="mc",
  ["description"]="KANNADA LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CD5, -- ೕ
 },
 [0x0CD6]={
  ["category"]="mc",
  ["description"]="KANNADA AI LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CD6, -- ೖ
 },
 [0x0CDE]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER FA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CDE, -- ೞ
 },
 [0x0CE0]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER VOCALIC RR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CE0, -- ೠ
 },
 [0x0CE1]={
  ["category"]="lo",
  ["description"]="KANNADA LETTER VOCALIC LL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CE1, -- ೡ
 },
 [0x0CE2]={
  ["category"]="mn",
  ["description"]="KANNADA VOWEL SIGN VOCALIC L",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CE2, -- ೢ
 },
 [0x0CE3]={
  ["category"]="mn",
  ["description"]="KANNADA VOWEL SIGN VOCALIC LL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0CE3, -- ೣ
 },
 [0x0CE6]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CE6, -- ೦
 },
 [0x0CE7]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CE7, -- ೧
 },
 [0x0CE8]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CE8, -- ೨
 },
 [0x0CE9]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CE9, -- ೩
 },
 [0x0CEA]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CEA, -- ೪
 },
 [0x0CEB]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CEB, -- ೫
 },
 [0x0CEC]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CEC, -- ೬
 },
 [0x0CED]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CED, -- ೭
 },
 [0x0CEE]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CEE, -- ೮
 },
 [0x0CEF]={
  ["category"]="nd",
  ["description"]="KANNADA DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0CEF, -- ೯
 },
 [0x0CF1]={
  ["category"]="so",
  ["description"]="KANNADA SIGN JIHVAMULIYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CF1, -- ೱ
 },
 [0x0CF2]={
  ["category"]="so",
  ["description"]="KANNADA SIGN UPADHMANIYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0CF2, -- ೲ
 },
 [0x0D02]={
  ["category"]="mc",
  ["description"]="MALAYALAM SIGN ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D02, -- ം
 },
 [0x0D03]={
  ["category"]="mc",
  ["description"]="MALAYALAM SIGN VISARGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D03, -- ഃ
 },
 [0x0D05]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D05, -- അ
 },
 [0x0D06]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D06, -- ആ
 },
 [0x0D07]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D07, -- ഇ
 },
 [0x0D08]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D08, -- ഈ
 },
 [0x0D09]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D09, -- ഉ
 },
 [0x0D0A]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER UU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D0A, -- ഊ
 },
 [0x0D0B]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER VOCALIC R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D0B, -- ഋ
 },
 [0x0D0C]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER VOCALIC L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D0C, -- ഌ
 },
 [0x0D0E]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D0E, -- എ
 },
 [0x0D0F]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D0F, -- ഏ
 },
 [0x0D10]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D10, -- ഐ
 },
 [0x0D12]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D12, -- ഒ
 },
 [0x0D13]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D13, -- ഓ
 },
 [0x0D14]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER AU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D14, -- ഔ
 },
 [0x0D15]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D15, -- ക
 },
 [0x0D16]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D16, -- ഖ
 },
 [0x0D17]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D17, -- ഗ
 },
 [0x0D18]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D18, -- ഘ
 },
 [0x0D19]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D19, -- ങ
 },
 [0x0D1A]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D1A, -- ച
 },
 [0x0D1B]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D1B, -- ഛ
 },
 [0x0D1C]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D1C, -- ജ
 },
 [0x0D1D]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D1D, -- ഝ
 },
 [0x0D1E]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D1E, -- ഞ
 },
 [0x0D1F]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D1F, -- ട
 },
 [0x0D20]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D20, -- ഠ
 },
 [0x0D21]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D21, -- ഡ
 },
 [0x0D22]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D22, -- ഢ
 },
 [0x0D23]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D23, -- ണ
 },
 [0x0D24]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D24, -- ത
 },
 [0x0D25]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D25, -- ഥ
 },
 [0x0D26]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D26, -- ദ
 },
 [0x0D27]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D27, -- ധ
 },
 [0x0D28]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D28, -- ന
 },
 [0x0D2A]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D2A, -- പ
 },
 [0x0D2B]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D2B, -- ഫ
 },
 [0x0D2C]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D2C, -- ബ
 },
 [0x0D2D]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D2D, -- ഭ
 },
 [0x0D2E]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D2E, -- മ
 },
 [0x0D2F]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D2F, -- യ
 },
 [0x0D30]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D30, -- ര
 },
 [0x0D31]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER RRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D31, -- റ
 },
 [0x0D32]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D32, -- ല
 },
 [0x0D33]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER LLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D33, -- ള
 },
 [0x0D34]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER LLLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D34, -- ഴ
 },
 [0x0D35]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D35, -- വ
 },
 [0x0D36]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D36, -- ശ
 },
 [0x0D37]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D37, -- ഷ
 },
 [0x0D38]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D38, -- സ
 },
 [0x0D39]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D39, -- ഹ
 },
 [0x0D3E]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D3E, -- ാ
 },
 [0x0D3F]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D3F, -- ി
 },
 [0x0D40]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN II",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D40, -- ീ
 },
 [0x0D41]={
  ["category"]="mn",
  ["description"]="MALAYALAM VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D41, -- ു
 },
 [0x0D42]={
  ["category"]="mn",
  ["description"]="MALAYALAM VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D42, -- ൂ
 },
 [0x0D43]={
  ["category"]="mn",
  ["description"]="MALAYALAM VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D43, -- ൃ
 },
 [0x0D46]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D46, -- െ
 },
 [0x0D47]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN EE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D47, -- േ
 },
 [0x0D48]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D48, -- ൈ
 },
 [0x0D4A]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN O",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0D46, 0x0D3E },
  ["unicodeslot"]=0x0D4A, -- ൊ
 },
 [0x0D4B]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN OO",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0D47, 0x0D3E },
  ["unicodeslot"]=0x0D4B, -- ോ
 },
 [0x0D4C]={
  ["category"]="mc",
  ["description"]="MALAYALAM VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0D46, 0x0D57 },
  ["unicodeslot"]=0x0D4C, -- ൌ
 },
 [0x0D4D]={
  ["category"]="mn",
  ["description"]="MALAYALAM SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D4D, -- ്
 },
 [0x0D57]={
  ["category"]="mc",
  ["description"]="MALAYALAM AU LENGTH MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D57, -- ൗ
 },
 [0x0D60]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER VOCALIC RR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D60, -- ൠ
 },
 [0x0D61]={
  ["category"]="lo",
  ["description"]="MALAYALAM LETTER VOCALIC LL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D61, -- ൡ
 },
 [0x0D66]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D66, -- ൦
 },
 [0x0D67]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D67, -- ൧
 },
 [0x0D68]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D68, -- ൨
 },
 [0x0D69]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D69, -- ൩
 },
 [0x0D6A]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D6A, -- ൪
 },
 [0x0D6B]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D6B, -- ൫
 },
 [0x0D6C]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D6C, -- ൬
 },
 [0x0D6D]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D6D, -- ൭
 },
 [0x0D6E]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D6E, -- ൮
 },
 [0x0D6F]={
  ["category"]="nd",
  ["description"]="MALAYALAM DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0D6F, -- ൯
 },
 [0x0D82]={
  ["category"]="mc",
  ["description"]="SINHALA SIGN ANUSVARAYA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D82, -- ං
 },
 [0x0D83]={
  ["category"]="mc",
  ["description"]="SINHALA SIGN VISARGAYA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0D83, -- ඃ
 },
 [0x0D85]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER AYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D85, -- අ
 },
 [0x0D86]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER AAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D86, -- ආ
 },
 [0x0D87]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER AEYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D87, -- ඇ
 },
 [0x0D88]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER AEEYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D88, -- ඈ
 },
 [0x0D89]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER IYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D89, -- ඉ
 },
 [0x0D8A]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER IIYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D8A, -- ඊ
 },
 [0x0D8B]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER UYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D8B, -- උ
 },
 [0x0D8C]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER UUYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D8C, -- ඌ
 },
 [0x0D8D]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER IRUYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D8D, -- ඍ
 },
 [0x0D8E]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER IRUUYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D8E, -- ඎ
 },
 [0x0D8F]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ILUYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D8F, -- ඏ
 },
 [0x0D90]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ILUUYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D90, -- ඐ
 },
 [0x0D91]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER EYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D91, -- එ
 },
 [0x0D92]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER EEYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D92, -- ඒ
 },
 [0x0D93]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER AIYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D93, -- ඓ
 },
 [0x0D94]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER OYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D94, -- ඔ
 },
 [0x0D95]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER OOYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D95, -- ඕ
 },
 [0x0D96]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER AUYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D96, -- ඖ
 },
 [0x0D9A]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA KAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D9A, -- ක
 },
 [0x0D9B]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA KAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D9B, -- ඛ
 },
 [0x0D9C]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA GAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D9C, -- ග
 },
 [0x0D9D]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA GAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D9D, -- ඝ
 },
 [0x0D9E]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER KANTAJA NAASIKYAYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D9E, -- ඞ
 },
 [0x0D9F]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER SANYAKA GAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0D9F, -- ඟ
 },
 [0x0DA0]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA CAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA0, -- ච
 },
 [0x0DA1]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA CAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA1, -- ඡ
 },
 [0x0DA2]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA JAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA2, -- ජ
 },
 [0x0DA3]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA JAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA3, -- ඣ
 },
 [0x0DA4]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER TAALUJA NAASIKYAYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA4, -- ඤ
 },
 [0x0DA5]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA5, -- ඥ
 },
 [0x0DA6]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER SANYAKA JAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA6, -- ඦ
 },
 [0x0DA7]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA TTAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA7, -- ට
 },
 [0x0DA8]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA TTAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA8, -- ඨ
 },
 [0x0DA9]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA DDAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DA9, -- ඩ
 },
 [0x0DAA]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA DDAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DAA, -- ඪ
 },
 [0x0DAB]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MUURDHAJA NAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DAB, -- ණ
 },
 [0x0DAC]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER SANYAKA DDAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DAC, -- ඬ
 },
 [0x0DAD]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA TAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DAD, -- ත
 },
 [0x0DAE]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA TAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DAE, -- ථ
 },
 [0x0DAF]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA DAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DAF, -- ද
 },
 [0x0DB0]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA DAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB0, -- ධ
 },
 [0x0DB1]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER DANTAJA NAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB1, -- න
 },
 [0x0DB3]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER SANYAKA DAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB3, -- ඳ
 },
 [0x0DB4]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA PAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB4, -- ප
 },
 [0x0DB5]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA PAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB5, -- ඵ
 },
 [0x0DB6]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER ALPAPRAANA BAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB6, -- බ
 },
 [0x0DB7]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAHAAPRAANA BAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB7, -- භ
 },
 [0x0DB8]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB8, -- ම
 },
 [0x0DB9]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER AMBA BAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DB9, -- ඹ
 },
 [0x0DBA]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER YAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DBA, -- ය
 },
 [0x0DBB]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER RAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DBB, -- ර
 },
 [0x0DBD]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER DANTAJA LAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DBD, -- ල
 },
 [0x0DC0]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER VAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DC0, -- ව
 },
 [0x0DC1]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER TAALUJA SAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DC1, -- ශ
 },
 [0x0DC2]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MUURDHAJA SAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DC2, -- ෂ
 },
 [0x0DC3]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER DANTAJA SAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DC3, -- ස
 },
 [0x0DC4]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER HAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DC4, -- හ
 },
 [0x0DC5]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER MUURDHAJA LAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DC5, -- ළ
 },
 [0x0DC6]={
  ["category"]="lo",
  ["description"]="SINHALA LETTER FAYANNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DC6, -- ෆ
 },
 [0x0DCA]={
  ["category"]="mn",
  ["description"]="SINHALA SIGN AL-LAKUNA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DCA, -- ්
 },
 [0x0DCF]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN AELA-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DCF, -- ා
 },
 [0x0DD0]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN KETTI AEDA-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD0, -- ැ
 },
 [0x0DD1]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN DIGA AEDA-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD1, -- ෑ
 },
 [0x0DD2]={
  ["category"]="mn",
  ["description"]="SINHALA VOWEL SIGN KETTI IS-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD2, -- ි
 },
 [0x0DD3]={
  ["category"]="mn",
  ["description"]="SINHALA VOWEL SIGN DIGA IS-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD3, -- ී
 },
 [0x0DD4]={
  ["category"]="mn",
  ["description"]="SINHALA VOWEL SIGN KETTI PAA-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD4, -- ු
 },
 [0x0DD6]={
  ["category"]="mn",
  ["description"]="SINHALA VOWEL SIGN DIGA PAA-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD6, -- ූ
 },
 [0x0DD8]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN GAETTA-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD8, -- ෘ
 },
 [0x0DD9]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN KOMBUVA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DD9, -- ෙ
 },
 [0x0DDA]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN DIGA KOMBUVA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0DD9, 0x0DCA },
  ["unicodeslot"]=0x0DDA, -- ේ
 },
 [0x0DDB]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN KOMBU DEKA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DDB, -- ෛ
 },
 [0x0DDC]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0DD9, 0x0DCF },
  ["unicodeslot"]=0x0DDC, -- ො
 },
 [0x0DDD]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0DDC, 0x0DCA },
  ["unicodeslot"]=0x0DDD, -- ෝ
 },
 [0x0DDE]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0DD9, 0x0DDF },
  ["unicodeslot"]=0x0DDE, -- ෞ
 },
 [0x0DDF]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN GAYANUKITTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DDF, -- ෟ
 },
 [0x0DF2]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN DIGA GAETTA-PILLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DF2, -- ෲ
 },
 [0x0DF3]={
  ["category"]="mc",
  ["description"]="SINHALA VOWEL SIGN DIGA GAYANUKITTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0DF3, -- ෳ
 },
 [0x0DF4]={
  ["category"]="po",
  ["description"]="SINHALA PUNCTUATION KUNDDALIYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0DF4, -- ෴
 },
 [0x0E01]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER KO KAI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E01, -- ก
 },
 [0x0E02]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER KHO KHAI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E02, -- ข
 },
 [0x0E03]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER KHO KHUAT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E03, -- ฃ
 },
 [0x0E04]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER KHO KHWAI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E04, -- ค
 },
 [0x0E05]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER KHO KHON",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E05, -- ฅ
 },
 [0x0E06]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER KHO RAKHANG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E06, -- ฆ
 },
 [0x0E07]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER NGO NGU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E07, -- ง
 },
 [0x0E08]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER CHO CHAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E08, -- จ
 },
 [0x0E09]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER CHO CHING",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E09, -- ฉ
 },
 [0x0E0A]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER CHO CHANG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E0A, -- ช
 },
 [0x0E0B]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SO SO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E0B, -- ซ
 },
 [0x0E0C]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER CHO CHOE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E0C, -- ฌ
 },
 [0x0E0D]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER YO YING",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E0D, -- ญ
 },
 [0x0E0E]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER DO CHADA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E0E, -- ฎ
 },
 [0x0E0F]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER TO PATAK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E0F, -- ฏ
 },
 [0x0E10]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER THO THAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E10, -- ฐ
 },
 [0x0E11]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER THO NANGMONTHO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E11, -- ฑ
 },
 [0x0E12]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER THO PHUTHAO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E12, -- ฒ
 },
 [0x0E13]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER NO NEN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E13, -- ณ
 },
 [0x0E14]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER DO DEK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E14, -- ด
 },
 [0x0E15]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER TO TAO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E15, -- ต
 },
 [0x0E16]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER THO THUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E16, -- ถ
 },
 [0x0E17]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER THO THAHAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E17, -- ท
 },
 [0x0E18]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER THO THONG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E18, -- ธ
 },
 [0x0E19]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER NO NU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E19, -- น
 },
 [0x0E1A]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER BO BAIMAI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E1A, -- บ
 },
 [0x0E1B]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER PO PLA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E1B, -- ป
 },
 [0x0E1C]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER PHO PHUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E1C, -- ผ
 },
 [0x0E1D]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER FO FA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E1D, -- ฝ
 },
 [0x0E1E]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER PHO PHAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E1E, -- พ
 },
 [0x0E1F]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER FO FAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E1F, -- ฟ
 },
 [0x0E20]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER PHO SAMPHAO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E20, -- ภ
 },
 [0x0E21]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER MO MA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E21, -- ม
 },
 [0x0E22]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER YO YAK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E22, -- ย
 },
 [0x0E23]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER RO RUA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E23, -- ร
 },
 [0x0E24]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER RU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E24, -- ฤ
 },
 [0x0E25]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER LO LING",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E25, -- ล
 },
 [0x0E26]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER LU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E26, -- ฦ
 },
 [0x0E27]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER WO WAEN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E27, -- ว
 },
 [0x0E28]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SO SALA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E28, -- ศ
 },
 [0x0E29]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SO RUSI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E29, -- ษ
 },
 [0x0E2A]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SO SUA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E2A, -- ส
 },
 [0x0E2B]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER HO HIP",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E2B, -- ห
 },
 [0x0E2C]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER LO CHULA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E2C, -- ฬ
 },
 [0x0E2D]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER O ANG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E2D, -- อ
 },
 [0x0E2E]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER HO NOKHUK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E2E, -- ฮ
 },
 [0x0E2F]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER PAIYANNOI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E2F, -- ฯ
 },
 [0x0E30]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA A",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E30, -- ะ
 },
 [0x0E31]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER MAI HAN-AKAT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E31, -- ั
 },
 [0x0E32]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA AA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E32, -- า
 },
 [0x0E33]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA AM",
  ["linebreak"]="sa",
  ["specials"]={ "compat", 0x0E4D, 0x0E32 },
  ["unicodeslot"]=0x0E33, -- ำ
 },
 [0x0E34]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER SARA I",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E34, -- ิ
 },
 [0x0E35]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER SARA II",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E35, -- ี
 },
 [0x0E36]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER SARA UE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E36, -- ึ
 },
 [0x0E37]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER SARA UEE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E37, -- ื
 },
 [0x0E38]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER SARA U",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E38, -- ุ
 },
 [0x0E39]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER SARA UU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E39, -- ู
 },
 [0x0E3A]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER PHINTHU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E3A, -- ฺ
 },
 [0x0E3F]={
  ["category"]="sc",
  ["description"]="THAI CURRENCY SYMBOL BAHT",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x0E3F, -- ฿
 },
 [0x0E40]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA E",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E40, -- เ
 },
 [0x0E41]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA AE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E41, -- แ
 },
 [0x0E42]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA O",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E42, -- โ
 },
 [0x0E43]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA AI MAIMUAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E43, -- ใ
 },
 [0x0E44]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER SARA AI MAIMALAI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E44, -- ไ
 },
 [0x0E45]={
  ["category"]="lo",
  ["description"]="THAI CHARACTER LAKKHANGYAO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E45, -- ๅ
 },
 [0x0E46]={
  ["category"]="lm",
  ["description"]="THAI CHARACTER MAIYAMOK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E46, -- ๆ
 },
 [0x0E47]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER MAITAIKHU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E47, -- ็
 },
 [0x0E48]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER MAI EK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E48, -- ่
 },
 [0x0E49]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER MAI THO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E49, -- ้
 },
 [0x0E4A]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER MAI TRI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E4A, -- ๊
 },
 [0x0E4B]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER MAI CHATTAWA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E4B, -- ๋
 },
 [0x0E4C]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER THANTHAKHAT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E4C, -- ์
 },
 [0x0E4D]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER NIKHAHIT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E4D, -- ํ
 },
 [0x0E4E]={
  ["category"]="mn",
  ["description"]="THAI CHARACTER YAMAKKAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E4E, -- ๎
 },
 [0x0E4F]={
  ["category"]="po",
  ["description"]="THAI CHARACTER FONGMAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0E4F, -- ๏
 },
 [0x0E50]={
  ["category"]="nd",
  ["description"]="THAI DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E50, -- ๐
 },
 [0x0E51]={
  ["category"]="nd",
  ["description"]="THAI DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E51, -- ๑
 },
 [0x0E52]={
  ["category"]="nd",
  ["description"]="THAI DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E52, -- ๒
 },
 [0x0E53]={
  ["category"]="nd",
  ["description"]="THAI DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E53, -- ๓
 },
 [0x0E54]={
  ["category"]="nd",
  ["description"]="THAI DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E54, -- ๔
 },
 [0x0E55]={
  ["category"]="nd",
  ["description"]="THAI DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E55, -- ๕
 },
 [0x0E56]={
  ["category"]="nd",
  ["description"]="THAI DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E56, -- ๖
 },
 [0x0E57]={
  ["category"]="nd",
  ["description"]="THAI DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E57, -- ๗
 },
 [0x0E58]={
  ["category"]="nd",
  ["description"]="THAI DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E58, -- ๘
 },
 [0x0E59]={
  ["category"]="nd",
  ["description"]="THAI DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0E59, -- ๙
 },
 [0x0E5A]={
  ["category"]="po",
  ["description"]="THAI CHARACTER ANGKHANKHU",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0E5A, -- ๚
 },
 [0x0E5B]={
  ["category"]="po",
  ["description"]="THAI CHARACTER KHOMUT",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0E5B, -- ๛
 },
 [0x0E81]={
  ["category"]="lo",
  ["description"]="LAO LETTER KO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E81, -- ກ
 },
 [0x0E82]={
  ["category"]="lo",
  ["description"]="LAO LETTER KHO SUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E82, -- ຂ
 },
 [0x0E84]={
  ["category"]="lo",
  ["description"]="LAO LETTER KHO TAM",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E84, -- ຄ
 },
 [0x0E87]={
  ["category"]="lo",
  ["description"]="LAO LETTER NGO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E87, -- ງ
 },
 [0x0E88]={
  ["category"]="lo",
  ["description"]="LAO LETTER CO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E88, -- ຈ
 },
 [0x0E8A]={
  ["category"]="lo",
  ["description"]="LAO LETTER SO TAM",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E8A, -- ຊ
 },
 [0x0E8D]={
  ["category"]="lo",
  ["description"]="LAO LETTER NYO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E8D, -- ຍ
 },
 [0x0E94]={
  ["category"]="lo",
  ["description"]="LAO LETTER DO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E94, -- ດ
 },
 [0x0E95]={
  ["category"]="lo",
  ["description"]="LAO LETTER TO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E95, -- ຕ
 },
 [0x0E96]={
  ["category"]="lo",
  ["description"]="LAO LETTER THO SUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E96, -- ຖ
 },
 [0x0E97]={
  ["category"]="lo",
  ["description"]="LAO LETTER THO TAM",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E97, -- ທ
 },
 [0x0E99]={
  ["category"]="lo",
  ["description"]="LAO LETTER NO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E99, -- ນ
 },
 [0x0E9A]={
  ["category"]="lo",
  ["description"]="LAO LETTER BO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E9A, -- ບ
 },
 [0x0E9B]={
  ["category"]="lo",
  ["description"]="LAO LETTER PO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E9B, -- ປ
 },
 [0x0E9C]={
  ["category"]="lo",
  ["description"]="LAO LETTER PHO SUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E9C, -- ຜ
 },
 [0x0E9D]={
  ["category"]="lo",
  ["description"]="LAO LETTER FO TAM",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E9D, -- ຝ
 },
 [0x0E9E]={
  ["category"]="lo",
  ["description"]="LAO LETTER PHO TAM",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E9E, -- ພ
 },
 [0x0E9F]={
  ["category"]="lo",
  ["description"]="LAO LETTER FO SUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0E9F, -- ຟ
 },
 [0x0EA1]={
  ["category"]="lo",
  ["description"]="LAO LETTER MO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EA1, -- ມ
 },
 [0x0EA2]={
  ["category"]="lo",
  ["description"]="LAO LETTER YO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EA2, -- ຢ
 },
 [0x0EA3]={
  ["category"]="lo",
  ["description"]="LAO LETTER LO LING",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EA3, -- ຣ
 },
 [0x0EA5]={
  ["category"]="lo",
  ["description"]="LAO LETTER LO LOOT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EA5, -- ລ
 },
 [0x0EA7]={
  ["category"]="lo",
  ["description"]="LAO LETTER WO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EA7, -- ວ
 },
 [0x0EAA]={
  ["category"]="lo",
  ["description"]="LAO LETTER SO SUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EAA, -- ສ
 },
 [0x0EAB]={
  ["category"]="lo",
  ["description"]="LAO LETTER HO SUNG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EAB, -- ຫ
 },
 [0x0EAD]={
  ["category"]="lo",
  ["description"]="LAO LETTER O",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EAD, -- ອ
 },
 [0x0EAE]={
  ["category"]="lo",
  ["description"]="LAO LETTER HO TAM",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EAE, -- ຮ
 },
 [0x0EAF]={
  ["category"]="lo",
  ["description"]="LAO ELLIPSIS",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EAF, -- ຯ
 },
 [0x0EB0]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN A",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB0, -- ະ
 },
 [0x0EB1]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN MAI KAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB1, -- ັ
 },
 [0x0EB2]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN AA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB2, -- າ
 },
 [0x0EB3]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN AM",
  ["linebreak"]="sa",
  ["specials"]={ "compat", 0x0ECD, 0x0EB2 },
  ["unicodeslot"]=0x0EB3, -- ຳ
 },
 [0x0EB4]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN I",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB4, -- ິ
 },
 [0x0EB5]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN II",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB5, -- ີ
 },
 [0x0EB6]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN Y",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB6, -- ຶ
 },
 [0x0EB7]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN YY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB7, -- ື
 },
 [0x0EB8]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN U",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB8, -- ຸ
 },
 [0x0EB9]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN UU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EB9, -- ູ
 },
 [0x0EBB]={
  ["category"]="mn",
  ["description"]="LAO VOWEL SIGN MAI KON",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EBB, -- ົ
 },
 [0x0EBC]={
  ["category"]="mn",
  ["description"]="LAO SEMIVOWEL SIGN LO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EBC, -- ຼ
 },
 [0x0EBD]={
  ["category"]="lo",
  ["description"]="LAO SEMIVOWEL SIGN NYO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EBD, -- ຽ
 },
 [0x0EC0]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN E",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC0, -- ເ
 },
 [0x0EC1]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN EI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC1, -- ແ
 },
 [0x0EC2]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN O",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC2, -- ໂ
 },
 [0x0EC3]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN AY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC3, -- ໃ
 },
 [0x0EC4]={
  ["category"]="lo",
  ["description"]="LAO VOWEL SIGN AI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC4, -- ໄ
 },
 [0x0EC6]={
  ["category"]="lm",
  ["description"]="LAO KO LA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC6, -- ໆ
 },
 [0x0EC8]={
  ["category"]="mn",
  ["description"]="LAO TONE MAI EK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC8, -- ່
 },
 [0x0EC9]={
  ["category"]="mn",
  ["description"]="LAO TONE MAI THO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0EC9, -- ້
 },
 [0x0ECA]={
  ["category"]="mn",
  ["description"]="LAO TONE MAI TI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0ECA, -- ໊
 },
 [0x0ECB]={
  ["category"]="mn",
  ["description"]="LAO TONE MAI CATAWA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0ECB, -- ໋
 },
 [0x0ECC]={
  ["category"]="mn",
  ["description"]="LAO CANCELLATION MARK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0ECC, -- ໌
 },
 [0x0ECD]={
  ["category"]="mn",
  ["description"]="LAO NIGGAHITA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x0ECD, -- ໍ
 },
 [0x0ED0]={
  ["category"]="nd",
  ["description"]="LAO DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED0, -- ໐
 },
 [0x0ED1]={
  ["category"]="nd",
  ["description"]="LAO DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED1, -- ໑
 },
 [0x0ED2]={
  ["category"]="nd",
  ["description"]="LAO DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED2, -- ໒
 },
 [0x0ED3]={
  ["category"]="nd",
  ["description"]="LAO DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED3, -- ໓
 },
 [0x0ED4]={
  ["category"]="nd",
  ["description"]="LAO DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED4, -- ໔
 },
 [0x0ED5]={
  ["category"]="nd",
  ["description"]="LAO DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED5, -- ໕
 },
 [0x0ED6]={
  ["category"]="nd",
  ["description"]="LAO DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED6, -- ໖
 },
 [0x0ED7]={
  ["category"]="nd",
  ["description"]="LAO DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED7, -- ໗
 },
 [0x0ED8]={
  ["category"]="nd",
  ["description"]="LAO DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED8, -- ໘
 },
 [0x0ED9]={
  ["category"]="nd",
  ["description"]="LAO DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0ED9, -- ໙
 },
 [0x0EDC]={
  ["category"]="lo",
  ["description"]="LAO HO NO",
  ["linebreak"]="sa",
  ["specials"]={ "compat", 0x0EAB, 0x0E99 },
  ["unicodeslot"]=0x0EDC, -- ໜ
 },
 [0x0EDD]={
  ["category"]="lo",
  ["description"]="LAO HO MO",
  ["linebreak"]="sa",
  ["specials"]={ "compat", 0x0EAB, 0x0EA1 },
  ["unicodeslot"]=0x0EDD, -- ໝ
 },
 [0x0F00]={
  ["category"]="lo",
  ["description"]="TIBETAN SYLLABLE OM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F00, -- ༀ
 },
 [0x0F01]={
  ["category"]="so",
  ["description"]="TIBETAN MARK GTER YIG MGO TRUNCATED A",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F01, -- ༁
 },
 [0x0F02]={
  ["category"]="so",
  ["description"]="TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F02, -- ༂
 },
 [0x0F03]={
  ["category"]="so",
  ["description"]="TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F03, -- ༃
 },
 [0x0F04]={
  ["category"]="po",
  ["description"]="TIBETAN MARK INITIAL YIG MGO MDUN MA",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F04, -- ༄
 },
 [0x0F05]={
  ["category"]="po",
  ["description"]="TIBETAN MARK CLOSING YIG MGO SGAB MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F05, -- ༅
 },
 [0x0F06]={
  ["category"]="po",
  ["description"]="TIBETAN MARK CARET YIG MGO PHUR SHAD MA",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F06, -- ༆
 },
 [0x0F07]={
  ["category"]="po",
  ["description"]="TIBETAN MARK YIG MGO TSHEG SHAD MA",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F07, -- ༇
 },
 [0x0F08]={
  ["category"]="po",
  ["description"]="TIBETAN MARK SBRUL SHAD",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x0F08, -- ༈
 },
 [0x0F09]={
  ["category"]="po",
  ["description"]="TIBETAN MARK BSKUR YIG MGO",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F09, -- ༉
 },
 [0x0F0A]={
  ["category"]="po",
  ["description"]="TIBETAN MARK BKA- SHOG YIG MGO",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0F0A, -- ༊
 },
 [0x0F0B]={
  ["category"]="po",
  ["description"]="TIBETAN MARK INTERSYLLABIC TSHEG",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0F0B, -- ་
 },
 [0x0F0C]={
  ["category"]="po",
  ["description"]="TIBETAN MARK DELIMITER TSHEG BSTAR",
  ["linebreak"]="gl",
  ["specials"]={ "nobreak", 0x0F0B },
  ["unicodeslot"]=0x0F0C, -- ༌
 },
 [0x0F0D]={
  ["category"]="po",
  ["description"]="TIBETAN MARK SHAD",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x0F0D, -- །
 },
 [0x0F0E]={
  ["category"]="po",
  ["description"]="TIBETAN MARK NYIS SHAD",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x0F0E, -- ༎
 },
 [0x0F0F]={
  ["category"]="po",
  ["description"]="TIBETAN MARK TSHEG SHAD",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x0F0F, -- ༏
 },
 [0x0F10]={
  ["category"]="po",
  ["description"]="TIBETAN MARK NYIS TSHEG SHAD",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x0F10, -- ༐
 },
 [0x0F11]={
  ["category"]="po",
  ["description"]="TIBETAN MARK RIN CHEN SPUNGS SHAD",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x0F11, -- ༑
 },
 [0x0F12]={
  ["category"]="po",
  ["description"]="TIBETAN MARK RGYA GRAM SHAD",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x0F12, -- ༒
 },
 [0x0F13]={
  ["category"]="so",
  ["description"]="TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F13, -- ༓
 },
 [0x0F14]={
  ["category"]="so",
  ["description"]="TIBETAN MARK GTER TSHEG",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x0F14, -- ༔
 },
 [0x0F15]={
  ["category"]="so",
  ["description"]="TIBETAN LOGOTYPE SIGN CHAD RTAGS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F15, -- ༕
 },
 [0x0F16]={
  ["category"]="so",
  ["description"]="TIBETAN LOGOTYPE SIGN LHAG RTAGS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F16, -- ༖
 },
 [0x0F17]={
  ["category"]="so",
  ["description"]="TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F17, -- ༗
 },
 [0x0F18]={
  ["category"]="mn",
  ["description"]="TIBETAN ASTROLOGICAL SIGN -KHYUD PA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F18, -- ༘
 },
 [0x0F19]={
  ["category"]="mn",
  ["description"]="TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F19, -- ༙
 },
 [0x0F1A]={
  ["category"]="so",
  ["description"]="TIBETAN SIGN RDEL DKAR GCIG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F1A, -- ༚
 },
 [0x0F1B]={
  ["category"]="so",
  ["description"]="TIBETAN SIGN RDEL DKAR GNYIS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F1B, -- ༛
 },
 [0x0F1C]={
  ["category"]="so",
  ["description"]="TIBETAN SIGN RDEL DKAR GSUM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F1C, -- ༜
 },
 [0x0F1D]={
  ["category"]="so",
  ["description"]="TIBETAN SIGN RDEL NAG GCIG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F1D, -- ༝
 },
 [0x0F1E]={
  ["category"]="so",
  ["description"]="TIBETAN SIGN RDEL NAG GNYIS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F1E, -- ༞
 },
 [0x0F1F]={
  ["category"]="so",
  ["description"]="TIBETAN SIGN RDEL DKAR RDEL NAG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F1F, -- ༟
 },
 [0x0F20]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F20, -- ༠
 },
 [0x0F21]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F21, -- ༡
 },
 [0x0F22]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F22, -- ༢
 },
 [0x0F23]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F23, -- ༣
 },
 [0x0F24]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F24, -- ༤
 },
 [0x0F25]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F25, -- ༥
 },
 [0x0F26]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F26, -- ༦
 },
 [0x0F27]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F27, -- ༧
 },
 [0x0F28]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F28, -- ༨
 },
 [0x0F29]={
  ["category"]="nd",
  ["description"]="TIBETAN DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x0F29, -- ༩
 },
 [0x0F2A]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF ONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F2A, -- ༪
 },
 [0x0F2B]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF TWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F2B, -- ༫
 },
 [0x0F2C]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF THREE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F2C, -- ༬
 },
 [0x0F2D]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF FOUR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F2D, -- ༭
 },
 [0x0F2E]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF FIVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F2E, -- ༮
 },
 [0x0F2F]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF SIX",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F2F, -- ༯
 },
 [0x0F30]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF SEVEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F30, -- ༰
 },
 [0x0F31]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF EIGHT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F31, -- ༱
 },
 [0x0F32]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF NINE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F32, -- ༲
 },
 [0x0F33]={
  ["category"]="no",
  ["description"]="TIBETAN DIGIT HALF ZERO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F33, -- ༳
 },
 [0x0F34]={
  ["category"]="so",
  ["description"]="TIBETAN MARK BSDUS RTAGS",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0F34, -- ༴
 },
 [0x0F35]={
  ["category"]="mn",
  ["description"]="TIBETAN MARK NGAS BZUNG NYI ZLA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F35, -- ༵
 },
 [0x0F36]={
  ["category"]="so",
  ["description"]="TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F36, -- ༶
 },
 [0x0F37]={
  ["category"]="mn",
  ["description"]="TIBETAN MARK NGAS BZUNG SGOR RTAGS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F37, -- ༷
 },
 [0x0F38]={
  ["category"]="so",
  ["description"]="TIBETAN MARK CHE MGO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F38, -- ༸
 },
 [0x0F39]={
  ["category"]="mn",
  ["description"]="TIBETAN MARK TSA -PHRU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F39, -- ༹
 },
 [0x0F3A]={
  ["category"]="ps",
  ["description"]="TIBETAN MARK GUG RTAGS GYON",
  ["linebreak"]="op",
  ["unicodeslot"]=0x0F3A, -- ༺
 },
 [0x0F3B]={
  ["category"]="pe",
  ["description"]="TIBETAN MARK GUG RTAGS GYAS",
  ["linebreak"]="cl",
  ["unicodeslot"]=0x0F3B, -- ༻
 },
 [0x0F3C]={
  ["category"]="ps",
  ["description"]="TIBETAN MARK ANG KHANG GYON",
  ["linebreak"]="op",
  ["unicodeslot"]=0x0F3C, -- ༼
 },
 [0x0F3D]={
  ["category"]="pe",
  ["description"]="TIBETAN MARK ANG KHANG GYAS",
  ["linebreak"]="cl",
  ["unicodeslot"]=0x0F3D, -- ༽
 },
 [0x0F3E]={
  ["category"]="mc",
  ["description"]="TIBETAN SIGN YAR TSHES",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F3E, -- ༾
 },
 [0x0F3F]={
  ["category"]="mc",
  ["description"]="TIBETAN SIGN MAR TSHES",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F3F, -- ༿
 },
 [0x0F40]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F40, -- ཀ
 },
 [0x0F41]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F41, -- ཁ
 },
 [0x0F42]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F42, -- ག
 },
 [0x0F43]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER GHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0F42, 0x0FB7 },
  ["unicodeslot"]=0x0F43, -- གྷ
 },
 [0x0F44]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F44, -- ང
 },
 [0x0F45]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F45, -- ཅ
 },
 [0x0F46]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F46, -- ཆ
 },
 [0x0F47]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F47, -- ཇ
 },
 [0x0F49]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F49, -- ཉ
 },
 [0x0F4A]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F4A, -- ཊ
 },
 [0x0F4B]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F4B, -- ཋ
 },
 [0x0F4C]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F4C, -- ཌ
 },
 [0x0F4D]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER DDHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0F4C, 0x0FB7 },
  ["unicodeslot"]=0x0F4D, -- ཌྷ
 },
 [0x0F4E]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F4E, -- ཎ
 },
 [0x0F4F]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F4F, -- ཏ
 },
 [0x0F50]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F50, -- ཐ
 },
 [0x0F51]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F51, -- ད
 },
 [0x0F52]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER DHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0F51, 0x0FB7 },
  ["unicodeslot"]=0x0F52, -- དྷ
 },
 [0x0F53]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F53, -- ན
 },
 [0x0F54]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F54, -- པ
 },
 [0x0F55]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F55, -- ཕ
 },
 [0x0F56]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F56, -- བ
 },
 [0x0F57]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER BHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0F56, 0x0FB7 },
  ["unicodeslot"]=0x0F57, -- བྷ
 },
 [0x0F58]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F58, -- མ
 },
 [0x0F59]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER TSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F59, -- ཙ
 },
 [0x0F5A]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER TSHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F5A, -- ཚ
 },
 [0x0F5B]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER DZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F5B, -- ཛ
 },
 [0x0F5C]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER DZHA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0F5B, 0x0FB7 },
  ["unicodeslot"]=0x0F5C, -- ཛྷ
 },
 [0x0F5D]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F5D, -- ཝ
 },
 [0x0F5E]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER ZHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F5E, -- ཞ
 },
 [0x0F5F]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER ZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F5F, -- ཟ
 },
 [0x0F60]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER -A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F60, -- འ
 },
 [0x0F61]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F61, -- ཡ
 },
 [0x0F62]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F62, -- ར
 },
 [0x0F63]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F63, -- ལ
 },
 [0x0F64]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F64, -- ཤ
 },
 [0x0F65]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F65, -- ཥ
 },
 [0x0F66]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F66, -- ས
 },
 [0x0F67]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F67, -- ཧ
 },
 [0x0F68]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F68, -- ཨ
 },
 [0x0F69]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER KSSA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0F40, 0x0FB5 },
  ["unicodeslot"]=0x0F69, -- ཀྵ
 },
 [0x0F6A]={
  ["category"]="lo",
  ["description"]="TIBETAN LETTER FIXED-FORM RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F6A, -- ཪ
 },
 [0x0F71]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN AA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F71, -- ཱ
 },
 [0x0F72]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F72, -- ི
 },
 [0x0F73]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN II",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0F71, 0x0F72 },
  ["unicodeslot"]=0x0F73, -- ཱི
 },
 [0x0F74]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F74, -- ུ
 },
 [0x0F75]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN UU",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0F71, 0x0F74 },
  ["unicodeslot"]=0x0F75, -- ཱུ
 },
 [0x0F76]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN VOCALIC R",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0FB2, 0x0F80 },
  ["unicodeslot"]=0x0F76, -- ྲྀ
 },
 [0x0F77]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN VOCALIC RR",
  ["linebreak"]="cm",
  ["specials"]={ "compat", 0x0FB2, 0x0F81 },
  ["unicodeslot"]=0x0F77, -- ཷ
 },
 [0x0F78]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN VOCALIC L",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0FB3, 0x0F80 },
  ["unicodeslot"]=0x0F78, -- ླྀ
 },
 [0x0F79]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN VOCALIC LL",
  ["linebreak"]="cm",
  ["specials"]={ "compat", 0x0FB3, 0x0F81 },
  ["unicodeslot"]=0x0F79, -- ཹ
 },
 [0x0F7A]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F7A, -- ེ
 },
 [0x0F7B]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN EE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F7B, -- ཻ
 },
 [0x0F7C]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F7C, -- ོ
 },
 [0x0F7D]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN OO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F7D, -- ཽ
 },
 [0x0F7E]={
  ["category"]="mn",
  ["description"]="TIBETAN SIGN RJES SU NGA RO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F7E, -- ཾ
 },
 [0x0F7F]={
  ["category"]="mc",
  ["description"]="TIBETAN SIGN RNAM BCAD",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0F7F, -- ཿ
 },
 [0x0F80]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN REVERSED I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F80, -- ྀ
 },
 [0x0F81]={
  ["category"]="mn",
  ["description"]="TIBETAN VOWEL SIGN REVERSED II",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0F71, 0x0F80 },
  ["unicodeslot"]=0x0F81, -- ཱྀ
 },
 [0x0F82]={
  ["category"]="mn",
  ["description"]="TIBETAN SIGN NYI ZLA NAA DA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F82, -- ྂ
 },
 [0x0F83]={
  ["category"]="mn",
  ["description"]="TIBETAN SIGN SNA LDAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F83, -- ྃ
 },
 [0x0F84]={
  ["category"]="mn",
  ["description"]="TIBETAN MARK HALANTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F84, -- ྄
 },
 [0x0F85]={
  ["category"]="po",
  ["description"]="TIBETAN MARK PALUTA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0F85, -- ྅
 },
 [0x0F86]={
  ["category"]="mn",
  ["description"]="TIBETAN SIGN LCI RTAGS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F86, -- ྆
 },
 [0x0F87]={
  ["category"]="mn",
  ["description"]="TIBETAN SIGN YANG RTAGS",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F87, -- ྇
 },
 [0x0F88]={
  ["category"]="lo",
  ["description"]="TIBETAN SIGN LCE TSA CAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F88, -- ྈ
 },
 [0x0F89]={
  ["category"]="lo",
  ["description"]="TIBETAN SIGN MCHU CAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F89, -- ྉ
 },
 [0x0F8A]={
  ["category"]="lo",
  ["description"]="TIBETAN SIGN GRU CAN RGYINGS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F8A, -- ྊ
 },
 [0x0F8B]={
  ["category"]="lo",
  ["description"]="TIBETAN SIGN GRU MED RGYINGS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0F8B, -- ྋ
 },
 [0x0F90]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER KA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F90, -- ྐ
 },
 [0x0F91]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER KHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F91, -- ྑ
 },
 [0x0F92]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER GA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F92, -- ྒ
 },
 [0x0F93]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER GHA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0F92, 0x0FB7 },
  ["unicodeslot"]=0x0F93, -- ྒྷ
 },
 [0x0F94]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER NGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F94, -- ྔ
 },
 [0x0F95]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER CA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F95, -- ྕ
 },
 [0x0F96]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER CHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F96, -- ྖ
 },
 [0x0F97]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER JA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F97, -- ྗ
 },
 [0x0F99]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER NYA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F99, -- ྙ
 },
 [0x0F9A]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER TTA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F9A, -- ྚ
 },
 [0x0F9B]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER TTHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F9B, -- ྛ
 },
 [0x0F9C]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER DDA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F9C, -- ྜ
 },
 [0x0F9D]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER DDHA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0F9C, 0x0FB7 },
  ["unicodeslot"]=0x0F9D, -- ྜྷ
 },
 [0x0F9E]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER NNA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F9E, -- ྞ
 },
 [0x0F9F]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER TA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0F9F, -- ྟ
 },
 [0x0FA0]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER THA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA0, -- ྠ
 },
 [0x0FA1]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER DA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA1, -- ྡ
 },
 [0x0FA2]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER DHA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0FA1, 0x0FB7 },
  ["unicodeslot"]=0x0FA2, -- ྡྷ
 },
 [0x0FA3]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER NA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA3, -- ྣ
 },
 [0x0FA4]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER PA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA4, -- ྤ
 },
 [0x0FA5]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER PHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA5, -- ྥ
 },
 [0x0FA6]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER BA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA6, -- ྦ
 },
 [0x0FA7]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER BHA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0FA6, 0x0FB7 },
  ["unicodeslot"]=0x0FA7, -- ྦྷ
 },
 [0x0FA8]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER MA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA8, -- ྨ
 },
 [0x0FA9]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER TSA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FA9, -- ྩ
 },
 [0x0FAA]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER TSHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FAA, -- ྪ
 },
 [0x0FAB]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER DZA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FAB, -- ྫ
 },
 [0x0FAC]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER DZHA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0FAB, 0x0FB7 },
  ["unicodeslot"]=0x0FAC, -- ྫྷ
 },
 [0x0FAD]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER WA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FAD, -- ྭ
 },
 [0x0FAE]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER ZHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FAE, -- ྮ
 },
 [0x0FAF]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER ZA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FAF, -- ྯ
 },
 [0x0FB0]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER -A",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB0, -- ྰ
 },
 [0x0FB1]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER YA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB1, -- ྱ
 },
 [0x0FB2]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER RA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB2, -- ྲ
 },
 [0x0FB3]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER LA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB3, -- ླ
 },
 [0x0FB4]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER SHA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB4, -- ྴ
 },
 [0x0FB5]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER SSA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB5, -- ྵ
 },
 [0x0FB6]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER SA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB6, -- ྶ
 },
 [0x0FB7]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER HA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB7, -- ྷ
 },
 [0x0FB8]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER A",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FB8, -- ྸ
 },
 [0x0FB9]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER KSSA",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x0F90, 0x0FB5 },
  ["unicodeslot"]=0x0FB9, -- ྐྵ
 },
 [0x0FBA]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER FIXED-FORM WA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FBA, -- ྺ
 },
 [0x0FBB]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER FIXED-FORM YA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FBB, -- ྻ
 },
 [0x0FBC]={
  ["category"]="mn",
  ["description"]="TIBETAN SUBJOINED LETTER FIXED-FORM RA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FBC, -- ྼ
 },
 [0x0FBE]={
  ["category"]="so",
  ["description"]="TIBETAN KU RU KHA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0FBE, -- ྾
 },
 [0x0FBF]={
  ["category"]="so",
  ["description"]="TIBETAN KU RU KHA BZHI MIG CAN",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x0FBF, -- ྿
 },
 [0x0FC0]={
  ["category"]="so",
  ["description"]="TIBETAN CANTILLATION SIGN HEAVY BEAT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC0, -- ࿀
 },
 [0x0FC1]={
  ["category"]="so",
  ["description"]="TIBETAN CANTILLATION SIGN LIGHT BEAT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC1, -- ࿁
 },
 [0x0FC2]={
  ["category"]="so",
  ["description"]="TIBETAN CANTILLATION SIGN CANG TE-U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC2, -- ࿂
 },
 [0x0FC3]={
  ["category"]="so",
  ["description"]="TIBETAN CANTILLATION SIGN SBUB -CHAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC3, -- ࿃
 },
 [0x0FC4]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL DRIL BU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC4, -- ࿄
 },
 [0x0FC5]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL RDO RJE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC5, -- ࿅
 },
 [0x0FC6]={
  ["category"]="mn",
  ["description"]="TIBETAN SYMBOL PADMA GDAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x0FC6, -- ࿆
 },
 [0x0FC7]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL RDO RJE RGYA GRAM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC7, -- ࿇
 },
 [0x0FC8]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL PHUR PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC8, -- ࿈
 },
 [0x0FC9]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL NOR BU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FC9, -- ࿉
 },
 [0x0FCA]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL NOR BU NYIS -KHYIL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FCA, -- ࿊
 },
 [0x0FCB]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL NOR BU GSUM -KHYIL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FCB, -- ࿋
 },
 [0x0FCC]={
  ["category"]="so",
  ["description"]="TIBETAN SYMBOL NOR BU BZHI -KHYIL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FCC, -- ࿌
 },
 [0x0FCF]={
  ["category"]="so",
  ["description"]="TIBETAN SIGN RDEL NAG GSUM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x0FCF, -- ࿏
 },
 [0x0FD0]={
  ["category"]="po",
  ["description"]="TIBETAN MARK BSKA- SHOG GI MGO RGYAN",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0FD0, -- ࿐
 },
 [0x0FD1]={
  ["category"]="po",
  ["description"]="TIBETAN MARK MNYAM YIG GI MGO RGYAN",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x0FD1, -- ࿑
 },
 [0x1000]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER KA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1000, -- က
 },
 [0x1001]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER KHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1001, -- ခ
 },
 [0x1002]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER GA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1002, -- ဂ
 },
 [0x1003]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER GHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1003, -- ဃ
 },
 [0x1004]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER NGA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1004, -- င
 },
 [0x1005]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER CA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1005, -- စ
 },
 [0x1006]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER CHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1006, -- ဆ
 },
 [0x1007]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER JA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1007, -- ဇ
 },
 [0x1008]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER JHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1008, -- ဈ
 },
 [0x1009]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER NYA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1009, -- ဉ
 },
 [0x100A]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER NNYA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x100A, -- ည
 },
 [0x100B]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER TTA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x100B, -- ဋ
 },
 [0x100C]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER TTHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x100C, -- ဌ
 },
 [0x100D]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER DDA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x100D, -- ဍ
 },
 [0x100E]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER DDHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x100E, -- ဎ
 },
 [0x100F]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER NNA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x100F, -- ဏ
 },
 [0x1010]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER TA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1010, -- တ
 },
 [0x1011]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER THA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1011, -- ထ
 },
 [0x1012]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER DA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1012, -- ဒ
 },
 [0x1013]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER DHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1013, -- ဓ
 },
 [0x1014]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER NA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1014, -- န
 },
 [0x1015]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER PA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1015, -- ပ
 },
 [0x1016]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER PHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1016, -- ဖ
 },
 [0x1017]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER BA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1017, -- ဗ
 },
 [0x1018]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER BHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1018, -- ဘ
 },
 [0x1019]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER MA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1019, -- မ
 },
 [0x101A]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER YA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x101A, -- ယ
 },
 [0x101B]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER RA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x101B, -- ရ
 },
 [0x101C]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER LA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x101C, -- လ
 },
 [0x101D]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER WA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x101D, -- ဝ
 },
 [0x101E]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER SA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x101E, -- သ
 },
 [0x101F]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER HA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x101F, -- ဟ
 },
 [0x1020]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER LLA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1020, -- ဠ
 },
 [0x1021]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER A",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1021, -- အ
 },
 [0x1023]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER I",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1023, -- ဣ
 },
 [0x1024]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER II",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1024, -- ဤ
 },
 [0x1025]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER U",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1025, -- ဥ
 },
 [0x1026]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER UU",
  ["linebreak"]="sa",
  ["specials"]={ "char", 0x1025, 0x102E },
  ["unicodeslot"]=0x1026, -- ဦ
 },
 [0x1027]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER E",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1027, -- ဧ
 },
 [0x1029]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER O",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1029, -- ဩ
 },
 [0x102A]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER AU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x102A, -- ဪ
 },
 [0x102C]={
  ["category"]="mc",
  ["description"]="MYANMAR VOWEL SIGN AA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x102C, -- ာ
 },
 [0x102D]={
  ["category"]="mn",
  ["description"]="MYANMAR VOWEL SIGN I",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x102D, -- ိ
 },
 [0x102E]={
  ["category"]="mn",
  ["description"]="MYANMAR VOWEL SIGN II",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x102E, -- ီ
 },
 [0x102F]={
  ["category"]="mn",
  ["description"]="MYANMAR VOWEL SIGN U",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x102F, -- ု
 },
 [0x1030]={
  ["category"]="mn",
  ["description"]="MYANMAR VOWEL SIGN UU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1030, -- ူ
 },
 [0x1031]={
  ["category"]="mc",
  ["description"]="MYANMAR VOWEL SIGN E",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1031, -- ေ
 },
 [0x1032]={
  ["category"]="mn",
  ["description"]="MYANMAR VOWEL SIGN AI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1032, -- ဲ
 },
 [0x1036]={
  ["category"]="mn",
  ["description"]="MYANMAR SIGN ANUSVARA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1036, -- ံ
 },
 [0x1037]={
  ["category"]="mn",
  ["description"]="MYANMAR SIGN DOT BELOW",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1037, -- ့
 },
 [0x1038]={
  ["category"]="mc",
  ["description"]="MYANMAR SIGN VISARGA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1038, -- း
 },
 [0x1039]={
  ["category"]="mn",
  ["description"]="MYANMAR SIGN VIRAMA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1039, -- ္
 },
 [0x1040]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1040, -- ၀
 },
 [0x1041]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1041, -- ၁
 },
 [0x1042]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1042, -- ၂
 },
 [0x1043]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1043, -- ၃
 },
 [0x1044]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1044, -- ၄
 },
 [0x1045]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1045, -- ၅
 },
 [0x1046]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1046, -- ၆
 },
 [0x1047]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1047, -- ၇
 },
 [0x1048]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1048, -- ၈
 },
 [0x1049]={
  ["category"]="nd",
  ["description"]="MYANMAR DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1049, -- ၉
 },
 [0x104A]={
  ["category"]="po",
  ["description"]="MYANMAR SIGN LITTLE SECTION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x104A, -- ၊
 },
 [0x104B]={
  ["category"]="po",
  ["description"]="MYANMAR SIGN SECTION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x104B, -- ။
 },
 [0x104C]={
  ["category"]="po",
  ["description"]="MYANMAR SYMBOL LOCATIVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x104C, -- ၌
 },
 [0x104D]={
  ["category"]="po",
  ["description"]="MYANMAR SYMBOL COMPLETED",
  ["linebreak"]="al",
  ["unicodeslot"]=0x104D, -- ၍
 },
 [0x104E]={
  ["category"]="po",
  ["description"]="MYANMAR SYMBOL AFOREMENTIONED",
  ["linebreak"]="al",
  ["unicodeslot"]=0x104E, -- ၎
 },
 [0x104F]={
  ["category"]="po",
  ["description"]="MYANMAR SYMBOL GENITIVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x104F, -- ၏
 },
 [0x1050]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER SHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1050, -- ၐ
 },
 [0x1051]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER SSA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1051, -- ၑ
 },
 [0x1052]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER VOCALIC R",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1052, -- ၒ
 },
 [0x1053]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER VOCALIC RR",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1053, -- ၓ
 },
 [0x1054]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER VOCALIC L",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1054, -- ၔ
 },
 [0x1055]={
  ["category"]="lo",
  ["description"]="MYANMAR LETTER VOCALIC LL",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1055, -- ၕ
 },
 [0x1056]={
  ["category"]="mc",
  ["description"]="MYANMAR VOWEL SIGN VOCALIC R",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1056, -- ၖ
 },
 [0x1057]={
  ["category"]="mc",
  ["description"]="MYANMAR VOWEL SIGN VOCALIC RR",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1057, -- ၗ
 },
 [0x1058]={
  ["category"]="mn",
  ["description"]="MYANMAR VOWEL SIGN VOCALIC L",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1058, -- ၘ
 },
 [0x1059]={
  ["category"]="mn",
  ["description"]="MYANMAR VOWEL SIGN VOCALIC LL",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1059, -- ၙ
 },
 [0x10A0]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER AN",
  ["lccode"]=0x2D00,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A0, -- Ⴀ
 },
 [0x10A1]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER BAN",
  ["lccode"]=0x2D01,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A1, -- Ⴁ
 },
 [0x10A2]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER GAN",
  ["lccode"]=0x2D02,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A2, -- Ⴂ
 },
 [0x10A3]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER DON",
  ["lccode"]=0x2D03,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A3, -- Ⴃ
 },
 [0x10A4]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER EN",
  ["lccode"]=0x2D04,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A4, -- Ⴄ
 },
 [0x10A5]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER VIN",
  ["lccode"]=0x2D05,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A5, -- Ⴅ
 },
 [0x10A6]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER ZEN",
  ["lccode"]=0x2D06,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A6, -- Ⴆ
 },
 [0x10A7]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER TAN",
  ["lccode"]=0x2D07,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A7, -- Ⴇ
 },
 [0x10A8]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER IN",
  ["lccode"]=0x2D08,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A8, -- Ⴈ
 },
 [0x10A9]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER KAN",
  ["lccode"]=0x2D09,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10A9, -- Ⴉ
 },
 [0x10AA]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER LAS",
  ["lccode"]=0x2D0A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10AA, -- Ⴊ
 },
 [0x10AB]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER MAN",
  ["lccode"]=0x2D0B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10AB, -- Ⴋ
 },
 [0x10AC]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER NAR",
  ["lccode"]=0x2D0C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10AC, -- Ⴌ
 },
 [0x10AD]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER ON",
  ["lccode"]=0x2D0D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10AD, -- Ⴍ
 },
 [0x10AE]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER PAR",
  ["lccode"]=0x2D0E,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10AE, -- Ⴎ
 },
 [0x10AF]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER ZHAR",
  ["lccode"]=0x2D0F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10AF, -- Ⴏ
 },
 [0x10B0]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER RAE",
  ["lccode"]=0x2D10,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B0, -- Ⴐ
 },
 [0x10B1]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER SAN",
  ["lccode"]=0x2D11,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B1, -- Ⴑ
 },
 [0x10B2]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER TAR",
  ["lccode"]=0x2D12,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B2, -- Ⴒ
 },
 [0x10B3]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER UN",
  ["lccode"]=0x2D13,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B3, -- Ⴓ
 },
 [0x10B4]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER PHAR",
  ["lccode"]=0x2D14,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B4, -- Ⴔ
 },
 [0x10B5]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER KHAR",
  ["lccode"]=0x2D15,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B5, -- Ⴕ
 },
 [0x10B6]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER GHAN",
  ["lccode"]=0x2D16,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B6, -- Ⴖ
 },
 [0x10B7]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER QAR",
  ["lccode"]=0x2D17,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B7, -- Ⴗ
 },
 [0x10B8]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER SHIN",
  ["lccode"]=0x2D18,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B8, -- Ⴘ
 },
 [0x10B9]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER CHIN",
  ["lccode"]=0x2D19,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10B9, -- Ⴙ
 },
 [0x10BA]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER CAN",
  ["lccode"]=0x2D1A,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10BA, -- Ⴚ
 },
 [0x10BB]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER JIL",
  ["lccode"]=0x2D1B,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10BB, -- Ⴛ
 },
 [0x10BC]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER CIL",
  ["lccode"]=0x2D1C,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10BC, -- Ⴜ
 },
 [0x10BD]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER CHAR",
  ["lccode"]=0x2D1D,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10BD, -- Ⴝ
 },
 [0x10BE]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER XAN",
  ["lccode"]=0x2D1E,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10BE, -- Ⴞ
 },
 [0x10BF]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER JHAN",
  ["lccode"]=0x2D1F,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10BF, -- Ⴟ
 },
 [0x10C0]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER HAE",
  ["lccode"]=0x2D20,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10C0, -- Ⴠ
 },
 [0x10C1]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER HE",
  ["lccode"]=0x2D21,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10C1, -- Ⴡ
 },
 [0x10C2]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER HIE",
  ["lccode"]=0x2D22,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10C2, -- Ⴢ
 },
 [0x10C3]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER WE",
  ["lccode"]=0x2D23,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10C3, -- Ⴣ
 },
 [0x10C4]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER HAR",
  ["lccode"]=0x2D24,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10C4, -- Ⴤ
 },
 [0x10C5]={
  ["category"]="lu",
  ["description"]="GEORGIAN CAPITAL LETTER HOE",
  ["lccode"]=0x2D25,
  ["linebreak"]="al",
  ["unicodeslot"]=0x10C5, -- Ⴥ
 },
 [0x10D0]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER AN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D0, -- ა
 },
 [0x10D1]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER BAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D1, -- ბ
 },
 [0x10D2]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER GAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D2, -- გ
 },
 [0x10D3]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER DON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D3, -- დ
 },
 [0x10D4]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER EN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D4, -- ე
 },
 [0x10D5]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER VIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D5, -- ვ
 },
 [0x10D6]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER ZEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D6, -- ზ
 },
 [0x10D7]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER TAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D7, -- თ
 },
 [0x10D8]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER IN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D8, -- ი
 },
 [0x10D9]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER KAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10D9, -- კ
 },
 [0x10DA]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER LAS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10DA, -- ლ
 },
 [0x10DB]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER MAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10DB, -- მ
 },
 [0x10DC]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER NAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10DC, -- ნ
 },
 [0x10DD]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER ON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10DD, -- ო
 },
 [0x10DE]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER PAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10DE, -- პ
 },
 [0x10DF]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER ZHAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10DF, -- ჟ
 },
 [0x10E0]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER RAE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E0, -- რ
 },
 [0x10E1]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER SAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E1, -- ს
 },
 [0x10E2]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER TAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E2, -- ტ
 },
 [0x10E3]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER UN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E3, -- უ
 },
 [0x10E4]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER PHAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E4, -- ფ
 },
 [0x10E5]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER KHAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E5, -- ქ
 },
 [0x10E6]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER GHAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E6, -- ღ
 },
 [0x10E7]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER QAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E7, -- ყ
 },
 [0x10E8]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER SHIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E8, -- შ
 },
 [0x10E9]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER CHIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10E9, -- ჩ
 },
 [0x10EA]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER CAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10EA, -- ც
 },
 [0x10EB]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER JIL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10EB, -- ძ
 },
 [0x10EC]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER CIL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10EC, -- წ
 },
 [0x10ED]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER CHAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10ED, -- ჭ
 },
 [0x10EE]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER XAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10EE, -- ხ
 },
 [0x10EF]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER JHAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10EF, -- ჯ
 },
 [0x10F0]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER HAE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F0, -- ჰ
 },
 [0x10F1]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F1, -- ჱ
 },
 [0x10F2]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER HIE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F2, -- ჲ
 },
 [0x10F3]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER WE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F3, -- ჳ
 },
 [0x10F4]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER HAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F4, -- ჴ
 },
 [0x10F5]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER HOE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F5, -- ჵ
 },
 [0x10F6]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER FI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F6, -- ჶ
 },
 [0x10F7]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER YN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F7, -- ჷ
 },
 [0x10F8]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER ELIFI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F8, -- ჸ
 },
 [0x10F9]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER TURNED GAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10F9, -- ჹ
 },
 [0x10FA]={
  ["category"]="lo",
  ["description"]="GEORGIAN LETTER AIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10FA, -- ჺ
 },
 [0x10FB]={
  ["category"]="po",
  ["description"]="GEORGIAN PARAGRAPH SEPARATOR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x10FB, -- ჻
 },
 [0x10FC]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER GEORGIAN NAR",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x10DC },
  ["unicodeslot"]=0x10FC, -- ჼ
 },
 [0x1100]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1100, -- ᄀ
 },
 [0x1101]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGKIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1101, -- ᄁ
 },
 [0x1102]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG NIEUN",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1102, -- ᄂ
 },
 [0x1103]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG TIKEUT",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1103, -- ᄃ
 },
 [0x1104]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGTIKEUT",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1104, -- ᄄ
 },
 [0x1105]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG RIEUL",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1105, -- ᄅ
 },
 [0x1106]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG MIEUM",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1106, -- ᄆ
 },
 [0x1107]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1107, -- ᄇ
 },
 [0x1108]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGPIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1108, -- ᄈ
 },
 [0x1109]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1109, -- ᄉ
 },
 [0x110A]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x110A, -- ᄊ
 },
 [0x110B]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x110B, -- ᄋ
 },
 [0x110C]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x110C, -- ᄌ
 },
 [0x110D]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGCIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x110D, -- ᄍ
 },
 [0x110E]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHIEUCH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x110E, -- ᄎ
 },
 [0x110F]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG KHIEUKH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x110F, -- ᄏ
 },
 [0x1110]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG THIEUTH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1110, -- ᄐ
 },
 [0x1111]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PHIEUPH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1111, -- ᄑ
 },
 [0x1112]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG HIEUH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1112, -- ᄒ
 },
 [0x1113]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG NIEUN-KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1113, -- ᄓ
 },
 [0x1114]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGNIEUN",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1114, -- ᄔ
 },
 [0x1115]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG NIEUN-TIKEUT",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1115, -- ᄕ
 },
 [0x1116]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG NIEUN-PIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1116, -- ᄖ
 },
 [0x1117]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG TIKEUT-KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1117, -- ᄗ
 },
 [0x1118]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG RIEUL-NIEUN",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1118, -- ᄘ
 },
 [0x1119]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGRIEUL",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1119, -- ᄙ
 },
 [0x111A]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG RIEUL-HIEUH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x111A, -- ᄚ
 },
 [0x111B]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG KAPYEOUNRIEUL",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x111B, -- ᄛ
 },
 [0x111C]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG MIEUM-PIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x111C, -- ᄜ
 },
 [0x111D]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG KAPYEOUNMIEUM",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x111D, -- ᄝ
 },
 [0x111E]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x111E, -- ᄞ
 },
 [0x111F]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-NIEUN",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x111F, -- ᄟ
 },
 [0x1120]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-TIKEUT",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1120, -- ᄠ
 },
 [0x1121]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-SIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1121, -- ᄡ
 },
 [0x1122]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-SIOS-KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1122, -- ᄢ
 },
 [0x1123]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-SIOS-TIKEUT",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1123, -- ᄣ
 },
 [0x1124]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-SIOS-PIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1124, -- ᄤ
 },
 [0x1125]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-SSANGSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1125, -- ᄥ
 },
 [0x1126]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-SIOS-CIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1126, -- ᄦ
 },
 [0x1127]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-CIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1127, -- ᄧ
 },
 [0x1128]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-CHIEUCH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1128, -- ᄨ
 },
 [0x1129]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-THIEUTH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1129, -- ᄩ
 },
 [0x112A]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PIEUP-PHIEUPH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x112A, -- ᄪ
 },
 [0x112B]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG KAPYEOUNPIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x112B, -- ᄫ
 },
 [0x112C]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG KAPYEOUNSSANGPIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x112C, -- ᄬ
 },
 [0x112D]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x112D, -- ᄭ
 },
 [0x112E]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-NIEUN",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x112E, -- ᄮ
 },
 [0x112F]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-TIKEUT",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x112F, -- ᄯ
 },
 [0x1130]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-RIEUL",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1130, -- ᄰ
 },
 [0x1131]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-MIEUM",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1131, -- ᄱ
 },
 [0x1132]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-PIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1132, -- ᄲ
 },
 [0x1133]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-PIEUP-KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1133, -- ᄳ
 },
 [0x1134]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-SSANGSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1134, -- ᄴ
 },
 [0x1135]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-IEUNG",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1135, -- ᄵ
 },
 [0x1136]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-CIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1136, -- ᄶ
 },
 [0x1137]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-CHIEUCH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1137, -- ᄷ
 },
 [0x1138]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-KHIEUKH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1138, -- ᄸ
 },
 [0x1139]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-THIEUTH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1139, -- ᄹ
 },
 [0x113A]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-PHIEUPH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x113A, -- ᄺ
 },
 [0x113B]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SIOS-HIEUH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x113B, -- ᄻ
 },
 [0x113C]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHITUEUMSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x113C, -- ᄼ
 },
 [0x113D]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHITUEUMSSANGSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x113D, -- ᄽ
 },
 [0x113E]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CEONGCHIEUMSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x113E, -- ᄾ
 },
 [0x113F]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x113F, -- ᄿ
 },
 [0x1140]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PANSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1140, -- ᅀ
 },
 [0x1141]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-KIYEOK",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1141, -- ᅁ
 },
 [0x1142]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-TIKEUT",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1142, -- ᅂ
 },
 [0x1143]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-MIEUM",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1143, -- ᅃ
 },
 [0x1144]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-PIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1144, -- ᅄ
 },
 [0x1145]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-SIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1145, -- ᅅ
 },
 [0x1146]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-PANSIOS",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1146, -- ᅆ
 },
 [0x1147]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGIEUNG",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1147, -- ᅇ
 },
 [0x1148]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-CIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1148, -- ᅈ
 },
 [0x1149]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-CHIEUCH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1149, -- ᅉ
 },
 [0x114A]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-THIEUTH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x114A, -- ᅊ
 },
 [0x114B]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG IEUNG-PHIEUPH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x114B, -- ᅋ
 },
 [0x114C]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG YESIEUNG",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x114C, -- ᅌ
 },
 [0x114D]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CIEUC-IEUNG",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x114D, -- ᅍ
 },
 [0x114E]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHITUEUMCIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x114E, -- ᅎ
 },
 [0x114F]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHITUEUMSSANGCIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x114F, -- ᅏ
 },
 [0x1150]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CEONGCHIEUMCIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1150, -- ᅐ
 },
 [0x1151]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1151, -- ᅑ
 },
 [0x1152]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHIEUCH-KHIEUKH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1152, -- ᅒ
 },
 [0x1153]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHIEUCH-HIEUH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1153, -- ᅓ
 },
 [0x1154]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CHITUEUMCHIEUCH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1154, -- ᅔ
 },
 [0x1155]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG CEONGCHIEUMCHIEUCH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1155, -- ᅕ
 },
 [0x1156]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG PHIEUPH-PIEUP",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1156, -- ᅖ
 },
 [0x1157]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG KAPYEOUNPHIEUPH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1157, -- ᅗ
 },
 [0x1158]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG SSANGHIEUH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1158, -- ᅘ
 },
 [0x1159]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG YEORINHIEUH",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x1159, -- ᅙ
 },
 [0x115F]={
  ["category"]="lo",
  ["cjkwd"]="w",
  ["description"]="HANGUL CHOSEONG FILLER",
  ["linebreak"]="jl",
  ["unicodeslot"]=0x115F, -- ᅟ
 },
 [0x1160]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG FILLER",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1160, -- ᅠ
 },
 [0x1161]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG A",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1161, -- ᅡ
 },
 [0x1162]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG AE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1162, -- ᅢ
 },
 [0x1163]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YA",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1163, -- ᅣ
 },
 [0x1164]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YAE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1164, -- ᅤ
 },
 [0x1165]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG EO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1165, -- ᅥ
 },
 [0x1166]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG E",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1166, -- ᅦ
 },
 [0x1167]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YEO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1167, -- ᅧ
 },
 [0x1168]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1168, -- ᅨ
 },
 [0x1169]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1169, -- ᅩ
 },
 [0x116A]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG WA",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x116A, -- ᅪ
 },
 [0x116B]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG WAE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x116B, -- ᅫ
 },
 [0x116C]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG OE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x116C, -- ᅬ
 },
 [0x116D]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x116D, -- ᅭ
 },
 [0x116E]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x116E, -- ᅮ
 },
 [0x116F]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG WEO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x116F, -- ᅯ
 },
 [0x1170]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG WE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1170, -- ᅰ
 },
 [0x1171]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG WI",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1171, -- ᅱ
 },
 [0x1172]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1172, -- ᅲ
 },
 [0x1173]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG EU",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1173, -- ᅳ
 },
 [0x1174]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YI",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1174, -- ᅴ
 },
 [0x1175]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG I",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1175, -- ᅵ
 },
 [0x1176]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG A-O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1176, -- ᅶ
 },
 [0x1177]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG A-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1177, -- ᅷ
 },
 [0x1178]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YA-O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1178, -- ᅸ
 },
 [0x1179]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YA-YO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1179, -- ᅹ
 },
 [0x117A]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG EO-O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x117A, -- ᅺ
 },
 [0x117B]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG EO-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x117B, -- ᅻ
 },
 [0x117C]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG EO-EU",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x117C, -- ᅼ
 },
 [0x117D]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YEO-O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x117D, -- ᅽ
 },
 [0x117E]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YEO-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x117E, -- ᅾ
 },
 [0x117F]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG O-EO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x117F, -- ᅿ
 },
 [0x1180]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG O-E",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1180, -- ᆀ
 },
 [0x1181]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG O-YE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1181, -- ᆁ
 },
 [0x1182]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG O-O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1182, -- ᆂ
 },
 [0x1183]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG O-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1183, -- ᆃ
 },
 [0x1184]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YO-YA",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1184, -- ᆄ
 },
 [0x1185]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YO-YAE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1185, -- ᆅ
 },
 [0x1186]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YO-YEO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1186, -- ᆆ
 },
 [0x1187]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YO-O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1187, -- ᆇ
 },
 [0x1188]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YO-I",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1188, -- ᆈ
 },
 [0x1189]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG U-A",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1189, -- ᆉ
 },
 [0x118A]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG U-AE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x118A, -- ᆊ
 },
 [0x118B]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG U-EO-EU",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x118B, -- ᆋ
 },
 [0x118C]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG U-YE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x118C, -- ᆌ
 },
 [0x118D]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG U-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x118D, -- ᆍ
 },
 [0x118E]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU-A",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x118E, -- ᆎ
 },
 [0x118F]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU-EO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x118F, -- ᆏ
 },
 [0x1190]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU-E",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1190, -- ᆐ
 },
 [0x1191]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU-YEO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1191, -- ᆑ
 },
 [0x1192]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU-YE",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1192, -- ᆒ
 },
 [0x1193]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1193, -- ᆓ
 },
 [0x1194]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YU-I",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1194, -- ᆔ
 },
 [0x1195]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG EU-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1195, -- ᆕ
 },
 [0x1196]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG EU-EU",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1196, -- ᆖ
 },
 [0x1197]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG YI-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1197, -- ᆗ
 },
 [0x1198]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG I-A",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1198, -- ᆘ
 },
 [0x1199]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG I-YA",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x1199, -- ᆙ
 },
 [0x119A]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG I-O",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x119A, -- ᆚ
 },
 [0x119B]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG I-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x119B, -- ᆛ
 },
 [0x119C]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG I-EU",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x119C, -- ᆜ
 },
 [0x119D]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG I-ARAEA",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x119D, -- ᆝ
 },
 [0x119E]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG ARAEA",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x119E, -- ᆞ
 },
 [0x119F]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG ARAEA-EO",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x119F, -- ᆟ
 },
 [0x11A0]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG ARAEA-U",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x11A0, -- ᆠ
 },
 [0x11A1]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG ARAEA-I",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x11A1, -- ᆡ
 },
 [0x11A2]={
  ["category"]="lo",
  ["description"]="HANGUL JUNGSEONG SSANGARAEA",
  ["linebreak"]="jv",
  ["unicodeslot"]=0x11A2, -- ᆢ
 },
 [0x11A8]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11A8, -- ᆨ
 },
 [0x11A9]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SSANGKIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11A9, -- ᆩ
 },
 [0x11AA]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KIYEOK-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11AA, -- ᆪ
 },
 [0x11AB]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11AB, -- ᆫ
 },
 [0x11AC]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN-CIEUC",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11AC, -- ᆬ
 },
 [0x11AD]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN-HIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11AD, -- ᆭ
 },
 [0x11AE]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG TIKEUT",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11AE, -- ᆮ
 },
 [0x11AF]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11AF, -- ᆯ
 },
 [0x11B0]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B0, -- ᆰ
 },
 [0x11B1]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-MIEUM",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B1, -- ᆱ
 },
 [0x11B2]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-PIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B2, -- ᆲ
 },
 [0x11B3]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B3, -- ᆳ
 },
 [0x11B4]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-THIEUTH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B4, -- ᆴ
 },
 [0x11B5]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-PHIEUPH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B5, -- ᆵ
 },
 [0x11B6]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-HIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B6, -- ᆶ
 },
 [0x11B7]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B7, -- ᆷ
 },
 [0x11B8]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B8, -- ᆸ
 },
 [0x11B9]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PIEUP-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11B9, -- ᆹ
 },
 [0x11BA]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11BA, -- ᆺ
 },
 [0x11BB]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SSANGSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11BB, -- ᆻ
 },
 [0x11BC]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG IEUNG",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11BC, -- ᆼ
 },
 [0x11BD]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG CIEUC",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11BD, -- ᆽ
 },
 [0x11BE]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG CHIEUCH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11BE, -- ᆾ
 },
 [0x11BF]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KHIEUKH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11BF, -- ᆿ
 },
 [0x11C0]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG THIEUTH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C0, -- ᇀ
 },
 [0x11C1]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PHIEUPH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C1, -- ᇁ
 },
 [0x11C2]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG HIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C2, -- ᇂ
 },
 [0x11C3]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KIYEOK-RIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C3, -- ᇃ
 },
 [0x11C4]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C4, -- ᇄ
 },
 [0x11C5]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C5, -- ᇅ
 },
 [0x11C6]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN-TIKEUT",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C6, -- ᇆ
 },
 [0x11C7]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C7, -- ᇇ
 },
 [0x11C8]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN-PANSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C8, -- ᇈ
 },
 [0x11C9]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG NIEUN-THIEUTH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11C9, -- ᇉ
 },
 [0x11CA]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG TIKEUT-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11CA, -- ᇊ
 },
 [0x11CB]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG TIKEUT-RIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11CB, -- ᇋ
 },
 [0x11CC]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-KIYEOK-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11CC, -- ᇌ
 },
 [0x11CD]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-NIEUN",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11CD, -- ᇍ
 },
 [0x11CE]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-TIKEUT",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11CE, -- ᇎ
 },
 [0x11CF]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11CF, -- ᇏ
 },
 [0x11D0]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SSANGRIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D0, -- ᇐ
 },
 [0x11D1]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D1, -- ᇑ
 },
 [0x11D2]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-MIEUM-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D2, -- ᇒ
 },
 [0x11D3]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-PIEUP-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D3, -- ᇓ
 },
 [0x11D4]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-PIEUP-HIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D4, -- ᇔ
 },
 [0x11D5]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D5, -- ᇕ
 },
 [0x11D6]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-SSANGSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D6, -- ᇖ
 },
 [0x11D7]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-PANSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D7, -- ᇗ
 },
 [0x11D8]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-KHIEUKH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D8, -- ᇘ
 },
 [0x11D9]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG RIEUL-YEORINHIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11D9, -- ᇙ
 },
 [0x11DA]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11DA, -- ᇚ
 },
 [0x11DB]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-RIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11DB, -- ᇛ
 },
 [0x11DC]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-PIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11DC, -- ᇜ
 },
 [0x11DD]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11DD, -- ᇝ
 },
 [0x11DE]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-SSANGSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11DE, -- ᇞ
 },
 [0x11DF]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-PANSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11DF, -- ᇟ
 },
 [0x11E0]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-CHIEUCH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E0, -- ᇠ
 },
 [0x11E1]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG MIEUM-HIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E1, -- ᇡ
 },
 [0x11E2]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KAPYEOUNMIEUM",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E2, -- ᇢ
 },
 [0x11E3]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PIEUP-RIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E3, -- ᇣ
 },
 [0x11E4]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PIEUP-PHIEUPH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E4, -- ᇤ
 },
 [0x11E5]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PIEUP-HIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E5, -- ᇥ
 },
 [0x11E6]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KAPYEOUNPIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E6, -- ᇦ
 },
 [0x11E7]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SIOS-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E7, -- ᇧ
 },
 [0x11E8]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SIOS-TIKEUT",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E8, -- ᇨ
 },
 [0x11E9]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SIOS-RIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11E9, -- ᇩ
 },
 [0x11EA]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SIOS-PIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11EA, -- ᇪ
 },
 [0x11EB]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PANSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11EB, -- ᇫ
 },
 [0x11EC]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG IEUNG-KIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11EC, -- ᇬ
 },
 [0x11ED]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG IEUNG-SSANGKIYEOK",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11ED, -- ᇭ
 },
 [0x11EE]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG SSANGIEUNG",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11EE, -- ᇮ
 },
 [0x11EF]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG IEUNG-KHIEUKH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11EF, -- ᇯ
 },
 [0x11F0]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG YESIEUNG",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F0, -- ᇰ
 },
 [0x11F1]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG YESIEUNG-SIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F1, -- ᇱ
 },
 [0x11F2]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG YESIEUNG-PANSIOS",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F2, -- ᇲ
 },
 [0x11F3]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG PHIEUPH-PIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F3, -- ᇳ
 },
 [0x11F4]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG KAPYEOUNPHIEUPH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F4, -- ᇴ
 },
 [0x11F5]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG HIEUH-NIEUN",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F5, -- ᇵ
 },
 [0x11F6]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG HIEUH-RIEUL",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F6, -- ᇶ
 },
 [0x11F7]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG HIEUH-MIEUM",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F7, -- ᇷ
 },
 [0x11F8]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG HIEUH-PIEUP",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F8, -- ᇸ
 },
 [0x11F9]={
  ["category"]="lo",
  ["description"]="HANGUL JONGSEONG YEORINHIEUH",
  ["linebreak"]="jt",
  ["unicodeslot"]=0x11F9, -- ᇹ
 },
 [0x1200]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1200, -- ሀ
 },
 [0x1201]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1201, -- ሁ
 },
 [0x1202]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1202, -- ሂ
 },
 [0x1203]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1203, -- ሃ
 },
 [0x1204]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1204, -- ሄ
 },
 [0x1205]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1205, -- ህ
 },
 [0x1206]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1206, -- ሆ
 },
 [0x1207]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1207, -- ሇ
 },
 [0x1208]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1208, -- ለ
 },
 [0x1209]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1209, -- ሉ
 },
 [0x120A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x120A, -- ሊ
 },
 [0x120B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x120B, -- ላ
 },
 [0x120C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x120C, -- ሌ
 },
 [0x120D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x120D, -- ል
 },
 [0x120E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x120E, -- ሎ
 },
 [0x120F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE LWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x120F, -- ሏ
 },
 [0x1210]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1210, -- ሐ
 },
 [0x1211]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1211, -- ሑ
 },
 [0x1212]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1212, -- ሒ
 },
 [0x1213]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1213, -- ሓ
 },
 [0x1214]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1214, -- ሔ
 },
 [0x1215]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1215, -- ሕ
 },
 [0x1216]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1216, -- ሖ
 },
 [0x1217]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE HHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1217, -- ሗ
 },
 [0x1218]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1218, -- መ
 },
 [0x1219]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1219, -- ሙ
 },
 [0x121A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x121A, -- ሚ
 },
 [0x121B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x121B, -- ማ
 },
 [0x121C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x121C, -- ሜ
 },
 [0x121D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ME",
  ["linebreak"]="al",
  ["unicodeslot"]=0x121D, -- ም
 },
 [0x121E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x121E, -- ሞ
 },
 [0x121F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x121F, -- ሟ
 },
 [0x1220]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1220, -- ሠ
 },
 [0x1221]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1221, -- ሡ
 },
 [0x1222]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1222, -- ሢ
 },
 [0x1223]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1223, -- ሣ
 },
 [0x1224]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1224, -- ሤ
 },
 [0x1225]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1225, -- ሥ
 },
 [0x1226]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1226, -- ሦ
 },
 [0x1227]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SZWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1227, -- ሧ
 },
 [0x1228]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1228, -- ረ
 },
 [0x1229]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1229, -- ሩ
 },
 [0x122A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x122A, -- ሪ
 },
 [0x122B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x122B, -- ራ
 },
 [0x122C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE REE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x122C, -- ሬ
 },
 [0x122D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x122D, -- ር
 },
 [0x122E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x122E, -- ሮ
 },
 [0x122F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x122F, -- ሯ
 },
 [0x1230]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1230, -- ሰ
 },
 [0x1231]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1231, -- ሱ
 },
 [0x1232]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1232, -- ሲ
 },
 [0x1233]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1233, -- ሳ
 },
 [0x1234]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1234, -- ሴ
 },
 [0x1235]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1235, -- ስ
 },
 [0x1236]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1236, -- ሶ
 },
 [0x1237]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1237, -- ሷ
 },
 [0x1238]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1238, -- ሸ
 },
 [0x1239]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1239, -- ሹ
 },
 [0x123A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x123A, -- ሺ
 },
 [0x123B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x123B, -- ሻ
 },
 [0x123C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x123C, -- ሼ
 },
 [0x123D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x123D, -- ሽ
 },
 [0x123E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x123E, -- ሾ
 },
 [0x123F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x123F, -- ሿ
 },
 [0x1240]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1240, -- ቀ
 },
 [0x1241]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1241, -- ቁ
 },
 [0x1242]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1242, -- ቂ
 },
 [0x1243]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1243, -- ቃ
 },
 [0x1244]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1244, -- ቄ
 },
 [0x1245]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1245, -- ቅ
 },
 [0x1246]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1246, -- ቆ
 },
 [0x1247]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1247, -- ቇ
 },
 [0x1248]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1248, -- ቈ
 },
 [0x124A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x124A, -- ቊ
 },
 [0x124B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x124B, -- ቋ
 },
 [0x124C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x124C, -- ቌ
 },
 [0x124D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x124D, -- ቍ
 },
 [0x1250]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1250, -- ቐ
 },
 [0x1251]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1251, -- ቑ
 },
 [0x1252]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1252, -- ቒ
 },
 [0x1253]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1253, -- ቓ
 },
 [0x1254]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1254, -- ቔ
 },
 [0x1255]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1255, -- ቕ
 },
 [0x1256]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1256, -- ቖ
 },
 [0x1258]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1258, -- ቘ
 },
 [0x125A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x125A, -- ቚ
 },
 [0x125B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x125B, -- ቛ
 },
 [0x125C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x125C, -- ቜ
 },
 [0x125D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE QHWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x125D, -- ቝ
 },
 [0x1260]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1260, -- በ
 },
 [0x1261]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1261, -- ቡ
 },
 [0x1262]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1262, -- ቢ
 },
 [0x1263]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1263, -- ባ
 },
 [0x1264]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1264, -- ቤ
 },
 [0x1265]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1265, -- ብ
 },
 [0x1266]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1266, -- ቦ
 },
 [0x1267]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1267, -- ቧ
 },
 [0x1268]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1268, -- ቨ
 },
 [0x1269]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1269, -- ቩ
 },
 [0x126A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x126A, -- ቪ
 },
 [0x126B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x126B, -- ቫ
 },
 [0x126C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x126C, -- ቬ
 },
 [0x126D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x126D, -- ቭ
 },
 [0x126E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x126E, -- ቮ
 },
 [0x126F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE VWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x126F, -- ቯ
 },
 [0x1270]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1270, -- ተ
 },
 [0x1271]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1271, -- ቱ
 },
 [0x1272]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1272, -- ቲ
 },
 [0x1273]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1273, -- ታ
 },
 [0x1274]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1274, -- ቴ
 },
 [0x1275]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1275, -- ት
 },
 [0x1276]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1276, -- ቶ
 },
 [0x1277]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1277, -- ቷ
 },
 [0x1278]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1278, -- ቸ
 },
 [0x1279]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1279, -- ቹ
 },
 [0x127A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x127A, -- ቺ
 },
 [0x127B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x127B, -- ቻ
 },
 [0x127C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x127C, -- ቼ
 },
 [0x127D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x127D, -- ች
 },
 [0x127E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x127E, -- ቾ
 },
 [0x127F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x127F, -- ቿ
 },
 [0x1280]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1280, -- ኀ
 },
 [0x1281]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1281, -- ኁ
 },
 [0x1282]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1282, -- ኂ
 },
 [0x1283]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1283, -- ኃ
 },
 [0x1284]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1284, -- ኄ
 },
 [0x1285]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1285, -- ኅ
 },
 [0x1286]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1286, -- ኆ
 },
 [0x1287]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1287, -- ኇ
 },
 [0x1288]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1288, -- ኈ
 },
 [0x128A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x128A, -- ኊ
 },
 [0x128B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x128B, -- ኋ
 },
 [0x128C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x128C, -- ኌ
 },
 [0x128D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE XWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x128D, -- ኍ
 },
 [0x1290]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1290, -- ነ
 },
 [0x1291]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1291, -- ኑ
 },
 [0x1292]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1292, -- ኒ
 },
 [0x1293]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1293, -- ና
 },
 [0x1294]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1294, -- ኔ
 },
 [0x1295]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1295, -- ን
 },
 [0x1296]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1296, -- ኖ
 },
 [0x1297]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1297, -- ኗ
 },
 [0x1298]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1298, -- ኘ
 },
 [0x1299]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1299, -- ኙ
 },
 [0x129A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x129A, -- ኚ
 },
 [0x129B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x129B, -- ኛ
 },
 [0x129C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x129C, -- ኜ
 },
 [0x129D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x129D, -- ኝ
 },
 [0x129E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x129E, -- ኞ
 },
 [0x129F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE NYWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x129F, -- ኟ
 },
 [0x12A0]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A0, -- አ
 },
 [0x12A1]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A1, -- ኡ
 },
 [0x12A2]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A2, -- ኢ
 },
 [0x12A3]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A3, -- ኣ
 },
 [0x12A4]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A4, -- ኤ
 },
 [0x12A5]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A5, -- እ
 },
 [0x12A6]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A6, -- ኦ
 },
 [0x12A7]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GLOTTAL WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A7, -- ኧ
 },
 [0x12A8]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A8, -- ከ
 },
 [0x12A9]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12A9, -- ኩ
 },
 [0x12AA]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12AA, -- ኪ
 },
 [0x12AB]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12AB, -- ካ
 },
 [0x12AC]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12AC, -- ኬ
 },
 [0x12AD]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12AD, -- ክ
 },
 [0x12AE]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12AE, -- ኮ
 },
 [0x12AF]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12AF, -- ኯ
 },
 [0x12B0]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12B0, -- ኰ
 },
 [0x12B2]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12B2, -- ኲ
 },
 [0x12B3]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12B3, -- ኳ
 },
 [0x12B4]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12B4, -- ኴ
 },
 [0x12B5]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12B5, -- ኵ
 },
 [0x12B8]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12B8, -- ኸ
 },
 [0x12B9]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12B9, -- ኹ
 },
 [0x12BA]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12BA, -- ኺ
 },
 [0x12BB]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12BB, -- ኻ
 },
 [0x12BC]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12BC, -- ኼ
 },
 [0x12BD]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12BD, -- ኽ
 },
 [0x12BE]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12BE, -- ኾ
 },
 [0x12C0]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12C0, -- ዀ
 },
 [0x12C2]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12C2, -- ዂ
 },
 [0x12C3]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12C3, -- ዃ
 },
 [0x12C4]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12C4, -- ዄ
 },
 [0x12C5]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE KXWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12C5, -- ዅ
 },
 [0x12C8]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12C8, -- ወ
 },
 [0x12C9]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12C9, -- ዉ
 },
 [0x12CA]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12CA, -- ዊ
 },
 [0x12CB]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12CB, -- ዋ
 },
 [0x12CC]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12CC, -- ዌ
 },
 [0x12CD]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12CD, -- ው
 },
 [0x12CE]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12CE, -- ዎ
 },
 [0x12CF]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE WOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12CF, -- ዏ
 },
 [0x12D0]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHARYNGEAL A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D0, -- ዐ
 },
 [0x12D1]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHARYNGEAL U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D1, -- ዑ
 },
 [0x12D2]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHARYNGEAL I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D2, -- ዒ
 },
 [0x12D3]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHARYNGEAL AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D3, -- ዓ
 },
 [0x12D4]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHARYNGEAL EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D4, -- ዔ
 },
 [0x12D5]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHARYNGEAL E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D5, -- ዕ
 },
 [0x12D6]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHARYNGEAL O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D6, -- ዖ
 },
 [0x12D8]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D8, -- ዘ
 },
 [0x12D9]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12D9, -- ዙ
 },
 [0x12DA]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12DA, -- ዚ
 },
 [0x12DB]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12DB, -- ዛ
 },
 [0x12DC]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12DC, -- ዜ
 },
 [0x12DD]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12DD, -- ዝ
 },
 [0x12DE]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12DE, -- ዞ
 },
 [0x12DF]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12DF, -- ዟ
 },
 [0x12E0]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E0, -- ዠ
 },
 [0x12E1]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E1, -- ዡ
 },
 [0x12E2]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E2, -- ዢ
 },
 [0x12E3]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E3, -- ዣ
 },
 [0x12E4]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E4, -- ዤ
 },
 [0x12E5]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E5, -- ዥ
 },
 [0x12E6]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E6, -- ዦ
 },
 [0x12E7]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE ZHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E7, -- ዧ
 },
 [0x12E8]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E8, -- የ
 },
 [0x12E9]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12E9, -- ዩ
 },
 [0x12EA]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12EA, -- ዪ
 },
 [0x12EB]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12EB, -- ያ
 },
 [0x12EC]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12EC, -- ዬ
 },
 [0x12ED]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12ED, -- ይ
 },
 [0x12EE]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12EE, -- ዮ
 },
 [0x12EF]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE YOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12EF, -- ዯ
 },
 [0x12F0]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F0, -- ደ
 },
 [0x12F1]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F1, -- ዱ
 },
 [0x12F2]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F2, -- ዲ
 },
 [0x12F3]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F3, -- ዳ
 },
 [0x12F4]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F4, -- ዴ
 },
 [0x12F5]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F5, -- ድ
 },
 [0x12F6]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F6, -- ዶ
 },
 [0x12F7]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F7, -- ዷ
 },
 [0x12F8]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F8, -- ዸ
 },
 [0x12F9]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12F9, -- ዹ
 },
 [0x12FA]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12FA, -- ዺ
 },
 [0x12FB]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12FB, -- ዻ
 },
 [0x12FC]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12FC, -- ዼ
 },
 [0x12FD]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12FD, -- ዽ
 },
 [0x12FE]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12FE, -- ዾ
 },
 [0x12FF]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE DDWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x12FF, -- ዿ
 },
 [0x1300]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1300, -- ጀ
 },
 [0x1301]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1301, -- ጁ
 },
 [0x1302]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1302, -- ጂ
 },
 [0x1303]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1303, -- ጃ
 },
 [0x1304]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1304, -- ጄ
 },
 [0x1305]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1305, -- ጅ
 },
 [0x1306]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1306, -- ጆ
 },
 [0x1307]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE JWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1307, -- ጇ
 },
 [0x1308]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1308, -- ገ
 },
 [0x1309]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1309, -- ጉ
 },
 [0x130A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x130A, -- ጊ
 },
 [0x130B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x130B, -- ጋ
 },
 [0x130C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x130C, -- ጌ
 },
 [0x130D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x130D, -- ግ
 },
 [0x130E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x130E, -- ጎ
 },
 [0x130F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x130F, -- ጏ
 },
 [0x1310]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1310, -- ጐ
 },
 [0x1312]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1312, -- ጒ
 },
 [0x1313]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1313, -- ጓ
 },
 [0x1314]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1314, -- ጔ
 },
 [0x1315]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1315, -- ጕ
 },
 [0x1318]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1318, -- ጘ
 },
 [0x1319]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1319, -- ጙ
 },
 [0x131A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x131A, -- ጚ
 },
 [0x131B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x131B, -- ጛ
 },
 [0x131C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x131C, -- ጜ
 },
 [0x131D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x131D, -- ጝ
 },
 [0x131E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x131E, -- ጞ
 },
 [0x131F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE GGWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x131F, -- ጟ
 },
 [0x1320]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1320, -- ጠ
 },
 [0x1321]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1321, -- ጡ
 },
 [0x1322]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1322, -- ጢ
 },
 [0x1323]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1323, -- ጣ
 },
 [0x1324]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1324, -- ጤ
 },
 [0x1325]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1325, -- ጥ
 },
 [0x1326]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1326, -- ጦ
 },
 [0x1327]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE THWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1327, -- ጧ
 },
 [0x1328]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1328, -- ጨ
 },
 [0x1329]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1329, -- ጩ
 },
 [0x132A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x132A, -- ጪ
 },
 [0x132B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x132B, -- ጫ
 },
 [0x132C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x132C, -- ጬ
 },
 [0x132D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x132D, -- ጭ
 },
 [0x132E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x132E, -- ጮ
 },
 [0x132F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE CHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x132F, -- ጯ
 },
 [0x1330]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1330, -- ጰ
 },
 [0x1331]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1331, -- ጱ
 },
 [0x1332]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1332, -- ጲ
 },
 [0x1333]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1333, -- ጳ
 },
 [0x1334]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1334, -- ጴ
 },
 [0x1335]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1335, -- ጵ
 },
 [0x1336]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1336, -- ጶ
 },
 [0x1337]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1337, -- ጷ
 },
 [0x1338]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1338, -- ጸ
 },
 [0x1339]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1339, -- ጹ
 },
 [0x133A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x133A, -- ጺ
 },
 [0x133B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x133B, -- ጻ
 },
 [0x133C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x133C, -- ጼ
 },
 [0x133D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x133D, -- ጽ
 },
 [0x133E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x133E, -- ጾ
 },
 [0x133F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TSWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x133F, -- ጿ
 },
 [0x1340]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1340, -- ፀ
 },
 [0x1341]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1341, -- ፁ
 },
 [0x1342]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1342, -- ፂ
 },
 [0x1343]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1343, -- ፃ
 },
 [0x1344]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1344, -- ፄ
 },
 [0x1345]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1345, -- ፅ
 },
 [0x1346]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1346, -- ፆ
 },
 [0x1347]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE TZOA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1347, -- ፇ
 },
 [0x1348]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1348, -- ፈ
 },
 [0x1349]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1349, -- ፉ
 },
 [0x134A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x134A, -- ፊ
 },
 [0x134B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x134B, -- ፋ
 },
 [0x134C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x134C, -- ፌ
 },
 [0x134D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x134D, -- ፍ
 },
 [0x134E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x134E, -- ፎ
 },
 [0x134F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x134F, -- ፏ
 },
 [0x1350]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1350, -- ፐ
 },
 [0x1351]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1351, -- ፑ
 },
 [0x1352]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1352, -- ፒ
 },
 [0x1353]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1353, -- ፓ
 },
 [0x1354]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1354, -- ፔ
 },
 [0x1355]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1355, -- ፕ
 },
 [0x1356]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1356, -- ፖ
 },
 [0x1357]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1357, -- ፗ
 },
 [0x1358]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE RYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1358, -- ፘ
 },
 [0x1359]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1359, -- ፙ
 },
 [0x135A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x135A, -- ፚ
 },
 [0x135F]={
  ["category"]="mn",
  ["description"]="ETHIOPIC COMBINING GEMINATION MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x135F, -- ፟
 },
 [0x1360]={
  ["category"]="so",
  ["description"]="ETHIOPIC SECTION MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1360, -- ፠
 },
 [0x1361]={
  ["category"]="po",
  ["description"]="ETHIOPIC WORDSPACE",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1361, -- ፡
 },
 [0x1362]={
  ["category"]="po",
  ["description"]="ETHIOPIC FULL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1362, -- ።
 },
 [0x1363]={
  ["category"]="po",
  ["description"]="ETHIOPIC COMMA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1363, -- ፣
 },
 [0x1364]={
  ["category"]="po",
  ["description"]="ETHIOPIC SEMICOLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1364, -- ፤
 },
 [0x1365]={
  ["category"]="po",
  ["description"]="ETHIOPIC COLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1365, -- ፥
 },
 [0x1366]={
  ["category"]="po",
  ["description"]="ETHIOPIC PREFACE COLON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1366, -- ፦
 },
 [0x1367]={
  ["category"]="po",
  ["description"]="ETHIOPIC QUESTION MARK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1367, -- ፧
 },
 [0x1368]={
  ["category"]="po",
  ["description"]="ETHIOPIC PARAGRAPH SEPARATOR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1368, -- ፨
 },
 [0x1369]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT ONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1369, -- ፩
 },
 [0x136A]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT TWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x136A, -- ፪
 },
 [0x136B]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT THREE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x136B, -- ፫
 },
 [0x136C]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT FOUR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x136C, -- ፬
 },
 [0x136D]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT FIVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x136D, -- ፭
 },
 [0x136E]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT SIX",
  ["linebreak"]="al",
  ["unicodeslot"]=0x136E, -- ፮
 },
 [0x136F]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT SEVEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x136F, -- ፯
 },
 [0x1370]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT EIGHT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1370, -- ፰
 },
 [0x1371]={
  ["category"]="no",
  ["description"]="ETHIOPIC DIGIT NINE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1371, -- ፱
 },
 [0x1372]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER TEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1372, -- ፲
 },
 [0x1373]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER TWENTY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1373, -- ፳
 },
 [0x1374]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER THIRTY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1374, -- ፴
 },
 [0x1375]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER FORTY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1375, -- ፵
 },
 [0x1376]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER FIFTY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1376, -- ፶
 },
 [0x1377]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER SIXTY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1377, -- ፷
 },
 [0x1378]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER SEVENTY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1378, -- ፸
 },
 [0x1379]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER EIGHTY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1379, -- ፹
 },
 [0x137A]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER NINETY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x137A, -- ፺
 },
 [0x137B]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER HUNDRED",
  ["linebreak"]="al",
  ["unicodeslot"]=0x137B, -- ፻
 },
 [0x137C]={
  ["category"]="no",
  ["description"]="ETHIOPIC NUMBER TEN THOUSAND",
  ["linebreak"]="al",
  ["unicodeslot"]=0x137C, -- ፼
 },
 [0x1380]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SEBATBEIT MWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1380, -- ᎀ
 },
 [0x1381]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1381, -- ᎁ
 },
 [0x1382]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1382, -- ᎂ
 },
 [0x1383]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE MWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1383, -- ᎃ
 },
 [0x1384]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SEBATBEIT BWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1384, -- ᎄ
 },
 [0x1385]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1385, -- ᎅ
 },
 [0x1386]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1386, -- ᎆ
 },
 [0x1387]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE BWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1387, -- ᎇ
 },
 [0x1388]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SEBATBEIT FWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1388, -- ᎈ
 },
 [0x1389]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1389, -- ᎉ
 },
 [0x138A]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x138A, -- ᎊ
 },
 [0x138B]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE FWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x138B, -- ᎋ
 },
 [0x138C]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE SEBATBEIT PWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x138C, -- ᎌ
 },
 [0x138D]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x138D, -- ᎍ
 },
 [0x138E]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x138E, -- ᎎ
 },
 [0x138F]={
  ["category"]="lo",
  ["description"]="ETHIOPIC SYLLABLE PWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x138F, -- ᎏ
 },
 [0x1390]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK YIZET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1390, -- ᎐
 },
 [0x1391]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK DERET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1391, -- ᎑
 },
 [0x1392]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK RIKRIK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1392, -- ᎒
 },
 [0x1393]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK SHORT RIKRIK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1393, -- ᎓
 },
 [0x1394]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK DIFAT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1394, -- ᎔
 },
 [0x1395]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK KENAT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1395, -- ᎕
 },
 [0x1396]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK CHIRET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1396, -- ᎖
 },
 [0x1397]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK HIDET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1397, -- ᎗
 },
 [0x1398]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK DERET-HIDET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1398, -- ᎘
 },
 [0x1399]={
  ["category"]="so",
  ["description"]="ETHIOPIC TONAL MARK KURT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1399, -- ᎙
 },
 [0x13A0]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A0, -- Ꭰ
 },
 [0x13A1]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A1, -- Ꭱ
 },
 [0x13A2]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A2, -- Ꭲ
 },
 [0x13A3]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A3, -- Ꭳ
 },
 [0x13A4]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A4, -- Ꭴ
 },
 [0x13A5]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER V",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A5, -- Ꭵ
 },
 [0x13A6]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A6, -- Ꭶ
 },
 [0x13A7]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A7, -- Ꭷ
 },
 [0x13A8]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER GE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A8, -- Ꭸ
 },
 [0x13A9]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER GI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13A9, -- Ꭹ
 },
 [0x13AA]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER GO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13AA, -- Ꭺ
 },
 [0x13AB]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER GU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13AB, -- Ꭻ
 },
 [0x13AC]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER GV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13AC, -- Ꭼ
 },
 [0x13AD]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13AD, -- Ꭽ
 },
 [0x13AE]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13AE, -- Ꭾ
 },
 [0x13AF]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER HI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13AF, -- Ꭿ
 },
 [0x13B0]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER HO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B0, -- Ꮀ
 },
 [0x13B1]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER HU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B1, -- Ꮁ
 },
 [0x13B2]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER HV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B2, -- Ꮂ
 },
 [0x13B3]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B3, -- Ꮃ
 },
 [0x13B4]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER LE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B4, -- Ꮄ
 },
 [0x13B5]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER LI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B5, -- Ꮅ
 },
 [0x13B6]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER LO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B6, -- Ꮆ
 },
 [0x13B7]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER LU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B7, -- Ꮇ
 },
 [0x13B8]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER LV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B8, -- Ꮈ
 },
 [0x13B9]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13B9, -- Ꮉ
 },
 [0x13BA]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER ME",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13BA, -- Ꮊ
 },
 [0x13BB]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER MI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13BB, -- Ꮋ
 },
 [0x13BC]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER MO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13BC, -- Ꮌ
 },
 [0x13BD]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER MU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13BD, -- Ꮍ
 },
 [0x13BE]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13BE, -- Ꮎ
 },
 [0x13BF]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER HNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13BF, -- Ꮏ
 },
 [0x13C0]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER NAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C0, -- Ꮐ
 },
 [0x13C1]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER NE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C1, -- Ꮑ
 },
 [0x13C2]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER NI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C2, -- Ꮒ
 },
 [0x13C3]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER NO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C3, -- Ꮓ
 },
 [0x13C4]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER NU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C4, -- Ꮔ
 },
 [0x13C5]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER NV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C5, -- Ꮕ
 },
 [0x13C6]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER QUA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C6, -- Ꮖ
 },
 [0x13C7]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER QUE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C7, -- Ꮗ
 },
 [0x13C8]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER QUI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C8, -- Ꮘ
 },
 [0x13C9]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER QUO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13C9, -- Ꮙ
 },
 [0x13CA]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER QUU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13CA, -- Ꮚ
 },
 [0x13CB]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER QUV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13CB, -- Ꮛ
 },
 [0x13CC]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13CC, -- Ꮜ
 },
 [0x13CD]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13CD, -- Ꮝ
 },
 [0x13CE]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER SE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13CE, -- Ꮞ
 },
 [0x13CF]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER SI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13CF, -- Ꮟ
 },
 [0x13D0]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER SO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D0, -- Ꮠ
 },
 [0x13D1]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER SU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D1, -- Ꮡ
 },
 [0x13D2]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER SV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D2, -- Ꮢ
 },
 [0x13D3]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D3, -- Ꮣ
 },
 [0x13D4]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D4, -- Ꮤ
 },
 [0x13D5]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER DE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D5, -- Ꮥ
 },
 [0x13D6]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D6, -- Ꮦ
 },
 [0x13D7]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER DI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D7, -- Ꮧ
 },
 [0x13D8]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D8, -- Ꮨ
 },
 [0x13D9]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER DO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13D9, -- Ꮩ
 },
 [0x13DA]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER DU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13DA, -- Ꮪ
 },
 [0x13DB]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER DV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13DB, -- Ꮫ
 },
 [0x13DC]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER DLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13DC, -- Ꮬ
 },
 [0x13DD]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13DD, -- Ꮭ
 },
 [0x13DE]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TLE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13DE, -- Ꮮ
 },
 [0x13DF]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TLI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13DF, -- Ꮯ
 },
 [0x13E0]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TLO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E0, -- Ꮰ
 },
 [0x13E1]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TLU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E1, -- Ꮱ
 },
 [0x13E2]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TLV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E2, -- Ꮲ
 },
 [0x13E3]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E3, -- Ꮳ
 },
 [0x13E4]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TSE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E4, -- Ꮴ
 },
 [0x13E5]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TSI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E5, -- Ꮵ
 },
 [0x13E6]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TSO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E6, -- Ꮶ
 },
 [0x13E7]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TSU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E7, -- Ꮷ
 },
 [0x13E8]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER TSV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E8, -- Ꮸ
 },
 [0x13E9]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13E9, -- Ꮹ
 },
 [0x13EA]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER WE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13EA, -- Ꮺ
 },
 [0x13EB]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER WI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13EB, -- Ꮻ
 },
 [0x13EC]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER WO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13EC, -- Ꮼ
 },
 [0x13ED]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER WU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13ED, -- Ꮽ
 },
 [0x13EE]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER WV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13EE, -- Ꮾ
 },
 [0x13EF]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13EF, -- Ꮿ
 },
 [0x13F0]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER YE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13F0, -- Ᏸ
 },
 [0x13F1]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER YI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13F1, -- Ᏹ
 },
 [0x13F2]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER YO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13F2, -- Ᏺ
 },
 [0x13F3]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER YU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13F3, -- Ᏻ
 },
 [0x13F4]={
  ["category"]="lo",
  ["description"]="CHEROKEE LETTER YV",
  ["linebreak"]="al",
  ["unicodeslot"]=0x13F4, -- Ᏼ
 },
 [0x1401]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1401, -- ᐁ
 },
 [0x1402]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS AAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1402, -- ᐂ
 },
 [0x1403]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1403, -- ᐃ
 },
 [0x1404]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS II",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1404, -- ᐄ
 },
 [0x1405]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1405, -- ᐅ
 },
 [0x1406]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1406, -- ᐆ
 },
 [0x1407]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE OO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1407, -- ᐇ
 },
 [0x1408]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1408, -- ᐈ
 },
 [0x1409]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1409, -- ᐉ
 },
 [0x140A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x140A, -- ᐊ
 },
 [0x140B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS AA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x140B, -- ᐋ
 },
 [0x140C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x140C, -- ᐌ
 },
 [0x140D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE WE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x140D, -- ᐍ
 },
 [0x140E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x140E, -- ᐎ
 },
 [0x140F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE WI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x140F, -- ᐏ
 },
 [0x1410]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1410, -- ᐐ
 },
 [0x1411]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE WII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1411, -- ᐑ
 },
 [0x1412]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1412, -- ᐒ
 },
 [0x1413]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE WO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1413, -- ᐓ
 },
 [0x1414]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1414, -- ᐔ
 },
 [0x1415]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE WOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1415, -- ᐕ
 },
 [0x1416]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI WOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1416, -- ᐖ
 },
 [0x1417]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1417, -- ᐗ
 },
 [0x1418]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1418, -- ᐘ
 },
 [0x1419]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1419, -- ᐙ
 },
 [0x141A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE WAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x141A, -- ᐚ
 },
 [0x141B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI WAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x141B, -- ᐛ
 },
 [0x141C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS AI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x141C, -- ᐜ
 },
 [0x141D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE W",
  ["linebreak"]="al",
  ["unicodeslot"]=0x141D, -- ᐝ
 },
 [0x141E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS GLOTTAL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x141E, -- ᐞ
 },
 [0x141F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL ACUTE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x141F, -- ᐟ
 },
 [0x1420]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL GRAVE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1420, -- ᐠ
 },
 [0x1421]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL BOTTOM HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1421, -- ᐡ
 },
 [0x1422]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL TOP HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1422, -- ᐢ
 },
 [0x1423]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL RIGHT HALF RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1423, -- ᐣ
 },
 [0x1424]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL RING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1424, -- ᐤ
 },
 [0x1425]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL DOUBLE ACUTE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1425, -- ᐥ
 },
 [0x1426]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1426, -- ᐦ
 },
 [0x1427]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL MIDDLE DOT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1427, -- ᐧ
 },
 [0x1428]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1428, -- ᐨ
 },
 [0x1429]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL PLUS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1429, -- ᐩ
 },
 [0x142A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FINAL DOWN TACK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x142A, -- ᐪ
 },
 [0x142B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS EN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x142B, -- ᐫ
 },
 [0x142C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS IN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x142C, -- ᐬ
 },
 [0x142D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS ON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x142D, -- ᐭ
 },
 [0x142E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS AN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x142E, -- ᐮ
 },
 [0x142F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x142F, -- ᐯ
 },
 [0x1430]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1430, -- ᐰ
 },
 [0x1431]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1431, -- ᐱ
 },
 [0x1432]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1432, -- ᐲ
 },
 [0x1433]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1433, -- ᐳ
 },
 [0x1434]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS POO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1434, -- ᐴ
 },
 [0x1435]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE POO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1435, -- ᐵ
 },
 [0x1436]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1436, -- ᐶ
 },
 [0x1437]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1437, -- ᐷ
 },
 [0x1438]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1438, -- ᐸ
 },
 [0x1439]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1439, -- ᐹ
 },
 [0x143A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x143A, -- ᐺ
 },
 [0x143B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE PWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x143B, -- ᐻ
 },
 [0x143C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x143C, -- ᐼ
 },
 [0x143D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE PWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x143D, -- ᐽ
 },
 [0x143E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x143E, -- ᐾ
 },
 [0x143F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE PWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x143F, -- ᐿ
 },
 [0x1440]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1440, -- ᑀ
 },
 [0x1441]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE PWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1441, -- ᑁ
 },
 [0x1442]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1442, -- ᑂ
 },
 [0x1443]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE PWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1443, -- ᑃ
 },
 [0x1444]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1444, -- ᑄ
 },
 [0x1445]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE PWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1445, -- ᑅ
 },
 [0x1446]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS PWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1446, -- ᑆ
 },
 [0x1447]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE PWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1447, -- ᑇ
 },
 [0x1448]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE PWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1448, -- ᑈ
 },
 [0x1449]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS P",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1449, -- ᑉ
 },
 [0x144A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE P",
  ["linebreak"]="al",
  ["unicodeslot"]=0x144A, -- ᑊ
 },
 [0x144B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x144B, -- ᑋ
 },
 [0x144C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x144C, -- ᑌ
 },
 [0x144D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x144D, -- ᑍ
 },
 [0x144E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x144E, -- ᑎ
 },
 [0x144F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x144F, -- ᑏ
 },
 [0x1450]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1450, -- ᑐ
 },
 [0x1451]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1451, -- ᑑ
 },
 [0x1452]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE TOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1452, -- ᑒ
 },
 [0x1453]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1453, -- ᑓ
 },
 [0x1454]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1454, -- ᑔ
 },
 [0x1455]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1455, -- ᑕ
 },
 [0x1456]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1456, -- ᑖ
 },
 [0x1457]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1457, -- ᑗ
 },
 [0x1458]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE TWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1458, -- ᑘ
 },
 [0x1459]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1459, -- ᑙ
 },
 [0x145A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE TWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x145A, -- ᑚ
 },
 [0x145B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x145B, -- ᑛ
 },
 [0x145C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE TWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x145C, -- ᑜ
 },
 [0x145D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x145D, -- ᑝ
 },
 [0x145E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE TWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x145E, -- ᑞ
 },
 [0x145F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x145F, -- ᑟ
 },
 [0x1460]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE TWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1460, -- ᑠ
 },
 [0x1461]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1461, -- ᑡ
 },
 [0x1462]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE TWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1462, -- ᑢ
 },
 [0x1463]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1463, -- ᑣ
 },
 [0x1464]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE TWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1464, -- ᑤ
 },
 [0x1465]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI TWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1465, -- ᑥ
 },
 [0x1466]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS T",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1466, -- ᑦ
 },
 [0x1467]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1467, -- ᑧ
 },
 [0x1468]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1468, -- ᑨ
 },
 [0x1469]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1469, -- ᑩ
 },
 [0x146A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x146A, -- ᑪ
 },
 [0x146B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x146B, -- ᑫ
 },
 [0x146C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x146C, -- ᑬ
 },
 [0x146D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x146D, -- ᑭ
 },
 [0x146E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x146E, -- ᑮ
 },
 [0x146F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x146F, -- ᑯ
 },
 [0x1470]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1470, -- ᑰ
 },
 [0x1471]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE KOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1471, -- ᑱ
 },
 [0x1472]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1472, -- ᑲ
 },
 [0x1473]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1473, -- ᑳ
 },
 [0x1474]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1474, -- ᑴ
 },
 [0x1475]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE KWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1475, -- ᑵ
 },
 [0x1476]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1476, -- ᑶ
 },
 [0x1477]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE KWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1477, -- ᑷ
 },
 [0x1478]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1478, -- ᑸ
 },
 [0x1479]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE KWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1479, -- ᑹ
 },
 [0x147A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x147A, -- ᑺ
 },
 [0x147B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE KWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x147B, -- ᑻ
 },
 [0x147C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x147C, -- ᑼ
 },
 [0x147D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE KWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x147D, -- ᑽ
 },
 [0x147E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x147E, -- ᑾ
 },
 [0x147F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE KWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x147F, -- ᑿ
 },
 [0x1480]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1480, -- ᒀ
 },
 [0x1481]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE KWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1481, -- ᒁ
 },
 [0x1482]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI KWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1482, -- ᒂ
 },
 [0x1483]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS K",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1483, -- ᒃ
 },
 [0x1484]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS KW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1484, -- ᒄ
 },
 [0x1485]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SOUTH-SLAVEY KEH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1485, -- ᒅ
 },
 [0x1486]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SOUTH-SLAVEY KIH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1486, -- ᒆ
 },
 [0x1487]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SOUTH-SLAVEY KOH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1487, -- ᒇ
 },
 [0x1488]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SOUTH-SLAVEY KAH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1488, -- ᒈ
 },
 [0x1489]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1489, -- ᒉ
 },
 [0x148A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x148A, -- ᒊ
 },
 [0x148B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x148B, -- ᒋ
 },
 [0x148C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x148C, -- ᒌ
 },
 [0x148D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x148D, -- ᒍ
 },
 [0x148E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS COO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x148E, -- ᒎ
 },
 [0x148F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE COO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x148F, -- ᒏ
 },
 [0x1490]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1490, -- ᒐ
 },
 [0x1491]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1491, -- ᒑ
 },
 [0x1492]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1492, -- ᒒ
 },
 [0x1493]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE CWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1493, -- ᒓ
 },
 [0x1494]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1494, -- ᒔ
 },
 [0x1495]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE CWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1495, -- ᒕ
 },
 [0x1496]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1496, -- ᒖ
 },
 [0x1497]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE CWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1497, -- ᒗ
 },
 [0x1498]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1498, -- ᒘ
 },
 [0x1499]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE CWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1499, -- ᒙ
 },
 [0x149A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x149A, -- ᒚ
 },
 [0x149B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE CWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x149B, -- ᒛ
 },
 [0x149C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x149C, -- ᒜ
 },
 [0x149D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE CWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x149D, -- ᒝ
 },
 [0x149E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x149E, -- ᒞ
 },
 [0x149F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE CWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x149F, -- ᒟ
 },
 [0x14A0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI CWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A0, -- ᒠ
 },
 [0x14A1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS C",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A1, -- ᒡ
 },
 [0x14A2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI TH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A2, -- ᒢ
 },
 [0x14A3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS ME",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A3, -- ᒣ
 },
 [0x14A4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A4, -- ᒤ
 },
 [0x14A5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A5, -- ᒥ
 },
 [0x14A6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A6, -- ᒦ
 },
 [0x14A7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A7, -- ᒧ
 },
 [0x14A8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A8, -- ᒨ
 },
 [0x14A9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE MOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14A9, -- ᒩ
 },
 [0x14AA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14AA, -- ᒪ
 },
 [0x14AB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14AB, -- ᒫ
 },
 [0x14AC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14AC, -- ᒬ
 },
 [0x14AD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE MWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14AD, -- ᒭ
 },
 [0x14AE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14AE, -- ᒮ
 },
 [0x14AF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE MWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14AF, -- ᒯ
 },
 [0x14B0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B0, -- ᒰ
 },
 [0x14B1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE MWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B1, -- ᒱ
 },
 [0x14B2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B2, -- ᒲ
 },
 [0x14B3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE MWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B3, -- ᒳ
 },
 [0x14B4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B4, -- ᒴ
 },
 [0x14B5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE MWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B5, -- ᒵ
 },
 [0x14B6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B6, -- ᒶ
 },
 [0x14B7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE MWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B7, -- ᒷ
 },
 [0x14B8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B8, -- ᒸ
 },
 [0x14B9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE MWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14B9, -- ᒹ
 },
 [0x14BA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI MWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14BA, -- ᒺ
 },
 [0x14BB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14BB, -- ᒻ
 },
 [0x14BC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14BC, -- ᒼ
 },
 [0x14BD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14BD, -- ᒽ
 },
 [0x14BE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS ATHAPASCAN M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14BE, -- ᒾ
 },
 [0x14BF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14BF, -- ᒿ
 },
 [0x14C0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C0, -- ᓀ
 },
 [0x14C1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C1, -- ᓁ
 },
 [0x14C2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C2, -- ᓂ
 },
 [0x14C3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C3, -- ᓃ
 },
 [0x14C4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C4, -- ᓄ
 },
 [0x14C5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C5, -- ᓅ
 },
 [0x14C6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE NOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C6, -- ᓆ
 },
 [0x14C7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C7, -- ᓇ
 },
 [0x14C8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C8, -- ᓈ
 },
 [0x14C9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14C9, -- ᓉ
 },
 [0x14CA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE NWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14CA, -- ᓊ
 },
 [0x14CB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14CB, -- ᓋ
 },
 [0x14CC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE NWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14CC, -- ᓌ
 },
 [0x14CD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14CD, -- ᓍ
 },
 [0x14CE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE NWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14CE, -- ᓎ
 },
 [0x14CF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI NWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14CF, -- ᓏ
 },
 [0x14D0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D0, -- ᓐ
 },
 [0x14D1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER NG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D1, -- ᓑ
 },
 [0x14D2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D2, -- ᓒ
 },
 [0x14D3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D3, -- ᓓ
 },
 [0x14D4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D4, -- ᓔ
 },
 [0x14D5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D5, -- ᓕ
 },
 [0x14D6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D6, -- ᓖ
 },
 [0x14D7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D7, -- ᓗ
 },
 [0x14D8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D8, -- ᓘ
 },
 [0x14D9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE LOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14D9, -- ᓙ
 },
 [0x14DA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14DA, -- ᓚ
 },
 [0x14DB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14DB, -- ᓛ
 },
 [0x14DC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14DC, -- ᓜ
 },
 [0x14DD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14DD, -- ᓝ
 },
 [0x14DE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14DE, -- ᓞ
 },
 [0x14DF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14DF, -- ᓟ
 },
 [0x14E0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E0, -- ᓠ
 },
 [0x14E1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E1, -- ᓡ
 },
 [0x14E2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E2, -- ᓢ
 },
 [0x14E3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E3, -- ᓣ
 },
 [0x14E4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E4, -- ᓤ
 },
 [0x14E5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E5, -- ᓥ
 },
 [0x14E6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E6, -- ᓦ
 },
 [0x14E7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E7, -- ᓧ
 },
 [0x14E8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E8, -- ᓨ
 },
 [0x14E9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14E9, -- ᓩ
 },
 [0x14EA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14EA, -- ᓪ
 },
 [0x14EB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14EB, -- ᓫ
 },
 [0x14EC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MEDIAL L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14EC, -- ᓬ
 },
 [0x14ED]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14ED, -- ᓭ
 },
 [0x14EE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14EE, -- ᓮ
 },
 [0x14EF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14EF, -- ᓯ
 },
 [0x14F0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F0, -- ᓰ
 },
 [0x14F1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F1, -- ᓱ
 },
 [0x14F2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F2, -- ᓲ
 },
 [0x14F3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE SOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F3, -- ᓳ
 },
 [0x14F4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F4, -- ᓴ
 },
 [0x14F5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F5, -- ᓵ
 },
 [0x14F6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F6, -- ᓶ
 },
 [0x14F7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F7, -- ᓷ
 },
 [0x14F8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F8, -- ᓸ
 },
 [0x14F9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14F9, -- ᓹ
 },
 [0x14FA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14FA, -- ᓺ
 },
 [0x14FB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14FB, -- ᓻ
 },
 [0x14FC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14FC, -- ᓼ
 },
 [0x14FD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14FD, -- ᓽ
 },
 [0x14FE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14FE, -- ᓾ
 },
 [0x14FF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x14FF, -- ᓿ
 },
 [0x1500]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1500, -- ᔀ
 },
 [0x1501]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1501, -- ᔁ
 },
 [0x1502]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1502, -- ᔂ
 },
 [0x1503]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1503, -- ᔃ
 },
 [0x1504]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI SWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1504, -- ᔄ
 },
 [0x1505]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1505, -- ᔅ
 },
 [0x1506]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS ATHAPASCAN S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1506, -- ᔆ
 },
 [0x1507]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1507, -- ᔇ
 },
 [0x1508]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1508, -- ᔈ
 },
 [0x1509]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MOOSE-CREE SK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1509, -- ᔉ
 },
 [0x150A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI SKW",
  ["linebreak"]="al",
  ["unicodeslot"]=0x150A, -- ᔊ
 },
 [0x150B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI S-W",
  ["linebreak"]="al",
  ["unicodeslot"]=0x150B, -- ᔋ
 },
 [0x150C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI SPWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x150C, -- ᔌ
 },
 [0x150D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI STWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x150D, -- ᔍ
 },
 [0x150E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI SKWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x150E, -- ᔎ
 },
 [0x150F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI SCWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x150F, -- ᔏ
 },
 [0x1510]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1510, -- ᔐ
 },
 [0x1511]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1511, -- ᔑ
 },
 [0x1512]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1512, -- ᔒ
 },
 [0x1513]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1513, -- ᔓ
 },
 [0x1514]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1514, -- ᔔ
 },
 [0x1515]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1515, -- ᔕ
 },
 [0x1516]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1516, -- ᔖ
 },
 [0x1517]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1517, -- ᔗ
 },
 [0x1518]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SHWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1518, -- ᔘ
 },
 [0x1519]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1519, -- ᔙ
 },
 [0x151A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SHWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x151A, -- ᔚ
 },
 [0x151B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x151B, -- ᔛ
 },
 [0x151C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SHWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x151C, -- ᔜ
 },
 [0x151D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x151D, -- ᔝ
 },
 [0x151E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SHWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x151E, -- ᔞ
 },
 [0x151F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x151F, -- ᔟ
 },
 [0x1520]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SHWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1520, -- ᔠ
 },
 [0x1521]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1521, -- ᔡ
 },
 [0x1522]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SHWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1522, -- ᔢ
 },
 [0x1523]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SHWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1523, -- ᔣ
 },
 [0x1524]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE SHWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1524, -- ᔤ
 },
 [0x1525]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1525, -- ᔥ
 },
 [0x1526]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1526, -- ᔦ
 },
 [0x1527]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1527, -- ᔧ
 },
 [0x1528]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1528, -- ᔨ
 },
 [0x1529]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1529, -- ᔩ
 },
 [0x152A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x152A, -- ᔪ
 },
 [0x152B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x152B, -- ᔫ
 },
 [0x152C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y-CREE YOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x152C, -- ᔬ
 },
 [0x152D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x152D, -- ᔭ
 },
 [0x152E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x152E, -- ᔮ
 },
 [0x152F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x152F, -- ᔯ
 },
 [0x1530]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE YWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1530, -- ᔰ
 },
 [0x1531]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1531, -- ᔱ
 },
 [0x1532]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE YWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1532, -- ᔲ
 },
 [0x1533]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1533, -- ᔳ
 },
 [0x1534]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE YWII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1534, -- ᔴ
 },
 [0x1535]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1535, -- ᔵ
 },
 [0x1536]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE YWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1536, -- ᔶ
 },
 [0x1537]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1537, -- ᔷ
 },
 [0x1538]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE YWOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1538, -- ᔸ
 },
 [0x1539]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1539, -- ᔹ
 },
 [0x153A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE YWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x153A, -- ᔺ
 },
 [0x153B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS YWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x153B, -- ᔻ
 },
 [0x153C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE YWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x153C, -- ᔼ
 },
 [0x153D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NASKAPI YWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x153D, -- ᔽ
 },
 [0x153E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Y",
  ["linebreak"]="al",
  ["unicodeslot"]=0x153E, -- ᔾ
 },
 [0x153F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BIBLE-CREE Y",
  ["linebreak"]="al",
  ["unicodeslot"]=0x153F, -- ᔿ
 },
 [0x1540]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE Y",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1540, -- ᕀ
 },
 [0x1541]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI YI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1541, -- ᕁ
 },
 [0x1542]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1542, -- ᕂ
 },
 [0x1543]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS R-CREE RE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1543, -- ᕃ
 },
 [0x1544]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1544, -- ᕄ
 },
 [0x1545]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1545, -- ᕅ
 },
 [0x1546]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1546, -- ᕆ
 },
 [0x1547]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1547, -- ᕇ
 },
 [0x1548]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1548, -- ᕈ
 },
 [0x1549]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS ROO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1549, -- ᕉ
 },
 [0x154A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x154A, -- ᕊ
 },
 [0x154B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x154B, -- ᕋ
 },
 [0x154C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x154C, -- ᕌ
 },
 [0x154D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x154D, -- ᕍ
 },
 [0x154E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS RWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x154E, -- ᕎ
 },
 [0x154F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE RWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x154F, -- ᕏ
 },
 [0x1550]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1550, -- ᕐ
 },
 [0x1551]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1551, -- ᕑ
 },
 [0x1552]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS MEDIAL R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1552, -- ᕒ
 },
 [0x1553]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1553, -- ᕓ
 },
 [0x1554]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1554, -- ᕔ
 },
 [0x1555]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1555, -- ᕕ
 },
 [0x1556]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1556, -- ᕖ
 },
 [0x1557]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1557, -- ᕗ
 },
 [0x1558]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1558, -- ᕘ
 },
 [0x1559]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1559, -- ᕙ
 },
 [0x155A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x155A, -- ᕚ
 },
 [0x155B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS FWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x155B, -- ᕛ
 },
 [0x155C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE FWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x155C, -- ᕜ
 },
 [0x155D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS F",
  ["linebreak"]="al",
  ["unicodeslot"]=0x155D, -- ᕝ
 },
 [0x155E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x155E, -- ᕞ
 },
 [0x155F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS N-CREE THE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x155F, -- ᕟ
 },
 [0x1560]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1560, -- ᕠ
 },
 [0x1561]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS N-CREE THI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1561, -- ᕡ
 },
 [0x1562]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1562, -- ᕢ
 },
 [0x1563]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS N-CREE THII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1563, -- ᕣ
 },
 [0x1564]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1564, -- ᕤ
 },
 [0x1565]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1565, -- ᕥ
 },
 [0x1566]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1566, -- ᕦ
 },
 [0x1567]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1567, -- ᕧ
 },
 [0x1568]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS THWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1568, -- ᕨ
 },
 [0x1569]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE THWAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1569, -- ᕩ
 },
 [0x156A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x156A, -- ᕪ
 },
 [0x156B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x156B, -- ᕫ
 },
 [0x156C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x156C, -- ᕬ
 },
 [0x156D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x156D, -- ᕭ
 },
 [0x156E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x156E, -- ᕮ
 },
 [0x156F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TTH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x156F, -- ᕯ
 },
 [0x1570]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TYE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1570, -- ᕰ
 },
 [0x1571]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TYI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1571, -- ᕱ
 },
 [0x1572]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TYO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1572, -- ᕲ
 },
 [0x1573]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1573, -- ᕳ
 },
 [0x1574]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1574, -- ᕴ
 },
 [0x1575]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK HI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1575, -- ᕵ
 },
 [0x1576]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK HII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1576, -- ᕶ
 },
 [0x1577]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK HO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1577, -- ᕷ
 },
 [0x1578]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK HOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1578, -- ᕸ
 },
 [0x1579]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1579, -- ᕹ
 },
 [0x157A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK HAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x157A, -- ᕺ
 },
 [0x157B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVIK H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x157B, -- ᕻ
 },
 [0x157C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NUNAVUT H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x157C, -- ᕼ
 },
 [0x157D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS HK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x157D, -- ᕽ
 },
 [0x157E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x157E, -- ᕾ
 },
 [0x157F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x157F, -- ᕿ
 },
 [0x1580]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1580, -- ᖀ
 },
 [0x1581]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1581, -- ᖁ
 },
 [0x1582]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1582, -- ᖂ
 },
 [0x1583]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1583, -- ᖃ
 },
 [0x1584]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1584, -- ᖄ
 },
 [0x1585]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS Q",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1585, -- ᖅ
 },
 [0x1586]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TLHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1586, -- ᖆ
 },
 [0x1587]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TLHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1587, -- ᖇ
 },
 [0x1588]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TLHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1588, -- ᖈ
 },
 [0x1589]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TLHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1589, -- ᖉ
 },
 [0x158A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE RE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x158A, -- ᖊ
 },
 [0x158B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE RI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x158B, -- ᖋ
 },
 [0x158C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE RO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x158C, -- ᖌ
 },
 [0x158D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WEST-CREE RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x158D, -- ᖍ
 },
 [0x158E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGAAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x158E, -- ᖎ
 },
 [0x158F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x158F, -- ᖏ
 },
 [0x1590]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1590, -- ᖐ
 },
 [0x1591]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1591, -- ᖑ
 },
 [0x1592]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1592, -- ᖒ
 },
 [0x1593]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1593, -- ᖓ
 },
 [0x1594]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1594, -- ᖔ
 },
 [0x1595]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1595, -- ᖕ
 },
 [0x1596]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NNG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1596, -- ᖖ
 },
 [0x1597]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI SHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1597, -- ᖗ
 },
 [0x1598]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI SHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1598, -- ᖘ
 },
 [0x1599]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI SHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1599, -- ᖙ
 },
 [0x159A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x159A, -- ᖚ
 },
 [0x159B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WOODS-CREE THE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x159B, -- ᖛ
 },
 [0x159C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WOODS-CREE THI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x159C, -- ᖜ
 },
 [0x159D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WOODS-CREE THO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x159D, -- ᖝ
 },
 [0x159E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WOODS-CREE THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x159E, -- ᖞ
 },
 [0x159F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS WOODS-CREE TH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x159F, -- ᖟ
 },
 [0x15A0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A0, -- ᖠ
 },
 [0x15A1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LHII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A1, -- ᖡ
 },
 [0x15A2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A2, -- ᖢ
 },
 [0x15A3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LHOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A3, -- ᖣ
 },
 [0x15A4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A4, -- ᖤ
 },
 [0x15A5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LHAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A5, -- ᖥ
 },
 [0x15A6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS LH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A6, -- ᖦ
 },
 [0x15A7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE THE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A7, -- ᖧ
 },
 [0x15A8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE THI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A8, -- ᖨ
 },
 [0x15A9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE THII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15A9, -- ᖩ
 },
 [0x15AA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE THO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15AA, -- ᖪ
 },
 [0x15AB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE THOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15AB, -- ᖫ
 },
 [0x15AC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15AC, -- ᖬ
 },
 [0x15AD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE THAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15AD, -- ᖭ
 },
 [0x15AE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS TH-CREE TH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15AE, -- ᖮ
 },
 [0x15AF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS AIVILIK B",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15AF, -- ᖯ
 },
 [0x15B0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B0, -- ᖰ
 },
 [0x15B1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B1, -- ᖱ
 },
 [0x15B2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B2, -- ᖲ
 },
 [0x15B3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B3, -- ᖳ
 },
 [0x15B4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT WE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B4, -- ᖴ
 },
 [0x15B5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT WI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B5, -- ᖵ
 },
 [0x15B6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT WO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B6, -- ᖶ
 },
 [0x15B7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B7, -- ᖷ
 },
 [0x15B8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT NE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B8, -- ᖸ
 },
 [0x15B9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT NI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15B9, -- ᖹ
 },
 [0x15BA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT NO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15BA, -- ᖺ
 },
 [0x15BB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15BB, -- ᖻ
 },
 [0x15BC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT KE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15BC, -- ᖼ
 },
 [0x15BD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT KI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15BD, -- ᖽ
 },
 [0x15BE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT KO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15BE, -- ᖾ
 },
 [0x15BF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS BLACKFOOT KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15BF, -- ᖿ
 },
 [0x15C0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI HE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C0, -- ᗀ
 },
 [0x15C1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI HI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C1, -- ᗁ
 },
 [0x15C2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI HO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C2, -- ᗂ
 },
 [0x15C3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C3, -- ᗃ
 },
 [0x15C4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C4, -- ᗄ
 },
 [0x15C5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C5, -- ᗅ
 },
 [0x15C6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C6, -- ᗆ
 },
 [0x15C7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C7, -- ᗇ
 },
 [0x15C8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C8, -- ᗈ
 },
 [0x15C9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15C9, -- ᗉ
 },
 [0x15CA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER RU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15CA, -- ᗊ
 },
 [0x15CB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER RO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15CB, -- ᗋ
 },
 [0x15CC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER RE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15CC, -- ᗌ
 },
 [0x15CD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER REE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15CD, -- ᗍ
 },
 [0x15CE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER RI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15CE, -- ᗎ
 },
 [0x15CF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15CF, -- ᗏ
 },
 [0x15D0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER WU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D0, -- ᗐ
 },
 [0x15D1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER WO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D1, -- ᗑ
 },
 [0x15D2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER WE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D2, -- ᗒ
 },
 [0x15D3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER WEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D3, -- ᗓ
 },
 [0x15D4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER WI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D4, -- ᗔ
 },
 [0x15D5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D5, -- ᗕ
 },
 [0x15D6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HWU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D6, -- ᗖ
 },
 [0x15D7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HWO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D7, -- ᗗ
 },
 [0x15D8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HWE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D8, -- ᗘ
 },
 [0x15D9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HWEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15D9, -- ᗙ
 },
 [0x15DA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HWI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15DA, -- ᗚ
 },
 [0x15DB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER HWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15DB, -- ᗛ
 },
 [0x15DC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER THU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15DC, -- ᗜ
 },
 [0x15DD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER THO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15DD, -- ᗝ
 },
 [0x15DE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER THE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15DE, -- ᗞ
 },
 [0x15DF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER THEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15DF, -- ᗟ
 },
 [0x15E0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER THI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E0, -- ᗠ
 },
 [0x15E1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E1, -- ᗡ
 },
 [0x15E2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E2, -- ᗢ
 },
 [0x15E3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E3, -- ᗣ
 },
 [0x15E4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E4, -- ᗤ
 },
 [0x15E5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E5, -- ᗥ
 },
 [0x15E6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E6, -- ᗦ
 },
 [0x15E7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E7, -- ᗧ
 },
 [0x15E8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER PU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E8, -- ᗨ
 },
 [0x15E9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER PO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15E9, -- ᗩ
 },
 [0x15EA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER PE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15EA, -- ᗪ
 },
 [0x15EB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER PEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15EB, -- ᗫ
 },
 [0x15EC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER PI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15EC, -- ᗬ
 },
 [0x15ED]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15ED, -- ᗭ
 },
 [0x15EE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER P",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15EE, -- ᗮ
 },
 [0x15EF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15EF, -- ᗯ
 },
 [0x15F0]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F0, -- ᗰ
 },
 [0x15F1]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F1, -- ᗱ
 },
 [0x15F2]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F2, -- ᗲ
 },
 [0x15F3]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F3, -- ᗳ
 },
 [0x15F4]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F4, -- ᗴ
 },
 [0x15F5]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F5, -- ᗵ
 },
 [0x15F6]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F6, -- ᗶ
 },
 [0x15F7]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F7, -- ᗷ
 },
 [0x15F8]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F8, -- ᗸ
 },
 [0x15F9]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15F9, -- ᗹ
 },
 [0x15FA]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15FA, -- ᗺ
 },
 [0x15FB]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KKU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15FB, -- ᗻ
 },
 [0x15FC]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KKO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15FC, -- ᗼ
 },
 [0x15FD]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15FD, -- ᗽ
 },
 [0x15FE]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KKEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15FE, -- ᗾ
 },
 [0x15FF]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KKI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x15FF, -- ᗿ
 },
 [0x1600]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KKA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1600, -- ᘀ
 },
 [0x1601]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER KK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1601, -- ᘁ
 },
 [0x1602]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER NU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1602, -- ᘂ
 },
 [0x1603]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER NO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1603, -- ᘃ
 },
 [0x1604]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER NE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1604, -- ᘄ
 },
 [0x1605]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER NEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1605, -- ᘅ
 },
 [0x1606]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER NI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1606, -- ᘆ
 },
 [0x1607]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1607, -- ᘇ
 },
 [0x1608]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER MU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1608, -- ᘈ
 },
 [0x1609]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER MO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1609, -- ᘉ
 },
 [0x160A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER ME",
  ["linebreak"]="al",
  ["unicodeslot"]=0x160A, -- ᘊ
 },
 [0x160B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER MEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x160B, -- ᘋ
 },
 [0x160C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER MI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x160C, -- ᘌ
 },
 [0x160D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x160D, -- ᘍ
 },
 [0x160E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER YU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x160E, -- ᘎ
 },
 [0x160F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER YO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x160F, -- ᘏ
 },
 [0x1610]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER YE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1610, -- ᘐ
 },
 [0x1611]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER YEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1611, -- ᘑ
 },
 [0x1612]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER YI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1612, -- ᘒ
 },
 [0x1613]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1613, -- ᘓ
 },
 [0x1614]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1614, -- ᘔ
 },
 [0x1615]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI JU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1615, -- ᘕ
 },
 [0x1616]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1616, -- ᘖ
 },
 [0x1617]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1617, -- ᘗ
 },
 [0x1618]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1618, -- ᘘ
 },
 [0x1619]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1619, -- ᘙ
 },
 [0x161A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS SAYISI JI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x161A, -- ᘚ
 },
 [0x161B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x161B, -- ᘛ
 },
 [0x161C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JJU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x161C, -- ᘜ
 },
 [0x161D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JJO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x161D, -- ᘝ
 },
 [0x161E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JJE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x161E, -- ᘞ
 },
 [0x161F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JJEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x161F, -- ᘟ
 },
 [0x1620]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JJI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1620, -- ᘠ
 },
 [0x1621]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER JJA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1621, -- ᘡ
 },
 [0x1622]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1622, -- ᘢ
 },
 [0x1623]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1623, -- ᘣ
 },
 [0x1624]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1624, -- ᘤ
 },
 [0x1625]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1625, -- ᘥ
 },
 [0x1626]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1626, -- ᘦ
 },
 [0x1627]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1627, -- ᘧ
 },
 [0x1628]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DLU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1628, -- ᘨ
 },
 [0x1629]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DLO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1629, -- ᘩ
 },
 [0x162A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DLE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x162A, -- ᘪ
 },
 [0x162B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DLEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x162B, -- ᘫ
 },
 [0x162C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DLI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x162C, -- ᘬ
 },
 [0x162D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x162D, -- ᘭ
 },
 [0x162E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x162E, -- ᘮ
 },
 [0x162F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x162F, -- ᘯ
 },
 [0x1630]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1630, -- ᘰ
 },
 [0x1631]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1631, -- ᘱ
 },
 [0x1632]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1632, -- ᘲ
 },
 [0x1633]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER LHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1633, -- ᘳ
 },
 [0x1634]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1634, -- ᘴ
 },
 [0x1635]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1635, -- ᘵ
 },
 [0x1636]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1636, -- ᘶ
 },
 [0x1637]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1637, -- ᘷ
 },
 [0x1638]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1638, -- ᘸ
 },
 [0x1639]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1639, -- ᘹ
 },
 [0x163A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x163A, -- ᘺ
 },
 [0x163B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x163B, -- ᘻ
 },
 [0x163C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x163C, -- ᘼ
 },
 [0x163D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x163D, -- ᘽ
 },
 [0x163E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x163E, -- ᘾ
 },
 [0x163F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TLA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x163F, -- ᘿ
 },
 [0x1640]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER ZU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1640, -- ᙀ
 },
 [0x1641]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER ZO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1641, -- ᙁ
 },
 [0x1642]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER ZE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1642, -- ᙂ
 },
 [0x1643]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER ZEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1643, -- ᙃ
 },
 [0x1644]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER ZI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1644, -- ᙄ
 },
 [0x1645]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER ZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1645, -- ᙅ
 },
 [0x1646]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER Z",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1646, -- ᙆ
 },
 [0x1647]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER INITIAL Z",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1647, -- ᙇ
 },
 [0x1648]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DZU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1648, -- ᙈ
 },
 [0x1649]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DZO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1649, -- ᙉ
 },
 [0x164A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DZE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x164A, -- ᙊ
 },
 [0x164B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DZEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x164B, -- ᙋ
 },
 [0x164C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DZI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x164C, -- ᙌ
 },
 [0x164D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER DZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x164D, -- ᙍ
 },
 [0x164E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x164E, -- ᙎ
 },
 [0x164F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x164F, -- ᙏ
 },
 [0x1650]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1650, -- ᙐ
 },
 [0x1651]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1651, -- ᙑ
 },
 [0x1652]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1652, -- ᙒ
 },
 [0x1653]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1653, -- ᙓ
 },
 [0x1654]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1654, -- ᙔ
 },
 [0x1655]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1655, -- ᙕ
 },
 [0x1656]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1656, -- ᙖ
 },
 [0x1657]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1657, -- ᙗ
 },
 [0x1658]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1658, -- ᙘ
 },
 [0x1659]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1659, -- ᙙ
 },
 [0x165A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER SH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x165A, -- ᙚ
 },
 [0x165B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TSU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x165B, -- ᙛ
 },
 [0x165C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TSO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x165C, -- ᙜ
 },
 [0x165D]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TSE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x165D, -- ᙝ
 },
 [0x165E]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TSEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x165E, -- ᙞ
 },
 [0x165F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TSI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x165F, -- ᙟ
 },
 [0x1660]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1660, -- ᙠ
 },
 [0x1661]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER CHU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1661, -- ᙡ
 },
 [0x1662]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER CHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1662, -- ᙢ
 },
 [0x1663]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER CHE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1663, -- ᙣ
 },
 [0x1664]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER CHEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1664, -- ᙤ
 },
 [0x1665]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER CHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1665, -- ᙥ
 },
 [0x1666]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1666, -- ᙦ
 },
 [0x1667]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTSU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1667, -- ᙧ
 },
 [0x1668]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTSO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1668, -- ᙨ
 },
 [0x1669]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTSE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1669, -- ᙩ
 },
 [0x166A]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTSEE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x166A, -- ᙪ
 },
 [0x166B]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTSI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x166B, -- ᙫ
 },
 [0x166C]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS CARRIER TTSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x166C, -- ᙬ
 },
 [0x166D]={
  ["category"]="po",
  ["description"]="CANADIAN SYLLABICS CHI SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x166D, -- ᙭
 },
 [0x166E]={
  ["category"]="po",
  ["description"]="CANADIAN SYLLABICS FULL STOP",
  ["linebreak"]="al",
  ["unicodeslot"]=0x166E, -- ᙮
 },
 [0x166F]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS QAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x166F, -- ᙯ
 },
 [0x1670]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NGAI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1670, -- ᙰ
 },
 [0x1671]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NNGI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1671, -- ᙱ
 },
 [0x1672]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NNGII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1672, -- ᙲ
 },
 [0x1673]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NNGO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1673, -- ᙳ
 },
 [0x1674]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NNGOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1674, -- ᙴ
 },
 [0x1675]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NNGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1675, -- ᙵ
 },
 [0x1676]={
  ["category"]="lo",
  ["description"]="CANADIAN SYLLABICS NNGAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1676, -- ᙶ
 },
 [0x1680]={
  ["category"]="zs",
  ["description"]="OGHAM SPACE MARK",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1680, --  
 },
 [0x1681]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER BEITH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1681, -- ᚁ
 },
 [0x1682]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER LUIS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1682, -- ᚂ
 },
 [0x1683]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER FEARN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1683, -- ᚃ
 },
 [0x1684]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER SAIL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1684, -- ᚄ
 },
 [0x1685]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER NION",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1685, -- ᚅ
 },
 [0x1686]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER UATH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1686, -- ᚆ
 },
 [0x1687]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER DAIR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1687, -- ᚇ
 },
 [0x1688]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER TINNE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1688, -- ᚈ
 },
 [0x1689]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER COLL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1689, -- ᚉ
 },
 [0x168A]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER CEIRT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x168A, -- ᚊ
 },
 [0x168B]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER MUIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x168B, -- ᚋ
 },
 [0x168C]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER GORT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x168C, -- ᚌ
 },
 [0x168D]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER NGEADAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x168D, -- ᚍ
 },
 [0x168E]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER STRAIF",
  ["linebreak"]="al",
  ["unicodeslot"]=0x168E, -- ᚎ
 },
 [0x168F]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER RUIS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x168F, -- ᚏ
 },
 [0x1690]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER AILM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1690, -- ᚐ
 },
 [0x1691]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER ONN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1691, -- ᚑ
 },
 [0x1692]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER UR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1692, -- ᚒ
 },
 [0x1693]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER EADHADH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1693, -- ᚓ
 },
 [0x1694]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER IODHADH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1694, -- ᚔ
 },
 [0x1695]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER EABHADH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1695, -- ᚕ
 },
 [0x1696]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER OR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1696, -- ᚖ
 },
 [0x1697]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER UILLEANN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1697, -- ᚗ
 },
 [0x1698]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER IFIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1698, -- ᚘ
 },
 [0x1699]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER EAMHANCHOLL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1699, -- ᚙ
 },
 [0x169A]={
  ["category"]="lo",
  ["description"]="OGHAM LETTER PEITH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x169A, -- ᚚ
 },
 [0x169B]={
  ["category"]="ps",
  ["description"]="OGHAM FEATHER MARK",
  ["linebreak"]="op",
  ["unicodeslot"]=0x169B, -- ᚛
 },
 [0x169C]={
  ["category"]="pe",
  ["description"]="OGHAM REVERSED FEATHER MARK",
  ["linebreak"]="cl",
  ["unicodeslot"]=0x169C, -- ᚜
 },
 [0x16A0]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER FEHU FEOH FE F",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A0, -- ᚠ
 },
 [0x16A1]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER V",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A1, -- ᚡ
 },
 [0x16A2]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER URUZ UR U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A2, -- ᚢ
 },
 [0x16A3]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER YR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A3, -- ᚣ
 },
 [0x16A4]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER Y",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A4, -- ᚤ
 },
 [0x16A5]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER W",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A5, -- ᚥ
 },
 [0x16A6]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER THURISAZ THURS THORN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A6, -- ᚦ
 },
 [0x16A7]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ETH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A7, -- ᚧ
 },
 [0x16A8]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ANSUZ A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A8, -- ᚨ
 },
 [0x16A9]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER OS O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16A9, -- ᚩ
 },
 [0x16AA]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER AC A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16AA, -- ᚪ
 },
 [0x16AB]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER AESC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16AB, -- ᚫ
 },
 [0x16AC]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER LONG-BRANCH-OSS O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16AC, -- ᚬ
 },
 [0x16AD]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-OSS O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16AD, -- ᚭ
 },
 [0x16AE]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16AE, -- ᚮ
 },
 [0x16AF]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER OE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16AF, -- ᚯ
 },
 [0x16B0]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B0, -- ᚰ
 },
 [0x16B1]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER RAIDO RAD REID R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B1, -- ᚱ
 },
 [0x16B2]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER KAUNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B2, -- ᚲ
 },
 [0x16B3]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER CEN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B3, -- ᚳ
 },
 [0x16B4]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER KAUN K",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B4, -- ᚴ
 },
 [0x16B5]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER G",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B5, -- ᚵ
 },
 [0x16B6]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ENG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B6, -- ᚶ
 },
 [0x16B7]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER GEBO GYFU G",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B7, -- ᚷ
 },
 [0x16B8]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER GAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B8, -- ᚸ
 },
 [0x16B9]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER WUNJO WYNN W",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16B9, -- ᚹ
 },
 [0x16BA]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER HAGLAZ H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16BA, -- ᚺ
 },
 [0x16BB]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER HAEGL H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16BB, -- ᚻ
 },
 [0x16BC]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER LONG-BRANCH-HAGALL H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16BC, -- ᚼ
 },
 [0x16BD]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-HAGALL H",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16BD, -- ᚽ
 },
 [0x16BE]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER NAUDIZ NYD NAUD N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16BE, -- ᚾ
 },
 [0x16BF]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-NAUD N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16BF, -- ᚿ
 },
 [0x16C0]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER DOTTED-N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C0, -- ᛀ
 },
 [0x16C1]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ISAZ IS ISS I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C1, -- ᛁ
 },
 [0x16C2]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C2, -- ᛂ
 },
 [0x16C3]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER JERAN J",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C3, -- ᛃ
 },
 [0x16C4]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER GER",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C4, -- ᛄ
 },
 [0x16C5]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER LONG-BRANCH-AR AE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C5, -- ᛅ
 },
 [0x16C6]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-AR A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C6, -- ᛆ
 },
 [0x16C7]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER IWAZ EOH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C7, -- ᛇ
 },
 [0x16C8]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER PERTHO PEORTH P",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C8, -- ᛈ
 },
 [0x16C9]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ALGIZ EOLHX",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16C9, -- ᛉ
 },
 [0x16CA]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SOWILO S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16CA, -- ᛊ
 },
 [0x16CB]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SIGEL LONG-BRANCH-SOL S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16CB, -- ᛋ
 },
 [0x16CC]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-SOL S",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16CC, -- ᛌ
 },
 [0x16CD]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER C",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16CD, -- ᛍ
 },
 [0x16CE]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER Z",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16CE, -- ᛎ
 },
 [0x16CF]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER TIWAZ TIR TYR T",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16CF, -- ᛏ
 },
 [0x16D0]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-TYR T",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D0, -- ᛐ
 },
 [0x16D1]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER D",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D1, -- ᛑ
 },
 [0x16D2]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER BERKANAN BEORC BJARKAN B",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D2, -- ᛒ
 },
 [0x16D3]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-BJARKAN B",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D3, -- ᛓ
 },
 [0x16D4]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER DOTTED-P",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D4, -- ᛔ
 },
 [0x16D5]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER OPEN-P",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D5, -- ᛕ
 },
 [0x16D6]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER EHWAZ EH E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D6, -- ᛖ
 },
 [0x16D7]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER MANNAZ MAN M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D7, -- ᛗ
 },
 [0x16D8]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER LONG-BRANCH-MADR M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D8, -- ᛘ
 },
 [0x16D9]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-MADR M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16D9, -- ᛙ
 },
 [0x16DA]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER LAUKAZ LAGU LOGR L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16DA, -- ᛚ
 },
 [0x16DB]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER DOTTED-L",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16DB, -- ᛛ
 },
 [0x16DC]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER INGWAZ",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16DC, -- ᛜ
 },
 [0x16DD]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16DD, -- ᛝ
 },
 [0x16DE]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER DAGAZ DAEG D",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16DE, -- ᛞ
 },
 [0x16DF]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER OTHALAN ETHEL O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16DF, -- ᛟ
 },
 [0x16E0]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER EAR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E0, -- ᛠ
 },
 [0x16E1]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER IOR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E1, -- ᛡ
 },
 [0x16E2]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER CWEORTH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E2, -- ᛢ
 },
 [0x16E3]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER CALC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E3, -- ᛣ
 },
 [0x16E4]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER CEALC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E4, -- ᛤ
 },
 [0x16E5]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER STAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E5, -- ᛥ
 },
 [0x16E6]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER LONG-BRANCH-YR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E6, -- ᛦ
 },
 [0x16E7]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER SHORT-TWIG-YR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E7, -- ᛧ
 },
 [0x16E8]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER ICELANDIC-YR",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E8, -- ᛨ
 },
 [0x16E9]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER Q",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16E9, -- ᛩ
 },
 [0x16EA]={
  ["category"]="lo",
  ["description"]="RUNIC LETTER X",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16EA, -- ᛪ
 },
 [0x16EB]={
  ["category"]="po",
  ["description"]="RUNIC SINGLE PUNCTUATION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x16EB, -- ᛫
 },
 [0x16EC]={
  ["category"]="po",
  ["description"]="RUNIC MULTIPLE PUNCTUATION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x16EC, -- ᛬
 },
 [0x16ED]={
  ["category"]="po",
  ["description"]="RUNIC CROSS PUNCTUATION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x16ED, -- ᛭
 },
 [0x16EE]={
  ["category"]="nl",
  ["description"]="RUNIC ARLAUG SYMBOL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16EE, -- ᛮ
 },
 [0x16EF]={
  ["category"]="nl",
  ["description"]="RUNIC TVIMADUR SYMBOL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16EF, -- ᛯ
 },
 [0x16F0]={
  ["category"]="nl",
  ["description"]="RUNIC BELGTHOR SYMBOL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x16F0, -- ᛰ
 },
 [0x1700]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1700, -- ᜀ
 },
 [0x1701]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1701, -- ᜁ
 },
 [0x1702]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1702, -- ᜂ
 },
 [0x1703]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1703, -- ᜃ
 },
 [0x1704]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1704, -- ᜄ
 },
 [0x1705]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1705, -- ᜅ
 },
 [0x1706]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1706, -- ᜆ
 },
 [0x1707]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1707, -- ᜇ
 },
 [0x1708]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1708, -- ᜈ
 },
 [0x1709]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1709, -- ᜉ
 },
 [0x170A]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x170A, -- ᜊ
 },
 [0x170B]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x170B, -- ᜋ
 },
 [0x170C]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x170C, -- ᜌ
 },
 [0x170E]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x170E, -- ᜎ
 },
 [0x170F]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x170F, -- ᜏ
 },
 [0x1710]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1710, -- ᜐ
 },
 [0x1711]={
  ["category"]="lo",
  ["description"]="TAGALOG LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1711, -- ᜑ
 },
 [0x1712]={
  ["category"]="mn",
  ["description"]="TAGALOG VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1712, -- ᜒ
 },
 [0x1713]={
  ["category"]="mn",
  ["description"]="TAGALOG VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1713, -- ᜓ
 },
 [0x1714]={
  ["category"]="mn",
  ["description"]="TAGALOG SIGN VIRAMA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1714, -- ᜔
 },
 [0x1720]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1720, -- ᜠ
 },
 [0x1721]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1721, -- ᜡ
 },
 [0x1722]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1722, -- ᜢ
 },
 [0x1723]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1723, -- ᜣ
 },
 [0x1724]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1724, -- ᜤ
 },
 [0x1725]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1725, -- ᜥ
 },
 [0x1726]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1726, -- ᜦ
 },
 [0x1727]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1727, -- ᜧ
 },
 [0x1728]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1728, -- ᜨ
 },
 [0x1729]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1729, -- ᜩ
 },
 [0x172A]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x172A, -- ᜪ
 },
 [0x172B]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x172B, -- ᜫ
 },
 [0x172C]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x172C, -- ᜬ
 },
 [0x172D]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x172D, -- ᜭ
 },
 [0x172E]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x172E, -- ᜮ
 },
 [0x172F]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x172F, -- ᜯ
 },
 [0x1730]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1730, -- ᜰ
 },
 [0x1731]={
  ["category"]="lo",
  ["description"]="HANUNOO LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1731, -- ᜱ
 },
 [0x1732]={
  ["category"]="mn",
  ["description"]="HANUNOO VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1732, -- ᜲ
 },
 [0x1733]={
  ["category"]="mn",
  ["description"]="HANUNOO VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1733, -- ᜳ
 },
 [0x1734]={
  ["category"]="mn",
  ["description"]="HANUNOO SIGN PAMUDPOD",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1734, -- ᜴
 },
 [0x1735]={
  ["category"]="po",
  ["description"]="PHILIPPINE SINGLE PUNCTUATION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1735, -- ᜵
 },
 [0x1736]={
  ["category"]="po",
  ["description"]="PHILIPPINE DOUBLE PUNCTUATION",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1736, -- ᜶
 },
 [0x1740]={
  ["category"]="lo",
  ["description"]="BUHID LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1740, -- ᝀ
 },
 [0x1741]={
  ["category"]="lo",
  ["description"]="BUHID LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1741, -- ᝁ
 },
 [0x1742]={
  ["category"]="lo",
  ["description"]="BUHID LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1742, -- ᝂ
 },
 [0x1743]={
  ["category"]="lo",
  ["description"]="BUHID LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1743, -- ᝃ
 },
 [0x1744]={
  ["category"]="lo",
  ["description"]="BUHID LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1744, -- ᝄ
 },
 [0x1745]={
  ["category"]="lo",
  ["description"]="BUHID LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1745, -- ᝅ
 },
 [0x1746]={
  ["category"]="lo",
  ["description"]="BUHID LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1746, -- ᝆ
 },
 [0x1747]={
  ["category"]="lo",
  ["description"]="BUHID LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1747, -- ᝇ
 },
 [0x1748]={
  ["category"]="lo",
  ["description"]="BUHID LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1748, -- ᝈ
 },
 [0x1749]={
  ["category"]="lo",
  ["description"]="BUHID LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1749, -- ᝉ
 },
 [0x174A]={
  ["category"]="lo",
  ["description"]="BUHID LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x174A, -- ᝊ
 },
 [0x174B]={
  ["category"]="lo",
  ["description"]="BUHID LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x174B, -- ᝋ
 },
 [0x174C]={
  ["category"]="lo",
  ["description"]="BUHID LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x174C, -- ᝌ
 },
 [0x174D]={
  ["category"]="lo",
  ["description"]="BUHID LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x174D, -- ᝍ
 },
 [0x174E]={
  ["category"]="lo",
  ["description"]="BUHID LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x174E, -- ᝎ
 },
 [0x174F]={
  ["category"]="lo",
  ["description"]="BUHID LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x174F, -- ᝏ
 },
 [0x1750]={
  ["category"]="lo",
  ["description"]="BUHID LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1750, -- ᝐ
 },
 [0x1751]={
  ["category"]="lo",
  ["description"]="BUHID LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1751, -- ᝑ
 },
 [0x1752]={
  ["category"]="mn",
  ["description"]="BUHID VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1752, -- ᝒ
 },
 [0x1753]={
  ["category"]="mn",
  ["description"]="BUHID VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1753, -- ᝓ
 },
 [0x1760]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1760, -- ᝠ
 },
 [0x1761]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1761, -- ᝡ
 },
 [0x1762]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1762, -- ᝢ
 },
 [0x1763]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1763, -- ᝣ
 },
 [0x1764]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1764, -- ᝤ
 },
 [0x1765]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1765, -- ᝥ
 },
 [0x1766]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1766, -- ᝦ
 },
 [0x1767]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1767, -- ᝧ
 },
 [0x1768]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1768, -- ᝨ
 },
 [0x1769]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1769, -- ᝩ
 },
 [0x176A]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x176A, -- ᝪ
 },
 [0x176B]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x176B, -- ᝫ
 },
 [0x176C]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x176C, -- ᝬ
 },
 [0x176E]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x176E, -- ᝮ
 },
 [0x176F]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x176F, -- ᝯ
 },
 [0x1770]={
  ["category"]="lo",
  ["description"]="TAGBANWA LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1770, -- ᝰ
 },
 [0x1772]={
  ["category"]="mn",
  ["description"]="TAGBANWA VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1772, -- ᝲ
 },
 [0x1773]={
  ["category"]="mn",
  ["description"]="TAGBANWA VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1773, -- ᝳ
 },
 [0x1780]={
  ["category"]="lo",
  ["description"]="KHMER LETTER KA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1780, -- ក
 },
 [0x1781]={
  ["category"]="lo",
  ["description"]="KHMER LETTER KHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1781, -- ខ
 },
 [0x1782]={
  ["category"]="lo",
  ["description"]="KHMER LETTER KO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1782, -- គ
 },
 [0x1783]={
  ["category"]="lo",
  ["description"]="KHMER LETTER KHO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1783, -- ឃ
 },
 [0x1784]={
  ["category"]="lo",
  ["description"]="KHMER LETTER NGO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1784, -- ង
 },
 [0x1785]={
  ["category"]="lo",
  ["description"]="KHMER LETTER CA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1785, -- ច
 },
 [0x1786]={
  ["category"]="lo",
  ["description"]="KHMER LETTER CHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1786, -- ឆ
 },
 [0x1787]={
  ["category"]="lo",
  ["description"]="KHMER LETTER CO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1787, -- ជ
 },
 [0x1788]={
  ["category"]="lo",
  ["description"]="KHMER LETTER CHO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1788, -- ឈ
 },
 [0x1789]={
  ["category"]="lo",
  ["description"]="KHMER LETTER NYO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1789, -- ញ
 },
 [0x178A]={
  ["category"]="lo",
  ["description"]="KHMER LETTER DA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x178A, -- ដ
 },
 [0x178B]={
  ["category"]="lo",
  ["description"]="KHMER LETTER TTHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x178B, -- ឋ
 },
 [0x178C]={
  ["category"]="lo",
  ["description"]="KHMER LETTER DO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x178C, -- ឌ
 },
 [0x178D]={
  ["category"]="lo",
  ["description"]="KHMER LETTER TTHO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x178D, -- ឍ
 },
 [0x178E]={
  ["category"]="lo",
  ["description"]="KHMER LETTER NNO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x178E, -- ណ
 },
 [0x178F]={
  ["category"]="lo",
  ["description"]="KHMER LETTER TA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x178F, -- ត
 },
 [0x1790]={
  ["category"]="lo",
  ["description"]="KHMER LETTER THA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1790, -- ថ
 },
 [0x1791]={
  ["category"]="lo",
  ["description"]="KHMER LETTER TO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1791, -- ទ
 },
 [0x1792]={
  ["category"]="lo",
  ["description"]="KHMER LETTER THO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1792, -- ធ
 },
 [0x1793]={
  ["category"]="lo",
  ["description"]="KHMER LETTER NO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1793, -- ន
 },
 [0x1794]={
  ["category"]="lo",
  ["description"]="KHMER LETTER BA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1794, -- ប
 },
 [0x1795]={
  ["category"]="lo",
  ["description"]="KHMER LETTER PHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1795, -- ផ
 },
 [0x1796]={
  ["category"]="lo",
  ["description"]="KHMER LETTER PO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1796, -- ព
 },
 [0x1797]={
  ["category"]="lo",
  ["description"]="KHMER LETTER PHO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1797, -- ភ
 },
 [0x1798]={
  ["category"]="lo",
  ["description"]="KHMER LETTER MO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1798, -- ម
 },
 [0x1799]={
  ["category"]="lo",
  ["description"]="KHMER LETTER YO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1799, -- យ
 },
 [0x179A]={
  ["category"]="lo",
  ["description"]="KHMER LETTER RO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x179A, -- រ
 },
 [0x179B]={
  ["category"]="lo",
  ["description"]="KHMER LETTER LO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x179B, -- ល
 },
 [0x179C]={
  ["category"]="lo",
  ["description"]="KHMER LETTER VO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x179C, -- វ
 },
 [0x179D]={
  ["category"]="lo",
  ["description"]="KHMER LETTER SHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x179D, -- ឝ
 },
 [0x179E]={
  ["category"]="lo",
  ["description"]="KHMER LETTER SSO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x179E, -- ឞ
 },
 [0x179F]={
  ["category"]="lo",
  ["description"]="KHMER LETTER SA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x179F, -- ស
 },
 [0x17A0]={
  ["category"]="lo",
  ["description"]="KHMER LETTER HA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A0, -- ហ
 },
 [0x17A1]={
  ["category"]="lo",
  ["description"]="KHMER LETTER LA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A1, -- ឡ
 },
 [0x17A2]={
  ["category"]="lo",
  ["description"]="KHMER LETTER QA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A2, -- អ
 },
 [0x17A3]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QAQ",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A3, -- ឣ
 },
 [0x17A4]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QAA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A4, -- ឤ
 },
 [0x17A5]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A5, -- ឥ
 },
 [0x17A6]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QII",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A6, -- ឦ
 },
 [0x17A7]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A7, -- ឧ
 },
 [0x17A8]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QUK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A8, -- ឨ
 },
 [0x17A9]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QUU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17A9, -- ឩ
 },
 [0x17AA]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QUUV",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17AA, -- ឪ
 },
 [0x17AB]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL RY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17AB, -- ឫ
 },
 [0x17AC]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL RYY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17AC, -- ឬ
 },
 [0x17AD]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL LY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17AD, -- ឭ
 },
 [0x17AE]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL LYY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17AE, -- ឮ
 },
 [0x17AF]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17AF, -- ឯ
 },
 [0x17B0]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QAI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B0, -- ឰ
 },
 [0x17B1]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QOO TYPE ONE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B1, -- ឱ
 },
 [0x17B2]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QOO TYPE TWO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B2, -- ឲ
 },
 [0x17B3]={
  ["category"]="lo",
  ["description"]="KHMER INDEPENDENT VOWEL QAU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B3, -- ឳ
 },
 [0x17B4]={
  ["category"]="cf",
  ["description"]="KHMER VOWEL INHERENT AQ",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B4, -- ឴
 },
 [0x17B5]={
  ["category"]="cf",
  ["description"]="KHMER VOWEL INHERENT AA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B5, -- ឵
 },
 [0x17B6]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN AA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B6, -- ា
 },
 [0x17B7]={
  ["category"]="mn",
  ["description"]="KHMER VOWEL SIGN I",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B7, -- ិ
 },
 [0x17B8]={
  ["category"]="mn",
  ["description"]="KHMER VOWEL SIGN II",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B8, -- ី
 },
 [0x17B9]={
  ["category"]="mn",
  ["description"]="KHMER VOWEL SIGN Y",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17B9, -- ឹ
 },
 [0x17BA]={
  ["category"]="mn",
  ["description"]="KHMER VOWEL SIGN YY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17BA, -- ឺ
 },
 [0x17BB]={
  ["category"]="mn",
  ["description"]="KHMER VOWEL SIGN U",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17BB, -- ុ
 },
 [0x17BC]={
  ["category"]="mn",
  ["description"]="KHMER VOWEL SIGN UU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17BC, -- ូ
 },
 [0x17BD]={
  ["category"]="mn",
  ["description"]="KHMER VOWEL SIGN UA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17BD, -- ួ
 },
 [0x17BE]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN OE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17BE, -- ើ
 },
 [0x17BF]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN YA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17BF, -- ឿ
 },
 [0x17C0]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN IE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C0, -- ៀ
 },
 [0x17C1]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN E",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C1, -- េ
 },
 [0x17C2]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN AE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C2, -- ែ
 },
 [0x17C3]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN AI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C3, -- ៃ
 },
 [0x17C4]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN OO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C4, -- ោ
 },
 [0x17C5]={
  ["category"]="mc",
  ["description"]="KHMER VOWEL SIGN AU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C5, -- ៅ
 },
 [0x17C6]={
  ["category"]="mn",
  ["description"]="KHMER SIGN NIKAHIT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C6, -- ំ
 },
 [0x17C7]={
  ["category"]="mc",
  ["description"]="KHMER SIGN REAHMUK",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C7, -- ះ
 },
 [0x17C8]={
  ["category"]="mc",
  ["description"]="KHMER SIGN YUUKALEAPINTU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C8, -- ៈ
 },
 [0x17C9]={
  ["category"]="mn",
  ["description"]="KHMER SIGN MUUSIKATOAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17C9, -- ៉
 },
 [0x17CA]={
  ["category"]="mn",
  ["description"]="KHMER SIGN TRIISAP",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17CA, -- ៊
 },
 [0x17CB]={
  ["category"]="mn",
  ["description"]="KHMER SIGN BANTOC",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17CB, -- ់
 },
 [0x17CC]={
  ["category"]="mn",
  ["description"]="KHMER SIGN ROBAT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17CC, -- ៌
 },
 [0x17CD]={
  ["category"]="mn",
  ["description"]="KHMER SIGN TOANDAKHIAT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17CD, -- ៍
 },
 [0x17CE]={
  ["category"]="mn",
  ["description"]="KHMER SIGN KAKABAT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17CE, -- ៎
 },
 [0x17CF]={
  ["category"]="mn",
  ["description"]="KHMER SIGN AHSDA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17CF, -- ៏
 },
 [0x17D0]={
  ["category"]="mn",
  ["description"]="KHMER SIGN SAMYOK SANNYA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17D0, -- ័
 },
 [0x17D1]={
  ["category"]="mn",
  ["description"]="KHMER SIGN VIRIAM",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17D1, -- ៑
 },
 [0x17D2]={
  ["category"]="mn",
  ["description"]="KHMER SIGN COENG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17D2, -- ្
 },
 [0x17D3]={
  ["category"]="mn",
  ["description"]="KHMER SIGN BATHAMASAT",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17D3, -- ៓
 },
 [0x17D4]={
  ["category"]="po",
  ["description"]="KHMER SIGN KHAN",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x17D4, -- ។
 },
 [0x17D5]={
  ["category"]="po",
  ["description"]="KHMER SIGN BARIYOOSAN",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x17D5, -- ៕
 },
 [0x17D6]={
  ["category"]="po",
  ["description"]="KHMER SIGN CAMNUC PII KUUH",
  ["linebreak"]="ns",
  ["unicodeslot"]=0x17D6, -- ៖
 },
 [0x17D7]={
  ["category"]="lm",
  ["description"]="KHMER SIGN LEK TOO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17D7, -- ៗ
 },
 [0x17D8]={
  ["category"]="po",
  ["description"]="KHMER SIGN BEYYAL",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x17D8, -- ៘
 },
 [0x17D9]={
  ["category"]="po",
  ["description"]="KHMER SIGN PHNAEK MUAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17D9, -- ៙
 },
 [0x17DA]={
  ["category"]="po",
  ["description"]="KHMER SIGN KOOMUUT",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x17DA, -- ៚
 },
 [0x17DB]={
  ["category"]="sc",
  ["description"]="KHMER CURRENCY SYMBOL RIEL",
  ["linebreak"]="pr",
  ["unicodeslot"]=0x17DB, -- ៛
 },
 [0x17DC]={
  ["category"]="lo",
  ["description"]="KHMER SIGN AVAKRAHASANYA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17DC, -- ៜ
 },
 [0x17DD]={
  ["category"]="mn",
  ["description"]="KHMER SIGN ATTHACAN",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x17DD, -- ៝
 },
 [0x17E0]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E0, -- ០
 },
 [0x17E1]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E1, -- ១
 },
 [0x17E2]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E2, -- ២
 },
 [0x17E3]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E3, -- ៣
 },
 [0x17E4]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E4, -- ៤
 },
 [0x17E5]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E5, -- ៥
 },
 [0x17E6]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E6, -- ៦
 },
 [0x17E7]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E7, -- ៧
 },
 [0x17E8]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E8, -- ៨
 },
 [0x17E9]={
  ["category"]="nd",
  ["description"]="KHMER DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x17E9, -- ៩
 },
 [0x17F0]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK SON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F0, -- ៰
 },
 [0x17F1]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK MUOY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F1, -- ៱
 },
 [0x17F2]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK PII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F2, -- ៲
 },
 [0x17F3]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK BEI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F3, -- ៳
 },
 [0x17F4]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK BUON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F4, -- ៴
 },
 [0x17F5]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK PRAM",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F5, -- ៵
 },
 [0x17F6]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK PRAM-MUOY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F6, -- ៶
 },
 [0x17F7]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK PRAM-PII",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F7, -- ៷
 },
 [0x17F8]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK PRAM-BEI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F8, -- ៸
 },
 [0x17F9]={
  ["category"]="no",
  ["description"]="KHMER SYMBOL LEK ATTAK PRAM-BUON",
  ["linebreak"]="al",
  ["unicodeslot"]=0x17F9, -- ៹
 },
 [0x1800]={
  ["category"]="po",
  ["description"]="MONGOLIAN BIRGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1800, -- ᠀
 },
 [0x1801]={
  ["category"]="po",
  ["description"]="MONGOLIAN ELLIPSIS",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1801, -- ᠁
 },
 [0x1802]={
  ["category"]="po",
  ["description"]="MONGOLIAN COMMA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1802, -- ᠂
 },
 [0x1803]={
  ["category"]="po",
  ["description"]="MONGOLIAN FULL STOP",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1803, -- ᠃
 },
 [0x1804]={
  ["category"]="po",
  ["description"]="MONGOLIAN COLON",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1804, -- ᠄
 },
 [0x1805]={
  ["category"]="po",
  ["description"]="MONGOLIAN FOUR DOTS",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1805, -- ᠅
 },
 [0x1806]={
  ["category"]="pd",
  ["description"]="MONGOLIAN TODO SOFT HYPHEN",
  ["linebreak"]="bb",
  ["unicodeslot"]=0x1806, -- ᠆
 },
 [0x1807]={
  ["category"]="po",
  ["description"]="MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1807, -- ᠇
 },
 [0x1808]={
  ["category"]="po",
  ["description"]="MONGOLIAN MANCHU COMMA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1808, -- ᠈
 },
 [0x1809]={
  ["category"]="po",
  ["description"]="MONGOLIAN MANCHU FULL STOP",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1809, -- ᠉
 },
 [0x180A]={
  ["category"]="po",
  ["description"]="MONGOLIAN NIRUGU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x180A, -- ᠊
 },
 [0x180B]={
  ["category"]="mn",
  ["description"]="MONGOLIAN FREE VARIATION SELECTOR ONE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x180B, -- ᠋
 },
 [0x180C]={
  ["category"]="mn",
  ["description"]="MONGOLIAN FREE VARIATION SELECTOR TWO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x180C, -- ᠌
 },
 [0x180D]={
  ["category"]="mn",
  ["description"]="MONGOLIAN FREE VARIATION SELECTOR THREE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x180D, -- ᠍
 },
 [0x180E]={
  ["category"]="zs",
  ["description"]="MONGOLIAN VOWEL SEPARATOR",
  ["linebreak"]="gl",
  ["unicodeslot"]=0x180E, -- ᠎
 },
 [0x1810]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1810, -- ᠐
 },
 [0x1811]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1811, -- ᠑
 },
 [0x1812]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1812, -- ᠒
 },
 [0x1813]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1813, -- ᠓
 },
 [0x1814]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1814, -- ᠔
 },
 [0x1815]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1815, -- ᠕
 },
 [0x1816]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1816, -- ᠖
 },
 [0x1817]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1817, -- ᠗
 },
 [0x1818]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1818, -- ᠘
 },
 [0x1819]={
  ["category"]="nd",
  ["description"]="MONGOLIAN DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1819, -- ᠙
 },
 [0x1820]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1820, -- ᠠ
 },
 [0x1821]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1821, -- ᠡ
 },
 [0x1822]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1822, -- ᠢ
 },
 [0x1823]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1823, -- ᠣ
 },
 [0x1824]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1824, -- ᠤ
 },
 [0x1825]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER OE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1825, -- ᠥ
 },
 [0x1826]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER UE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1826, -- ᠦ
 },
 [0x1827]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER EE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1827, -- ᠧ
 },
 [0x1828]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1828, -- ᠨ
 },
 [0x1829]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ANG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1829, -- ᠩ
 },
 [0x182A]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x182A, -- ᠪ
 },
 [0x182B]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x182B, -- ᠫ
 },
 [0x182C]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER QA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x182C, -- ᠬ
 },
 [0x182D]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x182D, -- ᠭ
 },
 [0x182E]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x182E, -- ᠮ
 },
 [0x182F]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x182F, -- ᠯ
 },
 [0x1830]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1830, -- ᠰ
 },
 [0x1831]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1831, -- ᠱ
 },
 [0x1832]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1832, -- ᠲ
 },
 [0x1833]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1833, -- ᠳ
 },
 [0x1834]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1834, -- ᠴ
 },
 [0x1835]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1835, -- ᠵ
 },
 [0x1836]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1836, -- ᠶ
 },
 [0x1837]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1837, -- ᠷ
 },
 [0x1838]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1838, -- ᠸ
 },
 [0x1839]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER FA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1839, -- ᠹ
 },
 [0x183A]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x183A, -- ᠺ
 },
 [0x183B]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x183B, -- ᠻ
 },
 [0x183C]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x183C, -- ᠼ
 },
 [0x183D]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x183D, -- ᠽ
 },
 [0x183E]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER HAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x183E, -- ᠾ
 },
 [0x183F]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ZRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x183F, -- ᠿ
 },
 [0x1840]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER LHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1840, -- ᡀ
 },
 [0x1841]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ZHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1841, -- ᡁ
 },
 [0x1842]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER CHI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1842, -- ᡂ
 },
 [0x1843]={
  ["category"]="lm",
  ["description"]="MONGOLIAN LETTER TODO LONG VOWEL SIGN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1843, -- ᡃ
 },
 [0x1844]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1844, -- ᡄ
 },
 [0x1845]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1845, -- ᡅ
 },
 [0x1846]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1846, -- ᡆ
 },
 [0x1847]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1847, -- ᡇ
 },
 [0x1848]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO OE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1848, -- ᡈ
 },
 [0x1849]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO UE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1849, -- ᡉ
 },
 [0x184A]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO ANG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x184A, -- ᡊ
 },
 [0x184B]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x184B, -- ᡋ
 },
 [0x184C]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x184C, -- ᡌ
 },
 [0x184D]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO QA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x184D, -- ᡍ
 },
 [0x184E]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x184E, -- ᡎ
 },
 [0x184F]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x184F, -- ᡏ
 },
 [0x1850]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1850, -- ᡐ
 },
 [0x1851]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1851, -- ᡑ
 },
 [0x1852]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1852, -- ᡒ
 },
 [0x1853]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1853, -- ᡓ
 },
 [0x1854]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO TSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1854, -- ᡔ
 },
 [0x1855]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1855, -- ᡕ
 },
 [0x1856]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1856, -- ᡖ
 },
 [0x1857]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1857, -- ᡗ
 },
 [0x1858]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO GAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1858, -- ᡘ
 },
 [0x1859]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO HAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1859, -- ᡙ
 },
 [0x185A]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO JIA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x185A, -- ᡚ
 },
 [0x185B]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO NIA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x185B, -- ᡛ
 },
 [0x185C]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO DZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x185C, -- ᡜ
 },
 [0x185D]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x185D, -- ᡝ
 },
 [0x185E]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x185E, -- ᡞ
 },
 [0x185F]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE IY",
  ["linebreak"]="al",
  ["unicodeslot"]=0x185F, -- ᡟ
 },
 [0x1860]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE UE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1860, -- ᡠ
 },
 [0x1861]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1861, -- ᡡ
 },
 [0x1862]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE ANG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1862, -- ᡢ
 },
 [0x1863]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1863, -- ᡣ
 },
 [0x1864]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1864, -- ᡤ
 },
 [0x1865]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1865, -- ᡥ
 },
 [0x1866]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1866, -- ᡦ
 },
 [0x1867]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1867, -- ᡧ
 },
 [0x1868]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1868, -- ᡨ
 },
 [0x1869]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1869, -- ᡩ
 },
 [0x186A]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x186A, -- ᡪ
 },
 [0x186B]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE FA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x186B, -- ᡫ
 },
 [0x186C]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE GAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x186C, -- ᡬ
 },
 [0x186D]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE HAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x186D, -- ᡭ
 },
 [0x186E]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE TSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x186E, -- ᡮ
 },
 [0x186F]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE ZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x186F, -- ᡯ
 },
 [0x1870]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE RAA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1870, -- ᡰ
 },
 [0x1871]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1871, -- ᡱ
 },
 [0x1872]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER SIBE ZHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1872, -- ᡲ
 },
 [0x1873]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1873, -- ᡳ
 },
 [0x1874]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1874, -- ᡴ
 },
 [0x1875]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1875, -- ᡵ
 },
 [0x1876]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU FA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1876, -- ᡶ
 },
 [0x1877]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ZHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1877, -- ᡷ
 },
 [0x1880]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI ANUSVARA ONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1880, -- ᢀ
 },
 [0x1881]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI VISARGA ONE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1881, -- ᢁ
 },
 [0x1882]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI DAMARU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1882, -- ᢂ
 },
 [0x1883]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI UBADAMA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1883, -- ᢃ
 },
 [0x1884]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI INVERTED UBADAMA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1884, -- ᢄ
 },
 [0x1885]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI BALUDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1885, -- ᢅ
 },
 [0x1886]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI THREE BALUDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1886, -- ᢆ
 },
 [0x1887]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1887, -- ᢇ
 },
 [0x1888]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1888, -- ᢈ
 },
 [0x1889]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1889, -- ᢉ
 },
 [0x188A]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x188A, -- ᢊ
 },
 [0x188B]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x188B, -- ᢋ
 },
 [0x188C]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x188C, -- ᢌ
 },
 [0x188D]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI TTHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x188D, -- ᢍ
 },
 [0x188E]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI DDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x188E, -- ᢎ
 },
 [0x188F]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI NNA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x188F, -- ᢏ
 },
 [0x1890]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1890, -- ᢐ
 },
 [0x1891]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1891, -- ᢑ
 },
 [0x1892]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1892, -- ᢒ
 },
 [0x1893]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1893, -- ᢓ
 },
 [0x1894]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1894, -- ᢔ
 },
 [0x1895]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI ZHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1895, -- ᢕ
 },
 [0x1896]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI ZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1896, -- ᢖ
 },
 [0x1897]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI AH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1897, -- ᢗ
 },
 [0x1898]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO ALI GALI TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1898, -- ᢘ
 },
 [0x1899]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER TODO ALI GALI ZHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1899, -- ᢙ
 },
 [0x189A]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x189A, -- ᢚ
 },
 [0x189B]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x189B, -- ᢛ
 },
 [0x189C]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x189C, -- ᢜ
 },
 [0x189D]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x189D, -- ᢝ
 },
 [0x189E]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI TTA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x189E, -- ᢞ
 },
 [0x189F]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI DDHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x189F, -- ᢟ
 },
 [0x18A0]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A0, -- ᢠ
 },
 [0x18A1]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A1, -- ᢡ
 },
 [0x18A2]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A2, -- ᢢ
 },
 [0x18A3]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI CYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A3, -- ᢣ
 },
 [0x18A4]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI ZHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A4, -- ᢤ
 },
 [0x18A5]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI ZA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A5, -- ᢥ
 },
 [0x18A6]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI HALF U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A6, -- ᢦ
 },
 [0x18A7]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER ALI GALI HALF YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A7, -- ᢧ
 },
 [0x18A8]={
  ["category"]="lo",
  ["description"]="MONGOLIAN LETTER MANCHU ALI GALI BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x18A8, -- ᢨ
 },
 [0x18A9]={
  ["category"]="mn",
  ["description"]="MONGOLIAN LETTER ALI GALI DAGALGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x18A9, -- ᢩ
 },
 [0x1900]={
  ["category"]="lo",
  ["description"]="LIMBU VOWEL-CARRIER LETTER",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1900, -- ᤀ
 },
 [0x1901]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1901, -- ᤁ
 },
 [0x1902]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER KHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1902, -- ᤂ
 },
 [0x1903]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1903, -- ᤃ
 },
 [0x1904]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER GHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1904, -- ᤄ
 },
 [0x1905]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1905, -- ᤅ
 },
 [0x1906]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1906, -- ᤆ
 },
 [0x1907]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER CHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1907, -- ᤇ
 },
 [0x1908]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1908, -- ᤈ
 },
 [0x1909]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER JHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1909, -- ᤉ
 },
 [0x190A]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER YAN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x190A, -- ᤊ
 },
 [0x190B]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x190B, -- ᤋ
 },
 [0x190C]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER THA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x190C, -- ᤌ
 },
 [0x190D]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x190D, -- ᤍ
 },
 [0x190E]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER DHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x190E, -- ᤎ
 },
 [0x190F]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x190F, -- ᤏ
 },
 [0x1910]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1910, -- ᤐ
 },
 [0x1911]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER PHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1911, -- ᤑ
 },
 [0x1912]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1912, -- ᤒ
 },
 [0x1913]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER BHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1913, -- ᤓ
 },
 [0x1914]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1914, -- ᤔ
 },
 [0x1915]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1915, -- ᤕ
 },
 [0x1916]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1916, -- ᤖ
 },
 [0x1917]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1917, -- ᤗ
 },
 [0x1918]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1918, -- ᤘ
 },
 [0x1919]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER SHA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1919, -- ᤙ
 },
 [0x191A]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER SSA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x191A, -- ᤚ
 },
 [0x191B]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x191B, -- ᤛ
 },
 [0x191C]={
  ["category"]="lo",
  ["description"]="LIMBU LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x191C, -- ᤜ
 },
 [0x1920]={
  ["category"]="mn",
  ["description"]="LIMBU VOWEL SIGN A",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1920, -- ᤠ
 },
 [0x1921]={
  ["category"]="mn",
  ["description"]="LIMBU VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1921, -- ᤡ
 },
 [0x1922]={
  ["category"]="mn",
  ["description"]="LIMBU VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1922, -- ᤢ
 },
 [0x1923]={
  ["category"]="mc",
  ["description"]="LIMBU VOWEL SIGN EE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1923, -- ᤣ
 },
 [0x1924]={
  ["category"]="mc",
  ["description"]="LIMBU VOWEL SIGN AI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1924, -- ᤤ
 },
 [0x1925]={
  ["category"]="mc",
  ["description"]="LIMBU VOWEL SIGN OO",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1925, -- ᤥ
 },
 [0x1926]={
  ["category"]="mc",
  ["description"]="LIMBU VOWEL SIGN AU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1926, -- ᤦ
 },
 [0x1927]={
  ["category"]="mn",
  ["description"]="LIMBU VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1927, -- ᤧ
 },
 [0x1928]={
  ["category"]="mn",
  ["description"]="LIMBU VOWEL SIGN O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1928, -- ᤨ
 },
 [0x1929]={
  ["category"]="mc",
  ["description"]="LIMBU SUBJOINED LETTER YA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1929, -- ᤩ
 },
 [0x192A]={
  ["category"]="mc",
  ["description"]="LIMBU SUBJOINED LETTER RA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x192A, -- ᤪ
 },
 [0x192B]={
  ["category"]="mc",
  ["description"]="LIMBU SUBJOINED LETTER WA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x192B, -- ᤫ
 },
 [0x1930]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER KA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1930, -- ᤰ
 },
 [0x1931]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER NGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1931, -- ᤱ
 },
 [0x1932]={
  ["category"]="mn",
  ["description"]="LIMBU SMALL LETTER ANUSVARA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1932, -- ᤲ
 },
 [0x1933]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER TA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1933, -- ᤳ
 },
 [0x1934]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER NA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1934, -- ᤴ
 },
 [0x1935]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER PA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1935, -- ᤵ
 },
 [0x1936]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER MA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1936, -- ᤶ
 },
 [0x1937]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER RA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1937, -- ᤷ
 },
 [0x1938]={
  ["category"]="mc",
  ["description"]="LIMBU SMALL LETTER LA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1938, -- ᤸ
 },
 [0x1939]={
  ["category"]="mn",
  ["description"]="LIMBU SIGN MUKPHRENG",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1939, -- ᤹
 },
 [0x193A]={
  ["category"]="mn",
  ["description"]="LIMBU SIGN KEMPHRENG",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x193A, -- ᤺
 },
 [0x193B]={
  ["category"]="mn",
  ["description"]="LIMBU SIGN SA-I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x193B, -- ᤻
 },
 [0x1940]={
  ["category"]="so",
  ["description"]="LIMBU SIGN LOO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1940, -- ᥀
 },
 [0x1944]={
  ["category"]="po",
  ["description"]="LIMBU EXCLAMATION MARK",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x1944, -- ᥄
 },
 [0x1945]={
  ["category"]="po",
  ["description"]="LIMBU QUESTION MARK",
  ["linebreak"]="ex",
  ["unicodeslot"]=0x1945, -- ᥅
 },
 [0x1946]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1946, -- ᥆
 },
 [0x1947]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1947, -- ᥇
 },
 [0x1948]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1948, -- ᥈
 },
 [0x1949]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1949, -- ᥉
 },
 [0x194A]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x194A, -- ᥊
 },
 [0x194B]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x194B, -- ᥋
 },
 [0x194C]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x194C, -- ᥌
 },
 [0x194D]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x194D, -- ᥍
 },
 [0x194E]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x194E, -- ᥎
 },
 [0x194F]={
  ["category"]="nd",
  ["description"]="LIMBU DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x194F, -- ᥏
 },
 [0x1950]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER KA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1950, -- ᥐ
 },
 [0x1951]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER XA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1951, -- ᥑ
 },
 [0x1952]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER NGA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1952, -- ᥒ
 },
 [0x1953]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TSA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1953, -- ᥓ
 },
 [0x1954]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER SA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1954, -- ᥔ
 },
 [0x1955]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER YA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1955, -- ᥕ
 },
 [0x1956]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1956, -- ᥖ
 },
 [0x1957]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER THA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1957, -- ᥗ
 },
 [0x1958]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER LA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1958, -- ᥘ
 },
 [0x1959]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER PA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1959, -- ᥙ
 },
 [0x195A]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER PHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x195A, -- ᥚ
 },
 [0x195B]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER MA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x195B, -- ᥛ
 },
 [0x195C]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER FA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x195C, -- ᥜ
 },
 [0x195D]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER VA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x195D, -- ᥝ
 },
 [0x195E]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER HA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x195E, -- ᥞ
 },
 [0x195F]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER QA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x195F, -- ᥟ
 },
 [0x1960]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER KHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1960, -- ᥠ
 },
 [0x1961]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TSHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1961, -- ᥡ
 },
 [0x1962]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER NA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1962, -- ᥢ
 },
 [0x1963]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER A",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1963, -- ᥣ
 },
 [0x1964]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER I",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1964, -- ᥤ
 },
 [0x1965]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER EE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1965, -- ᥥ
 },
 [0x1966]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER EH",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1966, -- ᥦ
 },
 [0x1967]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER U",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1967, -- ᥧ
 },
 [0x1968]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER OO",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1968, -- ᥨ
 },
 [0x1969]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER O",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1969, -- ᥩ
 },
 [0x196A]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER UE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x196A, -- ᥪ
 },
 [0x196B]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER E",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x196B, -- ᥫ
 },
 [0x196C]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER AUE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x196C, -- ᥬ
 },
 [0x196D]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER AI",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x196D, -- ᥭ
 },
 [0x1970]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TONE-0x0002",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1970, -- ᥰ
 },
 [0x1971]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TONE-0x0003",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1971, -- ᥱ
 },
 [0x1972]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TONE-0x0004",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1972, -- ᥲ
 },
 [0x1973]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TONE-0x0005",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1973, -- ᥳ
 },
 [0x1974]={
  ["category"]="lo",
  ["description"]="TAI LE LETTER TONE-0x0006",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1974, -- ᥴ
 },
 [0x1980]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH QA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1980, -- ᦀ
 },
 [0x1981]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW QA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1981, -- ᦁ
 },
 [0x1982]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH KA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1982, -- ᦂ
 },
 [0x1983]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH XA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1983, -- ᦃ
 },
 [0x1984]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH NGA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1984, -- ᦄ
 },
 [0x1985]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW KA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1985, -- ᦅ
 },
 [0x1986]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW XA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1986, -- ᦆ
 },
 [0x1987]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW NGA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1987, -- ᦇ
 },
 [0x1988]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH TSA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1988, -- ᦈ
 },
 [0x1989]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH SA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1989, -- ᦉ
 },
 [0x198A]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH YA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x198A, -- ᦊ
 },
 [0x198B]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW TSA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x198B, -- ᦋ
 },
 [0x198C]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW SA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x198C, -- ᦌ
 },
 [0x198D]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW YA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x198D, -- ᦍ
 },
 [0x198E]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH TA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x198E, -- ᦎ
 },
 [0x198F]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH THA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x198F, -- ᦏ
 },
 [0x1990]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH NA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1990, -- ᦐ
 },
 [0x1991]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW TA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1991, -- ᦑ
 },
 [0x1992]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW THA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1992, -- ᦒ
 },
 [0x1993]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW NA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1993, -- ᦓ
 },
 [0x1994]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH PA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1994, -- ᦔ
 },
 [0x1995]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH PHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1995, -- ᦕ
 },
 [0x1996]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH MA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1996, -- ᦖ
 },
 [0x1997]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW PA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1997, -- ᦗ
 },
 [0x1998]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW PHA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1998, -- ᦘ
 },
 [0x1999]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW MA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x1999, -- ᦙ
 },
 [0x199A]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH FA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x199A, -- ᦚ
 },
 [0x199B]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH VA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x199B, -- ᦛ
 },
 [0x199C]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH LA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x199C, -- ᦜ
 },
 [0x199D]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW FA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x199D, -- ᦝ
 },
 [0x199E]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW VA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x199E, -- ᦞ
 },
 [0x199F]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW LA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x199F, -- ᦟ
 },
 [0x19A0]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH HA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A0, -- ᦠ
 },
 [0x19A1]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH DA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A1, -- ᦡ
 },
 [0x19A2]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH BA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A2, -- ᦢ
 },
 [0x19A3]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW HA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A3, -- ᦣ
 },
 [0x19A4]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW DA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A4, -- ᦤ
 },
 [0x19A5]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW BA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A5, -- ᦥ
 },
 [0x19A6]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH KVA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A6, -- ᦦ
 },
 [0x19A7]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER HIGH XVA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A7, -- ᦧ
 },
 [0x19A8]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW KVA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A8, -- ᦨ
 },
 [0x19A9]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER LOW XVA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19A9, -- ᦩ
 },
 [0x19B0]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN VOWEL SHORTENER",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B0, -- ᦰ
 },
 [0x19B1]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN AA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B1, -- ᦱ
 },
 [0x19B2]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN II",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B2, -- ᦲ
 },
 [0x19B3]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN U",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B3, -- ᦳ
 },
 [0x19B4]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN UU",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B4, -- ᦴ
 },
 [0x19B5]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN E",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B5, -- ᦵ
 },
 [0x19B6]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN AE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B6, -- ᦶ
 },
 [0x19B7]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN O",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B7, -- ᦷ
 },
 [0x19B8]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN OA",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B8, -- ᦸ
 },
 [0x19B9]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN UE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19B9, -- ᦹ
 },
 [0x19BA]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN AY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19BA, -- ᦺ
 },
 [0x19BB]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN AAY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19BB, -- ᦻ
 },
 [0x19BC]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN UY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19BC, -- ᦼ
 },
 [0x19BD]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN OY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19BD, -- ᦽ
 },
 [0x19BE]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN OAY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19BE, -- ᦾ
 },
 [0x19BF]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN UEY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19BF, -- ᦿ
 },
 [0x19C0]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE VOWEL SIGN IY",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C0, -- ᧀ
 },
 [0x19C1]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER FINAL V",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C1, -- ᧁ
 },
 [0x19C2]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER FINAL NG",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C2, -- ᧂ
 },
 [0x19C3]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER FINAL N",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C3, -- ᧃ
 },
 [0x19C4]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER FINAL M",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C4, -- ᧄ
 },
 [0x19C5]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER FINAL K",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C5, -- ᧅ
 },
 [0x19C6]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER FINAL D",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C6, -- ᧆ
 },
 [0x19C7]={
  ["category"]="lo",
  ["description"]="NEW TAI LUE LETTER FINAL B",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C7, -- ᧇ
 },
 [0x19C8]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE TONE MARK-0x0001",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C8, -- ᧈ
 },
 [0x19C9]={
  ["category"]="mc",
  ["description"]="NEW TAI LUE TONE MARK-0x0002",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19C9, -- ᧉ
 },
 [0x19D0]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D0, -- ᧐
 },
 [0x19D1]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D1, -- ᧑
 },
 [0x19D2]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D2, -- ᧒
 },
 [0x19D3]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D3, -- ᧓
 },
 [0x19D4]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D4, -- ᧔
 },
 [0x19D5]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D5, -- ᧕
 },
 [0x19D6]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D6, -- ᧖
 },
 [0x19D7]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D7, -- ᧗
 },
 [0x19D8]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D8, -- ᧘
 },
 [0x19D9]={
  ["category"]="nd",
  ["description"]="NEW TAI LUE DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x19D9, -- ᧙
 },
 [0x19DE]={
  ["category"]="po",
  ["description"]="NEW TAI LUE SIGN LAE",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19DE, -- ᧞
 },
 [0x19DF]={
  ["category"]="po",
  ["description"]="NEW TAI LUE SIGN LAEV",
  ["linebreak"]="sa",
  ["unicodeslot"]=0x19DF, -- ᧟
 },
 [0x19E0]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PATHAMASAT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E0, -- ᧠
 },
 [0x19E1]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL MUOY KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E1, -- ᧡
 },
 [0x19E2]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PII KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E2, -- ᧢
 },
 [0x19E3]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL BEI KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E3, -- ᧣
 },
 [0x19E4]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL BUON KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E4, -- ᧤
 },
 [0x19E5]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E5, -- ᧥
 },
 [0x19E6]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-MUOY KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E6, -- ᧦
 },
 [0x19E7]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-PII KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E7, -- ᧧
 },
 [0x19E8]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-BEI KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E8, -- ᧨
 },
 [0x19E9]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-BUON KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19E9, -- ᧩
 },
 [0x19EA]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19EA, -- ᧪
 },
 [0x19EB]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-MUOY KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19EB, -- ᧫
 },
 [0x19EC]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-PII KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19EC, -- ᧬
 },
 [0x19ED]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-BEI KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19ED, -- ᧭
 },
 [0x19EE]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-BUON KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19EE, -- ᧮
 },
 [0x19EF]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-PRAM KOET",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19EF, -- ᧯
 },
 [0x19F0]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL TUTEYASAT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F0, -- ᧰
 },
 [0x19F1]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL MUOY ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F1, -- ᧱
 },
 [0x19F2]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PII ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F2, -- ᧲
 },
 [0x19F3]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL BEI ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F3, -- ᧳
 },
 [0x19F4]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL BUON ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F4, -- ᧴
 },
 [0x19F5]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F5, -- ᧵
 },
 [0x19F6]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-MUOY ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F6, -- ᧶
 },
 [0x19F7]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-PII ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F7, -- ᧷
 },
 [0x19F8]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-BEI ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F8, -- ᧸
 },
 [0x19F9]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL PRAM-BUON ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19F9, -- ᧹
 },
 [0x19FA]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19FA, -- ᧺
 },
 [0x19FB]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-MUOY ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19FB, -- ᧻
 },
 [0x19FC]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-PII ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19FC, -- ᧼
 },
 [0x19FD]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-BEI ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19FD, -- ᧽
 },
 [0x19FE]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-BUON ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19FE, -- ᧾
 },
 [0x19FF]={
  ["category"]="so",
  ["description"]="KHMER SYMBOL DAP-PRAM ROC",
  ["linebreak"]="al",
  ["unicodeslot"]=0x19FF, -- ᧿
 },
 [0x1A00]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A00, -- ᨀ
 },
 [0x1A01]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A01, -- ᨁ
 },
 [0x1A02]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A02, -- ᨂ
 },
 [0x1A03]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER NGKA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A03, -- ᨃ
 },
 [0x1A04]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A04, -- ᨄ
 },
 [0x1A05]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A05, -- ᨅ
 },
 [0x1A06]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A06, -- ᨆ
 },
 [0x1A07]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER MPA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A07, -- ᨇ
 },
 [0x1A08]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A08, -- ᨈ
 },
 [0x1A09]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A09, -- ᨉ
 },
 [0x1A0A]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A0A, -- ᨊ
 },
 [0x1A0B]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER NRA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A0B, -- ᨋ
 },
 [0x1A0C]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A0C, -- ᨌ
 },
 [0x1A0D]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A0D, -- ᨍ
 },
 [0x1A0E]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A0E, -- ᨎ
 },
 [0x1A0F]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER NYCA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A0F, -- ᨏ
 },
 [0x1A10]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A10, -- ᨐ
 },
 [0x1A11]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A11, -- ᨑ
 },
 [0x1A12]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A12, -- ᨒ
 },
 [0x1A13]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER VA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A13, -- ᨓ
 },
 [0x1A14]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A14, -- ᨔ
 },
 [0x1A15]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A15, -- ᨕ
 },
 [0x1A16]={
  ["category"]="lo",
  ["description"]="BUGINESE LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A16, -- ᨖ
 },
 [0x1A17]={
  ["category"]="mn",
  ["description"]="BUGINESE VOWEL SIGN I",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1A17, -- ᨗ
 },
 [0x1A18]={
  ["category"]="mn",
  ["description"]="BUGINESE VOWEL SIGN U",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1A18, -- ᨘ
 },
 [0x1A19]={
  ["category"]="mc",
  ["description"]="BUGINESE VOWEL SIGN E",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1A19, -- ᨙ
 },
 [0x1A1A]={
  ["category"]="mc",
  ["description"]="BUGINESE VOWEL SIGN O",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1A1A, -- ᨚ
 },
 [0x1A1B]={
  ["category"]="mc",
  ["description"]="BUGINESE VOWEL SIGN AE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1A1B, -- ᨛ
 },
 [0x1A1E]={
  ["category"]="po",
  ["description"]="BUGINESE PALLAWA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1A1E, -- ᨞
 },
 [0x1A1F]={
  ["category"]="po",
  ["description"]="BUGINESE END OF SECTION",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1A1F, -- ᨟
 },
 [0x1B00]={
  ["category"]="mn",
  ["description"]="BALINESE SIGN ULU RICEM",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B00, -- ᬀ
 },
 [0x1B01]={
  ["category"]="mn",
  ["description"]="BALINESE SIGN ULU CANDRA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B01, -- ᬁ
 },
 [0x1B02]={
  ["category"]="mn",
  ["description"]="BALINESE SIGN CECEK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B02, -- ᬂ
 },
 [0x1B03]={
  ["category"]="mn",
  ["description"]="BALINESE SIGN SURANG",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B03, -- ᬃ
 },
 [0x1B04]={
  ["category"]="mc",
  ["description"]="BALINESE SIGN BISAH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B04, -- ᬄ
 },
 [0x1B05]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER AKARA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B05, -- ᬅ
 },
 [0x1B06]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER AKARA TEDUNG",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1B05, 0x1B35 },
  ["unicodeslot"]=0x1B06, -- ᬆ
 },
 [0x1B07]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER IKARA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B07, -- ᬇ
 },
 [0x1B08]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER IKARA TEDUNG",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1B07, 0x1B35 },
  ["unicodeslot"]=0x1B08, -- ᬈ
 },
 [0x1B09]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER UKARA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B09, -- ᬉ
 },
 [0x1B0A]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER UKARA TEDUNG",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1B09, 0x1B35 },
  ["unicodeslot"]=0x1B0A, -- ᬊ
 },
 [0x1B0B]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER RA REPA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B0B, -- ᬋ
 },
 [0x1B0C]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER RA REPA TEDUNG",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1B0B, 0x1B35 },
  ["unicodeslot"]=0x1B0C, -- ᬌ
 },
 [0x1B0D]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER LA LENGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B0D, -- ᬍ
 },
 [0x1B0E]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER LA LENGA TEDUNG",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1B0D, 0x1B35 },
  ["unicodeslot"]=0x1B0E, -- ᬎ
 },
 [0x1B0F]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER EKARA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B0F, -- ᬏ
 },
 [0x1B10]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER AIKARA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B10, -- ᬐ
 },
 [0x1B11]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER OKARA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B11, -- ᬑ
 },
 [0x1B12]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER OKARA TEDUNG",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1B11, 0x1B35 },
  ["unicodeslot"]=0x1B12, -- ᬒ
 },
 [0x1B13]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER KA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B13, -- ᬓ
 },
 [0x1B14]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER KA MAHAPRANA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B14, -- ᬔ
 },
 [0x1B15]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER GA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B15, -- ᬕ
 },
 [0x1B16]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER GA GORA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B16, -- ᬖ
 },
 [0x1B17]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER NGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B17, -- ᬗ
 },
 [0x1B18]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER CA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B18, -- ᬘ
 },
 [0x1B19]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER CA LACA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B19, -- ᬙ
 },
 [0x1B1A]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER JA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B1A, -- ᬚ
 },
 [0x1B1B]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER JA JERA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B1B, -- ᬛ
 },
 [0x1B1C]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER NYA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B1C, -- ᬜ
 },
 [0x1B1D]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER TA LATIK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B1D, -- ᬝ
 },
 [0x1B1E]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER TA MURDA MAHAPRANA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B1E, -- ᬞ
 },
 [0x1B1F]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER DA MURDA ALPAPRANA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B1F, -- ᬟ
 },
 [0x1B20]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER DA MURDA MAHAPRANA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B20, -- ᬠ
 },
 [0x1B21]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER NA RAMBAT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B21, -- ᬡ
 },
 [0x1B22]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER TA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B22, -- ᬢ
 },
 [0x1B23]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER TA TAWA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B23, -- ᬣ
 },
 [0x1B24]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER DA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B24, -- ᬤ
 },
 [0x1B25]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER DA MADU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B25, -- ᬥ
 },
 [0x1B26]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER NA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B26, -- ᬦ
 },
 [0x1B27]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER PA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B27, -- ᬧ
 },
 [0x1B28]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER PA KAPAL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B28, -- ᬨ
 },
 [0x1B29]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER BA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B29, -- ᬩ
 },
 [0x1B2A]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER BA KEMBANG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B2A, -- ᬪ
 },
 [0x1B2B]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER MA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B2B, -- ᬫ
 },
 [0x1B2C]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER YA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B2C, -- ᬬ
 },
 [0x1B2D]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER RA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B2D, -- ᬭ
 },
 [0x1B2E]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER LA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B2E, -- ᬮ
 },
 [0x1B2F]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER WA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B2F, -- ᬯ
 },
 [0x1B30]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER SA SAGA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B30, -- ᬰ
 },
 [0x1B31]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER SA SAPA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B31, -- ᬱ
 },
 [0x1B32]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER SA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B32, -- ᬲ
 },
 [0x1B33]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER HA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B33, -- ᬳ
 },
 [0x1B34]={
  ["category"]="mn",
  ["description"]="BALINESE SIGN REREKAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B34, -- ᬴
 },
 [0x1B35]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN TEDUNG",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B35, -- ᬵ
 },
 [0x1B36]={
  ["category"]="mn",
  ["description"]="BALINESE VOWEL SIGN ULU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B36, -- ᬶ
 },
 [0x1B37]={
  ["category"]="mn",
  ["description"]="BALINESE VOWEL SIGN ULU SARI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B37, -- ᬷ
 },
 [0x1B38]={
  ["category"]="mn",
  ["description"]="BALINESE VOWEL SIGN SUKU",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B38, -- ᬸ
 },
 [0x1B39]={
  ["category"]="mn",
  ["description"]="BALINESE VOWEL SIGN SUKU ILUT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B39, -- ᬹ
 },
 [0x1B3A]={
  ["category"]="mn",
  ["description"]="BALINESE VOWEL SIGN RA REPA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B3A, -- ᬺ
 },
 [0x1B3B]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN RA REPA TEDUNG",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x1B3A, 0x1B35 },
  ["unicodeslot"]=0x1B3B, -- ᬻ
 },
 [0x1B3C]={
  ["category"]="mn",
  ["description"]="BALINESE VOWEL SIGN LA LENGA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B3C, -- ᬼ
 },
 [0x1B3D]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN LA LENGA TEDUNG",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x1B3C, 0x1B35 },
  ["unicodeslot"]=0x1B3D, -- ᬽ
 },
 [0x1B3E]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN TALING",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B3E, -- ᬾ
 },
 [0x1B3F]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN TALING REPA",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B3F, -- ᬿ
 },
 [0x1B40]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN TALING TEDUNG",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x1B3E, 0x1B35 },
  ["unicodeslot"]=0x1B40, -- ᭀ
 },
 [0x1B41]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN TALING REPA TEDUNG",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x1B3F, 0x1B35 },
  ["unicodeslot"]=0x1B41, -- ᭁ
 },
 [0x1B42]={
  ["category"]="mn",
  ["description"]="BALINESE VOWEL SIGN PEPET",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B42, -- ᭂ
 },
 [0x1B43]={
  ["category"]="mc",
  ["description"]="BALINESE VOWEL SIGN PEPET TEDUNG",
  ["linebreak"]="cm",
  ["specials"]={ "char", 0x1B42, 0x1B35 },
  ["unicodeslot"]=0x1B43, -- ᭃ
 },
 [0x1B44]={
  ["category"]="mc",
  ["description"]="BALINESE ADEG ADEG",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B44, -- ᭄
 },
 [0x1B45]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER KAF SASAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B45, -- ᭅ
 },
 [0x1B46]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER KHOT SASAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B46, -- ᭆ
 },
 [0x1B47]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER TZIR SASAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B47, -- ᭇ
 },
 [0x1B48]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER EF SASAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B48, -- ᭈ
 },
 [0x1B49]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER VE SASAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B49, -- ᭉ
 },
 [0x1B4A]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER ZAL SASAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B4A, -- ᭊ
 },
 [0x1B4B]={
  ["category"]="lo",
  ["description"]="BALINESE LETTER ASYURA SASAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B4B, -- ᭋ
 },
 [0x1B50]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT ZERO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B50, -- ᭐
 },
 [0x1B51]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT ONE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B51, -- ᭑
 },
 [0x1B52]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT TWO",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B52, -- ᭒
 },
 [0x1B53]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT THREE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B53, -- ᭓
 },
 [0x1B54]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT FOUR",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B54, -- ᭔
 },
 [0x1B55]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT FIVE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B55, -- ᭕
 },
 [0x1B56]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT SIX",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B56, -- ᭖
 },
 [0x1B57]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT SEVEN",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B57, -- ᭗
 },
 [0x1B58]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT EIGHT",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B58, -- ᭘
 },
 [0x1B59]={
  ["category"]="nd",
  ["description"]="BALINESE DIGIT NINE",
  ["linebreak"]="nu",
  ["unicodeslot"]=0x1B59, -- ᭙
 },
 [0x1B5A]={
  ["category"]="po",
  ["description"]="BALINESE PANTI",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1B5A, -- ᭚
 },
 [0x1B5B]={
  ["category"]="po",
  ["description"]="BALINESE PAMADA",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1B5B, -- ᭛
 },
 [0x1B5C]={
  ["category"]="po",
  ["description"]="BALINESE WINDU",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1B5C, -- ᭜
 },
 [0x1B5D]={
  ["category"]="po",
  ["description"]="BALINESE CARIK PAMUNGKAH",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1B5D, -- ᭝
 },
 [0x1B5E]={
  ["category"]="po",
  ["description"]="BALINESE CARIK SIKI",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1B5E, -- ᭞
 },
 [0x1B5F]={
  ["category"]="po",
  ["description"]="BALINESE CARIK PAREREN",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1B5F, -- ᭟
 },
 [0x1B60]={
  ["category"]="po",
  ["description"]="BALINESE PAMENENG",
  ["linebreak"]="ba",
  ["unicodeslot"]=0x1B60, -- ᭠
 },
 [0x1B61]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DONG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B61, -- ᭡
 },
 [0x1B62]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DENG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B62, -- ᭢
 },
 [0x1B63]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DUNG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B63, -- ᭣
 },
 [0x1B64]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DANG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B64, -- ᭤
 },
 [0x1B65]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DANG SURANG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B65, -- ᭥
 },
 [0x1B66]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B66, -- ᭦
 },
 [0x1B67]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DAENG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B67, -- ᭧
 },
 [0x1B68]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DEUNG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B68, -- ᭨
 },
 [0x1B69]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DAING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B69, -- ᭩
 },
 [0x1B6A]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL DANG GEDE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B6A, -- ᭪
 },
 [0x1B6B]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING TEGEH",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B6B, -- ᭫
 },
 [0x1B6C]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING ENDEP",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B6C, -- ᭬
 },
 [0x1B6D]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING KEMPUL",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B6D, -- ᭭
 },
 [0x1B6E]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING KEMPLI",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B6E, -- ᭮
 },
 [0x1B6F]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING JEGOGAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B6F, -- ᭯
 },
 [0x1B70]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B70, -- ᭰
 },
 [0x1B71]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B71, -- ᭱
 },
 [0x1B72]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING BENDE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B72, -- ᭲
 },
 [0x1B73]={
  ["category"]="mn",
  ["description"]="BALINESE MUSICAL SYMBOL COMBINING GONG",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1B73, -- ᭳
 },
 [0x1B74]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B74, -- ᭴
 },
 [0x1B75]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B75, -- ᭵
 },
 [0x1B76]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B76, -- ᭶
 },
 [0x1B77]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B77, -- ᭷
 },
 [0x1B78]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B78, -- ᭸
 },
 [0x1B79]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B79, -- ᭹
 },
 [0x1B7A]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B7A, -- ᭺
 },
 [0x1B7B]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B7B, -- ᭻
 },
 [0x1B7C]={
  ["category"]="so",
  ["description"]="BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1B7C, -- ᭼
 },
 [0x1D00]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL A",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D00, -- ᴀ
 },
 [0x1D01]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL AE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D01, -- ᴁ
 },
 [0x1D02]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED AE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D02, -- ᴂ
 },
 [0x1D03]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL BARRED B",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D03, -- ᴃ
 },
 [0x1D04]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL C",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D04, -- ᴄ
 },
 [0x1D05]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL D",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D05, -- ᴅ
 },
 [0x1D06]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL ETH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D06, -- ᴆ
 },
 [0x1D07]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D07, -- ᴇ
 },
 [0x1D08]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED OPEN E",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D08, -- ᴈ
 },
 [0x1D09]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D09, -- ᴉ
 },
 [0x1D0A]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL J",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D0A, -- ᴊ
 },
 [0x1D0B]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL K",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D0B, -- ᴋ
 },
 [0x1D0C]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL L WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D0C, -- ᴌ
 },
 [0x1D0D]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D0D, -- ᴍ
 },
 [0x1D0E]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL REVERSED N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D0E, -- ᴎ
 },
 [0x1D0F]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D0F, -- ᴏ
 },
 [0x1D10]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL OPEN O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D10, -- ᴐ
 },
 [0x1D11]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SIDEWAYS O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D11, -- ᴑ
 },
 [0x1D12]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SIDEWAYS OPEN O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D12, -- ᴒ
 },
 [0x1D13]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SIDEWAYS O WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D13, -- ᴓ
 },
 [0x1D14]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED OE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D14, -- ᴔ
 },
 [0x1D15]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL OU",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D15, -- ᴕ
 },
 [0x1D16]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TOP HALF O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D16, -- ᴖ
 },
 [0x1D17]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER BOTTOM HALF O",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D17, -- ᴗ
 },
 [0x1D18]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL P",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D18, -- ᴘ
 },
 [0x1D19]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL REVERSED R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D19, -- ᴙ
 },
 [0x1D1A]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL TURNED R",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D1A, -- ᴚ
 },
 [0x1D1B]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL T",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D1B, -- ᴛ
 },
 [0x1D1C]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D1C, -- ᴜ
 },
 [0x1D1D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SIDEWAYS U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D1D, -- ᴝ
 },
 [0x1D1E]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SIDEWAYS DIAERESIZED U",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D1E, -- ᴞ
 },
 [0x1D1F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SIDEWAYS TURNED M",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D1F, -- ᴟ
 },
 [0x1D20]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL V",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D20, -- ᴠ
 },
 [0x1D21]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL W",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D21, -- ᴡ
 },
 [0x1D22]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL Z",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D22, -- ᴢ
 },
 [0x1D23]={
  ["category"]="ll",
  ["description"]="LATIN LETTER SMALL CAPITAL EZH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D23, -- ᴣ
 },
 [0x1D24]={
  ["category"]="ll",
  ["description"]="LATIN LETTER VOICED LARYNGEAL SPIRANT",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D24, -- ᴤ
 },
 [0x1D25]={
  ["category"]="ll",
  ["description"]="LATIN LETTER AIN",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D25, -- ᴥ
 },
 [0x1D26]={
  ["category"]="ll",
  ["description"]="GREEK LETTER SMALL CAPITAL GAMMA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D26, -- ᴦ
 },
 [0x1D27]={
  ["category"]="ll",
  ["description"]="GREEK LETTER SMALL CAPITAL LAMDA",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D27, -- ᴧ
 },
 [0x1D28]={
  ["category"]="ll",
  ["description"]="GREEK LETTER SMALL CAPITAL PI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D28, -- ᴨ
 },
 [0x1D29]={
  ["category"]="ll",
  ["description"]="GREEK LETTER SMALL CAPITAL RHO",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D29, -- ᴩ
 },
 [0x1D2A]={
  ["category"]="ll",
  ["description"]="GREEK LETTER SMALL CAPITAL PSI",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D2A, -- ᴪ
 },
 [0x1D2B]={
  ["category"]="ll",
  ["description"]="CYRILLIC LETTER SMALL CAPITAL EL",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D2B, -- ᴫ
 },
 [0x1D2C]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL A",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0041 },
  ["unicodeslot"]=0x1D2C, -- ᴬ
 },
 [0x1D2D]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL AE",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x00C6 },
  ["unicodeslot"]=0x1D2D, -- ᴭ
 },
 [0x1D2E]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL B",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0042 },
  ["unicodeslot"]=0x1D2E, -- ᴮ
 },
 [0x1D2F]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL BARRED B",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D2F, -- ᴯ
 },
 [0x1D30]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL D",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0044 },
  ["unicodeslot"]=0x1D30, -- ᴰ
 },
 [0x1D31]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL E",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0045 },
  ["unicodeslot"]=0x1D31, -- ᴱ
 },
 [0x1D32]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL REVERSED E",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x018E },
  ["unicodeslot"]=0x1D32, -- ᴲ
 },
 [0x1D33]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL G",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0047 },
  ["unicodeslot"]=0x1D33, -- ᴳ
 },
 [0x1D34]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL H",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0048 },
  ["unicodeslot"]=0x1D34, -- ᴴ
 },
 [0x1D35]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL I",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0049 },
  ["unicodeslot"]=0x1D35, -- ᴵ
 },
 [0x1D36]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL J",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x004A },
  ["unicodeslot"]=0x1D36, -- ᴶ
 },
 [0x1D37]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL K",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x004B },
  ["unicodeslot"]=0x1D37, -- ᴷ
 },
 [0x1D38]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL L",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x004C },
  ["unicodeslot"]=0x1D38, -- ᴸ
 },
 [0x1D39]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL M",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x004D },
  ["unicodeslot"]=0x1D39, -- ᴹ
 },
 [0x1D3A]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL N",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x004E },
  ["unicodeslot"]=0x1D3A, -- ᴺ
 },
 [0x1D3B]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL REVERSED N",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D3B, -- ᴻ
 },
 [0x1D3C]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL O",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x004F },
  ["unicodeslot"]=0x1D3C, -- ᴼ
 },
 [0x1D3D]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL OU",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0222 },
  ["unicodeslot"]=0x1D3D, -- ᴽ
 },
 [0x1D3E]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL P",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0050 },
  ["unicodeslot"]=0x1D3E, -- ᴾ
 },
 [0x1D3F]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL R",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0052 },
  ["unicodeslot"]=0x1D3F, -- ᴿ
 },
 [0x1D40]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL T",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0054 },
  ["unicodeslot"]=0x1D40, -- ᵀ
 },
 [0x1D41]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL U",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0055 },
  ["unicodeslot"]=0x1D41, -- ᵁ
 },
 [0x1D42]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CAPITAL W",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0057 },
  ["unicodeslot"]=0x1D42, -- ᵂ
 },
 [0x1D43]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL A",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0061 },
  ["unicodeslot"]=0x1D43, -- ᵃ
 },
 [0x1D44]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED A",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0250 },
  ["unicodeslot"]=0x1D44, -- ᵄ
 },
 [0x1D45]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL ALPHA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0251 },
  ["unicodeslot"]=0x1D45, -- ᵅ
 },
 [0x1D46]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED AE",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D02 },
  ["unicodeslot"]=0x1D46, -- ᵆ
 },
 [0x1D47]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL B",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0062 },
  ["unicodeslot"]=0x1D47, -- ᵇ
 },
 [0x1D48]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL D",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0064 },
  ["unicodeslot"]=0x1D48, -- ᵈ
 },
 [0x1D49]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL E",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0065 },
  ["unicodeslot"]=0x1D49, -- ᵉ
 },
 [0x1D4A]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL SCHWA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0259 },
  ["unicodeslot"]=0x1D4A, -- ᵊ
 },
 [0x1D4B]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL OPEN E",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x025B },
  ["unicodeslot"]=0x1D4B, -- ᵋ
 },
 [0x1D4C]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED OPEN E",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x025C },
  ["unicodeslot"]=0x1D4C, -- ᵌ
 },
 [0x1D4D]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL G",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0067 },
  ["unicodeslot"]=0x1D4D, -- ᵍ
 },
 [0x1D4E]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED I",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D4E, -- ᵎ
 },
 [0x1D4F]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL K",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x006B },
  ["unicodeslot"]=0x1D4F, -- ᵏ
 },
 [0x1D50]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL M",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x006D },
  ["unicodeslot"]=0x1D50, -- ᵐ
 },
 [0x1D51]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL ENG",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x014B },
  ["unicodeslot"]=0x1D51, -- ᵑ
 },
 [0x1D52]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL O",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x006F },
  ["unicodeslot"]=0x1D52, -- ᵒ
 },
 [0x1D53]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL OPEN O",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0254 },
  ["unicodeslot"]=0x1D53, -- ᵓ
 },
 [0x1D54]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TOP HALF O",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D16 },
  ["unicodeslot"]=0x1D54, -- ᵔ
 },
 [0x1D55]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL BOTTOM HALF O",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D17 },
  ["unicodeslot"]=0x1D55, -- ᵕ
 },
 [0x1D56]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL P",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0070 },
  ["unicodeslot"]=0x1D56, -- ᵖ
 },
 [0x1D57]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL T",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0074 },
  ["unicodeslot"]=0x1D57, -- ᵗ
 },
 [0x1D58]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL U",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0075 },
  ["unicodeslot"]=0x1D58, -- ᵘ
 },
 [0x1D59]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL SIDEWAYS U",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D1D },
  ["unicodeslot"]=0x1D59, -- ᵙ
 },
 [0x1D5A]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED M",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x026F },
  ["unicodeslot"]=0x1D5A, -- ᵚ
 },
 [0x1D5B]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL V",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0076 },
  ["unicodeslot"]=0x1D5B, -- ᵛ
 },
 [0x1D5C]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL AIN",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D25 },
  ["unicodeslot"]=0x1D5C, -- ᵜ
 },
 [0x1D5D]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL BETA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x03B2 },
  ["unicodeslot"]=0x1D5D, -- ᵝ
 },
 [0x1D5E]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL GREEK GAMMA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x03B3 },
  ["unicodeslot"]=0x1D5E, -- ᵞ
 },
 [0x1D5F]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL DELTA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x03B4 },
  ["unicodeslot"]=0x1D5F, -- ᵟ
 },
 [0x1D60]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL GREEK PHI",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x03C6 },
  ["unicodeslot"]=0x1D60, -- ᵠ
 },
 [0x1D61]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL CHI",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x03C7 },
  ["unicodeslot"]=0x1D61, -- ᵡ
 },
 [0x1D62]={
  ["category"]="ll",
  ["description"]="LATIN SUBSCRIPT SMALL LETTER I",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x0069 },
  ["unicodeslot"]=0x1D62, -- ᵢ
 },
 [0x1D63]={
  ["category"]="ll",
  ["description"]="LATIN SUBSCRIPT SMALL LETTER R",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x0072 },
  ["unicodeslot"]=0x1D63, -- ᵣ
 },
 [0x1D64]={
  ["category"]="ll",
  ["description"]="LATIN SUBSCRIPT SMALL LETTER U",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x0075 },
  ["unicodeslot"]=0x1D64, -- ᵤ
 },
 [0x1D65]={
  ["category"]="ll",
  ["description"]="LATIN SUBSCRIPT SMALL LETTER V",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x0076 },
  ["unicodeslot"]=0x1D65, -- ᵥ
 },
 [0x1D66]={
  ["category"]="ll",
  ["description"]="GREEK SUBSCRIPT SMALL LETTER BETA",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x03B2 },
  ["unicodeslot"]=0x1D66, -- ᵦ
 },
 [0x1D67]={
  ["category"]="ll",
  ["description"]="GREEK SUBSCRIPT SMALL LETTER GAMMA",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x03B3 },
  ["unicodeslot"]=0x1D67, -- ᵧ
 },
 [0x1D68]={
  ["category"]="ll",
  ["description"]="GREEK SUBSCRIPT SMALL LETTER RHO",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x03C1 },
  ["unicodeslot"]=0x1D68, -- ᵨ
 },
 [0x1D69]={
  ["category"]="ll",
  ["description"]="GREEK SUBSCRIPT SMALL LETTER PHI",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x03C6 },
  ["unicodeslot"]=0x1D69, -- ᵩ
 },
 [0x1D6A]={
  ["category"]="ll",
  ["description"]="GREEK SUBSCRIPT SMALL LETTER CHI",
  ["linebreak"]="al",
  ["specials"]={ "sub", 0x03C7 },
  ["unicodeslot"]=0x1D6A, -- ᵪ
 },
 [0x1D6B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER UE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D6B, -- ᵫ
 },
 [0x1D6C]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER B WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["unicodeslot"]=0x1D6C, -- ᵬ
 },
 [0x1D6D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["unicodeslot"]=0x1D6D, -- ᵭ
 },
 [0x1D6E]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER F WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0066,
  ["unicodeslot"]=0x1D6E, -- ᵮ
 },
 [0x1D6F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER M WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x006D,
  ["unicodeslot"]=0x1D6F, -- ᵯ
 },
 [0x1D70]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["unicodeslot"]=0x1D70, -- ᵰ
 },
 [0x1D71]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER P WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0070,
  ["unicodeslot"]=0x1D71, -- ᵱ
 },
 [0x1D72]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["unicodeslot"]=0x1D72, -- ᵲ
 },
 [0x1D73]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["unicodeslot"]=0x1D73, -- ᵳ
 },
 [0x1D74]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["unicodeslot"]=0x1D74, -- ᵴ
 },
 [0x1D75]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["unicodeslot"]=0x1D75, -- ᵵ
 },
 [0x1D76]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH MIDDLE TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["unicodeslot"]=0x1D76, -- ᵶ
 },
 [0x1D77]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TURNED G",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D77, -- ᵷ
 },
 [0x1D78]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER CYRILLIC EN",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x043D },
  ["unicodeslot"]=0x1D78, -- ᵸ
 },
 [0x1D79]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER INSULAR G",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D79, -- ᵹ
 },
 [0x1D7A]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER TH WITH STRIKETHROUGH",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D7A, -- ᵺ
 },
 [0x1D7B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL CAPITAL LETTER I WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D7B, -- ᵻ
 },
 [0x1D7C]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER IOTA WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0269,
  ["unicodeslot"]=0x1D7C, -- ᵼ
 },
 [0x1D7D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER P WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x0070,
  ["uccode"]=0x2C63,
  ["unicodeslot"]=0x1D7D, -- ᵽ
 },
 [0x1D7E]={
  ["category"]="ll",
  ["description"]="LATIN SMALL CAPITAL LETTER U WITH STROKE",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D7E, -- ᵾ
 },
 [0x1D7F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER UPSILON WITH STROKE",
  ["linebreak"]="al",
  ["shcode"]=0x028A,
  ["unicodeslot"]=0x1D7F, -- ᵿ
 },
 [0x1D80]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER B WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["unicodeslot"]=0x1D80, -- ᶀ
 },
 [0x1D81]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["unicodeslot"]=0x1D81, -- ᶁ
 },
 [0x1D82]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER F WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0066,
  ["unicodeslot"]=0x1D82, -- ᶂ
 },
 [0x1D83]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER G WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["unicodeslot"]=0x1D83, -- ᶃ
 },
 [0x1D84]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER K WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006B,
  ["unicodeslot"]=0x1D84, -- ᶄ
 },
 [0x1D85]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["unicodeslot"]=0x1D85, -- ᶅ
 },
 [0x1D86]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER M WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006D,
  ["unicodeslot"]=0x1D86, -- ᶆ
 },
 [0x1D87]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["unicodeslot"]=0x1D87, -- ᶇ
 },
 [0x1D88]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER P WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0070,
  ["unicodeslot"]=0x1D88, -- ᶈ
 },
 [0x1D89]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["unicodeslot"]=0x1D89, -- ᶉ
 },
 [0x1D8A]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["unicodeslot"]=0x1D8A, -- ᶊ
 },
 [0x1D8B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER ESH WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0283,
  ["unicodeslot"]=0x1D8B, -- ᶋ
 },
 [0x1D8C]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER V WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0076,
  ["unicodeslot"]=0x1D8C, -- ᶌ
 },
 [0x1D8D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER X WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0078,
  ["unicodeslot"]=0x1D8D, -- ᶍ
 },
 [0x1D8E]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["unicodeslot"]=0x1D8E, -- ᶎ
 },
 [0x1D8F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER A WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["unicodeslot"]=0x1D8F, -- ᶏ
 },
 [0x1D90]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0251,
  ["unicodeslot"]=0x1D90, -- ᶐ
 },
 [0x1D91]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH HOOK AND TAIL",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["unicodeslot"]=0x1D91, -- ᶑ
 },
 [0x1D92]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER E WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["unicodeslot"]=0x1D92, -- ᶒ
 },
 [0x1D93]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D93, -- ᶓ
 },
 [0x1D94]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D94, -- ᶔ
 },
 [0x1D95]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0259,
  ["unicodeslot"]=0x1D95, -- ᶕ
 },
 [0x1D96]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER I WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["unicodeslot"]=0x1D96, -- ᶖ
 },
 [0x1D97]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["unicodeslot"]=0x1D97, -- ᶗ
 },
 [0x1D98]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER ESH WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0283,
  ["unicodeslot"]=0x1D98, -- ᶘ
 },
 [0x1D99]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER U WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["unicodeslot"]=0x1D99, -- ᶙ
 },
 [0x1D9A]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER EZH WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["shcode"]=0x0292,
  ["unicodeslot"]=0x1D9A, -- ᶚ
 },
 [0x1D9B]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED ALPHA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0252 },
  ["unicodeslot"]=0x1D9B, -- ᶛ
 },
 [0x1D9C]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL C",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0063 },
  ["unicodeslot"]=0x1D9C, -- ᶜ
 },
 [0x1D9D]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL C WITH CURL",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0255 },
  ["unicodeslot"]=0x1D9D, -- ᶝ
 },
 [0x1D9E]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL ETH",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x00F0 },
  ["unicodeslot"]=0x1D9E, -- ᶞ
 },
 [0x1D9F]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL REVERSED OPEN E",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x025C },
  ["unicodeslot"]=0x1D9F, -- ᶟ
 },
 [0x1DA0]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL F",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0066 },
  ["unicodeslot"]=0x1DA0, -- ᶠ
 },
 [0x1DA1]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL DOTLESS J WITH STROKE",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x025F },
  ["unicodeslot"]=0x1DA1, -- ᶡ
 },
 [0x1DA2]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL SCRIPT G",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0261 },
  ["unicodeslot"]=0x1DA2, -- ᶢ
 },
 [0x1DA3]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED H",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0265 },
  ["unicodeslot"]=0x1DA3, -- ᶣ
 },
 [0x1DA4]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL I WITH STROKE",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0268 },
  ["unicodeslot"]=0x1DA4, -- ᶤ
 },
 [0x1DA5]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL IOTA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0269 },
  ["unicodeslot"]=0x1DA5, -- ᶥ
 },
 [0x1DA6]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL CAPITAL I",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x026A },
  ["unicodeslot"]=0x1DA6, -- ᶦ
 },
 [0x1DA7]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL CAPITAL I WITH STROKE",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D7B },
  ["unicodeslot"]=0x1DA7, -- ᶧ
 },
 [0x1DA8]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL J WITH CROSSED-TAIL",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x029D },
  ["unicodeslot"]=0x1DA8, -- ᶨ
 },
 [0x1DA9]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL L WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x026D },
  ["unicodeslot"]=0x1DA9, -- ᶩ
 },
 [0x1DAA]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL L WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D85 },
  ["unicodeslot"]=0x1DAA, -- ᶪ
 },
 [0x1DAB]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL CAPITAL L",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x029F },
  ["unicodeslot"]=0x1DAB, -- ᶫ
 },
 [0x1DAC]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL M WITH HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0271 },
  ["unicodeslot"]=0x1DAC, -- ᶬ
 },
 [0x1DAD]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED M WITH LONG LEG",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0270 },
  ["unicodeslot"]=0x1DAD, -- ᶭ
 },
 [0x1DAE]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL N WITH LEFT HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0272 },
  ["unicodeslot"]=0x1DAE, -- ᶮ
 },
 [0x1DAF]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL N WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0273 },
  ["unicodeslot"]=0x1DAF, -- ᶯ
 },
 [0x1DB0]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL CAPITAL N",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0274 },
  ["unicodeslot"]=0x1DB0, -- ᶰ
 },
 [0x1DB1]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL BARRED O",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0275 },
  ["unicodeslot"]=0x1DB1, -- ᶱ
 },
 [0x1DB2]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL PHI",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0278 },
  ["unicodeslot"]=0x1DB2, -- ᶲ
 },
 [0x1DB3]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL S WITH HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0282 },
  ["unicodeslot"]=0x1DB3, -- ᶳ
 },
 [0x1DB4]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL ESH",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0283 },
  ["unicodeslot"]=0x1DB4, -- ᶴ
 },
 [0x1DB5]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL T WITH PALATAL HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x01AB },
  ["unicodeslot"]=0x1DB5, -- ᶵ
 },
 [0x1DB6]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL U BAR",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0289 },
  ["unicodeslot"]=0x1DB6, -- ᶶ
 },
 [0x1DB7]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL UPSILON",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x028A },
  ["unicodeslot"]=0x1DB7, -- ᶷ
 },
 [0x1DB8]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL CAPITAL U",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x1D1C },
  ["unicodeslot"]=0x1DB8, -- ᶸ
 },
 [0x1DB9]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL V WITH HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x028B },
  ["unicodeslot"]=0x1DB9, -- ᶹ
 },
 [0x1DBA]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL TURNED V",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x028C },
  ["unicodeslot"]=0x1DBA, -- ᶺ
 },
 [0x1DBB]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL Z",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x007A },
  ["unicodeslot"]=0x1DBB, -- ᶻ
 },
 [0x1DBC]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0290 },
  ["unicodeslot"]=0x1DBC, -- ᶼ
 },
 [0x1DBD]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL Z WITH CURL",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0291 },
  ["unicodeslot"]=0x1DBD, -- ᶽ
 },
 [0x1DBE]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL EZH",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x0292 },
  ["unicodeslot"]=0x1DBE, -- ᶾ
 },
 [0x1DBF]={
  ["category"]="lm",
  ["description"]="MODIFIER LETTER SMALL THETA",
  ["linebreak"]="al",
  ["specials"]={ "super", 0x03B8 },
  ["unicodeslot"]=0x1DBF, -- ᶿ
 },
 [0x1DC0]={
  ["category"]="mn",
  ["description"]="COMBINING DOTTED GRAVE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC0, -- ᷀
 },
 [0x1DC1]={
  ["category"]="mn",
  ["description"]="COMBINING DOTTED ACUTE ACCENT",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC1, -- ᷁
 },
 [0x1DC2]={
  ["category"]="mn",
  ["description"]="COMBINING SNAKE BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC2, -- ᷂
 },
 [0x1DC3]={
  ["category"]="mn",
  ["description"]="COMBINING SUSPENSION MARK",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC3, -- ᷃
 },
 [0x1DC4]={
  ["category"]="mn",
  ["description"]="COMBINING MACRON-ACUTE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC4, -- ᷄
 },
 [0x1DC5]={
  ["category"]="mn",
  ["description"]="COMBINING GRAVE-MACRON",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC5, -- ᷅
 },
 [0x1DC6]={
  ["category"]="mn",
  ["description"]="COMBINING MACRON-GRAVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC6, -- ᷆
 },
 [0x1DC7]={
  ["category"]="mn",
  ["description"]="COMBINING ACUTE-MACRON",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC7, -- ᷇
 },
 [0x1DC8]={
  ["category"]="mn",
  ["description"]="COMBINING GRAVE-ACUTE-GRAVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC8, -- ᷈
 },
 [0x1DC9]={
  ["category"]="mn",
  ["description"]="COMBINING ACUTE-GRAVE-ACUTE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DC9, -- ᷉
 },
 [0x1DCA]={
  ["category"]="mn",
  ["description"]="COMBINING LATIN SMALL LETTER R BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DCA, -- ᷊
 },
 [0x1DFE]={
  ["category"]="mn",
  ["description"]="COMBINING LEFT ARROWHEAD ABOVE",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DFE, -- ᷾
 },
 [0x1DFF]={
  ["category"]="mn",
  ["description"]="COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW",
  ["linebreak"]="cm",
  ["unicodeslot"]=0x1DFF, -- ᷿
 },
 [0x1E00]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER A WITH RING BELOW",
  ["lccode"]=0x1E01,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0325 },
  ["unicodeslot"]=0x1E00, -- Ḁ
 },
 [0x1E01]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER A WITH RING BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0325 },
  ["uccode"]=0x1E00,
  ["unicodeslot"]=0x1E01, -- ḁ
 },
 [0x1E02]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER B WITH DOT ABOVE",
  ["lccode"]=0x1E03,
  ["linebreak"]="al",
  ["shcode"]=0x0042,
  ["specials"]={ "char", 0x0042, 0x0307 },
  ["unicodeslot"]=0x1E02, -- Ḃ
 },
 [0x1E03]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER B WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["specials"]={ "char", 0x0062, 0x0307 },
  ["uccode"]=0x1E02,
  ["unicodeslot"]=0x1E03, -- ḃ
 },
 [0x1E04]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER B WITH DOT BELOW",
  ["lccode"]=0x1E05,
  ["linebreak"]="al",
  ["shcode"]=0x0042,
  ["specials"]={ "char", 0x0042, 0x0323 },
  ["unicodeslot"]=0x1E04, -- Ḅ
 },
 [0x1E05]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER B WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["specials"]={ "char", 0x0062, 0x0323 },
  ["uccode"]=0x1E04,
  ["unicodeslot"]=0x1E05, -- ḅ
 },
 [0x1E06]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER B WITH LINE BELOW",
  ["lccode"]=0x1E07,
  ["linebreak"]="al",
  ["shcode"]=0x0042,
  ["specials"]={ "char", 0x0042, 0x0331 },
  ["unicodeslot"]=0x1E06, -- Ḇ
 },
 [0x1E07]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER B WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0062,
  ["specials"]={ "char", 0x0062, 0x0331 },
  ["uccode"]=0x1E06,
  ["unicodeslot"]=0x1E07, -- ḇ
 },
 [0x1E08]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE",
  ["lccode"]=0x1E09,
  ["linebreak"]="al",
  ["shcode"]=0x0043,
  ["specials"]={ "char", 0x00C7, 0x0301 },
  ["unicodeslot"]=0x1E08, -- Ḉ
 },
 [0x1E09]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER C WITH CEDILLA AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0063,
  ["specials"]={ "char", 0x00E7, 0x0301 },
  ["uccode"]=0x1E08,
  ["unicodeslot"]=0x1E09, -- ḉ
 },
 [0x1E0A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER D WITH DOT ABOVE",
  ["lccode"]=0x1E0B,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["specials"]={ "char", 0x0044, 0x0307 },
  ["unicodeslot"]=0x1E0A, -- Ḋ
 },
 [0x1E0B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["specials"]={ "char", 0x0064, 0x0307 },
  ["uccode"]=0x1E0A,
  ["unicodeslot"]=0x1E0B, -- ḋ
 },
 [0x1E0C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER D WITH DOT BELOW",
  ["lccode"]=0x1E0D,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["specials"]={ "char", 0x0044, 0x0323 },
  ["unicodeslot"]=0x1E0C, -- Ḍ
 },
 [0x1E0D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["specials"]={ "char", 0x0064, 0x0323 },
  ["uccode"]=0x1E0C,
  ["unicodeslot"]=0x1E0D, -- ḍ
 },
 [0x1E0E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER D WITH LINE BELOW",
  ["lccode"]=0x1E0F,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["specials"]={ "char", 0x0044, 0x0331 },
  ["unicodeslot"]=0x1E0E, -- Ḏ
 },
 [0x1E0F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["specials"]={ "char", 0x0064, 0x0331 },
  ["uccode"]=0x1E0E,
  ["unicodeslot"]=0x1E0F, -- ḏ
 },
 [0x1E10]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER D WITH CEDILLA",
  ["lccode"]=0x1E11,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["specials"]={ "char", 0x0044, 0x0327 },
  ["unicodeslot"]=0x1E10, -- Ḑ
 },
 [0x1E11]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["specials"]={ "char", 0x0064, 0x0327 },
  ["uccode"]=0x1E10,
  ["unicodeslot"]=0x1E11, -- ḑ
 },
 [0x1E12]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW",
  ["lccode"]=0x1E13,
  ["linebreak"]="al",
  ["shcode"]=0x0044,
  ["specials"]={ "char", 0x0044, 0x032D },
  ["unicodeslot"]=0x1E12, -- Ḓ
 },
 [0x1E13]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0064,
  ["specials"]={ "char", 0x0064, 0x032D },
  ["uccode"]=0x1E12,
  ["unicodeslot"]=0x1E13, -- ḓ
 },
 [0x1E14]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER E WITH MACRON AND GRAVE",
  ["lccode"]=0x1E15,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0112, 0x0300 },
  ["unicodeslot"]=0x1E14, -- Ḕ
 },
 [0x1E15]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER E WITH MACRON AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0113, 0x0300 },
  ["uccode"]=0x1E14,
  ["unicodeslot"]=0x1E15, -- ḕ
 },
 [0x1E16]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER E WITH MACRON AND ACUTE",
  ["lccode"]=0x1E17,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0112, 0x0301 },
  ["unicodeslot"]=0x1E16, -- Ḗ
 },
 [0x1E17]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER E WITH MACRON AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0113, 0x0301 },
  ["uccode"]=0x1E16,
  ["unicodeslot"]=0x1E17, -- ḗ
 },
 [0x1E18]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW",
  ["lccode"]=0x1E19,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x032D },
  ["unicodeslot"]=0x1E18, -- Ḙ
 },
 [0x1E19]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x032D },
  ["uccode"]=0x1E18,
  ["unicodeslot"]=0x1E19, -- ḙ
 },
 [0x1E1A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER E WITH TILDE BELOW",
  ["lccode"]=0x1E1B,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0330 },
  ["unicodeslot"]=0x1E1A, -- Ḛ
 },
 [0x1E1B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER E WITH TILDE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0330 },
  ["uccode"]=0x1E1A,
  ["unicodeslot"]=0x1E1B, -- ḛ
 },
 [0x1E1C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE",
  ["lccode"]=0x1E1D,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0228, 0x0306 },
  ["unicodeslot"]=0x1E1C, -- Ḝ
 },
 [0x1E1D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER E WITH CEDILLA AND BREVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0229, 0x0306 },
  ["uccode"]=0x1E1C,
  ["unicodeslot"]=0x1E1D, -- ḝ
 },
 [0x1E1E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER F WITH DOT ABOVE",
  ["lccode"]=0x1E1F,
  ["linebreak"]="al",
  ["shcode"]=0x0046,
  ["specials"]={ "char", 0x0046, 0x0307 },
  ["unicodeslot"]=0x1E1E, -- Ḟ
 },
 [0x1E1F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER F WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0066,
  ["specials"]={ "char", 0x0066, 0x0307 },
  ["uccode"]=0x1E1E,
  ["unicodeslot"]=0x1E1F, -- ḟ
 },
 [0x1E20]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER G WITH MACRON",
  ["lccode"]=0x1E21,
  ["linebreak"]="al",
  ["shcode"]=0x0047,
  ["specials"]={ "char", 0x0047, 0x0304 },
  ["unicodeslot"]=0x1E20, -- Ḡ
 },
 [0x1E21]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER G WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0067,
  ["specials"]={ "char", 0x0067, 0x0304 },
  ["uccode"]=0x1E20,
  ["unicodeslot"]=0x1E21, -- ḡ
 },
 [0x1E22]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER H WITH DOT ABOVE",
  ["lccode"]=0x1E23,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["specials"]={ "char", 0x0048, 0x0307 },
  ["unicodeslot"]=0x1E22, -- Ḣ
 },
 [0x1E23]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER H WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x0307 },
  ["uccode"]=0x1E22,
  ["unicodeslot"]=0x1E23, -- ḣ
 },
 [0x1E24]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER H WITH DOT BELOW",
  ["lccode"]=0x1E25,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["specials"]={ "char", 0x0048, 0x0323 },
  ["unicodeslot"]=0x1E24, -- Ḥ
 },
 [0x1E25]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER H WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x0323 },
  ["uccode"]=0x1E24,
  ["unicodeslot"]=0x1E25, -- ḥ
 },
 [0x1E26]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER H WITH DIAERESIS",
  ["lccode"]=0x1E27,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["specials"]={ "char", 0x0048, 0x0308 },
  ["unicodeslot"]=0x1E26, -- Ḧ
 },
 [0x1E27]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER H WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x0308 },
  ["uccode"]=0x1E26,
  ["unicodeslot"]=0x1E27, -- ḧ
 },
 [0x1E28]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER H WITH CEDILLA",
  ["lccode"]=0x1E29,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["specials"]={ "char", 0x0048, 0x0327 },
  ["unicodeslot"]=0x1E28, -- Ḩ
 },
 [0x1E29]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER H WITH CEDILLA",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x0327 },
  ["uccode"]=0x1E28,
  ["unicodeslot"]=0x1E29, -- ḩ
 },
 [0x1E2A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER H WITH BREVE BELOW",
  ["lccode"]=0x1E2B,
  ["linebreak"]="al",
  ["shcode"]=0x0048,
  ["specials"]={ "char", 0x0048, 0x032E },
  ["unicodeslot"]=0x1E2A, -- Ḫ
 },
 [0x1E2B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER H WITH BREVE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x032E },
  ["uccode"]=0x1E2A,
  ["unicodeslot"]=0x1E2B, -- ḫ
 },
 [0x1E2C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER I WITH TILDE BELOW",
  ["lccode"]=0x1E2D,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0330 },
  ["unicodeslot"]=0x1E2C, -- Ḭ
 },
 [0x1E2D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER I WITH TILDE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0330 },
  ["uccode"]=0x1E2C,
  ["unicodeslot"]=0x1E2D, -- ḭ
 },
 [0x1E2E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE",
  ["lccode"]=0x1E2F,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x00CF, 0x0301 },
  ["unicodeslot"]=0x1E2E, -- Ḯ
 },
 [0x1E2F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x00EF, 0x0301 },
  ["uccode"]=0x1E2E,
  ["unicodeslot"]=0x1E2F, -- ḯ
 },
 [0x1E30]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER K WITH ACUTE",
  ["lccode"]=0x1E31,
  ["linebreak"]="al",
  ["shcode"]=0x004B,
  ["specials"]={ "char", 0x004B, 0x0301 },
  ["unicodeslot"]=0x1E30, -- Ḱ
 },
 [0x1E31]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER K WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006B,
  ["specials"]={ "char", 0x006B, 0x0301 },
  ["uccode"]=0x1E30,
  ["unicodeslot"]=0x1E31, -- ḱ
 },
 [0x1E32]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER K WITH DOT BELOW",
  ["lccode"]=0x1E33,
  ["linebreak"]="al",
  ["shcode"]=0x004B,
  ["specials"]={ "char", 0x004B, 0x0323 },
  ["unicodeslot"]=0x1E32, -- Ḳ
 },
 [0x1E33]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER K WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006B,
  ["specials"]={ "char", 0x006B, 0x0323 },
  ["uccode"]=0x1E32,
  ["unicodeslot"]=0x1E33, -- ḳ
 },
 [0x1E34]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER K WITH LINE BELOW",
  ["lccode"]=0x1E35,
  ["linebreak"]="al",
  ["shcode"]=0x004B,
  ["specials"]={ "char", 0x004B, 0x0331 },
  ["unicodeslot"]=0x1E34, -- Ḵ
 },
 [0x1E35]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER K WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006B,
  ["specials"]={ "char", 0x006B, 0x0331 },
  ["uccode"]=0x1E34,
  ["unicodeslot"]=0x1E35, -- ḵ
 },
 [0x1E36]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER L WITH DOT BELOW",
  ["lccode"]=0x1E37,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "char", 0x004C, 0x0323 },
  ["unicodeslot"]=0x1E36, -- Ḷ
 },
 [0x1E37]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "char", 0x006C, 0x0323 },
  ["uccode"]=0x1E36,
  ["unicodeslot"]=0x1E37, -- ḷ
 },
 [0x1E38]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON",
  ["lccode"]=0x1E39,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "char", 0x1E36, 0x0304 },
  ["unicodeslot"]=0x1E38, -- Ḹ
 },
 [0x1E39]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH DOT BELOW AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "char", 0x1E37, 0x0304 },
  ["uccode"]=0x1E38,
  ["unicodeslot"]=0x1E39, -- ḹ
 },
 [0x1E3A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER L WITH LINE BELOW",
  ["lccode"]=0x1E3B,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "char", 0x004C, 0x0331 },
  ["unicodeslot"]=0x1E3A, -- Ḻ
 },
 [0x1E3B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "char", 0x006C, 0x0331 },
  ["uccode"]=0x1E3A,
  ["unicodeslot"]=0x1E3B, -- ḻ
 },
 [0x1E3C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW",
  ["lccode"]=0x1E3D,
  ["linebreak"]="al",
  ["shcode"]=0x004C,
  ["specials"]={ "char", 0x004C, 0x032D },
  ["unicodeslot"]=0x1E3C, -- Ḽ
 },
 [0x1E3D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006C,
  ["specials"]={ "char", 0x006C, 0x032D },
  ["uccode"]=0x1E3C,
  ["unicodeslot"]=0x1E3D, -- ḽ
 },
 [0x1E3E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER M WITH ACUTE",
  ["lccode"]=0x1E3F,
  ["linebreak"]="al",
  ["shcode"]=0x004D,
  ["specials"]={ "char", 0x004D, 0x0301 },
  ["unicodeslot"]=0x1E3E, -- Ḿ
 },
 [0x1E3F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER M WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006D,
  ["specials"]={ "char", 0x006D, 0x0301 },
  ["uccode"]=0x1E3E,
  ["unicodeslot"]=0x1E3F, -- ḿ
 },
 [0x1E40]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER M WITH DOT ABOVE",
  ["lccode"]=0x1E41,
  ["linebreak"]="al",
  ["shcode"]=0x004D,
  ["specials"]={ "char", 0x004D, 0x0307 },
  ["unicodeslot"]=0x1E40, -- Ṁ
 },
 [0x1E41]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER M WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x006D,
  ["specials"]={ "char", 0x006D, 0x0307 },
  ["uccode"]=0x1E40,
  ["unicodeslot"]=0x1E41, -- ṁ
 },
 [0x1E42]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER M WITH DOT BELOW",
  ["lccode"]=0x1E43,
  ["linebreak"]="al",
  ["shcode"]=0x004D,
  ["specials"]={ "char", 0x004D, 0x0323 },
  ["unicodeslot"]=0x1E42, -- Ṃ
 },
 [0x1E43]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER M WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006D,
  ["specials"]={ "char", 0x006D, 0x0323 },
  ["uccode"]=0x1E42,
  ["unicodeslot"]=0x1E43, -- ṃ
 },
 [0x1E44]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER N WITH DOT ABOVE",
  ["lccode"]=0x1E45,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x0307 },
  ["unicodeslot"]=0x1E44, -- Ṅ
 },
 [0x1E45]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x0307 },
  ["uccode"]=0x1E44,
  ["unicodeslot"]=0x1E45, -- ṅ
 },
 [0x1E46]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER N WITH DOT BELOW",
  ["lccode"]=0x1E47,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x0323 },
  ["unicodeslot"]=0x1E46, -- Ṇ
 },
 [0x1E47]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x0323 },
  ["uccode"]=0x1E46,
  ["unicodeslot"]=0x1E47, -- ṇ
 },
 [0x1E48]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER N WITH LINE BELOW",
  ["lccode"]=0x1E49,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x0331 },
  ["unicodeslot"]=0x1E48, -- Ṉ
 },
 [0x1E49]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x0331 },
  ["uccode"]=0x1E48,
  ["unicodeslot"]=0x1E49, -- ṉ
 },
 [0x1E4A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW",
  ["lccode"]=0x1E4B,
  ["linebreak"]="al",
  ["shcode"]=0x004E,
  ["specials"]={ "char", 0x004E, 0x032D },
  ["unicodeslot"]=0x1E4A, -- Ṋ
 },
 [0x1E4B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006E,
  ["specials"]={ "char", 0x006E, 0x032D },
  ["uccode"]=0x1E4A,
  ["unicodeslot"]=0x1E4B, -- ṋ
 },
 [0x1E4C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER O WITH TILDE AND ACUTE",
  ["lccode"]=0x1E4D,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D5, 0x0301 },
  ["unicodeslot"]=0x1E4C, -- Ṍ
 },
 [0x1E4D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER O WITH TILDE AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F5, 0x0301 },
  ["uccode"]=0x1E4C,
  ["unicodeslot"]=0x1E4D, -- ṍ
 },
 [0x1E4E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS",
  ["lccode"]=0x1E4F,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D5, 0x0308 },
  ["unicodeslot"]=0x1E4E, -- Ṏ
 },
 [0x1E4F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER O WITH TILDE AND DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F5, 0x0308 },
  ["uccode"]=0x1E4E,
  ["unicodeslot"]=0x1E4F, -- ṏ
 },
 [0x1E50]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER O WITH MACRON AND GRAVE",
  ["lccode"]=0x1E51,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x014C, 0x0300 },
  ["unicodeslot"]=0x1E50, -- Ṑ
 },
 [0x1E51]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER O WITH MACRON AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x014D, 0x0300 },
  ["uccode"]=0x1E50,
  ["unicodeslot"]=0x1E51, -- ṑ
 },
 [0x1E52]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER O WITH MACRON AND ACUTE",
  ["lccode"]=0x1E53,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x014C, 0x0301 },
  ["unicodeslot"]=0x1E52, -- Ṓ
 },
 [0x1E53]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER O WITH MACRON AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x014D, 0x0301 },
  ["uccode"]=0x1E52,
  ["unicodeslot"]=0x1E53, -- ṓ
 },
 [0x1E54]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER P WITH ACUTE",
  ["lccode"]=0x1E55,
  ["linebreak"]="al",
  ["shcode"]=0x0050,
  ["specials"]={ "char", 0x0050, 0x0301 },
  ["unicodeslot"]=0x1E54, -- Ṕ
 },
 [0x1E55]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER P WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0070,
  ["specials"]={ "char", 0x0070, 0x0301 },
  ["uccode"]=0x1E54,
  ["unicodeslot"]=0x1E55, -- ṕ
 },
 [0x1E56]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER P WITH DOT ABOVE",
  ["lccode"]=0x1E57,
  ["linebreak"]="al",
  ["shcode"]=0x0050,
  ["specials"]={ "char", 0x0050, 0x0307 },
  ["unicodeslot"]=0x1E56, -- Ṗ
 },
 [0x1E57]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER P WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0070,
  ["specials"]={ "char", 0x0070, 0x0307 },
  ["uccode"]=0x1E56,
  ["unicodeslot"]=0x1E57, -- ṗ
 },
 [0x1E58]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER R WITH DOT ABOVE",
  ["lccode"]=0x1E59,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x0307 },
  ["unicodeslot"]=0x1E58, -- Ṙ
 },
 [0x1E59]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x0307 },
  ["uccode"]=0x1E58,
  ["unicodeslot"]=0x1E59, -- ṙ
 },
 [0x1E5A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER R WITH DOT BELOW",
  ["lccode"]=0x1E5B,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x0323 },
  ["unicodeslot"]=0x1E5A, -- Ṛ
 },
 [0x1E5B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x0323 },
  ["uccode"]=0x1E5A,
  ["unicodeslot"]=0x1E5B, -- ṛ
 },
 [0x1E5C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON",
  ["lccode"]=0x1E5D,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x1E5A, 0x0304 },
  ["unicodeslot"]=0x1E5C, -- Ṝ
 },
 [0x1E5D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH DOT BELOW AND MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x1E5B, 0x0304 },
  ["uccode"]=0x1E5C,
  ["unicodeslot"]=0x1E5D, -- ṝ
 },
 [0x1E5E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER R WITH LINE BELOW",
  ["lccode"]=0x1E5F,
  ["linebreak"]="al",
  ["shcode"]=0x0052,
  ["specials"]={ "char", 0x0052, 0x0331 },
  ["unicodeslot"]=0x1E5E, -- Ṟ
 },
 [0x1E5F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER R WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0072,
  ["specials"]={ "char", 0x0072, 0x0331 },
  ["uccode"]=0x1E5E,
  ["unicodeslot"]=0x1E5F, -- ṟ
 },
 [0x1E60]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER S WITH DOT ABOVE",
  ["lccode"]=0x1E61,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0053, 0x0307 },
  ["unicodeslot"]=0x1E60, -- Ṡ
 },
 [0x1E61]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0073, 0x0307 },
  ["uccode"]=0x1E60,
  ["unicodeslot"]=0x1E61, -- ṡ
 },
 [0x1E62]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER S WITH DOT BELOW",
  ["lccode"]=0x1E63,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0053, 0x0323 },
  ["unicodeslot"]=0x1E62, -- Ṣ
 },
 [0x1E63]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0073, 0x0323 },
  ["uccode"]=0x1E62,
  ["unicodeslot"]=0x1E63, -- ṣ
 },
 [0x1E64]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE",
  ["lccode"]=0x1E65,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x015A, 0x0307 },
  ["unicodeslot"]=0x1E64, -- Ṥ
 },
 [0x1E65]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x015B, 0x0307 },
  ["uccode"]=0x1E64,
  ["unicodeslot"]=0x1E65, -- ṥ
 },
 [0x1E66]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE",
  ["lccode"]=0x1E67,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x0160, 0x0307 },
  ["unicodeslot"]=0x1E66, -- Ṧ
 },
 [0x1E67]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH CARON AND DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x0161, 0x0307 },
  ["uccode"]=0x1E66,
  ["unicodeslot"]=0x1E67, -- ṧ
 },
 [0x1E68]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE",
  ["lccode"]=0x1E69,
  ["linebreak"]="al",
  ["shcode"]=0x0053,
  ["specials"]={ "char", 0x1E62, 0x0307 },
  ["unicodeslot"]=0x1E68, -- Ṩ
 },
 [0x1E69]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0073,
  ["specials"]={ "char", 0x1E63, 0x0307 },
  ["uccode"]=0x1E68,
  ["unicodeslot"]=0x1E69, -- ṩ
 },
 [0x1E6A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER T WITH DOT ABOVE",
  ["lccode"]=0x1E6B,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["specials"]={ "char", 0x0054, 0x0307 },
  ["unicodeslot"]=0x1E6A, -- Ṫ
 },
 [0x1E6B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x0307 },
  ["uccode"]=0x1E6A,
  ["unicodeslot"]=0x1E6B, -- ṫ
 },
 [0x1E6C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER T WITH DOT BELOW",
  ["lccode"]=0x1E6D,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["specials"]={ "char", 0x0054, 0x0323 },
  ["unicodeslot"]=0x1E6C, -- Ṭ
 },
 [0x1E6D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x0323 },
  ["uccode"]=0x1E6C,
  ["unicodeslot"]=0x1E6D, -- ṭ
 },
 [0x1E6E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER T WITH LINE BELOW",
  ["lccode"]=0x1E6F,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["specials"]={ "char", 0x0054, 0x0331 },
  ["unicodeslot"]=0x1E6E, -- Ṯ
 },
 [0x1E6F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x0331 },
  ["uccode"]=0x1E6E,
  ["unicodeslot"]=0x1E6F, -- ṯ
 },
 [0x1E70]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW",
  ["lccode"]=0x1E71,
  ["linebreak"]="al",
  ["shcode"]=0x0054,
  ["specials"]={ "char", 0x0054, 0x032D },
  ["unicodeslot"]=0x1E70, -- Ṱ
 },
 [0x1E71]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x032D },
  ["uccode"]=0x1E70,
  ["unicodeslot"]=0x1E71, -- ṱ
 },
 [0x1E72]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER U WITH DIAERESIS BELOW",
  ["lccode"]=0x1E73,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0324 },
  ["unicodeslot"]=0x1E72, -- Ṳ
 },
 [0x1E73]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER U WITH DIAERESIS BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0324 },
  ["uccode"]=0x1E72,
  ["unicodeslot"]=0x1E73, -- ṳ
 },
 [0x1E74]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER U WITH TILDE BELOW",
  ["lccode"]=0x1E75,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0330 },
  ["unicodeslot"]=0x1E74, -- Ṵ
 },
 [0x1E75]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER U WITH TILDE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0330 },
  ["uccode"]=0x1E74,
  ["unicodeslot"]=0x1E75, -- ṵ
 },
 [0x1E76]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW",
  ["lccode"]=0x1E77,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x032D },
  ["unicodeslot"]=0x1E76, -- Ṷ
 },
 [0x1E77]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x032D },
  ["uccode"]=0x1E76,
  ["unicodeslot"]=0x1E77, -- ṷ
 },
 [0x1E78]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER U WITH TILDE AND ACUTE",
  ["lccode"]=0x1E79,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0168, 0x0301 },
  ["unicodeslot"]=0x1E78, -- Ṹ
 },
 [0x1E79]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER U WITH TILDE AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0169, 0x0301 },
  ["uccode"]=0x1E78,
  ["unicodeslot"]=0x1E79, -- ṹ
 },
 [0x1E7A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS",
  ["lccode"]=0x1E7B,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x016A, 0x0308 },
  ["unicodeslot"]=0x1E7A, -- Ṻ
 },
 [0x1E7B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER U WITH MACRON AND DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x016B, 0x0308 },
  ["uccode"]=0x1E7A,
  ["unicodeslot"]=0x1E7B, -- ṻ
 },
 [0x1E7C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER V WITH TILDE",
  ["lccode"]=0x1E7D,
  ["linebreak"]="al",
  ["shcode"]=0x0056,
  ["specials"]={ "char", 0x0056, 0x0303 },
  ["unicodeslot"]=0x1E7C, -- Ṽ
 },
 [0x1E7D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER V WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0076,
  ["specials"]={ "char", 0x0076, 0x0303 },
  ["uccode"]=0x1E7C,
  ["unicodeslot"]=0x1E7D, -- ṽ
 },
 [0x1E7E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER V WITH DOT BELOW",
  ["lccode"]=0x1E7F,
  ["linebreak"]="al",
  ["shcode"]=0x0056,
  ["specials"]={ "char", 0x0056, 0x0323 },
  ["unicodeslot"]=0x1E7E, -- Ṿ
 },
 [0x1E7F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER V WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0076,
  ["specials"]={ "char", 0x0076, 0x0323 },
  ["uccode"]=0x1E7E,
  ["unicodeslot"]=0x1E7F, -- ṿ
 },
 [0x1E80]={
  ["adobename"]="Wgrave",
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER W WITH GRAVE",
  ["lccode"]=0x1E81,
  ["linebreak"]="al",
  ["shcode"]=0x0057,
  ["specials"]={ "char", 0x0057, 0x0300 },
  ["unicodeslot"]=0x1E80, -- Ẁ
 },
 [0x1E81]={
  ["adobename"]="wgrave",
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER W WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0077,
  ["specials"]={ "char", 0x0077, 0x0300 },
  ["uccode"]=0x1E80,
  ["unicodeslot"]=0x1E81, -- ẁ
 },
 [0x1E82]={
  ["adobename"]="Wacute",
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER W WITH ACUTE",
  ["lccode"]=0x1E83,
  ["linebreak"]="al",
  ["shcode"]=0x0057,
  ["specials"]={ "char", 0x0057, 0x0301 },
  ["unicodeslot"]=0x1E82, -- Ẃ
 },
 [0x1E83]={
  ["adobename"]="wacute",
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER W WITH ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0077,
  ["specials"]={ "char", 0x0077, 0x0301 },
  ["uccode"]=0x1E82,
  ["unicodeslot"]=0x1E83, -- ẃ
 },
 [0x1E84]={
  ["adobename"]="Wdieresis",
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER W WITH DIAERESIS",
  ["lccode"]=0x1E85,
  ["linebreak"]="al",
  ["shcode"]=0x0057,
  ["specials"]={ "char", 0x0057, 0x0308 },
  ["unicodeslot"]=0x1E84, -- Ẅ
 },
 [0x1E85]={
  ["adobename"]="wdieresis",
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER W WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0077,
  ["specials"]={ "char", 0x0077, 0x0308 },
  ["uccode"]=0x1E84,
  ["unicodeslot"]=0x1E85, -- ẅ
 },
 [0x1E86]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER W WITH DOT ABOVE",
  ["lccode"]=0x1E87,
  ["linebreak"]="al",
  ["shcode"]=0x0057,
  ["specials"]={ "char", 0x0057, 0x0307 },
  ["unicodeslot"]=0x1E86, -- Ẇ
 },
 [0x1E87]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER W WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0077,
  ["specials"]={ "char", 0x0077, 0x0307 },
  ["uccode"]=0x1E86,
  ["unicodeslot"]=0x1E87, -- ẇ
 },
 [0x1E88]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER W WITH DOT BELOW",
  ["lccode"]=0x1E89,
  ["linebreak"]="al",
  ["shcode"]=0x0057,
  ["specials"]={ "char", 0x0057, 0x0323 },
  ["unicodeslot"]=0x1E88, -- Ẉ
 },
 [0x1E89]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER W WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0077,
  ["specials"]={ "char", 0x0077, 0x0323 },
  ["uccode"]=0x1E88,
  ["unicodeslot"]=0x1E89, -- ẉ
 },
 [0x1E8A]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER X WITH DOT ABOVE",
  ["lccode"]=0x1E8B,
  ["linebreak"]="al",
  ["shcode"]=0x0058,
  ["specials"]={ "char", 0x0058, 0x0307 },
  ["unicodeslot"]=0x1E8A, -- Ẋ
 },
 [0x1E8B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER X WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0078,
  ["specials"]={ "char", 0x0078, 0x0307 },
  ["uccode"]=0x1E8A,
  ["unicodeslot"]=0x1E8B, -- ẋ
 },
 [0x1E8C]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER X WITH DIAERESIS",
  ["lccode"]=0x1E8D,
  ["linebreak"]="al",
  ["shcode"]=0x0058,
  ["specials"]={ "char", 0x0058, 0x0308 },
  ["unicodeslot"]=0x1E8C, -- Ẍ
 },
 [0x1E8D]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER X WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0078,
  ["specials"]={ "char", 0x0078, 0x0308 },
  ["uccode"]=0x1E8C,
  ["unicodeslot"]=0x1E8D, -- ẍ
 },
 [0x1E8E]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER Y WITH DOT ABOVE",
  ["lccode"]=0x1E8F,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0307 },
  ["unicodeslot"]=0x1E8E, -- Ẏ
 },
 [0x1E8F]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Y WITH DOT ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0307 },
  ["uccode"]=0x1E8E,
  ["unicodeslot"]=0x1E8F, -- ẏ
 },
 [0x1E90]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER Z WITH CIRCUMFLEX",
  ["lccode"]=0x1E91,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["specials"]={ "char", 0x005A, 0x0302 },
  ["unicodeslot"]=0x1E90, -- Ẑ
 },
 [0x1E91]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH CIRCUMFLEX",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["specials"]={ "char", 0x007A, 0x0302 },
  ["uccode"]=0x1E90,
  ["unicodeslot"]=0x1E91, -- ẑ
 },
 [0x1E92]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER Z WITH DOT BELOW",
  ["lccode"]=0x1E93,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["specials"]={ "char", 0x005A, 0x0323 },
  ["unicodeslot"]=0x1E92, -- Ẓ
 },
 [0x1E93]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["specials"]={ "char", 0x007A, 0x0323 },
  ["uccode"]=0x1E92,
  ["unicodeslot"]=0x1E93, -- ẓ
 },
 [0x1E94]={
  ["category"]="lu",
  ["description"]="LATIN CAPITAL LETTER Z WITH LINE BELOW",
  ["lccode"]=0x1E95,
  ["linebreak"]="al",
  ["shcode"]=0x005A,
  ["specials"]={ "char", 0x005A, 0x0331 },
  ["unicodeslot"]=0x1E94, -- Ẕ
 },
 [0x1E95]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Z WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x007A,
  ["specials"]={ "char", 0x007A, 0x0331 },
  ["uccode"]=0x1E94,
  ["unicodeslot"]=0x1E95, -- ẕ
 },
 [0x1E96]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER H WITH LINE BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0068,
  ["specials"]={ "char", 0x0068, 0x0331 },
  ["unicodeslot"]=0x1E96, -- ẖ
 },
 [0x1E97]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER T WITH DIAERESIS",
  ["linebreak"]="al",
  ["shcode"]=0x0074,
  ["specials"]={ "char", 0x0074, 0x0308 },
  ["unicodeslot"]=0x1E97, -- ẗ
 },
 [0x1E98]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER W WITH RING ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0077,
  ["specials"]={ "char", 0x0077, 0x030A },
  ["unicodeslot"]=0x1E98, -- ẘ
 },
 [0x1E99]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER Y WITH RING ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x030A },
  ["unicodeslot"]=0x1E99, -- ẙ
 },
 [0x1E9A]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER A WITH RIGHT HALF RING",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "compat", 0x0061, 0x02BE },
  ["unicodeslot"]=0x1E9A, -- ẚ
 },
 [0x1E9B]={
  ["category"]="ll",
  ["description"]="LATIN SMALL LETTER LONG S WITH DOT ABOVE",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x017F, 0x0307 },
  ["uccode"]=0x1E60,
  ["unicodeslot"]=0x1E9B, -- ẛ
 },
 [0x1EA0]={
  ["category"]="lu",
  ["contextname"]="Adotbelow",
  ["description"]="LATIN CAPITAL LETTER A WITH DOT BELOW",
  ["lccode"]=0x1EA1,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0323 },
  ["unicodeslot"]=0x1EA0, -- Ạ
 },
 [0x1EA1]={
  ["category"]="ll",
  ["contextname"]="adotbelow",
  ["description"]="LATIN SMALL LETTER A WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0323 },
  ["uccode"]=0x1EA0,
  ["unicodeslot"]=0x1EA1, -- ạ
 },
 [0x1EA2]={
  ["category"]="lu",
  ["contextname"]="Ahook",
  ["description"]="LATIN CAPITAL LETTER A WITH HOOK ABOVE",
  ["lccode"]=0x1EA3,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0041, 0x0309 },
  ["unicodeslot"]=0x1EA2, -- Ả
 },
 [0x1EA3]={
  ["category"]="ll",
  ["contextname"]="ahook",
  ["description"]="LATIN SMALL LETTER A WITH HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0061, 0x0309 },
  ["uccode"]=0x1EA2,
  ["unicodeslot"]=0x1EA3, -- ả
 },
 [0x1EA4]={
  ["category"]="lu",
  ["contextname"]="Acircumflexacute",
  ["description"]="LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE",
  ["lccode"]=0x1EA5,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x00C2, 0x0301 },
  ["unicodeslot"]=0x1EA4, -- Ấ
 },
 [0x1EA5]={
  ["category"]="ll",
  ["contextname"]="acircumflexacute",
  ["description"]="LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x00E2, 0x0301 },
  ["uccode"]=0x1EA4,
  ["unicodeslot"]=0x1EA5, -- ấ
 },
 [0x1EA6]={
  ["category"]="lu",
  ["contextname"]="Acircumflexgrave",
  ["description"]="LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE",
  ["lccode"]=0x1EA7,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x00C2, 0x0300 },
  ["unicodeslot"]=0x1EA6, -- Ầ
 },
 [0x1EA7]={
  ["category"]="ll",
  ["contextname"]="acircumflexgrave",
  ["description"]="LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x00E2, 0x0300 },
  ["uccode"]=0x1EA6,
  ["unicodeslot"]=0x1EA7, -- ầ
 },
 [0x1EA8]={
  ["category"]="lu",
  ["contextname"]="Acircumflexhook",
  ["description"]="LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
  ["lccode"]=0x1EA9,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x00C2, 0x0309 },
  ["unicodeslot"]=0x1EA8, -- Ẩ
 },
 [0x1EA9]={
  ["category"]="ll",
  ["contextname"]="acircumflexhook",
  ["description"]="LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x00E2, 0x0309 },
  ["uccode"]=0x1EA8,
  ["unicodeslot"]=0x1EA9, -- ẩ
 },
 [0x1EAA]={
  ["category"]="lu",
  ["contextname"]="Acircumflextilde",
  ["description"]="LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE",
  ["lccode"]=0x1EAB,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x00C2, 0x0303 },
  ["unicodeslot"]=0x1EAA, -- Ẫ
 },
 [0x1EAB]={
  ["category"]="ll",
  ["contextname"]="acircumflextilde",
  ["description"]="LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x00E2, 0x0303 },
  ["uccode"]=0x1EAA,
  ["unicodeslot"]=0x1EAB, -- ẫ
 },
 [0x1EAC]={
  ["category"]="lu",
  ["contextname"]="Acircumflexdotbelow",
  ["description"]="LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
  ["lccode"]=0x1EAD,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x1EA0, 0x0302 },
  ["unicodeslot"]=0x1EAC, -- Ậ
 },
 [0x1EAD]={
  ["category"]="ll",
  ["contextname"]="acircumflexdotbelow",
  ["description"]="LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x1EA1, 0x0302 },
  ["uccode"]=0x1EAC,
  ["unicodeslot"]=0x1EAD, -- ậ
 },
 [0x1EAE]={
  ["category"]="lu",
  ["contextname"]="Abreveacute",
  ["description"]="LATIN CAPITAL LETTER A WITH BREVE AND ACUTE",
  ["lccode"]=0x1EAF,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0102, 0x0301 },
  ["unicodeslot"]=0x1EAE, -- Ắ
 },
 [0x1EAF]={
  ["category"]="ll",
  ["contextname"]="abreveacute",
  ["description"]="LATIN SMALL LETTER A WITH BREVE AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0103, 0x0301 },
  ["uccode"]=0x1EAE,
  ["unicodeslot"]=0x1EAF, -- ắ
 },
 [0x1EB0]={
  ["category"]="lu",
  ["contextname"]="Abrevegrave",
  ["description"]="LATIN CAPITAL LETTER A WITH BREVE AND GRAVE",
  ["lccode"]=0x1EB1,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0102, 0x0300 },
  ["unicodeslot"]=0x1EB0, -- Ằ
 },
 [0x1EB1]={
  ["category"]="ll",
  ["contextname"]="abrevegrave",
  ["description"]="LATIN SMALL LETTER A WITH BREVE AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0103, 0x0300 },
  ["uccode"]=0x1EB0,
  ["unicodeslot"]=0x1EB1, -- ằ
 },
 [0x1EB2]={
  ["category"]="lu",
  ["contextname"]="Abrevehook",
  ["description"]="LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE",
  ["lccode"]=0x1EB3,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0102, 0x0309 },
  ["unicodeslot"]=0x1EB2, -- Ẳ
 },
 [0x1EB3]={
  ["category"]="ll",
  ["contextname"]="abrevehook",
  ["description"]="LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0103, 0x0309 },
  ["uccode"]=0x1EB2,
  ["unicodeslot"]=0x1EB3, -- ẳ
 },
 [0x1EB4]={
  ["category"]="lu",
  ["contextname"]="Abrevetilde",
  ["description"]="LATIN CAPITAL LETTER A WITH BREVE AND TILDE",
  ["lccode"]=0x1EB5,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x0102, 0x0303 },
  ["unicodeslot"]=0x1EB4, -- Ẵ
 },
 [0x1EB5]={
  ["category"]="ll",
  ["contextname"]="abrevetilde",
  ["description"]="LATIN SMALL LETTER A WITH BREVE AND TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x0103, 0x0303 },
  ["uccode"]=0x1EB4,
  ["unicodeslot"]=0x1EB5, -- ẵ
 },
 [0x1EB6]={
  ["category"]="lu",
  ["contextname"]="Abrevedotbelow",
  ["description"]="LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW",
  ["lccode"]=0x1EB7,
  ["linebreak"]="al",
  ["shcode"]=0x0041,
  ["specials"]={ "char", 0x1EA0, 0x0306 },
  ["unicodeslot"]=0x1EB6, -- Ặ
 },
 [0x1EB7]={
  ["category"]="ll",
  ["contextname"]="abrevedotbelow",
  ["description"]="LATIN SMALL LETTER A WITH BREVE AND DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0061,
  ["specials"]={ "char", 0x1EA1, 0x0306 },
  ["uccode"]=0x1EB6,
  ["unicodeslot"]=0x1EB7, -- ặ
 },
 [0x1EB8]={
  ["category"]="lu",
  ["contextname"]="Edotbelow",
  ["description"]="LATIN CAPITAL LETTER E WITH DOT BELOW",
  ["lccode"]=0x1EB9,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0323 },
  ["unicodeslot"]=0x1EB8, -- Ẹ
 },
 [0x1EB9]={
  ["category"]="ll",
  ["contextname"]="edotbelow",
  ["description"]="LATIN SMALL LETTER E WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0323 },
  ["uccode"]=0x1EB8,
  ["unicodeslot"]=0x1EB9, -- ẹ
 },
 [0x1EBA]={
  ["category"]="lu",
  ["contextname"]="Ehook",
  ["description"]="LATIN CAPITAL LETTER E WITH HOOK ABOVE",
  ["lccode"]=0x1EBB,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0309 },
  ["unicodeslot"]=0x1EBA, -- Ẻ
 },
 [0x1EBB]={
  ["category"]="ll",
  ["contextname"]="ehook",
  ["description"]="LATIN SMALL LETTER E WITH HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0309 },
  ["uccode"]=0x1EBA,
  ["unicodeslot"]=0x1EBB, -- ẻ
 },
 [0x1EBC]={
  ["category"]="lu",
  ["contextname"]="Etilde",
  ["description"]="LATIN CAPITAL LETTER E WITH TILDE",
  ["lccode"]=0x1EBD,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x0045, 0x0303 },
  ["unicodeslot"]=0x1EBC, -- Ẽ
 },
 [0x1EBD]={
  ["category"]="ll",
  ["contextname"]="etilde",
  ["description"]="LATIN SMALL LETTER E WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x0065, 0x0303 },
  ["uccode"]=0x1EBC,
  ["unicodeslot"]=0x1EBD, -- ẽ
 },
 [0x1EBE]={
  ["category"]="lu",
  ["contextname"]="Ecircumflexacute",
  ["description"]="LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE",
  ["lccode"]=0x1EBF,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x00CA, 0x0301 },
  ["unicodeslot"]=0x1EBE, -- Ế
 },
 [0x1EBF]={
  ["category"]="ll",
  ["contextname"]="ecircumflexacute",
  ["description"]="LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x00EA, 0x0301 },
  ["uccode"]=0x1EBE,
  ["unicodeslot"]=0x1EBF, -- ế
 },
 [0x1EC0]={
  ["category"]="lu",
  ["contextname"]="Ecircumflexgrave",
  ["description"]="LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE",
  ["lccode"]=0x1EC1,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x00CA, 0x0300 },
  ["unicodeslot"]=0x1EC0, -- Ề
 },
 [0x1EC1]={
  ["category"]="ll",
  ["contextname"]="ecircumflexgrave",
  ["description"]="LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x00EA, 0x0300 },
  ["uccode"]=0x1EC0,
  ["unicodeslot"]=0x1EC1, -- ề
 },
 [0x1EC2]={
  ["category"]="lu",
  ["contextname"]="Ecircumflexhook",
  ["description"]="LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
  ["lccode"]=0x1EC3,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x00CA, 0x0309 },
  ["unicodeslot"]=0x1EC2, -- Ể
 },
 [0x1EC3]={
  ["category"]="ll",
  ["contextname"]="ecircumflexhook",
  ["description"]="LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x00EA, 0x0309 },
  ["uccode"]=0x1EC2,
  ["unicodeslot"]=0x1EC3, -- ể
 },
 [0x1EC4]={
  ["category"]="lu",
  ["contextname"]="Ecircumflextilde",
  ["description"]="LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE",
  ["lccode"]=0x1EC5,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x00CA, 0x0303 },
  ["unicodeslot"]=0x1EC4, -- Ễ
 },
 [0x1EC5]={
  ["category"]="ll",
  ["contextname"]="ecircumflextilde",
  ["description"]="LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x00EA, 0x0303 },
  ["uccode"]=0x1EC4,
  ["unicodeslot"]=0x1EC5, -- ễ
 },
 [0x1EC6]={
  ["category"]="lu",
  ["contextname"]="Ecircumflexdotbelow",
  ["description"]="LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
  ["lccode"]=0x1EC7,
  ["linebreak"]="al",
  ["shcode"]=0x0045,
  ["specials"]={ "char", 0x1EB8, 0x0302 },
  ["unicodeslot"]=0x1EC6, -- Ệ
 },
 [0x1EC7]={
  ["category"]="ll",
  ["contextname"]="ecircumflexdotbelow",
  ["description"]="LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0065,
  ["specials"]={ "char", 0x1EB9, 0x0302 },
  ["uccode"]=0x1EC6,
  ["unicodeslot"]=0x1EC7, -- ệ
 },
 [0x1EC8]={
  ["category"]="lu",
  ["contextname"]="Ihook",
  ["description"]="LATIN CAPITAL LETTER I WITH HOOK ABOVE",
  ["lccode"]=0x1EC9,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0309 },
  ["unicodeslot"]=0x1EC8, -- Ỉ
 },
 [0x1EC9]={
  ["category"]="ll",
  ["contextname"]="ihook",
  ["description"]="LATIN SMALL LETTER I WITH HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0309 },
  ["uccode"]=0x1EC8,
  ["unicodeslot"]=0x1EC9, -- ỉ
 },
 [0x1ECA]={
  ["category"]="lu",
  ["contextname"]="Idotbelow",
  ["description"]="LATIN CAPITAL LETTER I WITH DOT BELOW",
  ["lccode"]=0x1ECB,
  ["linebreak"]="al",
  ["shcode"]=0x0049,
  ["specials"]={ "char", 0x0049, 0x0323 },
  ["unicodeslot"]=0x1ECA, -- Ị
 },
 [0x1ECB]={
  ["category"]="ll",
  ["contextname"]="idotbelow",
  ["description"]="LATIN SMALL LETTER I WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0069,
  ["specials"]={ "char", 0x0069, 0x0323 },
  ["uccode"]=0x1ECA,
  ["unicodeslot"]=0x1ECB, -- ị
 },
 [0x1ECC]={
  ["category"]="lu",
  ["contextname"]="Odotbelow",
  ["description"]="LATIN CAPITAL LETTER O WITH DOT BELOW",
  ["lccode"]=0x1ECD,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0323 },
  ["unicodeslot"]=0x1ECC, -- Ọ
 },
 [0x1ECD]={
  ["category"]="ll",
  ["contextname"]="odotbelow",
  ["description"]="LATIN SMALL LETTER O WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0323 },
  ["uccode"]=0x1ECC,
  ["unicodeslot"]=0x1ECD, -- ọ
 },
 [0x1ECE]={
  ["category"]="lu",
  ["contextname"]="Ohook",
  ["description"]="LATIN CAPITAL LETTER O WITH HOOK ABOVE",
  ["lccode"]=0x1ECF,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x004F, 0x0309 },
  ["unicodeslot"]=0x1ECE, -- Ỏ
 },
 [0x1ECF]={
  ["category"]="ll",
  ["contextname"]="ohook",
  ["description"]="LATIN SMALL LETTER O WITH HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x006F, 0x0309 },
  ["uccode"]=0x1ECE,
  ["unicodeslot"]=0x1ECF, -- ỏ
 },
 [0x1ED0]={
  ["category"]="lu",
  ["contextname"]="Ocircumflexacute",
  ["description"]="LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE",
  ["lccode"]=0x1ED1,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D4, 0x0301 },
  ["unicodeslot"]=0x1ED0, -- Ố
 },
 [0x1ED1]={
  ["category"]="ll",
  ["contextname"]="ocircumflexacute",
  ["description"]="LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F4, 0x0301 },
  ["uccode"]=0x1ED0,
  ["unicodeslot"]=0x1ED1, -- ố
 },
 [0x1ED2]={
  ["category"]="lu",
  ["contextname"]="Ocircumflexgrave",
  ["description"]="LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE",
  ["lccode"]=0x1ED3,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D4, 0x0300 },
  ["unicodeslot"]=0x1ED2, -- Ồ
 },
 [0x1ED3]={
  ["category"]="ll",
  ["contextname"]="ocircumflexgrave",
  ["description"]="LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F4, 0x0300 },
  ["uccode"]=0x1ED2,
  ["unicodeslot"]=0x1ED3, -- ồ
 },
 [0x1ED4]={
  ["category"]="lu",
  ["contextname"]="Ocircumflexhook",
  ["description"]="LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
  ["lccode"]=0x1ED5,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D4, 0x0309 },
  ["unicodeslot"]=0x1ED4, -- Ổ
 },
 [0x1ED5]={
  ["category"]="ll",
  ["contextname"]="ocircumflexhook",
  ["description"]="LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F4, 0x0309 },
  ["uccode"]=0x1ED4,
  ["unicodeslot"]=0x1ED5, -- ổ
 },
 [0x1ED6]={
  ["category"]="lu",
  ["contextname"]="Ocircumflextilde",
  ["description"]="LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE",
  ["lccode"]=0x1ED7,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x00D4, 0x0303 },
  ["unicodeslot"]=0x1ED6, -- Ỗ
 },
 [0x1ED7]={
  ["category"]="ll",
  ["contextname"]="ocircumflextilde",
  ["description"]="LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x00F4, 0x0303 },
  ["uccode"]=0x1ED6,
  ["unicodeslot"]=0x1ED7, -- ỗ
 },
 [0x1ED8]={
  ["category"]="lu",
  ["contextname"]="Ocircumflexdotbelow",
  ["description"]="LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
  ["lccode"]=0x1ED9,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x1ECC, 0x0302 },
  ["unicodeslot"]=0x1ED8, -- Ộ
 },
 [0x1ED9]={
  ["category"]="ll",
  ["contextname"]="ocircumflexdotbelow",
  ["description"]="LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x1ECD, 0x0302 },
  ["uccode"]=0x1ED8,
  ["unicodeslot"]=0x1ED9, -- ộ
 },
 [0x1EDA]={
  ["category"]="lu",
  ["contextname"]="Ohornacute",
  ["description"]="LATIN CAPITAL LETTER O WITH HORN AND ACUTE",
  ["lccode"]=0x1EDB,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x01A0, 0x0301 },
  ["unicodeslot"]=0x1EDA, -- Ớ
 },
 [0x1EDB]={
  ["category"]="ll",
  ["contextname"]="ohornacute",
  ["description"]="LATIN SMALL LETTER O WITH HORN AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x01A1, 0x0301 },
  ["uccode"]=0x1EDA,
  ["unicodeslot"]=0x1EDB, -- ớ
 },
 [0x1EDC]={
  ["category"]="lu",
  ["contextname"]="Ohorngrave",
  ["description"]="LATIN CAPITAL LETTER O WITH HORN AND GRAVE",
  ["lccode"]=0x1EDD,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x01A0, 0x0300 },
  ["unicodeslot"]=0x1EDC, -- Ờ
 },
 [0x1EDD]={
  ["category"]="ll",
  ["contextname"]="ohorngrave",
  ["description"]="LATIN SMALL LETTER O WITH HORN AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x01A1, 0x0300 },
  ["uccode"]=0x1EDC,
  ["unicodeslot"]=0x1EDD, -- ờ
 },
 [0x1EDE]={
  ["category"]="lu",
  ["contextname"]="Ohornhook",
  ["description"]="LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE",
  ["lccode"]=0x1EDF,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x01A0, 0x0309 },
  ["unicodeslot"]=0x1EDE, -- Ở
 },
 [0x1EDF]={
  ["category"]="ll",
  ["contextname"]="ohornhook",
  ["description"]="LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x01A1, 0x0309 },
  ["uccode"]=0x1EDE,
  ["unicodeslot"]=0x1EDF, -- ở
 },
 [0x1EE0]={
  ["category"]="lu",
  ["contextname"]="Ohorntilde",
  ["description"]="LATIN CAPITAL LETTER O WITH HORN AND TILDE",
  ["lccode"]=0x1EE1,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x01A0, 0x0303 },
  ["unicodeslot"]=0x1EE0, -- Ỡ
 },
 [0x1EE1]={
  ["category"]="ll",
  ["contextname"]="ohorntilde",
  ["description"]="LATIN SMALL LETTER O WITH HORN AND TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x01A1, 0x0303 },
  ["uccode"]=0x1EE0,
  ["unicodeslot"]=0x1EE1, -- ỡ
 },
 [0x1EE2]={
  ["category"]="lu",
  ["contextname"]="Ohorndotbelow",
  ["description"]="LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW",
  ["lccode"]=0x1EE3,
  ["linebreak"]="al",
  ["shcode"]=0x004F,
  ["specials"]={ "char", 0x01A0, 0x0323 },
  ["unicodeslot"]=0x1EE2, -- Ợ
 },
 [0x1EE3]={
  ["category"]="ll",
  ["contextname"]="ohorndotbelow",
  ["description"]="LATIN SMALL LETTER O WITH HORN AND DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x006F,
  ["specials"]={ "char", 0x01A1, 0x0323 },
  ["uccode"]=0x1EE2,
  ["unicodeslot"]=0x1EE3, -- ợ
 },
 [0x1EE4]={
  ["category"]="lu",
  ["contextname"]="Udotbelow",
  ["description"]="LATIN CAPITAL LETTER U WITH DOT BELOW",
  ["lccode"]=0x1EE5,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0323 },
  ["unicodeslot"]=0x1EE4, -- Ụ
 },
 [0x1EE5]={
  ["category"]="ll",
  ["contextname"]="udotbelow",
  ["description"]="LATIN SMALL LETTER U WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0323 },
  ["uccode"]=0x1EE4,
  ["unicodeslot"]=0x1EE5, -- ụ
 },
 [0x1EE6]={
  ["category"]="lu",
  ["contextname"]="Uhook",
  ["description"]="LATIN CAPITAL LETTER U WITH HOOK ABOVE",
  ["lccode"]=0x1EE7,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x0055, 0x0309 },
  ["unicodeslot"]=0x1EE6, -- Ủ
 },
 [0x1EE7]={
  ["category"]="ll",
  ["contextname"]="uhook",
  ["description"]="LATIN SMALL LETTER U WITH HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x0075, 0x0309 },
  ["uccode"]=0x1EE6,
  ["unicodeslot"]=0x1EE7, -- ủ
 },
 [0x1EE8]={
  ["category"]="lu",
  ["contextname"]="Uhornacute",
  ["description"]="LATIN CAPITAL LETTER U WITH HORN AND ACUTE",
  ["lccode"]=0x1EE9,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x01AF, 0x0301 },
  ["unicodeslot"]=0x1EE8, -- Ứ
 },
 [0x1EE9]={
  ["category"]="ll",
  ["contextname"]="uhornacute",
  ["description"]="LATIN SMALL LETTER U WITH HORN AND ACUTE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x01B0, 0x0301 },
  ["uccode"]=0x1EE8,
  ["unicodeslot"]=0x1EE9, -- ứ
 },
 [0x1EEA]={
  ["category"]="lu",
  ["contextname"]="Uhorngrave",
  ["description"]="LATIN CAPITAL LETTER U WITH HORN AND GRAVE",
  ["lccode"]=0x1EEB,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x01AF, 0x0300 },
  ["unicodeslot"]=0x1EEA, -- Ừ
 },
 [0x1EEB]={
  ["category"]="ll",
  ["contextname"]="uhorngrave",
  ["description"]="LATIN SMALL LETTER U WITH HORN AND GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x01B0, 0x0300 },
  ["uccode"]=0x1EEA,
  ["unicodeslot"]=0x1EEB, -- ừ
 },
 [0x1EEC]={
  ["category"]="lu",
  ["contextname"]="Uhornhook",
  ["description"]="LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE",
  ["lccode"]=0x1EED,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x01AF, 0x0309 },
  ["unicodeslot"]=0x1EEC, -- Ử
 },
 [0x1EED]={
  ["category"]="ll",
  ["contextname"]="uhornhook",
  ["description"]="LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x01B0, 0x0309 },
  ["uccode"]=0x1EEC,
  ["unicodeslot"]=0x1EED, -- ử
 },
 [0x1EEE]={
  ["category"]="lu",
  ["contextname"]="Uhorntilde",
  ["description"]="LATIN CAPITAL LETTER U WITH HORN AND TILDE",
  ["lccode"]=0x1EEF,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x01AF, 0x0303 },
  ["unicodeslot"]=0x1EEE, -- Ữ
 },
 [0x1EEF]={
  ["category"]="ll",
  ["contextname"]="uhorntilde",
  ["description"]="LATIN SMALL LETTER U WITH HORN AND TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x01B0, 0x0303 },
  ["uccode"]=0x1EEE,
  ["unicodeslot"]=0x1EEF, -- ữ
 },
 [0x1EF0]={
  ["category"]="lu",
  ["contextname"]="Uhorndotbelow",
  ["description"]="LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW",
  ["lccode"]=0x1EF1,
  ["linebreak"]="al",
  ["shcode"]=0x0055,
  ["specials"]={ "char", 0x01AF, 0x0323 },
  ["unicodeslot"]=0x1EF0, -- Ự
 },
 [0x1EF1]={
  ["category"]="ll",
  ["contextname"]="uhorndotbelow",
  ["description"]="LATIN SMALL LETTER U WITH HORN AND DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0075,
  ["specials"]={ "char", 0x01B0, 0x0323 },
  ["uccode"]=0x1EF0,
  ["unicodeslot"]=0x1EF1, -- ự
 },
 [0x1EF2]={
  ["adobename"]="Ygrave",
  ["category"]="lu",
  ["contextname"]="Ygrave",
  ["description"]="LATIN CAPITAL LETTER Y WITH GRAVE",
  ["lccode"]=0x1EF3,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0300 },
  ["unicodeslot"]=0x1EF2, -- Ỳ
 },
 [0x1EF3]={
  ["adobename"]="ygrave",
  ["category"]="ll",
  ["contextname"]="ygrave",
  ["description"]="LATIN SMALL LETTER Y WITH GRAVE",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0300 },
  ["uccode"]=0x1EF2,
  ["unicodeslot"]=0x1EF3, -- ỳ
 },
 [0x1EF4]={
  ["category"]="lu",
  ["contextname"]="Ydotbelow",
  ["description"]="LATIN CAPITAL LETTER Y WITH DOT BELOW",
  ["lccode"]=0x1EF5,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0323 },
  ["unicodeslot"]=0x1EF4, -- Ỵ
 },
 [0x1EF5]={
  ["category"]="ll",
  ["contextname"]="ydotbelow",
  ["description"]="LATIN SMALL LETTER Y WITH DOT BELOW",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0323 },
  ["uccode"]=0x1EF4,
  ["unicodeslot"]=0x1EF5, -- ỵ
 },
 [0x1EF6]={
  ["category"]="lu",
  ["contextname"]="Yhook",
  ["description"]="LATIN CAPITAL LETTER Y WITH HOOK ABOVE",
  ["lccode"]=0x1EF7,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0309 },
  ["unicodeslot"]=0x1EF6, -- Ỷ
 },
 [0x1EF7]={
  ["category"]="ll",
  ["contextname"]="yhook",
  ["description"]="LATIN SMALL LETTER Y WITH HOOK ABOVE",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0309 },
  ["uccode"]=0x1EF6,
  ["unicodeslot"]=0x1EF7, -- ỷ
 },
 [0x1EF8]={
  ["category"]="lu",
  ["contextname"]="Ytilde",
  ["description"]="LATIN CAPITAL LETTER Y WITH TILDE",
  ["lccode"]=0x1EF9,
  ["linebreak"]="al",
  ["shcode"]=0x0059,
  ["specials"]={ "char", 0x0059, 0x0303 },
  ["unicodeslot"]=0x1EF8, -- Ỹ
 },
 [0x1EF9]={
  ["category"]="ll",
  ["contextname"]="ytilde",
  ["description"]="LATIN SMALL LETTER Y WITH TILDE",
  ["linebreak"]="al",
  ["shcode"]=0x0079,
  ["specials"]={ "char", 0x0079, 0x0303 },
  ["uccode"]=0x1EF8,
  ["unicodeslot"]=0x1EF9, -- ỹ
 },
 [0x1F00]={
  ["category"]="ll",
  ["contextname"]="greekalphapsili",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0313 },
  ["uccode"]=0x1F08,
  ["unicodeslot"]=0x1F00, -- ἀ
 },
 [0x1F01]={
  ["category"]="ll",
  ["contextname"]="greekalphadasia",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0314 },
  ["uccode"]=0x1F09,
  ["unicodeslot"]=0x1F01, -- ἁ
 },
 [0x1F02]={
  ["category"]="ll",
  ["contextname"]="greekalphapsilivaria",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F00, 0x0300 },
  ["uccode"]=0x1F0A,
  ["unicodeslot"]=0x1F02, -- ἂ
 },
 [0x1F03]={
  ["category"]="ll",
  ["contextname"]="greekalphadasiavaria",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F01, 0x0300 },
  ["uccode"]=0x1F0B,
  ["unicodeslot"]=0x1F03, -- ἃ
 },
 [0x1F04]={
  ["category"]="ll",
  ["contextname"]="greekalphapsilitonos",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F00, 0x0301 },
  ["uccode"]=0x1F0C,
  ["unicodeslot"]=0x1F04, -- ἄ
 },
 [0x1F05]={
  ["category"]="ll",
  ["contextname"]="greekalphadasiatonos",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F01, 0x0301 },
  ["uccode"]=0x1F0D,
  ["unicodeslot"]=0x1F05, -- ἅ
 },
 [0x1F06]={
  ["category"]="ll",
  ["contextname"]="greekalphapsiliperispomeni",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F00, 0x0342 },
  ["uccode"]=0x1F0E,
  ["unicodeslot"]=0x1F06, -- ἆ
 },
 [0x1F07]={
  ["category"]="ll",
  ["contextname"]="greekalphadasiaperispomeni",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F01, 0x0342 },
  ["uccode"]=0x1F0F,
  ["unicodeslot"]=0x1F07, -- ἇ
 },
 [0x1F08]={
  ["category"]="lu",
  ["contextname"]="greekAlphapsili",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI",
  ["lccode"]=0x1F00,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0391, 0x0313 },
  ["unicodeslot"]=0x1F08, -- Ἀ
 },
 [0x1F09]={
  ["category"]="lu",
  ["contextname"]="greekAlphadasia",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA",
  ["lccode"]=0x1F01,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0391, 0x0314 },
  ["unicodeslot"]=0x1F09, -- Ἁ
 },
 [0x1F0A]={
  ["category"]="lu",
  ["contextname"]="greekAlphapsilivaria",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA",
  ["lccode"]=0x1F02,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F08, 0x0300 },
  ["unicodeslot"]=0x1F0A, -- Ἂ
 },
 [0x1F0B]={
  ["category"]="lu",
  ["contextname"]="greekAlphadasiavaria",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA",
  ["lccode"]=0x1F03,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F09, 0x0300 },
  ["unicodeslot"]=0x1F0B, -- Ἃ
 },
 [0x1F0C]={
  ["category"]="lu",
  ["contextname"]="greekAlphapsilitonos",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA",
  ["lccode"]=0x1F04,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F08, 0x0301 },
  ["unicodeslot"]=0x1F0C, -- Ἄ
 },
 [0x1F0D]={
  ["category"]="lu",
  ["contextname"]="greekAlphadasiatonos",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA",
  ["lccode"]=0x1F05,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F09, 0x0301 },
  ["unicodeslot"]=0x1F0D, -- Ἅ
 },
 [0x1F0E]={
  ["category"]="lu",
  ["contextname"]="greekAlphapsiliperispomeni",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI",
  ["lccode"]=0x1F06,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F08, 0x0342 },
  ["unicodeslot"]=0x1F0E, -- Ἆ
 },
 [0x1F0F]={
  ["category"]="lu",
  ["contextname"]="greekAlphadasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI",
  ["lccode"]=0x1F07,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F09, 0x0342 },
  ["unicodeslot"]=0x1F0F, -- Ἇ
 },
 [0x1F10]={
  ["category"]="ll",
  ["contextname"]="greekepsilonpsili",
  ["description"]="GREEK SMALL LETTER EPSILON WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x03B5, 0x0313 },
  ["uccode"]=0x1F18,
  ["unicodeslot"]=0x1F10, -- ἐ
 },
 [0x1F11]={
  ["category"]="ll",
  ["contextname"]="greekepsilondasia",
  ["description"]="GREEK SMALL LETTER EPSILON WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x03B5, 0x0314 },
  ["uccode"]=0x1F19,
  ["unicodeslot"]=0x1F11, -- ἑ
 },
 [0x1F12]={
  ["category"]="ll",
  ["contextname"]="greekepsilonpsilivaria",
  ["description"]="GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x1F10, 0x0300 },
  ["uccode"]=0x1F1A,
  ["unicodeslot"]=0x1F12, -- ἒ
 },
 [0x1F13]={
  ["category"]="ll",
  ["contextname"]="greekepsilondasiavaria",
  ["description"]="GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x1F11, 0x0300 },
  ["uccode"]=0x1F1B,
  ["unicodeslot"]=0x1F13, -- ἓ
 },
 [0x1F14]={
  ["category"]="ll",
  ["contextname"]="greekepsilonpsilitonos",
  ["description"]="GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x1F10, 0x0301 },
  ["uccode"]=0x1F1C,
  ["unicodeslot"]=0x1F14, -- ἔ
 },
 [0x1F15]={
  ["category"]="ll",
  ["contextname"]="greekepsilondasiatonos",
  ["description"]="GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x1F11, 0x0301 },
  ["uccode"]=0x1F1D,
  ["unicodeslot"]=0x1F15, -- ἕ
 },
 [0x1F18]={
  ["category"]="lu",
  ["contextname"]="greekEpsilonpsili",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH PSILI",
  ["lccode"]=0x1F10,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x0395, 0x0313 },
  ["unicodeslot"]=0x1F18, -- Ἐ
 },
 [0x1F19]={
  ["category"]="lu",
  ["contextname"]="greekEpsilondasia",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH DASIA",
  ["lccode"]=0x1F11,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x0395, 0x0314 },
  ["unicodeslot"]=0x1F19, -- Ἑ
 },
 [0x1F1A]={
  ["category"]="lu",
  ["contextname"]="greekEpsilonpsilivaria",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA",
  ["lccode"]=0x1F12,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x1F18, 0x0300 },
  ["unicodeslot"]=0x1F1A, -- Ἒ
 },
 [0x1F1B]={
  ["category"]="lu",
  ["contextname"]="greekEpsilondasiavaria",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA",
  ["lccode"]=0x1F13,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x1F19, 0x0300 },
  ["unicodeslot"]=0x1F1B, -- Ἓ
 },
 [0x1F1C]={
  ["category"]="lu",
  ["contextname"]="greekEpsilonpsilitonos",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA",
  ["lccode"]=0x1F14,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x1F18, 0x0301 },
  ["unicodeslot"]=0x1F1C, -- Ἔ
 },
 [0x1F1D]={
  ["category"]="lu",
  ["contextname"]="greekEpsilondasiatonos",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA",
  ["lccode"]=0x1F15,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x1F19, 0x0301 },
  ["unicodeslot"]=0x1F1D, -- Ἕ
 },
 [0x1F20]={
  ["category"]="ll",
  ["contextname"]="greeketapsili",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03B7, 0x0313 },
  ["uccode"]=0x1F28,
  ["unicodeslot"]=0x1F20, -- ἠ
 },
 [0x1F21]={
  ["category"]="ll",
  ["contextname"]="greeketadasia",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03B7, 0x0314 },
  ["uccode"]=0x1F29,
  ["unicodeslot"]=0x1F21, -- ἡ
 },
 [0x1F22]={
  ["category"]="ll",
  ["contextname"]="greeketapsilivaria",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F20, 0x0300 },
  ["uccode"]=0x1F2A,
  ["unicodeslot"]=0x1F22, -- ἢ
 },
 [0x1F23]={
  ["category"]="ll",
  ["contextname"]="greeketadasiavaria",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F21, 0x0300 },
  ["uccode"]=0x1F2B,
  ["unicodeslot"]=0x1F23, -- ἣ
 },
 [0x1F24]={
  ["category"]="ll",
  ["contextname"]="greeketapsilitonos",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F20, 0x0301 },
  ["uccode"]=0x1F2C,
  ["unicodeslot"]=0x1F24, -- ἤ
 },
 [0x1F25]={
  ["category"]="ll",
  ["contextname"]="greeketadasiatonos",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F21, 0x0301 },
  ["uccode"]=0x1F2D,
  ["unicodeslot"]=0x1F25, -- ἥ
 },
 [0x1F26]={
  ["category"]="ll",
  ["contextname"]="greeketapsiliperispomeni",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F20, 0x0342 },
  ["uccode"]=0x1F2E,
  ["unicodeslot"]=0x1F26, -- ἦ
 },
 [0x1F27]={
  ["category"]="ll",
  ["contextname"]="greeketadasiaperispomeni",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F21, 0x0342 },
  ["uccode"]=0x1F2F,
  ["unicodeslot"]=0x1F27, -- ἧ
 },
 [0x1F28]={
  ["category"]="lu",
  ["contextname"]="greekEtapsili",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI",
  ["lccode"]=0x1F20,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x0397, 0x0313 },
  ["unicodeslot"]=0x1F28, -- Ἠ
 },
 [0x1F29]={
  ["category"]="lu",
  ["contextname"]="greekEtadasia",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA",
  ["lccode"]=0x1F21,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x0397, 0x0314 },
  ["unicodeslot"]=0x1F29, -- Ἡ
 },
 [0x1F2A]={
  ["category"]="lu",
  ["contextname"]="greekEtapsilivaria",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA",
  ["lccode"]=0x1F22,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F28, 0x0300 },
  ["unicodeslot"]=0x1F2A, -- Ἢ
 },
 [0x1F2B]={
  ["category"]="lu",
  ["contextname"]="greekEtadasiavaria",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA",
  ["lccode"]=0x1F23,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F29, 0x0300 },
  ["unicodeslot"]=0x1F2B, -- Ἣ
 },
 [0x1F2C]={
  ["category"]="lu",
  ["contextname"]="greekEtapsilitonos",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA",
  ["lccode"]=0x1F24,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F28, 0x0301 },
  ["unicodeslot"]=0x1F2C, -- Ἤ
 },
 [0x1F2D]={
  ["category"]="lu",
  ["contextname"]="greekEtadasiatonos",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA",
  ["lccode"]=0x1F25,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F29, 0x0301 },
  ["unicodeslot"]=0x1F2D, -- Ἥ
 },
 [0x1F2E]={
  ["category"]="lu",
  ["contextname"]="greekEtapsiliperispomeni",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI",
  ["lccode"]=0x1F26,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F28, 0x0342 },
  ["unicodeslot"]=0x1F2E, -- Ἦ
 },
 [0x1F2F]={
  ["category"]="lu",
  ["contextname"]="greekEtadasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI",
  ["lccode"]=0x1F27,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F29, 0x0342 },
  ["unicodeslot"]=0x1F2F, -- Ἧ
 },
 [0x1F30]={
  ["category"]="ll",
  ["contextname"]="greekiotapsili",
  ["description"]="GREEK SMALL LETTER IOTA WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0313 },
  ["uccode"]=0x1F38,
  ["unicodeslot"]=0x1F30, -- ἰ
 },
 [0x1F31]={
  ["category"]="ll",
  ["contextname"]="greekiotadasia",
  ["description"]="GREEK SMALL LETTER IOTA WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0314 },
  ["uccode"]=0x1F39,
  ["unicodeslot"]=0x1F31, -- ἱ
 },
 [0x1F32]={
  ["category"]="ll",
  ["contextname"]="greekiotapsilivaria",
  ["description"]="GREEK SMALL LETTER IOTA WITH PSILI AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x1F30, 0x0300 },
  ["uccode"]=0x1F3A,
  ["unicodeslot"]=0x1F32, -- ἲ
 },
 [0x1F33]={
  ["category"]="ll",
  ["contextname"]="greekiotadasiavaria",
  ["description"]="GREEK SMALL LETTER IOTA WITH DASIA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x1F31, 0x0300 },
  ["uccode"]=0x1F3B,
  ["unicodeslot"]=0x1F33, -- ἳ
 },
 [0x1F34]={
  ["category"]="ll",
  ["contextname"]="greekiotapsilitonos",
  ["description"]="GREEK SMALL LETTER IOTA WITH PSILI AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x1F30, 0x0301 },
  ["uccode"]=0x1F3C,
  ["unicodeslot"]=0x1F34, -- ἴ
 },
 [0x1F35]={
  ["category"]="ll",
  ["contextname"]="greekiotadasiatonos",
  ["description"]="GREEK SMALL LETTER IOTA WITH DASIA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x1F31, 0x0301 },
  ["uccode"]=0x1F3D,
  ["unicodeslot"]=0x1F35, -- ἵ
 },
 [0x1F36]={
  ["category"]="ll",
  ["contextname"]="greekiotapsiliperispomeni",
  ["description"]="GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x1F30, 0x0342 },
  ["uccode"]=0x1F3E,
  ["unicodeslot"]=0x1F36, -- ἶ
 },
 [0x1F37]={
  ["category"]="ll",
  ["contextname"]="greekiotadasiaperispomeni",
  ["description"]="GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x1F31, 0x0342 },
  ["uccode"]=0x1F3F,
  ["unicodeslot"]=0x1F37, -- ἷ
 },
 [0x1F38]={
  ["category"]="lu",
  ["contextname"]="greekIotapsili",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH PSILI",
  ["lccode"]=0x1F30,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x0399, 0x0313 },
  ["unicodeslot"]=0x1F38, -- Ἰ
 },
 [0x1F39]={
  ["category"]="lu",
  ["contextname"]="greekIotadasia",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH DASIA",
  ["lccode"]=0x1F31,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x0399, 0x0314 },
  ["unicodeslot"]=0x1F39, -- Ἱ
 },
 [0x1F3A]={
  ["category"]="lu",
  ["contextname"]="greekIotapsilivaria",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA",
  ["lccode"]=0x1F32,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x1F38, 0x0300 },
  ["unicodeslot"]=0x1F3A, -- Ἲ
 },
 [0x1F3B]={
  ["category"]="lu",
  ["contextname"]="greekIotadasiavaria",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA",
  ["lccode"]=0x1F33,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x1F39, 0x0300 },
  ["unicodeslot"]=0x1F3B, -- Ἳ
 },
 [0x1F3C]={
  ["category"]="lu",
  ["contextname"]="greekIotapsilitonos",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA",
  ["lccode"]=0x1F34,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x1F38, 0x0301 },
  ["unicodeslot"]=0x1F3C, -- Ἴ
 },
 [0x1F3D]={
  ["category"]="lu",
  ["contextname"]="greekIotadasiatonos",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA",
  ["lccode"]=0x1F35,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x1F39, 0x0301 },
  ["unicodeslot"]=0x1F3D, -- Ἵ
 },
 [0x1F3E]={
  ["category"]="lu",
  ["contextname"]="greekIotapsiliperispomeni",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI",
  ["lccode"]=0x1F36,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x1F38, 0x0342 },
  ["unicodeslot"]=0x1F3E, -- Ἶ
 },
 [0x1F3F]={
  ["category"]="lu",
  ["contextname"]="greekIotadasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI",
  ["lccode"]=0x1F37,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x1F39, 0x0342 },
  ["unicodeslot"]=0x1F3F, -- Ἷ
 },
 [0x1F40]={
  ["category"]="ll",
  ["contextname"]="greekomicronpsili",
  ["description"]="GREEK SMALL LETTER OMICRON WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x03BF, 0x0313 },
  ["uccode"]=0x1F48,
  ["unicodeslot"]=0x1F40, -- ὀ
 },
 [0x1F41]={
  ["category"]="ll",
  ["contextname"]="greekomicrondasia",
  ["description"]="GREEK SMALL LETTER OMICRON WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x03BF, 0x0314 },
  ["uccode"]=0x1F49,
  ["unicodeslot"]=0x1F41, -- ὁ
 },
 [0x1F42]={
  ["category"]="ll",
  ["contextname"]="greekomicronpsilivaria",
  ["description"]="GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x1F40, 0x0300 },
  ["uccode"]=0x1F4A,
  ["unicodeslot"]=0x1F42, -- ὂ
 },
 [0x1F43]={
  ["category"]="ll",
  ["contextname"]="greekomicrondasiavaria",
  ["description"]="GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x1F41, 0x0300 },
  ["uccode"]=0x1F4B,
  ["unicodeslot"]=0x1F43, -- ὃ
 },
 [0x1F44]={
  ["category"]="ll",
  ["contextname"]="greekomicronpsilitonos",
  ["description"]="GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x1F40, 0x0301 },
  ["uccode"]=0x1F4C,
  ["unicodeslot"]=0x1F44, -- ὄ
 },
 [0x1F45]={
  ["category"]="ll",
  ["contextname"]="greekomicrondasiatonos",
  ["description"]="GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x1F41, 0x0301 },
  ["uccode"]=0x1F4D,
  ["unicodeslot"]=0x1F45, -- ὅ
 },
 [0x1F48]={
  ["category"]="lu",
  ["contextname"]="greekOmicronpsili",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH PSILI",
  ["lccode"]=0x1F40,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x039F, 0x0313 },
  ["unicodeslot"]=0x1F48, -- Ὀ
 },
 [0x1F49]={
  ["category"]="lu",
  ["contextname"]="greekOmicrondasia",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH DASIA",
  ["lccode"]=0x1F41,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x039F, 0x0314 },
  ["unicodeslot"]=0x1F49, -- Ὁ
 },
 [0x1F4A]={
  ["category"]="lu",
  ["contextname"]="greekOmicronpsilivaria",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA",
  ["lccode"]=0x1F42,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x1F48, 0x0300 },
  ["unicodeslot"]=0x1F4A, -- Ὂ
 },
 [0x1F4B]={
  ["category"]="lu",
  ["contextname"]="greekOmicrondasiavaria",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA",
  ["lccode"]=0x1F43,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x1F49, 0x0300 },
  ["unicodeslot"]=0x1F4B, -- Ὃ
 },
 [0x1F4C]={
  ["category"]="lu",
  ["contextname"]="greekOmicronpsilitonos",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA",
  ["lccode"]=0x1F44,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x1F48, 0x0301 },
  ["unicodeslot"]=0x1F4C, -- Ὄ
 },
 [0x1F4D]={
  ["category"]="lu",
  ["contextname"]="greekOmicrondasiatonos",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA",
  ["lccode"]=0x1F45,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x1F49, 0x0301 },
  ["unicodeslot"]=0x1F4D, -- Ὅ
 },
 [0x1F50]={
  ["category"]="ll",
  ["contextname"]="greekupsilonpsili",
  ["description"]="GREEK SMALL LETTER UPSILON WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0313 },
  ["unicodeslot"]=0x1F50, -- ὐ
 },
 [0x1F51]={
  ["category"]="ll",
  ["contextname"]="greekupsilondasia",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0314 },
  ["uccode"]=0x1F59,
  ["unicodeslot"]=0x1F51, -- ὑ
 },
 [0x1F52]={
  ["category"]="ll",
  ["contextname"]="greekupsilonpsilivaria",
  ["description"]="GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x1F50, 0x0300 },
  ["unicodeslot"]=0x1F52, -- ὒ
 },
 [0x1F53]={
  ["category"]="ll",
  ["contextname"]="greekupsilondasiavaria",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x1F51, 0x0300 },
  ["uccode"]=0x1F5B,
  ["unicodeslot"]=0x1F53, -- ὓ
 },
 [0x1F54]={
  ["category"]="ll",
  ["contextname"]="greekupsilonpsilitonos",
  ["description"]="GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x1F50, 0x0301 },
  ["unicodeslot"]=0x1F54, -- ὔ
 },
 [0x1F55]={
  ["category"]="ll",
  ["contextname"]="greekupsilondasiatonos",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x1F51, 0x0301 },
  ["uccode"]=0x1F5D,
  ["unicodeslot"]=0x1F55, -- ὕ
 },
 [0x1F56]={
  ["category"]="ll",
  ["contextname"]="greekupsilonpsiliperispomeni",
  ["description"]="GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x1F50, 0x0342 },
  ["unicodeslot"]=0x1F56, -- ὖ
 },
 [0x1F57]={
  ["category"]="ll",
  ["contextname"]="greekupsilondasiaperispomeni",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x1F51, 0x0342 },
  ["uccode"]=0x1F5F,
  ["unicodeslot"]=0x1F57, -- ὗ
 },
 [0x1F59]={
  ["category"]="lu",
  ["contextname"]="greekUpsilondasia",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH DASIA",
  ["lccode"]=0x1F51,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x03A5, 0x0314 },
  ["unicodeslot"]=0x1F59, -- Ὑ
 },
 [0x1F5B]={
  ["category"]="lu",
  ["contextname"]="greekUpsilondasiavaria",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA",
  ["lccode"]=0x1F53,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x1F59, 0x0300 },
  ["unicodeslot"]=0x1F5B, -- Ὓ
 },
 [0x1F5D]={
  ["category"]="lu",
  ["contextname"]="greekUpsilondasiatonos",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA",
  ["lccode"]=0x1F55,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x1F59, 0x0301 },
  ["unicodeslot"]=0x1F5D, -- Ὕ
 },
 [0x1F5F]={
  ["category"]="lu",
  ["contextname"]="greekUpsilondasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI",
  ["lccode"]=0x1F57,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x1F59, 0x0342 },
  ["unicodeslot"]=0x1F5F, -- Ὗ
 },
 [0x1F60]={
  ["category"]="ll",
  ["contextname"]="greekomegapsili",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03C9, 0x0313 },
  ["uccode"]=0x1F68,
  ["unicodeslot"]=0x1F60, -- ὠ
 },
 [0x1F61]={
  ["category"]="ll",
  ["contextname"]="greekomegadasia",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03C9, 0x0314 },
  ["uccode"]=0x1F69,
  ["unicodeslot"]=0x1F61, -- ὡ
 },
 [0x1F62]={
  ["category"]="ll",
  ["contextname"]="greekomegapsilivaria",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F60, 0x0300 },
  ["uccode"]=0x1F6A,
  ["unicodeslot"]=0x1F62, -- ὢ
 },
 [0x1F63]={
  ["category"]="ll",
  ["contextname"]="greekomegadasiavaria",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F61, 0x0300 },
  ["uccode"]=0x1F6B,
  ["unicodeslot"]=0x1F63, -- ὣ
 },
 [0x1F64]={
  ["category"]="ll",
  ["contextname"]="greekomegapsilitonos",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F60, 0x0301 },
  ["uccode"]=0x1F6C,
  ["unicodeslot"]=0x1F64, -- ὤ
 },
 [0x1F65]={
  ["category"]="ll",
  ["contextname"]="greekomegadasiatonos",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F61, 0x0301 },
  ["uccode"]=0x1F6D,
  ["unicodeslot"]=0x1F65, -- ὥ
 },
 [0x1F66]={
  ["category"]="ll",
  ["contextname"]="greekomegapsiliperispomeni",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F60, 0x0342 },
  ["uccode"]=0x1F6E,
  ["unicodeslot"]=0x1F66, -- ὦ
 },
 [0x1F67]={
  ["category"]="ll",
  ["contextname"]="greekomegadasiaperispomeni",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F61, 0x0342 },
  ["uccode"]=0x1F6F,
  ["unicodeslot"]=0x1F67, -- ὧ
 },
 [0x1F68]={
  ["category"]="lu",
  ["contextname"]="greekOmegapsili",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI",
  ["lccode"]=0x1F60,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x03A9, 0x0313 },
  ["unicodeslot"]=0x1F68, -- Ὠ
 },
 [0x1F69]={
  ["category"]="lu",
  ["contextname"]="greekOmegadasia",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA",
  ["lccode"]=0x1F61,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x03A9, 0x0314 },
  ["unicodeslot"]=0x1F69, -- Ὡ
 },
 [0x1F6A]={
  ["category"]="lu",
  ["contextname"]="greekOmegapsilivaria",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA",
  ["lccode"]=0x1F62,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F68, 0x0300 },
  ["unicodeslot"]=0x1F6A, -- Ὢ
 },
 [0x1F6B]={
  ["category"]="lu",
  ["contextname"]="greekOmegadasiavaria",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA",
  ["lccode"]=0x1F63,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F69, 0x0300 },
  ["unicodeslot"]=0x1F6B, -- Ὣ
 },
 [0x1F6C]={
  ["category"]="lu",
  ["contextname"]="greekOmegapsilitonos",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA",
  ["lccode"]=0x1F64,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F68, 0x0301 },
  ["unicodeslot"]=0x1F6C, -- Ὤ
 },
 [0x1F6D]={
  ["category"]="lu",
  ["contextname"]="greekOmegadasiatonos",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA",
  ["lccode"]=0x1F65,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F69, 0x0301 },
  ["unicodeslot"]=0x1F6D, -- Ὥ
 },
 [0x1F6E]={
  ["category"]="lu",
  ["contextname"]="greekOmegapsiliperispomeni",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI",
  ["lccode"]=0x1F66,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F68, 0x0342 },
  ["unicodeslot"]=0x1F6E, -- Ὦ
 },
 [0x1F6F]={
  ["category"]="lu",
  ["contextname"]="greekOmegadasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI",
  ["lccode"]=0x1F67,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F69, 0x0342 },
  ["unicodeslot"]=0x1F6F, -- Ὧ
 },
 [0x1F70]={
  ["category"]="ll",
  ["contextname"]="greekalphavaria",
  ["description"]="GREEK SMALL LETTER ALPHA WITH VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0300 },
  ["uccode"]=0x1FBA,
  ["unicodeslot"]=0x1F70, -- ὰ
 },
 [0x1F71]={
  ["category"]="ll",
  ["contextname"]="greekalphaoxia",
  ["description"]="GREEK SMALL LETTER ALPHA WITH OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03AC },
  ["uccode"]=0x1FBB,
  ["unicodeslot"]=0x1F71, -- ά
 },
 [0x1F72]={
  ["category"]="ll",
  ["contextname"]="greekepsilonvaria",
  ["description"]="GREEK SMALL LETTER EPSILON WITH VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x03B5, 0x0300 },
  ["uccode"]=0x1FC8,
  ["unicodeslot"]=0x1F72, -- ὲ
 },
 [0x1F73]={
  ["category"]="ll",
  ["contextname"]="greekepsilonoxia",
  ["description"]="GREEK SMALL LETTER EPSILON WITH OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B5,
  ["specials"]={ "char", 0x03AD },
  ["uccode"]=0x1FC9,
  ["unicodeslot"]=0x1F73, -- έ
 },
 [0x1F74]={
  ["category"]="ll",
  ["contextname"]="greeketavaria",
  ["description"]="GREEK SMALL LETTER ETA WITH VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03B7, 0x0300 },
  ["uccode"]=0x1FCA,
  ["unicodeslot"]=0x1F74, -- ὴ
 },
 [0x1F75]={
  ["category"]="ll",
  ["contextname"]="greeketaoxia",
  ["description"]="GREEK SMALL LETTER ETA WITH OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03AE },
  ["uccode"]=0x1FCB,
  ["unicodeslot"]=0x1F75, -- ή
 },
 [0x1F76]={
  ["category"]="ll",
  ["contextname"]="greekiotavaria",
  ["description"]="GREEK SMALL LETTER IOTA WITH VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0300 },
  ["uccode"]=0x1FDA,
  ["unicodeslot"]=0x1F76, -- ὶ
 },
 [0x1F77]={
  ["category"]="ll",
  ["contextname"]="greekiotaoxia",
  ["description"]="GREEK SMALL LETTER IOTA WITH OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03AF },
  ["uccode"]=0x1FDB,
  ["unicodeslot"]=0x1F77, -- ί
 },
 [0x1F78]={
  ["category"]="ll",
  ["contextname"]="greekomicronvaria",
  ["description"]="GREEK SMALL LETTER OMICRON WITH VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x03BF, 0x0300 },
  ["uccode"]=0x1FF8,
  ["unicodeslot"]=0x1F78, -- ὸ
 },
 [0x1F79]={
  ["category"]="ll",
  ["contextname"]="greekomicronoxia",
  ["description"]="GREEK SMALL LETTER OMICRON WITH OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03BF,
  ["specials"]={ "char", 0x03CC },
  ["uccode"]=0x1FF9,
  ["unicodeslot"]=0x1F79, -- ό
 },
 [0x1F7A]={
  ["category"]="ll",
  ["contextname"]="greekupsilonvaria",
  ["description"]="GREEK SMALL LETTER UPSILON WITH VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0300 },
  ["uccode"]=0x1FEA,
  ["unicodeslot"]=0x1F7A, -- ὺ
 },
 [0x1F7B]={
  ["category"]="ll",
  ["contextname"]="greekupsilonoxia",
  ["description"]="GREEK SMALL LETTER UPSILON WITH OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03CD },
  ["uccode"]=0x1FEB,
  ["unicodeslot"]=0x1F7B, -- ύ
 },
 [0x1F7C]={
  ["category"]="ll",
  ["contextname"]="greekomegavaria",
  ["description"]="GREEK SMALL LETTER OMEGA WITH VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03C9, 0x0300 },
  ["uccode"]=0x1FFA,
  ["unicodeslot"]=0x1F7C, -- ὼ
 },
 [0x1F7D]={
  ["category"]="ll",
  ["contextname"]="greekomegaoxia",
  ["description"]="GREEK SMALL LETTER OMEGA WITH OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03CE },
  ["uccode"]=0x1FFB,
  ["unicodeslot"]=0x1F7D, -- ώ
 },
 [0x1F80]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubpsili",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F00, 0x0345 },
  ["uccode"]=0x1F88,
  ["unicodeslot"]=0x1F80, -- ᾀ
 },
 [0x1F81]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubdasia",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F01, 0x0345 },
  ["uccode"]=0x1F89,
  ["unicodeslot"]=0x1F81, -- ᾁ
 },
 [0x1F82]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubpsilivaria",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F02, 0x0345 },
  ["uccode"]=0x1F8A,
  ["unicodeslot"]=0x1F82, -- ᾂ
 },
 [0x1F83]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubdasiavaria",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F03, 0x0345 },
  ["uccode"]=0x1F8B,
  ["unicodeslot"]=0x1F83, -- ᾃ
 },
 [0x1F84]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubpsilitonos",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F04, 0x0345 },
  ["uccode"]=0x1F8C,
  ["unicodeslot"]=0x1F84, -- ᾄ
 },
 [0x1F85]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubdasiatonos",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F05, 0x0345 },
  ["uccode"]=0x1F8D,
  ["unicodeslot"]=0x1F85, -- ᾅ
 },
 [0x1F86]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubpsiliperispomeni",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F06, 0x0345 },
  ["uccode"]=0x1F8E,
  ["unicodeslot"]=0x1F86, -- ᾆ
 },
 [0x1F87]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubdasiaperispomeni",
  ["description"]="GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F07, 0x0345 },
  ["uccode"]=0x1F8F,
  ["unicodeslot"]=0x1F87, -- ᾇ
 },
 [0x1F88]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubpsili",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI",
  ["lccode"]=0x1F80,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F08, 0x0345 },
  ["unicodeslot"]=0x1F88, -- ᾈ
 },
 [0x1F89]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubdasia",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F81,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F09, 0x0345 },
  ["unicodeslot"]=0x1F89, -- ᾉ
 },
 [0x1F8A]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubpsilivaria",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F82,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F0A, 0x0345 },
  ["unicodeslot"]=0x1F8A, -- ᾊ
 },
 [0x1F8B]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubdasiavaria",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F83,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F0B, 0x0345 },
  ["unicodeslot"]=0x1F8B, -- ᾋ
 },
 [0x1F8C]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubpsilitonos",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F84,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F0C, 0x0345 },
  ["unicodeslot"]=0x1F8C, -- ᾌ
 },
 [0x1F8D]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubdasiatonos",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F85,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F0D, 0x0345 },
  ["unicodeslot"]=0x1F8D, -- ᾍ
 },
 [0x1F8E]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubpsiliperispomeni",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
  ["lccode"]=0x1F86,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F0E, 0x0345 },
  ["unicodeslot"]=0x1F8E, -- ᾎ
 },
 [0x1F8F]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasubdasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
  ["lccode"]=0x1F87,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x1F0F, 0x0345 },
  ["unicodeslot"]=0x1F8F, -- ᾏ
 },
 [0x1F90]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubpsili",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F20, 0x0345 },
  ["uccode"]=0x1F98,
  ["unicodeslot"]=0x1F90, -- ᾐ
 },
 [0x1F91]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubdasia",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F21, 0x0345 },
  ["uccode"]=0x1F99,
  ["unicodeslot"]=0x1F91, -- ᾑ
 },
 [0x1F92]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubpsilivaria",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F22, 0x0345 },
  ["uccode"]=0x1F9A,
  ["unicodeslot"]=0x1F92, -- ᾒ
 },
 [0x1F93]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubdasiavaria",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F23, 0x0345 },
  ["uccode"]=0x1F9B,
  ["unicodeslot"]=0x1F93, -- ᾓ
 },
 [0x1F94]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubpsilitonos",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F24, 0x0345 },
  ["uccode"]=0x1F9C,
  ["unicodeslot"]=0x1F94, -- ᾔ
 },
 [0x1F95]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubdasiatonos",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F25, 0x0345 },
  ["uccode"]=0x1F9D,
  ["unicodeslot"]=0x1F95, -- ᾕ
 },
 [0x1F96]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubpsiliperispomeni",
  ["description"]="GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F26, 0x0345 },
  ["uccode"]=0x1F9E,
  ["unicodeslot"]=0x1F96, -- ᾖ
 },
 [0x1F97]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubdasiaperispomeni",
  ["description"]="GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F27, 0x0345 },
  ["uccode"]=0x1F9F,
  ["unicodeslot"]=0x1F97, -- ᾗ
 },
 [0x1F98]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubpsili",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI",
  ["lccode"]=0x1F90,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F28, 0x0345 },
  ["unicodeslot"]=0x1F98, -- ᾘ
 },
 [0x1F99]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubdasia",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F91,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F29, 0x0345 },
  ["unicodeslot"]=0x1F99, -- ᾙ
 },
 [0x1F9A]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubpsilivaria",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F92,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F2A, 0x0345 },
  ["unicodeslot"]=0x1F9A, -- ᾚ
 },
 [0x1F9B]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubdasiavaria",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F93,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F2B, 0x0345 },
  ["unicodeslot"]=0x1F9B, -- ᾛ
 },
 [0x1F9C]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubpsilitonos",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F94,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F2C, 0x0345 },
  ["unicodeslot"]=0x1F9C, -- ᾜ
 },
 [0x1F9D]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubdasiatonos",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1F95,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F2D, 0x0345 },
  ["unicodeslot"]=0x1F9D, -- ᾝ
 },
 [0x1F9E]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubpsiliperispomeni",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
  ["lccode"]=0x1F96,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F2E, 0x0345 },
  ["unicodeslot"]=0x1F9E, -- ᾞ
 },
 [0x1F9F]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasubdasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
  ["lccode"]=0x1F97,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x1F2F, 0x0345 },
  ["unicodeslot"]=0x1F9F, -- ᾟ
 },
 [0x1FA0]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubpsili",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F60, 0x0345 },
  ["uccode"]=0x1FA8,
  ["unicodeslot"]=0x1FA0, -- ᾠ
 },
 [0x1FA1]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubdasia",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F61, 0x0345 },
  ["uccode"]=0x1FA9,
  ["unicodeslot"]=0x1FA1, -- ᾡ
 },
 [0x1FA2]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubpsilivaria",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F62, 0x0345 },
  ["uccode"]=0x1FAA,
  ["unicodeslot"]=0x1FA2, -- ᾢ
 },
 [0x1FA3]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubdasiavaria",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F63, 0x0345 },
  ["uccode"]=0x1FAB,
  ["unicodeslot"]=0x1FA3, -- ᾣ
 },
 [0x1FA4]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubpsilitonos",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F64, 0x0345 },
  ["uccode"]=0x1FAC,
  ["unicodeslot"]=0x1FA4, -- ᾤ
 },
 [0x1FA5]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubdasiatonos",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F65, 0x0345 },
  ["uccode"]=0x1FAD,
  ["unicodeslot"]=0x1FA5, -- ᾥ
 },
 [0x1FA6]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubpsiliperispomeni",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F66, 0x0345 },
  ["uccode"]=0x1FAE,
  ["unicodeslot"]=0x1FA6, -- ᾦ
 },
 [0x1FA7]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubdasiaperispomeni",
  ["description"]="GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F67, 0x0345 },
  ["uccode"]=0x1FAF,
  ["unicodeslot"]=0x1FA7, -- ᾧ
 },
 [0x1FA8]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubpsili",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA0,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F68, 0x0345 },
  ["unicodeslot"]=0x1FA8, -- ᾨ
 },
 [0x1FA9]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubdasia",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA1,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F69, 0x0345 },
  ["unicodeslot"]=0x1FA9, -- ᾩ
 },
 [0x1FAA]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubpsilivaria",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA2,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F6A, 0x0345 },
  ["unicodeslot"]=0x1FAA, -- ᾪ
 },
 [0x1FAB]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubdasiavaria",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA3,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F6B, 0x0345 },
  ["unicodeslot"]=0x1FAB, -- ᾫ
 },
 [0x1FAC]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubpsilitonos",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA4,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F6C, 0x0345 },
  ["unicodeslot"]=0x1FAC, -- ᾬ
 },
 [0x1FAD]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubdasiatonos",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA5,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F6D, 0x0345 },
  ["unicodeslot"]=0x1FAD, -- ᾭ
 },
 [0x1FAE]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubpsiliperispomeni",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA6,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F6E, 0x0345 },
  ["unicodeslot"]=0x1FAE, -- ᾮ
 },
 [0x1FAF]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasubdasiaperispomeni",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
  ["lccode"]=0x1FA7,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x1F6F, 0x0345 },
  ["unicodeslot"]=0x1FAF, -- ᾯ
 },
 [0x1FB0]={
  ["category"]="ll",
  ["contextname"]="greekalphavrachy",
  ["description"]="GREEK SMALL LETTER ALPHA WITH VRACHY",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0306 },
  ["uccode"]=0x1FB8,
  ["unicodeslot"]=0x1FB0, -- ᾰ
 },
 [0x1FB1]={
  ["category"]="ll",
  ["contextname"]="greekalphamacron",
  ["description"]="GREEK SMALL LETTER ALPHA WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0304 },
  ["uccode"]=0x1FB9,
  ["unicodeslot"]=0x1FB1, -- ᾱ
 },
 [0x1FB2]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubvaria",
  ["description"]="GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1F70, 0x0345 },
  ["unicodeslot"]=0x1FB2, -- ᾲ
 },
 [0x1FB3]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasub",
  ["description"]="GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0345 },
  ["uccode"]=0x1FBC,
  ["unicodeslot"]=0x1FB3, -- ᾳ
 },
 [0x1FB4]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubtonos",
  ["description"]="GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03AC, 0x0345 },
  ["unicodeslot"]=0x1FB4, -- ᾴ
 },
 [0x1FB6]={
  ["category"]="ll",
  ["contextname"]="greekalphaperispomeni",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x03B1, 0x0342 },
  ["unicodeslot"]=0x1FB6, -- ᾶ
 },
 [0x1FB7]={
  ["category"]="ll",
  ["contextname"]="greekalphaiotasubperispomeni",
  ["description"]="GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B1,
  ["specials"]={ "char", 0x1FB6, 0x0345 },
  ["unicodeslot"]=0x1FB7, -- ᾷ
 },
 [0x1FB8]={
  ["category"]="lu",
  ["contextname"]="greekAlphavrachy",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH VRACHY",
  ["lccode"]=0x1FB0,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0391, 0x0306 },
  ["unicodeslot"]=0x1FB8, -- Ᾰ
 },
 [0x1FB9]={
  ["category"]="lu",
  ["contextname"]="greekAlphamacron",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH MACRON",
  ["lccode"]=0x1FB1,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0391, 0x0304 },
  ["unicodeslot"]=0x1FB9, -- Ᾱ
 },
 [0x1FBA]={
  ["category"]="lu",
  ["contextname"]="greekAlphavaria",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH VARIA",
  ["lccode"]=0x1F70,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0391, 0x0300 },
  ["unicodeslot"]=0x1FBA, -- Ὰ
 },
 [0x1FBB]={
  ["category"]="lu",
  ["contextname"]="greekAlphatonos",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH OXIA",
  ["lccode"]=0x1F71,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0386 },
  ["unicodeslot"]=0x1FBB, -- Ά
 },
 [0x1FBC]={
  ["category"]="lt",
  ["contextname"]="greekAlphaiotasub",
  ["description"]="GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI",
  ["lccode"]=0x1FB3,
  ["linebreak"]="al",
  ["shcode"]=0x0391,
  ["specials"]={ "char", 0x0391, 0x0345 },
  ["unicodeslot"]=0x1FBC, -- ᾼ
 },
 [0x1FBD]={
  ["category"]="sk",
  ["contextname"]="greekCoronis",
  ["description"]="GREEK KORONIS",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0313 },
  ["unicodeslot"]=0x1FBD, -- ᾽
 },
 [0x1FBE]={
  ["category"]="ll",
  ["contextname"]="greekprosgegrammeni",
  ["description"]="GREEK PROSGEGRAMMENI",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x03B9 },
  ["uccode"]=0x0399,
  ["unicodeslot"]=0x1FBE, -- ι
 },
 [0x1FBF]={
  ["category"]="sk",
  ["contextname"]="greekpsili",
  ["description"]="GREEK PSILI",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0313 },
  ["unicodeslot"]=0x1FBF, -- ᾿
 },
 [0x1FC0]={
  ["category"]="sk",
  ["contextname"]="greekperispomeni",
  ["description"]="GREEK PERISPOMENI",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0342 },
  ["unicodeslot"]=0x1FC0, -- ῀
 },
 [0x1FC1]={
  ["category"]="sk",
  ["contextname"]="greekdialytikaperispomeni",
  ["description"]="GREEK DIALYTIKA AND PERISPOMENI",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x00A8, 0x0342 },
  ["unicodeslot"]=0x1FC1, -- ῁
 },
 [0x1FC2]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubvaria",
  ["description"]="GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1F74, 0x0345 },
  ["unicodeslot"]=0x1FC2, -- ῂ
 },
 [0x1FC3]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasub",
  ["description"]="GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03B7, 0x0345 },
  ["uccode"]=0x1FCC,
  ["unicodeslot"]=0x1FC3, -- ῃ
 },
 [0x1FC4]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubtonos",
  ["description"]="GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03AE, 0x0345 },
  ["unicodeslot"]=0x1FC4, -- ῄ
 },
 [0x1FC6]={
  ["category"]="ll",
  ["contextname"]="greeketaperispomeni",
  ["description"]="GREEK SMALL LETTER ETA WITH PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x03B7, 0x0342 },
  ["unicodeslot"]=0x1FC6, -- ῆ
 },
 [0x1FC7]={
  ["category"]="ll",
  ["contextname"]="greeketaiotasubperispomeni",
  ["description"]="GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B7,
  ["specials"]={ "char", 0x1FC6, 0x0345 },
  ["unicodeslot"]=0x1FC7, -- ῇ
 },
 [0x1FC8]={
  ["category"]="lu",
  ["contextname"]="greekEpsilonvaria",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH VARIA",
  ["lccode"]=0x1F72,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x0395, 0x0300 },
  ["unicodeslot"]=0x1FC8, -- Ὲ
 },
 [0x1FC9]={
  ["category"]="lu",
  ["contextname"]="greekEpsilontonos",
  ["description"]="GREEK CAPITAL LETTER EPSILON WITH OXIA",
  ["lccode"]=0x1F73,
  ["linebreak"]="al",
  ["shcode"]=0x0395,
  ["specials"]={ "char", 0x0388 },
  ["unicodeslot"]=0x1FC9, -- Έ
 },
 [0x1FCA]={
  ["category"]="lu",
  ["contextname"]="greekEtavaria",
  ["description"]="GREEK CAPITAL LETTER ETA WITH VARIA",
  ["lccode"]=0x1F74,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x0397, 0x0300 },
  ["unicodeslot"]=0x1FCA, -- Ὴ
 },
 [0x1FCB]={
  ["category"]="lu",
  ["contextname"]="greekEtatonos",
  ["description"]="GREEK CAPITAL LETTER ETA WITH OXIA",
  ["lccode"]=0x1F75,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x0389 },
  ["unicodeslot"]=0x1FCB, -- Ή
 },
 [0x1FCC]={
  ["category"]="lt",
  ["contextname"]="greekEtaiotasub",
  ["description"]="GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI",
  ["lccode"]=0x1FC3,
  ["linebreak"]="al",
  ["shcode"]=0x0397,
  ["specials"]={ "char", 0x0397, 0x0345 },
  ["unicodeslot"]=0x1FCC, -- ῌ
 },
 [0x1FCD]={
  ["category"]="sk",
  ["contextname"]="greekpsilivaria",
  ["description"]="GREEK PSILI AND VARIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1FBF, 0x0300 },
  ["unicodeslot"]=0x1FCD, -- ῍
 },
 [0x1FCE]={
  ["category"]="sk",
  ["contextname"]="greekpsilitonos",
  ["description"]="GREEK PSILI AND OXIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1FBF, 0x0301 },
  ["unicodeslot"]=0x1FCE, -- ῎
 },
 [0x1FCF]={
  ["category"]="sk",
  ["contextname"]="greekpsiliperispomeni",
  ["description"]="GREEK PSILI AND PERISPOMENI",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1FBF, 0x0342 },
  ["unicodeslot"]=0x1FCF, -- ῏
 },
 [0x1FD0]={
  ["category"]="ll",
  ["contextname"]="greekiotavrachy",
  ["description"]="GREEK SMALL LETTER IOTA WITH VRACHY",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0306 },
  ["uccode"]=0x1FD8,
  ["unicodeslot"]=0x1FD0, -- ῐ
 },
 [0x1FD1]={
  ["category"]="ll",
  ["contextname"]="greekiotamacron",
  ["description"]="GREEK SMALL LETTER IOTA WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0304 },
  ["uccode"]=0x1FD9,
  ["unicodeslot"]=0x1FD1, -- ῑ
 },
 [0x1FD2]={
  ["category"]="ll",
  ["contextname"]="greekiotadialytikavaria",
  ["description"]="GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03CA, 0x0300 },
  ["unicodeslot"]=0x1FD2, -- ῒ
 },
 [0x1FD3]={
  ["category"]="ll",
  ["contextname"]="greekiotadialytikatonos",
  ["description"]="GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x0390 },
  ["unicodeslot"]=0x1FD3, -- ΐ
 },
 [0x1FD6]={
  ["category"]="ll",
  ["contextname"]="greekiotaperispomeni",
  ["description"]="GREEK SMALL LETTER IOTA WITH PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03B9, 0x0342 },
  ["unicodeslot"]=0x1FD6, -- ῖ
 },
 [0x1FD7]={
  ["category"]="ll",
  ["contextname"]="greekiotadialytikaperispomeni",
  ["description"]="GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03B9,
  ["specials"]={ "char", 0x03CA, 0x0342 },
  ["unicodeslot"]=0x1FD7, -- ῗ
 },
 [0x1FD8]={
  ["category"]="lu",
  ["contextname"]="greekIotavrachy",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH VRACHY",
  ["lccode"]=0x1FD0,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x0399, 0x0306 },
  ["unicodeslot"]=0x1FD8, -- Ῐ
 },
 [0x1FD9]={
  ["category"]="lu",
  ["contextname"]="greekIotamacron",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH MACRON",
  ["lccode"]=0x1FD1,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x0399, 0x0304 },
  ["unicodeslot"]=0x1FD9, -- Ῑ
 },
 [0x1FDA]={
  ["category"]="lu",
  ["contextname"]="greekIotavaria",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH VARIA",
  ["lccode"]=0x1F76,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x0399, 0x0300 },
  ["unicodeslot"]=0x1FDA, -- Ὶ
 },
 [0x1FDB]={
  ["category"]="lu",
  ["contextname"]="greekIotatonos",
  ["description"]="GREEK CAPITAL LETTER IOTA WITH OXIA",
  ["lccode"]=0x1F77,
  ["linebreak"]="al",
  ["shcode"]=0x0399,
  ["specials"]={ "char", 0x038A },
  ["unicodeslot"]=0x1FDB, -- Ί
 },
 [0x1FDD]={
  ["category"]="sk",
  ["contextname"]="greekdasiavaria",
  ["description"]="GREEK DASIA AND VARIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1FFE, 0x0300 },
  ["unicodeslot"]=0x1FDD, -- ῝
 },
 [0x1FDE]={
  ["category"]="sk",
  ["contextname"]="greekdasiatonos",
  ["description"]="GREEK DASIA AND OXIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1FFE, 0x0301 },
  ["unicodeslot"]=0x1FDE, -- ῞
 },
 [0x1FDF]={
  ["category"]="sk",
  ["contextname"]="greekdasiaperispomeni",
  ["description"]="GREEK DASIA AND PERISPOMENI",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x1FFE, 0x0342 },
  ["unicodeslot"]=0x1FDF, -- ῟
 },
 [0x1FE0]={
  ["category"]="ll",
  ["contextname"]="greekupsilonvrachy",
  ["description"]="GREEK SMALL LETTER UPSILON WITH VRACHY",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0306 },
  ["uccode"]=0x1FE8,
  ["unicodeslot"]=0x1FE0, -- ῠ
 },
 [0x1FE1]={
  ["category"]="ll",
  ["contextname"]="greekupsilonmacron",
  ["description"]="GREEK SMALL LETTER UPSILON WITH MACRON",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0304 },
  ["uccode"]=0x1FE9,
  ["unicodeslot"]=0x1FE1, -- ῡ
 },
 [0x1FE2]={
  ["category"]="ll",
  ["contextname"]="greekupsilondialytikavaria",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03CB, 0x0300 },
  ["unicodeslot"]=0x1FE2, -- ῢ
 },
 [0x1FE3]={
  ["category"]="ll",
  ["contextname"]="greekupsilondialytikatonos",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03B0 },
  ["unicodeslot"]=0x1FE3, -- ΰ
 },
 [0x1FE4]={
  ["category"]="ll",
  ["contextname"]="greekrhopsili",
  ["description"]="GREEK SMALL LETTER RHO WITH PSILI",
  ["linebreak"]="al",
  ["shcode"]=0x03C1,
  ["specials"]={ "char", 0x03C1, 0x0313 },
  ["unicodeslot"]=0x1FE4, -- ῤ
 },
 [0x1FE5]={
  ["category"]="ll",
  ["contextname"]="greekrhodasia",
  ["description"]="GREEK SMALL LETTER RHO WITH DASIA",
  ["linebreak"]="al",
  ["shcode"]=0x03C1,
  ["specials"]={ "char", 0x03C1, 0x0314 },
  ["uccode"]=0x1FEC,
  ["unicodeslot"]=0x1FE5, -- ῥ
 },
 [0x1FE6]={
  ["category"]="ll",
  ["contextname"]="greekupsilonperispomeni",
  ["description"]="GREEK SMALL LETTER UPSILON WITH PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03C5, 0x0342 },
  ["unicodeslot"]=0x1FE6, -- ῦ
 },
 [0x1FE7]={
  ["category"]="ll",
  ["contextname"]="greekupsilondialytikaperispomeni",
  ["description"]="GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C5,
  ["specials"]={ "char", 0x03CB, 0x0342 },
  ["unicodeslot"]=0x1FE7, -- ῧ
 },
 [0x1FE8]={
  ["category"]="lu",
  ["contextname"]="greekUpsilonvrachy",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH VRACHY",
  ["lccode"]=0x1FE0,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x03A5, 0x0306 },
  ["unicodeslot"]=0x1FE8, -- Ῠ
 },
 [0x1FE9]={
  ["category"]="lu",
  ["contextname"]="greekUpsilonmacron",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH MACRON",
  ["lccode"]=0x1FE1,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x03A5, 0x0304 },
  ["unicodeslot"]=0x1FE9, -- Ῡ
 },
 [0x1FEA]={
  ["category"]="lu",
  ["contextname"]="greekUpsilonvaria",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH VARIA",
  ["lccode"]=0x1F7A,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x03A5, 0x0300 },
  ["unicodeslot"]=0x1FEA, -- Ὺ
 },
 [0x1FEB]={
  ["category"]="lu",
  ["contextname"]="greekUpsilontonos",
  ["description"]="GREEK CAPITAL LETTER UPSILON WITH OXIA",
  ["lccode"]=0x1F7B,
  ["linebreak"]="al",
  ["shcode"]=0x03A5,
  ["specials"]={ "char", 0x038E },
  ["unicodeslot"]=0x1FEB, -- Ύ
 },
 [0x1FEC]={
  ["category"]="lu",
  ["contextname"]="greekRhodasia",
  ["description"]="GREEK CAPITAL LETTER RHO WITH DASIA",
  ["lccode"]=0x1FE5,
  ["linebreak"]="al",
  ["shcode"]=0x03A1,
  ["specials"]={ "char", 0x03A1, 0x0314 },
  ["unicodeslot"]=0x1FEC, -- Ῥ
 },
 [0x1FED]={
  ["category"]="sk",
  ["contextname"]="greekdialytikavaria",
  ["description"]="GREEK DIALYTIKA AND VARIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x00A8, 0x0300 },
  ["unicodeslot"]=0x1FED, -- ῭
 },
 [0x1FEE]={
  ["category"]="sk",
  ["contextname"]="greekdialytikatonos",
  ["description"]="GREEK DIALYTIKA AND OXIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0385 },
  ["unicodeslot"]=0x1FEE, -- ΅
 },
 [0x1FEF]={
  ["category"]="sk",
  ["contextname"]="greekvaria",
  ["description"]="GREEK VARIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x0060 },
  ["unicodeslot"]=0x1FEF, -- `
 },
 [0x1FF2]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubvaria",
  ["description"]="GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1F7C, 0x0345 },
  ["unicodeslot"]=0x1FF2, -- ῲ
 },
 [0x1FF3]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasub",
  ["description"]="GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03C9, 0x0345 },
  ["uccode"]=0x1FFC,
  ["unicodeslot"]=0x1FF3, -- ῳ
 },
 [0x1FF4]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubtonos",
  ["description"]="GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03CE, 0x0345 },
  ["unicodeslot"]=0x1FF4, -- ῴ
 },
 [0x1FF6]={
  ["category"]="ll",
  ["contextname"]="greekomegaperispomeni",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PERISPOMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x03C9, 0x0342 },
  ["unicodeslot"]=0x1FF6, -- ῶ
 },
 [0x1FF7]={
  ["category"]="ll",
  ["contextname"]="greekomegaiotasubperispomeni",
  ["description"]="GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI",
  ["linebreak"]="al",
  ["shcode"]=0x03C9,
  ["specials"]={ "char", 0x1FF6, 0x0345 },
  ["unicodeslot"]=0x1FF7, -- ῷ
 },
 [0x1FF8]={
  ["category"]="lu",
  ["contextname"]="greekOmicronvaria",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH VARIA",
  ["lccode"]=0x1F78,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x039F, 0x0300 },
  ["unicodeslot"]=0x1FF8, -- Ὸ
 },
 [0x1FF9]={
  ["category"]="lu",
  ["contextname"]="greekOmicrontonos",
  ["description"]="GREEK CAPITAL LETTER OMICRON WITH OXIA",
  ["lccode"]=0x1F79,
  ["linebreak"]="al",
  ["shcode"]=0x039F,
  ["specials"]={ "char", 0x038C },
  ["unicodeslot"]=0x1FF9, -- Ό
 },
 [0x1FFA]={
  ["category"]="lu",
  ["contextname"]="greekOmegavaria",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH VARIA",
  ["lccode"]=0x1F7C,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x03A9, 0x0300 },
  ["unicodeslot"]=0x1FFA, -- Ὼ
 },
 [0x1FFB]={
  ["category"]="lu",
  ["contextname"]="greekOmegatonos",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH OXIA",
  ["lccode"]=0x1F7D,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x038F },
  ["unicodeslot"]=0x1FFB, -- Ώ
 },
 [0x1FFC]={
  ["category"]="lt",
  ["contextname"]="greekOmegaiotasub",
  ["description"]="GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI",
  ["lccode"]=0x1FF3,
  ["linebreak"]="al",
  ["shcode"]=0x03A9,
  ["specials"]={ "char", 0x03A9, 0x0345 },
  ["unicodeslot"]=0x1FFC, -- ῼ
 },
 [0x1FFD]={
  ["category"]="sk",
  ["contextname"]="greekoxia",
  ["description"]="GREEK OXIA",
  ["linebreak"]="al",
  ["specials"]={ "char", 0x00B4 },
  ["unicodeslot"]=0x1FFD, -- ´
 },
 [0x1FFE]={
  ["category"]="sk",
  ["contextname"]="greekdasia",
  ["description"]="GREEK DASIA",
  ["linebreak"]="al",
  ["specials"]={ "compat", 0x0020, 0x0314 },
  ["unicodeslot"]=0x1FFE, -- ῾
 },
 [0x2000]={
  ["category"]="zs",
  ["description"]="EN QUAD",
  ["linebreak"]="ba",
  ["specials"]={ "char", 0x2002 },
  ["unicodeslot"]=0x2000, --  
 },
 [0x2001]={
  ["category"]="zs",
  ["description"]="EM QUAD