/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pencil;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFTextString;
import de.tu_darmstadt.sp.pencil.CloningVisitor;
import de.tu_darmstadt.sp.pencil.PageCommand;
import de.tu_darmstadt.sp.pencil.PageDescription;
import de.tu_darmstadt.sp.pencil.commands.BTCmd;
import de.tu_darmstadt.sp.pencil.commands.GCmd;
import de.tu_darmstadt.sp.pencil.commands.KCmd;
import de.tu_darmstadt.sp.pencil.commands.RGCmd;
import de.tu_darmstadt.sp.pencil.commands.TJCmd;
import de.tu_darmstadt.sp.pencil.commands.TfCmd;
import de.tu_darmstadt.sp.pencil.commands.cCmd;
import de.tu_darmstadt.sp.pencil.commands.gCmd;
import de.tu_darmstadt.sp.pencil.commands.kCmd;
import de.tu_darmstadt.sp.pencil.commands.lCmd;
import de.tu_darmstadt.sp.pencil.commands.reCmd;
import de.tu_darmstadt.sp.pencil.commands.rgCmd;
import java.util.ListIterator;

public class EnsureStatus
extends CloningVisitor {
    private TfCmd lastTfCmd = null;
    private PageCommand lastFillColor = null;
    private PageCommand lastStrokeColor = null;
    private boolean noTfSeen = true;
    private boolean noFillColorSeen = true;
    private boolean noStrokeColorSeen = true;

    public EnsureStatus() {
        this.theClone = new PageDescription();
    }

    public PageDescription getResult() {
        this.noTfSeen = true;
        this.noFillColorSeen = true;
        this.noStrokeColorSeen = true;
        return super.getResult();
    }

    public static void main(String[] args) throws Exception {
        try {
            EnsureStatus theChecker = new EnsureStatus();
            PageDescription orig1 = new PageDescription();
            PageDescription orig2 = new PageDescription();
            orig1.addCommand(new gCmd(0.0f));
            orig1.addCommand(new TfCmd("/F11", 12.5f));
            PDFArray pa = new PDFArray();
            pa.add(new PDFTextString("Hello,"));
            orig1.addCommand(new TJCmd(pa));
            orig1.accept(theChecker);
            PageDescription result = theChecker.getResult();
            System.out.println("Result: orig1 had " + EnsureStatus.mysize(orig1.getIterator()) + ", new has " + EnsureStatus.mysize(result.getIterator()));
            pa = new PDFArray();
            orig2.addCommand(new BTCmd());
            pa = new PDFArray();
            pa.add(new PDFTextString("Hello,"));
            orig2.addCommand(new TJCmd(pa));
            orig2.accept(theChecker);
            result = theChecker.getResult();
            System.out.println("Result: orig2 had " + EnsureStatus.mysize(orig2.getIterator()) + ", new has " + EnsureStatus.mysize(result.getIterator()));
            ListIterator ri = result.getIterator();
            while (ri.hasNext()) {
                PageCommand pc = (PageCommand)ri.next();
                System.out.println(pc.toString());
            }
        }
        catch (Exception e) {
            System.out.print(e.toString());
            e.printStackTrace();
            System.out.println();
            System.exit(-1);
        }
    }

    private void makeColorsValid() {
        if (this.noFillColorSeen && this.lastFillColor != null) {
            this.theClone.addCommand(this.lastFillColor);
            this.noFillColorSeen = false;
        }
        if (this.noStrokeColorSeen && this.lastStrokeColor != null) {
            this.theClone.addCommand(this.lastStrokeColor);
            this.noStrokeColorSeen = false;
        }
    }

    private static int mysize(ListIterator l) {
        int count = 0;
        while (l.hasNext()) {
            l.next();
            ++count;
        }
        return count;
    }

    public void resetColor() {
        this.noFillColorSeen = true;
        this.noStrokeColorSeen = true;
    }

    public void visit(BTCmd c) {
        this.makeColorsValid();
        this.theClone.addCommand(c);
    }

    public void visit(GCmd c) {
        this.lastStrokeColor = c;
        this.theClone.addCommand(c);
        this.noStrokeColorSeen = false;
    }

    public void visit(KCmd c) {
        this.lastStrokeColor = c;
        this.theClone.addCommand(c);
        this.noStrokeColorSeen = false;
    }

    public void visit(RGCmd c) {
        this.lastStrokeColor = c;
        this.theClone.addCommand(c);
        this.noStrokeColorSeen = false;
    }

    public void visit(TJCmd c) {
        if (this.noTfSeen) {
            this.theClone.addCommand(this.lastTfCmd);
            this.noTfSeen = false;
        }
        this.theClone.addCommand(c);
    }

    public void visit(TfCmd c) {
        this.lastTfCmd = c;
        this.theClone.addCommand(c);
        this.noTfSeen = false;
    }

    public void visit(cCmd c) {
        this.makeColorsValid();
        this.theClone.addCommand(c);
    }

    public void visit(gCmd c) {
        this.lastFillColor = c;
        this.theClone.addCommand(c);
        this.noFillColorSeen = false;
    }

    public void visit(kCmd c) {
        this.lastFillColor = c;
        this.theClone.addCommand(c);
        this.noFillColorSeen = false;
    }

    public void visit(lCmd c) {
        this.makeColorsValid();
        this.theClone.addCommand(c);
    }

    public void visit(reCmd c) {
        this.makeColorsValid();
        this.theClone.addCommand(c);
    }

    public void visit(rgCmd c) {
        this.lastFillColor = c;
        this.theClone.addCommand(c);
        this.noFillColorSeen = false;
    }

    public void visitorMethod(PageCommand c) {
        this.theClone.addCommand(c);
    }
}

