/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    private static final String PROPERTY_PREFIX = "java.util.logging.FileHandler";
    private static final String PATTERN_KEY = "java.util.logging.FileHandler.pattern";
    private static final String DEFAULT_PATTERN = "%h/java%u.log";
    private static final String LIMIT_KEY = "java.util.logging.FileHandler.limit";
    private static final int DEFAULT_LIMIT = 0;
    private static final String COUNT_KEY = "java.util.logging.FileHandler.count";
    private static final int DEFAULT_COUNT = 1;
    private static final String APPEND_KEY = "java.util.logging.FileHandler.append";
    private static final boolean DEFAULT_APPEND = false;
    private final int limit;
    private final int count;
    private final String pattern;
    private final boolean append;
    long written;
    private LinkedList logFiles;

    public FileHandler() throws IOException, SecurityException {
        this(LogManager.getLogManager().getProperty(PATTERN_KEY), LogManager.getIntProperty(LIMIT_KEY, 0), LogManager.getIntProperty(COUNT_KEY, 1), LogManager.getBooleanProperty(APPEND_KEY, false));
    }

    public FileHandler(String string) throws IOException, SecurityException {
        this(string, 0, 1, false);
    }

    public FileHandler(String string, boolean bl) throws IOException, SecurityException {
        this(string, 0, 1, bl);
    }

    public FileHandler(String string, int n, int n2) throws IOException, SecurityException {
        this(string, n, n2, LogManager.getBooleanProperty(APPEND_KEY, false));
    }

    public FileHandler(String string, int n, int n2, boolean bl) throws IOException, SecurityException {
        super(null, PROPERTY_PREFIX, Level.ALL, null, FileHandler.class$("java.util.logging.XMLFormatter"));
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = string != null ? string : DEFAULT_PATTERN;
        this.limit = n;
        this.count = n2;
        this.append = bl;
        this.written = 0L;
        this.logFiles = new LinkedList();
        this.setOutputStream(this.createFileStream(this.pattern, n, n2, bl, 0));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private OutputStream createFileStream(String string, int n, int n2, boolean bl, int n3) {
        int n4 = 0;
        LogManager.getLogManager().checkAccess();
        if (string == null) {
            string = LogManager.getLogManager().getProperty(PATTERN_KEY);
        }
        if (string == null) {
            string = DEFAULT_PATTERN;
        }
        if (n2 > 1 && !FileHandler.has(string, 'g')) {
            string = string + ".%g";
        }
        while (true) {
            String string2 = FileHandler.replaceFileNameEscapes(string, n3, n4, n2);
            try {
                File file = new File(string2);
                if (!file.exists() || bl) {
                    FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
                    if (this.logFiles.isEmpty()) {
                        this.logFiles.addFirst(string2);
                    }
                    return new ostr(this, fileOutputStream);
                }
            }
            catch (Exception exception) {
                this.reportError(null, exception, 4);
            }
            ++n4;
            if (FileHandler.has(string, 'u')) continue;
            string = string + ".%u";
        }
    }

    private static String replaceFileNameEscapes(String string, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        int n4 = 0;
        do {
            String string2;
            if (stringBuffer.charAt(n4) == '/') {
                string2 = System.getProperty("file.separator");
                stringBuffer.replace(n4, n4 + 1, string2);
                n4 = n4 + string2.length() - 1;
                continue;
            }
            if (stringBuffer.charAt(n4) != '%') continue;
            switch (stringBuffer.charAt(n4 + 1)) {
                case 't': {
                    string2 = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 'h': {
                    string2 = System.getProperty("user.home");
                    break;
                }
                case 'g': {
                    string2 = Integer.toString(n);
                    bl = true;
                    break;
                }
                case 'u': {
                    string2 = Integer.toString(n2);
                    break;
                }
                case '%': {
                    string2 = "%";
                    break;
                }
                default: {
                    string2 = "??";
                }
            }
            stringBuffer.replace(n4, n4 + 2, string2);
            n4 = n4 + string2.length() - 1;
        } while (++n4 < stringBuffer.length() - 1);
        if (!bl && n3 > 1) {
            stringBuffer.append('.');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public void publish(LogRecord logRecord) {
        if (this.limit > 0 && this.written >= (long)this.limit) {
            this.rotate();
        }
        super.publish(logRecord);
        this.flush();
    }

    private synchronized void rotate() {
        if (this.logFiles.size() > 0) {
            String string;
            File file = null;
            ListIterator listIterator = null;
            if (this.logFiles.size() == this.count) {
                file = new File((String)this.logFiles.getLast());
                file.delete();
                listIterator = this.logFiles.listIterator(this.logFiles.size() - 1);
            } else {
                string = FileHandler.replaceFileNameEscapes(this.pattern, this.logFiles.size(), 0, this.count);
                file = new File(string);
                this.logFiles.addLast(string);
                listIterator = this.logFiles.listIterator(this.logFiles.size() - 1);
            }
            while (listIterator.hasPrevious()) {
                string = (String)listIterator.previous();
                File file2 = new File(string);
                file2.renameTo(file);
                file = file2;
            }
        }
        this.setOutputStream(this.createFileStream(this.pattern, this.limit, this.count, this.append, 0));
        this.written = 0L;
    }

    private static boolean has(String string, char c) {
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if (c2 == c) {
                    return true;
                }
                if (c2 == '%') {
                    bl = false;
                    continue;
                }
            }
            bl = c2 == '%';
        }
        return false;
    }

    static {
        PROPERTY_PREFIX = PROPERTY_PREFIX;
        PATTERN_KEY = PATTERN_KEY;
        DEFAULT_PATTERN = DEFAULT_PATTERN;
        LIMIT_KEY = LIMIT_KEY;
        COUNT_KEY = COUNT_KEY;
        APPEND_KEY = APPEND_KEY;
    }

    private final class ostr
    extends FilterOutputStream {
        private /* synthetic */ FileHandler this$0;

        ostr(FileHandler fileHandler, OutputStream outputStream) {
            this.this$0 = fileHandler;
            super(outputStream);
        }

        public void write(int n) throws IOException {
            this.out.write(n);
            ++this.this$0.written;
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
            this.this$0.written += (long)n2;
        }
    }
}

