/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.VMDirectByteBuffer;

final class IntViewBufferImpl
extends IntBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    IntViewBufferImpl(ByteBuffer byteBuffer, int n) {
        super(n, n, 0, -1);
        this.bb = byteBuffer;
        this.offset = byteBuffer.position();
        this.readOnly = byteBuffer.isReadOnly();
        this.endian = byteBuffer.order();
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, this.offset);
        }
    }

    public IntViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl, ByteOrder byteOrder) {
        super(n2, n3, n4, n5);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteOrder;
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, n);
        }
    }

    public int get() {
        int n = this.position();
        int n2 = ByteBufferHelper.getInt(this.bb, (n << 2) + this.offset, this.endian);
        this.position(n + 1);
        return n2;
    }

    public int get(int n) {
        return ByteBufferHelper.getInt(this.bb, (n << 2) + this.offset, this.endian);
    }

    public IntBuffer put(int n) {
        int n2 = this.position();
        ByteBufferHelper.putInt(this.bb, (n2 << 2) + this.offset, n, this.endian);
        this.position(n2 + 1);
        return this;
    }

    public IntBuffer put(int n, int n2) {
        ByteBufferHelper.putInt(this.bb, (n << 2) + this.offset, n2, this.endian);
        return this;
    }

    public IntBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 4 * this.position(), 4 * n);
            this.position(n);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public IntBuffer slice() {
        return new IntViewBufferImpl(this.bb, (this.position() >> 2) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    IntBuffer duplicate(boolean bl) {
        int n = this.position();
        this.reset();
        int n2 = this.position();
        this.position(n);
        return new IntViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), n, n2, bl, this.endian);
    }

    public IntBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public IntBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }
}

