/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GYearMonthType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GYearMonthType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '-' && i == 0) {
                ++n2;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            if (!bl && c == '-') {
                String string2 = string.substring(n2, i);
                if (string2.length() < 4 || Integer.parseInt(string2) == 0) {
                    throw new DatatypeException(i, "illegal GYear value");
                }
                bl = true;
                n2 = i + 1;
                continue;
            }
            throw new DatatypeException(i, "illegal GYear value");
        }
        if (bl) {
            if (n - n2 != 2) {
                throw new DatatypeException("illegal GYear value");
            }
        } else {
            throw new DatatypeException("illegal GYear value");
        }
    }

    public Object createValue(String string, ValidationContext validationContext) {
        try {
            int n = 5;
            if (string.charAt(0) == '-') {
                ++n;
            }
            GYearMonth gYearMonth = new GYearMonth();
            gYearMonth.year = Integer.parseInt(string.substring(0, n));
            gYearMonth.month = Integer.parseInt(string.substring(n + 1));
            return gYearMonth;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GYearMonth
    implements Comparable {
        int year;
        int month;

        public int hashCode() {
            return this.year * 31 + this.month;
        }

        public boolean equals(Object object) {
            if (object instanceof GYearMonth) {
                GYearMonth gYearMonth = (GYearMonth)object;
                return gYearMonth.year == this.year && gYearMonth.month == this.month;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof GYearMonth) {
                GYearMonth gYearMonth = (GYearMonth)object;
                if (gYearMonth.year == this.year) {
                    if (gYearMonth.month == this.month) {
                        return 0;
                    }
                    if (this.month < gYearMonth.month) {
                        return -1;
                    }
                    return 1;
                }
                if (this.year < gYearMonth.year) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        GYearMonth() {
        }
    }
}

