/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.GNUSecurityParameters;
import gnu.javax.net.ssl.provider.JCESecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SecurityParameters;
import gnu.javax.net.ssl.provider.SessionContext;
import gnu.javax.net.ssl.provider.Util;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

final class Session
implements SSLSession {
    private static final SSLPermission GET_SESSION_CONTEXT_PERMISSION = new SSLPermission("getSSLSessionContext");
    private final long creationTime;
    private Date lastAccessedTime;
    ID sessionId;
    Certificate[] localCerts;
    Certificate[] peerCerts;
    X509Certificate[] peerCertChain;
    String peerHost;
    boolean peerVerified = false;
    SessionContext context;
    HashMap values;
    boolean valid = true;
    List enabledSuites;
    CipherSuite cipherSuite;
    SortedSet enabledProtocols;
    ProtocolVersion protocol;
    byte[] masterSecret;
    SRPTrustManager srpTrustManager;
    X509TrustManager trustManager;
    X509KeyManager keyManager;
    SecureRandom random;
    SecurityParameters params;
    Alert currentAlert;

    Session() {
        this(System.currentTimeMillis());
    }

    Session(long l) {
        this.creationTime = l;
        this.lastAccessedTime = new Date(0L);
        this.values = new HashMap();
        this.params = "true".equalsIgnoreCase(Util.getSecurityProperty("jessie.with.jce")) ? new JCESecurityParameters() : new GNUSecurityParameters(this);
    }

    protected Object clone() {
        Session session = new Session(this.creationTime);
        session.lastAccessedTime = this.lastAccessedTime;
        session.sessionId = this.sessionId;
        session.localCerts = this.localCerts != null ? (Certificate[])this.localCerts.clone() : null;
        session.peerCerts = this.peerCerts != null ? (Certificate[])this.peerCerts.clone() : null;
        session.peerHost = this.peerHost;
        session.peerVerified = this.peerVerified;
        session.context = this.context;
        session.values = this.values;
        session.enabledSuites = new ArrayList(this.enabledSuites);
        session.cipherSuite = this.cipherSuite;
        session.enabledProtocols = new TreeSet(this.enabledProtocols);
        session.protocol = this.protocol;
        session.masterSecret = this.masterSecret;
        session.keyManager = this.keyManager;
        session.srpTrustManager = this.srpTrustManager;
        session.trustManager = this.trustManager;
        session.random = this.random;
        return session;
    }

    public String getCipherSuite() {
        return this.cipherSuite.toString();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        if (this.sessionId != null) {
            return this.sessionId.getId();
        }
        return null;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime.getTime();
    }

    public Certificate[] getLocalCertificates() {
        if (this.localCerts != null) {
            return (Certificate[])this.localCerts.clone();
        }
        return null;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (!this.peerVerified) {
            throw new SSLPeerUnverifiedException("peer not verified");
        }
        if (this.peerCerts != null) {
            return (Certificate[])this.peerCerts.clone();
        }
        return null;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (!this.peerVerified) {
            throw new SSLPeerUnverifiedException("peer not verified");
        }
        if (this.peerCerts == null) {
            return null;
        }
        if (this.peerCertChain != null) {
            return (X509Certificate[])this.peerCertChain.clone();
        }
        try {
            this.peerCertChain = new X509Certificate[this.peerCerts.length];
            for (int i = 0; i < this.peerCerts.length; ++i) {
                this.peerCertChain[i] = X509Certificate.getInstance(this.peerCerts[i].getEncoded());
            }
            return (X509Certificate[])this.peerCertChain.clone();
        }
        catch (CertificateException certificateException) {
            return null;
        }
        catch (java.security.cert.CertificateException certificateException) {
            return null;
        }
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GET_SESSION_CONTEXT_PERMISSION);
        }
        return this.context;
    }

    public String[] getValueNames() {
        Set set = this.values.keySet();
        return (String[])set.toArray(new String[set.size()]);
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public void putValue(String string, Object object) {
        this.values.put(string, object);
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
        }
    }

    public void removeValue(String string) {
        Object object = this.values.remove(string);
        if (object != null && object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
        }
    }

    public void invalidate() {
        if (this.masterSecret != null) {
            for (int i = 0; i < this.masterSecret.length; ++i) {
                this.masterSecret[i] = 0;
            }
            this.masterSecret = null;
        }
        this.valid = false;
    }

    synchronized void access() {
        this.lastAccessedTime.setTime(System.currentTimeMillis());
        this.context.notifyAccess(this);
    }

    void setLastAccessedTime(long l) {
        this.lastAccessedTime.setTime(l);
    }

    static final class ID
    implements Comparable {
        private final byte[] id;

        ID(byte[] byArray) {
            if (byArray == null) {
                throw new IllegalArgumentException();
            }
            this.id = byArray;
        }

        public byte[] getId() {
            return (byte[])this.id.clone();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ID)) {
                return false;
            }
            return Arrays.equals(this.id, ((ID)object).id);
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.id.length; ++i) {
                n |= (this.id[i] & 0xFF) << ((i & 3) << 3 & 0x1F);
            }
            return n;
        }

        public int compareTo(Object object) {
            if (object == null || !(object instanceof ID)) {
                return 1;
            }
            byte[] byArray = ((ID)object).id;
            if (this.id.length != byArray.length) {
                if (this.id.length < byArray.length) {
                    return -1;
                }
                return 1;
            }
            for (int i = 0; i < this.id.length; ++i) {
                if (this.id[i] < byArray[i]) {
                    return -1;
                }
                if (this.id[i] <= byArray[i]) continue;
                return 1;
            }
            return 0;
        }

        public String toString() {
            return Util.toHexString(this.id, ':');
        }
    }
}

