/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.javax.crypto.sasl.srp.SecurityContext;
import gnu.javax.crypto.sasl.srp.StoreEntry;
import java.util.HashMap;

public class ServerStore {
    private static ServerStore singleton = null;
    private static final HashMap sid2ssc = new HashMap();
    private static final HashMap sid2ttl = new HashMap();
    private static final Object lock = new Object();
    private static int counter = 0;

    private ServerStore() {
    }

    static final synchronized ServerStore instance() {
        if (singleton == null) {
            singleton = new ServerStore();
        }
        return singleton;
    }

    static final synchronized byte[] getNewSessionID() {
        String string = String.valueOf(++counter);
        return ("SID-" + "0000000000".substring(0, 10 - string.length()) + string).getBytes();
    }

    boolean isAlive(byte[] byArray) {
        boolean bl = false;
        if (byArray != null && byArray.length != 0) {
            Object object = lock;
            synchronized (object) {
                String string;
                block4: {
                    try {
                        string = new String(byArray);
                        StoreEntry storeEntry = (StoreEntry)sid2ttl.get(string);
                        if (storeEntry == null || (bl = storeEntry.isAlive())) break block4;
                        sid2ssc.remove(string);
                        sid2ttl.remove(string);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        throw throwable;
                    }
                }
                string = null;
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    void cacheSession(int n, SecurityContext securityContext) {
        Object object = lock;
        synchronized (object) {
            String string;
            try {
                string = new String(securityContext.getSID());
                sid2ssc.put(string, securityContext);
                sid2ttl.put(string, new StoreEntry(n));
            }
            finally {
                string = null;
            }
            return;
        }
    }

    SecurityContext restoreSession(byte[] byArray) {
        String string = new String(byArray);
        Object object = lock;
        synchronized (object) {
            SecurityContext securityContext;
            SecurityContext securityContext2;
            try {
                securityContext2 = (SecurityContext)sid2ssc.remove(string);
                sid2ttl.remove(string);
            }
            finally {
                securityContext = null;
            }
            securityContext = securityContext2;
            return securityContext;
        }
    }

    void invalidateSession(byte[] byArray) {
        String string = new String(byArray);
        Object object = lock;
        synchronized (object) {
            try {
                sid2ssc.remove(string);
                sid2ttl.remove(string);
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }
}

