/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.pkcs;

import gnu.java.security.OID;
import gnu.java.security.ber.BER;
import gnu.java.security.ber.BEREncodingException;
import gnu.java.security.ber.BERReader;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class SignerInfo {
    private static final Logger log = Logger.getLogger(SignerInfo.class$("gnu.java.security.pkcs.SignerInfo").getName());
    private final BigInteger version;
    private final BigInteger serialNumber;
    private final X500Principal issuer;
    private final OID digestAlgorithmId;
    private final byte[] digestAlgorithmParams;
    private final byte[] authenticatedAttributes;
    private final OID digestEncryptionAlgorithmId;
    private final byte[] digestEncryptionAlgorithmParams;
    private final byte[] encryptedDigest;
    private final byte[] unauthenticatedAttributes;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SignerInfo(BERReader bERReader) throws IOException {
        DERValue dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed SignerInfo");
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() != 2) {
            throw new BEREncodingException("malformed Version");
        }
        this.version = (BigInteger)dERValue.getValue();
        log.fine("  Version: " + this.version);
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed IssuerAndSerialNumber");
        }
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed Issuer");
        }
        this.issuer = new X500Principal(dERValue.getEncoded());
        bERReader.skip(dERValue.getLength());
        dERValue = bERReader.read();
        if (dERValue.getTag() != 2) {
            throw new BEREncodingException("malformed SerialNumber");
        }
        this.serialNumber = (BigInteger)dERValue.getValue();
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed DigestAlgorithmIdentifier");
        }
        boolean bl = false;
        DERValue dERValue2 = bERReader.read();
        if (dERValue2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestAlgorithmId = (OID)dERValue2.getValue();
        if (BERValue.isIndefinite(dERValue)) {
            dERValue2 = bERReader.read();
            if (dERValue2 != BER.END_OF_SEQUENCE) {
                this.digestAlgorithmParams = dERValue2.getEncoded();
                dERValue2 = bERReader.read();
                if (dERValue2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestAlgorithmParams = null;
            }
        } else if (dERValue2.getEncodedLength() < dERValue.getLength()) {
            dERValue2 = bERReader.read();
            this.digestAlgorithmParams = dERValue2.getEncoded();
            if (dERValue2.isConstructed()) {
                bERReader.skip(dERValue2.getLength());
            }
        } else {
            this.digestAlgorithmParams = null;
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() == 0) {
            this.authenticatedAttributes = dERValue.getEncoded();
            dERValue = bERReader.read();
            if (dERValue.isConstructed()) {
                bERReader.skip(dERValue.getLength());
            }
            dERValue = bERReader.read();
        } else {
            this.authenticatedAttributes = null;
        }
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed DigestEncryptionAlgorithmIdentifier");
        }
        bl = false;
        dERValue2 = bERReader.read();
        if (dERValue2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestEncryptionAlgorithmId = (OID)dERValue2.getValue();
        if (BERValue.isIndefinite(dERValue)) {
            dERValue2 = bERReader.read();
            if (dERValue2 != BER.END_OF_SEQUENCE) {
                this.digestEncryptionAlgorithmParams = dERValue2.getEncoded();
                dERValue2 = bERReader.read();
                if (dERValue2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestEncryptionAlgorithmParams = null;
            }
        } else if (dERValue2.getEncodedLength() < dERValue.getLength()) {
            dERValue2 = bERReader.read();
            this.digestEncryptionAlgorithmParams = dERValue2.getEncoded();
            if (dERValue2.isConstructed()) {
                bERReader.skip(dERValue2.getLength());
            }
        } else {
            this.digestEncryptionAlgorithmParams = null;
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() != 4) {
            throw new BEREncodingException("malformed EncryptedDigest");
        }
        this.encryptedDigest = (byte[])dERValue.getValue();
        this.unauthenticatedAttributes = (byte[])(bERReader.peek() == 1 ? bERReader.read().getEncoded() : null);
        if (bERReader.peek() == 0) {
            bERReader.read();
        }
    }

    public SignerInfo(X500Principal x500Principal, BigInteger bigInteger, OID oID, byte[] byArray, OID oID2, byte[] byArray2, byte[] byArray3) {
        this.version = BigInteger.ONE;
        this.issuer = x500Principal;
        this.serialNumber = bigInteger;
        this.digestAlgorithmId = oID;
        this.digestAlgorithmParams = null;
        this.authenticatedAttributes = byArray;
        this.digestEncryptionAlgorithmId = oID2;
        this.digestEncryptionAlgorithmParams = null;
        this.encryptedDigest = byArray2;
        this.unauthenticatedAttributes = byArray3;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public OID getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public byte[] getDigestAlgorithmParams() {
        if (this.digestAlgorithmParams != null) {
            return (byte[])this.digestAlgorithmParams.clone();
        }
        return null;
    }

    public byte[] getAuthenticatedAttributes() {
        if (this.authenticatedAttributes != null) {
            return (byte[])this.authenticatedAttributes.clone();
        }
        return null;
    }

    public OID getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getDigestEncryptionAlgorithmParams() {
        if (this.digestEncryptionAlgorithmParams != null) {
            return (byte[])this.digestEncryptionAlgorithmParams.clone();
        }
        return null;
    }

    public byte[] getEncryptedDigest() {
        if (this.encryptedDigest != null) {
            return (byte[])this.encryptedDigest.clone();
        }
        return null;
    }

    public byte[] getUnauthenticatedAttributes() {
        if (this.unauthenticatedAttributes != null) {
            return (byte[])this.unauthenticatedAttributes.clone();
        }
        return null;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DERValue dERValue = new DERValue(2, this.version);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byteArrayOutputStream.write(this.issuer.getEncoded());
        DERValue dERValue2 = new DERValue(2, this.serialNumber);
        DERWriter.write(byteArrayOutputStream, dERValue2);
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DERValue dERValue3 = new DERValue(48, byArray.length, byArray, null);
        DERValue dERValue4 = new DERValue(6, this.digestAlgorithmId);
        ArrayList arrayList = new ArrayList(1);
        arrayList.add(dERValue4);
        DERValue dERValue5 = new DERValue(48, arrayList);
        if (this.authenticatedAttributes == null) {
            DERValue dERValue6 = new DERValue(5, null);
        } else {
            DERValue dERValue7 = new DERValue(49, this.authenticatedAttributes);
        }
        DERValue dERValue8 = new DERValue(6, this.digestEncryptionAlgorithmId);
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(dERValue8);
        DERValue dERValue9 = new DERValue(48, arrayList2);
        DERValue dERValue10 = new DERValue(4, this.encryptedDigest);
        if (this.unauthenticatedAttributes == null) {
            DERValue dERValue11 = new DERValue(5, null);
        } else {
            DERValue dERValue12 = new DERValue(49, this.unauthenticatedAttributes);
        }
        ArrayList arrayList3 = new ArrayList(5);
        arrayList3.add(dERValue);
        arrayList3.add(dERValue3);
        arrayList3.add(dERValue5);
        arrayList3.add(dERValue9);
        arrayList3.add(dERValue10);
        DERValue dERValue13 = new DERValue(48, arrayList3);
        DERWriter.write(outputStream, dERValue13);
    }
}

