createmailitemmodule.prototype = new ItemModule;
createmailitemmodule.prototype.constructor = createmailitemmodule;
createmailitemmodule.superclass = ItemModule.prototype;

function createmailitemmodule(id)
{
	if(arguments.length > 0) {
		this.init(id);
	}
}

createmailitemmodule.prototype.init = function(id)
{
	createmailitemmodule.superclass.init.call(this, id);
	
	/**
	 * Build "Add Signature" menu
	 */
	this.addSigMenuItems = new Array();
	// Get signature IDs 
	var id_lookup = String(parentWebclient.settings.get("createmail/signatures/id_lookup",""));
	if(id_lookup != ""){
		var signatureIDs = id_lookup.split(";");
		// Get the signature data and add to menu
		for(var i=0;i<signatureIDs.length;i++){
			// Prepare data object to hold the signature ID that we can use when we click on the menu item.
			var data = new Object();
			data["sig_id"] = signatureIDs[i];
			// Get signature from settings.
			var sig_name = parentWebclient.settings.get("createmail/signatures/"+signatureIDs[i]+"/name","");
			// Add to menu
			this.addSigMenuItems.push(webclient.menu.createMenuItem("addsignature", sig_name, false, eventAddSignatureMenuItem, null, null, data));
		}
	}

	this.message_action = false;
	this.message_action_entryid = false;
}


createmailitemmodule.prototype.execute = function(type, action)
{
	switch(type)
	{
		case "item":
			webclient.menu.showMenu();
			this.item(action);
			break;	
		
		case "update":
			this.updateMessage(action);
			break;
	}
}

/**
Function which updates entryid element, before sending the mail, so that draft message is removed when submitting message.
@param action -info that is to be updated.
*/
createmailitemmodule.prototype.updateMessage = function(action)
{
	var item = action.getElementsByTagName("item")[0];
	var entryid = item.getElementsByTagName("entryid")[0];
	var parententryid = item.getElementsByTagName("parententryid")[0];	

	var property = new Object();
	property["entryid"] = (entryid && entryid.firstChild ?entryid.firstChild.nodeValue:false);
	property["parententryid"] = (parententryid && parententryid.firstChild ?parententryid.firstChild.nodeValue:false);
	
	var entryidElement = dhtml.getElementById("entryid");
	var parententryidElement = dhtml.getElementById("parent_entryid");
	
	if (entryidElement && parententryidElement){
		entryidElement.value = property["entryid"];
		parententryidElement.value = property["parententryid"];
	}

	var attachments = item.getElementsByTagName("attachment");
	if(attachments && attachments.length > 0) {
		this.attachments = new Array();
		this.newattachments = new Array();
		this.deletedattachments = new Object();
		for(var i = 0; i < attachments.length; i++)
		{
			var attach_num = attachments[i].getElementsByTagName("attach_num")[0];
			var attach_method = attachments[i].getElementsByTagName("attach_method")[0];
			var name = attachments[i].getElementsByTagName("name")[0];
			var size = attachments[i].getElementsByTagName("size")[0];
			
			if(attach_num && attach_num.firstChild) {
				var attachment = new Object();
				attachment["attach_num"] = attach_num.firstChild.nodeValue;
				
				if(attach_method && attach_method.firstChild) {
					attachment["attach_method"] = attach_method.firstChild.nodeValue;
				}
				
				if(name && name.firstChild) {
					attachment["name"] = name.firstChild.nodeValue;
				}
				
				if(size && size.firstChild) {
					attachment["size"] = size.firstChild.nodeValue;
				}
				
				this.attachments.push(attachment);
			}
		}
		this.setAttachments();
	}
	window.waitForSaveResponse = false;
}

createmailitemmodule.prototype.item = function(action)
{

	var message = action.getElementsByTagName("item")[0];
	
	if(message && message.childNodes) {
		var attachments = message.getElementsByTagName("attachment");
	
		if(attachments && attachments.length > 0) {
			for(var i = 0; i < attachments.length; i++)
			{
				var attach_num = attachments[i].getElementsByTagName("attach_num")[0];
				var attach_method = attachments[i].getElementsByTagName("attach_method")[0];
				var name = attachments[i].getElementsByTagName("name")[0];
				var size = attachments[i].getElementsByTagName("size")[0];
				
				if(attach_num && attach_num.firstChild) {
					var attachment = new Object();
					attachment["attach_num"] = attach_num.firstChild.nodeValue;
					
					if(attach_method && attach_method.firstChild) {
						attachment["attach_method"] = attach_method.firstChild.nodeValue;
					}
					
					if(name && name.firstChild) {
						attachment["name"] = name.firstChild.nodeValue;
					}
					
					if(size && size.firstChild) {
						attachment["size"] = size.firstChild.nodeValue;
					}
					
					this.attachments.push(attachment);
				}
			}
		}

		switch(this.message_action)
		{
			case "reply":
				this.setSender(message);
				this.setSubjectBody(message, _("RE"));
				break;
			case "replyall":
				this.setSender(message);
				this.setRecipients(message, "replyall");
				this.setSubjectBody(message, _("RE"));
				break;
			case "forward":
				this.setSubjectBody(message, _("FW"));
				this.setAttachments(message);
				break;
			default:
				this.setRecipients(message);
				this.setBody(message, false, true);
				
				for(var i = 0; i < message.childNodes.length; i++)
				{
					var property = message.childNodes[i];
					
					if(property && property.firstChild)
					{
						var element = dhtml.getElementById(property.tagName);
						
						if(element) {
							element.value = property.firstChild.nodeValue;
						}
					}
				}
				
				this.setAttachments(message);
				break;
		}

		this.setFrom(message);
	}

	setImportance(parseInt(dhtml.getElementById("importance").value));
}

createmailitemmodule.prototype.checkNames = function(action)
{
	var names = action.getElementsByTagName("name");
	
	if(names && names.length > 0) {
		var to = dhtml.getElementById("to").value.split(";");
		var cc = dhtml.getElementById("cc").value.split(";");
		var bcc = dhtml.getElementById("bcc").value.split(";");

		this.setName(names, "to", to);
		this.setName(names, "cc", cc);
		this.setName(names, "bcc", bcc);
	}
}

createmailitemmodule.prototype.setName = function(names, type, recipients)
{
	var recipienttype = dhtml.getElementById(type);
	
	if(recipienttype) {
		recipienttype.value = "";
		
    	for(var i = 0; i < recipients.length; i++)
        {
        	var recipient = recipients[i];

            if(recipient != " " && recipient.length > 1) {
            	if(recipient.indexOf(" ") == 0) {
            		recipient = recipient.substring(1);
            	}
				
				for(var j = 0; j < names.length; j++)
				{
					var name = names[j];
            		var nameid = name.getElementsByTagName("nameid")[0];
            		var nametype = name.getElementsByTagName("nametype")[0];
            		var emailaddress = name.getElementsByTagName("emailaddress")[0];
    
            		if(nameid && nameid.firstChild && nametype && nametype.firstChild && emailaddress && emailaddress.firstChild) {
              			if(nametype.firstChild.nodeValue == type)
              			{  	
              				if(nameid.firstChild.nodeValue == recipient) {
		                		recipient = emailaddress.firstChild.nodeValue;
        		        	}
            			}
            		}
            	}
        
            	recipienttype.value += recipient + "; ";
            }
    	}
    }
}

createmailitemmodule.prototype.setSender = function(message)
{
	var replyto = message.getElementsByTagName("reply-to");
	var element = dhtml.getElementById("to");

	if(replyto.length > 0) {
		for(var i = 0; i < replyto.length; i++)
		{
			var email_address = replyto[i].getElementsByTagName("email_address")[0];
	
			if(email_address && email_address.firstChild) {
				element.value = email_address.firstChild.nodeValue + "; ";
			}
		}
	} else {
		var sent_representing_email_address = dhtml.getTextNode(message.getElementsByTagName("sent_representing_email_address")[0],"");		
		var sent_representing_name = dhtml.getTextNode(message.getElementsByTagName("sent_representing_name")[0],"");
		
		element.value = nameAndEmailToString(sent_representing_name,sent_representing_email_address,false) + "; ";
	}
}

createmailitemmodule.prototype.setSubjectBody = function(message, type)
{
	var subject = message.getElementsByTagName("subject")[0];

	var subjectElement = dhtml.getElementById("subject");
	if(subject && subject.firstChild) {
		var subjectValue = subject.firstChild.nodeValue;
		if(subject.firstChild.nodeValue.indexOf(type) < 0) {
			subjectValue = type + ": " + subjectValue;
		}
		
		subjectElement.value = subjectValue;
	}else if(type){
		subjectElement.value = type + ": ";
	}
	
	this.setBody(message, true);
}

createmailitemmodule.prototype.setBody = function(message, isReply, isConcept)
{
	var html_body = dhtml.getElementById("html_body");
	var use_html = dhtml.getElementById("use_html");

	if(html_body) {
		var content = "";
		var replyinfo = "";
		var reply_seperator = "";
		var contentprefix = "";
		var contentpostfix = "";
		var signature_seperator = "";
		
		var htmlFormat = use_html.value == "true" ? true : false;

		if(message) {
			var sent_representing_email_address = dhtml.getTextNode(message.getElementsByTagName("sent_representing_email_address")[0],"");		
			var sent_representing_name = dhtml.getTextNode(message.getElementsByTagName("sent_representing_name")[0],"");
			var message_delivery_time = dhtml.getTextNode(message.getElementsByTagName("message_delivery_time")[0]);
				if(message_delivery_time){
					message_delivery_time = strftime(_("%a %x %X"), message_delivery_time);
				}
				
			var received_by_email_address = dhtml.getTextNode(message.getElementsByTagName("received_by_email_address")[0],"");
			var subject = dhtml.getTextNode(message.getElementsByTagName("subject")[0],"");
			var body = message.getElementsByTagName("body")[0];
			var isHTML = dhtml.getTextNode(message.getElementsByTagName("isHTML")[0],false);

			sent_representing_email_address = nameAndEmailToString(sent_representing_name,sent_representing_email_address,htmlFormat);
			
			if(body && body.firstChild) {
				var element = body.firstChild;
				for(var i = 0; i < body.childNodes.length; i++)
				{
					content += element.nodeValue;
					element = element.nextSibling;
				}
			}

			// HTML reply with a HTML email
			if(isHTML && htmlFormat){
				// Get index of the start of the body content
				var bodyOpenIndex = content.search(/<body/gi);
				if(bodyOpenIndex > 0){
					// Fetch index after body tag
					bodyOpenIndex = content.indexOf(">", bodyOpenIndex) + 1;
				}else{
					bodyOpenIndex = 0;
				}
				// Get index of the end of the body content
				var bodyCloseIndex = content.search(/<\/body/gi);
				if(bodyCloseIndex == -1){
					bodyCloseIndex = content.length;
				}
				// Extract body content
				content = content.slice(bodyOpenIndex, bodyCloseIndex);

				// Remove some more tags
				content = removeTagFromSource(content, "head", true, true);
				content = removeTagFromSource(content, "style", true);
				content = removeTagFromSource(content, "script", false);
				content = removeTagFromSource(content, "title", true);
				content = removeTagFromSource(content, "meta", false);
				content = removeTagFromSource(content, "base", false);
				content = removeTagFromSource(content, "link", false);

				// HACK: Remove newlines to fix HTML
				content = content.replace(/\n/g, " ");
				content = content.replace(/\r/g, " ");

				// Remove all image tags of all inline images
				var images_result = content.match(/<img[^>]*>/gmi);
				if(typeof images_result == "object" && images_result != null && images_result.length > 1){
					// Loop through all image tags
					for(var i=0;i<images_result.length;i++){
						// Split the image tag up to find the source attribute
						var image_attr = images_result[i].split(" ");
						// Loop through all attributes
						for(var j=0;j<image_attr.length;j++){
							// Filter out source attribute
							if(image_attr[j].substr(0,4).toLowerCase() == "src="){
								// We only need to have the value of the attribute
								var image_src = image_attr[j].substr(4, image_attr[j].length);
								// Remove the qoutes 
								image_src = image_src.replace(/\'/g, "");
								image_src = image_src.replace(/\"/g, "");
								// Filter out inline images
								if(image_src.substr(0, 7) != "http://" && image_src.substr(0, 8) != "https://"){
									// Get starting position of the image tag in the email content
									var l_iStartIndex = content.indexOf(images_result[i]);
									if(l_iStartIndex > 0){
										// Get the part before the image tag and after the image tag and glue it together
										content = content.slice(0, l_iStartIndex) + content.slice((images_result[i].length + l_iStartIndex), content.length);
									}
								}
							}
						}
					}
				}
			}

			if (!isHTML && htmlFormat){
				// please note that currently all replies and forwards are plain text!
				content = content.replace(/&/g, "&amp;");
				content = content.replace(/</g, "&lt;");
				content = content.replace(/>/g, "&gt;");
				content = content.replace(/ {2}/g, " &nbsp;");
			}

			if(isReply) {
				//get Recipients
				var recipients = message.getElementsByTagName("recipients")[0].getElementsByTagName("recipient");
				var recipientList = new Object();
				for(var i=0; i<recipients.length; i++){
					var resDisplayName = dhtml.getTextNode(recipients[i].getElementsByTagName("display_name")[0],"");
					var resEmailAddress = dhtml.getTextNode(recipients[i].getElementsByTagName("email_address")[0],"");
					var resType = dhtml.getTextNode(recipients[i].getElementsByTagName("type")[0],"");
					if (resType != "bcc"){
						switch(resType){
							case "to":
								resType = _("To");
								break;
							case "cc":
								resType = _("CC");
								break;
						}
						if(!recipientList[resType]){
							recipientList[resType] = "";
						}
						
						recipientList[resType] += nameAndEmailToString(resDisplayName,resEmailAddress,htmlFormat)+"; ";
					}
				}
							
				if(htmlFormat) {
					reply_seperator = "<p>&nbsp;<br/>&nbsp;</p>";
					contentprefix = "<blockquote style='border-left: 2px solid #325FBA; padding-left: 5px;margin-left:5px;'>";
					replyinfo = "-----" + _("Original message") + "-----<br />";
					replyinfo += "<strong>" + _("From") + ":</strong> " + sent_representing_email_address + "<br />";
					replyinfo += "<strong>" + _("Sent") + ":</strong> " + message_delivery_time + "<br />";
					for(var resType in recipientList){
						replyinfo += "<strong>" + resType + ":</strong> " + recipientList[resType] + "<br />";
					}				
					replyinfo += "<strong>" + _("Subject") + ":</strong> " + subject + "<br /><br />";
					contentpostfix = "</blockquote>";
				} else {
					reply_seperator = "\n\n";
					replyinfo = "-----" + _("Original message") + "-----\n";
					replyinfo += _("From") + ": " + sent_representing_email_address + "\n";
					replyinfo += _("Sent") + ": " + message_delivery_time + "\n";
					for(var resType in recipientList){
						replyinfo += resType + ": " + recipientList[resType] + "\n";
					}
					replyinfo += _("Subject") + ": " + subject + "\n\n";

					// plain text reply/forward, use ">" to quote the message
					content = content.wordWrap(80,"\n")
					content = content.replace(/^/g,"> ");
					content = content.replace(/\n/g,"\n> ");
				}
			}
		}

		var signature = "";
		if(!isConcept){
			signature = this.getSignature();
			if(signature && signature != ""){
				if (htmlFormat){
					signature = signature.htmlEntities();
					signature_seperator = "<p>&nbsp;<br/>&nbsp;</p>";
				} else {
					signature_seperator = "\n\n";
				}
				signature = signature_seperator + signature;
			}
		}
		
		content = signature + reply_seperator + contentprefix + replyinfo + content + contentpostfix;
		if(htmlFormat) {
			content = content.replace(/\n/g, "<br />");
		}

		// Check if HTML editor is loaded and set the body
		if((typeof FCKeditorAPI != "undefined") && (fckEditor = FCKeditorAPI.GetInstance("html_body"))) {
			document.fckEditor = fckEditor;
			document.fckEditorContent = content;

			window.setTimeout(setBodyAfterTimeOut, "500");
		} else {
			html_body.value = content;
		}
	}
}

createmailitemmodule.prototype.setData = function(data)
{
	if(data["storeid"]) {
		this.storeid = data["storeid"];
	}
	
	if(data["parententryid"]) { 
		this.parententryid = data["parententryid"];
	}
	
	if(data["message_action"]) { 
		this.message_action = data["message_action"];
		
		if(data["message_action_entryid"]) {
			this.message_action_entryid = data["message_action_entryid"];
		}
	}
}

createmailitemmodule.prototype.save = function(props, send, recipients, dialog_attachments)
{
	var data = new Object();
	if(this.storeid) {
		data["store"] = this.storeid;
	}
	
	data["props"] = props;
	data["recipients"] = recipients;
	data["dialog_attachments"] = dialog_attachments;
	
	// We don't want to save attachments again if message is already saved.	
	if(this.message_action && (typeof props["entryid"] != 'undefined' && props["entryid"] == '')) {
		data["message_action"] = new Object();
		data["message_action"]["action_type"] = this.message_action;
		data["message_action"]["entryid"] = this.message_action_entryid;
		data["message_action"]["storeid"] = this.storeid;
	}
	
	if(send) {
		data["send"] = true;
	}

	if(parentWebclient) {
		parentWebclient.xmlrequest.addData(this, "save", data, webclient.modulePrefix);
		parentWebclient.xmlrequest.sendRequest(true);
	} else {
		webclient.xmlrequest.addData(this, "save", data);
		webclient.xmlrequest.sendRequest();
	}
}

/**
 * getSignature
 * 
 * Retrieve signature from the Settings Object. 
 * If no ID is supplied then check message_action (newmsg, reply, fwd).
 * @param id number (Optional) ID of the signature that needs to be retrieved.
 */
createmailitemmodule.prototype.getSignature = function(id){
	var signatureID = false;
	var sig_content = "";
	if(id){
		var name = parentWebclient.settings.get("createmail/signatures/"+id+"/name", false);
		if(name){
			signatureID = id;
		}else{
			signatureID = false;
		}
	}else{
		switch(this.message_action){
			case "reply":
			case "replyall":
			case "forward":
				signatureID = parentWebclient.settings.get("createmail/signatures/select_sig_replyfwd", false);
				break;
			default:
				signatureID = parentWebclient.settings.get("createmail/signatures/select_sig_newmsg", false);
		}
	}
	if(signatureID){
		sig_content = parentWebclient.settings.get("createmail/signatures/"+signatureID+"/content","");
	}
	return sig_content;
}

function setBodyAfterTimeOut()
{
	if(document.fckEditor && document.fckEditor.SetHTML) {
		document.fckEditor.SetHTML(document.fckEditorContent);
		document.fckEditor = false;
		document.fckEditorContent = false;
	} else {
		window.setTimout(setBody, '500');
	}
}

/**
 * eventAddSignatureMenuItem
 * 
 * 
 * @param moduleObject object module
 * @param element HTMLelem referenced element
 * @param event object event
 */
function eventAddSignatureMenuItem(moduleObject, element, event){
	element.parentNode.style.display = "none";
	addSignature(element.data["sig_id"]);
}
