/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

// IECServiceAdmin.h: interface for the IECServiceAdmin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef IECSERVICEADMIN
#define IECSERVICEADMIN

#include "ECDefs.h"

class IECServiceAdmin : public IUnknown {
public:
	// Create/Delete stores
	virtual HRESULT __stdcall CreateStore(ULONG ulStoreType, ULONG ulUserId, ULONG* lpcbStoreId, LPENTRYID* lppStoreId, ULONG* lpcbRootId, LPENTRYID *lppRootId) = 0;
	virtual HRESULT __stdcall ResolveStore(ULONG ulStoreId, ULONG *lpulUserID, ULONG* lpcbStoreID, LPENTRYID* lppStoreID) = 0;
	virtual HRESULT __stdcall GetStore(ULONG ulUserId, ULONG *lpulStoreId) = 0;
	virtual HRESULT __stdcall DeleteStore(ULONG ulStoreId) = 0;

	// User functions
	virtual HRESULT __stdcall CreateUser(LPECUSER lpECUser, ULONG *lpulUserId) = 0;
	virtual HRESULT __stdcall DeleteUser(ULONG ulUserId) = 0;
	virtual HRESULT __stdcall SetUser(LPECUSER lpECUser) = 0;
	virtual HRESULT __stdcall GetUser(ULONG ulUserId, LPECUSER *lppECUser) = 0;
	virtual HRESULT __stdcall ResolveUserName(char *lpszUserName, ULONG *lpulUserId) = 0;
	virtual HRESULT __stdcall GetUserList(ULONG ulCompanyId, ULONG *lpcUsers, LPECUSER *lppsUsers) = 0;
	virtual HRESULT __stdcall GetSendAsList(ULONG ulUserId, ULONG *lpcSenders, LPECUSER *lppSenders) = 0;
	virtual HRESULT __stdcall AddSendAsUser(ULONG ulUserId, ULONG ulSenderId) = 0;
	virtual HRESULT __stdcall DelSendAsUser(ULONG ulUserId, ULONG ulSenderId) = 0;

	// Group functions
	virtual HRESULT __stdcall CreateGroup(LPECGROUP lpECGroup, ULONG *lpulGroupId) = 0;
	virtual HRESULT __stdcall DeleteGroup(ULONG ulGroupId) = 0;
	virtual HRESULT __stdcall SetGroup(LPECGROUP lpECGroup) = 0;
	virtual HRESULT __stdcall GetGroup(ULONG ulGroupId, LPECGROUP *lppECGroup) = 0;
	virtual HRESULT __stdcall ResolveGroupName(char *lpszGroupName, ULONG *lpulGroupId) = 0;
	virtual HRESULT __stdcall GetGroupList(ULONG ulCompanyId, ULONG *lpcGroups, LPECGROUP *lppsGroups) = 0;

	virtual HRESULT __stdcall DeleteGroupUser(ULONG ulGroupId, ULONG ulUserId) = 0;
	virtual HRESULT __stdcall AddGroupUser(ULONG ulGroupId, ULONG ulUserId) = 0;
	virtual HRESULT __stdcall GetUserListOfGroup(ULONG ulGroupId, ULONG *lpcUsers, LPECUSER *lppsUsers) = 0;
	virtual HRESULT __stdcall GetGroupListOfUser(ULONG ulUserId, ULONG *lpcGroups, LPECGROUP *lppsGroups) = 0;

	// Company functions
	virtual HRESULT __stdcall CreateCompany(LPECCOMPANY lpECCompany, ULONG *lpulCompanyId) = 0;
	virtual HRESULT __stdcall DeleteCompany(ULONG ulCompanyId) = 0;
	virtual HRESULT __stdcall SetCompany(LPECCOMPANY lpECCompany) = 0;
	virtual HRESULT __stdcall GetCompany(ULONG ulCompanyId, LPECCOMPANY *lppECCompany) = 0;
	virtual HRESULT __stdcall ResolveCompanyName(char *lpszCompanyName, ULONG *lpulCompanyId) = 0;
	virtual HRESULT __stdcall GetCompanyList(ULONG *lpcCompanies, LPECCOMPANY *lppsCompanies) = 0;

	virtual HRESULT __stdcall AddCompanyToRemoteViewList(ULONG ulSetCompanyId, ULONG ulCompanyId) = 0;
	virtual HRESULT __stdcall DelCompanyFromRemoteViewList(ULONG ulSetCompanyId, ULONG ulCompanyId) = 0;
	virtual HRESULT __stdcall GetRemoteViewList(ULONG ulCompanyId, ULONG *lpcCompanies, LPECCOMPANY *lppsCompanies) = 0;
	virtual HRESULT __stdcall AddUserToRemoteAdminList(ULONG ulUserId, ULONG ulCompanyId) = 0;
	virtual HRESULT __stdcall DelUserFromRemoteAdminList(ULONG ulUserId, ULONG ulCompanyId) = 0;
	virtual HRESULT __stdcall GetRemoteAdminList(ULONG ulCompanyId, ULONG *lpcUsers, LPECUSER *lppsUsers) = 0;

	virtual HRESULT __stdcall SyncUsers(ULONG ulCompanyId) = 0;

	virtual HRESULT __stdcall GetQuota(ULONG ulUserId, LPECQUOTA* lppsQuota) = 0;
	virtual HRESULT __stdcall SetQuota(ULONG ulUserId, LPECQUOTA lpsQuota) = 0;

	virtual HRESULT __stdcall AddQuotaRecipient(ULONG ulCompanyId, ULONG ulRecipientId, ULONG ulType) = 0;
	virtual HRESULT __stdcall DeleteQuotaRecipient(ULONG ulCompanyId, ULONG ulRecipientId, ULONG ulType) = 0;
	virtual HRESULT __stdcall GetQuotaRecipients(ULONG ulUserId, ULONG *lpcUsers, LPECUSER *lppsUsers) = 0;

	virtual HRESULT __stdcall GetQuotaStatus(ULONG ulUserId, LPECQUOTASTATUS* lppsQuotaStatus) = 0;
	
	virtual HRESULT __stdcall PurgeSoftDelete(ULONG ulDays) = 0;
};

#endif // #ifndef IECSERVICEADMIN
