<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1458 $
 * $Id: EmbeddedMessageList.php 1458 2007-11-20 22:46:59Z ipso $
 * $Date: 2007-11-20 14:46:59 -0800 (Tue, 20 Nov 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('message','enabled')
		OR !( $permission->Check('message','view') OR $permission->Check('message','view_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Message List') ); // See index.php
//BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'object_type_id',
												'object_id',
												'parent_id',
												'message_data',
												'template',
												'close'
												) ) );
$mf = new MessageFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit_message':
		//Debug::setVerbosity(11);
		if ( !$permission->Check('message','enabled')
			OR !( $permission->Check('message','add') ) ) {

			$permission->Redirect( FALSE ); //Redirect

		}

		if ( isset($object_type_id) AND isset($object_id) ) {
			if ( !isset($parent_id) ) {
				$parent_id = 0;
			}

			$mf->setObjectType( $object_type_id );
			$mf->setObject( $object_id );
			$mf->setParent( $parent_id );
			$mf->setPriority();
			$mf->setStatus('UNREAD');
			$mf->setSubject( $message_data['subject'] );
			$mf->setBody( $message_data['body'] );

			if ( $mf->isValid() ) {
				$mf->Save();

				Redirect::Page( URLBuilder::getURL( 	array(	'template' => $template,
																'close' => 1,
																'object_type_id' => $object_type_id,
																'object_id' => $object_id), 'EmbeddedMessageList.php') );

				break;
			}

		}
	default:
		if ( isset($object_type_id) AND isset($object_id) ) {
			$mlf = new MessageListFactory();

			$mlf->getByObjectTypeAndObject($object_type_id, $object_id);

			$i=0;
			foreach ($mlf as $message) {
				//Get user info
				$ulf = new UserListFactory();

				$messages[] = array(
									'id' => $message->getId(),
									'parent_id' => $message->getParent(),
									'object_type' => $message->getObjectType(),
									'object_id' => $message->getObject(),
									'priority' => $message->getPriority(),
									'status' => $message->getStatus(),
									'subject' => $message->getSubject(),
									'body' => $message->getBody(),
									'created_date' => $message->getCreatedDate(),
									'created_by' => $message->getCreatedBy(),
									'created_by_full_name' => $ulf->getById( $message->getCreatedBy() )->getCurrent()->getFullName(),
									'updated_date' => $message->getUpdatedDate(),
									'updated_by' => $message->getUpdatedBy(),
									'deleted_date' => $message->getDeletedDate(),
									'deleted_by' => $message->getDeletedBy()
								);

				//Mark own messages as read.
				if ( $message->getCreatedBy() != $current_user->getId() ) {
					$mlf_b = new MessageListFactory();
					$message_obj = $mlf_b->getById( $message->getId() )->getCurrent();
					$message_obj->setStatus(20);
					$message_obj->Save();
				}

				if ( $i == 0 ) {
					$parent_id = $message->getId();
					$default_subject = TTi18n::gettext('Re:').' '.$message->getSubject();
				}

				$i++;
			}

			//Get object data
			$object_name_options = $mlf->getOptions('object_name');
			$smarty->assign_by_ref('object_name', $object_name_options[$object_type_id]);

			$smarty->assign_by_ref('messages', $messages);

			$smarty->assign_by_ref('message_data', $message_data);

			$smarty->assign_by_ref('default_subject', $default_subject);

			$smarty->assign_by_ref('total_messages', $i);

			$smarty->assign_by_ref('parent_id', $parent_id);
			$smarty->assign_by_ref('object_type_id', $object_type_id);
			$smarty->assign_by_ref('object_id', $object_id);
		}

		$smarty->assign_by_ref('template', $template);
		$smarty->assign_by_ref('close', $close);

		break;
}

$smarty->assign_by_ref('mf', $mf);

if ( $template == 1 ) {
	$smarty->display('message/LayerMessageList.tpl');
} else {
	$smarty->display('message/EmbeddedMessageList.tpl');
}
?>