"""Exception classes, generated from the Telepathy spec

Copyright (C) 2005-2008 Collabora Limited
Copyright (C) 2005-2008 Nokia Corporation


This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

from dbus import DBusException

__all__ = (
"NetworkError",
"NotImplemented",
"InvalidArgument",
"NotAvailable",
"PermissionDenied",
"Disconnected",
"InvalidHandle",
"ChannelBanned",
"ChannelFull",
"ChannelInviteOnly",
"NotYours",
"Cancelled",
"AuthenticationFailed",
"EncryptionNotAvailable",
"EncryptionError",
"CertNotProvided",
"CertUntrusted",
"CertExpired",
"CertNotActivated",
"CertFingerprintMismatch",
"CertHostnameMismatch",
"CertSelfSigned",
"CertInvalid",
"NotCapable",
"Offline",
"ChannelKicked",
"Busy",
"NoAnswer",
"DoesNotExist",
)


class NetworkError(DBusException):
    """\
    Raised when there is an error reading from or writing to the network.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NetworkError'
  
class NotImplemented(DBusException):
    """\
    Raised when the requested method, channel, etc is not available on this connection.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NotImplemented'
  
class InvalidArgument(DBusException):
    """\
    Raised when one of the provided arguments is invalid.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.InvalidArgument'
  
class NotAvailable(DBusException):
    """\
    Raised when the requested functionality is temporarily unavailable.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NotAvailable'
  
class PermissionDenied(DBusException):
    """\
    The user is not permitted to perform the requested operation.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.PermissionDenied'
  
class Disconnected(DBusException):
    """\
      The connection is not currently connected and cannot be used.
      This error may also be raised when operations are performed on a
      Connection for which
      StatusChanged
      has signalled status Disconnected for reason None.

      
        The second usage corresponds to None in the
        Connection_Status_Reason enum; if a better reason
        is available, the corresponding error should be used instead.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Disconnected'
  
class InvalidHandle(DBusException):
    """\
    The contact name specified is unknown on this channel or connection.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.InvalidHandle'
  
class ChannelBanned(DBusException):
    """\
    You are banned from the channel.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Channel.Banned'
  
class ChannelFull(DBusException):
    """\
    The channel is full.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Channel.Full'
  
class ChannelInviteOnly(DBusException):
    """\
    The requested channel is invite-only.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Channel.InviteOnly'
  
class NotYours(DBusException):
    """\
      The requested channel or other resource already exists, and another
      client is responsible for it
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NotYours'
  
class Cancelled(DBusException):
    """\
      Raised by an ongoing request if it is cancelled by user request before
      it has completed, or when operations are performed on an object which
      the user has asked to close (for instance, a Connection where the user
      has called Disconnect, or a Channel where the user has called Close).

      
        The second form can be used to correspond to the Requested member in
        the Connection_Status_Reason enum, or to
        to represent the situation where disconnecting a Connection,
        closing a Channel, etc. has been requested by the user but this
        request has not yet been acted on, for instance because the
        service will only act on the request when it has finished processing
        an event queue.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cancelled'
  
class AuthenticationFailed(DBusException):
    """\
      Raised when authentication with a service was unsuccessful.
      
        This corresponds to Authentication_Failed in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.AuthenticationFailed'
  
class EncryptionNotAvailable(DBusException):
    """\
      Raised if a user request insisted that encryption should be used,
      but encryption was not actually available.

      
        This corresponds to part of Encryption_Error in the
        Connection_Status_Reason enum. It's been separated
        into a distinct error here because the two concepts that were part
        of EncryptionError seem to be things that could reasonably appear
        differently in the UI.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.EncryptionNotAvailable'
  
class EncryptionError(DBusException):
    """\
      Raised if encryption appears to be available, but could not actually be
      used (for instance if SSL/TLS negotiation fails).
      
        This corresponds to part of Encryption_Error in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.EncryptionError'
  
class CertNotProvided(DBusException):
    """\
      Raised if the server did not provide a SSL/TLS certificate. This error
      MUST NOT be used to represent the absence of a client certificate
      provided by the Telepathy connection manager.
      
        This corresponds to Cert_Not_Provided in the
        Connection_Status_Reason enum. That error
        explicitly applied only to server SSL certificates, so this one
        is similarly limited; having the CM present a client certificate
        is a possible future feature, but it should have its own error
        handling.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.NotProvided'
  
class CertUntrusted(DBusException):
    """\
      Raised if the server provided a SSL/TLS certificate signed by an
      untrusted certifying authority. This error SHOULD NOT be used to
      represent a self-signed certificate: see the Self Signed error for that.
      
        This corresponds to Cert_Untrusted in the
        Connection_Status_Reason enum, with a clarification
        to avoid ambiguity.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.Untrusted'
  
class CertExpired(DBusException):
    """\
      Raised if the server provided an expired SSL/TLS certificate.
      
        This corresponds to Cert_Expired in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.Expired'
  
class CertNotActivated(DBusException):
    """\
      Raised if the server provided an SSL/TLS certificate that will become
      valid at some point in the future.
      
        This corresponds to Cert_Not_Activated in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.NotActivated'
  
class CertFingerprintMismatch(DBusException):
    """\
      Raised if the server provided an SSL/TLS certificate that did not have
      the expected fingerprint.
      
        This corresponds to Cert_Fingerprint_Mismatch in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.FingerprintMismatch'
  
class CertHostnameMismatch(DBusException):
    """\
      Raised if the server provided an SSL/TLS certificate that did not match
      its hostname.
      
        This corresponds to Cert_Hostname_Mismatch in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.HostnameMismatch'
  
class CertSelfSigned(DBusException):
    """\
      Raised if the server provided an SSL/TLS certificate that is self-signed
      and untrusted.
      
        This corresponds to Cert_Hostname_Mismatch in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.SelfSigned'
  
class CertInvalid(DBusException):
    """\
      Raised if the server provided an SSL/TLS certificate that is
      unacceptable in some way that does not have a more specific error.
      
        This corresponds to Cert_Other_Error in the
        Connection_Status_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Cert.Invalid'
  
class NotCapable(DBusException):
    """\
    Raised when requested functionality is unavailable due to contact
    not having required capabilities.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NotCapable'
  
class Offline(DBusException):
    """\
      Raised when requested functionality is unavailable because a contact is
      offline.

      
        This corresponds to Offline in the
        Channel_Group_Change_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Offline'
  
class ChannelKicked(DBusException):
    """\
      Used to represent a user being ejected from a channel by another user,
      for instance being kicked from a chatroom.

      
        This corresponds to Kicked in the
        Channel_Group_Change_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Channel.Kicked'
  
class Busy(DBusException):
    """\
      Used to represent a user being removed from a channel because of a
      "busy" indication.

      
        This corresponds to Busy in the
        Channel_Group_Change_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Busy'
  
class NoAnswer(DBusException):
    """\
      Used to represent a user being removed from a channel because they did
      not respond, e.g. to a StreamedMedia call.

      
        This corresponds to No_Answer in the
        Channel_Group_Change_Reason enum.
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NoAnswer'
  
class DoesNotExist(DBusException):
    """\
      Raised when the requested user does not, in fact, exist.

      
        This corresponds to Invalid_Contact in the
        Channel_Group_Change_Reason enum, but can also be
        used to represent other things not existing (like chatrooms, perhaps).
      
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.DoesNotExist'
  