# Set the section for the documentation.
set doc_section Fun
set doc_type Server

doc add "Scripts ($doc_type)/$doc_section" "~/.quirc/fun.tcl

This file contains various entertaining scripts to be used for the purpose of entertaining someone or something."


# ALIASES

# /asian
doc add "Aliases ($doc_type)/$doc_section/asian" "/asian

When run, displays a randomly generated asian name.  This code was contributed by Dinkmeister."

alias asian {
    # random first names
    set first(0) "Yo"
    set first(1) "Ko"
    set first(2) "Mo"
    set first(3) "Ma"
    set first(4) "Ta"
    set first(5) "Hi"
    set first(6) "Yu"
    set firstmid(0) "ru"
    set firstmid(1) "ra"
    set firstmid(2) "sho"
    set firstmid(3) "sha"
    set firstmid(4) "shi"
    set firstmid(5) "ko"
    set firstmid(6) "mo"
    set firstlast(0) "shimi"
    set firstlast(1) "shima"
    set firstlast(2) "chi"
    set firstlast(3) "shimo"
    set firstlast(4) "yoto"
    set firstlast(5) "yoko"
    set firstlast(6) "yoshimo"
    
    # random last names
    set lastfirst(0)  "Yo"
    set lastfirst(1)  "Ki" 
    set lastfirst(2)  "Ka"
    set lastfirst(3)  "Fo"
    set lastfirst(4)  "Ma"
    set lastfirst(5)  "Ha"
    set lastfirst(6)  "Ta"
    set lastmid(0)  "ma"
    set lastmid(1)  "to" 
    set lastmid(2)  "mi"
    set lastmid(3)  "ko"
    set lastmid(4)  "shi"
    set lastmid(5)  "sa"
    set lastmid(6)  "go"
    set last(0)  "shi"
    set last(1)  "bishi" 
    set last(2)  "moto"
    set last(3)  "yoko"
    set last(4)  "toko"
    set last(5)  "gotchi"
    set last(6)  "mata"
    
    say "$first([expr int(rand() * 7)])$firstmid([expr int(rand() * 7)])$firstlast([expr int(rand() * 7)]) $lastfirst([expr int(rand() * 7)])$lastmid([expr int(rand() * 7)])$last([expr int(rand() * 7)])"
}

# /christmas
doc add "Aliases ($doc_type)/$doc_section/christmas" "/christmas

This code displays a Christmas tree with a Christmas/New Years greeting.  It is very large, so be careful where you run it.  It may even flood you off IRC."

alias christmas {
    say "4,4xxxxxxxxkrisxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxx4,1M8,1E9,1R13,1R11,1Y  4,1C9,1H3,1R11,1I4,1S8,1T13,1M9,1A4,1S1,1xxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1krisxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1krisx4,1       15,1*1,1   1,1xxxxx8,1_/^\_1,1xxxxx4,1          15,1*1,1xxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxxxxx8,1<     >1,1xxxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxx15,1*1,1xxxxxxxxxxxxxxxxx8,1/15,1.-.8,1\1,1xxxxxxxxx15,1*1,1xxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxx15,1*1,1xxxxxxxxxx15,1`3,1/8,1&3,1\15,1`1,1xxxxxxxxxxxxxxxxxx15,1*1,1xxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxxxxx3,1,4,1@11,1.9,1*11,1;4,1@3,1,1,1xxxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxxxx3,1/15,1_11,1o8,1.9,1I 13,1%15,1_3,1\1,1xxxx15,1*1,1xxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxx15,1*1,1xxxxxxxxxxx3,1(15,1`'--:8,1o9,1(15,1_4,1@3,1;1,1xxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxx3,1/8,1`;--.,__ 15,1`'3,1)1,1xxxxxxxxxxxxx15,1*1,1xxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxx3,1;4,1@3,1`11,1o 9,1%13,1 O,15,1*8,1`'`&3,1\1,1xxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxx15,1*    (15,1`'--)_4,1@ ;11,1o 9,1%3,1'9,1()3,1\1,1xxxxx15,1*1,1xxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxx3,1/8,1`;--._15,1`''--._13,1O'4,1@3,1;1,1xxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxx3,1/13,1&9,1*3,1,9,1()12,1~11,1o8,1`;-.,_ 15,1`\"\"`)1,1xxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxx15,1*1,1xxxxxxxxxx3,1/`9,1,4,1@ ;13,1+& 9,1() 11,1o*8,1`;-';3,1\1,1xxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxx3,1(15,1`\"\"--.,_0 11,1+13,1% 4,1@' 13,1&9,1()3,1\1,1xxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxx3,1/8,1-.,_    15,1``''--....-'`3,1)  15,1*1,1xxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxx15,1*    3,1/4,1@11,1%9,1;11,1o8,1`:;'--,.__   __.'3,1\1,1xxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxx11,1;9,1*13,1,&11,1(); 4,1@ 13,1% 8,1&6,1^3,1;12,1~15,1`\"`11,1o3,1;4,1@9,1()3,1;1,1xxxxxxxx15,1*1,1xx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxx3,1/9,1()8,1; 11,1o8,1^12,1~8,1; 13,1& 9,1()8,1.11,1o4,1@8,1*13,1&3,1`;13,1&8,1%11,1O3,1\1,1xxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xx15,1*1,1xxx15,1      3,1`\"4,1=3,1\"4,1==3,1\"\"4,1==3,1,,,.,4,1=3,1\"4,1==3,1\"4,1===3,1\"`1,1xxxxxxxxxxx4,4xx"
    say "4,4xx1,1xx9,1_.-._  9,1__9,1.----..--3,1''4,1#####9,1---9,1...___...-----._1,1xx4,4xx"
    say "4,4xx1,1xxxxxxx9,1'`1,1xxxxxxxxxxxx3,1`\"\"\"\"\"`1,1xxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxxxxxxxx4,1and1,1Xxxxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxx9,1A 8,1H4,1A11,1P13,1P8,1Y 3,1N11,1E13,1W 8,1Y4,1E9,1A11,1R1,1xxxxxxxxxxxxxxx4,4xx"
    say "4,4xx1,1xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx4,4xx"
    say "4,4xxxxxxxxkrisxxx(jgs)xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx4,4xx"
}

# /homer
doc add "Aliases ($doc_type)/$doc_section/homer" "/homer

Prints out a random home quote to the current channel, query, or chat session.  This too was contributed by Dinkmeister."

alias homer {
    set homer(0) "As far as anyone knows we're a nice, normal family"
    set homer(1) "It says it's for dogs, but she can't read"
    set homer(2) "Lisa: Remember, Dad.  The handle of the Big Dipper points to the North Star. ;  Homer: That's nice, Lisa, but's we're not in astronomy class.  We're in the woods."
    set homer(3) "Yeah.  Wait a minute.  It's the guy from TV.  My kid's hero...Cruddy...Crummy...Krusty the Clown!"
    set homer(4) "Uh, so.  Let's have a conversation.  Uh, I think we'll find that we have very little in common."
    set homer(5) "Don't go easy on each other just because you're brother and sister.  I want to see you both fighting for your parents' love."
    set homer(6) "I don't want to look like a weirdo.  I'll just go with a muumuu."
    set homer(7) "Oh my God!  Space aliens!  Don't eat me, I have a wife and kids!  Eat them."
    set homer(8) "Marge, tell Bart I just want to drink a nice glass of syrup like I do every morning."
    set homer(9) "You know, Moe, my mom once said something that really stuck with me.  She said, `Homer, you're a big disappointment,' and, God bless her soul, she was really onto something."
    set homer(10) "Lisa: So gambling makes a good thing even better?;  Homer: That's right.  My God, it's like there's some kind of bond between us."
    set homer(11) "Jeez.  No beer ... no opera dogs ..."
    set homer(12) "You're everywhere.  You're omnivorous."
    set homer(13) "I can understand how they wouldn't let in those wild jungle apes, but what about those really smart ones who live among us who rollerskate and smoke cigars?"
    set homer(14) "You know something, folks, as ridiculous as this sounds, I would rather feel the sweet breath of my beautiful wife on the back of my neck as I sleep than stuff dollar bills into some stranger's G-string."
    set homer(15) "Could this be the best day of my life?"
    set homer(16) "Kirk: One day your wife is making you your favorite meal, the next day you're thawin'a hot dog in a gas station sink.;  Homer: Oh, that's tough, pal.  But it's never gonna happen to me."
    set homer(17) "See these?  American donuts.  Glazed, powdered, and raspberry-filled.  Now, how's that for freedom of choice."
    set homer(18) "The reason I look unhappy is that tonight I have to see a slide show starring my wife's sisters -- or as I call them, `the gruesome twosome.'"
    set homer(19) "I'm not a bad guy.  I work hard and I love my kids.  So why should I spend half my Sunday hearing about how I'm going to Hell?"
    set homer(20) "Mmm...incapacitating."
    set homer(21) "Marge, try to understand.  There are two kinds of college students: jocks and nerds.  As a jock, it is my duty to give nerds a hard time."
    set homer(22) "Listen, you big, stupid space-creature. Nobody, but nobody, eats the Simpsons!"
    set homer(23) "I wore my extra loose pants for nothing.  Nothing!"
    set homer(24) "You've been rubbing my nose in it since I got here!  Your family is better than my family, your beer comes from father away than my beer, you and your son like each other, your wife's butt is higher than my wife's butt!  You make me sick!"
    set homer(25) "Son, this is the only time I'm ever gonna say this.  It is not okay to lose."
    set homer(26) "As I got up in front of them, I felt an intoxication that had nothing to do with alcohol.  It was the intoxication of being a public spectacle"
    set homer(27) "Homer: What?!  Flanders!  You're the Devil?; Devil Flanders: Ho-oh, it's always the one you least suspect."
    set homer(28) "D'oh!  English!  Who needs that?  I'm never going to England. Come on, let's smoke."
    set homer(29) "They don't call me Colonel Homer because I'm some dumb-ass army guy."
    set homer(30) "I want to share something with you -- the three little sentences that will get you through life.  Number one, `Cover for me.'  Number two, `Oh, good idea, boss.' Number three, `It was like that when I got here.'"
    set homer(31) "Always remember that you're representing our country.  I guess what  I'm saying is, don't mess up France the way you messed up your room."
    set homer(32) "I can't believe I ate the whole thing"
    set homer(33) "Barney: Boy, you never stop eating and you don't gain a pound.; Homer: It's my metaba-ma-lism.  I guess I'm just one of the lucky ones."
    set homer(34) "Marge, you're my wife and I love you very much.  But you're living in a world of makebelieve.  With flowers and bells and leprechauns.  And magic frogs with funny little hats.."
    set homer(35) "Did you hear that, Marge?  She called me a baboon! The stupidest, ugliest, smellist ape of them all!"
    set homer(36) "Holy Moly!  The bastard's rich!"
    set homer(37) "Love isn't hopeless.  Look, maybe I'm no expert on the subject, but there was one time I got it right."
    set homer(38) "First Bush invades my home turf, then he takes my pals, then he makes fun of the way I talk -- probably -- now he steals my right to raise a disobedient, smart-alecky son!  Well, that's it!"
    set homer(39) "If there was any justice, my face would be on a bunch of crappy merchandise" 
    set homer(40) "Keep brain from freezing."
    set homer(41) "Lurleen, I can't get your song outta my mind.  I haven't felt this way since `Funky Town.'"
    set homer(42) "Marge: Homer, couldn't we pawn my engagement ring instead?; Homer: Now, I appreciate that, honey, but we need one hundred and fifty dollars here."
    set homer(43) "Marge: Homer, you're his father.  You've got to reason with him.; Homer: Oh, that never works.  He's a goner!"
    set homer(44) "I thought there was chocolate inside ... Well, why was it wrapped in foil?"
    set homer(45) "I don't care if Ned Flanders is the nicest guy in the world.  He's a jerk -- end of story."
    set homer(46) "Well, you know boys, a nuclear reactor is a lot like a woman.  You just have to read the manual and press the right button."
    set homer(47) "Homer: Boy, you don't have to follow in my footsteps.; Bart: Don't worry, I don't even like using the bathroom after you."
    set homer(48) "Homer: Why you little -- !"
    set homer(50) "I wish for a turkey sandwich on rye bread with lettuce and mustard.  And -- and I don't want any zombie turkeys, I don't want to turn into a turkey myself, and I don't want any other weird surprises -- you got it?"
    set homer(51) "Homer: I'm a bad father! ; Selma: You're also fat! ;  Homer: I'm also fat!"
    set homer(52) "Foul temptress.  I'll bet she thinks Ziggy's gotten too preachy, too!"
    set homer(53) "Homer: No TV and No Beer Make Homer ... something something.;  Marge: Go crazy?;  Homer: Don't mind if I do!"
    set homer(54) "It all happened at the beginning of that turbulent decade known as the eighties.  Those were idealistic days: the candidacy of John Anderson, the rise of Supertramp.  It was an exciting time to be young."
    set homer(55) "Twenty of the suckiest minutes of my life."
    set homer(56) "Homer: I don't want you to see me sitting on my worthless butt. ;  Bart: We've seen it, Dad."
    set homer(57) "Marge, this ticket doesn't just give me a seat.  It also give me the right -- no, the duty -- to make a complete ass of myself."
    set homer(58) "Herb: I want you to help me design a car.  A car for all the Homer Simpsons out there!  And I want to pay you two hundred thousand dollars a year! ;   Homer: And I want to let you!"
    set homer(59) "Homer: There couldn't be heaven if there weren't a hell.;  Bart: Who's in there?;  Homer: Oh, uh ... Hitler's dog.  And that dog Nixon had, whassisname, um, Chester ...;  Lisa: Checkers.;  Homer:Yeah!  One of the Lassies is in there, too.  The mean one -- the one that mauled Jimmy."
    set homer(60) "Losers!  Losers!  Kiss my big Springfield behind, Shelbyville!"
    set homer(61) "The doll's trying to kill me, and the toaster's been laughing at me."
    set homer(62) "Karl: You don't belong here.  You're a fraud and a phony and it's only a matter of time until they find you out.; Homer: (gasps)  Who told you?"
    set homer(63) "Bart: What'd you do?  Screw up like the Beatles and say you were bigger than Jesus?;  Homer: All the time.  It was the title of our second album."
    set homer(64) "Kirk: What makes you guys so special? ;  Homer: Because Marge and I have one thing that can never be broken: a strong marriage built on a solid foundation of routine."
    set homer(65) "Ah, sweet pity: where would my love life have been without it?"
    set homer(66) "Oh, honey, I didn't get drunk, I just went to a strange fantasy world."
    set homer(67) "Bart: So, like sometimes you can do stuff that you think is pretty bad so other kids will like you better? ;  Homer: You're not talking about killing anyone, are you?"
    set homer(68) "I'll get a bunck of monkeys, dress 'em up, and make 'em reenact the Civil War!  Heh, heh, heh!"
    set homer(69) "Weaseling out of things is important to learn.  It's what seperates us from the animals.  Except the weasel."
    set homer(70) "Homer: Your mother and I have been thinking about giving the puppies away. ;  Bart and Lisa: Noooooo!;  Homer: Mainly your mother."
    set homer(71) "Homer: Okay, okay, don't panic.  To find Flanders, I just have to think like Flanders! ;  Homers Brain: I'm a big four-eyed lame-o and I wear the same stupid sweater everyday, and -- ;  Homer: The Springfield River!"
    set homer(72) "It was the most I ever threw up, and it changed my life forever."
    set homer(73) "We live in a society of laws.  Why do you think I took you to all those \"Police Academy\" movies?  For fun? Well, I didn't hear anybody laughin', did you?"
    set homer(74) "Stealing?!  How could you?!  Haven't you learned anything from that guy who gives those sermons at church?  Captain What's-his-name?"
    set homer(75) "Aw, Dad, you've done a lot of great things, but you're a very old man, and old people are useless."
    set homer(76) "Homer: Little baby batter / Can't control this bladder! ;   Burns: Mmm...Crude, but I like it.  What do you say we freshen up out little drinkie poos? ; Homer: Don't mind if I do."
    set homer(77) "Homer:	Hey, Flanders, it's no use praying.  I already did the same thing, and we can't both win. ;  Flanders: Actually, Simpson, we were praying that no one gets hurt."
    set homer(78) "Asleep at the switch!  I wasn't asleep!  I was drunk!"
    set homer(79) "Hey!  Let's do that 2,000-pound man thing.  I'll be that Carl Reiner guy, and you be what's-his-face."
    set homer(80) "Don't let Krusty's death get you down, boy.  People die all the time.  Just like that.  Why, you could wake up dead tomorrow.  Well, good night."
    set homer(81) "Hey, what's the big deal about going to some building every Sunday?  I mean, isn't God everywhere?"
    set homer(82) "And anyone can be tooted?"
    set homer(83) "Flanders: Homer, affordable tract housing made us neighbors, but you made us friends. ;  Homer: To Ned Flanders, the richest left-handed man in town."
    set homer(84) "There's an empty spot I've always had inside me.  I tried to fill it with family, religion, community service.  But those were all dead ends.  I think this chair is the answer."
    set homer(85) "Bart: Dad, you killed the Zombie Flanders! ;  Homer: He was a zombie?"
    set homer(86) "If it'll make you feel any better, I've learned that life is one crushing defeat after another until you just wish Flanders was dead."
    set homer(87) "See you in hell, candy boys!!"
    set homer(88) "All right.  His story checks out."
    set homer(89) "I didn't want a hokey second wedding like those ones on TV!  This one's for real!"
    set homer(90) "Hmmm, look at those eyes.  He's trying to hypnotize" 
    set homer(91) "me, but not in the good Las Vegas way."
    set homer(92) "Marge!  I'm two-thirty-nine, and I'm feeling fine!"
    set homer(93) "I know you're mad at me right now, and I'm kinda mad  too ... I mean, we could sit here and try to figure out who forgot to pick up who till the cows come home.  But let's just say we're both wrong and that'll be that."
    set homer(94) "Well if it isn't the leader of the weiner patrol, boning up on his nerd lessons!"
    set homer(95) "Yeah.  Maybe I do have the right ... What's that stuff?"
    set homer(96) "And, Lord, we're especially thankful for nuclear power, the cleanest, safest energy source there is, except for solar, which is just a pipe dream."
    set homer(97) "Marge, you being a cop makes you the man!  Which makes me the woman -- and I have no interest in that, besides occasionally wearing the underwear, which, as we discussed, is strictly a confort thing."
    set homer(98) "Hello?  Yes?  Oh!  Heh, heh, uh ... if you're looking for that big donut of yours ... um, Flanders has it.  Just smash open his house.  (Closing the door.)  He came to life.  Good for him."
    set homer(99) "He may have come up with the recipe, but I came up with the idea of charging 6.95 for it."
    set homer(100) "Wh ... what's going on?  Wh ... wha ... why am I on a Japanese box?"
    set homer(101) "Wait a minute, Marge.  I saw \"Mrs. Doubtfire.\"  This is a man in drag!"
    set homer(102) "Abe: I used to be `with it.'  But then they changed what `it' was.  Now what I'm `with' isn't `it' and what's `it' seems weird and scary to me.  It'll happen to you.;   Homer: No way, man.  We're gonna keep on rockin' forever!"
    set homer(103) "Yes!  Oh, yes!  Read it and weep!  In your face -- I got more chicken bone!"
    set homer(104) "Must destroy mankind!  (His watch alarm goes off)  Ooh, lunchtime!"
    set homer(105) "Okay, Marge, as long as we're traumatizing the kids, I have a scandalous stroy of my own."
    set homer(106) "Marge: Homer, is this the way you pictured married life? ;  Homer: Yup, pretty much.  Except we drove around in a van solving mysteries."
    set homer(107) "Out at five, catch General Sherman at five-thirty, clean him at six, eat him at six-thirty, back in bed by seven with no incriminating evidence.  Heh heh heh.  The perfect crime."
    set homer(108) "Pfft.  Now you tell me."
    set homer(109) "I'll work from midnight to eight, come home, sleep for five minutes, eat breakfast, sleep six more minutes, shower, then I have ten minutes to bask in Lisa's love, then I'm off to the power plant fresh as a daisy."
    set homer(110) "Just squeeze your rage into a bitter little ball and release it at an appropriate time.  Like that day I hit that referee with a whiskey bottle.  'Member that?"
    set homer(111) "Come here, you little raven!"
    set homer(112) "Your mother seems really upset.  I better go have a talk with her -- during the commercial."
    
    say "\0030,2 HOMER \003 $homer([expr int(rand() * 113)])"
}

# /reverse
doc add "Aliases ($doc_type)/$doc_section/reverse" "/reverse <text>

Reverses the text and then sends it."

alias reverse {
    set newlist "";
    foreach item [split $arg {}] {
	set newlist [linsert $newlist 0 $item]
    }
    say [join $newlist {}]
}
