;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                        ;;
;;             Center for Spoken Language Understanding                   ;;
;;        Oregon Graduate Institute of Science & Technology               ;;
;;                         Portland, OR USA                               ;;
;;                        Copyright (c) 2000                              ;;
;;                                                                        ;;
;;      This module is not part of the CSTR/University of Edinburgh       ;;
;;               release of the Festival TTS system.                      ;;
;;                                                                        ;;
;;  In addition to any conditions disclaimers below, please see the file  ;;
;;  "license_ogi_tts.txt" distributed with this software for information  ;;
;;  on usage and redistribution, and for a DISCLAIMER OF ALL WARRANTIES.  ;;
;;                                                                        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  This file is additional code NOT INCLUDED with the Festival TTS 
;;;   system as distributed by CSTR/University of Edinburgh.  
;;;
;;;  Festival is being redistributed with permission of CSTR as part of 
;;;   the CSLU Toolkit.   
;;;
;;;  The CSLU Toolkit and this code are 
;;;    Copyright (C)1997 Center for Spoken Language Understanding,
;;;                      Oregon Graduate Institute of Science & Technology
;;;
;;; In addition to conditions disclaimers below, please see the file "license.ogi" 
;;; for information on usage and redistribution, and for a DISCLAIMER OF ALL WARRANTIES.
;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  worldbet average phoneme durations from gsw 450  -- MWM
;;;
(set! phoneme_durations 
'(
(U 0.067)
(@ 0.146)
(h 0.067)
(u 0.105)
(^ 0.090)
(v 0.053)
(I 0.060)
(dZ 0.097)
(i: 0.095)
(w 0.066)
(k 0.088)
(j 0.051)
(l 0.067)
(l 0.077) ;; mwm guess
(Z 0.080)
(N 0.072)
(m 0.070)
(z 0.079)
(aU 0.162)
(A 0.118)
(n 0.065)
(> 0.102)
(aI 0.156)
(b 0.071)
(oU 0.129)  
(tS 0.119)
(p 0.094)
(>i 0.165)
(d 0.052)
(D 0.032)
(E 0.091)
(9r 0.062)
(S 0.101)
(3r 0.149)
(ei 0.131)
(f 0.091)
(s 0.093)
(g 0.066)
(t 0.073)
(T 0.080)
(& 0.054)
(iU 0.156)
(pau 0.120)
(brth 0.256)
(h# 0.256)
))

(set! gsw_durs_worldbet
'(
(pau    0.120 0.050)
(brth   0.200 0.050)
(h#     0.200 0.050)
(h    0.061 0.028)
(@    0.141 0.061)
(U    0.067 0.024)
(u    0.107 0.044)
(^    0.087 0.025)
(v    0.051 0.019)
(I    0.065 0.030)
(i:   0.092 0.035)
(w    0.054 0.023)
(dZ   0.094 0.024)
(k    0.089 0.034)
(j    0.048 0.025)
(l    0.056 0.026)
(l=    0.066 0.036) ;; mwm guess
(Z    0.077 0.030)
(N    0.064 0.024)
(m    0.063 0.021)
(z    0.072 0.029)
(A    0.120 0.036)
(aU   0.171 0.046)
(n    0.059 0.025)
(oU   0.134 0.039)
(b    0.073 0.021)
(>    0.094 0.037)
(aI   0.137 0.047)
(tS   0.128 0.039)
(>i   0.183 0.050)
(iU   0.156 0.050)
(p    0.101 0.032)
(d    0.048 0.021)
(D    0.031 0.016)
(E    0.092 0.035)
(9r   0.053 0.025)
(S    0.108 0.031)
(f    0.095 0.033)
(3r   0.147 0.035)
(ei   0.130 0.042)
(s    0.102 0.037)
(T    0.093 0.050)
(g    0.064 0.021)
(t    0.070 0.034)
(&    0.046 0.020)
))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   A tree to predict zcore duratiosn build from gsw 450 (timit)
;;;   doesn't use actual phonemes so it can have better generalizations
;;;

;; RMSE 0.826528 Correlation is 0.561237 Mean (abs) Error 0.630966 (0.533902)

(set! gsw_duration_cart_tree
'
((name is pau)
 ((emph_sil is +)
  ((0.0 -1.0))
  ((0.0 0.0)))   ;;  a little hack for pauses
((Syllable.position_type is mid)
 ((p.ph_ctype is f)
  ((p.ph_cvox is +)
   ((0.629612 0.0707187))
   ((0.587977 -0.344103)))
  ((ph_ctype is n)
   ((Syllable.p.accented is 0)
    ((0.63614 -0.670918))
    ((0.456217 -0.620236)))
   ((ph_vlng is a)
    ((p.ph_ctype is s)
     ((0.458029 -0.546667))
     ((0.690478 -0.395217)))
    ((p.ph_ctype is l)
     ((p.seg_onsetcoda is onset)
      ((0.627988 -0.576273))
      ((0.689176 -0.275457)))
     ((n.ph_vlng is a)
      ((ph_ctype is l)
       ((0.687382 -0.659382))
       ((0.634963 -0.25514)))
      ((ph_ctype is f)
       ((Syllable.stress is 0)
        ((0.709044 -0.0395424))
        ((0.657406 -0.2548)))
       ((n.ph_vlng is s)
        ((Syllable.stress is 0)
         ((0.70078 -0.241594))
         ((0.715222 -0.544986)))
        ((Syllable.p.stress is 0)
         ((0.716613 -0.00583117))
         ((n.ph_ctype is s)
          ((0.748906 -0.438164))
          ((Syllable.n.syl_break < 1.2)
           ((ph_vlng is s)
            ((0.694752 -0.358606))
            ((n.ph_vlng is d)
             ((0.801296 0.100037))
             ((p.ph_vc is +)
              ((1.02599 -0.130962))
              ((0.860206 -0.365263)))))
           ((0.777008 0.355902))))))))))))
 ((n.ph_vlng is a)
  ((p.ph_vlng is d)
   ((pos_in_syl < 1.2)
    ((0.720201 -0.0426935))
    ((0.47871 -0.33262)))
   ((p.ph_ctype is n)
    ((ph_ctype is f)
     ((0.451972 -0.69876))
     ((0.741488 -0.599391)))
    ((ph_cvox is +)
     ((ph_ctype is s)
      ((0.726445 -0.375597))
      ((p.ph_vlng is l)
       ((0.742457 -0.311508))
       ((p.ph_vlng is a)
        ((0.746764 -0.284029))
        ((ph_ctype is n)
         ((0.843252 -0.471763))
         ((p.ph_vc is +)
          ((0.870476 -0.190471))
          ((p.ph_ctype is 0)
           ((0.768048 -0.194082))
           ((syl_final is 0)
            ((p.ph_ctype is s)
             ((0.725568 -0.778))
             ((0.998309 -0.122827)))
            ((1.00614 0.137212)))))))))
     ((p.ph_vlng is s)
      ((0.453651 -0.481596))
      ((Syllable.position_type is initial)
       ((0.550174 -0.0987692))
       ((ph_ctype is s)
        ((0.612677 -0.221675))
        ((0.596435 -0.571928))))))))
  ((Syllable.n.syl_break < 1.2)
   ((n.ph_ctype is n)
    ((ph_ctype is f)
     ((0.582947 -0.338488))
     ((p.ph_vlng is l)
      ((0.756499 -0.0909804))
      ((ph_vlng is a)
       ((pos_in_syl < 0.2)
        ((p.ph_ctype is f)
         ((0.510177 -0.45931))
         ((Syllable.p.accented is 0)
          ((0.86093 0.2752))
          ((0.676987 -0.0248))))
        ((p.ph_cvox is +)
         ((0.580704 -0.431186))
         ((0.578295 -0.685818))))
       ((p.ph_ctype is 0)
        ((Syllable.stress is 0)
         ((0.67355 -0.273339))
         ((0.867896 -0.188435)))
        ((pos_in_syl < 1.2)
         ((Syllable.position_type is initial)
          ((p.ph_cvox is +)
           ((0.662441 -0.0562667))
           ((0.712804 -0.363028)))
          ((p.ph_ctype is l)
           ((0.8976 -0.293874))
           ((p.ph_ctype is n)
            ((0.910474 0.285))
            ((Syllable.stress is 0)
             ((p.ph_ctype is f)
              ((0.706308 -0.514373))
              ((0.808335 -0.139422)))
             ((Syllable.n.stress is 0)
              ((1.33751 1.18041))
              ((0.866564 0.199)))))))
         ((0.797727 -0.298216)))))))
    ((n.ph_vlng is d)
     ((ph_vc is +)
      ((0.682656 0.00226866))
      ((ph_ctype is n)
       ((0.722411 -0.363065))
       ((p.ph_ctype is s)
        ((Syllable.n.stress is 0)
         ((0.823469 0.149128))
         ((0.677683 -0.219717)))
        ((p.ph_cvox is +)
         ((ph_ctype is f)
          ((0.809378 0.240088))
          ((ph_cvox is +)
           ((p.ph_vlng is a)
            ((0.913397 0.412897))
            ((1.17782 0.185697)))
           ((Syllable.n.stress is 0)
            ((0.74454 0.85594))
            ((0.816019 0.687691)))))
         ((0.796392 0.219767))))))
     ((Syllable.position_type is initial)
      ((ph_vlng is a)
       ((pos_in_syl < 0.2)
        ((0.666285 -0.00369231))
        ((0.701066 -0.239344)))
       ((p.ph_cvox is +)
        ((ph_ctype is a)
         ((0.731182 0.25241))
         ((pos_in_syl < 0.5)
          ((p.ph_vlng is a)
           ((ph_cvox is +)
            ((0.857888 0.623317))
            ((0.637688 0.945672)))
           ((Syllable.n.stress is 0)
            ((p.ph_ctype is n)
             ((0.775245 0.259))
             ((p.ph_ctype is s)
              ((0.795883 0.322172))
              ((ph_ctype is s)
               ((p.ph_cvox is +)
                ((0.855856 0.963833))
                ((0.759772 0.76966)))
               ((p.ph_ctype is f)
                ((0.800078 0.223222))
                ((p.ph_vc is +)
                 ((0.901623 0.602958))
                 ((0.927045 0.33018)))))))
            ((0.78594 -0.111048))))
          ((n.ph_ctype is f)
           ((0.584248 -0.180388))
           ((p.ph_vlng is d)
            ((0.654565 -0.216209))
            ((p.ph_ctype is f)
             ((0.664347 -0.370012))
             ((p.ph_vlng is l)
              ((n.ph_vlng is s)
               ((0.447236 -0.446275))
               ((0.779374 0.0227541)))
              ((ph_ctype is f)
               ((0.699661 0.161634))
               ((ph_vlng is d)
                ((0.726309 -0.630887))
                ((p.ph_cvox is +)
                 ((ph_ctype is l)
                  ((0.715839 0.0163457))
                  ((Syllable.p.syl_break < 0.3)
                   ((0.708243 -0.542189))
                   ((p.ph_vlng is a)
                    ((0.785612 0.24472))
                    ((n.ph_vlng is s)
                     ((0.764203 -0.616259))
                     ((ph_ctype is n)
                      ((0.753592 -0.251452))
                      ((pos_in_syl < 1.4)
                       ((0.753058 -0.18615))
                       ((0.982261 -0.167711))))))))
                 ((0.747153 -0.716712)))))))))))
        ((ph_ctype is s)
         ((0.557865 -1.08618))
         ((p.ph_ctype is l)
          ((0.574772 -0.690711))
          ((ph_vlng is s)
           ((Syllable.accented is 0)
            ((0.521298 -0.350437))
            ((0.498368 0.0507667)))
           ((p.seg_onsetcoda is onset)
            ((0.513495 -0.322591))
            ((syl_final is 0)
             ((ph_ctype is n)
              ((0.663333 -0.245075))
              ((0.70911 0.0574697)))
             ((0.63369 -0.714838)))))))))
      ((n.ph_vlng is s)
       ((pos_in_syl < 2.5)
        ((ph_ctype is n)
         ((0.747898 -0.443416))
         ((Syllable.position_type is single)
          ((p.ph_vlng is a)
           ((0.841483 0.566487))
           ((pos_in_syl < 0.2)
            ((Syllable.stress is 0)
             ((0.925191 -0.277157))
             ((Syllable.accented is 0)
              ((0.892144 0.404447))
              ((Syllable.n.stress is 0)
               ((1.04961 0.40876))
               ((1.15596 0.608068)))))
            ((syl_final is 0)
             ((0.727047 -0.543177))
             ((0.900171 -0.197517)))))
          ((p.ph_vc is +)
           ((0.641356 -0.251071))
           ((syl_final is 0)
            ((0.663192 -0.493156))
            ((0.946362 0.0198727))))))
        ((0.520349 -0.516593)))
       ((n.ph_vc is +)
        ((p.ph_vlng is a)
         ((0.769519 0.661785))
         ((Syllable.syl_break < 1.3)
          ((seg_onsetcoda is onset)
           ((Syllable.position_type is single)
            ((pos_in_syl < 0.2)
             ((Syllable.stress is 0)
              ((p.ph_cvox is +)
               ((0.95333 -0.543053))
               ((0.92105 -0.236923)))
              ((Syllable.n.stress is 0)
               ((0.886994 0.656815))
               ((0.99759 0.617271))))
             ((0.841704 -0.300097)))
            ((0.806944 -0.423067)))
           ((0.812547 -0.123448)))
          ((0.781704 0.428476))))
        ((n.ph_ctype is a)
         ((Syllable.position_type is single)
          ((p.ph_vc is +)
           ((0.902492 -0.01125))
           ((syl_final is 0)
            ((1.24937 0.38308))
            ((0.85454 -0.0442222))))
          ((0.946371 0.195247)))
         ((n.ph_ctype is s)
          ((ph_ctype is s)
           ((ph_cvox is +)
            ((0.596742 -0.430929))
            ((0.678106 -1.02713)))
           ((ph_ctype is f)
            ((seg_onsetcoda is onset)
             ((0.688399 -0.0374839))
             ((pos_in_syl < 1.3)
              ((0.612314 -0.73197))
              ((Syllable.p.syl_break < 0.3)
               ((0.691491 -0.661466))
               ((0.768019 -0.508897)))))
            ((p.ph_vlng is s)
             ((0.801336 -0.0472151))
             ((p.ph_ctype is n)
              ((0.828234 -0.0504405))
              ((ph_vlng is a)
               ((pos_in_syl < 0.3)
                ((0.86589 0.235652))
                ((Syllable.n.syl_break < 0.1)
                 ((0.850661 -0.442353))
                 ((0.549631 -0.5096))))
               ((p.ph_ctype is l)
                ((pos_in_syl < 1.2)
                 ((Syllable.stress is 0)
                  ((0.914832 -0.459397))
                  ((0.896749 0.263254)))
                 ((0.727493 -0.132339)))
                ((ph_vlng is l)
                 ((0.869658 0.0398208))
                 ((p.ph_vlng is d)
                  ((0.981571 -0.137135))
                  ((p.ph_vlng is a)
                   ((0.99776 -0.0463676))
                   ((Syllable.stress is 0)
                    ((p.seg_onsetcoda is onset)
                     ((1.04272 -0.246389))
                     ((1.07857 0.187374)))
                    ((p.seg_onsetcoda is onset)
                     ((p.ph_cvox is +)
                      ((1.05441 0.879288))
                      ((1.28272 0.528649)))
                     ((1.01513 0.689169)))))))))))))
          ((Syllable.syl_break < 1.3)
           ((ph_ctype is f)
            ((Syllable.position_type is single)
             ((p.ph_ctype is 0)
              ((p.ph_cvox is +)
               ((1.02615 0.100846))
               ((0.891466 -0.380468)))
              ((0.77622 -0.255417)))
             ((0.677027 -0.281241)))
            ((p.ph_vlng is a)
             ((Syllable.p.accented is 0)
              ((1.01145 0.363769))
              ((0.769474 0.397706)))
             ((ph_cvox is +)
              ((p.ph_vlng is s)
               ((Syllable.p.syl_break < 0.3)
                ((0.784148 0.343478))
                ((0.775948 0.569486)))
               ((p.ph_vlng is d)
                ((0.870878 0.281058))
                ((ph_vlng is d)
                 ((Syllable.n.syl_break < 0.1)
                  ((0.767438 -0.324836))
                  ((0.983612 0.0237826)))
                 ((ph_vlng is a)
                  ((pos_in_syl < 0.3)
                   ((Syllable.p.syl_break < 0.1)
                    ((1.00977 0.618765))
                    ((0.535529 -0.0473563)))
                   ((p.ph_cvox is +)
                    ((0.743279 -0.256842))
                    ((0.603426 -0.411875))))
                  ((p.ph_vc is +)
                   ((1.00878 0.29539))
                   ((p.ph_ctype is s)
                    ((Syllable.stress is 0)
                     ((0.85967 0.194627))
                     ((1.05523 0.720045)))
                    ((p.ph_ctype is n)
                     ((1.03635 -0.161408))
                     ((pos_in_syl < 1.2)
                      ((p.ph_ctype is f)
                       ((pos_in_syl < 0.1)
                        ((1.15811 0.555213))
                        ((0.86867 0.450922)))
                       ((Syllable.position_type is single)
                        ((Syllable.n.syl_break < 0.1)
                         ((0.960285 -0.489218))
                         ((1.81478 -0.013314)))
                        ((1.031 -0.242914))))
                      ((1.08894 0.315815))))))))))
              ((n.seg_onsetcoda is onset)
               ((n.ph_ctype is f)
                ((0.719377 -0.38092))
                ((pos_in_syl < 0.4)
                 ((0.962958 0.374759))
                 ((0.845203 -0.284982))))
               ((0.663941 -0.911884))))))
           ((n.ph_ctype is l)
            ((1.02766 0.385563))
            ((ph_ctype is s)
             ((Syllable.stress is 0)
              ((0.896716 0.889964))
              ((0.98577 1.40244)))
             ((pos_in_syl < 2.5)
              ((ph_vlng is a)
               ((1.10133 2.66615))
               ((p.ph_cvox is +)
                ((1.06481 2.18636))
                ((ph_ctype is f)
                 ((1.05989 2.03397))
                 ((Syllable.stress is 0)
                  ((ph_vc is +)
                   ((0.908156 0.615871))
                   ((1.24311 1.03157)))
                  ((1.35733 2.08377))))))
              ((0.973093 1.80384)))))))))))))
   ((n.ph_ctype is n)
    ((0.616159 -0.164389))
    ((ph_ctype is n)
     ((0.7454 0.126843))
     ((ph_vlng is s)
      ((0.779736 0.033703))
      ((p.ph_vlng is l)
       ((0.802582 0.361667))
       ((p.ph_vlng is s)
        ((0.796547 -0.0217356))
        ((ph_ctype is f)
         ((0.819685 0.131013))
         ((ph_vlng is l)
          ((0.836399 0.152508))
          ((p.ph_vlng is a)
           ((0.829388 0.4355))
           ((pos_in_syl < 0.5)
            ((Syllable.n.stress is 0)
             ((0.891044 0.511481))
             ((1.05352 0.352203)))
            ((p.ph_cvox is +)
             ((0.996947 -0.133602))
             ((0.828599 -0.343192)))))))))))))))
))

(provide 'ogi_gswdurtreeZ_wb)
