'\"
'\" Generated from file '/usr/obj/ports/tklib-0.5/tklib-0.5/modules/ctext/ctext.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) George Peter Staplin <GeorgePS@XMission.com>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ctext" n 3.2 ctext "Ctext a text widget with highlighting support"
.BS
.SH NAME
ctext \- Ctext a text widget with highlighting support
.SH SYNOPSIS
package require \fBTk \fR
.sp
package require \fBctext  ?3.2?\fR
.sp
\fBctext\fR \fIpathName\fR ?\fIoptions\fR?
.sp
\fB::ctext::addHighlightClass\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIkeywordlist\fR
.sp
\fB::ctext::addHighlightClassWithOnlyCharStart\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIchar\fR
.sp
\fB::ctext::addHighlightClassForSpecialChars\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIcharstring\fR
.sp
\fB::ctext::addHighlightClassForRegexp\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIpattern\fR
.sp
\fB::ctext::clearHighlightClasses\fR \fIpathName\fR
.sp
\fB::ctext::getHighlightClasses\fR \fIpathName\fR
.sp
\fB::ctext::deleteHighlightClass\fR \fIpathName\fR \fIclass\fR
.sp
\fB::ctext::enableComments\fR \fIenable\fR
.sp
\fB::ctext::disableComments\fR \fIenable\fR
.sp
\fIpathName\fR \fBhighlight\fR \fIstartIndex\fR \fIendIndex\fR
.sp
\fIpathName\fR \fBfastdelete\fR \fIindex1\fR ?\fIindex2\fR?
.sp
\fIpathName\fR \fBfastinsert\fR
.sp
\fIpathName\fR \fBcopy\fR
.sp
\fIpathName\fR \fBcut\fR
.sp
\fIpathName\fR \fBpaste\fR
.sp
\fIpathName\fR \fBappend\fR
.sp
\fIpathName\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR ?...?
.sp
.BE
.SH DESCRIPTION
The \fBctext\fR package provides the ctext widget which
is an enhanced text widget with support for configurable syntax
highlighting and some extra commands.
.PP
Ctext overloads the text widget and provides
new commands, named \fBhighlight\fR, \fBcopy\fR, \fBpaste\fR,\fBcut\fR,
\fBappend\fR, and \fBedit\fR.  It also provides several
commands that allow you to define classes.
Each class corresponds to a tag in the widget.
.SH COMMANDS
.TP
\fBctext\fR \fIpathName\fR ?\fIoptions\fR?
Creates and configures a ctext widget.
.PP
.SH HIGHLIGHTING
Highlighting is controlled with text widget tags, that are called highlight classes.
The \fIclass\fR is a tag name and can be configured like any text widget tag.
Four types of highlight classes are supported. All highlight classes are automatically used
by the \fBhighlight\fR method of the widget.
.TP
\fB::ctext::addHighlightClass\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIkeywordlist\fR
Add a highlighting class \fIclass\fR to the ctext widget \fIpathName\fR.
The highligthing will be done with the color \fIcolor\fR. All words in the \fIkeywordlist\fR will be
highlighted.
.nf

	# highlight some tcl keywords
	::ctext::addHighlightClass .t tclkeywords red [list set info interp uplevel upvar]]

.fi
.TP
\fB::ctext::addHighlightClassWithOnlyCharStart\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIchar\fR
Add a highlighting class \fIclass\fR to the ctext widget \fIpathName\fR.
The highligthing will be done with the color \fIcolor\fR. All words starting with \fIchar\fR will be
highlighted.
.nf

	::ctext::addHighlightClassWithOnlyCharStart .t vars blue \\$

.fi
.TP
\fB::ctext::addHighlightClassForSpecialChars\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIcharstring\fR
Add a highlighting class \fIclass\fR to the ctext widget \fIpathName\fR.
The highligthing will be done with the color \fIcolor\fR. All chars in \fIcharstring\fR will be
highlighted.
.TP
\fB::ctext::addHighlightClassForRegexp\fR \fIpathName\fR \fIclass\fR \fIcolor\fR \fIpattern\fR
Add a highlighting class \fIclass\fR to the ctext widget \fIpathName\fR.
The highligthing will be done with the color \fIcolor\fR. All text parts matching the regexp \fIpattern\fR
will be highligthed.
.TP
\fB::ctext::clearHighlightClasses\fR \fIpathName\fR
Remove all highlight classes from the widget \fIpathName\fR.
.TP
\fB::ctext::getHighlightClasses\fR \fIpathName\fR
List all highlight classes for the widget \fIpathName\fR.
.TP
\fB::ctext::deleteHighlightClass\fR \fIpathName\fR \fIclass\fR
Delete the highlight class \fIclass\fR from the widget \fIpathName\fR
.TP
\fB::ctext::enableComments\fR \fIenable\fR
Enable C comment highlighting. The \fIclass\fR for c-style comments is \fB_cComment\fR.
The C comment highlighting is disabled by default.
.TP
\fB::ctext::disableComments\fR \fIenable\fR
Disable C comment highlighting.
.PP
.SH "WIDGET COMMANDS"
Each ctext widget created with the above command supports the following
commands and options in addition to the standard text widget commands and
options.
.TP
\fIpathName\fR \fBhighlight\fR \fIstartIndex\fR \fIendIndex\fR
Highlight the text between \fIstartIndex\fR and \fIendIndex\fR.
.TP
\fIpathName\fR \fBfastdelete\fR \fIindex1\fR ?\fIindex2\fR?
Delete text range without updating the highlighting. Arguments
are identical to the \fIpathName\fR \fBdelete\fR command inherited from
the standard text widget.
.TP
\fIpathName\fR \fBfastinsert\fR
Insert text without updating the highlighting. Arguments
are identical to the \fIpathName\fR \fBinsert\fR command inherited from
the standard text widget.
.TP
\fIpathName\fR \fBcopy\fR
Call \fBtk_textCopy\fR for the ctext instance.
.TP
\fIpathName\fR \fBcut\fR
Call \fBtk_textCut\fR for the ctext instance.
.TP
\fIpathName\fR \fBpaste\fR
Call \fBtk_textPaste\fR for the ctext instance.
.TP
\fIpathName\fR \fBappend\fR
Append the current selection to the clipboard.
.TP
\fIpathName\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR ?...?
Set the options for the ctext widget. Each option name must be followed
the new value.
.PP
.SH "WIDGET OPTIONS"
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linemap\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Creates (-linemap 1) or deletes (-linemap 0) a line number list on the
left of the widget. The default is to have a linemap displayed.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linemapfg\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Changes the foreground of the linemap.
The default is the same color as the main text
widget.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linemapbg\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Changes the background of the linemap.
The default is the same color as the main text
widget.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linemap_select_fg\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Changes the selected
line foreground.  The default is black.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linemap_select_bg\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Changes the selected line
background.  The default is yellow.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linemap_mark_command\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Calls a procedure or command
with the \fIpathName\fR of the ctext window, the \fItype\fR which is
either \fBmarked\fR or \fBunmarked\fR, and finally the line
number selected.
The proc prototype is:
.nf

proc linemark_cmd {win type line}.

.fi
See also
ctext_test_interactive.tcl
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-highlight\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Takes a boolean value which defines
whether or not to highlight text which is inserted
or deleted.  The default is 1.
.LP
.nf
.ta 6c
Command-Line Switch:	\fB-linemap_markable\fR
Database Name:	\fB\fR
Database Class:	\fB\fR

.fi
.IP
Takes a boolean value which
specifies whether or not lines in the linemap
are markable with the mouse.  The default is 1.
.PP
.SH EXAMPLE
.nf

	package require Tk
	package require ctext

	proc main {} {
	pack [frame .f] -fill both -expand 1
	pack [scrollbar .f.s -command {.f.t yview}] -side right -fill y

	pack [ctext .f.t -bg black -fg white -insertbackground yellow  -yscrollcommand {.f.s set}] -fill both -expand 1

	ctext::addHighlightClass .f.t widgets purple  [list ctext button label text frame toplevel  scrollbar checkbutton canvas listbox menu menubar menubutton  radiobutton scale entry message tk_chooseDir tk_getSaveFile  tk_getOpenFile tk_chooseColor tk_optionMenu]

	ctext::addHighlightClass .f.t flags orange  [list -text -command -yscrollcommand  -xscrollcommand -background -foreground -fg -bg  -highlightbackground -y -x -highlightcolor -relief -width  -height -wrap -font -fill -side -outline -style -insertwidth  -textvariable -activebackground -activeforeground -insertbackground  -anchor -orient -troughcolor -nonewline -expand -type -message  -title -offset -in -after -yscroll -xscroll -forward -regexp -count  -exact -padx -ipadx -filetypes -all -from -to -label -value -variable  -regexp -backwards -forwards -bd -pady -ipady -state -row -column  -cursor -highlightcolors -linemap -menu -tearoff -displayof -cursor  -underline -tags -tag]

	ctext::addHighlightClass .f.t stackControl red  {proc uplevel namespace while for foreach if else}
	ctext::addHighlightClassWithOnlyCharStart .f.t vars mediumspringgreen "\\$"
	ctext::addHighlightClass .f.t variable_funcs gold {set global variable unset}
	ctext::addHighlightClassForSpecialChars .f.t brackets green {[]{}}
	ctext::addHighlightClassForRegexp .f.t paths lightblue {\\.[a-zA-Z0-9\\_\\-]+}
	ctext::addHighlightClassForRegexp .f.t comments khaki {#[^\\n\\r]*}
	.f.t fastinsert end [info body main]

	pack [frame .f1] -fill x

	.f.t highlight 1.0 end

	pack [button .f1.exit -text Exit -command exit] -side left

	pack [entry .e] -side bottom -fill x
	.e insert end "ctext::deleteHighlightClass .f.t "
	bind .e <Return> {eval [.e get]}
	}
	main


.fi
Further examples are in the source package for ctext.
.SH THANKS
Kevin Kenny, Neil Madden, Jeffrey Hobbs, Richard Suchenwirth,
Johan Bengtsson, Mac Cody, Gnther, Andreas Sievers, and Michael Schlenker.
.SH "SEE ALSO"
re_syntax, text
.SH KEYWORDS
syntax highlighting, text, widget
.SH COPYRIGHT
.nf
Copyright (c) George Peter Staplin <GeorgePS@XMission.com>

.fi