'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.11.1/tcllib-1.11.1/modules/fileutil/traverse.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "fileutil_traverse" n 0.4 fileutil "file utilities"
.BS
.SH NAME
fileutil_traverse \- Iterative directory traversal
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBfileutil::traverse  ?0.4?\fR
.sp
\fB::fileutil::traverse\fR ?\fIobjectName\fR? \fIpath\fR ?\fIoption\fR \fIvalue\fR...?
.sp
\fB$traverser\fR \fBcommand\fR ?\fIarg arg ...\fR?
.sp
\fB$traverser\fR \fBfiles\fR
.sp
\fB$traverser\fR \fBforeach\fR \fIfilevar\fR \fIscript\fR
.sp
\fB$traverser\fR \fBnext\fR \fIfilevar\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides objects for the programmable traversal of
directory hierarchies.
The main command exported by the package is:
.TP
\fB::fileutil::traverse\fR ?\fIobjectName\fR? \fIpath\fR ?\fIoption\fR \fIvalue\fR...?
The command creates a new traversal object with an associated global
Tcl command whose name is \fIobjectName\fR. This command may be used
to invoke various operations on the traverser.
If the string \fB%AUTO%\fR is used as the \fIobjectName\fR then a
unique name will be generated by the package itself.
.sp
Regarding the recognized options see section \fBOPTIONS\fR. Note
that all these options can be set only during the creation of the
traversal object. Changing them later is not possible and causes
errors to be thrown if attempted.
.sp
The object command has the following general form:
.RS
.TP
\fB$traverser\fR \fBcommand\fR ?\fIarg arg ...\fR?
\fICommand\fR and its \fIarg\fRuments determine the exact behavior of
the object.
.RE
.PP
The following commands are possible for traversal objects:
.TP
\fB$traverser\fR \fBfiles\fR
This method is the most highlevel one provided by traversal
objects. When invoked it returns a list containing the names of all
files and directories matching the current configuration of the
traverser.
.TP
\fB$traverser\fR \fBforeach\fR \fIfilevar\fR \fIscript\fR
The highlevel \fBfiles\fR method (see above) is based on this
mid-level method. When invoked it finds all files and directories
matching per the current configuration and executes the \fIscript\fR
for each path. The current path under consideration is stored in the
variable named by \fIfilevar\fR. Both variable and script live / are
executed in the context of the caller of the method. In the method
\fBfiles\fR the script simply saves the found paths into the list
to return.
.TP
\fB$traverser\fR \fBnext\fR \fIfilevar\fR
This is the lowest possible interface to the traverser, the core all
higher methods are built on. When invoked it returns a boolean value
indicating whether it found a path matching the current configuration
(\fBTrue\fR), or not (\fBFalse\fR). If a path was found it is
stored into the variable named by \fIfilevar\fR, in the context of the
caller.
The \fBforeach\fR method simply calls this method in a loop until
it returned \fBFalse\fR. This method is exposed so that we are also
able to incrementally traverse a directory hierarchy in an event-based
manner.
.PP
.SH OPTIONS
.TP
\fB-prefilter\fR command_prefix
This callback is executed for directories. Its result determines if
the traverser recurses into the directory or not. The default is to
always recurse into all directories. The callback is invoked with a
single argument, the \fIabsolute\fR path of the directory, and has to
return a boolean value, \fBTrue\fR when the directory passes the
filter, and \fBFalse\fR if not.
.TP
\fB-filter\fR command_prefix
This callback is executed for all paths. Its result determines if the
current path is a valid result, and returned by \fBnext\fR. The
default is to accept all paths as valid. The callback is invoked with
a single argument, the \fIabsolute\fR path to check, and has to
return a boolean value, \fBTrue\fR when the path passes the filter,
and \fBFalse\fR if not.
.TP
\fB-errorcmd\fR command_prefix
This callback is executed for all paths the traverser has trouble
with. Like being unable to change into them, get their status,
etc. The default is to ignore any such problems. The callback is
invoked with a two arguments, the \fIabsolute\fR path for which the
error occured, and the error message. Errors thrown by the filter
callbacks are handled through this callback too. Errors thrown by the
error callback itself are not caught and ignored, but allowed to pass
to the caller, i.e. however invoked the \fBnext\fR. Any other
results from the callback are ignored.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIfileutil\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
directory traversal, traversal