<?php
	/**
	 * StickyNote Module
	 * @author Johnny Biemans <j.biemans@connectux.com>
	 */
	class StickyNoteListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function StickyNoteListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getStickyNoteProperties();

			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "icon_index", true, 0, _("Icon"), _("Sort On Icon"));
			$this->addColumn($this->tablecolumns, "subject", true, 2, _("Subject"), _("Sort On Subject"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "body", false, 2, _("Body"), _("Sort On Body"));
			$this->addColumn($this->tablecolumns, "creation_time", true, 3, _("Created"), _("Sort On Created"));
			$this->addColumn($this->tablecolumns, "categories", false, 4, _("Categories"), _("Sort On Categories"));
			
			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->sort = array();
			$this->sort[$this->properties["creation_time"]] = TABLE_SORT_DESCEND;
			
			$this->start = 0;
		}
	}
?>
