suggestEmailAddressModule.prototype = new Module;
suggestEmailAddressModule.prototype.constructor = suggestEmailAddressModule;
suggestEmailAddressModule.superclass = Module.prototype;

function suggestEmailAddressModule(id, suggestlist){
	if(arguments.length > 1) {
		this.init(id, suggestlist);
	}
}

suggestEmailAddressModule.prototype.init = function(id, suggestlist){
	this.id = id;
	this.suggestionlists = new Array();
	this.addSuggestionList(suggestlist);
	this.cache = new Array();
	suggestEmailAddressModule.superclass.init.call(this, id);
}

suggestEmailAddressModule.prototype.addSuggestionList = function(suggestlist){
	if(typeof suggestlist == "object"){
		this.suggestionlists[suggestlist.id] = suggestlist;
	}
}

suggestEmailAddressModule.prototype.getList = function(suggestlistId, str){
	if(typeof this.cache[str] == "object"){
		if(typeof this.suggestionlists[suggestlistId] == "object"){
			this.suggestionlists[suggestlistId].handleResult(str, this.cache[str]);
		}
	}else{
		webclient.xmlrequest.addData(this, "getRecipientList", {searchstring: str, returnid: suggestlistId});
		webclient.xmlrequest.sendRequest();
	}
}

suggestEmailAddressModule.prototype.deleteRecipient = function(suggestlistId, recipient){
	webclient.xmlrequest.addData(this, "deleteRecipient", {deleteRecipient: recipient, test: "asdf", returnid: suggestlistId});
	webclient.xmlrequest.sendRequest();
	this.cache = new Array();
}

suggestEmailAddressModule.prototype.execute = function(type, action){
	var result = new Array();
	var searchstring = false;
	try{
		var resultcollection = action.getElementsByTagName("result");
		for(var i=0;i<resultcollection.length;i++){
			if(resultcollection[i].firstChild != null){
				result.push(resultcollection[i].firstChild.nodeValue);
			}
		}
		searchstring = action.getElementsByTagName("searchstring")[0].firstChild.nodeValue;
		var returnId = action.getElementsByTagName("returnid")[0].firstChild.nodeValue;

		this.cache[searchstring] = result;
	}
	catch(e){
	}

	if(typeof returnId != "undefined" && typeof this.suggestionlists[returnId] == "object"){
		this.suggestionlists[returnId].handleResult(searchstring, result);
	}
}

