/**
* Module for making the print preview and printing
*
*@author M. Erkens <m.erkens@connectux.com>
*/
printitemmodule.prototype = new ItemModule;
printitemmodule.prototype.constructor = printitemmodule;
printitemmodule.superclass = ItemModule.prototype;

function printitemmodule(id)
{
	if(arguments.length > 0) {
		this.init(id);
	}
}

printitemmodule.prototype.init = function(id)
{
	printitemmodule.superclass.init.call(this, id);
	this.printpreview = false;
}

printitemmodule.prototype.item = function(action)
{
	// get the iframe for the preview
	printing_frame = dhtml.getElementById("printing_frame").contentWindow;
	
	var message = action.getElementsByTagName("item")[0];
	this.propData = new Object();
	
	if(message && message.childNodes) {
		for(var i = 0; i < message.childNodes.length; i++)
		{
			var property = message.childNodes[i];

			if(property && property.firstChild && property.tagName == "members") {
				this.propData[property.tagName] = property;
			}else if(property && property.firstChild && property.tagName == "attachments") {
				var attachmentList = new Array();
				var attachmentNames = property.getElementsByTagName("name");
				for(var j=0;j<attachmentNames.length;j++){
					if(attachmentNames[j].firstChild){
						attachmentList.push(attachmentNames[j].firstChild.nodeValue);
					}
				}
				if(attachmentList.length > 0){
					this.propData[property.tagName] = attachmentList.join("; ");
				}
			}else {
				if(property && property.firstChild && property.firstChild.nodeValue)
				{
					if (property.tagName=="body"){
						this.propData[property.tagName] = property;
					}else{
						this.propData[property.tagName] = property.firstChild.nodeValue;
					}
				}
			}
		}
	}
	
	// select which preview type we need and create the right object
	switch(this.propData["message_class"])
	{
		case "IPM.Task":
			if(this.propData["duedate"]){
				this.propData["duedate"]=strftime_gmt(_("%a %x"), this.propData["duedate"]);
			}
			
			if(this.propData["startdate"]){
				this.propData["startdate"]=strftime_gmt(_("%a %x"), this.propData["startdate"]);
			}
			
			if(this.propData["last_modification_time"]){
				this.propData["last_modification_time"]=strftime(_("%a %x %X"), this.propData["last_modification_time"]);
			}
			this.printpreview = new printMessageItem();
			break;
			
		case "IPM.Appointment":
			if(this.propData["duedate"]){
				this.propData["duedate"]=strftime(_("%a %x %X"), this.propData["duedate"]);
			}
			
			if(this.propData["startdate"]){
				this.propData["startdate"]=strftime(_("%a %x %X"), this.propData["startdate"]);
			}
			
			if(this.propData["last_modification_time"]){
				this.propData["last_modification_time"]=strftime(_("%a %x %X"), this.propData["last_modification_time"]);
			}
			this.printpreview = new printMessageItem();
			break;
			
		case "IPM.Note":
			if(this.propData["message_delivery_time"]){
				this.propData["message_delivery_time"]=strftime(_("%a %x %X"), this.propData["message_delivery_time"]);
			}
			
			if(this.propData["last_modification_time"]){
				this.propData["last_modification_time"]=strftime(_("%a %x %X"), this.propData["last_modification_time"]);
			}
			this.printpreview = new printMessageItem();
			break;
			
		case "IPM.Schedule.Meeting":
		case "IPM.Schedule.Meeting.Request":
		case "IPM.Schedule.Meeting.Resp":
		case "IPM.Schedule.Meeting.Resp.Pos":
		case "IPM.Schedule.Meeting.Resp.Tent":
		case "IPM.Schedule.Meeting.Resp.Neg":
		case "IPM.Schedule.Meeting.Canceled":
			if(this.propData["message_delivery_time"]){
				this.propData["message_delivery_time"]=strftime(_("%a %x %X"), this.propData["message_delivery_time"]);
			}
			if(this.propData["duedate"]){
				this.propData["duedate"]=strftime(_("%a %x %X"), this.propData["duedate"]);
			}
			
			if(this.propData["startdate"]){
				this.propData["startdate"]=strftime(_("%a %x %X"), this.propData["startdate"]);
			}
			
			if(this.propData["last_modification_time"]){
				this.propData["last_modification_time"]=strftime(_("%a %x %X"), this.propData["last_modification_time"]);
			}
			this.printpreview = new printMessageItem();
			break;

		case "IPM.DistList":
			if(this.propData["last_modification_time"]){
				this.propData["last_modification_time"]=strftime(_("%a %x %X"), this.propData["last_modification_time"]);
			}
			this.printpreview = new printMessageItem();
			break;
		case "IPM.StickyNote":
		case "IPM.Contact":
		default:
			if(this.propData["last_modification_time"]){
				this.propData["last_modification_time"]=strftime(_("%a %x %X"), this.propData["last_modification_time"]);
			}
			
			if(this.propData["creation_time"]){
				this.propData["creation_time"]=strftime(_("%a %x %X"), this.propData["creation_time"]);
			}
			this.printpreview = new printMessageItem();
	}
	
	// give control to the printpreview object.
	if (this.printpreview){
		this.printpreview.init(this, printing_frame);
	}
}
