/**
* Folder properties module
*
*@author S.Koster <s.koster@zarafa.com>
*/

foldersizemodule.prototype = new Module;
foldersizemodule.prototype.constructor = foldersizemodule;
foldersizemodule.superclass = Module.prototype;

function foldersizemodule(id, element)
{
	if(arguments.length > 0) {
		this.init(id, element);
	}
}

foldersizemodule.prototype.init = function(id, element, title, data)
{
	if(data) {
		for(var property in data)
		{
			this[property] = data[property];
		}
	}
	
	foldersizemodule.superclass.init.call(this, id, element, title, data);
}

foldersizemodule.prototype.execute = function(type, action)
{
	switch(type)
	{
		case "foldersize":
			this.setFolderSizeData(action);
			break;
	}
}

/**
* make a XML request for folder size data
* data must be an array with the store and folder entryid
*/
foldersizemodule.prototype.getFolderSize = function()
{
	var data = {
		"store": this.store,
		"entryid": this.entryid
	};
	webclient.xmlrequest.addData(this, "foldersize", data);
	webclient.xmlrequest.sendRequest();
}

foldersizemodule.prototype.setFolderSizeData = function(action){
	var mainfolder = action.getElementsByTagName("mainfolder");
	// Make sure to only get folder-items belong the subfolders-item
	var subfolderlist = action.getElementsByTagName("subfolders");
	subfolderlist = action.getElementsByTagName("folder");

	// Get the properies for the selected folder
	dialogData = {
		'name': dhtml.getXMLValue(mainfolder[0], "name"),
		'size': parseInt(dhtml.getXMLValue(mainfolder[0], "size"),10) + _("KB"),
		'totalsize': parseInt(dhtml.getXMLValue(mainfolder[0], "totalsize"),10) + _("KB"),
		'subfolders': new Array()
	
	};
	// Build data for subfolder list
	for(var i=0;i<subfolderlist.length;i++){
		dialogData['subfolders'].push({
			name: {
				innerHTML: dhtml.getXMLValue(subfolderlist[i], "name")
			},
			size: {
				innerHTML: parseInt(dhtml.getXMLValue(subfolderlist[i], "size"),10) + _("KB")
			},
			totalsize: {
				innerHTML: parseInt(dhtml.getXMLValue(subfolderlist[i], "totalsize"),10) + _("KB")
			}
		});
		
	}
	this.size_data = dialogData;
	parseFolderSizeData(dialogData);
}
