datepickerlistmodule.prototype = new ListModule;
datepickerlistmodule.prototype.constructor = datepickerlistmodule;
datepickerlistmodule.superclass = ListModule.prototype;

function datepickerlistmodule(id, element, title, data)
{
	if(arguments.length > 0) {
		this.init(id, element, title, data);
	}
}

datepickerlistmodule.prototype.init = function(id, element, title, data)
{
	this.elementHeight = 160;
	datepickerlistmodule.superclass.init.call(this, id, element, title, data);
	this.initializeView();
	
	var todayTitle = new Date().getDate()+" "+MONTHS[new Date().getMonth()]+" "+new Date().getFullYear();

	this.menuItems.push(webclient.menu.createMenuItem("seperator", ""));
	this.menuItems.push(webclient.menu.createMenuItem("today", _("Today"), _("Today")+": "+todayTitle, eventDatePickerContextGoToday));
	this.menuItems.push(webclient.menu.createMenuItem("seperator", ""));
	this.menuItems.push(webclient.menu.createMenuItem("day", _("Day"), _("Day"), eventDatePickerSwitchCalendarView ));
	this.menuItems.push(webclient.menu.createMenuItem("workweek", _("Workweek"), _("Workweek"), eventDatePickerSwitchCalendarView));
	this.menuItems.push(webclient.menu.createMenuItem("week", _("Week"), _("Week"), eventDatePickerSwitchCalendarView));
	this.menuItems.push(webclient.menu.createMenuItem("7days", _("7 Days"), _("7 Days"), eventDatePickerSwitchCalendarView));
	this.menuItems.push(webclient.menu.createMenuItem("month", _("Month"), _("Month"), eventDatePickerSwitchCalendarView));

	webclient.menu.buildTopMenu(this.id, "appointment", this.menuItems, eventListNewMessage);
}

datepickerlistmodule.prototype.initializeView = function(month, year)
{
	this.setTitle(this.title, false, true);
	this.contentElement = dhtml.addElement(this.element, "div");
	
	this.events = new Object();
	this.events["day"] = new Object();
	this.events["day"]["mousedown"] = eventDatePickerListChangeDay;
	this.events["nextmonth"] = new Object();
	this.events["nextmonth"]["mousedown"] = eventDatePickerListNextMonth;
	this.events["previousmonth"] = new Object();
	this.events["previousmonth"]["mousedown"] = eventDatePickerListPreviousMonth;
	
}

datepickerlistmodule.prototype.loadFolder = function(folder, data)
{
	if (this.appointmentmodule){
		webclient.deleteModule(this.appointmentmodule);
	}

	this.appointmentmodule = webclient.loadModule("appointmentlist", folder["display_name"], "main", data, BORDER_LAYOUT);
	webclient.hierarchy.setNumberItems(folder["content_count"], folder["content_unread"]);
	this.appointmentmodule.datepicker = this;	
	
	// reload datepicker with new data

	this.setData(data);

	var date = new Date();
	this.changeMonth(date.getMonth()+1, date.getFullYear(), true, true);
	this.changeSelectedDate(date.getTime(), false);
}

datepickerlistmodule.prototype.changeMonth = function(month, year, previous, delay)
{
	if(previous) {
		month--;
		
		if(month < 0) {
			month = 11;
			year--;
		}
	} else {
		month++;
		
		if(month > 11) {
			month = 0;
			year++;
		}
	}
	
	var date = new Date();
	this.startdate = date.setTimeStamp(1, month+1, year) / 1000;
	
	dhtml.deleteAllChildren(this.contentElement);

	var data = new Object();
	data["month"] = month;
	data["year"] = year;
	
	if(this.timeoutid)
    	clearTimeout(this.timeoutid)
	
	this.viewController.initView(this.id, "datepicker", this.contentElement, this.events, data);
	if(!delay)
    	this.list();
    else
        this.timeoutid = setTimeout('webclient.modules.webclient_' + this.id + '.list(); webclient.xmlrequest.sendRequest();', 500);
}

datepickerlistmodule.prototype.getRestrictionData = function()
{
	var restriction = new Object();
	
	if(this.startdate) {
		restriction["startdate"] = this.startdate;
	} else
		restriction = false; // cancel list, we have no startdate yet
	
	return restriction;
}

datepickerlistmodule.prototype.changeSelectedDate = function (newdate, refresh)
{
	this.oldDate = this.selectedDate;
	var oldElem = dhtml.getElementById(this.oldDate);
	var newElem = dhtml.getElementById(newdate)
	dhtml.removeClassName(oldElem,"calendarselect");
	if (!dhtml.hasClassName(newElem, "calendartoday")){
		dhtml.addClassName(newElem,"calendarselect");
	}
	
	if(this.appointmentmodule && refresh) {
		this.appointmentmodule.changeDays(newdate);
	}

	this.selectedDate = newdate;
}

datepickerlistmodule.prototype.changeView = function (view, refresh)
{
	if (this.appointmentmodule) {
		this.appointmentmodule.destructor();
		this.appointmentmodule.initializeView(view);
		if(refresh)
			this.appointmentmodule.changeDays(this.appointmentmodule.selectedDate);
	}
}

datepickerlistmodule.prototype.deleteMessages = function ()
{
	this.appointmentmodule.deleteMessages(this.appointmentmodule.getSelectedMessages());
}

datepickerlistmodule.prototype.showCopyMessagesDialog = function ()
{
	this.appointmentmodule.showCopyMessagesDialog();
}

datepickerlistmodule.prototype.printItem = function()
{
	moduleObject = this.appointmentmodule;
	moduleObject.printItem(moduleObject.entryids[moduleObject.selectedMessages[0]]);
}

/**
* Function to open a print dialog
* @param string entryid The entryid for the item
*/
datepickerlistmodule.prototype.printList = function(entryid) 
{
	var windowData = new Object();
	
	windowData["modulename"] = this.appointmentmodule.getModuleName();
	windowData["moduleID"] = this.appointmentmodule.id;
	windowData["startdate"] = this.appointmentmodule.startdate;
	windowData["duedate"] = this.appointmentmodule.duedate;
	windowData["selecteddate"] = this.appointmentmodule.selectedDate;
	windowData["view"] = this.appointmentmodule.selectedview;

	// temporarily disabled day/workweek/7days views
	switch(windowData["view"]) {
		case "day":
			windowData["view"] = "list";
			break;
		case "workweek":
			windowData["view"] = "week";
			break;
		case "7days":
			windowData["view"] = "week";
			break;
	}

	// please note that this url is also printed, so make it more "interesting" by first set the entryid
	webclient.openModalDialog(this, "printing", DIALOG_URL+"entryid="+entryid+"&storeid="+this.storeid+"&task=printlist_modal", 714, 800, null, null, windowData);
}

function eventDatePickerListNextMonth(moduleObject, element, event)
{
	var month = false;
	var year = false;
	var classNames = element.className.split(" ");
	
	for(var i = 0; i < classNames.length; i++)
	{
		if(classNames[i].indexOf("_") > 0) {
			month = parseInt(classNames[i].substring(classNames[i].indexOf("_") + 1, classNames[i].lastIndexOf("_")));
			year = parseInt(classNames[i].substring(classNames[i].lastIndexOf("_") + 1));
		}
	}
	
	moduleObject.changeMonth(month, year, false, true);
}

function eventDatePickerListPreviousMonth(moduleObject, element, event)
{
	var month = false;
	var year = false;
	var classNames = element.className.split(" ");
	
	for(var i = 0; i < classNames.length; i++)
	{
		if(classNames[i].indexOf("_") > 0) {
			month = parseInt(classNames[i].substring(classNames[i].indexOf("_") + 1, classNames[i].lastIndexOf("_")));
			year = parseInt(classNames[i].substring(classNames[i].lastIndexOf("_") + 1));
		}
	}
	
	moduleObject.changeMonth(month, year, true, true);
}

function eventDatePickerListChangeDay(moduleObject, element, event)
{
	moduleObject.changeSelectedDate(parseInt(element.id), true);
}

function eventDatePickerSwitchCalendarView(moduleObject, element, event)
{
	var newView = element.id;
	moduleObject.changeView(newView, true);
}

function eventDatePickerContextGoToday(moduleObject, element, event)
{
	var date = new Date();
	moduleObject.changeMonth(date.getMonth()+1, date.getFullYear(), true);
	moduleObject.changeSelectedDate(date.getTime(), true);
}
