/**
 * function to handle the action restore selected items.
 * collect the entry ids from selected rows and pass them to request
 * with type = restore, to server.
 */
function restore_selected_items(){
	var selectedRowCount = tableWidget.getNumSelectedRows();
	var entryIds = new Array();
	if(selectedRowCount > 0){
		for (var i=0; i<selectedRowCount; i++){
			var rowId = tableWidget.getSelectedRowID(i);
			entryIds.push(tableWidget.getDataByRowID(rowId).entryid);
		}
		var send = confirm(_("Would you like to restore selected items?"));
		if(send) {
			var data = createRequestObject(module, "restore", entryIds);
	
			webclient.xmlrequest.showLoader();
			if(parentWebclient){
				parentWebclient.xmlrequest.addData(module, "restore", data, webclient.modulePrefix);
				parentWebclient.xmlrequest.sendRequest();
			}else{
				webclient.xmlrequest.addData(module, "restore", data);
				webclient.xmlrequest.sendRequest();
			}
		}
	}else{
		alert(_("Please select a row first to restore"));
	}
}
/**
 * function to handle the action delete permanently selected items.
 * collect the entry ids from selected rows and pass them to request
 * with type = delete, to server.
 */
function permanent_delete_items(){
	var selectedRowCount = tableWidget.getNumSelectedRows();
	var entryIds = new Array();
	if(selectedRowCount > 0){
		for (var i=0; i<selectedRowCount; i++){
			var rowId = tableWidget.getSelectedRowID(i);
			entryIds.push(tableWidget.getDataByRowID(rowId).entryid);
		}
		var send = confirm(_("Would you like to delete selected items permanently, after that you will not be able to restore them anyway?"));
		if(send) {
			var data = createRequestObject(module, "delete", entryIds);
			webclient.xmlrequest.showLoader();
			webclient.xmlrequest.addData(module, "delete", data);
			webclient.xmlrequest.sendRequest();
		}
	}else{
		alert(_("Please select a row first to delete"));
	}
}

/**
 * function to handle the action delete all items permanently
 * pass the parameter type = deleteall, to server.
 */
function permanent_delete_all(){
	var send = confirm(_("Would you like to delete all items permanently, after that you will not be able to restore them anyway?"));
	if(send) {
		var data = createRequestObject(module, "deleteall", null);
		webclient.xmlrequest.showLoader();
		// The cancel call will delete the item for us	
		webclient.xmlrequest.addData(module, "deleteall", data);
		webclient.xmlrequest.sendRequest();
	}
}

/**
 * function to handle the action restore all items permanently
 * pass the parameter type = restoreall, to server.
 */
function permanent_restore_all(){
	var send = confirm(_("Would you like to restore all items?"));
	if(send) {
		var data = createRequestObject(module, "restoreall", null);
		webclient.xmlrequest.showLoader();
		if(parentWebclient){
			parentWebclient.xmlrequest.addData(module, "restoreall", data, webclient.modulePrefix);
			parentWebclient.xmlrequest.sendRequest();
		}else{
			webclient.xmlrequest.addData(module, "restoreall", data);
			webclient.xmlrequest.sendRequest();
		}
	}
}

/**
 * function to initialize the table widget and put the data into it.
 * it also update the status bar's data.
 * @param object data an object with data to be filled in table widget.
 */
function initRestoreItems(data){
	var columnData = [
			{id:"icon_index",name:"","title":"Icon","sort":false,"visibility":true,"order":0,"width":25},
			{id:"sender_name",name:_("From"),"title":"From","sort":true,"visibility":true,"order":1,"width":200},
			{id:"subject",name:_("Subject"),"title":"Subject","sort":true,"visibility":true,"order":2,"width":300},
			{id:"deleted_on",name:_("Deleted on"),"title":"Deleted on","sort":true,"visibility":true,"order":3,"width":100},
			{id:"message_size",name:_("Size"),"title":"Size","sort":true,"visibility":true,"order":4,"width":""}
		]; 
	

	//create table widget view here
	var tableWidgetElem = dhtml.getElementById("restoreitemstable");

	tableWidget = new TableWidget(tableWidgetElem);

	for (var x in columnData){
		var col = columnData[x];
		tableWidget.addColumn(col["id"],col["name"],col["width"],col["order"],col["title"],col["sort"],col["visibility"]);
	}

	//put the data in table widget
	var items = new Array();
	
	//create an object to pass as data object in talewidget.
	for(var i in data){
		var itemData = data[i];
		var item = new Object();

		for(var j=0;j<columnData.length;j++){
			var value = "";
			var colId = columnData[j]["id"];
			switch(colId){
				case "icon_index":
					value = "<div class='rowcolumn message_icon "+iconIndexToClassName(itemData["icon_index"], itemData["message_class"], false)+"'>&nbsp;</div>";
					break;
				case "deleted_on":
					var dueBy = new Date(itemData["deleted_on"]*1000);
					value = dueBy.toDate();
					break;
				default:
					if(typeof(itemData[colId])!="undefined"){
						value = itemData[colId];
					}else{
						value = "&nbsp;";
					}
			}
			item[colId] = {innerHTML: value};
		}
		item["entryid"] = itemData["entryid"];
		item["rowID"] = itemData["entryid"];
		items.push(item);
	}

	//generate tableWidget
	tableWidget.generateTable(items);


	//set the status bar message
	var status = dhtml.getElementById("restoreitems_status");
	var selectedRowCount = tableWidget.getRowCount();
	status.innerHTML = _("Total %s recoverable items").sprintf("<b>"+selectedRowCount+"</b>");
	
	//Hide the loader. // need to check.. actually it should work but not working properly.
	if(webclient.xmlrequest.getRequestCount() > 0){
		webclient.xmlrequest.hideLoader();	
	}
}

/**
 * function which creates the request object for all functions.
 * @param Object moduleObject contains all data of module  object.
 * @param String actio_type define the action.
 * @param Array entryIdList array of selected entryIds 
 *                          if null passed as value that means function is delete
 * @return the request data object.
 */
function createRequestObject(moduleObject, action_type, entryIdList){
	var data = new Object;
	data["store"] = moduleObject.storeid;
	data["entryid"] = moduleObject.entryid;
	data["attributes"] = new Object();
	data["attributes"]["type"] = action_type;

	if(!!entryIdList){
		data["entrylist"] = entryIdList;
	}
	return data;
}
