function initEditor(useHTMLEditor, FCKEDITOR_JS_PATH, client_lang, spellchecker){
	if (useHTMLEditor){
		var height = 366;
		if(parentWebclient.settings.get("createmail/from", "false") != "false"){
			height -= 24;
		}
		var oFCKeditor = new FCKeditor("html_body", "100%", height+"px");
		oFCKeditor.EditorPath = FCKEDITOR_JS_PATH + "/";
		oFCKeditor.BasePath = oFCKeditor.EditorPath;
		oFCKeditor.ReplaceTextarea();
		document.fcklanguage = client_lang;
		document.fckspellcheck = spellchecker;
	}
}

function resizeBody()
{
	var use_html = dhtml.getElementById("use_html");
	var html_body = dhtml.getElementById("html_body");
	if(use_html && use_html.value == "true") {
		html_body = dhtml.getElementById("html_body___Frame");
	}
	
	if(html_body) {
		var height = document.documentElement.clientHeight - dhtml.getElementTop(html_body);
		
		var categoriesbar = dhtml.getElementById("categoriesbar");
		if(categoriesbar) {
			height -= categoriesbar.offsetHeight;
		}
		
		if(height < 50) {
			height = 50;
		}
		
		var width = html_body.parentNode.offsetWidth;
		if(width < 50) {
			width = 50;
		}

		html_body.style.height = (height - 10) + "px";
		html_body.style.width = "100%";
	}

	//Resize module
	if (module && typeof(module.resize) != "undefined") {
		module.resize();
	}
}

function getPropsFromDialog() {
	var props = new Object();
	
	// All input fields with an id
	var input = document.getElementsByTagName("input");
	for(var i = 0; i < input.length; i++) {
		if(input[i].id) {
			switch (input[i].type){
				case "checkbox":
				case "radio":
					props[input[i].id] = input[i].checked;
					break;
				case "hidden":
				case "text":
				default:
					props[input[i].id] = input[i].value;
			}
		}
	}
	
	// All textarea's with an id (except html_body)
	var textarea = document.getElementsByTagName("textarea");
	for(var i = 0; i < textarea.length; i++) {
		if(textarea[i].id && textarea[i]!="html_body") {
			props[textarea[i].id] = textarea[i].value;
		}
	}

	// select boxes
	var select = document.getElementsByTagName("select");
	for(var i = 0; i < select.length; i++) {
		if(select[i].id) {
			props[select[i].id] = select[i].value;
		}
	}

	// Body
	if(typeof(FCKeditorAPI) != "undefined" && (fckEditor = FCKeditorAPI.GetInstance("html_body"))) {
		props["body"] = cleanHTML(fckEditor.GetXHTML());
	}else{
		var body = dhtml.getElementById("html_body");
		if (body) {
			props["body"] = body.value;
		}
	}
	
	return props;
}

function getRecipients() {
	var recipients = new Array();
	var types = new Array("to", "cc", "bcc");

	for(var i = 0; i < types.length; i++) {
		var element = dhtml.getElementById(types[i]);
	
		if(element && element.value != "") {
			var recipientRows = element.value.split(";");

			for(var j = 0; j <  recipientRows.length; j++)
			{
				if(recipientRows[j].trim() != "") {
					var recipient = new Object();

					var regex = new RegExp(/([^<]*){0,1}\s*(<\s*([^>]*)>\s*){0,1}/);
					var result = regex.exec(recipientRows[j].trim());

					if(typeof result[1] != "undefined" || result[1] != ""){	
						result[1] = result[1];
					} else {
						// username
						result[1] = result[3];
					}
					
					if(typeof result[3] != "undefined" || result[3] != ""){
						result[3] = result[3];
					} else {
						// username@zarafa.com
						result[3] = result[1];
					}
					
					if(typeof result[3] == "undefined" || result[3] == ""){
						recipient["name"] = result[1].trim();
						recipient["address"] = result[1].trim();
					} else {
						recipient["name"] = result[1].trim();
						recipient["address"] = result[3].trim();
					}
									
					recipient["type"] = "mapi_" + types[i];
					recipients.push(recipient);
				}
			}
		}
	}
	
	return recipients;
}

function submit_createmail(send) {
    if (!window.waitForSaveResponse){ 
		if(send && module){
			if(validateEmailAddress(dhtml.getElementById("to").value, false, window.resolveForSendingMessage?false:true) && 
			 validateEmailAddress(dhtml.getElementById("cc").value, false, window.resolveForSendingMessage?false:true) && 
			 validateEmailAddress(dhtml.getElementById("bcc").value, false, window.resolveForSendingMessage?false:true)){
	 			window.waitForSaveResponse = true;
				var props = getPropsFromDialog();
				var recipients = new Object();
				recipients["recipient"] = getRecipients();
				if (recipients["recipient"].length==0){
					alert(_("Please input a valid email address!"));
					return;
				}
				
				module.save(props, send, recipients, dhtml.getElementById("dialog_attachments").value);

				// close opener window
				if (webclient.settings.get("createmail/close_read_on_reply", "no")=="yes" && window.opener && window.opener.name.indexOf("readmail")==0){
					window.opener.close();
				}
				
				// close our own window
				window.messageChanged = false;
				window.close();
			} else if (window.resolveForSendingMessage !== true) {
				// Set status for the resolver to know he has to call this function again
				window.resolveForSendingMessage = true;
				checkNames();
			}else{
				// Reset status for the resolver to know he does not have to call this function again
				window.resolveForSendingMessage = false;
			}
		} else{
			window.waitForSaveResponse = true;
			var props = getPropsFromDialog();
			var recipients = new Object();
			var recipientList = getRecipients();
			if(recipientList.length > 0){
				recipients["recipient"] = recipientList;
			}
			
			window.document.title = _("Create E-Mail");
			window.messageChanged = false;
			module.save(props, send, recipients, dhtml.getElementById("dialog_attachments").value);
		}
	}
}

function submit_stickynote() {
	if(module) {
		var props = getPropsFromDialog();
				
		module.save(props);
		window.close();
	}
}

function submit_contact()
{
	if(module) {
		var props = getPropsFromDialog();
		
		var email_addresses = new Object();
		email_addresses["email_address"] = new Array();
		
		for(var i = 1; i < 4; i++)
		{
			var email_address_element = dhtml.getElementById("email_address_" + i);
			var email_address_display_name_element = dhtml.getElementById("email_address_display_name_" + i);
			
			if(email_address_element && email_address_element.value != "") {
				var email_address = new Object();
				email_address["id"] = i;
				email_address["name"] = (email_address_display_name_element && email_address_display_name_element.value != ""?email_address_display_name_element.value:email_address_element.value);
				email_address["address"] = email_address_element.value;
				email_addresses["email_address"].push(email_address);
			}
		}
					
		module.save(props, email_addresses, dhtml.getElementById("dialog_attachments").value);
		window.close();
	}
}

function submit_task() {
	if(module) {
		var props = getPropsFromDialog();

		// check for precent complete value
		var text_percent_complete = props["text_percent_complete"];

		if(text_percent_complete.indexOf("%") >= 0) {
			text_percent_complete = text_percent_complete.substring(0, text_percent_complete.indexOf("%"));
		}

		text_percent_complete = parseInt(text_percent_complete);

		if(isNaN(text_percent_complete) || text_percent_complete > 100 || text_percent_complete < 0) {
			alert(_("Precent complete must be a number between 0 and 100"));
			return false;
		}

		module.save(props, false, false, dhtml.getElementById("dialog_attachments").value);
		window.close();
	}
}

function delete_item()
{
	module.deleteMessage();
	window.close();
}

function setImportance(value) 
{
	var importance = dhtml.getElementById("importance");

	if(importance) {
		var priority_high = dhtml.getElementById("priority_high");
		var priority_low = dhtml.getElementById("priority_low");

		switch(value)
		{
			case 0:
				dhtml.addClassName(priority_low, "menubuttonselected");
				dhtml.removeClassName(priority_high, "menubuttonselected");
				break;
			case 2:
				dhtml.addClassName(priority_high, "menubuttonselected");
				dhtml.removeClassName(priority_low, "menubuttonselected");
				break;
			default:
				dhtml.removeClassName(priority_low, "menubuttonselected");
				dhtml.removeClassName(priority_high, "menubuttonselected");
				break;
		}
		
		importance.value = value;
	}
}

//@todo fix this function
function changeItem(type)
{
	if(window.opener)
	{
		var message = window.opener.moduleObject.entryids;
		
		if(message) {
			var nextMessage = false;
			switch(type)
			{
				case "next":
					nextMessage = message.nextSibling;
					//this will not work when you change to an other view or page
					break;
				case "previous":
					nextMessage = message.previousSibling;
					//this will not work when you change to an other view or page
					break;
			}
			
			if(nextMessage) {
				var nextMessageLocation = new String(window.location);
				window.location = nextMessageLocation.substring(0, nextMessageLocation.lastIndexOf("=") + 1) + nextMessage.id;
				
				window.opener.dhtml.executeEvent(nextMessage, "mousedown");
				window.opener.dhtml.executeEvent(nextMessage, "mouseup");
			}
		}
	}
}

function changeCheckBoxStatus(id)
{
	var checkbox = dhtml.getElementById(id);
	
	if(checkbox) {
		if(checkbox.checked) {
			checkbox.checked = false;
		} else {
			checkbox.checked = true;
		}
	}
}

function attachmentSelect()
{
	var filelist = dhtml.getElementById("filelist");
	
	if(filelist) {
		var value = filelist.options[filelist.selectedIndex].value;
		
		var type = dhtml.getElementById("type");
		type.value = "attachment";
		if(String(value).search(/^[0-9]*$/) == -1){
			type.value = "new";
		}
		
		var deleteattachment = dhtml.getElementById("deleteattachment");
		deleteattachment.value = value;
	}
}

/**
 * eventMenuAddSignature
 * 
 * If the module contains signature items and if so, build the menu.
 */
function eventMenuAddSignature(){
	if(module.addSigMenuItems.length > 0){
		var posX = dhtml.getElementLeft(dhtml.getElementById("addsignature"));
		var posY = dhtml.getElementTop(dhtml.getElementById("addsignature"));
		posY += dhtml.getElementById("addsignature").offsetHeight;
		webclient.menu.buildContextMenu(module.id, "addsignature", module.addSigMenuItems, posX, posY);
	}else{
		alert(_("No signatures"));
	}
}

/**
 * addSignature
 * 
 * Add selected signature to the body of the message.
 * @param signatureID number ID of signature that is selected.
 */
function addSignature(signatureID)
{
	setMessageChanged();
	var signature = module.getSignature(signatureID);
	
	if(signature) {
		var use_html = dhtml.getElementById("use_html");
		if(use_html) {
			if(use_html.value == "false") {
				var body = dhtml.getElementById("html_body");
				if (body.setSelectionRange){
					body.value = body.value.substring(0, body.selectionStart) + signature + body.value.substring(body.selectionStart, body.selectionEnd) + body.value.substring(body.selectionEnd, body.value.length);
				} else if (document.selection && document.selection.createRange) {
					body.value = body.value.substring(0, window.start) + signature + body.value.substring(window.start, window.end) + body.value.substring(window.end, body.value.length);
				}
			} else {
				if(typeof(FCKeditorAPI) != "undefined" && (fckEditor = FCKeditorAPI.GetInstance("html_body"))) {
					signature = signature.htmlEntities();
					fckEditor.Selection.Restore();
					signature = signature.replace(/\n/g, "<br>");
					fckEditor.InsertHtml(signature);
				}
			}
		}
	} else {
		alert(_("No signature"));
	}
}

function getMailOptions()
{
	var parentwindow = window.opener;
	if(!parentwindow) {
		if(window.dialogArguments) {
			parentwindow = window.dialogArguments.parentWindow;
		}
	}
	
	var importance = dhtml.getElementById("importance");
	if(importance) {
		for(var i = 0; i < importance.options.length; i++)
		{
			var option = importance.options[i];
			if(option.value == parentwindow.dhtml.getElementById("importance").value) {
				option.selected = true;
			}
		}
	}
	
	var sensitivity = dhtml.getElementById("sensitivity");
	if(sensitivity) {
		for(var i = 0; i < sensitivity.options.length; i++)
		{
			var option = sensitivity.options[i];
			if(option.value == parentwindow.dhtml.getElementById("sensitivity").value) {
				option.selected = true;
			}
		}
	}

	var read_receipt = dhtml.getElementById("read_receipt");
	if(read_receipt) {
		var checked = false;
		if(parentwindow.dhtml.getElementById("read_receipt_requested").value == "1") {
			checked = true;
		}
		
		read_receipt.checked = checked;
	}
}

/**
 * Function will start the resolveNames process
 */ 
function checkNames()
{
	var recipients = new Array("to", "cc", "bcc");
	var resolveObj = new Object();
	for(var i = 0; i < recipients.length; i++)
	{
		if(dhtml.getElementById(recipients[i]).value){
			resolveObj[recipients[i]] = dhtml.getElementById(recipients[i]).value;
		} else {
			resolveObj[recipients[i]] = "";
		}
	}
	parentWebclient.resolvenames.resolveNames(resolveObj,checkNamesCallBack);
}

/**
 * Function is the callback function of resolveNames and will replace the resolved names
 * @param = "Object" of the resolved names
 */ 
function checkNamesCallBack(resolveObj)
{
	for(var i in resolveObj){
		if(dhtml.getElementById(i) && dhtml.getElementById(i).value){
			
			//replace unresolved name
			var unResolved = dhtml.getElementById(i).value.split(";");
			for(var keyword in resolveObj[i]){
				for(var j=0; j<unResolved.length; j++){
					unResolved[j] = unResolved[j].trim();
					if(unResolved[j] == keyword){
						unResolved[j] = resolveObj[i][keyword]["fullname"]+" <"+resolveObj[i][keyword]["emailaddress"]+">";
					}
				}				
			}
			
			//build string
			var newString = "";
			for(var j=0; j<unResolved.length; j++){
				newString += unResolved[j]+";";
			}
			dhtml.getElementById(i).value = newString;
		}
	}

	//Send mail
	if(window.resolveForSendingMessage === true){
		submit_createmail(true);
	}
}

function timeSpinnerUp(time_element)
{
	if(time_element) {
		if(time_element.value.indexOf(":")) {
			var hour = time_element.value.substring(0, time_element.value.indexOf(":"));
			var minutes = time_element.value.substring(time_element.value.indexOf(":") + 1);
			
			if(hour.substring(0, 1) == "0") {
				hour = hour.substring(1);
			}
			
			if(minutes.substring(0, 1) == "0") {
				minutes = minutes.substring(1);
			}
			
			hour = parseInt(hour);
			minutes = parseInt(minutes);
			
			if(hour >= 0 && minutes >= 0) {
				if(minutes >= 0 && minutes <= 29) {
					minutes = 30;
				} else if(minutes >= 30 && minutes <= 59) {
					hour++;
					minutes = 0;
				}
				
				if(hour > 23) {
					hour = 0;
				}
				
				time_element.value = (hour < 10?"0" + hour:hour) + ":" + (minutes < 10?"0" + minutes:minutes);
			} else {
				time_element.value = "09:00";
			}
		} else {
			time_element.value = "09:00";
		}
	}
	
	onChangeDate();
}

function timeSpinnerDown(time_element)
{
	if(time_element) {
		if(time_element.value.indexOf(":")) {
			var hour = time_element.value.substring(0, time_element.value.indexOf(":"));
			var minutes = time_element.value.substring(time_element.value.indexOf(":") + 1);
			
			if(hour.substring(0, 1) == "0") {
				hour = hour.substring(1);
			}
			
			if(minutes.substring(0, 1) == "0") {
				minutes = minutes.substring(1);
			}
			
			hour = parseInt(hour);
			minutes = parseInt(minutes);
			
			if(hour >= 0 && minutes >= 0) {
				if(minutes >= 0 && minutes <= 29) {
					minutes = 30;
					hour--;
				} else if(minutes >= 30 && minutes <= 59) {
					minutes = 0;
				}
				
				if(hour < 0) {
					hour = 23;
				}
				
				time_element.value = (hour < 10?"0" + hour:hour) + ":" + (minutes < 10?"0" + minutes:minutes);
			} else {
				time_element.value = "09:00";
			}
		} else {
			time_element.value = "09:00";
		}
	}
	
	onChangeDate();	
}

function onChangeDate()
{
	var text_startdate = dhtml.getElementById("text_startdate");
	var text_startdate_time = dhtml.getElementById("text_startdate_time");
	
	var text_duedate = dhtml.getElementById("text_duedate");
	var text_duedate_time = dhtml.getElementById("text_duedate_time");
	
	if(text_duedate.value.toLowerCase() == _("None").toLowerCase()) {
		text_duedate.value = text_startdate.value;
	}
	
	var startdate = Date.parseDate(text_startdate.value + " " + (text_startdate_time?text_startdate_time.value:"00:00"), _("%d-%m-%Y") + " " + _("%H:%M"));
	var duedate =   Date.parseDate(text_duedate.value + " " + (text_duedate_time?text_duedate_time.value:"00:00"), _("%d-%m-%Y") + " " + _("%H:%M"));

	if(duedate && startdate) {
		if(startdate > duedate) {
			text_startdate.value = text_duedate.value;

			if(text_startdate_time && text_duedate_time) {
				text_startdate_time.value = text_duedate_time.value;
			}
		}
	}
}


function changeFromAddress(){
	var from = dhtml.getElementById("from").value;

	var name = "";
	var email = "";

	var regex = new RegExp(/([^<]*){0,1}\s*(<\s*([^>]*)>\s*){0,1}/);
	var result = regex.exec(from.trim());

	if(result[1] != undefined && result[3] != undefined){
		if(!result[1] || result[1] == "" || !result[3] || result[3] != ""){
			name = result[1];
			email = result[3];

			if(!name){
				name = email;
			}
			if(!email){
				email = name;
			}
		}
	}

	dhtml.getElementById("sent_representing_name").value = name;
	dhtml.getElementById("sent_representing_email_address").value = email;
	dhtml.getElementById("sent_representing_addrtype").value = "SMTP";
}

/**
 * ZarafaDnD Firefox extension functions
 */
function getDnDinfo(){
	if(DND_FILEUPLOAD_URL){
		var url = window.location.protocol + "//" + window.location.host + "" + window.location.pathname;
		url = url.replace("index.php", "");
		if(url.charAt(url.length-1) != "/"){
			url+="/";
		}

		var dndinfo = new Object();
		dndinfo["url"] = url + DND_FILEUPLOAD_URL;
		dndinfo["dialog_attachments"] = dhtml.getElementById('dialog_attachments').value;
		return dndinfo;
	}
	return false;
}
function setDnDAttachments(input){
	var newattachments = new Array();
	var files = input.split("||");
	for(var i=0;i<files.length;i++){
		var file = files[i].split("|");
		var attachment = new Object();
		attachment["attach_num"] = file[0]
		attachment["name"] = file[1]
		attachment["size"] = file[2];
		newattachments.push(attachment);
	}
	module.newattachments = newattachments;
	module.setAttachments();
}
function allowDnDFiles(element){
	if(window.BROWSER_IE)
		return false;

	// Fire event to let the ZarafaDnD Firefox extension know that this dialog accepts dragged files
	dhtml.executeEvent((element||document.body), "ZarafaDnD");
}

/**
 * Function which will clean the string that is copied
 * directly from Word.
 * @param string html contains the raw paste from the clipboard
 * @return string cleaned string
 */
function cleanHTML(html)
{
	html = html.replace(/<o:p>\s*<\/o:p>/g, '') ;
	html = html.replace(/<o:p>.*?<\/o:p>/g, '&nbsp;') ;

	// Remove mso-xxx styles.
	html = html.replace( /\s*mso-[^:]+:[^;"]+;?/gi, '' ) ;

	// Remove margin styles.
	html = html.replace( /\s*MARGIN: 0cm 0cm 0pt\s*;/gi, '' ) ;
	html = html.replace( /\s*MARGIN: 0cm 0cm 0pt\s*"/gi, "\"" ) ;

	html = html.replace( /\s*TEXT-INDENT: 0cm\s*;/gi, '' ) ;
	html = html.replace( /\s*TEXT-INDENT: 0cm\s*"/gi, "\"" ) ;

	html = html.replace( /\s*TEXT-ALIGN: [^\s;]+;?"/gi, "\"" ) ;

	html = html.replace( /\s*PAGE-BREAK-BEFORE: [^\s;]+;?"/gi, "\"" ) ;

	html = html.replace( /\s*FONT-VARIANT: [^\s;]+;?"/gi, "\"" ) ;

	html = html.replace( /\s*tab-stops:[^;"]*;?/gi, '' ) ;
	html = html.replace( /\s*tab-stops:[^"]*/gi, '' ) ;

	// Remove Class attributes
	html = html.replace(/<(\w[^>]*) class=([^ |>]*)([^>]*)/gi, "<$1$3") ;

	// Remove empty styles.
	html =  html.replace( /\s*style="\s*"/gi, '' ) ;

	html = html.replace( /<SPAN\s*[^>]*>\s*&nbsp;\s*<\/SPAN>/gi, '&nbsp;' ) ;

	html = html.replace( /<SPAN\s*[^>]*><\/SPAN>/gi, '' ) ;

	// Remove Lang attributes
	html = html.replace(/<(\w[^>]*) lang=([^ |>]*)([^>]*)/gi, "<$1$3") ;

	html = html.replace( /<SPAN\s*>(.*?)<\/SPAN>/gi, '$1' ) ;

	html = html.replace( /<FONT\s*>(.*?)<\/FONT>/gi, '$1' ) ;

	// Remove XML elements and declarations
	html = html.replace(/<\\?\?xml[^>]*>/gi, '' ) ;

	// Remove Tags with XML namespace declarations: <o:p><\/o:p>
	html = html.replace(/<\/?\w+:[^>]*>/gi, '' ) ;

	// Remove comments [SF BUG-1481861].
	html = html.replace(/<\!--.*?-->/g, '' ) ;

	html = html.replace( /<(U|I|STRIKE)>&nbsp;<\/\1>/g, '&nbsp;' ) ;

	html = html.replace( /<H\d>\s*<\/H\d>/gi, '' ) ;

	// Remove "display:none" tags.
	html = html.replace( /<(\w+)[^>]*\sstyle="[^"]*DISPLAY\s?:\s?none(.*?)<\/\1>/ig, '' ) ;

	// Remove language tags
	html = html.replace( /<(\w[^>]*) language=([^ |>]*)([^>]*)/gi, "<$1$3") ;

	// Remove onmouseover and onmouseout events (from MS Word comments effect)
	html = html.replace( /<(\w[^>]*) onmouseover="([^\"]*)"([^>]*)/gi, "<$1$3") ;
	html = html.replace( /<(\w[^>]*) onmouseout="([^\"]*)"([^>]*)/gi, "<$1$3") ;
	html = html.replace( /<H1([^>]*)>/gi, '<div$1><b><font size="6">' ) ;
		
	html = html.replace( /<H2([^>]*)>/gi, '<div$1><b><font size="5">' ) ;
	html = html.replace( /<H3([^>]*)>/gi, '<div$1><b><font size="4">' ) ;
	html = html.replace( /<H4([^>]*)>/gi, '<div$1><b><font size="3">' ) ;
	html = html.replace( /<H5([^>]*)>/gi, '<div$1><b><font size="2">' ) ;
	html = html.replace( /<H6([^>]*)>/gi, '<div$1><b><font size="1">' ) ;

	html = html.replace( /<\/H\d>/gi, '<\/font><\/b><\/div>' ) ;

	// Remove empty tags (three times, just to be sure).
	// This also removes any empty anchor
	html = html.replace( /<([^\s>]+)(\s[^>]*)?>\s*<\/\1>/g, '' ) ;
	html = html.replace( /<([^\s>]+)(\s[^>]*)?>\s*<\/\1>/g, '' ) ;
	html = html.replace( /<([^\s>]+)(\s[^>]*)?>\s*<\/\1>/g, '' ) ;
	
	return html ;
}
/**
 * Function which retrieve current cursor position
 * within textarea.
 * @param element textArea textarea which contains message body.
 */
function IE_getCursorPosition(textArea)
{
    if (document.selection) { // IE
        var sel1 = document.selection.createRange();
        var sel2 = sel1.duplicate();
        sel2.moveToElementText(textArea);
        var selText = sel1.text;
        sel1.text = "}#{";
        var index = sel2.text.indexOf("}#{");
        window.start = (index == -1) ? sel2.text.length : sel2.text.substring(0, index).length;
        window.end = selText.length + window.start;
        sel1.moveStart('character', -3);
        sel1.text = selText;
    } else if (textArea.selectionStart || (textArea.selectionStart == "0")) { // Mozilla/Netscape
        window.start = textArea.selectionStart;
        window.end = textArea.selectionEnd;
    }
}
/**
 * Function which call IE_getCursorPosition() to
 * keep trac of cursor position.
 */
function IE_tracCursorPosition(moduleObject, element)
{
	var use_html = dhtml.getElementById("use_html");
	if (use_html){
		if(use_html.value == "false") {
			IE_getCursorPosition(element);
		}
	}
}
/**
 * Function which keeps trac of cursor position
 * when editor is loaded.
 */
function IE_tracCursorInEditor(fckEditor)
{
	if (fckEditor && fckEditor.HasFocus){
		if (fckEditor.Selection.GetSelection().type != "None") fckEditor.Selection.Save();
	}
}